package Statocles::Deploy::File;
# ABSTRACT: Deploy a site to a folder on the filesystem
$Statocles::Deploy::File::VERSION = '0.034';
use Statocles::Base 'Class';
with 'Statocles::Deploy';


has path => (
    is => 'ro',
    isa => Dir,
    coerce => Dir->coercion,
    required => 1,
);


sub deploy {
    my ( $self, $from_store, $message ) = @_;

    my @files;
    my $iter = $from_store->find_files;
    while ( my $path = $iter->() ) {
        # Git versions before 1.7.4.1 require a relative path to 'git add'
        push @files, $path->relative( "/" )->stringify;

        # XXX Implement a friendlier way to copy files from Stores
        my $in_fh = $from_store->open_file( $path );
        my $out_fh = $self->path->child( $path )->touchpath->openw_raw;
        while ( my $line = <$in_fh> ) {
            $out_fh->print( $line );
        }
    }

    return @files;
}

1;

__END__

=pod

=head1 NAME

Statocles::Deploy::File - Deploy a site to a folder on the filesystem

=head1 VERSION

version 0.034

=head1 DESCRIPTION

This class allows a site to be deployed to a folder on the filesystem.

This class extends L<Statocles::Store::File|Statocles::Store::File>.

=head1 ATTRIBUTES

=head2 path

The path to deploy to.

=head1 METHODS

=head2 deploy( FROM_STORE, MESSAGE )

Deploy the site, copying from the given store.

=head1 SEE ALSO

=over 4

=item L<Statocles::Store::File>

=item L<Statocles::Deploy>

=back

=head1 AUTHOR

Doug Bell <preaction@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Doug Bell.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
