package Bigtop::Example::Billing::LineItem;

use strict;

use base 'Bigtop::Example::Billing::GEN::LineItem';

use Gantry::Plugins::AutoCRUD qw(
    do_add
    do_edit
    do_delete
    form_name
);

use Bigtop::Example::Billing::Model;
use Bigtop::Example::Billing::Model::line_item qw( $LINE_ITEM );
use Bigtop::Example::Billing::Model::invoice   qw( $INVOICE   );

sub schema_base_class { return 'Bigtop::Example::Billing::Model'; }
use Gantry::Plugins::DBIxClassConn qw( get_schema );
use Gantry::Plugins::Calendar qw(
    do_calendar_month
    calendar_month_js
);



#-----------------------------------------------------------------
# $self->do_main( [ $invoice_id ] )
#-----------------------------------------------------------------
sub do_main {
    my ( $self, $invoice_id ) = @_;

    my $only_one_invoice = 0;
    my $title            = 'Line Items';
    if ( defined $invoice_id ) {
        $only_one_invoice = 1;
        my $invoice = $INVOICE->gfind( $self, $invoice_id );
        $title .= ' for Invoice ' . $invoice->foreign_display();
    }

    $self->stash->view->template( 'results.tt' );
    $self->stash->view->title( $title );

    my $retval = {
        headings       => [
            'Name',
            'Due Date',
            'Invoice',
        ],
        header_options => [
            {
                text => 'Add',
                link => $self->location() . "/add",
            },
        ],
    };

    my $schema = $self->get_schema();
    my @rows   = $LINE_ITEM->get_listing( { schema => $schema } );

    ROW:
    foreach my $row ( @rows ) {
        my $id = $row->id;

        next ROW if ( $only_one_invoice and $id != $invoice_id );

        push(
            @{ $retval->{rows} }, {
                data => [
                    $row->name,
                    $row->due_date,
                    $row->invoice->foreign_display(),
                ],
                options => [
                    {
                        text => 'Edit',
                        link => $self->location() . "/edit/$id",
                    },
                    {
                        text => 'Delete',
                        link => $self->location() . "/delete/$id",
                    },
                ],
            }
        );
    }

    $self->stash->view->data( $retval );
} # END do_main

#-----------------------------------------------------------------
# $self->form( $row )
#-----------------------------------------------------------------
# This method supplied by Bigtop::Example::Billing::GEN::LineItem


#-----------------------------------------------------------------
# get_model_name( )
#-----------------------------------------------------------------
sub get_model_name {
    return $LINE_ITEM;
}

#-----------------------------------------------------------------
# get_orm_helper( )
#-----------------------------------------------------------------
sub get_orm_helper {
    return 'Gantry::Plugins::AutoCRUDHelper::DBIxClass';
}

#-----------------------------------------------------------------
# text_descr( )
#-----------------------------------------------------------------
sub text_descr     {
    return 'line item';
}

1;

=head1 NAME

Bigtop::Example::Billing::LineItem - A controller in the Billing application

=head1 SYNOPSIS

This package is meant to be used in a stand alone server/CGI script or the
Perl block of an httpd.conf file.

Stand Alone Server or CGI script:

    use Bigtop::Example::Billing::LineItem;

    my $cgi = Gantry::Engine::CGI->new( {
        config => {
            #...
        },
        locations => {
            '/someurl' => 'Bigtop::Example::Billing::LineItem',
            #...
        },
    } );

httpd.conf:

    <Perl>
        # ...
        use Bigtop::Example::Billing::LineItem;
    </Perl>

    <Location /someurl>
        SetHandler  perl-script
        PerlHandler Bigtop::Example::Billing::LineItem
    </Location>

If all went well, one of these was correctly written during app generation.

=head1 DESCRIPTION

This module was originally generated by Bigtop.  But feel free to edit it.
You might even want to describe the table this module controls here.

=head1 METHODS

=over 4

=item get_model_name

=item text_descr

=item schema_base_class

=item get_orm_helper


=back


=head1 METHODS MIXED IN FROM Bigtop::Example::Billing::GEN::LineItem

=over 4

=item do_main

=item form


=back


=head1 DEPENDENCIES

    Bigtop::Example::Billing
    Bigtop::Example::Billing::GEN::LineItem
    Bigtop::Example::Billing::Model::line_item
    Gantry::Plugins::Calendar
    Gantry::Plugins::AutoCRUD

=head1 AUTHOR

Phil Crow

Tim Keefer

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2006 Phil Crow

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.6 or,
at your option, any later version of Perl 5 you may have available.

=cut
