# NEVER EDIT this file.  It was generated and will be overwritten without
# notice upon regeneration of this application.  You have been warned.
package Bigtop::Example::Billing::GEN::Company;

use strict;

use base 'Bigtop::Example::Billing';

use Bigtop::Example::Billing::Model::my_company qw(
    $MY_COMPANY
);

#-----------------------------------------------------------------
# $self->do_main(  )
#-----------------------------------------------------------------
sub do_main {
    my ( $self ) = @_;

    $self->stash->view->template( 'results.tt' );
    $self->stash->view->title( 'My Companies' );

    my $retval = {
        headings       => [
            'Name',
            'Contact Phone',
        ],
        header_options => [
            {
                text => 'Add',
                link => $self->location() . "/add",
            },
        ],
    };

    my $schema = $self->get_schema();
    my @rows   = $MY_COMPANY->get_listing( { schema => $schema } );

    foreach my $row ( @rows ) {
        my $id = $row->id;
        push(
            @{ $retval->{rows} }, {
                data => [
                    $row->name,
                    $row->contact_phone,
                ],
                options => [
                    {
                        text => 'Edit',
                        link => $self->location() . "/edit/$id",
                    },
                    {
                        text => 'Delete',
                        link => $self->location() . "/delete/$id",
                    },
                ],
            }
        );
    }

    $self->stash->view->data( $retval );
} # END do_main

#-----------------------------------------------------------------
# $self->form( $row )
#-----------------------------------------------------------------
sub form {
    my ( $self, $row ) = @_;

    my $selections = $MY_COMPANY->get_form_selections(
            { schema => $self->get_schema() }
    );

    return {
        name       => 'company',
        row        => $row,
        legend => $self->path_info =~ /edit/i ? 'Edit' : 'Add',
        fields     => [
            {
                name => 'name',
                label => 'Name',
                type => 'text',
                is => 'varchar',
            },
            {
                name => 'address',
                label => 'Address',
                type => 'text',
                is => 'varchar',
            },
            {
                name => 'city',
                label => 'City',
                type => 'text',
                is => 'varchar',
            },
            {
                name => 'state',
                label => 'State',
                type => 'text',
                is => 'varchar',
            },
            {
                name => 'zip',
                label => 'Zip',
                type => 'text',
                is => 'varchar',
            },
            {
                name => 'description',
                optional => 1,
                label => 'Description',
                type => 'text',
                is => 'varchar',
            },
            {
                name => 'contact_name',
                label => 'Contact Name',
                type => 'text',
                is => 'varchar',
            },
            {
                name => 'contact_email',
                label => 'Contact Email',
                type => 'text',
                is => 'varchar',
            },
            {
                name => 'contact_phone',
                label => 'Contact Phone',
                type => 'text',
                is => 'varchar',
            },
        ],
    };
} # END form


1;

=head1 NAME

Bigtop::Example::Billing::GEN::Company - generated support module for Bigtop::Example::Billing::Company

=head1 SYNOPSIS

In Bigtop::Example::Billing::Company:

    use Bigtop::Example::Billing::GEN::Company qw(
        do_main
        form
    );

=head1 DESCRIPTION

This module was generated by bigtop and IS subject to regeneration.
Use it in Bigtop::Example::Billing::Company to provide the methods below.
They are exported by default.

=head1 METHODS

=over 4

=item do_main

=item form


=back

=head1 AUTHOR

Generated by bigtop and subject to regeneration.

=cut

