#!/usr/bin/perl

use strict;
use warnings;

use Test::More;
use Test::Async::HTTP 0.02; # ->GET
use t::Util;

use Net::Async::Matrix;
use Future;

my $matrix = Net::Async::Matrix->new(
   ua => my $ua = Test::Async::HTTP->new,
   server => "localserver.test",

   make_delay => sub { Future->new },
);
matrix_login( $matrix, $ua );

# presence event
{
   my ( $user, %presence );
   $matrix->configure(
      on_presence => sub { shift; ( $user, %presence ) = @_ },
   );

   send_events( $ua,
      {  type    => "m.presence",
         content => {
            user_id  => '@some_user:server',
            presence => "online",
         },
      },
   );

   is( $user->user_id, '@some_user:server', '$user for on_presence event' );
   is( $presence{presence}[1], "online", '{presence} for on_presence event' );
}

done_testing;
