package Sah::SchemaR::date::tz_offset_lax;

our $DATE = '2020-03-04'; # DATE
our $VERSION = '0.012'; # VERSION

our $rschema = ["int",[{description=>"\nThis schema allows timezone offsets that are not known to exist, e.g. 1 second\n(+00:00:01). If you only want ot allow timezone offsets that are known to exist,\nsee the `date::tz_offset` schema.\n\nA coercion from these form of string is provided:\n\n    UTC\n\n    UTC-14 or UTC+12 or UTC+12:45 or UTC-00:25:21\n    -14 or +12, -1400 or +12:00\n\nA coercion from timezone name is also provided.\n\n",examples=>[{valid=>0,value=>""},{valid=>1,validated_value=>0,value=>"UTC"},{valid=>1,validated_value=>3600,value=>3600},{valid=>1,validated_value=>-43200,value=>-43200},{valid=>1,validated_value=>-43200,value=>-12},{valid=>1,validated_value=>-43200,value=>-1200},{valid=>1,validated_value=>-43200,value=>"-12:00"},{valid=>1,validated_value=>-43200,value=>"UTC-12"},{valid=>1,validated_value=>-43200,value=>"UTC-1200"},{valid=>1,validated_value=>45900,value=>"UTC+12:45"},{valid=>0,value=>"UTC-13"},{summary=>"Unknown offset",valid=>1,validated_value=>43260,value=>"UTC+12:01"}],max=>50400,min=>-43200,summary=>"Timezone offset in seconds from UTC","x.completion"=>sub{package Sah::Schema::date::tz_offset;require Complete::TZ;require Complete::Util;my(%args) = @_;Complete::Util::combine_answers(Complete::TZ::complete_tz_offset('word', $args{'word'}), Complete::TZ::complete_tz_name('word', $args{'word'}))},"x.perl.coerce_rules"=>["From_str::tz_offset_strings"]}],["date::tz_offset","int"]];

1;
# ABSTRACT: Timezone offset in seconds from UTC

__END__

=pod

=encoding UTF-8

=head1 NAME

Sah::SchemaR::date::tz_offset_lax - Timezone offset in seconds from UTC

=head1 VERSION

This document describes version 0.012 of Sah::SchemaR::date::tz_offset_lax (from Perl distribution Sah-Schemas-Date), released on 2020-03-04.

=head1 DESCRIPTION

This module is automatically generated by Dist::Zilla::Plugin::Sah::Schemas during distribution build.

A Sah::SchemaR::* module is useful if a client wants to quickly lookup the base type of a schema without having to do any extra resolving. With Sah::Schema::*, one might need to do several lookups if a schema is based on another schema, and so on. Compare for example L<Sah::Schema::poseven> vs L<Sah::SchemaR::poseven>, where in Sah::SchemaR::poseven one can immediately get that the base type is C<int>. Currently L<Perinci::Sub::Complete> uses Sah::SchemaR::* instead of Sah::Schema::* for reduced startup overhead when doing tab completion.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Sah-Schemas-Date>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Sah-Schemas-Date>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Sah-Schemas-Date>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020, 2019 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
