package Sah::Schema::fiat_or_cryptocurrency;

our $DATE = '2018-06-06'; # DATE
our $VERSION = '0.009'; # VERSION

our $schema = [str => {
    summary => 'Fiat currency code or cryptocurrency code, name, or safename',
    description => <<'_',

Either: a) a known fiat currency code (e.g. USD, GBP), or b) a known
cryptocurrency code or name or safename (e.g. BTC, "Bitcoin Cash",
ethereum-classic). Fiat currency code is checked against known codes in
<pm:Locale::Codes::Currency_Codes>. Cryptocurrency code/name/safename is checked
against catalog in <pm:CryptoCurrency::Catalog>. Cryptocurrency name/safename
Will be normalized to code in uppercase.

_
    'x.completion' => 'fiat_or_cryptocurrency',
    'x.perl.coerce_rules' => ['str_to_fiat_or_cryptocurrency_code'],
}, {}];

1;
# ABSTRACT: Fiat currency code or cryptocurrency code, name, or safename

__END__

=pod

=encoding UTF-8

=head1 NAME

Sah::Schema::fiat_or_cryptocurrency - Fiat currency code or cryptocurrency code, name, or safename

=head1 VERSION

This document describes version 0.009 of Sah::Schema::fiat_or_cryptocurrency (from Perl distribution Sah-Schemas-CryptoCurrency), released on 2018-06-06.

=head1 DESCRIPTION

Either: a) a known fiat currency code (e.g. USD, GBP), or b) a known
cryptocurrency code or name or safename (e.g. BTC, "Bitcoin Cash",
ethereum-classic). Fiat currency code is checked against known codes in
L<Locale::Codes::Currency_Codes>. Cryptocurrency code/name/safename is checked
against catalog in L<CryptoCurrency::Catalog>. Cryptocurrency name/safename
Will be normalized to code in uppercase.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Sah-Schemas-CryptoCurrency>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Sah-Schemas-CryptoCurrency>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Sah-Schemas-CryptoCurrency>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2018 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
