package Pod::Weaver::Section::Environment::PerinciCmdLine;

our $DATE = '2015-01-10'; # DATE
our $VERSION = '0.01'; # VERSION

use 5.010001;
use Moose;
with 'Pod::Weaver::Role::AddTextToSection';
with 'Pod::Weaver::Role::DetectPerinciCmdLineScript';
with 'Pod::Weaver::Role::DumpPerinciCmdLineScript';
with 'Pod::Weaver::Role::AddTextToSection';
with 'Pod::Weaver::Role::Section';

use List::Util qw(first);
use Moose::Autobox;

sub weave_section {
    my ($self, $document, $input) = @_;

    my $filename = $input->{filename} || 'file';
    if ($filename !~ m!^(bin|script)/!) {
        $self->log_debug(["skipped file %s (not bin/script)", $filename]);
        return;
    }

    my $res = $self->detect_perinci_cmdline_script($input);
    if ($res->[0] != 200) {
        die "Can't detect Perinci::CmdLine script for $filename: $res->[0] - $res->[1]";
    } elsif (!$res->[2]) {
        $self->log_debug(["skipped file %s (not a Perinci::CmdLine script: %s)", $filename, $res->[3]{'func.reason'}]);
        return;
    }

    $res = $self->dump_perinci_cmdline_script($input);
    if ($res->[0] != 200) {
        die "Can't dump Perinci::CmdLine script for $filename: $res->[0] - $res->[1]";
    }
    my $cli = $res->[2];

    # workaround because currently the dumped object does not contain all
    # attributes in the hash (Moo/Mo issue?), we need to access the attribute
    # accessor method first to get them recorded in the hash. this will be fixed
    # in the dump module in the future.
    {
        local $0 = $filename;

        local @INC = ("lib", @INC);
        eval "use " . ref($cli) . "()";
        die if $@;

        unless ($cli->read_env) {
            $self->log_debug(["skipped file %s (script does not read env)", $filename]);
            return;
        }

        my $text = $cli->env_name . "\n\n";

        $self->add_text_to_section($document, $text, 'ENVIRONMENT');
    }
}

no Moose;
1;
# ABSTRACT: Add a COMPLETION section for Perinci::CmdLine-based scripts

__END__

=pod

=encoding UTF-8

=head1 NAME

Pod::Weaver::Section::Environment::PerinciCmdLine - Add a COMPLETION section for Perinci::CmdLine-based scripts

=head1 VERSION

This document describes version 0.01 of Pod::Weaver::Section::Environment::PerinciCmdLine (from Perl distribution Pod-Weaver-Section-Environment-PerinciCmdLine), released on 2015-01-10.

=head1 SYNOPSIS

In your C<weaver.ini>:

 [Completion::PerinciCmdLine]

=head1 DESCRIPTION

This section plugin adds a COMPLETION section for Perinci::CmdLine-based
scripts. The section contains information on how to activate shell tab
completion for the scripts.

=for Pod::Coverage weave_section

=head1 SEE ALSO

L<Perinci::CmdLine>

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Pod-Weaver-Section-Environment-PerinciCmdLine>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Pod-Weaver-Section-Environment-PerinciCmdLine>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Pod-Weaver-Section-Environment-PerinciCmdLine>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
