package Dist::Zilla::Plugin::Test::ProveDeps;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2020-01-29'; # DATE
our $DIST = 'Dist-Zilla-Plugin-Test-ProveDeps'; # DIST
our $VERSION = '0.001'; # VERSION

use Moose;
with 'Dist::Zilla::Role::FileGatherer';
with 'Dist::Zilla::Role::PrereqSource';
with 'Dist::Zilla::Role::FileFinderUser' => {
    default_finders => [':InstallModules'],
};

use Data::Dmp;
use namespace::autoclean;

# Register the release test prereq as a "develop requires"
# so it will be listed in "dzil listdeps --author"
sub register_prereqs {
    my ($self) = @_;

    $self->zilla->register_prereqs(
        {
            type  => 'requires',
            phase => 'develop',
        },
        'App::ProveDeps' => '0.004',
    );
}

sub gather_files {
    my ($self) = @_;

    my @modules;
    for (@{ $self->found_files }) {
        next unless $_->name =~ m!\Alib/(.+)\.pm\z!;
        my $pkg = $1; $pkg =~ s!/!::!g;
        push @modules, $pkg;
    }

    my $filename = "xt/release/prove-deps.t";
    my $filecontent = q|
#!perl

# This file was automatically generated by Dist::Zilla::Plugin::Test::ProveDeps.

use Test::More;
use Cwd;

eval "use Test::ProveDeps 0.001";
plan skip_all => "Test::ProveDeps 0.001 required for testing dependent distributions"
  if $@;

all_dependents_ok(
    modules => | . dmp(\@modules) . q|,
    prove_opts => ['-l', "-I".getcwd()."/lib"],
);
|;

    $self->log(["Adding %s ...", $filename]);
    require Dist::Zilla::File::InMemory;
    $self->add_file(
        Dist::Zilla::File::InMemory->new({
            name => $filename,
            content => $filecontent,
        })
      );
}

__PACKAGE__->meta->make_immutable;
1;
# ABSTRACT: Add release test to run 'prove' on dependent distributions

__END__

=pod

=encoding UTF-8

=head1 NAME

Dist::Zilla::Plugin::Test::ProveDeps - Add release test to run 'prove' on dependent distributions

=head1 VERSION

This document describes version 0.001 of Dist::Zilla::Plugin::Test::ProveDeps (from Perl distribution Dist-Zilla-Plugin-Test-ProveDeps), released on 2020-01-29.

=head1 DESCRIPTION

EXPERIMENTAL.

This plugin adds the following files:

  xt/release/prove-deps.t

This test script uses L<Test::ProveDeps> to check your dependent distributions.

=for Pod::Coverage .+

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Dist-Zilla-Plugin-Test-ProveDeps>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Dist-Zilla-Plugin-Test-ProveDeps>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Dist-Zilla-Plugin-Test-ProveDeps>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
