package Bencher::Scenario::PERLANCAR::CommonModulesStartup;

our $DATE = '2016-04-13'; # DATE
our $VERSION = '0.04'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark startup overhead of commonly used modules',
    module_startup => 1,
    participants => [
        {module=>'strict'},
        {module=>'warnings'},
        {modules=>['strict', 'warnings']},
        {module=>'utf8'},
        {module=>'Role::Tiny'},
        {module=>'Role::Tiny::With'},
        {modules=>['Role::Tiny', 'Role::Tiny::With']},
        {module=>'List::Util'},
    ],
};

1;
# ABSTRACT: Benchmark startup overhead of commonly used modules

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::PERLANCAR::CommonModulesStartup - Benchmark startup overhead of commonly used modules

=head1 VERSION

This document describes version 0.04 of Bencher::Scenario::PERLANCAR::CommonModulesStartup (from Perl distribution Bencher-Scenarios-PERLANCAR), released on 2016-04-13.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m PERLANCAR::CommonModulesStartup

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<strict> 1.09

L<warnings> 1.32

L<utf8> 1.17

L<Role::Tiny> 2.000001

L<Role::Tiny::With> 2.000001

L<List::Util> 1.41

=head1 BENCHMARK PARTICIPANTS

=over

=item * strict (perl_code)

L<strict>



=item * warnings (perl_code)

L<warnings>



=item * strict+warnings (perl_code)

L<strict+warnings>



=item * utf8 (perl_code)

L<utf8>



=item * Role::Tiny (perl_code)

L<Role::Tiny>



=item * Role::Tiny::With (perl_code)

L<Role::Tiny::With>



=item * Role::Tiny+Role::Tiny::With (perl_code)

L<Role::Tiny+Role::Tiny::With>



=item * List::Util (perl_code)

L<List::Util>



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m PERLANCAR::CommonModulesStartup >>):

 +-----------------------------+-----------+------------------------+------------+---------+---------+
 | participant                 | time (ms) | mod_overhead_time (ms) | vs_slowest | errors  | samples |
 +-----------------------------+-----------+------------------------+------------+---------+---------+
 | Role::Tiny+Role::Tiny::With | 8         | 4                      | 1          | 3.6e-05 | 21      |
 | Role::Tiny::With            | 8         | 4                      | 1          | 3.7e-05 | 20      |
 | Role::Tiny                  | 7.5       | 3.5                    | 1.1        | 3.9e-05 | 20      |
 | strict+warnings             | 5.8       | 1.8                    | 1.4        | 1.5e-05 | 20      |
 | List::Util                  | 5.7       | 1.7                    | 1.4        | 2.8e-05 | 20      |
 | warnings                    | 5.4       | 1.4                    | 1.5        | 1.7e-05 | 21      |
 | strict                      | 4.5       | 0.5                    | 1.8        | 1.3e-05 | 20      |
 | utf8                        | 4.4       | 0.4                    | 1.8        | 1.6e-05 | 20      |
 | perl -e1 (baseline)         | 4         | 0                      | 2          | 1.7e-05 | 20      |
 +-----------------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-PERLANCAR>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-PERLANCAR>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-PERLANCAR>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
