package Bencher::Scenario::CloneModules;

our $DATE = '2021-07-31'; # DATE
our $VERSION = '0.050'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark various data cloning modules',
    participants => [
        {fcall_template=>'Clone::clone(<data>)'},
        {fcall_template=>'Clone::PP::clone(<data>)'},
        {fcall_template=>'Data::Clone::clone(<data>)'},
        {fcall_template=>'Sereal::Dclone::dclone(<data>)'},
        {fcall_template=>'Storable::dclone(<data>)'},
    ],
    datasets => [
        {name=>'array0'   , args=>{data=>[]}},
        {name=>'array1'   , args=>{data=>[1]}},
        {name=>'array10'  , args=>{data=>[1..10]}},
        {name=>'array100' , args=>{data=>[1..100]}},
        {name=>'array1k'  , args=>{data=>[1..1000]}},
        {name=>'array10k' , args=>{data=>[1..10_000]}},

        {name=>'hash1k'   , args=>{data=>{map {$_=>1} 1..1000}}},
        {name=>'hash10k'  , args=>{data=>{map {$_=>1} 1..10_000}}},
    ],
};

1;
# ABSTRACT: Benchmark various data cloning modules

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::CloneModules - Benchmark various data cloning modules

=head1 VERSION

This document describes version 0.050 of Bencher::Scenario::CloneModules (from Perl distribution Bencher-Scenarios-CloneModules), released on 2021-07-31.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m CloneModules

To run module startup overhead benchmark:

 % bencher --module-startup -m CloneModules

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Clone> 0.45

L<Clone::PP> 1.08

L<Data::Clone> 0.004

L<Sereal::Dclone> 0.003

L<Storable> 3.23

=head1 BENCHMARK PARTICIPANTS

=over

=item * Clone::clone (perl_code)

Function call template:

 Clone::clone(<data>)



=item * Clone::PP::clone (perl_code)

Function call template:

 Clone::PP::clone(<data>)



=item * Data::Clone::clone (perl_code)

Function call template:

 Data::Clone::clone(<data>)



=item * Sereal::Dclone::dclone (perl_code)

Function call template:

 Sereal::Dclone::dclone(<data>)



=item * Storable::dclone (perl_code)

Function call template:

 Storable::dclone(<data>)



=back

=head1 BENCHMARK DATASETS

=over

=item * array0

=item * array1

=item * array10

=item * array100

=item * array1k

=item * array10k

=item * hash1k

=item * hash10k

=back

=head1 BENCHMARK SAMPLE RESULTS

=head2 Sample benchmark #1

Run on: perl: I<< v5.34.0 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux LinuxMint version 19 >>, OS kernel: I<< Linux version 5.3.0-68-generic >>.

Benchmark command (cloning a 10k-element array):

 % bencher -m CloneModules --include-datasets array10k

Result formatted as table:

 #table1#
 +------------------------+-----------+-----------+-----------------------+-----------------------+---------+---------+
 | participant            | rate (/s) | time (ms) | pct_faster_vs_slowest | pct_slower_vs_fastest |  errors | samples |
 +------------------------+-----------+-----------+-----------------------+-----------------------+---------+---------+
 | Clone::clone           |       480 |      2.1  |                 0.00% |               528.98% | 5.1e-06 |      20 |
 | Clone::PP::clone       |      1200 |      0.81 |               158.13% |               143.66% | 2.5e-06 |      20 |
 | Storable::dclone       |      1400 |      0.71 |               194.00% |               113.94% | 3.5e-06 |      21 |
 | Sereal::Dclone::dclone |      2800 |      0.36 |               482.25% |                 8.03% | 6.9e-07 |      20 |
 | Data::Clone::clone     |      3000 |      0.33 |               528.98% |                 0.00% | 4.3e-07 |      20 |
 +------------------------+-----------+-----------+-----------------------+-----------------------+---------+---------+


The above result formatted in L<Benchmark.pm|Benchmark> style:

          Rate   C:c  CP:c   S:d  SD:d  DC:c 
  C:c    480/s    --  -61%  -66%  -82%  -84% 
  CP:c  1200/s  159%    --  -12%  -55%  -59% 
  S:d   1400/s  195%   14%    --  -49%  -53% 
  SD:d  2800/s  483%  125%   97%    --   -8% 
  DC:c  3000/s  536%  145%  115%    9%    -- 
 
 Legends:
   C:c: participant=Clone::clone
   CP:c: participant=Clone::PP::clone
   DC:c: participant=Data::Clone::clone
   S:d: participant=Storable::dclone
   SD:d: participant=Sereal::Dclone::dclone

The above result presented as chart:

#IMAGE: share/images/bencher-result-1.png|/tmp/8FUibnYqSi/bencher-result-1.png

=head2 Sample benchmark #2

Benchmark command (cloning a 10k-pair hash):

 % bencher -m CloneModules --include-datasets hash10k

Result formatted as table:

 #table2#
 +------------------------+-----------+-----------+-----------------------+-----------------------+---------+---------+
 | participant            | rate (/s) | time (ms) | pct_faster_vs_slowest | pct_slower_vs_fastest |  errors | samples |
 +------------------------+-----------+-----------+-----------------------+-----------------------+---------+---------+
 | Clone::clone           |       190 |       5.2 |                 0.00% |               126.46% | 8.9e-06 |      21 |
 | Clone::PP::clone       |       210 |       4.7 |                11.08% |               103.87% | 5.8e-06 |      20 |
 | Storable::dclone       |       340 |       2.9 |                76.92% |                28.00% | 3.8e-06 |      20 |
 | Data::Clone::clone     |       360 |       2.8 |                88.69% |                20.02% | 3.1e-06 |      20 |
 | Sereal::Dclone::dclone |       440 |       2.3 |               126.46% |                 0.00% | 4.3e-06 |      20 |
 +------------------------+-----------+-----------+-----------------------+-----------------------+---------+---------+


The above result formatted in L<Benchmark.pm|Benchmark> style:

         Rate   C:c  CP:c   S:d  DC:c  SD:d 
  C:c   190/s    --   -9%  -44%  -46%  -55% 
  CP:c  210/s   10%    --  -38%  -40%  -51% 
  S:d   340/s   79%   62%    --   -3%  -20% 
  DC:c  360/s   85%   67%    3%    --  -17% 
  SD:d  440/s  126%  104%   26%   21%    -- 
 
 Legends:
   C:c: participant=Clone::clone
   CP:c: participant=Clone::PP::clone
   DC:c: participant=Data::Clone::clone
   S:d: participant=Storable::dclone
   SD:d: participant=Sereal::Dclone::dclone

The above result presented as chart:

#IMAGE: share/images/bencher-result-2.png|/tmp/8FUibnYqSi/bencher-result-2.png

=head2 Sample benchmark #3

Benchmark command (benchmarking module startup overhead):

 % bencher -m CloneModules --module-startup

Result formatted as table:

 #table3#
 +---------------------+-----------+-------------------+-----------------------+-----------------------+-----------+---------+
 | participant         | time (ms) | mod_overhead_time | pct_faster_vs_slowest | pct_slower_vs_fastest |  errors   | samples |
 +---------------------+-----------+-------------------+-----------------------+-----------------------+-----------+---------+
 | Sereal::Dclone      |      10   |               4.6 |                 0.00% |               131.01% |   0.00024 |      20 |
 | Storable            |      12   |               6.6 |                 5.42% |               119.13% | 5.8e-05   |      20 |
 | Clone               |      10   |               4.6 |                26.44% |                82.70% |   0.00021 |      20 |
 | Clone::PP           |       9   |               3.6 |                42.26% |                62.39% |   0.00019 |      20 |
 | Data::Clone         |       7.3 |               1.9 |                71.61% |                34.62% |   4e-05   |      21 |
 | perl -e1 (baseline) |       5.4 |               0   |               131.01% |                 0.00% | 2.2e-05   |      23 |
 +---------------------+-----------+-------------------+-----------------------+-----------------------+-----------+---------+


The above result formatted in L<Benchmark.pm|Benchmark> style:

                          Rate     S   S:D     C   C:P   D:C  perl -e1 (baseline) 
  S                     83.3/s    --  -16%  -16%  -25%  -39%                 -55% 
  S:D                  100.0/s   19%    --    0%   -9%  -27%                 -46% 
  C                    100.0/s   19%    0%    --   -9%  -27%                 -46% 
  C:P                  111.1/s   33%   11%   11%    --  -18%                 -39% 
  D:C                  137.0/s   64%   36%   36%   23%    --                 -26% 
  perl -e1 (baseline)  185.2/s  122%   85%   85%   66%   35%                   -- 
 
 Legends:
   C: mod_overhead_time=4.6 participant=Clone
   C:P: mod_overhead_time=3.6 participant=Clone::PP
   D:C: mod_overhead_time=1.9 participant=Data::Clone
   S: mod_overhead_time=6.6 participant=Storable
   S:D: mod_overhead_time=4.6 participant=Sereal::Dclone
   perl -e1 (baseline): mod_overhead_time=0 participant=perl -e1 (baseline)

The above result presented as chart:

#IMAGE: share/images/bencher-result-3.png|/tmp/8FUibnYqSi/bencher-result-3.png

To display as an interactive HTML table on a browser, you can add option C<--format html+datatables>.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-CloneModules>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-CloneModules>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-CloneModules>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2021, 2017, 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
