package Bencher::Scenario::ZodiacModules;

our $DATE = '2016-06-26'; # DATE
our $VERSION = '0.04'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark various zodiac modules',
    participants => [
        {
            fcall_template => "Zodiac::Tiny::zodiac_of('2015-11-29')",
        },
        {
            fcall_template => "DateTime::Event::Zodiac::zodiac_date_name(DateTime->new(year=>2015, month=>11, day=>29))",
        },
        {
            fcall_template => "Zodiac::Chinese::Table::chinese_zodiac('2015-11-28')",
        },
        {
            fcall_template => "Zodiac::Chinese::chinese_zodiac(2015,11)",
        },
    ],
};

1;
# ABSTRACT: Benchmark various zodiac modules

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::ZodiacModules - Benchmark various zodiac modules

=head1 VERSION

This document describes version 0.04 of Bencher::Scenario::ZodiacModules (from Perl distribution Bencher-Scenario-ZodiacModules), released on 2016-06-26.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m ZodiacModules

To run module startup overhead benchmark:

 % bencher --module-startup -m ZodiacModules

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Zodiac::Tiny> 0.01

L<DateTime::Event::Zodiac> 1.03

L<Zodiac::Chinese::Table> 0.01

L<Zodiac::Chinese> 1

=head1 BENCHMARK PARTICIPANTS

=over

=item * Zodiac::Tiny::zodiac_of (perl_code)

Function call template:

 Zodiac::Tiny::zodiac_of('2015-11-29')



=item * DateTime::Event::Zodiac::zodiac_date_name (perl_code)

Function call template:

 DateTime::Event::Zodiac::zodiac_date_name(DateTime->new(year=>2015, month=>11, day=>29))



=item * Zodiac::Chinese::Table::chinese_zodiac (perl_code)

Function call template:

 Zodiac::Chinese::Table::chinese_zodiac('2015-11-28')



=item * Zodiac::Chinese::chinese_zodiac (perl_code)

Function call template:

 Zodiac::Chinese::chinese_zodiac(2015,11)



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.2 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m ZodiacModules >>):

 +-------------------------------------------+-----------+------------+------------+--------+---------+
 | participant                               | rate (/s) | time (μs)  | vs_slowest | errors | samples |
 +-------------------------------------------+-----------+------------+------------+--------+---------+
 | DateTime::Event::Zodiac::zodiac_date_name |      1270 | 786        |      1     |  6e-07 |      23 |
 | Zodiac::Chinese::Table::chinese_zodiac    |   1016040 |   0.984212 |    798.925 |  0     |      25 |
 | Zodiac::Tiny::zodiac_of                   |   1217160 |   0.821582 |    957.07  |  0     |      24 |
 | Zodiac::Chinese::chinese_zodiac           |   2409930 |   0.41495  |   1894.96  |  0     |      20 |
 +-------------------------------------------+-----------+------------+------------+--------+---------+


Benchmark module startup overhead (C<< bencher -m ZodiacModules --module-startup >>):

 +-------------------------+-----------+------------------------+------------+---------+---------+
 | participant             | time (ms) | mod_overhead_time (ms) | vs_slowest |  errors | samples |
 +-------------------------+-----------+------------------------+------------+---------+---------+
 | DateTime::Event::Zodiac |      39   |                   36.5 |        1   | 9.1e-05 |      22 |
 | Zodiac::Chinese::Table  |       6.2 |                    3.7 |        6.2 | 8.7e-06 |      20 |
 | Zodiac::Chinese         |       5.6 |                    3.1 |        6.9 | 1.2e-05 |      20 |
 | Zodiac::Tiny            |       3.3 |                    0.8 |       12   | 1.2e-05 |      20 |
 | perl -e1 (baseline)     |       2.5 |                    0   |       16   | 9.2e-06 |      20 |
 +-------------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-ZodiacModules>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-ZodiacModules>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-ZodiacModules>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
