package Bencher::Scenario::URIEscaping;

our $DATE = '2016-06-16'; # DATE
our $VERSION = '0.002'; # VERSION

use 5.010001;
use strict;
use utf8;
use warnings;

# we do this so URI::XSEscaoe does not override URI::Escape's functions, because
# obviously we want to test both
$ENV{PERL_URI_XSESCAPE} = 0;

our $scenario = {
    summary => 'Benchmark URI escaping using various modules',

    precision => 0.001,

    participants => [
        {fcall_template => 'URI::Escape::uri_escape(<str>)', tags=>['escape']},
        {fcall_template => 'URI::Escape::uri_escape_utf8(<str>)', tags=>['escape', 'utf8']},
        {fcall_template => 'URI::Escape::uri_unescape(<str>)', tags=>['unescape']},
        {fcall_template => 'URI::XSEscape::uri_escape(<str>)', tags=>['escape']},
        {fcall_template => 'URI::XSEscape::uri_escape_utf8(<str>)', tags=>['escape', 'utf8']},
        {fcall_template => 'URI::XSEscape::uri_unescape(<str>)', tags=>['unescape']},
        {fcall_template => 'URI::Escape::XS::uri_escape(<str>)', tags=>['escape']},
        #{fcall_template => 'URI::Escape::XS::uri_escape_utf8(<str>)', tags=>['escape', 'utf8']},
        {fcall_template => 'URI::Escape::XS::uri_unescape(<str>)', tags=>['unescape']},
    ],

    datasets => [
        {
            name => 'empty',
            tags => ['escape'],
            include_participant_tags => ['escape'],
            args => {str=>''},
        },
        # sample data from URI-XSEscape distribution
        {
            name => 'ascii53',
            tags => ['escape'],
            include_participant_tags => ['escape'],
            args => {str=>'I said this: you / them ~ us & me _will_ "do-it" NOW!'},
        },
        # sample data from URI-XSEscape distribution
        {
            name => 'utf36',
            tags => ['escape', 'utf8'],
            include_participant_tags => ['escape & utf8'],
            args => {str=>'http://www.google.co.jp/search?q=小飼弾'},
        },
        # sample data from URI-XSEscape distribution
        {
            name => 'u_ascii53',
            tags => ['unescape'],
            include_participant_tags => ['unescape'],
            args => {str=>'I%20said%20this%3a%20you%20%2f%20them%20~%20us%20%26%20me%20_will_%20%22do-it%22%20NOW%21'},
        },

        # sample data from URI-Escape-XS distribution
        {
            name => 'ascii66',
            tags => ['escape'],
            include_participant_tags => ['escape'],
            args => {str=>'https://stackoverflow.com/questions/3629212/how can perls xsub die'},
        },
        # sample data from URI-Escape-XS distribution
        {
            name => 'u_ascii66',
            tags => ['unescape'],
            include_participant_tags => ['unescape'],
            args => {str=>'https%3A%2F%2Fstackoverflow.com%2Fquestions%2F3629212%2Fhow%20can%20perls%20xsub%20die'},
        },
    ],
};

1;
# ABSTRACT: Benchmark URI escaping using various modules

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::URIEscaping - Benchmark URI escaping using various modules

=head1 VERSION

This document describes version 0.002 of Bencher::Scenario::URIEscaping (from Perl distribution Bencher-Scenario-URIEscaping), released on 2016-06-16.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m URIEscaping

To run module startup overhead benchmark:

 % bencher --module-startup -m URIEscaping

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<URI::Escape> 3.31

L<URI::XSEscape> 0.000007

L<URI::Escape::XS> 0.14

=head1 BENCHMARK PARTICIPANTS

=over

=item * URI::Escape::uri_escape (perl_code) [escape]

Function call template:

 URI::Escape::uri_escape(<str>)



=item * URI::Escape::uri_escape_utf8 (perl_code) [escape, utf8]

Function call template:

 URI::Escape::uri_escape_utf8(<str>)



=item * URI::Escape::uri_unescape (perl_code) [unescape]

Function call template:

 URI::Escape::uri_unescape(<str>)



=item * URI::XSEscape::uri_escape (perl_code) [escape]

Function call template:

 URI::XSEscape::uri_escape(<str>)



=item * URI::XSEscape::uri_escape_utf8 (perl_code) [escape, utf8]

Function call template:

 URI::XSEscape::uri_escape_utf8(<str>)



=item * URI::XSEscape::uri_unescape (perl_code) [unescape]

Function call template:

 URI::XSEscape::uri_unescape(<str>)



=item * URI::Escape::XS::uri_escape (perl_code) [escape]

Function call template:

 URI::Escape::XS::uri_escape(<str>)



=item * URI::Escape::XS::uri_unescape (perl_code) [unescape]

Function call template:

 URI::Escape::XS::uri_unescape(<str>)



=back

=head1 BENCHMARK DATASETS

=over

=item * empty [escape]

=item * ascii53 [escape]

=item * utf36 [escape, utf8]

=item * u_ascii53 [unescape]

=item * ascii66 [escape]

=item * u_ascii66 [unescape]

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.1 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m URIEscaping >>):

 +--------------------------------+-----------+-----------+-----------+------------+---------+---------+
 | participant                    | dataset   | rate (/s) | time (μs) | vs_slowest | errors  | samples |
 +--------------------------------+-----------+-----------+-----------+------------+---------+---------+
 | URI::Escape::uri_escape_utf8   | ascii53   | 8.05e+04  | 12.4      | 1          | 1.2e-08 | 23      |
 | URI::Escape::uri_escape        | ascii53   | 8.6e+04   | 12        | 1.1        | 1.2e-08 | 26      |
 | URI::Escape::uri_escape_utf8   | utf36     | 9.57e+04  | 10.4      | 1.19       | 3.3e-09 | 20      |
 | URI::Escape::uri_escape_utf8   | ascii66   | 1.14e+05  | 8.81      | 1.41       | 8.8e-09 | 46      |
 | URI::Escape::uri_unescape      | u_ascii53 | 1.2e+05   | 8.7       | 1.4        | 8.7e-09 | 47      |
 | URI::Escape::uri_escape        | ascii66   | 1.22e+05  | 8.21      | 1.51       | 7.5e-09 | 255     |
 | URI::Escape::uri_unescape      | u_ascii66 | 1.8e+05   | 5.57      | 2.23       | 4.4e-09 | 237     |
 | URI::Escape::uri_escape_utf8   | empty     | 9e+05     | 1.1       | 11         | 1.2e-09 | 41      |
 | URI::Escape::uri_escape        | empty     | 1.3e+06   | 0.78      | 16         | 8.3e-10 | 45      |
 | URI::XSEscape::uri_escape_utf8 | ascii66   | 1.3e+06   | 0.76      | 16         | 8.3e-10 | 81      |
 | URI::XSEscape::uri_escape_utf8 | ascii53   | 1.342e+06 | 0.7453    | 16.68      | 4.3e-11 | 20      |
 | URI::Escape::XS::uri_escape    | ascii66   | 1.38e+06  | 0.727     | 17.1       | 3.5e-10 | 28      |
 | URI::Escape::XS::uri_escape    | ascii53   | 1.4e+06   | 0.72      | 17         | 7.8e-10 | 92      |
 | URI::XSEscape::uri_escape_utf8 | utf36     | 1.48e+06  | 0.674     | 18.4       | 2.1e-10 | 20      |
 | URI::Escape::XS::uri_unescape  | u_ascii53 | 1.6e+06   | 0.61      | 20         | 7e-10   | 44      |
 | URI::Escape::XS::uri_escape    | empty     | 1.63e+06  | 0.612     | 20.3       | 2.1e-10 | 21      |
 | URI::Escape::XS::uri_unescape  | u_ascii66 | 1.83e+06  | 0.548     | 22.7       | 2.1e-10 | 20      |
 | URI::XSEscape::uri_escape_utf8 | empty     | 1.93e+06  | 0.517     | 24         | 2.1e-10 | 21      |
 | URI::XSEscape::uri_unescape    | u_ascii53 | 2.73e+06  | 0.367     | 33.9       | 2e-10   | 24      |
 | URI::XSEscape::uri_unescape    | u_ascii66 | 2.75e+06  | 0.364     | 34.1       | 2.1e-10 | 20      |
 | URI::XSEscape::uri_escape      | ascii53   | 2.88e+06  | 0.348     | 35.7       | 1.9e-10 | 24      |
 | URI::XSEscape::uri_escape      | ascii66   | 3e+06     | 0.34      | 37         | 4e-10   | 345     |
 | URI::XSEscape::uri_escape      | empty     | 5e+06     | 0.2       | 62.1       | 3.5e-11 | 20      |
 +--------------------------------+-----------+-----------+-----------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m URIEscaping --module-startup >>):

 +---------------------+-----------+------------------------+------------+---------+---------+
 | participant         | time (ms) | mod_overhead_time (ms) | vs_slowest | errors  | samples |
 +---------------------+-----------+------------------------+------------+---------+---------+
 | URI::Escape         | 11.3      | 6.87                   | 1          | 1.1e-05 | 1083    |
 | URI::Escape::XS     | 11        | 6.57                   | 1.03       | 1e-05   | 949     |
 | URI::XSEscape       | 9.38      | 4.95                   | 1.21       | 9.2e-06 | 672     |
 | perl -e1 (baseline) | 4.43      | 0                      | 2.56       | 4.4e-06 | 4009    |
 +---------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-URIEscaping>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-URIEscaping>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-URIEscaping>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
