package Bencher::Scenario::ShellQuoteAny;

our $DATE = '2016-09-26'; # DATE
our $VERSION = '0.001'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark cross-platform shell quoting',
    participants => [
        {
            fcall_template=>'ShellQuote::Any::shell_quote(<cmd>)',
        },
        {
            fcall_template=>'PERLANCAR::ShellQuote::Any::shell_quote(@{<cmd>})',
        },
    ],
    datasets => [
        {name=>'empty0', args=>{cmd=>[]}},
        {name=>'empty1', args=>{cmd=>['']}},
        {name=>'cmd1', args=>{cmd=>['foo bar']}},
        {name=>'cmd5', args=>{cmd=>['foo', 'bar', 'baz', 'qux', 'quux']}},
    ],
};

1;
# ABSTRACT: Benchmark cross-platform shell quoting

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::ShellQuoteAny - Benchmark cross-platform shell quoting

=head1 VERSION

This document describes version 0.001 of Bencher::Scenario::ShellQuoteAny (from Perl distribution Bencher-Scenario-ShellQuoteAny), released on 2016-09-26.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m ShellQuoteAny

To run module startup overhead benchmark:

 % bencher --module-startup -m ShellQuoteAny

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<ShellQuote::Any> 0.03

L<PERLANCAR::ShellQuote::Any> 0.001

=head1 BENCHMARK PARTICIPANTS

=over

=item * ShellQuote::Any::shell_quote (perl_code)

Function call template:

 ShellQuote::Any::shell_quote(<cmd>)



=item * PERLANCAR::ShellQuote::Any::shell_quote (perl_code)

Function call template:

 PERLANCAR::ShellQuote::Any::shell_quote(@{<cmd>})



=back

=head1 BENCHMARK DATASETS

=over

=item * empty0

=item * empty1

=item * cmd1

=item * cmd5

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.2 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.5 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m ShellQuoteAny >>):

 #table1#
 {dataset=>"cmd1"}
 +-----------------------------------------+-----------+-----------+------------+---------+---------+
 | participant                             | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +-----------------------------------------+-----------+-----------+------------+---------+---------+
 | ShellQuote::Any::shell_quote            |    451260 |     2.216 |       1    | 1.2e-11 |      20 |
 | PERLANCAR::ShellQuote::Any::shell_quote |    489000 |     2.05  |       1.08 | 8.3e-10 |      20 |
 +-----------------------------------------+-----------+-----------+------------+---------+---------+

 #table2#
 {dataset=>"cmd5"}
 +-----------------------------------------+-----------+-----------+------------+---------+---------+
 | participant                             | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +-----------------------------------------+-----------+-----------+------------+---------+---------+
 | ShellQuote::Any::shell_quote            |    265540 |    3.7659 |       1    | 1.1e-11 |      32 |
 | PERLANCAR::ShellQuote::Any::shell_quote |    273000 |    3.67   |       1.03 | 1.6e-09 |      21 |
 +-----------------------------------------+-----------+-----------+------------+---------+---------+

 #table3#
 {dataset=>"empty0"}
 +-----------------------------------------+-----------+-----------+------------+---------+---------+
 | participant                             | rate (/s) | time (ns) | vs_slowest |  errors | samples |
 +-----------------------------------------+-----------+-----------+------------+---------+---------+
 | ShellQuote::Any::shell_quote            |   1045000 |     957.3 |       1    | 3.4e-11 |      20 |
 | PERLANCAR::ShellQuote::Any::shell_quote |   1250000 |     801   |       1.19 | 4.2e-10 |      20 |
 +-----------------------------------------+-----------+-----------+------------+---------+---------+

 #table4#
 {dataset=>"empty1"}
 +-----------------------------------------+-----------+-----------+------------+---------+---------+
 | participant                             | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +-----------------------------------------+-----------+-----------+------------+---------+---------+
 | ShellQuote::Any::shell_quote            |    650000 |      1.5  |       1    | 2.1e-09 |      20 |
 | PERLANCAR::ShellQuote::Any::shell_quote |    726000 |      1.38 |       1.11 | 4.2e-10 |      20 |
 +-----------------------------------------+-----------+-----------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m ShellQuoteAny --module-startup >>):

 #table5#
 +----------------------------+-----------+------------------------+------------+---------+---------+
 | participant                | time (ms) | mod_overhead_time (ms) | vs_slowest |  errors | samples |
 +----------------------------+-----------+------------------------+------------+---------+---------+
 | ShellQuote::Any            |       4.6 |                    2   |        1   |   2e-05 |      21 |
 | PERLANCAR::ShellQuote::Any |       2.8 |                    0.2 |        1.6 | 2.4e-05 |      20 |
 | perl -e1 (baseline)        |       2.6 |                    0   |        1.8 | 1.7e-05 |      21 |
 +----------------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-ShellQuoteAny>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-ShellQuoteAny>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-ShellQuoteAny>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

L<Bencher::Scenario::HashBuilding>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
