package App::lcpan::Cmd::dist2author;

our $DATE = '2016-05-25'; # DATE
our $VERSION = '0.87'; # VERSION

use 5.010;
use strict;
use warnings;

require App::lcpan;

our %SPEC;

$SPEC{'handle_cmd'} = {
    v => 1.1,
    summary => 'Get author of distribution(s)',
    args => {
        %App::lcpan::common_args,
        %App::lcpan::dists_args,
    },
};
sub handle_cmd {
    my %args = @_;

    my $state = App::lcpan::_init(\%args, 'ro');
    my $dbh = $state->{dbh};

    my $dists = $args{dists};

    my $dists_s = join(",", map {
        my $d=$_; $d =~ s/::/-/g; $dbh->quote($d);
    } @$dists);

    my $sth = $dbh->prepare("SELECT
  dist.name dist,
  dist.cpanid author
FROM dist
WHERE dist.name IN ($dists_s)");

    my @res;
    $sth->execute;
    while (my $row = $sth->fetchrow_hashref) {
        push @res, $row;
    }

    if (@$dists == 1) {
        @res = map { $_->{dist} } @res;
        if (!@res) {
            return [404, "No such dist"];
        } elsif (@res == 1) {
            return [200, "OK", $res[0]];
        } else {
            return [200, "OK", \@res];
        }
    }

    [200, "OK", \@res, {'table.fields'=>[qw/dist author/]}];
}

1;
# ABSTRACT: Get author of distribution(s)

__END__

=pod

=encoding UTF-8

=head1 NAME

App::lcpan::Cmd::dist2author - Get author of distribution(s)

=head1 VERSION

This document describes version 0.87 of App::lcpan::Cmd::dist2author (from Perl distribution App-lcpan), released on 2016-05-25.

=head1 FUNCTIONS


=head2 handle_cmd(%args) -> [status, msg, result, meta]

Get author of distribution(s).

This function is not exported.

Arguments ('*' denotes required arguments):

=over 4

=item * B<cpan> => I<str>

Location of your local CPAN mirror, e.g. /path/to/cpan.

Defaults to C<~/cpan>.

=item * B<dists>* => I<array[str]>

=item * B<index_name> => I<str> (default: "index.db")

Filename of index.

=back

Returns an enveloped result (an array).

First element (status) is an integer containing HTTP status code
(200 means OK, 4xx caller error, 5xx function error). Second element
(msg) is a string containing error message, or 'OK' if status is
200. Third element (result) is optional, the actual result. Fourth
element (meta) is called result metadata and is optional, a hash
that contains extra information.

Return value:  (any)

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/App-lcpan>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-App-lcpan>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=App-lcpan>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
