## $Id: Capture.pir 26936 2008-04-12 05:13:43Z infinoid $

=head1 TITLE

Capture - Perl 6 Capture class

=head1 DESCRIPTION

This file sets up the Perl 6 C<Capture> class.

=cut

.namespace ['Capture']

.sub 'onload' :anon :init :load
    $P0 = subclass 'Capture', 'Perl6Capture'
    $P1 = get_hll_global 'Any'
    $P1 = $P1.HOW()
    addparent $P0, $P1
    $P1 = get_hll_global ['Perl6Object'], 'make_proto'
    $P1($P0, 'Capture')
.end


=head1 METHODS

=over

=item !create

Creates a capture.

=cut

.sub '!create' :method
    .param pmc invocant
    .param pmc array :slurpy
    .param pmc hash :named :slurpy

    # Create capture.
    .local pmc capt
    capt = self.'new'()

    # Set array part.
    .local pmc it
    it = iter array
  array_loop:
    unless it goto array_loop_end
    $P0 = shift it
    push capt, $P0
    goto array_loop
  array_loop_end:

    # Set hash part.
    it = iter hash
  hash_loop:
    unless it goto hash_loop_end
    $P0 = shift it
    $P1 = hash[$P0]
    capt[$P0] = $P1
    goto hash_loop
  hash_loop_end:

    # Done.
    .return(capt)
.end


=item clone (vtable method)

Captures are immutable, so just return ourself.

=cut

.sub 'clone' :method :vtable
    .return (self)
.end


=back

=cut


# Local Variables:
#   mode: pir
#   fill-column: 100
# End:
# vim: expandtab shiftwidth=4 ft=pir:
