#! perl
# Copyright (C) 2007, The Perl Foundation.
# $Id: fixup_gen_file.pl 21357 2007-09-18 19:50:27Z chromatic $

=head1 NAME

tools/build/fixup_gen_file.pl - mark a generated file as generated

=head1 SYNOPSIS

    % perl tools/build/fixup_gen_file.pl <generated_file> <dest_file>

=head1 DESCRIPTION

This script adds special headers and footers to files generated by tools
outside of Parrot's normal build process.  This is so that people do not
accidentally modify these files.

=cut

use strict;
use warnings;

use lib 'lib';
use Parrot::BuildUtil;

my ($gen_file, $source) = @ARGV;
my $contents            = Parrot::BuildUtil::slurp_file($gen_file);

open( my $dest_fh, '>', $gen_file ) or die "Cannot write to '$gen_file': $!\n";

print {$dest_fh} <<END_HEADER, $contents;
/* ex: set ro ft=c:
 * !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!!
 *
 * This file is generated automatically by the Parrot build process
 * from the file $source.
 *
 * Any changes made here will be lost!
 *
*/
END_HEADER

close $dest_fh;

# Local Variables:
#   mode: cperl
#   cperl-indent-level: 4
#   fill-column: 100
# End:
# vim: expandtab shiftwidth=4:
