#! perl
# $Id: nested.t 21311 2007-09-16 18:50:04Z bernhard $

# Copyright (C) 2001-2007, The Perl Foundation.

use strict;
use warnings;
use FindBin;
use lib "$FindBin::Bin/../../lib";

use Parrot::Test::Scheme tests => 8;

###
### Add
###

output_is( <<'CODE', 12, 'write (+ (+ 5 7))' );
(write (+ (+ 5 7)))
CODE

output_is( <<'CODE', 11, 'write (+ (+ 3 -1) (+ 2 7))' );
(write (+ (+ 3 -1) (+ 2 7)))
CODE

###
### Subtract
###

output_is( <<'CODE', 2, 'write (- (- 5 7))' );
(write (- (- 5 7)))
CODE

output_is( <<'CODE', 9, 'write (- (- 3 -1) (- 2 7))' );
(write (- (- 3 -1) (- 2 7)))
CODE

###
### Multiply
###

output_is( <<'CODE', 35, 'write (* (* 5 7))' );
(write (* (* 5 7)))
CODE

output_is( <<'CODE', -42, 'write (* (* 3 -1) (* 2 7))' );
(write (* (* 3 -1) (* 2 7)))
CODE

###
### Divide
###

###
### Abs
###

output_is( <<'CODE', 8, 'abs (+ 3 5)' );
(write (abs (+ 3 5)))
CODE

output_is( <<'CODE', 2, 'abs (- 3 5)' );
(write (abs (- 3 5)))
CODE

# Local Variables:
#   mode: cperl
#   cperl-indent-level: 4
#   fill-column: 100
# End:
# vim: expandtab shiftwidth=4:
