package JIRA::REST::Class::Issue::Transitions::Transition;
use base qw( JIRA::REST::Class::Abstract );
use strict;
use warnings;
use v5.10;

our $VERSION = '0.01'; # TRIAL

# ABSTRACT: A helper class for C<JIRA::REST::Class> that represents the state transitions a JIRA issue can go through.

__PACKAGE__->mk_ro_accessors(qw/ issue to /);
__PACKAGE__->mk_data_ro_accessors(qw/ id name hasScreen fields /);
__PACKAGE__->mk_field_ro_accessors(qw/ summary /);

sub init {
    my $self = shift;
    $self->SUPER::init(@_);

    $self->{to} = $self->make_object('status', { data => $self->data->{to} });
}


sub go {
    my $self = shift;
    $self->issue->post("/transitions", {
        transition => { id => $self->id }, @_
    });
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

JIRA::REST::Class::Issue::Transitions::Transition - A helper class for C<JIRA::REST::Class> that represents the state transitions a JIRA issue can go through.

=head1 VERSION

version 0.01

=head1 METHODS

=head2 B<go>

Perform the transition represented by this object on the issue.

=head1 AUTHOR

Packy Anderson <packy@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2016 by Packy Anderson.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
