package WebService::PayPal::PaymentsAdvanced::Role::HasMessage;
$WebService::PayPal::PaymentsAdvanced::Role::HasMessage::VERSION = '0.000006';
use Moo::Role;

use Types::Standard qw( Str );

has message => (
    is       => 'lazy',
    isa      => Str,
    init_arg => undef,
);

sub _build_message {
    my $self = shift;
    return $self->params->{RESPMSG};
}

1;

=pod

=encoding UTF-8

=head1 NAME

WebService::PayPal::PaymentsAdvanced::Role::HasMessage - Role which provides message attribute to exception and response classes.

=head1 VERSION

version 0.000006

=head1 AUTHOR

Olaf Alders <olaf@wundercounter.com>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2015 by MaxMind, Inc..

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut

__END__
#ABSTRACT: Role which provides message attribute to exception and response classes.
