
use strict ;
use warnings ;

use Module::Build;

my %all_modules ;
my @split_modules ;

my @pm_files = qw(
lib/Config/Hierarchical.pm
lib/Config/Hierarchical/Tie/ReadOnly.pm
lib/Config/Hierarchical/Delta.pm
);

for(@pm_files)
	{
	$all_modules{$_} = $_ ;
	push @split_modules, $_ ;
	}

sub GetVersionandRevisionFrom
{
my ($file) = @_ ;

my $version_from = File::Spec->catfile( split '/', $file );
my $version      = Module::Build->version_from_file($version_from);

if($ENV{'Config_Hierarchical_USE_GIT_VERSION_FOR_DIST'})
	{
	my $number_of_commits = `git log | grep -E 'commit [0-9a-f]{40}' | wc -l` ;
	chomp $number_of_commits ;
	
	if($number_of_commits)
		{
		#~ print "number of git revision $number_of_commits.\n" ;
		return("${version}.${number_of_commits}") ;
		}
	else
		{
		print "Couldn't get git revision, using version from '$file'!\n" ;
		return($version) ;
		}
	}
else
	{
	return($version) ;
	}
}

my $code = <<'EOC';
use strict ;
use warnings ;

sub GetVersionandRevisionFrom
{
my ($file) = @_ ;

my $version_from = File::Spec->catfile( split '/', $file );
my $version      = Module::Build->version_from_file($version_from);

if($ENV{'Config_Hierarchical_USE_GIT_VERSION_FOR_DIST'})
	{
	my $number_of_commits = `git log | grep -E 'commit [0-9a-f]{40}' | wc -l` ;
	chomp $number_of_commits ;
	
	if($number_of_commits)
		{
		#print "number of git revision: $number_of_commits.\n" ;
		return("${version}.${number_of_commits}") ;
		}
	else
		{
		print "Couldn't get git revision, using version from '$file'!\n" ;
		return($version) ;
		}
	}
else
	{
	return($version) ;
	}
}

sub ACTION_author_test
{
my $self = shift;
local $self->{properties}{test_files} = 'xt/author/*.t' ;
$self->SUPER::ACTION_test();
}

sub ACTION_build 
{
my $self = shift;

if($ENV{'Config_Hierarchical_USE_GIT_VERSION_FOR_DIST'})
	{
	my ($version) = GetVersionandRevisionFrom('lib/Config/Hierarchical.pm') ;
	
	#~ print "Generating version module ($version)\n" ;
	
	open VERSION, '>', 'Version.pm' or die "can't generate Version module: $!\n" ;
	
	print VERSION <<EOV ;
	
	# version module automatically generated by the build system
	
	package Config::Version ;
	
	sub GetVersion {return '$version'} ;
	
	1 ;
	
	# end of generated version module
EOV
	
	close VERSION ;
	}
	
$self->SUPER::ACTION_build(@_);
}

sub ACTION_latest
{
my $self = shift;

$self->ACTION_dist(@_) ;

if($ENV{'Config_Hierarchical_USE_GIT_VERSION_FOR_DIST'})
	{
	`git status -a`;

	my ($version) = GetVersionandRevisionFrom('lib/Config/Hierarchical.pm') ;
	
	my $source = "Config-Hierarchical-$version.tar.gz" ;
	my $destination = "Config-Hierarchical-latest.tar.gz" ;
	
	eval {use Net::SCP qw(scp iscp);};
	die $@ if $@ ;
	
	my $scp = Net::SCP->new();

	$scp->iscp($source, "nadim\@firewall:/var/www/localhost/htdocs/files_for_download/$destination") or die $scp->{errstr} ;
	}
}

sub ACTION_dist
{
my $self = shift;

if($ENV{'Config_Hierarchical_USE_GIT_VERSION_FOR_DIST'})
	{
	my $have_git = $self->do_system('git --version');
	
	if($have_git)
		{
		print `git status -a`;
		
		if($self->do_system('git log  > git_Changes'))
			{
			use File::Copy;
			move('git_Changes', 'Changes') ;
			}
		else
			{
			print "Couldn't get git log, 'Changes' will not be generated from git log!\n" ;
			}
		}
	else
		{
		print "git not found, 'Changes' will not be generated from git log!\n" ;
		}
	}

$self->SUPER::ACTION_test() ;
#~ $self->ACTION_author_test() ;

$self->SUPER::ACTION_dist();
};


EOC


my $class = Module::Build->subclass
			(
			class => 'Config::Hierarchical',
			code => $code,  
			) ;
			
my $build = $class->new
	(
	module_name => 'Config::Hierarchical',
	
	dist_version => GetVersionandRevisionFrom('lib/Config/Hierarchical.pm'),
	
	license => 'perl',
	
	requires => 
		{
		'Readonly'         => 0,
		'Data::Compare'    => 0,
		'Sub::Install'     => 0,
		'Data::TreeDumper' => 0,
		'Test::Cookbook' => 0.02,
		'Eval::Context' => 0.03,
		
		'Test::Block' => 0,
		'Test::Dependencies' => 0,
		'Test::Distribution' => 0,
		'Test::Exception' => 0,
		'Test::NoWarnings' => 0,
		'Test::Warn' => 0,
		'Test::Strict' => 0,
		},
		
	pm_files     => \%all_modules,
	autosplit    => \@split_modules,
	
	dist_author  => 'Khemir Nadim ibn Hamouda. <nadim@khemir.net>',
	dist_abstract => 'configuration variable hierachical container',
	);
	
$build->create_build_script;
  
