#!perl -Tw

use strict;
use warnings;
use Test::More tests => 22;
use Test::NoWarnings;

BEGIN {
	use_ok('CGI::Info');
}

ROBOT: {
	delete $ENV{'REMOTE_ADDR'};
	delete $ENV{'HTTP_USER_AGENT'};

	my $i = new_ok('CGI::Info');
	ok($i->is_search_engine() == 0);

	$ENV{'REMOTE_ADDR'} = '65.52.110.76';
	$i = new_ok('CGI::Info');
	ok($i->is_search_engine() == 0);

	$ENV{'HTTP_USER_AGENT'} = 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)';
	$i = new_ok('CGI::Info');
	ok($i->is_search_engine() == 1);
	ok($i->browser_type() eq 'robot');

	$ENV{'REMOTE_ADDR'} = '119.63.196.107';
	$ENV{'HTTP_USER_AGENT'} = 'Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)';

	$i = new_ok('CGI::Info');
	ok($i->is_search_engine() == 1);
	ok($i->browser_type() eq 'robot');

	$ENV{'REMOTE_ADDR'} = '207.241.237.233';
	$ENV{'HTTP_USER_AGENT'} = 'Mozilla/5.0 (compatible; archive.org_bot +http://www.archive.org/details/archive.org_bot)';

	$i = new_ok('CGI::Info');
	ok($i->is_search_engine() == 0);

	$ENV{'REMOTE_ADDR'} = '74.92.149.57';
	$ENV{'HTTP_USER_AGENT'} = 'Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10.7; en-US; rv:1.9.2.20) Gecko/20110803 Firefox/3.6.20';

	$i = new_ok('CGI::Info');
	ok($i->is_search_engine() == 0);

	$ENV{'REMOTE_ADDR'} = '66.249.73.149';
	$ENV{'HTTP_USER_AGENT'} = 'Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)';

	$i = new_ok('CGI::Info');
	ok($i->is_search_engine() == 1);
	ok($i->browser_type() eq 'robot');

	$ENV{'HTTP_USER_AGENT'} = 'A nonsense user agent string';
	$ENV{'REMOTE_ADDR'} = '212.159.106.41';
	$i = new_ok('CGI::Info');
	ok($i->is_search_engine() == 0);
	ok($i->browser_type() eq 'robot');
}
