# This Makefile.PL for Tree-RB-XS was generated by
# Dist::Zilla::Plugin::MakeMaker::Awesome 0.49.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use ExtUtils::MakeMaker;

our %PREREQ_PM;
BEGIN {
    %PREREQ_PM= (
        'ExtUtils::Depends' => '0.405',
    );

    # If the prereqs for this script are missing,
    # write out a Makefile that tells CPAN to install them
    my $use_prereqs_code= join('', map { "use $_ '$PREREQ_PM{$_}'; " } keys %PREREQ_PM).'1;';
    print $use_prereqs_code."\n";
    unless (eval $use_prereqs_code) {
       warn "$@\n";
       WriteMakefile(
             NAME         => 'Tree::RB::XS',
             PREREQ_FATAL => 1,
             PREREQ_PM    => \%PREREQ_PM,
       );
       exit 1; # not reached
    }
}

# Write out the rbtree.h and rbtree.c files
use FindBin;
use lib "$FindBin::RealBin/util";
use RBGen;
RBGen->new(namespace => 'rbtree_')
    ->write_api("$FindBin::RealBin/rbtree.h")
    ->write_impl("$FindBin::RealBin/rbtree.c");

my $dep= ExtUtils::Depends->new('Tree::RB::XS');

$dep->add_c('rbtree.c');
$dep->add_xs('TreeRBXS.xs');
$dep->add_pm(map { my $n= $_; $n =~ s/^lib/\$(INST_LIB)/; $_ => $n } <lib/*/*.pm>, <lib/*/*/*.pm>);
$dep->add_typemaps('typemap');

my %WriteMakefileArgs = (
  "ABSTRACT" => "Red/Black Tree container with similar API to Tree::RB",
  "AUTHOR" => "Michael Conrad <mike\@nrdvana.net>",
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::Depends" => "0.405",
    "ExtUtils::MakeMaker" => 0
  },
  "DISTNAME" => "Tree-RB-XS",
  "LICENSE" => "perl",
  "NAME" => "Tree::RB::XS",
  "PREREQ_PM" => {
    "Carp" => 0,
    "Exporter" => 0,
    "Scalar::Util" => 0,
    "XSLoader" => 0,
    "strict" => 0,
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "FindBin" => 0,
    "Test2::Suite" => "0.000139",
    "Test2::Tools::Subtest" => 0,
    "Test2::V0" => 0,
    "Time::HiRes" => 0,
    "lib" => 0,
    "parent" => 0
  },
  "VERSION" => "0.12",
  "test" => {
    "TESTS" => "t/*.t"
  }
);

%WriteMakefileArgs = (
    %WriteMakefileArgs,
    $dep->get_makefile_vars,
);

my %FallbackPrereqs = (
  "Carp" => 0,
  "Exporter" => 0,
  "FindBin" => 0,
  "Scalar::Util" => 0,
  "Test2::Suite" => "0.000139",
  "Test2::Tools::Subtest" => 0,
  "Test2::V0" => 0,
  "Time::HiRes" => 0,
  "XSLoader" => 0,
  "lib" => 0,
  "parent" => 0,
  "strict" => 0,
  "warnings" => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION('6.63_03') } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);
