#!/usr/bin/perl -w

use 5.006;

use strict;
use Module::Build;

my $builder = Module::Build->new(
    module_name => 'Gravatar::URL',
    license     => 'perl',

    meta_merge  => {
        resources => {
            bugtracker =>
              'http://rt.cpan.org/Public/Dist/Display.html?Name=Gravatar-URL',
            repository =>
              'http://svn.schwern.org/svn/CPAN/Gravatar-URL',
        },

        keywords => [ 'Gravatar' ],

        configure_requires => {
            'Module::Build'     => 0.2808
        },
    },

    build_requires      => {
        'Test::More'        => 0.40,
    },

    requires             => {
        'URI::Escape'       => 0,
        'Digest::MD5'       => 0,
        'Carp'              => 0,
        perl                => '5.6.0',
    },
);

$builder->create_build_script();
