#!/usr/bin/perl -w

=head1 NAME

example-getsatellitelist.pl - GPS::SpaceTrack getsatellitelist method example

=cut

use strict;
use lib qw{./lib ../lib};
use GPS::SpaceTrack;

my $lat=shift()||38.870997;    #degrees
my $lon=shift()||-77.05596;    #degrees
my $hae=shift()||13;           #meters

my $filename="";
$filename="../doc/gps.tle" if -r "../doc/gps.tle";
$filename="./doc/gps.tle" if -r "./doc/gps.tle";
$filename="./gps.tle" if -r "./gps.tle";
$filename="../gps.tle" if -r "../gps.tle";
$filename="../../gps.tle" if -r "../../gps.tle";

my $obj=GPS::SpaceTrack->new(filename=>$filename) || die();

my $i=0;
print join("\t", qw{Count PRN ELEV Azim SNR USED}), "\n";
foreach ($obj->getsatellitelist({lat=>$lat, lon=>$lon, alt=>$hae})) {
  print join "\t", ++$i,
                   $_->prn,
                   $_->elev,
                   $_->azim,
                   $_->snr,
                   $_->used;
  print "\n";
}

__END__

=head1 SAMPLE OUTPUT

  Count PRN     ELEV    Azim    SNR     USED
  1     10      82.3504976345584        339.677127468046        44.2026450445031  2     24      68.4355439795088        345.885792118558        38.9208914253991  3     02      55.3222191964004        73.8217836452593        30.4327698027741  4     06      36.8724770627893        308.075338462491        16.2019448600921  5     29      31.0466498320535        167.832339462786        11.9692538730861  6     07      30.7000125102801        310.829829791487        11.7294418230031  7     30      20.2234294506517        258.637356702231        5.37732015381120  8     26      18.2207643961167        177.350141755671        4.39957198001860  9     04      16.7380766832127        94.1631139614662        3.73240198658620  10    05      13.0915824128185        228.492843863955        2.30876868911920  11    13      7.09378343221286        32.5933329750899        0.686282432297905       0
  12    27      2.14949917899331        67.0848507169795        0.063305006688688       0
  13    21      -2.31006816657926       284.479650263652        0       0
  14    08      -2.8982266117236        92.8665243276918        0       0
  15    16      -12.0046260012336       350.115248969658        0       0
  16    17      -13.6636876335139       144.043366886325        0       0
  17    18      -14.3436511507757       233.536064424615        0       0
  18    23      -17.5249692779877       18.896786168271 0       0
  19    09      -20.0988077784026       198.307630727632        0       0
  20    31      -21.618914793397        307.821715931769        0       0
  21    25      -23.0412231061771       318.156024941566        0       0
  22    12      -27.8961996264913       16.2100176119627        0       0
  23    28      -39.3482708493149       123.358878409524        0       0
  24    22      -42.8649588786454       230.826792820631        0       0
  25    20      -48.2220568837961       60.2284530035477        0       0
  26    03      -55.2875579557199       344.325815721827        0       0
  27    14      -59.8377439669491       252.536206981833        0       0
  28    01      -59.9329626721447       322.596923774397        0       0
  29    11      -63.8515028571451       124.157495495177        0       0
  30    19      -75.2535649119526       353.334720486691        0       0

=cut
