package ImplicitTest;
use Test::More tests => 16;
use Devel::DumpTrace::PPI;
use PPI;
use strict;
use warnings;
use Carp::Always;

# more implicit argument tests, see also t/ppi/32-implicit.t

Devel::DumpTrace::import_all();
*preval = \&Devel::DumpTrace::PPI::preval;
*__add_implicit_elements = \&Devel::DumpTrace::PPI::__add_implicit_elements;

$_ = "FOOasdfBAR";
$. = 10;
@ARGV = ('squeam', '73');
$ENV{TEST_36} = "value 36";




my $doc = new PPI::Document(\<<'__EOD__');
if ($ENV{BEGIN_BIG_BLOCK} != 7) {
  m+asdf+ && print "Contains asdf\n";
  s/bar/quux/i && print "$_ world\n";
  my $r = y/0-9/a-j/;
  if (my $z=log) {
    print;
  }
  my $zz = ref;
  if (sin ... 17) {
    my $zzz = 512;
  }
  my $zzz = shift;
  some_function(-f);
  print "END_BIG_BLOCK\n" if -t;
}
__EOD__





my $s = $doc->find('PPI::Statement');
for (@$s) {
    __add_implicit_elements($_);
    Devel::DumpTrace::PPI::__add_implicit_to_given_when_blocks($_);
}

my @z1 = preval($s->[0], 1, __PACKAGE__);  # big if (...) {...}

ok("@z1" =~ /BEGIN_BIG_BLOCK/ && "@z1" =~ /END_BIG_BLOCK/,
   'z1 captures big if statement');
ok("@z1" =~ /\$_:'FOOasdfBAR'/, 'z1 $_ attached value');
ok("@z1" =~ /\$_.*=~.*m\+asdf\+/, 'z1 implicit $_ to m//');
ok("@z1" =~ m[\$_.*=~.*s/bar/], 'z1 implicit $_ to s///');
ok("@z1" =~ m[\$_.*=~.*y/0-9/], 'z1 implicit $_ to y|tr//');
ok("@z1" =~ m[\$z\s+=\s+log\s+\$_], 'z1 implicit $_ to log');
ok("@z1" =~ m[\$zz\s+=\s+ref\s+\$_], 'z1 implicit $_ to ref');
ok("@z1" =~ m[sin\s+\$_], 'z1 implicit $_ to sin');
ok("@z1" =~ m[\$\..*\s+==\s+17], 'z1 implicit $. to number in flipflop');
ok("@z1" =~ m[\$\.:10], 'z1 $. attached value');
ok("@z1" =~ m[\$zzz\b.*shift\s+\@ARGV], 'z1 implicit @ARGV');
ok("@z1" =~ m[\@ARGV:\(\'squeam], 'z1 @ARGV attached value');
ok("@z1" =~ m[-f\s+\$_], 'z1 implicit $_ to -f');
ok("@z1" =~ m[-f\s+\$_:'FOO], 'z1 $_ attached value');
ok("@z1" =~ m[-t\b] && !m[-t\b\s+\$_], 'z1 no implicit $_ to -t');

ok("@z1" =~ /TEST_36.*value 36/, 'z1 %ENV attached value');

