package MyTypes::TaskModifyData;
use strict;
use warnings;


our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}


use base qw(MyTypes::CommonItemData);
# Variety: sequence
use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Permissions_of :ATTR(:get<Permissions>);
my %Categories_of :ATTR(:get<Categories>);
my %Title_of :ATTR(:get<Title>);
my %Editor_of :ATTR(:get<Editor>);
my %AlertTemplate_of :ATTR(:get<AlertTemplate>);
my %Url_of :ATTR(:get<Url>);
my %Comment_of :ATTR(:get<Comment>);
my %AlertRecipients_of :ATTR(:get<AlertRecipients>);
my %Status_of :ATTR(:get<Status>);
my %Description_of :ATTR(:get<Description>);
my %DueDate_of :ATTR(:get<DueDate>);
my %AssignedTo_of :ATTR(:get<AssignedTo>);

__PACKAGE__->_factory(
    [ qw(        Permissions
        Categories
        Title
        Editor
        AlertTemplate
        Url
        Comment
        AlertRecipients
        Status
        Description
        DueDate
        AssignedTo

    ) ],
    {
        'Permissions' => \%Permissions_of,
        'Categories' => \%Categories_of,
        'Title' => \%Title_of,
        'Editor' => \%Editor_of,
        'AlertTemplate' => \%AlertTemplate_of,
        'Url' => \%Url_of,
        'Comment' => \%Comment_of,
        'AlertRecipients' => \%AlertRecipients_of,
        'Status' => \%Status_of,
        'Description' => \%Description_of,
        'DueDate' => \%DueDate_of,
        'AssignedTo' => \%AssignedTo_of,
    },
    {
        'Permissions' => 'MyTypes::ArrayOfPermission',
        'Categories' => 'MyTypes::ArrayOfString',
        'Title' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'Editor' => 'MyTypes::NUser',
        'AlertTemplate' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'Url' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'Comment' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'AlertRecipients' => 'MyTypes::HstringAddressesSalutations',
        'Status' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'Description' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'DueDate' => 'SOAP::WSDL::XSD::Typelib::Builtin::dateTime',
        'AssignedTo' => 'MyTypes::NUser',
    },
    {

        'Permissions' => 'Permissions',
        'Categories' => 'Categories',
        'Title' => 'Title',
        'Editor' => 'Editor',
        'AlertTemplate' => 'AlertTemplate',
        'Url' => 'Url',
        'Comment' => 'Comment',
        'AlertRecipients' => 'AlertRecipients',
        'Status' => 'Status',
        'Description' => 'Description',
        'DueDate' => 'DueDate',
        'AssignedTo' => 'AssignedTo',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

MyTypes::TaskModifyData

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
TaskModifyData from the namespace http://tempuri2.org/.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Status


=item * Description


=item * DueDate


=item * AssignedTo




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # MyTypes::TaskModifyData
   Status =>  $some_value, # string
   Description =>  $some_value, # string
   DueDate =>  $some_value, # dateTime
   AssignedTo =>  { value => $some_value },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

