# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl Business-KontoCheck.t'

use Test::More tests => 161;

BEGIN { use_ok('Business::KontoCheck') };

$ok_cnt=$nok_cnt=0;
while(<DATA>){
   chomp;
   ($soll,$zweck1)=split(/ /);

   ($zweck,$papier,$retval)=Business::KontoCheck::ipi_gen($zweck1);
   $ret_txt=$kto_retval{$retval};
   if($soll eq $zweck){$ok_cnt++;}else{$nok_cnt++;}
   ok($soll eq $zweck,"ipi_gen von $zweck1: $retval (Soll: $soll) => $ret_txt (ok: $ok_cnt, nok: $nok_cnt)");
   $retval=Business::KontoCheck::ipi_check($soll);
   $ret_txt=$kto_retval{$retval};
   if($retval eq 1){$ok_cnt++;}else{$nok_cnt++;}
   ok($retval eq 1,"ipi_check von $soll: $retval/$papier => $ret_txt (ok: $ok_cnt, nok: $nok_cnt)");
}

__DATA__
64VFAD35256230423153 vfad35256230423153
19AVFM22744812743429 avfm22744812743429
69SZQR97314511619595 szqr97314511619595
60VOPM15934003570667 vopm15934003570667
97QQZH46162726033563 qqzh46162726033563
29VQWB03326257229913 vqwb03326257229913
40ABNM65212349844052 abnm65212349844052
60BSYM84633780054364 bsym84633780054364
22VLMW76288869553169 vlmw76288869553169
47MUJE80192151469551 muje80192151469551
30MULW27087318815833 mulw27087318815833
04VPEM22310931134307 vpem22310931134307
80BKMW87211859254041 bkmw87211859254041
45YMKM99772938688139 ymkm99772938688139
35LPLH62607816711971 lplh62607816711971
91VJLH71806430238466 vjlh71806430238466
97JBST17387072176742 jbst17387072176742
07PLBO05625329899726 plbo05625329899726
31ACRC84685238980757 acrc84685238980757
30RPAR43947026474313 rpar43947026474313
72ZXMM76514825846203 zxmm76514825846203
92DOVS48902717018199 dovs48902717018199
76OCEW54578992902845 ocew54578992902845
79EKOS80529652055975 ekos80529652055975
62EOXH11112914547647 eoxh11112914547647
74TDEM71601984813850 tdem71601984813850
70NIOU90886276428782 niou90886276428782
09THNV36870446456475 thnv36870446456475
62LQGU95832741905785 lqgu95832741905785
39TWLZ70738025094777 twlz70738025094777
77WTGD84107837009241 wtgd84107837009241
97LYVR20829201646337 lyvr20829201646337
12WRRB60891958613390 wrrb60891958613390
71GWVX89585655565180 gwvx89585655565180
47DJIX62563182628314 djix62563182628314
31LZUI86646297320831 lzui86646297320831
22EKFL36016032368300 ekfl36016032368300
43EPNI91991538322411 epni91991538322411
96BQNV86385389681911 bqnv86385389681911
43RLPG65229377996659 rlpg65229377996659
84DCIC08175816228234 dcic08175816228234
59PBDK57497328901916 pbdk57497328901916
24AGAQ74158020712435 agaq74158020712435
94RHAF17703435274890 rhaf17703435274890
32COZE54177511680750 coze54177511680750
54HFYX88628276163916 hfyx88628276163916
43LVQQ91463629317530 lvqq91463629317530
98DNPG26088238420485 dnpg26088238420485
71RSAU19806243751008 rsau19806243751008
42PAGI47190186138019 pagi47190186138019
86POKG52194989794875 pokg52194989794875
27PQIB83893024699750 pqib83893024699750
39QQZB74743617432951 qqzb74743617432951
81SXDK33780329201645 sxdk33780329201645
03TLGF01937905266584 tlgf01937905266584
61OUPH20219307645575 ouph20219307645575
83JHCA76874597629852 jhca76874597629852
76NGKR93956829665462 ngkr93956829665462
20XSSC68065900145979 xssc68065900145979
78FLHD83638096586340 flhd83638096586340
92QYNI30868178628120 qyni30868178628120
64HZIT75623839973779 hzit75623839973779
43OKJA73394210866079 okja73394210866079
22DFLY26658904377884 dfly26658904377884
61WXEE24061053903587 wxee24061053903587
28BJUQ75178298300100 bjuq75178298300100
95RQOF19322952783338 rqof19322952783338
12YEDH68033582318934 yedh68033582318934
15APII67693122772451 apii67693122772451
20DCFE94827468327825 dcfe94827468327825
29MDQA50355741101773 mdqa50355741101773
89LVHK68438711708925 lvhk68438711708925
90SOIV63437887049400 soiv63437887049400
27BHSN90224333453343 bhsn90224333453343
64MPRO14712689531788 mpro14712689531788
64VFAD35256230423153 vfad35256230423153
90ASDJFEOQWP14356543 asdjfeoqwp14356543
660000000NOCHWASMEHR nochwasmehr
86000000000QUARKTEST quarktest
6200LETZTERTESTHEUTE letztertestheute
