package Bundle::MARCEL;

use strict;
use warnings;


our $VERSION = '0.05';


1;


__END__



=head1 NAME

Bundle::MARCEL - install (nearly) all modules by MARCEL

=head1 SYNOPSIS

    cpan Bundle::MARCEL

=head1 DESCRIPTION

This bundle contains all distributions by the CPAN author MARCEL. It is useful
if you want to set up a development environment for these modules so you can
easily make sure that all the dependencies are installed. You would probably
only want to do this if you are MARCEL.

=head1 CONTENTS



Acme::Tiroler

App::sync_cpantesters

App::vget

Aspect::Trace

Attribute::Overload

Attribute::TieClasses

Bundle::MARCEL

Bundle::MARCEL::Likes

Bundle::Perl6

Business::Address::POBox

Carp::Source

Class::Accessor::Bundle

Class::Accessor::Complex

Class::Accessor::Constructor

Class::Accessor::FactoryTyped

Class::Accessor::Installer

Class::Factory::Enhanced

Class::Null

Class::Scaffold

Class::Value

Class::Value::Bundle

Class::Value::Contact

Class::Value::Net

Class::Value::SemanticAdapter

Class::Value::URI

DBIx::Lookup::Field

Data::Comparable

Data::Container

Data::Conveyor

Data::Domain::Bundle

Data::Domain::Net

Data::Domain::SemanticAdapter

Data::Domain::URI

Data::Inherited

Data::Miscellany

Data::Semantic

Data::Semantic::Bundle

Data::Semantic::Net

Data::Semantic::URI

Data::Storage

Data::Timeline

Data::Timeline::Bundle

Data::Timeline::IScrobbler

Data::Timeline::SVK

Devel::SearchINC

Devel::TraceINC

Dist::Joseki

Error::Hierarchy

Exporter::Simple

Games::Go::Coordinate

Games::Go::Rank

Getopt::Attribute

GraphViz::ISA

Hash::Rename

Hook::Modular

Module::Changes

Module::Cloud

Module::Install::StandardTests

Module::Install::Template

Net::IP::Match

Number::Rangify

PerlIO::via::Pipe

Pod::Generated

Regexp::Common::AT::NICAT

Regexp::Common::AT::Profanity

Scalar::Properties

ShipIt::Bundle

ShipIt::Step::ApplyYAMLChangeLogVersion

ShipIt::Step::CheckYAMLChangeLog

ShipIt::Step::DistClean

ShipIt::Step::Jaiku

ShipIt::Step::Manifest

ShipIt::Step::Twitter

String::BlackWhiteList

String::FlexMatch

Sub::CharacterProperties

Template::Plugin::CPAN::Packages

Template::Plugin::Filter::Pipe

Term::Shell::Enhanced

Test::CompanionClasses

Test::Compile

Text::Pipe

Text::Pipe::Bundle

Text::Pipe::Encoding

Text::Pipe::HTML

Text::Pipe::Translate

Text::UpsideDown

Tie::Scalar::Timeout

Vim::Complete

YAML::Active

=head1 TAGS

If you talk about this module in blogs, on del.icio.us or anywhere else,
please use the C<bundlemarcel> tag.

=head1 VERSION 
                   
This document describes version 0.05 of L<Bundle::MARCEL>.

=head1 BUGS AND LIMITATIONS

No bugs have been reported.

Please report any bugs or feature requests to
C<<bug-bundle-marcel@rt.cpan.org>>, or through the web interface at
L<http://rt.cpan.org>.

=head1 INSTALLATION

See perlmodinstall for information and options on installing Perl modules.

=head1 AVAILABILITY

The latest version of this module is available from the Comprehensive Perl
Archive Network (CPAN). Visit <http://www.perl.com/CPAN/> to find a CPAN
site near you. Or see <http://www.perl.com/CPAN/authors/id/M/MA/MARCEL/>.

=head1 AUTHOR

Marcel GrE<uuml>nauer, C<< <marcel@cpan.org> >>

=head1 COPYRIGHT AND LICENSE

Copyright 2007 by Marcel GrE<uuml>nauer

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.


=cut

