#!perl
# Copyright: 2006 The Perl Foundation.  All Rights Reserved.
# $Id: perlenv.t 12465 2006-04-30 15:11:25Z bernhard $

use strict;
use warnings;
use lib qw( . lib ../lib ../../lib );

use Test::More;
use Parrot::Test;

=head1 NAME

t/pmc/perlenv.t - test the PerlEnv PMC


=head1 SYNOPSIS

    % prove t/pmc/perlenv.t

=head1 DESCRIPTION

Tests the PerlEnv PMC.

=cut

my $load_perl = <<'END_PASM';
    loadlib P20, 'perl_group'
    find_type I22, 'PerlEnv'
END_PASM


pir_output_is(<<"CODE", <<'OUT', 'new');
.sub 'test' :main
$load_perl
    new P0, I22
    print "ok 1\\n"
.end
CODE
ok 1
OUT


# remember to change the number of tests :-)
BEGIN { plan tests => 1; }
