use strict;
use warnings;
use Test::More tests => 1;

use MediaWiki::Bot;

my $username = $ENV{'PWPUsername'};
my $password = $ENV{'PWPPassword'};
my $login_data;
if (defined($username) and defined($password)) {
    $login_data = { username => $username, password => $password };
}

my $bot = MediaWiki::Bot->new({
    agent       => 'MediaWiki::Bot tests (35_secure.t)',
    host        => 'secure.wikimedia.org',
    path        => 'wikipedia/en/w',
    protocol    => 'https',
    login_data  => $login_data,
});

my $rand = rand();
my $status = $bot->edit({
    page    => 'User:ST47/test',
    text    => $rand,
    summary => 'MediaWiki::Bot tests (35_secure.t)',
});
SKIP: {
    if (defined($bot->{error}->{code}) and $bot->{error}->{code} == 3) {
        skip 'You are blocked, cannot use editing tests', 1;
    }

    my $is = $bot->get_text('User:ST47/test');
    is($is, $rand, 'Edited via secure server successfully');
}
