package # hide from PAUSE
App::YTDL::History;

use warnings;
use strict;
use 5.010000;

use Exporter qw( import );
our @EXPORT_OK = qw( read_history_files uploader_history_menu add_uploader_to_history write_uploader_history_to_file );

use List::MoreUtils qw( none );
use Term::Choose    qw( choose );

use App::YTDL::Helper qw( read_json write_json );



sub __read_history_files {  #### use this after some time ####
    my ( $opt ) = @_;
    $opt->{sticky}  = {};
    $opt->{history} = {};
    if ( $opt->{max_size_history} ) {
        $opt->{sticky}  = read_json( $opt, $opt->{sticky_file} )  if -e $opt->{sticky_file};
        $opt->{history} = read_json( $opt, $opt->{history_file} ) if -e $opt->{history_file};
    }
}
sub read_history_files {  #### keep this for some time ####
    my ( $opt ) = @_;
    require File::Spec::Functions;
    my $old_history_file = File::Spec::Functions::catfile( $opt->{config_dir}, 'channel_history.json' );
    my $old_sticky_file  = File::Spec::Functions::catfile( $opt->{config_dir}, 'channel_sticky.json' );
    $opt->{sticky}  = {};
    $opt->{history} = {};
    if ( $opt->{max_size_history} ) {
        if ( -e $opt->{sticky_file} ) {
            $opt->{sticky} = read_json( $opt, $opt->{sticky_file} );
        }
        elsif ( -e $old_sticky_file ) {
            $opt->{sticky} = read_json( $opt, $old_sticky_file );
            for my $url ( keys %{$opt->{sticky}} ) {
                $opt->{sticky}{$url}{uploader}    =         delete $opt->{sticky}{$url}{channel}       if $opt->{sticky}{$url}{channel};
                $opt->{sticky}{$url}{uploader_id} =         delete $opt->{sticky}{$url}{channel_id}    if $opt->{sticky}{$url}{channel_id};
                $opt->{sticky}{$url}{extractor}   = lcfirst delete $opt->{sticky}{$url}{extractor_key} if $opt->{sticky}{$url}{extractor_key};
                delete $opt->{sticky}{$url}{channel_url};
                if ( $opt->{sticky}{$url}{extractor} eq 'youtube' ) {
                    if ( $url =~ /^c#([^#]+)\z/ ) {
                        my $new_url = "https://www.youtube.com/user/$1";
                        $opt->{sticky}{$new_url} = delete $opt->{sticky}{$url};
                    }
                }
                if ( $url =~ /^http:(.+)\z/ ) {
                    my $new_url = "https:$1";
                    $opt->{sticky}{$new_url} = delete $opt->{sticky}{$url};
                }
            }
        write_json( $opt, $opt->{sticky_file},  $opt->{sticky} );
        unlink $old_sticky_file or warn $!;
        }
        if ( -e $opt->{history_file} ) {
            $opt->{history} = read_json( $opt, $opt->{history_file} );
        }
        elsif ( -e $old_history_file ) {
            $opt->{history} = read_json( $opt, $old_history_file );
            for my $url ( keys %{$opt->{history}} ) {
                $opt->{history}{$url}{uploader}    =         delete $opt->{history}{$url}{channel}       if $opt->{history}{$url}{channel};
                $opt->{history}{$url}{uploader_id} =         delete $opt->{history}{$url}{channel_id}    if $opt->{history}{$url}{channel_id};
                $opt->{history}{$url}{extractor}   = lcfirst delete $opt->{history}{$url}{extractor_key} if $opt->{history}{$url}{extractor_key};
                delete $opt->{history}{$url}{channel_url};
                if ( $opt->{history}{$url}{extractor} eq 'youtube' ) {
                    if ( $url =~ /^c#([^#]+)\z/ ) {
                        my $new_url = "https://www.youtube.com/user/$1";
                        $opt->{history}{$new_url} = delete $opt->{history}{$url};
                    }
                }
                if ( $url =~ /^http:(.+)\z/ ) {
                    my $new_url = "https:$1";
                    $opt->{history}{$new_url} = delete $opt->{history}{$url};
                }
            }
            write_json( $opt, $opt->{history_file}, $opt->{history} );
            unlink $old_history_file or warn $!;
        }
    }
}


sub uploader_history_menu {
    my ( $opt ) = @_;

    MENU : while ( 1 ) {
        my @list_size = ( '  ALL', '  30' );
        my $list_size_regexp = join '|', map { quotemeta } @list_size;
        my ( $uploader, $sticky ) = ( '- Uploader', '  Sticky' );
        # Choose
        my $choice = choose(
            [ undef, $uploader, $sticky, $list_size[$opt->{small_list_size}] ],
            { prompt => 'Choose:', layout => 3, undef => '  QUIT' }
        );
        if ( ! defined $choice ) {
            exit;
        }
        elsif ( $choice eq $uploader ) {
            my ( $sticky,  $sticky_url )  = _sticky_name_and_url( $opt->{sticky} );
            my ( $history, $history_url, $removed_next ) = _history_name_and_url( $opt, $opt->{history} );
            my $prompt = 'Uploader:' . "\n";
            my @ids;

            CHANNEL: while ( 1 ) {
                my $confirm = '  CONFIRM';
                my @pre = ( undef, $confirm );
                my $choices = _available_uploader( \@pre, $sticky, $history, $removed_next );
                # Choose
                my @indexes = choose(
                    $choices,
                    { prompt => $prompt . "\nYour choice:", layout => 3, index => 1,
                        undef => '  BACK', no_spacebar => [ 0 .. $#pre, $#$choices ] }
                );
                if ( ! $indexes[0] ) {
                    if ( @ids ) {
                        $prompt = 'Channels:' . "\n";
                        @ids = ();
                        next CHANNEL;
                    }
                    else {
                        next MENU;
                    }
                }
                if ( $choices->[$indexes[0]] eq $confirm ) {
                    shift @indexes;
                    for my $i ( @indexes ) {
                        $i -= @pre;
                        if ( $i <= $#$sticky ) {
                            push @ids, $sticky_url->[$i];
                            $prompt .= sprintf "= %s (%s)\n", $sticky->[$i], $opt->{sticky}{$sticky_url->[$i]}{uploader_id};
                        }
                        else {
                            $i -= @$sticky;
                            push @ids, $history_url->[$i];
                            $prompt .= sprintf "= %s (%s)\n", $history->[$i], $opt->{history}{$history_url->[$i]}{uploader_id};
                        }
                    }
                    return @ids;
                }
                else {
                    for my $i ( @indexes ) {
                        $i -= @pre;
                        if ( $i <= $#$sticky ) {
                            push @ids, $sticky_url->[$i];
                            $prompt .= sprintf "= %s (%s)\n", $sticky->[$i], $opt->{sticky}{$sticky_url->[$i]}{uploader_id};
                        }
                        else {
                            $i -= @$sticky;
                            push @ids, $history_url->[$i];
                            $prompt .= sprintf "= %s (%s)\n", $history->[$i], $opt->{history}{$history_url->[$i]}{uploader_id};
                        }
                    }
                }
            }
        }
        elsif ( $choice eq $sticky ) {
            my ( $sticky,  $sticky_url )  = _sticky_name_and_url( $opt->{sticky} );
            my ( $history, $history_url ) = _history_name_and_url( $opt, $opt->{history} );
            my $changed = 0;

            STICKY: while ( 1 ) {
                my @pre = ( undef );
                my $idx = choose(
                    [ @pre, map( "+ $_", @$sticky ), map( "- $_", @$history ) ],
                    { prompt => 'Choose:', layout => 3, index => 1, undef => '  <<' }
                );
                if ( ! $idx ) {
                    if ( $changed ) {
                        write_json( $opt, $opt->{sticky_file},  $opt->{sticky} );
                        write_json( $opt, $opt->{history_file}, $opt->{history} );
                    }
                    next MENU;
                }
                else {
                    $changed++;
                    $idx-= @pre;
                    if ( $idx > $#$sticky ) {
                        $idx -= @$sticky;
                        my $uploader_url = $history_url->[$idx];
                        $opt->{sticky}{$uploader_url} = delete $opt->{history}{$uploader_url};
                    }
                    else {
                        my $uploader_url = $sticky_url->[$idx];
                        $opt->{history}{$uploader_url} = delete $opt->{sticky}{$uploader_url};
                        $opt->{history}{$uploader_url}{timestamp} = time();
                    }
                    ( $sticky,  $sticky_url )  = _sticky_name_and_url( $opt->{sticky} );
                    ( $history, $history_url ) = _history_name_and_url( $opt, $opt->{history} );
                }
            }
        }
        if ( $choice =~ /^$list_size_regexp\z/ ) {
            $opt->{small_list_size}++;
            $opt->{small_list_size} = 0 if $opt->{small_list_size} > $#list_size;
            next MENU;
        }
    }
}


sub _available_uploader {
    my ( $pre, $sticky, $history, $removed_next ) = @_;
    my $choices = [ @$pre, map( "* $_", @$sticky ) ];
    for my $i ( 0 .. $#$history ) {
        push @$choices, "  $history->[$i]" if ! $removed_next->[$i];
        push @$choices, "| $history->[$i]" if   $removed_next->[$i];
    }
    return $choices;
}


sub _history_name_and_url {
    my ( $opt, $ref ) = @_;
    my $tmp_name = [];
    my $tmp_url  = [];
    my $tmp_removed_next = [];
    my $count = 0;
    for my $key ( sort { $ref->{$b}{timestamp} <=> $ref->{$a}{timestamp} } keys %$ref ) {
        $count++;
        push @$tmp_name, $ref->{$key}{uploader};
        push @$tmp_url, $key;
        push @$tmp_removed_next, $count >= $opt->{max_size_history} ? 1 : 0;
    }
    my $history_name = [];
    my $history_url  = [];
    my $removed_next = [];
    if ( ! $opt->{sort_history_by_timestamp} ) {
        for my $i ( sort { lc $tmp_name->[$a] cmp lc $tmp_name->[$b] } 0 .. $#$tmp_name ) {
            push @$history_name, $tmp_name->[$i];
            push @$history_url,  $tmp_url->[$i];
            push @$removed_next, $tmp_removed_next->[$i];
        }
    }
    else {
        $history_name = $tmp_name;
        $history_url  = $tmp_url;
        $removed_next = $tmp_removed_next;
    }
    return $history_name, $history_url, $removed_next;
}


sub _sticky_name_and_url {
    my ( $ref ) = @_;
    my $sticky_name = [];
    my $sticky_url  = [];
    for my $key ( sort { lc $ref->{$a}{uploader} cmp lc $ref->{$b}{uploader} } keys %$ref ) {
        push @$sticky_name, $ref->{$key}{uploader};
        push @$sticky_url, $key;
    }
    return $sticky_name, $sticky_url;
}


sub add_uploader_to_history {
    my ( $opt, $info, $ex, $video_id ) = @_;
    my $uploader    = $info->{$ex}{$video_id}{uploader};
    my $uploader_id = $info->{$ex}{$video_id}{uploader_id};
    return if ! length $uploader_id;
    my $uploader_url;
    $uploader_url = 'https://www.youtube.com/user/' if $ex eq 'youtube';
    $uploader_url = 'https://vimeo.com/'            if $ex eq 'vimeo';
    if ( defined $uploader_url ) {
        $uploader_url .= $uploader_id;
        if ( none{ $uploader_url eq $_ } keys %{$opt->{sticky}} ) {
            $opt->{history}{$uploader_url} = {
                uploader     => $uploader,
                uploader_id  => $uploader_id,
                extractor    => $ex,
                timestamp    => time(),
            };
        }
    }
}


sub write_uploader_history_to_file {
    my ( $opt ) = @_;
    my $c_hist = $opt->{history};
    my @keys = sort { $c_hist->{$b}{timestamp} <=> $c_hist->{$a}{timestamp} } keys %$c_hist;
    while ( @keys > $opt->{max_size_history} ) {
        my $key = pop @keys;
        delete $c_hist->{$key};
        @keys = sort { $c_hist->{$b}{timestamp} <=> $c_hist->{$a}{timestamp} } keys %$c_hist;
    }
    write_json( $opt, $opt->{history_file}, $c_hist );
}


1;


__END__
