package My::Builder::Unix;

use strict;
use warnings;
use base 'My::Builder';

use File::Spec::Functions qw(catdir catfile rel2abs);
use File::Spec qw(devnull);
use Config;

sub build_binaries {
  my ($self, $build_out, $srcdir) = @_;
  $srcdir ||= 'src';
  my $prefixdir = rel2abs($build_out);
  $self->config_data('build_prefix', $prefixdir); # save it for future ConfigData

  chdir $srcdir;

  # do './configure ...'
  my $run_configure = 'y';
  $run_configure = $self->prompt("Run ./configure again?", "n") if (-f "config.status");
  if (lc($run_configure) eq 'y') {
    my @cmd = ( './configure', '--enable-shared=no', '--disable-dependency-tracking', "--prefix=$prefixdir", 'CFLAGS=-fPIC');
    print STDERR "Configuring ...\n";
    print STDERR "(cmd: ".join(' ',@cmd).")\n";
    $self->do_system(@cmd) or die "###ERROR### [$?] during ./configure ... ";
  }

  # do 'make install'
  my @cmd = ($self->get_make, 'install');
  print STDERR "Running make install ...\n";
  print STDERR "(cmd: ".join(' ',@cmd).")\n";
  $self->do_system(@cmd) or die "###ERROR### [$?] during make ... ";

  chdir $self->base_dir();
  return 1;
}

sub get_make {
  my ($self) = @_;
  my $devnull = File::Spec->devnull();
  my @try = ($Config{gmake}, 'gmake', 'make', $Config{make});
  my %tested;
  print STDERR "Gonna detect GNU make:\n";

  if ($^O eq 'cygwin') {
    print STDERR "- on cygwin always 'make'\n";
    return 'make'
  }

  foreach my $name ( @try ) {
    next unless $name;
    next if $tested{$name};
    $tested{$name} = 1;
    print STDERR "- testing: '$name'\n";
    my $ver = `$name --version 2> $devnull`;
    if ($ver =~ /GNU Make/i) {
      print STDERR "- found: '$name'\n";
      return $name
    }
  }
  print STDERR "- fallback to: 'make'\n";
  return 'make';
}

# we are not afraid of dirnames with spaces on UNIX
# IMPORTANT: EU::MM is not properly handling -L'/path/to/lib/dir'

#sub quote_literal {
#    my ($self, $txt) = @_;
#    $txt =~ s|'|'\\''|g;
#    return "'$txt'";
#}

1;
