
=head1 NAME

Locale::SubCountry::Codes - data for Locale::SubCountry in JSON format

=head1 DESCRIPTION

Internal data for the Locale::SubCountry module

NOTE, THIS FILE IS CREATED WITH UTF-8 ENCODING. THIS SHOULD NOT BE CHANGED.

=head1 SOURCE

All codes have been downloaded from the latest version of the Alioth project
l<https://pkg-isocodes.alioth.debian.org/>


=cut
#------------------------------------------------------------------------------
use utf8;

our $VERSION = '2.02';
package Locale::SubCountry::Codes;

$Locale::SubCountry::Codes::JSON =
q{
{
"3166-1": [
    {
      "alpha_2": "AW",
      "alpha_3": "ABW",
      "name": "Aruba",
      "numeric": "533"
    },
    {
      "alpha_2": "AF",
      "alpha_3": "AFG",
      "name": "Afghanistan",
      "numeric": "004",
      "official_name": "Islamic Republic of Afghanistan"
    },
    {
      "alpha_2": "AO",
      "alpha_3": "AGO",
      "name": "Angola",
      "numeric": "024",
      "official_name": "Republic of Angola"
    },
    {
      "alpha_2": "AI",
      "alpha_3": "AIA",
      "name": "Anguilla",
      "numeric": "660"
    },
    {
      "alpha_2": "AX",
      "alpha_3": "ALA",
      "name": "Åland Islands",
      "numeric": "248"
    },
    {
      "alpha_2": "AL",
      "alpha_3": "ALB",
      "name": "Albania",
      "numeric": "008",
      "official_name": "Republic of Albania"
    },
    {
      "alpha_2": "AD",
      "alpha_3": "AND",
      "name": "Andorra",
      "numeric": "020",
      "official_name": "Principality of Andorra"
    },
    {
      "alpha_2": "AE",
      "alpha_3": "ARE",
      "name": "United Arab Emirates",
      "numeric": "784"
    },
    {
      "alpha_2": "AR",
      "alpha_3": "ARG",
      "name": "Argentina",
      "numeric": "032",
      "official_name": "Argentine Republic"
    },
    {
      "alpha_2": "AM",
      "alpha_3": "ARM",
      "name": "Armenia",
      "numeric": "051",
      "official_name": "Republic of Armenia"
    },
    {
      "alpha_2": "AS",
      "alpha_3": "ASM",
      "name": "American Samoa",
      "numeric": "016"
    },
    {
      "alpha_2": "AQ",
      "alpha_3": "ATA",
      "name": "Antarctica",
      "numeric": "010"
    },
    {
      "alpha_2": "TF",
      "alpha_3": "ATF",
      "name": "French Southern Territories",
      "numeric": "260"
    },
    {
      "alpha_2": "AG",
      "alpha_3": "ATG",
      "name": "Antigua and Barbuda",
      "numeric": "028"
    },
    {
      "alpha_2": "AU",
      "alpha_3": "AUS",
      "name": "Australia",
      "numeric": "036"
    },
    {
      "alpha_2": "AT",
      "alpha_3": "AUT",
      "name": "Austria",
      "numeric": "040",
      "official_name": "Republic of Austria"
    },
    {
      "alpha_2": "AZ",
      "alpha_3": "AZE",
      "name": "Azerbaijan",
      "numeric": "031",
      "official_name": "Republic of Azerbaijan"
    },
    {
      "alpha_2": "BI",
      "alpha_3": "BDI",
      "name": "Burundi",
      "numeric": "108",
      "official_name": "Republic of Burundi"
    },
    {
      "alpha_2": "BE",
      "alpha_3": "BEL",
      "name": "Belgium",
      "numeric": "056",
      "official_name": "Kingdom of Belgium"
    },
    {
      "alpha_2": "BJ",
      "alpha_3": "BEN",
      "name": "Benin",
      "numeric": "204",
      "official_name": "Republic of Benin"
    },
    {
      "alpha_2": "BQ",
      "alpha_3": "BES",
      "name": "Bonaire, Sint Eustatius and Saba",
      "numeric": "535",
      "official_name": "Bonaire, Sint Eustatius and Saba"
    },
    {
      "alpha_2": "BF",
      "alpha_3": "BFA",
      "name": "Burkina Faso",
      "numeric": "854"
    },
    {
      "alpha_2": "BD",
      "alpha_3": "BGD",
      "name": "Bangladesh",
      "numeric": "050",
      "official_name": "People's Republic of Bangladesh"
    },
    {
      "alpha_2": "BG",
      "alpha_3": "BGR",
      "name": "Bulgaria",
      "numeric": "100",
      "official_name": "Republic of Bulgaria"
    },
    {
      "alpha_2": "BH",
      "alpha_3": "BHR",
      "name": "Bahrain",
      "numeric": "048",
      "official_name": "Kingdom of Bahrain"
    },
    {
      "alpha_2": "BS",
      "alpha_3": "BHS",
      "name": "Bahamas",
      "numeric": "044",
      "official_name": "Commonwealth of the Bahamas"
    },
    {
      "alpha_2": "BA",
      "alpha_3": "BIH",
      "name": "Bosnia and Herzegovina",
      "numeric": "070",
      "official_name": "Republic of Bosnia and Herzegovina"
    },
    {
      "alpha_2": "BL",
      "alpha_3": "BLM",
      "name": "Saint Barthélemy",
      "numeric": "652"
    },
    {
      "alpha_2": "BY",
      "alpha_3": "BLR",
      "name": "Belarus",
      "numeric": "112",
      "official_name": "Republic of Belarus"
    },
    {
      "alpha_2": "BZ",
      "alpha_3": "BLZ",
      "name": "Belize",
      "numeric": "084"
    },
    {
      "alpha_2": "BM",
      "alpha_3": "BMU",
      "name": "Bermuda",
      "numeric": "060"
    },
    {
      "alpha_2": "BO",
      "alpha_3": "BOL",
      "common_name": "Bolivia",
      "name": "Bolivia, Plurinational State of",
      "numeric": "068",
      "official_name": "Plurinational State of Bolivia"
    },
    {
      "alpha_2": "BR",
      "alpha_3": "BRA",
      "name": "Brazil",
      "numeric": "076",
      "official_name": "Federative Republic of Brazil"
    },
    {
      "alpha_2": "BB",
      "alpha_3": "BRB",
      "name": "Barbados",
      "numeric": "052"
    },
    {
      "alpha_2": "BN",
      "alpha_3": "BRN",
      "name": "Brunei Darussalam",
      "numeric": "096"
    },
    {
      "alpha_2": "BT",
      "alpha_3": "BTN",
      "name": "Bhutan",
      "numeric": "064",
      "official_name": "Kingdom of Bhutan"
    },
    {
      "alpha_2": "BV",
      "alpha_3": "BVT",
      "name": "Bouvet Island",
      "numeric": "074"
    },
    {
      "alpha_2": "BW",
      "alpha_3": "BWA",
      "name": "Botswana",
      "numeric": "072",
      "official_name": "Republic of Botswana"
    },
    {
      "alpha_2": "CF",
      "alpha_3": "CAF",
      "name": "Central African Republic",
      "numeric": "140"
    },
    {
      "alpha_2": "CA",
      "alpha_3": "CAN",
      "name": "Canada",
      "numeric": "124"
    },
    {
      "alpha_2": "CC",
      "alpha_3": "CCK",
      "name": "Cocos (Keeling) Islands",
      "numeric": "166"
    },
    {
      "alpha_2": "CH",
      "alpha_3": "CHE",
      "name": "Switzerland",
      "numeric": "756",
      "official_name": "Swiss Confederation"
    },
    {
      "alpha_2": "CL",
      "alpha_3": "CHL",
      "name": "Chile",
      "numeric": "152",
      "official_name": "Republic of Chile"
    },
    {
      "alpha_2": "CN",
      "alpha_3": "CHN",
      "name": "China",
      "numeric": "156",
      "official_name": "People's Republic of China"
    },
    {
      "alpha_2": "CI",
      "alpha_3": "CIV",
      "name": "Côte d'Ivoire",
      "numeric": "384",
      "official_name": "Republic of Côte d'Ivoire"
    },
    {
      "alpha_2": "CM",
      "alpha_3": "CMR",
      "name": "Cameroon",
      "numeric": "120",
      "official_name": "Republic of Cameroon"
    },
    {
      "alpha_2": "CD",
      "alpha_3": "COD",
      "name": "Congo, The Democratic Republic of the",
      "numeric": "180"
    },
    {
      "alpha_2": "CG",
      "alpha_3": "COG",
      "name": "Congo",
      "numeric": "178",
      "official_name": "Republic of the Congo"
    },
    {
      "alpha_2": "CK",
      "alpha_3": "COK",
      "name": "Cook Islands",
      "numeric": "184"
    },
    {
      "alpha_2": "CO",
      "alpha_3": "COL",
      "name": "Colombia",
      "numeric": "170",
      "official_name": "Republic of Colombia"
    },
    {
      "alpha_2": "KM",
      "alpha_3": "COM",
      "name": "Comoros",
      "numeric": "174",
      "official_name": "Union of the Comoros"
    },
    {
      "alpha_2": "CV",
      "alpha_3": "CPV",
      "name": "Cabo Verde",
      "numeric": "132",
      "official_name": "Republic of Cabo Verde"
    },
    {
      "alpha_2": "CR",
      "alpha_3": "CRI",
      "name": "Costa Rica",
      "numeric": "188",
      "official_name": "Republic of Costa Rica"
    },
    {
      "alpha_2": "CU",
      "alpha_3": "CUB",
      "name": "Cuba",
      "numeric": "192",
      "official_name": "Republic of Cuba"
    },
    {
      "alpha_2": "CW",
      "alpha_3": "CUW",
      "name": "Curaçao",
      "numeric": "531",
      "official_name": "Curaçao"
    },
    {
      "alpha_2": "CX",
      "alpha_3": "CXR",
      "name": "Christmas Island",
      "numeric": "162"
    },
    {
      "alpha_2": "KY",
      "alpha_3": "CYM",
      "name": "Cayman Islands",
      "numeric": "136"
    },
    {
      "alpha_2": "CY",
      "alpha_3": "CYP",
      "name": "Cyprus",
      "numeric": "196",
      "official_name": "Republic of Cyprus"
    },
    {
      "alpha_2": "CZ",
      "alpha_3": "CZE",
      "name": "Czech Republic",
      "numeric": "203"
    },
    {
      "alpha_2": "DE",
      "alpha_3": "DEU",
      "name": "Germany",
      "numeric": "276",
      "official_name": "Federal Republic of Germany"
    },
    {
      "alpha_2": "DJ",
      "alpha_3": "DJI",
      "name": "Djibouti",
      "numeric": "262",
      "official_name": "Republic of Djibouti"
    },
    {
      "alpha_2": "DM",
      "alpha_3": "DMA",
      "name": "Dominica",
      "numeric": "212",
      "official_name": "Commonwealth of Dominica"
    },
    {
      "alpha_2": "DK",
      "alpha_3": "DNK",
      "name": "Denmark",
      "numeric": "208",
      "official_name": "Kingdom of Denmark"
    },
    {
      "alpha_2": "DO",
      "alpha_3": "DOM",
      "name": "Dominican Republic",
      "numeric": "214"
    },
    {
      "alpha_2": "DZ",
      "alpha_3": "DZA",
      "name": "Algeria",
      "numeric": "012",
      "official_name": "People's Democratic Republic of Algeria"
    },
    {
      "alpha_2": "EC",
      "alpha_3": "ECU",
      "name": "Ecuador",
      "numeric": "218",
      "official_name": "Republic of Ecuador"
    },
    {
      "alpha_2": "EG",
      "alpha_3": "EGY",
      "name": "Egypt",
      "numeric": "818",
      "official_name": "Arab Republic of Egypt"
    },
    {
      "alpha_2": "ER",
      "alpha_3": "ERI",
      "name": "Eritrea",
      "numeric": "232",
      "official_name": "the State of Eritrea"
    },
    {
      "alpha_2": "EH",
      "alpha_3": "ESH",
      "name": "Western Sahara",
      "numeric": "732"
    },
    {
      "alpha_2": "ES",
      "alpha_3": "ESP",
      "name": "Spain",
      "numeric": "724",
      "official_name": "Kingdom of Spain"
    },
    {
      "alpha_2": "EE",
      "alpha_3": "EST",
      "name": "Estonia",
      "numeric": "233",
      "official_name": "Republic of Estonia"
    },
    {
      "alpha_2": "ET",
      "alpha_3": "ETH",
      "name": "Ethiopia",
      "numeric": "231",
      "official_name": "Federal Democratic Republic of Ethiopia"
    },
    {
      "alpha_2": "FI",
      "alpha_3": "FIN",
      "name": "Finland",
      "numeric": "246",
      "official_name": "Republic of Finland"
    },
    {
      "alpha_2": "FJ",
      "alpha_3": "FJI",
      "name": "Fiji",
      "numeric": "242",
      "official_name": "Republic of Fiji"
    },
    {
      "alpha_2": "FK",
      "alpha_3": "FLK",
      "name": "Falkland Islands (Malvinas)",
      "numeric": "238"
    },
    {
      "alpha_2": "FR",
      "alpha_3": "FRA",
      "name": "France",
      "numeric": "250",
      "official_name": "French Republic"
    },
    {
      "alpha_2": "FO",
      "alpha_3": "FRO",
      "name": "Faroe Islands",
      "numeric": "234"
    },
    {
      "alpha_2": "FM",
      "alpha_3": "FSM",
      "name": "Micronesia, Federated States of",
      "numeric": "583",
      "official_name": "Federated States of Micronesia"
    },
    {
      "alpha_2": "GA",
      "alpha_3": "GAB",
      "name": "Gabon",
      "numeric": "266",
      "official_name": "Gabonese Republic"
    },
    {
      "alpha_2": "GB",
      "alpha_3": "GBR",
      "name": "United Kingdom",
      "numeric": "826",
      "official_name": "United Kingdom of Great Britain and Northern Ireland"
    },
    {
      "alpha_2": "GE",
      "alpha_3": "GEO",
      "name": "Georgia",
      "numeric": "268"
    },
    {
      "alpha_2": "GG",
      "alpha_3": "GGY",
      "name": "Guernsey",
      "numeric": "831"
    },
    {
      "alpha_2": "GH",
      "alpha_3": "GHA",
      "name": "Ghana",
      "numeric": "288",
      "official_name": "Republic of Ghana"
    },
    {
      "alpha_2": "GI",
      "alpha_3": "GIB",
      "name": "Gibraltar",
      "numeric": "292"
    },
    {
      "alpha_2": "GN",
      "alpha_3": "GIN",
      "name": "Guinea",
      "numeric": "324",
      "official_name": "Republic of Guinea"
    },
    {
      "alpha_2": "GP",
      "alpha_3": "GLP",
      "name": "Guadeloupe",
      "numeric": "312"
    },
    {
      "alpha_2": "GM",
      "alpha_3": "GMB",
      "name": "Gambia",
      "numeric": "270",
      "official_name": "Islamic Republic of the Gambia"
    },
    {
      "alpha_2": "GW",
      "alpha_3": "GNB",
      "name": "Guinea-Bissau",
      "numeric": "624",
      "official_name": "Republic of Guinea-Bissau"
    },
    {
      "alpha_2": "GQ",
      "alpha_3": "GNQ",
      "name": "Equatorial Guinea",
      "numeric": "226",
      "official_name": "Republic of Equatorial Guinea"
    },
    {
      "alpha_2": "GR",
      "alpha_3": "GRC",
      "name": "Greece",
      "numeric": "300",
      "official_name": "Hellenic Republic"
    },
    {
      "alpha_2": "GD",
      "alpha_3": "GRD",
      "name": "Grenada",
      "numeric": "308"
    },
    {
      "alpha_2": "GL",
      "alpha_3": "GRL",
      "name": "Greenland",
      "numeric": "304"
    },
    {
      "alpha_2": "GT",
      "alpha_3": "GTM",
      "name": "Guatemala",
      "numeric": "320",
      "official_name": "Republic of Guatemala"
    },
    {
      "alpha_2": "GF",
      "alpha_3": "GUF",
      "name": "French Guiana",
      "numeric": "254"
    },
    {
      "alpha_2": "GU",
      "alpha_3": "GUM",
      "name": "Guam",
      "numeric": "316"
    },
    {
      "alpha_2": "GY",
      "alpha_3": "GUY",
      "name": "Guyana",
      "numeric": "328",
      "official_name": "Republic of Guyana"
    },
    {
      "alpha_2": "HK",
      "alpha_3": "HKG",
      "name": "Hong Kong",
      "numeric": "344",
      "official_name": "Hong Kong Special Administrative Region of China"
    },
    {
      "alpha_2": "HM",
      "alpha_3": "HMD",
      "name": "Heard Island and McDonald Islands",
      "numeric": "334"
    },
    {
      "alpha_2": "HN",
      "alpha_3": "HND",
      "name": "Honduras",
      "numeric": "340",
      "official_name": "Republic of Honduras"
    },
    {
      "alpha_2": "HR",
      "alpha_3": "HRV",
      "name": "Croatia",
      "numeric": "191",
      "official_name": "Republic of Croatia"
    },
    {
      "alpha_2": "HT",
      "alpha_3": "HTI",
      "name": "Haiti",
      "numeric": "332",
      "official_name": "Republic of Haiti"
    },
    {
      "alpha_2": "HU",
      "alpha_3": "HUN",
      "name": "Hungary",
      "numeric": "348",
      "official_name": "Hungary"
    },
    {
      "alpha_2": "ID",
      "alpha_3": "IDN",
      "name": "Indonesia",
      "numeric": "360",
      "official_name": "Republic of Indonesia"
    },
    {
      "alpha_2": "IM",
      "alpha_3": "IMN",
      "name": "Isle of Man",
      "numeric": "833"
    },
    {
      "alpha_2": "IN",
      "alpha_3": "IND",
      "name": "India",
      "numeric": "356",
      "official_name": "Republic of India"
    },
    {
      "alpha_2": "IO",
      "alpha_3": "IOT",
      "name": "British Indian Ocean Territory",
      "numeric": "086"
    },
    {
      "alpha_2": "IE",
      "alpha_3": "IRL",
      "name": "Ireland",
      "numeric": "372"
    },
    {
      "alpha_2": "IR",
      "alpha_3": "IRN",
      "name": "Iran, Islamic Republic of",
      "numeric": "364",
      "official_name": "Islamic Republic of Iran"
    },
    {
      "alpha_2": "IQ",
      "alpha_3": "IRQ",
      "name": "Iraq",
      "numeric": "368",
      "official_name": "Republic of Iraq"
    },
    {
      "alpha_2": "IS",
      "alpha_3": "ISL",
      "name": "Iceland",
      "numeric": "352",
      "official_name": "Republic of Iceland"
    },
    {
      "alpha_2": "IL",
      "alpha_3": "ISR",
      "name": "Israel",
      "numeric": "376",
      "official_name": "State of Israel"
    },
    {
      "alpha_2": "IT",
      "alpha_3": "ITA",
      "name": "Italy",
      "numeric": "380",
      "official_name": "Italian Republic"
    },
    {
      "alpha_2": "JM",
      "alpha_3": "JAM",
      "name": "Jamaica",
      "numeric": "388"
    },
    {
      "alpha_2": "JE",
      "alpha_3": "JEY",
      "name": "Jersey",
      "numeric": "832"
    },
    {
      "alpha_2": "JO",
      "alpha_3": "JOR",
      "name": "Jordan",
      "numeric": "400",
      "official_name": "Hashemite Kingdom of Jordan"
    },
    {
      "alpha_2": "JP",
      "alpha_3": "JPN",
      "name": "Japan",
      "numeric": "392"
    },
    {
      "alpha_2": "KZ",
      "alpha_3": "KAZ",
      "name": "Kazakhstan",
      "numeric": "398",
      "official_name": "Republic of Kazakhstan"
    },
    {
      "alpha_2": "KE",
      "alpha_3": "KEN",
      "name": "Kenya",
      "numeric": "404",
      "official_name": "Republic of Kenya"
    },
    {
      "alpha_2": "KG",
      "alpha_3": "KGZ",
      "name": "Kyrgyzstan",
      "numeric": "417",
      "official_name": "Kyrgyz Republic"
    },
    {
      "alpha_2": "KH",
      "alpha_3": "KHM",
      "name": "Cambodia",
      "numeric": "116",
      "official_name": "Kingdom of Cambodia"
    },
    {
      "alpha_2": "KI",
      "alpha_3": "KIR",
      "name": "Kiribati",
      "numeric": "296",
      "official_name": "Republic of Kiribati"
    },
    {
      "alpha_2": "KN",
      "alpha_3": "KNA",
      "name": "Saint Kitts and Nevis",
      "numeric": "659"
    },
    {
      "alpha_2": "KR",
      "alpha_3": "KOR",
      "name": "Korea, Republic of",
      "numeric": "410"
    },
    {
      "alpha_2": "KW",
      "alpha_3": "KWT",
      "name": "Kuwait",
      "numeric": "414",
      "official_name": "State of Kuwait"
    },
    {
      "alpha_2": "LA",
      "alpha_3": "LAO",
      "name": "Lao People's Democratic Republic",
      "numeric": "418"
    },
    {
      "alpha_2": "LB",
      "alpha_3": "LBN",
      "name": "Lebanon",
      "numeric": "422",
      "official_name": "Lebanese Republic"
    },
    {
      "alpha_2": "LR",
      "alpha_3": "LBR",
      "name": "Liberia",
      "numeric": "430",
      "official_name": "Republic of Liberia"
    },
    {
      "alpha_2": "LY",
      "alpha_3": "LBY",
      "name": "Libya",
      "numeric": "434",
      "official_name": "Libya"
    },
    {
      "alpha_2": "LC",
      "alpha_3": "LCA",
      "name": "Saint Lucia",
      "numeric": "662"
    },
    {
      "alpha_2": "LI",
      "alpha_3": "LIE",
      "name": "Liechtenstein",
      "numeric": "438",
      "official_name": "Principality of Liechtenstein"
    },
    {
      "alpha_2": "LK",
      "alpha_3": "LKA",
      "name": "Sri Lanka",
      "numeric": "144",
      "official_name": "Democratic Socialist Republic of Sri Lanka"
    },
    {
      "alpha_2": "LS",
      "alpha_3": "LSO",
      "name": "Lesotho",
      "numeric": "426",
      "official_name": "Kingdom of Lesotho"
    },
    {
      "alpha_2": "LT",
      "alpha_3": "LTU",
      "name": "Lithuania",
      "numeric": "440",
      "official_name": "Republic of Lithuania"
    },
    {
      "alpha_2": "LU",
      "alpha_3": "LUX",
      "name": "Luxembourg",
      "numeric": "442",
      "official_name": "Grand Duchy of Luxembourg"
    },
    {
      "alpha_2": "LV",
      "alpha_3": "LVA",
      "name": "Latvia",
      "numeric": "428",
      "official_name": "Republic of Latvia"
    },
    {
      "alpha_2": "MO",
      "alpha_3": "MAC",
      "name": "Macao",
      "numeric": "446",
      "official_name": "Macao Special Administrative Region of China"
    },
    {
      "alpha_2": "MF",
      "alpha_3": "MAF",
      "name": "Saint Martin (French part)",
      "numeric": "663"
    },
    {
      "alpha_2": "MA",
      "alpha_3": "MAR",
      "name": "Morocco",
      "numeric": "504",
      "official_name": "Kingdom of Morocco"
    },
    {
      "alpha_2": "MC",
      "alpha_3": "MCO",
      "name": "Monaco",
      "numeric": "492",
      "official_name": "Principality of Monaco"
    },
    {
      "alpha_2": "MD",
      "alpha_3": "MDA",
      "common_name": "Moldova",
      "name": "Moldova, Republic of",
      "numeric": "498",
      "official_name": "Republic of Moldova"
    },
    {
      "alpha_2": "MG",
      "alpha_3": "MDG",
      "name": "Madagascar",
      "numeric": "450",
      "official_name": "Republic of Madagascar"
    },
    {
      "alpha_2": "MV",
      "alpha_3": "MDV",
      "name": "Maldives",
      "numeric": "462",
      "official_name": "Republic of Maldives"
    },
    {
      "alpha_2": "MX",
      "alpha_3": "MEX",
      "name": "Mexico",
      "numeric": "484",
      "official_name": "United Mexican States"
    },
    {
      "alpha_2": "MH",
      "alpha_3": "MHL",
      "name": "Marshall Islands",
      "numeric": "584",
      "official_name": "Republic of the Marshall Islands"
    },
    {
      "alpha_2": "MK",
      "alpha_3": "MKD",
      "name": "Macedonia, Republic of",
      "numeric": "807",
      "official_name": "The Former Yugoslav Republic of Macedonia"
    },
    {
      "alpha_2": "ML",
      "alpha_3": "MLI",
      "name": "Mali",
      "numeric": "466",
      "official_name": "Republic of Mali"
    },
    {
      "alpha_2": "MT",
      "alpha_3": "MLT",
      "name": "Malta",
      "numeric": "470",
      "official_name": "Republic of Malta"
    },
    {
      "alpha_2": "MM",
      "alpha_3": "MMR",
      "name": "Myanmar",
      "numeric": "104",
      "official_name": "Republic of Myanmar"
    },
    {
      "alpha_2": "ME",
      "alpha_3": "MNE",
      "name": "Montenegro",
      "numeric": "499",
      "official_name": "Montenegro"
    },
    {
      "alpha_2": "MN",
      "alpha_3": "MNG",
      "name": "Mongolia",
      "numeric": "496"
    },
    {
      "alpha_2": "MP",
      "alpha_3": "MNP",
      "name": "Northern Mariana Islands",
      "numeric": "580",
      "official_name": "Commonwealth of the Northern Mariana Islands"
    },
    {
      "alpha_2": "MZ",
      "alpha_3": "MOZ",
      "name": "Mozambique",
      "numeric": "508",
      "official_name": "Republic of Mozambique"
    },
    {
      "alpha_2": "MR",
      "alpha_3": "MRT",
      "name": "Mauritania",
      "numeric": "478",
      "official_name": "Islamic Republic of Mauritania"
    },
    {
      "alpha_2": "MS",
      "alpha_3": "MSR",
      "name": "Montserrat",
      "numeric": "500"
    },
    {
      "alpha_2": "MQ",
      "alpha_3": "MTQ",
      "name": "Martinique",
      "numeric": "474"
    },
    {
      "alpha_2": "MU",
      "alpha_3": "MUS",
      "name": "Mauritius",
      "numeric": "480",
      "official_name": "Republic of Mauritius"
    },
    {
      "alpha_2": "MW",
      "alpha_3": "MWI",
      "name": "Malawi",
      "numeric": "454",
      "official_name": "Republic of Malawi"
    },
    {
      "alpha_2": "MY",
      "alpha_3": "MYS",
      "name": "Malaysia",
      "numeric": "458"
    },
    {
      "alpha_2": "YT",
      "alpha_3": "MYT",
      "name": "Mayotte",
      "numeric": "175"
    },
    {
      "alpha_2": "NA",
      "alpha_3": "NAM",
      "name": "Namibia",
      "numeric": "516",
      "official_name": "Republic of Namibia"
    },
    {
      "alpha_2": "NC",
      "alpha_3": "NCL",
      "name": "New Caledonia",
      "numeric": "540"
    },
    {
      "alpha_2": "NE",
      "alpha_3": "NER",
      "name": "Niger",
      "numeric": "562",
      "official_name": "Republic of the Niger"
    },
    {
      "alpha_2": "NF",
      "alpha_3": "NFK",
      "name": "Norfolk Island",
      "numeric": "574"
    },
    {
      "alpha_2": "NG",
      "alpha_3": "NGA",
      "name": "Nigeria",
      "numeric": "566",
      "official_name": "Federal Republic of Nigeria"
    },
    {
      "alpha_2": "NI",
      "alpha_3": "NIC",
      "name": "Nicaragua",
      "numeric": "558",
      "official_name": "Republic of Nicaragua"
    },
    {
      "alpha_2": "NU",
      "alpha_3": "NIU",
      "name": "Niue",
      "numeric": "570",
      "official_name": "Niue"
    },
    {
      "alpha_2": "NL",
      "alpha_3": "NLD",
      "name": "Netherlands",
      "numeric": "528",
      "official_name": "Kingdom of the Netherlands"
    },
    {
      "alpha_2": "NO",
      "alpha_3": "NOR",
      "name": "Norway",
      "numeric": "578",
      "official_name": "Kingdom of Norway"
    },
    {
      "alpha_2": "NP",
      "alpha_3": "NPL",
      "name": "Nepal",
      "numeric": "524",
      "official_name": "Federal Democratic Republic of Nepal"
    },
    {
      "alpha_2": "NR",
      "alpha_3": "NRU",
      "name": "Nauru",
      "numeric": "520",
      "official_name": "Republic of Nauru"
    },
    {
      "alpha_2": "NZ",
      "alpha_3": "NZL",
      "name": "New Zealand",
      "numeric": "554"
    },
    {
      "alpha_2": "OM",
      "alpha_3": "OMN",
      "name": "Oman",
      "numeric": "512",
      "official_name": "Sultanate of Oman"
    },
    {
      "alpha_2": "PK",
      "alpha_3": "PAK",
      "name": "Pakistan",
      "numeric": "586",
      "official_name": "Islamic Republic of Pakistan"
    },
    {
      "alpha_2": "PA",
      "alpha_3": "PAN",
      "name": "Panama",
      "numeric": "591",
      "official_name": "Republic of Panama"
    },
    {
      "alpha_2": "PN",
      "alpha_3": "PCN",
      "name": "Pitcairn",
      "numeric": "612"
    },
    {
      "alpha_2": "PE",
      "alpha_3": "PER",
      "name": "Peru",
      "numeric": "604",
      "official_name": "Republic of Peru"
    },
    {
      "alpha_2": "PH",
      "alpha_3": "PHL",
      "name": "Philippines",
      "numeric": "608",
      "official_name": "Republic of the Philippines"
    },
    {
      "alpha_2": "PW",
      "alpha_3": "PLW",
      "name": "Palau",
      "numeric": "585",
      "official_name": "Republic of Palau"
    },
    {
      "alpha_2": "PG",
      "alpha_3": "PNG",
      "name": "Papua New Guinea",
      "numeric": "598",
      "official_name": "Independent State of Papua New Guinea"
    },
    {
      "alpha_2": "PL",
      "alpha_3": "POL",
      "name": "Poland",
      "numeric": "616",
      "official_name": "Republic of Poland"
    },
    {
      "alpha_2": "PR",
      "alpha_3": "PRI",
      "name": "Puerto Rico",
      "numeric": "630"
    },
    {
      "alpha_2": "KP",
      "alpha_3": "PRK",
      "name": "Korea, Democratic People's Republic of",
      "numeric": "408",
      "official_name": "Democratic People's Republic of Korea"
    },
    {
      "alpha_2": "PT",
      "alpha_3": "PRT",
      "name": "Portugal",
      "numeric": "620",
      "official_name": "Portuguese Republic"
    },
    {
      "alpha_2": "PY",
      "alpha_3": "PRY",
      "name": "Paraguay",
      "numeric": "600",
      "official_name": "Republic of Paraguay"
    },
    {
      "alpha_2": "PS",
      "alpha_3": "PSE",
      "name": "Palestine, State of",
      "numeric": "275",
      "official_name": "the State of Palestine"
    },
    {
      "alpha_2": "PF",
      "alpha_3": "PYF",
      "name": "French Polynesia",
      "numeric": "258"
    },
    {
      "alpha_2": "QA",
      "alpha_3": "QAT",
      "name": "Qatar",
      "numeric": "634",
      "official_name": "State of Qatar"
    },
    {
      "alpha_2": "RE",
      "alpha_3": "REU",
      "name": "Réunion",
      "numeric": "638"
    },
    {
      "alpha_2": "RO",
      "alpha_3": "ROU",
      "name": "Romania",
      "numeric": "642"
    },
    {
      "alpha_2": "RU",
      "alpha_3": "RUS",
      "name": "Russian Federation",
      "numeric": "643"
    },
    {
      "alpha_2": "RW",
      "alpha_3": "RWA",
      "name": "Rwanda",
      "numeric": "646",
      "official_name": "Rwandese Republic"
    },
    {
      "alpha_2": "SA",
      "alpha_3": "SAU",
      "name": "Saudi Arabia",
      "numeric": "682",
      "official_name": "Kingdom of Saudi Arabia"
    },
    {
      "alpha_2": "SD",
      "alpha_3": "SDN",
      "name": "Sudan",
      "numeric": "729",
      "official_name": "Republic of the Sudan"
    },
    {
      "alpha_2": "SN",
      "alpha_3": "SEN",
      "name": "Senegal",
      "numeric": "686",
      "official_name": "Republic of Senegal"
    },
    {
      "alpha_2": "SG",
      "alpha_3": "SGP",
      "name": "Singapore",
      "numeric": "702",
      "official_name": "Republic of Singapore"
    },
    {
      "alpha_2": "GS",
      "alpha_3": "SGS",
      "name": "South Georgia and the South Sandwich Islands",
      "numeric": "239"
    },
    {
      "alpha_2": "SH",
      "alpha_3": "SHN",
      "name": "Saint Helena, Ascension and Tristan da Cunha",
      "numeric": "654"
    },
    {
      "alpha_2": "SJ",
      "alpha_3": "SJM",
      "name": "Svalbard and Jan Mayen",
      "numeric": "744"
    },
    {
      "alpha_2": "SB",
      "alpha_3": "SLB",
      "name": "Solomon Islands",
      "numeric": "090"
    },
    {
      "alpha_2": "SL",
      "alpha_3": "SLE",
      "name": "Sierra Leone",
      "numeric": "694",
      "official_name": "Republic of Sierra Leone"
    },
    {
      "alpha_2": "SV",
      "alpha_3": "SLV",
      "name": "El Salvador",
      "numeric": "222",
      "official_name": "Republic of El Salvador"
    },
    {
      "alpha_2": "SM",
      "alpha_3": "SMR",
      "name": "San Marino",
      "numeric": "674",
      "official_name": "Republic of San Marino"
    },
    {
      "alpha_2": "SO",
      "alpha_3": "SOM",
      "name": "Somalia",
      "numeric": "706",
      "official_name": "Federal Republic of Somalia"
    },
    {
      "alpha_2": "PM",
      "alpha_3": "SPM",
      "name": "Saint Pierre and Miquelon",
      "numeric": "666"
    },
    {
      "alpha_2": "RS",
      "alpha_3": "SRB",
      "name": "Serbia",
      "numeric": "688",
      "official_name": "Republic of Serbia"
    },
    {
      "alpha_2": "SS",
      "alpha_3": "SSD",
      "name": "South Sudan",
      "numeric": "728",
      "official_name": "Republic of South Sudan"
    },
    {
      "alpha_2": "ST",
      "alpha_3": "STP",
      "name": "Sao Tome and Principe",
      "numeric": "678",
      "official_name": "Democratic Republic of Sao Tome and Principe"
    },
    {
      "alpha_2": "SR",
      "alpha_3": "SUR",
      "name": "Suriname",
      "numeric": "740",
      "official_name": "Republic of Suriname"
    },
    {
      "alpha_2": "SK",
      "alpha_3": "SVK",
      "name": "Slovakia",
      "numeric": "703",
      "official_name": "Slovak Republic"
    },
    {
      "alpha_2": "SI",
      "alpha_3": "SVN",
      "name": "Slovenia",
      "numeric": "705",
      "official_name": "Republic of Slovenia"
    },
    {
      "alpha_2": "SE",
      "alpha_3": "SWE",
      "name": "Sweden",
      "numeric": "752",
      "official_name": "Kingdom of Sweden"
    },
    {
      "alpha_2": "SZ",
      "alpha_3": "SWZ",
      "name": "Swaziland",
      "numeric": "748",
      "official_name": "Kingdom of Swaziland"
    },
    {
      "alpha_2": "SX",
      "alpha_3": "SXM",
      "name": "Sint Maarten (Dutch part)",
      "numeric": "534",
      "official_name": "Sint Maarten (Dutch part)"
    },
    {
      "alpha_2": "SC",
      "alpha_3": "SYC",
      "name": "Seychelles",
      "numeric": "690",
      "official_name": "Republic of Seychelles"
    },
    {
      "alpha_2": "SY",
      "alpha_3": "SYR",
      "name": "Syrian Arab Republic",
      "numeric": "760"
    },
    {
      "alpha_2": "TC",
      "alpha_3": "TCA",
      "name": "Turks and Caicos Islands",
      "numeric": "796"
    },
    {
      "alpha_2": "TD",
      "alpha_3": "TCD",
      "name": "Chad",
      "numeric": "148",
      "official_name": "Republic of Chad"
    },
    {
      "alpha_2": "TG",
      "alpha_3": "TGO",
      "name": "Togo",
      "numeric": "768",
      "official_name": "Togolese Republic"
    },
    {
      "alpha_2": "TH",
      "alpha_3": "THA",
      "name": "Thailand",
      "numeric": "764",
      "official_name": "Kingdom of Thailand"
    },
    {
      "alpha_2": "TJ",
      "alpha_3": "TJK",
      "name": "Tajikistan",
      "numeric": "762",
      "official_name": "Republic of Tajikistan"
    },
    {
      "alpha_2": "TK",
      "alpha_3": "TKL",
      "name": "Tokelau",
      "numeric": "772"
    },
    {
      "alpha_2": "TM",
      "alpha_3": "TKM",
      "name": "Turkmenistan",
      "numeric": "795"
    },
    {
      "alpha_2": "TL",
      "alpha_3": "TLS",
      "name": "Timor-Leste",
      "numeric": "626",
      "official_name": "Democratic Republic of Timor-Leste"
    },
    {
      "alpha_2": "TO",
      "alpha_3": "TON",
      "name": "Tonga",
      "numeric": "776",
      "official_name": "Kingdom of Tonga"
    },
    {
      "alpha_2": "TT",
      "alpha_3": "TTO",
      "name": "Trinidad and Tobago",
      "numeric": "780",
      "official_name": "Republic of Trinidad and Tobago"
    },
    {
      "alpha_2": "TN",
      "alpha_3": "TUN",
      "name": "Tunisia",
      "numeric": "788",
      "official_name": "Republic of Tunisia"
    },
    {
      "alpha_2": "TR",
      "alpha_3": "TUR",
      "name": "Turkey",
      "numeric": "792",
      "official_name": "Republic of Turkey"
    },
    {
      "alpha_2": "TV",
      "alpha_3": "TUV",
      "name": "Tuvalu",
      "numeric": "798"
    },
    {
      "alpha_2": "TW",
      "alpha_3": "TWN",
      "common_name": "Taiwan",
      "name": "Taiwan, Province of China",
      "numeric": "158",
      "official_name": "Taiwan, Province of China"
    },
    {
      "alpha_2": "TZ",
      "alpha_3": "TZA",
      "common_name": "Tanzania",
      "name": "Tanzania, United Republic of",
      "numeric": "834",
      "official_name": "United Republic of Tanzania"
    },
    {
      "alpha_2": "UG",
      "alpha_3": "UGA",
      "name": "Uganda",
      "numeric": "800",
      "official_name": "Republic of Uganda"
    },
    {
      "alpha_2": "UA",
      "alpha_3": "UKR",
      "name": "Ukraine",
      "numeric": "804"
    },
    {
      "alpha_2": "UM",
      "alpha_3": "UMI",
      "name": "United States Minor Outlying Islands",
      "numeric": "581"
    },
    {
      "alpha_2": "UY",
      "alpha_3": "URY",
      "name": "Uruguay",
      "numeric": "858",
      "official_name": "Eastern Republic of Uruguay"
    },
    {
      "alpha_2": "US",
      "alpha_3": "USA",
      "name": "United States",
      "numeric": "840",
      "official_name": "United States of America"
    },
    {
      "alpha_2": "UZ",
      "alpha_3": "UZB",
      "name": "Uzbekistan",
      "numeric": "860",
      "official_name": "Republic of Uzbekistan"
    },
    {
      "alpha_2": "VA",
      "alpha_3": "VAT",
      "name": "Holy See (Vatican City State)",
      "numeric": "336"
    },
    {
      "alpha_2": "VC",
      "alpha_3": "VCT",
      "name": "Saint Vincent and the Grenadines",
      "numeric": "670"
    },
    {
      "alpha_2": "VE",
      "alpha_3": "VEN",
      "common_name": "Venezuela",
      "name": "Venezuela, Bolivarian Republic of",
      "numeric": "862",
      "official_name": "Bolivarian Republic of Venezuela"
    },
    {
      "alpha_2": "VG",
      "alpha_3": "VGB",
      "name": "Virgin Islands, British",
      "numeric": "092",
      "official_name": "British Virgin Islands"
    },
    {
      "alpha_2": "VI",
      "alpha_3": "VIR",
      "name": "Virgin Islands, U.S.",
      "numeric": "850",
      "official_name": "Virgin Islands of the United States"
    },
    {
      "alpha_2": "VN",
      "alpha_3": "VNM",
      "name": "Viet Nam",
      "numeric": "704",
      "official_name": "Socialist Republic of Viet Nam"
    },
    {
      "alpha_2": "VU",
      "alpha_3": "VUT",
      "name": "Vanuatu",
      "numeric": "548",
      "official_name": "Republic of Vanuatu"
    },
    {
      "alpha_2": "WF",
      "alpha_3": "WLF",
      "name": "Wallis and Futuna",
      "numeric": "876"
    },
    {
      "alpha_2": "WS",
      "alpha_3": "WSM",
      "name": "Samoa",
      "numeric": "882",
      "official_name": "Independent State of Samoa"
    },
    {
      "alpha_2": "YE",
      "alpha_3": "YEM",
      "name": "Yemen",
      "numeric": "887",
      "official_name": "Republic of Yemen"
    },
    {
      "alpha_2": "ZA",
      "alpha_3": "ZAF",
      "name": "South Africa",
      "numeric": "710",
      "official_name": "Republic of South Africa"
    },
    {
      "alpha_2": "ZM",
      "alpha_3": "ZMB",
      "name": "Zambia",
      "numeric": "894",
      "official_name": "Republic of Zambia"
    },
    {
      "alpha_2": "ZW",
      "alpha_3": "ZWE",
      "name": "Zimbabwe",
      "numeric": "716",
      "official_name": "Republic of Zimbabwe"
    }
  ],
  
  "3166-2": [
    {
      "code": "AD-02",
      "name": "Canillo",
      "type": "Parish"
    },
    {
      "code": "AD-03",
      "name": "Encamp",
      "type": "Parish"
    },
    {
      "code": "AD-04",
      "name": "La Massana",
      "type": "Parish"
    },
    {
      "code": "AD-05",
      "name": "Ordino",
      "type": "Parish"
    },
    {
      "code": "AD-06",
      "name": "Sant Julià de Lòria",
      "type": "Parish"
    },
    {
      "code": "AD-07",
      "name": "Andorra la Vella",
      "type": "Parish"
    },
    {
      "code": "AD-08",
      "name": "Escaldes-Engordany",
      "type": "Parish"
    },
    {
      "code": "AE-AJ",
      "name": "'Ajmān",
      "type": "Emirate"
    },
    {
      "code": "AE-AZ",
      "name": "Abū Ȥaby [Abu Dhabi]",
      "type": "Emirate"
    },
    {
      "code": "AE-DU",
      "name": "Dubayy",
      "type": "Emirate"
    },
    {
      "code": "AE-FU",
      "name": "Al Fujayrah",
      "type": "Emirate"
    },
    {
      "code": "AE-RK",
      "name": "Ra’s al Khaymah",
      "type": "Emirate"
    },
    {
      "code": "AE-SH",
      "name": "Ash Shāriqah",
      "type": "Emirate"
    },
    {
      "code": "AE-UQ",
      "name": "Umm al Qaywayn",
      "type": "Emirate"
    },
    {
      "code": "AF-BAL",
      "name": "Balkh",
      "type": "Province"
    },
    {
      "code": "AF-BAM",
      "name": "Bāmyān",
      "type": "Province"
    },
    {
      "code": "AF-BDG",
      "name": "Bādghīs",
      "type": "Province"
    },
    {
      "code": "AF-BDS",
      "name": "Badakhshān",
      "type": "Province"
    },
    {
      "code": "AF-BGL",
      "name": "Baghlān",
      "type": "Province"
    },
    {
      "code": "AF-DAY",
      "name": "Dāykundī",
      "type": "Province"
    },
    {
      "code": "AF-FRA",
      "name": "Farāh",
      "type": "Province"
    },
    {
      "code": "AF-FYB",
      "name": "Fāryāb",
      "type": "Province"
    },
    {
      "code": "AF-GHA",
      "name": "Ghaznī",
      "type": "Province"
    },
    {
      "code": "AF-GHO",
      "name": "Ghōr",
      "type": "Province"
    },
    {
      "code": "AF-HEL",
      "name": "Helmand",
      "type": "Province"
    },
    {
      "code": "AF-HER",
      "name": "Herāt",
      "type": "Province"
    },
    {
      "code": "AF-JOW",
      "name": "Jowzjān",
      "type": "Province"
    },
    {
      "code": "AF-KAB",
      "name": "Kābul",
      "type": "Province"
    },
    {
      "code": "AF-KAN",
      "name": "Kandahār",
      "type": "Province"
    },
    {
      "code": "AF-KAP",
      "name": "Kāpīsā",
      "type": "Province"
    },
    {
      "code": "AF-KDZ",
      "name": "Kunduz",
      "type": "Province"
    },
    {
      "code": "AF-KHO",
      "name": "Khōst",
      "type": "Province"
    },
    {
      "code": "AF-KNR",
      "name": "Kunar",
      "type": "Province"
    },
    {
      "code": "AF-LAG",
      "name": "Laghmān",
      "type": "Province"
    },
    {
      "code": "AF-LOG",
      "name": "Lōgar",
      "type": "Province"
    },
    {
      "code": "AF-NAN",
      "name": "Nangarhār",
      "type": "Province"
    },
    {
      "code": "AF-NIM",
      "name": "Nīmrōz",
      "type": "Province"
    },
    {
      "code": "AF-NUR",
      "name": "Nūristān",
      "type": "Province"
    },
    {
      "code": "AF-PAN",
      "name": "Panjshayr",
      "type": "Province"
    },
    {
      "code": "AF-PAR",
      "name": "Parwān",
      "type": "Province"
    },
    {
      "code": "AF-PIA",
      "name": "Paktiyā",
      "type": "Province"
    },
    {
      "code": "AF-PKA",
      "name": "Paktīkā",
      "type": "Province"
    },
    {
      "code": "AF-SAM",
      "name": "Samangān",
      "type": "Province"
    },
    {
      "code": "AF-SAR",
      "name": "Sar-e Pul",
      "type": "Province"
    },
    {
      "code": "AF-TAK",
      "name": "Takhār",
      "type": "Province"
    },
    {
      "code": "AF-URU",
      "name": "Uruzgān",
      "type": "Province"
    },
    {
      "code": "AF-WAR",
      "name": "Wardak",
      "type": "Province"
    },
    {
      "code": "AF-ZAB",
      "name": "Zābul",
      "type": "Province"
    },
    {
      "code": "AG-03",
      "name": "Saint George",
      "type": "Parish"
    },
    {
      "code": "AG-04",
      "name": "Saint John",
      "type": "Parish"
    },
    {
      "code": "AG-05",
      "name": "Saint Mary",
      "type": "Parish"
    },
    {
      "code": "AG-06",
      "name": "Saint Paul",
      "type": "Parish"
    },
    {
      "code": "AG-07",
      "name": "Saint Peter",
      "type": "Parish"
    },
    {
      "code": "AG-08",
      "name": "Saint Philip",
      "type": "Parish"
    },
    {
      "code": "AG-10",
      "name": "Barbuda",
      "type": "Dependency"
    },
    {
      "code": "AG-11",
      "name": "Redonda",
      "type": "Dependency"
    },
    {
      "code": "AL-01",
      "name": "Berat",
      "type": "County"
    },
    {
      "code": "AL-02",
      "name": "Durrës",
      "type": "County"
    },
    {
      "code": "AL-03",
      "name": "Elbasan",
      "type": "County"
    },
    {
      "code": "AL-04",
      "name": "Fier",
      "type": "County"
    },
    {
      "code": "AL-05",
      "name": "Gjirokastër",
      "type": "County"
    },
    {
      "code": "AL-06",
      "name": "Korçë",
      "type": "County"
    },
    {
      "code": "AL-07",
      "name": "Kukës",
      "type": "County"
    },
    {
      "code": "AL-08",
      "name": "Lezhë",
      "type": "County"
    },
    {
      "code": "AL-09",
      "name": "Dibër",
      "type": "County"
    },
    {
      "code": "AL-10",
      "name": "Shkodër",
      "type": "County"
    },
    {
      "code": "AL-11",
      "name": "Tiranë",
      "type": "County"
    },
    {
      "code": "AL-12",
      "name": "Vlorë",
      "type": "County"
    },
    {
      "code": "AL-BR",
      "name": "Berat",
      "parent": "01",
      "type": "District"
    },
    {
      "code": "AL-BU",
      "name": "Bulqizë",
      "parent": "09",
      "type": "District"
    },
    {
      "code": "AL-DI",
      "name": "Dibër",
      "parent": "09",
      "type": "District"
    },
    {
      "code": "AL-DL",
      "name": "Delvinë",
      "parent": "12",
      "type": "District"
    },
    {
      "code": "AL-DR",
      "name": "Durrës",
      "parent": "02",
      "type": "District"
    },
    {
      "code": "AL-DV",
      "name": "Devoll",
      "parent": "06",
      "type": "District"
    },
    {
      "code": "AL-EL",
      "name": "Elbasan",
      "parent": "03",
      "type": "District"
    },
    {
      "code": "AL-ER",
      "name": "Kolonjë",
      "parent": "06",
      "type": "District"
    },
    {
      "code": "AL-FR",
      "name": "Fier",
      "parent": "04",
      "type": "District"
    },
    {
      "code": "AL-GJ",
      "name": "Gjirokastër",
      "parent": "05",
      "type": "District"
    },
    {
      "code": "AL-GR",
      "name": "Gramsh",
      "parent": "03",
      "type": "District"
    },
    {
      "code": "AL-HA",
      "name": "Has",
      "parent": "07",
      "type": "District"
    },
    {
      "code": "AL-KA",
      "name": "Kavajë",
      "parent": "11",
      "type": "District"
    },
    {
      "code": "AL-KB",
      "name": "Kurbin",
      "parent": "08",
      "type": "District"
    },
    {
      "code": "AL-KC",
      "name": "Kuçovë",
      "parent": "01",
      "type": "District"
    },
    {
      "code": "AL-KO",
      "name": "Korçë",
      "parent": "06",
      "type": "District"
    },
    {
      "code": "AL-KR",
      "name": "Krujë",
      "parent": "02",
      "type": "District"
    },
    {
      "code": "AL-KU",
      "name": "Kukës",
      "parent": "07",
      "type": "District"
    },
    {
      "code": "AL-LB",
      "name": "Librazhd",
      "parent": "03",
      "type": "District"
    },
    {
      "code": "AL-LE",
      "name": "Lezhë",
      "parent": "08",
      "type": "District"
    },
    {
      "code": "AL-LU",
      "name": "Lushnjë",
      "parent": "04",
      "type": "District"
    },
    {
      "code": "AL-MK",
      "name": "Mallakastër",
      "parent": "04",
      "type": "District"
    },
    {
      "code": "AL-MM",
      "name": "Malësi e Madhe",
      "parent": "10",
      "type": "District"
    },
    {
      "code": "AL-MR",
      "name": "Mirditë",
      "parent": "08",
      "type": "District"
    },
    {
      "code": "AL-MT",
      "name": "Mat",
      "parent": "09",
      "type": "District"
    },
    {
      "code": "AL-PG",
      "name": "Pogradec",
      "parent": "06",
      "type": "District"
    },
    {
      "code": "AL-PQ",
      "name": "Peqin",
      "parent": "03",
      "type": "District"
    },
    {
      "code": "AL-PR",
      "name": "Përmet",
      "parent": "05",
      "type": "District"
    },
    {
      "code": "AL-PU",
      "name": "Pukë",
      "parent": "10",
      "type": "District"
    },
    {
      "code": "AL-SH",
      "name": "Shkodër",
      "parent": "10",
      "type": "District"
    },
    {
      "code": "AL-SK",
      "name": "Skrapar",
      "parent": "01",
      "type": "District"
    },
    {
      "code": "AL-SR",
      "name": "Sarandë",
      "parent": "12",
      "type": "District"
    },
    {
      "code": "AL-TE",
      "name": "Tepelenë",
      "parent": "05",
      "type": "District"
    },
    {
      "code": "AL-TP",
      "name": "Tropojë",
      "parent": "07",
      "type": "District"
    },
    {
      "code": "AL-TR",
      "name": "Tiranë",
      "parent": "11",
      "type": "District"
    },
    {
      "code": "AL-VL",
      "name": "Vlorë",
      "parent": "12",
      "type": "District"
    },
    {
      "code": "AM-AG",
      "name": "Aragacotn",
      "type": "Province"
    },
    {
      "code": "AM-AR",
      "name": "Ararat",
      "type": "Province"
    },
    {
      "code": "AM-AV",
      "name": "Armavir",
      "type": "Province"
    },
    {
      "code": "AM-ER",
      "name": "Erevan",
      "type": "Province"
    },
    {
      "code": "AM-GR",
      "name": "Gegarkunik'",
      "type": "Province"
    },
    {
      "code": "AM-KT",
      "name": "Kotayk'",
      "type": "Province"
    },
    {
      "code": "AM-LO",
      "name": "Lory",
      "type": "Province"
    },
    {
      "code": "AM-SH",
      "name": "Sirak",
      "type": "Province"
    },
    {
      "code": "AM-SU",
      "name": "Syunik'",
      "type": "Province"
    },
    {
      "code": "AM-TV",
      "name": "Tavus",
      "type": "Province"
    },
    {
      "code": "AM-VD",
      "name": "Vayoc Jor",
      "type": "Province"
    },
    {
      "code": "AO-BGO",
      "name": "Bengo",
      "type": "Province"
    },
    {
      "code": "AO-BGU",
      "name": "Benguela",
      "type": "Province"
    },
    {
      "code": "AO-BIE",
      "name": "Bié",
      "type": "Province"
    },
    {
      "code": "AO-CAB",
      "name": "Cabinda",
      "type": "Province"
    },
    {
      "code": "AO-CCU",
      "name": "Cuando-Cubango",
      "type": "Province"
    },
    {
      "code": "AO-CNN",
      "name": "Cunene",
      "type": "Province"
    },
    {
      "code": "AO-CNO",
      "name": "Cuanza Norte",
      "type": "Province"
    },
    {
      "code": "AO-CUS",
      "name": "Cuanza Sul",
      "type": "Province"
    },
    {
      "code": "AO-HUA",
      "name": "Huambo",
      "type": "Province"
    },
    {
      "code": "AO-HUI",
      "name": "Huíla",
      "type": "Province"
    },
    {
      "code": "AO-LNO",
      "name": "Lunda Norte",
      "type": "Province"
    },
    {
      "code": "AO-LSU",
      "name": "Lunda Sul",
      "type": "Province"
    },
    {
      "code": "AO-LUA",
      "name": "Luanda",
      "type": "Province"
    },
    {
      "code": "AO-MAL",
      "name": "Malange",
      "type": "Province"
    },
    {
      "code": "AO-MOX",
      "name": "Moxico",
      "type": "Province"
    },
    {
      "code": "AO-NAM",
      "name": "Namibe",
      "type": "Province"
    },
    {
      "code": "AO-UIG",
      "name": "Uíge",
      "type": "Province"
    },
    {
      "code": "AO-ZAI",
      "name": "Zaire",
      "type": "Province"
    },
    {
      "code": "AR-A",
      "name": "Salta",
      "type": "Province"
    },
    {
      "code": "AR-B",
      "name": "Buenos Aires",
      "type": "Province"
    },
    {
      "code": "AR-C",
      "name": "Ciudad Autónoma de Buenos Aires",
      "type": "City"
    },
    {
      "code": "AR-D",
      "name": "San Luis",
      "type": "Province"
    },
    {
      "code": "AR-E",
      "name": "Entre Rios",
      "type": "Province"
    },
    {
      "code": "AR-G",
      "name": "Santiago del Estero",
      "type": "Province"
    },
    {
      "code": "AR-H",
      "name": "Chaco",
      "type": "Province"
    },
    {
      "code": "AR-J",
      "name": "San Juan",
      "type": "Province"
    },
    {
      "code": "AR-K",
      "name": "Catamarca",
      "type": "Province"
    },
    {
      "code": "AR-L",
      "name": "La Pampa",
      "type": "Province"
    },
    {
      "code": "AR-M",
      "name": "Mendoza",
      "type": "Province"
    },
    {
      "code": "AR-N",
      "name": "Misiones",
      "type": "Province"
    },
    {
      "code": "AR-P",
      "name": "Formosa",
      "type": "Province"
    },
    {
      "code": "AR-Q",
      "name": "Neuquen",
      "type": "Province"
    },
    {
      "code": "AR-R",
      "name": "Rio Negro",
      "type": "Province"
    },
    {
      "code": "AR-S",
      "name": "Santa Fe",
      "type": "Province"
    },
    {
      "code": "AR-T",
      "name": "Tucuman",
      "type": "Province"
    },
    {
      "code": "AR-U",
      "name": "Chubut",
      "type": "Province"
    },
    {
      "code": "AR-V",
      "name": "Tierra del Fuego",
      "type": "Province"
    },
    {
      "code": "AR-W",
      "name": "Corrientes",
      "type": "Province"
    },
    {
      "code": "AR-X",
      "name": "Cordoba",
      "type": "Province"
    },
    {
      "code": "AR-Y",
      "name": "Jujuy",
      "type": "Province"
    },
    {
      "code": "AR-Z",
      "name": "Santa Cruz",
      "type": "Province"
    },
    {
      "code": "AT-1",
      "name": "Burgenland",
      "type": "State"
    },
    {
      "code": "AT-2",
      "name": "Kärnten",
      "type": "State"
    },
    {
      "code": "AT-3",
      "name": "Niederösterreich",
      "type": "State"
    },
    {
      "code": "AT-4",
      "name": "Oberösterreich",
      "type": "State"
    },
    {
      "code": "AT-5",
      "name": "Salzburg",
      "type": "State"
    },
    {
      "code": "AT-6",
      "name": "Steiermark",
      "type": "State"
    },
    {
      "code": "AT-7",
      "name": "Tirol",
      "type": "State"
    },
    {
      "code": "AT-8",
      "name": "Vorarlberg",
      "type": "State"
    },
    {
      "code": "AT-9",
      "name": "Wien",
      "type": "State"
    },
    {
      "code": "AU-ACT",
      "name": "Australian Capital Territory",
      "type": "Territory"
    },
    {
      "code": "AU-NSW",
      "name": "New South Wales",
      "type": "State"
    },
    {
      "code": "AU-NT",
      "name": "Northern Territory",
      "type": "Territory"
    },
    {
      "code": "AU-QLD",
      "name": "Queensland",
      "type": "State"
    },
    {
      "code": "AU-SA",
      "name": "South Australia",
      "type": "State"
    },
    {
      "code": "AU-TAS",
      "name": "Tasmania",
      "type": "State"
    },
    {
      "code": "AU-VIC",
      "name": "Victoria",
      "type": "State"
    },
    {
      "code": "AU-WA",
      "name": "Western Australia",
      "type": "State"
    },
    {
      "code": "AZ-ABS",
      "name": "Abşeron",
      "type": "Rayon"
    },
    {
      "code": "AZ-AGA",
      "name": "Ağstafa",
      "type": "Rayon"
    },
    {
      "code": "AZ-AGC",
      "name": "Ağcabədi",
      "type": "Rayon"
    },
    {
      "code": "AZ-AGM",
      "name": "Ağdam",
      "type": "Rayon"
    },
    {
      "code": "AZ-AGS",
      "name": "Ağdaş",
      "type": "Rayon"
    },
    {
      "code": "AZ-AGU",
      "name": "Ağsu",
      "type": "Rayon"
    },
    {
      "code": "AZ-AST",
      "name": "Astara",
      "type": "Rayon"
    },
    {
      "code": "AZ-BA",
      "name": "Bakı",
      "type": "Municipality"
    },
    {
      "code": "AZ-BAB",
      "name": "Babək",
      "parent": "NX",
      "type": "Rayon"
    },
    {
      "code": "AZ-BAL",
      "name": "Balakən",
      "type": "Rayon"
    },
    {
      "code": "AZ-BAR",
      "name": "Bərdə",
      "type": "Rayon"
    },
    {
      "code": "AZ-BEY",
      "name": "Beyləqan",
      "type": "Rayon"
    },
    {
      "code": "AZ-BIL",
      "name": "Biləsuvar",
      "type": "Rayon"
    },
    {
      "code": "AZ-CAB",
      "name": "Cəbrayıl",
      "type": "Rayon"
    },
    {
      "code": "AZ-CAL",
      "name": "Cəlilabab",
      "type": "Rayon"
    },
    {
      "code": "AZ-CUL",
      "name": "Culfa",
      "parent": "NX",
      "type": "Rayon"
    },
    {
      "code": "AZ-DAS",
      "name": "Daşkəsən",
      "type": "Rayon"
    },
    {
      "code": "AZ-FUZ",
      "name": "Füzuli",
      "type": "Rayon"
    },
    {
      "code": "AZ-GA",
      "name": "Gəncə",
      "type": "Municipality"
    },
    {
      "code": "AZ-GAD",
      "name": "Gədəbəy",
      "type": "Rayon"
    },
    {
      "code": "AZ-GOR",
      "name": "Goranboy",
      "type": "Rayon"
    },
    {
      "code": "AZ-GOY",
      "name": "Göyçay",
      "type": "Rayon"
    },
    {
      "code": "AZ-GYG",
      "name": "Göygöl",
      "type": "Rayon"
    },
    {
      "code": "AZ-HAC",
      "name": "Hacıqabul",
      "type": "Rayon"
    },
    {
      "code": "AZ-IMI",
      "name": "İmişli",
      "type": "Rayon"
    },
    {
      "code": "AZ-ISM",
      "name": "İsmayıllı",
      "type": "Rayon"
    },
    {
      "code": "AZ-KAL",
      "name": "Kəlbəcər",
      "type": "Rayon"
    },
    {
      "code": "AZ-KAN",
      "name": "Kǝngǝrli",
      "parent": "NX",
      "type": "Rayon"
    },
    {
      "code": "AZ-KUR",
      "name": "Kürdəmir",
      "type": "Rayon"
    },
    {
      "code": "AZ-LA",
      "name": "Lənkəran",
      "type": "Municipality"
    },
    {
      "code": "AZ-LAC",
      "name": "Laçın",
      "type": "Rayon"
    },
    {
      "code": "AZ-LAN",
      "name": "Lənkəran",
      "type": "Rayon"
    },
    {
      "code": "AZ-LER",
      "name": "Lerik",
      "type": "Rayon"
    },
    {
      "code": "AZ-MAS",
      "name": "Masallı",
      "type": "Rayon"
    },
    {
      "code": "AZ-MI",
      "name": "Mingəçevir",
      "type": "Municipality"
    },
    {
      "code": "AZ-NA",
      "name": "Naftalan",
      "type": "Municipality"
    },
    {
      "code": "AZ-NEF",
      "name": "Neftçala",
      "type": "Rayon"
    },
    {
      "code": "AZ-NV",
      "name": "Naxçıvan",
      "parent": "NX",
      "type": "Municipality"
    },
    {
      "code": "AZ-NX",
      "name": "Naxçıvan",
      "type": "Autonomous republic"
    },
    {
      "code": "AZ-OGU",
      "name": "Oğuz",
      "type": "Rayon"
    },
    {
      "code": "AZ-ORD",
      "name": "Ordubad",
      "parent": "NX",
      "type": "Rayon"
    },
    {
      "code": "AZ-QAB",
      "name": "Qəbələ",
      "type": "Rayon"
    },
    {
      "code": "AZ-QAX",
      "name": "Qax",
      "type": "Rayon"
    },
    {
      "code": "AZ-QAZ",
      "name": "Qazax",
      "type": "Rayon"
    },
    {
      "code": "AZ-QBA",
      "name": "Quba",
      "type": "Rayon"
    },
    {
      "code": "AZ-QBI",
      "name": "Qubadlı",
      "type": "Rayon"
    },
    {
      "code": "AZ-QOB",
      "name": "Qobustan",
      "type": "Rayon"
    },
    {
      "code": "AZ-QUS",
      "name": "Qusar",
      "type": "Rayon"
    },
    {
      "code": "AZ-SA",
      "name": "Şəki",
      "type": "Municipality"
    },
    {
      "code": "AZ-SAB",
      "name": "Sabirabad",
      "type": "Rayon"
    },
    {
      "code": "AZ-SAD",
      "name": "Sədərək",
      "parent": "NX",
      "type": "Rayon"
    },
    {
      "code": "AZ-SAH",
      "name": "Şahbuz",
      "parent": "NX",
      "type": "Rayon"
    },
    {
      "code": "AZ-SAK",
      "name": "Şəki",
      "type": "Rayon"
    },
    {
      "code": "AZ-SAL",
      "name": "Salyan",
      "type": "Rayon"
    },
    {
      "code": "AZ-SAR",
      "name": "Şərur",
      "parent": "NX",
      "type": "Rayon"
    },
    {
      "code": "AZ-SAT",
      "name": "Saatlı",
      "type": "Rayon"
    },
    {
      "code": "AZ-SBN",
      "name": "Şabran",
      "type": "Rayon"
    },
    {
      "code": "AZ-SIY",
      "name": "Siyəzən",
      "type": "Rayon"
    },
    {
      "code": "AZ-SKR",
      "name": "Şəmkir",
      "type": "Rayon"
    },
    {
      "code": "AZ-SM",
      "name": "Sumqayıt",
      "type": "Municipality"
    },
    {
      "code": "AZ-SMI",
      "name": "Şamaxı",
      "type": "Rayon"
    },
    {
      "code": "AZ-SMX",
      "name": "Samux",
      "type": "Rayon"
    },
    {
      "code": "AZ-SR",
      "name": "Şirvan",
      "type": "Municipality"
    },
    {
      "code": "AZ-SUS",
      "name": "Şuşa",
      "type": "Rayon"
    },
    {
      "code": "AZ-TAR",
      "name": "Tərtər",
      "type": "Rayon"
    },
    {
      "code": "AZ-TOV",
      "name": "Tovuz",
      "type": "Rayon"
    },
    {
      "code": "AZ-UCA",
      "name": "Ucar",
      "type": "Rayon"
    },
    {
      "code": "AZ-XA",
      "name": "Xankəndi",
      "type": "Municipality"
    },
    {
      "code": "AZ-XAC",
      "name": "Xaçmaz",
      "type": "Rayon"
    },
    {
      "code": "AZ-XCI",
      "name": "Xocalı",
      "type": "Rayon"
    },
    {
      "code": "AZ-XIZ",
      "name": "Xızı",
      "type": "Rayon"
    },
    {
      "code": "AZ-XVD",
      "name": "Xocavənd",
      "type": "Rayon"
    },
    {
      "code": "AZ-YAR",
      "name": "Yardımlı",
      "type": "Rayon"
    },
    {
      "code": "AZ-YE",
      "name": "Yevlax",
      "type": "Municipality"
    },
    {
      "code": "AZ-YEV",
      "name": "Yevlax",
      "type": "Rayon"
    },
    {
      "code": "AZ-ZAN",
      "name": "Zəngilan",
      "type": "Rayon"
    },
    {
      "code": "AZ-ZAQ",
      "name": "Zaqatala",
      "type": "Rayon"
    },
    {
      "code": "AZ-ZAR",
      "name": "Zərdab",
      "type": "Rayon"
    },
    {
      "code": "BA-01",
      "name": "Unsko-sanski kanton",
      "parent": "BIH",
      "type": "Canton"
    },
    {
      "code": "BA-02",
      "name": "Posavski kanton",
      "parent": "BIH",
      "type": "Canton"
    },
    {
      "code": "BA-03",
      "name": "Tuzlanski kanton",
      "parent": "BIH",
      "type": "Canton"
    },
    {
      "code": "BA-04",
      "name": "Zeničko-dobojski kanton",
      "parent": "BIH",
      "type": "Canton"
    },
    {
      "code": "BA-05",
      "name": "Bosansko-podrinjski kanton",
      "parent": "BIH",
      "type": "Canton"
    },
    {
      "code": "BA-06",
      "name": "Srednjobosanski kanton",
      "parent": "BIH",
      "type": "Canton"
    },
    {
      "code": "BA-07",
      "name": "Hercegovačko-neretvanski kanton",
      "parent": "BIH",
      "type": "Canton"
    },
    {
      "code": "BA-08",
      "name": "Zapadnohercegovački kanton",
      "parent": "BIH",
      "type": "Canton"
    },
    {
      "code": "BA-09",
      "name": "Kanton Sarajevo",
      "parent": "BIH",
      "type": "Canton"
    },
    {
      "code": "BA-10",
      "name": "Kanton br. 10 (Livanjski kanton)",
      "parent": "BIH",
      "type": "Canton"
    },
    {
      "code": "BA-BIH",
      "name": "Federacija Bosne i Hercegovine",
      "type": "Entity"
    },
    {
      "code": "BA-BRC",
      "name": "Brčko distrikt",
      "type": "District"
    },
    {
      "code": "BA-SRP",
      "name": "Republika Srpska",
      "type": "Entity"
    },
    {
      "code": "BB-01",
      "name": "Christ Church",
      "type": "Parish"
    },
    {
      "code": "BB-02",
      "name": "Saint Andrew",
      "type": "Parish"
    },
    {
      "code": "BB-03",
      "name": "Saint George",
      "type": "Parish"
    },
    {
      "code": "BB-04",
      "name": "Saint James",
      "type": "Parish"
    },
    {
      "code": "BB-05",
      "name": "Saint John",
      "type": "Parish"
    },
    {
      "code": "BB-06",
      "name": "Saint Joseph",
      "type": "Parish"
    },
    {
      "code": "BB-07",
      "name": "Saint Lucy",
      "type": "Parish"
    },
    {
      "code": "BB-08",
      "name": "Saint Michael",
      "type": "Parish"
    },
    {
      "code": "BB-09",
      "name": "Saint Peter",
      "type": "Parish"
    },
    {
      "code": "BB-10",
      "name": "Saint Philip",
      "type": "Parish"
    },
    {
      "code": "BB-11",
      "name": "Saint Thomas",
      "type": "Parish"
    },
    {
      "code": "BD-01",
      "name": "Bandarban",
      "parent": "B",
      "type": "District"
    },
    {
      "code": "BD-02",
      "name": "Barguna",
      "parent": "A",
      "type": "District"
    },
    {
      "code": "BD-03",
      "name": "Bogra",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "BD-04",
      "name": "Brahmanbaria",
      "parent": "B",
      "type": "District"
    },
    {
      "code": "BD-05",
      "name": "Bagerhat",
      "parent": "D",
      "type": "District"
    },
    {
      "code": "BD-06",
      "name": "Barisal",
      "parent": "A",
      "type": "District"
    },
    {
      "code": "BD-07",
      "name": "Bhola",
      "parent": "A",
      "type": "District"
    },
    {
      "code": "BD-08",
      "name": "Comilla",
      "parent": "B",
      "type": "District"
    },
    {
      "code": "BD-09",
      "name": "Chandpur",
      "parent": "B",
      "type": "District"
    },
    {
      "code": "BD-10",
      "name": "Chittagong",
      "parent": "B",
      "type": "District"
    },
    {
      "code": "BD-11",
      "name": "Cox's Bazar",
      "parent": "B",
      "type": "District"
    },
    {
      "code": "BD-12",
      "name": "Chuadanga",
      "parent": "D",
      "type": "District"
    },
    {
      "code": "BD-13",
      "name": "Dhaka",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "BD-14",
      "name": "Dinajpur",
      "parent": "F",
      "type": "District"
    },
    {
      "code": "BD-15",
      "name": "Faridpur",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "BD-16",
      "name": "Feni",
      "parent": "B",
      "type": "District"
    },
    {
      "code": "BD-17",
      "name": "Gopalganj",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "BD-18",
      "name": "Gazipur",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "BD-19",
      "name": "Gaibandha",
      "parent": "F",
      "type": "District"
    },
    {
      "code": "BD-20",
      "name": "Habiganj",
      "parent": "G",
      "type": "District"
    },
    {
      "code": "BD-21",
      "name": "Jamalpur",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "BD-22",
      "name": "Jessore",
      "parent": "D",
      "type": "District"
    },
    {
      "code": "BD-23",
      "name": "Jhenaidah",
      "parent": "D",
      "type": "District"
    },
    {
      "code": "BD-24",
      "name": "Jaipurhat",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "BD-25",
      "name": "Jhalakati",
      "parent": "A",
      "type": "District"
    },
    {
      "code": "BD-26",
      "name": "Kishorganj",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "BD-27",
      "name": "Khulna",
      "parent": "D",
      "type": "District"
    },
    {
      "code": "BD-28",
      "name": "Kurigram",
      "parent": "F",
      "type": "District"
    },
    {
      "code": "BD-29",
      "name": "Khagrachari",
      "parent": "B",
      "type": "District"
    },
    {
      "code": "BD-30",
      "name": "Kushtia",
      "parent": "D",
      "type": "District"
    },
    {
      "code": "BD-31",
      "name": "Lakshmipur",
      "parent": "B",
      "type": "District"
    },
    {
      "code": "BD-32",
      "name": "Lalmonirhat",
      "parent": "F",
      "type": "District"
    },
    {
      "code": "BD-33",
      "name": "Manikganj",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "BD-34",
      "name": "Mymensingh",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "BD-35",
      "name": "Munshiganj",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "BD-36",
      "name": "Madaripur",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "BD-37",
      "name": "Magura",
      "parent": "D",
      "type": "District"
    },
    {
      "code": "BD-38",
      "name": "Moulvibazar",
      "parent": "G",
      "type": "District"
    },
    {
      "code": "BD-39",
      "name": "Meherpur",
      "parent": "D",
      "type": "District"
    },
    {
      "code": "BD-40",
      "name": "Narayanganj",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "BD-41",
      "name": "Netrakona",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "BD-42",
      "name": "Narsingdi",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "BD-43",
      "name": "Narail",
      "parent": "D",
      "type": "District"
    },
    {
      "code": "BD-44",
      "name": "Natore",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "BD-45",
      "name": "Nawabganj",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "BD-46",
      "name": "Nilphamari",
      "parent": "F",
      "type": "District"
    },
    {
      "code": "BD-47",
      "name": "Noakhali",
      "parent": "B",
      "type": "District"
    },
    {
      "code": "BD-48",
      "name": "Naogaon",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "BD-49",
      "name": "Pabna",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "BD-50",
      "name": "Pirojpur",
      "parent": "A",
      "type": "District"
    },
    {
      "code": "BD-51",
      "name": "Patuakhali",
      "parent": "A",
      "type": "District"
    },
    {
      "code": "BD-52",
      "name": "Panchagarh",
      "parent": "F",
      "type": "District"
    },
    {
      "code": "BD-53",
      "name": "Rajbari",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "BD-54",
      "name": "Rajshahi",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "BD-55",
      "name": "Rangpur",
      "parent": "F",
      "type": "District"
    },
    {
      "code": "BD-56",
      "name": "Rangamati",
      "parent": "B",
      "type": "District"
    },
    {
      "code": "BD-57",
      "name": "Sherpur",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "BD-58",
      "name": "Satkhira",
      "parent": "D",
      "type": "District"
    },
    {
      "code": "BD-59",
      "name": "Sirajganj",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "BD-60",
      "name": "Sylhet",
      "parent": "G",
      "type": "District"
    },
    {
      "code": "BD-61",
      "name": "Sunamganj",
      "parent": "G",
      "type": "District"
    },
    {
      "code": "BD-62",
      "name": "Shariatpur",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "BD-63",
      "name": "Tangail",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "BD-64",
      "name": "Thakurgaon",
      "parent": "F",
      "type": "District"
    },
    {
      "code": "BD-A",
      "name": "Barisal",
      "type": "Division"
    },
    {
      "code": "BD-B",
      "name": "Chittagong",
      "type": "Division"
    },
    {
      "code": "BD-C",
      "name": "Dhaka",
      "type": "Division"
    },
    {
      "code": "BD-D",
      "name": "Khulna",
      "type": "Division"
    },
    {
      "code": "BD-E",
      "name": "Rajshahi",
      "type": "Division"
    },
    {
      "code": "BD-F",
      "name": "Rangpur",
      "type": "Division"
    },
    {
      "code": "BD-G",
      "name": "Sylhet",
      "type": "Division"
    },
    {
      "code": "BE-BRU",
      "name": "Bruxelles-Capitale, Région de;Brussels Hoofdstedelijk Gewest",
      "type": "Region"
    },
    {
      "code": "BE-VAN",
      "name": "Antwerpen",
      "parent": "VLG",
      "type": "Province"
    },
    {
      "code": "BE-VBR",
      "name": "Vlaams-Brabant",
      "parent": "VLG",
      "type": "Province"
    },
    {
      "code": "BE-VLG",
      "name": "Vlaams Gewest",
      "type": "Region"
    },
    {
      "code": "BE-VLI",
      "name": "Limburg",
      "parent": "VLG",
      "type": "Province"
    },
    {
      "code": "BE-VOV",
      "name": "Oost-Vlaanderen",
      "parent": "VLG",
      "type": "Province"
    },
    {
      "code": "BE-VWV",
      "name": "West-Vlaanderen",
      "parent": "VLG",
      "type": "Province"
    },
    {
      "code": "BE-WAL",
      "name": "wallonne, Région",
      "type": "Region"
    },
    {
      "code": "BE-WBR",
      "name": "Brabant wallon",
      "parent": "WAL",
      "type": "Province"
    },
    {
      "code": "BE-WHT",
      "name": "Hainaut",
      "parent": "WAL",
      "type": "Province"
    },
    {
      "code": "BE-WLG",
      "name": "Liège",
      "parent": "WAL",
      "type": "Province"
    },
    {
      "code": "BE-WLX",
      "name": "Luxembourg",
      "parent": "WAL",
      "type": "Province"
    },
    {
      "code": "BE-WNA",
      "name": "Namur",
      "parent": "WAL",
      "type": "Province"
    },
    {
      "code": "BF-01",
      "name": "Boucle du Mouhoun",
      "type": "Region"
    },
    {
      "code": "BF-02",
      "name": "Cascades",
      "type": "Region"
    },
    {
      "code": "BF-03",
      "name": "Centre",
      "type": "Region"
    },
    {
      "code": "BF-04",
      "name": "Centre-Est",
      "type": "Region"
    },
    {
      "code": "BF-05",
      "name": "Centre-Nord",
      "type": "Region"
    },
    {
      "code": "BF-06",
      "name": "Centre-Ouest",
      "type": "Region"
    },
    {
      "code": "BF-07",
      "name": "Centre-Sud",
      "type": "Region"
    },
    {
      "code": "BF-08",
      "name": "Est",
      "type": "Region"
    },
    {
      "code": "BF-09",
      "name": "Hauts-Bassins",
      "type": "Region"
    },
    {
      "code": "BF-10",
      "name": "Nord",
      "type": "Region"
    },
    {
      "code": "BF-11",
      "name": "Plateau-Central",
      "type": "Region"
    },
    {
      "code": "BF-12",
      "name": "Sahel",
      "type": "Region"
    },
    {
      "code": "BF-13",
      "name": "Sud-Ouest",
      "type": "Region"
    },
    {
      "code": "BF-BAL",
      "name": "Balé",
      "parent": "01",
      "type": "Province"
    },
    {
      "code": "BF-BAM",
      "name": "Bam",
      "parent": "05",
      "type": "Province"
    },
    {
      "code": "BF-BAN",
      "name": "Banwa",
      "parent": "01",
      "type": "Province"
    },
    {
      "code": "BF-BAZ",
      "name": "Bazèga",
      "parent": "07",
      "type": "Province"
    },
    {
      "code": "BF-BGR",
      "name": "Bougouriba",
      "parent": "13",
      "type": "Province"
    },
    {
      "code": "BF-BLG",
      "name": "Boulgou",
      "parent": "04",
      "type": "Province"
    },
    {
      "code": "BF-BLK",
      "name": "Boulkiemdé",
      "parent": "06",
      "type": "Province"
    },
    {
      "code": "BF-COM",
      "name": "Comoé",
      "parent": "02",
      "type": "Province"
    },
    {
      "code": "BF-GAN",
      "name": "Ganzourgou",
      "parent": "11",
      "type": "Province"
    },
    {
      "code": "BF-GNA",
      "name": "Gnagna",
      "parent": "08",
      "type": "Province"
    },
    {
      "code": "BF-GOU",
      "name": "Gourma",
      "parent": "08",
      "type": "Province"
    },
    {
      "code": "BF-HOU",
      "name": "Houet",
      "parent": "09",
      "type": "Province"
    },
    {
      "code": "BF-IOB",
      "name": "Ioba",
      "parent": "13",
      "type": "Province"
    },
    {
      "code": "BF-KAD",
      "name": "Kadiogo",
      "parent": "03",
      "type": "Province"
    },
    {
      "code": "BF-KEN",
      "name": "Kénédougou",
      "parent": "09",
      "type": "Province"
    },
    {
      "code": "BF-KMD",
      "name": "Komondjari",
      "parent": "08",
      "type": "Province"
    },
    {
      "code": "BF-KMP",
      "name": "Kompienga",
      "parent": "08",
      "type": "Province"
    },
    {
      "code": "BF-KOP",
      "name": "Koulpélogo",
      "parent": "04",
      "type": "Province"
    },
    {
      "code": "BF-KOS",
      "name": "Kossi",
      "parent": "01",
      "type": "Province"
    },
    {
      "code": "BF-KOT",
      "name": "Kouritenga",
      "parent": "04",
      "type": "Province"
    },
    {
      "code": "BF-KOW",
      "name": "Kourwéogo",
      "parent": "11",
      "type": "Province"
    },
    {
      "code": "BF-LER",
      "name": "Léraba",
      "parent": "02",
      "type": "Province"
    },
    {
      "code": "BF-LOR",
      "name": "Loroum",
      "parent": "10",
      "type": "Province"
    },
    {
      "code": "BF-MOU",
      "name": "Mouhoun",
      "parent": "01",
      "type": "Province"
    },
    {
      "code": "BF-NAM",
      "name": "Namentenga",
      "parent": "05",
      "type": "Province"
    },
    {
      "code": "BF-NAO",
      "name": "Naouri",
      "parent": "07",
      "type": "Province"
    },
    {
      "code": "BF-NAY",
      "name": "Nayala",
      "parent": "01",
      "type": "Province"
    },
    {
      "code": "BF-NOU",
      "name": "Noumbiel",
      "parent": "13",
      "type": "Province"
    },
    {
      "code": "BF-OUB",
      "name": "Oubritenga",
      "parent": "11",
      "type": "Province"
    },
    {
      "code": "BF-OUD",
      "name": "Oudalan",
      "parent": "12",
      "type": "Province"
    },
    {
      "code": "BF-PAS",
      "name": "Passoré",
      "parent": "10",
      "type": "Province"
    },
    {
      "code": "BF-PON",
      "name": "Poni",
      "parent": "13",
      "type": "Province"
    },
    {
      "code": "BF-SEN",
      "name": "Séno",
      "parent": "12",
      "type": "Province"
    },
    {
      "code": "BF-SIS",
      "name": "Sissili",
      "parent": "06",
      "type": "Province"
    },
    {
      "code": "BF-SMT",
      "name": "Sanmatenga",
      "parent": "05",
      "type": "Province"
    },
    {
      "code": "BF-SNG",
      "name": "Sanguié",
      "parent": "06",
      "type": "Province"
    },
    {
      "code": "BF-SOM",
      "name": "Soum",
      "parent": "12",
      "type": "Province"
    },
    {
      "code": "BF-SOR",
      "name": "Sourou",
      "parent": "01",
      "type": "Province"
    },
    {
      "code": "BF-TAP",
      "name": "Tapoa",
      "parent": "08",
      "type": "Province"
    },
    {
      "code": "BF-TUI",
      "name": "Tui",
      "parent": "09",
      "type": "Province"
    },
    {
      "code": "BF-YAG",
      "name": "Yagha",
      "parent": "12",
      "type": "Province"
    },
    {
      "code": "BF-YAT",
      "name": "Yatenga",
      "parent": "10",
      "type": "Province"
    },
    {
      "code": "BF-ZIR",
      "name": "Ziro",
      "parent": "06",
      "type": "Province"
    },
    {
      "code": "BF-ZON",
      "name": "Zondoma",
      "parent": "10",
      "type": "Province"
    },
    {
      "code": "BF-ZOU",
      "name": "Zoundwéogo",
      "parent": "07",
      "type": "Province"
    },
    {
      "code": "BG-01",
      "name": "Blagoevgrad",
      "type": "Region"
    },
    {
      "code": "BG-02",
      "name": "Burgas",
      "type": "Region"
    },
    {
      "code": "BG-03",
      "name": "Varna",
      "type": "Region"
    },
    {
      "code": "BG-04",
      "name": "Veliko Tarnovo",
      "type": "Region"
    },
    {
      "code": "BG-05",
      "name": "Vidin",
      "type": "Region"
    },
    {
      "code": "BG-06",
      "name": "Vratsa",
      "type": "Region"
    },
    {
      "code": "BG-07",
      "name": "Gabrovo",
      "type": "Region"
    },
    {
      "code": "BG-08",
      "name": "Dobrich",
      "type": "Region"
    },
    {
      "code": "BG-09",
      "name": "Kardzhali",
      "type": "Region"
    },
    {
      "code": "BG-10",
      "name": "Kyustendil",
      "type": "Region"
    },
    {
      "code": "BG-11",
      "name": "Lovech",
      "type": "Region"
    },
    {
      "code": "BG-12",
      "name": "Montana",
      "type": "Region"
    },
    {
      "code": "BG-13",
      "name": "Pazardzhik",
      "type": "Region"
    },
    {
      "code": "BG-14",
      "name": "Pernik",
      "type": "Region"
    },
    {
      "code": "BG-15",
      "name": "Pleven",
      "type": "Region"
    },
    {
      "code": "BG-16",
      "name": "Plovdiv",
      "type": "Region"
    },
    {
      "code": "BG-17",
      "name": "Razgrad",
      "type": "Region"
    },
    {
      "code": "BG-18",
      "name": "Ruse",
      "type": "Region"
    },
    {
      "code": "BG-19",
      "name": "Silistra",
      "type": "Region"
    },
    {
      "code": "BG-20",
      "name": "Sliven",
      "type": "Region"
    },
    {
      "code": "BG-21",
      "name": "Smolyan",
      "type": "Region"
    },
    {
      "code": "BG-22",
      "name": "Sofia-Grad",
      "type": "Region"
    },
    {
      "code": "BG-23",
      "name": "Sofia",
      "type": "Region"
    },
    {
      "code": "BG-24",
      "name": "Stara Zagora",
      "type": "Region"
    },
    {
      "code": "BG-25",
      "name": "Targovishte",
      "type": "Region"
    },
    {
      "code": "BG-26",
      "name": "Haskovo",
      "type": "Region"
    },
    {
      "code": "BG-27",
      "name": "Shumen",
      "type": "Region"
    },
    {
      "code": "BG-28",
      "name": "Yambol",
      "type": "Region"
    },
    {
      "code": "BH-13",
      "name": "Al Manāmah (Al ‘Āşimah)",
      "type": "Governorate"
    },
    {
      "code": "BH-14",
      "name": "Al Janūbīyah",
      "type": "Governorate"
    },
    {
      "code": "BH-15",
      "name": "Al Muḩarraq",
      "type": "Governorate"
    },
    {
      "code": "BH-16",
      "name": "Al Wusţá",
      "type": "Governorate"
    },
    {
      "code": "BH-17",
      "name": "Ash Shamālīyah",
      "type": "Governorate"
    },
    {
      "code": "BI-BB",
      "name": "Bubanza",
      "type": "Province"
    },
    {
      "code": "BI-BL",
      "name": "Bujumbura Rural",
      "type": "Province"
    },
    {
      "code": "BI-BM",
      "name": "Bujumbura Mairie",
      "type": "Province"
    },
    {
      "code": "BI-BR",
      "name": "Bururi",
      "type": "Province"
    },
    {
      "code": "BI-CA",
      "name": "Cankuzo",
      "type": "Province"
    },
    {
      "code": "BI-CI",
      "name": "Cibitoke",
      "type": "Province"
    },
    {
      "code": "BI-GI",
      "name": "Gitega",
      "type": "Province"
    },
    {
      "code": "BI-KI",
      "name": "Kirundo",
      "type": "Province"
    },
    {
      "code": "BI-KR",
      "name": "Karuzi",
      "type": "Province"
    },
    {
      "code": "BI-KY",
      "name": "Kayanza",
      "type": "Province"
    },
    {
      "code": "BI-MA",
      "name": "Makamba",
      "type": "Province"
    },
    {
      "code": "BI-MU",
      "name": "Muramvya",
      "type": "Province"
    },
    {
      "code": "BI-MW",
      "name": "Mwaro",
      "type": "Province"
    },
    {
      "code": "BI-NG",
      "name": "Ngozi",
      "type": "Province"
    },
    {
      "code": "BI-RT",
      "name": "Rutana",
      "type": "Province"
    },
    {
      "code": "BI-RY",
      "name": "Ruyigi",
      "type": "Province"
    },
    {
      "code": "BJ-AK",
      "name": "Atakora",
      "type": "Department"
    },
    {
      "code": "BJ-AL",
      "name": "Alibori",
      "type": "Department"
    },
    {
      "code": "BJ-AQ",
      "name": "Atlantique",
      "type": "Department"
    },
    {
      "code": "BJ-BO",
      "name": "Borgou",
      "type": "Department"
    },
    {
      "code": "BJ-CO",
      "name": "Collines",
      "type": "Department"
    },
    {
      "code": "BJ-DO",
      "name": "Donga",
      "type": "Department"
    },
    {
      "code": "BJ-KO",
      "name": "Kouffo",
      "type": "Department"
    },
    {
      "code": "BJ-LI",
      "name": "Littoral",
      "type": "Department"
    },
    {
      "code": "BJ-MO",
      "name": "Mono",
      "type": "Department"
    },
    {
      "code": "BJ-OU",
      "name": "Ouémé",
      "type": "Department"
    },
    {
      "code": "BJ-PL",
      "name": "Plateau",
      "type": "Department"
    },
    {
      "code": "BJ-ZO",
      "name": "Zou",
      "type": "Department"
    },
    {
      "code": "BN-BE",
      "name": "Belait",
      "type": "District"
    },
    {
      "code": "BN-BM",
      "name": "Brunei-Muara",
      "type": "District"
    },
    {
      "code": "BN-TE",
      "name": "Temburong",
      "type": "District"
    },
    {
      "code": "BN-TU",
      "name": "Tutong",
      "type": "District"
    },
    {
      "code": "BO-B",
      "name": "El Beni",
      "type": "Department"
    },
    {
      "code": "BO-C",
      "name": "Cochabamba",
      "type": "Department"
    },
    {
      "code": "BO-H",
      "name": "Chuquisaca",
      "type": "Department"
    },
    {
      "code": "BO-L",
      "name": "La Paz",
      "type": "Department"
    },
    {
      "code": "BO-N",
      "name": "Pando",
      "type": "Department"
    },
    {
      "code": "BO-O",
      "name": "Oruro",
      "type": "Department"
    },
    {
      "code": "BO-P",
      "name": "Potosí",
      "type": "Department"
    },
    {
      "code": "BO-S",
      "name": "Santa Cruz",
      "type": "Department"
    },
    {
      "code": "BO-T",
      "name": "Tarija",
      "type": "Department"
    },
    {
      "code": "BQ-BO",
      "name": "Bonaire",
      "type": "Special municipality"
    },
    {
      "code": "BQ-SA",
      "name": "Saba",
      "type": "Special municipality"
    },
    {
      "code": "BQ-SE",
      "name": "Sint Eustatius",
      "type": "Special municipality"
    },
    {
      "code": "BR-AC",
      "name": "Acre",
      "type": "State"
    },
    {
      "code": "BR-AL",
      "name": "Alagoas",
      "type": "State"
    },
    {
      "code": "BR-AM",
      "name": "Amazonas",
      "type": "State"
    },
    {
      "code": "BR-AP",
      "name": "Amapá",
      "type": "State"
    },
    {
      "code": "BR-BA",
      "name": "Bahia",
      "type": "State"
    },
    {
      "code": "BR-CE",
      "name": "Ceará",
      "type": "State"
    },
    {
      "code": "BR-DF",
      "name": "Distrito Federal",
      "type": "Federal District"
    },
    {
      "code": "BR-ES",
      "name": "Espírito Santo",
      "type": "State"
    },
    {
      "code": "BR-FN",
      "name": "Fernando de Noronha",
      "type": "State"
    },
    {
      "code": "BR-GO",
      "name": "Goiás",
      "type": "State"
    },
    {
      "code": "BR-MA",
      "name": "Maranhão",
      "type": "State"
    },
    {
      "code": "BR-MG",
      "name": "Minas Gerais",
      "type": "State"
    },
    {
      "code": "BR-MS",
      "name": "Mato Grosso do Sul",
      "type": "State"
    },
    {
      "code": "BR-MT",
      "name": "Mato Grosso",
      "type": "State"
    },
    {
      "code": "BR-PA",
      "name": "Pará",
      "type": "State"
    },
    {
      "code": "BR-PB",
      "name": "Paraíba",
      "type": "State"
    },
    {
      "code": "BR-PE",
      "name": "Pernambuco",
      "type": "State"
    },
    {
      "code": "BR-PI",
      "name": "Piauí",
      "type": "State"
    },
    {
      "code": "BR-PR",
      "name": "Paraná",
      "type": "State"
    },
    {
      "code": "BR-RJ",
      "name": "Rio de Janeiro",
      "type": "State"
    },
    {
      "code": "BR-RN",
      "name": "Rio Grande do Norte",
      "type": "State"
    },
    {
      "code": "BR-RO",
      "name": "Rondônia",
      "type": "State"
    },
    {
      "code": "BR-RR",
      "name": "Roraima",
      "type": "State"
    },
    {
      "code": "BR-RS",
      "name": "Rio Grande do Sul",
      "type": "State"
    },
    {
      "code": "BR-SC",
      "name": "Santa Catarina",
      "type": "State"
    },
    {
      "code": "BR-SE",
      "name": "Sergipe",
      "type": "State"
    },
    {
      "code": "BR-SP",
      "name": "São Paulo",
      "type": "State"
    },
    {
      "code": "BR-TO",
      "name": "Tocantins",
      "type": "State"
    },
    {
      "code": "BS-AK",
      "name": "Acklins",
      "type": "District"
    },
    {
      "code": "BS-BI",
      "name": "Bimini",
      "type": "District"
    },
    {
      "code": "BS-BP",
      "name": "Black Point",
      "type": "District"
    },
    {
      "code": "BS-BY",
      "name": "Berry Islands",
      "type": "District"
    },
    {
      "code": "BS-CE",
      "name": "Central Eleuthera",
      "type": "District"
    },
    {
      "code": "BS-CI",
      "name": "Cat Island",
      "type": "District"
    },
    {
      "code": "BS-CK",
      "name": "Crooked Island and Long Cay",
      "type": "District"
    },
    {
      "code": "BS-CO",
      "name": "Central Abaco",
      "type": "District"
    },
    {
      "code": "BS-CS",
      "name": "Central Andros",
      "type": "District"
    },
    {
      "code": "BS-EG",
      "name": "East Grand Bahama",
      "type": "District"
    },
    {
      "code": "BS-EX",
      "name": "Exuma",
      "type": "District"
    },
    {
      "code": "BS-FP",
      "name": "City of Freeport",
      "type": "District"
    },
    {
      "code": "BS-GC",
      "name": "Grand Cay",
      "type": "District"
    },
    {
      "code": "BS-HI",
      "name": "Harbour Island",
      "type": "District"
    },
    {
      "code": "BS-HT",
      "name": "Hope Town",
      "type": "District"
    },
    {
      "code": "BS-IN",
      "name": "Inagua",
      "type": "District"
    },
    {
      "code": "BS-LI",
      "name": "Long Island",
      "type": "District"
    },
    {
      "code": "BS-MC",
      "name": "Mangrove Cay",
      "type": "District"
    },
    {
      "code": "BS-MG",
      "name": "Mayaguana",
      "type": "District"
    },
    {
      "code": "BS-MI",
      "name": "Moore's Island",
      "type": "District"
    },
    {
      "code": "BS-NE",
      "name": "North Eleuthera",
      "type": "District"
    },
    {
      "code": "BS-NO",
      "name": "North Abaco",
      "type": "District"
    },
    {
      "code": "BS-NS",
      "name": "North Andros",
      "type": "District"
    },
    {
      "code": "BS-RC",
      "name": "Rum Cay",
      "type": "District"
    },
    {
      "code": "BS-RI",
      "name": "Ragged Island",
      "type": "District"
    },
    {
      "code": "BS-SA",
      "name": "South Andros",
      "type": "District"
    },
    {
      "code": "BS-SE",
      "name": "South Eleuthera",
      "type": "District"
    },
    {
      "code": "BS-SO",
      "name": "South Abaco",
      "type": "District"
    },
    {
      "code": "BS-SS",
      "name": "San Salvador",
      "type": "District"
    },
    {
      "code": "BS-SW",
      "name": "Spanish Wells",
      "type": "District"
    },
    {
      "code": "BS-WG",
      "name": "West Grand Bahama",
      "type": "District"
    },
    {
      "code": "BT-11",
      "name": "Paro",
      "type": "District"
    },
    {
      "code": "BT-12",
      "name": "Chhukha",
      "type": "District"
    },
    {
      "code": "BT-13",
      "name": "Ha",
      "type": "District"
    },
    {
      "code": "BT-14",
      "name": "Samtee",
      "type": "District"
    },
    {
      "code": "BT-15",
      "name": "Thimphu",
      "type": "District"
    },
    {
      "code": "BT-21",
      "name": "Tsirang",
      "type": "District"
    },
    {
      "code": "BT-22",
      "name": "Dagana",
      "type": "District"
    },
    {
      "code": "BT-23",
      "name": "Punakha",
      "type": "District"
    },
    {
      "code": "BT-24",
      "name": "Wangdue Phodrang",
      "type": "District"
    },
    {
      "code": "BT-31",
      "name": "Sarpang",
      "type": "District"
    },
    {
      "code": "BT-32",
      "name": "Trongsa",
      "type": "District"
    },
    {
      "code": "BT-33",
      "name": "Bumthang",
      "type": "District"
    },
    {
      "code": "BT-34",
      "name": "Zhemgang",
      "type": "District"
    },
    {
      "code": "BT-41",
      "name": "Trashigang",
      "type": "District"
    },
    {
      "code": "BT-42",
      "name": "Monggar",
      "type": "District"
    },
    {
      "code": "BT-43",
      "name": "Pemagatshel",
      "type": "District"
    },
    {
      "code": "BT-44",
      "name": "Lhuentse",
      "type": "District"
    },
    {
      "code": "BT-45",
      "name": "Samdrup Jongkha",
      "type": "District"
    },
    {
      "code": "BT-GA",
      "name": "Gasa",
      "type": "District"
    },
    {
      "code": "BT-TY",
      "name": "Trashi Yangtse",
      "type": "District"
    },
    {
      "code": "BW-CE",
      "name": "Central",
      "type": "District"
    },
    {
      "code": "BW-GH",
      "name": "Ghanzi",
      "type": "District"
    },
    {
      "code": "BW-KG",
      "name": "Kgalagadi",
      "type": "District"
    },
    {
      "code": "BW-KL",
      "name": "Kgatleng",
      "type": "District"
    },
    {
      "code": "BW-KW",
      "name": "Kweneng",
      "type": "District"
    },
    {
      "code": "BW-NE",
      "name": "North-East",
      "type": "District"
    },
    {
      "code": "BW-NW",
      "name": "North-West",
      "type": "District"
    },
    {
      "code": "BW-SE",
      "name": "South-East",
      "type": "District"
    },
    {
      "code": "BW-SO",
      "name": "Southern",
      "type": "District"
    },
    {
      "code": "BY-BR",
      "name": "Brèsckaja voblasc'",
      "type": "Oblast"
    },
    {
      "code": "BY-HM",
      "name": "Horad Minsk",
      "type": "City"
    },
    {
      "code": "BY-HO",
      "name": "Homel'skaja voblasc'",
      "type": "Oblast"
    },
    {
      "code": "BY-HR",
      "name": "Hrodzenskaja voblasc'",
      "type": "Oblast"
    },
    {
      "code": "BY-MA",
      "name": "Mahilëuskaja voblasc'",
      "type": "Oblast"
    },
    {
      "code": "BY-MI",
      "name": "Minskaja voblasc'",
      "type": "Oblast"
    },
    {
      "code": "BY-VI",
      "name": "Vicebskaja voblasc'",
      "type": "Oblast"
    },
    {
      "code": "BZ-BZ",
      "name": "Belize",
      "type": "District"
    },
    {
      "code": "BZ-CY",
      "name": "Cayo",
      "type": "District"
    },
    {
      "code": "BZ-CZL",
      "name": "Corozal",
      "type": "District"
    },
    {
      "code": "BZ-OW",
      "name": "Orange Walk",
      "type": "District"
    },
    {
      "code": "BZ-SC",
      "name": "Stann Creek",
      "type": "District"
    },
    {
      "code": "BZ-TOL",
      "name": "Toledo",
      "type": "District"
    },
    {
      "code": "CA-AB",
      "name": "Alberta",
      "type": "Province"
    },
    {
      "code": "CA-BC",
      "name": "British Columbia",
      "type": "Province"
    },
    {
      "code": "CA-MB",
      "name": "Manitoba",
      "type": "Province"
    },
    {
      "code": "CA-NB",
      "name": "New Brunswick",
      "type": "Province"
    },
    {
      "code": "CA-NL",
      "name": "Newfoundland and Labrador",
      "type": "Province"
    },
    {
      "code": "CA-NS",
      "name": "Nova Scotia",
      "type": "Province"
    },
    {
      "code": "CA-NT",
      "name": "Northwest Territories",
      "type": "Territory"
    },
    {
      "code": "CA-NU",
      "name": "Nunavut",
      "type": "Territory"
    },
    {
      "code": "CA-ON",
      "name": "Ontario",
      "type": "Province"
    },
    {
      "code": "CA-PE",
      "name": "Prince Edward Island",
      "type": "Province"
    },
    {
      "code": "CA-QC",
      "name": "Quebec",
      "type": "Province"
    },
    {
      "code": "CA-SK",
      "name": "Saskatchewan",
      "type": "Province"
    },
    {
      "code": "CA-YT",
      "name": "Yukon Territory",
      "type": "Territory"
    },
    {
      "code": "CD-BC",
      "name": "Bas-Congo",
      "type": "Province"
    },
    {
      "code": "CD-BN",
      "name": "Bandundu",
      "type": "Province"
    },
    {
      "code": "CD-EQ",
      "name": "Équateur",
      "type": "Province"
    },
    {
      "code": "CD-KA",
      "name": "Katanga",
      "type": "Province"
    },
    {
      "code": "CD-KE",
      "name": "Kasai-Oriental",
      "type": "Province"
    },
    {
      "code": "CD-KN",
      "name": "Kinshasa",
      "type": "City"
    },
    {
      "code": "CD-KW",
      "name": "Kasai-Occidental",
      "type": "Province"
    },
    {
      "code": "CD-MA",
      "name": "Maniema",
      "type": "Province"
    },
    {
      "code": "CD-NK",
      "name": "Nord-Kivu",
      "type": "Province"
    },
    {
      "code": "CD-OR",
      "name": "Orientale",
      "type": "Province"
    },
    {
      "code": "CD-SK",
      "name": "Sud-Kivu",
      "type": "Province"
    },
    {
      "code": "CF-AC",
      "name": "Ouham",
      "type": "Prefecture"
    },
    {
      "code": "CF-BB",
      "name": "Bamingui-Bangoran",
      "type": "Prefecture"
    },
    {
      "code": "CF-BGF",
      "name": "Bangui",
      "type": "Commune"
    },
    {
      "code": "CF-BK",
      "name": "Basse-Kotto",
      "type": "Prefecture"
    },
    {
      "code": "CF-HK",
      "name": "Haute-Kotto",
      "type": "Prefecture"
    },
    {
      "code": "CF-HM",
      "name": "Haut-Mbomou",
      "type": "Prefecture"
    },
    {
      "code": "CF-HS",
      "name": "Haute-Sangha / Mambéré-Kadéï",
      "type": "Prefecture"
    },
    {
      "code": "CF-KB",
      "name": "Gribingui",
      "type": "Economic Prefecture"
    },
    {
      "code": "CF-KG",
      "name": "Kémo-Gribingui",
      "type": "Prefecture"
    },
    {
      "code": "CF-LB",
      "name": "Lobaye",
      "type": "Prefecture"
    },
    {
      "code": "CF-MB",
      "name": "Mbomou",
      "type": "Prefecture"
    },
    {
      "code": "CF-MP",
      "name": "Ombella-M'poko",
      "type": "Prefecture"
    },
    {
      "code": "CF-NM",
      "name": "Nana-Mambéré",
      "type": "Prefecture"
    },
    {
      "code": "CF-OP",
      "name": "Ouham-Pendé",
      "type": "Prefecture"
    },
    {
      "code": "CF-SE",
      "name": "Sangha",
      "type": "Economic Prefecture"
    },
    {
      "code": "CF-UK",
      "name": "Ouaka",
      "type": "Prefecture"
    },
    {
      "code": "CF-VK",
      "name": "Vakaga",
      "type": "Prefecture"
    },
    {
      "code": "CG-11",
      "name": "Bouenza",
      "type": "Region"
    },
    {
      "code": "CG-12",
      "name": "Pool",
      "type": "Region"
    },
    {
      "code": "CG-13",
      "name": "Sangha",
      "type": "Region"
    },
    {
      "code": "CG-14",
      "name": "Plateaux",
      "type": "Region"
    },
    {
      "code": "CG-15",
      "name": "Cuvette-Ouest",
      "type": "Region"
    },
    {
      "code": "CG-2",
      "name": "Lékoumou",
      "type": "Region"
    },
    {
      "code": "CG-5",
      "name": "Kouilou",
      "type": "Region"
    },
    {
      "code": "CG-7",
      "name": "Likouala",
      "type": "Region"
    },
    {
      "code": "CG-8",
      "name": "Cuvette",
      "type": "Region"
    },
    {
      "code": "CG-9",
      "name": "Niari",
      "type": "Region"
    },
    {
      "code": "CG-BZV",
      "name": "Brazzaville",
      "type": "Capital District"
    },
    {
      "code": "CH-AG",
      "name": "Aargau",
      "type": "Canton"
    },
    {
      "code": "CH-AI",
      "name": "Appenzell Innerrhoden",
      "type": "Canton"
    },
    {
      "code": "CH-AR",
      "name": "Appenzell Ausserrhoden",
      "type": "Canton"
    },
    {
      "code": "CH-BE",
      "name": "Bern",
      "type": "Canton"
    },
    {
      "code": "CH-BL",
      "name": "Basel-Landschaft",
      "type": "Canton"
    },
    {
      "code": "CH-BS",
      "name": "Basel-Stadt",
      "type": "Canton"
    },
    {
      "code": "CH-FR",
      "name": "Fribourg",
      "type": "Canton"
    },
    {
      "code": "CH-GE",
      "name": "Genève",
      "type": "Canton"
    },
    {
      "code": "CH-GL",
      "name": "Glarus",
      "type": "Canton"
    },
    {
      "code": "CH-GR",
      "name": "Graubünden",
      "type": "Canton"
    },
    {
      "code": "CH-JU",
      "name": "Jura",
      "type": "Canton"
    },
    {
      "code": "CH-LU",
      "name": "Luzern",
      "type": "Canton"
    },
    {
      "code": "CH-NE",
      "name": "Neuchâtel",
      "type": "Canton"
    },
    {
      "code": "CH-NW",
      "name": "Nidwalden",
      "type": "Canton"
    },
    {
      "code": "CH-OW",
      "name": "Obwalden",
      "type": "Canton"
    },
    {
      "code": "CH-SG",
      "name": "Sankt Gallen",
      "type": "Canton"
    },
    {
      "code": "CH-SH",
      "name": "Schaffhausen",
      "type": "Canton"
    },
    {
      "code": "CH-SO",
      "name": "Solothurn",
      "type": "Canton"
    },
    {
      "code": "CH-SZ",
      "name": "Schwyz",
      "type": "Canton"
    },
    {
      "code": "CH-TG",
      "name": "Thurgau",
      "type": "Canton"
    },
    {
      "code": "CH-TI",
      "name": "Ticino",
      "type": "Canton"
    },
    {
      "code": "CH-UR",
      "name": "Uri",
      "type": "Canton"
    },
    {
      "code": "CH-VD",
      "name": "Vaud",
      "type": "Canton"
    },
    {
      "code": "CH-VS",
      "name": "Valais",
      "type": "Canton"
    },
    {
      "code": "CH-ZG",
      "name": "Zug",
      "type": "Canton"
    },
    {
      "code": "CH-ZH",
      "name": "Zürich",
      "type": "Canton"
    },
    {
      "code": "CI-01",
      "name": "Lagunes (Région des)",
      "type": "Region"
    },
    {
      "code": "CI-02",
      "name": "Haut-Sassandra (Région du)",
      "type": "Region"
    },
    {
      "code": "CI-03",
      "name": "Savanes (Région des)",
      "type": "Region"
    },
    {
      "code": "CI-04",
      "name": "Vallée du Bandama (Région de la)",
      "type": "Region"
    },
    {
      "code": "CI-05",
      "name": "Moyen-Comoé (Région du)",
      "type": "Region"
    },
    {
      "code": "CI-06",
      "name": "18 Montagnes (Région des)",
      "type": "Region"
    },
    {
      "code": "CI-07",
      "name": "Lacs (Région des)",
      "type": "Region"
    },
    {
      "code": "CI-08",
      "name": "Zanzan (Région du)",
      "type": "Region"
    },
    {
      "code": "CI-09",
      "name": "Bas-Sassandra (Région du)",
      "type": "Region"
    },
    {
      "code": "CI-10",
      "name": "Denguélé (Région du)",
      "type": "Region"
    },
    {
      "code": "CI-11",
      "name": "Nzi-Comoé (Région)",
      "type": "Region"
    },
    {
      "code": "CI-12",
      "name": "Marahoué (Région de la)",
      "type": "Region"
    },
    {
      "code": "CI-13",
      "name": "Sud-Comoé (Région du)",
      "type": "Region"
    },
    {
      "code": "CI-14",
      "name": "Worodouqou (Région du)",
      "type": "Region"
    },
    {
      "code": "CI-15",
      "name": "Sud-Bandama (Région du)",
      "type": "Region"
    },
    {
      "code": "CI-16",
      "name": "Agnébi (Région de l')",
      "type": "Region"
    },
    {
      "code": "CI-17",
      "name": "Bafing (Région du)",
      "type": "Region"
    },
    {
      "code": "CI-18",
      "name": "Fromager (Région du)",
      "type": "Region"
    },
    {
      "code": "CI-19",
      "name": "Moyen-Cavally (Région du)",
      "type": "Region"
    },
    {
      "code": "CL-AI",
      "name": "Aisén del General Carlos Ibáñez del Campo",
      "type": "Region"
    },
    {
      "code": "CL-AN",
      "name": "Antofagasta",
      "type": "Region"
    },
    {
      "code": "CL-AP",
      "name": "Arica y Parinacota",
      "type": "Region"
    },
    {
      "code": "CL-AR",
      "name": "Araucanía",
      "type": "Region"
    },
    {
      "code": "CL-AT",
      "name": "Atacama",
      "type": "Region"
    },
    {
      "code": "CL-BI",
      "name": "Bío-Bío",
      "type": "Region"
    },
    {
      "code": "CL-CO",
      "name": "Coquimbo",
      "type": "Region"
    },
    {
      "code": "CL-LI",
      "name": "Libertador General Bernardo O'Higgins",
      "type": "Region"
    },
    {
      "code": "CL-LL",
      "name": "Los Lagos",
      "type": "Region"
    },
    {
      "code": "CL-LR",
      "name": "Los Ríos",
      "type": "Region"
    },
    {
      "code": "CL-MA",
      "name": "Magallanes y Antártica Chilena",
      "type": "Region"
    },
    {
      "code": "CL-ML",
      "name": "Maule",
      "type": "Region"
    },
    {
      "code": "CL-RM",
      "name": "Región Metropolitana de Santiago",
      "type": "Region"
    },
    {
      "code": "CL-TA",
      "name": "Tarapacá",
      "type": "Region"
    },
    {
      "code": "CL-VS",
      "name": "Valparaíso",
      "type": "Region"
    },
    {
      "code": "CM-AD",
      "name": "Adamaoua",
      "type": "Province"
    },
    {
      "code": "CM-CE",
      "name": "Centre",
      "type": "Province"
    },
    {
      "code": "CM-EN",
      "name": "Far North",
      "type": "Province"
    },
    {
      "code": "CM-ES",
      "name": "East",
      "type": "Province"
    },
    {
      "code": "CM-LT",
      "name": "Littoral",
      "type": "Province"
    },
    {
      "code": "CM-NO",
      "name": "North",
      "type": "Province"
    },
    {
      "code": "CM-NW",
      "name": "North-West (Cameroon)",
      "type": "Province"
    },
    {
      "code": "CM-OU",
      "name": "West",
      "type": "Province"
    },
    {
      "code": "CM-SU",
      "name": "South",
      "type": "Province"
    },
    {
      "code": "CM-SW",
      "name": "South-West",
      "type": "Province"
    },
    {
      "code": "CN-11",
      "name": "Beijing",
      "type": "Municipality"
    },
    {
      "code": "CN-12",
      "name": "Tianjin",
      "type": "Municipality"
    },
    {
      "code": "CN-13",
      "name": "Hebei",
      "type": "Province"
    },
    {
      "code": "CN-14",
      "name": "Shanxi",
      "type": "Province"
    },
    {
      "code": "CN-15",
      "name": "Nei Mongol",
      "type": "Autonomous region"
    },
    {
      "code": "CN-21",
      "name": "Liaoning",
      "type": "Province"
    },
    {
      "code": "CN-22",
      "name": "Jilin",
      "type": "Province"
    },
    {
      "code": "CN-23",
      "name": "Heilongjiang",
      "type": "Province"
    },
    {
      "code": "CN-31",
      "name": "Shanghai",
      "type": "Municipality"
    },
    {
      "code": "CN-32",
      "name": "Jiangsu",
      "type": "Province"
    },
    {
      "code": "CN-33",
      "name": "Zhejiang",
      "type": "Province"
    },
    {
      "code": "CN-34",
      "name": "Anhui",
      "type": "Province"
    },
    {
      "code": "CN-35",
      "name": "Fujian",
      "type": "Province"
    },
    {
      "code": "CN-36",
      "name": "Jiangxi",
      "type": "Province"
    },
    {
      "code": "CN-37",
      "name": "Shandong",
      "type": "Province"
    },
    {
      "code": "CN-41",
      "name": "Henan",
      "type": "Province"
    },
    {
      "code": "CN-42",
      "name": "Hubei",
      "type": "Province"
    },
    {
      "code": "CN-43",
      "name": "Hunan",
      "type": "Province"
    },
    {
      "code": "CN-44",
      "name": "Guangdong",
      "type": "Province"
    },
    {
      "code": "CN-45",
      "name": "Guangxi",
      "type": "Autonomous region"
    },
    {
      "code": "CN-46",
      "name": "Hainan",
      "type": "Province"
    },
    {
      "code": "CN-50",
      "name": "Chongqing",
      "type": "Municipality"
    },
    {
      "code": "CN-51",
      "name": "Sichuan",
      "type": "Province"
    },
    {
      "code": "CN-52",
      "name": "Guizhou",
      "type": "Province"
    },
    {
      "code": "CN-53",
      "name": "Yunnan",
      "type": "Province"
    },
    {
      "code": "CN-54",
      "name": "Xizang",
      "type": "Autonomous region"
    },
    {
      "code": "CN-61",
      "name": "Shaanxi",
      "type": "Province"
    },
    {
      "code": "CN-62",
      "name": "Gansu",
      "type": "Province"
    },
    {
      "code": "CN-63",
      "name": "Qinghai",
      "type": "Province"
    },
    {
      "code": "CN-64",
      "name": "Ningxia",
      "type": "Autonomous region"
    },
    {
      "code": "CN-65",
      "name": "Xinjiang",
      "type": "Autonomous region"
    },
    {
      "code": "CN-71",
      "name": "Taiwan",
      "type": "Province"
    },
    {
      "code": "CN-91",
      "name": "Xianggang (Hong-Kong)",
      "type": "Special administrative region"
    },
    {
      "code": "CN-92",
      "name": "Aomen (Macau)",
      "type": "Special administrative region"
    },
    {
      "code": "CO-AMA",
      "name": "Amazonas",
      "type": "Department"
    },
    {
      "code": "CO-ANT",
      "name": "Antioquia",
      "type": "Department"
    },
    {
      "code": "CO-ARA",
      "name": "Arauca",
      "type": "Department"
    },
    {
      "code": "CO-ATL",
      "name": "Atlántico",
      "type": "Department"
    },
    {
      "code": "CO-BOL",
      "name": "Bolívar",
      "type": "Department"
    },
    {
      "code": "CO-BOY",
      "name": "Boyacá",
      "type": "Department"
    },
    {
      "code": "CO-CAL",
      "name": "Caldas",
      "type": "Department"
    },
    {
      "code": "CO-CAQ",
      "name": "Caquetá",
      "type": "Department"
    },
    {
      "code": "CO-CAS",
      "name": "Casanare",
      "type": "Department"
    },
    {
      "code": "CO-CAU",
      "name": "Cauca",
      "type": "Department"
    },
    {
      "code": "CO-CES",
      "name": "Cesar",
      "type": "Department"
    },
    {
      "code": "CO-CHO",
      "name": "Chocó",
      "type": "Department"
    },
    {
      "code": "CO-COR",
      "name": "Córdoba",
      "type": "Department"
    },
    {
      "code": "CO-CUN",
      "name": "Cundinamarca",
      "type": "Department"
    },
    {
      "code": "CO-DC",
      "name": "Distrito Capital de Bogotá",
      "type": "Capital district"
    },
    {
      "code": "CO-GUA",
      "name": "Guainía",
      "type": "Department"
    },
    {
      "code": "CO-GUV",
      "name": "Guaviare",
      "type": "Department"
    },
    {
      "code": "CO-HUI",
      "name": "Huila",
      "type": "Department"
    },
    {
      "code": "CO-LAG",
      "name": "La Guajira",
      "type": "Department"
    },
    {
      "code": "CO-MAG",
      "name": "Magdalena",
      "type": "Department"
    },
    {
      "code": "CO-MET",
      "name": "Meta",
      "type": "Department"
    },
    {
      "code": "CO-NAR",
      "name": "Nariño",
      "type": "Department"
    },
    {
      "code": "CO-NSA",
      "name": "Norte de Santander",
      "type": "Department"
    },
    {
      "code": "CO-PUT",
      "name": "Putumayo",
      "type": "Department"
    },
    {
      "code": "CO-QUI",
      "name": "Quindío",
      "type": "Department"
    },
    {
      "code": "CO-RIS",
      "name": "Risaralda",
      "type": "Department"
    },
    {
      "code": "CO-SAN",
      "name": "Santander",
      "type": "Department"
    },
    {
      "code": "CO-SAP",
      "name": "San Andrés, Providencia y Santa Catalina",
      "type": "Department"
    },
    {
      "code": "CO-SUC",
      "name": "Sucre",
      "type": "Department"
    },
    {
      "code": "CO-TOL",
      "name": "Tolima",
      "type": "Department"
    },
    {
      "code": "CO-VAC",
      "name": "Valle del Cauca",
      "type": "Department"
    },
    {
      "code": "CO-VAU",
      "name": "Vaupés",
      "type": "Department"
    },
    {
      "code": "CO-VID",
      "name": "Vichada",
      "type": "Department"
    },
    {
      "code": "CR-A",
      "name": "Alajuela",
      "type": "Province"
    },
    {
      "code": "CR-C",
      "name": "Cartago",
      "type": "Province"
    },
    {
      "code": "CR-G",
      "name": "Guanacaste",
      "type": "Province"
    },
    {
      "code": "CR-H",
      "name": "Heredia",
      "type": "Province"
    },
    {
      "code": "CR-L",
      "name": "Limón",
      "type": "Province"
    },
    {
      "code": "CR-P",
      "name": "Puntarenas",
      "type": "Province"
    },
    {
      "code": "CR-SJ",
      "name": "San José",
      "type": "Province"
    },
    {
      "code": "CU-01",
      "name": "Pinar del Rio",
      "type": "Province"
    },
    {
      "code": "CU-02",
      "name": "La Habana",
      "type": "Province"
    },
    {
      "code": "CU-03",
      "name": "Ciudad de La Habana",
      "type": "Province"
    },
    {
      "code": "CU-04",
      "name": "Matanzas",
      "type": "Province"
    },
    {
      "code": "CU-05",
      "name": "Villa Clara",
      "type": "Province"
    },
    {
      "code": "CU-06",
      "name": "Cienfuegos",
      "type": "Province"
    },
    {
      "code": "CU-07",
      "name": "Sancti Spíritus",
      "type": "Province"
    },
    {
      "code": "CU-08",
      "name": "Ciego de Ávila",
      "type": "Province"
    },
    {
      "code": "CU-09",
      "name": "Camagüey",
      "type": "Province"
    },
    {
      "code": "CU-10",
      "name": "Las Tunas",
      "type": "Province"
    },
    {
      "code": "CU-11",
      "name": "Holguín",
      "type": "Province"
    },
    {
      "code": "CU-12",
      "name": "Granma",
      "type": "Province"
    },
    {
      "code": "CU-13",
      "name": "Santiago de Cuba",
      "type": "Province"
    },
    {
      "code": "CU-14",
      "name": "Guantánamo",
      "type": "Province"
    },
    {
      "code": "CU-99",
      "name": "Isla de la Juventud",
      "type": "Special municipality"
    },
    {
      "code": "CV-B",
      "name": "Ilhas de Barlavento",
      "type": "Geographical region"
    },
    {
      "code": "CV-BR",
      "name": "Brava",
      "parent": "S",
      "type": "Municipality"
    },
    {
      "code": "CV-BV",
      "name": "Boa Vista",
      "parent": "B",
      "type": "Municipality"
    },
    {
      "code": "CV-CA",
      "name": "Santa Catarina",
      "parent": "S",
      "type": "Municipality"
    },
    {
      "code": "CV-CF",
      "name": "Santa Catarina de Fogo",
      "parent": "S",
      "type": "Municipality"
    },
    {
      "code": "CV-CR",
      "name": "Santa Cruz",
      "parent": "S",
      "type": "Municipality"
    },
    {
      "code": "CV-MA",
      "name": "Maio",
      "parent": "S",
      "type": "Municipality"
    },
    {
      "code": "CV-MO",
      "name": "Mosteiros",
      "parent": "S",
      "type": "Municipality"
    },
    {
      "code": "CV-PA",
      "name": "Paul",
      "parent": "B",
      "type": "Municipality"
    },
    {
      "code": "CV-PN",
      "name": "Porto Novo",
      "parent": "B",
      "type": "Municipality"
    },
    {
      "code": "CV-PR",
      "name": "Praia",
      "parent": "S",
      "type": "Municipality"
    },
    {
      "code": "CV-RB",
      "name": "Ribeira Brava",
      "parent": "B",
      "type": "Municipality"
    },
    {
      "code": "CV-RG",
      "name": "Ribeira Grande",
      "parent": "B",
      "type": "Municipality"
    },
    {
      "code": "CV-RS",
      "name": "Ribeira Grande de Santiago",
      "parent": "S",
      "type": "Municipality"
    },
    {
      "code": "CV-S",
      "name": "Ilhas de Sotavento",
      "type": "Geographical region"
    },
    {
      "code": "CV-SD",
      "name": "São Domingos",
      "parent": "S",
      "type": "Municipality"
    },
    {
      "code": "CV-SF",
      "name": "São Filipe",
      "parent": "S",
      "type": "Municipality"
    },
    {
      "code": "CV-SL",
      "name": "Sal",
      "parent": "B",
      "type": "Municipality"
    },
    {
      "code": "CV-SM",
      "name": "São Miguel",
      "parent": "S",
      "type": "Municipality"
    },
    {
      "code": "CV-SO",
      "name": "São Lourenço dos Órgãos",
      "parent": "S",
      "type": "Municipality"
    },
    {
      "code": "CV-SS",
      "name": "São Salvador do Mundo",
      "parent": "S",
      "type": "Municipality"
    },
    {
      "code": "CV-SV",
      "name": "São Vicente",
      "parent": "B",
      "type": "Municipality"
    },
    {
      "code": "CV-TA",
      "name": "Tarrafal",
      "parent": "S",
      "type": "Municipality"
    },
    {
      "code": "CV-TS",
      "name": "Tarrafal de São Nicolau",
      "parent": "S",
      "type": "Municipality"
    },
    {
      "code": "CY-01",
      "name": "Lefkosía",
      "type": "District"
    },
    {
      "code": "CY-02",
      "name": "Lemesós",
      "type": "District"
    },
    {
      "code": "CY-03",
      "name": "Lárnaka",
      "type": "District"
    },
    {
      "code": "CY-04",
      "name": "Ammóchostos",
      "type": "District"
    },
    {
      "code": "CY-05",
      "name": "Páfos",
      "type": "District"
    },
    {
      "code": "CY-06",
      "name": "Kerýneia",
      "type": "District"
    },
    {
      "code": "CZ-10",
      "name": "Praha, Hlavní mešto",
      "type": "capital city"
    },
    {
      "code": "CZ-101",
      "name": "Praha 1",
      "parent": "10",
      "type": "district"
    },
    {
      "code": "CZ-102",
      "name": "Praha 2",
      "parent": "10",
      "type": "district"
    },
    {
      "code": "CZ-103",
      "name": "Praha 3",
      "parent": "10",
      "type": "district"
    },
    {
      "code": "CZ-104",
      "name": "Praha 4",
      "parent": "10",
      "type": "district"
    },
    {
      "code": "CZ-105",
      "name": "Praha 5",
      "parent": "10",
      "type": "district"
    },
    {
      "code": "CZ-106",
      "name": "Praha 6",
      "parent": "10",
      "type": "district"
    },
    {
      "code": "CZ-107",
      "name": "Praha 7",
      "parent": "10",
      "type": "district"
    },
    {
      "code": "CZ-108",
      "name": "Praha 8",
      "parent": "10",
      "type": "district"
    },
    {
      "code": "CZ-109",
      "name": "Praha 9",
      "parent": "10",
      "type": "district"
    },
    {
      "code": "CZ-110",
      "name": "Praha 10",
      "parent": "10",
      "type": "district"
    },
    {
      "code": "CZ-111",
      "name": "Praha 11",
      "parent": "10",
      "type": "district"
    },
    {
      "code": "CZ-112",
      "name": "Praha 12",
      "parent": "10",
      "type": "district"
    },
    {
      "code": "CZ-113",
      "name": "Praha 13",
      "parent": "10",
      "type": "district"
    },
    {
      "code": "CZ-114",
      "name": "Praha 14",
      "parent": "10",
      "type": "district"
    },
    {
      "code": "CZ-115",
      "name": "Praha 15",
      "parent": "10",
      "type": "district"
    },
    {
      "code": "CZ-116",
      "name": "Praha 16",
      "parent": "10",
      "type": "district"
    },
    {
      "code": "CZ-117",
      "name": "Praha 17",
      "parent": "10",
      "type": "district"
    },
    {
      "code": "CZ-118",
      "name": "Praha 18",
      "parent": "10",
      "type": "district"
    },
    {
      "code": "CZ-119",
      "name": "Praha 19",
      "parent": "10",
      "type": "district"
    },
    {
      "code": "CZ-120",
      "name": "Praha 20",
      "parent": "10",
      "type": "district"
    },
    {
      "code": "CZ-121",
      "name": "Praha 21",
      "parent": "10",
      "type": "district"
    },
    {
      "code": "CZ-122",
      "name": "Praha 22",
      "parent": "10",
      "type": "district"
    },
    {
      "code": "CZ-20",
      "name": "Středočeský kraj",
      "type": "region"
    },
    {
      "code": "CZ-201",
      "name": "Benešov",
      "parent": "20",
      "type": "district"
    },
    {
      "code": "CZ-202",
      "name": "Beroun",
      "parent": "20",
      "type": "district"
    },
    {
      "code": "CZ-203",
      "name": "Kladno",
      "parent": "20",
      "type": "district"
    },
    {
      "code": "CZ-204",
      "name": "Kolín",
      "parent": "20",
      "type": "district"
    },
    {
      "code": "CZ-205",
      "name": "Kutná Hora",
      "parent": "20",
      "type": "district"
    },
    {
      "code": "CZ-206",
      "name": "Mělník",
      "parent": "20",
      "type": "district"
    },
    {
      "code": "CZ-207",
      "name": "Mladá Boleslav",
      "parent": "20",
      "type": "district"
    },
    {
      "code": "CZ-208",
      "name": "Nymburk",
      "parent": "20",
      "type": "district"
    },
    {
      "code": "CZ-209",
      "name": "Praha-východ",
      "parent": "20",
      "type": "district"
    },
    {
      "code": "CZ-20A",
      "name": "Praha-západ",
      "parent": "20",
      "type": "district"
    },
    {
      "code": "CZ-20B",
      "name": "Příbram",
      "parent": "20",
      "type": "district"
    },
    {
      "code": "CZ-20C",
      "name": "Rakovník",
      "parent": "20",
      "type": "district"
    },
    {
      "code": "CZ-31",
      "name": "Jihočeský kraj",
      "type": "region"
    },
    {
      "code": "CZ-311",
      "name": "České Budějovice",
      "parent": "31",
      "type": "district"
    },
    {
      "code": "CZ-312",
      "name": "Český Krumlov",
      "parent": "31",
      "type": "district"
    },
    {
      "code": "CZ-313",
      "name": "Jindřichův Hradec",
      "parent": "31",
      "type": "district"
    },
    {
      "code": "CZ-314",
      "name": "Písek",
      "parent": "31",
      "type": "district"
    },
    {
      "code": "CZ-315",
      "name": "Prachatice",
      "parent": "31",
      "type": "district"
    },
    {
      "code": "CZ-316",
      "name": "Strakonice",
      "parent": "31",
      "type": "district"
    },
    {
      "code": "CZ-317",
      "name": "Tábor",
      "parent": "31",
      "type": "district"
    },
    {
      "code": "CZ-32",
      "name": "Plzeňský kraj",
      "type": "region"
    },
    {
      "code": "CZ-321",
      "name": "Domažlice",
      "parent": "32",
      "type": "district"
    },
    {
      "code": "CZ-322",
      "name": "Klatovy",
      "parent": "32",
      "type": "district"
    },
    {
      "code": "CZ-323",
      "name": "Plzeň-město",
      "parent": "32",
      "type": "district"
    },
    {
      "code": "CZ-324",
      "name": "Plzeň-jih",
      "parent": "32",
      "type": "district"
    },
    {
      "code": "CZ-325",
      "name": "Plzeň-sever",
      "parent": "32",
      "type": "district"
    },
    {
      "code": "CZ-326",
      "name": "Rokycany",
      "parent": "32",
      "type": "district"
    },
    {
      "code": "CZ-327",
      "name": "Tachov",
      "parent": "32",
      "type": "district"
    },
    {
      "code": "CZ-41",
      "name": "Karlovarský kraj",
      "type": "region"
    },
    {
      "code": "CZ-411",
      "name": "Cheb",
      "parent": "41",
      "type": "district"
    },
    {
      "code": "CZ-412",
      "name": "Karlovy Vary",
      "parent": "41",
      "type": "district"
    },
    {
      "code": "CZ-413",
      "name": "Sokolov",
      "parent": "41",
      "type": "district"
    },
    {
      "code": "CZ-42",
      "name": "Ústecký kraj",
      "type": "region"
    },
    {
      "code": "CZ-421",
      "name": "Děčín",
      "parent": "42",
      "type": "district"
    },
    {
      "code": "CZ-422",
      "name": "Chomutov",
      "parent": "42",
      "type": "district"
    },
    {
      "code": "CZ-423",
      "name": "Litoměřice",
      "parent": "42",
      "type": "district"
    },
    {
      "code": "CZ-424",
      "name": "Louny",
      "parent": "42",
      "type": "district"
    },
    {
      "code": "CZ-425",
      "name": "Most",
      "parent": "42",
      "type": "district"
    },
    {
      "code": "CZ-426",
      "name": "Teplice",
      "parent": "42",
      "type": "district"
    },
    {
      "code": "CZ-427",
      "name": "Ústí nad Labem",
      "parent": "42",
      "type": "district"
    },
    {
      "code": "CZ-51",
      "name": "Liberecký kraj",
      "type": "region"
    },
    {
      "code": "CZ-511",
      "name": "Česká Lípa",
      "parent": "51",
      "type": "district"
    },
    {
      "code": "CZ-512",
      "name": "Jablonec nad Nisou",
      "parent": "51",
      "type": "district"
    },
    {
      "code": "CZ-513",
      "name": "Liberec",
      "parent": "51",
      "type": "district"
    },
    {
      "code": "CZ-514",
      "name": "Semily",
      "parent": "51",
      "type": "district"
    },
    {
      "code": "CZ-52",
      "name": "Královéhradecký kraj",
      "type": "region"
    },
    {
      "code": "CZ-521",
      "name": "Hradec Králové",
      "parent": "52",
      "type": "district"
    },
    {
      "code": "CZ-522",
      "name": "Jičín",
      "parent": "52",
      "type": "district"
    },
    {
      "code": "CZ-523",
      "name": "Náchod",
      "parent": "52",
      "type": "district"
    },
    {
      "code": "CZ-524",
      "name": "Rychnov nad Kněžnou",
      "parent": "52",
      "type": "district"
    },
    {
      "code": "CZ-525",
      "name": "Trutnov",
      "parent": "52",
      "type": "district"
    },
    {
      "code": "CZ-53",
      "name": "Pardubický kraj",
      "type": "region"
    },
    {
      "code": "CZ-531",
      "name": "Chrudim",
      "parent": "53",
      "type": "district"
    },
    {
      "code": "CZ-532",
      "name": "Pardubice",
      "parent": "53",
      "type": "district"
    },
    {
      "code": "CZ-533",
      "name": "Svitavy",
      "parent": "53",
      "type": "district"
    },
    {
      "code": "CZ-534",
      "name": "Ústí nad Orlicí",
      "parent": "53",
      "type": "district"
    },
    {
      "code": "CZ-63",
      "name": "Kraj Vysočina",
      "type": "region"
    },
    {
      "code": "CZ-631",
      "name": "Havlíčkův Brod",
      "parent": "63",
      "type": "district"
    },
    {
      "code": "CZ-632",
      "name": "Jihlava",
      "parent": "63",
      "type": "district"
    },
    {
      "code": "CZ-633",
      "name": "Pelhřimov",
      "parent": "63",
      "type": "district"
    },
    {
      "code": "CZ-634",
      "name": "Třebíč",
      "parent": "63",
      "type": "district"
    },
    {
      "code": "CZ-635",
      "name": "Žďár nad Sázavou",
      "parent": "63",
      "type": "district"
    },
    {
      "code": "CZ-64",
      "name": "Jihomoravský kraj",
      "type": "region"
    },
    {
      "code": "CZ-641",
      "name": "Blansko",
      "parent": "64",
      "type": "district"
    },
    {
      "code": "CZ-642",
      "name": "Brno-město",
      "parent": "64",
      "type": "district"
    },
    {
      "code": "CZ-643",
      "name": "Brno-venkov",
      "parent": "64",
      "type": "district"
    },
    {
      "code": "CZ-644",
      "name": "Břeclav",
      "parent": "64",
      "type": "district"
    },
    {
      "code": "CZ-645",
      "name": "Hodonín",
      "parent": "64",
      "type": "district"
    },
    {
      "code": "CZ-646",
      "name": "Vyškov",
      "parent": "64",
      "type": "district"
    },
    {
      "code": "CZ-647",
      "name": "Znojmo",
      "parent": "64",
      "type": "district"
    },
    {
      "code": "CZ-71",
      "name": "Olomoucký kraj",
      "type": "region"
    },
    {
      "code": "CZ-711",
      "name": "Jeseník",
      "parent": "71",
      "type": "district"
    },
    {
      "code": "CZ-712",
      "name": "Olomouc",
      "parent": "71",
      "type": "district"
    },
    {
      "code": "CZ-713",
      "name": "Prostějov",
      "parent": "71",
      "type": "district"
    },
    {
      "code": "CZ-714",
      "name": "Přerov",
      "parent": "71",
      "type": "district"
    },
    {
      "code": "CZ-715",
      "name": "Šumperk",
      "parent": "71",
      "type": "district"
    },
    {
      "code": "CZ-72",
      "name": "Zlínský kraj",
      "type": "region"
    },
    {
      "code": "CZ-721",
      "name": "Kroměříž",
      "parent": "72",
      "type": "district"
    },
    {
      "code": "CZ-722",
      "name": "Uherské Hradiště",
      "parent": "72",
      "type": "district"
    },
    {
      "code": "CZ-723",
      "name": "Vsetín",
      "parent": "72",
      "type": "district"
    },
    {
      "code": "CZ-724",
      "name": "Zlín",
      "parent": "72",
      "type": "district"
    },
    {
      "code": "CZ-80",
      "name": "Moravskoslezský kraj",
      "type": "region"
    },
    {
      "code": "CZ-801",
      "name": "Bruntál",
      "parent": "80",
      "type": "district"
    },
    {
      "code": "CZ-802",
      "name": "Frýdek Místek",
      "parent": "80",
      "type": "district"
    },
    {
      "code": "CZ-803",
      "name": "Karviná",
      "parent": "80",
      "type": "district"
    },
    {
      "code": "CZ-804",
      "name": "Nový Jičín",
      "parent": "80",
      "type": "district"
    },
    {
      "code": "CZ-805",
      "name": "Opava",
      "parent": "80",
      "type": "district"
    },
    {
      "code": "CZ-806",
      "name": "Ostrava-město",
      "parent": "80",
      "type": "district"
    },
    {
      "code": "DE-BB",
      "name": "Brandenburg",
      "type": "State"
    },
    {
      "code": "DE-BE",
      "name": "Berlin",
      "type": "State"
    },
    {
      "code": "DE-BW",
      "name": "Baden-Württemberg",
      "type": "State"
    },
    {
      "code": "DE-BY",
      "name": "Bayern",
      "type": "State"
    },
    {
      "code": "DE-HB",
      "name": "Bremen",
      "type": "State"
    },
    {
      "code": "DE-HE",
      "name": "Hessen",
      "type": "State"
    },
    {
      "code": "DE-HH",
      "name": "Hamburg",
      "type": "State"
    },
    {
      "code": "DE-MV",
      "name": "Mecklenburg-Vorpommern",
      "type": "State"
    },
    {
      "code": "DE-NI",
      "name": "Niedersachsen",
      "type": "State"
    },
    {
      "code": "DE-NW",
      "name": "Nordrhein-Westfalen",
      "type": "State"
    },
    {
      "code": "DE-RP",
      "name": "Rheinland-Pfalz",
      "type": "State"
    },
    {
      "code": "DE-SH",
      "name": "Schleswig-Holstein",
      "type": "State"
    },
    {
      "code": "DE-SL",
      "name": "Saarland",
      "type": "State"
    },
    {
      "code": "DE-SN",
      "name": "Sachsen",
      "type": "State"
    },
    {
      "code": "DE-ST",
      "name": "Sachsen-Anhalt",
      "type": "State"
    },
    {
      "code": "DE-TH",
      "name": "Thüringen",
      "type": "State"
    },
    {
      "code": "DJ-AR",
      "name": "Arta",
      "type": "Region"
    },
    {
      "code": "DJ-AS",
      "name": "Ali Sabieh",
      "type": "Region"
    },
    {
      "code": "DJ-DI",
      "name": "Dikhil",
      "type": "Region"
    },
    {
      "code": "DJ-DJ",
      "name": "Djibouti",
      "type": "City"
    },
    {
      "code": "DJ-OB",
      "name": "Obock",
      "type": "Region"
    },
    {
      "code": "DJ-TA",
      "name": "Tadjourah",
      "type": "Region"
    },
    {
      "code": "DK-81",
      "name": "Nordjylland",
      "type": "Region"
    },
    {
      "code": "DK-82",
      "name": "Midtjylland",
      "type": "Region"
    },
    {
      "code": "DK-83",
      "name": "Syddanmark",
      "type": "Region"
    },
    {
      "code": "DK-84",
      "name": "Hovedstaden",
      "type": "Region"
    },
    {
      "code": "DK-85",
      "name": "Sjælland",
      "type": "Region"
    },
    {
      "code": "DM-01",
      "name": "Saint Peter",
      "type": "Parish"
    },
    {
      "code": "DM-02",
      "name": "Saint Andrew",
      "type": "Parish"
    },
    {
      "code": "DM-03",
      "name": "Saint David",
      "type": "Parish"
    },
    {
      "code": "DM-04",
      "name": "Saint George",
      "type": "Parish"
    },
    {
      "code": "DM-05",
      "name": "Saint John",
      "type": "Parish"
    },
    {
      "code": "DM-06",
      "name": "Saint Joseph",
      "type": "Parish"
    },
    {
      "code": "DM-07",
      "name": "Saint Luke",
      "type": "Parish"
    },
    {
      "code": "DM-08",
      "name": "Saint Mark",
      "type": "Parish"
    },
    {
      "code": "DM-09",
      "name": "Saint Patrick",
      "type": "Parish"
    },
    {
      "code": "DM-10",
      "name": "Saint Paul",
      "type": "Parish"
    },
    {
      "code": "DO-01",
      "name": "Distrito Nacional (Santo Domingo)",
      "type": "District"
    },
    {
      "code": "DO-02",
      "name": "Azua",
      "type": "Province"
    },
    {
      "code": "DO-03",
      "name": "Bahoruco",
      "type": "Province"
    },
    {
      "code": "DO-04",
      "name": "Barahona",
      "type": "Province"
    },
    {
      "code": "DO-05",
      "name": "Dajabón",
      "type": "Province"
    },
    {
      "code": "DO-06",
      "name": "Duarte",
      "type": "Province"
    },
    {
      "code": "DO-07",
      "name": "La Estrelleta [Elías Piña]",
      "type": "Province"
    },
    {
      "code": "DO-08",
      "name": "El Seybo [El Seibo]",
      "type": "Province"
    },
    {
      "code": "DO-09",
      "name": "Espaillat",
      "type": "Province"
    },
    {
      "code": "DO-10",
      "name": "Independencia",
      "type": "Province"
    },
    {
      "code": "DO-11",
      "name": "La Altagracia",
      "type": "Province"
    },
    {
      "code": "DO-12",
      "name": "La Romana",
      "type": "Province"
    },
    {
      "code": "DO-13",
      "name": "La Vega",
      "type": "Province"
    },
    {
      "code": "DO-14",
      "name": "María Trinidad Sánchez",
      "type": "Province"
    },
    {
      "code": "DO-15",
      "name": "Monte Cristi",
      "type": "Province"
    },
    {
      "code": "DO-16",
      "name": "Pedernales",
      "type": "Province"
    },
    {
      "code": "DO-17",
      "name": "Peravia",
      "type": "Province"
    },
    {
      "code": "DO-18",
      "name": "Puerto Plata",
      "type": "Province"
    },
    {
      "code": "DO-19",
      "name": "Salcedo",
      "type": "Province"
    },
    {
      "code": "DO-20",
      "name": "Samaná",
      "type": "Province"
    },
    {
      "code": "DO-21",
      "name": "San Cristóbal",
      "type": "Province"
    },
    {
      "code": "DO-22",
      "name": "San Juan",
      "type": "Province"
    },
    {
      "code": "DO-23",
      "name": "San Pedro de Macorís",
      "type": "Province"
    },
    {
      "code": "DO-24",
      "name": "Sánchez Ramírez",
      "type": "Province"
    },
    {
      "code": "DO-25",
      "name": "Santiago",
      "type": "Province"
    },
    {
      "code": "DO-26",
      "name": "Santiago Rodríguez",
      "type": "Province"
    },
    {
      "code": "DO-27",
      "name": "Valverde",
      "type": "Province"
    },
    {
      "code": "DO-28",
      "name": "Monseñor Nouel",
      "type": "Province"
    },
    {
      "code": "DO-29",
      "name": "Monte Plata",
      "type": "Province"
    },
    {
      "code": "DO-30",
      "name": "Hato Mayor",
      "type": "Province"
    },
    {
      "code": "DZ-01",
      "name": "Adrar",
      "type": "Province"
    },
    {
      "code": "DZ-02",
      "name": "Chlef",
      "type": "Province"
    },
    {
      "code": "DZ-03",
      "name": "Laghouat",
      "type": "Province"
    },
    {
      "code": "DZ-04",
      "name": "Oum el Bouaghi",
      "type": "Province"
    },
    {
      "code": "DZ-05",
      "name": "Batna",
      "type": "Province"
    },
    {
      "code": "DZ-06",
      "name": "Béjaïa",
      "type": "Province"
    },
    {
      "code": "DZ-07",
      "name": "Biskra",
      "type": "Province"
    },
    {
      "code": "DZ-08",
      "name": "Béchar",
      "type": "Province"
    },
    {
      "code": "DZ-09",
      "name": "Blida",
      "type": "Province"
    },
    {
      "code": "DZ-10",
      "name": "Bouira",
      "type": "Province"
    },
    {
      "code": "DZ-11",
      "name": "Tamanghasset",
      "type": "Province"
    },
    {
      "code": "DZ-12",
      "name": "Tébessa",
      "type": "Province"
    },
    {
      "code": "DZ-13",
      "name": "Tlemcen",
      "type": "Province"
    },
    {
      "code": "DZ-14",
      "name": "Tiaret",
      "type": "Province"
    },
    {
      "code": "DZ-15",
      "name": "Tizi Ouzou",
      "type": "Province"
    },
    {
      "code": "DZ-16",
      "name": "Alger",
      "type": "Province"
    },
    {
      "code": "DZ-17",
      "name": "Djelfa",
      "type": "Province"
    },
    {
      "code": "DZ-18",
      "name": "Jijel",
      "type": "Province"
    },
    {
      "code": "DZ-19",
      "name": "Sétif",
      "type": "Province"
    },
    {
      "code": "DZ-20",
      "name": "Saïda",
      "type": "Province"
    },
    {
      "code": "DZ-21",
      "name": "Skikda",
      "type": "Province"
    },
    {
      "code": "DZ-22",
      "name": "Sidi Bel Abbès",
      "type": "Province"
    },
    {
      "code": "DZ-23",
      "name": "Annaba",
      "type": "Province"
    },
    {
      "code": "DZ-24",
      "name": "Guelma",
      "type": "Province"
    },
    {
      "code": "DZ-25",
      "name": "Constantine",
      "type": "Province"
    },
    {
      "code": "DZ-26",
      "name": "Médéa",
      "type": "Province"
    },
    {
      "code": "DZ-27",
      "name": "Mostaganem",
      "type": "Province"
    },
    {
      "code": "DZ-28",
      "name": "Msila",
      "type": "Province"
    },
    {
      "code": "DZ-29",
      "name": "Mascara",
      "type": "Province"
    },
    {
      "code": "DZ-30",
      "name": "Ouargla",
      "type": "Province"
    },
    {
      "code": "DZ-31",
      "name": "Oran",
      "type": "Province"
    },
    {
      "code": "DZ-32",
      "name": "El Bayadh",
      "type": "Province"
    },
    {
      "code": "DZ-33",
      "name": "Illizi",
      "type": "Province"
    },
    {
      "code": "DZ-34",
      "name": "Bordj Bou Arréridj",
      "type": "Province"
    },
    {
      "code": "DZ-35",
      "name": "Boumerdès",
      "type": "Province"
    },
    {
      "code": "DZ-36",
      "name": "El Tarf",
      "type": "Province"
    },
    {
      "code": "DZ-37",
      "name": "Tindouf",
      "type": "Province"
    },
    {
      "code": "DZ-38",
      "name": "Tissemsilt",
      "type": "Province"
    },
    {
      "code": "DZ-39",
      "name": "El Oued",
      "type": "Province"
    },
    {
      "code": "DZ-40",
      "name": "Khenchela",
      "type": "Province"
    },
    {
      "code": "DZ-41",
      "name": "Souk Ahras",
      "type": "Province"
    },
    {
      "code": "DZ-42",
      "name": "Tipaza",
      "type": "Province"
    },
    {
      "code": "DZ-43",
      "name": "Mila",
      "type": "Province"
    },
    {
      "code": "DZ-44",
      "name": "Aïn Defla",
      "type": "Province"
    },
    {
      "code": "DZ-45",
      "name": "Naama",
      "type": "Province"
    },
    {
      "code": "DZ-46",
      "name": "Aïn Témouchent",
      "type": "Province"
    },
    {
      "code": "DZ-47",
      "name": "Ghardaïa",
      "type": "Province"
    },
    {
      "code": "DZ-48",
      "name": "Relizane",
      "type": "Province"
    },
    {
      "code": "EC-A",
      "name": "Azuay",
      "type": "Province"
    },
    {
      "code": "EC-B",
      "name": "Bolívar",
      "type": "Province"
    },
    {
      "code": "EC-C",
      "name": "Carchi",
      "type": "Province"
    },
    {
      "code": "EC-D",
      "name": "Orellana",
      "type": "Province"
    },
    {
      "code": "EC-E",
      "name": "Esmeraldas",
      "type": "Province"
    },
    {
      "code": "EC-F",
      "name": "Cañar",
      "type": "Province"
    },
    {
      "code": "EC-G",
      "name": "Guayas",
      "type": "Province"
    },
    {
      "code": "EC-H",
      "name": "Chimborazo",
      "type": "Province"
    },
    {
      "code": "EC-I",
      "name": "Imbabura",
      "type": "Province"
    },
    {
      "code": "EC-L",
      "name": "Loja",
      "type": "Province"
    },
    {
      "code": "EC-M",
      "name": "Manabí",
      "type": "Province"
    },
    {
      "code": "EC-N",
      "name": "Napo",
      "type": "Province"
    },
    {
      "code": "EC-O",
      "name": "El Oro",
      "type": "Province"
    },
    {
      "code": "EC-P",
      "name": "Pichincha",
      "type": "Province"
    },
    {
      "code": "EC-R",
      "name": "Los Ríos",
      "type": "Province"
    },
    {
      "code": "EC-S",
      "name": "Morona-Santiago",
      "type": "Province"
    },
    {
      "code": "EC-SD",
      "name": "Santo Domingo de los Tsáchilas",
      "type": "Province"
    },
    {
      "code": "EC-SE",
      "name": "Santa Elena",
      "type": "Province"
    },
    {
      "code": "EC-T",
      "name": "Tungurahua",
      "type": "Province"
    },
    {
      "code": "EC-U",
      "name": "Sucumbíos",
      "type": "Province"
    },
    {
      "code": "EC-W",
      "name": "Galápagos",
      "type": "Province"
    },
    {
      "code": "EC-X",
      "name": "Cotopaxi",
      "type": "Province"
    },
    {
      "code": "EC-Y",
      "name": "Pastaza",
      "type": "Province"
    },
    {
      "code": "EC-Z",
      "name": "Zamora-Chinchipe",
      "type": "Province"
    },
    {
      "code": "EE-37",
      "name": "Harjumaa",
      "type": "County"
    },
    {
      "code": "EE-39",
      "name": "Hiiumaa",
      "type": "County"
    },
    {
      "code": "EE-44",
      "name": "Ida-Virumaa",
      "type": "County"
    },
    {
      "code": "EE-49",
      "name": "Jõgevamaa",
      "type": "County"
    },
    {
      "code": "EE-51",
      "name": "Järvamaa",
      "type": "County"
    },
    {
      "code": "EE-57",
      "name": "Läänemaa",
      "type": "County"
    },
    {
      "code": "EE-59",
      "name": "Lääne-Virumaa",
      "type": "County"
    },
    {
      "code": "EE-65",
      "name": "Põlvamaa",
      "type": "County"
    },
    {
      "code": "EE-67",
      "name": "Pärnumaa",
      "type": "County"
    },
    {
      "code": "EE-70",
      "name": "Raplamaa",
      "type": "County"
    },
    {
      "code": "EE-74",
      "name": "Saaremaa",
      "type": "County"
    },
    {
      "code": "EE-78",
      "name": "Tartumaa",
      "type": "County"
    },
    {
      "code": "EE-82",
      "name": "Valgamaa",
      "type": "County"
    },
    {
      "code": "EE-84",
      "name": "Viljandimaa",
      "type": "County"
    },
    {
      "code": "EE-86",
      "name": "Võrumaa",
      "type": "County"
    },
    {
      "code": "EG-ALX",
      "name": "Al Iskandarīyah",
      "type": "Governorate"
    },
    {
      "code": "EG-ASN",
      "name": "Aswān",
      "type": "Governorate"
    },
    {
      "code": "EG-AST",
      "name": "Asyūt",
      "type": "Governorate"
    },
    {
      "code": "EG-BA",
      "name": "Al Bahr al Ahmar",
      "type": "Governorate"
    },
    {
      "code": "EG-BH",
      "name": "Al Buhayrah",
      "type": "Governorate"
    },
    {
      "code": "EG-BNS",
      "name": "Banī Suwayf",
      "type": "Governorate"
    },
    {
      "code": "EG-C",
      "name": "Al Qāhirah",
      "type": "Governorate"
    },
    {
      "code": "EG-DK",
      "name": "Ad Daqahlīyah",
      "type": "Governorate"
    },
    {
      "code": "EG-DT",
      "name": "Dumyāt",
      "type": "Governorate"
    },
    {
      "code": "EG-FYM",
      "name": "Al Fayyūm",
      "type": "Governorate"
    },
    {
      "code": "EG-GH",
      "name": "Al Gharbīyah",
      "type": "Governorate"
    },
    {
      "code": "EG-GZ",
      "name": "Al Jīzah",
      "type": "Governorate"
    },
    {
      "code": "EG-HU",
      "name": "Ḩulwān",
      "type": "Governorate"
    },
    {
      "code": "EG-IS",
      "name": "Al Ismā`īlīyah",
      "type": "Governorate"
    },
    {
      "code": "EG-JS",
      "name": "Janūb Sīnā'",
      "type": "Governorate"
    },
    {
      "code": "EG-KB",
      "name": "Al Qalyūbīyah",
      "type": "Governorate"
    },
    {
      "code": "EG-KFS",
      "name": "Kafr ash Shaykh",
      "type": "Governorate"
    },
    {
      "code": "EG-KN",
      "name": "Qinā",
      "type": "Governorate"
    },
    {
      "code": "EG-MN",
      "name": "Al Minyā",
      "type": "Governorate"
    },
    {
      "code": "EG-MNF",
      "name": "Al Minūfīyah",
      "type": "Governorate"
    },
    {
      "code": "EG-MT",
      "name": "Matrūh",
      "type": "Governorate"
    },
    {
      "code": "EG-PTS",
      "name": "Būr Sa`īd",
      "type": "Governorate"
    },
    {
      "code": "EG-SHG",
      "name": "Sūhāj",
      "type": "Governorate"
    },
    {
      "code": "EG-SHR",
      "name": "Ash Sharqīyah",
      "type": "Governorate"
    },
    {
      "code": "EG-SIN",
      "name": "Shamal Sīnā'",
      "type": "Governorate"
    },
    {
      "code": "EG-SU",
      "name": "As Sādis min Uktūbar",
      "type": "Governorate"
    },
    {
      "code": "EG-SUZ",
      "name": "As Suways",
      "type": "Governorate"
    },
    {
      "code": "EG-WAD",
      "name": "Al Wādī al Jadīd",
      "type": "Governorate"
    },
    {
      "code": "ER-AN",
      "name": "Ansabā",
      "type": "Province"
    },
    {
      "code": "ER-DK",
      "name": "Janūbī al Baḩrī al Aḩmar",
      "type": "Province"
    },
    {
      "code": "ER-DU",
      "name": "Al Janūbī",
      "type": "Province"
    },
    {
      "code": "ER-GB",
      "name": "Qāsh-Barkah",
      "type": "Province"
    },
    {
      "code": "ER-MA",
      "name": "Al Awsaţ",
      "type": "Province"
    },
    {
      "code": "ER-SK",
      "name": "Shimālī al Baḩrī al Aḩmar",
      "type": "Province"
    },
    {
      "code": "ES-A",
      "name": "Alicante",
      "parent": "VC",
      "type": "Province"
    },
    {
      "code": "ES-AB",
      "name": "Albacete",
      "parent": "CM",
      "type": "Province"
    },
    {
      "code": "ES-AL",
      "name": "Almería",
      "parent": "AN",
      "type": "Province"
    },
    {
      "code": "ES-AN",
      "name": "Andalucía",
      "type": "Autonomous community"
    },
    {
      "code": "ES-AR",
      "name": "Aragón",
      "type": "Autonomous community"
    },
    {
      "code": "ES-AS",
      "name": "Asturias, Principado de",
      "type": "Autonomous community"
    },
    {
      "code": "ES-AV",
      "name": "Ávila",
      "parent": "CL",
      "type": "Province"
    },
    {
      "code": "ES-B",
      "name": "Barcelona",
      "parent": "CT",
      "type": "Province"
    },
    {
      "code": "ES-BA",
      "name": "Badajoz",
      "parent": "EX",
      "type": "Province"
    },
    {
      "code": "ES-BI",
      "name": "Bizkaia",
      "parent": "PV",
      "type": "Province"
    },
    {
      "code": "ES-BU",
      "name": "Burgos",
      "parent": "CL",
      "type": "Province"
    },
    {
      "code": "ES-C",
      "name": "A Coruña",
      "parent": "GA",
      "type": "Province"
    },
    {
      "code": "ES-CA",
      "name": "Cádiz",
      "parent": "AN",
      "type": "Province"
    },
    {
      "code": "ES-CB",
      "name": "Cantabria",
      "type": "Autonomous community"
    },
    {
      "code": "ES-CC",
      "name": "Cáceres",
      "parent": "EX",
      "type": "Province"
    },
    {
      "code": "ES-CE",
      "name": "Ceuta",
      "type": "Autonomous city"
    },
    {
      "code": "ES-CL",
      "name": "Castilla y León",
      "type": "Autonomous community"
    },
    {
      "code": "ES-CM",
      "name": "Castilla-La Mancha",
      "type": "Autonomous community"
    },
    {
      "code": "ES-CN",
      "name": "Canarias",
      "type": "Autonomous community"
    },
    {
      "code": "ES-CO",
      "name": "Córdoba",
      "parent": "AN",
      "type": "Province"
    },
    {
      "code": "ES-CR",
      "name": "Ciudad Real",
      "parent": "CM",
      "type": "Province"
    },
    {
      "code": "ES-CS",
      "name": "Castellón",
      "parent": "VC",
      "type": "Province"
    },
    {
      "code": "ES-CT",
      "name": "Catalunya",
      "type": "Autonomous community"
    },
    {
      "code": "ES-CU",
      "name": "Cuenca",
      "parent": "CM",
      "type": "Province"
    },
    {
      "code": "ES-EX",
      "name": "Extremadura",
      "type": "Autonomous community"
    },
    {
      "code": "ES-GA",
      "name": "Galicia",
      "type": "Autonomous community"
    },
    {
      "code": "ES-GC",
      "name": "Las Palmas",
      "parent": "CN",
      "type": "Province"
    },
    {
      "code": "ES-GI",
      "name": "Girona",
      "parent": "CT",
      "type": "Province"
    },
    {
      "code": "ES-GR",
      "name": "Granada",
      "parent": "AN",
      "type": "Province"
    },
    {
      "code": "ES-GU",
      "name": "Guadalajara",
      "parent": "CM",
      "type": "Province"
    },
    {
      "code": "ES-H",
      "name": "Huelva",
      "parent": "AN",
      "type": "Province"
    },
    {
      "code": "ES-HU",
      "name": "Huesca",
      "parent": "AR",
      "type": "Province"
    },
    {
      "code": "ES-IB",
      "name": "Illes Balears",
      "type": "Autonomous community"
    },
    {
      "code": "ES-J",
      "name": "Jaén",
      "parent": "AN",
      "type": "Province"
    },
    {
      "code": "ES-L",
      "name": "Lleida",
      "parent": "CT",
      "type": "Province"
    },
    {
      "code": "ES-LE",
      "name": "León",
      "parent": "CL",
      "type": "Province"
    },
    {
      "code": "ES-LO",
      "name": "La Rioja",
      "parent": "RI",
      "type": "Province"
    },
    {
      "code": "ES-LU",
      "name": "Lugo",
      "parent": "GA",
      "type": "Province"
    },
    {
      "code": "ES-M",
      "name": "Madrid",
      "parent": "MD",
      "type": "Province"
    },
    {
      "code": "ES-MA",
      "name": "Málaga",
      "parent": "AN",
      "type": "Province"
    },
    {
      "code": "ES-MC",
      "name": "Murcia, Región de",
      "type": "Autonomous community"
    },
    {
      "code": "ES-MD",
      "name": "Madrid, Comunidad de",
      "type": "Autonomous community"
    },
    {
      "code": "ES-ML",
      "name": "Melilla",
      "type": "Autonomous city"
    },
    {
      "code": "ES-MU",
      "name": "Murcia",
      "parent": "MC",
      "type": "Province"
    },
    {
      "code": "ES-NA",
      "name": "Navarra / Nafarroa",
      "parent": "NC",
      "type": "Province"
    },
    {
      "code": "ES-NC",
      "name": "Navarra, Comunidad Foral de / Nafarroako Foru Komunitatea",
      "type": "Autonomous community"
    },
    {
      "code": "ES-O",
      "name": "Asturias",
      "parent": "AS",
      "type": "Province"
    },
    {
      "code": "ES-OR",
      "name": "Ourense",
      "parent": "GA",
      "type": "Province"
    },
    {
      "code": "ES-P",
      "name": "Palencia",
      "parent": "CL",
      "type": "Province"
    },
    {
      "code": "ES-PM",
      "name": "Balears",
      "parent": "IB",
      "type": "Province"
    },
    {
      "code": "ES-PO",
      "name": "Pontevedra",
      "parent": "GA",
      "type": "Province"
    },
    {
      "code": "ES-PV",
      "name": "País Vasco / Euskal Herria",
      "type": "Autonomous community"
    },
    {
      "code": "ES-RI",
      "name": "La Rioja",
      "type": "Autonomous community"
    },
    {
      "code": "ES-S",
      "name": "Cantabria",
      "parent": "CB",
      "type": "Province"
    },
    {
      "code": "ES-SA",
      "name": "Salamanca",
      "parent": "CL",
      "type": "Province"
    },
    {
      "code": "ES-SE",
      "name": "Sevilla",
      "parent": "AN",
      "type": "Province"
    },
    {
      "code": "ES-SG",
      "name": "Segovia",
      "parent": "CL",
      "type": "Province"
    },
    {
      "code": "ES-SO",
      "name": "Soria",
      "parent": "CL",
      "type": "Province"
    },
    {
      "code": "ES-SS",
      "name": "Gipuzkoa",
      "parent": "PV",
      "type": "Province"
    },
    {
      "code": "ES-T",
      "name": "Tarragona",
      "parent": "CT",
      "type": "Province"
    },
    {
      "code": "ES-TE",
      "name": "Teruel",
      "parent": "AR",
      "type": "Province"
    },
    {
      "code": "ES-TF",
      "name": "Santa Cruz de Tenerife",
      "parent": "CN",
      "type": "Province"
    },
    {
      "code": "ES-TO",
      "name": "Toledo",
      "parent": "CM",
      "type": "Province"
    },
    {
      "code": "ES-V",
      "name": "Valencia / València",
      "parent": "VC",
      "type": "Province"
    },
    {
      "code": "ES-VA",
      "name": "Valladolid",
      "parent": "CL",
      "type": "Province"
    },
    {
      "code": "ES-VC",
      "name": "Valenciana, Comunidad / Valenciana, Comunitat",
      "type": "Autonomous community"
    },
    {
      "code": "ES-VI",
      "name": "Álava",
      "parent": "PV",
      "type": "Province"
    },
    {
      "code": "ES-Z",
      "name": "Zaragoza",
      "parent": "AR",
      "type": "Province"
    },
    {
      "code": "ES-ZA",
      "name": "Zamora",
      "parent": "CL",
      "type": "Province"
    },
    {
      "code": "ET-AA",
      "name": "Ādīs Ābeba",
      "type": "Administration"
    },
    {
      "code": "ET-AF",
      "name": "Āfar",
      "type": "State"
    },
    {
      "code": "ET-AM",
      "name": "Āmara",
      "type": "State"
    },
    {
      "code": "ET-BE",
      "name": "Bīnshangul Gumuz",
      "type": "State"
    },
    {
      "code": "ET-DD",
      "name": "Dirē Dawa",
      "type": "Administration"
    },
    {
      "code": "ET-GA",
      "name": "Gambēla Hizboch",
      "type": "State"
    },
    {
      "code": "ET-HA",
      "name": "Hārerī Hizb",
      "type": "State"
    },
    {
      "code": "ET-OR",
      "name": "Oromīya",
      "type": "State"
    },
    {
      "code": "ET-SN",
      "name": "YeDebub Bihēroch Bihēreseboch na Hizboch",
      "type": "State"
    },
    {
      "code": "ET-SO",
      "name": "Sumalē",
      "type": "State"
    },
    {
      "code": "ET-TI",
      "name": "Tigray",
      "type": "State"
    },
    {
      "code": "FI-01",
      "name": "Ahvenanmaan maakunta",
      "type": "Region"
    },
    {
      "code": "FI-02",
      "name": "Etelä-Karjala",
      "type": "Region"
    },
    {
      "code": "FI-03",
      "name": "Etelä-Pohjanmaa",
      "type": "Region"
    },
    {
      "code": "FI-04",
      "name": "Etelä-Savo",
      "type": "Region"
    },
    {
      "code": "FI-05",
      "name": "Kainuu",
      "type": "Region"
    },
    {
      "code": "FI-06",
      "name": "Kanta-Häme",
      "type": "Region"
    },
    {
      "code": "FI-07",
      "name": "Keski-Pohjanmaa",
      "type": "Region"
    },
    {
      "code": "FI-08",
      "name": "Keski-Suomi",
      "type": "Region"
    },
    {
      "code": "FI-09",
      "name": "Kymenlaakso",
      "type": "Region"
    },
    {
      "code": "FI-10",
      "name": "Lappi",
      "type": "Region"
    },
    {
      "code": "FI-11",
      "name": "Pirkanmaa",
      "type": "Region"
    },
    {
      "code": "FI-12",
      "name": "Pohjanmaa",
      "type": "Region"
    },
    {
      "code": "FI-13",
      "name": "Pohjois-Karjala",
      "type": "Region"
    },
    {
      "code": "FI-14",
      "name": "Pohjois-Pohjanmaa",
      "type": "Region"
    },
    {
      "code": "FI-15",
      "name": "Pohjois-Savo",
      "type": "Region"
    },
    {
      "code": "FI-16",
      "name": "Päijät-Häme",
      "type": "Region"
    },
    {
      "code": "FI-17",
      "name": "Satakunta",
      "type": "Region"
    },
    {
      "code": "FI-18",
      "name": "Uusimaa",
      "type": "Region"
    },
    {
      "code": "FI-19",
      "name": "Varsinais-Suomi",
      "type": "Region"
    },
    {
      "code": "FJ-C",
      "name": "Central",
      "type": "Division"
    },
    {
      "code": "FJ-E",
      "name": "Eastern",
      "type": "Division"
    },
    {
      "code": "FJ-N",
      "name": "Northern",
      "type": "Division"
    },
    {
      "code": "FJ-R",
      "name": "Rotuma",
      "type": "Dependency"
    },
    {
      "code": "FJ-W",
      "name": "Western",
      "type": "Division"
    },
    {
      "code": "FM-KSA",
      "name": "Kosrae",
      "type": "State"
    },
    {
      "code": "FM-PNI",
      "name": "Pohnpei",
      "type": "State"
    },
    {
      "code": "FM-TRK",
      "name": "Chuuk",
      "type": "State"
    },
    {
      "code": "FM-YAP",
      "name": "Yap",
      "type": "State"
    },
    {
      "code": "FR-01",
      "name": "Ain",
      "parent": "V",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-02",
      "name": "Aisne",
      "parent": "S",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-03",
      "name": "Allier",
      "parent": "C",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-04",
      "name": "Alpes-de-Haute-Provence",
      "parent": "U",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-05",
      "name": "Hautes-Alpes",
      "parent": "U",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-06",
      "name": "Alpes-Maritimes",
      "parent": "U",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-07",
      "name": "Ardèche",
      "parent": "V",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-08",
      "name": "Ardennes",
      "parent": "G",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-09",
      "name": "Ariège",
      "parent": "N",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-10",
      "name": "Aube",
      "parent": "G",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-11",
      "name": "Aude",
      "parent": "K",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-12",
      "name": "Aveyron",
      "parent": "N",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-13",
      "name": "Bouches-du-Rhône",
      "parent": "U",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-14",
      "name": "Calvados",
      "parent": "P",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-15",
      "name": "Cantal",
      "parent": "C",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-16",
      "name": "Charente",
      "parent": "T",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-17",
      "name": "Charente-Maritime",
      "parent": "T",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-18",
      "name": "Cher",
      "parent": "F",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-19",
      "name": "Corrèze",
      "parent": "L",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-21",
      "name": "Côte-d'Or",
      "parent": "D",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-22",
      "name": "Côtes-d'Armor",
      "parent": "E",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-23",
      "name": "Creuse",
      "parent": "L",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-24",
      "name": "Dordogne",
      "parent": "B",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-25",
      "name": "Doubs",
      "parent": "I",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-26",
      "name": "Drôme",
      "parent": "V",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-27",
      "name": "Eure",
      "parent": "Q",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-28",
      "name": "Eure-et-Loir",
      "parent": "F",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-29",
      "name": "Finistère",
      "parent": "E",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-2A",
      "name": "Corse-du-Sud",
      "parent": "H",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-2B",
      "name": "Haute-Corse",
      "parent": "H",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-30",
      "name": "Gard",
      "parent": "K",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-31",
      "name": "Haute-Garonne",
      "parent": "N",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-32",
      "name": "Gers",
      "parent": "N",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-33",
      "name": "Gironde",
      "parent": "B",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-34",
      "name": "Hérault",
      "parent": "K",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-35",
      "name": "Ille-et-Vilaine",
      "parent": "E",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-36",
      "name": "Indre",
      "parent": "F",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-37",
      "name": "Indre-et-Loire",
      "parent": "F",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-38",
      "name": "Isère",
      "parent": "V",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-39",
      "name": "Jura",
      "parent": "I",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-40",
      "name": "Landes",
      "parent": "B",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-41",
      "name": "Loir-et-Cher",
      "parent": "F",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-42",
      "name": "Loire",
      "parent": "V",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-43",
      "name": "Haute-Loire",
      "parent": "C",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-44",
      "name": "Loire-Atlantique",
      "parent": "R",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-45",
      "name": "Loiret",
      "parent": "F",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-46",
      "name": "Lot",
      "parent": "N",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-47",
      "name": "Lot-et-Garonne",
      "parent": "B",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-48",
      "name": "Lozère",
      "parent": "K",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-49",
      "name": "Maine-et-Loire",
      "parent": "R",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-50",
      "name": "Manche",
      "parent": "P",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-51",
      "name": "Marne",
      "parent": "G",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-52",
      "name": "Haute-Marne",
      "parent": "G",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-53",
      "name": "Mayenne",
      "parent": "R",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-54",
      "name": "Meurthe-et-Moselle",
      "parent": "M",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-55",
      "name": "Meuse",
      "parent": "M",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-56",
      "name": "Morbihan",
      "parent": "E",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-57",
      "name": "Moselle",
      "parent": "M",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-58",
      "name": "Nièvre",
      "parent": "D",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-59",
      "name": "Nord",
      "parent": "O",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-60",
      "name": "Oise",
      "parent": "S",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-61",
      "name": "Orne",
      "parent": "P",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-62",
      "name": "Pas-de-Calais",
      "parent": "O",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-63",
      "name": "Puy-de-Dôme",
      "parent": "C",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-64",
      "name": "Pyrénées-Atlantiques",
      "parent": "B",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-65",
      "name": "Hautes-Pyrénées",
      "parent": "N",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-66",
      "name": "Pyrénées-Orientales",
      "parent": "K",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-67",
      "name": "Bas-Rhin",
      "parent": "A",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-68",
      "name": "Haut-Rhin",
      "parent": "A",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-69",
      "name": "Rhône",
      "parent": "V",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-70",
      "name": "Haute-Saône",
      "parent": "I",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-71",
      "name": "Saône-et-Loire",
      "parent": "D",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-72",
      "name": "Sarthe",
      "parent": "R",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-73",
      "name": "Savoie",
      "parent": "V",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-74",
      "name": "Haute-Savoie",
      "parent": "V",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-75",
      "name": "Paris",
      "parent": "J",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-76",
      "name": "Seine-Maritime",
      "parent": "Q",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-77",
      "name": "Seine-et-Marne",
      "parent": "J",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-78",
      "name": "Yvelines",
      "parent": "J",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-79",
      "name": "Deux-Sèvres",
      "parent": "T",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-80",
      "name": "Somme",
      "parent": "S",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-81",
      "name": "Tarn",
      "parent": "N",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-82",
      "name": "Tarn-et-Garonne",
      "parent": "N",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-83",
      "name": "Var",
      "parent": "U",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-84",
      "name": "Vaucluse",
      "parent": "U",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-85",
      "name": "Vendée",
      "parent": "R",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-86",
      "name": "Vienne",
      "parent": "T",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-87",
      "name": "Haute-Vienne",
      "parent": "L",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-88",
      "name": "Vosges",
      "parent": "M",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-89",
      "name": "Yonne",
      "parent": "D",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-90",
      "name": "Territoire de Belfort",
      "parent": "I",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-91",
      "name": "Essonne",
      "parent": "J",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-92",
      "name": "Hauts-de-Seine",
      "parent": "J",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-93",
      "name": "Seine-Saint-Denis",
      "parent": "J",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-94",
      "name": "Val-de-Marne",
      "parent": "J",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-95",
      "name": "Val d'Oise",
      "parent": "J",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-A",
      "name": "Alsace",
      "type": "Metropolitan region"
    },
    {
      "code": "FR-B",
      "name": "Aquitaine",
      "type": "Metropolitan region"
    },
    {
      "code": "FR-BL",
      "name": "Saint-Barthélemy",
      "type": "Overseas territorial collectivity"
    },
    {
      "code": "FR-C",
      "name": "Auvergne",
      "type": "Metropolitan region"
    },
    {
      "code": "FR-CP",
      "name": "Clipperton",
      "type": "Dependency"
    },
    {
      "code": "FR-D",
      "name": "Bourgogne",
      "type": "Metropolitan region"
    },
    {
      "code": "FR-E",
      "name": "Bretagne",
      "type": "Metropolitan region"
    },
    {
      "code": "FR-F",
      "name": "Centre",
      "type": "Metropolitan region"
    },
    {
      "code": "FR-G",
      "name": "Champagne-Ardenne",
      "type": "Metropolitan region"
    },
    {
      "code": "FR-GF",
      "name": "Guyane",
      "type": "Overseas region/department"
    },
    {
      "code": "FR-GP",
      "name": "Guadeloupe",
      "type": "Overseas region/department"
    },
    {
      "code": "FR-H",
      "name": "Corse",
      "type": "Metropolitan region"
    },
    {
      "code": "FR-I",
      "name": "Franche-Comté",
      "type": "Metropolitan region"
    },
    {
      "code": "FR-J",
      "name": "Île-de-France",
      "type": "Metropolitan region"
    },
    {
      "code": "FR-K",
      "name": "Languedoc-Roussillon",
      "type": "Metropolitan region"
    },
    {
      "code": "FR-L",
      "name": "Limousin",
      "type": "Metropolitan region"
    },
    {
      "code": "FR-M",
      "name": "Lorraine",
      "type": "Metropolitan region"
    },
    {
      "code": "FR-MF",
      "name": "Saint-Martin",
      "type": "Overseas territorial collectivity"
    },
    {
      "code": "FR-MQ",
      "name": "Martinique",
      "type": "Overseas region/department"
    },
    {
      "code": "FR-N",
      "name": "Midi-Pyrénées",
      "type": "Metropolitan region"
    },
    {
      "code": "FR-NC",
      "name": "Nouvelle-Calédonie",
      "type": "Overseas territorial collectivity"
    },
    {
      "code": "FR-O",
      "name": "Nord - Pas-de-Calais",
      "type": "Metropolitan region"
    },
    {
      "code": "FR-P",
      "name": "Basse-Normandie",
      "type": "Metropolitan region"
    },
    {
      "code": "FR-PF",
      "name": "Polynésie française",
      "type": "Overseas territorial collectivity"
    },
    {
      "code": "FR-PM",
      "name": "Saint-Pierre-et-Miquelon",
      "type": "Overseas territorial collectivity"
    },
    {
      "code": "FR-Q",
      "name": "Haute-Normandie",
      "type": "Metropolitan region"
    },
    {
      "code": "FR-R",
      "name": "Pays de la Loire",
      "type": "Metropolitan region"
    },
    {
      "code": "FR-RE",
      "name": "Réunion",
      "type": "Overseas region/department"
    },
    {
      "code": "FR-S",
      "name": "Picardie",
      "type": "Metropolitan region"
    },
    {
      "code": "FR-T",
      "name": "Poitou-Charentes",
      "type": "Metropolitan region"
    },
    {
      "code": "FR-TF",
      "name": "Terres australes françaises",
      "type": "Overseas territorial collectivity"
    },
    {
      "code": "FR-U",
      "name": "Provence-Alpes-Côte d'Azur",
      "type": "Metropolitan region"
    },
    {
      "code": "FR-V",
      "name": "Rhône-Alpes",
      "type": "Metropolitan region"
    },
    {
      "code": "FR-WF",
      "name": "Wallis-et-Futuna",
      "type": "Overseas territorial collectivity"
    },
    {
      "code": "FR-YT",
      "name": "Mayotte",
      "type": "Overseas region/department"
    },
    {
      "code": "GA-1",
      "name": "Estuaire",
      "type": "Province"
    },
    {
      "code": "GA-2",
      "name": "Haut-Ogooué",
      "type": "Province"
    },
    {
      "code": "GA-3",
      "name": "Moyen-Ogooué",
      "type": "Province"
    },
    {
      "code": "GA-4",
      "name": "Ngounié",
      "type": "Province"
    },
    {
      "code": "GA-5",
      "name": "Nyanga",
      "type": "Province"
    },
    {
      "code": "GA-6",
      "name": "Ogooué-Ivindo",
      "type": "Province"
    },
    {
      "code": "GA-7",
      "name": "Ogooué-Lolo",
      "type": "Province"
    },
    {
      "code": "GA-8",
      "name": "Ogooué-Maritime",
      "type": "Province"
    },
    {
      "code": "GA-9",
      "name": "Woleu-Ntem",
      "type": "Province"
    },
    {
      "code": "GB-ABC",
      "name": "Armagh, Banbridge and Craigavon",
      "parent": "NIR",
      "type": "District"
    },
    {
      "code": "GB-ABD",
      "name": "Aberdeenshire",
      "parent": "SCT",
      "type": "Council area"
    },
    {
      "code": "GB-ABE",
      "name": "Aberdeen City",
      "parent": "SCT",
      "type": "Council area"
    },
    {
      "code": "GB-AGB",
      "name": "Argyll and Bute",
      "parent": "SCT",
      "type": "Council area"
    },
    {
      "code": "GB-AGY",
      "name": "Isle of Anglesey; Sir Ynys Môn",
      "parent": "WLS",
      "type": "Unitary authority"
    },
    {
      "code": "GB-AND",
      "name": "Ards and North Down",
      "parent": "NIR",
      "type": "District"
    },
    {
      "code": "GB-ANN",
      "name": "Antrim and Newtownabbey",
      "parent": "NIR",
      "type": "District"
    },
    {
      "code": "GB-ANS",
      "name": "Angus",
      "parent": "SCT",
      "type": "Council area"
    },
    {
      "code": "GB-BAS",
      "name": "Bath and North East Somerset",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-BBD",
      "name": "Blackburn with Darwen",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-BDF",
      "name": "Bedford",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-BDG",
      "name": "Barking and Dagenham",
      "parent": "ENG",
      "type": "London borough"
    },
    {
      "code": "GB-BEN",
      "name": "Brent",
      "parent": "ENG",
      "type": "London borough"
    },
    {
      "code": "GB-BEX",
      "name": "Bexley",
      "parent": "ENG",
      "type": "London borough"
    },
    {
      "code": "GB-BFS",
      "name": "Belfast",
      "parent": "NIR",
      "type": "District"
    },
    {
      "code": "GB-BGE",
      "name": "Bridgend; Pen-y-bont ar Ogwr",
      "parent": "WLS",
      "type": "Unitary authority"
    },
    {
      "code": "GB-BGW",
      "name": "Blaenau Gwent",
      "parent": "WLS",
      "type": "Unitary authority"
    },
    {
      "code": "GB-BIR",
      "name": "Birmingham",
      "parent": "ENG",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-BKM",
      "name": "Buckinghamshire",
      "parent": "ENG",
      "type": "Two-tier county"
    },
    {
      "code": "GB-BMH",
      "name": "Bournemouth",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-BNE",
      "name": "Barnet",
      "parent": "ENG",
      "type": "London borough"
    },
    {
      "code": "GB-BNH",
      "name": "Brighton and Hove",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-BNS",
      "name": "Barnsley",
      "parent": "ENG",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-BOL",
      "name": "Bolton",
      "parent": "ENG",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-BPL",
      "name": "Blackpool",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-BRC",
      "name": "Bracknell Forest",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-BRD",
      "name": "Bradford",
      "parent": "ENG",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-BRY",
      "name": "Bromley",
      "parent": "ENG",
      "type": "London borough"
    },
    {
      "code": "GB-BST",
      "name": "Bristol, City of",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-BUR",
      "name": "Bury",
      "parent": "ENG",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-CAM",
      "name": "Cambridgeshire",
      "parent": "ENG",
      "type": "Two-tier county"
    },
    {
      "code": "GB-CAY",
      "name": "Caerphilly; Caerffili",
      "parent": "WLS",
      "type": "Unitary authority"
    },
    {
      "code": "GB-CBF",
      "name": "Central Bedfordshire",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-CCG",
      "name": "Causeway Coast and Glens",
      "parent": "NIR",
      "type": "District"
    },
    {
      "code": "GB-CGN",
      "name": "Ceredigion; Sir Ceredigion",
      "parent": "WLS",
      "type": "Unitary authority"
    },
    {
      "code": "GB-CHE",
      "name": "Cheshire East",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-CHW",
      "name": "Cheshire West and Chester",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-CLD",
      "name": "Calderdale",
      "parent": "ENG",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-CLK",
      "name": "Clackmannanshire",
      "parent": "SCT",
      "type": "Council area"
    },
    {
      "code": "GB-CMA",
      "name": "Cumbria",
      "parent": "ENG",
      "type": "Two-tier county"
    },
    {
      "code": "GB-CMD",
      "name": "Camden",
      "parent": "ENG",
      "type": "London borough"
    },
    {
      "code": "GB-CMN",
      "name": "Carmarthenshire; Sir Gaerfyrddin",
      "parent": "WLS",
      "type": "Unitary authority"
    },
    {
      "code": "GB-CON",
      "name": "Cornwall",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-COV",
      "name": "Coventry",
      "parent": "ENG",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-CRF",
      "name": "Cardiff; Caerdydd",
      "parent": "WLS",
      "type": "Unitary authority"
    },
    {
      "code": "GB-CRY",
      "name": "Croydon",
      "parent": "ENG",
      "type": "London borough"
    },
    {
      "code": "GB-CWY",
      "name": "Conwy",
      "parent": "WLS",
      "type": "Unitary authority"
    },
    {
      "code": "GB-DAL",
      "name": "Darlington",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-DBY",
      "name": "Derbyshire",
      "parent": "ENG",
      "type": "Two-tier county"
    },
    {
      "code": "GB-DEN",
      "name": "Denbighshire; Sir Ddinbych",
      "parent": "WLS",
      "type": "Unitary authority"
    },
    {
      "code": "GB-DER",
      "name": "Derby",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-DEV",
      "name": "Devon",
      "parent": "ENG",
      "type": "Two-tier county"
    },
    {
      "code": "GB-DGY",
      "name": "Dumfries and Galloway",
      "parent": "SCT",
      "type": "Council area"
    },
    {
      "code": "GB-DNC",
      "name": "Doncaster",
      "parent": "ENG",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-DND",
      "name": "Dundee City",
      "parent": "SCT",
      "type": "Council area"
    },
    {
      "code": "GB-DOR",
      "name": "Dorset",
      "parent": "ENG",
      "type": "Two-tier county"
    },
    {
      "code": "GB-DRS",
      "name": "Derry and Strabane",
      "parent": "NIR",
      "type": "District"
    },
    {
      "code": "GB-DUD",
      "name": "Dudley",
      "parent": "ENG",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-DUR",
      "name": "Durham County",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-EAL",
      "name": "Ealing",
      "parent": "ENG",
      "type": "London borough"
    },
    {
      "code": "GB-EAW",
      "name": "England and Wales",
      "type": "Nation"
    },
    {
      "code": "GB-EAY",
      "name": "East Ayrshire",
      "parent": "SCT",
      "type": "Council area"
    },
    {
      "code": "GB-EDH",
      "name": "Edinburgh, City of",
      "parent": "SCT",
      "type": "Council area"
    },
    {
      "code": "GB-EDU",
      "name": "East Dunbartonshire",
      "parent": "SCT",
      "type": "Council area"
    },
    {
      "code": "GB-ELN",
      "name": "East Lothian",
      "parent": "SCT",
      "type": "Council area"
    },
    {
      "code": "GB-ELS",
      "name": "Eilean Siar",
      "parent": "SCT",
      "type": "Council area"
    },
    {
      "code": "GB-ENF",
      "name": "Enfield",
      "parent": "ENG",
      "type": "London borough"
    },
    {
      "code": "GB-ENG",
      "name": "England",
      "type": "Country"
    },
    {
      "code": "GB-ERW",
      "name": "East Renfrewshire",
      "parent": "SCT",
      "type": "Council area"
    },
    {
      "code": "GB-ERY",
      "name": "East Riding of Yorkshire",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-ESS",
      "name": "Essex",
      "parent": "ENG",
      "type": "Two-tier county"
    },
    {
      "code": "GB-ESX",
      "name": "East Sussex",
      "parent": "ENG",
      "type": "Two-tier county"
    },
    {
      "code": "GB-FAL",
      "name": "Falkirk",
      "parent": "SCT",
      "type": "Council area"
    },
    {
      "code": "GB-FIF",
      "name": "Fife",
      "parent": "SCT",
      "type": "Council area"
    },
    {
      "code": "GB-FLN",
      "name": "Flintshire; Sir y Fflint",
      "parent": "WLS",
      "type": "Unitary authority"
    },
    {
      "code": "GB-FMO",
      "name": "Fermanagh and Omagh",
      "parent": "NIR",
      "type": "District"
    },
    {
      "code": "GB-GAT",
      "name": "Gateshead",
      "parent": "ENG",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-GBN",
      "name": "Great Britain",
      "type": "Nation"
    },
    {
      "code": "GB-GLG",
      "name": "Glasgow City",
      "parent": "SCT",
      "type": "Council area"
    },
    {
      "code": "GB-GLS",
      "name": "Gloucestershire",
      "parent": "ENG",
      "type": "Two-tier county"
    },
    {
      "code": "GB-GRE",
      "name": "Greenwich",
      "parent": "ENG",
      "type": "London borough"
    },
    {
      "code": "GB-GWN",
      "name": "Gwynedd",
      "parent": "WLS",
      "type": "Unitary authority"
    },
    {
      "code": "GB-HAL",
      "name": "Halton",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-HAM",
      "name": "Hampshire",
      "parent": "ENG",
      "type": "Two-tier county"
    },
    {
      "code": "GB-HAV",
      "name": "Havering",
      "parent": "ENG",
      "type": "London borough"
    },
    {
      "code": "GB-HCK",
      "name": "Hackney",
      "parent": "ENG",
      "type": "London borough"
    },
    {
      "code": "GB-HEF",
      "name": "Herefordshire",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-HIL",
      "name": "Hillingdon",
      "parent": "ENG",
      "type": "London borough"
    },
    {
      "code": "GB-HLD",
      "name": "Highland",
      "parent": "SCT",
      "type": "Council area"
    },
    {
      "code": "GB-HMF",
      "name": "Hammersmith and Fulham",
      "parent": "ENG",
      "type": "London borough"
    },
    {
      "code": "GB-HNS",
      "name": "Hounslow",
      "parent": "ENG",
      "type": "London borough"
    },
    {
      "code": "GB-HPL",
      "name": "Hartlepool",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-HRT",
      "name": "Hertfordshire",
      "parent": "ENG",
      "type": "Two-tier county"
    },
    {
      "code": "GB-HRW",
      "name": "Harrow",
      "parent": "ENG",
      "type": "London borough"
    },
    {
      "code": "GB-HRY",
      "name": "Haringey",
      "parent": "ENG",
      "type": "London borough"
    },
    {
      "code": "GB-IOS",
      "name": "Isles of Scilly",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-IOW",
      "name": "Isle of Wight",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-ISL",
      "name": "Islington",
      "parent": "ENG",
      "type": "London borough"
    },
    {
      "code": "GB-IVC",
      "name": "Inverclyde",
      "parent": "SCT",
      "type": "Council area"
    },
    {
      "code": "GB-KEC",
      "name": "Kensington and Chelsea",
      "parent": "ENG",
      "type": "London borough"
    },
    {
      "code": "GB-KEN",
      "name": "Kent",
      "parent": "ENG",
      "type": "Two-tier county"
    },
    {
      "code": "GB-KHL",
      "name": "Kingston upon Hull",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-KIR",
      "name": "Kirklees",
      "parent": "ENG",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-KTT",
      "name": "Kingston upon Thames",
      "parent": "ENG",
      "type": "London borough"
    },
    {
      "code": "GB-KWL",
      "name": "Knowsley",
      "parent": "ENG",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-LAN",
      "name": "Lancashire",
      "parent": "ENG",
      "type": "Two-tier county"
    },
    {
      "code": "GB-LBC",
      "name": "Lisburn and Castlereagh",
      "parent": "NIR",
      "type": "District"
    },
    {
      "code": "GB-LBH",
      "name": "Lambeth",
      "parent": "ENG",
      "type": "London borough"
    },
    {
      "code": "GB-LCE",
      "name": "Leicester",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-LDS",
      "name": "Leeds",
      "parent": "ENG",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-LEC",
      "name": "Leicestershire",
      "parent": "ENG",
      "type": "Two-tier county"
    },
    {
      "code": "GB-LEW",
      "name": "Lewisham",
      "parent": "ENG",
      "type": "London borough"
    },
    {
      "code": "GB-LIN",
      "name": "Lincolnshire",
      "parent": "ENG",
      "type": "Two-tier county"
    },
    {
      "code": "GB-LIV",
      "name": "Liverpool",
      "parent": "ENG",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-LND",
      "name": "London, City of",
      "parent": "ENG",
      "type": "City corporation"
    },
    {
      "code": "GB-LUT",
      "name": "Luton",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-MAN",
      "name": "Manchester",
      "parent": "ENG",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-MDB",
      "name": "Middlesbrough",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-MDW",
      "name": "Medway",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-MEA",
      "name": "Mid and East Antrim",
      "parent": "NIR",
      "type": "District"
    },
    {
      "code": "GB-MIK",
      "name": "Milton Keynes",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-MLN",
      "name": "Midlothian",
      "parent": "SCT",
      "type": "Council area"
    },
    {
      "code": "GB-MON",
      "name": "Monmouthshire; Sir Fynwy",
      "parent": "WLS",
      "type": "Unitary authority"
    },
    {
      "code": "GB-MRT",
      "name": "Merton",
      "parent": "ENG",
      "type": "London borough"
    },
    {
      "code": "GB-MRY",
      "name": "Moray",
      "parent": "SCT",
      "type": "Council area"
    },
    {
      "code": "GB-MTY",
      "name": "Merthyr Tydfil; Merthyr Tudful",
      "parent": "WLS",
      "type": "Unitary authority"
    },
    {
      "code": "GB-MUL",
      "name": "Mid Ulster",
      "parent": "NIR",
      "type": "District"
    },
    {
      "code": "GB-NAY",
      "name": "North Ayrshire",
      "parent": "SCT",
      "type": "Council area"
    },
    {
      "code": "GB-NBL",
      "name": "Northumberland",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-NEL",
      "name": "North East Lincolnshire",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-NET",
      "name": "Newcastle upon Tyne",
      "parent": "ENG",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-NFK",
      "name": "Norfolk",
      "parent": "ENG",
      "type": "Two-tier county"
    },
    {
      "code": "GB-NGM",
      "name": "Nottingham",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-NIR",
      "name": "Northern Ireland",
      "type": "Province"
    },
    {
      "code": "GB-NLK",
      "name": "North Lanarkshire",
      "parent": "SCT",
      "type": "Council area"
    },
    {
      "code": "GB-NLN",
      "name": "North Lincolnshire",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-NMD",
      "name": "Newry, Mourne and Down",
      "parent": "NIR",
      "type": "District"
    },
    {
      "code": "GB-NSM",
      "name": "North Somerset",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-NTH",
      "name": "Northamptonshire",
      "parent": "ENG",
      "type": "Two-tier county"
    },
    {
      "code": "GB-NTL",
      "name": "Neath Port Talbot; Castell-nedd Port Talbot",
      "parent": "WLS",
      "type": "Unitary authority"
    },
    {
      "code": "GB-NTT",
      "name": "Nottinghamshire",
      "parent": "ENG",
      "type": "Two-tier county"
    },
    {
      "code": "GB-NTY",
      "name": "North Tyneside",
      "parent": "ENG",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-NWM",
      "name": "Newham",
      "parent": "ENG",
      "type": "London borough"
    },
    {
      "code": "GB-NWP",
      "name": "Newport; Casnewydd",
      "parent": "WLS",
      "type": "Unitary authority"
    },
    {
      "code": "GB-NYK",
      "name": "North Yorkshire",
      "parent": "ENG",
      "type": "Two-tier county"
    },
    {
      "code": "GB-OLD",
      "name": "Oldham",
      "parent": "ENG",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-ORK",
      "name": "Orkney Islands",
      "parent": "SCT",
      "type": "Council area"
    },
    {
      "code": "GB-OXF",
      "name": "Oxfordshire",
      "parent": "ENG",
      "type": "Two-tier county"
    },
    {
      "code": "GB-PEM",
      "name": "Pembrokeshire; Sir Benfro",
      "parent": "WLS",
      "type": "Unitary authority"
    },
    {
      "code": "GB-PKN",
      "name": "Perth and Kinross",
      "parent": "SCT",
      "type": "Council area"
    },
    {
      "code": "GB-PLY",
      "name": "Plymouth",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-POL",
      "name": "Poole",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-POR",
      "name": "Portsmouth",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-POW",
      "name": "Powys",
      "parent": "WLS",
      "type": "Unitary authority"
    },
    {
      "code": "GB-PTE",
      "name": "Peterborough",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-RCC",
      "name": "Redcar and Cleveland",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-RCH",
      "name": "Rochdale",
      "parent": "ENG",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-RCT",
      "name": "Rhondda, Cynon, Taff; Rhondda, Cynon, Taf",
      "parent": "WLS",
      "type": "Unitary authority"
    },
    {
      "code": "GB-RDB",
      "name": "Redbridge",
      "parent": "ENG",
      "type": "London borough"
    },
    {
      "code": "GB-RDG",
      "name": "Reading",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-RFW",
      "name": "Renfrewshire",
      "parent": "SCT",
      "type": "Council area"
    },
    {
      "code": "GB-RIC",
      "name": "Richmond upon Thames",
      "parent": "ENG",
      "type": "London borough"
    },
    {
      "code": "GB-ROT",
      "name": "Rotherham",
      "parent": "ENG",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-RUT",
      "name": "Rutland",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-SAW",
      "name": "Sandwell",
      "parent": "ENG",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-SAY",
      "name": "South Ayrshire",
      "parent": "SCT",
      "type": "Council area"
    },
    {
      "code": "GB-SCB",
      "name": "Scottish Borders, The",
      "parent": "SCT",
      "type": "Council area"
    },
    {
      "code": "GB-SCT",
      "name": "Scotland",
      "type": "Country"
    },
    {
      "code": "GB-SFK",
      "name": "Suffolk",
      "parent": "ENG",
      "type": "Two-tier county"
    },
    {
      "code": "GB-SFT",
      "name": "Sefton",
      "parent": "ENG",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-SGC",
      "name": "South Gloucestershire",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-SHF",
      "name": "Sheffield",
      "parent": "ENG",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-SHN",
      "name": "St. Helens",
      "parent": "ENG",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-SHR",
      "name": "Shropshire",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-SKP",
      "name": "Stockport",
      "parent": "ENG",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-SLF",
      "name": "Salford",
      "parent": "ENG",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-SLG",
      "name": "Slough",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-SLK",
      "name": "South Lanarkshire",
      "parent": "SCT",
      "type": "Council area"
    },
    {
      "code": "GB-SND",
      "name": "Sunderland",
      "parent": "ENG",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-SOL",
      "name": "Solihull",
      "parent": "ENG",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-SOM",
      "name": "Somerset",
      "parent": "ENG",
      "type": "Two-tier county"
    },
    {
      "code": "GB-SOS",
      "name": "Southend-on-Sea",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-SRY",
      "name": "Surrey",
      "parent": "ENG",
      "type": "Two-tier county"
    },
    {
      "code": "GB-STE",
      "name": "Stoke-on-Trent",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-STG",
      "name": "Stirling",
      "parent": "SCT",
      "type": "Council area"
    },
    {
      "code": "GB-STH",
      "name": "Southampton",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-STN",
      "name": "Sutton",
      "parent": "ENG",
      "type": "London borough"
    },
    {
      "code": "GB-STS",
      "name": "Staffordshire",
      "parent": "ENG",
      "type": "Two-tier county"
    },
    {
      "code": "GB-STT",
      "name": "Stockton-on-Tees",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-STY",
      "name": "South Tyneside",
      "parent": "ENG",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-SWA",
      "name": "Swansea; Abertawe",
      "parent": "WLS",
      "type": "Unitary authority"
    },
    {
      "code": "GB-SWD",
      "name": "Swindon",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-SWK",
      "name": "Southwark",
      "parent": "ENG",
      "type": "London borough"
    },
    {
      "code": "GB-TAM",
      "name": "Tameside",
      "parent": "ENG",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-TFW",
      "name": "Telford and Wrekin",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-THR",
      "name": "Thurrock",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-TOB",
      "name": "Torbay",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-TOF",
      "name": "Torfaen; Tor-faen",
      "parent": "WLS",
      "type": "Unitary authority"
    },
    {
      "code": "GB-TRF",
      "name": "Trafford",
      "parent": "ENG",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-TWH",
      "name": "Tower Hamlets",
      "parent": "ENG",
      "type": "London borough"
    },
    {
      "code": "GB-UKM",
      "name": "United Kingdom",
      "type": "Nation"
    },
    {
      "code": "GB-VGL",
      "name": "Vale of Glamorgan, The; Bro Morgannwg",
      "parent": "WLS",
      "type": "Unitary authority"
    },
    {
      "code": "GB-WAR",
      "name": "Warwickshire",
      "parent": "ENG",
      "type": "Two-tier county"
    },
    {
      "code": "GB-WBK",
      "name": "West Berkshire",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-WDU",
      "name": "West Dunbartonshire",
      "parent": "SCT",
      "type": "Council area"
    },
    {
      "code": "GB-WFT",
      "name": "Waltham Forest",
      "parent": "ENG",
      "type": "London borough"
    },
    {
      "code": "GB-WGN",
      "name": "Wigan",
      "parent": "ENG",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-WIL",
      "name": "Wiltshire",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-WKF",
      "name": "Wakefield",
      "parent": "ENG",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-WLL",
      "name": "Walsall",
      "parent": "ENG",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-WLN",
      "name": "West Lothian",
      "parent": "SCT",
      "type": "Council area"
    },
    {
      "code": "GB-WLS",
      "name": "Wales; Cymru",
      "type": "Country"
    },
    {
      "code": "GB-WLV",
      "name": "Wolverhampton",
      "parent": "ENG",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-WND",
      "name": "Wandsworth",
      "parent": "ENG",
      "type": "London borough"
    },
    {
      "code": "GB-WNM",
      "name": "Windsor and Maidenhead",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-WOK",
      "name": "Wokingham",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-WOR",
      "name": "Worcestershire",
      "parent": "ENG",
      "type": "Two-tier county"
    },
    {
      "code": "GB-WRL",
      "name": "Wirral",
      "parent": "ENG",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-WRT",
      "name": "Warrington",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-WRX",
      "name": "Wrexham; Wrecsam",
      "parent": "WLS",
      "type": "Unitary authority"
    },
    {
      "code": "GB-WSM",
      "name": "Westminster",
      "parent": "ENG",
      "type": "London borough"
    },
    {
      "code": "GB-WSX",
      "name": "West Sussex",
      "parent": "ENG",
      "type": "Two-tier county"
    },
    {
      "code": "GB-YOR",
      "name": "York",
      "parent": "ENG",
      "type": "Unitary authority"
    },
    {
      "code": "GB-ZET",
      "name": "Shetland Islands",
      "parent": "SCT",
      "type": "Council area"
    },
    {
      "code": "GD-01",
      "name": "Saint Andrew",
      "type": "Parish"
    },
    {
      "code": "GD-02",
      "name": "Saint David",
      "type": "Parish"
    },
    {
      "code": "GD-03",
      "name": "Saint George",
      "type": "Parish"
    },
    {
      "code": "GD-04",
      "name": "Saint John",
      "type": "Parish"
    },
    {
      "code": "GD-05",
      "name": "Saint Mark",
      "type": "Parish"
    },
    {
      "code": "GD-06",
      "name": "Saint Patrick",
      "type": "Parish"
    },
    {
      "code": "GD-10",
      "name": "Southern Grenadine Islands",
      "type": "Dependency"
    },
    {
      "code": "GE-AB",
      "name": "Abkhazia",
      "type": "Autonomous republic"
    },
    {
      "code": "GE-AJ",
      "name": "Ajaria",
      "type": "Autonomous republic"
    },
    {
      "code": "GE-GU",
      "name": "Guria",
      "type": "Region"
    },
    {
      "code": "GE-IM",
      "name": "Imeret’i",
      "type": "Region"
    },
    {
      "code": "GE-KA",
      "name": "Kakhet’i",
      "type": "Region"
    },
    {
      "code": "GE-KK",
      "name": "K’vemo K’art’li",
      "type": "Region"
    },
    {
      "code": "GE-MM",
      "name": "Mts’khet’a-Mt’ianet’i",
      "type": "Region"
    },
    {
      "code": "GE-RL",
      "name": "Racha-Lech’khumi-K’vemo Svanet’i",
      "type": "Region"
    },
    {
      "code": "GE-SJ",
      "name": "Samts’khe-Javakhet’i",
      "type": "Region"
    },
    {
      "code": "GE-SK",
      "name": "Shida K’art’li",
      "type": "Region"
    },
    {
      "code": "GE-SZ",
      "name": "Samegrelo-Zemo Svanet’i",
      "type": "Region"
    },
    {
      "code": "GE-TB",
      "name": "T’bilisi",
      "type": "City"
    },
    {
      "code": "GH-AA",
      "name": "Greater Accra",
      "type": "Region"
    },
    {
      "code": "GH-AH",
      "name": "Ashanti",
      "type": "Region"
    },
    {
      "code": "GH-BA",
      "name": "Brong-Ahafo",
      "type": "Region"
    },
    {
      "code": "GH-CP",
      "name": "Central",
      "type": "Region"
    },
    {
      "code": "GH-EP",
      "name": "Eastern",
      "type": "Region"
    },
    {
      "code": "GH-NP",
      "name": "Northern",
      "type": "Region"
    },
    {
      "code": "GH-TV",
      "name": "Volta",
      "type": "Region"
    },
    {
      "code": "GH-UE",
      "name": "Upper East",
      "type": "Region"
    },
    {
      "code": "GH-UW",
      "name": "Upper West",
      "type": "Region"
    },
    {
      "code": "GH-WP",
      "name": "Western",
      "type": "Region"
    },
    {
      "code": "GL-KU",
      "name": "Kommune Kujalleq",
      "type": "Municipality"
    },
    {
      "code": "GL-QA",
      "name": "Qaasuitsup Kommunia",
      "type": "Municipality"
    },
    {
      "code": "GL-QE",
      "name": "Qeqqata Kommunia",
      "type": "Municipality"
    },
    {
      "code": "GL-SM",
      "name": "Kommuneqarfik Sermersooq",
      "type": "Municipality"
    },
    {
      "code": "GM-B",
      "name": "Banjul",
      "type": "City"
    },
    {
      "code": "GM-L",
      "name": "Lower River",
      "type": "Division"
    },
    {
      "code": "GM-M",
      "name": "Central River",
      "type": "Division"
    },
    {
      "code": "GM-N",
      "name": "North Bank",
      "type": "Division"
    },
    {
      "code": "GM-U",
      "name": "Upper River",
      "type": "Division"
    },
    {
      "code": "GM-W",
      "name": "Western",
      "type": "Division"
    },
    {
      "code": "GN-B",
      "name": "Boké",
      "type": "Governorate"
    },
    {
      "code": "GN-BE",
      "name": "Beyla",
      "parent": "N",
      "type": "Prefecture"
    },
    {
      "code": "GN-BF",
      "name": "Boffa",
      "parent": "B",
      "type": "Prefecture"
    },
    {
      "code": "GN-BK",
      "name": "Boké",
      "parent": "B",
      "type": "Prefecture"
    },
    {
      "code": "GN-C",
      "name": "Conakry",
      "type": "Special zone"
    },
    {
      "code": "GN-CO",
      "name": "Coyah",
      "parent": "D",
      "type": "Prefecture"
    },
    {
      "code": "GN-D",
      "name": "Kindia",
      "type": "Governorate"
    },
    {
      "code": "GN-DB",
      "name": "Dabola",
      "parent": "F",
      "type": "Prefecture"
    },
    {
      "code": "GN-DI",
      "name": "Dinguiraye",
      "parent": "F",
      "type": "Prefecture"
    },
    {
      "code": "GN-DL",
      "name": "Dalaba",
      "parent": "M",
      "type": "Prefecture"
    },
    {
      "code": "GN-DU",
      "name": "Dubréka",
      "parent": "D",
      "type": "Prefecture"
    },
    {
      "code": "GN-F",
      "name": "Faranah",
      "type": "Governorate"
    },
    {
      "code": "GN-FA",
      "name": "Faranah",
      "parent": "F",
      "type": "Prefecture"
    },
    {
      "code": "GN-FO",
      "name": "Forécariah",
      "parent": "D",
      "type": "Prefecture"
    },
    {
      "code": "GN-FR",
      "name": "Fria",
      "parent": "B",
      "type": "Prefecture"
    },
    {
      "code": "GN-GA",
      "name": "Gaoual",
      "parent": "B",
      "type": "Prefecture"
    },
    {
      "code": "GN-GU",
      "name": "Guékédou",
      "parent": "N",
      "type": "Prefecture"
    },
    {
      "code": "GN-K",
      "name": "Kankan",
      "type": "Governorate"
    },
    {
      "code": "GN-KA",
      "name": "Kankan",
      "parent": "K",
      "type": "Prefecture"
    },
    {
      "code": "GN-KB",
      "name": "Koubia",
      "parent": "L",
      "type": "Prefecture"
    },
    {
      "code": "GN-KD",
      "name": "Kindia",
      "parent": "D",
      "type": "Prefecture"
    },
    {
      "code": "GN-KE",
      "name": "Kérouané",
      "parent": "K",
      "type": "Prefecture"
    },
    {
      "code": "GN-KN",
      "name": "Koundara",
      "parent": "B",
      "type": "Prefecture"
    },
    {
      "code": "GN-KO",
      "name": "Kouroussa",
      "parent": "K",
      "type": "Prefecture"
    },
    {
      "code": "GN-KS",
      "name": "Kissidougou",
      "parent": "F",
      "type": "Prefecture"
    },
    {
      "code": "GN-L",
      "name": "Labé",
      "type": "Governorate"
    },
    {
      "code": "GN-LA",
      "name": "Labé",
      "parent": "L",
      "type": "Prefecture"
    },
    {
      "code": "GN-LE",
      "name": "Lélouma",
      "parent": "L",
      "type": "Prefecture"
    },
    {
      "code": "GN-LO",
      "name": "Lola",
      "parent": "N",
      "type": "Prefecture"
    },
    {
      "code": "GN-M",
      "name": "Mamou",
      "type": "Governorate"
    },
    {
      "code": "GN-MC",
      "name": "Macenta",
      "parent": "N",
      "type": "Prefecture"
    },
    {
      "code": "GN-MD",
      "name": "Mandiana",
      "parent": "K",
      "type": "Prefecture"
    },
    {
      "code": "GN-ML",
      "name": "Mali",
      "parent": "L",
      "type": "Prefecture"
    },
    {
      "code": "GN-MM",
      "name": "Mamou",
      "parent": "M",
      "type": "Prefecture"
    },
    {
      "code": "GN-N",
      "name": "Nzérékoré",
      "type": "Governorate"
    },
    {
      "code": "GN-NZ",
      "name": "Nzérékoré",
      "parent": "N",
      "type": "Prefecture"
    },
    {
      "code": "GN-PI",
      "name": "Pita",
      "parent": "M",
      "type": "Prefecture"
    },
    {
      "code": "GN-SI",
      "name": "Siguiri",
      "parent": "K",
      "type": "Prefecture"
    },
    {
      "code": "GN-TE",
      "name": "Télimélé",
      "parent": "D",
      "type": "Prefecture"
    },
    {
      "code": "GN-TO",
      "name": "Tougué",
      "parent": "L",
      "type": "Prefecture"
    },
    {
      "code": "GN-YO",
      "name": "Yomou",
      "parent": "N",
      "type": "Prefecture"
    },
    {
      "code": "GQ-AN",
      "name": "Annobón",
      "parent": "I",
      "type": "Province"
    },
    {
      "code": "GQ-BN",
      "name": "Bioko Norte",
      "parent": "I",
      "type": "Province"
    },
    {
      "code": "GQ-BS",
      "name": "Bioko Sur",
      "parent": "I",
      "type": "Province"
    },
    {
      "code": "GQ-C",
      "name": "Región Continental",
      "type": "Region"
    },
    {
      "code": "GQ-CS",
      "name": "Centro Sur",
      "parent": "C",
      "type": "Province"
    },
    {
      "code": "GQ-I",
      "name": "Región Insular",
      "type": "Region"
    },
    {
      "code": "GQ-KN",
      "name": "Kié-Ntem",
      "parent": "C",
      "type": "Province"
    },
    {
      "code": "GQ-LI",
      "name": "Litoral",
      "parent": "C",
      "type": "Province"
    },
    {
      "code": "GQ-WN",
      "name": "Wele-Nzas",
      "parent": "C",
      "type": "Province"
    },
    {
      "code": "GR-01",
      "name": "Aitolia kai Akarnania",
      "parent": "G",
      "type": "Department"
    },
    {
      "code": "GR-03",
      "name": "Voiotia",
      "parent": "H",
      "type": "Department"
    },
    {
      "code": "GR-04",
      "name": "Evvoias",
      "parent": "H",
      "type": "Department"
    },
    {
      "code": "GR-05",
      "name": "Evrytania",
      "parent": "H",
      "type": "Department"
    },
    {
      "code": "GR-06",
      "name": "Fthiotida",
      "parent": "H",
      "type": "Department"
    },
    {
      "code": "GR-07",
      "name": "Fokida",
      "parent": "H",
      "type": "Department"
    },
    {
      "code": "GR-11",
      "name": "Argolida",
      "parent": "J",
      "type": "Department"
    },
    {
      "code": "GR-12",
      "name": "Arkadia",
      "parent": "J",
      "type": "Department"
    },
    {
      "code": "GR-13",
      "name": "Achaïa",
      "parent": "G",
      "type": "Department"
    },
    {
      "code": "GR-14",
      "name": "Ileia",
      "parent": "G",
      "type": "Department"
    },
    {
      "code": "GR-15",
      "name": "Korinthia",
      "parent": "J",
      "type": "Department"
    },
    {
      "code": "GR-16",
      "name": "Lakonia",
      "parent": "J",
      "type": "Department"
    },
    {
      "code": "GR-17",
      "name": "Messinia",
      "parent": "J",
      "type": "Department"
    },
    {
      "code": "GR-21",
      "name": "Zakynthos",
      "parent": "F",
      "type": "Department"
    },
    {
      "code": "GR-22",
      "name": "Kerkyra",
      "parent": "F",
      "type": "Department"
    },
    {
      "code": "GR-23",
      "name": "Kefallonia",
      "parent": "F",
      "type": "Department"
    },
    {
      "code": "GR-24",
      "name": "Lefkada",
      "parent": "F",
      "type": "Department"
    },
    {
      "code": "GR-31",
      "name": "Arta",
      "parent": "F",
      "type": "Department"
    },
    {
      "code": "GR-32",
      "name": "Thesprotia",
      "parent": "D",
      "type": "Department"
    },
    {
      "code": "GR-33",
      "name": "Ioannina",
      "parent": "D",
      "type": "Department"
    },
    {
      "code": "GR-34",
      "name": "Preveza",
      "parent": "D",
      "type": "Department"
    },
    {
      "code": "GR-41",
      "name": "Karditsa",
      "parent": "E",
      "type": "Department"
    },
    {
      "code": "GR-42",
      "name": "Larisa",
      "parent": "E",
      "type": "Department"
    },
    {
      "code": "GR-43",
      "name": "Magnisia",
      "parent": "E",
      "type": "Department"
    },
    {
      "code": "GR-44",
      "name": "Trikala",
      "parent": "E",
      "type": "Department"
    },
    {
      "code": "GR-51",
      "name": "Grevena",
      "parent": "C",
      "type": "Department"
    },
    {
      "code": "GR-52",
      "name": "Drama",
      "parent": "A",
      "type": "Department"
    },
    {
      "code": "GR-53",
      "name": "Imathia",
      "parent": "B",
      "type": "Department"
    },
    {
      "code": "GR-54",
      "name": "Thessaloniki",
      "parent": "B",
      "type": "Department"
    },
    {
      "code": "GR-55",
      "name": "Kavala",
      "parent": "A",
      "type": "Department"
    },
    {
      "code": "GR-56",
      "name": "Kastoria",
      "parent": "C",
      "type": "Department"
    },
    {
      "code": "GR-57",
      "name": "Kilkis",
      "parent": "B",
      "type": "Department"
    },
    {
      "code": "GR-58",
      "name": "Kozani",
      "parent": "C",
      "type": "Department"
    },
    {
      "code": "GR-59",
      "name": "Pella",
      "parent": "B",
      "type": "Department"
    },
    {
      "code": "GR-61",
      "name": "Pieria",
      "parent": "B",
      "type": "Department"
    },
    {
      "code": "GR-62",
      "name": "Serres",
      "parent": "B",
      "type": "Department"
    },
    {
      "code": "GR-63",
      "name": "Florina",
      "parent": "C",
      "type": "Department"
    },
    {
      "code": "GR-64",
      "name": "Chalkidiki",
      "parent": "B",
      "type": "Department"
    },
    {
      "code": "GR-69",
      "name": "Agio Oros",
      "type": "Self-governed part"
    },
    {
      "code": "GR-71",
      "name": "Evros",
      "parent": "A",
      "type": "Department"
    },
    {
      "code": "GR-72",
      "name": "Xanthi",
      "parent": "A",
      "type": "Department"
    },
    {
      "code": "GR-73",
      "name": "Rodopi",
      "parent": "A",
      "type": "Department"
    },
    {
      "code": "GR-81",
      "name": "Dodekanisos",
      "parent": "L",
      "type": "Department"
    },
    {
      "code": "GR-82",
      "name": "Kyklades",
      "parent": "L",
      "type": "Department"
    },
    {
      "code": "GR-83",
      "name": "Lesvos",
      "parent": "K",
      "type": "Department"
    },
    {
      "code": "GR-84",
      "name": "Samos",
      "parent": "K",
      "type": "Department"
    },
    {
      "code": "GR-85",
      "name": "Chios",
      "parent": "K",
      "type": "Department"
    },
    {
      "code": "GR-91",
      "name": "Irakleio",
      "parent": "M",
      "type": "Department"
    },
    {
      "code": "GR-92",
      "name": "Lasithi",
      "parent": "M",
      "type": "Department"
    },
    {
      "code": "GR-93",
      "name": "Rethymno",
      "parent": "M",
      "type": "Department"
    },
    {
      "code": "GR-94",
      "name": "Chania",
      "parent": "M",
      "type": "Department"
    },
    {
      "code": "GR-A",
      "name": "Anatoliki Makedonia kai Thraki",
      "type": "Administrative region"
    },
    {
      "code": "GR-A1",
      "name": "Attiki",
      "parent": "I",
      "type": "Department"
    },
    {
      "code": "GR-B",
      "name": "Kentriki Makedonia",
      "type": "Administrative region"
    },
    {
      "code": "GR-C",
      "name": "Dytiki Makedonia",
      "type": "Administrative region"
    },
    {
      "code": "GR-D",
      "name": "Ipeiros",
      "type": "Administrative region"
    },
    {
      "code": "GR-E",
      "name": "Thessalia",
      "type": "Administrative region"
    },
    {
      "code": "GR-F",
      "name": "Ionia Nisia",
      "type": "Administrative region"
    },
    {
      "code": "GR-G",
      "name": "Dytiki Ellada",
      "type": "Administrative region"
    },
    {
      "code": "GR-H",
      "name": "Sterea Ellada",
      "type": "Administrative region"
    },
    {
      "code": "GR-I",
      "name": "Attiki",
      "type": "Administrative region"
    },
    {
      "code": "GR-J",
      "name": "Peloponnisos",
      "type": "Administrative region"
    },
    {
      "code": "GR-K",
      "name": "Voreio Aigaio",
      "type": "Administrative region"
    },
    {
      "code": "GR-L",
      "name": "Notio Aigaio",
      "type": "Administrative region"
    },
    {
      "code": "GR-M",
      "name": "Kriti",
      "type": "Administrative region"
    },
    {
      "code": "GT-AV",
      "name": "Alta Verapaz",
      "type": "Department"
    },
    {
      "code": "GT-BV",
      "name": "Baja Verapaz",
      "type": "Department"
    },
    {
      "code": "GT-CM",
      "name": "Chimaltenango",
      "type": "Department"
    },
    {
      "code": "GT-CQ",
      "name": "Chiquimula",
      "type": "Department"
    },
    {
      "code": "GT-ES",
      "name": "Escuintla",
      "type": "Department"
    },
    {
      "code": "GT-GU",
      "name": "Guatemala",
      "type": "Department"
    },
    {
      "code": "GT-HU",
      "name": "Huehuetenango",
      "type": "Department"
    },
    {
      "code": "GT-IZ",
      "name": "Izabal",
      "type": "Department"
    },
    {
      "code": "GT-JA",
      "name": "Jalapa",
      "type": "Department"
    },
    {
      "code": "GT-JU",
      "name": "Jutiapa",
      "type": "Department"
    },
    {
      "code": "GT-PE",
      "name": "Petén",
      "type": "Department"
    },
    {
      "code": "GT-PR",
      "name": "El Progreso",
      "type": "Department"
    },
    {
      "code": "GT-QC",
      "name": "Quiché",
      "type": "Department"
    },
    {
      "code": "GT-QZ",
      "name": "Quetzaltenango",
      "type": "Department"
    },
    {
      "code": "GT-RE",
      "name": "Retalhuleu",
      "type": "Department"
    },
    {
      "code": "GT-SA",
      "name": "Sacatepéquez",
      "type": "Department"
    },
    {
      "code": "GT-SM",
      "name": "San Marcos",
      "type": "Department"
    },
    {
      "code": "GT-SO",
      "name": "Sololá",
      "type": "Department"
    },
    {
      "code": "GT-SR",
      "name": "Santa Rosa",
      "type": "Department"
    },
    {
      "code": "GT-SU",
      "name": "Suchitepéquez",
      "type": "Department"
    },
    {
      "code": "GT-TO",
      "name": "Totonicapán",
      "type": "Department"
    },
    {
      "code": "GT-ZA",
      "name": "Zacapa",
      "type": "Department"
    },
    {
      "code": "GW-BA",
      "name": "Bafatá",
      "parent": "L",
      "type": "Region"
    },
    {
      "code": "GW-BL",
      "name": "Bolama",
      "parent": "S",
      "type": "Region"
    },
    {
      "code": "GW-BM",
      "name": "Biombo",
      "parent": "N",
      "type": "Region"
    },
    {
      "code": "GW-BS",
      "name": "Bissau",
      "type": "Autonomous sector"
    },
    {
      "code": "GW-CA",
      "name": "Cacheu",
      "parent": "N",
      "type": "Region"
    },
    {
      "code": "GW-GA",
      "name": "Gabú",
      "parent": "L",
      "type": "Region"
    },
    {
      "code": "GW-L",
      "name": "Leste",
      "type": "Province"
    },
    {
      "code": "GW-N",
      "name": "Norte",
      "type": "Province"
    },
    {
      "code": "GW-OI",
      "name": "Oio",
      "parent": "N",
      "type": "Region"
    },
    {
      "code": "GW-QU",
      "name": "Quinara",
      "parent": "S",
      "type": "Region"
    },
    {
      "code": "GW-S",
      "name": "Sul",
      "type": "Province"
    },
    {
      "code": "GW-TO",
      "name": "Tombali",
      "parent": "S",
      "type": "Region"
    },
    {
      "code": "GY-BA",
      "name": "Barima-Waini",
      "type": "Region"
    },
    {
      "code": "GY-CU",
      "name": "Cuyuni-Mazaruni",
      "type": "Region"
    },
    {
      "code": "GY-DE",
      "name": "Demerara-Mahaica",
      "type": "Region"
    },
    {
      "code": "GY-EB",
      "name": "East Berbice-Corentyne",
      "type": "Region"
    },
    {
      "code": "GY-ES",
      "name": "Essequibo Islands-West Demerara",
      "type": "Region"
    },
    {
      "code": "GY-MA",
      "name": "Mahaica-Berbice",
      "type": "Region"
    },
    {
      "code": "GY-PM",
      "name": "Pomeroon-Supenaam",
      "type": "Region"
    },
    {
      "code": "GY-PT",
      "name": "Potaro-Siparuni",
      "type": "Region"
    },
    {
      "code": "GY-UD",
      "name": "Upper Demerara-Berbice",
      "type": "Region"
    },
    {
      "code": "GY-UT",
      "name": "Upper Takutu-Upper Essequibo",
      "type": "Region"
    },
    {
      "code": "HN-AT",
      "name": "Atlántida",
      "type": "Department"
    },
    {
      "code": "HN-CH",
      "name": "Choluteca",
      "type": "Department"
    },
    {
      "code": "HN-CL",
      "name": "Colón",
      "type": "Department"
    },
    {
      "code": "HN-CM",
      "name": "Comayagua",
      "type": "Department"
    },
    {
      "code": "HN-CP",
      "name": "Copán",
      "type": "Department"
    },
    {
      "code": "HN-CR",
      "name": "Cortés",
      "type": "Department"
    },
    {
      "code": "HN-EP",
      "name": "El Paraíso",
      "type": "Department"
    },
    {
      "code": "HN-FM",
      "name": "Francisco Morazán",
      "type": "Department"
    },
    {
      "code": "HN-GD",
      "name": "Gracias a Dios",
      "type": "Department"
    },
    {
      "code": "HN-IB",
      "name": "Islas de la Bahía",
      "type": "Department"
    },
    {
      "code": "HN-IN",
      "name": "Intibucá",
      "type": "Department"
    },
    {
      "code": "HN-LE",
      "name": "Lempira",
      "type": "Department"
    },
    {
      "code": "HN-LP",
      "name": "La Paz",
      "type": "Department"
    },
    {
      "code": "HN-OC",
      "name": "Ocotepeque",
      "type": "Department"
    },
    {
      "code": "HN-OL",
      "name": "Olancho",
      "type": "Department"
    },
    {
      "code": "HN-SB",
      "name": "Santa Bárbara",
      "type": "Department"
    },
    {
      "code": "HN-VA",
      "name": "Valle",
      "type": "Department"
    },
    {
      "code": "HN-YO",
      "name": "Yoro",
      "type": "Department"
    },
    {
      "code": "HR-01",
      "name": "Zagrebačka županija",
      "type": "County"
    },
    {
      "code": "HR-02",
      "name": "Krapinsko-zagorska županija",
      "type": "County"
    },
    {
      "code": "HR-03",
      "name": "Sisačko-moslavačka županija",
      "type": "County"
    },
    {
      "code": "HR-04",
      "name": "Karlovačka županija",
      "type": "County"
    },
    {
      "code": "HR-05",
      "name": "Varaždinska županija",
      "type": "County"
    },
    {
      "code": "HR-06",
      "name": "Koprivničko-križevačka županija",
      "type": "County"
    },
    {
      "code": "HR-07",
      "name": "Bjelovarsko-bilogorska županija",
      "type": "County"
    },
    {
      "code": "HR-08",
      "name": "Primorsko-goranska županija",
      "type": "County"
    },
    {
      "code": "HR-09",
      "name": "Ličko-senjska županija",
      "type": "County"
    },
    {
      "code": "HR-10",
      "name": "Virovitičko-podravska županija",
      "type": "County"
    },
    {
      "code": "HR-11",
      "name": "Požeško-slavonska županija",
      "type": "County"
    },
    {
      "code": "HR-12",
      "name": "Brodsko-posavska županija",
      "type": "County"
    },
    {
      "code": "HR-13",
      "name": "Zadarska županija",
      "type": "County"
    },
    {
      "code": "HR-14",
      "name": "Osječko-baranjska županija",
      "type": "County"
    },
    {
      "code": "HR-15",
      "name": "Šibensko-kninska županija",
      "type": "County"
    },
    {
      "code": "HR-16",
      "name": "Vukovarsko-srijemska županija",
      "type": "County"
    },
    {
      "code": "HR-17",
      "name": "Splitsko-dalmatinska županija",
      "type": "County"
    },
    {
      "code": "HR-18",
      "name": "Istarska županija",
      "type": "County"
    },
    {
      "code": "HR-19",
      "name": "Dubrovačko-neretvanska županija",
      "type": "County"
    },
    {
      "code": "HR-20",
      "name": "Međimurska županija",
      "type": "County"
    },
    {
      "code": "HR-21",
      "name": "Grad Zagreb",
      "type": "City"
    },
    {
      "code": "HT-AR",
      "name": "Artibonite",
      "type": "Department"
    },
    {
      "code": "HT-CE",
      "name": "Centre",
      "type": "Department"
    },
    {
      "code": "HT-GA",
      "name": "Grande-Anse",
      "type": "Department"
    },
    {
      "code": "HT-ND",
      "name": "Nord",
      "type": "Department"
    },
    {
      "code": "HT-NE",
      "name": "Nord-Est",
      "type": "Department"
    },
    {
      "code": "HT-NO",
      "name": "Nord-Ouest",
      "type": "Department"
    },
    {
      "code": "HT-OU",
      "name": "Ouest",
      "type": "Department"
    },
    {
      "code": "HT-SD",
      "name": "Sud",
      "type": "Department"
    },
    {
      "code": "HT-SE",
      "name": "Sud-Est",
      "type": "Department"
    },
    {
      "code": "HU-BA",
      "name": "Baranya",
      "type": "County"
    },
    {
      "code": "HU-BC",
      "name": "Békéscsaba",
      "type": "City with county rights"
    },
    {
      "code": "HU-BE",
      "name": "Békés",
      "type": "County"
    },
    {
      "code": "HU-BK",
      "name": "Bács-Kiskun",
      "type": "County"
    },
    {
      "code": "HU-BU",
      "name": "Budapest",
      "type": "Capital city"
    },
    {
      "code": "HU-BZ",
      "name": "Borsod-Abaúj-Zemplén",
      "type": "County"
    },
    {
      "code": "HU-CS",
      "name": "Csongrád",
      "type": "County"
    },
    {
      "code": "HU-DE",
      "name": "Debrecen",
      "type": "City with county rights"
    },
    {
      "code": "HU-DU",
      "name": "Dunaújváros",
      "type": "City with county rights"
    },
    {
      "code": "HU-EG",
      "name": "Eger",
      "type": "City with county rights"
    },
    {
      "code": "HU-ER",
      "name": "Érd",
      "type": "City with county rights"
    },
    {
      "code": "HU-FE",
      "name": "Fejér",
      "type": "County"
    },
    {
      "code": "HU-GS",
      "name": "Győr-Moson-Sopron",
      "type": "County"
    },
    {
      "code": "HU-GY",
      "name": "Győr",
      "type": "City with county rights"
    },
    {
      "code": "HU-HB",
      "name": "Hajdú-Bihar",
      "type": "County"
    },
    {
      "code": "HU-HE",
      "name": "Heves",
      "type": "County"
    },
    {
      "code": "HU-HV",
      "name": "Hódmezővásárhely",
      "type": "City with county rights"
    },
    {
      "code": "HU-JN",
      "name": "Jász-Nagykun-Szolnok",
      "type": "County"
    },
    {
      "code": "HU-KE",
      "name": "Komárom-Esztergom",
      "type": "County"
    },
    {
      "code": "HU-KM",
      "name": "Kecskemét",
      "type": "City with county rights"
    },
    {
      "code": "HU-KV",
      "name": "Kaposvár",
      "type": "City with county rights"
    },
    {
      "code": "HU-MI",
      "name": "Miskolc",
      "type": "City with county rights"
    },
    {
      "code": "HU-NK",
      "name": "Nagykanizsa",
      "type": "City with county rights"
    },
    {
      "code": "HU-NO",
      "name": "Nógrád",
      "type": "County"
    },
    {
      "code": "HU-NY",
      "name": "Nyíregyháza",
      "type": "City with county rights"
    },
    {
      "code": "HU-PE",
      "name": "Pest",
      "type": "County"
    },
    {
      "code": "HU-PS",
      "name": "Pécs",
      "type": "City with county rights"
    },
    {
      "code": "HU-SD",
      "name": "Szeged",
      "type": "City with county rights"
    },
    {
      "code": "HU-SF",
      "name": "Székesfehérvár",
      "type": "City with county rights"
    },
    {
      "code": "HU-SH",
      "name": "Szombathely",
      "type": "City with county rights"
    },
    {
      "code": "HU-SK",
      "name": "Szolnok",
      "type": "City with county rights"
    },
    {
      "code": "HU-SN",
      "name": "Sopron",
      "type": "City with county rights"
    },
    {
      "code": "HU-SO",
      "name": "Somogy",
      "type": "County"
    },
    {
      "code": "HU-SS",
      "name": "Szekszárd",
      "type": "City with county rights"
    },
    {
      "code": "HU-ST",
      "name": "Salgótarján",
      "type": "City with county rights"
    },
    {
      "code": "HU-SZ",
      "name": "Szabolcs-Szatmár-Bereg",
      "type": "County"
    },
    {
      "code": "HU-TB",
      "name": "Tatabánya",
      "type": "City with county rights"
    },
    {
      "code": "HU-TO",
      "name": "Tolna",
      "type": "County"
    },
    {
      "code": "HU-VA",
      "name": "Vas",
      "type": "County"
    },
    {
      "code": "HU-VE",
      "name": "Veszprém (county)",
      "type": "County"
    },
    {
      "code": "HU-VM",
      "name": "Veszprém",
      "type": "City with county rights"
    },
    {
      "code": "HU-ZA",
      "name": "Zala",
      "type": "County"
    },
    {
      "code": "HU-ZE",
      "name": "Zalaegerszeg",
      "type": "City with county rights"
    },
    {
      "code": "ID-AC",
      "name": "Aceh",
      "parent": "SM",
      "type": "Autonomous Province"
    },
    {
      "code": "ID-BA",
      "name": "Bali",
      "parent": "NU",
      "type": "Province"
    },
    {
      "code": "ID-BB",
      "name": "Bangka Belitung",
      "parent": "SM",
      "type": "Province"
    },
    {
      "code": "ID-BE",
      "name": "Bengkulu",
      "parent": "SM",
      "type": "Province"
    },
    {
      "code": "ID-BT",
      "name": "Banten",
      "parent": "JW",
      "type": "Province"
    },
    {
      "code": "ID-GO",
      "name": "Gorontalo",
      "parent": "SL",
      "type": "Province"
    },
    {
      "code": "ID-IJ",
      "name": "Papua",
      "type": "Geographical unit"
    },
    {
      "code": "ID-JA",
      "name": "Jambi",
      "parent": "SM",
      "type": "Province"
    },
    {
      "code": "ID-JB",
      "name": "Jawa Barat",
      "parent": "JW",
      "type": "Province"
    },
    {
      "code": "ID-JI",
      "name": "Jawa Timur",
      "parent": "JW",
      "type": "Province"
    },
    {
      "code": "ID-JK",
      "name": "Jakarta Raya",
      "parent": "JW",
      "type": "Special District"
    },
    {
      "code": "ID-JT",
      "name": "Jawa Tengah",
      "parent": "JW",
      "type": "Province"
    },
    {
      "code": "ID-JW",
      "name": "Jawa",
      "type": "Geographical unit"
    },
    {
      "code": "ID-KA",
      "name": "Kalimantan",
      "type": "Geographical unit"
    },
    {
      "code": "ID-KB",
      "name": "Kalimantan Barat",
      "parent": "KA",
      "type": "Province"
    },
    {
      "code": "ID-KI",
      "name": "Kalimantan Timur",
      "parent": "KA",
      "type": "Province"
    },
    {
      "code": "ID-KR",
      "name": "Kepulauan Riau",
      "parent": "SM",
      "type": "Province"
    },
    {
      "code": "ID-KS",
      "name": "Kalimantan Selatan",
      "parent": "KA",
      "type": "Province"
    },
    {
      "code": "ID-KT",
      "name": "Kalimantan Tengah",
      "parent": "KA",
      "type": "Province"
    },
    {
      "code": "ID-LA",
      "name": "Lampung",
      "parent": "SM",
      "type": "Province"
    },
    {
      "code": "ID-MA",
      "name": "Maluku",
      "parent": "ML",
      "type": "Province"
    },
    {
      "code": "ID-ML",
      "name": "Maluku",
      "type": "Geographical unit"
    },
    {
      "code": "ID-MU",
      "name": "Maluku Utara",
      "parent": "ML",
      "type": "Province"
    },
    {
      "code": "ID-NB",
      "name": "Nusa Tenggara Barat",
      "parent": "NU",
      "type": "Province"
    },
    {
      "code": "ID-NT",
      "name": "Nusa Tenggara Timur",
      "parent": "NU",
      "type": "Province"
    },
    {
      "code": "ID-NU",
      "name": "Nusa Tenggara",
      "type": "Geographical unit"
    },
    {
      "code": "ID-PA",
      "name": "Papua",
      "parent": "IJ",
      "type": "Province"
    },
    {
      "code": "ID-PB",
      "name": "Papua Barat",
      "parent": "IJ",
      "type": "Province"
    },
    {
      "code": "ID-RI",
      "name": "Riau",
      "parent": "SM",
      "type": "Province"
    },
    {
      "code": "ID-SA",
      "name": "Sulawesi Utara",
      "parent": "SL",
      "type": "Province"
    },
    {
      "code": "ID-SB",
      "name": "Sumatra Barat",
      "parent": "SM",
      "type": "Province"
    },
    {
      "code": "ID-SG",
      "name": "Sulawesi Tenggara",
      "parent": "SL",
      "type": "Province"
    },
    {
      "code": "ID-SL",
      "name": "Sulawesi",
      "type": "Geographical unit"
    },
    {
      "code": "ID-SM",
      "name": "Sumatera",
      "type": "Geographical unit"
    },
    {
      "code": "ID-SN",
      "name": "Sulawesi Selatan",
      "parent": "SL",
      "type": "Province"
    },
    {
      "code": "ID-SR",
      "name": "Sulawesi Barat",
      "parent": "SL",
      "type": "Province"
    },
    {
      "code": "ID-SS",
      "name": "Sumatra Selatan",
      "parent": "SM",
      "type": "Province"
    },
    {
      "code": "ID-ST",
      "name": "Sulawesi Tengah",
      "parent": "SL",
      "type": "Province"
    },
    {
      "code": "ID-SU",
      "name": "Sumatera Utara",
      "parent": "SM",
      "type": "Province"
    },
    {
      "code": "ID-YO",
      "name": "Yogyakarta",
      "parent": "JW",
      "type": "Special Region"
    },
    {
      "code": "IE-C",
      "name": "Connacht",
      "type": "Province"
    },
    {
      "code": "IE-CE",
      "name": "Clare",
      "parent": "M",
      "type": "County"
    },
    {
      "code": "IE-CN",
      "name": "Cavan",
      "parent": "U",
      "type": "County"
    },
    {
      "code": "IE-CO",
      "name": "Cork",
      "parent": "M",
      "type": "County"
    },
    {
      "code": "IE-CW",
      "name": "Carlow",
      "parent": "L",
      "type": "County"
    },
    {
      "code": "IE-D",
      "name": "Dublin",
      "parent": "L",
      "type": "County"
    },
    {
      "code": "IE-DL",
      "name": "Donegal",
      "parent": "U",
      "type": "County"
    },
    {
      "code": "IE-G",
      "name": "Galway",
      "parent": "C",
      "type": "County"
    },
    {
      "code": "IE-KE",
      "name": "Kildare",
      "parent": "L",
      "type": "County"
    },
    {
      "code": "IE-KK",
      "name": "Kilkenny",
      "parent": "L",
      "type": "County"
    },
    {
      "code": "IE-KY",
      "name": "Kerry",
      "parent": "M",
      "type": "County"
    },
    {
      "code": "IE-L",
      "name": "Leinster",
      "type": "Province"
    },
    {
      "code": "IE-LD",
      "name": "Longford",
      "parent": "L",
      "type": "County"
    },
    {
      "code": "IE-LH",
      "name": "Louth",
      "parent": "L",
      "type": "County"
    },
    {
      "code": "IE-LK",
      "name": "Limerick",
      "parent": "M",
      "type": "County"
    },
    {
      "code": "IE-LM",
      "name": "Leitrim",
      "parent": "C",
      "type": "County"
    },
    {
      "code": "IE-LS",
      "name": "Laois",
      "parent": "L",
      "type": "County"
    },
    {
      "code": "IE-M",
      "name": "Munster",
      "type": "Province"
    },
    {
      "code": "IE-MH",
      "name": "Meath",
      "parent": "L",
      "type": "County"
    },
    {
      "code": "IE-MN",
      "name": "Monaghan",
      "parent": "U",
      "type": "County"
    },
    {
      "code": "IE-MO",
      "name": "Mayo",
      "parent": "C",
      "type": "County"
    },
    {
      "code": "IE-OY",
      "name": "Offaly",
      "parent": "L",
      "type": "County"
    },
    {
      "code": "IE-RN",
      "name": "Roscommon",
      "parent": "C",
      "type": "County"
    },
    {
      "code": "IE-SO",
      "name": "Sligo",
      "parent": "C",
      "type": "County"
    },
    {
      "code": "IE-TA",
      "name": "Tipperary",
      "parent": "M",
      "type": "County"
    },
    {
      "code": "IE-U",
      "name": "Ulster",
      "type": "Province"
    },
    {
      "code": "IE-WD",
      "name": "Waterford",
      "parent": "M",
      "type": "County"
    },
    {
      "code": "IE-WH",
      "name": "Westmeath",
      "parent": "L",
      "type": "County"
    },
    {
      "code": "IE-WW",
      "name": "Wicklow",
      "parent": "L",
      "type": "County"
    },
    {
      "code": "IE-WX",
      "name": "Wexford",
      "parent": "L",
      "type": "County"
    },
    {
      "code": "IL-D",
      "name": "HaDarom",
      "type": "District"
    },
    {
      "code": "IL-HA",
      "name": "Hefa",
      "type": "District"
    },
    {
      "code": "IL-JM",
      "name": "Yerushalayim Al Quds",
      "type": "District"
    },
    {
      "code": "IL-M",
      "name": "HaMerkaz",
      "type": "District"
    },
    {
      "code": "IL-TA",
      "name": "Tel-Aviv",
      "type": "District"
    },
    {
      "code": "IL-Z",
      "name": "HaZafon",
      "type": "District"
    },
    {
      "code": "IN-AN",
      "name": "Andaman and Nicobar Islands",
      "type": "Union territory"
    },
    {
      "code": "IN-AP",
      "name": "Andhra Pradesh",
      "type": "State"
    },
    {
      "code": "IN-AR",
      "name": "Arunachal Pradesh",
      "type": "State"
    },
    {
      "code": "IN-AS",
      "name": "Assam",
      "type": "State"
    },
    {
      "code": "IN-BR",
      "name": "Bihar",
      "type": "State"
    },
    {
      "code": "IN-CH",
      "name": "Chandigarh",
      "type": "Union territory"
    },
    {
      "code": "IN-CT",
      "name": "Chhattisgarh",
      "type": "State"
    },
    {
      "code": "IN-DD",
      "name": "Damen and Diu",
      "type": "Union territory"
    },
    {
      "code": "IN-DL",
      "name": "Delhi",
      "type": "Union territory"
    },
    {
      "code": "IN-DN",
      "name": "Dadra and Nagar Haveli",
      "type": "Union territory"
    },
    {
      "code": "IN-GA",
      "name": "Goa",
      "type": "State"
    },
    {
      "code": "IN-GJ",
      "name": "Gujarat",
      "type": "State"
    },
    {
      "code": "IN-HP",
      "name": "Himachal Pradesh",
      "type": "State"
    },
    {
      "code": "IN-HR",
      "name": "Haryana",
      "type": "State"
    },
    {
      "code": "IN-JH",
      "name": "Jharkhand",
      "type": "State"
    },
    {
      "code": "IN-JK",
      "name": "Jammu and Kashmir",
      "type": "State"
    },
    {
      "code": "IN-KA",
      "name": "Karnataka",
      "type": "State"
    },
    {
      "code": "IN-KL",
      "name": "Kerala",
      "type": "State"
    },
    {
      "code": "IN-LD",
      "name": "Lakshadweep",
      "type": "Union territory"
    },
    {
      "code": "IN-MH",
      "name": "Maharashtra",
      "type": "State"
    },
    {
      "code": "IN-ML",
      "name": "Meghalaya",
      "type": "State"
    },
    {
      "code": "IN-MN",
      "name": "Manipur",
      "type": "State"
    },
    {
      "code": "IN-MP",
      "name": "Madhya Pradesh",
      "type": "State"
    },
    {
      "code": "IN-MZ",
      "name": "Mizoram",
      "type": "State"
    },
    {
      "code": "IN-NL",
      "name": "Nagaland",
      "type": "State"
    },
    {
      "code": "IN-OR",
      "name": "Orissa",
      "type": "State"
    },
    {
      "code": "IN-PB",
      "name": "Punjab",
      "type": "State"
    },
    {
      "code": "IN-PY",
      "name": "Puducherry",
      "type": "Union territory"
    },
    {
      "code": "IN-RJ",
      "name": "Rajasthan",
      "type": "State"
    },
    {
      "code": "IN-SK",
      "name": "Sikkim",
      "type": "State"
    },
    {
      "code": "IN-TN",
      "name": "Tamil Nadu",
      "type": "State"
    },
    {
      "code": "IN-TR",
      "name": "Tripura",
      "type": "State"
    },
    {
      "code": "IN-UP",
      "name": "Uttar Pradesh",
      "type": "State"
    },
    {
      "code": "IN-UT",
      "name": "Uttarakhand",
      "type": "State"
    },
    {
      "code": "IN-WB",
      "name": "West Bengal",
      "type": "State"
    },
    {
      "code": "IQ-AN",
      "name": "Al Anbar",
      "type": "Governorate"
    },
    {
      "code": "IQ-AR",
      "name": "Arbil",
      "type": "Governorate"
    },
    {
      "code": "IQ-BA",
      "name": "Al Basrah",
      "type": "Governorate"
    },
    {
      "code": "IQ-BB",
      "name": "Babil",
      "type": "Governorate"
    },
    {
      "code": "IQ-BG",
      "name": "Baghdad",
      "type": "Governorate"
    },
    {
      "code": "IQ-DA",
      "name": "Dahuk",
      "type": "Governorate"
    },
    {
      "code": "IQ-DI",
      "name": "Diyala",
      "type": "Governorate"
    },
    {
      "code": "IQ-DQ",
      "name": "Dhi Qar",
      "type": "Governorate"
    },
    {
      "code": "IQ-KA",
      "name": "Karbala'",
      "type": "Governorate"
    },
    {
      "code": "IQ-MA",
      "name": "Maysan",
      "type": "Governorate"
    },
    {
      "code": "IQ-MU",
      "name": "Al Muthanna",
      "type": "Governorate"
    },
    {
      "code": "IQ-NA",
      "name": "An Najef",
      "type": "Governorate"
    },
    {
      "code": "IQ-NI",
      "name": "Ninawa",
      "type": "Governorate"
    },
    {
      "code": "IQ-QA",
      "name": "Al Qadisiyah",
      "type": "Governorate"
    },
    {
      "code": "IQ-SD",
      "name": "Salah ad Din",
      "type": "Governorate"
    },
    {
      "code": "IQ-SW",
      "name": "As Sulaymaniyah",
      "type": "Governorate"
    },
    {
      "code": "IQ-TS",
      "name": "At Ta'mim",
      "type": "Governorate"
    },
    {
      "code": "IQ-WA",
      "name": "Wasit",
      "type": "Governorate"
    },
    {
      "code": "IR-01",
      "name": "Āzarbāyjān-e Sharqī",
      "type": "Province"
    },
    {
      "code": "IR-02",
      "name": "Āzarbāyjān-e Gharbī",
      "type": "Province"
    },
    {
      "code": "IR-03",
      "name": "Ardabīl",
      "type": "Province"
    },
    {
      "code": "IR-04",
      "name": "Eşfahān",
      "type": "Province"
    },
    {
      "code": "IR-05",
      "name": "Īlām",
      "type": "Province"
    },
    {
      "code": "IR-06",
      "name": "Būshehr",
      "type": "Province"
    },
    {
      "code": "IR-07",
      "name": "Tehrān",
      "type": "Province"
    },
    {
      "code": "IR-08",
      "name": "Chahār Mahāll va Bakhtīārī",
      "type": "Province"
    },
    {
      "code": "IR-10",
      "name": "Khūzestān",
      "type": "Province"
    },
    {
      "code": "IR-11",
      "name": "Zanjān",
      "type": "Province"
    },
    {
      "code": "IR-12",
      "name": "Semnān",
      "type": "Province"
    },
    {
      "code": "IR-13",
      "name": "Sīstān va Balūchestān",
      "type": "Province"
    },
    {
      "code": "IR-14",
      "name": "Fārs",
      "type": "Province"
    },
    {
      "code": "IR-15",
      "name": "Kermān",
      "type": "Province"
    },
    {
      "code": "IR-16",
      "name": "Kordestān",
      "type": "Province"
    },
    {
      "code": "IR-17",
      "name": "Kermānshāh",
      "type": "Province"
    },
    {
      "code": "IR-18",
      "name": "Kohgīlūyeh va Būyer Ahmad",
      "type": "Province"
    },
    {
      "code": "IR-19",
      "name": "Gīlān",
      "type": "Province"
    },
    {
      "code": "IR-20",
      "name": "Lorestān",
      "type": "Province"
    },
    {
      "code": "IR-21",
      "name": "Māzandarān",
      "type": "Province"
    },
    {
      "code": "IR-22",
      "name": "Markazī",
      "type": "Province"
    },
    {
      "code": "IR-23",
      "name": "Hormozgān",
      "type": "Province"
    },
    {
      "code": "IR-24",
      "name": "Hamadān",
      "type": "Province"
    },
    {
      "code": "IR-25",
      "name": "Yazd",
      "type": "Province"
    },
    {
      "code": "IR-26",
      "name": "Qom",
      "type": "Province"
    },
    {
      "code": "IR-27",
      "name": "Golestān",
      "type": "Province"
    },
    {
      "code": "IR-28",
      "name": "Qazvīn",
      "type": "Province"
    },
    {
      "code": "IR-29",
      "name": "Khorāsān-e Janūbī",
      "type": "Province"
    },
    {
      "code": "IR-30",
      "name": "Khorāsān-e Razavī",
      "type": "Province"
    },
    {
      "code": "IR-31",
      "name": "Khorāsān-e Shemālī",
      "type": "Province"
    },
    {
      "code": "IS-0",
      "name": "Reykjavík",
      "type": "City"
    },
    {
      "code": "IS-1",
      "name": "Höfuðborgarsvæðið",
      "type": "Region"
    },
    {
      "code": "IS-2",
      "name": "Suðurnes",
      "type": "Region"
    },
    {
      "code": "IS-3",
      "name": "Vesturland",
      "type": "Region"
    },
    {
      "code": "IS-4",
      "name": "Vestfirðir",
      "type": "Region"
    },
    {
      "code": "IS-5",
      "name": "Norðurland vestra",
      "type": "Region"
    },
    {
      "code": "IS-6",
      "name": "Norðurland eystra",
      "type": "Region"
    },
    {
      "code": "IS-7",
      "name": "Austurland",
      "type": "Region"
    },
    {
      "code": "IS-8",
      "name": "Suðurland",
      "type": "Region"
    },
    {
      "code": "IT-21",
      "name": "Piemonte",
      "type": "Region"
    },
    {
      "code": "IT-23",
      "name": "Valle d'Aosta",
      "type": "Region"
    },
    {
      "code": "IT-25",
      "name": "Lombardia",
      "type": "Region"
    },
    {
      "code": "IT-32",
      "name": "Trentino-Alto Adige",
      "type": "Region"
    },
    {
      "code": "IT-34",
      "name": "Veneto",
      "type": "Region"
    },
    {
      "code": "IT-36",
      "name": "Friuli-Venezia Giulia",
      "type": "Region"
    },
    {
      "code": "IT-42",
      "name": "Liguria",
      "type": "Region"
    },
    {
      "code": "IT-45",
      "name": "Emilia-Romagna",
      "type": "Region"
    },
    {
      "code": "IT-52",
      "name": "Toscana",
      "type": "Region"
    },
    {
      "code": "IT-55",
      "name": "Umbria",
      "type": "Region"
    },
    {
      "code": "IT-57",
      "name": "Marche",
      "type": "Region"
    },
    {
      "code": "IT-62",
      "name": "Lazio",
      "type": "Region"
    },
    {
      "code": "IT-65",
      "name": "Abruzzo",
      "type": "Region"
    },
    {
      "code": "IT-67",
      "name": "Molise",
      "type": "Region"
    },
    {
      "code": "IT-72",
      "name": "Campania",
      "type": "Region"
    },
    {
      "code": "IT-75",
      "name": "Puglia",
      "type": "Region"
    },
    {
      "code": "IT-77",
      "name": "Basilicata",
      "type": "Region"
    },
    {
      "code": "IT-78",
      "name": "Calabria",
      "type": "Region"
    },
    {
      "code": "IT-82",
      "name": "Sicilia",
      "type": "Region"
    },
    {
      "code": "IT-88",
      "name": "Sardegna",
      "type": "Region"
    },
    {
      "code": "IT-AG",
      "name": "Agrigento",
      "parent": "82",
      "type": "Province"
    },
    {
      "code": "IT-AL",
      "name": "Alessandria",
      "parent": "21",
      "type": "Province"
    },
    {
      "code": "IT-AN",
      "name": "Ancona",
      "parent": "57",
      "type": "Province"
    },
    {
      "code": "IT-AO",
      "name": "Aosta",
      "parent": "23",
      "type": "Province"
    },
    {
      "code": "IT-AP",
      "name": "Ascoli Piceno",
      "parent": "57",
      "type": "Province"
    },
    {
      "code": "IT-AQ",
      "name": "L'Aquila",
      "parent": "65",
      "type": "Province"
    },
    {
      "code": "IT-AR",
      "name": "Arezzo",
      "parent": "52",
      "type": "Province"
    },
    {
      "code": "IT-AT",
      "name": "Asti",
      "parent": "21",
      "type": "Province"
    },
    {
      "code": "IT-AV",
      "name": "Avellino",
      "parent": "72",
      "type": "Province"
    },
    {
      "code": "IT-BA",
      "name": "Bari",
      "parent": "75",
      "type": "Province"
    },
    {
      "code": "IT-BG",
      "name": "Bergamo",
      "parent": "25",
      "type": "Province"
    },
    {
      "code": "IT-BI",
      "name": "Biella",
      "parent": "21",
      "type": "Province"
    },
    {
      "code": "IT-BL",
      "name": "Belluno",
      "parent": "34",
      "type": "Province"
    },
    {
      "code": "IT-BN",
      "name": "Benevento",
      "parent": "72",
      "type": "Province"
    },
    {
      "code": "IT-BO",
      "name": "Bologna",
      "parent": "45",
      "type": "Province"
    },
    {
      "code": "IT-BR",
      "name": "Brindisi",
      "parent": "75",
      "type": "Province"
    },
    {
      "code": "IT-BS",
      "name": "Brescia",
      "parent": "25",
      "type": "Province"
    },
    {
      "code": "IT-BT",
      "name": "Barletta-Andria-Trani",
      "parent": "75",
      "type": "Province"
    },
    {
      "code": "IT-BZ",
      "name": "Bolzano",
      "parent": "32",
      "type": "Province"
    },
    {
      "code": "IT-CA",
      "name": "Cagliari",
      "parent": "88",
      "type": "Province"
    },
    {
      "code": "IT-CB",
      "name": "Campobasso",
      "parent": "67",
      "type": "Province"
    },
    {
      "code": "IT-CE",
      "name": "Caserta",
      "parent": "72",
      "type": "Province"
    },
    {
      "code": "IT-CH",
      "name": "Chieti",
      "parent": "65",
      "type": "Province"
    },
    {
      "code": "IT-CI",
      "name": "Carbonia-Iglesias",
      "parent": "88",
      "type": "Province"
    },
    {
      "code": "IT-CL",
      "name": "Caltanissetta",
      "parent": "82",
      "type": "Province"
    },
    {
      "code": "IT-CN",
      "name": "Cuneo",
      "parent": "21",
      "type": "Province"
    },
    {
      "code": "IT-CO",
      "name": "Como",
      "parent": "25",
      "type": "Province"
    },
    {
      "code": "IT-CR",
      "name": "Cremona",
      "parent": "25",
      "type": "Province"
    },
    {
      "code": "IT-CS",
      "name": "Cosenza",
      "parent": "78",
      "type": "Province"
    },
    {
      "code": "IT-CT",
      "name": "Catania",
      "parent": "82",
      "type": "Province"
    },
    {
      "code": "IT-CZ",
      "name": "Catanzaro",
      "parent": "78",
      "type": "Province"
    },
    {
      "code": "IT-EN",
      "name": "Enna",
      "parent": "82",
      "type": "Province"
    },
    {
      "code": "IT-FC",
      "name": "Forlì-Cesena",
      "parent": "45",
      "type": "Province"
    },
    {
      "code": "IT-FE",
      "name": "Ferrara",
      "parent": "45",
      "type": "Province"
    },
    {
      "code": "IT-FG",
      "name": "Foggia",
      "parent": "75",
      "type": "Province"
    },
    {
      "code": "IT-FI",
      "name": "Firenze",
      "parent": "52",
      "type": "Province"
    },
    {
      "code": "IT-FM",
      "name": "Fermo",
      "parent": "57",
      "type": "Province"
    },
    {
      "code": "IT-FR",
      "name": "Frosinone",
      "parent": "62",
      "type": "Province"
    },
    {
      "code": "IT-GE",
      "name": "Genova",
      "parent": "42",
      "type": "Province"
    },
    {
      "code": "IT-GO",
      "name": "Gorizia",
      "parent": "36",
      "type": "Province"
    },
    {
      "code": "IT-GR",
      "name": "Grosseto",
      "parent": "52",
      "type": "Province"
    },
    {
      "code": "IT-IM",
      "name": "Imperia",
      "parent": "42",
      "type": "Province"
    },
    {
      "code": "IT-IS",
      "name": "Isernia",
      "parent": "67",
      "type": "Province"
    },
    {
      "code": "IT-KR",
      "name": "Crotone",
      "parent": "78",
      "type": "Province"
    },
    {
      "code": "IT-LC",
      "name": "Lecco",
      "parent": "25",
      "type": "Province"
    },
    {
      "code": "IT-LE",
      "name": "Lecce",
      "parent": "75",
      "type": "Province"
    },
    {
      "code": "IT-LI",
      "name": "Livorno",
      "parent": "52",
      "type": "Province"
    },
    {
      "code": "IT-LO",
      "name": "Lodi",
      "parent": "25",
      "type": "Province"
    },
    {
      "code": "IT-LT",
      "name": "Latina",
      "parent": "62",
      "type": "Province"
    },
    {
      "code": "IT-LU",
      "name": "Lucca",
      "parent": "52",
      "type": "Province"
    },
    {
      "code": "IT-MB",
      "name": "Monza e Brianza",
      "parent": "25",
      "type": "Province"
    },
    {
      "code": "IT-MC",
      "name": "Macerata",
      "parent": "57",
      "type": "Province"
    },
    {
      "code": "IT-ME",
      "name": "Messina",
      "parent": "82",
      "type": "Province"
    },
    {
      "code": "IT-MI",
      "name": "Milano",
      "parent": "25",
      "type": "Province"
    },
    {
      "code": "IT-MN",
      "name": "Mantova",
      "parent": "25",
      "type": "Province"
    },
    {
      "code": "IT-MO",
      "name": "Modena",
      "parent": "45",
      "type": "Province"
    },
    {
      "code": "IT-MS",
      "name": "Massa-Carrara",
      "parent": "52",
      "type": "Province"
    },
    {
      "code": "IT-MT",
      "name": "Matera",
      "parent": "77",
      "type": "Province"
    },
    {
      "code": "IT-NA",
      "name": "Napoli",
      "parent": "72",
      "type": "Province"
    },
    {
      "code": "IT-NO",
      "name": "Novara",
      "parent": "21",
      "type": "Province"
    },
    {
      "code": "IT-NU",
      "name": "Nuoro",
      "parent": "88",
      "type": "Province"
    },
    {
      "code": "IT-OG",
      "name": "Ogliastra",
      "parent": "88",
      "type": "Province"
    },
    {
      "code": "IT-OR",
      "name": "Oristano",
      "parent": "88",
      "type": "Province"
    },
    {
      "code": "IT-OT",
      "name": "Olbia-Tempio",
      "parent": "88",
      "type": "Province"
    },
    {
      "code": "IT-PA",
      "name": "Palermo",
      "parent": "82",
      "type": "Province"
    },
    {
      "code": "IT-PC",
      "name": "Piacenza",
      "parent": "45",
      "type": "Province"
    },
    {
      "code": "IT-PD",
      "name": "Padova",
      "parent": "34",
      "type": "Province"
    },
    {
      "code": "IT-PE",
      "name": "Pescara",
      "parent": "65",
      "type": "Province"
    },
    {
      "code": "IT-PG",
      "name": "Perugia",
      "parent": "55",
      "type": "Province"
    },
    {
      "code": "IT-PI",
      "name": "Pisa",
      "parent": "52",
      "type": "Province"
    },
    {
      "code": "IT-PN",
      "name": "Pordenone",
      "parent": "36",
      "type": "Province"
    },
    {
      "code": "IT-PO",
      "name": "Prato",
      "parent": "52",
      "type": "Province"
    },
    {
      "code": "IT-PR",
      "name": "Parma",
      "parent": "45",
      "type": "Province"
    },
    {
      "code": "IT-PT",
      "name": "Pistoia",
      "parent": "52",
      "type": "Province"
    },
    {
      "code": "IT-PU",
      "name": "Pesaro e Urbino",
      "parent": "57",
      "type": "Province"
    },
    {
      "code": "IT-PV",
      "name": "Pavia",
      "parent": "25",
      "type": "Province"
    },
    {
      "code": "IT-PZ",
      "name": "Potenza",
      "parent": "77",
      "type": "Province"
    },
    {
      "code": "IT-RA",
      "name": "Ravenna",
      "parent": "45",
      "type": "Province"
    },
    {
      "code": "IT-RC",
      "name": "Reggio Calabria",
      "parent": "78",
      "type": "Province"
    },
    {
      "code": "IT-RE",
      "name": "Reggio Emilia",
      "parent": "45",
      "type": "Province"
    },
    {
      "code": "IT-RG",
      "name": "Ragusa",
      "parent": "82",
      "type": "Province"
    },
    {
      "code": "IT-RI",
      "name": "Rieti",
      "parent": "62",
      "type": "Province"
    },
    {
      "code": "IT-RM",
      "name": "Roma",
      "parent": "62",
      "type": "Province"
    },
    {
      "code": "IT-RN",
      "name": "Rimini",
      "parent": "45",
      "type": "Province"
    },
    {
      "code": "IT-RO",
      "name": "Rovigo",
      "parent": "34",
      "type": "Province"
    },
    {
      "code": "IT-SA",
      "name": "Salerno",
      "parent": "72",
      "type": "Province"
    },
    {
      "code": "IT-SI",
      "name": "Siena",
      "parent": "52",
      "type": "Province"
    },
    {
      "code": "IT-SO",
      "name": "Sondrio",
      "parent": "25",
      "type": "Province"
    },
    {
      "code": "IT-SP",
      "name": "La Spezia",
      "parent": "42",
      "type": "Province"
    },
    {
      "code": "IT-SR",
      "name": "Siracusa",
      "parent": "82",
      "type": "Province"
    },
    {
      "code": "IT-SS",
      "name": "Sassari",
      "parent": "88",
      "type": "Province"
    },
    {
      "code": "IT-SV",
      "name": "Savona",
      "parent": "42",
      "type": "Province"
    },
    {
      "code": "IT-TA",
      "name": "Taranto",
      "parent": "75",
      "type": "Province"
    },
    {
      "code": "IT-TE",
      "name": "Teramo",
      "parent": "65",
      "type": "Province"
    },
    {
      "code": "IT-TN",
      "name": "Trento",
      "parent": "32",
      "type": "Province"
    },
    {
      "code": "IT-TO",
      "name": "Torino",
      "parent": "21",
      "type": "Province"
    },
    {
      "code": "IT-TP",
      "name": "Trapani",
      "parent": "82",
      "type": "Province"
    },
    {
      "code": "IT-TR",
      "name": "Terni",
      "parent": "55",
      "type": "Province"
    },
    {
      "code": "IT-TS",
      "name": "Trieste",
      "parent": "36",
      "type": "Province"
    },
    {
      "code": "IT-TV",
      "name": "Treviso",
      "parent": "34",
      "type": "Province"
    },
    {
      "code": "IT-UD",
      "name": "Udine",
      "parent": "36",
      "type": "Province"
    },
    {
      "code": "IT-VA",
      "name": "Varese",
      "parent": "25",
      "type": "Province"
    },
    {
      "code": "IT-VB",
      "name": "Verbano-Cusio-Ossola",
      "parent": "21",
      "type": "Province"
    },
    {
      "code": "IT-VC",
      "name": "Vercelli",
      "parent": "21",
      "type": "Province"
    },
    {
      "code": "IT-VE",
      "name": "Venezia",
      "parent": "34",
      "type": "Province"
    },
    {
      "code": "IT-VI",
      "name": "Vicenza",
      "parent": "34",
      "type": "Province"
    },
    {
      "code": "IT-VR",
      "name": "Verona",
      "parent": "34",
      "type": "Province"
    },
    {
      "code": "IT-VS",
      "name": "Medio Campidano",
      "parent": "88",
      "type": "Province"
    },
    {
      "code": "IT-VT",
      "name": "Viterbo",
      "parent": "62",
      "type": "Province"
    },
    {
      "code": "IT-VV",
      "name": "Vibo Valentia",
      "parent": "78",
      "type": "Province"
    },
    {
      "code": "JM-01",
      "name": "Kingston",
      "type": "Parish"
    },
    {
      "code": "JM-02",
      "name": "Saint Andrew",
      "type": "Parish"
    },
    {
      "code": "JM-03",
      "name": "Saint Thomas",
      "type": "Parish"
    },
    {
      "code": "JM-04",
      "name": "Portland",
      "type": "Parish"
    },
    {
      "code": "JM-05",
      "name": "Saint Mary",
      "type": "Parish"
    },
    {
      "code": "JM-06",
      "name": "Saint Ann",
      "type": "Parish"
    },
    {
      "code": "JM-07",
      "name": "Trelawny",
      "type": "Parish"
    },
    {
      "code": "JM-08",
      "name": "Saint James",
      "type": "Parish"
    },
    {
      "code": "JM-09",
      "name": "Hanover",
      "type": "Parish"
    },
    {
      "code": "JM-10",
      "name": "Westmoreland",
      "type": "Parish"
    },
    {
      "code": "JM-11",
      "name": "Saint Elizabeth",
      "type": "Parish"
    },
    {
      "code": "JM-12",
      "name": "Manchester",
      "type": "Parish"
    },
    {
      "code": "JM-13",
      "name": "Clarendon",
      "type": "Parish"
    },
    {
      "code": "JM-14",
      "name": "Saint Catherine",
      "type": "Parish"
    },
    {
      "code": "JO-AJ",
      "name": "‘Ajlūn",
      "type": "Governorate"
    },
    {
      "code": "JO-AM",
      "name": "‘Ammān (Al ‘Aşimah)",
      "type": "Governorate"
    },
    {
      "code": "JO-AQ",
      "name": "Al ‘Aqabah",
      "type": "Governorate"
    },
    {
      "code": "JO-AT",
      "name": "Aţ Ţafīlah",
      "type": "Governorate"
    },
    {
      "code": "JO-AZ",
      "name": "Az Zarqā'",
      "type": "Governorate"
    },
    {
      "code": "JO-BA",
      "name": "Al Balqā'",
      "type": "Governorate"
    },
    {
      "code": "JO-IR",
      "name": "Irbid",
      "type": "Governorate"
    },
    {
      "code": "JO-JA",
      "name": "Jarash",
      "type": "Governorate"
    },
    {
      "code": "JO-KA",
      "name": "Al Karak",
      "type": "Governorate"
    },
    {
      "code": "JO-MA",
      "name": "Al Mafraq",
      "type": "Governorate"
    },
    {
      "code": "JO-MD",
      "name": "Mādabā",
      "type": "Governorate"
    },
    {
      "code": "JO-MN",
      "name": "Ma‘ān",
      "type": "Governorate"
    },
    {
      "code": "JP-01",
      "name": "Hokkaido",
      "type": "Prefecture"
    },
    {
      "code": "JP-02",
      "name": "Aomori",
      "type": "Prefecture"
    },
    {
      "code": "JP-03",
      "name": "Iwate",
      "type": "Prefecture"
    },
    {
      "code": "JP-04",
      "name": "Miyagi",
      "type": "Prefecture"
    },
    {
      "code": "JP-05",
      "name": "Akita",
      "type": "Prefecture"
    },
    {
      "code": "JP-06",
      "name": "Yamagata",
      "type": "Prefecture"
    },
    {
      "code": "JP-07",
      "name": "Fukushima",
      "type": "Prefecture"
    },
    {
      "code": "JP-08",
      "name": "Ibaraki",
      "type": "Prefecture"
    },
    {
      "code": "JP-09",
      "name": "Tochigi",
      "type": "Prefecture"
    },
    {
      "code": "JP-10",
      "name": "Gunma",
      "type": "Prefecture"
    },
    {
      "code": "JP-11",
      "name": "Saitama",
      "type": "Prefecture"
    },
    {
      "code": "JP-12",
      "name": "Chiba",
      "type": "Prefecture"
    },
    {
      "code": "JP-13",
      "name": "Tokyo",
      "type": "Prefecture"
    },
    {
      "code": "JP-14",
      "name": "Kanagawa",
      "type": "Prefecture"
    },
    {
      "code": "JP-15",
      "name": "Niigata",
      "type": "Prefecture"
    },
    {
      "code": "JP-16",
      "name": "Toyama",
      "type": "Prefecture"
    },
    {
      "code": "JP-17",
      "name": "Ishikawa",
      "type": "Prefecture"
    },
    {
      "code": "JP-18",
      "name": "Fukui",
      "type": "Prefecture"
    },
    {
      "code": "JP-19",
      "name": "Yamanashi",
      "type": "Prefecture"
    },
    {
      "code": "JP-20",
      "name": "Nagano",
      "type": "Prefecture"
    },
    {
      "code": "JP-21",
      "name": "Gifu",
      "type": "Prefecture"
    },
    {
      "code": "JP-22",
      "name": "Shizuoka",
      "type": "Prefecture"
    },
    {
      "code": "JP-23",
      "name": "Aichi",
      "type": "Prefecture"
    },
    {
      "code": "JP-24",
      "name": "Mie",
      "type": "Prefecture"
    },
    {
      "code": "JP-25",
      "name": "Shiga",
      "type": "Prefecture"
    },
    {
      "code": "JP-26",
      "name": "Kyoto",
      "type": "Prefecture"
    },
    {
      "code": "JP-27",
      "name": "Osaka",
      "type": "Prefecture"
    },
    {
      "code": "JP-28",
      "name": "Hyogo",
      "type": "Prefecture"
    },
    {
      "code": "JP-29",
      "name": "Nara",
      "type": "Prefecture"
    },
    {
      "code": "JP-30",
      "name": "Wakayama",
      "type": "Prefecture"
    },
    {
      "code": "JP-31",
      "name": "Tottori",
      "type": "Prefecture"
    },
    {
      "code": "JP-32",
      "name": "Shimane",
      "type": "Prefecture"
    },
    {
      "code": "JP-33",
      "name": "Okayama",
      "type": "Prefecture"
    },
    {
      "code": "JP-34",
      "name": "Hiroshima",
      "type": "Prefecture"
    },
    {
      "code": "JP-35",
      "name": "Yamaguchi",
      "type": "Prefecture"
    },
    {
      "code": "JP-36",
      "name": "Tokushima",
      "type": "Prefecture"
    },
    {
      "code": "JP-37",
      "name": "Kagawa",
      "type": "Prefecture"
    },
    {
      "code": "JP-38",
      "name": "Ehime",
      "type": "Prefecture"
    },
    {
      "code": "JP-39",
      "name": "Kochi",
      "type": "Prefecture"
    },
    {
      "code": "JP-40",
      "name": "Fukuoka",
      "type": "Prefecture"
    },
    {
      "code": "JP-41",
      "name": "Saga",
      "type": "Prefecture"
    },
    {
      "code": "JP-42",
      "name": "Nagasaki",
      "type": "Prefecture"
    },
    {
      "code": "JP-43",
      "name": "Kumamoto",
      "type": "Prefecture"
    },
    {
      "code": "JP-44",
      "name": "Oita",
      "type": "Prefecture"
    },
    {
      "code": "JP-45",
      "name": "Miyazaki",
      "type": "Prefecture"
    },
    {
      "code": "JP-46",
      "name": "Kagoshima",
      "type": "Prefecture"
    },
    {
      "code": "JP-47",
      "name": "Okinawa",
      "type": "Prefecture"
    },
    {
      "code": "KE-110",
      "name": "Nairobi Municipality",
      "type": "Province"
    },
    {
      "code": "KE-200",
      "name": "Central",
      "type": "Province"
    },
    {
      "code": "KE-300",
      "name": "Coast",
      "type": "Province"
    },
    {
      "code": "KE-400",
      "name": "Eastern",
      "type": "Province"
    },
    {
      "code": "KE-500",
      "name": "North-Eastern Kaskazini Mashariki",
      "type": "Province"
    },
    {
      "code": "KE-700",
      "name": "Rift Valley",
      "type": "Province"
    },
    {
      "code": "KE-800",
      "name": "Western Magharibi",
      "type": "Province"
    },
    {
      "code": "KG-B",
      "name": "Batken",
      "type": "Region"
    },
    {
      "code": "KG-C",
      "name": "Chü",
      "type": "Region"
    },
    {
      "code": "KG-GB",
      "name": "Bishkek",
      "type": "City"
    },
    {
      "code": "KG-J",
      "name": "Jalal-Abad",
      "type": "Region"
    },
    {
      "code": "KG-N",
      "name": "Naryn",
      "type": "Region"
    },
    {
      "code": "KG-O",
      "name": "Osh",
      "type": "Region"
    },
    {
      "code": "KG-T",
      "name": "Talas",
      "type": "Region"
    },
    {
      "code": "KG-Y",
      "name": "Ysyk-Köl",
      "type": "Region"
    },
    {
      "code": "KH-1",
      "name": "Banteay Mean Chey",
      "type": "Province"
    },
    {
      "code": "KH-10",
      "name": "Krachoh",
      "type": "Province"
    },
    {
      "code": "KH-11",
      "name": "Mondol Kiri",
      "type": "Province"
    },
    {
      "code": "KH-12",
      "name": "Phnom Penh",
      "type": "Autonomous municipality"
    },
    {
      "code": "KH-13",
      "name": "Preah Vihear",
      "type": "Province"
    },
    {
      "code": "KH-14",
      "name": "Prey Veaeng",
      "type": "Province"
    },
    {
      "code": "KH-15",
      "name": "Pousaat",
      "type": "Province"
    },
    {
      "code": "KH-16",
      "name": "Rotanak Kiri",
      "type": "Province"
    },
    {
      "code": "KH-17",
      "name": "Siem Reab",
      "type": "Province"
    },
    {
      "code": "KH-18",
      "name": "Krong Preah Sihanouk",
      "type": "Autonomous municipality"
    },
    {
      "code": "KH-19",
      "name": "Stueng Traeng",
      "type": "Province"
    },
    {
      "code": "KH-2",
      "name": "Battambang",
      "type": "Province"
    },
    {
      "code": "KH-20",
      "name": "Svaay Rieng",
      "type": "Province"
    },
    {
      "code": "KH-21",
      "name": "Taakaev",
      "type": "Province"
    },
    {
      "code": "KH-22",
      "name": "Otdar Mean Chey",
      "type": "Province"
    },
    {
      "code": "KH-23",
      "name": "Krong Kaeb",
      "type": "Autonomous municipality"
    },
    {
      "code": "KH-24",
      "name": "Krong Pailin",
      "type": "Autonomous municipality"
    },
    {
      "code": "KH-3",
      "name": "Kampong Cham",
      "type": "Province"
    },
    {
      "code": "KH-4",
      "name": "Kampong Chhnang",
      "type": "Province"
    },
    {
      "code": "KH-5",
      "name": "Kampong Speu",
      "type": "Province"
    },
    {
      "code": "KH-6",
      "name": "Kampong Thom",
      "type": "Province"
    },
    {
      "code": "KH-7",
      "name": "Kampot",
      "type": "Province"
    },
    {
      "code": "KH-8",
      "name": "Kandal",
      "type": "Province"
    },
    {
      "code": "KH-9",
      "name": "Kach Kong",
      "type": "Province"
    },
    {
      "code": "KI-G",
      "name": "Gilbert Islands",
      "type": "Island group"
    },
    {
      "code": "KI-L",
      "name": "Line Islands",
      "type": "Island group"
    },
    {
      "code": "KI-P",
      "name": "Phoenix Islands",
      "type": "Island group"
    },
    {
      "code": "KM-A",
      "name": "Andjouân (Anjwān)",
      "type": "Island"
    },
    {
      "code": "KM-G",
      "name": "Andjazîdja (Anjazījah)",
      "type": "Island"
    },
    {
      "code": "KM-M",
      "name": "Moûhîlî (Mūhīlī)",
      "type": "Island"
    },
    {
      "code": "KN-01",
      "name": "Christ Church Nichola Town",
      "parent": "K",
      "type": "Parish"
    },
    {
      "code": "KN-02",
      "name": "Saint Anne Sandy Point",
      "parent": "K",
      "type": "Parish"
    },
    {
      "code": "KN-03",
      "name": "Saint George Basseterre",
      "parent": "K",
      "type": "Parish"
    },
    {
      "code": "KN-04",
      "name": "Saint George Gingerland",
      "parent": "N",
      "type": "Parish"
    },
    {
      "code": "KN-05",
      "name": "Saint James Windward",
      "parent": "N",
      "type": "Parish"
    },
    {
      "code": "KN-06",
      "name": "Saint John Capisterre",
      "parent": "K",
      "type": "Parish"
    },
    {
      "code": "KN-07",
      "name": "Saint John Figtree",
      "parent": "N",
      "type": "Parish"
    },
    {
      "code": "KN-08",
      "name": "Saint Mary Cayon",
      "parent": "K",
      "type": "Parish"
    },
    {
      "code": "KN-09",
      "name": "Saint Paul Capisterre",
      "parent": "K",
      "type": "Parish"
    },
    {
      "code": "KN-10",
      "name": "Saint Paul Charlestown",
      "parent": "N",
      "type": "Parish"
    },
    {
      "code": "KN-11",
      "name": "Saint Peter Basseterre",
      "parent": "K",
      "type": "Parish"
    },
    {
      "code": "KN-12",
      "name": "Saint Thomas Lowland",
      "parent": "N",
      "type": "Parish"
    },
    {
      "code": "KN-13",
      "name": "Saint Thomas Middle Island",
      "parent": "K",
      "type": "Parish"
    },
    {
      "code": "KN-15",
      "name": "Trinity Palmetto Point",
      "parent": "K",
      "type": "Parish"
    },
    {
      "code": "KN-K",
      "name": "Saint Kitts",
      "type": "State"
    },
    {
      "code": "KN-N",
      "name": "Nevis",
      "type": "State"
    },
    {
      "code": "KP-01",
      "name": "P’yŏngyang",
      "type": "Capital city"
    },
    {
      "code": "KP-02",
      "name": "P’yŏngan-namdo",
      "type": "Province"
    },
    {
      "code": "KP-03",
      "name": "P’yŏngan-bukto",
      "type": "Province"
    },
    {
      "code": "KP-04",
      "name": "Chagang-do",
      "type": "Province"
    },
    {
      "code": "KP-05",
      "name": "Hwanghae-namdo",
      "type": "Province"
    },
    {
      "code": "KP-06",
      "name": "Hwanghae-bukto",
      "type": "Province"
    },
    {
      "code": "KP-07",
      "name": "Kangwŏn-do",
      "type": "Province"
    },
    {
      "code": "KP-08",
      "name": "Hamgyŏng-namdo",
      "type": "Province"
    },
    {
      "code": "KP-09",
      "name": "Hamgyŏng-bukto",
      "type": "Province"
    },
    {
      "code": "KP-10",
      "name": "Yanggang-do",
      "type": "Province"
    },
    {
      "code": "KP-13",
      "name": "Nasŏn (Najin-Sŏnbong)",
      "type": "Special city"
    },
    {
      "code": "KR-11",
      "name": "Seoul Teugbyeolsi",
      "type": "Capital Metropolitan City"
    },
    {
      "code": "KR-26",
      "name": "Busan Gwang'yeogsi",
      "type": "Metropolitan cities"
    },
    {
      "code": "KR-27",
      "name": "Daegu Gwang'yeogsi",
      "type": "Metropolitan cities"
    },
    {
      "code": "KR-28",
      "name": "Incheon Gwang'yeogsi",
      "type": "Metropolitan cities"
    },
    {
      "code": "KR-29",
      "name": "Gwangju Gwang'yeogsi",
      "type": "Metropolitan cities"
    },
    {
      "code": "KR-30",
      "name": "Daejeon Gwang'yeogsi",
      "type": "Metropolitan cities"
    },
    {
      "code": "KR-31",
      "name": "Ulsan Gwang'yeogsi",
      "type": "Metropolitan cities"
    },
    {
      "code": "KR-41",
      "name": "Gyeonggido",
      "type": "Province"
    },
    {
      "code": "KR-42",
      "name": "Gang'weondo",
      "type": "Province"
    },
    {
      "code": "KR-43",
      "name": "Chungcheongbukdo",
      "type": "Province"
    },
    {
      "code": "KR-44",
      "name": "Chungcheongnamdo",
      "type": "Province"
    },
    {
      "code": "KR-45",
      "name": "Jeonrabukdo",
      "type": "Province"
    },
    {
      "code": "KR-46",
      "name": "Jeonranamdo",
      "type": "Province"
    },
    {
      "code": "KR-47",
      "name": "Gyeongsangbukdo",
      "type": "Province"
    },
    {
      "code": "KR-48",
      "name": "Gyeongsangnamdo",
      "type": "Province"
    },
    {
      "code": "KR-49",
      "name": "Jejudo",
      "type": "Province"
    },
    {
      "code": "KW-AH",
      "name": "Al Ahmadi",
      "type": "Governorate"
    },
    {
      "code": "KW-FA",
      "name": "Al Farwānīyah",
      "type": "Governorate"
    },
    {
      "code": "KW-HA",
      "name": "Hawallī",
      "type": "Governorate"
    },
    {
      "code": "KW-JA",
      "name": "Al Jahrrā’",
      "type": "Governorate"
    },
    {
      "code": "KW-KU",
      "name": "Al Kuwayt (Al ‘Āşimah)",
      "type": "Governorate"
    },
    {
      "code": "KW-MU",
      "name": "Mubārak al Kabīr",
      "type": "Governorate"
    },
    {
      "code": "KZ-AKM",
      "name": "Aqmola oblysy",
      "type": "Region"
    },
    {
      "code": "KZ-AKT",
      "name": "Aqtöbe oblysy",
      "type": "Region"
    },
    {
      "code": "KZ-ALA",
      "name": "Almaty",
      "type": "City"
    },
    {
      "code": "KZ-ALM",
      "name": "Almaty oblysy",
      "type": "Region"
    },
    {
      "code": "KZ-AST",
      "name": "Astana",
      "type": "City"
    },
    {
      "code": "KZ-ATY",
      "name": "Atyraū oblysy",
      "type": "Region"
    },
    {
      "code": "KZ-KAR",
      "name": "Qaraghandy oblysy",
      "type": "Region"
    },
    {
      "code": "KZ-KUS",
      "name": "Qostanay oblysy",
      "type": "Region"
    },
    {
      "code": "KZ-KZY",
      "name": "Qyzylorda oblysy",
      "type": "Region"
    },
    {
      "code": "KZ-MAN",
      "name": "Mangghystaū oblysy",
      "type": "Region"
    },
    {
      "code": "KZ-PAV",
      "name": "Pavlodar oblysy",
      "type": "Region"
    },
    {
      "code": "KZ-SEV",
      "name": "Soltüstik Quzaqstan oblysy",
      "type": "Region"
    },
    {
      "code": "KZ-VOS",
      "name": "Shyghys Qazaqstan oblysy",
      "type": "Region"
    },
    {
      "code": "KZ-YUZ",
      "name": "Ongtüstik Qazaqstan oblysy",
      "type": "Region"
    },
    {
      "code": "KZ-ZAP",
      "name": "Batys Quzaqstan oblysy",
      "type": "Region"
    },
    {
      "code": "KZ-ZHA",
      "name": "Zhambyl oblysy",
      "type": "Region"
    },
    {
      "code": "LA-AT",
      "name": "Attapu",
      "type": "Province"
    },
    {
      "code": "LA-BK",
      "name": "Bokèo",
      "type": "Province"
    },
    {
      "code": "LA-BL",
      "name": "Bolikhamxai",
      "type": "Province"
    },
    {
      "code": "LA-CH",
      "name": "Champasak",
      "type": "Province"
    },
    {
      "code": "LA-HO",
      "name": "Houaphan",
      "type": "Province"
    },
    {
      "code": "LA-KH",
      "name": "Khammouan",
      "type": "Province"
    },
    {
      "code": "LA-LM",
      "name": "Louang Namtha",
      "type": "Province"
    },
    {
      "code": "LA-LP",
      "name": "Louangphabang",
      "type": "Province"
    },
    {
      "code": "LA-OU",
      "name": "Oudômxai",
      "type": "Province"
    },
    {
      "code": "LA-PH",
      "name": "Phôngsali",
      "type": "Province"
    },
    {
      "code": "LA-SL",
      "name": "Salavan",
      "type": "Province"
    },
    {
      "code": "LA-SV",
      "name": "Savannakhét",
      "type": "Province"
    },
    {
      "code": "LA-VI",
      "name": "Vientiane",
      "type": "Province"
    },
    {
      "code": "LA-VT",
      "name": "Vientiane",
      "type": "Prefecture"
    },
    {
      "code": "LA-XA",
      "name": "Xaignabouli",
      "type": "Province"
    },
    {
      "code": "LA-XE",
      "name": "Xékong",
      "type": "Province"
    },
    {
      "code": "LA-XI",
      "name": "Xiangkhouang",
      "type": "Province"
    },
    {
      "code": "LA-XS",
      "name": "Xaisômboun",
      "type": "Province"
    },
    {
      "code": "LB-AK",
      "name": "Aakkâr",
      "type": "Governorate"
    },
    {
      "code": "LB-AS",
      "name": "Liban-Nord",
      "type": "Governorate"
    },
    {
      "code": "LB-BA",
      "name": "Beyrouth",
      "type": "Governorate"
    },
    {
      "code": "LB-BH",
      "name": "Baalbek-Hermel",
      "type": "Governorate"
    },
    {
      "code": "LB-BI",
      "name": "Béqaa",
      "type": "Governorate"
    },
    {
      "code": "LB-JA",
      "name": "Liban-Sud",
      "type": "Governorate"
    },
    {
      "code": "LB-JL",
      "name": "Mont-Liban",
      "type": "Governorate"
    },
    {
      "code": "LB-NA",
      "name": "Nabatîyé",
      "type": "Governorate"
    },
    {
      "code": "LI-01",
      "name": "Balzers",
      "type": "Commune"
    },
    {
      "code": "LI-02",
      "name": "Eschen",
      "type": "Commune"
    },
    {
      "code": "LI-03",
      "name": "Gamprin",
      "type": "Commune"
    },
    {
      "code": "LI-04",
      "name": "Mauren",
      "type": "Commune"
    },
    {
      "code": "LI-05",
      "name": "Planken",
      "type": "Commune"
    },
    {
      "code": "LI-06",
      "name": "Ruggell",
      "type": "Commune"
    },
    {
      "code": "LI-07",
      "name": "Schaan",
      "type": "Commune"
    },
    {
      "code": "LI-08",
      "name": "Schellenberg",
      "type": "Commune"
    },
    {
      "code": "LI-09",
      "name": "Triesen",
      "type": "Commune"
    },
    {
      "code": "LI-10",
      "name": "Triesenberg",
      "type": "Commune"
    },
    {
      "code": "LI-11",
      "name": "Vaduz",
      "type": "Commune"
    },
    {
      "code": "LK-1",
      "name": "Basnāhira paḷāta",
      "type": "Province"
    },
    {
      "code": "LK-11",
      "name": "Kŏḷamba",
      "parent": "1",
      "type": "District"
    },
    {
      "code": "LK-12",
      "name": "Gampaha",
      "parent": "1",
      "type": "District"
    },
    {
      "code": "LK-13",
      "name": "Kaḷutara",
      "parent": "1",
      "type": "District"
    },
    {
      "code": "LK-2",
      "name": "Madhyama paḷāta",
      "type": "Province"
    },
    {
      "code": "LK-21",
      "name": "Mahanuvara",
      "parent": "2",
      "type": "District"
    },
    {
      "code": "LK-22",
      "name": "Mātale",
      "parent": "2",
      "type": "District"
    },
    {
      "code": "LK-23",
      "name": "Nuvara Ĕliya",
      "parent": "2",
      "type": "District"
    },
    {
      "code": "LK-3",
      "name": "Dakuṇu paḷāta",
      "type": "Province"
    },
    {
      "code": "LK-31",
      "name": "Gālla",
      "parent": "3",
      "type": "District"
    },
    {
      "code": "LK-32",
      "name": "Mātara",
      "parent": "3",
      "type": "District"
    },
    {
      "code": "LK-33",
      "name": "Hambantŏṭa",
      "parent": "3",
      "type": "District"
    },
    {
      "code": "LK-4",
      "name": "Uturu paḷāta",
      "type": "Province"
    },
    {
      "code": "LK-41",
      "name": "Yāpanaya",
      "parent": "4",
      "type": "District"
    },
    {
      "code": "LK-42",
      "name": "Kilinŏchchi",
      "parent": "4",
      "type": "District"
    },
    {
      "code": "LK-43",
      "name": "Mannārama",
      "parent": "4",
      "type": "District"
    },
    {
      "code": "LK-44",
      "name": "Vavuniyāva",
      "parent": "4",
      "type": "District"
    },
    {
      "code": "LK-45",
      "name": "Mulativ",
      "parent": "4",
      "type": "District"
    },
    {
      "code": "LK-5",
      "name": "Næ̆gĕnahira paḷāta",
      "type": "Province"
    },
    {
      "code": "LK-51",
      "name": "Maḍakalapuva",
      "parent": "5",
      "type": "District"
    },
    {
      "code": "LK-52",
      "name": "Ampāara",
      "parent": "5",
      "type": "District"
    },
    {
      "code": "LK-53",
      "name": "Trikuṇāmalaya",
      "parent": "5",
      "type": "District"
    },
    {
      "code": "LK-6",
      "name": "Vayamba paḷāta",
      "type": "Province"
    },
    {
      "code": "LK-61",
      "name": "Kuruṇægala",
      "parent": "6",
      "type": "District"
    },
    {
      "code": "LK-62",
      "name": "Puttalama",
      "parent": "6",
      "type": "District"
    },
    {
      "code": "LK-7",
      "name": "Uturumæ̆da paḷāta",
      "type": "Province"
    },
    {
      "code": "LK-71",
      "name": "Anurādhapura",
      "parent": "7",
      "type": "District"
    },
    {
      "code": "LK-72",
      "name": "Pŏḷŏnnaruva",
      "parent": "7",
      "type": "District"
    },
    {
      "code": "LK-8",
      "name": "Ūva paḷāta",
      "type": "Province"
    },
    {
      "code": "LK-81",
      "name": "Badulla",
      "parent": "8",
      "type": "District"
    },
    {
      "code": "LK-82",
      "name": "Mŏṇarāgala",
      "parent": "8",
      "type": "District"
    },
    {
      "code": "LK-9",
      "name": "Sabaragamuva paḷāta",
      "type": "Province"
    },
    {
      "code": "LK-91",
      "name": "Ratnapura",
      "parent": "9",
      "type": "District"
    },
    {
      "code": "LK-92",
      "name": "Kægalla",
      "parent": "9",
      "type": "District"
    },
    {
      "code": "LR-BG",
      "name": "Bong",
      "type": "County"
    },
    {
      "code": "LR-BM",
      "name": "Bomi",
      "type": "County"
    },
    {
      "code": "LR-CM",
      "name": "Grand Cape Mount",
      "type": "County"
    },
    {
      "code": "LR-GB",
      "name": "Grand Bassa",
      "type": "County"
    },
    {
      "code": "LR-GG",
      "name": "Grand Gedeh",
      "type": "County"
    },
    {
      "code": "LR-GK",
      "name": "Grand Kru",
      "type": "County"
    },
    {
      "code": "LR-LO",
      "name": "Lofa",
      "type": "County"
    },
    {
      "code": "LR-MG",
      "name": "Margibi",
      "type": "County"
    },
    {
      "code": "LR-MO",
      "name": "Montserrado",
      "type": "County"
    },
    {
      "code": "LR-MY",
      "name": "Maryland",
      "type": "County"
    },
    {
      "code": "LR-NI",
      "name": "Nimba",
      "type": "County"
    },
    {
      "code": "LR-RI",
      "name": "Rivercess",
      "type": "County"
    },
    {
      "code": "LR-SI",
      "name": "Sinoe",
      "type": "County"
    },
    {
      "code": "LS-A",
      "name": "Maseru",
      "type": "District"
    },
    {
      "code": "LS-B",
      "name": "Butha-Buthe",
      "type": "District"
    },
    {
      "code": "LS-C",
      "name": "Leribe",
      "type": "District"
    },
    {
      "code": "LS-D",
      "name": "Berea",
      "type": "District"
    },
    {
      "code": "LS-E",
      "name": "Mafeteng",
      "type": "District"
    },
    {
      "code": "LS-F",
      "name": "Mohale's Hoek",
      "type": "District"
    },
    {
      "code": "LS-G",
      "name": "Quthing",
      "type": "District"
    },
    {
      "code": "LS-H",
      "name": "Qacha's Nek",
      "type": "District"
    },
    {
      "code": "LS-J",
      "name": "Mokhotlong",
      "type": "District"
    },
    {
      "code": "LS-K",
      "name": "Thaba-Tseka",
      "type": "District"
    },
    {
      "code": "LT-AL",
      "name": "Alytaus Apskritis",
      "type": "County"
    },
    {
      "code": "LT-KL",
      "name": "Klaipėdos Apskritis",
      "type": "County"
    },
    {
      "code": "LT-KU",
      "name": "Kauno Apskritis",
      "type": "County"
    },
    {
      "code": "LT-MR",
      "name": "Marijampolės Apskritis",
      "type": "County"
    },
    {
      "code": "LT-PN",
      "name": "Panevėžio Apskritis",
      "type": "County"
    },
    {
      "code": "LT-SA",
      "name": "Šiaulių Apskritis",
      "type": "County"
    },
    {
      "code": "LT-TA",
      "name": "Tauragés Apskritis",
      "type": "County"
    },
    {
      "code": "LT-TE",
      "name": "Telšių Apskritis",
      "type": "County"
    },
    {
      "code": "LT-UT",
      "name": "Utenos Apskritis",
      "type": "County"
    },
    {
      "code": "LT-VL",
      "name": "Vilniaus Apskritis",
      "type": "County"
    },
    {
      "code": "LU-D",
      "name": "Diekirch",
      "type": "District"
    },
    {
      "code": "LU-G",
      "name": "Grevenmacher",
      "type": "District"
    },
    {
      "code": "LU-L",
      "name": "Luxembourg",
      "type": "District"
    },
    {
      "code": "LV-001",
      "name": "Aglonas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-002",
      "name": "Aizkraukles novads",
      "type": "Municipality"
    },
    {
      "code": "LV-003",
      "name": "Aizputes novads",
      "type": "Municipality"
    },
    {
      "code": "LV-004",
      "name": "Aknīstes novads",
      "type": "Municipality"
    },
    {
      "code": "LV-005",
      "name": "Alojas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-006",
      "name": "Alsungas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-007",
      "name": "Alūksnes novads",
      "type": "Municipality"
    },
    {
      "code": "LV-008",
      "name": "Amatas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-009",
      "name": "Apes novads",
      "type": "Municipality"
    },
    {
      "code": "LV-010",
      "name": "Auces novads",
      "type": "Municipality"
    },
    {
      "code": "LV-011",
      "name": "Ādažu novads",
      "type": "Municipality"
    },
    {
      "code": "LV-012",
      "name": "Babītes novads",
      "type": "Municipality"
    },
    {
      "code": "LV-013",
      "name": "Baldones novads",
      "type": "Municipality"
    },
    {
      "code": "LV-014",
      "name": "Baltinavas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-015",
      "name": "Balvu novads",
      "type": "Municipality"
    },
    {
      "code": "LV-016",
      "name": "Bauskas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-017",
      "name": "Beverīnas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-018",
      "name": "Brocēnu novads",
      "type": "Municipality"
    },
    {
      "code": "LV-019",
      "name": "Burtnieku novads",
      "type": "Municipality"
    },
    {
      "code": "LV-020",
      "name": "Carnikavas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-021",
      "name": "Cesvaines novads",
      "type": "Municipality"
    },
    {
      "code": "LV-022",
      "name": "Cēsu novads",
      "type": "Municipality"
    },
    {
      "code": "LV-023",
      "name": "Ciblas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-024",
      "name": "Dagdas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-025",
      "name": "Daugavpils novads",
      "type": "Municipality"
    },
    {
      "code": "LV-026",
      "name": "Dobeles novads",
      "type": "Municipality"
    },
    {
      "code": "LV-027",
      "name": "Dundagas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-028",
      "name": "Durbes novads",
      "type": "Municipality"
    },
    {
      "code": "LV-029",
      "name": "Engures novads",
      "type": "Municipality"
    },
    {
      "code": "LV-030",
      "name": "Ērgļu novads",
      "type": "Municipality"
    },
    {
      "code": "LV-031",
      "name": "Garkalnes novads",
      "type": "Municipality"
    },
    {
      "code": "LV-032",
      "name": "Grobiņas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-033",
      "name": "Gulbenes novads",
      "type": "Municipality"
    },
    {
      "code": "LV-034",
      "name": "Iecavas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-035",
      "name": "Ikšķiles novads",
      "type": "Municipality"
    },
    {
      "code": "LV-036",
      "name": "Ilūkstes novads",
      "type": "Municipality"
    },
    {
      "code": "LV-037",
      "name": "Inčukalna novads",
      "type": "Municipality"
    },
    {
      "code": "LV-038",
      "name": "Jaunjelgavas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-039",
      "name": "Jaunpiebalgas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-040",
      "name": "Jaunpils novads",
      "type": "Municipality"
    },
    {
      "code": "LV-041",
      "name": "Jelgavas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-042",
      "name": "Jēkabpils novads",
      "type": "Municipality"
    },
    {
      "code": "LV-043",
      "name": "Kandavas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-044",
      "name": "Kārsavas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-045",
      "name": "Kocēnu novads",
      "type": "Municipality"
    },
    {
      "code": "LV-046",
      "name": "Kokneses novads",
      "type": "Municipality"
    },
    {
      "code": "LV-047",
      "name": "Krāslavas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-048",
      "name": "Krimuldas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-049",
      "name": "Krustpils novads",
      "type": "Municipality"
    },
    {
      "code": "LV-050",
      "name": "Kuldīgas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-051",
      "name": "Ķeguma novads",
      "type": "Municipality"
    },
    {
      "code": "LV-052",
      "name": "Ķekavas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-053",
      "name": "Lielvārdes novads",
      "type": "Municipality"
    },
    {
      "code": "LV-054",
      "name": "Limbažu novads",
      "type": "Municipality"
    },
    {
      "code": "LV-055",
      "name": "Līgatnes novads",
      "type": "Municipality"
    },
    {
      "code": "LV-056",
      "name": "Līvānu novads",
      "type": "Municipality"
    },
    {
      "code": "LV-057",
      "name": "Lubānas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-058",
      "name": "Ludzas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-059",
      "name": "Madonas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-060",
      "name": "Mazsalacas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-061",
      "name": "Mālpils novads",
      "type": "Municipality"
    },
    {
      "code": "LV-062",
      "name": "Mārupes novads",
      "type": "Municipality"
    },
    {
      "code": "LV-063",
      "name": "Mērsraga novads",
      "type": "Municipality"
    },
    {
      "code": "LV-064",
      "name": "Naukšēnu novads",
      "type": "Municipality"
    },
    {
      "code": "LV-065",
      "name": "Neretas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-066",
      "name": "Nīcas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-067",
      "name": "Ogres novads",
      "type": "Municipality"
    },
    {
      "code": "LV-068",
      "name": "Olaines novads",
      "type": "Municipality"
    },
    {
      "code": "LV-069",
      "name": "Ozolnieku novads",
      "type": "Municipality"
    },
    {
      "code": "LV-070",
      "name": "Pārgaujas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-071",
      "name": "Pāvilostas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-072",
      "name": "Pļaviņu novads",
      "type": "Municipality"
    },
    {
      "code": "LV-073",
      "name": "Preiļu novads",
      "type": "Municipality"
    },
    {
      "code": "LV-074",
      "name": "Priekules novads",
      "type": "Municipality"
    },
    {
      "code": "LV-075",
      "name": "Priekuļu novads",
      "type": "Municipality"
    },
    {
      "code": "LV-076",
      "name": "Raunas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-077",
      "name": "Rēzeknes novads",
      "type": "Municipality"
    },
    {
      "code": "LV-078",
      "name": "Riebiņu novads",
      "type": "Municipality"
    },
    {
      "code": "LV-079",
      "name": "Rojas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-080",
      "name": "Ropažu novads",
      "type": "Municipality"
    },
    {
      "code": "LV-081",
      "name": "Rucavas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-082",
      "name": "Rugāju novads",
      "type": "Municipality"
    },
    {
      "code": "LV-083",
      "name": "Rundāles novads",
      "type": "Municipality"
    },
    {
      "code": "LV-084",
      "name": "Rūjienas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-085",
      "name": "Salas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-086",
      "name": "Salacgrīvas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-087",
      "name": "Salaspils novads",
      "type": "Municipality"
    },
    {
      "code": "LV-088",
      "name": "Saldus novads",
      "type": "Municipality"
    },
    {
      "code": "LV-089",
      "name": "Saulkrastu novads",
      "type": "Municipality"
    },
    {
      "code": "LV-090",
      "name": "Sējas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-091",
      "name": "Siguldas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-092",
      "name": "Skrīveru novads",
      "type": "Municipality"
    },
    {
      "code": "LV-093",
      "name": "Skrundas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-094",
      "name": "Smiltenes novads",
      "type": "Municipality"
    },
    {
      "code": "LV-095",
      "name": "Stopiņu novads",
      "type": "Municipality"
    },
    {
      "code": "LV-096",
      "name": "Strenču novads",
      "type": "Municipality"
    },
    {
      "code": "LV-097",
      "name": "Talsu novads",
      "type": "Municipality"
    },
    {
      "code": "LV-098",
      "name": "Tērvetes novads",
      "type": "Municipality"
    },
    {
      "code": "LV-099",
      "name": "Tukuma novads",
      "type": "Municipality"
    },
    {
      "code": "LV-100",
      "name": "Vaiņodes novads",
      "type": "Municipality"
    },
    {
      "code": "LV-101",
      "name": "Valkas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-102",
      "name": "Varakļānu novads",
      "type": "Municipality"
    },
    {
      "code": "LV-103",
      "name": "Vārkavas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-104",
      "name": "Vecpiebalgas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-105",
      "name": "Vecumnieku novads",
      "type": "Municipality"
    },
    {
      "code": "LV-106",
      "name": "Ventspils novads",
      "type": "Municipality"
    },
    {
      "code": "LV-107",
      "name": "Viesītes novads",
      "type": "Municipality"
    },
    {
      "code": "LV-108",
      "name": "Viļakas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-109",
      "name": "Viļānu novads",
      "type": "Municipality"
    },
    {
      "code": "LV-110",
      "name": "Zilupes novads",
      "type": "Municipality"
    },
    {
      "code": "LV-DGV",
      "name": "Daugavpils",
      "type": "Republican City"
    },
    {
      "code": "LV-JEL",
      "name": "Jelgava",
      "type": "Republican City"
    },
    {
      "code": "LV-JKB",
      "name": "Jēkabpils",
      "type": "Republican City"
    },
    {
      "code": "LV-JUR",
      "name": "Jūrmala",
      "type": "Republican City"
    },
    {
      "code": "LV-LPX",
      "name": "Liepāja",
      "type": "Republican City"
    },
    {
      "code": "LV-REZ",
      "name": "Rēzekne",
      "type": "Republican City"
    },
    {
      "code": "LV-RIX",
      "name": "Rīga",
      "type": "Republican City"
    },
    {
      "code": "LV-VEN",
      "name": "Ventspils",
      "type": "Republican City"
    },
    {
      "code": "LV-VMR",
      "name": "Valmiera",
      "type": "Republican City"
    },
    {
      "code": "LY-BA",
      "name": "Banghāzī",
      "type": "Popularates"
    },
    {
      "code": "LY-BU",
      "name": "Al Buţnān",
      "type": "Popularates"
    },
    {
      "code": "LY-DR",
      "name": "Darnah",
      "type": "Popularates"
    },
    {
      "code": "LY-GT",
      "name": "Ghāt",
      "type": "Popularates"
    },
    {
      "code": "LY-JA",
      "name": "Al Jabal al Akhḑar",
      "type": "Popularates"
    },
    {
      "code": "LY-JB",
      "name": "Jaghbūb",
      "type": "Popularates"
    },
    {
      "code": "LY-JG",
      "name": "Al Jabal al Gharbī",
      "type": "Popularates"
    },
    {
      "code": "LY-JI",
      "name": "Al Jifārah",
      "type": "Popularates"
    },
    {
      "code": "LY-JU",
      "name": "Al Jufrah",
      "type": "Popularates"
    },
    {
      "code": "LY-KF",
      "name": "Al Kufrah",
      "type": "Popularates"
    },
    {
      "code": "LY-MB",
      "name": "Al Marqab",
      "type": "Popularates"
    },
    {
      "code": "LY-MI",
      "name": "Mişrātah",
      "type": "Popularates"
    },
    {
      "code": "LY-MJ",
      "name": "Al Marj",
      "type": "Popularates"
    },
    {
      "code": "LY-MQ",
      "name": "Murzuq",
      "type": "Popularates"
    },
    {
      "code": "LY-NL",
      "name": "Nālūt",
      "type": "Popularates"
    },
    {
      "code": "LY-NQ",
      "name": "An Nuqaţ al Khams",
      "type": "Popularates"
    },
    {
      "code": "LY-SB",
      "name": "Sabhā",
      "type": "Popularates"
    },
    {
      "code": "LY-SR",
      "name": "Surt",
      "type": "Popularates"
    },
    {
      "code": "LY-TB",
      "name": "Ţarābulus",
      "type": "Popularates"
    },
    {
      "code": "LY-WA",
      "name": "Al Wāḩāt",
      "type": "Popularates"
    },
    {
      "code": "LY-WD",
      "name": "Wādī al Ḩayāt",
      "type": "Popularates"
    },
    {
      "code": "LY-WS",
      "name": "Wādī ash Shāţiʾ",
      "type": "Popularates"
    },
    {
      "code": "LY-ZA",
      "name": "Az Zāwiyah",
      "type": "Popularates"
    },
    {
      "code": "MA-01",
      "name": "Tanger-Tétouan",
      "type": "Economic region"
    },
    {
      "code": "MA-02",
      "name": "Gharb-Chrarda-Beni Hssen",
      "type": "Economic region"
    },
    {
      "code": "MA-03",
      "name": "Taza-Al Hoceima-Taounate",
      "type": "Economic region"
    },
    {
      "code": "MA-04",
      "name": "L'Oriental",
      "type": "Economic region"
    },
    {
      "code": "MA-05",
      "name": "Fès-Boulemane",
      "type": "Economic region"
    },
    {
      "code": "MA-06",
      "name": "Meknès-Tafilalet",
      "type": "Economic region"
    },
    {
      "code": "MA-07",
      "name": "Rabat-Salé-Zemmour-Zaer",
      "type": "Economic region"
    },
    {
      "code": "MA-08",
      "name": "Grand Casablanca",
      "type": "Economic region"
    },
    {
      "code": "MA-09",
      "name": "Chaouia-Ouardigha",
      "type": "Economic region"
    },
    {
      "code": "MA-10",
      "name": "Doukhala-Abda",
      "type": "Economic region"
    },
    {
      "code": "MA-11",
      "name": "Marrakech-Tensift-Al Haouz",
      "type": "Economic region"
    },
    {
      "code": "MA-12",
      "name": "Tadla-Azilal",
      "type": "Economic region"
    },
    {
      "code": "MA-13",
      "name": "Sous-Massa-Draa",
      "type": "Economic region"
    },
    {
      "code": "MA-14",
      "name": "Guelmim-Es Smara",
      "type": "Economic region"
    },
    {
      "code": "MA-15",
      "name": "Laâyoune-Boujdour-Sakia el Hamra",
      "type": "Economic region"
    },
    {
      "code": "MA-16",
      "name": "Oued ed Dahab-Lagouira",
      "type": "Economic region"
    },
    {
      "code": "MA-AGD",
      "name": "Agadir-Ida-Outanane",
      "parent": "13",
      "type": "Prefecture"
    },
    {
      "code": "MA-AOU",
      "name": "Aousserd",
      "parent": "16",
      "type": "Prefecture"
    },
    {
      "code": "MA-ASZ",
      "name": "Assa-Zag",
      "parent": "14",
      "type": "Province"
    },
    {
      "code": "MA-AZI",
      "name": "Azilal",
      "parent": "12",
      "type": "Province"
    },
    {
      "code": "MA-BEM",
      "name": "Beni Mellal",
      "parent": "12",
      "type": "Province"
    },
    {
      "code": "MA-BER",
      "name": "Berkane",
      "parent": "04",
      "type": "Province"
    },
    {
      "code": "MA-BES",
      "name": "Ben Slimane",
      "parent": "09",
      "type": "Province"
    },
    {
      "code": "MA-BOD",
      "name": "Boujdour (EH)",
      "parent": "15",
      "type": "Province"
    },
    {
      "code": "MA-BOM",
      "name": "Boulemane",
      "parent": "05",
      "type": "Province"
    },
    {
      "code": "MA-CAS",
      "name": "Casablanca [Dar el Beïda]",
      "parent": "08",
      "type": "Prefecture"
    },
    {
      "code": "MA-CHE",
      "name": "Chefchaouen",
      "parent": "01",
      "type": "Province"
    },
    {
      "code": "MA-CHI",
      "name": "Chichaoua",
      "parent": "11",
      "type": "Province"
    },
    {
      "code": "MA-CHT",
      "name": "Chtouka-Ait Baha",
      "parent": "13",
      "type": "Province"
    },
    {
      "code": "MA-ERR",
      "name": "Errachidia",
      "parent": "06",
      "type": "Province"
    },
    {
      "code": "MA-ESI",
      "name": "Essaouira",
      "parent": "11",
      "type": "Province"
    },
    {
      "code": "MA-ESM",
      "name": "Es Smara (EH)",
      "parent": "14",
      "type": "Province"
    },
    {
      "code": "MA-FAH",
      "name": "Fahs-Beni Makada",
      "parent": "01",
      "type": "Prefecture"
    },
    {
      "code": "MA-FES",
      "name": "Fès-Dar-Dbibegh",
      "parent": "05",
      "type": "Prefecture"
    },
    {
      "code": "MA-FIG",
      "name": "Figuig",
      "parent": "04",
      "type": "Province"
    },
    {
      "code": "MA-GUE",
      "name": "Guelmim",
      "parent": "14",
      "type": "Province"
    },
    {
      "code": "MA-HAJ",
      "name": "El Hajeb",
      "parent": "06",
      "type": "Province"
    },
    {
      "code": "MA-HAO",
      "name": "Al Haouz",
      "parent": "11",
      "type": "Province"
    },
    {
      "code": "MA-HOC",
      "name": "Al Hoceïma",
      "parent": "03",
      "type": "Province"
    },
    {
      "code": "MA-IFR",
      "name": "Ifrane",
      "parent": "06",
      "type": "Province"
    },
    {
      "code": "MA-INE",
      "name": "Inezgane-Ait Melloul",
      "parent": "13",
      "type": "Prefecture"
    },
    {
      "code": "MA-JDI",
      "name": "El Jadida",
      "parent": "10",
      "type": "Province"
    },
    {
      "code": "MA-JRA",
      "name": "Jrada",
      "parent": "04",
      "type": "Province"
    },
    {
      "code": "MA-KEN",
      "name": "Kénitra",
      "parent": "02",
      "type": "Province"
    },
    {
      "code": "MA-KES",
      "name": "Kelaat es Sraghna",
      "parent": "11",
      "type": "Province"
    },
    {
      "code": "MA-KHE",
      "name": "Khemisaet",
      "parent": "07",
      "type": "Province"
    },
    {
      "code": "MA-KHN",
      "name": "Khenifra",
      "parent": "06",
      "type": "Province"
    },
    {
      "code": "MA-KHO",
      "name": "Khouribga",
      "parent": "09",
      "type": "Province"
    },
    {
      "code": "MA-LAA",
      "name": "Laâyoune (EH)",
      "parent": "15",
      "type": "Province"
    },
    {
      "code": "MA-LAR",
      "name": "Larache",
      "parent": "01",
      "type": "Province"
    },
    {
      "code": "MA-MED",
      "name": "Médiouna",
      "parent": "08",
      "type": "Province"
    },
    {
      "code": "MA-MEK",
      "name": "Meknès",
      "parent": "06",
      "type": "Prefecture"
    },
    {
      "code": "MA-MMD",
      "name": "Marrakech-Medina",
      "parent": "11",
      "type": "Prefecture"
    },
    {
      "code": "MA-MMN",
      "name": "Marrakech-Menara",
      "parent": "11",
      "type": "Prefecture"
    },
    {
      "code": "MA-MOH",
      "name": "Mohammadia",
      "parent": "08",
      "type": "Prefecture"
    },
    {
      "code": "MA-MOU",
      "name": "Moulay Yacoub",
      "parent": "05",
      "type": "Province"
    },
    {
      "code": "MA-NAD",
      "name": "Nador",
      "parent": "04",
      "type": "Province"
    },
    {
      "code": "MA-NOU",
      "name": "Nouaceur",
      "parent": "08",
      "type": "Province"
    },
    {
      "code": "MA-OUA",
      "name": "Ouarzazate",
      "parent": "13",
      "type": "Province"
    },
    {
      "code": "MA-OUD",
      "name": "Oued ed Dahab (EH)",
      "parent": "16",
      "type": "Province"
    },
    {
      "code": "MA-OUJ",
      "name": "Oujda-Angad",
      "parent": "04",
      "type": "Prefecture"
    },
    {
      "code": "MA-RAB",
      "name": "Rabat",
      "parent": "07",
      "type": "Prefecture"
    },
    {
      "code": "MA-SAF",
      "name": "Safi",
      "parent": "10",
      "type": "Province"
    },
    {
      "code": "MA-SAL",
      "name": "Salé",
      "parent": "07",
      "type": "Prefecture"
    },
    {
      "code": "MA-SEF",
      "name": "Sefrou",
      "parent": "05",
      "type": "Province"
    },
    {
      "code": "MA-SET",
      "name": "Settat",
      "parent": "09",
      "type": "Province"
    },
    {
      "code": "MA-SIK",
      "name": "Sidl Kacem",
      "parent": "02",
      "type": "Province"
    },
    {
      "code": "MA-SKH",
      "name": "Skhirate-Témara",
      "parent": "07",
      "type": "Prefecture"
    },
    {
      "code": "MA-SYB",
      "name": "Sidi Youssef Ben Ali",
      "parent": "11",
      "type": "Prefecture"
    },
    {
      "code": "MA-TAI",
      "name": "Taourirt",
      "parent": "04",
      "type": "Province"
    },
    {
      "code": "MA-TAO",
      "name": "Taounate",
      "parent": "03",
      "type": "Province"
    },
    {
      "code": "MA-TAR",
      "name": "Taroudant",
      "parent": "13",
      "type": "Province"
    },
    {
      "code": "MA-TAT",
      "name": "Tata",
      "parent": "14",
      "type": "Province"
    },
    {
      "code": "MA-TAZ",
      "name": "Taza",
      "parent": "03",
      "type": "Province"
    },
    {
      "code": "MA-TET",
      "name": "Tétouan",
      "parent": "01",
      "type": "Prefecture"
    },
    {
      "code": "MA-TIZ",
      "name": "Tiznit",
      "parent": "13",
      "type": "Province"
    },
    {
      "code": "MA-TNG",
      "name": "Tanger-Assilah",
      "parent": "01",
      "type": "Prefecture"
    },
    {
      "code": "MA-TNT",
      "name": "Tan-Tan",
      "parent": "14",
      "type": "Province"
    },
    {
      "code": "MA-ZAG",
      "name": "Zagora",
      "parent": "13",
      "type": "Province"
    },
    {
      "code": "MC-CL",
      "name": "La Colle",
      "type": "Quarter"
    },
    {
      "code": "MC-CO",
      "name": "La Condamine",
      "type": "Quarter"
    },
    {
      "code": "MC-FO",
      "name": "Fontvieille",
      "type": "Quarter"
    },
    {
      "code": "MC-GA",
      "name": "La Gare",
      "type": "Quarter"
    },
    {
      "code": "MC-JE",
      "name": "Jardin Exotique",
      "type": "Quarter"
    },
    {
      "code": "MC-LA",
      "name": "Larvotto",
      "type": "Quarter"
    },
    {
      "code": "MC-MA",
      "name": "Malbousquet",
      "type": "Quarter"
    },
    {
      "code": "MC-MC",
      "name": "Monte-Carlo",
      "type": "Quarter"
    },
    {
      "code": "MC-MG",
      "name": "Moneghetti",
      "type": "Quarter"
    },
    {
      "code": "MC-MO",
      "name": "Monaco-Ville",
      "type": "Quarter"
    },
    {
      "code": "MC-MU",
      "name": "Moulins",
      "type": "Quarter"
    },
    {
      "code": "MC-PH",
      "name": "Port-Hercule",
      "type": "Quarter"
    },
    {
      "code": "MC-SD",
      "name": "Sainte-Dévote",
      "type": "Quarter"
    },
    {
      "code": "MC-SO",
      "name": "La Source",
      "type": "Quarter"
    },
    {
      "code": "MC-SP",
      "name": "Spélugues",
      "type": "Quarter"
    },
    {
      "code": "MC-SR",
      "name": "Saint-Roman",
      "type": "Quarter"
    },
    {
      "code": "MC-VR",
      "name": "Vallon de la Rousse",
      "type": "Quarter"
    },
    {
      "code": "MD-AN",
      "name": "Anenii Noi",
      "type": "District"
    },
    {
      "code": "MD-BA",
      "name": "Bălți",
      "type": "City"
    },
    {
      "code": "MD-BD",
      "name": "Tighina",
      "type": "City"
    },
    {
      "code": "MD-BR",
      "name": "Briceni",
      "type": "District"
    },
    {
      "code": "MD-BS",
      "name": "Basarabeasca",
      "type": "District"
    },
    {
      "code": "MD-CA",
      "name": "Cahul",
      "type": "District"
    },
    {
      "code": "MD-CL",
      "name": "Călărași",
      "type": "District"
    },
    {
      "code": "MD-CM",
      "name": "Cimișlia",
      "type": "District"
    },
    {
      "code": "MD-CR",
      "name": "Criuleni",
      "type": "District"
    },
    {
      "code": "MD-CS",
      "name": "Căușeni",
      "type": "District"
    },
    {
      "code": "MD-CT",
      "name": "Cantemir",
      "type": "District"
    },
    {
      "code": "MD-CU",
      "name": "Chișinău",
      "type": "City"
    },
    {
      "code": "MD-DO",
      "name": "Dondușeni",
      "type": "District"
    },
    {
      "code": "MD-DR",
      "name": "Drochia",
      "type": "District"
    },
    {
      "code": "MD-DU",
      "name": "Dubăsari",
      "type": "District"
    },
    {
      "code": "MD-ED",
      "name": "Edineț",
      "type": "District"
    },
    {
      "code": "MD-FA",
      "name": "Fălești",
      "type": "District"
    },
    {
      "code": "MD-FL",
      "name": "Florești",
      "type": "District"
    },
    {
      "code": "MD-GA",
      "name": "Găgăuzia, Unitatea teritorială autonomă",
      "type": "Autonomous territorial unit"
    },
    {
      "code": "MD-GL",
      "name": "Glodeni",
      "type": "District"
    },
    {
      "code": "MD-HI",
      "name": "Hîncești",
      "type": "District"
    },
    {
      "code": "MD-IA",
      "name": "Ialoveni",
      "type": "District"
    },
    {
      "code": "MD-LE",
      "name": "Leova",
      "type": "District"
    },
    {
      "code": "MD-NI",
      "name": "Nisporeni",
      "type": "District"
    },
    {
      "code": "MD-OC",
      "name": "Ocnița",
      "type": "District"
    },
    {
      "code": "MD-OR",
      "name": "Orhei",
      "type": "District"
    },
    {
      "code": "MD-RE",
      "name": "Rezina",
      "type": "District"
    },
    {
      "code": "MD-RI",
      "name": "Rîșcani",
      "type": "District"
    },
    {
      "code": "MD-SD",
      "name": "Șoldănești",
      "type": "District"
    },
    {
      "code": "MD-SI",
      "name": "Sîngerei",
      "type": "District"
    },
    {
      "code": "MD-SN",
      "name": "Stînga Nistrului, unitatea teritorială din",
      "type": "Territorial unit"
    },
    {
      "code": "MD-SO",
      "name": "Soroca",
      "type": "District"
    },
    {
      "code": "MD-ST",
      "name": "Strășeni",
      "type": "District"
    },
    {
      "code": "MD-SV",
      "name": "Ștefan Vodă",
      "type": "District"
    },
    {
      "code": "MD-TA",
      "name": "Taraclia",
      "type": "District"
    },
    {
      "code": "MD-TE",
      "name": "Telenești",
      "type": "District"
    },
    {
      "code": "MD-UN",
      "name": "Ungheni",
      "type": "District"
    },
    {
      "code": "ME-01",
      "name": "Andrijevica",
      "type": "Municipality"
    },
    {
      "code": "ME-02",
      "name": "Bar",
      "type": "Municipality"
    },
    {
      "code": "ME-03",
      "name": "Berane",
      "type": "Municipality"
    },
    {
      "code": "ME-04",
      "name": "Bijelo Polje",
      "type": "Municipality"
    },
    {
      "code": "ME-05",
      "name": "Budva",
      "type": "Municipality"
    },
    {
      "code": "ME-06",
      "name": "Cetinje",
      "type": "Municipality"
    },
    {
      "code": "ME-07",
      "name": "Danilovgrad",
      "type": "Municipality"
    },
    {
      "code": "ME-08",
      "name": "Herceg-Novi",
      "type": "Municipality"
    },
    {
      "code": "ME-09",
      "name": "Kolašin",
      "type": "Municipality"
    },
    {
      "code": "ME-10",
      "name": "Kotor",
      "type": "Municipality"
    },
    {
      "code": "ME-11",
      "name": "Mojkovac",
      "type": "Municipality"
    },
    {
      "code": "ME-12",
      "name": "Nikšić",
      "type": "Municipality"
    },
    {
      "code": "ME-13",
      "name": "Plav",
      "type": "Municipality"
    },
    {
      "code": "ME-14",
      "name": "Pljevlja",
      "type": "Municipality"
    },
    {
      "code": "ME-15",
      "name": "Plužine",
      "type": "Municipality"
    },
    {
      "code": "ME-16",
      "name": "Podgorica",
      "type": "Municipality"
    },
    {
      "code": "ME-17",
      "name": "Rožaje",
      "type": "Municipality"
    },
    {
      "code": "ME-18",
      "name": "Šavnik",
      "type": "Municipality"
    },
    {
      "code": "ME-19",
      "name": "Tivat",
      "type": "Municipality"
    },
    {
      "code": "ME-20",
      "name": "Ulcinj",
      "type": "Municipality"
    },
    {
      "code": "ME-21",
      "name": "Žabljak",
      "type": "Municipality"
    },
    {
      "code": "MG-A",
      "name": "Toamasina",
      "type": "Autonomous province"
    },
    {
      "code": "MG-D",
      "name": "Antsiranana",
      "type": "Autonomous province"
    },
    {
      "code": "MG-F",
      "name": "Fianarantsoa",
      "type": "Autonomous province"
    },
    {
      "code": "MG-M",
      "name": "Mahajanga",
      "type": "Autonomous province"
    },
    {
      "code": "MG-T",
      "name": "Antananarivo",
      "type": "Autonomous province"
    },
    {
      "code": "MG-U",
      "name": "Toliara",
      "type": "Autonomous province"
    },
    {
      "code": "MH-ALK",
      "name": "Ailuk",
      "parent": "T",
      "type": "Municipality"
    },
    {
      "code": "MH-ALL",
      "name": "Ailinglaplap",
      "parent": "L",
      "type": "Municipality"
    },
    {
      "code": "MH-ARN",
      "name": "Arno",
      "parent": "T",
      "type": "Municipality"
    },
    {
      "code": "MH-AUR",
      "name": "Aur",
      "parent": "T",
      "type": "Municipality"
    },
    {
      "code": "MH-EBO",
      "name": "Ebon",
      "parent": "L",
      "type": "Municipality"
    },
    {
      "code": "MH-ENI",
      "name": "Enewetak",
      "parent": "L",
      "type": "Municipality"
    },
    {
      "code": "MH-JAB",
      "name": "Jabat",
      "parent": "L",
      "type": "Municipality"
    },
    {
      "code": "MH-JAL",
      "name": "Jaluit",
      "parent": "L",
      "type": "Municipality"
    },
    {
      "code": "MH-KIL",
      "name": "Kili",
      "parent": "L",
      "type": "Municipality"
    },
    {
      "code": "MH-KWA",
      "name": "Kwajalein",
      "parent": "L",
      "type": "Municipality"
    },
    {
      "code": "MH-L",
      "name": "Ralik chain",
      "type": "Chains (of islands)"
    },
    {
      "code": "MH-LAE",
      "name": "Lae",
      "parent": "L",
      "type": "Municipality"
    },
    {
      "code": "MH-LIB",
      "name": "Lib",
      "parent": "L",
      "type": "Municipality"
    },
    {
      "code": "MH-LIK",
      "name": "Likiep",
      "parent": "T",
      "type": "Municipality"
    },
    {
      "code": "MH-MAJ",
      "name": "Majuro",
      "parent": "T",
      "type": "Municipality"
    },
    {
      "code": "MH-MAL",
      "name": "Maloelap",
      "parent": "T",
      "type": "Municipality"
    },
    {
      "code": "MH-MEJ",
      "name": "Mejit",
      "parent": "T",
      "type": "Municipality"
    },
    {
      "code": "MH-MIL",
      "name": "Mili",
      "parent": "T",
      "type": "Municipality"
    },
    {
      "code": "MH-NMK",
      "name": "Namdrik",
      "parent": "L",
      "type": "Municipality"
    },
    {
      "code": "MH-NMU",
      "name": "Namu",
      "parent": "L",
      "type": "Municipality"
    },
    {
      "code": "MH-RON",
      "name": "Rongelap",
      "parent": "L",
      "type": "Municipality"
    },
    {
      "code": "MH-T",
      "name": "Ratak chain",
      "type": "Chains (of islands)"
    },
    {
      "code": "MH-UJA",
      "name": "Ujae",
      "parent": "L",
      "type": "Municipality"
    },
    {
      "code": "MH-UTI",
      "name": "Utirik",
      "parent": "T",
      "type": "Municipality"
    },
    {
      "code": "MH-WTJ",
      "name": "Wotje",
      "parent": "T",
      "type": "Municipality"
    },
    {
      "code": "MH-WTN",
      "name": "Wotho",
      "parent": "L",
      "type": "Municipality"
    },
    {
      "code": "MK-01",
      "name": "Aerodrom",
      "type": "Municipality"
    },
    {
      "code": "MK-02",
      "name": "Aračinovo",
      "type": "Municipality"
    },
    {
      "code": "MK-03",
      "name": "Berovo",
      "type": "Municipality"
    },
    {
      "code": "MK-04",
      "name": "Bitola",
      "type": "Municipality"
    },
    {
      "code": "MK-05",
      "name": "Bogdanci",
      "type": "Municipality"
    },
    {
      "code": "MK-06",
      "name": "Bogovinje",
      "type": "Municipality"
    },
    {
      "code": "MK-07",
      "name": "Bosilovo",
      "type": "Municipality"
    },
    {
      "code": "MK-08",
      "name": "Brvenica",
      "type": "Municipality"
    },
    {
      "code": "MK-09",
      "name": "Butel",
      "type": "Municipality"
    },
    {
      "code": "MK-10",
      "name": "Valandovo",
      "type": "Municipality"
    },
    {
      "code": "MK-11",
      "name": "Vasilevo",
      "type": "Municipality"
    },
    {
      "code": "MK-12",
      "name": "Vevčani",
      "type": "Municipality"
    },
    {
      "code": "MK-13",
      "name": "Veles",
      "type": "Municipality"
    },
    {
      "code": "MK-14",
      "name": "Vinica",
      "type": "Municipality"
    },
    {
      "code": "MK-15",
      "name": "Vraneštica",
      "type": "Municipality"
    },
    {
      "code": "MK-16",
      "name": "Vrapčište",
      "type": "Municipality"
    },
    {
      "code": "MK-17",
      "name": "Gazi Baba",
      "type": "Municipality"
    },
    {
      "code": "MK-18",
      "name": "Gevgelija",
      "type": "Municipality"
    },
    {
      "code": "MK-19",
      "name": "Gostivar",
      "type": "Municipality"
    },
    {
      "code": "MK-20",
      "name": "Gradsko",
      "type": "Municipality"
    },
    {
      "code": "MK-21",
      "name": "Debar",
      "type": "Municipality"
    },
    {
      "code": "MK-22",
      "name": "Debarca",
      "type": "Municipality"
    },
    {
      "code": "MK-23",
      "name": "Delčevo",
      "type": "Municipality"
    },
    {
      "code": "MK-24",
      "name": "Demir Kapija",
      "type": "Municipality"
    },
    {
      "code": "MK-25",
      "name": "Demir Hisar",
      "type": "Municipality"
    },
    {
      "code": "MK-26",
      "name": "Dojran",
      "type": "Municipality"
    },
    {
      "code": "MK-27",
      "name": "Dolneni",
      "type": "Municipality"
    },
    {
      "code": "MK-28",
      "name": "Drugovo",
      "type": "Municipality"
    },
    {
      "code": "MK-29",
      "name": "Gjorče Petrov",
      "type": "Municipality"
    },
    {
      "code": "MK-30",
      "name": "Želino",
      "type": "Municipality"
    },
    {
      "code": "MK-31",
      "name": "Zajas",
      "type": "Municipality"
    },
    {
      "code": "MK-32",
      "name": "Zelenikovo",
      "type": "Municipality"
    },
    {
      "code": "MK-33",
      "name": "Zrnovci",
      "type": "Municipality"
    },
    {
      "code": "MK-34",
      "name": "Ilinden",
      "type": "Municipality"
    },
    {
      "code": "MK-35",
      "name": "Jegunovce",
      "type": "Municipality"
    },
    {
      "code": "MK-36",
      "name": "Kavadarci",
      "type": "Municipality"
    },
    {
      "code": "MK-37",
      "name": "Karbinci",
      "type": "Municipality"
    },
    {
      "code": "MK-38",
      "name": "Karpoš",
      "type": "Municipality"
    },
    {
      "code": "MK-39",
      "name": "Kisela Voda",
      "type": "Municipality"
    },
    {
      "code": "MK-40",
      "name": "Kičevo",
      "type": "Municipality"
    },
    {
      "code": "MK-41",
      "name": "Konče",
      "type": "Municipality"
    },
    {
      "code": "MK-42",
      "name": "Kočani",
      "type": "Municipality"
    },
    {
      "code": "MK-43",
      "name": "Kratovo",
      "type": "Municipality"
    },
    {
      "code": "MK-44",
      "name": "Kriva Palanka",
      "type": "Municipality"
    },
    {
      "code": "MK-45",
      "name": "Krivogaštani",
      "type": "Municipality"
    },
    {
      "code": "MK-46",
      "name": "Kruševo",
      "type": "Municipality"
    },
    {
      "code": "MK-47",
      "name": "Kumanovo",
      "type": "Municipality"
    },
    {
      "code": "MK-48",
      "name": "Lipkovo",
      "type": "Municipality"
    },
    {
      "code": "MK-49",
      "name": "Lozovo",
      "type": "Municipality"
    },
    {
      "code": "MK-50",
      "name": "Mavrovo-i-Rostuša",
      "type": "Municipality"
    },
    {
      "code": "MK-51",
      "name": "Makedonska Kamenica",
      "type": "Municipality"
    },
    {
      "code": "MK-52",
      "name": "Makedonski Brod",
      "type": "Municipality"
    },
    {
      "code": "MK-53",
      "name": "Mogila",
      "type": "Municipality"
    },
    {
      "code": "MK-54",
      "name": "Negotino",
      "type": "Municipality"
    },
    {
      "code": "MK-55",
      "name": "Novaci",
      "type": "Municipality"
    },
    {
      "code": "MK-56",
      "name": "Novo Selo",
      "type": "Municipality"
    },
    {
      "code": "MK-57",
      "name": "Oslomej",
      "type": "Municipality"
    },
    {
      "code": "MK-58",
      "name": "Ohrid",
      "type": "Municipality"
    },
    {
      "code": "MK-59",
      "name": "Petrovec",
      "type": "Municipality"
    },
    {
      "code": "MK-60",
      "name": "Pehčevo",
      "type": "Municipality"
    },
    {
      "code": "MK-61",
      "name": "Plasnica",
      "type": "Municipality"
    },
    {
      "code": "MK-62",
      "name": "Prilep",
      "type": "Municipality"
    },
    {
      "code": "MK-63",
      "name": "Probištip",
      "type": "Municipality"
    },
    {
      "code": "MK-64",
      "name": "Radoviš",
      "type": "Municipality"
    },
    {
      "code": "MK-65",
      "name": "Rankovce",
      "type": "Municipality"
    },
    {
      "code": "MK-66",
      "name": "Resen",
      "type": "Municipality"
    },
    {
      "code": "MK-67",
      "name": "Rosoman",
      "type": "Municipality"
    },
    {
      "code": "MK-68",
      "name": "Saraj",
      "type": "Municipality"
    },
    {
      "code": "MK-69",
      "name": "Sveti Nikole",
      "type": "Municipality"
    },
    {
      "code": "MK-70",
      "name": "Sopište",
      "type": "Municipality"
    },
    {
      "code": "MK-71",
      "name": "Staro Nagoričane",
      "type": "Municipality"
    },
    {
      "code": "MK-72",
      "name": "Struga",
      "type": "Municipality"
    },
    {
      "code": "MK-73",
      "name": "Strumica",
      "type": "Municipality"
    },
    {
      "code": "MK-74",
      "name": "Studeničani",
      "type": "Municipality"
    },
    {
      "code": "MK-75",
      "name": "Tearce",
      "type": "Municipality"
    },
    {
      "code": "MK-76",
      "name": "Tetovo",
      "type": "Municipality"
    },
    {
      "code": "MK-77",
      "name": "Centar",
      "type": "Municipality"
    },
    {
      "code": "MK-78",
      "name": "Centar Župa",
      "type": "Municipality"
    },
    {
      "code": "MK-79",
      "name": "Čair",
      "type": "Municipality"
    },
    {
      "code": "MK-80",
      "name": "Čaška",
      "type": "Municipality"
    },
    {
      "code": "MK-81",
      "name": "Češinovo-Obleševo",
      "type": "Municipality"
    },
    {
      "code": "MK-82",
      "name": "Čučer Sandevo",
      "type": "Municipality"
    },
    {
      "code": "MK-83",
      "name": "Štip",
      "type": "Municipality"
    },
    {
      "code": "MK-84",
      "name": "Šuto Orizari",
      "type": "Municipality"
    },
    {
      "code": "ML-1",
      "name": "Kayes",
      "type": "Region"
    },
    {
      "code": "ML-2",
      "name": "Koulikoro",
      "type": "Region"
    },
    {
      "code": "ML-3",
      "name": "Sikasso",
      "type": "Region"
    },
    {
      "code": "ML-4",
      "name": "Ségou",
      "type": "Region"
    },
    {
      "code": "ML-5",
      "name": "Mopti",
      "type": "Region"
    },
    {
      "code": "ML-6",
      "name": "Tombouctou",
      "type": "Region"
    },
    {
      "code": "ML-7",
      "name": "Gao",
      "type": "Region"
    },
    {
      "code": "ML-8",
      "name": "Kidal",
      "type": "Region"
    },
    {
      "code": "ML-BK0",
      "name": "Bamako",
      "type": "District"
    },
    {
      "code": "MM-01",
      "name": "Sagaing",
      "type": "Division"
    },
    {
      "code": "MM-02",
      "name": "Bago",
      "type": "Division"
    },
    {
      "code": "MM-03",
      "name": "Magway",
      "type": "Division"
    },
    {
      "code": "MM-04",
      "name": "Mandalay",
      "type": "Division"
    },
    {
      "code": "MM-05",
      "name": "Tanintharyi",
      "type": "Division"
    },
    {
      "code": "MM-06",
      "name": "Yangon",
      "type": "Division"
    },
    {
      "code": "MM-07",
      "name": "Ayeyarwady",
      "type": "Division"
    },
    {
      "code": "MM-11",
      "name": "Kachin",
      "type": "State"
    },
    {
      "code": "MM-12",
      "name": "Kayah",
      "type": "State"
    },
    {
      "code": "MM-13",
      "name": "Kayin",
      "type": "State"
    },
    {
      "code": "MM-14",
      "name": "Chin",
      "type": "State"
    },
    {
      "code": "MM-15",
      "name": "Mon",
      "type": "State"
    },
    {
      "code": "MM-16",
      "name": "Rakhine",
      "type": "State"
    },
    {
      "code": "MM-17",
      "name": "Shan",
      "type": "State"
    },
    {
      "code": "MN-035",
      "name": "Orhon",
      "type": "Municipality"
    },
    {
      "code": "MN-037",
      "name": "Darhan uul",
      "type": "Municipality"
    },
    {
      "code": "MN-039",
      "name": "Hentiy",
      "type": "Province"
    },
    {
      "code": "MN-041",
      "name": "Hövsgöl",
      "type": "Province"
    },
    {
      "code": "MN-043",
      "name": "Hovd",
      "type": "Province"
    },
    {
      "code": "MN-046",
      "name": "Uvs",
      "type": "Province"
    },
    {
      "code": "MN-047",
      "name": "Töv",
      "type": "Province"
    },
    {
      "code": "MN-049",
      "name": "Selenge",
      "type": "Province"
    },
    {
      "code": "MN-051",
      "name": "Sühbaatar",
      "type": "Province"
    },
    {
      "code": "MN-053",
      "name": "Ömnögovi",
      "type": "Province"
    },
    {
      "code": "MN-055",
      "name": "Övörhangay",
      "type": "Province"
    },
    {
      "code": "MN-057",
      "name": "Dzavhan",
      "type": "Province"
    },
    {
      "code": "MN-059",
      "name": "Dundgovi",
      "type": "Province"
    },
    {
      "code": "MN-061",
      "name": "Dornod",
      "type": "Province"
    },
    {
      "code": "MN-063",
      "name": "Dornogovi",
      "type": "Province"
    },
    {
      "code": "MN-064",
      "name": "Govi-Sumber",
      "type": "Municipality"
    },
    {
      "code": "MN-065",
      "name": "Govi-Altay",
      "type": "Province"
    },
    {
      "code": "MN-067",
      "name": "Bulgan",
      "type": "Province"
    },
    {
      "code": "MN-069",
      "name": "Bayanhongor",
      "type": "Province"
    },
    {
      "code": "MN-071",
      "name": "Bayan-Ölgiy",
      "type": "Province"
    },
    {
      "code": "MN-073",
      "name": "Arhangay",
      "type": "Province"
    },
    {
      "code": "MN-1",
      "name": "Ulanbaatar",
      "type": "Municipality"
    },
    {
      "code": "MR-01",
      "name": "Hodh ech Chargui",
      "type": "Region"
    },
    {
      "code": "MR-02",
      "name": "Hodh el Charbi",
      "type": "Region"
    },
    {
      "code": "MR-03",
      "name": "Assaba",
      "type": "Region"
    },
    {
      "code": "MR-04",
      "name": "Gorgol",
      "type": "Region"
    },
    {
      "code": "MR-05",
      "name": "Brakna",
      "type": "Region"
    },
    {
      "code": "MR-06",
      "name": "Trarza",
      "type": "Region"
    },
    {
      "code": "MR-07",
      "name": "Adrar",
      "type": "Region"
    },
    {
      "code": "MR-08",
      "name": "Dakhlet Nouadhibou",
      "type": "Region"
    },
    {
      "code": "MR-09",
      "name": "Tagant",
      "type": "Region"
    },
    {
      "code": "MR-10",
      "name": "Guidimaka",
      "type": "Region"
    },
    {
      "code": "MR-11",
      "name": "Tiris Zemmour",
      "type": "Region"
    },
    {
      "code": "MR-12",
      "name": "Inchiri",
      "type": "Region"
    },
    {
      "code": "MR-NKC",
      "name": "Nouakchott",
      "type": "District"
    },
    {
      "code": "MT-01",
      "name": "Attard",
      "type": "Local council"
    },
    {
      "code": "MT-02",
      "name": "Balzan",
      "type": "Local council"
    },
    {
      "code": "MT-03",
      "name": "Birgu",
      "type": "Local council"
    },
    {
      "code": "MT-04",
      "name": "Birkirkara",
      "type": "Local council"
    },
    {
      "code": "MT-05",
      "name": "Birżebbuġa",
      "type": "Local council"
    },
    {
      "code": "MT-06",
      "name": "Bormla",
      "type": "Local council"
    },
    {
      "code": "MT-07",
      "name": "Dingli",
      "type": "Local council"
    },
    {
      "code": "MT-08",
      "name": "Fgura",
      "type": "Local council"
    },
    {
      "code": "MT-09",
      "name": "Floriana",
      "type": "Local council"
    },
    {
      "code": "MT-10",
      "name": "Fontana",
      "type": "Local council"
    },
    {
      "code": "MT-11",
      "name": "Gudja",
      "type": "Local council"
    },
    {
      "code": "MT-12",
      "name": "Gżira",
      "type": "Local council"
    },
    {
      "code": "MT-13",
      "name": "Għajnsielem",
      "type": "Local council"
    },
    {
      "code": "MT-14",
      "name": "Għarb",
      "type": "Local council"
    },
    {
      "code": "MT-15",
      "name": "Għargħur",
      "type": "Local council"
    },
    {
      "code": "MT-16",
      "name": "Għasri",
      "type": "Local council"
    },
    {
      "code": "MT-17",
      "name": "Għaxaq",
      "type": "Local council"
    },
    {
      "code": "MT-18",
      "name": "Ħamrun",
      "type": "Local council"
    },
    {
      "code": "MT-19",
      "name": "Iklin",
      "type": "Local council"
    },
    {
      "code": "MT-20",
      "name": "Isla",
      "type": "Local council"
    },
    {
      "code": "MT-21",
      "name": "Kalkara",
      "type": "Local council"
    },
    {
      "code": "MT-22",
      "name": "Kerċem",
      "type": "Local council"
    },
    {
      "code": "MT-23",
      "name": "Kirkop",
      "type": "Local council"
    },
    {
      "code": "MT-24",
      "name": "Lija",
      "type": "Local council"
    },
    {
      "code": "MT-25",
      "name": "Luqa",
      "type": "Local council"
    },
    {
      "code": "MT-26",
      "name": "Marsa",
      "type": "Local council"
    },
    {
      "code": "MT-27",
      "name": "Marsaskala",
      "type": "Local council"
    },
    {
      "code": "MT-28",
      "name": "Marsaxlokk",
      "type": "Local council"
    },
    {
      "code": "MT-29",
      "name": "Mdina",
      "type": "Local council"
    },
    {
      "code": "MT-30",
      "name": "Mellieħa",
      "type": "Local council"
    },
    {
      "code": "MT-31",
      "name": "Mġarr",
      "type": "Local council"
    },
    {
      "code": "MT-32",
      "name": "Mosta",
      "type": "Local council"
    },
    {
      "code": "MT-33",
      "name": "Mqabba",
      "type": "Local council"
    },
    {
      "code": "MT-34",
      "name": "Msida",
      "type": "Local council"
    },
    {
      "code": "MT-35",
      "name": "Mtarfa",
      "type": "Local council"
    },
    {
      "code": "MT-36",
      "name": "Munxar",
      "type": "Local council"
    },
    {
      "code": "MT-37",
      "name": "Nadur",
      "type": "Local council"
    },
    {
      "code": "MT-38",
      "name": "Naxxar",
      "type": "Local council"
    },
    {
      "code": "MT-39",
      "name": "Paola",
      "type": "Local council"
    },
    {
      "code": "MT-40",
      "name": "Pembroke",
      "type": "Local council"
    },
    {
      "code": "MT-41",
      "name": "Pietà",
      "type": "Local council"
    },
    {
      "code": "MT-42",
      "name": "Qala",
      "type": "Local council"
    },
    {
      "code": "MT-43",
      "name": "Qormi",
      "type": "Local council"
    },
    {
      "code": "MT-44",
      "name": "Qrendi",
      "type": "Local council"
    },
    {
      "code": "MT-45",
      "name": "Rabat Għawdex",
      "type": "Local council"
    },
    {
      "code": "MT-46",
      "name": "Rabat Malta",
      "type": "Local council"
    },
    {
      "code": "MT-47",
      "name": "Safi",
      "type": "Local council"
    },
    {
      "code": "MT-48",
      "name": "San Ġiljan",
      "type": "Local council"
    },
    {
      "code": "MT-49",
      "name": "San Ġwann",
      "type": "Local council"
    },
    {
      "code": "MT-50",
      "name": "San Lawrenz",
      "type": "Local council"
    },
    {
      "code": "MT-51",
      "name": "San Pawl il-Baħar",
      "type": "Local council"
    },
    {
      "code": "MT-52",
      "name": "Sannat",
      "type": "Local council"
    },
    {
      "code": "MT-53",
      "name": "Santa Luċija",
      "type": "Local council"
    },
    {
      "code": "MT-54",
      "name": "Santa Venera",
      "type": "Local council"
    },
    {
      "code": "MT-55",
      "name": "Siġġiewi",
      "type": "Local council"
    },
    {
      "code": "MT-56",
      "name": "Sliema",
      "type": "Local council"
    },
    {
      "code": "MT-57",
      "name": "Swieqi",
      "type": "Local council"
    },
    {
      "code": "MT-58",
      "name": "Ta’ Xbiex",
      "type": "Local council"
    },
    {
      "code": "MT-59",
      "name": "Tarxien",
      "type": "Local council"
    },
    {
      "code": "MT-60",
      "name": "Valletta",
      "type": "Local council"
    },
    {
      "code": "MT-61",
      "name": "Xagħra",
      "type": "Local council"
    },
    {
      "code": "MT-62",
      "name": "Xewkija",
      "type": "Local council"
    },
    {
      "code": "MT-63",
      "name": "Xgħajra",
      "type": "Local council"
    },
    {
      "code": "MT-64",
      "name": "Żabbar",
      "type": "Local council"
    },
    {
      "code": "MT-65",
      "name": "Żebbuġ Għawdex",
      "type": "Local council"
    },
    {
      "code": "MT-66",
      "name": "Żebbuġ Malta",
      "type": "Local council"
    },
    {
      "code": "MT-67",
      "name": "Żejtun",
      "type": "Local council"
    },
    {
      "code": "MT-68",
      "name": "Żurrieq",
      "type": "Local council"
    },
    {
      "code": "MU-AG",
      "name": "Agalega Islands",
      "type": "Dependency"
    },
    {
      "code": "MU-BL",
      "name": "Black River",
      "type": "District"
    },
    {
      "code": "MU-BR",
      "name": "Beau Bassin-Rose Hill",
      "type": "City"
    },
    {
      "code": "MU-CC",
      "name": "Cargados Carajos Shoals",
      "type": "Dependency"
    },
    {
      "code": "MU-CU",
      "name": "Curepipe",
      "type": "City"
    },
    {
      "code": "MU-FL",
      "name": "Flacq",
      "type": "District"
    },
    {
      "code": "MU-GP",
      "name": "Grand Port",
      "type": "District"
    },
    {
      "code": "MU-MO",
      "name": "Moka",
      "type": "District"
    },
    {
      "code": "MU-PA",
      "name": "Pamplemousses",
      "type": "District"
    },
    {
      "code": "MU-PL",
      "name": "Port Louis",
      "type": "District"
    },
    {
      "code": "MU-PU",
      "name": "Port Louis",
      "type": "City"
    },
    {
      "code": "MU-PW",
      "name": "Plaines Wilhems",
      "type": "District"
    },
    {
      "code": "MU-QB",
      "name": "Quatre Bornes",
      "type": "City"
    },
    {
      "code": "MU-RO",
      "name": "Rodrigues Island",
      "type": "Dependency"
    },
    {
      "code": "MU-RP",
      "name": "Rivière du Rempart",
      "type": "District"
    },
    {
      "code": "MU-SA",
      "name": "Savanne",
      "type": "District"
    },
    {
      "code": "MU-VP",
      "name": "Vacoas-Phoenix",
      "type": "City"
    },
    {
      "code": "MV-00",
      "name": "Alifu Dhaalu",
      "parent": "NC",
      "type": "Administrative atoll"
    },
    {
      "code": "MV-01",
      "name": "Seenu",
      "parent": "SU",
      "type": "Administrative atoll"
    },
    {
      "code": "MV-02",
      "name": "Alifu Alifu",
      "parent": "NC",
      "type": "Administrative atoll"
    },
    {
      "code": "MV-03",
      "name": "Lhaviyani",
      "parent": "NO",
      "type": "Administrative atoll"
    },
    {
      "code": "MV-04",
      "name": "Vaavu",
      "parent": "NC",
      "type": "Administrative atoll"
    },
    {
      "code": "MV-05",
      "name": "Laamu",
      "parent": "US",
      "type": "Administrative atoll"
    },
    {
      "code": "MV-07",
      "name": "Haa Alifu",
      "parent": "UN",
      "type": "Administrative atoll"
    },
    {
      "code": "MV-08",
      "name": "Thaa",
      "parent": "US",
      "type": "Administrative atoll"
    },
    {
      "code": "MV-12",
      "name": "Meemu",
      "parent": "CE",
      "type": "Administrative atoll"
    },
    {
      "code": "MV-13",
      "name": "Raa",
      "parent": "NO",
      "type": "Administrative atoll"
    },
    {
      "code": "MV-14",
      "name": "Faafu",
      "parent": "CE",
      "type": "Administrative atoll"
    },
    {
      "code": "MV-17",
      "name": "Dhaalu",
      "parent": "CE",
      "type": "Administrative atoll"
    },
    {
      "code": "MV-20",
      "name": "Baa",
      "parent": "NO",
      "type": "Administrative atoll"
    },
    {
      "code": "MV-23",
      "name": "Haa Dhaalu",
      "parent": "UN",
      "type": "Administrative atoll"
    },
    {
      "code": "MV-24",
      "name": "Shaviyani",
      "parent": "UN",
      "type": "Administrative atoll"
    },
    {
      "code": "MV-25",
      "name": "Noonu",
      "parent": "NO",
      "type": "Administrative atoll"
    },
    {
      "code": "MV-26",
      "name": "Kaafu",
      "parent": "NC",
      "type": "Administrative atoll"
    },
    {
      "code": "MV-27",
      "name": "Gaafu Alifu",
      "parent": "SC",
      "type": "Administrative atoll"
    },
    {
      "code": "MV-28",
      "name": "Gaafu Dhaalu",
      "parent": "SC",
      "type": "Administrative atoll"
    },
    {
      "code": "MV-29",
      "name": "Gnaviyani",
      "parent": "SU",
      "type": "Administrative atoll"
    },
    {
      "code": "MV-CE",
      "name": "Central",
      "type": "Province"
    },
    {
      "code": "MV-MLE",
      "name": "Male",
      "type": "City"
    },
    {
      "code": "MV-NC",
      "name": "North Central",
      "type": "Province"
    },
    {
      "code": "MV-NO",
      "name": "North",
      "type": "Province"
    },
    {
      "code": "MV-SC",
      "name": "South Central",
      "type": "Province"
    },
    {
      "code": "MV-SU",
      "name": "South",
      "type": "Province"
    },
    {
      "code": "MV-UN",
      "name": "Upper North",
      "type": "Province"
    },
    {
      "code": "MV-US",
      "name": "Upper South",
      "type": "Province"
    },
    {
      "code": "MW-BA",
      "name": "Balaka",
      "parent": "S",
      "type": "District"
    },
    {
      "code": "MW-BL",
      "name": "Blantyre",
      "parent": "S",
      "type": "District"
    },
    {
      "code": "MW-C",
      "name": "Central Region",
      "type": "Region"
    },
    {
      "code": "MW-CK",
      "name": "Chikwawa",
      "parent": "S",
      "type": "District"
    },
    {
      "code": "MW-CR",
      "name": "Chiradzulu",
      "parent": "S",
      "type": "District"
    },
    {
      "code": "MW-CT",
      "name": "Chitipa",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "MW-DE",
      "name": "Dedza",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "MW-DO",
      "name": "Dowa",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "MW-KR",
      "name": "Karonga",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "MW-KS",
      "name": "Kasungu",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "MW-LI",
      "name": "Lilongwe",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "MW-LK",
      "name": "Likoma",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "MW-MC",
      "name": "Mchinji",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "MW-MG",
      "name": "Mangochi",
      "parent": "S",
      "type": "District"
    },
    {
      "code": "MW-MH",
      "name": "Machinga",
      "parent": "S",
      "type": "District"
    },
    {
      "code": "MW-MU",
      "name": "Mulanje",
      "parent": "S",
      "type": "District"
    },
    {
      "code": "MW-MW",
      "name": "Mwanza",
      "parent": "S",
      "type": "District"
    },
    {
      "code": "MW-MZ",
      "name": "Mzimba",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "MW-N",
      "name": "Northern Region",
      "type": "Region"
    },
    {
      "code": "MW-NB",
      "name": "Nkhata Bay",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "MW-NE",
      "name": "Neno",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "MW-NI",
      "name": "Ntchisi",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "MW-NK",
      "name": "Nkhotakota",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "MW-NS",
      "name": "Nsanje",
      "parent": "S",
      "type": "District"
    },
    {
      "code": "MW-NU",
      "name": "Ntcheu",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "MW-PH",
      "name": "Phalombe",
      "parent": "S",
      "type": "District"
    },
    {
      "code": "MW-RU",
      "name": "Rumphi",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "MW-S",
      "name": "Southern Region",
      "type": "Region"
    },
    {
      "code": "MW-SA",
      "name": "Salima",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "MW-TH",
      "name": "Thyolo",
      "parent": "S",
      "type": "District"
    },
    {
      "code": "MW-ZO",
      "name": "Zomba",
      "parent": "S",
      "type": "District"
    },
    {
      "code": "MX-AGU",
      "name": "Aguascalientes",
      "type": "State"
    },
    {
      "code": "MX-BCN",
      "name": "Baja California",
      "type": "State"
    },
    {
      "code": "MX-BCS",
      "name": "Baja California Sur",
      "type": "State"
    },
    {
      "code": "MX-CAM",
      "name": "Campeche",
      "type": "State"
    },
    {
      "code": "MX-CHH",
      "name": "Chihuahua",
      "type": "State"
    },
    {
      "code": "MX-CHP",
      "name": "Chiapas",
      "type": "State"
    },
    {
      "code": "MX-COA",
      "name": "Coahuila",
      "type": "State"
    },
    {
      "code": "MX-COL",
      "name": "Colima",
      "type": "State"
    },
    {
      "code": "MX-DIF",
      "name": "Distrito Federal",
      "type": "Federal district"
    },
    {
      "code": "MX-DUR",
      "name": "Durango",
      "type": "State"
    },
    {
      "code": "MX-GRO",
      "name": "Guerrero",
      "type": "State"
    },
    {
      "code": "MX-GUA",
      "name": "Guanajuato",
      "type": "State"
    },
    {
      "code": "MX-HID",
      "name": "Hidalgo",
      "type": "State"
    },
    {
      "code": "MX-JAL",
      "name": "Jalisco",
      "type": "State"
    },
    {
      "code": "MX-MEX",
      "name": "México",
      "type": "State"
    },
    {
      "code": "MX-MIC",
      "name": "Michoacán",
      "type": "State"
    },
    {
      "code": "MX-MOR",
      "name": "Morelos",
      "type": "State"
    },
    {
      "code": "MX-NAY",
      "name": "Nayarit",
      "type": "State"
    },
    {
      "code": "MX-NLE",
      "name": "Nuevo León",
      "type": "State"
    },
    {
      "code": "MX-OAX",
      "name": "Oaxaca",
      "type": "State"
    },
    {
      "code": "MX-PUE",
      "name": "Puebla",
      "type": "State"
    },
    {
      "code": "MX-QUE",
      "name": "Querétaro",
      "type": "State"
    },
    {
      "code": "MX-ROO",
      "name": "Quintana Roo",
      "type": "State"
    },
    {
      "code": "MX-SIN",
      "name": "Sinaloa",
      "type": "State"
    },
    {
      "code": "MX-SLP",
      "name": "San Luis Potosí",
      "type": "State"
    },
    {
      "code": "MX-SON",
      "name": "Sonora",
      "type": "State"
    },
    {
      "code": "MX-TAB",
      "name": "Tabasco",
      "type": "State"
    },
    {
      "code": "MX-TAM",
      "name": "Tamaulipas",
      "type": "State"
    },
    {
      "code": "MX-TLA",
      "name": "Tlaxcala",
      "type": "State"
    },
    {
      "code": "MX-VER",
      "name": "Veracruz",
      "type": "State"
    },
    {
      "code": "MX-YUC",
      "name": "Yucatán",
      "type": "State"
    },
    {
      "code": "MX-ZAC",
      "name": "Zacatecas",
      "type": "State"
    },
    {
      "code": "MY-01",
      "name": "Johor",
      "type": "State"
    },
    {
      "code": "MY-02",
      "name": "Kedah",
      "type": "State"
    },
    {
      "code": "MY-03",
      "name": "Kelantan",
      "type": "State"
    },
    {
      "code": "MY-04",
      "name": "Melaka",
      "type": "State"
    },
    {
      "code": "MY-05",
      "name": "Negeri Sembilan",
      "type": "State"
    },
    {
      "code": "MY-06",
      "name": "Pahang",
      "type": "State"
    },
    {
      "code": "MY-07",
      "name": "Pulau Pinang",
      "type": "State"
    },
    {
      "code": "MY-08",
      "name": "Perak",
      "type": "State"
    },
    {
      "code": "MY-09",
      "name": "Perlis",
      "type": "State"
    },
    {
      "code": "MY-10",
      "name": "Selangor",
      "type": "State"
    },
    {
      "code": "MY-11",
      "name": "Terengganu",
      "type": "State"
    },
    {
      "code": "MY-12",
      "name": "Sabah",
      "type": "State"
    },
    {
      "code": "MY-13",
      "name": "Sarawak",
      "type": "State"
    },
    {
      "code": "MY-14",
      "name": "Wilayah Persekutuan Kuala Lumpur",
      "type": "Federal Territories"
    },
    {
      "code": "MY-15",
      "name": "Wilayah Persekutuan Labuan",
      "type": "Federal Territories"
    },
    {
      "code": "MY-16",
      "name": "Wilayah Persekutuan Putrajaya",
      "type": "Federal Territories"
    },
    {
      "code": "MZ-A",
      "name": "Niassa",
      "type": "Province"
    },
    {
      "code": "MZ-B",
      "name": "Manica",
      "type": "Province"
    },
    {
      "code": "MZ-G",
      "name": "Gaza",
      "type": "Province"
    },
    {
      "code": "MZ-I",
      "name": "Inhambane",
      "type": "Province"
    },
    {
      "code": "MZ-L",
      "name": "Maputo",
      "type": "Province"
    },
    {
      "code": "MZ-MPM",
      "name": "Maputo (city)",
      "type": "City"
    },
    {
      "code": "MZ-N",
      "name": "Numpula",
      "type": "Province"
    },
    {
      "code": "MZ-P",
      "name": "Cabo Delgado",
      "type": "Province"
    },
    {
      "code": "MZ-Q",
      "name": "Zambezia",
      "type": "Province"
    },
    {
      "code": "MZ-S",
      "name": "Sofala",
      "type": "Province"
    },
    {
      "code": "MZ-T",
      "name": "Tete",
      "type": "Province"
    },
    {
      "code": "NA-CA",
      "name": "Caprivi",
      "type": "Region"
    },
    {
      "code": "NA-ER",
      "name": "Erongo",
      "type": "Region"
    },
    {
      "code": "NA-HA",
      "name": "Hardap",
      "type": "Region"
    },
    {
      "code": "NA-KA",
      "name": "Karas",
      "type": "Region"
    },
    {
      "code": "NA-KH",
      "name": "Khomas",
      "type": "Region"
    },
    {
      "code": "NA-KU",
      "name": "Kunene",
      "type": "Region"
    },
    {
      "code": "NA-OD",
      "name": "Otjozondjupa",
      "type": "Region"
    },
    {
      "code": "NA-OH",
      "name": "Omaheke",
      "type": "Region"
    },
    {
      "code": "NA-OK",
      "name": "Okavango",
      "type": "Region"
    },
    {
      "code": "NA-ON",
      "name": "Oshana",
      "type": "Region"
    },
    {
      "code": "NA-OS",
      "name": "Omusati",
      "type": "Region"
    },
    {
      "code": "NA-OT",
      "name": "Oshikoto",
      "type": "Region"
    },
    {
      "code": "NA-OW",
      "name": "Ohangwena",
      "type": "Region"
    },
    {
      "code": "NE-1",
      "name": "Agadez",
      "type": "Department"
    },
    {
      "code": "NE-2",
      "name": "Diffa",
      "type": "Department"
    },
    {
      "code": "NE-3",
      "name": "Dosso",
      "type": "Department"
    },
    {
      "code": "NE-4",
      "name": "Maradi",
      "type": "Department"
    },
    {
      "code": "NE-5",
      "name": "Tahoua",
      "type": "Department"
    },
    {
      "code": "NE-6",
      "name": "Tillabéri",
      "type": "Department"
    },
    {
      "code": "NE-7",
      "name": "Zinder",
      "type": "Department"
    },
    {
      "code": "NE-8",
      "name": "Niamey",
      "type": "Capital District"
    },
    {
      "code": "NG-AB",
      "name": "Abia",
      "type": "State"
    },
    {
      "code": "NG-AD",
      "name": "Adamawa",
      "type": "State"
    },
    {
      "code": "NG-AK",
      "name": "Akwa Ibom",
      "type": "State"
    },
    {
      "code": "NG-AN",
      "name": "Anambra",
      "type": "State"
    },
    {
      "code": "NG-BA",
      "name": "Bauchi",
      "type": "State"
    },
    {
      "code": "NG-BE",
      "name": "Benue",
      "type": "State"
    },
    {
      "code": "NG-BO",
      "name": "Borno",
      "type": "State"
    },
    {
      "code": "NG-BY",
      "name": "Bayelsa",
      "type": "State"
    },
    {
      "code": "NG-CR",
      "name": "Cross River",
      "type": "State"
    },
    {
      "code": "NG-DE",
      "name": "Delta",
      "type": "State"
    },
    {
      "code": "NG-EB",
      "name": "Ebonyi",
      "type": "State"
    },
    {
      "code": "NG-ED",
      "name": "Edo",
      "type": "State"
    },
    {
      "code": "NG-EK",
      "name": "Ekiti",
      "type": "State"
    },
    {
      "code": "NG-EN",
      "name": "Enugu",
      "type": "State"
    },
    {
      "code": "NG-FC",
      "name": "Abuja Capital Territory",
      "type": "Capital Territory"
    },
    {
      "code": "NG-GO",
      "name": "Gombe",
      "type": "State"
    },
    {
      "code": "NG-IM",
      "name": "Imo",
      "type": "State"
    },
    {
      "code": "NG-JI",
      "name": "Jigawa",
      "type": "State"
    },
    {
      "code": "NG-KD",
      "name": "Kaduna",
      "type": "State"
    },
    {
      "code": "NG-KE",
      "name": "Kebbi",
      "type": "State"
    },
    {
      "code": "NG-KN",
      "name": "Kano",
      "type": "State"
    },
    {
      "code": "NG-KO",
      "name": "Kogi",
      "type": "State"
    },
    {
      "code": "NG-KT",
      "name": "Katsina",
      "type": "State"
    },
    {
      "code": "NG-KW",
      "name": "Kwara",
      "type": "State"
    },
    {
      "code": "NG-LA",
      "name": "Lagos",
      "type": "State"
    },
    {
      "code": "NG-NA",
      "name": "Nassarawa",
      "type": "State"
    },
    {
      "code": "NG-NI",
      "name": "Niger",
      "type": "State"
    },
    {
      "code": "NG-OG",
      "name": "Ogun",
      "type": "State"
    },
    {
      "code": "NG-ON",
      "name": "Ondo",
      "type": "State"
    },
    {
      "code": "NG-OS",
      "name": "Osun",
      "type": "State"
    },
    {
      "code": "NG-OY",
      "name": "Oyo",
      "type": "State"
    },
    {
      "code": "NG-PL",
      "name": "Plateau",
      "type": "State"
    },
    {
      "code": "NG-RI",
      "name": "Rivers",
      "type": "State"
    },
    {
      "code": "NG-SO",
      "name": "Sokoto",
      "type": "State"
    },
    {
      "code": "NG-TA",
      "name": "Taraba",
      "type": "State"
    },
    {
      "code": "NG-YO",
      "name": "Yobe",
      "type": "State"
    },
    {
      "code": "NG-ZA",
      "name": "Zamfara",
      "type": "State"
    },
    {
      "code": "NI-AN",
      "name": "Atlántico Norte",
      "type": "Autonomous Region"
    },
    {
      "code": "NI-AS",
      "name": "Atlántico Sur",
      "type": "Autonomous Region"
    },
    {
      "code": "NI-BO",
      "name": "Boaco",
      "type": "Department"
    },
    {
      "code": "NI-CA",
      "name": "Carazo",
      "type": "Department"
    },
    {
      "code": "NI-CI",
      "name": "Chinandega",
      "type": "Department"
    },
    {
      "code": "NI-CO",
      "name": "Chontales",
      "type": "Department"
    },
    {
      "code": "NI-ES",
      "name": "Estelí",
      "type": "Department"
    },
    {
      "code": "NI-GR",
      "name": "Granada",
      "type": "Department"
    },
    {
      "code": "NI-JI",
      "name": "Jinotega",
      "type": "Department"
    },
    {
      "code": "NI-LE",
      "name": "León",
      "type": "Department"
    },
    {
      "code": "NI-MD",
      "name": "Madriz",
      "type": "Department"
    },
    {
      "code": "NI-MN",
      "name": "Managua",
      "type": "Department"
    },
    {
      "code": "NI-MS",
      "name": "Masaya",
      "type": "Department"
    },
    {
      "code": "NI-MT",
      "name": "Matagalpa",
      "type": "Department"
    },
    {
      "code": "NI-NS",
      "name": "Nueva Segovia",
      "type": "Department"
    },
    {
      "code": "NI-RI",
      "name": "Rivas",
      "type": "Department"
    },
    {
      "code": "NI-SJ",
      "name": "Río San Juan",
      "type": "Department"
    },
    {
      "code": "NL-AW",
      "name": "Aruba",
      "type": "Country"
    },
    {
      "code": "NL-BQ1",
      "name": "Bonaire",
      "type": "Special municipality"
    },
    {
      "code": "NL-BQ2",
      "name": "Saba",
      "type": "Special municipality"
    },
    {
      "code": "NL-BQ3",
      "name": "Sint Eustatius",
      "type": "Special municipality"
    },
    {
      "code": "NL-CW",
      "name": "Curaçao",
      "type": "Country"
    },
    {
      "code": "NL-DR",
      "name": "Drenthe",
      "type": "Province"
    },
    {
      "code": "NL-FL",
      "name": "Flevoland",
      "type": "Province"
    },
    {
      "code": "NL-FR",
      "name": "Friesland",
      "type": "Province"
    },
    {
      "code": "NL-GE",
      "name": "Gelderland",
      "type": "Province"
    },
    {
      "code": "NL-GR",
      "name": "Groningen",
      "type": "Province"
    },
    {
      "code": "NL-LI",
      "name": "Limburg",
      "type": "Province"
    },
    {
      "code": "NL-NB",
      "name": "Noord-Brabant",
      "type": "Province"
    },
    {
      "code": "NL-NH",
      "name": "Noord-Holland",
      "type": "Province"
    },
    {
      "code": "NL-OV",
      "name": "Overijssel",
      "type": "Province"
    },
    {
      "code": "NL-SX",
      "name": "Sint Maarten",
      "type": "Country"
    },
    {
      "code": "NL-UT",
      "name": "Utrecht",
      "type": "Province"
    },
    {
      "code": "NL-ZE",
      "name": "Zeeland",
      "type": "Province"
    },
    {
      "code": "NL-ZH",
      "name": "Zuid-Holland",
      "type": "Province"
    },
    {
      "code": "NO-01",
      "name": "Østfold",
      "type": "County"
    },
    {
      "code": "NO-02",
      "name": "Akershus",
      "type": "County"
    },
    {
      "code": "NO-03",
      "name": "Oslo",
      "type": "County"
    },
    {
      "code": "NO-04",
      "name": "Hedmark",
      "type": "County"
    },
    {
      "code": "NO-05",
      "name": "Oppland",
      "type": "County"
    },
    {
      "code": "NO-06",
      "name": "Buskerud",
      "type": "County"
    },
    {
      "code": "NO-07",
      "name": "Vestfold",
      "type": "County"
    },
    {
      "code": "NO-08",
      "name": "Telemark",
      "type": "County"
    },
    {
      "code": "NO-09",
      "name": "Aust-Agder",
      "type": "County"
    },
    {
      "code": "NO-10",
      "name": "Vest-Agder",
      "type": "County"
    },
    {
      "code": "NO-11",
      "name": "Rogaland",
      "type": "County"
    },
    {
      "code": "NO-12",
      "name": "Hordaland",
      "type": "County"
    },
    {
      "code": "NO-14",
      "name": "Sogn og Fjordane",
      "type": "County"
    },
    {
      "code": "NO-15",
      "name": "Møre og Romsdal",
      "type": "County"
    },
    {
      "code": "NO-16",
      "name": "Sør-Trøndelag",
      "type": "County"
    },
    {
      "code": "NO-17",
      "name": "Nord-Trøndelag",
      "type": "County"
    },
    {
      "code": "NO-18",
      "name": "Nordland",
      "type": "County"
    },
    {
      "code": "NO-19",
      "name": "Troms",
      "type": "County"
    },
    {
      "code": "NO-20",
      "name": "Finnmark",
      "type": "County"
    },
    {
      "code": "NO-21",
      "name": "Svalbard (Arctic Region)",
      "type": "Arctic Region"
    },
    {
      "code": "NO-22",
      "name": "Jan Mayen (Arctic Region)",
      "type": "Arctic Region"
    },
    {
      "code": "NP-1",
      "name": "Madhyamanchal",
      "type": "Development region"
    },
    {
      "code": "NP-2",
      "name": "Madhya Pashchimanchal",
      "type": "Development region"
    },
    {
      "code": "NP-3",
      "name": "Pashchimanchal",
      "type": "Development region"
    },
    {
      "code": "NP-4",
      "name": "Purwanchal",
      "type": "Development region"
    },
    {
      "code": "NP-5",
      "name": "Sudur Pashchimanchal",
      "type": "Development region"
    },
    {
      "code": "NP-BA",
      "name": "Bagmati",
      "parent": "1",
      "type": "zone"
    },
    {
      "code": "NP-BH",
      "name": "Bheri",
      "parent": "2",
      "type": "zone"
    },
    {
      "code": "NP-DH",
      "name": "Dhawalagiri",
      "parent": "3",
      "type": "zone"
    },
    {
      "code": "NP-GA",
      "name": "Gandaki",
      "parent": "3",
      "type": "zone"
    },
    {
      "code": "NP-JA",
      "name": "Janakpur",
      "parent": "1",
      "type": "zone"
    },
    {
      "code": "NP-KA",
      "name": "Karnali",
      "parent": "2",
      "type": "zone"
    },
    {
      "code": "NP-KO",
      "name": "Kosi",
      "parent": "4",
      "type": "zone"
    },
    {
      "code": "NP-LU",
      "name": "Lumbini",
      "parent": "3",
      "type": "zone"
    },
    {
      "code": "NP-MA",
      "name": "Mahakali",
      "parent": "5",
      "type": "zone"
    },
    {
      "code": "NP-ME",
      "name": "Mechi",
      "parent": "4",
      "type": "zone"
    },
    {
      "code": "NP-NA",
      "name": "Narayani",
      "parent": "1",
      "type": "zone"
    },
    {
      "code": "NP-RA",
      "name": "Rapti",
      "parent": "2",
      "type": "zone"
    },
    {
      "code": "NP-SA",
      "name": "Sagarmatha",
      "parent": "4",
      "type": "zone"
    },
    {
      "code": "NP-SE",
      "name": "Seti",
      "parent": "5",
      "type": "zone"
    },
    {
      "code": "NR-01",
      "name": "Aiwo",
      "type": "District"
    },
    {
      "code": "NR-02",
      "name": "Anabar",
      "type": "District"
    },
    {
      "code": "NR-03",
      "name": "Anetan",
      "type": "District"
    },
    {
      "code": "NR-04",
      "name": "Anibare",
      "type": "District"
    },
    {
      "code": "NR-05",
      "name": "Baiti",
      "type": "District"
    },
    {
      "code": "NR-06",
      "name": "Boe",
      "type": "District"
    },
    {
      "code": "NR-07",
      "name": "Buada",
      "type": "District"
    },
    {
      "code": "NR-08",
      "name": "Denigomodu",
      "type": "District"
    },
    {
      "code": "NR-09",
      "name": "Ewa",
      "type": "District"
    },
    {
      "code": "NR-10",
      "name": "Ijuw",
      "type": "District"
    },
    {
      "code": "NR-11",
      "name": "Meneng",
      "type": "District"
    },
    {
      "code": "NR-12",
      "name": "Nibok",
      "type": "District"
    },
    {
      "code": "NR-13",
      "name": "Uaboe",
      "type": "District"
    },
    {
      "code": "NR-14",
      "name": "Yaren",
      "type": "District"
    },
    {
      "code": "NZ-AUK",
      "name": "Auckland",
      "parent": "N",
      "type": "Regional council"
    },
    {
      "code": "NZ-BOP",
      "name": "Bay of Plenty",
      "parent": "N",
      "type": "Regional council"
    },
    {
      "code": "NZ-CAN",
      "name": "Canterbury",
      "parent": "S",
      "type": "Regional council"
    },
    {
      "code": "NZ-CIT",
      "name": "Chatham Islands Territory",
      "type": "Special island authority"
    },
    {
      "code": "NZ-GIS",
      "name": "Gisborne District",
      "parent": "N",
      "type": "Unitary authority"
    },
    {
      "code": "NZ-HKB",
      "name": "Hawke's Bay",
      "parent": "N",
      "type": "Regional council"
    },
    {
      "code": "NZ-MBH",
      "name": "Marlborough District",
      "parent": "S",
      "type": "Unitary authority"
    },
    {
      "code": "NZ-MWT",
      "name": "Manawatu-Wanganui",
      "parent": "N",
      "type": "Regional council"
    },
    {
      "code": "NZ-N",
      "name": "North Island",
      "type": "Island"
    },
    {
      "code": "NZ-NSN",
      "name": "Nelson City",
      "parent": "S",
      "type": "Unitary authority"
    },
    {
      "code": "NZ-NTL",
      "name": "Northland",
      "parent": "N",
      "type": "Regional council"
    },
    {
      "code": "NZ-OTA",
      "name": "Otago",
      "parent": "S",
      "type": "Regional council"
    },
    {
      "code": "NZ-S",
      "name": "South Island",
      "type": "Island"
    },
    {
      "code": "NZ-STL",
      "name": "Southland",
      "parent": "S",
      "type": "Regional council"
    },
    {
      "code": "NZ-TAS",
      "name": "Tasman District",
      "parent": "S",
      "type": "Unitary authority"
    },
    {
      "code": "NZ-TKI",
      "name": "Taranaki",
      "parent": "N",
      "type": "Regional council"
    },
    {
      "code": "NZ-WGN",
      "name": "Wellington",
      "parent": "N",
      "type": "Regional council"
    },
    {
      "code": "NZ-WKO",
      "name": "Waikato",
      "parent": "N",
      "type": "Regional council"
    },
    {
      "code": "NZ-WTC",
      "name": "West Coast",
      "parent": "S",
      "type": "Regional council"
    },
    {
      "code": "OM-BA",
      "name": "Al Bāţinah",
      "type": "Region"
    },
    {
      "code": "OM-BU",
      "name": "Al Buraymī",
      "type": "Governorate"
    },
    {
      "code": "OM-DA",
      "name": "Ad Dākhilīya",
      "type": "Region"
    },
    {
      "code": "OM-MA",
      "name": "Masqaţ",
      "type": "Governorate"
    },
    {
      "code": "OM-MU",
      "name": "Musandam",
      "type": "Governorate"
    },
    {
      "code": "OM-SH",
      "name": "Ash Sharqīyah",
      "type": "Region"
    },
    {
      "code": "OM-WU",
      "name": "Al Wusţá",
      "type": "Region"
    },
    {
      "code": "OM-ZA",
      "name": "Az̧ Z̧āhirah",
      "type": "Region"
    },
    {
      "code": "OM-ZU",
      "name": "Z̧ufār",
      "type": "Governorate"
    },
    {
      "code": "PA-1",
      "name": "Bocas del Toro",
      "type": "Province"
    },
    {
      "code": "PA-2",
      "name": "Coclé",
      "type": "Province"
    },
    {
      "code": "PA-3",
      "name": "Colón",
      "type": "Province"
    },
    {
      "code": "PA-4",
      "name": "Chiriquí",
      "type": "Province"
    },
    {
      "code": "PA-5",
      "name": "Darién",
      "type": "Province"
    },
    {
      "code": "PA-6",
      "name": "Herrera",
      "type": "Province"
    },
    {
      "code": "PA-7",
      "name": "Los Santos",
      "type": "Province"
    },
    {
      "code": "PA-8",
      "name": "Panamá",
      "type": "Province"
    },
    {
      "code": "PA-9",
      "name": "Veraguas",
      "type": "Province"
    },
    {
      "code": "PA-EM",
      "name": "Emberá",
      "type": "Indigenous region"
    },
    {
      "code": "PA-KY",
      "name": "Kuna Yala",
      "type": "Indigenous region"
    },
    {
      "code": "PA-NB",
      "name": "Ngöbe-Buglé",
      "type": "Indigenous region"
    },
    {
      "code": "PE-AMA",
      "name": "Amazonas",
      "type": "Region"
    },
    {
      "code": "PE-ANC",
      "name": "Ancash",
      "type": "Region"
    },
    {
      "code": "PE-APU",
      "name": "Apurímac",
      "type": "Region"
    },
    {
      "code": "PE-ARE",
      "name": "Arequipa",
      "type": "Region"
    },
    {
      "code": "PE-AYA",
      "name": "Ayacucho",
      "type": "Region"
    },
    {
      "code": "PE-CAJ",
      "name": "Cajamarca",
      "type": "Region"
    },
    {
      "code": "PE-CAL",
      "name": "El Callao",
      "type": "Constitutional province"
    },
    {
      "code": "PE-CUS",
      "name": "Cusco [Cuzco]",
      "type": "Region"
    },
    {
      "code": "PE-HUC",
      "name": "Huánuco",
      "type": "Region"
    },
    {
      "code": "PE-HUV",
      "name": "Huancavelica",
      "type": "Region"
    },
    {
      "code": "PE-ICA",
      "name": "Ica",
      "type": "Region"
    },
    {
      "code": "PE-JUN",
      "name": "Junín",
      "type": "Region"
    },
    {
      "code": "PE-LAL",
      "name": "La Libertad",
      "type": "Region"
    },
    {
      "code": "PE-LAM",
      "name": "Lambayeque",
      "type": "Region"
    },
    {
      "code": "PE-LIM",
      "name": "Lima",
      "type": "Region"
    },
    {
      "code": "PE-LMA",
      "name": "Municipalidad Metropolitana de Lima",
      "type": "Municipality"
    },
    {
      "code": "PE-LOR",
      "name": "Loreto",
      "type": "Region"
    },
    {
      "code": "PE-MDD",
      "name": "Madre de Dios",
      "type": "Region"
    },
    {
      "code": "PE-MOQ",
      "name": "Moquegua",
      "type": "Region"
    },
    {
      "code": "PE-PAS",
      "name": "Pasco",
      "type": "Region"
    },
    {
      "code": "PE-PIU",
      "name": "Piura",
      "type": "Region"
    },
    {
      "code": "PE-PUN",
      "name": "Puno",
      "type": "Region"
    },
    {
      "code": "PE-SAM",
      "name": "San Martín",
      "type": "Region"
    },
    {
      "code": "PE-TAC",
      "name": "Tacna",
      "type": "Region"
    },
    {
      "code": "PE-TUM",
      "name": "Tumbes",
      "type": "Region"
    },
    {
      "code": "PE-UCA",
      "name": "Ucayali",
      "type": "Region"
    },
    {
      "code": "PG-CPK",
      "name": "Chimbu",
      "type": "Province"
    },
    {
      "code": "PG-CPM",
      "name": "Central",
      "type": "Province"
    },
    {
      "code": "PG-EBR",
      "name": "East New Britain",
      "type": "Province"
    },
    {
      "code": "PG-EHG",
      "name": "Eastern Highlands",
      "type": "Province"
    },
    {
      "code": "PG-EPW",
      "name": "Enga",
      "type": "Province"
    },
    {
      "code": "PG-ESW",
      "name": "East Sepik",
      "type": "Province"
    },
    {
      "code": "PG-GPK",
      "name": "Gulf",
      "type": "Province"
    },
    {
      "code": "PG-MBA",
      "name": "Milne Bay",
      "type": "Province"
    },
    {
      "code": "PG-MPL",
      "name": "Morobe",
      "type": "Province"
    },
    {
      "code": "PG-MPM",
      "name": "Madang",
      "type": "Province"
    },
    {
      "code": "PG-MRL",
      "name": "Manus",
      "type": "Province"
    },
    {
      "code": "PG-NCD",
      "name": "National Capital District (Port Moresby)",
      "type": "District"
    },
    {
      "code": "PG-NIK",
      "name": "New Ireland",
      "type": "Province"
    },
    {
      "code": "PG-NPP",
      "name": "Northern",
      "type": "Province"
    },
    {
      "code": "PG-NSB",
      "name": "Bougainville",
      "type": "Autonomous region"
    },
    {
      "code": "PG-SAN",
      "name": "Sandaun",
      "type": "Province"
    },
    {
      "code": "PG-SHM",
      "name": "Southern Highlands",
      "type": "Province"
    },
    {
      "code": "PG-WBK",
      "name": "West New Britain",
      "type": "Province"
    },
    {
      "code": "PG-WHM",
      "name": "Western Highlands",
      "type": "Province"
    },
    {
      "code": "PG-WPD",
      "name": "Western",
      "type": "Province"
    },
    {
      "code": "PH-00",
      "name": "National Capital Region",
      "type": "Region"
    },
    {
      "code": "PH-01",
      "name": "Ilocos (Region I)",
      "type": "Region"
    },
    {
      "code": "PH-02",
      "name": "Cagayan Valley (Region II)",
      "type": "Region"
    },
    {
      "code": "PH-03",
      "name": "Central Luzon (Region III)",
      "type": "Region"
    },
    {
      "code": "PH-05",
      "name": "Bicol (Region V)",
      "type": "Region"
    },
    {
      "code": "PH-06",
      "name": "Western Visayas (Region VI)",
      "type": "Region"
    },
    {
      "code": "PH-07",
      "name": "Central Visayas (Region VII)",
      "type": "Region"
    },
    {
      "code": "PH-08",
      "name": "Eastern Visayas (Region VIII)",
      "type": "Region"
    },
    {
      "code": "PH-09",
      "name": "Zamboanga Peninsula (Region IX)",
      "type": "Region"
    },
    {
      "code": "PH-10",
      "name": "Northern Mindanao (Region X)",
      "type": "Region"
    },
    {
      "code": "PH-11",
      "name": "Davao (Region XI)",
      "type": "Region"
    },
    {
      "code": "PH-12",
      "name": "Soccsksargen (Region XII)",
      "type": "Region"
    },
    {
      "code": "PH-13",
      "name": "Caraga (Region XIII)",
      "type": "Region"
    },
    {
      "code": "PH-14",
      "name": "Autonomous Region in Muslim Mindanao (ARMM)",
      "type": "Region"
    },
    {
      "code": "PH-15",
      "name": "Cordillera Administrative Region (CAR)",
      "type": "Region"
    },
    {
      "code": "PH-40",
      "name": "CALABARZON (Region IV-A)",
      "type": "Region"
    },
    {
      "code": "PH-41",
      "name": "MIMAROPA (Region IV-B)",
      "type": "Region"
    },
    {
      "code": "PH-ABR",
      "name": "Abra",
      "parent": "15",
      "type": "Province"
    },
    {
      "code": "PH-AGN",
      "name": "Agusan del Norte",
      "parent": "13",
      "type": "Province"
    },
    {
      "code": "PH-AGS",
      "name": "Agusan del Sur",
      "parent": "13",
      "type": "Province"
    },
    {
      "code": "PH-AKL",
      "name": "Aklan",
      "parent": "06",
      "type": "Province"
    },
    {
      "code": "PH-ALB",
      "name": "Albay",
      "parent": "05",
      "type": "Province"
    },
    {
      "code": "PH-ANT",
      "name": "Antique",
      "parent": "06",
      "type": "Province"
    },
    {
      "code": "PH-APA",
      "name": "Apayao",
      "parent": "15",
      "type": "Province"
    },
    {
      "code": "PH-AUR",
      "name": "Aurora",
      "parent": "03",
      "type": "Province"
    },
    {
      "code": "PH-BAN",
      "name": "Batasn",
      "parent": "03",
      "type": "Province"
    },
    {
      "code": "PH-BAS",
      "name": "Basilan",
      "parent": "09",
      "type": "Province"
    },
    {
      "code": "PH-BEN",
      "name": "Benguet",
      "parent": "15",
      "type": "Province"
    },
    {
      "code": "PH-BIL",
      "name": "Biliran",
      "parent": "08",
      "type": "Province"
    },
    {
      "code": "PH-BOH",
      "name": "Bohol",
      "parent": "07",
      "type": "Province"
    },
    {
      "code": "PH-BTG",
      "name": "Batangas",
      "parent": "40",
      "type": "Province"
    },
    {
      "code": "PH-BTN",
      "name": "Batanes",
      "parent": "02",
      "type": "Province"
    },
    {
      "code": "PH-BUK",
      "name": "Bukidnon",
      "parent": "10",
      "type": "Province"
    },
    {
      "code": "PH-BUL",
      "name": "Bulacan",
      "parent": "03",
      "type": "Province"
    },
    {
      "code": "PH-CAG",
      "name": "Cagayan",
      "parent": "02",
      "type": "Province"
    },
    {
      "code": "PH-CAM",
      "name": "Camiguin",
      "parent": "10",
      "type": "Province"
    },
    {
      "code": "PH-CAN",
      "name": "Camarines Norte",
      "parent": "05",
      "type": "Province"
    },
    {
      "code": "PH-CAP",
      "name": "Capiz",
      "parent": "06",
      "type": "Province"
    },
    {
      "code": "PH-CAS",
      "name": "Camarines Sur",
      "parent": "05",
      "type": "Province"
    },
    {
      "code": "PH-CAT",
      "name": "Catanduanes",
      "parent": "05",
      "type": "Province"
    },
    {
      "code": "PH-CAV",
      "name": "Cavite",
      "parent": "40",
      "type": "Province"
    },
    {
      "code": "PH-CEB",
      "name": "Cebu",
      "parent": "07",
      "type": "Province"
    },
    {
      "code": "PH-COM",
      "name": "Compostela Valley",
      "parent": "11",
      "type": "Province"
    },
    {
      "code": "PH-DAO",
      "name": "Davao Oriental",
      "parent": "11",
      "type": "Province"
    },
    {
      "code": "PH-DAS",
      "name": "Davao del Sur",
      "parent": "11",
      "type": "Province"
    },
    {
      "code": "PH-DAV",
      "name": "Davao del Norte",
      "parent": "11",
      "type": "Province"
    },
    {
      "code": "PH-DIN",
      "name": "Dinagat Islands",
      "parent": "13",
      "type": "Province"
    },
    {
      "code": "PH-EAS",
      "name": "Eastern Samar",
      "parent": "08",
      "type": "Province"
    },
    {
      "code": "PH-GUI",
      "name": "Guimaras",
      "parent": "06",
      "type": "Province"
    },
    {
      "code": "PH-IFU",
      "name": "Ifugao",
      "parent": "15",
      "type": "Province"
    },
    {
      "code": "PH-ILI",
      "name": "Iloilo",
      "parent": "06",
      "type": "Province"
    },
    {
      "code": "PH-ILN",
      "name": "Ilocos Norte",
      "parent": "01",
      "type": "Province"
    },
    {
      "code": "PH-ILS",
      "name": "Ilocos Sur",
      "parent": "01",
      "type": "Province"
    },
    {
      "code": "PH-ISA",
      "name": "Isabela",
      "parent": "02",
      "type": "Province"
    },
    {
      "code": "PH-KAL",
      "name": "Kalinga-Apayso",
      "parent": "15",
      "type": "Province"
    },
    {
      "code": "PH-LAG",
      "name": "Laguna",
      "parent": "40",
      "type": "Province"
    },
    {
      "code": "PH-LAN",
      "name": "Lanao del Norte",
      "parent": "12",
      "type": "Province"
    },
    {
      "code": "PH-LAS",
      "name": "Lanao del Sur",
      "parent": "14",
      "type": "Province"
    },
    {
      "code": "PH-LEY",
      "name": "Leyte",
      "parent": "08",
      "type": "Province"
    },
    {
      "code": "PH-LUN",
      "name": "La Union",
      "parent": "01",
      "type": "Province"
    },
    {
      "code": "PH-MAD",
      "name": "Marinduque",
      "parent": "41",
      "type": "Province"
    },
    {
      "code": "PH-MAG",
      "name": "Maguindanao",
      "parent": "14",
      "type": "Province"
    },
    {
      "code": "PH-MAS",
      "name": "Masbate",
      "parent": "05",
      "type": "Province"
    },
    {
      "code": "PH-MDC",
      "name": "Mindoro Occidental",
      "parent": "41",
      "type": "Province"
    },
    {
      "code": "PH-MDR",
      "name": "Mindoro Oriental",
      "parent": "41",
      "type": "Province"
    },
    {
      "code": "PH-MOU",
      "name": "Mountain Province",
      "parent": "15",
      "type": "Province"
    },
    {
      "code": "PH-MSC",
      "name": "Misamis Occidental",
      "parent": "10",
      "type": "Province"
    },
    {
      "code": "PH-MSR",
      "name": "Misamis Oriental",
      "parent": "10",
      "type": "Province"
    },
    {
      "code": "PH-NCO",
      "name": "North Cotabato",
      "parent": "12",
      "type": "Province"
    },
    {
      "code": "PH-NEC",
      "name": "Negros Occidental",
      "parent": "06",
      "type": "Province"
    },
    {
      "code": "PH-NER",
      "name": "Negros Oriental",
      "parent": "07",
      "type": "Province"
    },
    {
      "code": "PH-NSA",
      "name": "Northern Samar",
      "parent": "08",
      "type": "Province"
    },
    {
      "code": "PH-NUE",
      "name": "Nueva Ecija",
      "parent": "03",
      "type": "Province"
    },
    {
      "code": "PH-NUV",
      "name": "Nueva Vizcaya",
      "parent": "02",
      "type": "Province"
    },
    {
      "code": "PH-PAM",
      "name": "Pampanga",
      "parent": "03",
      "type": "Province"
    },
    {
      "code": "PH-PAN",
      "name": "Pangasinan",
      "parent": "01",
      "type": "Province"
    },
    {
      "code": "PH-PLW",
      "name": "Palawan",
      "parent": "41",
      "type": "Province"
    },
    {
      "code": "PH-QUE",
      "name": "Quezon",
      "parent": "40",
      "type": "Province"
    },
    {
      "code": "PH-QUI",
      "name": "Quirino",
      "parent": "02",
      "type": "Province"
    },
    {
      "code": "PH-RIZ",
      "name": "Rizal",
      "parent": "40",
      "type": "Province"
    },
    {
      "code": "PH-ROM",
      "name": "Romblon",
      "parent": "41",
      "type": "Province"
    },
    {
      "code": "PH-SAR",
      "name": "Sarangani",
      "parent": "11",
      "type": "Province"
    },
    {
      "code": "PH-SCO",
      "name": "South Cotabato",
      "parent": "11",
      "type": "Province"
    },
    {
      "code": "PH-SIG",
      "name": "Siquijor",
      "parent": "07",
      "type": "Province"
    },
    {
      "code": "PH-SLE",
      "name": "Southern Leyte",
      "parent": "08",
      "type": "Province"
    },
    {
      "code": "PH-SLU",
      "name": "Sulu",
      "parent": "14",
      "type": "Province"
    },
    {
      "code": "PH-SOR",
      "name": "Sorsogon",
      "parent": "05",
      "type": "Province"
    },
    {
      "code": "PH-SUK",
      "name": "Sultan Kudarat",
      "parent": "12",
      "type": "Province"
    },
    {
      "code": "PH-SUN",
      "name": "Surigao del Norte",
      "parent": "13",
      "type": "Province"
    },
    {
      "code": "PH-SUR",
      "name": "Surigao del Sur",
      "parent": "13",
      "type": "Province"
    },
    {
      "code": "PH-TAR",
      "name": "Tarlac",
      "parent": "03",
      "type": "Province"
    },
    {
      "code": "PH-TAW",
      "name": "Tawi-Tawi",
      "parent": "14",
      "type": "Province"
    },
    {
      "code": "PH-WSA",
      "name": "Western Samar",
      "parent": "08",
      "type": "Province"
    },
    {
      "code": "PH-ZAN",
      "name": "Zamboanga del Norte",
      "parent": "09",
      "type": "Province"
    },
    {
      "code": "PH-ZAS",
      "name": "Zamboanga del Sur",
      "parent": "09",
      "type": "Province"
    },
    {
      "code": "PH-ZMB",
      "name": "Zambales",
      "parent": "03",
      "type": "Province"
    },
    {
      "code": "PH-ZSI",
      "name": "Zamboanga Sibugay",
      "parent": "09",
      "type": "Province"
    },
    {
      "code": "PK-BA",
      "name": "Balochistan",
      "type": "Province"
    },
    {
      "code": "PK-GB",
      "name": "Gilgit-Baltistan",
      "type": "Area"
    },
    {
      "code": "PK-IS",
      "name": "Islamabad",
      "type": "Capital territory"
    },
    {
      "code": "PK-JK",
      "name": "Azad Kashmir",
      "type": "Area"
    },
    {
      "code": "PK-KP",
      "name": "Khyber Pakhtunkhwa",
      "type": "Province"
    },
    {
      "code": "PK-PB",
      "name": "Punjab",
      "type": "Province"
    },
    {
      "code": "PK-SD",
      "name": "Sindh",
      "type": "Province"
    },
    {
      "code": "PK-TA",
      "name": "Federally Administered Tribal Areas",
      "type": "Territory"
    },
    {
      "code": "PL-DS",
      "name": "Dolnośląskie",
      "type": "Province"
    },
    {
      "code": "PL-KP",
      "name": "Kujawsko-pomorskie",
      "type": "Province"
    },
    {
      "code": "PL-LB",
      "name": "Lubuskie",
      "type": "Province"
    },
    {
      "code": "PL-LD",
      "name": "Łódzkie",
      "type": "Province"
    },
    {
      "code": "PL-LU",
      "name": "Lubelskie",
      "type": "Province"
    },
    {
      "code": "PL-MA",
      "name": "Małopolskie",
      "type": "Province"
    },
    {
      "code": "PL-MZ",
      "name": "Mazowieckie",
      "type": "Province"
    },
    {
      "code": "PL-OP",
      "name": "Opolskie",
      "type": "Province"
    },
    {
      "code": "PL-PD",
      "name": "Podlaskie",
      "type": "Province"
    },
    {
      "code": "PL-PK",
      "name": "Podkarpackie",
      "type": "Province"
    },
    {
      "code": "PL-PM",
      "name": "Pomorskie",
      "type": "Province"
    },
    {
      "code": "PL-SK",
      "name": "Świętokrzyskie",
      "type": "Province"
    },
    {
      "code": "PL-SL",
      "name": "Śląskie",
      "type": "Province"
    },
    {
      "code": "PL-WN",
      "name": "Warmińsko-mazurskie",
      "type": "Province"
    },
    {
      "code": "PL-WP",
      "name": "Wielkopolskie",
      "type": "Province"
    },
    {
      "code": "PL-ZP",
      "name": "Zachodniopomorskie",
      "type": "Province"
    },
    {
      "code": "PS-BTH",
      "name": "Bethlehem",
      "type": "Governorate"
    },
    {
      "code": "PS-DEB",
      "name": "Deir El Balah",
      "type": "Governorate"
    },
    {
      "code": "PS-GZA",
      "name": "Gaza",
      "type": "Governorate"
    },
    {
      "code": "PS-HBN",
      "name": "Hebron",
      "type": "Governorate"
    },
    {
      "code": "PS-JEM",
      "name": "Jerusalem",
      "type": "Governorate"
    },
    {
      "code": "PS-JEN",
      "name": "Jenin",
      "type": "Governorate"
    },
    {
      "code": "PS-JRH",
      "name": "Jericho - Al Aghwar",
      "type": "Governorate"
    },
    {
      "code": "PS-KYS",
      "name": "Khan Yunis",
      "type": "Governorate"
    },
    {
      "code": "PS-NBS",
      "name": "Nablus",
      "type": "Governorate"
    },
    {
      "code": "PS-NGZ",
      "name": "North Gaza",
      "type": "Governorate"
    },
    {
      "code": "PS-QQA",
      "name": "Qalqilya",
      "type": "Governorate"
    },
    {
      "code": "PS-RBH",
      "name": "Ramallah",
      "type": "Governorate"
    },
    {
      "code": "PS-RFH",
      "name": "Rafah",
      "type": "Governorate"
    },
    {
      "code": "PS-SLT",
      "name": "Salfit",
      "type": "Governorate"
    },
    {
      "code": "PS-TBS",
      "name": "Tubas",
      "type": "Governorate"
    },
    {
      "code": "PS-TKM",
      "name": "Tulkarm",
      "type": "Governorate"
    },
    {
      "code": "PT-01",
      "name": "Aveiro",
      "type": "District"
    },
    {
      "code": "PT-02",
      "name": "Beja",
      "type": "District"
    },
    {
      "code": "PT-03",
      "name": "Braga",
      "type": "District"
    },
    {
      "code": "PT-04",
      "name": "Bragança",
      "type": "District"
    },
    {
      "code": "PT-05",
      "name": "Castelo Branco",
      "type": "District"
    },
    {
      "code": "PT-06",
      "name": "Coimbra",
      "type": "District"
    },
    {
      "code": "PT-07",
      "name": "Évora",
      "type": "District"
    },
    {
      "code": "PT-08",
      "name": "Faro",
      "type": "District"
    },
    {
      "code": "PT-09",
      "name": "Guarda",
      "type": "District"
    },
    {
      "code": "PT-10",
      "name": "Leiria",
      "type": "District"
    },
    {
      "code": "PT-11",
      "name": "Lisboa",
      "type": "District"
    },
    {
      "code": "PT-12",
      "name": "Portalegre",
      "type": "District"
    },
    {
      "code": "PT-13",
      "name": "Porto",
      "type": "District"
    },
    {
      "code": "PT-14",
      "name": "Santarém",
      "type": "District"
    },
    {
      "code": "PT-15",
      "name": "Setúbal",
      "type": "District"
    },
    {
      "code": "PT-16",
      "name": "Viana do Castelo",
      "type": "District"
    },
    {
      "code": "PT-17",
      "name": "Vila Real",
      "type": "District"
    },
    {
      "code": "PT-18",
      "name": "Viseu",
      "type": "District"
    },
    {
      "code": "PT-20",
      "name": "Região Autónoma dos Açores",
      "type": "Autonomous region"
    },
    {
      "code": "PT-30",
      "name": "Região Autónoma da Madeira",
      "type": "Autonomous region"
    },
    {
      "code": "PW-002",
      "name": "Aimeliik",
      "type": "State"
    },
    {
      "code": "PW-004",
      "name": "Airai",
      "type": "State"
    },
    {
      "code": "PW-010",
      "name": "Angaur",
      "type": "State"
    },
    {
      "code": "PW-050",
      "name": "Hatobohei",
      "type": "State"
    },
    {
      "code": "PW-100",
      "name": "Kayangel",
      "type": "State"
    },
    {
      "code": "PW-150",
      "name": "Koror",
      "type": "State"
    },
    {
      "code": "PW-212",
      "name": "Melekeok",
      "type": "State"
    },
    {
      "code": "PW-214",
      "name": "Ngaraard",
      "type": "State"
    },
    {
      "code": "PW-218",
      "name": "Ngarchelong",
      "type": "State"
    },
    {
      "code": "PW-222",
      "name": "Ngardmau",
      "type": "State"
    },
    {
      "code": "PW-224",
      "name": "Ngatpang",
      "type": "State"
    },
    {
      "code": "PW-226",
      "name": "Ngchesar",
      "type": "State"
    },
    {
      "code": "PW-227",
      "name": "Ngeremlengui",
      "type": "State"
    },
    {
      "code": "PW-228",
      "name": "Ngiwal",
      "type": "State"
    },
    {
      "code": "PW-350",
      "name": "Peleliu",
      "type": "State"
    },
    {
      "code": "PW-370",
      "name": "Sonsorol",
      "type": "State"
    },
    {
      "code": "PY-1",
      "name": "Concepción",
      "type": "Department"
    },
    {
      "code": "PY-10",
      "name": "Alto Paraná",
      "type": "Department"
    },
    {
      "code": "PY-11",
      "name": "Central",
      "type": "Department"
    },
    {
      "code": "PY-12",
      "name": "Ñeembucú",
      "type": "Department"
    },
    {
      "code": "PY-13",
      "name": "Amambay",
      "type": "Department"
    },
    {
      "code": "PY-14",
      "name": "Canindeyú",
      "type": "Department"
    },
    {
      "code": "PY-15",
      "name": "Presidente Hayes",
      "type": "Department"
    },
    {
      "code": "PY-16",
      "name": "Alto Paraguay",
      "type": "Department"
    },
    {
      "code": "PY-19",
      "name": "Boquerón",
      "type": "Department"
    },
    {
      "code": "PY-2",
      "name": "San Pedro",
      "type": "Department"
    },
    {
      "code": "PY-3",
      "name": "Cordillera",
      "type": "Department"
    },
    {
      "code": "PY-4",
      "name": "Guairá",
      "type": "Department"
    },
    {
      "code": "PY-5",
      "name": "Caaguazú",
      "type": "Department"
    },
    {
      "code": "PY-6",
      "name": "Caazapá",
      "type": "Department"
    },
    {
      "code": "PY-7",
      "name": "Itapúa",
      "type": "Department"
    },
    {
      "code": "PY-8",
      "name": "Misiones",
      "type": "Department"
    },
    {
      "code": "PY-9",
      "name": "Paraguarí",
      "type": "Department"
    },
    {
      "code": "PY-ASU",
      "name": "Asunción",
      "type": "Capital district"
    },
    {
      "code": "QA-DA",
      "name": "Ad Dawhah",
      "type": "Municipality"
    },
    {
      "code": "QA-KH",
      "name": "Al Khawr wa adh Dhakhīrah",
      "type": "Municipality"
    },
    {
      "code": "QA-MS",
      "name": "Ash Shamal",
      "type": "Municipality"
    },
    {
      "code": "QA-RA",
      "name": "Ar Rayyan",
      "type": "Municipality"
    },
    {
      "code": "QA-US",
      "name": "Umm Salal",
      "type": "Municipality"
    },
    {
      "code": "QA-WA",
      "name": "Al Wakrah",
      "type": "Municipality"
    },
    {
      "code": "QA-ZA",
      "name": "Az̧ Z̧a‘āyin",
      "type": "Municipality"
    },
    {
      "code": "RO-AB",
      "name": "Alba",
      "type": "Department"
    },
    {
      "code": "RO-AG",
      "name": "Argeș",
      "type": "Department"
    },
    {
      "code": "RO-AR",
      "name": "Arad",
      "type": "Department"
    },
    {
      "code": "RO-B",
      "name": "București",
      "type": "Municipality"
    },
    {
      "code": "RO-BC",
      "name": "Bacău",
      "type": "Department"
    },
    {
      "code": "RO-BH",
      "name": "Bihor",
      "type": "Department"
    },
    {
      "code": "RO-BN",
      "name": "Bistrița-Năsăud",
      "type": "Department"
    },
    {
      "code": "RO-BR",
      "name": "Brăila",
      "type": "Department"
    },
    {
      "code": "RO-BT",
      "name": "Botoșani",
      "type": "Department"
    },
    {
      "code": "RO-BV",
      "name": "Brașov",
      "type": "Department"
    },
    {
      "code": "RO-BZ",
      "name": "Buzău",
      "type": "Department"
    },
    {
      "code": "RO-CJ",
      "name": "Cluj",
      "type": "Department"
    },
    {
      "code": "RO-CL",
      "name": "Călărași",
      "type": "Department"
    },
    {
      "code": "RO-CS",
      "name": "Caraș-Severin",
      "type": "Department"
    },
    {
      "code": "RO-CT",
      "name": "Constanța",
      "type": "Department"
    },
    {
      "code": "RO-CV",
      "name": "Covasna",
      "type": "Department"
    },
    {
      "code": "RO-DB",
      "name": "Dâmbovița",
      "type": "Department"
    },
    {
      "code": "RO-DJ",
      "name": "Dolj",
      "type": "Department"
    },
    {
      "code": "RO-GJ",
      "name": "Gorj",
      "type": "Department"
    },
    {
      "code": "RO-GL",
      "name": "Galați",
      "type": "Department"
    },
    {
      "code": "RO-GR",
      "name": "Giurgiu",
      "type": "Department"
    },
    {
      "code": "RO-HD",
      "name": "Hunedoara",
      "type": "Department"
    },
    {
      "code": "RO-HR",
      "name": "Harghita",
      "type": "Department"
    },
    {
      "code": "RO-IF",
      "name": "Ilfov",
      "type": "Department"
    },
    {
      "code": "RO-IL",
      "name": "Ialomița",
      "type": "Department"
    },
    {
      "code": "RO-IS",
      "name": "Iași",
      "type": "Department"
    },
    {
      "code": "RO-MH",
      "name": "Mehedinți",
      "type": "Department"
    },
    {
      "code": "RO-MM",
      "name": "Maramureș",
      "type": "Department"
    },
    {
      "code": "RO-MS",
      "name": "Mureș",
      "type": "Department"
    },
    {
      "code": "RO-NT",
      "name": "Neamț",
      "type": "Department"
    },
    {
      "code": "RO-OT",
      "name": "Olt",
      "type": "Department"
    },
    {
      "code": "RO-PH",
      "name": "Prahova",
      "type": "Department"
    },
    {
      "code": "RO-SB",
      "name": "Sibiu",
      "type": "Department"
    },
    {
      "code": "RO-SJ",
      "name": "Sălaj",
      "type": "Department"
    },
    {
      "code": "RO-SM",
      "name": "Satu Mare",
      "type": "Department"
    },
    {
      "code": "RO-SV",
      "name": "Suceava",
      "type": "Department"
    },
    {
      "code": "RO-TL",
      "name": "Tulcea",
      "type": "Department"
    },
    {
      "code": "RO-TM",
      "name": "Timiș",
      "type": "Department"
    },
    {
      "code": "RO-TR",
      "name": "Teleorman",
      "type": "Department"
    },
    {
      "code": "RO-VL",
      "name": "Vâlcea",
      "type": "Department"
    },
    {
      "code": "RO-VN",
      "name": "Vrancea",
      "type": "Department"
    },
    {
      "code": "RO-VS",
      "name": "Vaslui",
      "type": "Department"
    },
    {
      "code": "RS-00",
      "name": "Beograd",
      "type": "City"
    },
    {
      "code": "RS-01",
      "name": "Severnobački okrug",
      "parent": "VO",
      "type": "District"
    },
    {
      "code": "RS-02",
      "name": "Srednjebanatski okrug",
      "parent": "VO",
      "type": "District"
    },
    {
      "code": "RS-03",
      "name": "Severnobanatski okrug",
      "parent": "VO",
      "type": "District"
    },
    {
      "code": "RS-04",
      "name": "Južnobanatski okrug",
      "parent": "VO",
      "type": "District"
    },
    {
      "code": "RS-05",
      "name": "Zapadnobački okrug",
      "parent": "VO",
      "type": "District"
    },
    {
      "code": "RS-06",
      "name": "Južnobački okrug",
      "parent": "VO",
      "type": "District"
    },
    {
      "code": "RS-07",
      "name": "Sremski okrug",
      "parent": "VO",
      "type": "District"
    },
    {
      "code": "RS-08",
      "name": "Mačvanski okrug",
      "type": "District"
    },
    {
      "code": "RS-09",
      "name": "Kolubarski okrug",
      "type": "District"
    },
    {
      "code": "RS-10",
      "name": "Podunavski okrug",
      "type": "District"
    },
    {
      "code": "RS-11",
      "name": "Braničevski okrug",
      "type": "District"
    },
    {
      "code": "RS-12",
      "name": "Šumadijski okrug",
      "type": "District"
    },
    {
      "code": "RS-13",
      "name": "Pomoravski okrug",
      "type": "District"
    },
    {
      "code": "RS-14",
      "name": "Borski okrug",
      "type": "District"
    },
    {
      "code": "RS-15",
      "name": "Zaječarski okrug",
      "type": "District"
    },
    {
      "code": "RS-16",
      "name": "Zlatiborski okrug",
      "type": "District"
    },
    {
      "code": "RS-17",
      "name": "Moravički okrug",
      "type": "District"
    },
    {
      "code": "RS-18",
      "name": "Raški okrug",
      "type": "District"
    },
    {
      "code": "RS-19",
      "name": "Rasinski okrug",
      "type": "District"
    },
    {
      "code": "RS-20",
      "name": "Nišavski okrug",
      "type": "District"
    },
    {
      "code": "RS-21",
      "name": "Toplički okrug",
      "type": "District"
    },
    {
      "code": "RS-22",
      "name": "Pirotski okrug",
      "type": "District"
    },
    {
      "code": "RS-23",
      "name": "Jablanički okrug",
      "type": "District"
    },
    {
      "code": "RS-24",
      "name": "Pčinjski okrug",
      "type": "District"
    },
    {
      "code": "RS-25",
      "name": "Kosovski okrug",
      "parent": "KM",
      "type": "District"
    },
    {
      "code": "RS-26",
      "name": "Pećki okrug",
      "parent": "KM",
      "type": "District"
    },
    {
      "code": "RS-27",
      "name": "Prizrenski okrug",
      "parent": "KM",
      "type": "District"
    },
    {
      "code": "RS-28",
      "name": "Kosovsko-Mitrovački okrug",
      "parent": "KM",
      "type": "District"
    },
    {
      "code": "RS-29",
      "name": "Kosovsko-Pomoravski okrug",
      "parent": "KM",
      "type": "District"
    },
    {
      "code": "RS-KM",
      "name": "Kosovo-Metohija",
      "type": "Autonomous province"
    },
    {
      "code": "RS-VO",
      "name": "Vojvodina",
      "type": "Autonomous province"
    },
    {
      "code": "RU-AD",
      "name": "Adygeya, Respublika",
      "type": "Republic"
    },
    {
      "code": "RU-AL",
      "name": "Altay, Respublika",
      "type": "Republic"
    },
    {
      "code": "RU-ALT",
      "name": "Altayskiy kray",
      "type": "Administrative Territory"
    },
    {
      "code": "RU-AMU",
      "name": "Amurskaya oblast'",
      "type": "Administrative Region"
    },
    {
      "code": "RU-ARK",
      "name": "Arkhangel'skaya oblast'",
      "type": "Administrative Region"
    },
    {
      "code": "RU-AST",
      "name": "Astrakhanskaya oblast'",
      "type": "Administrative Region"
    },
    {
      "code": "RU-BA",
      "name": "Bashkortostan, Respublika",
      "type": "Republic"
    },
    {
      "code": "RU-BEL",
      "name": "Belgorodskaya oblast'",
      "type": "Administrative Region"
    },
    {
      "code": "RU-BRY",
      "name": "Bryanskaya oblast'",
      "type": "Administrative Region"
    },
    {
      "code": "RU-BU",
      "name": "Buryatiya, Respublika",
      "type": "Republic"
    },
    {
      "code": "RU-CE",
      "name": "Chechenskaya Respublika",
      "type": "Republic"
    },
    {
      "code": "RU-CHE",
      "name": "Chelyabinskaya oblast'",
      "type": "Administrative Region"
    },
    {
      "code": "RU-CHU",
      "name": "Chukotskiy avtonomnyy okrug",
      "type": "Autonomous District"
    },
    {
      "code": "RU-CU",
      "name": "Chuvashskaya Respublika",
      "type": "Republic"
    },
    {
      "code": "RU-DA",
      "name": "Dagestan, Respublika",
      "type": "Republic"
    },
    {
      "code": "RU-IN",
      "name": "Respublika Ingushetiya",
      "type": "Republic"
    },
    {
      "code": "RU-IRK",
      "name": "Irkutiskaya oblast'",
      "type": "Administrative Region"
    },
    {
      "code": "RU-IVA",
      "name": "Ivanovskaya oblast'",
      "type": "Administrative Region"
    },
    {
      "code": "RU-KAM",
      "name": "Kamchatskiy kray",
      "type": "Administrative Territory"
    },
    {
      "code": "RU-KB",
      "name": "Kabardino-Balkarskaya Respublika",
      "type": "Republic"
    },
    {
      "code": "RU-KC",
      "name": "Karachayevo-Cherkesskaya Respublika",
      "type": "Republic"
    },
    {
      "code": "RU-KDA",
      "name": "Krasnodarskiy kray",
      "type": "Administrative Territory"
    },
    {
      "code": "RU-KEM",
      "name": "Kemerovskaya oblast'",
      "type": "Administrative Region"
    },
    {
      "code": "RU-KGD",
      "name": "Kaliningradskaya oblast'",
      "type": "Administrative Region"
    },
    {
      "code": "RU-KGN",
      "name": "Kurganskaya oblast'",
      "type": "Administrative Region"
    },
    {
      "code": "RU-KHA",
      "name": "Khabarovskiy kray",
      "type": "Administrative Territory"
    },
    {
      "code": "RU-KHM",
      "name": "Khanty-Mansiysky avtonomnyy okrug-Yugra",
      "type": "Autonomous District"
    },
    {
      "code": "RU-KIR",
      "name": "Kirovskaya oblast'",
      "type": "Administrative Region"
    },
    {
      "code": "RU-KK",
      "name": "Khakasiya, Respublika",
      "type": "Republic"
    },
    {
      "code": "RU-KL",
      "name": "Kalmykiya, Respublika",
      "type": "Republic"
    },
    {
      "code": "RU-KLU",
      "name": "Kaluzhskaya oblast'",
      "type": "Administrative Region"
    },
    {
      "code": "RU-KO",
      "name": "Komi, Respublika",
      "type": "Republic"
    },
    {
      "code": "RU-KOS",
      "name": "Kostromskaya oblast'",
      "type": "Administrative Region"
    },
    {
      "code": "RU-KR",
      "name": "Kareliya, Respublika",
      "type": "Republic"
    },
    {
      "code": "RU-KRS",
      "name": "Kurskaya oblast'",
      "type": "Administrative Region"
    },
    {
      "code": "RU-KYA",
      "name": "Krasnoyarskiy kray",
      "type": "Administrative Territory"
    },
    {
      "code": "RU-LEN",
      "name": "Leningradskaya oblast'",
      "type": "Administrative Region"
    },
    {
      "code": "RU-LIP",
      "name": "Lipetskaya oblast'",
      "type": "Administrative Region"
    },
    {
      "code": "RU-MAG",
      "name": "Magadanskaya oblast'",
      "type": "Administrative Region"
    },
    {
      "code": "RU-ME",
      "name": "Mariy El, Respublika",
      "type": "Republic"
    },
    {
      "code": "RU-MO",
      "name": "Mordoviya, Respublika",
      "type": "Republic"
    },
    {
      "code": "RU-MOS",
      "name": "Moskovskaya oblast'",
      "type": "Administrative Region"
    },
    {
      "code": "RU-MOW",
      "name": "Moskva",
      "type": "Autonomous City"
    },
    {
      "code": "RU-MUR",
      "name": "Murmanskaya oblast'",
      "type": "Administrative Region"
    },
    {
      "code": "RU-NEN",
      "name": "Nenetskiy avtonomnyy okrug",
      "type": "Autonomous District"
    },
    {
      "code": "RU-NGR",
      "name": "Novgorodskaya oblast'",
      "type": "Administrative Region"
    },
    {
      "code": "RU-NIZ",
      "name": "Nizhegorodskaya oblast'",
      "type": "Administrative Region"
    },
    {
      "code": "RU-NVS",
      "name": "Novosibirskaya oblast'",
      "type": "Administrative Region"
    },
    {
      "code": "RU-OMS",
      "name": "Omskaya oblast'",
      "type": "Administrative Region"
    },
    {
      "code": "RU-ORE",
      "name": "Orenburgskaya oblast'",
      "type": "Administrative Region"
    },
    {
      "code": "RU-ORL",
      "name": "Orlovskaya oblast'",
      "type": "Administrative Region"
    },
    {
      "code": "RU-PER",
      "name": "Permskiy kray",
      "type": "Administrative Territory"
    },
    {
      "code": "RU-PNZ",
      "name": "Penzenskaya oblast'",
      "type": "Administrative Region"
    },
    {
      "code": "RU-PRI",
      "name": "Primorskiy kray",
      "type": "Administrative Territory"
    },
    {
      "code": "RU-PSK",
      "name": "Pskovskaya oblast'",
      "type": "Administrative Region"
    },
    {
      "code": "RU-ROS",
      "name": "Rostovskaya oblast'",
      "type": "Administrative Region"
    },
    {
      "code": "RU-RYA",
      "name": "Ryazanskaya oblast'",
      "type": "Administrative Region"
    },
    {
      "code": "RU-SA",
      "name": "Sakha, Respublika [Yakutiya]",
      "type": "Republic"
    },
    {
      "code": "RU-SAK",
      "name": "Sakhalinskaya oblast'",
      "type": "Administrative Region"
    },
    {
      "code": "RU-SAM",
      "name": "Samaraskaya oblast'",
      "type": "Administrative Region"
    },
    {
      "code": "RU-SAR",
      "name": "Saratovskaya oblast'",
      "type": "Administrative Region"
    },
    {
      "code": "RU-SE",
      "name": "Severnaya Osetiya-Alaniya, Respublika",
      "type": "Republic"
    },
    {
      "code": "RU-SMO",
      "name": "Smolenskaya oblast'",
      "type": "Administrative Region"
    },
    {
      "code": "RU-SPE",
      "name": "Sankt-Peterburg",
      "type": "Autonomous City"
    },
    {
      "code": "RU-STA",
      "name": "Stavropol'skiy kray",
      "type": "Administrative Territory"
    },
    {
      "code": "RU-SVE",
      "name": "Sverdlovskaya oblast'",
      "type": "Administrative Region"
    },
    {
      "code": "RU-TA",
      "name": "Tatarstan, Respublika",
      "type": "Republic"
    },
    {
      "code": "RU-TAM",
      "name": "Tambovskaya oblast'",
      "type": "Administrative Region"
    },
    {
      "code": "RU-TOM",
      "name": "Tomskaya oblast'",
      "type": "Administrative Region"
    },
    {
      "code": "RU-TUL",
      "name": "Tul'skaya oblast'",
      "type": "Administrative Region"
    },
    {
      "code": "RU-TVE",
      "name": "Tverskaya oblast'",
      "type": "Administrative Region"
    },
    {
      "code": "RU-TY",
      "name": "Tyva, Respublika [Tuva]",
      "type": "Republic"
    },
    {
      "code": "RU-TYU",
      "name": "Tyumenskaya oblast'",
      "type": "Administrative Region"
    },
    {
      "code": "RU-UD",
      "name": "Udmurtskaya Respublika",
      "type": "Republic"
    },
    {
      "code": "RU-ULY",
      "name": "Ul'yanovskaya oblast'",
      "type": "Administrative Region"
    },
    {
      "code": "RU-VGG",
      "name": "Volgogradskaya oblast'",
      "type": "Administrative Region"
    },
    {
      "code": "RU-VLA",
      "name": "Vladimirskaya oblast'",
      "type": "Administrative Region"
    },
    {
      "code": "RU-VLG",
      "name": "Vologodskaya oblast'",
      "type": "Administrative Region"
    },
    {
      "code": "RU-VOR",
      "name": "Voronezhskaya oblast'",
      "type": "Administrative Region"
    },
    {
      "code": "RU-YAN",
      "name": "Yamalo-Nenetskiy avtonomnyy okrug",
      "type": "Autonomous District"
    },
    {
      "code": "RU-YAR",
      "name": "Yaroslavskaya oblast'",
      "type": "Administrative Region"
    },
    {
      "code": "RU-YEV",
      "name": "Yevreyskaya avtonomnaya oblast'",
      "type": "Autonomous Region"
    },
    {
      "code": "RU-ZAB",
      "name": "Zabajkal'skij kraj",
      "type": "Administrative Territory"
    },
    {
      "code": "RW-01",
      "name": "Ville de Kigali",
      "type": "Town council"
    },
    {
      "code": "RW-02",
      "name": "Est",
      "type": "Province"
    },
    {
      "code": "RW-03",
      "name": "Nord",
      "type": "Province"
    },
    {
      "code": "RW-04",
      "name": "Ouest",
      "type": "Province"
    },
    {
      "code": "RW-05",
      "name": "Sud",
      "type": "Province"
    },
    {
      "code": "SA-01",
      "name": "Ar Riyāḍ",
      "type": "Province"
    },
    {
      "code": "SA-02",
      "name": "Makkah",
      "type": "Province"
    },
    {
      "code": "SA-03",
      "name": "Al Madīnah",
      "type": "Province"
    },
    {
      "code": "SA-04",
      "name": "Ash Sharqīyah",
      "type": "Province"
    },
    {
      "code": "SA-05",
      "name": "Al Qaşīm",
      "type": "Province"
    },
    {
      "code": "SA-06",
      "name": "Ḥā'il",
      "type": "Province"
    },
    {
      "code": "SA-07",
      "name": "Tabūk",
      "type": "Province"
    },
    {
      "code": "SA-08",
      "name": "Al Ḥudūd ash Shamāliyah",
      "type": "Province"
    },
    {
      "code": "SA-09",
      "name": "Jīzan",
      "type": "Province"
    },
    {
      "code": "SA-10",
      "name": "Najrān",
      "type": "Province"
    },
    {
      "code": "SA-11",
      "name": "Al Bāhah",
      "type": "Province"
    },
    {
      "code": "SA-12",
      "name": "Al Jawf",
      "type": "Province"
    },
    {
      "code": "SA-14",
      "name": "`Asīr",
      "type": "Province"
    },
    {
      "code": "SB-CE",
      "name": "Central",
      "type": "Province"
    },
    {
      "code": "SB-CH",
      "name": "Choiseul",
      "type": "Province"
    },
    {
      "code": "SB-CT",
      "name": "Capital Territory (Honiara)",
      "type": "Capital territory"
    },
    {
      "code": "SB-GU",
      "name": "Guadalcanal",
      "type": "Province"
    },
    {
      "code": "SB-IS",
      "name": "Isabel",
      "type": "Province"
    },
    {
      "code": "SB-MK",
      "name": "Makira",
      "type": "Province"
    },
    {
      "code": "SB-ML",
      "name": "Malaita",
      "type": "Province"
    },
    {
      "code": "SB-RB",
      "name": "Rennell and Bellona",
      "type": "Province"
    },
    {
      "code": "SB-TE",
      "name": "Temotu",
      "type": "Province"
    },
    {
      "code": "SB-WE",
      "name": "Western",
      "type": "Province"
    },
    {
      "code": "SC-01",
      "name": "Anse aux Pins",
      "type": "District"
    },
    {
      "code": "SC-02",
      "name": "Anse Boileau",
      "type": "District"
    },
    {
      "code": "SC-03",
      "name": "Anse Etoile",
      "type": "District"
    },
    {
      "code": "SC-04",
      "name": "Anse Louis",
      "type": "District"
    },
    {
      "code": "SC-05",
      "name": "Anse Royale",
      "type": "District"
    },
    {
      "code": "SC-06",
      "name": "Baie Lazare",
      "type": "District"
    },
    {
      "code": "SC-07",
      "name": "Baie Sainte Anne",
      "type": "District"
    },
    {
      "code": "SC-08",
      "name": "Beau Vallon",
      "type": "District"
    },
    {
      "code": "SC-09",
      "name": "Bel Air",
      "type": "District"
    },
    {
      "code": "SC-10",
      "name": "Bel Ombre",
      "type": "District"
    },
    {
      "code": "SC-11",
      "name": "Cascade",
      "type": "District"
    },
    {
      "code": "SC-12",
      "name": "Glacis",
      "type": "District"
    },
    {
      "code": "SC-13",
      "name": "Grand Anse Mahe",
      "type": "District"
    },
    {
      "code": "SC-14",
      "name": "Grand Anse Praslin",
      "type": "District"
    },
    {
      "code": "SC-15",
      "name": "La Digue",
      "type": "District"
    },
    {
      "code": "SC-16",
      "name": "English River",
      "type": "District"
    },
    {
      "code": "SC-17",
      "name": "Mont Buxton",
      "type": "District"
    },
    {
      "code": "SC-18",
      "name": "Mont Fleuri",
      "type": "District"
    },
    {
      "code": "SC-19",
      "name": "Plaisance",
      "type": "District"
    },
    {
      "code": "SC-20",
      "name": "Pointe Larue",
      "type": "District"
    },
    {
      "code": "SC-21",
      "name": "Port Glaud",
      "type": "District"
    },
    {
      "code": "SC-22",
      "name": "Saint Louis",
      "type": "District"
    },
    {
      "code": "SC-23",
      "name": "Takamaka",
      "type": "District"
    },
    {
      "code": "SC-24",
      "name": "Les Mamelles",
      "type": "District"
    },
    {
      "code": "SC-25",
      "name": "Roche Caiman",
      "type": "District"
    },
    {
      "code": "SD-DC",
      "name": "Zalingei",
      "type": "state"
    },
    {
      "code": "SD-DE",
      "name": "Sharq Dārfūr",
      "type": "state"
    },
    {
      "code": "SD-DN",
      "name": "Shamāl Dārfūr",
      "type": "state"
    },
    {
      "code": "SD-DS",
      "name": "Janūb Dārfūr",
      "type": "state"
    },
    {
      "code": "SD-DW",
      "name": "Gharb Dārfūr",
      "type": "state"
    },
    {
      "code": "SD-GD",
      "name": "Al Qaḑārif",
      "type": "state"
    },
    {
      "code": "SD-GZ",
      "name": "Al Jazīrah",
      "type": "state"
    },
    {
      "code": "SD-KA",
      "name": "Kassalā",
      "type": "state"
    },
    {
      "code": "SD-KH",
      "name": "Al Kharţūm",
      "type": "state"
    },
    {
      "code": "SD-KN",
      "name": "Shamāl Kurdufān",
      "type": "state"
    },
    {
      "code": "SD-KS",
      "name": "Janūb Kurdufān",
      "type": "state"
    },
    {
      "code": "SD-NB",
      "name": "An Nīl al Azraq",
      "type": "state"
    },
    {
      "code": "SD-NO",
      "name": "Ash Shamālīyah",
      "type": "state"
    },
    {
      "code": "SD-NR",
      "name": "An Nīl",
      "type": "state"
    },
    {
      "code": "SD-NW",
      "name": "An Nīl al Abyaḑ",
      "type": "state"
    },
    {
      "code": "SD-RS",
      "name": "Al Baḩr al Aḩmar",
      "type": "state"
    },
    {
      "code": "SD-SI",
      "name": "Sinnār",
      "type": "state"
    },
    {
      "code": "SE-AB",
      "name": "Stockholms län",
      "type": "County"
    },
    {
      "code": "SE-AC",
      "name": "Västerbottens län",
      "type": "County"
    },
    {
      "code": "SE-BD",
      "name": "Norrbottens län",
      "type": "County"
    },
    {
      "code": "SE-C",
      "name": "Uppsala län",
      "type": "County"
    },
    {
      "code": "SE-D",
      "name": "Södermanlands län",
      "type": "County"
    },
    {
      "code": "SE-E",
      "name": "Östergötlands län",
      "type": "County"
    },
    {
      "code": "SE-F",
      "name": "Jönköpings län",
      "type": "County"
    },
    {
      "code": "SE-G",
      "name": "Kronobergs län",
      "type": "County"
    },
    {
      "code": "SE-H",
      "name": "Kalmar län",
      "type": "County"
    },
    {
      "code": "SE-I",
      "name": "Gotlands län",
      "type": "County"
    },
    {
      "code": "SE-K",
      "name": "Blekinge län",
      "type": "County"
    },
    {
      "code": "SE-M",
      "name": "Skåne län",
      "type": "County"
    },
    {
      "code": "SE-N",
      "name": "Hallands län",
      "type": "County"
    },
    {
      "code": "SE-O",
      "name": "Västra Götalands län",
      "type": "County"
    },
    {
      "code": "SE-S",
      "name": "Värmlands län",
      "type": "County"
    },
    {
      "code": "SE-T",
      "name": "Örebro län",
      "type": "County"
    },
    {
      "code": "SE-U",
      "name": "Västmanlands län",
      "type": "County"
    },
    {
      "code": "SE-W",
      "name": "Dalarnas län",
      "type": "County"
    },
    {
      "code": "SE-X",
      "name": "Gävleborgs län",
      "type": "County"
    },
    {
      "code": "SE-Y",
      "name": "Västernorrlands län",
      "type": "County"
    },
    {
      "code": "SE-Z",
      "name": "Jämtlands län",
      "type": "County"
    },
    {
      "code": "SG-01",
      "name": "Central Singapore",
      "type": "district"
    },
    {
      "code": "SG-02",
      "name": "North East",
      "type": "district"
    },
    {
      "code": "SG-03",
      "name": "North West",
      "type": "district"
    },
    {
      "code": "SG-04",
      "name": "South East",
      "type": "district"
    },
    {
      "code": "SG-05",
      "name": "South West",
      "type": "district"
    },
    {
      "code": "SH-AC",
      "name": "Ascension",
      "type": "Geographical Entity"
    },
    {
      "code": "SH-HL",
      "name": "Saint Helena",
      "type": "Geographical Entity"
    },
    {
      "code": "SH-TA",
      "name": "Tristan da Cunha",
      "type": "Geographical Entity"
    },
    {
      "code": "SI-001",
      "name": "Ajdovščina",
      "type": "Municipality"
    },
    {
      "code": "SI-002",
      "name": "Beltinci",
      "type": "Municipality"
    },
    {
      "code": "SI-003",
      "name": "Bled",
      "type": "Municipality"
    },
    {
      "code": "SI-004",
      "name": "Bohinj",
      "type": "Municipality"
    },
    {
      "code": "SI-005",
      "name": "Borovnica",
      "type": "Municipality"
    },
    {
      "code": "SI-006",
      "name": "Bovec",
      "type": "Municipality"
    },
    {
      "code": "SI-007",
      "name": "Brda",
      "type": "Municipality"
    },
    {
      "code": "SI-008",
      "name": "Brezovica",
      "type": "Municipality"
    },
    {
      "code": "SI-009",
      "name": "Brežice",
      "type": "Municipality"
    },
    {
      "code": "SI-010",
      "name": "Tišina",
      "type": "Municipality"
    },
    {
      "code": "SI-011",
      "name": "Celje",
      "type": "Municipality"
    },
    {
      "code": "SI-012",
      "name": "Cerklje na Gorenjskem",
      "type": "Municipality"
    },
    {
      "code": "SI-013",
      "name": "Cerknica",
      "type": "Municipality"
    },
    {
      "code": "SI-014",
      "name": "Cerkno",
      "type": "Municipality"
    },
    {
      "code": "SI-015",
      "name": "Črenšovci",
      "type": "Municipality"
    },
    {
      "code": "SI-016",
      "name": "Črna na Koroškem",
      "type": "Municipality"
    },
    {
      "code": "SI-017",
      "name": "Črnomelj",
      "type": "Municipality"
    },
    {
      "code": "SI-018",
      "name": "Destrnik",
      "type": "Municipality"
    },
    {
      "code": "SI-019",
      "name": "Divača",
      "type": "Municipality"
    },
    {
      "code": "SI-020",
      "name": "Dobrepolje",
      "type": "Municipality"
    },
    {
      "code": "SI-021",
      "name": "Dobrova-Polhov Gradec",
      "type": "Municipality"
    },
    {
      "code": "SI-022",
      "name": "Dol pri Ljubljani",
      "type": "Municipality"
    },
    {
      "code": "SI-023",
      "name": "Domžale",
      "type": "Municipality"
    },
    {
      "code": "SI-024",
      "name": "Dornava",
      "type": "Municipality"
    },
    {
      "code": "SI-025",
      "name": "Dravograd",
      "type": "Municipality"
    },
    {
      "code": "SI-026",
      "name": "Duplek",
      "type": "Municipality"
    },
    {
      "code": "SI-027",
      "name": "Gorenja vas-Poljane",
      "type": "Municipality"
    },
    {
      "code": "SI-028",
      "name": "Gorišnica",
      "type": "Municipality"
    },
    {
      "code": "SI-029",
      "name": "Gornja Radgona",
      "type": "Municipality"
    },
    {
      "code": "SI-030",
      "name": "Gornji Grad",
      "type": "Municipality"
    },
    {
      "code": "SI-031",
      "name": "Gornji Petrovci",
      "type": "Municipality"
    },
    {
      "code": "SI-032",
      "name": "Grosuplje",
      "type": "Municipality"
    },
    {
      "code": "SI-033",
      "name": "Šalovci",
      "type": "Municipality"
    },
    {
      "code": "SI-034",
      "name": "Hrastnik",
      "type": "Municipality"
    },
    {
      "code": "SI-035",
      "name": "Hrpelje-Kozina",
      "type": "Municipality"
    },
    {
      "code": "SI-036",
      "name": "Idrija",
      "type": "Municipality"
    },
    {
      "code": "SI-037",
      "name": "Ig",
      "type": "Municipality"
    },
    {
      "code": "SI-038",
      "name": "Ilirska Bistrica",
      "type": "Municipality"
    },
    {
      "code": "SI-039",
      "name": "Ivančna Gorica",
      "type": "Municipality"
    },
    {
      "code": "SI-040",
      "name": "Izola/Isola",
      "type": "Municipality"
    },
    {
      "code": "SI-041",
      "name": "Jesenice",
      "type": "Municipality"
    },
    {
      "code": "SI-042",
      "name": "Juršinci",
      "type": "Municipality"
    },
    {
      "code": "SI-043",
      "name": "Kamnik",
      "type": "Municipality"
    },
    {
      "code": "SI-044",
      "name": "Kanal",
      "type": "Municipality"
    },
    {
      "code": "SI-045",
      "name": "Kidričevo",
      "type": "Municipality"
    },
    {
      "code": "SI-046",
      "name": "Kobarid",
      "type": "Municipality"
    },
    {
      "code": "SI-047",
      "name": "Kobilje",
      "type": "Municipality"
    },
    {
      "code": "SI-048",
      "name": "Kočevje",
      "type": "Municipality"
    },
    {
      "code": "SI-049",
      "name": "Komen",
      "type": "Municipality"
    },
    {
      "code": "SI-050",
      "name": "Koper/Capodistria",
      "type": "Municipality"
    },
    {
      "code": "SI-051",
      "name": "Kozje",
      "type": "Municipality"
    },
    {
      "code": "SI-052",
      "name": "Kranj",
      "type": "Municipality"
    },
    {
      "code": "SI-053",
      "name": "Kranjska Gora",
      "type": "Municipality"
    },
    {
      "code": "SI-054",
      "name": "Krško",
      "type": "Municipality"
    },
    {
      "code": "SI-055",
      "name": "Kungota",
      "type": "Municipality"
    },
    {
      "code": "SI-056",
      "name": "Kuzma",
      "type": "Municipality"
    },
    {
      "code": "SI-057",
      "name": "Laško",
      "type": "Municipality"
    },
    {
      "code": "SI-058",
      "name": "Lenart",
      "type": "Municipality"
    },
    {
      "code": "SI-059",
      "name": "Lendava/Lendva",
      "type": "Municipality"
    },
    {
      "code": "SI-060",
      "name": "Litija",
      "type": "Municipality"
    },
    {
      "code": "SI-061",
      "name": "Ljubljana",
      "type": "Municipality"
    },
    {
      "code": "SI-062",
      "name": "Ljubno",
      "type": "Municipality"
    },
    {
      "code": "SI-063",
      "name": "Ljutomer",
      "type": "Municipality"
    },
    {
      "code": "SI-064",
      "name": "Logatec",
      "type": "Municipality"
    },
    {
      "code": "SI-065",
      "name": "Loška dolina",
      "type": "Municipality"
    },
    {
      "code": "SI-066",
      "name": "Loški Potok",
      "type": "Municipality"
    },
    {
      "code": "SI-067",
      "name": "Luče",
      "type": "Municipality"
    },
    {
      "code": "SI-068",
      "name": "Lukovica",
      "type": "Municipality"
    },
    {
      "code": "SI-069",
      "name": "Majšperk",
      "type": "Municipality"
    },
    {
      "code": "SI-070",
      "name": "Maribor",
      "type": "Municipality"
    },
    {
      "code": "SI-071",
      "name": "Medvode",
      "type": "Municipality"
    },
    {
      "code": "SI-072",
      "name": "Mengeš",
      "type": "Municipality"
    },
    {
      "code": "SI-073",
      "name": "Metlika",
      "type": "Municipality"
    },
    {
      "code": "SI-074",
      "name": "Mežica",
      "type": "Municipality"
    },
    {
      "code": "SI-075",
      "name": "Miren-Kostanjevica",
      "type": "Municipality"
    },
    {
      "code": "SI-076",
      "name": "Mislinja",
      "type": "Municipality"
    },
    {
      "code": "SI-077",
      "name": "Moravče",
      "type": "Municipality"
    },
    {
      "code": "SI-078",
      "name": "Moravske Toplice",
      "type": "Municipality"
    },
    {
      "code": "SI-079",
      "name": "Mozirje",
      "type": "Municipality"
    },
    {
      "code": "SI-080",
      "name": "Murska Sobota",
      "type": "Municipality"
    },
    {
      "code": "SI-081",
      "name": "Muta",
      "type": "Municipality"
    },
    {
      "code": "SI-082",
      "name": "Naklo",
      "type": "Municipality"
    },
    {
      "code": "SI-083",
      "name": "Nazarje",
      "type": "Municipality"
    },
    {
      "code": "SI-084",
      "name": "Nova Gorica",
      "type": "Municipality"
    },
    {
      "code": "SI-085",
      "name": "Novo mesto",
      "type": "Municipality"
    },
    {
      "code": "SI-086",
      "name": "Odranci",
      "type": "Municipality"
    },
    {
      "code": "SI-087",
      "name": "Ormož",
      "type": "Municipality"
    },
    {
      "code": "SI-088",
      "name": "Osilnica",
      "type": "Municipality"
    },
    {
      "code": "SI-089",
      "name": "Pesnica",
      "type": "Municipality"
    },
    {
      "code": "SI-090",
      "name": "Piran/Pirano",
      "type": "Municipality"
    },
    {
      "code": "SI-091",
      "name": "Pivka",
      "type": "Municipality"
    },
    {
      "code": "SI-092",
      "name": "Podčetrtek",
      "type": "Municipality"
    },
    {
      "code": "SI-093",
      "name": "Podvelka",
      "type": "Municipality"
    },
    {
      "code": "SI-094",
      "name": "Postojna",
      "type": "Municipality"
    },
    {
      "code": "SI-095",
      "name": "Preddvor",
      "type": "Municipality"
    },
    {
      "code": "SI-096",
      "name": "Ptuj",
      "type": "Municipality"
    },
    {
      "code": "SI-097",
      "name": "Puconci",
      "type": "Municipality"
    },
    {
      "code": "SI-098",
      "name": "Rače-Fram",
      "type": "Municipality"
    },
    {
      "code": "SI-099",
      "name": "Radeče",
      "type": "Municipality"
    },
    {
      "code": "SI-100",
      "name": "Radenci",
      "type": "Municipality"
    },
    {
      "code": "SI-101",
      "name": "Radlje ob Dravi",
      "type": "Municipality"
    },
    {
      "code": "SI-102",
      "name": "Radovljica",
      "type": "Municipality"
    },
    {
      "code": "SI-103",
      "name": "Ravne na Koroškem",
      "type": "Municipality"
    },
    {
      "code": "SI-104",
      "name": "Ribnica",
      "type": "Municipality"
    },
    {
      "code": "SI-105",
      "name": "Rogašovci",
      "type": "Municipality"
    },
    {
      "code": "SI-106",
      "name": "Rogaška Slatina",
      "type": "Municipality"
    },
    {
      "code": "SI-107",
      "name": "Rogatec",
      "type": "Municipality"
    },
    {
      "code": "SI-108",
      "name": "Ruše",
      "type": "Municipality"
    },
    {
      "code": "SI-109",
      "name": "Semič",
      "type": "Municipality"
    },
    {
      "code": "SI-110",
      "name": "Sevnica",
      "type": "Municipality"
    },
    {
      "code": "SI-111",
      "name": "Sežana",
      "type": "Municipality"
    },
    {
      "code": "SI-112",
      "name": "Slovenj Gradec",
      "type": "Municipality"
    },
    {
      "code": "SI-113",
      "name": "Slovenska Bistrica",
      "type": "Municipality"
    },
    {
      "code": "SI-114",
      "name": "Slovenske Konjice",
      "type": "Municipality"
    },
    {
      "code": "SI-115",
      "name": "Starče",
      "type": "Municipality"
    },
    {
      "code": "SI-116",
      "name": "Sveti Jurij",
      "type": "Municipality"
    },
    {
      "code": "SI-117",
      "name": "Šenčur",
      "type": "Municipality"
    },
    {
      "code": "SI-118",
      "name": "Šentilj",
      "type": "Municipality"
    },
    {
      "code": "SI-119",
      "name": "Šentjernej",
      "type": "Municipality"
    },
    {
      "code": "SI-120",
      "name": "Šentjur",
      "type": "Municipality"
    },
    {
      "code": "SI-121",
      "name": "Škocjan",
      "type": "Municipality"
    },
    {
      "code": "SI-122",
      "name": "Škofja Loka",
      "type": "Municipality"
    },
    {
      "code": "SI-123",
      "name": "Škofljica",
      "type": "Municipality"
    },
    {
      "code": "SI-124",
      "name": "Šmarje pri Jelšah",
      "type": "Municipality"
    },
    {
      "code": "SI-125",
      "name": "Šmartno ob Paki",
      "type": "Municipality"
    },
    {
      "code": "SI-126",
      "name": "Šoštanj",
      "type": "Municipality"
    },
    {
      "code": "SI-127",
      "name": "Štore",
      "type": "Municipality"
    },
    {
      "code": "SI-128",
      "name": "Tolmin",
      "type": "Municipality"
    },
    {
      "code": "SI-129",
      "name": "Trbovlje",
      "type": "Municipality"
    },
    {
      "code": "SI-130",
      "name": "Trebnje",
      "type": "Municipality"
    },
    {
      "code": "SI-131",
      "name": "Tržič",
      "type": "Municipality"
    },
    {
      "code": "SI-132",
      "name": "Turnišče",
      "type": "Municipality"
    },
    {
      "code": "SI-133",
      "name": "Velenje",
      "type": "Municipality"
    },
    {
      "code": "SI-134",
      "name": "Velike Lašče",
      "type": "Municipality"
    },
    {
      "code": "SI-135",
      "name": "Videm",
      "type": "Municipality"
    },
    {
      "code": "SI-136",
      "name": "Vipava",
      "type": "Municipality"
    },
    {
      "code": "SI-137",
      "name": "Vitanje",
      "type": "Municipality"
    },
    {
      "code": "SI-138",
      "name": "Vodice",
      "type": "Municipality"
    },
    {
      "code": "SI-139",
      "name": "Vojnik",
      "type": "Municipality"
    },
    {
      "code": "SI-140",
      "name": "Vrhnika",
      "type": "Municipality"
    },
    {
      "code": "SI-141",
      "name": "Vuzenica",
      "type": "Municipality"
    },
    {
      "code": "SI-142",
      "name": "Zagorje ob Savi",
      "type": "Municipality"
    },
    {
      "code": "SI-143",
      "name": "Zavrč",
      "type": "Municipality"
    },
    {
      "code": "SI-144",
      "name": "Zreče",
      "type": "Municipality"
    },
    {
      "code": "SI-146",
      "name": "Železniki",
      "type": "Municipality"
    },
    {
      "code": "SI-147",
      "name": "Žiri",
      "type": "Municipality"
    },
    {
      "code": "SI-148",
      "name": "Benedikt",
      "type": "Municipality"
    },
    {
      "code": "SI-149",
      "name": "Bistrica ob Sotli",
      "type": "Municipality"
    },
    {
      "code": "SI-150",
      "name": "Bloke",
      "type": "Municipality"
    },
    {
      "code": "SI-151",
      "name": "Braslovče",
      "type": "Municipality"
    },
    {
      "code": "SI-152",
      "name": "Cankova",
      "type": "Municipality"
    },
    {
      "code": "SI-153",
      "name": "Cerkvenjak",
      "type": "Municipality"
    },
    {
      "code": "SI-154",
      "name": "Dobje",
      "type": "Municipality"
    },
    {
      "code": "SI-155",
      "name": "Dobrna",
      "type": "Municipality"
    },
    {
      "code": "SI-156",
      "name": "Dobrovnik/Dobronak",
      "type": "Municipality"
    },
    {
      "code": "SI-157",
      "name": "Dolenjske Toplice",
      "type": "Municipality"
    },
    {
      "code": "SI-158",
      "name": "Grad",
      "type": "Municipality"
    },
    {
      "code": "SI-159",
      "name": "Hajdina",
      "type": "Municipality"
    },
    {
      "code": "SI-160",
      "name": "Hoče-Slivnica",
      "type": "Municipality"
    },
    {
      "code": "SI-161",
      "name": "Hodoš/Hodos",
      "type": "Municipality"
    },
    {
      "code": "SI-162",
      "name": "Horjul",
      "type": "Municipality"
    },
    {
      "code": "SI-163",
      "name": "Jezersko",
      "type": "Municipality"
    },
    {
      "code": "SI-164",
      "name": "Komenda",
      "type": "Municipality"
    },
    {
      "code": "SI-165",
      "name": "Kostel",
      "type": "Municipality"
    },
    {
      "code": "SI-166",
      "name": "Križevci",
      "type": "Municipality"
    },
    {
      "code": "SI-167",
      "name": "Lovrenc na Pohorju",
      "type": "Municipality"
    },
    {
      "code": "SI-168",
      "name": "Markovci",
      "type": "Municipality"
    },
    {
      "code": "SI-169",
      "name": "Miklavž na Dravskem polju",
      "type": "Municipality"
    },
    {
      "code": "SI-170",
      "name": "Mirna Peč",
      "type": "Municipality"
    },
    {
      "code": "SI-171",
      "name": "Oplotnica",
      "type": "Municipality"
    },
    {
      "code": "SI-172",
      "name": "Podlehnik",
      "type": "Municipality"
    },
    {
      "code": "SI-173",
      "name": "Polzela",
      "type": "Municipality"
    },
    {
      "code": "SI-174",
      "name": "Prebold",
      "type": "Municipality"
    },
    {
      "code": "SI-175",
      "name": "Prevalje",
      "type": "Municipality"
    },
    {
      "code": "SI-176",
      "name": "Razkrižje",
      "type": "Municipality"
    },
    {
      "code": "SI-177",
      "name": "Ribnica na Pohorju",
      "type": "Municipality"
    },
    {
      "code": "SI-178",
      "name": "Selnica ob Dravi",
      "type": "Municipality"
    },
    {
      "code": "SI-179",
      "name": "Sodražica",
      "type": "Municipality"
    },
    {
      "code": "SI-180",
      "name": "Solčava",
      "type": "Municipality"
    },
    {
      "code": "SI-181",
      "name": "Sveta Ana",
      "type": "Municipality"
    },
    {
      "code": "SI-182",
      "name": "Sveta Andraž v Slovenskih Goricah",
      "type": "Municipality"
    },
    {
      "code": "SI-183",
      "name": "Šempeter-Vrtojba",
      "type": "Municipality"
    },
    {
      "code": "SI-184",
      "name": "Tabor",
      "type": "Municipality"
    },
    {
      "code": "SI-185",
      "name": "Trnovska vas",
      "type": "Municipality"
    },
    {
      "code": "SI-186",
      "name": "Trzin",
      "type": "Municipality"
    },
    {
      "code": "SI-187",
      "name": "Velika Polana",
      "type": "Municipality"
    },
    {
      "code": "SI-188",
      "name": "Veržej",
      "type": "Municipality"
    },
    {
      "code": "SI-189",
      "name": "Vransko",
      "type": "Municipality"
    },
    {
      "code": "SI-190",
      "name": "Žalec",
      "type": "Municipality"
    },
    {
      "code": "SI-191",
      "name": "Žetale",
      "type": "Municipality"
    },
    {
      "code": "SI-192",
      "name": "Žirovnica",
      "type": "Municipality"
    },
    {
      "code": "SI-193",
      "name": "Žužemberk",
      "type": "Municipality"
    },
    {
      "code": "SI-194",
      "name": "Šmartno pri Litiji",
      "type": "Municipality"
    },
    {
      "code": "SI-195",
      "name": "Apače",
      "type": "Municipality"
    },
    {
      "code": "SI-196",
      "name": "Cirkulane",
      "type": "Municipality"
    },
    {
      "code": "SI-197",
      "name": "Kosanjevica na Krki",
      "type": "Municipality"
    },
    {
      "code": "SI-198",
      "name": "Makole",
      "type": "Municipality"
    },
    {
      "code": "SI-199",
      "name": "Mokronog-Trebelno",
      "type": "Municipality"
    },
    {
      "code": "SI-200",
      "name": "Poljčane",
      "type": "Municipality"
    },
    {
      "code": "SI-201",
      "name": "Renče-Vogrsko",
      "type": "Municipality"
    },
    {
      "code": "SI-202",
      "name": "Središče ob Dravi",
      "type": "Municipality"
    },
    {
      "code": "SI-203",
      "name": "Straža",
      "type": "Municipality"
    },
    {
      "code": "SI-204",
      "name": "Sveta Trojica v Slovenskih Goricah",
      "type": "Municipality"
    },
    {
      "code": "SI-205",
      "name": "Sveti Tomaž",
      "type": "Municipality"
    },
    {
      "code": "SI-206",
      "name": "Šmarjeske Topliče",
      "type": "Municipality"
    },
    {
      "code": "SI-207",
      "name": "Gorje",
      "type": "Municipality"
    },
    {
      "code": "SI-208",
      "name": "Log-Dragomer",
      "type": "Municipality"
    },
    {
      "code": "SI-209",
      "name": "Rečica ob Savinji",
      "type": "Municipality"
    },
    {
      "code": "SI-210",
      "name": "Sveti Jurij v Slovenskih Goricah",
      "type": "Municipality"
    },
    {
      "code": "SI-211",
      "name": "Šentrupert",
      "type": "Municipality"
    },
    {
      "code": "SK-BC",
      "name": "Banskobystrický kraj",
      "type": "Region"
    },
    {
      "code": "SK-BL",
      "name": "Bratislavský kraj",
      "type": "Region"
    },
    {
      "code": "SK-KI",
      "name": "Košický kraj",
      "type": "Region"
    },
    {
      "code": "SK-NI",
      "name": "Nitriansky kraj",
      "type": "Region"
    },
    {
      "code": "SK-PV",
      "name": "Prešovský kraj",
      "type": "Region"
    },
    {
      "code": "SK-TA",
      "name": "Trnavský kraj",
      "type": "Region"
    },
    {
      "code": "SK-TC",
      "name": "Trenčiansky kraj",
      "type": "Region"
    },
    {
      "code": "SK-ZI",
      "name": "Žilinský kraj",
      "type": "Region"
    },
    {
      "code": "SL-E",
      "name": "Eastern",
      "type": "Province"
    },
    {
      "code": "SL-N",
      "name": "Northern",
      "type": "Province"
    },
    {
      "code": "SL-S",
      "name": "Southern (Sierra Leone)",
      "type": "Province"
    },
    {
      "code": "SL-W",
      "name": "Western Area (Freetown)",
      "type": "Area"
    },
    {
      "code": "SM-01",
      "name": "Acquaviva",
      "type": "Municipalities"
    },
    {
      "code": "SM-02",
      "name": "Chiesanuova",
      "type": "Municipalities"
    },
    {
      "code": "SM-03",
      "name": "Domagnano",
      "type": "Municipalities"
    },
    {
      "code": "SM-04",
      "name": "Faetano",
      "type": "Municipalities"
    },
    {
      "code": "SM-05",
      "name": "Fiorentino",
      "type": "Municipalities"
    },
    {
      "code": "SM-06",
      "name": "Borgo Maggiore",
      "type": "Municipalities"
    },
    {
      "code": "SM-07",
      "name": "San Marino",
      "type": "Municipalities"
    },
    {
      "code": "SM-08",
      "name": "Montegiardino",
      "type": "Municipalities"
    },
    {
      "code": "SM-09",
      "name": "Serravalle",
      "type": "Municipalities"
    },
    {
      "code": "SN-DB",
      "name": "Diourbel",
      "type": "Region"
    },
    {
      "code": "SN-DK",
      "name": "Dakar",
      "type": "Region"
    },
    {
      "code": "SN-FK",
      "name": "Fatick",
      "type": "Region"
    },
    {
      "code": "SN-KA",
      "name": "Kaffrine",
      "type": "Region"
    },
    {
      "code": "SN-KD",
      "name": "Kolda",
      "type": "Region"
    },
    {
      "code": "SN-KE",
      "name": "Kédougou",
      "type": "Region"
    },
    {
      "code": "SN-KL",
      "name": "Kaolack",
      "type": "Region"
    },
    {
      "code": "SN-LG",
      "name": "Louga",
      "type": "Region"
    },
    {
      "code": "SN-MT",
      "name": "Matam",
      "type": "Region"
    },
    {
      "code": "SN-SE",
      "name": "Sédhiou",
      "type": "Region"
    },
    {
      "code": "SN-SL",
      "name": "Saint-Louis",
      "type": "Region"
    },
    {
      "code": "SN-TC",
      "name": "Tambacounda",
      "type": "Region"
    },
    {
      "code": "SN-TH",
      "name": "Thiès",
      "type": "Region"
    },
    {
      "code": "SN-ZG",
      "name": "Ziguinchor",
      "type": "Region"
    },
    {
      "code": "SO-AW",
      "name": "Awdal",
      "type": "Region"
    },
    {
      "code": "SO-BK",
      "name": "Bakool",
      "type": "Region"
    },
    {
      "code": "SO-BN",
      "name": "Banaadir",
      "type": "Region"
    },
    {
      "code": "SO-BR",
      "name": "Bari",
      "type": "Region"
    },
    {
      "code": "SO-BY",
      "name": "Bay",
      "type": "Region"
    },
    {
      "code": "SO-GA",
      "name": "Galguduud",
      "type": "Region"
    },
    {
      "code": "SO-GE",
      "name": "Gedo",
      "type": "Region"
    },
    {
      "code": "SO-HI",
      "name": "Hiirsan",
      "type": "Region"
    },
    {
      "code": "SO-JD",
      "name": "Jubbada Dhexe",
      "type": "Region"
    },
    {
      "code": "SO-JH",
      "name": "Jubbada Hoose",
      "type": "Region"
    },
    {
      "code": "SO-MU",
      "name": "Mudug",
      "type": "Region"
    },
    {
      "code": "SO-NU",
      "name": "Nugaal",
      "type": "Region"
    },
    {
      "code": "SO-SA",
      "name": "Saneag",
      "type": "Region"
    },
    {
      "code": "SO-SD",
      "name": "Shabeellaha Dhexe",
      "type": "Region"
    },
    {
      "code": "SO-SH",
      "name": "Shabeellaha Hoose",
      "type": "Region"
    },
    {
      "code": "SO-SO",
      "name": "Sool",
      "type": "Region"
    },
    {
      "code": "SO-TO",
      "name": "Togdheer",
      "type": "Region"
    },
    {
      "code": "SO-WO",
      "name": "Woqooyi Galbeed",
      "type": "Region"
    },
    {
      "code": "SR-BR",
      "name": "Brokopondo",
      "type": "District"
    },
    {
      "code": "SR-CM",
      "name": "Commewijne",
      "type": "District"
    },
    {
      "code": "SR-CR",
      "name": "Coronie",
      "type": "District"
    },
    {
      "code": "SR-MA",
      "name": "Marowijne",
      "type": "District"
    },
    {
      "code": "SR-NI",
      "name": "Nickerie",
      "type": "District"
    },
    {
      "code": "SR-PM",
      "name": "Paramaribo",
      "type": "District"
    },
    {
      "code": "SR-PR",
      "name": "Para",
      "type": "District"
    },
    {
      "code": "SR-SA",
      "name": "Saramacca",
      "type": "District"
    },
    {
      "code": "SR-SI",
      "name": "Sipaliwini",
      "type": "District"
    },
    {
      "code": "SR-WA",
      "name": "Wanica",
      "type": "District"
    },
    {
      "code": "SS-BN",
      "name": "Northern Bahr el-Ghazal",
      "type": "state"
    },
    {
      "code": "SS-BW",
      "name": "Western Bahr el-Ghazal",
      "type": "state"
    },
    {
      "code": "SS-EC",
      "name": "Central Equatoria",
      "type": "state"
    },
    {
      "code": "SS-EE8",
      "name": "Eastern Equatoria",
      "type": "state"
    },
    {
      "code": "SS-EW",
      "name": "Western Equatoria",
      "type": "state"
    },
    {
      "code": "SS-JG",
      "name": "Jonglei",
      "type": "state"
    },
    {
      "code": "SS-LK",
      "name": "Lakes",
      "type": "state"
    },
    {
      "code": "SS-NU",
      "name": "Upper Nile",
      "type": "state"
    },
    {
      "code": "SS-UY",
      "name": "Unity",
      "type": "state"
    },
    {
      "code": "SS-WR",
      "name": "Warrap",
      "type": "state"
    },
    {
      "code": "ST-P",
      "name": "Príncipe",
      "type": "Municipality"
    },
    {
      "code": "ST-S",
      "name": "São Tomé",
      "type": "Municipality"
    },
    {
      "code": "SV-AH",
      "name": "Ahuachapán",
      "type": "Department"
    },
    {
      "code": "SV-CA",
      "name": "Cabañas",
      "type": "Department"
    },
    {
      "code": "SV-CH",
      "name": "Chalatenango",
      "type": "Department"
    },
    {
      "code": "SV-CU",
      "name": "Cuscatlán",
      "type": "Department"
    },
    {
      "code": "SV-LI",
      "name": "La Libertad",
      "type": "Department"
    },
    {
      "code": "SV-MO",
      "name": "Morazán",
      "type": "Department"
    },
    {
      "code": "SV-PA",
      "name": "La Paz",
      "type": "Department"
    },
    {
      "code": "SV-SA",
      "name": "Santa Ana",
      "type": "Department"
    },
    {
      "code": "SV-SM",
      "name": "San Miguel",
      "type": "Department"
    },
    {
      "code": "SV-SO",
      "name": "Sonsonate",
      "type": "Department"
    },
    {
      "code": "SV-SS",
      "name": "San Salvador",
      "type": "Department"
    },
    {
      "code": "SV-SV",
      "name": "San Vicente",
      "type": "Department"
    },
    {
      "code": "SV-UN",
      "name": "La Unión",
      "type": "Department"
    },
    {
      "code": "SV-US",
      "name": "Usulután",
      "type": "Department"
    },
    {
      "code": "SY-DI",
      "name": "Dimashq",
      "type": "Governorate"
    },
    {
      "code": "SY-DR",
      "name": "Dar'a",
      "type": "Governorate"
    },
    {
      "code": "SY-DY",
      "name": "Dayr az Zawr",
      "type": "Governorate"
    },
    {
      "code": "SY-HA",
      "name": "Al Hasakah",
      "type": "Governorate"
    },
    {
      "code": "SY-HI",
      "name": "Homs",
      "type": "Governorate"
    },
    {
      "code": "SY-HL",
      "name": "Halab",
      "type": "Governorate"
    },
    {
      "code": "SY-HM",
      "name": "Hamah",
      "type": "Governorate"
    },
    {
      "code": "SY-ID",
      "name": "Idlib",
      "type": "Governorate"
    },
    {
      "code": "SY-LA",
      "name": "Al Ladhiqiyah",
      "type": "Governorate"
    },
    {
      "code": "SY-QU",
      "name": "Al Qunaytirah",
      "type": "Governorate"
    },
    {
      "code": "SY-RA",
      "name": "Ar Raqqah",
      "type": "Governorate"
    },
    {
      "code": "SY-RD",
      "name": "Rif Dimashq",
      "type": "Governorate"
    },
    {
      "code": "SY-SU",
      "name": "As Suwayda'",
      "type": "Governorate"
    },
    {
      "code": "SY-TA",
      "name": "Tartus",
      "type": "Governorate"
    },
    {
      "code": "SZ-HH",
      "name": "Hhohho",
      "type": "District"
    },
    {
      "code": "SZ-LU",
      "name": "Lubombo",
      "type": "District"
    },
    {
      "code": "SZ-MA",
      "name": "Manzini",
      "type": "District"
    },
    {
      "code": "SZ-SH",
      "name": "Shiselweni",
      "type": "District"
    },
    {
      "code": "TD-BA",
      "name": "Al Baṭḩah",
      "type": "Region"
    },
    {
      "code": "TD-BG",
      "name": "Baḩr al Ghazāl",
      "type": "Region"
    },
    {
      "code": "TD-BO",
      "name": "Būrkū",
      "type": "Region"
    },
    {
      "code": "TD-CB",
      "name": "Shārī Bāqirmī",
      "type": "Region"
    },
    {
      "code": "TD-EN",
      "name": "Innīdī",
      "type": "Region"
    },
    {
      "code": "TD-GR",
      "name": "Qīrā",
      "type": "Region"
    },
    {
      "code": "TD-HL",
      "name": "Ḥajjar Lamīs",
      "type": "Region"
    },
    {
      "code": "TD-KA",
      "name": "Kānim",
      "type": "Region"
    },
    {
      "code": "TD-LC",
      "name": "Al Buḩayrah",
      "type": "Region"
    },
    {
      "code": "TD-LO",
      "name": "Lūqūn al Gharbī",
      "type": "Region"
    },
    {
      "code": "TD-LR",
      "name": "Lūqūn ash Sharqī",
      "type": "Region"
    },
    {
      "code": "TD-MA",
      "name": "Māndūl",
      "type": "Region"
    },
    {
      "code": "TD-MC",
      "name": "Shārī al Awsaṭ",
      "type": "Region"
    },
    {
      "code": "TD-ME",
      "name": "Māyū Kībbī ash Sharqī",
      "type": "Region"
    },
    {
      "code": "TD-MO",
      "name": "Māyū Kībbī al Gharbī",
      "type": "Region"
    },
    {
      "code": "TD-ND",
      "name": "Madīnat Injamīnā",
      "type": "Region"
    },
    {
      "code": "TD-OD",
      "name": "Waddāy",
      "type": "Region"
    },
    {
      "code": "TD-SA",
      "name": "Salāmāt",
      "type": "Region"
    },
    {
      "code": "TD-SI",
      "name": "Sīlā",
      "type": "Region"
    },
    {
      "code": "TD-TA",
      "name": "Tānjilī",
      "type": "Region"
    },
    {
      "code": "TD-TI",
      "name": "Tibastī",
      "type": "Region"
    },
    {
      "code": "TD-WF",
      "name": "Wādī Fīrā",
      "type": "Region"
    },
    {
      "code": "TG-C",
      "name": "Région du Centre",
      "type": "Region"
    },
    {
      "code": "TG-K",
      "name": "Région de la Kara",
      "type": "Region"
    },
    {
      "code": "TG-M",
      "name": "Région Maritime",
      "type": "Region"
    },
    {
      "code": "TG-P",
      "name": "Région des Plateaux",
      "type": "Region"
    },
    {
      "code": "TG-S",
      "name": "Région des Savannes",
      "type": "Region"
    },
    {
      "code": "TH-10",
      "name": "Krung Thep Maha Nakhon Bangkok",
      "type": "Municipality"
    },
    {
      "code": "TH-11",
      "name": "Samut Prakan",
      "type": "Province"
    },
    {
      "code": "TH-12",
      "name": "Nonthaburi",
      "type": "Province"
    },
    {
      "code": "TH-13",
      "name": "Pathum Thani",
      "type": "Province"
    },
    {
      "code": "TH-14",
      "name": "Phra Nakhon Si Ayutthaya",
      "type": "Province"
    },
    {
      "code": "TH-15",
      "name": "Ang Thong",
      "type": "Province"
    },
    {
      "code": "TH-16",
      "name": "Lop Buri",
      "type": "Province"
    },
    {
      "code": "TH-17",
      "name": "Sing Buri",
      "type": "Province"
    },
    {
      "code": "TH-18",
      "name": "Chai Nat",
      "type": "Province"
    },
    {
      "code": "TH-19",
      "name": "Saraburi",
      "type": "Province"
    },
    {
      "code": "TH-20",
      "name": "Chon Buri",
      "type": "Province"
    },
    {
      "code": "TH-21",
      "name": "Rayong",
      "type": "Province"
    },
    {
      "code": "TH-22",
      "name": "Chanthaburi",
      "type": "Province"
    },
    {
      "code": "TH-23",
      "name": "Trat",
      "type": "Province"
    },
    {
      "code": "TH-24",
      "name": "Chachoengsao",
      "type": "Province"
    },
    {
      "code": "TH-25",
      "name": "Prachin Buri",
      "type": "Province"
    },
    {
      "code": "TH-26",
      "name": "Nakhon Nayok",
      "type": "Province"
    },
    {
      "code": "TH-27",
      "name": "Sa Kaeo",
      "type": "Province"
    },
    {
      "code": "TH-30",
      "name": "Nakhon Ratchasima",
      "type": "Province"
    },
    {
      "code": "TH-31",
      "name": "Buri Ram",
      "type": "Province"
    },
    {
      "code": "TH-32",
      "name": "Surin",
      "type": "Province"
    },
    {
      "code": "TH-33",
      "name": "Si Sa Ket",
      "type": "Province"
    },
    {
      "code": "TH-34",
      "name": "Ubon Ratchathani",
      "type": "Province"
    },
    {
      "code": "TH-35",
      "name": "Yasothon",
      "type": "Province"
    },
    {
      "code": "TH-36",
      "name": "Chaiyaphum",
      "type": "Province"
    },
    {
      "code": "TH-37",
      "name": "Amnat Charoen",
      "type": "Province"
    },
    {
      "code": "TH-39",
      "name": "Nong Bua Lam Phu",
      "type": "Province"
    },
    {
      "code": "TH-40",
      "name": "Khon Kaen",
      "type": "Province"
    },
    {
      "code": "TH-41",
      "name": "Udon Thani",
      "type": "Province"
    },
    {
      "code": "TH-42",
      "name": "Loei",
      "type": "Province"
    },
    {
      "code": "TH-43",
      "name": "Nong Khai",
      "type": "Province"
    },
    {
      "code": "TH-44",
      "name": "Maha Sarakham",
      "type": "Province"
    },
    {
      "code": "TH-45",
      "name": "Roi Et",
      "type": "Province"
    },
    {
      "code": "TH-46",
      "name": "Kalasin",
      "type": "Province"
    },
    {
      "code": "TH-47",
      "name": "Sakon Nakhon",
      "type": "Province"
    },
    {
      "code": "TH-48",
      "name": "Nakhon Phanom",
      "type": "Province"
    },
    {
      "code": "TH-49",
      "name": "Mukdahan",
      "type": "Province"
    },
    {
      "code": "TH-50",
      "name": "Chiang Mai",
      "type": "Province"
    },
    {
      "code": "TH-51",
      "name": "Lamphun",
      "type": "Province"
    },
    {
      "code": "TH-52",
      "name": "Lampang",
      "type": "Province"
    },
    {
      "code": "TH-53",
      "name": "Uttaradit",
      "type": "Province"
    },
    {
      "code": "TH-54",
      "name": "Phrae",
      "type": "Province"
    },
    {
      "code": "TH-55",
      "name": "Nan",
      "type": "Province"
    },
    {
      "code": "TH-56",
      "name": "Phayao",
      "type": "Province"
    },
    {
      "code": "TH-57",
      "name": "Chiang Rai",
      "type": "Province"
    },
    {
      "code": "TH-58",
      "name": "Mae Hong Son",
      "type": "Province"
    },
    {
      "code": "TH-60",
      "name": "Nakhon Sawan",
      "type": "Province"
    },
    {
      "code": "TH-61",
      "name": "Uthai Thani",
      "type": "Province"
    },
    {
      "code": "TH-62",
      "name": "Kamphaeng Phet",
      "type": "Province"
    },
    {
      "code": "TH-63",
      "name": "Tak",
      "type": "Province"
    },
    {
      "code": "TH-64",
      "name": "Sukhothai",
      "type": "Province"
    },
    {
      "code": "TH-65",
      "name": "Phitsanulok",
      "type": "Province"
    },
    {
      "code": "TH-66",
      "name": "Phichit",
      "type": "Province"
    },
    {
      "code": "TH-67",
      "name": "Phetchabun",
      "type": "Province"
    },
    {
      "code": "TH-70",
      "name": "Ratchaburi",
      "type": "Province"
    },
    {
      "code": "TH-71",
      "name": "Kanchanaburi",
      "type": "Province"
    },
    {
      "code": "TH-72",
      "name": "Suphan Buri",
      "type": "Province"
    },
    {
      "code": "TH-73",
      "name": "Nakhon Pathom",
      "type": "Province"
    },
    {
      "code": "TH-74",
      "name": "Samut Sakhon",
      "type": "Province"
    },
    {
      "code": "TH-75",
      "name": "Samut Songkhram",
      "type": "Province"
    },
    {
      "code": "TH-76",
      "name": "Phetchaburi",
      "type": "Province"
    },
    {
      "code": "TH-77",
      "name": "Prachuap Khiri Khan",
      "type": "Province"
    },
    {
      "code": "TH-80",
      "name": "Nakhon Si Thammarat",
      "type": "Province"
    },
    {
      "code": "TH-81",
      "name": "Krabi",
      "type": "Province"
    },
    {
      "code": "TH-82",
      "name": "Phangnga",
      "type": "Province"
    },
    {
      "code": "TH-83",
      "name": "Phuket",
      "type": "Province"
    },
    {
      "code": "TH-84",
      "name": "Surat Thani",
      "type": "Province"
    },
    {
      "code": "TH-85",
      "name": "Ranong",
      "type": "Province"
    },
    {
      "code": "TH-86",
      "name": "Chumphon",
      "type": "Province"
    },
    {
      "code": "TH-90",
      "name": "Songkhla",
      "type": "Province"
    },
    {
      "code": "TH-91",
      "name": "Satun",
      "type": "Province"
    },
    {
      "code": "TH-92",
      "name": "Trang",
      "type": "Province"
    },
    {
      "code": "TH-93",
      "name": "Phatthalung",
      "type": "Province"
    },
    {
      "code": "TH-94",
      "name": "Pattani",
      "type": "Province"
    },
    {
      "code": "TH-95",
      "name": "Yala",
      "type": "Province"
    },
    {
      "code": "TH-96",
      "name": "Narathiwat",
      "type": "Province"
    },
    {
      "code": "TH-S",
      "name": "Phatthaya",
      "type": "Province"
    },
    {
      "code": "TJ-GB",
      "name": "Gorno-Badakhshan",
      "type": "Autonomous region"
    },
    {
      "code": "TJ-KT",
      "name": "Khatlon",
      "type": "Region"
    },
    {
      "code": "TJ-SU",
      "name": "Sughd",
      "type": "Region"
    },
    {
      "code": "TL-AL",
      "name": "Aileu",
      "type": "District"
    },
    {
      "code": "TL-AN",
      "name": "Ainaro",
      "type": "District"
    },
    {
      "code": "TL-BA",
      "name": "Baucau",
      "type": "District"
    },
    {
      "code": "TL-BO",
      "name": "Bobonaro",
      "type": "District"
    },
    {
      "code": "TL-CO",
      "name": "Cova Lima",
      "type": "District"
    },
    {
      "code": "TL-DI",
      "name": "Díli",
      "type": "District"
    },
    {
      "code": "TL-ER",
      "name": "Ermera",
      "type": "District"
    },
    {
      "code": "TL-LA",
      "name": "Lautem",
      "type": "District"
    },
    {
      "code": "TL-LI",
      "name": "Liquiça",
      "type": "District"
    },
    {
      "code": "TL-MF",
      "name": "Manufahi",
      "type": "District"
    },
    {
      "code": "TL-MT",
      "name": "Manatuto",
      "type": "District"
    },
    {
      "code": "TL-OE",
      "name": "Oecussi",
      "type": "District"
    },
    {
      "code": "TL-VI",
      "name": "Viqueque",
      "type": "District"
    },
    {
      "code": "TM-A",
      "name": "Ahal",
      "type": "Region"
    },
    {
      "code": "TM-B",
      "name": "Balkan",
      "type": "Region"
    },
    {
      "code": "TM-D",
      "name": "Daşoguz",
      "type": "Region"
    },
    {
      "code": "TM-L",
      "name": "Lebap",
      "type": "Region"
    },
    {
      "code": "TM-M",
      "name": "Mary",
      "type": "Region"
    },
    {
      "code": "TM-S",
      "name": "Aşgabat",
      "type": "City"
    },
    {
      "code": "TN-11",
      "name": "Tunis",
      "type": "Governorate"
    },
    {
      "code": "TN-12",
      "name": "Ariana",
      "type": "Governorate"
    },
    {
      "code": "TN-13",
      "name": "Ben Arous",
      "type": "Governorate"
    },
    {
      "code": "TN-14",
      "name": "La Manouba",
      "type": "Governorate"
    },
    {
      "code": "TN-21",
      "name": "Nabeul",
      "type": "Governorate"
    },
    {
      "code": "TN-22",
      "name": "Zaghouan",
      "type": "Governorate"
    },
    {
      "code": "TN-23",
      "name": "Bizerte",
      "type": "Governorate"
    },
    {
      "code": "TN-31",
      "name": "Béja",
      "type": "Governorate"
    },
    {
      "code": "TN-32",
      "name": "Jendouba",
      "type": "Governorate"
    },
    {
      "code": "TN-33",
      "name": "Le Kef",
      "type": "Governorate"
    },
    {
      "code": "TN-34",
      "name": "Siliana",
      "type": "Governorate"
    },
    {
      "code": "TN-41",
      "name": "Kairouan",
      "type": "Governorate"
    },
    {
      "code": "TN-42",
      "name": "Kasserine",
      "type": "Governorate"
    },
    {
      "code": "TN-43",
      "name": "Sidi Bouzid",
      "type": "Governorate"
    },
    {
      "code": "TN-51",
      "name": "Sousse",
      "type": "Governorate"
    },
    {
      "code": "TN-52",
      "name": "Monastir",
      "type": "Governorate"
    },
    {
      "code": "TN-53",
      "name": "Mahdia",
      "type": "Governorate"
    },
    {
      "code": "TN-61",
      "name": "Sfax",
      "type": "Governorate"
    },
    {
      "code": "TN-71",
      "name": "Gafsa",
      "type": "Governorate"
    },
    {
      "code": "TN-72",
      "name": "Tozeur",
      "type": "Governorate"
    },
    {
      "code": "TN-73",
      "name": "Kebili",
      "type": "Governorate"
    },
    {
      "code": "TN-81",
      "name": "Gabès",
      "type": "Governorate"
    },
    {
      "code": "TN-82",
      "name": "Medenine",
      "type": "Governorate"
    },
    {
      "code": "TN-83",
      "name": "Tataouine",
      "type": "Governorate"
    },
    {
      "code": "TO-01",
      "name": "'Eua",
      "type": "Division"
    },
    {
      "code": "TO-02",
      "name": "Ha'apai",
      "type": "Division"
    },
    {
      "code": "TO-03",
      "name": "Niuas",
      "type": "Division"
    },
    {
      "code": "TO-04",
      "name": "Tongatapu",
      "type": "Division"
    },
    {
      "code": "TO-05",
      "name": "Vava'u",
      "type": "Division"
    },
    {
      "code": "TR-01",
      "name": "Adana",
      "type": "Province"
    },
    {
      "code": "TR-02",
      "name": "Adıyaman",
      "type": "Province"
    },
    {
      "code": "TR-03",
      "name": "Afyonkarahisar",
      "type": "Province"
    },
    {
      "code": "TR-04",
      "name": "Ağrı",
      "type": "Province"
    },
    {
      "code": "TR-05",
      "name": "Amasya",
      "type": "Province"
    },
    {
      "code": "TR-06",
      "name": "Ankara",
      "type": "Province"
    },
    {
      "code": "TR-07",
      "name": "Antalya",
      "type": "Province"
    },
    {
      "code": "TR-08",
      "name": "Artvin",
      "type": "Province"
    },
    {
      "code": "TR-09",
      "name": "Aydın",
      "type": "Province"
    },
    {
      "code": "TR-10",
      "name": "Balıkesir",
      "type": "Province"
    },
    {
      "code": "TR-11",
      "name": "Bilecik",
      "type": "Province"
    },
    {
      "code": "TR-12",
      "name": "Bingöl",
      "type": "Province"
    },
    {
      "code": "TR-13",
      "name": "Bitlis",
      "type": "Province"
    },
    {
      "code": "TR-14",
      "name": "Bolu",
      "type": "Province"
    },
    {
      "code": "TR-15",
      "name": "Burdur",
      "type": "Province"
    },
    {
      "code": "TR-16",
      "name": "Bursa",
      "type": "Province"
    },
    {
      "code": "TR-17",
      "name": "Çanakkale",
      "type": "Province"
    },
    {
      "code": "TR-18",
      "name": "Çankırı",
      "type": "Province"
    },
    {
      "code": "TR-19",
      "name": "Çorum",
      "type": "Province"
    },
    {
      "code": "TR-20",
      "name": "Denizli",
      "type": "Province"
    },
    {
      "code": "TR-21",
      "name": "Diyarbakır",
      "type": "Province"
    },
    {
      "code": "TR-22",
      "name": "Edirne",
      "type": "Province"
    },
    {
      "code": "TR-23",
      "name": "Elazığ",
      "type": "Province"
    },
    {
      "code": "TR-24",
      "name": "Erzincan",
      "type": "Province"
    },
    {
      "code": "TR-25",
      "name": "Erzurum",
      "type": "Province"
    },
    {
      "code": "TR-26",
      "name": "Eskişehir",
      "type": "Province"
    },
    {
      "code": "TR-27",
      "name": "Gaziantep",
      "type": "Province"
    },
    {
      "code": "TR-28",
      "name": "Giresun",
      "type": "Province"
    },
    {
      "code": "TR-29",
      "name": "Gümüşhane",
      "type": "Province"
    },
    {
      "code": "TR-30",
      "name": "Hakkâri",
      "type": "Province"
    },
    {
      "code": "TR-31",
      "name": "Hatay",
      "type": "Province"
    },
    {
      "code": "TR-32",
      "name": "Isparta",
      "type": "Province"
    },
    {
      "code": "TR-33",
      "name": "Mersin",
      "type": "Province"
    },
    {
      "code": "TR-34",
      "name": "İstanbul",
      "type": "Province"
    },
    {
      "code": "TR-35",
      "name": "İzmir",
      "type": "Province"
    },
    {
      "code": "TR-36",
      "name": "Kars",
      "type": "Province"
    },
    {
      "code": "TR-37",
      "name": "Kastamonu",
      "type": "Province"
    },
    {
      "code": "TR-38",
      "name": "Kayseri",
      "type": "Province"
    },
    {
      "code": "TR-39",
      "name": "Kırklareli",
      "type": "Province"
    },
    {
      "code": "TR-40",
      "name": "Kırşehir",
      "type": "Province"
    },
    {
      "code": "TR-41",
      "name": "Kocaeli",
      "type": "Province"
    },
    {
      "code": "TR-42",
      "name": "Konya",
      "type": "Province"
    },
    {
      "code": "TR-43",
      "name": "Kütahya",
      "type": "Province"
    },
    {
      "code": "TR-44",
      "name": "Malatya",
      "type": "Province"
    },
    {
      "code": "TR-45",
      "name": "Manisa",
      "type": "Province"
    },
    {
      "code": "TR-46",
      "name": "Kahramanmaraş",
      "type": "Province"
    },
    {
      "code": "TR-47",
      "name": "Mardin",
      "type": "Province"
    },
    {
      "code": "TR-48",
      "name": "Muğla",
      "type": "Province"
    },
    {
      "code": "TR-49",
      "name": "Muş",
      "type": "Province"
    },
    {
      "code": "TR-50",
      "name": "Nevşehir",
      "type": "Province"
    },
    {
      "code": "TR-51",
      "name": "Niğde",
      "type": "Province"
    },
    {
      "code": "TR-52",
      "name": "Ordu",
      "type": "Province"
    },
    {
      "code": "TR-53",
      "name": "Rize",
      "type": "Province"
    },
    {
      "code": "TR-54",
      "name": "Sakarya",
      "type": "Province"
    },
    {
      "code": "TR-55",
      "name": "Samsun",
      "type": "Province"
    },
    {
      "code": "TR-56",
      "name": "Siirt",
      "type": "Province"
    },
    {
      "code": "TR-57",
      "name": "Sinop",
      "type": "Province"
    },
    {
      "code": "TR-58",
      "name": "Sivas",
      "type": "Province"
    },
    {
      "code": "TR-59",
      "name": "Tekirdağ",
      "type": "Province"
    },
    {
      "code": "TR-60",
      "name": "Tokat",
      "type": "Province"
    },
    {
      "code": "TR-61",
      "name": "Trabzon",
      "type": "Province"
    },
    {
      "code": "TR-62",
      "name": "Tunceli",
      "type": "Province"
    },
    {
      "code": "TR-63",
      "name": "Şanlıurfa",
      "type": "Province"
    },
    {
      "code": "TR-64",
      "name": "Uşak",
      "type": "Province"
    },
    {
      "code": "TR-65",
      "name": "Van",
      "type": "Province"
    },
    {
      "code": "TR-66",
      "name": "Yozgat",
      "type": "Province"
    },
    {
      "code": "TR-67",
      "name": "Zonguldak",
      "type": "Province"
    },
    {
      "code": "TR-68",
      "name": "Aksaray",
      "type": "Province"
    },
    {
      "code": "TR-69",
      "name": "Bayburt",
      "type": "Province"
    },
    {
      "code": "TR-70",
      "name": "Karaman",
      "type": "Province"
    },
    {
      "code": "TR-71",
      "name": "Kırıkkale",
      "type": "Province"
    },
    {
      "code": "TR-72",
      "name": "Batman",
      "type": "Province"
    },
    {
      "code": "TR-73",
      "name": "Şırnak",
      "type": "Province"
    },
    {
      "code": "TR-74",
      "name": "Bartın",
      "type": "Province"
    },
    {
      "code": "TR-75",
      "name": "Ardahan",
      "type": "Province"
    },
    {
      "code": "TR-76",
      "name": "Iğdır",
      "type": "Province"
    },
    {
      "code": "TR-77",
      "name": "Yalova",
      "type": "Province"
    },
    {
      "code": "TR-78",
      "name": "Karabük",
      "type": "Province"
    },
    {
      "code": "TR-79",
      "name": "Kilis",
      "type": "Province"
    },
    {
      "code": "TR-80",
      "name": "Osmaniye",
      "type": "Province"
    },
    {
      "code": "TR-81",
      "name": "Düzce",
      "type": "Province"
    },
    {
      "code": "TT-ARI",
      "name": "Arima",
      "type": "Borough"
    },
    {
      "code": "TT-CHA",
      "name": "Chaguanas",
      "type": "Borough"
    },
    {
      "code": "TT-CTT",
      "name": "Couva-Tabaquite-Talparo",
      "type": "Region"
    },
    {
      "code": "TT-DMN",
      "name": "Diego Martin",
      "type": "Region"
    },
    {
      "code": "TT-ETO",
      "name": "Eastern Tobago",
      "type": "Region"
    },
    {
      "code": "TT-PED",
      "name": "Penal-Debe",
      "type": "Region"
    },
    {
      "code": "TT-POS",
      "name": "Port of Spain",
      "type": "City"
    },
    {
      "code": "TT-PRT",
      "name": "Princes Town",
      "type": "Region"
    },
    {
      "code": "TT-PTF",
      "name": "Point Fortin",
      "type": "Borough"
    },
    {
      "code": "TT-RCM",
      "name": "Rio Claro-Mayaro",
      "type": "Region"
    },
    {
      "code": "TT-SFO",
      "name": "San Fernando",
      "type": "City"
    },
    {
      "code": "TT-SGE",
      "name": "Sangre Grande",
      "type": "Region"
    },
    {
      "code": "TT-SIP",
      "name": "Siparia",
      "type": "Region"
    },
    {
      "code": "TT-SJL",
      "name": "San Juan-Laventille",
      "type": "Region"
    },
    {
      "code": "TT-TUP",
      "name": "Tunapuna-Piarco",
      "type": "Region"
    },
    {
      "code": "TT-WTO",
      "name": "Western Tobago",
      "type": "Region"
    },
    {
      "code": "TV-FUN",
      "name": "Funafuti",
      "type": "Town council"
    },
    {
      "code": "TV-NIT",
      "name": "Niutao",
      "type": "Island council"
    },
    {
      "code": "TV-NKF",
      "name": "Nukufetau",
      "type": "Island council"
    },
    {
      "code": "TV-NKL",
      "name": "Nukulaelae",
      "type": "Island council"
    },
    {
      "code": "TV-NMA",
      "name": "Nanumea",
      "type": "Island council"
    },
    {
      "code": "TV-NMG",
      "name": "Nanumanga",
      "type": "Island council"
    },
    {
      "code": "TV-NUI",
      "name": "Nui",
      "type": "Island council"
    },
    {
      "code": "TV-VAI",
      "name": "Vaitupu",
      "type": "Island council"
    },
    {
      "code": "TW-CHA",
      "name": "Changhua",
      "type": "District"
    },
    {
      "code": "TW-CYI",
      "name": "Chiay City",
      "type": "Municipality"
    },
    {
      "code": "TW-CYQ",
      "name": "Chiayi",
      "type": "District"
    },
    {
      "code": "TW-HSQ",
      "name": "Hsinchu",
      "type": "District"
    },
    {
      "code": "TW-HSZ",
      "name": "Hsinchui City",
      "type": "Municipality"
    },
    {
      "code": "TW-HUA",
      "name": "Hualien",
      "type": "District"
    },
    {
      "code": "TW-ILA",
      "name": "Ilan",
      "type": "District"
    },
    {
      "code": "TW-KEE",
      "name": "Keelung City",
      "type": "Municipality"
    },
    {
      "code": "TW-KHH",
      "name": "Kaohsiung City",
      "type": "Special Municipality"
    },
    {
      "code": "TW-KHQ",
      "name": "Kaohsiung",
      "type": "District"
    },
    {
      "code": "TW-MIA",
      "name": "Miaoli",
      "type": "District"
    },
    {
      "code": "TW-NAN",
      "name": "Nantou",
      "type": "District"
    },
    {
      "code": "TW-PEN",
      "name": "Penghu",
      "type": "District"
    },
    {
      "code": "TW-PIF",
      "name": "Pingtung",
      "type": "District"
    },
    {
      "code": "TW-TAO",
      "name": "Taoyuan",
      "type": "District"
    },
    {
      "code": "TW-TNN",
      "name": "Tainan City",
      "type": "Municipality"
    },
    {
      "code": "TW-TNQ",
      "name": "Tainan",
      "type": "District"
    },
    {
      "code": "TW-TPE",
      "name": "Taipei City",
      "type": "Special Municipality"
    },
    {
      "code": "TW-TPQ",
      "name": "Taipei",
      "type": "District"
    },
    {
      "code": "TW-TTT",
      "name": "Taitung",
      "type": "District"
    },
    {
      "code": "TW-TXG",
      "name": "Taichung City",
      "type": "Municipality"
    },
    {
      "code": "TW-TXQ",
      "name": "Taichung",
      "type": "District"
    },
    {
      "code": "TW-YUN",
      "name": "Yunlin",
      "type": "District"
    },
    {
      "code": "TZ-01",
      "name": "Arusha",
      "type": "Region"
    },
    {
      "code": "TZ-02",
      "name": "Dar-es-Salaam",
      "type": "Region"
    },
    {
      "code": "TZ-03",
      "name": "Dodoma",
      "type": "Region"
    },
    {
      "code": "TZ-04",
      "name": "Iringa",
      "type": "Region"
    },
    {
      "code": "TZ-05",
      "name": "Kagera",
      "type": "Region"
    },
    {
      "code": "TZ-06",
      "name": "Kaskazini Pemba",
      "type": "Region"
    },
    {
      "code": "TZ-07",
      "name": "Kaskazini Unguja",
      "type": "Region"
    },
    {
      "code": "TZ-08",
      "name": "Kigoma",
      "type": "Region"
    },
    {
      "code": "TZ-09",
      "name": "Kilimanjaro",
      "type": "Region"
    },
    {
      "code": "TZ-10",
      "name": "Kusini Pemba",
      "type": "Region"
    },
    {
      "code": "TZ-11",
      "name": "Kusini Unguja",
      "type": "Region"
    },
    {
      "code": "TZ-12",
      "name": "Lindi",
      "type": "Region"
    },
    {
      "code": "TZ-13",
      "name": "Mara",
      "type": "Region"
    },
    {
      "code": "TZ-14",
      "name": "Mbeya",
      "type": "Region"
    },
    {
      "code": "TZ-15",
      "name": "Mjini Magharibi",
      "type": "Region"
    },
    {
      "code": "TZ-16",
      "name": "Morogoro",
      "type": "Region"
    },
    {
      "code": "TZ-17",
      "name": "Mtwara",
      "type": "Region"
    },
    {
      "code": "TZ-18",
      "name": "Mwanza",
      "type": "Region"
    },
    {
      "code": "TZ-19",
      "name": "Pwani",
      "type": "Region"
    },
    {
      "code": "TZ-20",
      "name": "Rukwa",
      "type": "Region"
    },
    {
      "code": "TZ-21",
      "name": "Ruvuma",
      "type": "Region"
    },
    {
      "code": "TZ-22",
      "name": "Shinyanga",
      "type": "Region"
    },
    {
      "code": "TZ-23",
      "name": "Singida",
      "type": "Region"
    },
    {
      "code": "TZ-24",
      "name": "Tabora",
      "type": "Region"
    },
    {
      "code": "TZ-25",
      "name": "Tanga",
      "type": "Region"
    },
    {
      "code": "TZ-26",
      "name": "Manyara",
      "type": "Region"
    },
    {
      "code": "UA-05",
      "name": "Vinnyts'ka Oblast'",
      "type": "Province"
    },
    {
      "code": "UA-07",
      "name": "Volyns'ka Oblast'",
      "type": "Province"
    },
    {
      "code": "UA-09",
      "name": "Luhans'ka Oblast'",
      "type": "Province"
    },
    {
      "code": "UA-12",
      "name": "Dnipropetrovs'ka Oblast'",
      "type": "Province"
    },
    {
      "code": "UA-14",
      "name": "Donets'ka Oblast'",
      "type": "Province"
    },
    {
      "code": "UA-18",
      "name": "Zhytomyrs'ka Oblast'",
      "type": "Province"
    },
    {
      "code": "UA-21",
      "name": "Zakarpats'ka Oblast'",
      "type": "Province"
    },
    {
      "code": "UA-23",
      "name": "Zaporiz'ka Oblast'",
      "type": "Province"
    },
    {
      "code": "UA-26",
      "name": "Ivano-Frankivs'ka Oblast'",
      "type": "Province"
    },
    {
      "code": "UA-30",
      "name": "Kyïvs'ka mis'ka rada",
      "type": "City"
    },
    {
      "code": "UA-32",
      "name": "Kyïvs'ka Oblast'",
      "type": "Province"
    },
    {
      "code": "UA-35",
      "name": "Kirovohrads'ka Oblast'",
      "type": "Province"
    },
    {
      "code": "UA-40",
      "name": "Sevastopol",
      "type": "City"
    },
    {
      "code": "UA-43",
      "name": "Respublika Krym",
      "type": "Autonomous republic"
    },
    {
      "code": "UA-46",
      "name": "L'vivs'ka Oblast'",
      "type": "Province"
    },
    {
      "code": "UA-48",
      "name": "Mykolaïvs'ka Oblast'",
      "type": "Province"
    },
    {
      "code": "UA-51",
      "name": "Odes'ka Oblast'",
      "type": "Province"
    },
    {
      "code": "UA-53",
      "name": "Poltavs'ka Oblast'",
      "type": "Province"
    },
    {
      "code": "UA-56",
      "name": "Rivnens'ka Oblast'",
      "type": "Province"
    },
    {
      "code": "UA-59",
      "name": "Sums 'ka Oblast'",
      "type": "Province"
    },
    {
      "code": "UA-61",
      "name": "Ternopil's'ka Oblast'",
      "type": "Province"
    },
    {
      "code": "UA-63",
      "name": "Kharkivs'ka Oblast'",
      "type": "Province"
    },
    {
      "code": "UA-65",
      "name": "Khersons'ka Oblast'",
      "type": "Province"
    },
    {
      "code": "UA-68",
      "name": "Khmel'nyts'ka Oblast'",
      "type": "Province"
    },
    {
      "code": "UA-71",
      "name": "Cherkas'ka Oblast'",
      "type": "Province"
    },
    {
      "code": "UA-74",
      "name": "Chernihivs'ka Oblast'",
      "type": "Province"
    },
    {
      "code": "UA-77",
      "name": "Chernivets'ka Oblast'",
      "type": "Province"
    },
    {
      "code": "UG-101",
      "name": "Kalangala",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "UG-102",
      "name": "Kampala",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "UG-103",
      "name": "Kiboga",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "UG-104",
      "name": "Luwero",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "UG-105",
      "name": "Masaka",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "UG-106",
      "name": "Mpigi",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "UG-107",
      "name": "Mubende",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "UG-108",
      "name": "Mukono",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "UG-109",
      "name": "Nakasongola",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "UG-110",
      "name": "Rakai",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "UG-111",
      "name": "Sembabule",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "UG-112",
      "name": "Kayunga",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "UG-113",
      "name": "Wakiso",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "UG-114",
      "name": "Mityana",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "UG-115",
      "name": "Nakaseke",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "UG-116",
      "name": "Lyantonde",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "UG-201",
      "name": "Bugiri",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-202",
      "name": "Busia",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-203",
      "name": "Iganga",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-204",
      "name": "Jinja",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-205",
      "name": "Kamuli",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-206",
      "name": "Kapchorwa",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-207",
      "name": "Katakwi",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-208",
      "name": "Kumi",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-209",
      "name": "Mbale",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-210",
      "name": "Pallisa",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-211",
      "name": "Soroti",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-212",
      "name": "Tororo",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-213",
      "name": "Kaberamaido",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-214",
      "name": "Mayuge",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-215",
      "name": "Sironko",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-216",
      "name": "Amuria",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-217",
      "name": "Budaka",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-218",
      "name": "Bukwa",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-219",
      "name": "Butaleja",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-220",
      "name": "Kaliro",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-221",
      "name": "Manafwa",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-222",
      "name": "Namutumba",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-223",
      "name": "Bududa",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-224",
      "name": "Bukedea",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-301",
      "name": "Adjumani",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-302",
      "name": "Apac",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-303",
      "name": "Arua",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-304",
      "name": "Gulu",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-305",
      "name": "Kitgum",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-306",
      "name": "Kotido",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-307",
      "name": "Lira",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-308",
      "name": "Moroto",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-309",
      "name": "Moyo",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-310",
      "name": "Nebbi",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-311",
      "name": "Nakapiripirit",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-312",
      "name": "Pader",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-313",
      "name": "Yumbe",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-314",
      "name": "Amolatar",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-315",
      "name": "Kaabong",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-316",
      "name": "Koboko",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-317",
      "name": "Abim",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-318",
      "name": "Dokolo",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-319",
      "name": "Amuru",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-320",
      "name": "Maracha",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-321",
      "name": "Oyam",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-401",
      "name": "Bundibugyo",
      "parent": "W",
      "type": "District"
    },
    {
      "code": "UG-402",
      "name": "Bushenyi",
      "parent": "W",
      "type": "District"
    },
    {
      "code": "UG-403",
      "name": "Hoima",
      "parent": "W",
      "type": "District"
    },
    {
      "code": "UG-404",
      "name": "Kabale",
      "parent": "W",
      "type": "District"
    },
    {
      "code": "UG-405",
      "name": "Kabarole",
      "parent": "W",
      "type": "District"
    },
    {
      "code": "UG-406",
      "name": "Kasese",
      "parent": "W",
      "type": "District"
    },
    {
      "code": "UG-407",
      "name": "Kibaale",
      "parent": "W",
      "type": "District"
    },
    {
      "code": "UG-408",
      "name": "Kisoro",
      "parent": "W",
      "type": "District"
    },
    {
      "code": "UG-409",
      "name": "Masindi",
      "parent": "W",
      "type": "District"
    },
    {
      "code": "UG-410",
      "name": "Mbarara",
      "parent": "W",
      "type": "District"
    },
    {
      "code": "UG-411",
      "name": "Ntungamo",
      "parent": "W",
      "type": "District"
    },
    {
      "code": "UG-412",
      "name": "Rukungiri",
      "parent": "W",
      "type": "District"
    },
    {
      "code": "UG-413",
      "name": "Kamwenge",
      "parent": "W",
      "type": "District"
    },
    {
      "code": "UG-414",
      "name": "Kanungu",
      "parent": "W",
      "type": "District"
    },
    {
      "code": "UG-415",
      "name": "Kyenjojo",
      "parent": "W",
      "type": "District"
    },
    {
      "code": "UG-416",
      "name": "Ibanda",
      "parent": "W",
      "type": "District"
    },
    {
      "code": "UG-417",
      "name": "Isingiro",
      "parent": "W",
      "type": "District"
    },
    {
      "code": "UG-418",
      "name": "Kiruhura",
      "parent": "W",
      "type": "District"
    },
    {
      "code": "UG-419",
      "name": "Buliisa",
      "parent": "W",
      "type": "District"
    },
    {
      "code": "UG-C",
      "name": "Central",
      "type": "Geographical region"
    },
    {
      "code": "UG-E",
      "name": "Eastern",
      "type": "Geographical region"
    },
    {
      "code": "UG-N",
      "name": "Northern",
      "type": "Geographical region"
    },
    {
      "code": "UG-W",
      "name": "Western",
      "type": "Geographical region"
    },
    {
      "code": "UM-67",
      "name": "Johnston Atoll",
      "type": "Territory"
    },
    {
      "code": "UM-71",
      "name": "Midway Islands",
      "type": "Territory"
    },
    {
      "code": "UM-76",
      "name": "Navassa Island",
      "type": "Territory"
    },
    {
      "code": "UM-79",
      "name": "Wake Island",
      "type": "Territory"
    },
    {
      "code": "UM-81",
      "name": "Baker Island",
      "type": "Territory"
    },
    {
      "code": "UM-84",
      "name": "Howland Island",
      "type": "Territory"
    },
    {
      "code": "UM-86",
      "name": "Jarvis Island",
      "type": "Territory"
    },
    {
      "code": "UM-89",
      "name": "Kingman Reef",
      "type": "Territory"
    },
    {
      "code": "UM-95",
      "name": "Palmyra Atoll",
      "type": "Territory"
    },
    {
      "code": "US-AK",
      "name": "Alaska",
      "type": "State"
    },
    {
      "code": "US-AL",
      "name": "Alabama",
      "type": "State"
    },
    {
      "code": "US-AR",
      "name": "Arkansas",
      "type": "State"
    },
    {
      "code": "US-AS",
      "name": "American Samoa",
      "type": "Outlying area"
    },
    {
      "code": "US-AZ",
      "name": "Arizona",
      "type": "State"
    },
    {
      "code": "US-CA",
      "name": "California",
      "type": "State"
    },
    {
      "code": "US-CO",
      "name": "Colorado",
      "type": "State"
    },
    {
      "code": "US-CT",
      "name": "Connecticut",
      "type": "State"
    },
    {
      "code": "US-DC",
      "name": "District of Columbia",
      "type": "District"
    },
    {
      "code": "US-DE",
      "name": "Delaware",
      "type": "State"
    },
    {
      "code": "US-FL",
      "name": "Florida",
      "type": "State"
    },
    {
      "code": "US-GA",
      "name": "Georgia",
      "type": "State"
    },
    {
      "code": "US-GU",
      "name": "Guam",
      "type": "Outlying area"
    },
    {
      "code": "US-HI",
      "name": "Hawaii",
      "type": "State"
    },
    {
      "code": "US-IA",
      "name": "Iowa",
      "type": "State"
    },
    {
      "code": "US-ID",
      "name": "Idaho",
      "type": "State"
    },
    {
      "code": "US-IL",
      "name": "Illinois",
      "type": "State"
    },
    {
      "code": "US-IN",
      "name": "Indiana",
      "type": "State"
    },
    {
      "code": "US-KS",
      "name": "Kansas",
      "type": "State"
    },
    {
      "code": "US-KY",
      "name": "Kentucky",
      "type": "State"
    },
    {
      "code": "US-LA",
      "name": "Louisiana",
      "type": "State"
    },
    {
      "code": "US-MA",
      "name": "Massachusetts",
      "type": "State"
    },
    {
      "code": "US-MD",
      "name": "Maryland",
      "type": "State"
    },
    {
      "code": "US-ME",
      "name": "Maine",
      "type": "State"
    },
    {
      "code": "US-MI",
      "name": "Michigan",
      "type": "State"
    },
    {
      "code": "US-MN",
      "name": "Minnesota",
      "type": "State"
    },
    {
      "code": "US-MO",
      "name": "Missouri",
      "type": "State"
    },
    {
      "code": "US-MP",
      "name": "Northern Mariana Islands",
      "type": "Outlying area"
    },
    {
      "code": "US-MS",
      "name": "Mississippi",
      "type": "State"
    },
    {
      "code": "US-MT",
      "name": "Montana",
      "type": "State"
    },
    {
      "code": "US-NC",
      "name": "North Carolina",
      "type": "State"
    },
    {
      "code": "US-ND",
      "name": "North Dakota",
      "type": "State"
    },
    {
      "code": "US-NE",
      "name": "Nebraska",
      "type": "State"
    },
    {
      "code": "US-NH",
      "name": "New Hampshire",
      "type": "State"
    },
    {
      "code": "US-NJ",
      "name": "New Jersey",
      "type": "State"
    },
    {
      "code": "US-NM",
      "name": "New Mexico",
      "type": "State"
    },
    {
      "code": "US-NV",
      "name": "Nevada",
      "type": "State"
    },
    {
      "code": "US-NY",
      "name": "New York",
      "type": "State"
    },
    {
      "code": "US-OH",
      "name": "Ohio",
      "type": "State"
    },
    {
      "code": "US-OK",
      "name": "Oklahoma",
      "type": "State"
    },
    {
      "code": "US-OR",
      "name": "Oregon",
      "type": "State"
    },
    {
      "code": "US-PA",
      "name": "Pennsylvania",
      "type": "State"
    },
    {
      "code": "US-PR",
      "name": "Puerto Rico",
      "type": "Outlying area"
    },
    {
      "code": "US-RI",
      "name": "Rhode Island",
      "type": "State"
    },
    {
      "code": "US-SC",
      "name": "South Carolina",
      "type": "State"
    },
    {
      "code": "US-SD",
      "name": "South Dakota",
      "type": "State"
    },
    {
      "code": "US-TN",
      "name": "Tennessee",
      "type": "State"
    },
    {
      "code": "US-TX",
      "name": "Texas",
      "type": "State"
    },
    {
      "code": "US-UM",
      "name": "United States Minor Outlying Islands",
      "type": "Outlying area"
    },
    {
      "code": "US-UT",
      "name": "Utah",
      "type": "State"
    },
    {
      "code": "US-VA",
      "name": "Virginia",
      "type": "State"
    },
    {
      "code": "US-VI",
      "name": "Virgin Islands",
      "type": "Outlying area"
    },
    {
      "code": "US-VT",
      "name": "Vermont",
      "type": "State"
    },
    {
      "code": "US-WA",
      "name": "Washington",
      "type": "State"
    },
    {
      "code": "US-WI",
      "name": "Wisconsin",
      "type": "State"
    },
    {
      "code": "US-WV",
      "name": "West Virginia",
      "type": "State"
    },
    {
      "code": "US-WY",
      "name": "Wyoming",
      "type": "State"
    },
    {
      "code": "UY-AR",
      "name": "Artigas",
      "type": "Department"
    },
    {
      "code": "UY-CA",
      "name": "Canelones",
      "type": "Department"
    },
    {
      "code": "UY-CL",
      "name": "Cerro Largo",
      "type": "Department"
    },
    {
      "code": "UY-CO",
      "name": "Colonia",
      "type": "Department"
    },
    {
      "code": "UY-DU",
      "name": "Durazno",
      "type": "Department"
    },
    {
      "code": "UY-FD",
      "name": "Florida",
      "type": "Department"
    },
    {
      "code": "UY-FS",
      "name": "Flores",
      "type": "Department"
    },
    {
      "code": "UY-LA",
      "name": "Lavalleja",
      "type": "Department"
    },
    {
      "code": "UY-MA",
      "name": "Maldonado",
      "type": "Department"
    },
    {
      "code": "UY-MO",
      "name": "Montevideo",
      "type": "Department"
    },
    {
      "code": "UY-PA",
      "name": "Paysandú",
      "type": "Department"
    },
    {
      "code": "UY-RN",
      "name": "Río Negro",
      "type": "Department"
    },
    {
      "code": "UY-RO",
      "name": "Rocha",
      "type": "Department"
    },
    {
      "code": "UY-RV",
      "name": "Rivera",
      "type": "Department"
    },
    {
      "code": "UY-SA",
      "name": "Salto",
      "type": "Department"
    },
    {
      "code": "UY-SJ",
      "name": "San José",
      "type": "Department"
    },
    {
      "code": "UY-SO",
      "name": "Soriano",
      "type": "Department"
    },
    {
      "code": "UY-TA",
      "name": "Tacuarembó",
      "type": "Department"
    },
    {
      "code": "UY-TT",
      "name": "Treinta y Tres",
      "type": "Department"
    },
    {
      "code": "UZ-AN",
      "name": "Andijon",
      "type": "Region"
    },
    {
      "code": "UZ-BU",
      "name": "Buxoro",
      "type": "Region"
    },
    {
      "code": "UZ-FA",
      "name": "Farg'ona",
      "type": "Region"
    },
    {
      "code": "UZ-JI",
      "name": "Jizzax",
      "type": "Region"
    },
    {
      "code": "UZ-NG",
      "name": "Namangan",
      "type": "Region"
    },
    {
      "code": "UZ-NW",
      "name": "Navoiy",
      "type": "Region"
    },
    {
      "code": "UZ-QA",
      "name": "Qashqadaryo",
      "type": "Region"
    },
    {
      "code": "UZ-QR",
      "name": "Qoraqalpog'iston Respublikasi",
      "type": "Republic"
    },
    {
      "code": "UZ-SA",
      "name": "Samarqand",
      "type": "Region"
    },
    {
      "code": "UZ-SI",
      "name": "Sirdaryo",
      "type": "Region"
    },
    {
      "code": "UZ-SU",
      "name": "Surxondaryo",
      "type": "Region"
    },
    {
      "code": "UZ-TK",
      "name": "Toshkent",
      "type": "City"
    },
    {
      "code": "UZ-TO",
      "name": "Toshkent",
      "type": "Region"
    },
    {
      "code": "UZ-XO",
      "name": "Xorazm",
      "type": "Region"
    },
    {
      "code": "VC-01",
      "name": "Charlotte",
      "type": "Parish"
    },
    {
      "code": "VC-02",
      "name": "Saint Andrew",
      "type": "Parish"
    },
    {
      "code": "VC-03",
      "name": "Saint David",
      "type": "Parish"
    },
    {
      "code": "VC-04",
      "name": "Saint George",
      "type": "Parish"
    },
    {
      "code": "VC-05",
      "name": "Saint Patrick",
      "type": "Parish"
    },
    {
      "code": "VC-06",
      "name": "Grenadines",
      "type": "Parish"
    },
    {
      "code": "VE-A",
      "name": "Distrito Federal",
      "type": "Federal District"
    },
    {
      "code": "VE-B",
      "name": "Anzoátegui",
      "type": "State"
    },
    {
      "code": "VE-C",
      "name": "Apure",
      "type": "State"
    },
    {
      "code": "VE-D",
      "name": "Aragua",
      "type": "State"
    },
    {
      "code": "VE-E",
      "name": "Barinas",
      "type": "State"
    },
    {
      "code": "VE-F",
      "name": "Bolívar",
      "type": "State"
    },
    {
      "code": "VE-G",
      "name": "Carabobo",
      "type": "State"
    },
    {
      "code": "VE-H",
      "name": "Cojedes",
      "type": "State"
    },
    {
      "code": "VE-I",
      "name": "Falcón",
      "type": "State"
    },
    {
      "code": "VE-J",
      "name": "Guárico",
      "type": "State"
    },
    {
      "code": "VE-K",
      "name": "Lara",
      "type": "State"
    },
    {
      "code": "VE-L",
      "name": "Mérida",
      "type": "State"
    },
    {
      "code": "VE-M",
      "name": "Miranda",
      "type": "State"
    },
    {
      "code": "VE-N",
      "name": "Monagas",
      "type": "State"
    },
    {
      "code": "VE-O",
      "name": "Nueva Esparta",
      "type": "State"
    },
    {
      "code": "VE-P",
      "name": "Portuguesa",
      "type": "State"
    },
    {
      "code": "VE-R",
      "name": "Sucre",
      "type": "State"
    },
    {
      "code": "VE-S",
      "name": "Táchira",
      "type": "State"
    },
    {
      "code": "VE-T",
      "name": "Trujillo",
      "type": "State"
    },
    {
      "code": "VE-U",
      "name": "Yaracuy",
      "type": "State"
    },
    {
      "code": "VE-V",
      "name": "Zulia",
      "type": "State"
    },
    {
      "code": "VE-W",
      "name": "Dependencias Federales",
      "type": "Federal Dependency"
    },
    {
      "code": "VE-X",
      "name": "Vargas",
      "type": "State"
    },
    {
      "code": "VE-Y",
      "name": "Delta Amacuro",
      "type": "State"
    },
    {
      "code": "VE-Z",
      "name": "Amazonas",
      "type": "State"
    },
    {
      "code": "VN-01",
      "name": "Lai Châu",
      "type": "Province"
    },
    {
      "code": "VN-02",
      "name": "Lào Cai",
      "type": "Province"
    },
    {
      "code": "VN-03",
      "name": "Hà Giang",
      "type": "Province"
    },
    {
      "code": "VN-04",
      "name": "Cao Bằng",
      "type": "Province"
    },
    {
      "code": "VN-05",
      "name": "Sơn La",
      "type": "Province"
    },
    {
      "code": "VN-06",
      "name": "Yên Bái",
      "type": "Province"
    },
    {
      "code": "VN-07",
      "name": "Tuyên Quang",
      "type": "Province"
    },
    {
      "code": "VN-09",
      "name": "Lạng Sơn",
      "type": "Province"
    },
    {
      "code": "VN-13",
      "name": "Quảng Ninh",
      "type": "Province"
    },
    {
      "code": "VN-14",
      "name": "Hoà Bình",
      "type": "Province"
    },
    {
      "code": "VN-15",
      "name": "Hà Tây",
      "type": "Province"
    },
    {
      "code": "VN-18",
      "name": "Ninh Bình",
      "type": "Province"
    },
    {
      "code": "VN-20",
      "name": "Thái Bình",
      "type": "Province"
    },
    {
      "code": "VN-21",
      "name": "Thanh Hóa",
      "type": "Province"
    },
    {
      "code": "VN-22",
      "name": "Nghệ An",
      "type": "Province"
    },
    {
      "code": "VN-23",
      "name": "Hà Tỉnh",
      "type": "Province"
    },
    {
      "code": "VN-24",
      "name": "Quảng Bình",
      "type": "Province"
    },
    {
      "code": "VN-25",
      "name": "Quảng Trị",
      "type": "Province"
    },
    {
      "code": "VN-26",
      "name": "Thừa Thiên-Huế",
      "type": "Province"
    },
    {
      "code": "VN-27",
      "name": "Quảng Nam",
      "type": "Province"
    },
    {
      "code": "VN-28",
      "name": "Kon Tum",
      "type": "Province"
    },
    {
      "code": "VN-29",
      "name": "Quảng Ngãi",
      "type": "Province"
    },
    {
      "code": "VN-30",
      "name": "Gia Lai",
      "type": "Province"
    },
    {
      "code": "VN-31",
      "name": "Bình Định",
      "type": "Province"
    },
    {
      "code": "VN-32",
      "name": "Phú Yên",
      "type": "Province"
    },
    {
      "code": "VN-33",
      "name": "Đắc Lắk",
      "type": "Province"
    },
    {
      "code": "VN-34",
      "name": "Khánh Hòa",
      "type": "Province"
    },
    {
      "code": "VN-35",
      "name": "Lâm Đồng",
      "type": "Province"
    },
    {
      "code": "VN-36",
      "name": "Ninh Thuận",
      "type": "Province"
    },
    {
      "code": "VN-37",
      "name": "Tây Ninh",
      "type": "Province"
    },
    {
      "code": "VN-39",
      "name": "Đồng Nai",
      "type": "Province"
    },
    {
      "code": "VN-40",
      "name": "Bình Thuận",
      "type": "Province"
    },
    {
      "code": "VN-41",
      "name": "Long An",
      "type": "Province"
    },
    {
      "code": "VN-43",
      "name": "Bà Rịa-Vũng Tàu",
      "type": "Province"
    },
    {
      "code": "VN-44",
      "name": "An Giang",
      "type": "Province"
    },
    {
      "code": "VN-45",
      "name": "Đồng Tháp",
      "type": "Province"
    },
    {
      "code": "VN-46",
      "name": "Tiền Giang",
      "type": "Province"
    },
    {
      "code": "VN-47",
      "name": "Kiên Giang",
      "type": "Province"
    },
    {
      "code": "VN-49",
      "name": "Vĩnh Long",
      "type": "Province"
    },
    {
      "code": "VN-50",
      "name": "Bến Tre",
      "type": "Province"
    },
    {
      "code": "VN-51",
      "name": "Trà Vinh",
      "type": "Province"
    },
    {
      "code": "VN-52",
      "name": "Sóc Trăng",
      "type": "Province"
    },
    {
      "code": "VN-53",
      "name": "Bắc Kạn",
      "type": "Province"
    },
    {
      "code": "VN-54",
      "name": "Bắc Giang",
      "type": "Province"
    },
    {
      "code": "VN-55",
      "name": "Bạc Liêu",
      "type": "Province"
    },
    {
      "code": "VN-56",
      "name": "Bắc Ninh",
      "type": "Province"
    },
    {
      "code": "VN-57",
      "name": "Bình Dương",
      "type": "Province"
    },
    {
      "code": "VN-58",
      "name": "Bình Phước",
      "type": "Province"
    },
    {
      "code": "VN-59",
      "name": "Cà Mau",
      "type": "Province"
    },
    {
      "code": "VN-61",
      "name": "Hải Duong",
      "type": "Province"
    },
    {
      "code": "VN-63",
      "name": "Hà Nam",
      "type": "Province"
    },
    {
      "code": "VN-66",
      "name": "Hưng Yên",
      "type": "Province"
    },
    {
      "code": "VN-67",
      "name": "Nam Định",
      "type": "Province"
    },
    {
      "code": "VN-68",
      "name": "Phú Thọ",
      "type": "Province"
    },
    {
      "code": "VN-69",
      "name": "Thái Nguyên",
      "type": "Province"
    },
    {
      "code": "VN-70",
      "name": "Vĩnh Phúc",
      "type": "Province"
    },
    {
      "code": "VN-71",
      "name": "Điện Biên",
      "type": "Province"
    },
    {
      "code": "VN-72",
      "name": "Đắk Nông",
      "type": "Province"
    },
    {
      "code": "VN-73",
      "name": "Hậu Giang",
      "type": "Province"
    },
    {
      "code": "VN-CT",
      "name": "Cần Thơ",
      "type": "Municipality"
    },
    {
      "code": "VN-DN",
      "name": "Đà Nẵng",
      "type": "Municipality"
    },
    {
      "code": "VN-HN",
      "name": "Hà Nội",
      "type": "Municipality"
    },
    {
      "code": "VN-HP",
      "name": "Hải Phòng",
      "type": "Municipality"
    },
    {
      "code": "VN-SG",
      "name": "Hồ Chí Minh [Sài Gòn]",
      "type": "Municipality"
    },
    {
      "code": "VU-MAP",
      "name": "Malampa",
      "type": "Province"
    },
    {
      "code": "VU-PAM",
      "name": "Pénama",
      "type": "Province"
    },
    {
      "code": "VU-SAM",
      "name": "Sanma",
      "type": "Province"
    },
    {
      "code": "VU-SEE",
      "name": "Shéfa",
      "type": "Province"
    },
    {
      "code": "VU-TAE",
      "name": "Taféa",
      "type": "Province"
    },
    {
      "code": "VU-TOB",
      "name": "Torba",
      "type": "Province"
    },
    {
      "code": "WS-AA",
      "name": "A'ana",
      "type": "District"
    },
    {
      "code": "WS-AL",
      "name": "Aiga-i-le-Tai",
      "type": "District"
    },
    {
      "code": "WS-AT",
      "name": "Atua",
      "type": "District"
    },
    {
      "code": "WS-FA",
      "name": "Fa'asaleleaga",
      "type": "District"
    },
    {
      "code": "WS-GE",
      "name": "Gaga'emauga",
      "type": "District"
    },
    {
      "code": "WS-GI",
      "name": "Gagaifomauga",
      "type": "District"
    },
    {
      "code": "WS-PA",
      "name": "Palauli",
      "type": "District"
    },
    {
      "code": "WS-SA",
      "name": "Satupa'itea",
      "type": "District"
    },
    {
      "code": "WS-TU",
      "name": "Tuamasaga",
      "type": "District"
    },
    {
      "code": "WS-VF",
      "name": "Va'a-o-Fonoti",
      "type": "District"
    },
    {
      "code": "WS-VS",
      "name": "Vaisigano",
      "type": "District"
    },
    {
      "code": "YE-AB",
      "name": "Abyān",
      "type": "Governorate"
    },
    {
      "code": "YE-AD",
      "name": "'Adan",
      "type": "Governorate"
    },
    {
      "code": "YE-AM",
      "name": "'Amrān",
      "type": "Governorate"
    },
    {
      "code": "YE-BA",
      "name": "Al Bayḑā'",
      "type": "Governorate"
    },
    {
      "code": "YE-DA",
      "name": "Aḑ Ḑāli‘",
      "type": "Governorate"
    },
    {
      "code": "YE-DH",
      "name": "Dhamār",
      "type": "Governorate"
    },
    {
      "code": "YE-HD",
      "name": "Ḩaḑramawt",
      "type": "Governorate"
    },
    {
      "code": "YE-HJ",
      "name": "Ḩajjah",
      "type": "Governorate"
    },
    {
      "code": "YE-IB",
      "name": "Ibb",
      "type": "Governorate"
    },
    {
      "code": "YE-JA",
      "name": "Al Jawf",
      "type": "Governorate"
    },
    {
      "code": "YE-LA",
      "name": "Laḩij",
      "type": "Governorate"
    },
    {
      "code": "YE-MA",
      "name": "Ma'rib",
      "type": "Governorate"
    },
    {
      "code": "YE-MR",
      "name": "Al Mahrah",
      "type": "Governorate"
    },
    {
      "code": "YE-MU",
      "name": "Al Ḩudaydah",
      "type": "Governorate"
    },
    {
      "code": "YE-MW",
      "name": "Al Maḩwīt",
      "type": "Governorate"
    },
    {
      "code": "YE-RA",
      "name": "Raymah",
      "type": "Governorate"
    },
    {
      "code": "YE-SD",
      "name": "Şa'dah",
      "type": "Governorate"
    },
    {
      "code": "YE-SH",
      "name": "Shabwah",
      "type": "Governorate"
    },
    {
      "code": "YE-SN",
      "name": "Şan'ā'",
      "type": "Governorate"
    },
    {
      "code": "YE-TA",
      "name": "Tā'izz",
      "type": "Governorate"
    },
    {
      "code": "ZA-EC",
      "name": "Eastern Cape",
      "type": "Province"
    },
    {
      "code": "ZA-FS",
      "name": "Free State",
      "type": "Province"
    },
    {
      "code": "ZA-GP",
      "name": "Gauteng",
      "type": "Province"
    },
    {
      "code": "ZA-LP",
      "name": "Limpopo",
      "type": "Province"
    },
    {
      "code": "ZA-MP",
      "name": "Mpumalanga",
      "type": "Province"
    },
    {
      "code": "ZA-NC",
      "name": "Northern Cape",
      "type": "Province"
    },
    {
      "code": "ZA-NW",
      "name": "North-West (South Africa)",
      "type": "Province"
    },
    {
      "code": "ZA-WC",
      "name": "Western Cape",
      "type": "Province"
    },
    {
      "code": "ZA-ZN",
      "name": "Kwazulu-Natal",
      "type": "Province"
    },
    {
      "code": "ZM-01",
      "name": "Western",
      "type": "Province"
    },
    {
      "code": "ZM-02",
      "name": "Central",
      "type": "Province"
    },
    {
      "code": "ZM-03",
      "name": "Eastern",
      "type": "Province"
    },
    {
      "code": "ZM-04",
      "name": "Luapula",
      "type": "Province"
    },
    {
      "code": "ZM-05",
      "name": "Northern",
      "type": "Province"
    },
    {
      "code": "ZM-06",
      "name": "North-Western",
      "type": "Province"
    },
    {
      "code": "ZM-07",
      "name": "Southern (Zambia)",
      "type": "Province"
    },
    {
      "code": "ZM-08",
      "name": "Copperbelt",
      "type": "Province"
    },
    {
      "code": "ZM-09",
      "name": "Lusaka",
      "type": "Province"
    },
    {
      "code": "ZW-BU",
      "name": "Bulawayo",
      "type": "City"
    },
    {
      "code": "ZW-HA",
      "name": "Harare",
      "type": "City"
    },
    {
      "code": "ZW-MA",
      "name": "Manicaland",
      "type": "Province"
    },
    {
      "code": "ZW-MC",
      "name": "Mashonaland Central",
      "type": "Province"
    },
    {
      "code": "ZW-ME",
      "name": "Mashonaland East",
      "type": "Province"
    },
    {
      "code": "ZW-MI",
      "name": "Midlands",
      "type": "Province"
    },
    {
      "code": "ZW-MN",
      "name": "Matabeleland North",
      "type": "Province"
    },
    {
      "code": "ZW-MS",
      "name": "Matabeleland South",
      "type": "Province"
    },
    {
      "code": "ZW-MV",
      "name": "Masvingo",
      "type": "Province"
    },
    {
      "code": "ZW-MW",
      "name": "Mashonaland West",
      "type": "Province"
    }
  ]
}

};
#-------------------------------------------------------------------------------
1;