# SPVM Language

<img src="/logo/spvm_logo.jpg" width="160px">

<a href="https://metacpan.org/pod/SPVM">SPVM - CPAN</a>

## SPVM Tutorial

* <a href="https://github.com/yuki-kimoto/SPVM/wiki/Tutorial">SPVM Tutorial</a>

## Documents

<ul>

<li><p><a href="https://metacpan.org/pod/SPVM::Document::Language">Language Specification</a></p>

<ul>

<li><p><a href="https://metacpan.org/pod/SPVM::Document::Language::Tokenization">Lexical Tokenization</a></p>

</li>
<li><p><a href="https://metacpan.org/pod/SPVM::Document::Language::SyntaxParsing">Syntax Parsing</a></p>

</li>
<li><p><a href="https://metacpan.org/pod/SPVM::Document::Language::Class">Class Definition</a></p>

</li>
<li><p><a href="https://metacpan.org/pod/SPVM::Document::Language::Types">Types</a></p>

</li>
<li><p><a href="https://metacpan.org/pod/SPVM::Document::Language::Statements">Statements</a></p>

</li>
<li><p><a href="https://metacpan.org/pod/SPVM::Document::Language::Operators">Operators</a></p>

</li>
<li><p><a href="https://metacpan.org/pod/SPVM::Document::Language::ExceptionHandling">Exception Handling</a></p>

</li>
<li><p><a href="https://metacpan.org/pod/SPVM::Document::Language::GarbageCollection">Garbage Collection</a></p>

</li>
<li><p><a href="https://metacpan.org/pod/SPVM::Document::Language::System">System Setting</a></p>

</li>
</ul>

</li>
<li><p><a href="https://metacpan.org/pod/SPVM::ExchangeAPI">Exchange APIs</a></p>

</li>
<li><p><a href="https://metacpan.org/pod/SPVM::Document::NativeClass">Native Classes</a></p>

</li>
<li><p><a href="https://metacpan.org/pod/SPVM::Builder::Config">Native Class Configurations</a></p>

</li>
<li><p><a href="https://metacpan.org/pod/SPVM::Document::NativeAPI">Native APIs</a></p>

<ul>

<li><p><a href="https://metacpan.org/pod/SPVM::Document::NativeAPI::Runtime">Runtime Native APIs</a></p>

</li>
<li><p><a href="https://metacpan.org/pod/SPVM::Document::NativeAPI::BasicType">Basic Type Native APIs</a></p>

</li>
<li><p><a href="https://metacpan.org/pod/SPVM::Document::NativeAPI::ClassVariable">Class Variable Native APIs</a></p>

</li>
<li><p><a href="https://metacpan.org/pod/SPVM::Document::NativeAPI::Field">Field Native APIs</a></p>

</li>
<li><p><a href="https://metacpan.org/pod/SPVM::Document::NativeAPI::Method">Method Native APIs</a></p>

</li>
<li><p><a href="https://metacpan.org/pod/SPVM::Document::NativeAPI::Argument">Argument Native APIs</a></p>

</li>
<li><p><a href="https://metacpan.org/pod/SPVM::Document::NativeAPI::Type">Type Native APIs</a></p>

</li>
<li><p><a href="https://metacpan.org/pod/SPVM::Document::NativeAPI::Compiler">Compiler Native APIs</a></p>

</li>
<li><p><a href="https://metacpan.org/pod/SPVM::Document::NativeAPI::ClassFile">Class File Native APIs</a></p>

</li>
<li><p><a href="https://metacpan.org/pod/SPVM::Document::NativeAPI::StringBuffer">String Buffer Native APIs</a></p>

</li>
<li><p><a href="https://metacpan.org/pod/SPVM::Document::NativeAPI::Allocator">Allocatord Native APIs</a></p>

</li>
<li><p><a href="https://metacpan.org/pod/SPVM::Document::NativeAPI::Mutex">Mutex Native APIs</a></p>

</li>
<li><p><a href="https://metacpan.org/pod/SPVM::Document::NativeAPI::Internal">Internal Native APIs</a></p>

</li>
</ul>

</li>
<li><p><a href="https://metacpan.org/pod/SPVM::Document::Resource">Resources</a></p>

</li>
<li><p><a href="https://metacpan.org/pod/SPVM::Document::EnvironmentVariables">Environment Variables</a></p>

</li>
</ul>

### Commands

<ul>

<li><p><a href="https://metacpan.org/pod/spvm">spvm - Executing SPVM Programs</a></p>

</li>
<li><p><a href="https://metacpan.org/pod/spvmcc">spvmcc - Generating Executable Files</a></p>

</li>
<li><p><a href="https://metacpan.org/pod/spvmdist">spvmdist - Distributing SPVM Modules</a></p>

</li>
</ul>

### Modules

<ul>

<li><p><a href="https://metacpan.org/pod/SPVM::Document::Modules">Standard Modules</a></p>

</li>
<li><p><a href="https://github.com/yuki-kimoto/SPVM/wiki/CPAN-Modules">CPAN Modules</a></p>

</li>
</ul>

### Examples

<ul>

<li><p><a href="https://github.com/yuki-kimoto/SPVM/tree/doc/t/02_vm/lib/SPVM/TestCase">SPVM Test Cases</a></p>

</li>
<li><p><a href="https://github.com/yuki-kimoto/SPVM/tree/doc/examples/native">Binding C/C++ Libraries</a></p>

</li>
</ul>

### Wiki

<ul>

<li><p><a href="https://github.com/yuki-kimoto/SPVM/wiki">Wiki</a></p>

</li>
</ul>

