use strict;
use warnings;
use Module::Build;

my $builder = Module::Build->new(
   module_name         => 'PBP::Moose',
   license             => 'artistic2',
   dist_author         => 'Juergen von Brietzke <juergen.von.brietzke@t-online.de>',
   dist_version_from   => 'lib/PBP/Moose.pm',
   requires => {
      'perl'                         => 5.012000,
      'Hook::AfterRuntime'           => 0,
      'Moose'                        => 0,
      'Moose::Exporter'              => 0,
      'Moose::Util::TypeConstraints' => 0,
      'MooseX::AttributeShortcuts'   => 0,
      'MooseX::DeclareX'             => 0,
      'MooseX::HasDefaults::RO'      => 0,
      'PBP::Perl'                    => 0,
      'namespace::autoclean'         => 0,
   },
    build_requires => {
        'Test::More'          => 0,
        'Test::Perl::Critic'  => 0,
        'Test::Pod'           => 1.14,
        'Test::Pod::Coverage' => 1.04,
    },
   add_to_cleanup      => [ 'PBP-Moose-*' ],
);

$builder->create_build_script();
