# $Id: Split.pm,v 1.8 2005/12/26 13:57:47 joern Exp $

#-----------------------------------------------------------------------
# Copyright (C) 2001-2003 Jrn Reder <joern AT zyn.de>.
# All Rights Reserved. See file COPYRIGHT for details.
# 
# This program is part of Video::DVDRip, which is free software; you can
# redistribute it and/or modify it under the same terms as Perl itself.
#-----------------------------------------------------------------------

package Video::DVDRip::Job::Split;
use Locale::TextDomain qw (video.dvdrip);
use Video::DVDRip::FixLocaleTextDomainUTF8;

# That's Perl! The job classes inherit from this class,
# which is decided at *runtime* - this way standard and
# cluster mode can share the same job execution system
# by inserting the cluster logic dynamically into the
# inheritence line... great stuff!

BEGIN {	eval "use base $Video::DVDRip::JobClass" }

use Carp;
use strict;

sub ogg_pass			{ shift->{ogg_pass}			}
sub set_ogg_pass		{ shift->{ogg_pass}		= $_[1]	}


sub type {
	return "split";
}

sub info {
	my $self = shift;

	my $info;
	if ( $self->ogg_pass ) {
		$info = __x("split OGG pass {pass}", pass => $self->ogg_pass);
	} else {
		$info = __"split AVI";
	}
	
	$info .= " - ".__x("title #{title}", title => $self->title->nr);

	return $info;
}

sub init {
	my $self = shift;
	
	my $title = $self->title;
	
	if ( $title->is_ogg ) {
		$self->set_progress_show_fps ( 0 );
		$self->set_progress_show_percent ( 1 );
		$self->set_progress_max(2000);
		$self->set_ogg_pass(1);
		return 1;
	}

	$self->set_ogg_pass(0);

	$self->set_progress_show_fps ( 1 );

	my $max_value;
	if ( $title->tc_start_frame ne '' or
	     $title->tc_end_frame ne '' ) {
	     	$max_value = $title->tc_end_frame;
		$max_value ||= $title->frames;
	} else {
		$max_value = $title->frames;
	}

	$self->set_progress_max ( $max_value );

	1;
}

sub get_diskspace_needed {
	my $self = shift; $self->trace_in;

	return $self->title->tc_target_size * 1024;
}

sub get_diskspace_freed {
	return 0;
}

sub command {
	my $self = shift;

	return $self->title->get_split_command;
}

sub parse_output {
	my $self = shift;
	my ($line) = @_;

	if ( $self->ogg_pass ) {
		if ( $line =~ /second\s+pass/i ) {
			$self->set_ogg_pass( 2 );
			$self->set_progress_show_fps( 1 );
		}
		if ( $line =~ m!(\d+)/(\d+)! ) {
			$self->set_progress_cnt (
				1000 * ( $self->ogg_pass - 1 ) +
				int ( 1000 * $1 / $2 )
			);
		}
	} else {
		if ( $line =~ /\(\d{6}-(\d+)\),\s+(.*?)\[.*?$/ ) {
			$self->set_progress_cnt ($1);
		}
	}
	
	$self->set_operation_successful ( 1 )
		if $line =~ /DVDRIP_SUCCESS/;

	1;	
}

1;
