#!./perl

use strict;
use Config;
BEGIN {
    warn " >>> set_defaults.PL running...\n";
    require vars;
    my $pk;
    do {
	my $sitelib = $Config{sitelib};
	my $prefix = $ENV{PERL5PREFIX} || $Config{prefix};
	$sitelib =~ s/$Config{prefix}/$prefix/;
	local @INC = ($sitelib);
	eval { require "./Conf.pm" };
	if (!$@) {
	    warn " >>> using ./Conf.pm\n";
	    $pk = 'Envy::Conf';
	} else {
	    eval { require Envy::Conf };
	    if (!$@) {
		$pk = 'Envy::Conf';
		warn " >>> using installed Envy::Conf ($INC{'Envy/Conf.pm'})\n";
	    } else {
		require "./DefaultConf.pm";
		$pk = 'Envy::DefaultConf';
		warn " >>> using DefaultConf.pm\n";
	    }
	}
    };
    $pk->import(qw(%env0 $startup $prefix @path));
    require "./subst.pm";
}
use IO::File;

sub do_init_env {
    my ($file) = @_;
    my $str='';
    if ($file eq 'login.IN') {
	for my $k (sort keys %env0) {
	    my $v=$env0{$k};
	    $str .= "setenv $k $v\n";
	}
    } else {
	for my $k (sort keys %env0) {
	    my $v=$env0{$k};
	    $str .= "$k=$v; export $k\n";
	}
    }
    $str;
}

# This maps symlinks from $ETOP/etc/login/ to $HOME/.
my $symlink = {
	       'dot.profile' => ['.profile', '.zprofile', '.bash_profile'],
	       'dot.shrc' => ['.shrc', '.zshrc', '.bashrc'],
	       'dot.login' => ['.login'],
	       'dot.cshrc' => ['.cshrc'],
	       'dot.dtprofile' => ['.dtprofile'],
	      };

my $symlink_str;
while (my($k,$v) = each %$symlink) {
    for my $to (@$v) {
	$symlink_str .= 'safe_symlink $ETOP/etc/login/'.$k.' $HOME/'.$to."\n";
    }
}

my $perl5lib = $Config{sitelib};
$perl5lib =~ s/$Config{prefix}/$prefix/;

my $subst = {'#SEARCH#' => "qw(".join(' ',@path).")",
	     '#STARTUP#' => $startup,
	     '#ENVY.PL#' => "$prefix/bin/envy.pl",
	     '#INITIAL_ENV#' => \&do_init_env,
	     '#SAFE_SYMLINK#' => $symlink_str,
	     '#ETOP#' => $prefix,
	     '#PERL5LIB#' => $perl5lib,
	    };

sub go {
    my $who = `whoami`."@".`hostname`;
    $who =~ s/\n//g;

    my $status = IO::File->new();
    $status->open(">Conf.pm.new") or die "open >Conf.pm.new: $!";
    select $status;
    print q[# Re-generated by uncommenting the following line:
# return 0;

use strict;
package Envy::Conf;
require Exporter;
use vars qw(@ISA @EXPORT_OK
	    %env0 $startup $prefix @path);
@ISA = ('Exporter');
@EXPORT_OK = qw(%env0 $startup $prefix @path);

# Hardcoded environment:
%env0 = (
].join('',map { "\t'$_' => '$env0{$_}',\n" } sort keys %env0) .q[);

# Startup envy:
$startup = ]."'$startup';".q[

# Prefix:
$prefix = ]."'$prefix';".q[

# Default $ENVY_PATH:
@path = qw(
].join('', map { "\t$_\n" } @path).q[);

1;
];
    $status->close;

    my $f1 = new IO::File;
    my $f2 = new IO::File;
    for my $in (keys %$subst_files) {
	my $out = $subst_files->{$in};
	my $gen = "\n";
	$gen .= "# set_defaults.PL $in -> $out\n";
	warn "Substituting $in -> $out\n";
	my $v2str = sub {
	    my $v = shift;
	    if (ref $v) { $v->($in) }
	    else { $v }
	};
	$f1->open($in) or die "open $in: $!";
	$f2->open(">$out") or die "open $out: $!";
	while (defined(my $l=<$f1>)) {
	    while (my($k,$v)=each %$subst) {
		$l =~ s/$k/&$v2str($v)/e;
	    }
	    $f2->print($l);
	}
	$f2->print($gen);
	$f1->close;
	$f2->close;
	chmod(0755, $out)==1 or die "chmod $out: $!";
    }
}
&go;

if (system "cmp -s ./Conf.pm ./Conf.pm.new") {
    rename "./Conf.pm.new", "./Conf.pm";
    warn " >>> Done!  New configuration written to ./Conf.pm <<<\n";
} else {
    warn " >>> Done!  (./Conf.pm unchanged) <<<\n";
    unlink "./Conf.pm.new";
}
