use strict;
use warnings;
use utf8;

use Test::More tests => 8;

use String::Copyright;

is copyright("#define foo(c) 1999 Foo"), '', 'bogus sign';

is copyright("(c) 1999 Foo\n#define foo(c) 1999 Bar"),
	'© 1999 Foo',
	'sign, then bogus sign';

is copyright("#define foo(c) 1999 Foo\n(c) 1999 Bar"),
	'© 1999 Bar',
	'bogus sign, then sign';

is copyright("(c) 1999 Foo #define foo(c) 1999 Bar"),
	'© 1999 Foo #define foo(c) 1999 Bar',
	'sign, then bogus sign on same line';

is copyright("#define foo(c) 1999 Foo (c) 1999 Bar"),
	'© 1999 Bar',
	'bogus sign, then sign on same line';

TODO: {
	local $TODO = 'not yet handled';
	is copyright("(c) 1999 Foo (c) 2000 Foo © 2002 Foo"),
		'© 1999-2000, 2002 Foo',
		'sign x 3 on same line';
}

is copyright("* Note, the copyright information is at end of file."), '',
	'non-sign and space';

is copyright("* For copyright information, see copyright.h."), '',
	'non-sign and punctuation';
