# Generated by default/object.tt
package Paws::DMS::NeptuneSettings;
  use Moose;
  has ErrorRetryDuration => (is => 'ro', isa => 'Int');
  has IamAuthEnabled => (is => 'ro', isa => 'Bool');
  has MaxFileSize => (is => 'ro', isa => 'Int');
  has MaxRetryCount => (is => 'ro', isa => 'Int');
  has S3BucketFolder => (is => 'ro', isa => 'Str', required => 1);
  has S3BucketName => (is => 'ro', isa => 'Str', required => 1);
  has ServiceAccessRoleArn => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::DMS::NeptuneSettings

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::DMS::NeptuneSettings object:

  $service_obj->Method(Att1 => { ErrorRetryDuration => $value, ..., ServiceAccessRoleArn => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::DMS::NeptuneSettings object:

  $result = $service_obj->Method(...);
  $result->Att1->ErrorRetryDuration

=head1 DESCRIPTION

Provides information that defines an Amazon Neptune endpoint.

=head1 ATTRIBUTES


=head2 ErrorRetryDuration => Int

The number of milliseconds for AWS DMS to wait to retry a bulk-load of
migrated graph data to the Neptune target database before raising an
error. The default is 250.


=head2 IamAuthEnabled => Bool

If you want AWS Identity and Access Management (IAM) authorization
enabled for this endpoint, set this parameter to C<true>. Then attach
the appropriate IAM policy document to your service role specified by
C<ServiceAccessRoleArn>. The default is C<false>.


=head2 MaxFileSize => Int

The maximum size in kilobytes of migrated graph data stored in a .csv
file before AWS DMS bulk-loads the data to the Neptune target database.
The default is 1,048,576 KB. If the bulk load is successful, AWS DMS
clears the bucket, ready to store the next batch of migrated graph
data.


=head2 MaxRetryCount => Int

The number of times for AWS DMS to retry a bulk load of migrated graph
data to the Neptune target database before raising an error. The
default is 5.


=head2 B<REQUIRED> S3BucketFolder => Str

A folder path where you want AWS DMS to store migrated graph data in
the S3 bucket specified by C<S3BucketName>


=head2 B<REQUIRED> S3BucketName => Str

The name of the Amazon S3 bucket where AWS DMS can temporarily store
migrated graph data in .csv files before bulk-loading it to the Neptune
target database. AWS DMS maps the SQL source data to graph data before
storing it in these .csv files.


=head2 ServiceAccessRoleArn => Str

The Amazon Resource Name (ARN) of the service role that you created for
the Neptune target endpoint. For more information, see Creating an IAM
Service Role for Accessing Amazon Neptune as a Target
(https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.ServiceRole)
in the I<AWS Database Migration Service User Guide.>



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::DMS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

