package Paws::RedShift::DeferredMaintenanceWindow;
  use Moose;
  has DeferMaintenanceEndTime => (is => 'ro', isa => 'Str');
  has DeferMaintenanceIdentifier => (is => 'ro', isa => 'Str');
  has DeferMaintenanceStartTime => (is => 'ro', isa => 'Str');
1;

### main pod documentation begin ###

=head1 NAME

Paws::RedShift::DeferredMaintenanceWindow

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::RedShift::DeferredMaintenanceWindow object:

  $service_obj->Method(Att1 => { DeferMaintenanceEndTime => $value, ..., DeferMaintenanceStartTime => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::RedShift::DeferredMaintenanceWindow object:

  $result = $service_obj->Method(...);
  $result->Att1->DeferMaintenanceEndTime

=head1 DESCRIPTION

Describes a deferred maintenance window

=head1 ATTRIBUTES


=head2 DeferMaintenanceEndTime => Str

  A timestamp for the end of the time period when we defer maintenance.


=head2 DeferMaintenanceIdentifier => Str

  A unique identifier for the maintenance window.


=head2 DeferMaintenanceStartTime => Str

  A timestamp for the beginning of the time period when we defer
maintenance.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::RedShift>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

