
package Paws::AutoScaling::DeleteNotificationConfiguration;
  use Moose;
  has AutoScalingGroupName => (is => 'ro', isa => 'Str', required => 1);
  has TopicARN => (is => 'ro', isa => 'Str', required => 1);

  use MooseX::ClassAttribute;

  class_has _api_call => (isa => 'Str', is => 'ro', default => 'DeleteNotificationConfiguration');
  class_has _returns => (isa => 'Str', is => 'ro', default => 'Paws::API::Response');
  class_has _result_key => (isa => 'Str', is => 'ro');
1;

### main pod documentation begin ###

=head1 NAME

Paws::AutoScaling::DeleteNotificationConfiguration - Arguments for method DeleteNotificationConfiguration on L<Paws::AutoScaling>

=head1 DESCRIPTION

This class represents the parameters used for calling the method DeleteNotificationConfiguration on the
L<Auto Scaling|Paws::AutoScaling> service. Use the attributes of this class
as arguments to method DeleteNotificationConfiguration.

You shouldn't make instances of this class. Each attribute should be used as a named argument in the call to DeleteNotificationConfiguration.

=head1 SYNOPSIS

    my $autoscaling = Paws->service('AutoScaling');
    # To delete an Auto Scaling notification
    # This example deletes the specified notification from the specified Auto
    # Scaling group.
    $autoscaling->DeleteNotificationConfiguration(
      {
        'AutoScalingGroupName' => 'my-auto-scaling-group',
        'TopicARN' => 'arn:aws:sns:us-west-2:123456789012:my-sns-topic'
      }
    );


Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.
For the AWS API documentation, see L<https://docs.aws.amazon.com/goto/WebAPI/autoscaling/DeleteNotificationConfiguration>

=head1 ATTRIBUTES


=head2 B<REQUIRED> AutoScalingGroupName => Str

The name of the Auto Scaling group.



=head2 B<REQUIRED> TopicARN => Str

The Amazon Resource Name (ARN) of the Amazon Simple Notification
Service (Amazon SNS) topic.




=head1 SEE ALSO

This class forms part of L<Paws>, documenting arguments for method DeleteNotificationConfiguration in L<Paws::AutoScaling>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

