
package Paws::GuardDuty::UpdateDetector;
  use Moose;
  has DetectorId => (is => 'ro', isa => 'Str', traits => ['ParamInURI'], uri_name => 'detectorId', required => 1);
  has Enable => (is => 'ro', isa => 'Bool', traits => ['NameInRequest'], request_name => 'enable');

  use MooseX::ClassAttribute;

  class_has _api_call => (isa => 'Str', is => 'ro', default => 'UpdateDetector');
  class_has _api_uri  => (isa => 'Str', is => 'ro', default => '/detector/{detectorId}');
  class_has _api_method  => (isa => 'Str', is => 'ro', default => 'POST');
  class_has _returns => (isa => 'Str', is => 'ro', default => 'Paws::GuardDuty::UpdateDetectorResponse');
1;

### main pod documentation begin ###

=head1 NAME

Paws::GuardDuty::UpdateDetector - Arguments for method UpdateDetector on L<Paws::GuardDuty>

=head1 DESCRIPTION

This class represents the parameters used for calling the method UpdateDetector on the
L<Amazon GuardDuty|Paws::GuardDuty> service. Use the attributes of this class
as arguments to method UpdateDetector.

You shouldn't make instances of this class. Each attribute should be used as a named argument in the call to UpdateDetector.

=head1 SYNOPSIS

    my $guardduty = Paws->service('GuardDuty');
    my $UpdateDetectorResponse = $guardduty->UpdateDetector(
      DetectorId => 'My__string',
      Enable     => 1,              # OPTIONAL
    );

Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.
For the AWS API documentation, see L<https://aws.amazon.com/documentation/>

=head1 ATTRIBUTES


=head2 B<REQUIRED> DetectorId => Str

The unique ID of the detector that you want to update.



=head2 Enable => Bool

Updated boolean value for the detector that specifies whether the
detector is enabled.




=head1 SEE ALSO

This class forms part of L<Paws>, documenting arguments for method UpdateDetector in L<Paws::GuardDuty>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

