
package Paws::Batch::DescribeJobDefinitions;
  use Moose;
  has JobDefinitionName => (is => 'ro', isa => 'Str');
  has JobDefinitions => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has MaxResults => (is => 'ro', isa => 'Int');
  has NextToken => (is => 'ro', isa => 'Str');
  has Status => (is => 'ro', isa => 'Str');

  use MooseX::ClassAttribute;

  class_has _api_call => (isa => 'Str', is => 'ro', default => 'DescribeJobDefinitions');
  class_has _api_uri  => (isa => 'Str', is => 'ro', default => '/v1/describejobdefinitions');
  class_has _api_method  => (isa => 'Str', is => 'ro', default => 'POST');
  class_has _returns => (isa => 'Str', is => 'ro', default => 'Paws::Batch::DescribeJobDefinitionsResponse');
  class_has _result_key => (isa => 'Str', is => 'ro');
1;

### main pod documentation begin ###

=head1 NAME

Paws::Batch::DescribeJobDefinitions - Arguments for method DescribeJobDefinitions on Paws::Batch

=head1 DESCRIPTION

This class represents the parameters used for calling the method DescribeJobDefinitions on the 
AWS Batch service. Use the attributes of this class
as arguments to method DescribeJobDefinitions.

You shouldn't make instances of this class. Each attribute should be used as a named argument in the call to DescribeJobDefinitions.

As an example:

  $service_obj->DescribeJobDefinitions(Att1 => $value1, Att2 => $value2, ...);

Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.

=head1 ATTRIBUTES


=head2 JobDefinitionName => Str

The name of the job definition to describe.



=head2 JobDefinitions => ArrayRef[Str|Undef]

A space-separated list of up to 100 job definition names or full Amazon
Resource Name (ARN) entries.



=head2 MaxResults => Int

The maximum number of results returned by C<DescribeJobDefinitions> in
paginated output. When this parameter is used,
C<DescribeJobDefinitions> only returns C<maxResults> results in a
single page along with a C<nextToken> response element. The remaining
results of the initial request can be seen by sending another
C<DescribeJobDefinitions> request with the returned C<nextToken> value.
This value can be between 1 and 100. If this parameter is not used,
then C<DescribeJobDefinitions> returns up to 100 results and a
C<nextToken> value if applicable.



=head2 NextToken => Str

The C<nextToken> value returned from a previous paginated
C<DescribeJobDefinitions> request where C<maxResults> was used and the
results exceeded the value of that parameter. Pagination continues from
the end of the previous results that returned the C<nextToken> value.
This value is C<null> when there are no more results to return.

This token should be treated as an opaque identifier that is only used
to retrieve the next items in a list and not for other programmatic
purposes.



=head2 Status => Str

The status with which to filter job definitions.




=head1 SEE ALSO

This class forms part of L<Paws>, documenting arguments for method DescribeJobDefinitions in L<Paws::Batch>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: https://github.com/pplu/aws-sdk-perl

Please report bugs to: https://github.com/pplu/aws-sdk-perl/issues

=cut

