use Moose::Util::TypeConstraints;

coerce 'Cfn::Resource::Properties::AWS::IAM::UserToGroupAddition',
  from 'HashRef',
   via { Cfn::Resource::Properties::AWS::IAM::UserToGroupAddition->new( %$_ ) };

package Cfn::Resource::AWS::IAM::UserToGroupAddition {
  use Moose;
  extends 'Cfn::Resource';
  has Properties => (isa => 'Cfn::Resource::Properties::AWS::IAM::UserToGroupAddition', is => 'rw', coerce => 1, required => 1);
}

package Cfn::Resource::Properties::AWS::IAM::UserToGroupAddition  {
  use Moose;
  use MooseX::StrictConstructor;
  extends 'Cfn::Resource::Properties';
  has GroupName => (isa => 'Cfn::Value', is => 'rw', coerce => 1, required => 1);
  has Users => (isa => 'Cfn::Value::Array|Cfn::Value::Function', is => 'rw', coerce => 1, required => 1);
}

1;
