package Locale::CLDR::Fa;
# This file auto generated from Data\common\main\fa.xml
#	on Tue 19 Jan 10:23:36 pm GMT
# XML file generated 2014-03-05 23:14:25 -0600 (Wed, 05 Mar 2014)

use version;

our $VERSION = version->declare('v0.25.5');

use v5.10;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';

use Moose;

extends('Locale::CLDR::Root');
has 'valid_algorithmic_formats' => (
	is => 'ro',
	isa => 'ArrayRef',
	init_arg => undef,
	default => sub {[ 'spellout-numbering-year','spellout-numbering','spellout-cardinal' ]},
);

has 'algorithmic_number_format_data' => (
	is => 'ro',
	isa => 'HashRef',
	init_arg => undef,
	default => sub { 
		use bignum;
		return {
		'spellout-cardinal' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(منفی →→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(صفر),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(←← ممیز →→),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(یک),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(دو),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(سه),
				},
				'4' => {
					base_value => q(4),
					divisor => q(1),
					rule => q(چهار),
				},
				'5' => {
					base_value => q(5),
					divisor => q(1),
					rule => q(پنج),
				},
				'6' => {
					base_value => q(6),
					divisor => q(1),
					rule => q(شش),
				},
				'7' => {
					base_value => q(7),
					divisor => q(1),
					rule => q(هفت),
				},
				'8' => {
					base_value => q(8),
					divisor => q(1),
					rule => q(هشت),
				},
				'9' => {
					base_value => q(9),
					divisor => q(1),
					rule => q(نه),
				},
				'10' => {
					base_value => q(10),
					divisor => q(10),
					rule => q(ده),
				},
				'11' => {
					base_value => q(11),
					divisor => q(10),
					rule => q(یازده),
				},
				'12' => {
					base_value => q(12),
					divisor => q(10),
					rule => q(دوازده),
				},
				'13' => {
					base_value => q(13),
					divisor => q(10),
					rule => q(سیزده),
				},
				'14' => {
					base_value => q(14),
					divisor => q(10),
					rule => q(چهارده),
				},
				'15' => {
					base_value => q(15),
					divisor => q(10),
					rule => q(پانزده),
				},
				'16' => {
					base_value => q(16),
					divisor => q(10),
					rule => q(شانزده),
				},
				'17' => {
					base_value => q(17),
					divisor => q(10),
					rule => q(هفده),
				},
				'18' => {
					base_value => q(18),
					divisor => q(10),
					rule => q(هجده),
				},
				'19' => {
					base_value => q(19),
					divisor => q(10),
					rule => q(نوزده),
				},
				'20' => {
					base_value => q(20),
					divisor => q(10),
					rule => q(بیست[ و →→]),
				},
				'30' => {
					base_value => q(30),
					divisor => q(10),
					rule => q(سی[ و →→]),
				},
				'40' => {
					base_value => q(40),
					divisor => q(10),
					rule => q(چهل[ و →→]),
				},
				'50' => {
					base_value => q(50),
					divisor => q(10),
					rule => q(پنجاه[ و →→]),
				},
				'60' => {
					base_value => q(60),
					divisor => q(10),
					rule => q(شصت[ و →→]),
				},
				'70' => {
					base_value => q(70),
					divisor => q(10),
					rule => q(هفتاد[ و →→]),
				},
				'80' => {
					base_value => q(80),
					divisor => q(10),
					rule => q(هشتاد[ و →→]),
				},
				'90' => {
					base_value => q(90),
					divisor => q(10),
					rule => q(نود[ و →→]),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(صد[ و →→]),
				},
				'200' => {
					base_value => q(200),
					divisor => q(100),
					rule => q(دویست[ و →→]),
				},
				'300' => {
					base_value => q(300),
					divisor => q(100),
					rule => q(سیصد[ و →→]),
				},
				'400' => {
					base_value => q(400),
					divisor => q(100),
					rule => q(چهارصد[ و →→]),
				},
				'500' => {
					base_value => q(500),
					divisor => q(100),
					rule => q(پانصد[ و →→]),
				},
				'600' => {
					base_value => q(600),
					divisor => q(100),
					rule => q(ششصد[ و →→]),
				},
				'700' => {
					base_value => q(700),
					divisor => q(100),
					rule => q(هفتصد[ و →→]),
				},
				'800' => {
					base_value => q(800),
					divisor => q(100),
					rule => q(هشتصد[ و →→]),
				},
				'900' => {
					base_value => q(900),
					divisor => q(100),
					rule => q(نهصد[ و →→]),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(←← هزار[ و →→]),
				},
				'1000000' => {
					base_value => q(1000000),
					divisor => q(1000000),
					rule => q(←← میلیون[ و →→]),
				},
				'1000000000' => {
					base_value => q(1000000000),
					divisor => q(1000000000),
					rule => q(←← میلیارد[ و →→]),
				},
				'1000000000000' => {
					base_value => q(1000000000000),
					divisor => q(1000000000000),
					rule => q(←← هزار میلیارد[ و →→]),
				},
				'1000000000000000000' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
				'max' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
			},
		},
		'spellout-numbering' => {
			'public' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-cardinal=),
				},
				'max' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-cardinal=),
				},
			},
		},
		'spellout-numbering-year' => {
			'public' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-numbering=),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(=#,###0.#=),
				},
				'max' => {
					divisor => q(1),
					rule => q(=#,###0.#=),
				},
			},
		},
	} },
);

# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $territory, $script, $variant) = @_;

	my $display_pattern = '{0} ({1})';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0}، {1}', grep {$_} (
		$territory,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub { 
		 sub {
			 my %languages = (
				'aa' => 'آفاری',
 				'ab' => 'آبخازی',
 				'ace' => 'آچئی',
 				'ach' => 'آچولیایی',
 				'ada' => 'آدانگمه‌ای',
 				'ady' => 'آدیجیایی',
 				'ae' => 'اوستایی',
 				'af' => 'آفریکانس',
 				'afh' => 'آفریهیلی',
 				'ain' => 'آینویی',
 				'ak' => 'آکان',
 				'akk' => 'آکدی',
 				'ale' => 'آلئوتی',
 				'alt' => 'آلتایی جنوبی',
 				'am' => 'امهری',
 				'an' => 'آراگونی',
 				'ang' => 'انگلیسی باستان',
 				'anp' => 'آنگیکا',
 				'ar' => 'عربی',
 				'ar_001' => 'عربی رسمی',
 				'arc' => 'آرامی',
 				'arn' => 'آروکانیایی',
 				'arp' => 'آراپاهویی',
 				'arw' => 'آراواکی',
 				'as' => 'آسامی',
 				'av' => 'آواری',
 				'ay' => 'آیمارایی',
 				'az' => 'ترکی آذربایجانی',
 				'az@alt=short' => 'آذری',
 				'az@alt=variant' => 'آذربایجانی',
 				'ba' => 'باشغیری',
 				'bal' => 'بلوچی',
 				'ban' => 'بالیایی',
 				'bas' => 'باسایی',
 				'bax' => 'بمونی',
 				'be' => 'بلوروسی',
 				'bej' => 'بجایی',
 				'bem' => 'بمبایی',
 				'bg' => 'بلغاری',
 				'bho' => 'بوجپوری',
 				'bi' => 'بیسلاما',
 				'bik' => 'بیکولی',
 				'bin' => 'بینی',
 				'bm' => 'بامبارایی',
 				'bn' => 'بنگالی',
 				'bo' => 'تبتی',
 				'br' => 'برتانیایی',
 				'bra' => 'براج',
 				'bs' => 'بوسنیایی',
 				'bua' => 'بوریاتی',
 				'bug' => 'بوگیایی',
 				'byn' => 'بلین',
 				'ca' => 'کاتالان',
 				'cad' => 'کادویی',
 				'car' => 'کاریبی',
 				'ce' => 'چچنی',
 				'ceb' => 'سبویی',
 				'ch' => 'چامورویی',
 				'chb' => 'چیبچا',
 				'chg' => 'جغتایی',
 				'chk' => 'چوکی',
 				'chm' => 'ماریایی',
 				'cho' => 'چوکتویی',
 				'chp' => 'چیپه‌ویه‌ای',
 				'chr' => 'چروکیایی',
 				'chy' => 'شایانی',
 				'ckb' => 'کردی سورانی',
 				'co' => 'کورسی',
 				'cop' => 'قبطی',
 				'cr' => 'کریایی',
 				'crh' => 'ترکی کریمه',
 				'cs' => 'چکی',
 				'csb' => 'کاشوبی',
 				'cu' => 'اسلاوی کلیسایی',
 				'cv' => 'چوواشی',
 				'cy' => 'ویلزی',
 				'da' => 'دانمارکی',
 				'dak' => 'داکوتایی',
 				'dar' => 'دارقینی',
 				'de' => 'آلمانی',
 				'de_AT' => 'آلمانی اتریش',
 				'de_CH' => 'آلمانی علیای سوئیس',
 				'del' => 'دلاواری',
 				'dgr' => 'دوگریب',
 				'din' => 'دینکایی',
 				'doi' => 'دوگری',
 				'dsb' => 'صُربی سفلی',
 				'dua' => 'دوآلایی',
 				'dum' => 'هلندی میانه',
 				'dv' => 'مالدیوی',
 				'dyu' => 'دایولایی',
 				'dz' => 'جونخایی',
 				'ee' => 'اوه‌ای',
 				'efi' => 'افیکی',
 				'egy' => 'مصری کهن',
 				'eka' => 'اکاجوک',
 				'el' => 'یونانی',
 				'elx' => 'عیلامی',
 				'en' => 'انگلیسی',
 				'en_AU' => 'انگلیسی استرالیا',
 				'en_CA' => 'انگلیسی کانادا',
 				'en_GB' => 'انگلیسی بریتانیا',
 				'en_US' => 'انگلیسی امریکا',
 				'en_US@alt=short' => 'انگلیسی (US)',
 				'enm' => 'انگلیسی میانه',
 				'eo' => 'اسپرانتو',
 				'es' => 'اسپانیایی',
 				'es_419' => 'اسپانیایی امریکای لاتین',
 				'es_ES' => 'اسپانیایی اروپا',
 				'es_MX' => 'اسپانیایی مکزیک',
 				'et' => 'استونیایی',
 				'eu' => 'باسکی',
 				'ewo' => 'اواندو',
 				'fa' => 'فارسی',
 				'fan' => 'فانکی',
 				'fat' => 'فانتیایی',
 				'ff' => 'فولایی',
 				'fi' => 'فنلاندی',
 				'fil' => 'فیلیپینی',
 				'fj' => 'فیجیایی',
 				'fo' => 'فارویی',
 				'fon' => 'فونی',
 				'fr' => 'فرانسوی',
 				'fr_CA' => 'فرانسوی کانادا',
 				'fr_CH' => 'فرانسوی سوئیس',
 				'frm' => 'فرانسوی میانه',
 				'fro' => 'فرانسوی باستان',
 				'frr' => 'فریزی شمالی',
 				'frs' => 'فریزی شرقی',
 				'fur' => 'فریولیایی',
 				'fy' => 'فریزی غربی',
 				'ga' => 'ایرلندی',
 				'gaa' => 'گایی',
 				'gay' => 'گایویی',
 				'gba' => 'گبایایی',
 				'gd' => 'گیلی اسکاتلندی',
 				'gez' => 'گی‌ئزی',
 				'gil' => 'گیلبرتی',
 				'gl' => 'گالیسیایی',
 				'gmh' => 'آلمانی علیای میانه',
 				'gn' => 'گوارانی',
 				'goh' => 'آلمانی علیای باستان',
 				'gon' => 'گوندی',
 				'gor' => 'گورونتالو',
 				'got' => 'گوتی',
 				'grb' => 'گریبویی',
 				'grc' => 'یونانی کهن',
 				'gsw' => 'آلمانی سوئیسی',
 				'gu' => 'گجراتی',
 				'gv' => 'مانی',
 				'gwi' => 'گویچ این',
 				'ha' => 'هوسیایی',
 				'hai' => 'هایدایی',
 				'haw' => 'هاوائیایی',
 				'he' => 'عبری',
 				'hi' => 'هندی',
 				'hil' => 'هیلی‌گاینونی',
 				'hit' => 'هیتی',
 				'hmn' => 'همونگ',
 				'ho' => 'موتویی هیری',
 				'hr' => 'کروات',
 				'hsb' => 'صُربی علیا',
 				'ht' => 'هائیتیایی',
 				'hu' => 'مجاری',
 				'hup' => 'هوپا',
 				'hy' => 'ارمنی',
 				'hz' => 'هریرویی',
 				'ia' => 'میان‌زبان',
 				'iba' => 'آیبن',
 				'id' => 'اندونزیایی',
 				'ie' => 'اکسیدنتال',
 				'ig' => 'ایگبویی',
 				'ii' => 'یی سیچوان',
 				'ik' => 'اینوپیک',
 				'ilo' => 'ایلوکویی',
 				'inh' => 'اینگوشی',
 				'io' => 'ایدو',
 				'is' => 'ایسلندی',
 				'it' => 'ایتالیایی',
 				'iu' => 'اینوکتیتوت',
 				'ja' => 'ژاپنی',
 				'jbo' => 'لوجبان',
 				'jpr' => 'فارسی یهودی',
 				'jrb' => 'عربی یهودی',
 				'jv' => 'جاوه‌ای',
 				'ka' => 'گرجی',
 				'kaa' => 'قره‌قالپاقی',
 				'kab' => 'قبایلی',
 				'kac' => 'کاچینی',
 				'kaj' => 'جو',
 				'kam' => 'کامبایی',
 				'kaw' => 'کاویایی',
 				'kbd' => 'کاباردینی',
 				'kcg' => 'تایپه ای',
 				'kfo' => 'کورو',
 				'kg' => 'کنگویی',
 				'kha' => 'خاسیایی',
 				'kho' => 'ختنی',
 				'ki' => 'کیکویویی',
 				'kj' => 'کوانیاما',
 				'kk' => 'قزاقی',
 				'kl' => 'گرینلندی',
 				'km' => 'خمری',
 				'kmb' => 'کیمبوندویی',
 				'kn' => 'کاناده‌ای',
 				'ko' => 'کره‌ای',
 				'kok' => 'کنکانی',
 				'kpe' => 'کپله‌ای',
 				'kr' => 'کانوریایی',
 				'krc' => 'قره‌چایی‐بالکاری',
 				'kru' => 'کوروخی',
 				'ks' => 'کشمیری',
 				'ku' => 'کردی',
 				'kum' => 'کومیکی',
 				'kut' => 'کوتنی',
 				'kv' => 'کومیایی',
 				'kw' => 'کرنوالی',
 				'ky' => 'قرقیزی',
 				'la' => 'لاتینی',
 				'lad' => 'لادینو',
 				'lah' => 'لاهندا',
 				'lam' => 'لامبا',
 				'lb' => 'لوگزامبورگی',
 				'lez' => 'لزگی',
 				'lg' => 'گاندایی',
 				'li' => 'لیمبورگی',
 				'ln' => 'لینگالا',
 				'lo' => 'لائوسی',
 				'lol' => 'مونگویی',
 				'loz' => 'لوزیایی',
 				'lt' => 'لیتوانیایی',
 				'lu' => 'لوبایی‐کاتانگا',
 				'lua' => 'لوبایی‐لولوا',
 				'lui' => 'لویسنو',
 				'lun' => 'لوندایی',
 				'luo' => 'لوئویی',
 				'lus' => 'لوشه‌ای',
 				'lv' => 'لتونیایی',
 				'mad' => 'مادورایی',
 				'mag' => 'ماگاهیایی',
 				'mai' => 'مایدیلی',
 				'mak' => 'ماکاسار',
 				'man' => 'ماندینگویی',
 				'mas' => 'ماسایی',
 				'mdf' => 'مکشایی',
 				'mdr' => 'ماندار',
 				'men' => 'منده‌ای',
 				'mfe' => 'موریسین',
 				'mg' => 'مالاگاسیایی',
 				'mga' => 'ایرلندی میانه',
 				'mh' => 'مارشالی',
 				'mi' => 'مائوریایی',
 				'mic' => 'میکماکی',
 				'min' => 'مینانگ‌کابویی',
 				'mk' => 'مقدونی',
 				'ml' => 'مالایالامی',
 				'mn' => 'مغولی',
 				'mnc' => 'مانچویی',
 				'mni' => 'میته‌ای',
 				'moh' => 'موهاکی',
 				'mos' => 'ماسیایی',
 				'mr' => 'مراتی',
 				'ms' => 'مالایی',
 				'mt' => 'مالتی',
 				'mul' => 'چندین زبان',
 				'mus' => 'کریکی',
 				'mwr' => 'مارواری',
 				'my' => 'برمه‌ای',
 				'myv' => 'ارزیایی',
 				'na' => 'نائورویی',
 				'nap' => 'ناپلی',
 				'nb' => 'بوکسمال نروژی',
 				'nd' => 'انده‌بله‌ای شمالی',
 				'nds' => 'آلمانی سفلی',
 				'ne' => 'نپالی',
 				'new' => 'نواریایی',
 				'ng' => 'اندونگایی',
 				'nia' => 'نیاسی',
 				'niu' => 'نیویی',
 				'nl' => 'هلندی',
 				'nl_BE' => 'فلمنگی',
 				'nn' => 'نرس جدید نروژی',
 				'no' => 'نروژی',
 				'nog' => 'نغایی',
 				'non' => 'نرس باستان',
 				'nr' => 'انده‌بله‌ای جنوبی',
 				'nso' => 'سوتویی شمالی',
 				'nv' => 'ناواهویی',
 				'nwc' => 'نواریایی کلاسیک',
 				'ny' => 'نیانجایی',
 				'nym' => 'نیام‌وزیایی',
 				'nyn' => 'نیانکوله‌ای',
 				'nyo' => 'نیورویی',
 				'nzi' => 'نزیمایی',
 				'oc' => 'اوکیتایی',
 				'oj' => 'اوجیبوایی',
 				'om' => 'اورومویی',
 				'or' => 'اوریه‌ای',
 				'os' => 'آسی',
 				'osa' => 'اوسیجی',
 				'ota' => 'ترکی عثمانی',
 				'pa' => 'پنجابی',
 				'pag' => 'پانگاسینانی',
 				'pal' => 'پهلوی',
 				'pam' => 'پامپانگایی',
 				'pap' => 'پاپیامنتو',
 				'pau' => 'پالائویی',
 				'peo' => 'فارسی باستان',
 				'phn' => 'فنیقی',
 				'pi' => 'پالی',
 				'pl' => 'لهستانی',
 				'pon' => 'پانپیی',
 				'pro' => 'پرووانسی باستان',
 				'ps' => 'پشتو',
 				'ps@alt=variant' => 'پختو',
 				'pt' => 'پرتغالی',
 				'pt_BR' => 'پرتغالی برزیل',
 				'pt_PT' => 'پرتغالی اروپا',
 				'qu' => 'کچوایی',
 				'raj' => 'راجستانی',
 				'rap' => 'راپانویی',
 				'rar' => 'راروتونگایی',
 				'rm' => 'رومانش',
 				'rn' => 'روندیایی',
 				'ro' => 'رومانیایی',
 				'ro_MD' => 'مولداویایی',
 				'rom' => 'رومانویی',
 				'root' => 'ریشه',
 				'ru' => 'روسی',
 				'rw' => 'کینیارواندایی',
 				'sa' => 'سنسکریت',
 				'sad' => 'سانداوه‌ای',
 				'sah' => 'یاقوتی',
 				'sam' => 'آرامی سامری',
 				'sas' => 'ساساکی',
 				'sat' => 'سانتالی',
 				'sc' => 'ساردینیایی',
 				'scn' => 'سیسیلی',
 				'sco' => 'اسکاتلندی',
 				'sd' => 'سندی',
 				'se' => 'سامی شمالی',
 				'sel' => 'سلکوپی',
 				'sg' => 'سانگویی',
 				'sga' => 'ایرلندی باستان',
 				'sh' => 'صرب و کرواتی',
 				'shn' => 'شانی',
 				'shu' => 'عربی چادی',
 				'si' => 'سینهالی',
 				'sid' => 'سیدامویی',
 				'sk' => 'اسلواکی',
 				'sl' => 'اسلووینیایی',
 				'sm' => 'ساموآیی',
 				'sn' => 'شونایی',
 				'snk' => 'سونینکه‌ای',
 				'so' => 'سومالیایی',
 				'sog' => 'سغدی',
 				'sq' => 'آلبانیایی',
 				'sr' => 'صربی',
 				'srn' => 'تاکی‌تاکی',
 				'srr' => 'سریری',
 				'ss' => 'سوازیایی',
 				'st' => 'سوتویی جنوبی',
 				'su' => 'سوندایی',
 				'suk' => 'سوکومایی',
 				'sus' => 'سوسویی',
 				'sux' => 'سومری',
 				'sv' => 'سوئدی',
 				'sw' => 'سواحلی',
 				'swb' => 'کوموری',
 				'swc' => 'سواحلی کنگویی',
 				'syc' => 'سریانی کلاسیک',
 				'syr' => 'سریانی',
 				'ta' => 'تامیلی',
 				'te' => 'تلوگویی',
 				'tem' => 'تمنه‌ای',
 				'ter' => 'ترنو',
 				'tet' => 'تتومی',
 				'tg' => 'تاجیکی',
 				'th' => 'تایلندی',
 				'ti' => 'تیگرینیایی',
 				'tig' => 'تیگره‌ای',
 				'tiv' => 'تیوی',
 				'tk' => 'ترکمنی',
 				'tl' => 'تاگالوگی',
 				'tlh' => 'کلینگون',
 				'tli' => 'تلین‌گیتی',
 				'tmh' => 'تاماشقی',
 				'tn' => 'تسوانایی',
 				'to' => 'تونگایی',
 				'tog' => 'تونگایی نیاسا',
 				'tpi' => 'توک‌پیسینی',
 				'tr' => 'ترکی استانبولی',
 				'tr@alt=secondary' => 'ترکی',
 				'ts' => 'تسونگایی',
 				'tsi' => 'تسیم‌شیانی',
 				'tt' => 'تاتاری',
 				'tum' => 'تومبوکایی',
 				'tvl' => 'تووالویی',
 				'tw' => 'توی‌یایی',
 				'ty' => 'تاهیتیایی',
 				'tyv' => 'تووایی',
 				'udm' => 'اودمورتی',
 				'ug' => 'اویغوری',
 				'uga' => 'اوگاریتی',
 				'uk' => 'اوکراینی',
 				'umb' => 'امبوندویی',
 				'und' => 'زبان نامشخص',
 				'ur' => 'اردو',
 				'uz' => 'ازبکی',
 				'vai' => 'ویایی',
 				've' => 'وندایی',
 				'vi' => 'ویتنامی',
 				'vo' => 'ولاپوک',
 				'vot' => 'وتی',
 				'wa' => 'والونی',
 				'wal' => 'والامو',
 				'war' => 'وارایی',
 				'was' => 'واشویی',
 				'wo' => 'ولوفی',
 				'xal' => 'قلموقی',
 				'xh' => 'خوسایی',
 				'yao' => 'یائویی',
 				'yap' => 'یاپی',
 				'yi' => 'یدی',
 				'yo' => 'یوروبایی',
 				'yue' => 'کانتونیز',
 				'za' => 'چوانگی',
 				'zap' => 'زاپوتکی',
 				'zen' => 'زناگا',
 				'zgh' => 'آمازیغی معیار مراکش',
 				'zh' => 'چینی',
 				'zh_Hans' => 'چینی ساده‌شده',
 				'zh_Hant' => 'چینی سنتی',
 				'zu' => 'زولویی',
 				'zun' => 'زونیایی',
 				'zxx' => 'بدون محتوای زبانی',
 				'zza' => 'زازایی',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Arab' => 'عربی',
 			'Arab@alt=variant' => 'فارسی-عربی',
 			'Armi' => 'آرامی هخامنشی',
 			'Armn' => 'ارمنی',
 			'Avst' => 'اوستایی',
 			'Bali' => 'بالیایی',
 			'Batk' => 'باتاکی',
 			'Beng' => 'بنگالی',
 			'Blis' => 'نمادهای بلیس',
 			'Bopo' => 'بوپوموفو',
 			'Brah' => 'براهمی',
 			'Brai' => 'بریل',
 			'Bugi' => 'بوگیایی',
 			'Buhd' => 'بوهید',
 			'Cakm' => 'کاکم',
 			'Cari' => 'کاری',
 			'Cham' => 'چمی',
 			'Cher' => 'چروکیایی',
 			'Cirt' => 'کرت',
 			'Copt' => 'قبطی',
 			'Cprt' => 'قبرسی',
 			'Cyrl' => 'سیریلی',
 			'Deva' => 'دوناگری',
 			'Dsrt' => 'دیسرتی',
 			'Egyh' => 'کاهنی مصری',
 			'Egyp' => 'هیروگلیف مصری',
 			'Ethi' => 'اتیوپیایی',
 			'Geok' => 'گرجی خوتسوری',
 			'Geor' => 'گرجی',
 			'Glag' => 'گلاگولیتیک',
 			'Goth' => 'گوتیک',
 			'Grek' => 'یونانی',
 			'Gujr' => 'گجراتی',
 			'Guru' => 'گورومخی',
 			'Hang' => 'هانگول',
 			'Hani' => 'هان',
 			'Hano' => 'هانونویی',
 			'Hans' => 'ساده‌شده',
 			'Hans@alt=stand-alone' => 'هان ساده‌شده',
 			'Hant' => 'سنتی',
 			'Hant@alt=stand-alone' => 'هان سنتی',
 			'Hebr' => 'عبری',
 			'Hira' => 'هیراگانا',
 			'Hluw' => 'هیروگلیف‌های آناتولی',
 			'Hrkt' => 'سیلابی‌های ژاپنی',
 			'Hung' => 'مجاری باستان',
 			'Inds' => 'ایندوس',
 			'Ital' => 'ایتالی باستان',
 			'Java' => 'جاوه‌ای',
 			'Jpan' => 'ژاپنی',
 			'Kali' => 'کایالی',
 			'Kana' => 'کاتاکانا',
 			'Khmr' => 'خمری',
 			'Khoj' => 'خواجکی',
 			'Knda' => 'کاناده‌ای',
 			'Kore' => 'کره‌ای',
 			'Kthi' => 'کثی',
 			'Lana' => 'لانایی',
 			'Laoo' => 'لائوسی',
 			'Latf' => 'لاتینی فراکتور',
 			'Latg' => 'لاتینی گیلی',
 			'Latn' => 'لاتینی',
 			'Limb' => 'لیمبایی',
 			'Lina' => 'خطی الف',
 			'Linb' => 'خطی ب',
 			'Lyci' => 'لسیایی',
 			'Lydi' => 'لدیایی',
 			'Mand' => 'منده‌ای',
 			'Mani' => 'مانوی',
 			'Maya' => 'هیروگلیف مایایی',
 			'Mero' => 'مروییتی',
 			'Mlym' => 'مالایالامی',
 			'Mong' => 'مغولی',
 			'Moon' => 'مونی',
 			'Mtei' => 'مایک میتی',
 			'Mymr' => 'میانمار',
 			'Narb' => 'عربی شمالی باستان',
 			'Nbat' => 'نبطی',
 			'Ogam' => 'اوگامی',
 			'Orkh' => 'اورخونی',
 			'Orya' => 'اوریه‌ای',
 			'Palm' => 'پالمیرایی',
 			'Perm' => 'پرمی باستان',
 			'Phli' => 'پهلوی کتیبه‌ای',
 			'Phlp' => 'پهلوی زبوری',
 			'Phlv' => 'پهلوی کتابی',
 			'Phnx' => 'فنیقی',
 			'Prti' => 'پارتی کتیبه‌ای',
 			'Rjng' => 'رجنگی',
 			'Runr' => 'رونی',
 			'Samr' => 'سامری',
 			'Sara' => 'ساراتی',
 			'Sarb' => 'عربی جنوبی باستان',
 			'Saur' => 'سوراشترایی',
 			'Shaw' => 'شاوی',
 			'Sinh' => 'سینهالی',
 			'Sylo' => 'سیلوتی نگاری',
 			'Syrc' => 'سریانی',
 			'Syre' => 'سریانی سطرنجیلی',
 			'Syrj' => 'سریانی غربی',
 			'Syrn' => 'سریانی شرقی',
 			'Tagb' => 'تگبنوایی',
 			'Taml' => 'تامیلی',
 			'Telu' => 'تلوگویی',
 			'Teng' => 'تنگوار',
 			'Tfng' => 'تیفیناغی',
 			'Tglg' => 'تاگالوگی',
 			'Thaa' => 'تانه‌ای',
 			'Thai' => 'تایلندی',
 			'Tibt' => 'تبتی',
 			'Ugar' => 'اوگاریتی',
 			'Vaii' => 'ویایی',
 			'Visp' => 'گفتار قابل مشاهده',
 			'Xpeo' => 'فارسی باستان',
 			'Xsux' => 'میخی سومری‐آکدی',
 			'Yiii' => 'یی',
 			'Zinh' => 'موروثی',
 			'Zmth' => 'علائم ریاضی',
 			'Zsym' => 'علائم',
 			'Zxxx' => 'نانوشته',
 			'Zyyy' => 'مشترک',
 			'Zzzz' => 'خط نامشخص',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_territory' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'001' => 'جهان',
 			'002' => 'افریقا',
 			'003' => 'امریکای شمالی',
 			'005' => 'امریکای جنوبی',
 			'009' => 'اقیانوسیه',
 			'011' => 'غرب افریقا',
 			'013' => 'امریکای مرکزی',
 			'014' => 'شرق افریقا',
 			'015' => 'شمال افریقا',
 			'017' => 'مرکز افریقا',
 			'018' => 'جنوب افریقا',
 			'019' => 'امریکا',
 			'021' => 'شمال امریکا',
 			'029' => 'کارائیب',
 			'030' => 'شرق آسیا',
 			'034' => 'جنوب آسیا',
 			'035' => 'جنوب شرق آسیا',
 			'039' => 'جنوب اروپا',
 			'053' => 'استرالزی',
 			'054' => 'ملانزی',
 			'057' => 'ناحیهٔ میکرونزی',
 			'061' => 'پلی‌نزی',
 			'142' => 'آسیا',
 			'143' => 'آسیای مرکزی',
 			'145' => 'غرب آسیا',
 			'150' => 'اروپا',
 			'151' => 'شرق اروپا',
 			'154' => 'شمال اروپا',
 			'155' => 'غرب اروپا',
 			'419' => 'امریکای لاتین',
 			'AC' => 'جزایر آسنسیون',
 			'AD' => 'آندورا',
 			'AE' => 'امارات متحدهٔ عربی',
 			'AF' => 'افغانستان',
 			'AG' => 'آنتیگوا و باربودا',
 			'AI' => 'آنگویلا',
 			'AL' => 'آلبانی',
 			'AM' => 'ارمنستان',
 			'AN' => 'آنتیل هلند',
 			'AO' => 'آنگولا',
 			'AQ' => 'جنوبگان',
 			'AR' => 'آرژانتین',
 			'AS' => 'ساموآی آمریکا',
 			'AT' => 'اتریش',
 			'AU' => 'استرالیا',
 			'AW' => 'آروبا',
 			'AX' => 'جزایر اُلند',
 			'AZ' => 'جمهوری آذربایجان',
 			'BA' => 'بوسنی و هرزگوین',
 			'BB' => 'باربادوس',
 			'BD' => 'بنگلادش',
 			'BE' => 'بلژیک',
 			'BF' => 'بورکینافاسو',
 			'BG' => 'بلغارستان',
 			'BH' => 'بحرین',
 			'BI' => 'بوروندی',
 			'BJ' => 'بنین',
 			'BL' => 'سن بارتلمی',
 			'BM' => 'برمودا',
 			'BN' => 'برونئی',
 			'BO' => 'بولیوی',
 			'BQ' => 'جزایر کارائیب هلند',
 			'BR' => 'برزیل',
 			'BS' => 'باهاما',
 			'BT' => 'بوتان',
 			'BV' => 'جزیره بووه',
 			'BW' => 'بوتسوانا',
 			'BY' => 'بلاروس',
 			'BZ' => 'بلیز',
 			'CA' => 'کانادا',
 			'CC' => 'جزایر کوکوس (کیلینگ)',
 			'CD' => 'کنگو - کینشاسا',
 			'CD@alt=variant' => 'کنگو (جمهوری دموکراتیک)',
 			'CF' => 'جمهوری افریقای مرکزی',
 			'CG' => 'کنگو - برازویل',
 			'CG@alt=variant' => 'کنگو (جمهوری)',
 			'CH' => 'سوئیس',
 			'CI' => 'ساحل عاج',
 			'CK' => 'جزایر کوک',
 			'CL' => 'شیلی',
 			'CM' => 'کامرون',
 			'CN' => 'چین',
 			'CO' => 'کلمبیا',
 			'CP' => 'جزایر کلیپرتون',
 			'CR' => 'کاستاریکا',
 			'CU' => 'کوبا',
 			'CV' => 'کیپ‌ورد',
 			'CW' => 'کوراسائو',
 			'CX' => 'جزیرهٔ کریسمس',
 			'CY' => 'قبرس',
 			'CZ' => 'جمهوری چک',
 			'DE' => 'آلمان',
 			'DG' => 'دیه‌گو گارسیا',
 			'DJ' => 'جیبوتی',
 			'DK' => 'دانمارک',
 			'DM' => 'دومینیکا',
 			'DO' => 'جمهوری دومینیکن',
 			'DZ' => 'الجزایر',
 			'EA' => 'سبته و ملیله',
 			'EC' => 'اکوادور',
 			'EE' => 'استونی',
 			'EG' => 'مصر',
 			'EH' => 'صحرای غربی',
 			'ER' => 'اریتره',
 			'ES' => 'اسپانیا',
 			'ET' => 'اتیوپی',
 			'EU' => 'اتحادیهٔ اروپا',
 			'FI' => 'فنلاند',
 			'FJ' => 'فیجی',
 			'FK' => 'جزایر فالکلند',
 			'FK@alt=variant' => 'جزایر فالکلند (ایسلاس مالویناس)',
 			'FM' => 'میکرونزی',
 			'FO' => 'جزایر فارو',
 			'FR' => 'فرانسه',
 			'GA' => 'گابن',
 			'GB' => 'بریتانیا',
 			'GD' => 'گرنادا',
 			'GE' => 'گرجستان',
 			'GF' => 'گویان فرانسه',
 			'GG' => 'گرنزی',
 			'GH' => 'غنا',
 			'GI' => 'جبل‌الطارق',
 			'GL' => 'گرینلند',
 			'GM' => 'گامبیا',
 			'GN' => 'گینه',
 			'GP' => 'گوادلوپ',
 			'GQ' => 'گینهٔ استوایی',
 			'GR' => 'یونان',
 			'GS' => 'جزایر جورجیای جنوبی و ساندویچ جنوبی',
 			'GT' => 'گواتمالا',
 			'GU' => 'گوام',
 			'GW' => 'گینهٔ بیسائو',
 			'GY' => 'گویان',
 			'HK' => 'هنگ‌کنگ، ناحیهٔ ویژهٔ حکومتی چین',
 			'HK@alt=short' => 'هنگ‌کنگ',
 			'HM' => 'جزیرهٔ هرد و جزایر مک‌دونالد',
 			'HN' => 'هندوراس',
 			'HR' => 'کرواسی',
 			'HT' => 'هائیتی',
 			'HU' => 'مجارستان',
 			'IC' => 'جزایر قناری',
 			'ID' => 'اندونزی',
 			'IE' => 'ایرلند',
 			'IL' => 'اسرائیل',
 			'IM' => 'جزیرهٔ من',
 			'IN' => 'هند',
 			'IO' => 'قلمرو بریتانیا در اقیانوس هند',
 			'IQ' => 'عراق',
 			'IR' => 'ایران',
 			'IS' => 'ایسلند',
 			'IT' => 'ایتالیا',
 			'JE' => 'جرزی',
 			'JM' => 'جامائیکا',
 			'JO' => 'اردن',
 			'JP' => 'ژاپن',
 			'KE' => 'کنیا',
 			'KG' => 'قرقیزستان',
 			'KH' => 'کامبوج',
 			'KI' => 'کیریباتی',
 			'KM' => 'کومور',
 			'KN' => 'سنت کیتس و نویس',
 			'KP' => 'کرهٔ شمالی',
 			'KR' => 'کرهٔ جنوبی',
 			'KW' => 'کویت',
 			'KY' => 'جزایر کِیمن',
 			'KZ' => 'قزاقستان',
 			'LA' => 'لائوس',
 			'LB' => 'لبنان',
 			'LC' => 'سنت لوسیا',
 			'LI' => 'لیختن‌اشتاین',
 			'LK' => 'سری‌لانکا',
 			'LR' => 'لیبریا',
 			'LS' => 'لسوتو',
 			'LT' => 'لیتوانی',
 			'LU' => 'لوکزامبورگ',
 			'LV' => 'لتونی',
 			'LY' => 'لیبی',
 			'MA' => 'مراکش',
 			'MC' => 'موناکو',
 			'MD' => 'مولداوی',
 			'ME' => 'مونته‌نگرو',
 			'MF' => 'سنت مارتین',
 			'MG' => 'ماداگاسکار',
 			'MH' => 'جزایر مارشال',
 			'MK' => 'مقدونیه',
 			'MK@alt=variant' => 'مقدونیه (جمهوری سابقاً یوگسلاو)',
 			'ML' => 'مالی',
 			'MM' => 'میانمار (برمه)',
 			'MN' => 'مغولستان',
 			'MO' => 'ماکائو، ناحیهٔ ویژهٔ حکومتی چین',
 			'MO@alt=short' => 'ماکائو',
 			'MP' => 'جزایر ماریانای شمالی',
 			'MQ' => 'مارتینیک',
 			'MR' => 'موریتانی',
 			'MS' => 'مونت‌سرات',
 			'MT' => 'مالت',
 			'MU' => 'موریس',
 			'MV' => 'مالدیو',
 			'MW' => 'مالاوی',
 			'MX' => 'مکزیک',
 			'MY' => 'مالزی',
 			'MZ' => 'موزامبیک',
 			'NA' => 'نامیبیا',
 			'NC' => 'کالدونیای جدید',
 			'NE' => 'نیجر',
 			'NF' => 'جزیره نورفک',
 			'NG' => 'نیجریه',
 			'NI' => 'نیکاراگوئه',
 			'NL' => 'هلند',
 			'NO' => 'نروژ',
 			'NP' => 'نپال',
 			'NR' => 'نائورو',
 			'NU' => 'نیوئه',
 			'NZ' => 'زلاند نو',
 			'OM' => 'عمان',
 			'PA' => 'پاناما',
 			'PE' => 'پرو',
 			'PF' => 'پلی‌نزی فرانسه',
 			'PG' => 'پاپوا گینهٔ نو',
 			'PH' => 'فیلیپین',
 			'PK' => 'پاکستان',
 			'PL' => 'لهستان',
 			'PM' => 'سن پیر و میکلن',
 			'PN' => 'جزایر پیت‌کرن',
 			'PR' => 'پورتوریکو',
 			'PS' => 'سرزمین‌های فلسطینی',
 			'PS@alt=short' => 'فلسطین',
 			'PT' => 'پرتغال',
 			'PW' => 'پالائو',
 			'PY' => 'پاراگوئه',
 			'QA' => 'قطر',
 			'QO' => 'بخش‌های دورافتادهٔ اقیانوسیه',
 			'RE' => 'رئونیون',
 			'RO' => 'رومانی',
 			'RS' => 'صربستان',
 			'RU' => 'روسیه',
 			'RW' => 'رواندا',
 			'SA' => 'عربستان سعودی',
 			'SA@alt=short' => 'عربستان',
 			'SB' => 'جزایر سلیمان',
 			'SC' => 'سیشل',
 			'SD' => 'سودان',
 			'SE' => 'سوئد',
 			'SG' => 'سنگاپور',
 			'SH' => 'سنت هلن',
 			'SI' => 'اسلوونی',
 			'SJ' => 'اسوالبارد و جان‌ماین',
 			'SK' => 'اسلواکی',
 			'SL' => 'سیرالئون',
 			'SM' => 'سن مارینو',
 			'SN' => 'سنگال',
 			'SO' => 'سومالی',
 			'SR' => 'سورینام',
 			'SS' => 'سودان جنوبی',
 			'ST' => 'سائوتومه و پرینسیپ',
 			'SV' => 'السالوادور',
 			'SX' => 'سنت مارتن',
 			'SY' => 'سوریه',
 			'SZ' => 'سوازیلند',
 			'TA' => 'تریستان دا کونا',
 			'TC' => 'جزایر تورکس و کایکوس',
 			'TD' => 'چاد',
 			'TF' => 'مستعمره‌های جنوبی فرانسه',
 			'TG' => 'توگو',
 			'TH' => 'تایلند',
 			'TJ' => 'تاجیکستان',
 			'TK' => 'توکلائو',
 			'TL' => 'تیمور شرقی',
 			'TM' => 'ترکمنستان',
 			'TN' => 'تونس',
 			'TO' => 'تونگا',
 			'TR' => 'ترکیه',
 			'TT' => 'ترینیداد و توباگو',
 			'TV' => 'تووالو',
 			'TW' => 'تایوان',
 			'TZ' => 'تانزانیا',
 			'UA' => 'اوکراین',
 			'UG' => 'اوگاندا',
 			'UM' => 'جزایر دورافتادهٔ ایالات متحده',
 			'US' => 'ایالات متحدهٔ امریکا',
 			'UY' => 'اروگوئه',
 			'UZ' => 'ازبکستان',
 			'VA' => 'واتیکان',
 			'VC' => 'سنت وینسنت و گرنادین‌ها',
 			'VE' => 'ونزوئلا',
 			'VG' => 'جزایر ویرجین بریتانیا',
 			'VI' => 'جزایر ویرجین ایالات متحده',
 			'VN' => 'ویتنام',
 			'VU' => 'وانواتو',
 			'WF' => 'والیس و فوتونا',
 			'WS' => 'ساموآ',
 			'XK' => 'کوزووو',
 			'YE' => 'یمن',
 			'YT' => 'مایوت',
 			'ZA' => 'افریقای جنوبی',
 			'ZM' => 'زامبیا',
 			'ZW' => 'زیمبابوه',
 			'ZZ' => 'ناحیهٔ نامشخص',

		}
	},
);

has 'display_name_variant' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'1901' => 'رسم‌الخط سنتی آلمانی',
 			'1996' => 'رسم‌الخط آلمانی ۱۹۹۶ میلادی',
 			'AREVELA' => 'ارمنی شرقی',
 			'AREVMDA' => 'ارمنی غربی',
 			'FONIPA' => 'فونتیک IPA',
 			'FONUPA' => 'فونتیک UPA',
 			'POSIX' => 'کامپیوتری',
 			'REVISED' => 'رسم‌الخط تجدیدنظرشده',
 			'SAAHO' => 'ساهویی',
 			'SCOTLAND' => 'انگلیسی معیار اسکاتلند',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'calendar' => 'تقویم',
 			'colalternate' => 'مرتب‌سازی با نادیده گرفتن نمادها',
 			'colbackwards' => 'مرتب‌سازی معکوس براساس آکسان',
 			'colcasefirst' => 'ترتیب بر اساس حروف کوچک/بزرگ',
 			'colcaselevel' => 'مرتب‌سازی حساس به اندازه حروف',
 			'colhiraganaquaternary' => 'سیستم مرتب‌سازی کانا',
 			'collation' => 'ترتیب',
 			'colnormalization' => 'مرتب‌سازی معمولی',
 			'colnumeric' => 'مرتب‌سازی عددی',
 			'colstrength' => 'قدرت مرتب‌سازی',
 			'currency' => 'واحد پول',
 			'numbers' => 'اعداد',
 			'timezone' => 'منطقه زمانی',
 			'va' => 'متغیر محلی',
 			'variabletop' => 'مرتب‌سازی به عنوان نماد',
 			'x' => 'استفادهٔ خصوصی',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[Str]]',
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{تقویم بودایی},
 				'chinese' => q{تقویم چینی},
 				'coptic' => q{تقویم قبطی},
 				'ethiopic' => q{تقویم اتیوپیایی},
 				'ethiopic-amete-alem' => q{تقویم اتیوپیایی عامت عالم},
 				'gregorian' => q{تقویم میلادی},
 				'hebrew' => q{تقویم عبری},
 				'indian' => q{تقویم ملی هند},
 				'islamic' => q{تقویم هجری قمری},
 				'islamic-civil' => q{تقویم هجری قمری جدولی مدنی},
 				'islamic-tbla' => q{تقویم هجری قمری جدولی نجومی},
 				'japanese' => q{تقویم ژاپنی},
 				'persian' => q{تقویم هجری شمسی},
 				'roc' => q{تقویم جمهوری چین (تایوان)},
 			},
 			'colalternate' => {
 				'non-ignorable' => q{مرتب‌سازی نمادها},
 				'shifted' => q{مرتب‌سازی با نادیده گرفتن نمادها},
 			},
 			'colbackwards' => {
 				'no' => q{مرتب‌سازی آکسان‌ها به صورت معمولی},
 				'yes' => q{مرتب‌سازی معکوس براساس آکسان},
 			},
 			'colcasefirst' => {
 				'lower' => q{ابتدا مرتب‌سازی حروف کوچک},
 				'no' => q{مرتب‌سازی به ترتیب معمولی بزرگ و کوچکی حروف},
 				'upper' => q{مرتب‌سازی بر اساس حرف بزرگ در ابتدا},
 			},
 			'colcaselevel' => {
 				'no' => q{مرتب‌سازی بدون توجه به کوچک و بزرگی حروف},
 				'yes' => q{مرتب‌سازی با حساسیت به اندازه حروف},
 			},
 			'colhiraganaquaternary' => {
 				'no' => q{مرتب‌سازی بر اساس سیستم کانا به صورت جداگانه},
 				'yes' => q{مرتب‌سازی کانا به صورت متفاوت},
 			},
 			'collation' => {
 				'big5han' => q{ترتیب چینی سنتی - Big5},
 				'dictionary' => q{ترتیب فرهنگ لغت},
 				'ducet' => q{ترتیب پیش‌فرض یونی‌کد},
 				'gb2312han' => q{ترتیب چینی ساده‌شده - GB2312},
 				'phonebook' => q{ترتیب دفتر تلفن},
 				'phonetic' => q{مرتب کردن بر اساس آوایی},
 				'pinyin' => q{ترتیب پین‌یین},
 				'reformed' => q{ترتیب اصلاح‌شده},
 				'search' => q{جستجوی عمومی},
 				'searchjl' => q{جستجو با صامت اول هانگول},
 				'standard' => q{ترتیب استاندارد},
 				'stroke' => q{ترتیب حرکتی},
 				'traditional' => q{ترتیب سنتی},
 				'unihan' => q{ترتیب رادیکالی-حرکتی},
 			},
 			'colnormalization' => {
 				'no' => q{مرتب‌سازی بدون عادی‌سازی},
 				'yes' => q{مرتب‌سازی یونیکد نرمال شده},
 			},
 			'colnumeric' => {
 				'no' => q{مرتب‌سازی ارقام بصورت مجزا},
 				'yes' => q{مرتب‌سازی شماره‌ها با سیستم عددی},
 			},
 			'colstrength' => {
 				'identical' => q{مرتب‌سازی همه},
 				'primary' => q{مرتب‌سازی فقط حروف پایه},
 				'quaternary' => q{مرتب‌سازی بر اساس آکسان/اندازه حروف/عرض/کانا},
 				'secondary' => q{مرتب‌سازی آکسان‌ها},
 				'tertiary' => q{مرتب‌سازی بر اساس آکسان/اندازه حرف/عرض},
 			},
 			'numbers' => {
 				'arab' => q{ارقام عربی},
 				'arabext' => q{ارقام فارسی},
 				'armn' => q{اعداد ارمنی},
 				'armnlow' => q{اعداد ارمنی با حروف کوچک},
 				'bali' => q{ارقام بالیایی},
 				'beng' => q{ارقام بنگالی},
 				'deva' => q{ارقام دوناگری},
 				'ethi' => q{اعداد اتیوپیایی},
 				'finance' => q{سیستم عددی مالی},
 				'fullwide' => q{ارقام تمام‌عرض},
 				'geor' => q{اعداد گرجی},
 				'grek' => q{اعداد یونانی},
 				'greklow' => q{اعداد یونانی با حروف کوچک},
 				'gujr' => q{ارقام گجراتی},
 				'guru' => q{ارقام گورومخی},
 				'hanidec' => q{اعداد دهدهی چینی},
 				'hans' => q{اعداد چینی ساده‌شده},
 				'hansfin' => q{اعداد مالی چینی ساده‌شده},
 				'hant' => q{اعداد چینی سنتی},
 				'hantfin' => q{اعداد مالی چینی سنتی},
 				'hebr' => q{اعداد عبری},
 				'java' => q{ارقام جاوه‌ای},
 				'jpan' => q{اعداد ژاپنی},
 				'jpanfin' => q{اعداد مالی ژاپنی},
 				'khmr' => q{ارقام خمری},
 				'knda' => q{ارقام کاناده‌ای},
 				'laoo' => q{ارقام لائوسی},
 				'latn' => q{ارقام غربی},
 				'mlym' => q{ارقام مالایالامی},
 				'mong' => q{ارقام مغولی},
 				'mymr' => q{ارقام میانماری},
 				'mymrshan' => q{ارقام شان میانماری},
 				'native' => q{ارقام بومی},
 				'orya' => q{ارقام اوریه‌ای},
 				'roman' => q{اعداد رومی},
 				'romanlow' => q{اعداد رومی با حروف کوچک},
 				'taml' => q{اعداد سنتی تامیلی},
 				'tamldec' => q{ارقام تامیلی},
 				'telu' => q{ارقام تلوگویی},
 				'thai' => q{ارقام تایلندی},
 				'tibt' => q{ارقام تبتی},
 				'traditional' => q{سیستم اعداد سنتی},
 				'vaii' => q{ارقام وایی},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'metric' => q{متریک},
 			'UK' => q{بریتانیایی},
 			'US' => q{امریکایی},

		}
	},
);

has 'display_name_transform_name' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'bgn' => 'BGN',
 			'numeric' => 'سیستم اعداد',
 			'tone' => 'تون',
 			'ungegn' => 'UNGEGN',
 			'x-accents' => 'تکیه',
 			'x-fullwidth' => 'تمام‌عرض',
 			'x-halfwidth' => 'نیم‌عرض',
 			'x-jamo' => 'جامو',
 			'x-pinyin' => 'پین‌یین',
 			'x-publishing' => 'نشر',

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'language' => 'زبان: {0}',
 			'script' => 'خط: {0}',
 			'territory' => 'ناحیه: {0}',

		}
	},
);

has 'text_orientation' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { return {
			lines => '',
			characters => 'right-to-left',
		}}
);

has 'characters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{(?^u:[‌‍‎‏ َ ِ ُ ْ ٖ ٰ إ ك ى ي])},
			index => ['آ', 'ا', 'ب', 'پ', 'ت', 'ث', 'ج', 'چ', 'ح', 'خ', 'د', 'ذ', 'ر', 'ز', 'ژ', 'س', 'ش', 'ص', 'ض', 'ط', 'ظ', 'ع', 'غ', 'ف', 'ق', 'ک', 'گ', 'ل', 'م', 'ن', 'و', 'ه', 'ی'],
			main => qr{(?^u:[ً ٍ ٌ ّ ٔ آ ا ء أ ؤ ئ ب پ ت ث ج چ ح خ د ذ ر ز ژ س ش ص ض ط ظ ع غ ف ق ک گ ل م ن و ه ة ی])},
			punctuation => qr{(?^u:[\- ‐ ، ٫ ٬ ؛ \: ! ؟ . … ‹ › « » ( ) \[ \] * / \\])},
		};
	},
EOT
: sub {
		return { index => ['آ', 'ا', 'ب', 'پ', 'ت', 'ث', 'ج', 'چ', 'ح', 'خ', 'د', 'ذ', 'ر', 'ز', 'ژ', 'س', 'ش', 'ص', 'ض', 'ط', 'ظ', 'ع', 'غ', 'ف', 'ق', 'ک', 'گ', 'ل', 'م', 'ن', 'و', 'ه', 'ی'], };
},
);


has 'ellipsis' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub {
		return {
			'final' => '{0}…',
			'initial' => '…{0}',
			'medial' => '{0}…{1}',
			'word-final' => '{0} …',
			'word-initial' => '… {0}',
			'word-medial' => '{0} … {1}',
		};
	},
);

has 'more_information' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{؟},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{«},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{»},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{‹},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{›},
);

has 'duration_units' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { {
				hm => 'h:mm',
				hms => 'h:mm:ss',
				ms => 'm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[HashRef[Str]]]',
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					'acre' => {
						'one' => q({0} جریب),
						'other' => q({0} جریب),
					},
					'arc-minute' => {
						'one' => q({0} دقیقه),
						'other' => q({0} دقیقه),
					},
					'arc-second' => {
						'one' => q({0} ثانیه),
						'other' => q({0} ثانیه),
					},
					'celsius' => {
						'one' => q({0} درجهٔ سلسیوس),
						'other' => q({0} درجهٔ سلسیوس),
					},
					'centimeter' => {
						'one' => q({0} سانتی‌متر),
						'other' => q({0} سانتی‌متر),
					},
					'cubic-kilometer' => {
						'one' => q({0} کیلومتر مکعب),
						'other' => q({0} کیلومتر مکعب),
					},
					'cubic-mile' => {
						'one' => q({0} مایل مکعب),
						'other' => q({0} مایل مکعب),
					},
					'day' => {
						'one' => q({0} روز),
						'other' => q({0} روز),
					},
					'degree' => {
						'one' => q({0} درجه),
						'other' => q({0} درجه),
					},
					'fahrenheit' => {
						'one' => q({0} درجهٔ فارنهایت),
						'other' => q({0} درجهٔ فارنهایت),
					},
					'foot' => {
						'one' => q({0} فوت),
						'other' => q({0} فوت),
					},
					'gram' => {
						'one' => q({0} گرم),
						'other' => q({0} گرم),
					},
					'hectare' => {
						'one' => q({0} هکتار),
						'other' => q({0} هکتار),
					},
					'hectopascal' => {
						'one' => q({0} هکتوپاسکال),
						'other' => q({0} هکتوپاسکال),
					},
					'horsepower' => {
						'one' => q({0} اسب بخار),
						'other' => q({0} اسب بخار),
					},
					'hour' => {
						'one' => q({0} ساعت),
						'other' => q({0} ساعت),
					},
					'inch' => {
						'one' => q({0} اینچ),
						'other' => q({0} اینچ),
					},
					'inch-hg' => {
						'one' => q({0} اینچ جیوه),
						'other' => q({0} اینچ جیوه),
					},
					'kilogram' => {
						'one' => q({0} کیلوگرم),
						'other' => q({0} کیلوگرم),
					},
					'kilometer' => {
						'one' => q({0} کیلومتر),
						'other' => q({0} کیلومتر),
					},
					'kilometer-per-hour' => {
						'one' => q({0} کیلومتر در ساعت),
						'other' => q({0} کیلومتر در ساعت),
					},
					'kilowatt' => {
						'one' => q({0} کیلووات),
						'other' => q({0} کیلووات),
					},
					'light-year' => {
						'one' => q({0} سال نوری),
						'other' => q({0} سال نوری),
					},
					'liter' => {
						'one' => q({0} لیتر),
						'other' => q({0} لیتر),
					},
					'meter' => {
						'one' => q({0} متر),
						'other' => q({0} متر),
					},
					'meter-per-second' => {
						'one' => q({0} متر در ثانیه),
						'other' => q({0} متر در ثانیه),
					},
					'mile' => {
						'one' => q({0} مایل),
						'other' => q({0} مایل),
					},
					'mile-per-hour' => {
						'one' => q({0} مایل در ساعت),
						'other' => q({0} مایل در ساعت),
					},
					'millibar' => {
						'one' => q({0} میلی‌بار),
						'other' => q({0} میلی‌بار),
					},
					'millimeter' => {
						'one' => q({0} میلی‌متر),
						'other' => q({0} میلی‌متر),
					},
					'millisecond' => {
						'one' => q({0} میلی‌ثانیه),
						'other' => q({0} میلی‌ثانیه),
					},
					'minute' => {
						'one' => q({0} دقیقه),
						'other' => q({0} دقیقه),
					},
					'month' => {
						'one' => q({0} ماه),
						'other' => q({0} ماه),
					},
					'ounce' => {
						'one' => q({0} اونس),
						'other' => q({0} اونس),
					},
					'per' => {
						'' => q({0} بر {1}),
					},
					'picometer' => {
						'one' => q({0} پیکومتر),
						'other' => q({0} پیکومتر),
					},
					'pound' => {
						'one' => q({0} پوند),
						'other' => q({0} پوند),
					},
					'second' => {
						'one' => q({0} ثانیه),
						'other' => q({0} ثانیه),
					},
					'square-foot' => {
						'one' => q({0} فوت مربع),
						'other' => q({0} فوت مربع),
					},
					'square-kilometer' => {
						'one' => q({0} کیلومتر مربع),
						'other' => q({0} کیلومتر مربع),
					},
					'square-meter' => {
						'one' => q({0} متر مربع),
						'other' => q({0} متر مربع),
					},
					'square-mile' => {
						'one' => q({0} مایل مربع),
						'other' => q({0} مایل مربع),
					},
					'watt' => {
						'one' => q({0} وات),
						'other' => q({0} وات),
					},
					'week' => {
						'one' => q({0} هفته),
						'other' => q({0} هفته),
					},
					'yard' => {
						'one' => q({0} یارد),
						'other' => q({0} یارد),
					},
					'year' => {
						'one' => q({0} سال),
						'other' => q({0} سال),
					},
				},
				'narrow' => {
					'acre' => {
						'one' => q({0}جریب),
						'other' => q({0} جریب),
					},
					'arc-minute' => {
						'one' => q({0}′),
						'other' => q({0}′),
					},
					'arc-second' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					'celsius' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'centimeter' => {
						'one' => q({0} cm),
						'other' => q({0} cm),
					},
					'cubic-kilometer' => {
						'one' => q({0}km³),
						'other' => q({0}km³),
					},
					'cubic-mile' => {
						'one' => q({0}mi³),
						'other' => q({0}mi³),
					},
					'day' => {
						'one' => q({0} روز),
						'other' => q({0} روز),
					},
					'degree' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'fahrenheit' => {
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					'foot' => {
						'one' => q({0}ft),
						'other' => q({0}ft),
					},
					'g-force' => {
						'one' => q({0}G),
						'other' => q({0}G),
					},
					'gram' => {
						'one' => q({0}g),
						'other' => q({0}g),
					},
					'hectare' => {
						'one' => q({0}ha),
						'other' => q({0}ha),
					},
					'hectopascal' => {
						'one' => q({0}hPa),
						'other' => q({0}hPa),
					},
					'horsepower' => {
						'one' => q({0}hp),
						'other' => q({0}hp),
					},
					'hour' => {
						'one' => q({0} ساعت),
						'other' => q({0} ساعت),
					},
					'inch' => {
						'one' => q({0}in),
						'other' => q({0}in),
					},
					'inch-hg' => {
						'one' => q({0}inHg),
						'other' => q({0}inHg),
					},
					'kilogram' => {
						'one' => q({0}kg),
						'other' => q({0}kg),
					},
					'kilometer' => {
						'one' => q({0}km),
						'other' => q({0}km),
					},
					'kilometer-per-hour' => {
						'one' => q({0}km/h),
						'other' => q({0}km/h),
					},
					'kilowatt' => {
						'one' => q({0}kW),
						'other' => q({0}kW),
					},
					'light-year' => {
						'one' => q({0}ly),
						'other' => q({0}ly),
					},
					'liter' => {
						'one' => q({0} l),
						'other' => q({0} l),
					},
					'meter' => {
						'one' => q({0}m),
						'other' => q({0}m),
					},
					'meter-per-second' => {
						'one' => q({0}m/s),
						'other' => q({0}m/s),
					},
					'mile' => {
						'one' => q({0}mi),
						'other' => q({0}mi),
					},
					'mile-per-hour' => {
						'one' => q({0}mph),
						'other' => q({0}mph),
					},
					'millibar' => {
						'one' => q({0}mbar),
						'other' => q({0}mbar),
					},
					'millimeter' => {
						'one' => q({0}mm),
						'other' => q({0}mm),
					},
					'millisecond' => {
						'one' => q({0}ms),
						'other' => q({0}ms),
					},
					'minute' => {
						'one' => q({0} دقیقه),
						'other' => q({0} دقیقه),
					},
					'month' => {
						'one' => q({0} ماه),
						'other' => q({0} ماه),
					},
					'ounce' => {
						'one' => q({0}oz),
						'other' => q({0}oz),
					},
					'per' => {
						'' => q({0}/{1}),
					},
					'picometer' => {
						'one' => q({0}pm),
						'other' => q({0}pm),
					},
					'pound' => {
						'one' => q({0}lb),
						'other' => q({0}lb),
					},
					'second' => {
						'one' => q({0}s),
						'other' => q({0}s),
					},
					'square-foot' => {
						'one' => q({0}ft²),
						'other' => q({0}ft²),
					},
					'square-kilometer' => {
						'one' => q({0}km²),
						'other' => q({0}km²),
					},
					'square-meter' => {
						'one' => q({0}m²),
						'other' => q({0}m²),
					},
					'square-mile' => {
						'one' => q({0} mi²),
						'other' => q({0} mi²),
					},
					'watt' => {
						'one' => q({0}W),
						'other' => q({0}W),
					},
					'week' => {
						'one' => q({0} هفته),
						'other' => q({0} هفته),
					},
					'yard' => {
						'one' => q({0}yd),
						'other' => q({0}yd),
					},
					'year' => {
						'one' => q({0} سال),
						'other' => q({0} سال),
					},
				},
				'short' => {
					'acre' => {
						'one' => q({0} جریب),
						'other' => q({0} جریب),
					},
					'arc-minute' => {
						'one' => q({0} دق),
						'other' => q({0} دق),
					},
					'arc-second' => {
						'one' => q({0} ث),
						'other' => q({0} ث),
					},
					'celsius' => {
						'one' => q({0}°C),
						'other' => q({0}°C),
					},
					'centimeter' => {
						'one' => q({0} سانت),
						'other' => q({0} سانت),
					},
					'cubic-kilometer' => {
						'one' => q({0} کیلومترمکعب),
						'other' => q({0} کیلومترمکعب),
					},
					'cubic-mile' => {
						'one' => q({0} مایل مکعب),
						'other' => q({0} مایل مکعب),
					},
					'day' => {
						'one' => q({0} روز),
						'other' => q({0} روز),
					},
					'degree' => {
						'one' => q({0} درجه),
						'other' => q({0} درجه),
					},
					'fahrenheit' => {
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					'foot' => {
						'one' => q({0} فوت),
						'other' => q({0} فوت),
					},
					'g-force' => {
						'one' => q({0}G),
						'other' => q({0}G),
					},
					'gram' => {
						'one' => q({0} گرم),
						'other' => q({0} گرم),
					},
					'hectare' => {
						'one' => q({0} هکتار),
						'other' => q({0} هکتار),
					},
					'hectopascal' => {
						'one' => q({0} هکتوپاسکال),
						'other' => q({0} هکتوپاسکال),
					},
					'horsepower' => {
						'one' => q({0} اسب بخار),
						'other' => q({0} اسب بخار),
					},
					'hour' => {
						'one' => q({0} ساعت),
						'other' => q({0} ساعت),
					},
					'inch' => {
						'one' => q({0} اینچ),
						'other' => q({0} اینچ),
					},
					'inch-hg' => {
						'one' => q({0} اینچ‌جیوه),
						'other' => q({0} اینچ‌جیوه),
					},
					'kilogram' => {
						'one' => q({0} کیلو),
						'other' => q({0} کیلو),
					},
					'kilometer' => {
						'one' => q({0} کیلومتر),
						'other' => q({0} کیلومتر),
					},
					'kilometer-per-hour' => {
						'one' => q({0} کیلومتردرساعت),
						'other' => q({0} کیلومتردرساعت),
					},
					'kilowatt' => {
						'one' => q({0} کیلووات),
						'other' => q({0} کیلووات),
					},
					'light-year' => {
						'one' => q({0} سال نوری),
						'other' => q({0} سال نوری),
					},
					'liter' => {
						'one' => q({0} l),
						'other' => q({0} l),
					},
					'meter' => {
						'one' => q({0} متر),
						'other' => q({0} متر),
					},
					'meter-per-second' => {
						'one' => q({0} متردرثانیه),
						'other' => q({0} متردرثانیه),
					},
					'mile' => {
						'one' => q({0} مایل),
						'other' => q({0} مایل),
					},
					'mile-per-hour' => {
						'one' => q({0} مایل‌درساعت),
						'other' => q({0} مایل‌درساعت),
					},
					'millibar' => {
						'one' => q({0} میلی‌بار),
						'other' => q({0} میلی‌بار),
					},
					'millimeter' => {
						'one' => q({0} میلیمتر),
						'other' => q({0} میلیمتر),
					},
					'millisecond' => {
						'one' => q({0} میلی‌ثانیه),
						'other' => q({0} میلی‌ثانیه),
					},
					'minute' => {
						'one' => q({0} دقیقه),
						'other' => q({0} دقیقه),
					},
					'month' => {
						'one' => q({0} ماه),
						'other' => q({0} ماه),
					},
					'ounce' => {
						'one' => q({0} اونس),
						'other' => q({0} اونس),
					},
					'per' => {
						'' => q({0}/{1}),
					},
					'picometer' => {
						'one' => q({0} پیکومتر),
						'other' => q({0} پیکومتر),
					},
					'pound' => {
						'one' => q({0} پوند),
						'other' => q({0} پوند),
					},
					'second' => {
						'one' => q({0} ثانیه),
						'other' => q({0} ثانیه),
					},
					'square-foot' => {
						'one' => q({0} فوت مربع),
						'other' => q({0} فوت مربع),
					},
					'square-kilometer' => {
						'one' => q({0} کیلومترمربع),
						'other' => q({0} کیلومترمربع),
					},
					'square-meter' => {
						'one' => q({0} مترمربع),
						'other' => q({0} مترمربع),
					},
					'square-mile' => {
						'one' => q({0} مایل مربع),
						'other' => q({0} مایل مربع),
					},
					'watt' => {
						'one' => q({0} وات),
						'other' => q({0} وات),
					},
					'week' => {
						'one' => q({0} هفته),
						'other' => q({0} هفته),
					},
					'yard' => {
						'one' => q({0} یارد),
						'other' => q({0} یارد),
					},
					'year' => {
						'one' => q({0} سال),
						'other' => q({0} سال),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:بله|ب|آری|آ|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:نه|ن|خیر|خ|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
				start => q({0}،‏ {1}),
				middle => q({0}،‏ {1}),
				end => q({0} و {1}),
				2 => q({0} و {1}),
		} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> 'arabext',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> 'arabext',
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'arabext' => {
			'decimal' => q(٫),
			'exponential' => q(×۱۰^),
			'group' => q(٬),
			'infinity' => q(∞),
			'list' => q(؛),
			'minusSign' => q(‎−),
			'nan' => q(ناعدد),
			'perMille' => q(؉),
			'percentSign' => q(٪),
			'plusSign' => q(‎+‎),
			'superscriptingExponent' => q(×),
		},
		'latn' => {
			'decimal' => q(.),
			'exponential' => q(E),
			'group' => q(,),
			'infinity' => q(∞),
			'list' => q(;),
			'minusSign' => q(‎−),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(‎+),
			'superscriptingExponent' => q(×),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'1000' => {
					'one' => '0K',
					'other' => '0K',
				},
				'10000' => {
					'one' => '00K',
					'other' => '00K',
				},
				'100000' => {
					'one' => '000K',
					'other' => '000K',
				},
				'1000000' => {
					'one' => '0M',
					'other' => '0M',
				},
				'10000000' => {
					'one' => '00M',
					'other' => '00M',
				},
				'100000000' => {
					'one' => '000M',
					'other' => '000M',
				},
				'1000000000' => {
					'one' => '0G',
					'other' => '0G',
				},
				'10000000000' => {
					'one' => '00G',
					'other' => '00G',
				},
				'100000000000' => {
					'one' => '000G',
					'other' => '000G',
				},
				'1000000000000' => {
					'one' => '0T',
					'other' => '0T',
				},
				'10000000000000' => {
					'one' => '00T',
					'other' => '00T',
				},
				'100000000000000' => {
					'one' => '000T',
					'other' => '000T',
				},
				'standard' => {
					'' => '#,##0.###',
				},
			},
			'long' => {
				'1000' => {
					'one' => '0 هزار',
					'other' => '0 هزار',
				},
				'10000' => {
					'one' => '00 هزار',
					'other' => '00 هزار',
				},
				'100000' => {
					'one' => '000 هزار',
					'other' => '000 هزار',
				},
				'1000000' => {
					'one' => '0 میلیون',
					'other' => '0 میلیون',
				},
				'10000000' => {
					'one' => '00 میلیون',
					'other' => '00 میلیون',
				},
				'100000000' => {
					'one' => '000 میلیون',
					'other' => '000 میلیون',
				},
				'1000000000' => {
					'one' => '0 میلیارد',
					'other' => '0 میلیارد',
				},
				'10000000000' => {
					'one' => '00 میلیارد',
					'other' => '00 میلیارد',
				},
				'100000000000' => {
					'one' => '000 میلیارد',
					'other' => '000 میلیارد',
				},
				'1000000000000' => {
					'one' => '0 هزار میلیارد',
					'other' => '0 هزار میلیارد',
				},
				'10000000000000' => {
					'one' => '00 هزار میلیارد',
					'other' => '00 هزار میلیارد',
				},
				'100000000000000' => {
					'one' => '000 هزار میلیارد',
					'other' => '000 هزار میلیارد',
				},
			},
			'short' => {
				'1000' => {
					'one' => '0K',
					'other' => '0K',
				},
				'10000' => {
					'one' => '00K',
					'other' => '00K',
				},
				'100000' => {
					'one' => '000K',
					'other' => '000K',
				},
				'1000000' => {
					'one' => '0M',
					'other' => '0M',
				},
				'10000000' => {
					'one' => '00M',
					'other' => '00M',
				},
				'100000000' => {
					'one' => '000M',
					'other' => '000M',
				},
				'1000000000' => {
					'one' => '0G',
					'other' => '0G',
				},
				'10000000000' => {
					'one' => '00G',
					'other' => '00G',
				},
				'100000000000' => {
					'one' => '000G',
					'other' => '000G',
				},
				'1000000000000' => {
					'one' => '0T',
					'other' => '0T',
				},
				'10000000000000' => {
					'one' => '00T',
					'other' => '00T',
				},
				'100000000000000' => {
					'one' => '000T',
					'other' => '000T',
				},
			},
		},
		percentFormat => {
			'default' => {
				'standard' => {
					'' => '#,##0%',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'standard' => {
					'' => '#E0',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'negative' => '‎(¤#,##0.00)',
						'positive' => '‎¤#,##0.00',
					},
					'standard' => {
						'negative' => '‎¤#,##0.00',
						'positive' => '‎¤#,##0.00',
					},
				},
			},
		},
} },
);

has 'curriencies' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'ADP' => {
			display_name => {
				'currency' => q(پزتای آندورا),
			},
		},
		'AED' => {
			display_name => {
				'currency' => q(درهم امارات متحدهٔ عربی),
			},
		},
		'AFA' => {
			display_name => {
				'currency' => q(افغانی افغانستان \(۱۹۲۷ تا ۲۰۰۲\)),
			},
		},
		'AFN' => {
			symbol => '؋',
			display_name => {
				'currency' => q(افغانی افغانستان),
				'one' => q(افغانی افغانستان),
				'other' => q(افغانی افغانستان),
			},
		},
		'ALL' => {
			display_name => {
				'currency' => q(لک آلبانی),
			},
		},
		'AMD' => {
			display_name => {
				'currency' => q(درم ارمنستان),
			},
		},
		'ANG' => {
			display_name => {
				'currency' => q(گیلدر آنتیل هلند),
			},
		},
		'AOA' => {
			display_name => {
				'currency' => q(کوانزای آنگولا),
			},
		},
		'ARP' => {
			display_name => {
				'currency' => q(پزوی آرژانتین \(۱۹۸۳ تا ۱۹۸۵\)‏),
			},
		},
		'ARS' => {
			display_name => {
				'currency' => q(پزوی آرژانتین),
			},
		},
		'ATS' => {
			display_name => {
				'currency' => q(شیلینگ اتریش),
			},
		},
		'AUD' => {
			display_name => {
				'currency' => q(دلار استرالیا),
			},
		},
		'AWG' => {
			display_name => {
				'currency' => q(فلورین آروبا),
			},
		},
		'AZM' => {
			display_name => {
				'currency' => q(منات جمهوری آذربایجان \(۱۹۹۳ تا ۲۰۰۶\)),
			},
		},
		'AZN' => {
			display_name => {
				'currency' => q(منات جمهوری آذربایجان),
			},
		},
		'BAD' => {
			display_name => {
				'currency' => q(دینار بوسنی و هرزگوین \(۱۹۹۲ تا ۱۹۹۴\)),
			},
		},
		'BAM' => {
			display_name => {
				'currency' => q(مارک تبدیل‌پذیر بوسنی و هرزگوین),
			},
		},
		'BBD' => {
			display_name => {
				'currency' => q(دلار باربادوس),
			},
		},
		'BDT' => {
			display_name => {
				'currency' => q(تاکای بنگلادش),
			},
		},
		'BEF' => {
			display_name => {
				'currency' => q(فرانک بلژیک),
			},
		},
		'BEL' => {
			display_name => {
				'currency' => q(فرانک بلژیک \(مالی\)),
			},
		},
		'BGN' => {
			display_name => {
				'currency' => q(لف بلغارستان),
			},
		},
		'BHD' => {
			display_name => {
				'currency' => q(دینار بحرین),
			},
		},
		'BIF' => {
			display_name => {
				'currency' => q(فرانک بوروندی),
			},
		},
		'BMD' => {
			display_name => {
				'currency' => q(دلار برمودا),
				'one' => q(دلار برمودا),
				'other' => q(دلار برمودا),
			},
		},
		'BND' => {
			display_name => {
				'currency' => q(دلار برونئی),
			},
		},
		'BOB' => {
			display_name => {
				'currency' => q(بولیویانوی بولیوی),
			},
		},
		'BOP' => {
			display_name => {
				'currency' => q(پزوی بولیوی),
			},
		},
		'BRL' => {
			display_name => {
				'currency' => q(رئال برزیل),
				'one' => q(رئال برزیل),
				'other' => q(رئال برزیل),
			},
		},
		'BSD' => {
			display_name => {
				'currency' => q(دلار باهاما),
			},
		},
		'BTN' => {
			display_name => {
				'currency' => q(انگولتروم بوتان),
			},
		},
		'BWP' => {
			display_name => {
				'currency' => q(پولای بوتسوانا),
			},
		},
		'BYB' => {
			display_name => {
				'currency' => q(روبل جدید بیلوروسی \(۱۹۹۴ تا ۱۹۹۹\)),
			},
		},
		'BYR' => {
			display_name => {
				'currency' => q(روبل بیلوروسی),
			},
		},
		'BZD' => {
			display_name => {
				'currency' => q(دلار بلیز),
			},
		},
		'CAD' => {
			symbol => '$CA',
			display_name => {
				'currency' => q(دلار کانادا),
				'one' => q(دلار کانادا),
				'other' => q(دلار کانادا),
			},
		},
		'CDF' => {
			display_name => {
				'currency' => q(فرانک کنگو),
			},
		},
		'CHF' => {
			display_name => {
				'currency' => q(فرانک سوئیس),
			},
		},
		'CLP' => {
			display_name => {
				'currency' => q(پزوی شیلی),
			},
		},
		'CNY' => {
			symbol => '¥CN',
			display_name => {
				'currency' => q(یوآن چین),
			},
		},
		'COP' => {
			display_name => {
				'currency' => q(پزوی کلمبیا),
			},
		},
		'CRC' => {
			display_name => {
				'currency' => q(کولون کاستاریکا),
			},
		},
		'CSD' => {
			display_name => {
				'currency' => q(دینار صربستان \(۲۰۰۲ تا ۲۰۰۶\)),
			},
		},
		'CUC' => {
			display_name => {
				'currency' => q(پزوی تبدیل‌پذیر کوبا),
			},
		},
		'CUP' => {
			display_name => {
				'currency' => q(پزوی کوبا),
			},
		},
		'CVE' => {
			display_name => {
				'currency' => q(اسکودوی کیپ‌ورد),
			},
		},
		'CYP' => {
			display_name => {
				'currency' => q(پوند قبرس),
			},
		},
		'CZK' => {
			display_name => {
				'currency' => q(کورونای جمهوری چک),
			},
		},
		'DDM' => {
			display_name => {
				'currency' => q(مارک آلمان شرقی),
			},
		},
		'DEM' => {
			display_name => {
				'currency' => q(مارک آلمان),
			},
		},
		'DJF' => {
			display_name => {
				'currency' => q(فرانک جیبوتی),
			},
		},
		'DKK' => {
			display_name => {
				'currency' => q(کرون دانمارک),
			},
		},
		'DOP' => {
			display_name => {
				'currency' => q(پزوی جمهوری دومینیکن),
			},
		},
		'DZD' => {
			display_name => {
				'currency' => q(دینار الجزایر),
			},
		},
		'EGP' => {
			display_name => {
				'currency' => q(لیرهٔ مصر),
			},
		},
		'ERN' => {
			display_name => {
				'currency' => q(ناکفای اریتره),
			},
		},
		'ETB' => {
			display_name => {
				'currency' => q(بیر اتیوپی),
			},
		},
		'EUR' => {
			symbol => '€',
			display_name => {
				'currency' => q(یورو),
				'one' => q(یورو),
				'other' => q(یورو),
			},
		},
		'FJD' => {
			display_name => {
				'currency' => q(دلار فیجی),
			},
		},
		'FKP' => {
			display_name => {
				'currency' => q(پوند جزایر فالکلند),
			},
		},
		'FRF' => {
			display_name => {
				'currency' => q(فرانک فرانسه),
			},
		},
		'GBP' => {
			symbol => '£',
			display_name => {
				'currency' => q(پوند بریتانیا),
			},
		},
		'GEL' => {
			display_name => {
				'currency' => q(لاری گرجستان),
			},
		},
		'GHS' => {
			display_name => {
				'currency' => q(سدی غنا),
			},
		},
		'GIP' => {
			display_name => {
				'currency' => q(پوند جبل‌الطارق),
			},
		},
		'GMD' => {
			display_name => {
				'currency' => q(دالاسی گامبیا),
			},
		},
		'GNF' => {
			display_name => {
				'currency' => q(فرانک گینه),
			},
		},
		'GRD' => {
			display_name => {
				'currency' => q(دراخمای یونان),
			},
		},
		'GTQ' => {
			display_name => {
				'currency' => q(کتزال گواتمالا),
			},
		},
		'GWP' => {
			display_name => {
				'currency' => q(پزوی گینهٔ بیسائو),
			},
		},
		'GYD' => {
			display_name => {
				'currency' => q(دلار گویان),
			},
		},
		'HKD' => {
			symbol => '$HK',
			display_name => {
				'currency' => q(دلار هنگ‌کنگ),
			},
		},
		'HNL' => {
			display_name => {
				'currency' => q(لمپیرای هندوراس),
			},
		},
		'HRD' => {
			display_name => {
				'currency' => q(دینار کرواسی),
			},
		},
		'HRK' => {
			display_name => {
				'currency' => q(کونای کرواسی),
			},
		},
		'HTG' => {
			display_name => {
				'currency' => q(گورد هائیتی),
			},
		},
		'HUF' => {
			display_name => {
				'currency' => q(فورینت مجارستان),
			},
		},
		'IDR' => {
			display_name => {
				'currency' => q(روپیهٔ اندونزی),
			},
		},
		'IEP' => {
			display_name => {
				'currency' => q(پوند ایرلند),
			},
		},
		'ILS' => {
			symbol => '₪',
			display_name => {
				'currency' => q(شقل جدید اسرائیل),
			},
		},
		'INR' => {
			symbol => '₹',
			display_name => {
				'currency' => q(روپیهٔ هند),
				'one' => q(روپیهٔ هند),
				'other' => q(روپیهٔ هند),
			},
		},
		'IQD' => {
			display_name => {
				'currency' => q(دینار عراق),
			},
		},
		'IRR' => {
			symbol => 'ریال',
			display_name => {
				'currency' => q(ریال ایران),
				'one' => q(ریال ایران),
				'other' => q(ریال ایران),
			},
		},
		'ISK' => {
			display_name => {
				'currency' => q(کرونای ایسلند),
			},
		},
		'ITL' => {
			display_name => {
				'currency' => q(لیرهٔ ایتالیا),
			},
		},
		'JMD' => {
			display_name => {
				'currency' => q(دلار جامائیکا),
			},
		},
		'JOD' => {
			display_name => {
				'currency' => q(دینار اردن),
			},
		},
		'JPY' => {
			symbol => '¥',
			display_name => {
				'currency' => q(ین ژاپن),
				'one' => q(ین ژاپن),
				'other' => q(ین ژاپن),
			},
		},
		'KES' => {
			display_name => {
				'currency' => q(شیلینگ کنیا),
			},
		},
		'KGS' => {
			display_name => {
				'currency' => q(سوم قرقیزستان),
			},
		},
		'KHR' => {
			display_name => {
				'currency' => q(ری‌یل کامبوج),
			},
		},
		'KMF' => {
			display_name => {
				'currency' => q(فرانک کومورو),
			},
		},
		'KPW' => {
			display_name => {
				'currency' => q(وون کرهٔ شمالی),
			},
		},
		'KRW' => {
			symbol => '₩',
			display_name => {
				'currency' => q(وون کرهٔ جنوبی),
			},
		},
		'KWD' => {
			display_name => {
				'currency' => q(دینار کویت),
			},
		},
		'KYD' => {
			display_name => {
				'currency' => q(دلار جزایر کِیمن),
			},
		},
		'KZT' => {
			display_name => {
				'currency' => q(تنگهٔ قزاقستان),
			},
		},
		'LAK' => {
			display_name => {
				'currency' => q(کیپ لائوس),
			},
		},
		'LBP' => {
			display_name => {
				'currency' => q(لیرهٔ لبنان),
			},
		},
		'LKR' => {
			display_name => {
				'currency' => q(روپیهٔ سری‌لانکا),
			},
		},
		'LRD' => {
			display_name => {
				'currency' => q(دلار لیبریا),
			},
		},
		'LSL' => {
			display_name => {
				'currency' => q(لوتی لسوتو),
			},
		},
		'LTL' => {
			display_name => {
				'currency' => q(لیتاس لیتوانی),
			},
		},
		'LUF' => {
			display_name => {
				'currency' => q(فرانک لوکزامبورگ),
			},
		},
		'LUL' => {
			display_name => {
				'currency' => q(فرانک مالی لوگزامبورگ),
			},
		},
		'LVL' => {
			display_name => {
				'currency' => q(لاتس لتونی),
			},
		},
		'LVR' => {
			display_name => {
				'currency' => q(روبل لتونی),
			},
		},
		'LYD' => {
			display_name => {
				'currency' => q(دینار لیبی),
			},
		},
		'MAD' => {
			display_name => {
				'currency' => q(درهم مراکش),
			},
		},
		'MAF' => {
			display_name => {
				'currency' => q(فرانک مراکش),
			},
		},
		'MDL' => {
			display_name => {
				'currency' => q(لئوی مولداوی),
			},
		},
		'MGA' => {
			display_name => {
				'currency' => q(آریاری مالاگاسی),
			},
		},
		'MGF' => {
			display_name => {
				'currency' => q(فرانک ماداگاسکار),
			},
		},
		'MKD' => {
			display_name => {
				'currency' => q(دینار مقدونیه),
			},
		},
		'MLF' => {
			display_name => {
				'currency' => q(فرانک مالی),
			},
		},
		'MMK' => {
			display_name => {
				'currency' => q(کیات میانمار),
			},
		},
		'MNT' => {
			display_name => {
				'currency' => q(توگریک مغولستان),
			},
		},
		'MOP' => {
			display_name => {
				'currency' => q(پاتاکای ماکائو),
			},
		},
		'MRO' => {
			display_name => {
				'currency' => q(اوگوئیای موریتانی),
			},
		},
		'MTL' => {
			display_name => {
				'currency' => q(لیرهٔ مالت),
			},
		},
		'MTP' => {
			display_name => {
				'currency' => q(پوند مالت),
			},
		},
		'MUR' => {
			display_name => {
				'currency' => q(روپیهٔ موریس),
			},
		},
		'MVR' => {
			display_name => {
				'currency' => q(روپیهٔ مالدیو),
			},
		},
		'MWK' => {
			display_name => {
				'currency' => q(کواچای مالاوی),
			},
		},
		'MXN' => {
			symbol => '$MX',
			display_name => {
				'currency' => q(پزوی مکزیک),
			},
		},
		'MXP' => {
			display_name => {
				'currency' => q(پزوی نقرهٔ مکزیک \(۱۸۶۱ تا ۱۹۹۲\)),
			},
		},
		'MYR' => {
			display_name => {
				'currency' => q(رینگیت مالزی),
			},
		},
		'MZE' => {
			display_name => {
				'currency' => q(اسکودوی موزامبیک),
			},
		},
		'MZN' => {
			display_name => {
				'currency' => q(متیکال موزامبیک),
			},
		},
		'NAD' => {
			display_name => {
				'currency' => q(دلار نامیبیا),
			},
		},
		'NGN' => {
			display_name => {
				'currency' => q(نایرای نیجریه),
			},
		},
		'NIO' => {
			display_name => {
				'currency' => q(کوردوبای نیکاراگوئه),
			},
		},
		'NLG' => {
			display_name => {
				'currency' => q(گیلدر هلند),
			},
		},
		'NOK' => {
			display_name => {
				'currency' => q(کرون نروژ),
			},
		},
		'NPR' => {
			display_name => {
				'currency' => q(روپیهٔ نپال),
			},
		},
		'NZD' => {
			symbol => '$NZ',
			display_name => {
				'currency' => q(دلار زلاند نو),
			},
		},
		'OMR' => {
			display_name => {
				'currency' => q(ریال عمان),
			},
		},
		'PAB' => {
			display_name => {
				'currency' => q(بالبوای پاناما),
			},
		},
		'PEN' => {
			display_name => {
				'currency' => q(نوئووسول پرو),
			},
		},
		'PGK' => {
			display_name => {
				'currency' => q(کینای پاپوا گینهٔ نو),
			},
		},
		'PHP' => {
			display_name => {
				'currency' => q(پزوی فیلیپین),
			},
		},
		'PKR' => {
			display_name => {
				'currency' => q(روپیهٔ پاکستان),
			},
		},
		'PLN' => {
			display_name => {
				'currency' => q(زواتی لهستان),
			},
		},
		'PTE' => {
			display_name => {
				'currency' => q(اسکودوی پرتغال),
			},
		},
		'PYG' => {
			display_name => {
				'currency' => q(گوارانی پاراگوئه),
			},
		},
		'QAR' => {
			display_name => {
				'currency' => q(ریال قطر),
			},
		},
		'RHD' => {
			display_name => {
				'currency' => q(دلار رودزیا),
			},
		},
		'RON' => {
			display_name => {
				'currency' => q(لئوی رومانی),
			},
		},
		'RSD' => {
			display_name => {
				'currency' => q(دینار صربستان),
			},
		},
		'RUB' => {
			display_name => {
				'currency' => q(روبل روسیه),
				'one' => q(روبل روسیه),
				'other' => q(روبل روسیه),
			},
		},
		'RUR' => {
			display_name => {
				'currency' => q(روبل روسیه \(۱۹۹۱ تا ۱۹۹۸\)),
			},
		},
		'RWF' => {
			display_name => {
				'currency' => q(فرانک رواندا),
			},
		},
		'SAR' => {
			display_name => {
				'currency' => q(ریال سعودی),
			},
		},
		'SBD' => {
			display_name => {
				'currency' => q(دلار جزایر سلیمان),
			},
		},
		'SCR' => {
			display_name => {
				'currency' => q(روپیهٔ سیشل),
			},
		},
		'SDD' => {
			display_name => {
				'currency' => q(دینار سودان \(۱۹۹۲ تا ۲۰۰۷\)),
			},
		},
		'SDG' => {
			display_name => {
				'currency' => q(لیرهٔ سودان),
			},
		},
		'SEK' => {
			display_name => {
				'currency' => q(کرون سوئد),
			},
		},
		'SGD' => {
			display_name => {
				'currency' => q(دلار سنگاپور),
			},
		},
		'SHP' => {
			display_name => {
				'currency' => q(پوند سنت هلن),
			},
		},
		'SLL' => {
			display_name => {
				'currency' => q(لئون سیرالئون),
			},
		},
		'SOS' => {
			display_name => {
				'currency' => q(شیلینگ سومالی),
			},
		},
		'SRD' => {
			display_name => {
				'currency' => q(دلار سورینام),
			},
		},
		'SRG' => {
			display_name => {
				'currency' => q(گیلدر سورینام),
			},
		},
		'SSP' => {
			display_name => {
				'currency' => q(پوند سودان جنوبی),
			},
		},
		'STD' => {
			display_name => {
				'currency' => q(دوبرای سائوتومه و پرنسیپ),
			},
		},
		'SUR' => {
			display_name => {
				'currency' => q(روبل شوروی),
			},
		},
		'SYP' => {
			display_name => {
				'currency' => q(لیرهٔ سوریه),
			},
		},
		'SZL' => {
			display_name => {
				'currency' => q(لیلانگنی سوازیلند),
			},
		},
		'THB' => {
			symbol => '฿',
			display_name => {
				'currency' => q(بات تایلند),
			},
		},
		'TJR' => {
			display_name => {
				'currency' => q(روبل تاجیکستان),
			},
		},
		'TJS' => {
			display_name => {
				'currency' => q(سامانی تاجیکستان),
			},
		},
		'TMM' => {
			display_name => {
				'currency' => q(منات ترکمنستان \(۱۹۹۳ تا ۲۰۰۹\)),
			},
		},
		'TMT' => {
			display_name => {
				'currency' => q(منات ترکمنستان),
			},
		},
		'TND' => {
			display_name => {
				'currency' => q(دینار تونس),
			},
		},
		'TOP' => {
			display_name => {
				'currency' => q(پاآنگای تونگا),
			},
		},
		'TPE' => {
			display_name => {
				'currency' => q(اسکودوی تیمور),
			},
		},
		'TRL' => {
			display_name => {
				'currency' => q(لیرهٔ ترکیه \(۱۹۲۲ تا ۲۰۰۵\)),
			},
		},
		'TRY' => {
			display_name => {
				'currency' => q(لیرهٔ ترکیه),
			},
		},
		'TTD' => {
			display_name => {
				'currency' => q(دلار ترینیداد و توباگو),
			},
		},
		'TWD' => {
			display_name => {
				'currency' => q(دلار جدید تایوان),
			},
		},
		'TZS' => {
			display_name => {
				'currency' => q(شیلینگ تانزانیا),
			},
		},
		'UAH' => {
			display_name => {
				'currency' => q(هریونیای اوکراین),
			},
		},
		'UGS' => {
			display_name => {
				'currency' => q(شیلینگ اوگاندا \(۱۹۶۶ تا ۱۹۸۷\)),
			},
		},
		'UGX' => {
			display_name => {
				'currency' => q(شیلینگ اوگاندا),
			},
		},
		'USD' => {
			symbol => '$',
			display_name => {
				'currency' => q(دلار امریکا),
				'one' => q(دلار امریکا),
				'other' => q(دلار امریکا),
			},
		},
		'USN' => {
			display_name => {
				'currency' => q(دلار امریکا \(روز بعد\)),
			},
		},
		'USS' => {
			display_name => {
				'currency' => q(دلار امریکا \(همان روز\)),
			},
		},
		'UYP' => {
			display_name => {
				'currency' => q(پزوی اوروگوئه \(۱۹۷۵ تا ۱۹۹۳\)),
			},
		},
		'UYU' => {
			display_name => {
				'currency' => q(پزوی اوروگوئه),
			},
		},
		'UZS' => {
			display_name => {
				'currency' => q(سوم ازبکستان),
			},
		},
		'VEF' => {
			display_name => {
				'currency' => q(بولیوار ونزوئلا),
			},
		},
		'VND' => {
			symbol => '₫',
			display_name => {
				'currency' => q(دانگ ویتنام),
			},
		},
		'VUV' => {
			display_name => {
				'currency' => q(واتوی وانوواتو),
			},
		},
		'WST' => {
			display_name => {
				'currency' => q(تالای ساموا),
			},
		},
		'XAF' => {
			symbol => 'FCFA',
			display_name => {
				'currency' => q(فرانک CFA مرکز آفریقا),
			},
		},
		'XAG' => {
			display_name => {
				'currency' => q(نقره),
			},
		},
		'XAU' => {
			display_name => {
				'currency' => q(طلا),
			},
		},
		'XCD' => {
			symbol => '$EC',
			display_name => {
				'currency' => q(دلار شرق کارائیب),
			},
		},
		'XFO' => {
			display_name => {
				'currency' => q(فرانک طلای فرانسه),
			},
		},
		'XOF' => {
			symbol => 'CFA',
			display_name => {
				'currency' => q(فرانک CFA غرب آفریقا),
			},
		},
		'XPD' => {
			display_name => {
				'currency' => q(پالادیم),
			},
		},
		'XPF' => {
			symbol => 'CFPF',
			display_name => {
				'currency' => q(فرانک CFP),
			},
		},
		'XPT' => {
			display_name => {
				'currency' => q(پلاتین),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(ارز نامشخص),
				'one' => q(\(ارز نامشخص\)),
				'other' => q(\(ارز نامشخص\)),
			},
		},
		'YDD' => {
			display_name => {
				'currency' => q(دینار یمن),
			},
		},
		'YER' => {
			display_name => {
				'currency' => q(ریال یمن),
			},
		},
		'ZAR' => {
			display_name => {
				'currency' => q(راند افریقای جنوبی),
			},
		},
		'ZMK' => {
			display_name => {
				'currency' => q(کواچای زامبیا \(۱۹۶۸ تا ۲۰۱۲\)),
			},
		},
		'ZMW' => {
			display_name => {
				'currency' => q(کواچای زامبیا),
			},
		},
		'ZWD' => {
			display_name => {
				'currency' => q(دلار زیمبابوه \(۱۹۸۰ تا ۲۰۰۸\)),
			},
		},
		'ZWL' => {
			display_name => {
				'currency' => q(دلار زیمبابوه \(۲۰۰۹\)),
			},
		},
		'ZWR' => {
			display_name => {
				'currency' => q(دلار زیمبابوه \(۲۰۰۸\)),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ژانویهٔ',
							'فوریهٔ',
							'مارس',
							'آوریل',
							'مهٔ',
							'ژوئن',
							'ژوئیهٔ',
							'اوت',
							'سپتامبر',
							'اکتبر',
							'نوامبر',
							'دسامبر'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'ژ',
							'ف',
							'م',
							'آ',
							'م',
							'ژ',
							'ژ',
							'ا',
							'س',
							'ا',
							'ن',
							'د'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ژانویهٔ',
							'فوریهٔ',
							'مارس',
							'آوریل',
							'مهٔ',
							'ژوئن',
							'ژوئیهٔ',
							'اوت',
							'سپتامبر',
							'اکتبر',
							'نوامبر',
							'دسامبر'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'ژانویه',
							'فوریه',
							'مارس',
							'آوریل',
							'مه',
							'ژوئن',
							'ژوئیه',
							'اوت',
							'سپتامبر',
							'اکتبر',
							'نوامبر',
							'دسامبر'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'ژ',
							'ف',
							'م',
							'آ',
							'م',
							'ژ',
							'ژ',
							'ا',
							'س',
							'ا',
							'ن',
							'د'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ژانویه',
							'فوریه',
							'مارس',
							'آوریل',
							'مه',
							'ژوئن',
							'ژوئیه',
							'اوت',
							'سپتامبر',
							'اکتبر',
							'نوامبر',
							'دسامبر'
						],
						leap => [
							
						],
					},
				},
			},
			'hebrew' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'تشری',
							'حشوان',
							'کسلو',
							'طوت',
							'شباط',
							'آذار',
							'واذار',
							'نیسان',
							'ایار',
							'سیوان',
							'تموز',
							'آب',
							'ایلول'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'واذار الثانی'
						],
					},
					narrow => {
						nonleap => [
							'ت',
							'ح',
							'ک',
							'ط',
							'ش',
							'آ',
							'و',
							'ن',
							'ا',
							'س',
							'ت',
							'آ',
							'ا'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'و'
						],
					},
					wide => {
						nonleap => [
							'تشری',
							'حشوان',
							'کسلو',
							'طوت',
							'شباط',
							'آذار',
							'واذار',
							'نیسان',
							'ایار',
							'سیوان',
							'تموز',
							'آب',
							'ایلول'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'واذار الثانی'
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'تشری',
							'حشوان',
							'کسلو',
							'طوت',
							'شباط',
							'آذار',
							'واذار',
							'نیسان',
							'ایار',
							'سیوان',
							'تموز',
							'آب',
							'ایلول'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'واذار الثانی'
						],
					},
					narrow => {
						nonleap => [
							'ت',
							'ح',
							'ک',
							'ط',
							'ش',
							'آ',
							'و',
							'ن',
							'ا',
							'س',
							'ت',
							'آ',
							'ا'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'و'
						],
					},
					wide => {
						nonleap => [
							'تشری',
							'حشوان',
							'کسلو',
							'طوت',
							'شباط',
							'آذار',
							'واذار',
							'نیسان',
							'ایار',
							'سیوان',
							'تموز',
							'آب',
							'ایلول'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'واذار الثانی'
						],
					},
				},
			},
			'islamic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'محرم',
							'صفر',
							'ربیع الاول',
							'ربیع الثانی',
							'جمادی الاول',
							'جمادی الثانی',
							'رجب',
							'شعبان',
							'رمضان',
							'شوال',
							'ذیقعدهٔ',
							'ذیحجهٔ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'م',
							'ص',
							'ر',
							'ر',
							'ج',
							'ج',
							'ر',
							'ش',
							'ر',
							'ش',
							'ذ',
							'ذ'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'محرم',
							'صفر',
							'ربیع الاول',
							'ربیع الثانی',
							'جمادی الاول',
							'جمادی الثانی',
							'رجب',
							'شعبان',
							'رمضان',
							'شوال',
							'ذیقعدهٔ',
							'ذیحجهٔ'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'محرم',
							'صفر',
							'ربیع الاول',
							'ربیع الثانی',
							'جمادی الاول',
							'جمادی الثانی',
							'رجب',
							'شعبان',
							'رمضان',
							'شوال',
							'ذیقعده',
							'ذیحجه'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'م',
							'ص',
							'ر',
							'ر',
							'ج',
							'ج',
							'ر',
							'ش',
							'ر',
							'ش',
							'ذ',
							'ذ'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'محرم',
							'صفر',
							'ربیع الاول',
							'ربیع الثانی',
							'جمادی الاول',
							'جمادی الثانی',
							'رجب',
							'شعبان',
							'رمضان',
							'شوال',
							'ذیقعده',
							'ذیحجه'
						],
						leap => [
							
						],
					},
				},
			},
			'persian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'فروردین',
							'اردیبهشت',
							'خرداد',
							'تیر',
							'مرداد',
							'شهریور',
							'مهر',
							'آبان',
							'آذر',
							'دی',
							'بهمن',
							'اسفند'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'ف',
							'ا',
							'خ',
							'ت',
							'م',
							'ش',
							'م',
							'آ',
							'آ',
							'د',
							'ب',
							'ا'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'فروردین',
							'اردیبهشت',
							'خرداد',
							'تیر',
							'مرداد',
							'شهریور',
							'مهر',
							'آبان',
							'آذر',
							'دی',
							'بهمن',
							'اسفند'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'فروردین',
							'اردیبهشت',
							'خرداد',
							'تیر',
							'مرداد',
							'شهریور',
							'مهر',
							'آبان',
							'آذر',
							'دی',
							'بهمن',
							'اسفند'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'ف',
							'ا',
							'خ',
							'ت',
							'م',
							'ش',
							'م',
							'آ',
							'آ',
							'د',
							'ب',
							'ا'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'فروردین',
							'اردیبهشت',
							'خرداد',
							'تیر',
							'مرداد',
							'شهریور',
							'مهر',
							'آبان',
							'آذر',
							'دی',
							'بهمن',
							'اسفند'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'دوشنبه',
						tue => 'سه‌شنبه',
						wed => 'چهارشنبه',
						thu => 'پنجشنبه',
						fri => 'جمعه',
						sat => 'شنبه',
						sun => 'یکشنبه'
					},
					narrow => {
						mon => 'د',
						tue => 'س',
						wed => 'چ',
						thu => 'پ',
						fri => 'ج',
						sat => 'ش',
						sun => 'ی'
					},
					short => {
						mon => '۲ش',
						tue => '۳ش',
						wed => '۴ش',
						thu => '۵ش',
						fri => 'ج',
						sat => 'ش',
						sun => '۱ش'
					},
					wide => {
						mon => 'دوشنبه',
						tue => 'سه‌شنبه',
						wed => 'چهارشنبه',
						thu => 'پنجشنبه',
						fri => 'جمعه',
						sat => 'شنبه',
						sun => 'یکشنبه'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'دوشنبه',
						tue => 'سه‌شنبه',
						wed => 'چهارشنبه',
						thu => 'پنجشنبه',
						fri => 'جمعه',
						sat => 'شنبه',
						sun => 'یکشنبه'
					},
					narrow => {
						mon => 'د',
						tue => 'س',
						wed => 'چ',
						thu => 'پ',
						fri => 'ج',
						sat => 'ش',
						sun => 'ی'
					},
					short => {
						mon => '۲ش',
						tue => '۳ش',
						wed => '۴ش',
						thu => '۵ش',
						fri => 'ج',
						sat => 'ش',
						sun => '۱ش'
					},
					wide => {
						mon => 'دوشنبه',
						tue => 'سه‌شنبه',
						wed => 'چهارشنبه',
						thu => 'پنجشنبه',
						fri => 'جمعه',
						sat => 'شنبه',
						sun => 'یکشنبه'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'س‌م۱',
						1 => 'س‌م۲',
						2 => 'س‌م۳',
						3 => 'س‌م۴'
					},
					narrow => {0 => '۱',
						1 => '۲',
						2 => '۳',
						3 => '۴'
					},
					wide => {0 => 'سه‌ماههٔ اول',
						1 => 'سه‌ماههٔ دوم',
						2 => 'سه‌ماههٔ سوم',
						3 => 'سه‌ماههٔ چهارم'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => 'س‌م۱',
						1 => 'س‌م۲',
						2 => 'س‌م۳',
						3 => 'س‌م۴'
					},
					narrow => {0 => '۱',
						1 => '۲',
						2 => '۳',
						3 => '۴'
					},
					wide => {0 => 'سه‌ماههٔ اول',
						1 => 'سه‌ماههٔ دوم',
						2 => 'سه‌ماههٔ سوم',
						3 => 'سه‌ماههٔ چهارم'
					},
				},
			},
	} },
);

has 'day_period_data' => (
	traits		=> ['Code'],
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	handles		=> { call => 'execute_method' },
	default		=> sub { sub {
		# Time in hhmm format
		my ($self, $type, $time) = @_;
		SWITCH:
		for ($type) {
			if ($_ eq 'chinese') {
				return 'morning' if $time >= 0600
					&& $time < 1200;
				return 'weeHours' if $time >= 0000
					&& $time < 0100;
				return 'afternoon' if $time >= 1600
					&& $time < 1900;
				return 'earlyMorning' if $time >= 0100
					&& $time < 0600;
				return 'night' if $time >= 1900
					&& $time < 2400;
				return 'midDay' if $time > 1200
					&& $time < 1600;
				return 'noon' if $time == 1200;
			last SWITCH;
			}
			if ($_ eq 'hebrew') {
				return 'morning' if $time >= 0600
					&& $time < 1200;
				return 'weeHours' if $time >= 0000
					&& $time < 0100;
				return 'afternoon' if $time >= 1600
					&& $time < 1900;
				return 'earlyMorning' if $time >= 0100
					&& $time < 0600;
				return 'night' if $time >= 1900
					&& $time < 2400;
				return 'midDay' if $time > 1200
					&& $time < 1600;
				return 'noon' if $time == 1200;
			last SWITCH;
			}
			if ($_ eq 'generic') {
				return 'morning' if $time >= 0600
					&& $time < 1200;
				return 'weeHours' if $time >= 0000
					&& $time < 0100;
				return 'afternoon' if $time >= 1600
					&& $time < 1900;
				return 'earlyMorning' if $time >= 0100
					&& $time < 0600;
				return 'night' if $time >= 1900
					&& $time < 2400;
				return 'midDay' if $time > 1200
					&& $time < 1600;
				return 'noon' if $time == 1200;
			last SWITCH;
			}
			if ($_ eq 'islamic') {
				return 'morning' if $time >= 0600
					&& $time < 1200;
				return 'weeHours' if $time >= 0000
					&& $time < 0100;
				return 'afternoon' if $time >= 1600
					&& $time < 1900;
				return 'earlyMorning' if $time >= 0100
					&& $time < 0600;
				return 'night' if $time >= 1900
					&& $time < 2400;
				return 'midDay' if $time > 1200
					&& $time < 1600;
				return 'noon' if $time == 1200;
			last SWITCH;
			}
			if ($_ eq 'persian') {
				return 'morning' if $time >= 0600
					&& $time < 1200;
				return 'weeHours' if $time >= 0000
					&& $time < 0100;
				return 'afternoon' if $time >= 1600
					&& $time < 1900;
				return 'earlyMorning' if $time >= 0100
					&& $time < 0600;
				return 'night' if $time >= 1900
					&& $time < 2400;
				return 'midDay' if $time > 1200
					&& $time < 1600;
				return 'noon' if $time == 1200;
			last SWITCH;
			}
			if ($_ eq 'gregorian') {
				return 'morning' if $time >= 0600
					&& $time < 1200;
				return 'weeHours' if $time >= 0000
					&& $time < 0100;
				return 'afternoon' if $time >= 1600
					&& $time < 1900;
				return 'earlyMorning' if $time >= 0100
					&& $time < 0600;
				return 'night' if $time >= 1900
					&& $time < 2400;
				return 'midDay' if $time > 1200
					&& $time < 1600;
				return 'noon' if $time == 1200;
			last SWITCH;
			}
		}
	} },
);

has 'day_periods' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'wide' => {
					'afternoon' => q{عصر},
					'weeHours' => q{نیمه‌شب},
					'earlyMorning' => q{بامداد},
					'midDay' => q{بعدازظهر},
					'night' => q{شب},
					'pm' => q{بعدازظهر},
					'morning' => q{صبح},
					'am' => q{قبل‌ازظهر},
					'noon' => q{ظهر},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'chinese' => {
		},
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'ق.م.',
				'1' => 'م.'
			},
			narrow => {
				'0' => 'ق',
				'1' => 'م'
			},
			wide => {
				'0' => 'قبل از میلاد',
				'1' => 'میلادی'
			},
		},
		'hebrew' => {
		},
		'islamic' => {
			abbreviated => {
				'0' => 'ه‍.ق.'
			},
			wide => {
				'0' => 'هجری قمری'
			},
		},
		'persian' => {
			abbreviated => {
				'0' => 'ه‍.ش.'
			},
			wide => {
				'0' => 'هجری شمسی'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'chinese' => {
		},
		'generic' => {
			'full' => q{EEEE d MMMM y G},
			'long' => q{d MMMM y G},
			'medium' => q{d MMM y G},
			'short' => q{y/M/d G},
		},
		'gregorian' => {
			'full' => q{EEEE d MMMM y},
			'long' => q{d MMMM y},
			'medium' => q{d MMM y},
			'short' => q{y/M/d},
		},
		'hebrew' => {
		},
		'islamic' => {
			'full' => q{EEEE d MMMM y GGGG},
			'long' => q{d MMMM y G},
			'medium' => q{y/M/d G},
			'short' => q{yy/M/d G},
		},
		'persian' => {
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'chinese' => {
		},
		'generic' => {
		},
		'gregorian' => {
			'full' => q{H:mm:ss (zzzz)},
			'long' => q{H:mm:ss (z)},
			'medium' => q{H:mm:ss},
			'short' => q{H:mm},
		},
		'hebrew' => {
		},
		'islamic' => {
		},
		'persian' => {
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'chinese' => {
		},
		'generic' => {
			'full' => q{{1}، ساعت {0}},
			'long' => q{{1}، ساعت {0}},
			'medium' => q{{1}،‏ {0}},
			'short' => q{{1}،‏ {0}},
		},
		'gregorian' => {
			'full' => q{{1}، ساعت {0}},
			'long' => q{{1}، ساعت {0}},
			'medium' => q{{1}،‏ {0}},
			'short' => q{{1}،‏ {0}},
		},
		'hebrew' => {
		},
		'islamic' => {
		},
		'persian' => {
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			EHm => q{E H:mm},
			EHms => q{E H:mm:ss},
			Ed => q{E d},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{y G},
			GyMMM => q{MMM y G},
			GyMMMEd => q{E d MMM y G},
			GyMMMd => q{d MMM y G},
			H => q{H},
			HHmmZ => q{HH:mm (Z)},
			Hm => q{H:mm},
			Hms => q{H:mm:ss},
			M => q{L},
			MEd => q{E M/d},
			MMM => q{LLL},
			MMMEd => q{E d LLL},
			MMMMEd => q{E d LLLL},
			MMMMd => q{d LLLL},
			MMMd => q{d LLL},
			Md => q{M/d},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			mmss => q{mm:ss},
			ms => q{mm:ss},
			y => q{y},
			yM => q{y/M},
			yMEd => q{E y/M/d},
			yMMM => q{MMM y},
			yMMMEd => q{E d MMM y},
			yMMMM => q{MMMM y},
			yMMMMEEEEd => q{EEEE d MMMM y},
			yMMMd => q{d MMM y},
			yMd => q{y/M/d},
			yQQQ => q{QQQQ y},
			yQQQQ => q{QQQQ y},
		},
		'generic' => {
			Ed => q{E d},
			Gy => q{y G},
			GyMMM => q{MMM y G},
			GyMMMEd => q{E d MMM y G},
			GyMMMd => q{d MMM y G},
			H => q{H},
			HHmmZ => q{HH:mm (Z)},
			Hm => q{H:mm},
			Hms => q{H:mm:ss},
			M => q{L},
			MEd => q{E M/d},
			MMM => q{LLL},
			MMMEd => q{E d LLL},
			MMMMEd => q{E d LLLL},
			MMMMd => q{d LLLL},
			MMMd => q{d LLL},
			Md => q{M/d},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{y G},
			yyyy => q{y G},
			yyyyM => q{y/M G},
			yyyyMEd => q{E y/M/d G},
			yyyyMMM => q{MMM y G},
			yyyyMMMEd => q{E d MMM y G},
			yyyyMMMd => q{d MMM y G},
			yyyyMd => q{y/M/d G},
			yyyyQQQ => q{QQQQ y G},
			yyyyQQQQ => q{QQQQ y G},
		},
		'islamic' => {
			Ed => q{E d},
			Gy => q{y G},
			GyMMM => q{MMM y G},
			GyMMMEd => q{E d MMM y G},
			GyMMMd => q{d MMM y G},
			H => q{H},
			Hm => q{H:mm},
			HmZ => q{HH:mm (Z)},
			Hms => q{H:mm:ss},
			M => q{L},
			MEd => q{E M/d},
			MMM => q{LLL},
			MMMEd => q{E d LLL},
			MMMMEd => q{E d LLLL},
			MMMMd => q{d LLLL},
			MMMd => q{d LLL},
			Md => q{M/d},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{y},
			yM => q{y/M},
			yMEd => q{E y/M/d},
			yMMM => q{MMM y},
			yMMMEd => q{E d MMM y},
			yMMMM => q{MMMM y},
			yQQQ => q{QQQ y},
			yQQQQ => q{QQQQ y},
			yyyy => q{y G},
			yyyyMMM => q{MMM y G},
			yyyyMMMEd => q{E d MMM y G},
			yyyyMMMd => q{d MMM y G},
			yyyyQQQ => q{QQQQ y G},
			yyyyQQQQ => q{QQQQ y G},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'Day-Of-Week' => '{1} {0}',
			'Timezone' => '{0} ({1})',
		},
		'generic' => {
			'Day-Of-Week' => '{1} {0}',
			'Timezone' => '{0} ({1})',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			H => {
				H => q{H تا H},
			},
			Hm => {
				H => q{H:mm تا H:mm},
				m => q{H:mm تا H:mm},
			},
			Hmv => {
				H => q{H:mm تا H:mm v},
				m => q{H:mm تا H:mm v},
			},
			Hv => {
				H => q{H تا H v},
			},
			M => {
				M => q{M تا M},
			},
			MEd => {
				M => q{E M/d تا E M/d},
				d => q{E M/d تا E M/d},
			},
			MMM => {
				M => q{LLL تا LLL},
			},
			MMMEd => {
				M => q{E d LLL تا E d LLL},
				d => q{E d LLL تا E d LLL},
			},
			MMMd => {
				M => q{d LLL تا d LLL},
				d => q{d تا d LLL},
			},
			Md => {
				M => q{M/d تا M/d},
				d => q{M/d تا M/d},
			},
			d => {
				d => q{d تا d},
			},
			fallback => '{0} تا {1}',
			h => {
				a => q{h a تا h a},
				h => q{h تا h a},
			},
			hm => {
				a => q{h:mm a تا h:mm a},
				h => q{h:mm تا h:mm a},
				m => q{h:mm تا h:mm a},
			},
			hmv => {
				a => q{h:mm a تا h:mm a v},
				h => q{h:mm تا h:mm a v},
				m => q{h:mm تا h:mm a v},
			},
			hv => {
				a => q{h a تا h a v},
				h => q{h تا h a v},
			},
			y => {
				y => q{y تا y},
			},
			yM => {
				M => q{y/M تا y/M},
				y => q{y/M تا y/M},
			},
			yMEd => {
				M => q{E y/M/d تا E y/M/d},
				d => q{E y/M/d تا E y/M/d},
				y => q{E y/M/d تا E y/M/d},
			},
			yMMM => {
				M => q{LLL تا MMM y},
				y => q{MMM y تا MMM y},
			},
			yMMMEd => {
				M => q{E d LLL تا E d MMM y},
				d => q{E d LLL تا E d MMM y},
				y => q{E d MMM y تا E d MMM y},
			},
			yMMMM => {
				M => q{LLLL تا MMMM y},
				y => q{MMMM y تا MMMM y},
			},
			yMMMd => {
				M => q{d LLL تا d MMM y},
				d => q{d تا d MMM y},
				y => q{d MMM y تا d MMM y},
			},
			yMd => {
				M => q{y/M/d تا y/M/d},
				d => q{y/M/d تا y/M/d},
				y => q{y/M/d تا y/M/d},
			},
		},
		'generic' => {
			H => {
				H => q{H تا H},
			},
			Hm => {
				H => q{H:mm تا H:mm},
				m => q{H:mm تا H:mm},
			},
			Hmv => {
				H => q{H:mm تا H:mm (v)},
				m => q{H:mm تا H:mm (v)},
			},
			Hv => {
				H => q{H تا H (v)},
			},
			M => {
				M => q{M تا M},
			},
			MEd => {
				M => q{E M/d تا E M/d},
				d => q{E M/d تا E M/d},
			},
			MMM => {
				M => q{LLL تا LLL},
			},
			MMMEd => {
				M => q{E d LLL تا E d LLL},
				d => q{E d LLL تا E d LLL},
			},
			MMMd => {
				M => q{d LLL تا d LLL},
				d => q{d تا d LLL},
			},
			Md => {
				M => q{M/d تا M/d},
				d => q{M/d تا M/d},
			},
			d => {
				d => q{d تا d},
			},
			fallback => '{0} تا {1}',
			h => {
				a => q{h a تا h a},
				h => q{h تا h a},
			},
			hm => {
				a => q{h:mm a تا h:mm a},
				h => q{h:mm تا h:mm a},
				m => q{h:mm تا h:mm a},
			},
			hmv => {
				a => q{h:mm a تا h:mm a (v)},
				h => q{h:mm تا h:mm a (v)},
				m => q{h:mm تا h:mm a (v)},
			},
			hv => {
				a => q{h a تا h a (v)},
				h => q{h تا h a (v)},
			},
			y => {
				y => q{y تا y G},
			},
			yM => {
				M => q{y/M تا y/M G},
				y => q{y/M تا y/M G},
			},
			yMEd => {
				M => q{E y/M/d تا E y/M/d G},
				d => q{E y/M/d تا E y/M/d G},
				y => q{E y/M/d تا E y/M/d G},
			},
			yMMM => {
				M => q{LLL تا MMM y G},
				y => q{MMM y تا MMM y G},
			},
			yMMMEd => {
				M => q{E d LLL تا E d MMM y G},
				d => q{E d LLL تا E d MMM y G},
				y => q{E d MMM y تا E d MMM y G},
			},
			yMMMM => {
				M => q{LLLL تا MMMM y G},
				y => q{MMMM y تا MMMM y G},
			},
			yMMMd => {
				M => q{d LLL تا d MMM y G},
				d => q{d تا d MMM y G},
				y => q{d MMM y تا d MMM y G},
			},
			yMd => {
				M => q{y/M/d تا y/M/d G},
				d => q{y/M/d تا y/M/d G},
				y => q{y/M/d تا y/M/d G},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HH:mm;−HH:mm),
		gmtFormat => q(GMT{0}),
		gmtZeroFormat => q(GMT),
		regionFormat => q(وقت {0}),
		regionFormat => q(وقت تابستانی {0}),
		regionFormat => q(وقت عادی {0}),
		fallbackFormat => q({1} ({0})),
		'Afghanistan' => {
			long => {
				'standard' => q(وقت افغانستان),
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#آبیجان#,
		},
		'Africa/Accra' => {
			exemplarCity => q#اکرا#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#آدیس آبابا#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#الجزیره#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#اسمره#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#باماکو#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#بانگی#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#بانجول#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#بیسائو#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#بلانتیره#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#برازویل#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#بوجومبورا#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#قاهره#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#کازابلانکا#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#سبته#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#کوناکری#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#داکار#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#دارالسلام#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#جیبوتی#,
		},
		'Africa/Douala' => {
			exemplarCity => q#دوآلا#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#العیون#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#فری‌تاون#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#گابورون#,
		},
		'Africa/Harare' => {
			exemplarCity => q#هراره#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#ژوهانسبورگ#,
		},
		'Africa/Juba' => {
			exemplarCity => q#جوبا#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#کامپالا#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#خارطوم#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#کیگالی#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#کینشاسا#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#لاگوس#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#لیبرویل#,
		},
		'Africa/Lome' => {
			exemplarCity => q#لومه#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#لواندا#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#لوبومباشی#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#لوزاکا#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#مالابو#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#ماپوتو#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#ماسرو#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#مبابانه#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#موگادیشو#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#مونروویا#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#نایروبی#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#انجامنا#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#نیامی#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#نوآکشوت#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#اوآگادوگو#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#پورتو نووو#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#سائوتومه#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#طرابلس#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#شهر تونس#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#ویندهوک#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q(وقت مرکز افریقا),
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q(وقت شرق افریقا),
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q(وقت جنوب افریقا),
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q(وقت تابستانی غرب افریقا),
				'generic' => q(وقت غرب افریقا),
				'standard' => q(وقت عادی غرب افریقا),
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q(وقت تابستانی آلاسکا),
				'generic' => q(وقت آلاسکا),
				'standard' => q(وقت عادی آلاسکا),
			},
		},
		'Almaty' => {
			long => {
				'daylight' => q(وقت تابستانی آلماآتا),
				'generic' => q(وقت آلماآتا),
				'standard' => q(وقت عادی آلماآتا),
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q(وقت تابستانی آمازون),
				'generic' => q(وقت آمازون),
				'standard' => q(وقت عادی آمازون),
			},
		},
		'America/Adak' => {
			exemplarCity => q#ایدک#,
		},
		'America/Anchorage' => {
			exemplarCity => q#انکوریج#,
		},
		'America/Anguilla' => {
			exemplarCity => q#آنگوئیلا#,
		},
		'America/Antigua' => {
			exemplarCity => q#آنتیگوا#,
		},
		'America/Araguaina' => {
			exemplarCity => q#آراگواینا#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#لاریوخا#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#ریوگالگوس#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#سالتا#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#سن‌خوان#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#سن‌لوئیس#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#توکومن#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#اوشوایا#,
		},
		'America/Aruba' => {
			exemplarCity => q#اروبا#,
		},
		'America/Asuncion' => {
			exemplarCity => q#آسونسیون#,
		},
		'America/Bahia' => {
			exemplarCity => q#بایا#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#باهیا باندراس#,
		},
		'America/Barbados' => {
			exemplarCity => q#باربادوس#,
		},
		'America/Belem' => {
			exemplarCity => q#بلم#,
		},
		'America/Belize' => {
			exemplarCity => q#بلیز#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#بلان‐سابلون#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#بوئاویشتا#,
		},
		'America/Bogota' => {
			exemplarCity => q#بوگوتا#,
		},
		'America/Boise' => {
			exemplarCity => q#بویسی#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#بوئنوس‌آیرس#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#کمبریج‌بی#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#کمپو گرانده#,
		},
		'America/Cancun' => {
			exemplarCity => q#کانکون#,
		},
		'America/Caracas' => {
			exemplarCity => q#کاراکاس#,
		},
		'America/Catamarca' => {
			exemplarCity => q#کاتامارکا#,
		},
		'America/Cayenne' => {
			exemplarCity => q#کاین#,
		},
		'America/Cayman' => {
			exemplarCity => q#کیمن#,
		},
		'America/Chicago' => {
			exemplarCity => q#شیکاگو#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#چیواوا#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#اتکوکان#,
		},
		'America/Cordoba' => {
			exemplarCity => q#کوردووا#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#کاستاریکا#,
		},
		'America/Creston' => {
			exemplarCity => q#کرستون#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#کویاوا#,
		},
		'America/Curacao' => {
			exemplarCity => q#کوراسائو#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#دانمارک‌شاون#,
		},
		'America/Dawson' => {
			exemplarCity => q#داوسن#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#داوسن کریک#,
		},
		'America/Denver' => {
			exemplarCity => q#دنور#,
		},
		'America/Detroit' => {
			exemplarCity => q#دترویت#,
		},
		'America/Dominica' => {
			exemplarCity => q#دومینیکا#,
		},
		'America/Edmonton' => {
			exemplarCity => q#ادمونتون#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#ایرونپه#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#السالوادور#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#فورتالزا#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#گلیس‌بی#,
		},
		'America/Godthab' => {
			exemplarCity => q#گودهوب#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#گوس‌بی#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#گراند تورک#,
		},
		'America/Grenada' => {
			exemplarCity => q#گرانادا#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#گوادلوپ#,
		},
		'America/Guatemala' => {
			exemplarCity => q#گواتمالا#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#گوایاکیل#,
		},
		'America/Guyana' => {
			exemplarCity => q#گویان#,
		},
		'America/Halifax' => {
			exemplarCity => q#هلیفکس#,
		},
		'America/Havana' => {
			exemplarCity => q#هاوانا#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#ارموسیو#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#ناکس، ایندیانا#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#مارنگو، ایندیانا#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#پیترزبرگ، ایندیانا#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#تل‌سیتی، ایندیانا#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#ویوی، ایندیانا#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#وینسنس، اندیانا#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#ویناماک، ایندیانا#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#ایندیاناپولیس#,
		},
		'America/Inuvik' => {
			exemplarCity => q#اینوویک#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#ایکلوئت#,
		},
		'America/Jamaica' => {
			exemplarCity => q#جامائیکا#,
		},
		'America/Jujuy' => {
			exemplarCity => q#خوخوی#,
		},
		'America/Juneau' => {
			exemplarCity => q#جونو#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#مانتیسلو، کنتاکی#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#کرالندیک#,
		},
		'America/La_Paz' => {
			exemplarCity => q#لاپاز#,
		},
		'America/Lima' => {
			exemplarCity => q#لیما#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#لوس‌آنجلس#,
		},
		'America/Louisville' => {
			exemplarCity => q#لوئیزویل#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#بخش شاهزاده‌‌نشین پایین#,
		},
		'America/Maceio' => {
			exemplarCity => q#ماسیو#,
		},
		'America/Managua' => {
			exemplarCity => q#ماناگوا#,
		},
		'America/Manaus' => {
			exemplarCity => q#ماناوس#,
		},
		'America/Marigot' => {
			exemplarCity => q#ماریگات#,
		},
		'America/Martinique' => {
			exemplarCity => q#مارتینیک#,
		},
		'America/Matamoros' => {
			exemplarCity => q#ماتاموروس#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#ماساتلان#,
		},
		'America/Mendoza' => {
			exemplarCity => q#مندوسا#,
		},
		'America/Menominee' => {
			exemplarCity => q#منامینی#,
		},
		'America/Merida' => {
			exemplarCity => q#مریدا#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#متالاکاتلا#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#مکزیکوسیتی#,
		},
		'America/Miquelon' => {
			exemplarCity => q#میکلون#,
		},
		'America/Moncton' => {
			exemplarCity => q#مانکتون#,
		},
		'America/Monterrey' => {
			exemplarCity => q#مونتری#,
		},
		'America/Montevideo' => {
			exemplarCity => q#مونته‌ویدئو#,
		},
		'America/Montserrat' => {
			exemplarCity => q#مونتسرات#,
		},
		'America/Nassau' => {
			exemplarCity => q#ناسائو#,
		},
		'America/New_York' => {
			exemplarCity => q#نیویورک#,
		},
		'America/Nipigon' => {
			exemplarCity => q#نیپیگان#,
		},
		'America/Nome' => {
			exemplarCity => q#نوم#,
		},
		'America/Noronha' => {
			exemplarCity => q#نورونیا#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#بیولا، داکوتای شمالی#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#سنتر، داکوتای شمالی#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#نیوسالم، داکوتای شمالی#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#اخیناگا#,
		},
		'America/Panama' => {
			exemplarCity => q#پاناما#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#پانگنیرتونگ#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#پاراماریبو#,
		},
		'America/Phoenix' => {
			exemplarCity => q#فینکس#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#پورتوپرنس#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#پورت‌آواسپین#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#پورتوولیو#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#پورتوریکو#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#رینی‌ریور#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#خلیجک رنکین#,
		},
		'America/Recife' => {
			exemplarCity => q#ریسیفی#,
		},
		'America/Regina' => {
			exemplarCity => q#رجاینا#,
		},
		'America/Resolute' => {
			exemplarCity => q#رزولوت#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#ریوبرانکو#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#سانتا ایزابل#,
		},
		'America/Santarem' => {
			exemplarCity => q#سنتارم#,
		},
		'America/Santiago' => {
			exemplarCity => q#سانتیاگو#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#سانتو دومینگو#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#سائوپائولو#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#اسکورسبیسوند#,
		},
		'America/Sitka' => {
			exemplarCity => q#سیتکا#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#سنت بارتلمی#,
		},
		'America/St_Johns' => {
			exemplarCity => q#سنت جان#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#سنت کیتس#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#سنت لوسیا#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#سنت توماس#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#سنت وینسنت#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#سوئیفت‌کرنت#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#تگوسیگالپا#,
		},
		'America/Thule' => {
			exemplarCity => q#تول#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#تاندربی#,
		},
		'America/Tijuana' => {
			exemplarCity => q#تیخوانا#,
		},
		'America/Toronto' => {
			exemplarCity => q#تورنتو#,
		},
		'America/Tortola' => {
			exemplarCity => q#تورتولا#,
		},
		'America/Vancouver' => {
			exemplarCity => q#ونکوور#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#وایت‌هورس#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#وینیپگ#,
		},
		'America/Yakutat' => {
			exemplarCity => q#یاکوتات#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#یلونایف#,
		},
		'America_Central' => {
			long => {
				'daylight' => q(وقت تابستانی مرکز امریکا),
				'generic' => q(وقت مرکز امریکا),
				'standard' => q(وقت عادی مرکز امریکا),
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q(وقت تابستانی شرق امریکا),
				'generic' => q(وقت شرق امریکا),
				'standard' => q(وقت عادی شرق امریکا),
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q(وقت تابستانی کوهستانی امریکا),
				'generic' => q(وقت کوهستانی امریکا),
				'standard' => q(وقت عادی کوهستانی امریکا),
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q(وقت تابستانی غرب امریکا),
				'generic' => q(وقت غرب امریکا),
				'standard' => q(وقت عادی غرب امریکا),
			},
		},
		'Anadyr' => {
			long => {
				'daylight' => q(وقت تابستانی آنادیر),
				'generic' => q(وقت آنادیر),
				'standard' => q(وقت عادی آنادیر),
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#کیسی#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#دیویس#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#دومون دورویل#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#مکواری#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#ماوسون#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#مک‌موردو#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#پالمر#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#روترا#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#شووا#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#ووستوک#,
		},
		'Arabian' => {
			long => {
				'daylight' => q(وقت تابستانی عربستان),
				'generic' => q(وقت عربستان),
				'standard' => q(وقت عادی عربستان),
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#لانگ‌یربین#,
		},
		'Argentina' => {
			long => {
				'daylight' => q(وقت تابستانی آرژانتین),
				'generic' => q(وقت آرژانتین),
				'standard' => q(وقت عادی آرژانتین),
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q(وقت تابستانی غرب آرژانتین),
				'generic' => q(وقت غرب آرژانتین),
				'standard' => q(وقت عادی غرب آرژانتین),
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q(وقت تابستانی ارمنستان),
				'generic' => q(وقت ارمنستان),
				'standard' => q(وقت عادی ارمنستان),
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#عدن#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#آلماتی#,
		},
		'Asia/Amman' => {
			exemplarCity => q#عمّان#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#آنادیر#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#آقتاو#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#آقتوبه#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#عشق‌آباد#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#بغداد#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#بحرین#,
		},
		'Asia/Baku' => {
			exemplarCity => q#باکو#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#بانکوک#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#بیروت#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#بیشکک#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#برونئی#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#کلکته#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#چویبالسان#,
		},
		'Asia/Chongqing' => {
			exemplarCity => q#چونگ‌کینگ#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#کلمبو#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#دمشق#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#داکا#,
		},
		'Asia/Dili' => {
			exemplarCity => q#دیلی#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#دبی#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#دوشنبه#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#غزه#,
		},
		'Asia/Harbin' => {
			exemplarCity => q#هاربین#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#الخلیل#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#هنگ‌کنگ#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#خوود#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#ایرکوتسک#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#جاکارتا#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#جایاپورا#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#اورشلیم#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#کابل#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#کامچاتکا#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#کراچی#,
		},
		'Asia/Kashgar' => {
			exemplarCity => q#کاشغر#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#کاتماندو#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#خاندیگا#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#کراسنویارسک#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#کوالالامپور#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#کوچینگ#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#کویت#,
		},
		'Asia/Macau' => {
			exemplarCity => q#ماکائو#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#ماگادان#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#ماکاسار#,
		},
		'Asia/Manila' => {
			exemplarCity => q#مانیل#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#مسقط#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#نیکوزیا#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#نوووکوزنتسک#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#نووسیبیریسک#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#اومسک#,
		},
		'Asia/Oral' => {
			exemplarCity => q#اورال#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#پنوم‌پن#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#پونتیاناک#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#پیونگ‌یانگ#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#قطر#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#قیزیل‌اوردا#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#یانگون#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#ریاض#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#هوشی‌مین‌سیتی#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#ساخالین#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#سمرقند#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#سئول#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#شانگهای#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#سنگاپور#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#تایپه#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#تاشکند#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#تفلیس#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#تهران#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#تیمفو#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#توکیو#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#اولان‌باتور#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#ارومچی#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#اوست نرا#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#وینتیان#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#ولادی‌وستوک#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#یاکوتسک#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#یکاترینبرگ#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#ایروان#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q(وقت تابستانی آتلانتیک),
				'generic' => q(وقت آتلانتیک),
				'standard' => q(وقت عادی آتلانتیک),
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#آزور#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#برمودا#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#قناری#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#کیپ‌ورد#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#فارو#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#مادیرا#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#ریکیاویک#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#جورجیای جنوبی#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#سنت هلنا#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#استانلی#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#آدلاید#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#بریسبین#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#بروکن‌هیل#,
		},
		'Australia/Currie' => {
			exemplarCity => q#کوری#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#داروین#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#اوکلا#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#هوبارت#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#لیندمن#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#لردهاو#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#ملبورن#,
		},
		'Australia/Perth' => {
			exemplarCity => q#پرت#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#سیدنی#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q(وقت تابستانی مرکز استرالیا),
				'generic' => q(وقت مرکز استرالیا),
				'standard' => q(وقت عادی مرکز استرالیا),
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q(وقت تابستانی مرکز-غرب استرالیا),
				'generic' => q(وقت مرکز-غرب استرالیا),
				'standard' => q(وقت عادی مرکز-غرب استرالیا),
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q(وقت تابستانی شرق استرالیا),
				'generic' => q(وقت شرق استرالیا),
				'standard' => q(وقت عادی شرق استرالیا),
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q(وقت تابستانی غرب استرالیا),
				'generic' => q(وقت غرب استرالیا),
				'standard' => q(وقت عادی غرب استرالیا),
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q(وقت تابستانی جمهوری آذربایجان),
				'generic' => q(وقت جمهوری آذربایجان),
				'standard' => q(وقت عادی جمهوری آذربایجان),
			},
		},
		'Azores' => {
			long => {
				'daylight' => q(وقت تابستانی آزور),
				'generic' => q(وقت آزور),
				'standard' => q(وقت عادی آزور),
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q(وقت تابستانی بنگلادش),
				'generic' => q(وقت بنگلادش),
				'standard' => q(وقت عادی بنگلادش),
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q(وقت بوتان),
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q(وقت بولیوی),
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q(وقت تابستانی برازیلیا),
				'generic' => q(وقت برازیلیا),
				'standard' => q(وقت عادی برازیلیا),
			},
		},
		'Brunei' => {
			long => {
				'standard' => q(وقت برونئی دارالسلام),
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q(وقت تابستانی کیپ‌ورد),
				'generic' => q(وقت کیپ‌ورد),
				'standard' => q(وقت عادی کیپ‌ورد),
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q(وقت چامورو),
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q(وقت تابستانی چت‌هام),
				'generic' => q(وقت چت‌هام),
				'standard' => q(وقت عادی چت‌هام),
			},
		},
		'Chile' => {
			long => {
				'daylight' => q(وقت تابستانی شیلی),
				'generic' => q(وقت شیلی),
				'standard' => q(وقت عادی شیلی),
			},
		},
		'China' => {
			long => {
				'daylight' => q(وقت تابستانی چین),
				'generic' => q(وقت چین),
				'standard' => q(وقت عادی چین),
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q(وقت تابستانی چویبالسان),
				'generic' => q(وقت چویبالسان),
				'standard' => q(وقت عادی چویبالسان),
			},
		},
		'Christmas' => {
			long => {
				'standard' => q(وقت جزیرهٔ کریسمس),
			},
		},
		'Cocos' => {
			long => {
				'standard' => q(وقت جزایر کوکوس),
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q(وقت تابستانی کلمبیا),
				'generic' => q(وقت کلمبیا),
				'standard' => q(وقت عادی کلمبیا),
			},
		},
		'Cook' => {
			long => {
				'daylight' => q(وقت تابستانی جزایر کوک),
				'generic' => q(وقت جزایر کوک),
				'standard' => q(وقت عادی جزایر کوک),
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q(وقت تابستانی کوبا),
				'generic' => q(وقت کوبا),
				'standard' => q(وقت عادی کوبا),
			},
		},
		'Davis' => {
			long => {
				'standard' => q(وقت دیویس),
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q(وقت دومون دورویل),
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q(وقت تیمور شرقی),
			},
		},
		'Easter' => {
			long => {
				'daylight' => q(وقت تابستانی جزیرهٔ ایستر),
				'generic' => q(وقت جزیرهٔ ایستر),
				'standard' => q(وقت عادی جزیرهٔ ایستر),
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q(وقت اکوادور),
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#شهر نامشخص#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#آمستردام#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#آندورا#,
		},
		'Europe/Athens' => {
			exemplarCity => q#آتن#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#بلگراد#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#برلین#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#براتیسلاوا#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#بروکسل#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#بخارست#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#بوداپست#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#بازنگن#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#کیشیناو#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#کپنهاگ#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#دوبلین#,
			long => {
				'daylight' => q(وقت تابستانی ایرلند),
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#جبل‌الطارق#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#گرنزی#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#هلسینکی#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#جزیرهٔ من#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#استانبول#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#جرزی#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#کالینینگراد#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#کیف#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#لیسبون#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#لیوبلیانا#,
		},
		'Europe/London' => {
			exemplarCity => q#لندن#,
			long => {
				'daylight' => q(وقت تابستانی بریتانیا),
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#لوکزامبورگ#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#مادرید#,
		},
		'Europe/Malta' => {
			exemplarCity => q#مالت#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#ماریه‌هامن#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#مینسک#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#موناکو#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#مسکو#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#اسلو#,
		},
		'Europe/Paris' => {
			exemplarCity => q#پاریس#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#پادگاریتسا#,
		},
		'Europe/Prague' => {
			exemplarCity => q#پراگ#,
		},
		'Europe/Riga' => {
			exemplarCity => q#ریگا#,
		},
		'Europe/Rome' => {
			exemplarCity => q#رم#,
		},
		'Europe/Samara' => {
			exemplarCity => q#سامارا#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#سان‌مارینو#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#سارایوو#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#سیمفروپل#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#اسکوپیه#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#صوفیه#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#استکهلم#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#تالین#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#تیرانا#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#اوژگورود#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#فادوتس#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#واتیکان#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#وین#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#ویلنیوس#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#ولگاگراد#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#ورشو#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#زاگرب#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#زاپوروژیا#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#زوریخ#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q(وقت تابستانی مرکز اروپا),
				'generic' => q(وقت مرکز اروپا),
				'standard' => q(وقت عادی مرکز اروپا),
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q(وقت تابستانی شرق اروپا),
				'generic' => q(وقت شرق اروپا),
				'standard' => q(وقت عادی شرق اروپا),
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q(وقت تابستانی غرب اروپا),
				'generic' => q(وقت غرب اروپا),
				'standard' => q(وقت عادی غرب اروپا),
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q(وقت تابستانی جزایر فالکلند),
				'generic' => q(وقت جزایر فالکلند),
				'standard' => q(وقت عادی جزایر فالکلند),
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q(وقت تابستانی فیجی),
				'generic' => q(وقت فیجی),
				'standard' => q(وقت عادی فیجی),
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q(وقت گویان فرانسه),
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q(وقت سرزمین‌های جنوبی و جنوبگان فرانسه),
			},
		},
		'GMT' => {
			long => {
				'standard' => q(وقت گرینویچ),
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q(وقت گالاپاگوس),
			},
		},
		'Gambier' => {
			long => {
				'standard' => q(وقت گامبیه),
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q(وقت تابستانی گرجستان),
				'generic' => q(وقت گرجستان),
				'standard' => q(وقت عادی گرجستان),
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q(وقت جزایر گیلبرت),
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q(وقت تابستانی شرق گرینلند),
				'generic' => q(وقت شرق گرینلند),
				'standard' => q(وقت عادی شرق گرینلند),
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q(وقت تابستانی غرب گرینلند),
				'generic' => q(وقت غرب گرینلند),
				'standard' => q(وقت عادی غرب گرینلند),
			},
		},
		'Guam' => {
			long => {
				'standard' => q(وقت عادی گوام),
			},
		},
		'Gulf' => {
			long => {
				'standard' => q(وقت خلیج فارس),
			},
		},
		'Guyana' => {
			long => {
				'standard' => q(وقت گویان),
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q(وقت تابستانی هاوایی),
				'generic' => q(وقت هاوایی),
				'standard' => q(وقت عادی هاوایی),
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q(وقت تابستانی هنگ‌کنگ),
				'generic' => q(وقت هنگ‌کنگ),
				'standard' => q(وقت عادی هنگ‌کنگ),
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q(وقت تابستانی خوود),
				'generic' => q(وقت خوود),
				'standard' => q(وقت عادی خوود),
			},
		},
		'India' => {
			long => {
				'standard' => q(وقت هند),
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#آنتاناناریوو#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#شاگوس#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#کریسمس#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#کوکوس#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#کومورو#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#کرگولن#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#ماهه#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#مالدیو#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#موریس#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#مایوت#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#رئونیون#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q(وقت اقیانوس هند),
			},
		},
		'Indochina' => {
			long => {
				'standard' => q(وقت هندوچین),
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q(وقت مرکز اندونزی),
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q(وقت شرق اندونزی),
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q(وقت غرب اندونزی),
			},
		},
		'Iran' => {
			long => {
				'daylight' => q(وقت تابستانی ایران),
				'generic' => q(وقت ایران),
				'standard' => q(وقت عادی ایران),
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q(وقت تابستانی ایرکوتسک),
				'generic' => q(وقت ایرکوتسک),
				'standard' => q(وقت عادی ایرکوتسک),
			},
		},
		'Israel' => {
			long => {
				'daylight' => q(وقت تابستانی اسرائیل),
				'generic' => q(وقت اسرائیل),
				'standard' => q(وقت عادی اسرائیل),
			},
		},
		'Japan' => {
			long => {
				'daylight' => q(وقت تابستانی ژاپن),
				'generic' => q(وقت ژاپن),
				'standard' => q(وقت عادی ژاپن),
			},
		},
		'Kamchatka' => {
			long => {
				'daylight' => q(وقت تابستانی پتروپاولوسک‐کامچاتسکی),
				'generic' => q(وقت پتروپاولوسک‐کامچاتسکی),
				'standard' => q(وقت عادی پتروپاولوسک‐کامچاتسکی),
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q(وقت شرق قزاقستان),
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q(وقت غرب قزاقستان),
			},
		},
		'Korea' => {
			long => {
				'daylight' => q(وقت تابستانی کره),
				'generic' => q(وقت کره),
				'standard' => q(وقت عادی کره),
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q(وقت کوسرای),
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q(وقت تابستانی کراسنویارسک),
				'generic' => q(وقت کراسنویارسک),
				'standard' => q(وقت عادی کراسنویارسک),
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q(وقت قرقیزستان),
			},
		},
		'Lanka' => {
			long => {
				'standard' => q(وقت لانکا),
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q(وقت جزایر لاین),
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q(وقت تابستانی لردهو),
				'generic' => q(وقت لردهو),
				'standard' => q(وقت عادی لردهو),
			},
		},
		'Macau' => {
			long => {
				'daylight' => q(وقت تابستانی ماکائو),
				'generic' => q(وقت ماکائو),
				'standard' => q(وقت عادی ماکائو),
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q(وقت جزیرهٔ مکواری),
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q(وقت تابستانی ماگادان),
				'generic' => q(وقت ماگادان),
				'standard' => q(وقت عادی ماگادان),
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q(وقت مالزی),
			},
		},
		'Maldives' => {
			long => {
				'standard' => q(وقت مالدیو),
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q(وقت مارکوئز),
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q(وقت جزایر مارشال),
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q(وقت تابستانی موریس),
				'generic' => q(وقت موریس),
				'standard' => q(وقت عادی موریس),
			},
		},
		'Mawson' => {
			long => {
				'standard' => q(وقت ماوسون),
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q(وقت تابستانی اولان‌باتور),
				'generic' => q(وقت اولان‌باتور),
				'standard' => q(وقت عادی اولان‌باتور),
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q(وقت تابستانی مسکو),
				'generic' => q(وقت مسکو),
				'standard' => q(وقت عادی مسکو),
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q(وقت میانمار),
			},
		},
		'Nauru' => {
			long => {
				'standard' => q(وقت نائورو),
			},
		},
		'Nepal' => {
			long => {
				'standard' => q(وقت نپال),
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q(وقت تابستانی کالدونیای جدید),
				'generic' => q(وقت کالدونیای جدید),
				'standard' => q(وقت عادی کالدونیای جدید),
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q(وقت تابستانی زلاند نو),
				'generic' => q(وقت زلاند نو),
				'standard' => q(وقت عادی زلاند نو),
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q(وقت تابستانی نیوفاندلند),
				'generic' => q(وقت نیوفاندلند),
				'standard' => q(وقت عادی نیوفاندلند),
			},
		},
		'Niue' => {
			long => {
				'standard' => q(وقت نیوئه),
			},
		},
		'Norfolk' => {
			long => {
				'standard' => q(وقت جزایر نورفولک),
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q(وقت تابستانی فرناندو دی نورونیا),
				'generic' => q(وقت فرناندو دی نورونیا),
				'standard' => q(وقت عادی فرناندو دی نورونیا),
			},
		},
		'North_Mariana' => {
			long => {
				'standard' => q(وقت جزایر ماریانای شمالی),
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q(وقت تابستانی نووسیبیرسک),
				'generic' => q(وقت نووسیبیرسک),
				'standard' => q(وقت عادی نووسیبیرسک),
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q(وقت تابستانی اومسک),
				'generic' => q(وقت اومسک),
				'standard' => q(وقت عادی اومسک),
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#آپیا#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#اوکلند#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#چتم#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#ایستر#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#افاته#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#اندربری#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#فاکائوفو#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#فیجی#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#فونافوتی#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#گالاپاگوس#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#گامبیر#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#گوادال‌کانال#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#گوام#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#هونولولو#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#جانستون#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#کریتیماتی#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#کوسرای#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#کواجیلین#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#ماجورو#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#مارکوزه#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#میدوی#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#نائورو#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#نیوئه#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#نورفولک#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#نومئا#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#پاگوپاگو#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#پالائو#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#پیت‌کرن#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#پانپی#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#پورت‌مورزبی#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#راروتونگا#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#سایپان#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#تاهیتی#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#تاراوا#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#تونگاتاپو#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#چوک#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#ویک#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#والیس#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q(وقت تابستانی پاکستان),
				'generic' => q(وقت پاکستان),
				'standard' => q(وقت عادی پاکستان),
			},
		},
		'Palau' => {
			long => {
				'standard' => q(وقت پالائو),
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q(وقت پاپوا گینهٔ نو),
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q(وقت تابستانی پاراگوئه),
				'generic' => q(وقت پاراگوئه),
				'standard' => q(وقت عادی پاراگوئه),
			},
		},
		'Peru' => {
			long => {
				'daylight' => q(وقت تابستانی پرو),
				'generic' => q(وقت پرو),
				'standard' => q(وقت عادی پرو),
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q(وقت تابستانی فیلیپین),
				'generic' => q(وقت فیلیپین),
				'standard' => q(وقت عادی فیلیپین),
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q(وقت جزایر فونیکس),
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q(وقت تابستانی سنت پیر و میکلون),
				'generic' => q(وقت سنت پیر و میکلون),
				'standard' => q(وقت عادی سنت پیر و میکلون),
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q(وقت پیتکایرن),
			},
		},
		'Ponape' => {
			long => {
				'standard' => q(وقت پوناپه),
			},
		},
		'Qyzylorda' => {
			long => {
				'daylight' => q(وقت تابستانی قیزیل‌اوردا),
				'generic' => q(وقت قیزیل‌اوردا),
				'standard' => q(وقت عادی قیزیل‌اوردا),
			},
		},
		'Reunion' => {
			long => {
				'standard' => q(وقت ریونیون),
			},
		},
		'Rothera' => {
			long => {
				'standard' => q(وقت روترا),
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q(وقت تابستانی ساخالین),
				'generic' => q(وقت ساخالین),
				'standard' => q(وقت عادی ساخالین),
			},
		},
		'Samara' => {
			long => {
				'daylight' => q(وقت تابستانی سامارا),
				'generic' => q(وقت سامارا),
				'standard' => q(وقت عادی سامارا),
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q(وقت تابستانی ساموا),
				'generic' => q(وقت ساموا),
				'standard' => q(وقت عادی ساموا),
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q(وقت سیشل),
			},
		},
		'Singapore' => {
			long => {
				'standard' => q(وقت سنگاپور),
			},
		},
		'Solomon' => {
			long => {
				'standard' => q(وقت جزایر سلیمان),
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q(وقت جورجیای جنوبی),
			},
		},
		'Suriname' => {
			long => {
				'standard' => q(وقت سورینام),
			},
		},
		'Syowa' => {
			long => {
				'standard' => q(وقت شووا),
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q(وقت تاهیتی),
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q(وقت تابستانی تایپه),
				'generic' => q(وقت تایپه),
				'standard' => q(وقت عادی تایپه),
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q(وقت تاجیکستان),
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q(وقت توکلائو),
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q(وقت تابستانی تونگا),
				'generic' => q(وقت تونگا),
				'standard' => q(وقت عادی تونگا),
			},
		},
		'Truk' => {
			long => {
				'standard' => q(وقت چوئوک),
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q(وقت تابستانی ترکمنستان),
				'generic' => q(وقت ترکمنستان),
				'standard' => q(وقت عادی ترکمنستان),
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q(وقت تووالو),
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q(وقت تابستانی اروگوئه),
				'generic' => q(وقت اروگوئه),
				'standard' => q(وقت عادی اروگوئه),
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q(وقت تابستانی ازبکستان),
				'generic' => q(وقت ازبکستان),
				'standard' => q(وقت عادی ازبکستان),
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q(وقت تابستانی واناتو),
				'generic' => q(وقت واناتو),
				'standard' => q(وقت عادی واناتو),
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q(وقت ونزوئلا),
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q(وقت تابستانی ولادی‌وستوک),
				'generic' => q(وقت ولادی‌وستوک),
				'standard' => q(وقت عادی ولادی‌وستوک),
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q(وقت تابستانی ولگاگراد),
				'generic' => q(وقت ولگاگراد),
				'standard' => q(وقت عادی ولگاگراد),
			},
		},
		'Vostok' => {
			long => {
				'standard' => q(وقت وستوک),
			},
		},
		'Wake' => {
			long => {
				'standard' => q(وقت جزیرهٔ ویک),
			},
		},
		'Wallis' => {
			long => {
				'standard' => q(وقت والیس و فوتونا),
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q(وقت تابستانی یاکوتسک),
				'generic' => q(وقت یاکوتسک),
				'standard' => q(وقت عادی یاکوتسک),
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q(وقت تابستانی یکاترینبورگ),
				'generic' => q(وقت یکاترینبورگ),
				'standard' => q(وقت عادی یکاترینبورگ),
			},
		},
	 } }
);
no Moose;
__PACKAGE__->meta->make_immutable;

1;

# vim: tabstop=4
