package Locale::CLDR::Mr;
# This file auto generated from Data\common\main\mr.xml
#	on Sun  1 Jun  3:53:53 pm GMT
# XML file generated 2014-03-05 23:14:25 -0600 (Wed, 05 Mar 2014)

use version;

our $VERSION = version->declare('v0.25.2');

use v5.10;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';

use Moose;

extends('Locale::CLDR::Root');
# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $territory, $script, $variant) = @_;

	my $display_pattern = '{0} ({1})';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0}, {1}', grep {$_} (
		$territory,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub { 
		 sub {
			 my %languages = (
				'aa' => 'अफार',
 				'ab' => 'अबखेजियन',
 				'ace' => 'अचीनी',
 				'ach' => 'अकोली',
 				'ada' => 'अडांग्मे',
 				'ady' => 'अडिघे',
 				'ae' => 'अवेस्तन',
 				'af' => 'अफ्रिकान्स',
 				'afh' => 'अफ्रिहिली',
 				'ain' => 'ऐनू',
 				'ak' => 'अकान',
 				'akk' => 'अक्कादिआन',
 				'ale' => 'अलेउत',
 				'alt' => 'दक्षिणात्य अल्ताई',
 				'am' => 'अम्हारिक',
 				'an' => 'अर्गोनीज',
 				'ang' => 'पुरातन इंग्रजी',
 				'anp' => 'अंगिका',
 				'ar' => 'अरबी',
 				'ar_001' => 'आधुनिक प्रमाणित अरबी',
 				'arc' => 'अ‍ॅरेमाइक',
 				'arn' => 'अ‍ॅरॉकॅनियन',
 				'arp' => 'अराफाओ',
 				'arw' => 'अरावक',
 				'as' => 'आसामी',
 				'ast' => 'अस्तुरियन',
 				'av' => 'अ‍ॅव्हेरिक',
 				'awa' => 'अवधी',
 				'ay' => 'ऐमरा',
 				'az' => 'अझरबैजानी',
 				'az@alt=short' => 'अझेरी',
 				'ba' => 'बष्किर',
 				'bal' => 'बलुची',
 				'ban' => 'बालिनीस',
 				'bas' => 'बसा',
 				'be' => 'बेलारुशियन',
 				'bej' => 'बेजा',
 				'bem' => 'बेम्बा',
 				'bg' => 'बल्गेरियन',
 				'bho' => 'भोजपुरी',
 				'bi' => 'बिस्लामा',
 				'bik' => 'बिकोल',
 				'bin' => 'बिनी',
 				'bla' => 'सिक्सिका',
 				'bm' => 'बाम्बारा',
 				'bn' => 'बंगाली',
 				'bo' => 'तिबेटी',
 				'br' => 'ब्रेतॉन',
 				'bra' => 'ब्रज',
 				'bs' => 'बोस्नियन',
 				'bua' => 'बुरियात',
 				'bug' => 'बगिनीस',
 				'byn' => 'ब्लिन',
 				'ca' => 'कॅटलान',
 				'cad' => 'कॅड्डो',
 				'car' => 'कॅरिब',
 				'cch' => 'अत्सम',
 				'ce' => 'चेचन',
 				'ceb' => 'सिबुआनो',
 				'ch' => 'कॅमोरो',
 				'chb' => 'चिब्चा',
 				'chg' => 'छगाताई',
 				'chk' => 'चूकीसे',
 				'chm' => 'मारी',
 				'chn' => 'चिनूक जारगॉन',
 				'cho' => 'चोक्तौ',
 				'chp' => 'शिपेव्यान',
 				'chr' => 'चेरोकी',
 				'chy' => 'शेयेन्न',
 				'ckb' => 'सोरानी कुर्दिश',
 				'co' => 'कॉर्सिकन',
 				'cop' => 'कॉप्टिक',
 				'cr' => 'क्री',
 				'crh' => 'क्राइमीन तुर्की',
 				'cs' => 'झेक',
 				'csb' => 'काशुबियन',
 				'cu' => 'चर्च स्लाव्हिक',
 				'cv' => 'चूवाश',
 				'cy' => 'वेल्श',
 				'da' => 'डॅनिश',
 				'dak' => 'दाकोता',
 				'dar' => 'दार्गवा',
 				'de' => 'जर्मन',
 				'de_AT' => 'ऑस्ट्रियन जर्मन',
 				'de_CH' => 'स्विस हाय जर्मन',
 				'del' => 'डेलॅवेयर',
 				'den' => 'स्लाव्ह',
 				'dgr' => 'डोग्रिब',
 				'din' => 'दिन्का',
 				'doi' => 'डोगरी',
 				'dsb' => 'निम्न सोर्बियन',
 				'dua' => 'दुआला',
 				'dum' => 'मिडल डच',
 				'dv' => 'दिवेही',
 				'dyu' => 'ड्युला',
 				'dz' => 'झोंगखा',
 				'ee' => 'यू',
 				'efi' => 'एफिक',
 				'egy' => 'प्राचीन इजिप्शियन',
 				'eka' => 'एकाजुक',
 				'el' => 'ग्रीक',
 				'elx' => 'एलामाइट',
 				'en' => 'इंग्रजी',
 				'en_AU' => 'ऑस्ट्रेलियन इंग्रजी',
 				'en_CA' => 'कॅनडियन इंग्रजी',
 				'en_GB' => 'इंग्रजी (यूके)',
 				'en_GB@alt=short' => 'यू.के. इंग्रजी',
 				'en_US' => 'यू.एस. इंग्रजी',
 				'en_US@alt=short' => 'यू.एस. इंग्रजी',
 				'enm' => 'मिडल इंग्रजी',
 				'eo' => 'एस्परान्टो',
 				'es' => 'स्पॅनिश',
 				'es_419' => 'लॅटिन अमेरिकन स्पॅनिश',
 				'es_ES' => 'युरोपियन स्पॅनिश',
 				'es_MX' => 'मेक्सिकन स्पॅनिश',
 				'et' => 'इस्टोनियन',
 				'eu' => 'बास्क',
 				'ewo' => 'इवोन्डो',
 				'fa' => 'फारसी',
 				'fan' => 'फँग',
 				'fat' => 'फन्टी',
 				'ff' => 'फुलाह',
 				'fi' => 'फिन्निश',
 				'fil' => 'फिलिपिनो',
 				'fj' => 'फिजियन',
 				'fo' => 'फरोइज',
 				'fon' => 'फॉन',
 				'fr' => 'फ्रेंच',
 				'fr_CA' => 'कॅनडियन फ्रेंच',
 				'fr_CH' => 'स्विस फ्रेंच',
 				'frm' => 'मिडल फ्रेंच',
 				'fro' => 'पुरातन फ्रेंच',
 				'frr' => 'उत्तरी फ्रिशियन',
 				'frs' => 'पौर्वात्य फ्रिशियन',
 				'fur' => 'फ्रियुलियान',
 				'fy' => 'पश्चिमी फ्रिशियन',
 				'ga' => 'आयरिश',
 				'gaa' => 'Ga',
 				'gay' => 'गायो',
 				'gba' => 'बाया',
 				'gd' => 'स्कॉट्स गेलिक',
 				'gez' => 'गीझ',
 				'gil' => 'जिल्बरटीज',
 				'gl' => 'गॅलिशियन',
 				'gmh' => 'मिडल हाय जर्मन',
 				'gn' => 'गुआरनी',
 				'goh' => 'पुरातन हाइ जर्मन',
 				'gon' => 'गाँडी',
 				'gor' => 'गोरोन्तालो',
 				'got' => 'गॉथिक',
 				'grb' => 'ग्रेबो',
 				'grc' => 'प्राचीन ग्रीक',
 				'gsw' => 'स्विस जर्मन',
 				'gu' => 'गुजराती',
 				'gv' => 'मांक्स',
 				'gwi' => 'ग्विच\'इन',
 				'ha' => 'हौसा',
 				'hai' => 'हैडा',
 				'haw' => 'हवाईयन',
 				'he' => 'हिब्रू',
 				'hi' => 'हिंदी',
 				'hil' => 'हिलीगेनॉन',
 				'hit' => 'हिट्टिते',
 				'hmn' => 'माँग',
 				'ho' => 'हिरी मॉटू',
 				'hr' => 'क्रोएशियन',
 				'hsb' => 'अप्पर सॉर्बियन',
 				'ht' => 'हैतीयन',
 				'hu' => 'हंगेरियन',
 				'hup' => 'हूपा',
 				'hy' => 'आर्मेनियन',
 				'hz' => 'हरेरो',
 				'ia' => 'इंटरलिंग्वा',
 				'iba' => 'इबान',
 				'id' => 'इंडोनेशियन',
 				'ie' => 'इन्टरलिंग',
 				'ig' => 'ईग्बो',
 				'ii' => 'सिचुआन यी',
 				'ik' => 'इनूपियाक',
 				'ilo' => 'इलोको',
 				'inh' => 'इंगुश',
 				'io' => 'इडौ',
 				'is' => 'आईसलँडिक',
 				'it' => 'इटालियन',
 				'iu' => 'इनुकिटुट्',
 				'ja' => 'जपानी',
 				'jbo' => 'लोज्बान',
 				'jpr' => 'जुदेओ-फारसी',
 				'jrb' => 'जुदेओ-अरबी',
 				'jv' => 'जावनीस्',
 				'ka' => 'जॉर्जियन',
 				'kaa' => 'कारा-कल्पक',
 				'kab' => 'कबाइल',
 				'kac' => 'काचिन',
 				'kaj' => 'ज्जु',
 				'kam' => 'कम्बा',
 				'kaw' => 'कावी',
 				'kbd' => 'कबार्डियन',
 				'kcg' => 'त्याप',
 				'kfo' => 'कोरो',
 				'kg' => 'काँगो',
 				'kha' => 'खासी',
 				'kho' => 'खोतानीस',
 				'ki' => 'किकुयू',
 				'kj' => 'क्वान्यामा',
 				'kk' => 'कझाक',
 				'kl' => 'कलाल्लिसुत',
 				'km' => 'ख्मेर',
 				'kmb' => 'किम्बन्दु',
 				'kn' => 'कन्नड',
 				'ko' => 'कोरियन',
 				'kok' => 'कोंकणी',
 				'kos' => 'कोसरियन',
 				'kpe' => 'क्पेल्ले',
 				'kr' => 'कनुरी',
 				'krc' => 'कराचय-बाल्कर',
 				'krl' => 'करेलियन',
 				'kru' => 'कुरूख',
 				'ks' => 'काश्मीरी',
 				'ku' => 'कुर्दिश',
 				'kum' => 'कुमीक',
 				'kut' => 'कुतेनाई',
 				'kv' => 'कोमी',
 				'kw' => 'कोर्निश',
 				'ky' => 'किरगीझ',
 				'la' => 'लॅटिन',
 				'lad' => 'लादीनो',
 				'lah' => 'लाह्न्डा',
 				'lam' => 'लाम्बा',
 				'lb' => 'लक्झेंबर्गिश',
 				'lez' => 'लेझ्घीयन',
 				'lg' => 'गांडा',
 				'li' => 'लिंबूर्गिश',
 				'ln' => 'लिंगाला',
 				'lo' => 'लाओ',
 				'lol' => 'मोंगो',
 				'loz' => 'लोझि',
 				'lt' => 'लिथुआनियन',
 				'lu' => 'ल्यूबा-कटांगा',
 				'lua' => 'लुबा-लुलुआ',
 				'lui' => 'लुइसेनो',
 				'lun' => 'लुन्डा',
 				'luo' => 'ल्युओ',
 				'lus' => 'लुशाई',
 				'lv' => 'लाट्‌वियन',
 				'mad' => 'मादुरीस',
 				'mag' => 'मगही',
 				'mai' => 'मैथिली',
 				'mak' => 'मकस्सर',
 				'man' => 'मन्डिन्गो',
 				'mas' => 'मसाई',
 				'mdf' => 'मोक्ष',
 				'mdr' => 'मंडार',
 				'men' => 'मेन्डे',
 				'mfe' => 'मोरिस्येन',
 				'mg' => 'मलागसी',
 				'mga' => 'मिडल आयरिश',
 				'mh' => 'मार्शलीज',
 				'mi' => 'माओरी',
 				'mic' => 'मिकमॅक',
 				'min' => 'मिनांग्काबाउ',
 				'mk' => 'मॅसेडोनियन',
 				'ml' => 'मल्याळम',
 				'mn' => 'मंगोलियन',
 				'mnc' => 'मान्चु',
 				'mni' => 'मणिपुरी',
 				'moh' => 'मोहॉक',
 				'mos' => 'मोस्सी',
 				'mr' => 'मराठी',
 				'ms' => 'मलय',
 				'mt' => 'माल्टिज्',
 				'mul' => 'एकविध भाषा',
 				'mus' => 'क्रीक',
 				'mwl' => 'मिरांडिज्',
 				'mwr' => 'मारवाडी',
 				'my' => 'बर्मी',
 				'myv' => 'एर्झ्या',
 				'na' => 'नउरू',
 				'nap' => 'नेपोलिटान',
 				'nb' => 'नॉर्वेजियन बोकमाल',
 				'nd' => 'उत्तरी देबेली',
 				'nds' => 'लो जर्मन',
 				'ne' => 'नेपाळी',
 				'new' => 'नेवारी',
 				'ng' => 'डोंगा',
 				'nia' => 'नियास',
 				'niu' => 'नियुआन',
 				'nl' => 'डच',
 				'nl_BE' => 'फ्लेमिश',
 				'nn' => 'नॉर्वेजियन न्योर्स्क',
 				'no' => 'नोर्वेजियन',
 				'nog' => 'नोगाई',
 				'non' => 'पुरातन नॉर्स',
 				'nqo' => 'एन्को',
 				'nr' => 'दक्षिणात्य देबेली',
 				'nso' => 'उत्तरी सोथो',
 				'nv' => 'नावाजो',
 				'nwc' => 'अभिजात नेवारी',
 				'ny' => 'न्यान्जा',
 				'nym' => 'न्यामवेझी',
 				'nyn' => 'न्यानकोल',
 				'nyo' => 'न्योरो',
 				'nzi' => 'न्झिमा',
 				'oc' => 'ऑक्सितान',
 				'oj' => 'ओजिब्वा',
 				'om' => 'ओरोमो',
 				'or' => 'उडिया',
 				'os' => 'ओस्सेटिक',
 				'osa' => 'ओसेज',
 				'ota' => 'ओटोमान तुर्किश',
 				'pa' => 'पंजाबी',
 				'pag' => 'पंगासीनान',
 				'pal' => 'पहलवी',
 				'pam' => 'पाम्पान्गा',
 				'pap' => 'पापियामेन्टो',
 				'pau' => 'पालाउआन',
 				'peo' => 'पुरातन फारसी',
 				'phn' => 'फोनिशियन',
 				'pi' => 'पाली',
 				'pl' => 'पोलिश',
 				'pon' => 'पोह्नपियन',
 				'pro' => 'पुरातन प्रोव्हेन्सल',
 				'ps' => 'पश्तो',
 				'ps@alt=variant' => 'पुश्तो',
 				'pt' => 'पोर्तुगीज',
 				'pt_BR' => 'ब्राझिलियन पोर्तुगीज',
 				'pt_PT' => 'युरोपियन पोर्तुगीज',
 				'qu' => 'क्वेचुआ',
 				'raj' => 'राजस्थानी',
 				'rap' => 'रापानुई',
 				'rar' => 'रारोटोंगन',
 				'rm' => 'रोमान्श',
 				'rn' => 'रुन्दी',
 				'ro' => 'रोमानियन',
 				'ro_MD' => 'मोल्डाव्हियन',
 				'rom' => 'रोमानी',
 				'root' => 'रूट',
 				'ru' => 'रशियन',
 				'rup' => 'अरोमानियन',
 				'rw' => 'किन्यार्वान्डा',
 				'sa' => 'संस्कृत',
 				'sad' => 'सँडवे',
 				'sah' => 'याकूत',
 				'sam' => 'सामरिटान अरॅमिक',
 				'sas' => 'सासाक',
 				'sat' => 'संताली',
 				'sc' => 'सर्दिनियन',
 				'scn' => 'सिसिलियन',
 				'sco' => 'स्कॉट्स',
 				'sd' => 'सिंधी',
 				'se' => 'नॉर्दन सामी',
 				'sel' => 'सेल्कप',
 				'sg' => 'सांगो',
 				'sga' => 'पुरातन आयरिश',
 				'sh' => 'सर्बो-क्रोएशियन',
 				'shn' => 'शॅन',
 				'si' => 'सिंहला',
 				'sid' => 'सिदामो',
 				'sk' => 'स्लोव्हाक',
 				'sl' => 'स्लोव्हेनियन',
 				'sm' => 'सामोअन',
 				'sma' => 'दक्षिणात्य सामी',
 				'smj' => 'ल्युल सामी',
 				'smn' => 'इनारी सामी',
 				'sms' => 'स्कोल्ट सामी',
 				'sn' => 'शोना',
 				'snk' => 'सोनिन्के',
 				'so' => 'सोमाली',
 				'sog' => 'सोग्डिएन',
 				'sq' => 'अल्बानियन',
 				'sr' => 'सर्बियन',
 				'srn' => 'स्रानान टॉन्गो',
 				'srr' => 'सेरेर',
 				'ss' => 'स्वाती',
 				'st' => 'सेसोथो',
 				'su' => 'सुंदानीज',
 				'suk' => 'सुकुमा',
 				'sus' => 'सुसु',
 				'sux' => 'सुमेरियन',
 				'sv' => 'स्वीडिश',
 				'sw' => 'स्वाहिली',
 				'swb' => 'कोमोरियन',
 				'syc' => 'अभिजात सिरियाक',
 				'syr' => 'सिरियाक',
 				'ta' => 'तामिळ',
 				'te' => 'तेलगू',
 				'tem' => 'टिम्ने',
 				'ter' => 'तेरेनो',
 				'tet' => 'तेतुम',
 				'tg' => 'ताजिक',
 				'th' => 'थाई',
 				'ti' => 'टिग्रिन्या',
 				'tig' => 'टाइग्रे',
 				'tiv' => 'तिव',
 				'tk' => 'तुर्कमेन',
 				'tkl' => 'टोकेलाऊ',
 				'tl' => 'टागालोग',
 				'tlh' => 'क्लिंगोन',
 				'tli' => 'लिंगित',
 				'tmh' => 'तामाशेक',
 				'tn' => 'त्स्वाना',
 				'to' => 'टोंगन',
 				'tog' => 'न्यासा टोन्गा',
 				'tpi' => 'टोक पिसिन',
 				'tr' => 'तुर्की',
 				'ts' => 'सोंगा',
 				'tsi' => 'सिम्शियन',
 				'tt' => 'ततार',
 				'tum' => 'तुम्बुका',
 				'tvl' => 'टुवालु',
 				'tw' => 'ट्वी',
 				'ty' => 'ताहितीयन',
 				'tyv' => 'टुवीनियन',
 				'udm' => 'उदमुर्त',
 				'ug' => 'उइगुर',
 				'uga' => 'युगॅरिटिक',
 				'uk' => 'युक्रेनियन',
 				'umb' => 'उम्बुन्डु',
 				'und' => 'अज्ञात भाषा',
 				'ur' => 'उर्दू',
 				'uz' => 'उझ्बेक',
 				'vai' => 'वाई',
 				've' => 'व्हेंदा',
 				'vi' => 'व्हिएतनामी',
 				'vo' => 'ओलापुक',
 				'vot' => 'वॉटिक',
 				'wa' => 'वालून',
 				'wal' => 'वलामो',
 				'war' => 'वारे',
 				'was' => 'वाशो',
 				'wo' => 'वोलोफ',
 				'xal' => 'काल्मिक',
 				'xh' => 'खोसा',
 				'yao' => 'याओ',
 				'yap' => 'यापीस',
 				'yi' => 'यिद्दिश',
 				'yo' => 'योरुबा',
 				'yue' => 'कँटोनीज',
 				'za' => 'झुआंग',
 				'zap' => 'झेपोटेक',
 				'zbl' => 'ब्लिसिम्बॉल्स',
 				'zen' => 'झेनान्गा',
 				'zgh' => 'मानक मोरोक्कन तामाझाइट',
 				'zh' => 'चीनी',
 				'zh_Hans' => 'सरलीकृत चीनी',
 				'zh_Hant' => 'पारंपारिक चीनी',
 				'zu' => 'झुलू',
 				'zun' => 'झुनी',
 				'zxx' => 'भाषावैज्ञानिक सामग्री नाही',
 				'zza' => 'झाझा',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Arab' => 'अरबी',
 			'Arab@alt=variant' => 'फारसी-अरबी',
 			'Armi' => 'इम्पिरियल आर्मेनिक',
 			'Armn' => 'अर्मेनियन',
 			'Avst' => 'अवेस्तान',
 			'Bali' => 'बाली',
 			'Batk' => 'बटाक',
 			'Beng' => 'बंगाली',
 			'Blis' => 'ब्लिसिम्बॉल्स',
 			'Bopo' => 'बोपोमोफो',
 			'Brah' => 'ब्रह्मी',
 			'Brai' => 'ब्रेल',
 			'Bugi' => 'बूगी',
 			'Buhd' => 'बुहिद',
 			'Cakm' => 'चकमा',
 			'Cans' => 'यूनिफाइड कॅनेडियन अ‍ॅबोरिदनल सिलॅबिक्स',
 			'Cari' => 'कॅरियन',
 			'Cham' => 'चाम',
 			'Cher' => 'चेरोकी',
 			'Cirt' => 'किर्थ',
 			'Copt' => 'कॉप्टिक',
 			'Cprt' => 'सायप्रिऑट',
 			'Cyrl' => 'सीरिलिक',
 			'Cyrs' => 'पुरातन चर्च स्लाव्होनिक सिरिलिक',
 			'Deva' => 'देवनागरी',
 			'Dsrt' => 'डेसर्ट',
 			'Egyd' => 'इजिप्शियन डेमोटिक',
 			'Egyh' => 'इजिप्शियन हायरेटिक',
 			'Egyp' => 'इजिप्शियन हायरोग्लिफ्स',
 			'Ethi' => 'ईथिओपिक',
 			'Geok' => 'जॉर्जियन खुत्सुरी',
 			'Geor' => 'जॉर्जियन',
 			'Glag' => 'ग्लॅगोलिटिक',
 			'Goth' => 'गोथिक',
 			'Grek' => 'ग्रीक',
 			'Gujr' => 'गुजराती',
 			'Guru' => 'गुरुमुखी',
 			'Hang' => 'हंगुल',
 			'Hani' => 'हान',
 			'Hano' => 'हनुनू',
 			'Hans' => 'सरलीकृत',
 			'Hans@alt=stand-alone' => 'सरलीकृत हान',
 			'Hant' => 'पारंपारिक',
 			'Hant@alt=stand-alone' => 'पारंपारिक हान',
 			'Hebr' => 'हिब्रू',
 			'Hira' => 'हिरागाना',
 			'Hmng' => 'पहाउ मंग',
 			'Hrkt' => 'कॅटाकना आणि हिरागाना',
 			'Hung' => 'पुरातन हंगेरियन',
 			'Inds' => 'सिन्धु',
 			'Ital' => 'जुनी इटालिक',
 			'Java' => 'जावानीस',
 			'Jpan' => 'जपानी',
 			'Kali' => 'कायाह ली',
 			'Kana' => 'कॅटाकाना',
 			'Khar' => 'खारोश्थी',
 			'Khmr' => 'ख्मेर',
 			'Knda' => 'कन्नड',
 			'Kore' => 'कोरियन',
 			'Kthi' => 'काइथी',
 			'Lana' => 'लाना',
 			'Laoo' => 'लाओ',
 			'Latf' => 'फ्रॅक्तुर लॅटिन',
 			'Latg' => 'गाएलिक लेटिन',
 			'Latn' => 'लॅटिन',
 			'Lepc' => 'लेपचा',
 			'Limb' => 'लिम्बू',
 			'Lina' => 'लीनियार अ',
 			'Linb' => 'लीनियर बी',
 			'Lyci' => 'लायशियान',
 			'Lydi' => 'लायडियान',
 			'Mand' => 'मान्डायीन',
 			'Mani' => 'मानीचायीन',
 			'Maya' => 'मायान हाइरोग्लिफ्स',
 			'Mero' => 'मेरोइटिक',
 			'Mlym' => 'मल्याळम',
 			'Mong' => 'मंगोलियन',
 			'Moon' => 'मून',
 			'Mtei' => 'मेइतेइ मायेक',
 			'Mymr' => 'म्यानमार',
 			'Nkoo' => 'एन्\'को',
 			'Ogam' => 'ओघाम',
 			'Olck' => 'ओल चिकि',
 			'Orkh' => 'ओर्खोन',
 			'Orya' => 'उडिया',
 			'Osma' => 'उस्मानिया',
 			'Perm' => 'पुरातन पर्मिक',
 			'Phag' => 'फाग्स-पा',
 			'Phli' => 'इन्स्क्रिप्शनल पाहलवी',
 			'Phlp' => 'सॉल्टर पाहलवी',
 			'Phlv' => 'बुक पाहलवी',
 			'Phnx' => 'फोनिशियन',
 			'Plrd' => 'पोलार्ड फोनेटिक',
 			'Prti' => 'इन्स्क्रिप्शनल पर्थियन',
 			'Rjng' => 'रीजांग',
 			'Roro' => 'रोन्गोरोन्गो',
 			'Runr' => 'रूनिक',
 			'Samr' => 'समरिटान',
 			'Sara' => 'सराती',
 			'Saur' => 'सौराष्ट्र',
 			'Sgnw' => 'संकेत लिपी',
 			'Shaw' => 'शॅव्हियन',
 			'Sinh' => 'सिंहला',
 			'Sund' => 'सूदानी',
 			'Sylo' => 'सिलोती नागरी',
 			'Syrc' => 'सिरीयाक',
 			'Syre' => 'एस्त्ट्रेन्जेलो सिरियाक',
 			'Syrj' => 'पश्चिमी सिरियाक',
 			'Syrn' => 'पूर्वी सिरियाक',
 			'Tagb' => 'तगोआन्वा',
 			'Tale' => 'ताई ली',
 			'Talu' => 'नवीन ताई लू',
 			'Taml' => 'तामिळ',
 			'Tavt' => 'ताई विएत',
 			'Telu' => 'तेलगु',
 			'Teng' => 'तेन्गवार',
 			'Tfng' => 'तिफिनाघ',
 			'Tglg' => 'टागालोग',
 			'Thaa' => 'थाना',
 			'Thai' => 'थाई',
 			'Tibt' => 'तिबेटी',
 			'Ugar' => 'युगारिटिक',
 			'Vaii' => 'वाई',
 			'Visp' => 'दृश्य संवाद',
 			'Xpeo' => 'पुरातन फारसी',
 			'Xsux' => 'दृश्यमान भाषा',
 			'Yiii' => 'यी',
 			'Zinh' => 'वंशपरंपरागत',
 			'Zmth' => 'गणिती संकेतलिपी',
 			'Zsym' => 'प्रतीक',
 			'Zxxx' => 'अलिखित',
 			'Zyyy' => 'सामान्य',
 			'Zzzz' => 'अज्ञात लिपी',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_territory' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'001' => 'विश्व',
 			'002' => 'आफ्रिका',
 			'003' => 'उत्तर अमेरिका',
 			'005' => 'दक्षिण अमेरिका',
 			'009' => 'ओशनिया',
 			'011' => 'पश्चिम आफ्रिका',
 			'013' => 'मध्य अमेरिका',
 			'014' => 'पूर्व आफ्रिका',
 			'015' => 'उत्तर आफ्रिका',
 			'017' => 'मध्य आफ्रिका',
 			'018' => 'दक्षिणी आफ्रिका',
 			'019' => 'अमेरिका',
 			'021' => 'उत्तरी अमेरिका',
 			'029' => 'कॅरीबियन',
 			'030' => 'पूर्व अशिया',
 			'034' => 'दक्षिण अशिया',
 			'035' => 'दक्षिण पूर्व अशिया',
 			'039' => 'दक्षिण युरोप',
 			'053' => 'ऑस्‍ट्रेलेशिया',
 			'054' => 'मेलानेशिया',
 			'057' => 'मायक्रोनेशियन प्रदेश',
 			'061' => 'पॉलिनेशिया',
 			'142' => 'अशिया',
 			'143' => 'मध्य अशिया',
 			'145' => 'पश्चिम अशिया',
 			'150' => 'युरोप',
 			'151' => 'पूर्व युरोप',
 			'154' => 'उत्तर युरोप',
 			'155' => 'पश्चिम युरोप',
 			'419' => 'लॅटिन अमेरिका',
 			'AC' => 'अ‍ॅसेन्शियन बेट',
 			'AD' => 'अँडोरा',
 			'AE' => 'संयुक्त अरब अमीरात',
 			'AF' => 'अफगाणिस्तान',
 			'AG' => 'अँटिग्वा आणि बर्बुडा',
 			'AI' => 'अँग्विला',
 			'AL' => 'अल्बानिया',
 			'AM' => 'अर्मेनिया',
 			'AN' => 'नेदरलँड्‍स अँ‍टिल्स',
 			'AO' => 'अंगोला',
 			'AQ' => 'अंटार्क्टिका',
 			'AR' => 'अर्जेंटिना',
 			'AS' => 'अमेरिकन सामोआ',
 			'AT' => 'ऑस्ट्रिया',
 			'AU' => 'ऑस्ट्रेलिया',
 			'AW' => 'अरुबा',
 			'AX' => 'अ‍ॅलँड बेटे',
 			'AZ' => 'अझरबैजान',
 			'BA' => 'बोस्निया अणि हर्जेगोविना',
 			'BB' => 'बार्बाडोस',
 			'BD' => 'बांग्लादेश',
 			'BE' => 'बेल्जियम',
 			'BF' => 'बुर्किना फासो',
 			'BG' => 'बल्गेरिया',
 			'BH' => 'बहारीन',
 			'BI' => 'बुरुंडी',
 			'BJ' => 'बेनिन',
 			'BL' => 'सेंट बार्थेलेमी',
 			'BM' => 'बर्मुडा',
 			'BN' => 'ब्रुनेई',
 			'BO' => 'बोलिव्हिया',
 			'BQ' => 'कॅरिबियन नेदरलँड्स',
 			'BR' => 'ब्राझिल',
 			'BS' => 'बहामाज',
 			'BT' => 'भूतान',
 			'BV' => 'बोउवेट बेट',
 			'BW' => 'बोट्सवाना',
 			'BY' => 'बेलारूस',
 			'BZ' => 'बेलिझे',
 			'CA' => 'कॅनडा',
 			'CC' => 'कोकोस बेटे',
 			'CD' => 'काँगो - किंशासा',
 			'CD@alt=variant' => 'काँगो (ङीआरसी)',
 			'CF' => 'केंद्रीय अफ्रिकी प्रजासत्ताक',
 			'CG' => 'काँगो - ब्राझाविले',
 			'CG@alt=variant' => 'काँगो (प्रजासत्ताक)',
 			'CH' => 'स्वित्झर्लंड',
 			'CI' => 'आयव्हरी कोस्ट',
 			'CK' => 'कुक बेटे',
 			'CL' => 'चिली',
 			'CM' => 'कॅमेरून',
 			'CN' => 'चीन',
 			'CO' => 'कोलम्बिया',
 			'CP' => 'क्लिपरटोन बेट',
 			'CR' => 'कोस्टारिका',
 			'CU' => 'क्यूबा',
 			'CV' => 'केप व्हर्डे',
 			'CW' => 'कुरॅको',
 			'CX' => 'ख्रिसमस बेट',
 			'CY' => 'सायप्रस',
 			'CZ' => 'झेक प्रजासत्ताक',
 			'DE' => 'जर्मनी',
 			'DG' => 'दिएगो गार्सिया',
 			'DJ' => 'जिबौटी',
 			'DK' => 'डेन्मार्क',
 			'DM' => 'डोमिनिका',
 			'DO' => 'डोमिनिकन प्रजासत्ताक',
 			'DZ' => 'अल्जीरिया',
 			'EA' => 'स्यूटा आणि मेलिला',
 			'EC' => 'इक्वाडोर',
 			'EE' => 'एस्टोनिया',
 			'EG' => 'इजिप्त',
 			'EH' => 'पश्चिम सहारा',
 			'ER' => 'एरिट्रिया',
 			'ES' => 'स्पेन',
 			'ET' => 'इथिओपिया',
 			'EU' => 'युरोपीय संघ',
 			'FI' => 'फिनलंड',
 			'FJ' => 'फिजी',
 			'FK' => 'फॉकलंड बेटे',
 			'FK@alt=variant' => 'फॉकलंड बेटे (इस्लास मालविनास)',
 			'FM' => 'मायक्रोनेशिया',
 			'FO' => 'फरोए बेटे',
 			'FR' => 'फ्रान्स',
 			'GA' => 'गॅबॉन',
 			'GB' => 'युनायटेड किंगडम',
 			'GB@alt=short' => 'यू.के.',
 			'GD' => 'ग्रेनेडा',
 			'GE' => 'जॉर्जिया',
 			'GF' => 'फ्रेंच गयाना',
 			'GG' => 'ग्वेर्नसे',
 			'GH' => 'घाना',
 			'GI' => 'जिब्राल्टर',
 			'GL' => 'ग्रीनलंड',
 			'GM' => 'गाम्बिया',
 			'GN' => 'गिनी',
 			'GP' => 'ग्वाडेलोउपे',
 			'GQ' => 'इक्वेटोरियल गिनी',
 			'GR' => 'ग्रीस',
 			'GS' => 'दक्षिण जॉर्जिया आणि दक्षिण सँडविच बेटे',
 			'GT' => 'ग्वाटेमाला',
 			'GU' => 'गुआम',
 			'GW' => 'गिनी-बिसाउ',
 			'GY' => 'गयाना',
 			'HK' => 'हाँगकाँग एसएआर चीन',
 			'HK@alt=short' => 'हाँगकाँग',
 			'HM' => 'हर्ड आणि मॅक्डोनाल्ड बेटे',
 			'HN' => 'होंडुरास',
 			'HR' => 'क्रोएशिया',
 			'HT' => 'हैती',
 			'HU' => 'हंगेरी',
 			'IC' => 'कॅनरी बेटे',
 			'ID' => 'इंडोनेशिया',
 			'IE' => 'आयर्लंड',
 			'IL' => 'इस्त्राइल',
 			'IM' => 'इस्ले ऑफ मॅन',
 			'IN' => 'भारत',
 			'IO' => 'ब्रिटिश इंडियन ओशन प्रदेश',
 			'IQ' => 'इराक',
 			'IR' => 'ईराण',
 			'IS' => 'आइसलँड',
 			'IT' => 'इटली',
 			'JE' => 'जर्सी',
 			'JM' => 'जमैका',
 			'JO' => 'जॉर्डन',
 			'JP' => 'जपान',
 			'KE' => 'केनिया',
 			'KG' => 'किरगिझस्तान',
 			'KH' => 'कंबोडिया',
 			'KI' => 'किरीबाटी',
 			'KM' => 'कोमोरोज',
 			'KN' => 'सेंट किट्स आणि नेव्हिस',
 			'KP' => 'उत्तर कोरिया',
 			'KR' => 'दक्षिण कोरिया',
 			'KW' => 'कुवेत',
 			'KY' => 'केमन बेटे',
 			'KZ' => 'कझाकस्तान',
 			'LA' => 'लाओस',
 			'LB' => 'लेबनॉन',
 			'LC' => 'सेंट ल्यूसिया',
 			'LI' => 'लिंचेनस्टाइन',
 			'LK' => 'श्रीलंका',
 			'LR' => 'लायबेरिया',
 			'LS' => 'लेसोथो',
 			'LT' => 'लिथुआनिया',
 			'LU' => 'लक्झेंबर्ग',
 			'LV' => 'लाट्‌विया',
 			'LY' => 'लिबिया',
 			'MA' => 'मोरोक्को',
 			'MC' => 'मोनॅको',
 			'MD' => 'मोल्डोव्हा',
 			'ME' => 'मोंटेनेग्रो',
 			'MF' => 'सेंट मार्टिन',
 			'MG' => 'मादागास्कर',
 			'MH' => 'मार्शल बेटे',
 			'MK' => 'मॅसेडोनिया',
 			'MK@alt=variant' => 'मॅसेडोनिया (FYROM)',
 			'ML' => 'माली',
 			'MM' => 'म्यानमार (बर्मा)',
 			'MN' => 'मंगोलिया',
 			'MO' => 'मकाओ एसएआर चीन',
 			'MO@alt=short' => 'मकाऊ',
 			'MP' => 'उत्तरी मारियाना बेटे',
 			'MQ' => 'मार्टिनिक',
 			'MR' => 'मॉरिटानिया',
 			'MS' => 'मॉन्ट्सेराट',
 			'MT' => 'माल्टा',
 			'MU' => 'मॉरिशस',
 			'MV' => 'मालदीव',
 			'MW' => 'मलावी',
 			'MX' => 'मेक्सिको',
 			'MY' => 'मलेशिया',
 			'MZ' => 'मोझाम्बिक',
 			'NA' => 'नामिबिया',
 			'NC' => 'न्यू कॅलेडोनिया',
 			'NE' => 'नाइजर',
 			'NF' => 'नॉरफॉक बेट',
 			'NG' => 'नायजेरिया',
 			'NI' => 'निकाराग्वे',
 			'NL' => 'नेदरलँड',
 			'NO' => 'नॉर्वे',
 			'NP' => 'नेपाळ',
 			'NR' => 'नऊरु',
 			'NU' => 'नीयू',
 			'NZ' => 'न्यूझीलंड',
 			'OM' => 'ओमान',
 			'PA' => 'पनामा',
 			'PE' => 'पेरू',
 			'PF' => 'फ्रेंच पॉलिनेशिया',
 			'PG' => 'पापुआ न्यू गिनी',
 			'PH' => 'फिलिपिन्स',
 			'PK' => 'पाकिस्तान',
 			'PL' => 'पोलंड',
 			'PM' => 'सेंट पियरे आणि मिक्वेलोन',
 			'PN' => 'पिटकैर्न बेटे',
 			'PR' => 'पोर्टो रिको',
 			'PS' => 'पॅलेस्टिनियन प्रदेश',
 			'PS@alt=short' => 'पॅलेस्टाईन',
 			'PT' => 'पोर्तुगाल',
 			'PW' => 'पलाऊ',
 			'PY' => 'पराग्वे',
 			'QA' => 'कतार',
 			'QO' => 'आउटलाईंग ओशनिया',
 			'RE' => 'रियुनियन',
 			'RO' => 'रोमानिया',
 			'RS' => 'सर्बिया',
 			'RU' => 'रशिया',
 			'RW' => 'रवांडा',
 			'SA' => 'सौदी अरब',
 			'SB' => 'सोलोमन बेटे',
 			'SC' => 'सेशेल्स',
 			'SD' => 'सुदान',
 			'SE' => 'स्वीडन',
 			'SG' => 'सिंगापूर',
 			'SH' => 'सेंट हेलेना',
 			'SI' => 'स्लोव्हेनिया',
 			'SJ' => 'स्वालबर्ड आणि जान मायेन',
 			'SK' => 'स्लोव्हाकिया',
 			'SL' => 'सिएरा लिओन',
 			'SM' => 'सॅन मरीनो',
 			'SN' => 'सेनेगल',
 			'SO' => 'सोमालिया',
 			'SR' => 'सुरिनाम',
 			'SS' => 'दक्षिण सुदान',
 			'ST' => 'साओ टोम आणि प्रिंसिपे',
 			'SV' => 'अल साल्वाडोर',
 			'SX' => 'सिंट मार्टेन',
 			'SY' => 'सीरिया',
 			'SZ' => 'स्वाझिलँड',
 			'TA' => 'ट्रिस्टन दा कन्हा',
 			'TC' => 'टर्क्स आणि कैकोस बेटे',
 			'TD' => 'चाड',
 			'TF' => 'फ्रेंच दाक्षिणात्य प्रदेश',
 			'TG' => 'टोगो',
 			'TH' => 'थायलंड',
 			'TJ' => 'ताजिकिस्तान',
 			'TK' => 'तोकेलाउ',
 			'TL' => 'पूर्व तिमोर',
 			'TM' => 'तुर्कमेनिस्तान',
 			'TN' => 'ट्यूनिशिया',
 			'TO' => 'टोंगा',
 			'TR' => 'तुर्की',
 			'TT' => 'त्रिनिदाद आणि टोबॅगो',
 			'TV' => 'टुवालु',
 			'TW' => 'तैवान',
 			'TZ' => 'टांझानिया',
 			'UA' => 'युक्रेन',
 			'UG' => 'युगांडा',
 			'UM' => 'यू.एस. आउटलाइंग बेटे',
 			'US' => 'युनायटेड स्टेट्स',
 			'US@alt=short' => 'यू.एस.',
 			'UY' => 'उरुग्वे',
 			'UZ' => 'उझबेकिस्तान',
 			'VA' => 'व्हॅटिकन सिटी',
 			'VC' => 'सेंट व्हिन्सेंट आणि ग्रेनडाइन्स',
 			'VE' => 'व्हेनेझुएला',
 			'VG' => 'ब्रिटिश व्हर्जिन बेटे',
 			'VI' => 'यू.एस. व्हर्जिन बेटे',
 			'VN' => 'व्हिएतनाम',
 			'VU' => 'वानौटु',
 			'WF' => 'वालिस आणि फ्यूचूना',
 			'WS' => 'सामोआ',
 			'XK' => 'कोसोव्हो',
 			'YE' => 'येमेन',
 			'YT' => 'मायोट्टे',
 			'ZA' => 'दक्षिण आफ्रिका',
 			'ZM' => 'झाम्बिया',
 			'ZW' => 'झिम्बाब्वे',
 			'ZZ' => 'अज्ञात प्रदेश',

		}
	},
);

has 'display_name_variant' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'PINYIN' => 'पिनयिन रोमनायझेशन',
 			'WADEGILE' => 'वादे-गिलेस रोमनायझेशन',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'calendar' => 'दिनदर्शिका',
 			'colalternate' => 'प्रतीक क्रमवारीकडे दुर्लक्ष करा',
 			'colbackwards' => 'उलट उच्चार क्रमवारी',
 			'colcasefirst' => 'अपरकेस/लोअरकेस क्रम',
 			'colcaselevel' => 'केस संवेदी क्रमवारी',
 			'colhiraganaquaternary' => 'काना क्रमवारी',
 			'collation' => 'क्रमवारी क्रम',
 			'colnormalization' => 'सामान्य क्रमवारी',
 			'colnumeric' => 'अंकीय क्रमवारी',
 			'colstrength' => 'क्रमवारी सामर्थ्य',
 			'currency' => 'चलन',
 			'numbers' => 'संख्या',
 			'timezone' => 'टाइम झोन',
 			'va' => 'लोकेल व्हेरियंट',
 			'variabletop' => 'प्रतीक म्हणून क्रमवारी लावा',
 			'x' => 'खासगी-वापर',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[Str]]',
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{बौद्ध दिनदर्शिका},
 				'chinese' => q{चीनी दिनदर्शिका},
 				'coptic' => q{कॉप्टिक दिनदर्शिका},
 				'ethiopic' => q{इथिओपिक दिनदर्शिका},
 				'ethiopic-amete-alem' => q{इतिओपिक अमेटे अलेम दिनदर्शिका},
 				'gregorian' => q{ग्रेगोरियन दिनदर्शिका},
 				'hebrew' => q{यहूदी दिनदर्शिका},
 				'indian' => q{भारतीय राष्ट्रीय दिनदर्शिका},
 				'islamic' => q{मुस्लिम दिनदर्शिका},
 				'islamic-civil' => q{मुस्लिम- नागरी दिनदर्शिका},
 				'japanese' => q{जपानी दिनदर्शिका},
 				'persian' => q{फारसी दिनदर्शिका},
 				'roc' => q{मिनदोउ दिनदर्शिका},
 			},
 			'colalternate' => {
 				'non-ignorable' => q{प्रतीकांची क्रमवारी लावा},
 				'shifted' => q{दुर्लक्षित प्रतीकांची क्रमवारी लावा},
 			},
 			'colbackwards' => {
 				'no' => q{सामान्यपणे उच्चार क्रमवारी करा},
 				'yes' => q{उलट उच्चार क्रमवारी लावा},
 			},
 			'colcasefirst' => {
 				'lower' => q{प्रथम लोअरकेस क्रमवारी लावा},
 				'no' => q{सामान्य केस क्रमाची क्रमवारी लावा},
 				'upper' => q{प्रथम अपरकेस क्रमवारी लावा},
 			},
 			'colcaselevel' => {
 				'no' => q{केस संवेदी क्रमवारी लावा},
 				'yes' => q{केस संवेदी क्रमवारी लावा},
 			},
 			'colhiraganaquaternary' => {
 				'no' => q{काना विभक्तपणे क्रमवारी लावा},
 				'yes' => q{काना भिन्नपणे क्रमवारी लावा},
 			},
 			'collation' => {
 				'big5han' => q{पारंपारिक चिनी क्रमवारी क्रम - Big5},
 				'dictionary' => q{शब्दकोश अनुक्रम},
 				'ducet' => q{डीफॉल्ट युनिकोड क्रमवारी क्रम},
 				'gb2312han' => q{सरलीकृत चिनी क्रमवारी क्रम - GB2312},
 				'phonebook' => q{फोनबुक अनुक्रम},
 				'phonetic' => q{ध्वनीविचार क्रमवारी क्रम},
 				'pinyin' => q{पिनयिन अनुक्रम},
 				'reformed' => q{पुनर्स्वरूपित अनुक्रम},
 				'search' => q{सामान्य हेतु शोध},
 				'searchjl' => q{हँगुल प्रारंभिक व्यंजनानुसार शोधा},
 				'standard' => q{प्रमाणित क्रमवारी क्रम},
 				'stroke' => q{स्ट्रोक अनुक्रम},
 				'traditional' => q{पारंपारिक अनुक्रम},
 				'unihan' => q{रॅडिकल-स्ट्रोक अनुक्रम},
 			},
 			'colnormalization' => {
 				'no' => q{नेहमीसारखे न करता क्रमवारी लावा},
 				'yes' => q{युनिकोड सामान्यीकृत क्रमवारी लावा},
 			},
 			'colnumeric' => {
 				'no' => q{अंकांची वैयक्तिकरित्या क्रमवारी लावा},
 				'yes' => q{अंकांची संख्‍याक्रमानुसार क्रमवारी लावा},
 			},
 			'colstrength' => {
 				'identical' => q{सर्व क्रमवारी लावा},
 				'primary' => q{केवळ मूळ अक्षरांची क्रमवारी लावा},
 				'quaternary' => q{उच्चार/केस/रुंदी/काना क्रमवारी लावा},
 				'secondary' => q{उच्चार क्रमवारी लावा},
 				'tertiary' => q{उच्चार/केस/रुंदीची क्रमवारी लावा},
 			},
 			'numbers' => {
 				'arab' => q{अरबी-भारतीय अंक},
 				'arabext' => q{विस्तारित अरबी-भारतीय अंक},
 				'armn' => q{अमेरिकन अंक},
 				'armnlow' => q{अमेरिकन छोटी लिपी अंक},
 				'beng' => q{बंगाली अंक},
 				'deva' => q{देवनागरी अंक},
 				'ethi' => q{इथिओपिक अंक},
 				'finance' => q{वित्तीय संख्‍या},
 				'fullwide' => q{पूर्ण रुंदीचे अंक},
 				'geor' => q{जॉर्जियन अंक},
 				'grek' => q{ग्रीक अंक},
 				'greklow' => q{ग्रीक लहान लिपीचे अंक},
 				'gujr' => q{गुजराती अंक},
 				'guru' => q{गुरमुखी अंक},
 				'hanidec' => q{चीनी दशांश अंक},
 				'hans' => q{सरलीकृत चीनी अंक},
 				'hansfin' => q{सरलीकृत चीनी वित्तीय अंक},
 				'hant' => q{पारंपारिक चीनी अंक},
 				'hantfin' => q{पारंपारिक चीनी वित्तीय अंक},
 				'hebr' => q{हिब्रू अंक},
 				'jpan' => q{जपानी अंक},
 				'jpanfin' => q{जपानी वित्तीय अंक},
 				'khmr' => q{ख्मेर अंक},
 				'knda' => q{कन्नड अंक},
 				'laoo' => q{लाओ अंक},
 				'latn' => q{पश्चिमी अंक},
 				'mlym' => q{मल्याळम अंक},
 				'mong' => q{मंगोलियन अंक},
 				'mymr' => q{म्यानमार अंक},
 				'native' => q{मूळ अंक},
 				'orya' => q{उडिया अंक},
 				'roman' => q{रोमन अंक},
 				'romanlow' => q{रोमन लहान लिपीचे अंक},
 				'taml' => q{पारंपारिक तामिळ अंक},
 				'tamldec' => q{तामिळ अंक},
 				'telu' => q{तेलगु अंक},
 				'thai' => q{थाई अंक},
 				'tibt' => q{तिबेटी अंक},
 				'traditional' => q{पारंपारिक संख्‍या},
 				'vaii' => q{व्हाई अंक},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'metric' => q{मेट्रिक},
 			'UK' => q{यूके},
 			'US' => q{यूएस},

		}
	},
);

has 'display_name_transform_name' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'bgn' => 'BGN',
 			'numeric' => 'अंकीय',
 			'tone' => 'स्वर',
 			'ungegn' => 'UNGEGN',
 			'x-accents' => 'गडद-फिकेपणा',
 			'x-fullwidth' => 'पूर्णरुंदी',
 			'x-halfwidth' => 'अर्धीरुंदी',
 			'x-jamo' => 'जामो',
 			'x-pinyin' => 'पिनयिन',
 			'x-publishing' => 'प्रकाशन',

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'language' => 'भाषा: {0}',
 			'script' => 'लिपी: {0}',
 			'territory' => 'प्रदेश: {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{(?^u:[‌‍])},
			index => ['\u200D', 'ॐ', '\u0902', 'ः', 'अ', 'आ', 'इ', 'ई', 'उ', 'ऊ', 'ऋ', 'ऌ', 'ए', 'ऐ', 'ऑ', 'ओ', 'औ', 'क', 'ख', 'ग', 'घ', 'ङ', 'च', 'छ', 'ज', 'झ', 'ञ', 'ट', 'ठ', 'ड', 'ढ', 'ण', 'त', 'थ', 'द', 'ध', 'न', 'प', 'फ', 'ब', 'भ', 'म', 'य', 'र', 'ल', 'व', 'श', 'ष', 'स', 'ह', 'ळ', 'ऽ', '\u0945', '\u094D'],
			main => qr{(?^u:[़ ० १ २ ३ ४ ५ ६ ७ ८ ९ ॐ ं ँ ः अ आ इ ई उ ऊ ऋ ऌ ऍ ए ऐ ऑ ओ औ क ख ग घ ङ च छ ज झ ञ ट ठ ड ढ ण त थ द ध न प फ ब भ म य र ल व श ष स ह ळ ऽ ा ि ी ु ू ृ ॄ ॅ े ै ॉ ो ौ ्])},
			punctuation => qr{(?^u:[\- ‐ – — , ; \: ! ? . … ' ‘ ’ " “ ” ( ) \[ \] @ * / \& # ′ ″])},
		};
	},
EOT
: sub {
		return { index => ['\u200D', 'ॐ', '\u0902', 'ः', 'अ', 'आ', 'इ', 'ई', 'उ', 'ऊ', 'ऋ', 'ऌ', 'ए', 'ऐ', 'ऑ', 'ओ', 'औ', 'क', 'ख', 'ग', 'घ', 'ङ', 'च', 'छ', 'ज', 'झ', 'ञ', 'ट', 'ठ', 'ड', 'ढ', 'ण', 'त', 'थ', 'द', 'ध', 'न', 'प', 'फ', 'ब', 'भ', 'म', 'य', 'र', 'ल', 'व', 'श', 'ष', 'स', 'ह', 'ळ', 'ऽ', '\u0945', '\u094D'], };
},
);


has 'ellipsis' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub {
		return {
			'final' => '{0}…',
			'initial' => '…{0}',
			'medial' => '{0}…{1}',
			'word-final' => '{0} …',
			'word-initial' => '… {0}',
			'word-medial' => '{0} … {1}',
		};
	},
);

has 'more_information' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{?},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{“},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{”},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{‘},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{’},
);

has 'duration_units' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { {
				hm => 'h:mm',
				hms => 'h:mm:ss',
				ms => 'm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[HashRef[Str]]]',
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					'acre' => {
						'one' => q({0} एकर),
						'other' => q({0} एकर),
					},
					'arc-minute' => {
						'one' => q({0} मिनिट),
						'other' => q({0} मिनिटे),
					},
					'arc-second' => {
						'one' => q({0} सेकंद),
						'other' => q({0} सेकंद),
					},
					'celsius' => {
						'one' => q({0} अंश सेल्सिअस),
						'other' => q({0} अंश सेल्सिअस),
					},
					'centimeter' => {
						'one' => q({0} सेंटीमीटर),
						'other' => q({0} सेंटीमीटर),
					},
					'cubic-kilometer' => {
						'one' => q({0} क्युबिक किलोमीटर),
						'other' => q({0} क्युबिक किलोमीटर),
					},
					'cubic-mile' => {
						'one' => q({0} क्युबिक मैल),
						'other' => q({0} क्युबिक मैल),
					},
					'day' => {
						'one' => q({0} दिवस),
						'other' => q({0} दिवस),
					},
					'degree' => {
						'one' => q({0} अंश),
						'other' => q({0} अंश),
					},
					'fahrenheit' => {
						'one' => q({0} अंश फॅरनहाईट),
						'other' => q({0} अंश फॅरनहाईट),
					},
					'foot' => {
						'one' => q({0} फूट),
						'other' => q({0} फूट),
					},
					'g-force' => {
						'one' => q({0} जी-फोर्स),
						'other' => q({0} जी-फोर्स),
					},
					'gram' => {
						'one' => q({0} ग्रॅम),
						'other' => q({0} ग्रॅम),
					},
					'hectare' => {
						'one' => q({0} हेक्टर),
						'other' => q({0} हेक्टर),
					},
					'hectopascal' => {
						'one' => q({0} हेक्टोपास्कल),
						'other' => q({0} हेक्टोपास्कल),
					},
					'horsepower' => {
						'one' => q({0} हॉर्सपॉवर),
						'other' => q({0} हॉर्सपॉवर),
					},
					'hour' => {
						'one' => q({0} तास),
						'other' => q({0} तास),
					},
					'inch' => {
						'one' => q({0} इंच),
						'other' => q({0} इंच),
					},
					'inch-hg' => {
						'one' => q({0} मर्क्यूरी इंच),
						'other' => q({0} मर्क्यूरी इंच),
					},
					'kilogram' => {
						'one' => q({0} किलोग्रॅम),
						'other' => q({0} किलोग्रॅम),
					},
					'kilometer' => {
						'one' => q({0} किलोमीटर),
						'other' => q({0} किलोमीटर),
					},
					'kilometer-per-hour' => {
						'one' => q({0} किलोमीटर प्रति तास),
						'other' => q({0} किलोमीटर प्रति तास),
					},
					'kilowatt' => {
						'one' => q({0} किलोवॉट),
						'other' => q({0} किलोवॉट),
					},
					'light-year' => {
						'one' => q({0} प्रकाश वर्ष),
						'other' => q({0} प्रकाश वर्षे),
					},
					'liter' => {
						'one' => q({0} लीटर),
						'other' => q({0} लीटर),
					},
					'meter' => {
						'one' => q({0} मीटर),
						'other' => q({0} मीटर),
					},
					'meter-per-second' => {
						'one' => q({0} मीटर प्रति सेकंद),
						'other' => q({0} मीटर प्रति सेकंद),
					},
					'mile' => {
						'one' => q({0} मैल),
						'other' => q({0} मैल),
					},
					'mile-per-hour' => {
						'one' => q({0} मैल प्रति तास),
						'other' => q({0} मैल प्रति तास),
					},
					'millibar' => {
						'one' => q({0} मिलिबार),
						'other' => q({0} मिलिबार),
					},
					'millimeter' => {
						'one' => q({0} मिलिमीटर),
						'other' => q({0} मिलिमीटर),
					},
					'millisecond' => {
						'one' => q({0} मिलिसेकंद),
						'other' => q({0} मिलिसेकंद),
					},
					'minute' => {
						'one' => q({0} मिनिट),
						'other' => q({0} मिनिटे),
					},
					'month' => {
						'one' => q({0} महिना),
						'other' => q({0} महिने),
					},
					'ounce' => {
						'one' => q({0} औंस),
						'other' => q({0} औंस),
					},
					'per' => {
						'' => q({0} प्रति {1}),
					},
					'picometer' => {
						'one' => q({0} पिकोमीटर),
						'other' => q({0} पिकोमीटर),
					},
					'pound' => {
						'one' => q({0} पाउंड),
						'other' => q({0} पाउंड),
					},
					'second' => {
						'one' => q({0} सेकंद),
						'other' => q({0} सेकंद),
					},
					'square-foot' => {
						'one' => q({0} चौरस फूट),
						'other' => q({0} चौरस फूट),
					},
					'square-kilometer' => {
						'one' => q({0} चौरस किलोमीटर),
						'other' => q({0} चौरस किलोमीटर),
					},
					'square-meter' => {
						'one' => q({0} चौरस मीटर),
						'other' => q({0} चौरस मीटर),
					},
					'square-mile' => {
						'one' => q({0} चौरस मैल),
						'other' => q({0} चौरस मैल),
					},
					'watt' => {
						'one' => q({0} वॉट),
						'other' => q({0} वॉट),
					},
					'week' => {
						'one' => q({0} आठवडा),
						'other' => q({0} आठवडे),
					},
					'yard' => {
						'one' => q({0} यार्ड),
						'other' => q({0} यार्ड),
					},
					'year' => {
						'one' => q({0} वर्ष),
						'other' => q({0} वर्षे),
					},
				},
				'narrow' => {
					'acre' => {
						'one' => q({0}एकर),
						'other' => q({0}एकर),
					},
					'arc-minute' => {
						'one' => q({0}′),
						'other' => q({0}'),
					},
					'arc-second' => {
						'one' => q({0}″),
						'other' => q({0}"),
					},
					'celsius' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'centimeter' => {
						'one' => q({0}सेंमी),
						'other' => q({0}सेंमी),
					},
					'cubic-kilometer' => {
						'one' => q({0}किमी³),
						'other' => q({0}किमी³),
					},
					'cubic-mile' => {
						'one' => q({0}मै³),
						'other' => q({0}मै³),
					},
					'day' => {
						'one' => q({0}दि),
						'other' => q({0}दि),
					},
					'degree' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'fahrenheit' => {
						'one' => q({0}°फॅ),
						'other' => q({0}°फॅ),
					},
					'foot' => {
						'one' => q({0}'),
						'other' => q({0}'),
					},
					'g-force' => {
						'one' => q({0}जी),
						'other' => q({0}जी),
					},
					'gram' => {
						'one' => q({0}ग्रॅ),
						'other' => q({0}ग्रॅ),
					},
					'hectare' => {
						'one' => q({0}हेक्टर),
						'other' => q({0}हेक्टर),
					},
					'hectopascal' => {
						'one' => q({0}हेक्टोपा),
						'other' => q({0}हेक्टोपा),
					},
					'horsepower' => {
						'one' => q({0} हॉपॉ),
						'other' => q({0}हॉपॉ),
					},
					'hour' => {
						'one' => q({0}ता),
						'other' => q({0}ता),
					},
					'inch' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					'inch-hg' => {
						'one' => q({0}" हेग्रॅ),
						'other' => q({0}" हेग्रॅ),
					},
					'kilogram' => {
						'one' => q({0}किग्रॅ),
						'other' => q({0}किग्रॅ),
					},
					'kilometer' => {
						'one' => q({0}किमी),
						'other' => q({0}किमी),
					},
					'kilometer-per-hour' => {
						'one' => q({0}किप्रता),
						'other' => q({0}किप्रता),
					},
					'kilowatt' => {
						'one' => q({0}किवॉ),
						'other' => q({0}किवॉ),
					},
					'light-year' => {
						'one' => q({0}प्रव),
						'other' => q({0}प्रव),
					},
					'liter' => {
						'one' => q({0}ली),
						'other' => q({0}ली),
					},
					'meter' => {
						'one' => q({0}मी),
						'other' => q({0}मी),
					},
					'meter-per-second' => {
						'one' => q({0}मी/से),
						'other' => q({0}मी/से),
					},
					'mile' => {
						'one' => q({0}मैल),
						'other' => q({0}मैल),
					},
					'mile-per-hour' => {
						'one' => q({0}मैप्रता),
						'other' => q({0}मैप्रता),
					},
					'millibar' => {
						'one' => q({0}मिबा),
						'other' => q({0}मिबा),
					},
					'millimeter' => {
						'one' => q({0}मिमी),
						'other' => q({0}मिमी),
					},
					'millisecond' => {
						'one' => q({0} मिलिसे),
						'other' => q({0} मिलिसे),
					},
					'minute' => {
						'one' => q({0} मिनिट),
						'other' => q({0}मि),
					},
					'month' => {
						'one' => q({0}म),
						'other' => q({0}म),
					},
					'ounce' => {
						'one' => q({0}औंस),
						'other' => q({0}औंस),
					},
					'per' => {
						'' => q({0}/{1}),
					},
					'picometer' => {
						'one' => q({0}पिमी),
						'other' => q({0}पिमी),
					},
					'pound' => {
						'one' => q({0}#),
						'other' => q({0}#),
					},
					'second' => {
						'one' => q({0}से),
						'other' => q({0}से),
					},
					'square-foot' => {
						'one' => q({0} फूट²),
						'other' => q({0}फूट²),
					},
					'square-kilometer' => {
						'one' => q({0} किमी²),
						'other' => q({0} किमी²),
					},
					'square-meter' => {
						'one' => q({0} मी²),
						'other' => q({0} मी²),
					},
					'square-mile' => {
						'one' => q({0}मै²),
						'other' => q({0}मै²),
					},
					'watt' => {
						'one' => q({0}वॉ),
						'other' => q({0}वॉ),
					},
					'week' => {
						'one' => q({0}आ),
						'other' => q({0}आ),
					},
					'yard' => {
						'one' => q({0}यार्ड),
						'other' => q({0}यार्ड),
					},
					'year' => {
						'one' => q({0}व),
						'other' => q({0}व),
					},
				},
				'short' => {
					'acre' => {
						'one' => q({0} एकर),
						'other' => q({0} एकर),
					},
					'arc-minute' => {
						'one' => q({0} मिनि),
						'other' => q({0} मिनि),
					},
					'arc-second' => {
						'one' => q({0} सेक),
						'other' => q({0} सेक),
					},
					'celsius' => {
						'one' => q({0}°से),
						'other' => q({0}°से),
					},
					'centimeter' => {
						'one' => q({0} सेंमी),
						'other' => q({0} सेंमी),
					},
					'cubic-kilometer' => {
						'one' => q({0} किमी³),
						'other' => q({0} किमी³),
					},
					'cubic-mile' => {
						'one' => q({0} मै³),
						'other' => q({0} मै³),
					},
					'day' => {
						'one' => q({0} दिवस),
						'other' => q({0} दिवस),
					},
					'degree' => {
						'one' => q({0} अंश),
						'other' => q({0} अंश),
					},
					'fahrenheit' => {
						'one' => q({0}°फॅ),
						'other' => q({0}°फॅ),
					},
					'foot' => {
						'one' => q({0} फूट),
						'other' => q({0} फूट),
					},
					'g-force' => {
						'one' => q({0} जी),
						'other' => q({0} जी),
					},
					'gram' => {
						'one' => q({0} ग्रॅ),
						'other' => q({0} ग्रॅ),
					},
					'hectare' => {
						'one' => q({0} हेक्टर),
						'other' => q({0} हेक्टर),
					},
					'hectopascal' => {
						'one' => q({0} हेक्टोपा),
						'other' => q({0} हेक्टोपा),
					},
					'horsepower' => {
						'one' => q({0} हॉपॉ),
						'other' => q({0} हॉपॉ),
					},
					'hour' => {
						'one' => q({0} ता),
						'other' => q({0} ता),
					},
					'inch' => {
						'one' => q({0} इंच),
						'other' => q({0} इंच),
					},
					'inch-hg' => {
						'one' => q({0} हेग्रॅमध्ये),
						'other' => q({0} हेग्रॅमध्ये),
					},
					'kilogram' => {
						'one' => q({0} किग्रॅ),
						'other' => q({0} किग्रॅ),
					},
					'kilometer' => {
						'one' => q({0} किमी),
						'other' => q({0} किमी),
					},
					'kilometer-per-hour' => {
						'one' => q({0} किप्रता),
						'other' => q({0} किप्रता),
					},
					'kilowatt' => {
						'one' => q({0} किवॉ),
						'other' => q({0} किवॉ),
					},
					'light-year' => {
						'one' => q({0} प्रव),
						'other' => q({0} प्रव),
					},
					'liter' => {
						'one' => q({0} ली),
						'other' => q({0} ली),
					},
					'meter' => {
						'one' => q({0} मी),
						'other' => q({0} मी),
					},
					'meter-per-second' => {
						'one' => q({0} मी/से),
						'other' => q({0} मी/से),
					},
					'mile' => {
						'one' => q({0} मैल),
						'other' => q({0} मैल),
					},
					'mile-per-hour' => {
						'one' => q({0} मैप्रता),
						'other' => q({0} मैप्रता),
					},
					'millibar' => {
						'one' => q({0} मिबा),
						'other' => q({0} मिबा),
					},
					'millimeter' => {
						'one' => q({0} मिमी),
						'other' => q({0} मिमी),
					},
					'millisecond' => {
						'one' => q({0} मिलिसे),
						'other' => q({0} मिलिसे),
					},
					'minute' => {
						'one' => q({0} मिनि),
						'other' => q({0} मिनि),
					},
					'month' => {
						'one' => q({0} महिना),
						'other' => q({0} महिने),
					},
					'ounce' => {
						'one' => q({0} औंस),
						'other' => q({0} औंस),
					},
					'per' => {
						'' => q({0}/{1}),
					},
					'picometer' => {
						'one' => q({0} पिमी),
						'other' => q({0} पिमी),
					},
					'pound' => {
						'one' => q({0} पाउंड),
						'other' => q({0} पाउंड),
					},
					'second' => {
						'one' => q({0} से),
						'other' => q({0} से),
					},
					'square-foot' => {
						'one' => q({0} चौ फूट),
						'other' => q({0} चौ फूट),
					},
					'square-kilometer' => {
						'one' => q({0} किमी²),
						'other' => q({0} किमी²),
					},
					'square-meter' => {
						'one' => q({0} मी²),
						'other' => q({0} मी²),
					},
					'square-mile' => {
						'one' => q({0} चौ मी),
						'other' => q({0} चौ मी),
					},
					'watt' => {
						'one' => q({0} वॉ),
						'other' => q({0} वॉ),
					},
					'week' => {
						'one' => q({0} आ),
						'other' => q({0} आ),
					},
					'yard' => {
						'one' => q({0} यार्ड),
						'other' => q({0} यार्ड),
					},
					'year' => {
						'one' => q({0} वर्ष),
						'other' => q({0} वर्षे),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:होयःहो|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:नाहीःना|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
				start => q({0}, {1}),
				middle => q({0}, {1}),
				end => q({0}, {1}),
				2 => q({0}, {1}),
		} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> 'deva',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> 'deva',
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'deva' => {
			'decimal' => q(.),
			'exponential' => q(E),
			'group' => q(,),
			'infinity' => q(∞),
			'list' => q(),
			'minusSign' => q(-),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
		},
		'latn' => {
			'decimal' => q(.),
			'exponential' => q(E),
			'group' => q(,),
			'infinity' => q(∞),
			'list' => q(;),
			'minusSign' => q(-),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'0' => {
					'default' => '#,##0.###',
				},
				'1000' => {
					'one' => '0K',
					'other' => '0K',
				},
				'10000' => {
					'one' => '00K',
					'other' => '00K',
				},
				'100000' => {
					'one' => '000K',
					'other' => '000K',
				},
				'1000000' => {
					'one' => '0M',
					'other' => '0M',
				},
				'10000000' => {
					'one' => '00M',
					'other' => '00M',
				},
				'100000000' => {
					'one' => '000M',
					'other' => '000M',
				},
				'1000000000' => {
					'one' => '0B',
					'other' => '0B',
				},
				'10000000000' => {
					'one' => '00B',
					'other' => '00B',
				},
				'100000000000' => {
					'one' => '000B',
					'other' => '000B',
				},
				'1000000000000' => {
					'one' => '0T',
					'other' => '0T',
				},
				'10000000000000' => {
					'one' => '00T',
					'other' => '00T',
				},
				'100000000000000' => {
					'one' => '000T',
					'other' => '000T',
				},
			},
			'long' => {
				'1000' => {
					'one' => '0 हजार',
					'other' => '0 हजार',
				},
				'10000' => {
					'one' => '00 हजार',
					'other' => '00 हजार',
				},
				'100000' => {
					'one' => '000 हजार',
					'other' => '000 हजार',
				},
				'1000000' => {
					'one' => '0 दशलक्ष',
					'other' => '0 दशलक्ष',
				},
				'10000000' => {
					'one' => '00 दशलक्ष',
					'other' => '00 दशलक्ष',
				},
				'100000000' => {
					'one' => '000 दशलक्ष',
					'other' => '000 दशलक्ष',
				},
				'1000000000' => {
					'one' => '0 महापद्म',
					'other' => '0 महापद्म',
				},
				'10000000000' => {
					'one' => '00 महापद्म',
					'other' => '00 महापद्म',
				},
				'100000000000' => {
					'one' => '000 महापद्म',
					'other' => '000 महापद्म',
				},
				'1000000000000' => {
					'one' => '0 खरब',
					'other' => '0 खरब',
				},
				'10000000000000' => {
					'one' => '00 खरब',
					'other' => '00 खरब',
				},
				'100000000000000' => {
					'one' => '000 खरब',
					'other' => '000 खरब',
				},
			},
			'short' => {
				'1000' => {
					'one' => '0K',
					'other' => '0K',
				},
				'10000' => {
					'one' => '00K',
					'other' => '00K',
				},
				'100000' => {
					'one' => '000K',
					'other' => '000K',
				},
				'1000000' => {
					'one' => '0M',
					'other' => '0M',
				},
				'10000000' => {
					'one' => '00M',
					'other' => '00M',
				},
				'100000000' => {
					'one' => '000M',
					'other' => '000M',
				},
				'1000000000' => {
					'one' => '0B',
					'other' => '0B',
				},
				'10000000000' => {
					'one' => '00B',
					'other' => '00B',
				},
				'100000000000' => {
					'one' => '000B',
					'other' => '000B',
				},
				'1000000000000' => {
					'one' => '0T',
					'other' => '0T',
				},
				'10000000000000' => {
					'one' => '00T',
					'other' => '00T',
				},
				'100000000000000' => {
					'one' => '000T',
					'other' => '000T',
				},
			},
		},
		percentFormat => {
			'default' => {
				'0' => {
					'default' => '#,##0%',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'0' => {
					'default' => '[#E0]',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'deva' => {
			'pattern' => {
				'default' => {
					'standard' => {
						'negative' => '¤#,##0.00',
						'positive' => '¤#,##0.00',
					},
				},
			},
		},
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'negative' => '(¤#,##0.00)',
						'positive' => '¤#,##0.00',
					},
					'standard' => {
						'negative' => '¤#,##0.00',
						'positive' => '¤#,##0.00',
					},
				},
			},
		},
} },
);

has 'curriencies' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'AED' => {
			display_name => {
				'currency' => q(संयुक्त अरब अमीरात दिरहॅम),
				'one' => q(संयुक्त अरब अमीरात दिरहॅम),
				'other' => q(संयुक्त अरब अमीरात दिरहॅम),
			},
		},
		'AFN' => {
			display_name => {
				'currency' => q(अफगाण अफगाणी),
				'one' => q(अफगाण अफगाणी),
				'other' => q(अफगाण अफगाणी),
			},
		},
		'ALL' => {
			display_name => {
				'currency' => q(अल्बानियन लेक),
				'one' => q(अल्बानियन लेक),
				'other' => q(अल्बानियन लेक),
			},
		},
		'AMD' => {
			display_name => {
				'currency' => q(आर्मेनियन द्रॅम),
				'one' => q(आर्मेनियन द्रॅम),
				'other' => q(आर्मेनियन द्रॅम),
			},
		},
		'ANG' => {
			display_name => {
				'currency' => q(नेदरलँडचा अँटिलीन गिल्डर),
				'one' => q(नेदरलँडचा अँटिलीन गिल्डर),
				'other' => q(नेदरलँडचा अँटिलीन गिल्डर),
			},
		},
		'AOA' => {
			display_name => {
				'currency' => q(अँगोलन क्वॅन्झा),
				'one' => q(अँगोलन क्वॅन्झा),
				'other' => q(अँगोलन क्वॅन्झा),
			},
		},
		'ARS' => {
			display_name => {
				'currency' => q(अर्जेंटाइन पेसो),
				'one' => q(अर्जेंटाइन पेसो),
				'other' => q(अर्जेंटाइन पेसो),
			},
		},
		'AUD' => {
			symbol => 'A$',
			display_name => {
				'currency' => q(ऑस्ट्रेलियन डॉलर),
				'one' => q(ऑस्ट्रेलियन डॉलर),
				'other' => q(ऑस्ट्रेलियन डॉलर),
			},
		},
		'AWG' => {
			display_name => {
				'currency' => q(अरुबा फ्लोरिन),
				'one' => q(अरुबा फ्लोरिन),
				'other' => q(अरुबा फ्लोरिन),
			},
		},
		'AZN' => {
			display_name => {
				'currency' => q(अझरबैझानी मानाट),
				'one' => q(अझरबैझानी मानाट),
				'other' => q(अझरबैझानी मानाट),
			},
		},
		'BAM' => {
			display_name => {
				'currency' => q(बोस्निया-हर्जेगोविना कन्व्हर्टिबल मार्क),
				'one' => q(बोस्निया-हर्जेगोविना कन्व्हर्टिबल मार्क),
				'other' => q(बोस्निया-हर्जेगोविना कन्व्हर्टिबल मार्क),
			},
		},
		'BBD' => {
			display_name => {
				'currency' => q(बार्बाडियन डॉलर),
				'one' => q(बार्बाडियन डॉलर),
				'other' => q(बार्बाडियन डॉलर),
			},
		},
		'BDT' => {
			display_name => {
				'currency' => q(बांगलादेशी टका),
				'one' => q(बांगलादेशी टका),
				'other' => q(बांगलादेशी टका),
			},
		},
		'BGN' => {
			display_name => {
				'currency' => q(बल्गेरियन लेव),
				'one' => q(बल्गेरियन लेव),
				'other' => q(बल्गेरियन लेव),
			},
		},
		'BHD' => {
			display_name => {
				'currency' => q(बाहरिनी दिनार),
				'one' => q(बाहरिनी दिनार),
				'other' => q(बाहरिनी दिनार),
			},
		},
		'BIF' => {
			display_name => {
				'currency' => q(बुरुडियन फ्रँक),
				'one' => q(बुरुडियन फ्रँक),
				'other' => q(बुरुडियन फ्रँक),
			},
		},
		'BMD' => {
			display_name => {
				'currency' => q(बर्मुडा डॉलर),
				'one' => q(बर्मुडा डॉलर),
				'other' => q(बर्मुडा डॉलर),
			},
		},
		'BND' => {
			display_name => {
				'currency' => q(ब्रुनेई डॉलर),
				'one' => q(ब्रुनेई डॉलर),
				'other' => q(ब्रुनेई डॉलर),
			},
		},
		'BOB' => {
			display_name => {
				'currency' => q(बोलिव्हियन बोलिव्हियानो),
				'one' => q(बोलिव्हियन बोलिव्हियानो),
				'other' => q(बोलिव्हियन बोलिव्हियानो),
			},
		},
		'BRL' => {
			symbol => 'R$',
			display_name => {
				'currency' => q(ब्राझिलियन रेयाल),
				'one' => q(ब्राझिलियन रेयाल),
				'other' => q(ब्राझिलियन रेयाल),
			},
		},
		'BSD' => {
			display_name => {
				'currency' => q(बहामी डॉलर),
				'one' => q(बहामी डॉलर),
				'other' => q(बहामी डॉलर),
			},
		},
		'BTN' => {
			display_name => {
				'currency' => q(भूतानी एंगल्ट्रम),
				'one' => q(भूतानी एंगल्ट्रम),
				'other' => q(भूतानी एंगल्ट्रम),
			},
		},
		'BWP' => {
			display_name => {
				'currency' => q(बोट्सवाना पुला),
				'one' => q(बोट्सवाना पुला),
				'other' => q(बोट्सवाना पुला),
			},
		},
		'BYR' => {
			display_name => {
				'currency' => q(बेलारुशियन रुबल),
				'one' => q(बेलारुशियन रुबल),
				'other' => q(बेलारुशियन रुबल),
			},
		},
		'BZD' => {
			display_name => {
				'currency' => q(बेलीझ डॉलर),
				'one' => q(बेलीझ डॉलर),
				'other' => q(बेलीझ डॉलर),
			},
		},
		'CAD' => {
			symbol => 'CA$',
			display_name => {
				'currency' => q(कॅनडियन डॉलर),
				'one' => q(कॅनडियन डॉलर),
				'other' => q(कॅनडियन डॉलर),
			},
		},
		'CDF' => {
			display_name => {
				'currency' => q(काँगोलीज फ्रँक),
				'one' => q(काँगोलीज फ्रँक),
				'other' => q(काँगोलीज फ्रँक),
			},
		},
		'CHF' => {
			display_name => {
				'currency' => q(स्विस फ्रँक),
				'one' => q(स्विस फ्रँक),
				'other' => q(स्विस फ्रँक),
			},
		},
		'CLP' => {
			display_name => {
				'currency' => q(चिली पेसो),
				'one' => q(चिली पेसो),
				'other' => q(चिली पेसो),
			},
		},
		'CNY' => {
			symbol => 'CN¥',
			display_name => {
				'currency' => q(चीनी युआन),
				'one' => q(चीनी युआन),
				'other' => q(चीनी युआन),
			},
		},
		'COP' => {
			display_name => {
				'currency' => q(कोलंबियन पेसो),
				'one' => q(कोलंबियन पेसो),
				'other' => q(कोलंबियन पेसो),
			},
		},
		'CRC' => {
			display_name => {
				'currency' => q(कोस्टा रिका कोलोन),
				'one' => q(कोस्टा रिका कोलोन),
				'other' => q(कोस्टा रिका कोलोन),
			},
		},
		'CUC' => {
			display_name => {
				'currency' => q(क्यूबन विनिमय पेसो),
				'one' => q(क्यूबन विनिमय पेसो),
				'other' => q(क्यूबन विनिमय पेसो),
			},
		},
		'CUP' => {
			display_name => {
				'currency' => q(क्यूबन पेसो),
				'one' => q(क्यूबन पेसो),
				'other' => q(क्यूबन पेसो),
			},
		},
		'CVE' => {
			display_name => {
				'currency' => q(केप व्हर्डेयन एस्कुडो),
				'one' => q(केप व्हर्डेयन एस्कुडो),
				'other' => q(केप व्हर्डेयन एस्कुडो),
			},
		},
		'CZK' => {
			display_name => {
				'currency' => q(झेक प्रजासत्ताक कोरुना),
				'one' => q(झेक प्रजासत्ताक कोरुना),
				'other' => q(झेक प्रजासत्ताक कोरुना),
			},
		},
		'DJF' => {
			display_name => {
				'currency' => q(जिबौटियन फ्रँक),
				'one' => q(जिबौटियन फ्रँक),
				'other' => q(जिबौटियन फ्रँक),
			},
		},
		'DKK' => {
			display_name => {
				'currency' => q(डॅनिश क्रोन),
				'one' => q(डॅनिश क्रोन),
				'other' => q(डॅनिश क्रोन),
			},
		},
		'DOP' => {
			display_name => {
				'currency' => q(डोमिनिकन पेसो),
				'one' => q(डोमिनिकन पेसो),
				'other' => q(डोमिनिकन पेसो),
			},
		},
		'DZD' => {
			display_name => {
				'currency' => q(अल्जेरियन दिनार),
				'one' => q(अल्जेरियन दिनार),
				'other' => q(अल्जेरियन दिनार),
			},
		},
		'EGP' => {
			display_name => {
				'currency' => q(इजिप्शियन पाउंड),
				'one' => q(इजिप्शियन पाउंड),
				'other' => q(इजिप्शियन पाउंड),
			},
		},
		'ERN' => {
			display_name => {
				'currency' => q(इरिट्रियन नाफ्का),
				'one' => q(इरिट्रिया नाफ्का),
				'other' => q(इरिट्रिया नाफ्का),
			},
		},
		'ETB' => {
			display_name => {
				'currency' => q(इथिओपियन बिर),
				'one' => q(इथिओपियन बिर),
				'other' => q(इथिओपियन बिर),
			},
		},
		'EUR' => {
			symbol => '€',
			display_name => {
				'currency' => q(यूरो),
				'one' => q(युरो),
				'other' => q(युरो),
			},
		},
		'FJD' => {
			display_name => {
				'currency' => q(फिजियन डॉलर),
				'one' => q(फिजियन डॉलर),
				'other' => q(फिजियन डॉलर),
			},
		},
		'FKP' => {
			display_name => {
				'currency' => q(फॉकलंड आयलंड पाउंड),
				'one' => q(फॉकलंड आयलंड पाउंड),
				'other' => q(फॉकलंड आयलंड पाउंड),
			},
		},
		'GBP' => {
			symbol => '£',
			display_name => {
				'currency' => q(ब्रिटिश पाऊंड स्टर्लिंग),
				'one' => q(ब्रिटिश पाऊंड स्टर्लिंग),
				'other' => q(ब्रिटिश पाऊंड स्टर्लिंग),
			},
		},
		'GEL' => {
			display_name => {
				'currency' => q(जॉर्जियन लारी),
				'one' => q(जॉर्जियन लारी),
				'other' => q(जॉर्जियन लारी),
			},
		},
		'GHS' => {
			display_name => {
				'currency' => q(घानीयन सेडी),
				'one' => q(घानीयन सेडी),
				'other' => q(घानीयन सेडी),
			},
		},
		'GIP' => {
			display_name => {
				'currency' => q(जिब्राल्टर पाउंड),
				'one' => q(जिब्राल्टर पाउंड),
				'other' => q(जिब्राल्टर पाउंड),
			},
		},
		'GMD' => {
			display_name => {
				'currency' => q(गाम्बियन डालासी),
				'one' => q(गाम्बियन डालासी),
				'other' => q(गाम्बियन डालासी),
			},
		},
		'GNF' => {
			display_name => {
				'currency' => q(गिनी फ्रँक),
				'one' => q(गिनी फ्रँक),
				'other' => q(गिनी फ्रँक),
			},
		},
		'GTQ' => {
			display_name => {
				'currency' => q(ग्वाटेमालाचे क्वेत्झाल),
				'one' => q(ग्वाटेमालाचे क्वेत्झाल),
				'other' => q(ग्वाटेमालाचे क्वेत्झाल),
			},
		},
		'GYD' => {
			display_name => {
				'currency' => q(गयाना डॉलर),
				'one' => q(गयाना डॉलर),
				'other' => q(गयाना डॉलर),
			},
		},
		'HKD' => {
			symbol => 'HK$',
			display_name => {
				'currency' => q(हाँगकाँग डॉलर),
				'one' => q(हाँगकाँग डॉलर),
				'other' => q(हाँगकाँग डॉलर),
			},
		},
		'HNL' => {
			display_name => {
				'currency' => q(होंडुरा लेम्पियरा),
				'one' => q(होंडुरा लेम्पियरा),
				'other' => q(होंडुरा लेम्पियरा),
			},
		},
		'HRK' => {
			display_name => {
				'currency' => q(क्रोएशियन कूना),
				'one' => q(क्रोएशियन कूना),
				'other' => q(क्रोएशियन कूना),
			},
		},
		'HTG' => {
			display_name => {
				'currency' => q(हैती गोअर्ड),
				'one' => q(हैती गोअर्ड),
				'other' => q(हैती गोअर्ड),
			},
		},
		'HUF' => {
			display_name => {
				'currency' => q(हंगेरियन फॉरिन्ट),
				'one' => q(हंगेरियन फॉरिन्ट),
				'other' => q(हंगेरियन फॉरिन्ट),
			},
		},
		'IDR' => {
			display_name => {
				'currency' => q(इंडोनेशियन रुपैयाह),
				'one' => q(इंडोनेशियन रुपैयाह),
				'other' => q(इंडोनेशियन रुपैयाह),
			},
		},
		'ILS' => {
			symbol => '₪',
			display_name => {
				'currency' => q(ईस्त्रायली न्यू शेकेल),
				'one' => q(ईस्त्रायली न्यू शेकेल),
				'other' => q(ईस्त्रायली न्यू शेकेल),
			},
		},
		'INR' => {
			symbol => '₹',
			display_name => {
				'currency' => q(भारतीय रुपया),
				'one' => q(भारतीय रुपया),
				'other' => q(भारतीय रुपया),
			},
		},
		'IQD' => {
			display_name => {
				'currency' => q(इराकी दिनार),
				'one' => q(इराकी दिनार),
				'other' => q(इराकी दिनार),
			},
		},
		'IRR' => {
			display_name => {
				'currency' => q(इराणी रियाल),
				'one' => q(इराणी रियाल),
				'other' => q(इराणी रियाल),
			},
		},
		'ISK' => {
			display_name => {
				'currency' => q(आइसलँडिक क्रोन),
				'one' => q(आइसलँडिक क्रोन),
				'other' => q(आइसलँडिक क्रोन),
			},
		},
		'JMD' => {
			display_name => {
				'currency' => q(जमैकन डॉलर),
				'one' => q(जमैकन डॉलर),
				'other' => q(जमैकन डॉलर),
			},
		},
		'JOD' => {
			display_name => {
				'currency' => q(जॉर्डनियन दिनार),
				'one' => q(जॉर्डनियन दिनार),
				'other' => q(जॉर्डनियन दिनार),
			},
		},
		'JPY' => {
			symbol => 'JP¥',
			display_name => {
				'currency' => q(जपानी येन),
				'one' => q(जपानी येन),
				'other' => q(जपानी येन),
			},
		},
		'KES' => {
			display_name => {
				'currency' => q(केनियन शिलिंग),
				'one' => q(केनियन शिलिंग),
				'other' => q(केनियन शिलिंग),
			},
		},
		'KGS' => {
			display_name => {
				'currency' => q(किरगिस्तानी सॉम),
				'one' => q(किरगिस्तानी सॉम),
				'other' => q(किरगिस्तानी सॉम),
			},
		},
		'KHR' => {
			display_name => {
				'currency' => q(कंबोडियन रियेल),
				'one' => q(कंबोडियन रियेल),
				'other' => q(कंबोडियन रियेल),
			},
		},
		'KMF' => {
			display_name => {
				'currency' => q(कोलोरियन फ्रँक),
				'one' => q(कोलोरियन फ्रँक),
				'other' => q(कोलोरियन फ्रँक),
			},
		},
		'KPW' => {
			display_name => {
				'currency' => q(उत्तर कोरियन वॉन),
				'one' => q(उत्तर कोरियन वॉन),
				'other' => q(उत्तर कोरियन वॉन),
			},
		},
		'KRW' => {
			symbol => '₩',
			display_name => {
				'currency' => q(दक्षिण कोरियन वॉन),
				'one' => q(दक्षिण कोरियन वॉन),
				'other' => q(दक्षिण कोरियन वॉन),
			},
		},
		'KWD' => {
			display_name => {
				'currency' => q(कुवैती दिनार),
				'one' => q(कुवैती दिनार),
				'other' => q(कुवैती दिनार),
			},
		},
		'KYD' => {
			display_name => {
				'currency' => q(केमेन आयलॅंड डॉलर),
				'one' => q(केमेन आयलॅंड डॉलर),
				'other' => q(केमेन आयलॅंड डॉलर),
			},
		},
		'KZT' => {
			display_name => {
				'currency' => q(कझाकिस्तानी तेंगे),
				'one' => q(कझाकिस्तानी तेंगे),
				'other' => q(कझाकिस्तानी तेंगे),
			},
		},
		'LAK' => {
			display_name => {
				'currency' => q(लेओशियन किप),
				'one' => q(लेओशियन किप),
				'other' => q(लेओशियन किप),
			},
		},
		'LBP' => {
			display_name => {
				'currency' => q(लेबनीज पाउंड),
				'one' => q(लेबनीज पाउंड),
				'other' => q(लेबनीज पाउंड),
			},
		},
		'LKR' => {
			display_name => {
				'currency' => q(श्रीलंकन रुपी),
				'one' => q(श्रीलंकन रुपी),
				'other' => q(श्रीलंकन रुपी),
			},
		},
		'LRD' => {
			display_name => {
				'currency' => q(लाइबेरियन डॉलर),
				'one' => q(लाइबेरियन डॉलर),
				'other' => q(लाइबेरियन डॉलर),
			},
		},
		'LSL' => {
			display_name => {
				'currency' => q(लेसोटो लोटी),
			},
		},
		'LTL' => {
			display_name => {
				'currency' => q(लिथुआनियन लिटाज्),
				'one' => q(लिथुआनियन लिटाज्),
				'other' => q(लिथुआनियन लिटाज्),
			},
		},
		'LVL' => {
			display_name => {
				'currency' => q(लाट्व्हियन लाट्झ),
				'one' => q(लाट्व्हियन लाट्झ),
				'other' => q(लाट्व्हियन लाटी),
			},
		},
		'LYD' => {
			display_name => {
				'currency' => q(लिबियाचा दिनार),
				'one' => q(लिबियाचा दिनार),
				'other' => q(लिबियाचा दिनार),
			},
		},
		'MAD' => {
			display_name => {
				'currency' => q(मोरोक्को दिरहॅम),
				'one' => q(मोरोक्को दिरहॅम),
				'other' => q(मोरोक्को दिरहॅम),
			},
		},
		'MDL' => {
			display_name => {
				'currency' => q(मोल्डोवन लेउ),
				'one' => q(मोल्डोवन लेउ),
				'other' => q(मोल्डोवन लेई),
			},
		},
		'MGA' => {
			display_name => {
				'currency' => q(मालागासी एरियारी),
				'one' => q(मालागासी एरियारी),
				'other' => q(मालागासी एरियारी),
			},
		},
		'MKD' => {
			display_name => {
				'currency' => q(मॅसेडोनियन दिनार),
				'one' => q(मॅसेडोनियन दिनार),
				'other' => q(मॅसेडोनियन दिनार),
			},
		},
		'MMK' => {
			display_name => {
				'currency' => q(म्यानमा क्याट),
				'one' => q(म्यानमा क्याट),
				'other' => q(म्यानमा क्याट),
			},
		},
		'MNT' => {
			display_name => {
				'currency' => q(मंगोलियन टुग्रिक),
				'one' => q(मंगोलियन टुग्रिक),
				'other' => q(मंगोलियन टुग्रिक),
			},
		},
		'MOP' => {
			display_name => {
				'currency' => q(मॅकॅनीज् पटाका),
				'one' => q(मॅकॅनीज् पटाका),
				'other' => q(मॅकॅनीज् पटाका),
			},
		},
		'MRO' => {
			display_name => {
				'currency' => q(मॉरिटानियन ओगिया),
				'one' => q(मॉरिटानियन ओगिया),
				'other' => q(मॉरिटानियन ओगिया),
			},
		},
		'MUR' => {
			display_name => {
				'currency' => q(मॉरिशियन रुपी),
				'one' => q(मॉरिशियन रुपी),
				'other' => q(मॉरिशियन रुपी),
			},
		},
		'MVR' => {
			display_name => {
				'currency' => q(मालदीवियन रुफिया),
				'one' => q(मालदीवियन रुफिया),
				'other' => q(मालदीवियन रुफिया),
			},
		},
		'MWK' => {
			display_name => {
				'currency' => q(मालावियन क्वाचा),
				'one' => q(मालावियन क्वाचा),
				'other' => q(मालावियन क्वाचा),
			},
		},
		'MXN' => {
			symbol => 'MX$',
			display_name => {
				'currency' => q(मेक्सिको पेसो),
				'one' => q(मेक्सिको पेसो),
				'other' => q(मेक्सिको पेसो),
			},
		},
		'MYR' => {
			display_name => {
				'currency' => q(मलेशियन रिंगिट),
				'one' => q(मलेशियन रिंगिट),
				'other' => q(मलेशियन रिंगिट),
			},
		},
		'MZN' => {
			display_name => {
				'currency' => q(मोझांबिकन मेटिकल),
				'one' => q(मोझांबिकन मेटिकल),
				'other' => q(मोझांबिकन मेटिकल),
			},
		},
		'NAD' => {
			display_name => {
				'currency' => q(नमिबियन डॉलर),
				'one' => q(नमिबियन डॉलर),
				'other' => q(नमिबियन डॉलर),
			},
		},
		'NGN' => {
			display_name => {
				'currency' => q(नायजेरियन नायरा),
				'one' => q(नायजेरियन नायरा),
				'other' => q(नायजेरियन नायरा),
			},
		},
		'NIO' => {
			display_name => {
				'currency' => q(निकाराग्वेचा कोर्डोबा),
				'one' => q(निकाराग्वेचा कोर्डोबा),
				'other' => q(निकाराग्वेचा कोर्डोबा),
			},
		},
		'NOK' => {
			display_name => {
				'currency' => q(नॉर्वेजियन क्रोन),
				'one' => q(नॉर्वेजियन क्रोन),
				'other' => q(नॉर्वेजियन क्रोन),
			},
		},
		'NPR' => {
			display_name => {
				'currency' => q(नेपाळी रुपया),
				'one' => q(नेपाळी रुपया),
				'other' => q(नेपाळी रुपया),
			},
		},
		'NZD' => {
			symbol => 'NZ$',
			display_name => {
				'currency' => q(न्यूझीलँड डॉलर),
				'one' => q(न्यूझीलँड डॉलर),
				'other' => q(न्यूझीलँड डॉलर),
			},
		},
		'OMR' => {
			display_name => {
				'currency' => q(ओमानी रियाल),
				'one' => q(ओमानी रियाल),
				'other' => q(ओमानी रियाल),
			},
		},
		'PAB' => {
			display_name => {
				'currency' => q(पनामा बाल्बोआ),
				'one' => q(पनामा बाल्बोआ),
				'other' => q(पनामा बाल्बोआ),
			},
		},
		'PEN' => {
			display_name => {
				'currency' => q(पेरुवियन नुइव्हो सोल),
				'one' => q(पेरुवियन नुइव्हो सोल),
				'other' => q(पेरुवियन नुइव्हो सोल),
			},
		},
		'PGK' => {
			display_name => {
				'currency' => q(पापुआ न्यू गिनीयन किना),
				'one' => q(पापुआ न्यू गिनीयन किना),
				'other' => q(पापुआ न्यू गिनीयन किना),
			},
		},
		'PHP' => {
			display_name => {
				'currency' => q(फिलिपिनी पेसो),
				'one' => q(फिलिपिनी पेसो),
				'other' => q(फिलिपिनी पेसो),
			},
		},
		'PKR' => {
			display_name => {
				'currency' => q(पाकिस्तानी रुपया),
				'one' => q(पाकिस्तानी रुपया),
				'other' => q(पाकिस्तानी रुपया),
			},
		},
		'PLN' => {
			display_name => {
				'currency' => q(पोलिश झ्लॉटी),
				'one' => q(पोलिश झ्लॉटी),
				'other' => q(पोलिश झ्लॉटी),
			},
		},
		'PYG' => {
			display_name => {
				'currency' => q(पराग्वे ग्वारानी),
				'one' => q(पराग्वे ग्वारानी),
				'other' => q(पराग्वे ग्वारानी),
			},
		},
		'QAR' => {
			display_name => {
				'currency' => q(कतारी रियाल),
				'one' => q(कतारी रियाल),
				'other' => q(कतारी रियाल),
			},
		},
		'RON' => {
			display_name => {
				'currency' => q(रोमानियन लेऊ),
				'one' => q(रोमानियन लेऊ),
				'other' => q(रोमानियन लेई),
			},
		},
		'RSD' => {
			display_name => {
				'currency' => q(सर्बियन दिनार),
				'one' => q(सर्बियन दिनार),
				'other' => q(सर्बियन दिनार),
			},
		},
		'RUB' => {
			display_name => {
				'currency' => q(रशियन रुबल),
				'one' => q(रशियन रुबल),
				'other' => q(रशियन रुबल),
			},
		},
		'RWF' => {
			display_name => {
				'currency' => q(रवांडा फ्रँक),
				'one' => q(रवांडा फ्रँक),
				'other' => q(रवांडा फ्रँक),
			},
		},
		'SAR' => {
			display_name => {
				'currency' => q(सौदी रियाल),
				'one' => q(सौदी रियाल),
				'other' => q(सौदी रियाल),
			},
		},
		'SBD' => {
			display_name => {
				'currency' => q(सोलोमन आयलँड्स),
				'one' => q(सोलोमन आयलँड्स),
				'other' => q(सोलोमन आयलँड्स),
			},
		},
		'SCR' => {
			display_name => {
				'currency' => q(सेशेलोईस रुपी),
				'one' => q(सेशेलोईस रुपी),
				'other' => q(सेशेलोईस रुपी),
			},
		},
		'SDG' => {
			display_name => {
				'currency' => q(सुदानी पाउंड),
				'one' => q(सुदानी पाउंड),
				'other' => q(सुदानी पाउंड),
			},
		},
		'SEK' => {
			display_name => {
				'currency' => q(स्वीडिश क्रोन),
				'one' => q(स्वीडिश क्रोन),
				'other' => q(स्वीडिश क्रोन),
			},
		},
		'SGD' => {
			display_name => {
				'currency' => q(सिंगापूर डॉलर),
				'one' => q(सिंगापूर डॉलर),
				'other' => q(सिंगापूर डॉलर),
			},
		},
		'SHP' => {
			display_name => {
				'currency' => q(सेंट हेलेना पाउंड),
				'one' => q(सेंट हेलेना पाउंड),
				'other' => q(सेंट हेलेना पाउंड),
			},
		},
		'SLL' => {
			display_name => {
				'currency' => q(सिएरा लिऑनचा लिऑन),
				'one' => q(सिएरा लिऑनचा लिऑन),
				'other' => q(सिएरा लिऑनचा लिऑन),
			},
		},
		'SOS' => {
			display_name => {
				'currency' => q(सोमाली शिलिंग),
				'one' => q(सोमाली शिलिंग),
				'other' => q(सोमाली शिलिंग),
			},
		},
		'SRD' => {
			display_name => {
				'currency' => q(सुरिनामी डॉलर),
				'one' => q(सुरिनामी डॉलर),
				'other' => q(सुरिनामी डॉलर),
			},
		},
		'SSP' => {
			display_name => {
				'currency' => q(दक्षिण सुदानी पाउंड),
				'one' => q(दक्षिण सुदानी पाउंड),
				'other' => q(दक्षिण सुदानी पाउंड),
			},
		},
		'STD' => {
			display_name => {
				'currency' => q(साओ टोम आणि प्रिन्सिपे डोबरा),
				'one' => q(साओ टोम आणि प्रिन्सिपे डोबरा),
				'other' => q(साओ टोम आणि प्रिन्सिपे डोबरा),
			},
		},
		'SYP' => {
			display_name => {
				'currency' => q(सीरियन पाउंड),
				'one' => q(सीरियन पाउंड),
				'other' => q(सीरियन पाउंड),
			},
		},
		'SZL' => {
			display_name => {
				'currency' => q(स्वाझी लीलांगेनी),
				'one' => q(स्वाझी लीलांगेनी),
				'other' => q(स्वाझी लीलांगेनी),
			},
		},
		'THB' => {
			symbol => '฿',
			display_name => {
				'currency' => q(थाई बाहत),
				'one' => q(थाई बाहत),
				'other' => q(थाई बाहत),
			},
		},
		'TJS' => {
			display_name => {
				'currency' => q(ताजकीस्तानी सोमोनी),
				'one' => q(ताजकीस्तानी सोमोनी),
				'other' => q(ताजकीस्तानचा सोमोनी),
			},
		},
		'TMT' => {
			display_name => {
				'currency' => q(तुर्कमेनिस्तानी मानाट),
				'one' => q(तुर्कमेनिस्तानी मानाट),
				'other' => q(तुर्कमेनिस्तानी मानाट),
			},
		},
		'TND' => {
			display_name => {
				'currency' => q(ट्यूनिसियन दिनार),
				'one' => q(ट्यूनिसियन दिनार),
				'other' => q(ट्यूनिसियन दिनार),
			},
		},
		'TOP' => {
			display_name => {
				'currency' => q(टोंगा पाआंगा),
				'one' => q(टोंगा पाआंगा),
				'other' => q(टोंगा पाआंगा),
			},
		},
		'TRY' => {
			display_name => {
				'currency' => q(तुर्की लिरा),
				'one' => q(तुर्की लिरा),
				'other' => q(तुर्की लिरा),
			},
		},
		'TTD' => {
			display_name => {
				'currency' => q(त्रिनिदाद आणि टोबॅगो डॉलर),
				'one' => q(त्रिनिदाद आणि टोबॅगो डॉलर),
				'other' => q(त्रिनिदाद आणि टोबॅगो डॉलर),
			},
		},
		'TWD' => {
			symbol => 'NT$',
			display_name => {
				'currency' => q(न्यू तैवान डॉलर),
				'one' => q(न्यू तैवान डॉलर),
				'other' => q(न्यू तैवान डॉलर),
			},
		},
		'TZS' => {
			display_name => {
				'currency' => q(टांझानियन शिलिंग),
				'one' => q(टांझानियन शिलिंग),
				'other' => q(टांझानियन शिलिंग),
			},
		},
		'UAH' => {
			display_name => {
				'currency' => q(यूक्रेनियन हरिन्या),
				'one' => q(युक्रेनियन हरिन्या),
				'other' => q(युक्रेनियन हरिन्या),
			},
		},
		'UGX' => {
			display_name => {
				'currency' => q(युगांडा शिलिंग),
				'one' => q(युगांडा शिलिंग),
				'other' => q(युगांडा शिलिंग),
			},
		},
		'USD' => {
			symbol => '$',
			display_name => {
				'currency' => q(यूएस डॉलर),
				'one' => q(यूएस डॉलर),
				'other' => q(यूएस डॉलर),
			},
		},
		'UYU' => {
			display_name => {
				'currency' => q(उरुग्वेचा पेसो),
				'one' => q(उरुग्वेचा पेसो),
				'other' => q(उरुग्वेचा पेसो),
			},
		},
		'UZS' => {
			display_name => {
				'currency' => q(उझबेकिस्तान सॉम),
				'one' => q(उझबेकिस्तान सॉम),
				'other' => q(उझबेकिस्तान सॉम),
			},
		},
		'VEF' => {
			display_name => {
				'currency' => q(व्हेनेझुएला बोलिव्हार),
				'one' => q(व्हेनेझुएला बोलिव्हार),
				'other' => q(व्हेनेझुएला बोलिव्हार),
			},
		},
		'VND' => {
			symbol => '₫',
			display_name => {
				'currency' => q(व्हिएतनामी डोंग),
				'one' => q(व्हिएतनामी डोंग),
				'other' => q(व्हिएतनामी डोंग),
			},
		},
		'VUV' => {
			display_name => {
				'currency' => q(वानाटु वाटु),
				'one' => q(वानाटु वाटु),
				'other' => q(वानाटु वाटु),
			},
		},
		'WST' => {
			display_name => {
				'currency' => q(सामोअन टाला),
				'one' => q(सामोअन टाला),
				'other' => q(सामोअन टाला),
			},
		},
		'XAF' => {
			symbol => 'FCFA',
			display_name => {
				'currency' => q([CFA] फ्रँक [BEAC]),
				'one' => q([CFA] फ्रँक [BEAC]),
				'other' => q([CFA] फ्रँक्स [BEAC]),
			},
		},
		'XCD' => {
			symbol => 'EC$',
			display_name => {
				'currency' => q(पूर्व कॅरीबियन डॉलर),
				'one' => q(पूर्व कॅरीबियन डॉलर),
				'other' => q(पूर्व कॅरीबियन डॉलर),
			},
		},
		'XOF' => {
			symbol => 'CFA',
			display_name => {
				'currency' => q([CFA] फ्रँक [BCEAO]),
				'one' => q([CFA] फ्रँक [BCEAO]),
				'other' => q([CFA] फ्रँक्स [BCEAO]),
			},
		},
		'XPF' => {
			symbol => 'CFPF',
			display_name => {
				'currency' => q(सीएफपी फ्रँक),
				'one' => q(सीएफपी फ्रँक),
				'other' => q(सीएफपी फ्रँक),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(अज्ञात चलन),
				'one' => q(अज्ञात चलन),
				'other' => q(अज्ञात चलन),
			},
		},
		'YER' => {
			display_name => {
				'currency' => q(येमेनी रियाल),
				'one' => q(येमेनी रियाल),
				'other' => q(येमेनी रियाल),
			},
		},
		'ZAR' => {
			display_name => {
				'currency' => q(दक्षिण आफ्रिकी रँड),
				'one' => q(दक्षिण आफ्रिकी रँड),
				'other' => q(दक्षिण आफ्रिकी रँड),
			},
		},
		'ZMK' => {
			display_name => {
				'currency' => q(झांबियन क्वाचा \(1968–2012\)),
			},
		},
		'ZMW' => {
			display_name => {
				'currency' => q(झांबियन क्वाचा),
				'one' => q(झांबियन क्वाचा),
				'other' => q(झांबियन क्वाचा),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'जाने',
							'फेब्रु',
							'मार्च',
							'एप्रि',
							'मे',
							'जून',
							'जुलै',
							'ऑग',
							'सप्टें',
							'ऑक्टो',
							'नोव्हें',
							'डिसें'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'जा',
							'फे',
							'मा',
							'ए',
							'मे',
							'जू',
							'जु',
							'ऑ',
							'स',
							'ऑ',
							'नो',
							'डि'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'जानेवारी',
							'फेब्रुवारी',
							'मार्च',
							'एप्रिल',
							'मे',
							'जून',
							'जुलै',
							'ऑगस्ट',
							'सप्टेंबर',
							'ऑक्टोबर',
							'नोव्हेंबर',
							'डिसेंबर'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'जाने',
							'फेब्रु',
							'मार्च',
							'एप्रि',
							'मे',
							'जून',
							'जुलै',
							'ऑग',
							'सप्टें',
							'ऑक्टो',
							'नोव्हें',
							'डिसें'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'जा',
							'फे',
							'मा',
							'ए',
							'मे',
							'जू',
							'जु',
							'ऑ',
							'स',
							'ऑ',
							'नो',
							'डि'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'जानेवारी',
							'फेब्रुवारी',
							'मार्च',
							'एप्रिल',
							'मे',
							'जून',
							'जुलै',
							'ऑगस्ट',
							'सप्टेंबर',
							'ऑक्टोबर',
							'नोव्हेंबर',
							'डिसेंबर'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'सोम',
						tue => 'मंगळ',
						wed => 'बुध',
						thu => 'गुरु',
						fri => 'शुक्र',
						sat => 'शनि',
						sun => 'रवि'
					},
					narrow => {
						mon => 'सो',
						tue => 'मं',
						wed => 'बु',
						thu => 'गु',
						fri => 'शु',
						sat => 'श',
						sun => 'र'
					},
					short => {
						mon => 'सो',
						tue => 'मं',
						wed => 'बु',
						thu => 'गु',
						fri => 'शु',
						sat => 'श',
						sun => 'र'
					},
					wide => {
						mon => 'सोमवार',
						tue => 'मंगळवार',
						wed => 'बुधवार',
						thu => 'गुरुवार',
						fri => 'शुक्रवार',
						sat => 'शनिवार',
						sun => 'रविवार'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'सोम',
						tue => 'मंगळ',
						wed => 'बुध',
						thu => 'गुरु',
						fri => 'शुक्र',
						sat => 'शनि',
						sun => 'रवि'
					},
					narrow => {
						mon => 'सो',
						tue => 'मं',
						wed => 'बु',
						thu => 'गु',
						fri => 'शु',
						sat => 'श',
						sun => 'र'
					},
					short => {
						mon => 'सो',
						tue => 'मं',
						wed => 'बु',
						thu => 'गु',
						fri => 'शु',
						sat => 'श',
						sun => 'र'
					},
					wide => {
						mon => 'सोमवार',
						tue => 'मंगळवार',
						wed => 'बुधवार',
						thu => 'गुरुवार',
						fri => 'शुक्रवार',
						sat => 'शनिवार',
						sun => 'रविवार'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'ति1',
						1 => 'ति2',
						2 => 'ति3',
						3 => 'ति4'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => 'प्रथम तिमाही',
						1 => 'द्वितीय तिमाही',
						2 => 'तृतीय तिमाही',
						3 => 'चतुर्थ तिमाही'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => 'ति1',
						1 => 'ति2',
						2 => 'ति3',
						3 => 'ति4'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => 'प्रथम तिमाही',
						1 => 'द्वितीय तिमाही',
						2 => 'तृतीय तिमाही',
						3 => 'चतुर्थ तिमाही'
					},
				},
			},
	} },
);

has 'day_periods' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'abbreviated' => {
					'pm' => q{PM},
					'am' => q{AM},
				},
				'wide' => {
					'am' => q{[AM]},
					'pm' => q{[PM]},
				},
				'narrow' => {
					'am' => q{AM},
					'pm' => q{PM},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'ईसापूर्व',
				'1' => 'सन'
			},
			wide => {
				'0' => 'ईसवीसनपूर्व',
				'1' => 'ईसवीसन'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{EEEE, d MMMM, y G},
			'long' => q{d MMMM, y G},
			'medium' => q{d MMM, y G},
			'short' => q{d/M/y GGGGG},
		},
		'gregorian' => {
			'full' => q{EEEE, d MMMM, y},
			'long' => q{d MMMM, y},
			'medium' => q{d MMM, y},
			'short' => q{d/M/yy},
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			'full' => q{h:mm:ss a zzzz},
			'long' => q{h:mm:ss a z},
			'medium' => q{h:mm:ss a},
			'short' => q{h:mm a},
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{{1} 'वाजता' {0}},
			'long' => q{{1} 'वाजता' {0}},
			'medium' => q{{1}, {0}},
			'short' => q{{1}, {0}},
		},
		'gregorian' => {
			'full' => q{{1} 'रोजी' {0}},
			'long' => q{{1} 'रोजी' {0}},
			'medium' => q{{1}, {0}},
			'short' => q{{1}, {0}},
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Ed => q{E d},
			Gy => q{y G},
			GyMMM => q{MMM y G},
			GyMMMEd => q{E, d MMM, y G},
			GyMMMd => q{d MMM, y G},
			H => q{HH},
			Hm => q{H-mm},
			Hms => q{H-mm-ss},
			M => q{L},
			MEd => q{E, d/M},
			MMM => q{LLL},
			MMMEd => q{E, d MMM},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			MMdd => q{dd-MM},
			Md => q{d/M},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{y G},
			yyyy => q{y G},
			yyyyM => q{M/y GGGGG},
			yyyyMEd => q{E, d/M/y GGGGG},
			yyyyMM => q{MM-y G},
			yyyyMMM => q{MMM y G},
			yyyyMMMEd => q{E, d MMM, y G},
			yyyyMMMM => q{MMMM y G},
			yyyyMMMd => q{d MMM, y G},
			yyyyMd => q{d/M/y GGGGG},
			yyyyQQQ => q{QQQ y G},
			yyyyQQQQ => q{QQQQ y G},
		},
		'gregorian' => {
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{d E},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{G y},
			GyMMM => q{MMM G y},
			GyMMMEd => q{E, d MMM, G y},
			GyMMMd => q{d MMM, G y},
			H => q{HH},
			Hm => q{H:mm},
			Hms => q{H:mm:ss},
			M => q{L},
			MEd => q{E, d/M},
			MMM => q{LLL},
			MMMEd => q{E, d MMM},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			MMdd => q{dd-MM},
			Md => q{d/M},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{y},
			yM => q{M/y},
			yMEd => q{E, d/M/y},
			yMM => q{MM-y},
			yMMM => q{MMM y},
			yMMMEd => q{E, d, MMM y},
			yMMMM => q{MMMM y},
			yMMMd => q{d MMM, y},
			yMd => q{d/M/y},
			yQQQ => q{QQQ y},
			yQQQQ => q{QQQQ y},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'Timezone' => '{0} {1}',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E, d/M – E, d/M},
				d => q{E, d/M – E, d/M},
			},
			MMM => {
				M => q{MMM–MMM},
			},
			MMMEd => {
				M => q{E, d MMM – E, d MMM},
				d => q{E, d MMM – E, d MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d–d MMM},
			},
			Md => {
				M => q{d/M – d/M},
				d => q{d/M – d/M},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y–y G},
			},
			yM => {
				M => q{M/y – M/y GGGGG},
				y => q{M/y – M/y GGGGG},
			},
			yMEd => {
				M => q{E, d/M/y – E, d/M/y GGGGG},
				d => q{E, d/M/y – E, d/M/y GGGGG},
				y => q{E, d/M/y – E, d/M/y GGGGG},
			},
			yMMM => {
				M => q{MMM–MMM y G},
				y => q{MMM y – MMM y G},
			},
			yMMMEd => {
				M => q{E, d MMM - E, d MMM y G},
				d => q{E, d MMM y – E, d MMM, y G},
				y => q{E, d MMM y - E, d MMM y G},
			},
			yMMMM => {
				M => q{MMMM–MMMM y G},
				y => q{MMMM y – MMMM y G},
			},
			yMMMd => {
				M => q{d MMM – d, MMM y G},
				d => q{d–d, MMM y G},
				y => q{d, MMM y – d, MMM y G},
			},
			yMd => {
				M => q{d/M/y – d/M/y GGGGG},
				d => q{d/M/y – d/M/y GGGGG},
				y => q{d/M/y – d/M/y GGGGG},
			},
		},
		'gregorian' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E, d/M - E, d/M},
				d => q{E, d/M - E, d/M},
			},
			MMM => {
				M => q{MMM–MMM},
			},
			MMMEd => {
				M => q{E, d MMM - E, d MMM},
				d => q{E, d MMM - E, d MMM},
			},
			MMMd => {
				M => q{d MMM - d MMM},
				d => q{d-d MMM},
			},
			Md => {
				M => q{d/M - d/M},
				d => q{d/M - d/M},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y–y},
			},
			yM => {
				M => q{M/y – M/y},
				y => q{M/y – M/y},
			},
			yMEd => {
				M => q{E, d/M/y – E, d/M/y},
				d => q{E, d/M/y – E, d/M/y},
				y => q{E, d/M/y – E, d/M/y},
			},
			yMMM => {
				M => q{MMM–MMM y},
				y => q{MMM y – MMM y},
			},
			yMMMEd => {
				M => q{E, d MMM – E, d MMM, y},
				d => q{E, d MMM y – E, d MMM, y},
				y => q{E, d MMM, y – E, d MMM, y},
			},
			yMMMM => {
				M => q{MMMM – MMMM y},
				y => q{MMMM y – MMMM y},
			},
			yMMMd => {
				M => q{d MMM – d MMM, y},
				d => q{d-d MMM, y},
				y => q{d MMM, y – d MMM, y},
			},
			yMd => {
				M => q{d/M/y – d/M/y},
				d => q{d/M/y – d/M/y},
				y => q{d/M/y – d/M/y},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HH:mm;-HH:mm),
		gmtFormat => q([GMT]{0}),
		gmtZeroFormat => q([GMT]),
		regionFormat => q({0} वेळ),
		regionFormat => q({0} सूर्यप्रकाश वेळ),
		regionFormat => q({0} प्रमाण वेळ),
		fallbackFormat => q({1} ({0})),
		'Acre' => {
			long => {
				'daylight' => q(ऐकर ग्रीष्म वेळ),
				'generic' => q(एकर वेळ),
				'standard' => q(एकर प्रमाणवेळ),
			},
		},
		'Afghanistan' => {
			long => {
				'standard' => q(अफगाणिस्तान वेळ),
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#अबिद्जान#,
		},
		'Africa/Accra' => {
			exemplarCity => q#अ‍ॅक्रा#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#आदिस अबाबा#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#अल्जिअर्स#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#एस्मारा#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#बामको#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#बांगुई#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#बंजुल#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#बिसाउ#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#ब्लँटायर#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#ब्राझाव्हिले#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#बुजुंबुरा#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#कैरो#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#कॅसाब्लान्का#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#सेउटा#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#कोनाक्रि#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#डकर#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#दार ए सलाम#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#जिबौटी#,
		},
		'Africa/Douala' => {
			exemplarCity => q#दोउआला#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#एल ऐउन#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#फ्रीटाउन#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#गाबोरोन#,
		},
		'Africa/Harare' => {
			exemplarCity => q#हरारे#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#जोहान्सबर्ग#,
		},
		'Africa/Juba' => {
			exemplarCity => q#जुबा#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#कंपाला#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#खार्टुम#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#कीगाली#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#किन्शासा#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#लागोस#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#लिबरव्हिल#,
		},
		'Africa/Lome' => {
			exemplarCity => q#लोम#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#लुआंडा#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#लुबंबाशी#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#लुसाका#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#मलाबो#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#मापुटो#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#मसेरु#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#मबाबाने#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#मोगादिशु#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#मोनरोव्हिया#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#नैरोबी#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#डीजमेना#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#नियामे#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#नुआकचॉट#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#ओउगाडोउगोउ#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#पोर्टो-नोव्हो#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#साओ तोमे#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#त्रिपोली#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#टयूनिस#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#विंडहोएक#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q(मध्‍य आफ्रिका वेळ),
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q(पूर्व आफ्रिका वेळ),
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q(दक्षिण आफ्रिका वेळ),
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q(पश्चिम आफ्रिका उन्हाळी वेळ),
				'generic' => q(पश्चिम आफ्रिका वेळ),
				'standard' => q(पश्चिम आफ्रिका प्रमाण वेळ),
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q(अलास्का सूर्यप्रकाश वेळ),
				'generic' => q(अलास्का वेळ),
				'standard' => q(अलास्का प्रमाण वेळ),
			},
		},
		'Almaty' => {
			long => {
				'daylight' => q(अल्माटी ग्रीष्मकालीन वेळ),
				'generic' => q(अल्माटी वेळ),
				'standard' => q(अल्माटी प्रमाणवेळ),
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q(अ‍ॅमेझॉन उन्हाळी वेळ),
				'generic' => q(अॅमेझॉन वेळ),
				'standard' => q(अ‍ॅमेझॉन प्रमाण वेळ),
			},
		},
		'America/Adak' => {
			exemplarCity => q#अडॅक#,
		},
		'America/Anchorage' => {
			exemplarCity => q#अँकरेज#,
		},
		'America/Anguilla' => {
			exemplarCity => q#अँग्विला#,
		},
		'America/Antigua' => {
			exemplarCity => q#अँटिग्वा#,
		},
		'America/Araguaina' => {
			exemplarCity => q#अरागुआइना#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#ला रियोजा#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#रियो गॅलेगॉस#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#सॉल्ता#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#सान जुआन#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#सॅन लुईस#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#टुकुमान#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#उस्वाइया#,
		},
		'America/Aruba' => {
			exemplarCity => q#अरुबा#,
		},
		'America/Asuncion' => {
			exemplarCity => q#आसुन्सियोन#,
		},
		'America/Bahia' => {
			exemplarCity => q#बहिया#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#बाहिया बांदेरास#,
		},
		'America/Barbados' => {
			exemplarCity => q#बार्बाडोस#,
		},
		'America/Belem' => {
			exemplarCity => q#बेलेम#,
		},
		'America/Belize' => {
			exemplarCity => q#बेलिझे#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#ब्लांक सॅबलोन#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#बोआ व्हिस्टा#,
		},
		'America/Bogota' => {
			exemplarCity => q#बोगोटा#,
		},
		'America/Boise' => {
			exemplarCity => q#बोइसी#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#ब्युनोस आयर्स#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#केंब्रिज उपसागर#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#कॅम्पो ग्रँडे#,
		},
		'America/Cancun' => {
			exemplarCity => q#कानकुन#,
		},
		'America/Caracas' => {
			exemplarCity => q#कराकास#,
		},
		'America/Catamarca' => {
			exemplarCity => q#कॅटामार्का#,
		},
		'America/Cayenne' => {
			exemplarCity => q#कायेने#,
		},
		'America/Cayman' => {
			exemplarCity => q#केमन#,
		},
		'America/Chicago' => {
			exemplarCity => q#शिकागो#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#चिहुआहुआ#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#अॅटिकोकन#,
		},
		'America/Cordoba' => {
			exemplarCity => q#कॉर्डोबा#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#कोस्टा रिका#,
		},
		'America/Creston' => {
			exemplarCity => q#क्रेस्टन#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#कुइबा#,
		},
		'America/Curacao' => {
			exemplarCity => q#कुराकाओ#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#डेन्मार्कशॉन#,
		},
		'America/Dawson' => {
			exemplarCity => q#डॉसन#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#डॉसन क्रीक#,
		},
		'America/Denver' => {
			exemplarCity => q#डेन्व्हर#,
		},
		'America/Detroit' => {
			exemplarCity => q#डेट्रॉइट#,
		},
		'America/Dominica' => {
			exemplarCity => q#डोमिनिका#,
		},
		'America/Edmonton' => {
			exemplarCity => q#एडमाँटन#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#यूरुनीपे#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#एल साल्वाडोर#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#फोर्टालेझा#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#ग्लेस उपसागर#,
		},
		'America/Godthab' => {
			exemplarCity => q#नूक#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#गूस उपसागर#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#ग्रँड टर्क#,
		},
		'America/Grenada' => {
			exemplarCity => q#ग्रेनेडा#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#ग्वाडेलोउपे#,
		},
		'America/Guatemala' => {
			exemplarCity => q#ग्वाटेमाला#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#गुआयाक्विल#,
		},
		'America/Guyana' => {
			exemplarCity => q#गयाना#,
		},
		'America/Halifax' => {
			exemplarCity => q#हॅलिफॅक्स#,
		},
		'America/Havana' => {
			exemplarCity => q#हवाना#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#हर्मोसिलो#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#नॉक्स, इंडियाना#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#मारेंगो, इंडियाना#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#पीटर्सबर्ग, इंडियाना#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#टेल सिटी, इंडियाना#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#वेवाय-इंडियाना#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#विंसेनस, इंडियाना#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#विनमॅक, इंडियाना#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#इंडियानापोलिस#,
		},
		'America/Inuvik' => {
			exemplarCity => q#इनुविक#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#इकालुइत#,
		},
		'America/Jamaica' => {
			exemplarCity => q#जमैका#,
		},
		'America/Jujuy' => {
			exemplarCity => q#जुजुय#,
		},
		'America/Juneau' => {
			exemplarCity => q#ज्यूनौ#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#माँटिसेलो, केंटुकी#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#क्रालेंदिजिक#,
		},
		'America/La_Paz' => {
			exemplarCity => q#ला पेझ#,
		},
		'America/Lima' => {
			exemplarCity => q#लीमा#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#लॉस एंजेलिस#,
		},
		'America/Louisville' => {
			exemplarCity => q#लुईव्हिल#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#लोअर प्रिन्स क्वार्टर#,
		},
		'America/Maceio' => {
			exemplarCity => q#मेसेइओ#,
		},
		'America/Managua' => {
			exemplarCity => q#मानागुआ#,
		},
		'America/Manaus' => {
			exemplarCity => q#मनौस#,
		},
		'America/Marigot' => {
			exemplarCity => q#मेरीगोट#,
		},
		'America/Martinique' => {
			exemplarCity => q#मार्टिनिक#,
		},
		'America/Matamoros' => {
			exemplarCity => q#माटामोरोस#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#माझातलान#,
		},
		'America/Mendoza' => {
			exemplarCity => q#मेंदोझा#,
		},
		'America/Menominee' => {
			exemplarCity => q#मेनोमिनी#,
		},
		'America/Merida' => {
			exemplarCity => q#मेरिडा#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#मेतलाकतला#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#मेक्सिको सिटी#,
		},
		'America/Miquelon' => {
			exemplarCity => q#मिक्वेलोन#,
		},
		'America/Moncton' => {
			exemplarCity => q#माँकटन#,
		},
		'America/Monterrey' => {
			exemplarCity => q#मॉन्टेरे#,
		},
		'America/Montevideo' => {
			exemplarCity => q#मोन्टेव्हिडियो#,
		},
		'America/Montserrat' => {
			exemplarCity => q#माँन्टसेरात#,
		},
		'America/Nassau' => {
			exemplarCity => q#नसाऊ#,
		},
		'America/New_York' => {
			exemplarCity => q#न्यूयॉर्क#,
		},
		'America/Nipigon' => {
			exemplarCity => q#निपिगोन#,
		},
		'America/Nome' => {
			exemplarCity => q#नोम#,
		},
		'America/Noronha' => {
			exemplarCity => q#नोरोन्हा#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#ब्युलाह, उत्तर डकोटा#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#मध्य, उत्तर डकोटा#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#न्यू सालेम, उत्तर डकोटा#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#ओजिनागा#,
		},
		'America/Panama' => {
			exemplarCity => q#पनामा#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#पँगनिरतुंग#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#पारमरीबो#,
		},
		'America/Phoenix' => {
			exemplarCity => q#फॉनिक्स#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#पोर्ट-औ-प्रिंस#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#पोर्ट ऑफ स्पेन#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#पोर्टो वेल्हो#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#पोर्टो रिको#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#रेनी नदी#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#रॅनकिन इनलेट#,
		},
		'America/Recife' => {
			exemplarCity => q#रेसिफे#,
		},
		'America/Regina' => {
			exemplarCity => q#रेजिना#,
		},
		'America/Resolute' => {
			exemplarCity => q#रेजोल्यूट#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#रियो ब्रांको#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#सँटा इसाबेल#,
		},
		'America/Santarem' => {
			exemplarCity => q#सँटारेम#,
		},
		'America/Santiago' => {
			exemplarCity => q#सॅन्टिएगो#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#सॅन्टो डोमिंगो#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#साओ पावलो#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#इट्टोकोर्टूरमिट#,
		},
		'America/Sitka' => {
			exemplarCity => q#सितका#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#सेंट बार्थेलेमी#,
		},
		'America/St_Johns' => {
			exemplarCity => q#सेंट जॉन्स#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#सेंट किट्स#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#सेंट लुसिया#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#सेंट थॉमस#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#सेंट विन्सेंट#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#स्विफ्ट करंट#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#टेगुसिगाल्पा#,
		},
		'America/Thule' => {
			exemplarCity => q#थुले#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#थंडर उपसागर#,
		},
		'America/Tijuana' => {
			exemplarCity => q#तिजुआना#,
		},
		'America/Toronto' => {
			exemplarCity => q#टोरोंटो#,
		},
		'America/Tortola' => {
			exemplarCity => q#टोर्टोला#,
		},
		'America/Vancouver' => {
			exemplarCity => q#व्हँकुव्हर#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#व्हाइटहॉर्स#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#विनीपेग#,
		},
		'America/Yakutat' => {
			exemplarCity => q#यकुतात#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#यलोनाइफ#,
		},
		'America_Central' => {
			long => {
				'daylight' => q(उत्तर अमेरिकन केंद्रीय सूर्यप्रकाश वेळ),
				'generic' => q(उत्तर अमेरिकन केंद्रीय वेळ),
				'standard' => q(उत्तर अमेरिकन प्रमाण वेळ),
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q(उत्तर अमेरिकन पूर्वी सूर्यप्रकाश वेळ),
				'generic' => q(उत्तर अमेरिकन पूर्वी वेळ),
				'standard' => q(उत्तर अमेरिकन पूर्वी प्रमाण वेळ),
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q(उत्तर अमेरिकन पर्वतीय सूर्यप्रकाश वेळ),
				'generic' => q(उत्तर अमेरिकन पर्वतीय वेळ),
				'standard' => q(उत्तर अमेरिकन पर्वतीय प्रमाण वेळ),
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q(उत्तर अमेरिकन पॅसिफिक सूर्यप्रकाश वेळ),
				'generic' => q(उत्तर अमेरिकन पॅसिफिक वेळ),
				'standard' => q(उत्तर अमेरिकन पॅसिफिक प्रमाण वेळ),
			},
		},
		'Anadyr' => {
			long => {
				'daylight' => q(अनादीर ग्रीष्मकालीन वेळ),
				'generic' => q(एनाडीयर वेळ),
				'standard' => q(अनादीर प्रमाणवेळ),
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#कॅसे#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#डेव्हिस#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#डुमोंट डी'उर्व्हिल#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#मॅक्वायर#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#मॉसन#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#मॅक्मुरडो#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#पामेर#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#रोथेरा#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#स्योवा#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#वोस्टोक#,
		},
		'Aqtau' => {
			long => {
				'daylight' => q(अ‍ॅक्ताउ ग्रीष्मकालीन वेळ),
				'generic' => q(अ‍ॅक्ताउ वेळ),
				'standard' => q(अ‍ॅक्ताउ प्रमाणवेळ),
			},
		},
		'Aqtobe' => {
			long => {
				'daylight' => q(अ‍ॅक्टोबे ग्रीष्मकालीन वेळ),
				'generic' => q(अ‍ॅक्टोबे वेळ),
				'standard' => q(अ‍ॅक्टोबे प्रमाणवेळ),
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q(अरेबियन सूर्यप्रकाश वेळ),
				'generic' => q(अरेबियन वेळ),
				'standard' => q(अरेबियन प्रमाण वेळ),
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#लाँगइयरबीयेन#,
		},
		'Argentina' => {
			long => {
				'daylight' => q(अर्जेंटिना उन्हाळी वेळ),
				'generic' => q(अर्जेंटिना वेळ),
				'standard' => q(अर्जेंटिना प्रमाण वेळ),
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q(पश्चिम अर्जेंटिना उन्हाळी वेळ),
				'generic' => q(पश्चिम अर्जेंटिना वेळ),
				'standard' => q(पश्चिम अर्जेंटिना प्रमाण वेळ),
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q(आर्मेनिया उन्हाळी वेळ),
				'generic' => q(आर्मेनिया वेळ),
				'standard' => q(आर्मेनिया प्रमाण वेळ),
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#एडेन#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#अल्माटी#,
		},
		'Asia/Amman' => {
			exemplarCity => q#अम्मान#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#एनाडीयर#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#अ‍ॅक्टौ#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#अ‍ॅक्टोबे#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#अश्गाबात#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#बगदाद#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#बहारीन#,
		},
		'Asia/Baku' => {
			exemplarCity => q#बाकु#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#बँकॉक#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#बैरुत#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#बिश्केक#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#ब्रुनेई#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#कोलकाता#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#चोईबाल्सन#,
		},
		'Asia/Chongqing' => {
			exemplarCity => q#चाँगकिंग#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#कोलंबो#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#दमास्कस#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#ढाका#,
		},
		'Asia/Dili' => {
			exemplarCity => q#डिलि#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#दुबई#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#दुशान्बे#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#गाझा#,
		},
		'Asia/Harbin' => {
			exemplarCity => q#हार्बिन#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#हेब्रॉन#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#हाँगकाँग#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#होव्ड#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#ईर्कुत्स्क#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#जकार्ता#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#जयापुरा#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#जेरुसलेम#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#काबूल#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#कॅमचाटका#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#कराची#,
		},
		'Asia/Kashgar' => {
			exemplarCity => q#कशगर#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#काठमांडू#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#खंदिगा#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#क्रास्नोयार्स्क#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#क्वालालंपूर#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#कुचिंग#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#कुवेत#,
		},
		'Asia/Macau' => {
			exemplarCity => q#मकाऊ#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#मेगाडन#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#मकस्सार#,
		},
		'Asia/Manila' => {
			exemplarCity => q#मनिला#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#मस्कत#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#निकोसिया#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#नोवोकुझ्नेत्स्क#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#नोवोसिबिर्स्क#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#ओम्स्क#,
		},
		'Asia/Oral' => {
			exemplarCity => q#ओरल#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#प्नोम पेन्ह#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#पाँटियानाक#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#प्योंगयांग#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#कतार#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#किझीलोर्डा#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#रंगून#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#रियाध#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#हो चि मिन्ह शहर#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#साखालिन#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#समरकंद#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#सेउल#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#शांघाय#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#सिंगापूर#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#तैपेई#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#ताश्कंद#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#बिलिसी#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#तेहरान#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#थिंफू#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#टोकियो#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#उलानबातर#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#उरुम्की#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#उस्त-नेरा#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#व्हिएन्टाइन#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#व्लादिवोस्टोक#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#यकुत्स्क#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#येक्तेरिनबर्ग#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#येरेवन#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q(अटलांटिक सूर्यप्रकाश वेळ),
				'generic' => q(अटलांटिक वेळ),
				'standard' => q(अटलांटिक प्रमाण वेळ),
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#अझोरेस#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#बर्मुडा#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#कॅनरी#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#केप व्हर्डे#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#फॅरो#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#मडीयरा#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#रेयक्जाविक#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#दक्षिण जॉर्जिया#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#सेंट. हेलेना#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#स्टॅनले#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#एडलेड#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#ब्रिस्बेन#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#ब्रोकन हिल#,
		},
		'Australia/Currie' => {
			exemplarCity => q#कुह्री#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#डार्विन#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#उक्ला#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#होबार्ट#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#लिंडेमन#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#लॉर्ड होवे#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#मेलबोर्न#,
		},
		'Australia/Perth' => {
			exemplarCity => q#पर्थ#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#सिडनी#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q(ऑस्ट्रेलियन मध्य सूर्यप्रकाश वेळ),
				'generic' => q(मध्य ऑस्ट्रेलिया वेळ),
				'standard' => q(ऑस्ट्रेलियन मध्य प्रमाण वेळ),
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q(ऑस्ट्रेलियन मध्य-पश्चिम सूर्यप्रकाश वेळ),
				'generic' => q(ऑस्ट्रेलियन मध्य-पश्चिम वेळ),
				'standard' => q(ऑस्ट्रेलियन मध्य-पश्चिम प्रमाण वेळ),
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q(ऑस्ट्रेलियन पूर्व सूर्यप्रकाश वेळ),
				'generic' => q(पूर्व ऑस्ट्रेलिया वेळ),
				'standard' => q(ऑस्ट्रेलियन पूर्व प्रमाण वेळ),
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q(ऑस्ट्रेलियन पश्चिम सूर्यप्रकाश वेळ),
				'generic' => q(पश्चिम ऑस्ट्रेलिया वेळ),
				'standard' => q(ऑस्ट्रेलियन पश्चिम प्रमाण वेळ),
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q(अझरबैजान उन्हाळी वेळ),
				'generic' => q(अझरबैजान वेळ),
				'standard' => q(अझरबैजान प्रमाण वेळ),
			},
		},
		'Azores' => {
			long => {
				'daylight' => q(अ‍ॅझोरेस उन्हाळी वेळ),
				'generic' => q(अ‍ॅझोरेस वेळ),
				'standard' => q(अ‍ॅझोरेस प्रमाण वेळ),
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q(बांग्लादेश उन्हाळी वेळ),
				'generic' => q(बांग्लादेश वेळ),
				'standard' => q(बांग्लादेश प्रमाण वेळ),
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q(भूतान वेळ),
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q(बोलिव्हिया वेळ),
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q(ब्राझिलिया उन्हाळी वेळ),
				'generic' => q(ब्राझिलिया वेळ),
				'standard' => q(ब्राझिलिया प्रमाण वेळ),
			},
		},
		'Brunei' => {
			long => {
				'standard' => q(ब्रुनेई दारूसलाम वेळ),
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q(केप व्हर्डे उन्हाळी वेळ),
				'generic' => q(केप व्हर्डे वेळ),
				'standard' => q(केप व्हर्डे प्रमाण वेळ),
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q(चामोरो वेळ),
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q(चॅथम सूर्यप्रकाश वेळ),
				'generic' => q(चॅथम वेळ),
				'standard' => q(चॅथम प्रमाण वेळ),
			},
		},
		'Chile' => {
			long => {
				'daylight' => q(चिली उन्हाळी वेळ),
				'generic' => q(चिली वेळ),
				'standard' => q(चिली प्रमाण वेळ),
			},
		},
		'China' => {
			long => {
				'daylight' => q(चीनी सूर्यप्रकाश वेळ),
				'generic' => q(चीनी वेळ),
				'standard' => q(चीनी प्रमाण वेळ),
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q(चोईबाल्सन उन्हाळी वेळ),
				'generic' => q(चोईबाल्सन वेळ),
				'standard' => q(चोईबाल्सन प्रमाण वेळ),
			},
		},
		'Christmas' => {
			long => {
				'standard' => q(ख्रिसमस बेट वेळ),
			},
		},
		'Cocos' => {
			long => {
				'standard' => q(कॉकोस बेटे वेळ),
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q(कोलंबिया उन्हाळी वेळ),
				'generic' => q(कोलंबिया वेळ),
				'standard' => q(कोलंबिया प्रमाण वेळ),
			},
		},
		'Cook' => {
			long => {
				'daylight' => q(कुक बेटे अर्ध उन्हाळी वेळ),
				'generic' => q(कुक बेटे वेळ),
				'standard' => q(कुक बेटे प्रमाण वेळ),
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q(क्यूबा सूर्यप्रकाश वेळ),
				'generic' => q(क्यूबा वेळ),
				'standard' => q(क्यूबा प्रमाण वेळ),
			},
		},
		'Davis' => {
			long => {
				'standard' => q(डेव्हिस वेळ),
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q(डरमाँट-डी'उर्व्हिले वेळ),
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q(पूर्व तिमोर वेळ),
			},
		},
		'Easter' => {
			long => {
				'daylight' => q(इस्टर बेट उन्हाळी वेळ),
				'generic' => q(इस्टर बेट वेळ),
				'standard' => q(इस्टर बेट प्रमाण वेळ),
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q(इक्वेडोर वेळ),
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#अज्ञात शहर#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#अ‍ॅमस्टरडॅम#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#अँडोरा#,
		},
		'Europe/Athens' => {
			exemplarCity => q#अथेन्स#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#बेलग्रेड#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#बर्लिन#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#ब्रातिस्लाव्हा#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#ब्रुसेल्स#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#बुखारेस्ट#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#बुडापेस्ट#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#बुसिंजेन#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#चिसिनौ#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#कोपेनहेगन#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#डब्लिन#,
			long => {
				'daylight' => q(इरिश उन्हाळी वेळ),
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#जिब्राल्टर#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#ग्वेर्नसे#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#हेलसिंकी#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#आइल ऑफ मॅन#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#इस्तंबूल#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#जर्सी#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#कलिनिनग्राड#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#कीव#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#लिस्बन#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#लुब्लियाना#,
		},
		'Europe/London' => {
			exemplarCity => q#लंडन#,
			long => {
				'daylight' => q(ब्रिटिश उन्हाळी वेळ),
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#लक्झेंबर्ग#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#माद्रिद#,
		},
		'Europe/Malta' => {
			exemplarCity => q#माल्टा#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#मरियेहामेन#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#मिन्स्क#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#मोनॅको#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#मॉस्को#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#ऑस्लो#,
		},
		'Europe/Paris' => {
			exemplarCity => q#पॅरिस#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#पॉडगोरिका#,
		},
		'Europe/Prague' => {
			exemplarCity => q#प्राग#,
		},
		'Europe/Riga' => {
			exemplarCity => q#रिगा#,
		},
		'Europe/Rome' => {
			exemplarCity => q#रोम#,
		},
		'Europe/Samara' => {
			exemplarCity => q#समारा#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#सॅन मरिनो#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#साराजेव्हो#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#सिम्फरोपोल#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#स्कॉप्जे#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#सोफिया#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#स्टॉकहोम#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#तल्लिन्न#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#टिराने#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#उझगोरोड#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#वडूझ#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#व्हॅटिकन#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#व्हिएन्ना#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#विलनियस#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#व्होल्गोग्राड#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#वॉर्सा#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#झॅग्रेब#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#झापोरोझे#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#झुरिच#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q(मध्‍य युरोपियन उन्हाळी वेळ),
				'generic' => q(मध्‍य युरोपियन वेळ),
				'standard' => q(मध्‍य युरोपियन प्रमाण वेळ),
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q(पूर्व युरोपियन उन्हाळी वेळ),
				'generic' => q(पूर्व युरोपियन वेळ),
				'standard' => q(पूर्व युरोपियन प्रमाण वेळ),
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q(पश्चिम युरोपियन उन्हाळी वेळ),
				'generic' => q(पश्चिम युरोपियन वेळ),
				'standard' => q(पश्चिम युरोपियन प्रमाण वेळ),
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q(फॉकलंड बेटे उन्हाळी वेळ),
				'generic' => q(फॉकलंड बेटे वेळ),
				'standard' => q(फॉकलंड बेटे प्रमाण वेळ),
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q(फिजी उन्हाळी वेळ),
				'generic' => q(फिजी वेळ),
				'standard' => q(फिजी प्रमाण वेळ),
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q(फ्रेंच गयाना वेळ),
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q(फ्रेंच दक्षिण आणि अंटार्क्टिक वेळ),
			},
		},
		'GMT' => {
			long => {
				'standard' => q(ग्रीनिच प्रमाण वेळ),
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q(गॅलापागोस वेळ),
			},
		},
		'Gambier' => {
			long => {
				'standard' => q(गॅम्बियर वेळ),
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q(जॉर्जिया उन्हाळी वेळ),
				'generic' => q(जॉर्जिया वेळ),
				'standard' => q(जॉर्जिया प्रमाण वेळ),
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q(गिल्बर्ट बेटे वेळ),
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q(पूर्व ग्रीनलँड उन्हाळी वेळ),
				'generic' => q(पूर्व ग्रीनलँड वेळ),
				'standard' => q(पूर्व ग्रीनलँड प्रमाण वेळ),
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q(पश्चिम ग्रीनलँड उन्हाळी वेळ),
				'generic' => q(पश्चिम ग्रीनलँड वेळ),
				'standard' => q(पश्चिम ग्रीनलँड प्रमाण वेळ),
			},
		},
		'Guam' => {
			long => {
				'standard' => q(गुआम प्रमाणवेळ),
			},
		},
		'Gulf' => {
			long => {
				'standard' => q(खाडी वेळ),
			},
		},
		'Guyana' => {
			long => {
				'standard' => q(गयाना वेळ),
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q(हवाई-अलूशन सूर्यप्रकाश वेळ),
				'generic' => q(हवाई-अलूशन वेळ),
				'standard' => q(हवाई-अलूशन प्रमाण वेळ),
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q(हाँग काँग उन्हाळी वेळ),
				'generic' => q(हाँग काँग वेळ),
				'standard' => q(हाँग काँग प्रमाण वेळ),
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q(होव्ह्ड उन्हाळी वेळ),
				'generic' => q(होव्ह्ड वेळ),
				'standard' => q(होव्ह्ड प्रमाण वेळ),
			},
		},
		'India' => {
			long => {
				'standard' => q(भारतीय प्रमाण वेळ),
			},
			short => {
				'standard' => q(IST),
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#अंटानानारिवो#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#चागोस#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#ख्रिसमस#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#कोकोस#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#कोमोरो#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#करग्यूलेन#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#माहे#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#मालदीव#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#मॉरिशस#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#मायोट्टे#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#रियुनियन#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q(हिंदमहासागर वेळ),
			},
		},
		'Indochina' => {
			long => {
				'standard' => q(इंडोचायना वेळ),
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q(मध्‍य इंडोनेशिया वेळ),
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q(पूर्व इंडोनेशिया वेळ),
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q(पश्चिम इंडोनेशिया वेळ),
			},
		},
		'Iran' => {
			long => {
				'daylight' => q(इराण सूर्यप्रकाश वेळ),
				'generic' => q(इराण वेळ),
				'standard' => q(इराण प्रमाण वेळ),
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q(इर्कुत्सक उन्हाळी वेळ),
				'generic' => q(इर्कुत्सक वेळ),
				'standard' => q(इर्कुत्सक प्रमाण वेळ),
			},
		},
		'Israel' => {
			long => {
				'daylight' => q(इस्राएल सूर्यप्रकाश वेळ),
				'generic' => q(इस्राएल वेळ),
				'standard' => q(इस्राएल प्रमाण वेळ),
			},
		},
		'Japan' => {
			long => {
				'daylight' => q(जपान सूर्यप्रकाश वेळ),
				'generic' => q(जपान वेळ),
				'standard' => q(जपान प्रमाण वेळ),
			},
		},
		'Kamchatka' => {
			long => {
				'daylight' => q(पेट्रोपाव्हलोस्क- कामचाट्स्की ग्रीष्मकालीन वेळ),
				'generic' => q(पेट्रोपाव्हलोस्क- कामचाट्स्की वेळ),
				'standard' => q(पेट्रोपाव्हलोस्क- कामचाट्स्की प्रमाणवेळ),
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q(पूर्व कझाकस्तान वेळ),
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q(पश्चिम कझाकस्तान वेळ),
			},
		},
		'Korea' => {
			long => {
				'daylight' => q(कोरियन सूर्यप्रकाश वेळ),
				'generic' => q(कोरियन वेळ),
				'standard' => q(कोरियन प्रमाण वेळ),
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q(कोस्राई वेळ),
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q(क्रास्नोयार्क्स उन्हाळी वेळ),
				'generic' => q(क्रास्नोयार्स्क वेळ),
				'standard' => q(क्रास्नोयार्स्क प्रमाण वेळ),
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q(किरगिस्तान वेळ),
			},
		},
		'Lanka' => {
			long => {
				'standard' => q(लंका वेळ),
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q(लाइन बेटे वेळ),
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q(लॉर्ड होवे सूर्यप्रकाश वेळ),
				'generic' => q(लॉर्ड होवे वेळ),
				'standard' => q(लॉर्ड होवे प्रमाण वेळ),
			},
		},
		'Macau' => {
			long => {
				'daylight' => q(मकाऊ ग्रीष्मकालीन वेळ),
				'generic' => q(मकाऊ वेळ),
				'standard' => q(मकाऊ प्रमाणवेळ),
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q(मॅक्वेरी बेट वेळ),
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q(मॅगाडन उन्हाळी वेळ),
				'generic' => q(मॅगाडन वेळ),
				'standard' => q(मॅगाडन प्रमाण वेळ),
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q(मलेशिया वेळ),
			},
		},
		'Maldives' => {
			long => {
				'standard' => q(मालदिव वेळ),
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q(मार्क्वेसास वेळ),
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q(मार्शल बेटे वेळ),
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q(मॉरीशस उन्हाळी वेळ),
				'generic' => q(मॉरीशस वेळ),
				'standard' => q(मॉरीशस प्रमाण वेळ),
			},
		},
		'Mawson' => {
			long => {
				'standard' => q(मॉसन वेळ),
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q(उलान बाटोर उन्हाळी वेळ),
				'generic' => q(उलान बाटोर वेळ),
				'standard' => q(उलान बाटोर प्रमाण वेळ),
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q(मॉस्को उन्हाळी वेळ),
				'generic' => q(मॉस्को वेळ),
				'standard' => q(मॉस्को प्रमाण वेळ),
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q(म्यानमार वेळ),
			},
		},
		'Nauru' => {
			long => {
				'standard' => q(नउरु वेळ),
			},
		},
		'Nepal' => {
			long => {
				'standard' => q(नेपाळ वेळ),
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q(न्यू कॅलेडोनिया उन्हाळी वेळ),
				'generic' => q(न्यू कॅलेडोनिया वेळ),
				'standard' => q(नवीन कॅलेडोनिया प्रमाण वेळ),
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q(न्यूझीलंड सूर्यप्रकाश वेळ),
				'generic' => q(न्यूझीलंड वेळ),
				'standard' => q(न्यूझीलंड प्रमाण वेळ),
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q(न्यू फाउंडलंड सूर्यप्रकाश वेळ),
				'generic' => q(न्यू फाउंडलंड वेळ),
				'standard' => q(न्यू फाउंडलंड प्रमाण वेळ),
			},
		},
		'Niue' => {
			long => {
				'standard' => q(निऊइ वेळ),
			},
		},
		'Norfolk' => {
			long => {
				'standard' => q(नॉरफोक बेट वेळ),
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q(फर्नांडो दी नोरोन्हा उन्हाळी वेळ),
				'generic' => q(फर्नांडो दी नोरोन्हा वेळ),
				'standard' => q(फर्नांडो दी नोरोन्हा प्रमाण वेळ),
			},
		},
		'North_Mariana' => {
			long => {
				'standard' => q(उत्तर मरिना बेटे वेळ),
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q(नोवोसिबिर्स्क उन्हाळी वेळ),
				'generic' => q(नोवोसिबिर्स्क वेळ),
				'standard' => q(नोवोसिबिर्स्क प्रमाण वेळ),
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q(ओम्स्क उन्हाळी वेळ),
				'generic' => q(ओम्स्क वेळ),
				'standard' => q(ऑम्स्क प्रमाण वेळ),
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#अपिया#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#ऑकलंड#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#चॅटहॅम#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#ईस्टर#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#इफेट#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#एंडरबरी#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#फाकाओफो#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#फिजी#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#फुनाफुती#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#गॅलापागोस#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#गॅम्बियर#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#ग्वाडलकनाल#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#गुआम#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#होनोलुलू#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#जोहान्स्टन#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#किरितिमाती#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#कोसराए#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#क्वाजालेईन#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#मजुरो#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#मारक्विसास#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#मिडवे#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#नउरु#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#नियू#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#नॉरफोक#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#नौमिआ#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#पॅगो पॅगो#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#पलाऊ#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#पिट्कैर्न#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#पोनपेई#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#पोर्ट मोरेस्बे#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#रारोटोंगा#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#सैपान#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#ताहिती#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#तारावा#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#टोंगाटापू#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#चूक#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#वेक#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#वालिस#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q(पाकिस्तान उन्हाळी वेळ),
				'generic' => q(पाकिस्तान वेळ),
				'standard' => q(पाकिस्तान प्रमाण वेळ),
			},
		},
		'Palau' => {
			long => {
				'standard' => q(पलाऊ वेळ),
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q(पापुआ न्यू गिनी वेळ),
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q(पॅराग्वे उन्हाळी वेळ),
				'generic' => q(पॅराग्वे वेळ),
				'standard' => q(पॅराग्वे प्रमाण वेळ),
			},
		},
		'Peru' => {
			long => {
				'daylight' => q(पेरु उन्हाळी वेळ),
				'generic' => q(पेरु वेळ),
				'standard' => q(पेरु प्रमाण वेळ),
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q(फिलिपाइन उन्हाळी वेळ),
				'generic' => q(फिलिपाइन वेळ),
				'standard' => q(फिलिपाइन प्रमाण वेळ),
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q(‍फोनिक्स बेटे वेळ),
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q(सेंट पियर आणि मिक्वेलोन सूर्यप्रकाश वेळ),
				'generic' => q(सेंट पियर आणि मिक्वेलोन वेळ),
				'standard' => q(सेंट पियर आणि मिक्वेलोन प्रमाण वेळ),
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q(पिटकैर्न वेळ),
			},
		},
		'Ponape' => {
			long => {
				'standard' => q(पोनॅपे वेळ),
			},
		},
		'Qyzylorda' => {
			long => {
				'daylight' => q(क़िझीलोर्डा ग्रीष्मकालीन वेळ),
				'generic' => q(क़िझीलोर्डा वेळ),
				'standard' => q(क़िझीलोर्डा प्रमाणवेळ),
			},
		},
		'Reunion' => {
			long => {
				'standard' => q(रियुनियन वेळ),
			},
		},
		'Rothera' => {
			long => {
				'standard' => q(रोथेरा वेळ),
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q(सखलिन उन्हाळी वेळ),
				'generic' => q(सखलिन वेळ),
				'standard' => q(सखलिन प्रमाण वेळ),
			},
		},
		'Samara' => {
			long => {
				'daylight' => q(सामरा ग्रीष्मकालीन वेळ),
				'generic' => q(समारा वेळ),
				'standard' => q(सामरा प्रमाणवेळ),
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q(सामोआ उन्हाळी वेळ),
				'generic' => q(सामोआ वेळ),
				'standard' => q(सामोआ प्रमाण वेळ),
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q(सेशेल्स वेळ),
			},
		},
		'Singapore' => {
			long => {
				'standard' => q(सिंगापूर प्रमाण वेळ),
			},
		},
		'Solomon' => {
			long => {
				'standard' => q(सोलोमॉन बेटे वेळ),
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q(दक्षिण जॉर्जिया वेळ),
			},
		},
		'Suriname' => {
			long => {
				'standard' => q(सुरिनाम वेळ),
			},
		},
		'Syowa' => {
			long => {
				'standard' => q(स्योवा वेळ),
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q(ताहिती वेळ),
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q(तैपेई सूर्यप्रकाश वेळ),
				'generic' => q(तैपेई वेळ),
				'standard' => q(तैपेई प्रमाण वेळ),
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q(ताजिकिस्तान वेळ),
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q(टोकेलाऊ वेळ),
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q(टोंगा उन्हाळी वेळ),
				'generic' => q(टोंगा वेळ),
				'standard' => q(टोंगा प्रमाण वेळ),
			},
		},
		'Truk' => {
			long => {
				'standard' => q(चूक वेळ),
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q(तुर्कमेनिस्तान उन्हाळी वेळ),
				'generic' => q(तुर्कमेनिस्तान वेळ),
				'standard' => q(तुर्कमेनिस्तान प्रमाण वेळ),
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q(तुवालू वेळ),
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q(उरुग्वे उन्हाळी वेळ),
				'generic' => q(उरुग्वे वेळ),
				'standard' => q(उरुग्वे प्रमाण वेळ),
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q(उझबेकिस्तान उन्हाळी वेळ),
				'generic' => q(उझबेकिस्तान वेळ),
				'standard' => q(उझबेकिस्तान प्रमाण वेळ),
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q(वनातू उन्हाळी वेळ),
				'generic' => q(वनातू वेळ),
				'standard' => q(वनातू प्रमाण वेळ),
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q(व्हेनेझुएला वेळ),
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q(व्लादिवोस्तोक उन्हाळी वेळ),
				'generic' => q(व्लादिवोस्तोक वेळ),
				'standard' => q(व्लादिवोस्तोक प्रमाण वेळ),
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q(व्होल्गोग्राड उन्हाळी वेळ),
				'generic' => q(व्होल्गोग्राड वेळ),
				'standard' => q(व्होल्गोग्रड प्रमाण वेळ),
			},
		},
		'Vostok' => {
			long => {
				'standard' => q(व्होस्टॉक वेळ),
			},
		},
		'Wake' => {
			long => {
				'standard' => q(वेक बेट वेळ),
			},
		},
		'Wallis' => {
			long => {
				'standard' => q(वॉलिस आणि फुटुना वेळ),
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q(याकुत्सक उन्हाळी वेळ),
				'generic' => q(याकुत्सक वेळ),
				'standard' => q(याकुत्सक प्रमाण वेळ),
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q(येकतरिनबर्ग उन्हाळी वेळ),
				'generic' => q(येकतरिनबर्ग वेळ),
				'standard' => q(येकतरिनबर्ग प्रमाण वेळ),
			},
		},
	 } }
);
no Moose;
__PACKAGE__->meta->make_immutable;

1;

# vim: tabstop=4
