package Locale::CLDR::Gu v0.25.1;
# This file auto generated from Data\common\main\gu.xml
#	on Sat 10 May 12:03:14 pm GMT
# XML file generated 2014-02-28 23:57:43 -0600 (Fri, 28 Feb 2014)

use v5.18;
use mro 'c3';
use utf8;

use Moose;

extends('Locale::CLDR::Root');
# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $territory, $script, $variant) = @_;

	my $display_pattern = '{0} ({1})';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0}, {1}', grep {$_} (
		$territory,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub { 
		 sub {
			 my %languages = (
				'aa' => 'અફાર',
 				'ab' => 'અબખાજિયન',
 				'ace' => 'અચીની',
 				'ach' => 'એકોલી',
 				'ada' => 'અદાંગ્મી',
 				'ady' => 'અદિઘે',
 				'ae' => 'અવેસ્તન',
 				'af' => 'આફ્રિકન્સ',
 				'afh' => 'અફ્રિહિલી',
 				'agq' => 'agq',
 				'ain' => 'એનૂ',
 				'ak' => 'અકાન',
 				'akk' => 'અક્કાદીયાન',
 				'ale' => 'અલેઉત',
 				'alt' => 'દક્ષિણ અલ્તાઇ',
 				'am' => 'એમ્હારિક',
 				'an' => 'અર્ગોનીઝ',
 				'ang' => 'જુની અંગ્રેજી',
 				'anp' => 'અંગીકા',
 				'ar' => 'અરબી',
 				'ar_001' => 'મોડર્ન સ્ટાન્ડર્ડ અરબી',
 				'arc' => 'અર્માઇક',
 				'arn' => 'એરોકૈનિયન',
 				'arp' => 'અરાપાહો',
 				'arw' => 'અરાવક',
 				'as' => 'આસામી',
 				'ast' => 'અસ્તુરિયન',
 				'av' => 'અવેરિક',
 				'awa' => 'અવધી',
 				'ay' => 'આયમારા',
 				'az' => 'અઝરબૈજાની',
 				'az@alt=short' => 'અઝેરી',
 				'ba' => 'બષ્ખિર',
 				'bal' => 'બલૂચી',
 				'ban' => 'બાલિનીસ',
 				'bas' => 'બસા',
 				'bax' => 'બામન',
 				'be' => 'બેલારુશિયન',
 				'bej' => 'બેજા',
 				'bem' => 'બેમ્બા',
 				'bg' => 'બલ્ગેરિયન',
 				'bho' => 'ભોજપુરી',
 				'bi' => 'બિસ્લામા',
 				'bik' => 'બિકોલ',
 				'bin' => 'બિની',
 				'bla' => 'સિક્સિકા',
 				'bm' => 'બામ્બારા',
 				'bn' => 'બંગાળી',
 				'bo' => 'તિબેટીયન',
 				'br' => 'બ્રેટોન',
 				'bra' => 'બ્રજ',
 				'brx' => 'બોડો',
 				'bs' => 'બોસ્નિયન',
 				'bua' => 'બુરિયાત',
 				'bug' => 'બગિનીસ',
 				'byn' => 'બ્લિન',
 				'ca' => 'કતલાન',
 				'cad' => 'કડ્ડો',
 				'car' => 'કરિબ',
 				'cch' => 'અત્સમ',
 				'ce' => 'ચેચન',
 				'ceb' => 'સિબુઆનો',
 				'ch' => 'કેમોરો',
 				'chb' => 'ચિબ્ચા',
 				'chg' => 'છગાતાઇ',
 				'chk' => 'ચૂકીસે',
 				'chm' => 'મારી',
 				'chn' => 'ચિનૂક જાર્ગન',
 				'cho' => 'ચોક્તૌ',
 				'chp' => 'શિપેવ્યાન',
 				'chr' => 'શેરોકી',
 				'chy' => 'શેયેન્ન',
 				'ckb' => 'સોરાની કુર્દિશ',
 				'co' => 'કોર્સિકન',
 				'cop' => 'કોપ્ટિક',
 				'cr' => 'ક્રી',
 				'crh' => 'ક્રિમીન તુર્કી',
 				'cs' => 'ચેક',
 				'csb' => 'કાશુબિયન',
 				'cu' => 'ચર્ચ સ્લાવિક',
 				'cv' => 'ચૂવાશ',
 				'cy' => 'વેલ્શ',
 				'da' => 'ડેનિશ',
 				'dak' => 'દાકોતા',
 				'dar' => 'દાર્ગવા',
 				'de' => 'જર્મન',
 				'de_AT' => 'ઓસ્ટ્રિઅન જર્મન',
 				'de_CH' => 'સ્વિસ હાય જર્મન',
 				'del' => 'દેલેવેર',
 				'den' => 'સ્લેવ',
 				'dgr' => 'ડોગ્રિબ',
 				'din' => 'દિન્કા',
 				'doi' => 'ડોગ્રી',
 				'dsb' => 'નિમ્ન સોર્બિયન',
 				'dua' => 'દુઆલા',
 				'dum' => 'મધ્ય ડચ',
 				'dv' => 'દિવેહી',
 				'dyu' => 'ડ્યુલા',
 				'dz' => 'ઝોંગખા',
 				'ee' => 'ઈવ',
 				'efi' => 'એફિક',
 				'egy' => 'પ્રાચીન ઇજીપ્શિયન',
 				'eka' => 'એકાજુક',
 				'el' => 'ગ્રીક',
 				'elx' => 'એલામાઇટ',
 				'en' => 'અંગ્રેજી',
 				'en_AU' => 'ઓસ્ટ્રેલિયન અંગ્રેજી',
 				'en_CA' => 'કેનેડિયન અંગ્રેજી',
 				'en_GB' => 'બ્રિટિશ અંગ્રેજી',
 				'en_GB@alt=short' => 'યુ.કે. અંગ્રેજી',
 				'en_US' => 'અમેરિકન અંગ્રેજી',
 				'en_US@alt=short' => 'યુ. એસ. અંગ્રેજી',
 				'enm' => 'મિડિલ અંગ્રેજી',
 				'eo' => 'એસ્પેરાન્ટો',
 				'es' => 'સ્પેનિશ',
 				'es_419' => 'લેટિન અમેરિકન સ્પેનિશ',
 				'es_ES' => 'યુરોપિયન સ્પેનિશ',
 				'es_MX' => 'મેક્સિકન સ્પેનિશ',
 				'et' => 'એસ્ટોનિયન',
 				'eu' => 'બાસ્ક',
 				'ewo' => 'ઇવોન્ડો',
 				'fa' => 'પર્શિયન',
 				'fan' => 'ફેંગ',
 				'fat' => 'ફન્ટી',
 				'ff' => 'ફુલાહ',
 				'fi' => 'ફિનિશ',
 				'fil' => 'ફિલિપિનો',
 				'fj' => 'ફિજીયન',
 				'fo' => 'ફોરિસ્ત',
 				'fon' => 'ફોન',
 				'fr' => 'ફ્રેન્ચ',
 				'fr_CA' => 'કેનેડિયન ફ્રેંચ',
 				'fr_CH' => 'સ્વિસ ફ્રેંચ',
 				'frm' => 'મિડિલ ફ્રેંચ',
 				'fro' => 'જૂની ફ્રેંચ',
 				'frr' => 'નોર્ધર્ન ફ્રિશિયન',
 				'frs' => 'પૂર્વ ફ્રિશિયન',
 				'fur' => 'ફ્રિયુલિયાન',
 				'fy' => 'પશ્ચિમી ફ્રિશિયન',
 				'ga' => 'આઇરિશ',
 				'gaa' => 'Ga',
 				'gay' => 'ગાયો',
 				'gba' => 'બાયા',
 				'gd' => 'સ્કોટ્સ ગેલિક',
 				'gez' => 'ગીઝ',
 				'gil' => 'જિલ્બરટીઝ',
 				'gl' => 'ગેલિશિયન',
 				'gmh' => 'મધ્ય હાઇ જર્મન',
 				'gn' => 'ગુઆરાની',
 				'goh' => 'જૂની હાઇ જર્મન',
 				'gon' => 'ગોંડી',
 				'gor' => 'ગોરોન્તાલો',
 				'got' => 'ગોથિક',
 				'grb' => 'ગ્રેબો',
 				'grc' => 'પ્રાચીન ગ્રીક',
 				'gsw' => 'સ્વિસ જર્મન',
 				'gu' => 'ગુજરાતી',
 				'gv' => 'માંક્સ',
 				'gwi' => 'ગ્વિચ\'ઇન',
 				'ha' => 'હૌસા',
 				'hai' => 'હૈડા',
 				'haw' => 'હાવાઇયન',
 				'he' => 'હીબ્રુ',
 				'hi' => 'હિન્દી',
 				'hil' => 'હિલિગેનોન',
 				'hit' => 'હિટ્ટિતે',
 				'hmn' => 'મોંગ',
 				'ho' => 'હિરી મોટૂ',
 				'hr' => 'ક્રોએશિયન',
 				'hsb' => 'અપ્પર સોર્બિયન',
 				'ht' => 'હૈતીયન',
 				'hu' => 'હંગેરિયન',
 				'hup' => 'હૂપા',
 				'hy' => 'આર્મેનિયન',
 				'hz' => 'હેરેરો',
 				'ia' => 'ઇંટરલિંગુઆ',
 				'iba' => 'ઇબાન',
 				'id' => 'ઇન્ડોનેશિયન',
 				'ie' => 'ઇંટરલિંગ',
 				'ig' => 'ઇગ્બો',
 				'ii' => 'સિચુઆન યી',
 				'ik' => 'ઇનુપિયાક',
 				'ilo' => 'ઇલોકો',
 				'inh' => 'ઇંગુશ',
 				'io' => 'ઇડૌ',
 				'is' => 'આઇસલેન્ડિક',
 				'it' => 'ઇટાલિયન',
 				'iu' => 'ઇનુકિટૂટ',
 				'ja' => 'જાપાનીઝ',
 				'jbo' => 'લોજ્બાન',
 				'jpr' => 'જુદેઓ-પર્શિયન',
 				'jrb' => 'જુદેઓ-અરબી',
 				'jv' => 'જાવાનીસ',
 				'ka' => 'જ્યોર્જિઅન',
 				'kaa' => 'કારા-કલ્પક',
 				'kab' => 'કબાઇલ',
 				'kac' => 'કાચિન',
 				'kaj' => 'જ્જુ',
 				'kam' => 'કમ્બા',
 				'kaw' => 'કાવી',
 				'kbd' => 'કબાર્ડિયન',
 				'kcg' => 'ત્યાપ',
 				'kfo' => 'કોરો',
 				'kg' => 'કોંગો',
 				'kha' => 'ખાસી',
 				'kho' => 'ખોતાનીસ',
 				'ki' => 'કિકુયૂ',
 				'kj' => 'ક્વાન્યામા',
 				'kk' => 'કઝાક',
 				'kl' => 'કલાલ્લિસુત',
 				'km' => 'ખ્મેર',
 				'kmb' => 'કિમ્બન્દુ',
 				'kn' => 'કન્નડા',
 				'ko' => 'કોરિયન',
 				'kok' => 'કોંકણી',
 				'kos' => 'કોસરિયન',
 				'kpe' => 'ક્પેલ્લે',
 				'kr' => 'કનુરી',
 				'krc' => 'કરાચય-બલ્કાર',
 				'krl' => 'કરેલિયન',
 				'kru' => 'કુરૂખ',
 				'ks' => 'કશ્મીરી',
 				'ku' => 'કુર્દિશ',
 				'kum' => 'કુમીક',
 				'kut' => 'કુતેનાઇ',
 				'kv' => 'કોમી',
 				'kw' => 'કોર્નિશ',
 				'ky' => 'કિર્ગીઝ',
 				'la' => 'લેટિન',
 				'lad' => 'લાદીનો',
 				'lah' => 'લાહન્ડા',
 				'lam' => 'લામ્બા',
 				'lb' => 'લક્ઝેમબર્ગિશ',
 				'lez' => 'લેઝધીયન',
 				'lg' => 'ગાંડા',
 				'li' => 'લિંબૂર્ગિશ',
 				'ln' => 'લિંગાલા',
 				'lo' => 'લાઓથિયન',
 				'lol' => 'મોગો',
 				'loz' => 'લોઝી',
 				'lt' => 'લિથુનિયન',
 				'lu' => 'લ્યૂબા કટાંગા',
 				'lua' => 'લ્યૂબા-લુલુઆ',
 				'lui' => 'લુઇસેનો',
 				'lun' => 'લુન્ડા',
 				'luo' => 'લ્યુઓ',
 				'lus' => 'લુશાઇ',
 				'lv' => 'લાતવિયન',
 				'mad' => 'માદુરીસ',
 				'mag' => 'મગહી',
 				'mai' => 'મૈથિલી',
 				'mak' => 'મકાસર',
 				'man' => 'મન્ડિન્ગો',
 				'mas' => 'મસાઇ',
 				'mdf' => 'મોક્ષ',
 				'mdr' => 'મંડાર',
 				'men' => 'મેન્ડે',
 				'mfe' => 'મોરીસ્યેન',
 				'mg' => 'મલાગસી',
 				'mga' => 'મિડિલ આઇરિશ',
 				'mh' => 'માર્શલીઝ',
 				'mi' => 'માઓરી',
 				'mic' => 'મિકમેક',
 				'min' => 'મિનાંગ્કાબાઉ',
 				'mk' => 'મેસેડોનિયન',
 				'ml' => 'મલયાલમ',
 				'mn' => 'મોંગોલિયન',
 				'mnc' => 'માન્ચુ',
 				'mni' => 'મનિપૂરી',
 				'moh' => 'મોહૌક',
 				'mos' => 'મોસ્સી',
 				'mr' => 'મરાઠી',
 				'ms' => 'મલય',
 				'mt' => 'માલ્ટિઝ',
 				'mul' => 'બહુવિધ ભાષા',
 				'mus' => 'ક્રિક',
 				'mwl' => 'મિરાંડી',
 				'mwr' => 'મારવાડી',
 				'my' => 'બર્મીઝ',
 				'myv' => 'એર્ઝયા',
 				'na' => 'નાઉરૂ',
 				'nap' => 'નેપોલિટાન',
 				'nb' => 'નોર્વેજીયન બોકમાલ',
 				'nd' => 'ઉતર દેબેલ',
 				'nds' => 'લો જર્મન',
 				'ne' => 'નેપાળી',
 				'new' => 'નેવારી',
 				'ng' => 'ડોન્ગા',
 				'nia' => 'નિયાસ',
 				'niu' => 'નિયુઆન',
 				'nl' => 'ડચ',
 				'nl_BE' => 'ફ્લેમિશ',
 				'nn' => 'નૉર્વેજીયન નાયનૉર્સ્ક',
 				'no' => 'નૉર્વેજીયન',
 				'nog' => 'નોગાઇ',
 				'non' => 'જૂની નોર્સ',
 				'nqo' => 'એન\'કો',
 				'nr' => 'દક્ષિણ દેબેલ',
 				'nso' => 'ઉતરી સોથો',
 				'nv' => 'નાવાજો',
 				'nwc' => 'પરંપરાગત નેવારી',
 				'ny' => 'ન્યાન્જા',
 				'nym' => 'ન્યામવેઝી',
 				'nyn' => 'ન્યાનકોલ',
 				'nyo' => 'ન્યોરો',
 				'nzi' => 'ન્ઝિમા',
 				'oc' => 'ઓક્સિટન',
 				'oj' => 'ઓઝિંબ્વા',
 				'om' => 'ઓરોમો',
 				'or' => 'ઉડિયા',
 				'os' => 'ઓસ્સેટિક',
 				'osa' => 'ઓસેજ',
 				'ota' => 'ઓટોમાન તુર્કિશ',
 				'pa' => 'પંજાબી',
 				'pag' => 'પંગાસીનાન',
 				'pal' => 'પહલવી',
 				'pam' => 'પમ્પાન્ગા',
 				'pap' => 'પાપિયામેન્ટો',
 				'pau' => 'પલાઉઆન',
 				'peo' => 'જૂની પર્શિયન',
 				'phn' => 'ફોનિશિયન',
 				'pi' => 'પાલી',
 				'pl' => 'પોલીશ',
 				'pon' => 'પોહપિએન',
 				'pro' => 'જુની પ્રોવેન્સલ',
 				'ps' => 'પશ્તો',
 				'ps@alt=variant' => 'પુશ્ટો',
 				'pt' => 'પોર્ટુગીઝ',
 				'pt_BR' => 'બ્રાઝિલીયન પોર્ટુગીઝ',
 				'pt_PT' => 'યુરોપિયન પોર્ટુગીઝ',
 				'qu' => 'ક્વેચુઆ',
 				'raj' => 'રાજસ્થાની',
 				'rap' => 'રાપાનુઇ',
 				'rar' => 'રારોટોંગન',
 				'rm' => 'રોમાન્સ',
 				'rn' => 'રૂન્દી',
 				'ro' => 'રોમાનિયન',
 				'ro_MD' => 'મોલડાવિયન',
 				'rom' => 'રોમાની',
 				'root' => 'મૂલ',
 				'ru' => 'રશિયન',
 				'rup' => 'અરોમેનિયન',
 				'rw' => 'કિન્યારવાન્ડા',
 				'sa' => 'સંસ્કૃત',
 				'sad' => 'સોંડવે',
 				'sah' => 'યાકૂત',
 				'sam' => 'સામરિટાન અરેમિક',
 				'sas' => 'સાસાક',
 				'sat' => 'સંતાલી',
 				'sc' => 'સાર્દિનિયન',
 				'scn' => 'સિસિલિયાન',
 				'sco' => 'સ્કોટ્સ',
 				'sd' => 'સિંધી',
 				'se' => 'નૉર્થન સામી',
 				'sel' => 'સેલ્કપ',
 				'sg' => 'સાંગો',
 				'sga' => 'જૂની આયરિશ',
 				'sh' => 'સર્બો-ક્રોએશિયન',
 				'shn' => 'શેન',
 				'si' => 'સિંહલી',
 				'sid' => 'સિદામો',
 				'sk' => 'સ્લોવૅક',
 				'sl' => 'સ્લોવેનિયન',
 				'sm' => 'સામોન',
 				'sma' => 'દક્ષિણ સામી',
 				'smj' => 'લ્યુલ સામી',
 				'smn' => 'ઇનારી સામી',
 				'sms' => 'સ્કોલ્ટ સામી',
 				'sn' => 'શોના',
 				'snk' => 'સોનિન્કે',
 				'so' => 'સોમાલી',
 				'sog' => 'સોગ્ડિએન',
 				'sq' => 'અલ્બેનિયન',
 				'sr' => 'સર્બિયન',
 				'srn' => 'સ્રાનન ટોન્ગો',
 				'srr' => 'સેરેર',
 				'ss' => 'સ્વાતી',
 				'st' => 'સદર્ન સોથો',
 				'su' => 'સંડેનીઝ',
 				'suk' => 'સુકુમા',
 				'sus' => 'સુસુ',
 				'sux' => 'સુમેરિયન',
 				'sv' => 'સ્વીડિશ',
 				'sw' => 'સ્વાહિલી',
 				'swb' => 'કોમોરિયન',
 				'syc' => 'પરંપરાગત સિરિએક',
 				'syr' => 'સિરિએક',
 				'ta' => 'તમિલ',
 				'te' => 'તેલુગુ',
 				'tem' => 'ટિમ્ને',
 				'ter' => 'તેરેનો',
 				'tet' => 'તેતુમ',
 				'tg' => 'તાજીક',
 				'th' => 'થાઈ',
 				'ti' => 'ટાઇગ્રિનિયા',
 				'tig' => 'ટાઇગ્રે',
 				'tiv' => 'તિવ',
 				'tk' => 'તુર્કમેન',
 				'tkl' => 'તોકેલાઉ',
 				'tl' => 'ટાગાલોગ',
 				'tlh' => 'ક્લિન્ગોન',
 				'tli' => 'લિંગિત',
 				'tmh' => 'તામાશેખ',
 				'tn' => 'ત્સ્વાના',
 				'to' => 'ટોંગાન',
 				'tog' => 'ન્યાસા ટોન્ગા',
 				'tpi' => 'ટોક પિસિન',
 				'tr' => 'ટર્કીશ',
 				'ts' => 'સોંગા',
 				'tsi' => 'સિમ્શિયન',
 				'tt' => 'તતાર',
 				'tum' => 'તુમ્બુકા',
 				'tvl' => 'તુવાલુ',
 				'tw' => 'ટ્વાઇ',
 				'ty' => 'તાહિતિયન',
 				'tyv' => 'ટુવીનિયન',
 				'udm' => 'ઉદમુર્ત',
 				'ug' => 'ઉઇગુર',
 				'uga' => 'યુગેરિટિક',
 				'uk' => 'યુક્રેનિયન',
 				'umb' => 'ઉમ્બુન્ડૂ',
 				'und' => 'અજ્ઞાત ભાષા',
 				'ur' => 'ઉર્દુ',
 				'uz' => 'ઉઝ્બેક',
 				'vai' => 'વાઇ',
 				've' => 'વેન્દા',
 				'vi' => 'વિયેતનામીસ',
 				'vo' => 'વોલાપુક',
 				'vot' => 'વોટિક',
 				'wa' => 'વાલૂન',
 				'wal' => 'વલામો',
 				'war' => 'વારે',
 				'was' => 'વાશો',
 				'wo' => 'વોલોફ',
 				'xal' => 'કાલ્મિક',
 				'xh' => 'ખોસા',
 				'yao' => 'યાઓ',
 				'yap' => 'યાપીસ',
 				'yi' => 'યિદ્દિશ',
 				'yo' => 'યોરૂબા',
 				'yue' => 'કેંટોનીઝ',
 				'za' => 'ઝુઆગ',
 				'zap' => 'ઝેપોટેક',
 				'zbl' => 'બ્લિસિમ્બોલ્સ',
 				'zen' => 'ઝેનાગા',
 				'zgh' => 'પ્રમાણભૂત મોરોક્કન ટમાઝિટ',
 				'zh' => 'ચાઇનીઝ',
 				'zh_Hans' => 'સરળીકૃત ચાઇનીઝ',
 				'zh_Hant' => 'પારંપરિક ચાઇનીઝ',
 				'zu' => 'ઝુલુ',
 				'zun' => 'ઝૂની',
 				'zxx' => 'કોઇ ભાષાશાસ્ત્રીય સામગ્રી નથી',
 				'zza' => 'ઝાઝા',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Arab' => 'અરેબી',
 			'Arab@alt=variant' => 'પર્સો-અરેબીક',
 			'Armi' => 'ઇમ્પિરિયલ આર્મનિક',
 			'Armn' => 'અર્મેનિયન',
 			'Avst' => 'અવેસ્તન',
 			'Bali' => 'બાલીનીઝ',
 			'Batk' => 'બટાક',
 			'Beng' => 'બંગાળી',
 			'Blis' => 'બ્લિસિમ્બોલ્સ',
 			'Bopo' => 'બોપોમોફો',
 			'Brah' => 'બ્રહ્મી',
 			'Brai' => 'બ્રેલ',
 			'Bugi' => 'બગિનીસ',
 			'Buhd' => 'બુહિદ',
 			'Cakm' => 'ચકમા',
 			'Cans' => 'યુનાઇટેડ કેનેડિયન એબોરિજનલ સિલેબિક્સ',
 			'Cari' => 'કરૈન',
 			'Cher' => 'ચેરોકી',
 			'Cirt' => 'સિર્થ',
 			'Copt' => 'કોપ્ટિક',
 			'Cprt' => 'સિપ્રાયટ',
 			'Cyrl' => 'સિરિલિક',
 			'Cyrs' => 'ઓલ્ડ ચર્ચ સ્લાવોનિક સિરિલિક',
 			'Deva' => 'દેવનાગરી',
 			'Dsrt' => 'ડેસરેટ',
 			'Egyd' => 'ઇજિપ્શિયન ડેમોટિક',
 			'Egyh' => 'ઇજિપ્શિયન હાઇરેટિક',
 			'Egyp' => 'ઇજિપ્શિયન હાઇરોગ્લિફ્સ',
 			'Ethi' => 'ઇથિયોપિક',
 			'Geok' => 'જ્યોર્જિઅન ખુતસુરી',
 			'Geor' => 'જ્યોર્જિઅન',
 			'Glag' => 'ગ્લેગોલિટિક',
 			'Goth' => 'ગોથિક',
 			'Grek' => 'ગ્રીક',
 			'Gujr' => 'ગુજરાતી',
 			'Guru' => 'ગુરૂમુખી',
 			'Hang' => 'હંગુલ',
 			'Hani' => 'હાન',
 			'Hano' => 'હનુનૂ',
 			'Hans' => 'સરળીકૃત',
 			'Hans@alt=stand-alone' => 'સરળીકૃત હેન',
 			'Hant' => 'પરંપરાગત',
 			'Hant@alt=stand-alone' => 'પરંપરાગત હાન',
 			'Hebr' => 'હીબ્રુ',
 			'Hira' => 'હિરાગાના',
 			'Hmng' => 'પહાઉ મોન્ગ',
 			'Hrkt' => 'કતાકના અને હિરાગના',
 			'Hung' => 'ઓલ્ડ હંગેરિયન',
 			'Inds' => 'સિન્ધુ',
 			'Ital' => 'જૂનુ ઇટાલિક',
 			'Java' => 'જાવાનીસ',
 			'Jpan' => 'જાપાની',
 			'Kali' => 'કાયાહ લી',
 			'Kana' => 'કટાકાના',
 			'Khar' => 'ખારોશ્થી',
 			'Khmr' => 'ખ્મેર',
 			'Knda' => 'કન્નડા',
 			'Kore' => 'કોરિયન',
 			'Kthi' => 'કૈથી',
 			'Lana' => 'લાના',
 			'Laoo' => 'લાઓ',
 			'Latf' => 'ફ્રેકતુર લેટિન',
 			'Latg' => 'ગૈલિક લેટિન',
 			'Latn' => 'લેટિન',
 			'Lepc' => 'લેપચા',
 			'Limb' => 'લિમ્બૂ',
 			'Lina' => 'લીનિયર અ',
 			'Linb' => 'લીનિયર બી',
 			'Lyci' => 'લિશિયન',
 			'Lydi' => 'લિડિયન',
 			'Mand' => 'માન્ડાયીન',
 			'Mani' => 'માનીચાયીન',
 			'Maya' => 'મયાન હાઇરોગ્લિફ્સ',
 			'Mero' => 'મેરોઇટિક',
 			'Mlym' => 'મલયાલમ',
 			'Mong' => 'મોંગોલિયન',
 			'Moon' => 'મૂન',
 			'Mtei' => 'મેઇતેઇ માયેક',
 			'Mymr' => 'મ્યાંમાર',
 			'Nkoo' => 'એન\' કો',
 			'Ogam' => 'ઓઘામ',
 			'Olck' => 'ઓલ ચિકી',
 			'Orkh' => 'ઓરખોન',
 			'Orya' => 'ઉડિયા',
 			'Osma' => 'ઓસ્માન્યા',
 			'Perm' => 'ઓલ્ડ પરમિક',
 			'Phag' => 'ફાગ્સ-પા',
 			'Phli' => 'ઇન્સ્ક્રિપ્શનલ પહલવી',
 			'Phlp' => 'સાલટર પહલવી',
 			'Phlv' => 'બુક પહલવી',
 			'Phnx' => 'ફોનિશિયન',
 			'Plrd' => 'પોલાર્ડ ફોનેટિક',
 			'Prti' => 'ઇન્સ્ક્રિપ્શનલ પાર્થિયન',
 			'Rjng' => 'રીજાંગ',
 			'Roro' => 'રોંગોરોંગો',
 			'Runr' => 'રૂનિક',
 			'Samr' => 'સમરિટાન',
 			'Sara' => 'સરાતી',
 			'Saur' => 'સૌરાષ્ટ્ર',
 			'Sgnw' => 'સંકેત લિપી',
 			'Shaw' => 'શાવિયાન',
 			'Sinh' => 'સિંહલી',
 			'Sund' => 'સુદાનીઝ',
 			'Sylo' => 'સિલોતી નાગરી',
 			'Syrc' => 'સિરિયેક',
 			'Syre' => 'એસ્ત્રેન્જેલો સિરિયાક',
 			'Syrj' => 'પશ્ચિમ સિરિયાક',
 			'Syrn' => 'પૂર્વ સિરિયાક',
 			'Tagb' => 'તગબન્વા',
 			'Tale' => 'તાઇ લી',
 			'Talu' => 'નવીન તાઇ લૂ',
 			'Taml' => 'તમિલ',
 			'Tavt' => 'તાઇ વેઇત',
 			'Telu' => 'તેલુગુ',
 			'Teng' => 'તેન્ગવાર',
 			'Tfng' => 'તિફિનાઘ',
 			'Tglg' => 'ટેગાલોગ',
 			'Thaa' => 'થાના',
 			'Thai' => 'થાઇ',
 			'Tibt' => 'ટિબેટી',
 			'Ugar' => 'યુગાતિટિક',
 			'Vaii' => 'વાઇ',
 			'Visp' => 'વિસિબલ સ્પીચ',
 			'Xpeo' => 'જુની ફારસી',
 			'Xsux' => 'સુમેરો અક્કાદિયન સુનિફોર્મ',
 			'Yiii' => 'યી',
 			'Zinh' => 'વંશાગત',
 			'Zmth' => 'ગણિતીય સંકેતલિપિ',
 			'Zsym' => 'પ્રતીક લિપી',
 			'Zxxx' => 'અલિખિત',
 			'Zyyy' => 'સામાન્ય',
 			'Zzzz' => 'અજ્ઞાત લિપિ',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_territory' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'001' => 'વિશ્વ',
 			'002' => 'આફ્રિકા',
 			'003' => 'ઉતર અમેરિકા',
 			'005' => 'દક્ષિણ અમેરિકા',
 			'009' => 'ઓશિઆનિયા',
 			'011' => 'પશ્ચિમ આફ્રિકા',
 			'013' => 'મધ્ય અમેરિકા',
 			'014' => 'પૂર્વ અમેરિકા',
 			'015' => 'ઉતરીય આફ્રિકા',
 			'017' => 'મધ્ય આફ્રિકા',
 			'018' => 'દક્ષિણી આફ્રિકા',
 			'019' => 'અમેરિકાસ',
 			'021' => 'ઉતરીય અમેરિકા',
 			'029' => 'કેરિબિયન',
 			'030' => 'પૂર્વી એશિયા',
 			'034' => 'દક્ષિણી એશિયા',
 			'035' => 'દક્ષિણ- પૂર્વ એશિયા',
 			'039' => 'દક્ષિણી યૂરોપ',
 			'053' => 'ઓસ્ટ્રેલિયા',
 			'054' => 'મેલાનેશિયા',
 			'057' => 'માઇક્રોનેશિયન રીજન',
 			'061' => 'પોલિનેશિયા',
 			'142' => 'એશિયા',
 			'143' => 'મધ્ય એશિયા',
 			'145' => 'પશ્ચિમ એશિયા',
 			'150' => 'યૂરોપ',
 			'151' => 'પૂર્વી યૂરોપ',
 			'154' => 'ઉતરીય યૂરોપ',
 			'155' => 'પશ્ચિમ યૂરોપ',
 			'419' => 'લેટિન અમેરિકા',
 			'AC' => 'એસેન્શન આઇલેન્ડ',
 			'AD' => 'ઍંડોરા',
 			'AE' => 'યુનાઇટેડ અરબ એમિરેટ્સ',
 			'AF' => 'અફઘાનિસ્તાન',
 			'AG' => 'એન્ટીગુઆ અને બરબુડા',
 			'AI' => 'ઍંગ્વિલા',
 			'AL' => 'અલ્બેનિયા',
 			'AM' => 'આર્મેનિયા',
 			'AN' => 'નેધરલેંડ્સ એંટિલેસ',
 			'AO' => 'અંગોલા',
 			'AQ' => 'એન્ટાર્કટિકા',
 			'AR' => 'આર્જેન્ટીના',
 			'AS' => 'અમેરીકન સમોઆ',
 			'AT' => 'ઑસ્ટ્રિયા',
 			'AU' => 'ઑસ્ટ્રેલિયા',
 			'AW' => 'અરુબા',
 			'AX' => 'એલેંડ આઇલેન્ડ્સ',
 			'AZ' => 'અઝરબૈજાન',
 			'BA' => 'બોસ્નિયા અને હર્ઝેગોવિના',
 			'BB' => 'બાર્બાડોસ',
 			'BD' => 'બાંગ્લાદેશ',
 			'BE' => 'બેલ્જીયમ',
 			'BF' => 'બુર્કિના ફાસો',
 			'BG' => 'બલ્ગેરિયા',
 			'BH' => 'બેહરીન',
 			'BI' => 'બુરુંડી',
 			'BJ' => 'બેનિન',
 			'BL' => 'સેંટ બાર્થલેમી',
 			'BM' => 'બર્મુડા',
 			'BN' => 'બ્રુનેઇ',
 			'BO' => 'બોલિવિયા',
 			'BQ' => 'કેરેબિયન નેધરલેન્ડ્ઝ',
 			'BR' => 'બ્રાઝિલ',
 			'BS' => 'બહામાસ',
 			'BT' => 'ભૂટાન',
 			'BV' => 'બૌવેત આઇલેન્ડ',
 			'BW' => 'બોત્સ્વાના',
 			'BY' => 'બેલારુસ',
 			'BZ' => 'બેલીઝ',
 			'CA' => 'કેનેડા',
 			'CC' => 'કોકોઝ આઇલેન્ડ',
 			'CD' => 'કોંગો - કિંશાસા',
 			'CD@alt=variant' => 'કોંગો (ડીઆરસી)',
 			'CF' => 'સેંટ્રલ આફ્રિકન રીપબ્લિક',
 			'CG' => 'કોંગો - બ્રાઝાવિલે',
 			'CG@alt=variant' => 'કોંગો (પ્રજાસત્તાક)',
 			'CH' => 'સ્વિટ્ઝર્લૅન્ડ',
 			'CI' => 'આઇવરી કોસ્ટ',
 			'CK' => 'કુક આઇલેન્ડ્સ',
 			'CL' => 'ચિલી',
 			'CM' => 'કૅમરૂન',
 			'CN' => 'ચીન',
 			'CO' => 'કોલમ્બિયા',
 			'CP' => 'ક્લિપરટન આઇલેન્ડ',
 			'CR' => 'કોસ્ટા રિકા',
 			'CU' => 'ક્યુબા',
 			'CV' => 'કૅપ વર્ડે',
 			'CW' => 'કુરાકાઓ',
 			'CX' => 'ક્રિસમસ આઇલેંડ',
 			'CY' => 'સાયપ્રસ',
 			'CZ' => 'ચેક રીપબ્લિક',
 			'DE' => 'જર્મની',
 			'DG' => 'ડિએગો ગારસિઆ',
 			'DJ' => 'જીબૌટી',
 			'DK' => 'ડેનમાર્ક',
 			'DM' => 'ડોમિનિકા',
 			'DO' => 'ડોમિનિકન રીપબ્લિક',
 			'DZ' => 'અલ્જીરિયા',
 			'EA' => 'સ્યુટા અને મેલિલા',
 			'EC' => 'એક્વાડોર',
 			'EE' => 'એસ્ટોનિયા',
 			'EG' => 'ઇજિપ્ત',
 			'EH' => 'પશ્ચિમી સહારા',
 			'ER' => 'એરિટ્રિયા',
 			'ES' => 'સ્પેન',
 			'ET' => 'ઇથિઓપિયા',
 			'EU' => 'યુરોપિયન સંઘ',
 			'FI' => 'ફીનલેંડ',
 			'FJ' => 'ફીજી',
 			'FK' => 'ફૉકલૅંડ આઇલૅંડ્સ',
 			'FK@alt=variant' => 'ફૉકલેન્ડ આઇલેન્ડ્સ',
 			'FM' => 'માઇક્રોનેશિયા',
 			'FO' => 'ફૅરો આઇલેન્ડ્સ',
 			'FR' => 'ફ્રાંસ',
 			'GA' => 'ગેબન',
 			'GB' => 'યુનાઇટેડ કિંગડમ',
 			'GB@alt=short' => 'યુ.કે.',
 			'GD' => 'ગ્રેનેડા',
 			'GE' => 'જ્યોર્જીયા',
 			'GF' => 'ફ્રેંચ ગયાના',
 			'GG' => 'ગ્વેર્નસે',
 			'GH' => 'ઘાના',
 			'GI' => 'જીબ્રાલ્ટર',
 			'GL' => 'ગ્રીનલેન્ડ',
 			'GM' => 'ગેમ્બિયા',
 			'GN' => 'ગિની',
 			'GP' => 'ગ્વાડેલોપ',
 			'GQ' => 'ઇક્વેટોરિયલ ગિની',
 			'GR' => 'ગ્રીસ',
 			'GS' => 'દક્ષિણ જ્યોર્જીયા અને દક્ષિણ સેન્ડવિચ આઇલેન્ડ',
 			'GT' => 'ગ્વાટેમાલા',
 			'GU' => 'ગ્વામ',
 			'GW' => 'ગિની-બિસાઉ',
 			'GY' => 'ગયાના',
 			'HK' => 'હોંગકોંગ સાર ચીન',
 			'HK@alt=short' => 'હોંગ કોંગ',
 			'HM' => 'હર્ડ આઇલૅંડ એંડ મેકડોનાલ્ડ આઇલૅંડ્સ',
 			'HN' => 'હોન્ડુરસ',
 			'HR' => 'ક્રોએશિયા',
 			'HT' => 'હૈતિ',
 			'HU' => 'હંગેરી',
 			'IC' => 'કૅનેરી આઇલેન્ડ્સ',
 			'ID' => 'ઇન્ડોનેશિયા',
 			'IE' => 'આયર્લેંડ',
 			'IL' => 'ઇઝરાઇલ',
 			'IM' => 'ઇસ્લે ઓફ મૅન',
 			'IN' => 'ભારત',
 			'IO' => 'બ્રિટિશ ઇન્ડિયન ઓશન ટેરિટરી',
 			'IQ' => 'ઇરાક',
 			'IR' => 'ઈરાન',
 			'IS' => 'આઇસલેન્ડ',
 			'IT' => 'ઇટાલી',
 			'JE' => 'જર્સી',
 			'JM' => 'જમૈકા',
 			'JO' => 'જોર્ડન',
 			'JP' => 'જાપાન',
 			'KE' => 'કેન્યા',
 			'KG' => 'કિર્ગિઝ્સ્તાન',
 			'KH' => 'કંબોડિયા',
 			'KI' => 'કિરિબાટી',
 			'KM' => 'કોમોરસ',
 			'KN' => 'સેંટ કિટ્સ એંડ નેવિસ',
 			'KP' => 'ઉત્તર કોરિયા',
 			'KR' => 'દક્ષિણ કોરિયા',
 			'KW' => 'કુવૈત',
 			'KY' => 'કેયમેન આઇલૅંડ્સ',
 			'KZ' => 'કઝાકિસ્તાન',
 			'LA' => 'લાઓસ',
 			'LB' => 'લેબનોન',
 			'LC' => 'સેંટ લુસિયા',
 			'LI' => 'લૈચટેંસ્ટેઇન',
 			'LK' => 'શ્રીલંકા',
 			'LR' => 'લાઇબેરિયા',
 			'LS' => 'લેસોથો',
 			'LT' => 'લિથુઆનિયા',
 			'LU' => 'લક્ઝમબર્ગ',
 			'LV' => 'લાત્વિયા',
 			'LY' => 'લિબિયા',
 			'MA' => 'મોરોક્કો',
 			'MC' => 'મોનાકો',
 			'MD' => 'મોલડોવા',
 			'ME' => 'મૉન્ટેંનેગ્રો',
 			'MF' => 'સેંટ માર્ટિન',
 			'MG' => 'મેડાગાસ્કર',
 			'MH' => 'માર્શલ આઇલેન્ડ્સ',
 			'MK' => 'મેસેડોનિયા',
 			'MK@alt=variant' => 'મેસેડોનિયા (FYROM)',
 			'ML' => 'માલી',
 			'MM' => 'મ્યાંમાર',
 			'MN' => 'મંગોલિયા',
 			'MO' => 'મકાઉ SAR ચીન',
 			'MO@alt=short' => 'મકાઓ',
 			'MP' => 'ઉતરીય મારિયાના આઇલેન્ડ્સ',
 			'MQ' => 'માર્ટીનીક',
 			'MR' => 'મૌરિટાનિયા',
 			'MS' => 'મોંટસેરાત',
 			'MT' => 'માલ્ટા',
 			'MU' => 'મોરિશિયસ',
 			'MV' => 'માલદિવ્સ',
 			'MW' => 'માલાવી',
 			'MX' => 'મેક્સિકો',
 			'MY' => 'મલેશિયા',
 			'MZ' => 'મોઝામ્બિક',
 			'NA' => 'નામિબિયા',
 			'NC' => 'ન્યુ સેલેડોનિયા',
 			'NE' => 'નાઇજર',
 			'NF' => 'નોરફૉક આઇલેન્ડ',
 			'NG' => 'નાઇજીરીયા',
 			'NI' => 'નિકારાગુઆ',
 			'NL' => 'નેધરલેન્ડ',
 			'NO' => 'નૉર્વે',
 			'NP' => 'નેપાળ',
 			'NR' => 'નૌરુ',
 			'NU' => 'નીયુ',
 			'NZ' => 'ન્યુઝીલેન્ડ',
 			'OM' => 'ઓમાન',
 			'PA' => 'પનામા',
 			'PE' => 'પેરુ',
 			'PF' => 'ફ્રેંચ પોલિનેશિયા',
 			'PG' => 'પાપુઆ ન્યૂ ગિની',
 			'PH' => 'ફિલિપિન્સ',
 			'PK' => 'પાકિસ્તાન',
 			'PL' => 'પોલેંડ',
 			'PM' => 'સેંટ પીએરે એન્ડ મિકીલોન',
 			'PN' => 'પીટકૈર્ન',
 			'PR' => 'પ્યુઅર્ટો રિકો',
 			'PS' => 'પેલેસ્ટિનિયન ટેરિટરી',
 			'PS@alt=short' => 'પેલેસ્ટાઇન',
 			'PT' => 'પોર્ટુગલ',
 			'PW' => 'પલાઉ',
 			'PY' => 'પેરાગ્વે',
 			'QA' => 'કતાર',
 			'QO' => 'આઉટલાયિંગ ઓશનિયા',
 			'RE' => 'રીયુનિયન',
 			'RO' => 'રોમાનિયા',
 			'RS' => 'સર્બિયા',
 			'RU' => 'રશિયન ફેડરેશન',
 			'RW' => 'રવાંડા',
 			'SA' => 'સાઉદી અરેબિયા',
 			'SB' => 'સોલોમન આઇલેન્ડ',
 			'SC' => 'શેશેલ્સ',
 			'SD' => 'સુદાન',
 			'SE' => 'સ્વીડન',
 			'SG' => 'સિંગાપુર',
 			'SH' => 'સેંટ હેલેના',
 			'SI' => 'સ્લોવેનિયા',
 			'SJ' => 'સ્વાલબર્ડ એંડ જેન મેયન',
 			'SK' => 'સ્લોવેકિયા',
 			'SL' => 'સીએરા લેઓન',
 			'SM' => 'સૅન મેરિનો',
 			'SN' => 'સેનેગલ',
 			'SO' => 'સોમાલિયા',
 			'SR' => 'સુરીનામ',
 			'SS' => 'દક્ષિણ સુદાન',
 			'ST' => 'સાઓ ટૉમ અને પ્રિંસિપે',
 			'SV' => 'એલ સેલ્વાડોર',
 			'SX' => 'સિંટ માર્ટેન',
 			'SY' => 'સીરિયા',
 			'SZ' => 'સ્વાઝિલેન્ડ',
 			'TA' => 'ટ્રિસ્ટન ડે કુના',
 			'TC' => 'ટર્ક્સ એન્ડ કૈકોસ આઇલેન્ડ્સ',
 			'TD' => 'ચાડ',
 			'TF' => 'ફ્રેંચ સદર્ન ટેરિટરીઝ',
 			'TG' => 'ટોગો',
 			'TH' => 'થાઇલેંડ',
 			'TJ' => 'તાજીકિસ્તાન',
 			'TK' => 'ટોકેલાઉ',
 			'TL' => 'પૂર્વ તિમોર',
 			'TM' => 'તુર્ક્મનિસ્તાન',
 			'TN' => 'ટ્યુનિશિયા',
 			'TO' => 'ટોંગા',
 			'TR' => 'તુર્કસ્તાન',
 			'TT' => 'ત્રિનિડાડ અને ટોબેગો',
 			'TV' => 'તુવાલુ',
 			'TW' => 'તાઇવાન',
 			'TZ' => 'તાંઝાનિયા',
 			'UA' => 'યૂક્રેન',
 			'UG' => 'યુગાંડા',
 			'UM' => 'સંયુક્ત રાજ્ય આઉટલાઇંગ આયલેન્ડ્સ',
 			'US' => 'સંયુકત રાજ્ય/ અમેરિકા',
 			'US@alt=short' => 'યુ.એસ.',
 			'UY' => 'ઉરુગ્વે',
 			'UZ' => 'ઉઝ્બેકિસ્તાન',
 			'VA' => 'વેટિકન',
 			'VC' => 'સેંટ વિંસેંટ એંડ ધ ગ્રેનેડિન્સ',
 			'VE' => 'વેનેઝુએલા',
 			'VG' => 'બ્રિટિશ વર્જિન આઇલેન્ડ',
 			'VI' => 'યુ.એસ વર્જિન આઇલેન્ડ',
 			'VN' => 'વિયેતનામ',
 			'VU' => 'વાનુઆતુ',
 			'WF' => 'વૉલિસ એંડ ફ્યુચુના આઇલેન્ડ્સ',
 			'WS' => 'સમોઆ',
 			'XK' => 'કોસોવો',
 			'YE' => 'યેમેન',
 			'YT' => 'મેયોટ',
 			'ZA' => 'દક્ષિણ આફ્રિકા',
 			'ZM' => 'ઝામ્બિયા',
 			'ZW' => 'ઝિમ્બાબ્વે',
 			'ZZ' => 'અજ્ઞાત પ્રદેશ',

		}
	},
);

has 'display_name_variant' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'PINYIN' => 'પિનયિન રોમનાઇઝેશન',
 			'WADEGILE' => 'વેડ-ગિલ્સ રોમનાઇઝેશન',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'calendar' => 'કેલેન્ડર',
 			'colalternate' => 'પ્રતીકોની સૉર્ટિંગને અવગણો',
 			'colbackwards' => 'વિપરીત એક્સેંટ સૉર્ટિંગ',
 			'colcasefirst' => 'અપરકેસ/લોઅરકેસ ક્રમાંકન',
 			'colcaselevel' => 'કેસ સંવેદી સૉર્ટિંગ',
 			'colhiraganaquaternary' => 'કાના સૉર્ટિંગ',
 			'collation' => 'સૉર્ટ ક્રમ',
 			'colnormalization' => 'સામાન્ય સૉર્ટિંગ',
 			'colnumeric' => 'આંકડાકીય સૉર્ટિંગ',
 			'colstrength' => 'સૉર્ટિંગ શક્તિ',
 			'currency' => 'ચલણ',
 			'numbers' => 'આંકડાઓ',
 			'timezone' => 'સમય ઝોન',
 			'va' => 'લોકેલ વેરિએન્ટ',
 			'variabletop' => 'પ્રતીકો તરીકે સૉર્ટ કરો',
 			'x' => 'ખાનગી-ઉપયોગ',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[Str]]',
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{બુદ્ધિસ્ટ કેલેન્ડર},
 				'chinese' => q{ચાઇનિઝ કેલેન્ડર},
 				'coptic' => q{કોપ્ટિક કેલેન્ડર},
 				'ethiopic' => q{ઇથિઓપિક કેલેન્ડર},
 				'ethiopic-amete-alem' => q{ઇથિઓપિક એમેટ એલેમ કેલેન્ડર},
 				'gregorian' => q{ગ્રેગોરિયન કેલેન્ડર},
 				'hebrew' => q{હિબ્રુ કેલેન્ડર},
 				'indian' => q{ભારતીય રાષ્ટ્રીય કેલેન્ડર},
 				'islamic' => q{ઇસ્લામિક કેલેન્ડર},
 				'islamic-civil' => q{ઇસ્લામિક-નાગરિક કેલેન્ડર},
 				'japanese' => q{જાપાનિઝ કેલેન્ડર},
 				'persian' => q{પર્શિયન કેલેન્ડર},
 				'roc' => q{મિંગુઓ કેલેન્ડર},
 			},
 			'colalternate' => {
 				'non-ignorable' => q{પ્રતીકોને સૉર્ટ કરો},
 				'shifted' => q{પ્રતીકોને અવગણીને સૉર્ટ કરો},
 			},
 			'colbackwards' => {
 				'no' => q{ઉચ્ચારોને સામાન્ય રીતે સૉર્ટ કરો},
 				'yes' => q{ઉચ્ચારોને વિપરીત સૉર્ટ કરો},
 			},
 			'colcasefirst' => {
 				'lower' => q{પ્રથમ લોઅરકેસ સૉર્ટ કરો},
 				'no' => q{સામાન્ય કેસના ક્રમમાં સૉર્ટ કરો},
 				'upper' => q{પ્રથમ અપરકેસ સૉર્ટ કરો},
 			},
 			'colcaselevel' => {
 				'no' => q{કેસ સંવેદીને સૉર્ટ કરો},
 				'yes' => q{કેસ સંવેદી સૉર્ટ કરો},
 			},
 			'colhiraganaquaternary' => {
 				'no' => q{કાનાને અલગ સૉર્ટ કરો},
 				'yes' => q{કાનાને અલગ રીતે સૉર્ટ કરો},
 			},
 			'collation' => {
 				'big5han' => q{પરંપરાગત ચાઇનિઝ સોર્ટ ક્રમબદ્ધ},
 				'dictionary' => q{શબ્દકોશ અનુક્મ},
 				'ducet' => q{ડિફોલ્ટ યુનિકોડ અનુક્મ},
 				'gb2312han' => q{સરળીકૃત ચાઇનીઝ સૉર્ટ ક્રમ - GB2312},
 				'phonebook' => q{ફોનબુક અનુક્મ},
 				'phonetic' => q{ધ્વન્યાત્મક સૉર્ટ ક્રમ},
 				'pinyin' => q{પિનયિન અનુક્મ},
 				'reformed' => q{પૂનર્સ્વરૂપિત અનુક્મ},
 				'search' => q{સામાન્ય-ઉદ્દેશ શોધ},
 				'searchjl' => q{હંગુલ પ્રારંભિક વ્યંજન દ્વારા શોધો},
 				'standard' => q{માનક સૉર્ટ ક્રમ},
 				'stroke' => q{સ્ટ્રોક અનુક્મ},
 				'traditional' => q{પરંપરાગત અનુક્મ},
 				'unihan' => q{રેડિકલ-સ્ટ્રોક},
 			},
 			'colnormalization' => {
 				'no' => q{સામાન્યકૃત વિના સૉર્ટ કરો},
 				'yes' => q{યુનિકોડ સામાન્યકૃતને સૉર્ટ કરો},
 			},
 			'colnumeric' => {
 				'no' => q{અંકોને અલગથી સૉર્ટ કરોવ્યક્તિગત રીતે ક્રમમાં ગોઠવો અંકો},
 				'yes' => q{અંકોને સંખ્યાત્મક રીતે સૉર્ટ કરો},
 			},
 			'colstrength' => {
 				'identical' => q{બધા સૉર્ટ કરો},
 				'primary' => q{ફક્ત આધાર અક્ષરોને સૉર્ટ કરો},
 				'quaternary' => q{ઉચ્ચારો/કેસ/પહોળાઈ/કાના સૉર્ટ કરો},
 				'secondary' => q{ઉચ્ચારો સૉર્ટ કરો},
 				'tertiary' => q{ઉચ્ચારો/કેસ/પહોળાઈ સૉર્ટ કરો},
 			},
 			'numbers' => {
 				'arab' => q{અરેબિક-ભારતીય અંકો},
 				'arabext' => q{વિસ્તૃત અરેબિક-ઇન્ડિક અંકો},
 				'armn' => q{અર્મેનિયન સંખ્યાઓ},
 				'armnlow' => q{અર્મેનિયન નાના અક્ષરની સંખ્યાઓ},
 				'beng' => q{બંગાળી અંકો},
 				'deva' => q{દેવનાગરી},
 				'ethi' => q{ઇથિયોપીક સંખ્યાઓ},
 				'finance' => q{નાણાકીય સંખ્યાઓ},
 				'fullwide' => q{પૂર્ણ પહોળાઈ અંકો},
 				'geor' => q{જ્યોર્જિઅન સંખ્યાઓ},
 				'grek' => q{ગ્રિક સંખ્યાઓ},
 				'greklow' => q{ગ્રિક નાના અક્ષરની સંખ્યાઓ},
 				'gujr' => q{ગુજરાતી અંકો},
 				'guru' => q{ગુરમુખી અંકો},
 				'hanidec' => q{ચાઇનીઝ દશાંશ સંખ્યા},
 				'hans' => q{સરળીકૃત ચાઇનીઝ સંખ્યાઓ},
 				'hansfin' => q{સરળીકૃત ચાઇનીઝ નાણાકિય સંખ્યાઓ},
 				'hant' => q{પરંપરાગત ચાઇનીઝ સંખ્યાઓ},
 				'hantfin' => q{પરંપરાગત ચાઇનીઝ નાણાંકીય સંખ્યાઓ},
 				'hebr' => q{હિબ્રુ સંખ્યાઓ},
 				'jpan' => q{જાપાનીઝ સંખ્યાઓ},
 				'jpanfin' => q{જાપાનીઝ નાણાકિય સંખ્યાઓ},
 				'khmr' => q{ખેમેર અંકો},
 				'knda' => q{કન્નડા અંકો},
 				'laoo' => q{લાઓ અંકો},
 				'latn' => q{પશ્ચિમી અંકો},
 				'mlym' => q{મલયાલમ અંકો},
 				'mong' => q{મોંગોલિયન અંકો},
 				'mymr' => q{મ્યાન્માર અંકો},
 				'native' => q{મૂળ અંકો},
 				'orya' => q{ઓરિયા અંકો},
 				'roman' => q{રોમન સંખ્યાઓ},
 				'romanlow' => q{રોમન નાના અક્ષરની સંખ્યા},
 				'taml' => q{તમિલ સંખ્યાઓ},
 				'tamldec' => q{તમિલ અંકો},
 				'telu' => q{તેલુગુ અંકો},
 				'thai' => q{થાઇ અંકો},
 				'tibt' => q{તિબેટિયન અંકો},
 				'traditional' => q{પરંપરાગત અંકો},
 				'vaii' => q{વાઇ અંકો},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'metric' => q{મેટ્રિક},
 			'UK' => q{યુકે},
 			'US' => q{અમેરિકા},

		}
	},
);

has 'display_name_transform_name' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'bgn' => 'BGN',
 			'numeric' => 'સંખ્યા',
 			'tone' => 'ધ્વની',
 			'ungegn' => 'UNGEGN',
 			'x-accents' => 'સ્વરાઘાતો',
 			'x-fullwidth' => 'પૂર્ણપહોળાઇ',
 			'x-halfwidth' => 'અર્ધપહોળાઈ',
 			'x-jamo' => 'જેમો',
 			'x-pinyin' => 'પીનયીન',
 			'x-publishing' => 'પ્રકાશન',

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'language' => '{0}',
 			'script' => '{0}',
 			'territory' => '{0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{(?^u:[‌‍ ૰])},
			index => ['અ', '{અ\u0A82}', '{અઃ}', 'આ', 'ઇ', 'ઈ', 'ઉ', 'ઊ', 'ઋ', 'ઍ', 'એ', 'ઐ', 'ઑ', 'ઓ', 'ઔ', 'ક', '{ક\u0ACDષ}', 'ખ', 'ગ', 'ઘ', 'ઙ', 'ચ', 'છ', 'જ', '{જ\u0ACDઞ}', 'ઝ', 'ઞ', 'ટ', 'ઠ', 'ડ', 'ઢ', 'ણ', 'ત', '{ત\u0ACDર}', 'થ', 'દ', 'ધ', 'ન', 'પ', 'ફ', 'બ', 'ભ', 'મ', 'ય', 'ર', 'લ', 'વ', 'શ', 'ષ', 'સ', 'હ', 'ળ'],
			main => qr{(?^u:[઼ ૐ ં ઁ ઃ અ આ ઇ ઈ ઉ ઊ ઋ ૠ ઍ એ ઐ ઑ ઓ ઔ ક ખ ગ ઘ ઙ ચ છ જ ઝ ઞ ટ ઠ ડ ઢ ણ ત થ દ ધ ન પ ફ બ ભ મ ય ર લ વ શ ષ સ હ ળ ઽ ા િ ી ુ ૂ ૃ ૄ ૅ ે ૈ ૉ ો ૌ ્])},
			punctuation => qr{(?^u:[\- ‐ – — , ; \: ! ? . … ' ‘ ’ " “ ” ( ) \[ \] § @ * / \& # † ‡ ′ ″])},
		};
	},
);

has 'ellipsis' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub {
		return {
			'final' => '{0}…',
			'initial' => '… {0}',
			'medial' => '{0} … {1}',
			'word-final' => '{0} …',
			'word-initial' => '… {0}',
			'word-medial' => '{0} … {1}',
		};
	},
);

has 'more_information' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{?},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{“},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{”},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{‘},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{’},
);

has 'duration_units' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { {
				hm => 'h:mm',
				hms => 'h:mm:ss',
				ms => 'm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[HashRef[Str]]]',
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					'acre' => {
						'one' => q({0} એકર),
						'other' => q({0} એકર),
					},
					'arc-minute' => {
						'one' => q({0} માઇન્યૂટ),
						'other' => q({0} માઇન્યૂટ),
					},
					'arc-second' => {
						'one' => q({0} સેકન્ડ),
						'other' => q({0} સેકન્ડ),
					},
					'celsius' => {
						'one' => q({0} ડિગ્રી સેલ્સિયસ),
						'other' => q({0} ડિગ્રી સેલ્સિયસ),
					},
					'centimeter' => {
						'one' => q({0} સેન્ટિમીટર),
						'other' => q({0} સેન્ટિમીટર),
					},
					'cubic-kilometer' => {
						'one' => q({0} ઘન કિલોમીટર),
						'other' => q({0} ઘન કિલોમીટર),
					},
					'cubic-mile' => {
						'one' => q({0} ઘન માઇલ),
						'other' => q({0} ઘન માઇલ),
					},
					'day' => {
						'one' => q({0} દિવસ),
						'other' => q({0} દિવસ),
					},
					'degree' => {
						'one' => q({0} અંશ),
						'other' => q({0} અંશ),
					},
					'fahrenheit' => {
						'one' => q({0} ડિગ્રી ફેરનહીટ),
						'other' => q({0} ડિગ્રી ફેરનહીટ),
					},
					'foot' => {
						'one' => q({0} ફૂટ),
						'other' => q({0} ફિટ),
					},
					'g-force' => {
						'one' => q({0} g-બળ),
						'other' => q({0} g-બળ),
					},
					'gram' => {
						'one' => q({0} ગ્રામ),
						'other' => q({0} ગ્રામ),
					},
					'hectare' => {
						'one' => q({0} હેક્ટર),
						'other' => q({0} હેક્ટર),
					},
					'hectopascal' => {
						'one' => q({0} હેક્ટૉપાસ્કલ),
						'other' => q({0} હેક્ટૉપાસ્કલ),
					},
					'horsepower' => {
						'one' => q({0} હોર્સપાવર),
						'other' => q({0} હોર્સપાવર),
					},
					'hour' => {
						'one' => q({0} કલાક),
						'other' => q({0} કલાક),
					},
					'inch' => {
						'one' => q({0} ઇંચ),
						'other' => q({0} ઇંચ),
					},
					'inch-hg' => {
						'one' => q({0} પારાના ઇંચ),
						'other' => q({0} પારાના ઇંચ),
					},
					'kilogram' => {
						'one' => q({0} કિલોગ્રામ),
						'other' => q({0} કિલોગ્રામ),
					},
					'kilometer' => {
						'one' => q({0} કિલોમીટર),
						'other' => q({0} કિલોમીટર),
					},
					'kilometer-per-hour' => {
						'one' => q({0} કિલોમીટર પ્રતિ કલાક),
						'other' => q({0} કિલોમીટર પ્રતિ કલાક),
					},
					'kilowatt' => {
						'one' => q({0} કિલોવૉટ),
						'other' => q({0} કિલોવૉટ),
					},
					'light-year' => {
						'one' => q({0} પ્રકાશ વર્ષ),
						'other' => q({0} પ્રકાશ વર્ષ),
					},
					'liter' => {
						'one' => q({0} લિટર),
						'other' => q({0} લિટર),
					},
					'meter' => {
						'one' => q({0} મીટર),
						'other' => q({0} મીટર),
					},
					'meter-per-second' => {
						'one' => q({0} મીટર પ્રતિ સેકન્ડ),
						'other' => q({0} મીટર પ્રતિ સેકન્ડ),
					},
					'mile' => {
						'one' => q({0} માઇલ),
						'other' => q({0} માઇલ),
					},
					'mile-per-hour' => {
						'one' => q({0} માઇલ પ્રતિ કલાક),
						'other' => q({0} માઇલ પ્રતિ કલાક),
					},
					'millibar' => {
						'one' => q({0} મિલીબાર),
						'other' => q({0} મિલીબાર),
					},
					'millimeter' => {
						'one' => q({0} મિલિમીટર),
						'other' => q({0} મિલિમીટર),
					},
					'millisecond' => {
						'one' => q({0} મિલિસેકન્ડ),
						'other' => q({0} મિલિસેકન્ડ્સ),
					},
					'minute' => {
						'one' => q({0} મિનિટ),
						'other' => q({0} મિનિટ),
					},
					'month' => {
						'one' => q({0} મહિનો),
						'other' => q({0} મહિના),
					},
					'ounce' => {
						'one' => q({0} ઔંશ),
						'other' => q({0} ઔંશ),
					},
					'per' => {
						'' => q({0} પ્રતિ {1}),
					},
					'picometer' => {
						'one' => q({0} પિસૉમિટર),
						'other' => q({0} પિસૉમિટર),
					},
					'pound' => {
						'one' => q({0} પાઉન્ડ),
						'other' => q({0} પાઉન્ડ),
					},
					'second' => {
						'one' => q({0} સેકંડ),
						'other' => q({0} સેકંડ),
					},
					'square-foot' => {
						'one' => q({0} ચોરસ ફૂટ),
						'other' => q({0} ચોરસ ફૂટ),
					},
					'square-kilometer' => {
						'one' => q({0} ચોરસ કિલોમીટર),
						'other' => q({0} ચોરસ કિલોમીટર),
					},
					'square-meter' => {
						'one' => q({0} ચોરસ મીટર),
						'other' => q({0} ચોરસ મીટર),
					},
					'square-mile' => {
						'one' => q({0} ચોરસ માઇલ),
						'other' => q({0} ચોરસ માઇલ),
					},
					'watt' => {
						'one' => q({0} વૉટ),
						'other' => q({0} વૉટ),
					},
					'week' => {
						'one' => q({0} અઠવાડિયું),
						'other' => q({0} અઠવાડિયા),
					},
					'yard' => {
						'one' => q({0} વાર),
						'other' => q({0} વાર),
					},
					'year' => {
						'one' => q({0} વર્ષ),
						'other' => q({0} વર્ષ),
					},
				},
				'narrow' => {
					'acre' => {
						'one' => q({0} ac),
						'other' => q({0} ac),
					},
					'arc-minute' => {
						'one' => q({0}′),
						'other' => q({0}′),
					},
					'arc-second' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					'celsius' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'centimeter' => {
						'one' => q({0} સેમી),
						'other' => q({0} સેમી),
					},
					'cubic-kilometer' => {
						'one' => q({0} km³),
						'other' => q({0} km³),
					},
					'cubic-mile' => {
						'one' => q({0} mi³),
						'other' => q({0} mi³),
					},
					'day' => {
						'one' => q({0} દિવસ),
						'other' => q({0} દિવસ),
					},
					'degree' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'fahrenheit' => {
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					'foot' => {
						'one' => q({0} '),
						'other' => q({0} '),
					},
					'g-force' => {
						'one' => q({0} G),
						'other' => q({0} G),
					},
					'gram' => {
						'one' => q({0} ગ્રા),
						'other' => q({0} ગ્રા),
					},
					'hectare' => {
						'one' => q({0} ha),
						'other' => q({0} ha),
					},
					'hectopascal' => {
						'one' => q({0} hPa),
						'other' => q({0} hPa),
					},
					'horsepower' => {
						'one' => q({0} hp),
						'other' => q({0} hp),
					},
					'hour' => {
						'one' => q({0} કલાક),
						'other' => q({0} કલાક),
					},
					'inch' => {
						'one' => q({0} "),
						'other' => q({0} "),
					},
					'inch-hg' => {
						'one' => q({0} inHg),
						'other' => q({0} inHg),
					},
					'kilogram' => {
						'one' => q({0} કિગ્રા),
						'other' => q({0} કિગ્રા),
					},
					'kilometer' => {
						'one' => q({0} કિમી),
						'other' => q({0} કિમી),
					},
					'kilometer-per-hour' => {
						'one' => q({0} km/h),
						'other' => q({0} km/h),
					},
					'kilowatt' => {
						'one' => q({0} kW),
						'other' => q({0} kW),
					},
					'light-year' => {
						'one' => q({0}પ્રકાશવર્ષ),
						'other' => q({0}પ્રકાશવર્ષ),
					},
					'liter' => {
						'one' => q({0} l),
						'other' => q({0} l),
					},
					'meter' => {
						'one' => q({0} મી),
						'other' => q({0} મી),
					},
					'meter-per-second' => {
						'one' => q({0} m/s),
						'other' => q({0} m/s),
					},
					'mile' => {
						'one' => q({0} માઇલ),
						'other' => q({0} માઇલ),
					},
					'mile-per-hour' => {
						'one' => q({0} mi/h),
						'other' => q({0} mi/h),
					},
					'millibar' => {
						'one' => q({0}મિલીબાર),
						'other' => q({0}મિલીબાર),
					},
					'millimeter' => {
						'one' => q({0} મિમી),
						'other' => q({0} મિમી),
					},
					'millisecond' => {
						'one' => q({0} મિસે),
						'other' => q({0} મિસે),
					},
					'minute' => {
						'one' => q({0} મિનિટ),
						'other' => q({0} મિનિટ),
					},
					'month' => {
						'one' => q({0} મહિનો),
						'other' => q({0} મહિનો),
					},
					'ounce' => {
						'one' => q({0} ઔંશ),
						'other' => q({0} ઔંશ),
					},
					'per' => {
						'' => q({0}/{1}),
					},
					'picometer' => {
						'one' => q({0}પિસૉ.મી),
						'other' => q({0}પિસૉ.મી),
					},
					'pound' => {
						'one' => q({0} પાઉન્ડ),
						'other' => q({0} પાઉન્ડ),
					},
					'second' => {
						'one' => q({0} સેકંડ),
						'other' => q({0} સેકંડ),
					},
					'square-foot' => {
						'one' => q({0} ft²),
						'other' => q({0} ft²),
					},
					'square-kilometer' => {
						'one' => q({0} km²),
						'other' => q({0} km²),
					},
					'square-meter' => {
						'one' => q({0} m²),
						'other' => q({0} m²),
					},
					'square-mile' => {
						'one' => q({0} mi²),
						'other' => q({0} mi²),
					},
					'watt' => {
						'one' => q({0} W),
						'other' => q({0} W),
					},
					'week' => {
						'one' => q({0} અઠ.),
						'other' => q({0} અઠ.),
					},
					'yard' => {
						'one' => q({0} વાર),
						'other' => q({0} વાર),
					},
					'year' => {
						'one' => q({0} વર્ષ),
						'other' => q({0} વર્ષ),
					},
				},
				'short' => {
					'acre' => {
						'one' => q({0} એકર),
						'other' => q({0} એકર),
					},
					'arc-minute' => {
						'one' => q({0} માઇન્યૂટ),
						'other' => q({0} માઇન્યૂટ),
					},
					'arc-second' => {
						'one' => q({0} સેકન્ડ),
						'other' => q({0} સેકન્ડ),
					},
					'celsius' => {
						'one' => q({0}°C),
						'other' => q({0}°C),
					},
					'centimeter' => {
						'one' => q({0} સેમી),
						'other' => q({0} સેમી),
					},
					'cubic-kilometer' => {
						'one' => q({0} km³),
						'other' => q({0} km³),
					},
					'cubic-mile' => {
						'one' => q({0} ઘન માઇલ),
						'other' => q({0} ઘન માઇલ),
					},
					'day' => {
						'one' => q({0} દિવસ),
						'other' => q({0} દિવસ),
					},
					'degree' => {
						'one' => q({0} અંશ),
						'other' => q({0} અંશ),
					},
					'fahrenheit' => {
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					'foot' => {
						'one' => q({0} ફૂટ),
						'other' => q({0} ફૂટ),
					},
					'g-force' => {
						'one' => q({0} G),
						'other' => q({0} G),
					},
					'gram' => {
						'one' => q({0} ગ્રા),
						'other' => q({0} ગ્રા),
					},
					'hectare' => {
						'one' => q({0} હેક્ટર),
						'other' => q({0} હેક્ટર),
					},
					'hectopascal' => {
						'one' => q({0} hPa),
						'other' => q({0} hPa),
					},
					'horsepower' => {
						'one' => q({0} હોર્સપાવર),
						'other' => q({0} હોર્સપાવર),
					},
					'hour' => {
						'one' => q({0} કલાક),
						'other' => q({0} કલાક),
					},
					'inch' => {
						'one' => q({0} ઇંચ),
						'other' => q({0} ઇંચ),
					},
					'inch-hg' => {
						'one' => q({0} inHg),
						'other' => q({0} inHg),
					},
					'kilogram' => {
						'one' => q({0} કિગ્રા),
						'other' => q({0} કિગ્રા),
					},
					'kilometer' => {
						'one' => q({0} કિમી),
						'other' => q({0} કિમી),
					},
					'kilometer-per-hour' => {
						'one' => q({0} કિમી/કલાક),
						'other' => q({0} કિમી/કલાક),
					},
					'kilowatt' => {
						'one' => q({0} કિલોવૉટ),
						'other' => q({0} કિલોવૉટ),
					},
					'light-year' => {
						'one' => q({0} પ્રકાશ વર્ષ),
						'other' => q({0} પ્રકાશ વર્ષ),
					},
					'liter' => {
						'one' => q({0} લિ),
						'other' => q({0} લિ),
					},
					'meter' => {
						'one' => q({0} મી),
						'other' => q({0} મી),
					},
					'meter-per-second' => {
						'one' => q({0} મીટર/સેકન્ડ),
						'other' => q({0} મીટર/સેકન્ડ),
					},
					'mile' => {
						'one' => q({0} માઇલ),
						'other' => q({0} માઇલ),
					},
					'mile-per-hour' => {
						'one' => q({0} માઇલ/કલાક),
						'other' => q({0} માઇલ/કલાક),
					},
					'millibar' => {
						'one' => q({0} મિલીબાર),
						'other' => q({0} મિલીબાર),
					},
					'millimeter' => {
						'one' => q({0} મિમી),
						'other' => q({0} મિમી),
					},
					'millisecond' => {
						'one' => q({0} મિસે),
						'other' => q({0} મિસે),
					},
					'minute' => {
						'one' => q({0} મિનિટ),
						'other' => q({0} મિનિટ),
					},
					'month' => {
						'one' => q({0} મહિનો),
						'other' => q({0} મહિના),
					},
					'ounce' => {
						'one' => q({0} ઔંશ),
						'other' => q({0} ઔંશ),
					},
					'per' => {
						'' => q({0}/{1}),
					},
					'picometer' => {
						'one' => q({0} પિસૉમિટર),
						'other' => q({0} પિસૉમિટર),
					},
					'pound' => {
						'one' => q({0} પાઉન્ડ),
						'other' => q({0} પાઉન્ડ),
					},
					'second' => {
						'one' => q({0} સેકંડ),
						'other' => q({0} સેકંડ),
					},
					'square-foot' => {
						'one' => q({0} ચોરસ ફૂટ),
						'other' => q({0} ચોરસ ફૂટ),
					},
					'square-kilometer' => {
						'one' => q({0} km²),
						'other' => q({0} km²),
					},
					'square-meter' => {
						'one' => q({0} ચોરસ મીટર),
						'other' => q({0} ચોરસ મીટર),
					},
					'square-mile' => {
						'one' => q({0} ચોરસ માઇલ),
						'other' => q({0} ચોરસ માઇલ),
					},
					'watt' => {
						'one' => q({0} વૉટ),
						'other' => q({0} વૉટ),
					},
					'week' => {
						'one' => q({0} અઠ.),
						'other' => q({0} અઠ.),
					},
					'yard' => {
						'one' => q({0} વાર),
						'other' => q({0} વાર),
					},
					'year' => {
						'one' => q({0} વર્ષ),
						'other' => q({0} વર્ષ),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:હા|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:નહીં|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
				start => q({0}, {1}),
				middle => q({0}, {1}),
				end => q({0}, {1}),
				2 => q({0}, {1}),
		} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> 'latn',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> 'gujr',
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'decimal' => q(.),
			'exponential' => q(E),
			'group' => q(,),
			'infinity' => q(∞),
			'list' => q(;),
			'minusSign' => q(-),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'0' => {
					'default' => '#,##,##0.###',
				},
				'1000' => {
					'one' => '0 હજાર',
					'other' => '0 હજાર',
				},
				'10000' => {
					'one' => '00 હજાર',
					'other' => '00 હજાર',
				},
				'100000' => {
					'one' => '0 લાખ',
					'other' => '0 લાખ',
				},
				'1000000' => {
					'one' => '00 લાખ',
					'other' => '00 લાખ',
				},
				'10000000' => {
					'one' => '0 કરોડ',
					'other' => '0 કરોડ',
				},
				'100000000' => {
					'one' => '00 કરોડ',
					'other' => '00 કરોડ',
				},
				'1000000000' => {
					'one' => '0 અબજ',
					'other' => '0 અબજ',
				},
				'10000000000' => {
					'one' => '00 અબજ',
					'other' => '00 અબજ',
				},
				'100000000000' => {
					'one' => '0 નિખર્વ',
					'other' => '0 નિખર્વ',
				},
				'1000000000000' => {
					'one' => '0 મહાપદ્મ',
					'other' => '0 મહાપદ્મ',
				},
				'10000000000000' => {
					'one' => '0 શંકુ',
					'other' => '0 શંકુ',
				},
				'100000000000000' => {
					'one' => '0 જલધિ',
					'other' => '0 જલધિ',
				},
			},
			'long' => {
				'1000' => {
					'one' => '0 હજાર',
					'other' => '0 હજાર',
				},
				'10000' => {
					'one' => '00 હજાર',
					'other' => '00 હજાર',
				},
				'100000' => {
					'one' => '0 લાખ',
					'other' => '0 લાખ',
				},
				'1000000' => {
					'one' => '00 લાખ',
					'other' => '00 લાખ',
				},
				'10000000' => {
					'one' => '0 કરોડ',
					'other' => '0 કરોડ',
				},
				'100000000' => {
					'one' => '00 કરોડ',
					'other' => '00 કરોડ',
				},
				'1000000000' => {
					'one' => '0 અબજ',
					'other' => '0 અબજ',
				},
				'10000000000' => {
					'one' => '00 અબજ',
					'other' => '00 અબજ',
				},
				'100000000000' => {
					'one' => '0 નિખર્વ',
					'other' => '0 નિખર્વ',
				},
				'1000000000000' => {
					'one' => '0 મહાપદ્મ',
					'other' => '0 મહાપદ્મ',
				},
				'10000000000000' => {
					'one' => '0 શંકુ',
					'other' => '0 શંકુ',
				},
				'100000000000000' => {
					'one' => '0 જલધિ',
					'other' => '0 જલધિ',
				},
			},
			'short' => {
				'1000' => {
					'one' => '0 હજાર',
					'other' => '0 હજાર',
				},
				'10000' => {
					'one' => '00 હજાર',
					'other' => '00 હજાર',
				},
				'100000' => {
					'one' => '0 લાખ',
					'other' => '0 લાખ',
				},
				'1000000' => {
					'one' => '00 લાખ',
					'other' => '00 લાખ',
				},
				'10000000' => {
					'one' => '0 કરોડ',
					'other' => '0 કરોડ',
				},
				'100000000' => {
					'one' => '00 કરોડ',
					'other' => '00 કરોડ',
				},
				'1000000000' => {
					'one' => '0 અબજ',
					'other' => '0 અબજ',
				},
				'10000000000' => {
					'one' => '00 અબજ',
					'other' => '00 અબજ',
				},
				'100000000000' => {
					'one' => '0 નિખર્વ',
					'other' => '0 નિખર્વ',
				},
				'1000000000000' => {
					'one' => '0 મહાપદ્મ',
					'other' => '0 મહાપદ્મ',
				},
				'10000000000000' => {
					'one' => '0 શંકુ',
					'other' => '0 શંકુ',
				},
				'100000000000000' => {
					'one' => '0 જલધિ',
					'other' => '0 જલધિ',
				},
			},
		},
		percentFormat => {
			'default' => {
				'0' => {
					'default' => '#,##,##0%',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'0' => {
					'default' => '#E0',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'negative' => '(¤#,##,##0.00)',
						'positive' => '¤#,##,##0.00',
					},
					'standard' => {
						'negative' => '¤#,##,##0.00',
						'positive' => '¤#,##,##0.00',
					},
				},
			},
		},
} },
);

has 'curriencies' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'AED' => {
			display_name => {
				'currency' => q(યુનાઈટેડ આરબ અમિરાત દિરહામ),
				'one' => q(યુનાઈટેડ આરબ અમિરાત દિરહામ),
				'other' => q(યુનાઈટેડ આરબ અમિરાત દિરહામ),
			},
		},
		'AFN' => {
			display_name => {
				'currency' => q(અફ્ગાન અફ્ગાની),
				'one' => q(અફ્ગાન અફ્ગાની),
				'other' => q(અફ્ગાન અફ્ગાની),
			},
		},
		'ALL' => {
			display_name => {
				'currency' => q(અલ્બેનિયન લેક),
				'one' => q(અલ્બેનિયન લેક),
				'other' => q(અલ્બેનિયન લેક),
			},
		},
		'AMD' => {
			display_name => {
				'currency' => q(અર્મેનિયન ડ્રેમ),
				'one' => q(અર્મેનિયન ડ્રેમ),
				'other' => q(અર્મેનિયન ડ્રેમ),
			},
		},
		'ANG' => {
			display_name => {
				'currency' => q(નેધરલેંડ એંટિલિન ગિલ્ડર),
				'one' => q(નેધરલેંડ એંટિલિન ગિલ્ડર),
				'other' => q(નેધરલેંડ એંટિલિન ગિલ્ડર),
			},
		},
		'AOA' => {
			display_name => {
				'currency' => q(અંગોલિયન ક્વાન્ઝા),
				'one' => q(અંગોલિયન ક્વાન્ઝા),
				'other' => q(અંગોલિયન ક્વાન્ઝા),
			},
		},
		'ARS' => {
			display_name => {
				'currency' => q(અર્જેન્ટીના પેસો),
				'one' => q(અર્જેન્ટીના પેસો),
				'other' => q(અર્જેન્ટીના પેસો),
			},
		},
		'AUD' => {
			symbol => 'A$',
			display_name => {
				'currency' => q(ઑસ્ટ્રેલિયન ડૉલર),
				'one' => q(ઑસ્ટ્રેલિયન ડૉલર),
				'other' => q(ઑસ્ટ્રેલિયન ડૉલર),
			},
		},
		'AWG' => {
			display_name => {
				'currency' => q(અરુબન ફ્લોરિન),
				'one' => q(અરુબન ફ્લોરિન),
				'other' => q(અરુબન ફ્લોરિન),
			},
		},
		'AZN' => {
			display_name => {
				'currency' => q(અઝરબૈજાની મનાત),
				'one' => q(અઝરબૈજાની મનાત),
				'other' => q(અઝરબૈજાની મનાત),
			},
		},
		'BAM' => {
			display_name => {
				'currency' => q(બોસ્નિયા અને હર્ઝેગોવિના રૂપાંતર યોગ્ય માર્ક),
				'one' => q(બોસ્નિયા અને હર્ઝેગોવિના રૂપાંતર યોગ્ય માર્ક),
				'other' => q(બોસ્નિયા અને હર્ઝેગોવિના રૂપાંતર યોગ્ય માર્ક),
			},
		},
		'BBD' => {
			display_name => {
				'currency' => q(બાર્બાડિયન ડોલર),
				'one' => q(બાર્બાડિયન ડોલર),
				'other' => q(બાર્બાડિયન ડોલર),
			},
		},
		'BDT' => {
			display_name => {
				'currency' => q(બાંગલાદેશી ટાકા),
				'one' => q(બાંગલાદેશી ટાકા),
				'other' => q(બાંગલાદેશી ટાકા),
			},
		},
		'BGN' => {
			display_name => {
				'currency' => q(બલ્ગેરીયન લેવ),
				'one' => q(બલ્ગેરીયન લેવ),
				'other' => q(બલ્ગેરીયન લેવ),
			},
		},
		'BHD' => {
			display_name => {
				'currency' => q(બેહરિની દિનાર),
				'one' => q(બેહરિની દિનાર),
				'other' => q(બેહરિની દિનાર),
			},
		},
		'BIF' => {
			display_name => {
				'currency' => q(બુરુન્ડિયન ફ્રેંક),
				'one' => q(બુરુન્ડિયન ફ્રેંક),
				'other' => q(બુરુન્ડિયન ફ્રેંક),
			},
		},
		'BMD' => {
			display_name => {
				'currency' => q(બર્મુડન ડોલર),
				'one' => q(બર્મુડન ડોલર),
				'other' => q(બર્મુડન ડોલર),
			},
		},
		'BND' => {
			display_name => {
				'currency' => q(બ્રુનેઇ ડોલર),
				'one' => q(બ્રુનેઇ ડોલર),
				'other' => q(બ્રુનેઇ ડોલર),
			},
		},
		'BOB' => {
			display_name => {
				'currency' => q(બોલિવિયન બોલિવિયાનો),
				'one' => q(બોલિવિયન બોલિવિયાનો),
				'other' => q(બોલિવિયન બોલિવિયાનો),
			},
		},
		'BRL' => {
			symbol => 'R$',
			display_name => {
				'currency' => q(બ્રાઝિલીયન રિઆલ),
				'one' => q(બ્રાઝિલીયન રિઆલ),
				'other' => q(બ્રાઝિલીયન રિઆલ),
			},
		},
		'BSD' => {
			display_name => {
				'currency' => q(બહામિયન ડોલર),
				'one' => q(બહામિયન ડોલર),
				'other' => q(બહામિયન ડોલર),
			},
		},
		'BTN' => {
			display_name => {
				'currency' => q(ભુતાનિઝ એંગુલ્ત્રમ),
				'one' => q(ભુતાનિઝ એંગુલ્ત્રમ),
				'other' => q(ભુતાનિઝ એંગુલ્ત્રમ),
			},
		},
		'BWP' => {
			display_name => {
				'currency' => q(બોત્સવાનન પુલા),
				'one' => q(બોત્સવાનન પુલા),
				'other' => q(બોત્સવાનન પુલા),
			},
		},
		'BYR' => {
			display_name => {
				'currency' => q(બેલારુશિયન રબલ),
				'one' => q(બેલારુશિયન રબલ),
				'other' => q(બેલારુશિયન રબલ),
			},
		},
		'BZD' => {
			display_name => {
				'currency' => q(બેલિઝ ડોલર),
				'one' => q(બેલિઝ ડોલર),
				'other' => q(બેલિઝ ડોલર),
			},
		},
		'CAD' => {
			symbol => 'CA$',
			display_name => {
				'currency' => q(કેનેડિયન ડૉલર),
				'one' => q(કેનેડિયન ડૉલર),
				'other' => q(કેનેડિયન ડૉલર),
			},
		},
		'CDF' => {
			display_name => {
				'currency' => q(કોંગોલિઝ ફ્રેંક),
				'one' => q(કોંગોલિઝ ફ્રેંક),
				'other' => q(કોંગોલિઝ ફ્રેંક),
			},
		},
		'CHF' => {
			display_name => {
				'currency' => q(સ્વિસ ફ્રેંક),
				'one' => q(સ્વિસ ફ્રેંક),
				'other' => q(સ્વિસ ફ્રેંક),
			},
		},
		'CLP' => {
			display_name => {
				'currency' => q(ચિલિઅન પેસો),
				'one' => q(ચિલિઅન પેસો),
				'other' => q(ચિલિઅન પેસો),
			},
		},
		'CNY' => {
			symbol => 'CN¥',
			display_name => {
				'currency' => q(ચાઇનિઝ યુઆન),
				'one' => q(ચાઇનિઝ યુઆન),
				'other' => q(ચાઇનિઝ યુઆન),
			},
		},
		'COP' => {
			display_name => {
				'currency' => q(કોલમ્બિયન પેસો),
				'one' => q(કોલમ્બિયન પેસો),
				'other' => q(કોલમ્બિયન પેસો),
			},
		},
		'CRC' => {
			display_name => {
				'currency' => q(કોસ્ટા રિકન કોલોન),
				'one' => q(કોસ્ટા રિકન કોલોન),
				'other' => q(કોસ્ટા રિકન કોલોન),
			},
		},
		'CUC' => {
			display_name => {
				'currency' => q(ક્યુબન રૂપાંતર યોગ્ય પેસો),
				'one' => q(ક્યુબન રૂપાંતર યોગ્ય પેસો),
				'other' => q(ક્યુબન રૂપાંતર યોગ્ય પેસો),
			},
		},
		'CUP' => {
			display_name => {
				'currency' => q(ક્યુબન પેસો),
				'one' => q(ક્યુબન પેસો),
				'other' => q(ક્યુબન પેસો),
			},
		},
		'CVE' => {
			display_name => {
				'currency' => q(કેપ વર્દિયન એસ્કુડો),
				'one' => q(કેપ વર્દિયન એસ્કુડો),
				'other' => q(કેપ વર્દિયન એસ્કુડો),
			},
		},
		'CZK' => {
			display_name => {
				'currency' => q(ચેક રીપબ્લિક કોરુના),
				'one' => q(ચેક રીપબ્લિક કોરુના),
				'other' => q(ચેક રીપબ્લિક કોરુના),
			},
		},
		'DJF' => {
			display_name => {
				'currency' => q(જિબુટિયન ફ્રેંક),
				'one' => q(જિબુટિયન ફ્રેંક),
				'other' => q(જિબુટિયન ફ્રેંક),
			},
		},
		'DKK' => {
			display_name => {
				'currency' => q(ડેનિશ ક્રોન),
				'one' => q(ડેનિશ ક્રોન),
				'other' => q(ડેનિશ ક્રોન),
			},
		},
		'DOP' => {
			display_name => {
				'currency' => q(ડોમિનિકન પેસો),
				'one' => q(ડોમિનિકન પેસો),
				'other' => q(ડોમિનિકન પેસો),
			},
		},
		'DZD' => {
			display_name => {
				'currency' => q(અલ્જિરિયન દિનાર),
				'one' => q(અલ્જિરિયન દિનાર),
				'other' => q(અલ્જિરિયન દિનાર),
			},
		},
		'EGP' => {
			display_name => {
				'currency' => q(ઇજિપ્તિયન પાઉન્ડ),
				'one' => q(ઇજિપ્તિયન પાઉન્ડ),
				'other' => q(ઇજિપ્તિયન પાઉન્ડ),
			},
		},
		'ERN' => {
			display_name => {
				'currency' => q(એરિટ્રેયન નક્ફા),
				'one' => q(એરિટ્રેયન નક્ફા),
				'other' => q(એરિટ્રેયન નક્ફા),
			},
		},
		'ETB' => {
			display_name => {
				'currency' => q(ઇથિયોપીયન બિર),
				'one' => q(ઇથિયોપીયન બિર),
				'other' => q(ઇથિયોપીયન બિર),
			},
		},
		'EUR' => {
			symbol => '€',
			display_name => {
				'currency' => q(યુરો),
				'one' => q(યુરો),
				'other' => q(યુરો),
			},
		},
		'FJD' => {
			display_name => {
				'currency' => q(ફિજિઅન ડોલર),
				'one' => q(ફિજિઅન ડોલર),
				'other' => q(ફિજિઅન ડોલર),
			},
		},
		'FKP' => {
			display_name => {
				'currency' => q(ફૉકલેન્ડ આઇલેંડ્સ પાઉન્ડ),
				'one' => q(ફૉકલેન્ડ આઇલેંડ્સ પાઉન્ડ),
				'other' => q(ફૉકલેન્ડ આઇલેંડ્સ પાઉન્ડ),
			},
		},
		'GBP' => {
			symbol => '£',
			display_name => {
				'currency' => q(બ્રિટિશ પાઉન્ડ સ્ટર્લિંગ),
				'one' => q(બ્રિટિશ પાઉન્ડ સ્ટર્લિંગ),
				'other' => q(બ્રિટિશ પાઉન્ડ સ્ટર્લિંગ),
			},
		},
		'GEL' => {
			display_name => {
				'currency' => q(જ્યોર્જિઅન લારી),
				'one' => q(જ્યોર્જિઅન લારી),
				'other' => q(જ્યોર્જિઅન લારી),
			},
		},
		'GHS' => {
			display_name => {
				'currency' => q(ઘાનાઇયન સેડી),
				'one' => q(ઘાનાઇયન સેડી),
				'other' => q(ઘાનાઇયન સેડી),
			},
		},
		'GIP' => {
			display_name => {
				'currency' => q(જીબ્રાલ્ટર પાઉન્ડ),
				'one' => q(જીબ્રાલ્ટર પાઉન્ડ),
				'other' => q(જીબ્રાલ્ટર પાઉન્ડ),
			},
		},
		'GMD' => {
			display_name => {
				'currency' => q(ગેમ્બિયન દલાસી),
				'one' => q(ગેમ્બિયન દલાસી),
				'other' => q(ગેમ્બિયન દલાસી),
			},
		},
		'GNF' => {
			display_name => {
				'currency' => q(ગિનીયન ફ્રેંક),
				'one' => q(ગિનીયન ફ્રેંક),
				'other' => q(ગિનીયન ફ્રેંક),
			},
		},
		'GTQ' => {
			display_name => {
				'currency' => q(ગ્વાટેમાલા કુઇટ્ઝલ),
				'one' => q(ગ્વાટેમાલા કુઇટ્ઝલ),
				'other' => q(ગ્વાટેમાલા કુઇટ્ઝલ),
			},
		},
		'GYD' => {
			display_name => {
				'currency' => q(ગયાનિઝ ડોલર),
				'one' => q(ગયાનિઝ ડોલર),
				'other' => q(ગયાનિઝ ડોલર),
			},
		},
		'HKD' => {
			symbol => 'HK$',
			display_name => {
				'currency' => q(હોંગ કોંગ ડૉલર),
				'one' => q(હોંગ કોંગ ડૉલર),
				'other' => q(હોંગ કોંગ ડૉલર),
			},
		},
		'HNL' => {
			display_name => {
				'currency' => q(હોન્ડ્યુરન લેમ્પિરા),
				'one' => q(હોન્ડ્યુરન લેમ્પિરા),
				'other' => q(હોન્ડ્યુરન લેમ્પિરા),
			},
		},
		'HRK' => {
			display_name => {
				'currency' => q(ક્રોએશિયન ક્યુના),
				'one' => q(ક્રોએશિયન ક્યુના),
				'other' => q(ક્રોએશિયન ક્યુના),
			},
		},
		'HTG' => {
			display_name => {
				'currency' => q(હાઇટિઇન ગોર્ડ),
				'one' => q(હાઇટિઇન ગોર્ડ),
				'other' => q(હાઇટિઇન ગોર્ડ),
			},
		},
		'HUF' => {
			display_name => {
				'currency' => q(હંગેરીયન ફોરિન્ત),
				'one' => q(હંગેરીયન ફોરિન્ત),
				'other' => q(હંગેરીયન ફોરિન્ત),
			},
		},
		'IDR' => {
			display_name => {
				'currency' => q(ઇન્ડોનેશિયન રૂપિયા),
				'one' => q(ઇન્ડોનેશિયન રૂપિયા),
				'other' => q(ઇન્ડોનેશિયન રૂપિયા),
			},
		},
		'ILS' => {
			symbol => '₪',
			display_name => {
				'currency' => q(ઇઝરાયેલી ન્યુ શેકલ),
				'one' => q(ઇઝરાયેલી ન્યુ શેકલ),
				'other' => q(ઇઝરાયેલી ન્યુ શેકલ),
			},
		},
		'INR' => {
			symbol => '₹',
			display_name => {
				'currency' => q(ભારતીય રૂપિયા),
				'one' => q(ભારતીય રૂપિયા),
				'other' => q(ભારતીય રૂપિયા),
			},
		},
		'IQD' => {
			display_name => {
				'currency' => q(ઇરાકી દિનાર),
				'one' => q(ઇરાકી દિનાર),
				'other' => q(ઇરાકી દિનાર),
			},
		},
		'IRR' => {
			display_name => {
				'currency' => q(ઇરાનિયન રિયાલ),
				'one' => q(ઇરાનિયન રિયાલ),
				'other' => q(ઇરાનિયન રિયાલ),
			},
		},
		'ISK' => {
			display_name => {
				'currency' => q(આઇસ્લેંડિક ક્રોના),
			},
		},
		'JMD' => {
			display_name => {
				'currency' => q(જમૈકિયન ડોલર),
				'one' => q(જમૈકિયન ડોલર),
				'other' => q(જમૈકિયન ડોલર),
			},
		},
		'JOD' => {
			display_name => {
				'currency' => q(જોર્ડનિયન દિનાર),
				'one' => q(જોર્ડનિયન દિનાર),
				'other' => q(જોર્ડનિયન દિનાર),
			},
		},
		'JPY' => {
			symbol => 'JP¥',
			display_name => {
				'currency' => q(જાપાનીઝ યેન),
				'one' => q(જાપાનીઝ યેન),
				'other' => q(જાપાનીઝ યેન),
			},
		},
		'KES' => {
			display_name => {
				'currency' => q(કેન્યેન શિલિંગ),
				'one' => q(કેન્યેન શિલિંગ),
				'other' => q(કેન્યેન શિલિંગ),
			},
		},
		'KGS' => {
			display_name => {
				'currency' => q(કિર્ગિસ્તાની સોમ),
				'one' => q(કિર્ગિસ્તાની સોમ),
				'other' => q(કિર્ગિસ્તાની સોમ),
			},
		},
		'KHR' => {
			display_name => {
				'currency' => q(કેમ્બોડિયન રીઅલ),
				'one' => q(કેમ્બોડિયન રીઅલ),
				'other' => q(કેમ્બોડિયન રીઅલ),
			},
		},
		'KMF' => {
			display_name => {
				'currency' => q(કોમોરિઅન ફ્રેંક),
				'one' => q(કોમોરિઅન ફ્રેંક),
				'other' => q(કોમોરિઅન ફ્રેંક),
			},
		},
		'KPW' => {
			display_name => {
				'currency' => q(ઉત્તર કોરિયન વન),
				'one' => q(ઉત્તર કોરિયન વન),
				'other' => q(ઉત્તર કોરિયન વન),
			},
		},
		'KRW' => {
			symbol => '₩',
			display_name => {
				'currency' => q(દક્ષિણ કોરિયન વન),
				'one' => q(દક્ષિણ કોરિયન વન),
				'other' => q(દક્ષિણ કોરિયન વન),
			},
		},
		'KWD' => {
			display_name => {
				'currency' => q(કુવૈતી દીનાર),
				'one' => q(કુવૈતી દીનાર),
				'other' => q(કુવૈતી દીનાર),
			},
		},
		'KYD' => {
			display_name => {
				'currency' => q(કેયમેન આઇલેંડ્સ ડોલર),
				'one' => q(કેયમેન આઇલેંડ્સ ડોલર),
				'other' => q(કેયમેન આઇલેંડ્સ ડોલર),
			},
		},
		'KZT' => {
			display_name => {
				'currency' => q(કઝાકિસ્તાની ટેંગ),
				'one' => q(કઝાકિસ્તાની ટેંગ),
				'other' => q(કઝાકિસ્તાની ટેંગ),
			},
		},
		'LAK' => {
			display_name => {
				'currency' => q(લાઓશિયન કિપ),
				'one' => q(લાઓશિયન કિપ),
				'other' => q(લાઓશિયન કિપ),
			},
		},
		'LBP' => {
			display_name => {
				'currency' => q(લેબેનિઝ પાઉન્ડ),
				'one' => q(લેબેનિઝ પાઉન્ડ),
				'other' => q(લેબેનિઝ પાઉન્ડ),
			},
		},
		'LKR' => {
			display_name => {
				'currency' => q(શ્રી લંકન રૂપી),
				'one' => q(શ્રી લંકન રૂપી),
				'other' => q(શ્રી લંકન રૂપી),
			},
		},
		'LRD' => {
			display_name => {
				'currency' => q(લિબેરિયન ડોલર),
				'one' => q(લિબેરિયન ડોલર),
				'other' => q(લિબેરિયન ડોલર),
			},
		},
		'LSL' => {
			display_name => {
				'currency' => q(લેસોથો લોતી),
			},
		},
		'LTL' => {
			display_name => {
				'currency' => q(લિથુએનિયન લિતાસ),
				'one' => q(લિથુએનિયન લિતાસ),
				'other' => q(લિથુએનિયન લિતાસ),
			},
		},
		'LVL' => {
			display_name => {
				'currency' => q(લાતવિયન લેત્સ),
				'one' => q(લાતવિયન લેત્સ),
				'other' => q(લાતવિયન લેત્સ),
			},
		},
		'LYD' => {
			display_name => {
				'currency' => q(લિબ્યન દિનાર),
				'one' => q(લિબ્યન દિનાર),
				'other' => q(લિબ્યન દિનાર),
			},
		},
		'MAD' => {
			display_name => {
				'currency' => q(મોરોક્કન દિરામ),
				'one' => q(મોરોક્કનદિરામ),
				'other' => q(મોરોક્કનદિરામ),
			},
		},
		'MDL' => {
			display_name => {
				'currency' => q(મોલડોવેન લિયુ),
				'one' => q(મોલડોવેન લિયુ),
				'other' => q(મોલડોવેન લિયુ),
			},
		},
		'MGA' => {
			display_name => {
				'currency' => q(માલાગેસી અરીઆરી),
				'one' => q(માલાગેસી અરીઆરી),
				'other' => q(માલાગેસી અરીઆરી),
			},
		},
		'MKD' => {
			display_name => {
				'currency' => q(મેસેડોનિયન દિનાર),
				'one' => q(મેસેડોનિયન દિનાર),
				'other' => q(મેસેડોનિયન દિનાર),
			},
		},
		'MMK' => {
			display_name => {
				'currency' => q(મયાન્મા ક્યાત),
				'one' => q(મયાન્મા ક્યાત),
				'other' => q(મયાન્મા ક્યાત),
			},
		},
		'MNT' => {
			display_name => {
				'currency' => q(મોંગોલિયન ટગરિક),
				'one' => q(મોંગોલિયન ટગરિક),
				'other' => q(મોંગોલિયન ટગરિક),
			},
		},
		'MOP' => {
			display_name => {
				'currency' => q(માકાનિઝ પતાકા),
				'one' => q(માકાનિઝ પતાકા),
				'other' => q(માકાનિઝ પતાકા),
			},
		},
		'MRO' => {
			display_name => {
				'currency' => q(મોરીશેનિયન ઓગુયા),
				'one' => q(મોરીશેનિયન ઓગુયા),
				'other' => q(મોરીશેનિયન ઓગુયા),
			},
		},
		'MUR' => {
			display_name => {
				'currency' => q(મોરેશીઅન રૂપી),
				'one' => q(મોરેશીઅન રૂપી),
				'other' => q(મોરેશીઅન રૂપી),
			},
		},
		'MVR' => {
			display_name => {
				'currency' => q(માલ્દિવિયન રુફિયા),
				'one' => q(માલ્દિવિયન રુફિયા),
				'other' => q(માલ્દિવિયન રુફિયા),
			},
		},
		'MWK' => {
			display_name => {
				'currency' => q(માલાવિયન ક્વાચા),
				'one' => q(માલાવિયન ક્વાચા),
				'other' => q(માલાવિયન ક્વાચા),
			},
		},
		'MXN' => {
			symbol => 'MX$',
			display_name => {
				'currency' => q(મેક્સિકન પેસો),
				'one' => q(મેક્સિકન પેસો),
				'other' => q(મેક્સિકન પેસો),
			},
		},
		'MYR' => {
			display_name => {
				'currency' => q(મલેશિયન રિંગ્ગેટ),
				'one' => q(મલેશિયન રિંગ્ગેટ),
				'other' => q(મલેશિયન રિંગ્ગેટ),
			},
		},
		'MZN' => {
			display_name => {
				'currency' => q(મોઝામ્બિકન મેટિકલ),
				'one' => q(મોઝામ્બિકન મેટિકલ),
				'other' => q(મોઝામ્બિકન મેટિકલ),
			},
		},
		'NAD' => {
			display_name => {
				'currency' => q(નામિબિયન ડોલર),
				'one' => q(નામિબિયન ડોલર),
				'other' => q(નામિબિયન ડોલર),
			},
		},
		'NGN' => {
			display_name => {
				'currency' => q(નાઇજીરિયન નૈરા),
				'one' => q(નાઇજીરિયન નૈરા),
				'other' => q(નાઇજીરિયન નૈરા),
			},
		},
		'NIO' => {
			display_name => {
				'currency' => q(નિકારાગુઅન કોર્ડોબા),
				'one' => q(નિકારાગુઅન કોર્ડોબા),
				'other' => q(નિકારાગુઅન કોર્ડોબા),
			},
		},
		'NOK' => {
			display_name => {
				'currency' => q(નૉર્વેજિયન ક્રોન),
				'one' => q(નૉર્વેજિયન ક્રોન),
				'other' => q(નૉર્વેજિયન ક્રોન),
			},
		},
		'NPR' => {
			display_name => {
				'currency' => q(નેપાલિઝ રૂપી),
				'one' => q(નેપાલિઝ રૂપી),
				'other' => q(નેપાલિઝ રૂપી),
			},
		},
		'NZD' => {
			symbol => 'NZ$',
			display_name => {
				'currency' => q(ન્યૂઝિલેંડ ડૉલર),
				'one' => q(ન્યૂઝિલેંડ ડૉલર),
				'other' => q(ન્યૂઝિલેંડ ડૉલર),
			},
		},
		'OMR' => {
			display_name => {
				'currency' => q(ઓમાની રિયાલ),
				'one' => q(ઓમાની રિયાલ),
				'other' => q(ઓમાની રિયાલ),
			},
		},
		'PAB' => {
			display_name => {
				'currency' => q(પનામેનિયન બાલ્બોઆ),
				'one' => q(પનામેનિયન બાલ્બોઆ),
				'other' => q(પનામેનિયન બાલ્બોઆ),
			},
		},
		'PEN' => {
			display_name => {
				'currency' => q(પેરુવિયન ન્યુવો સોલ),
				'one' => q(પેરુવિયન ન્યુવો સોલ),
				'other' => q(પેરુવિયન ન્યુવો સોલ),
			},
		},
		'PGK' => {
			display_name => {
				'currency' => q(પાપુઆ ન્યૂ ગિનીયન કિના),
				'one' => q(પાપુઆ ન્યૂ ગિનીયન કિના),
				'other' => q(પાપુઆ ન્યૂ ગિનીયન કિના),
			},
		},
		'PHP' => {
			display_name => {
				'currency' => q(ફિલીપાઇન પેસો),
				'one' => q(ફિલીપાઇન પેસો),
				'other' => q(ફિલીપાઇન પેસો),
			},
		},
		'PKR' => {
			display_name => {
				'currency' => q(પાકિસ્તાની રૂપી),
				'one' => q(પાકિસ્તાની રૂપી),
				'other' => q(પાકિસ્તાની રૂપી),
			},
		},
		'PLN' => {
			display_name => {
				'currency' => q(પોલિસ ઝ્લોટી),
				'one' => q(પોલિસ ઝ્લોટી),
				'other' => q(પોલિસ ઝ્લોટી),
			},
		},
		'PYG' => {
			display_name => {
				'currency' => q(પરાગ્વેયન ગૌરાની),
				'one' => q(પરાગ્વેયન ગૌરાની),
				'other' => q(પરાગ્વેયન ગૌરાની),
			},
		},
		'QAR' => {
			display_name => {
				'currency' => q(કતારી રિયાલ),
				'one' => q(કતારી રિયાલ),
				'other' => q(કતારી રિયાલ),
			},
		},
		'RON' => {
			display_name => {
				'currency' => q(રોમાનિયન લેઉ),
				'one' => q(રોમાનિયન લેઉ),
				'other' => q(રોમાનિયન લેઉ),
			},
		},
		'RSD' => {
			display_name => {
				'currency' => q(સર્બિયન દિનાર),
				'one' => q(સર્બિયન દિનાર),
				'other' => q(સર્બિયન દિનાર),
			},
		},
		'RUB' => {
			display_name => {
				'currency' => q(રશિયન રબલ),
				'one' => q(રશિયન રબલ),
				'other' => q(રશિયન રબલ),
			},
		},
		'RWF' => {
			display_name => {
				'currency' => q(રવાંડન ફ્રેંક),
				'one' => q(રવાંડન ફ્રેંક),
				'other' => q(રવાંડન ફ્રેંક),
			},
		},
		'SAR' => {
			display_name => {
				'currency' => q(સાઉદી રિયાલ),
				'one' => q(સાઉદી રિયાલ),
				'other' => q(સાઉદી રિયાલ),
			},
		},
		'SBD' => {
			display_name => {
				'currency' => q(સોલોમન આઇલેંડ્સ ડોલર),
				'one' => q(સોલોમન આઇલેંડ્સ ડોલર),
				'other' => q(સોલોમન આઇલેંડ્સ ડોલર),
			},
		},
		'SCR' => {
			display_name => {
				'currency' => q(સેશેલોઈ રૂપી),
				'one' => q(સેશેલોઈ રૂપી),
				'other' => q(સેશેલોઈ રૂપી),
			},
		},
		'SDG' => {
			display_name => {
				'currency' => q(સુદાનિઝ પાઉન્ડ),
				'one' => q(સુદાનિઝ પાઉન્ડ),
				'other' => q(સુદાનિઝ પાઉન્ડ),
			},
		},
		'SEK' => {
			display_name => {
				'currency' => q(સ્વીડિશ ક્રોના),
				'one' => q(સ્વીડિશ ક્રોના),
				'other' => q(સ્વીડિશ ક્રોના),
			},
		},
		'SGD' => {
			display_name => {
				'currency' => q(સિંગાપુર ડૉલર),
				'one' => q(સિંગાપુર ડૉલર),
				'other' => q(સિંગાપુર ડૉલર),
			},
		},
		'SHP' => {
			display_name => {
				'currency' => q(સેંટ હેલેના પાઉન્ડ),
				'one' => q(સેંટ હેલેના પાઉન્ડ),
				'other' => q(સેંટ હેલેના પાઉન્ડ),
			},
		},
		'SLL' => {
			display_name => {
				'currency' => q(સિએરા લિઓનિઅન લિઓન),
				'one' => q(સિએરા લિઓનિઅન લિઓન),
				'other' => q(સિએરા લિઓનિઅન લિઓન),
			},
		},
		'SOS' => {
			display_name => {
				'currency' => q(સોમાલી શિલિંગ),
				'one' => q(સોમાલી શિલિંગ),
				'other' => q(સોમાલી શિલિંગ),
			},
		},
		'SRD' => {
			display_name => {
				'currency' => q(સૂરીનામિઝ ડોલર),
				'one' => q(સૂરીનામિઝ ડોલર),
				'other' => q(સૂરીનામિઝ ડોલર),
			},
		},
		'SSP' => {
			display_name => {
				'currency' => q(દક્ષિણ સુદાનિઝ પાઉન્ડ),
				'one' => q(દક્ષિણ સુદાનિઝ પાઉન્ડ),
				'other' => q(દક્ષિણ સુદાનિઝ પાઉન્ડ),
			},
		},
		'STD' => {
			display_name => {
				'currency' => q(સાઓ ટૉમ એન્ડ પ્રિંસાઇપ ડોબ્રા),
				'one' => q(સાઓ ટૉમ એન્ડ પ્રિંસાઇપ ડોબ્રા),
				'other' => q(સાઓ ટૉમ એન્ડ પ્રિંસાઇપ ડોબ્રા),
			},
		},
		'SYP' => {
			display_name => {
				'currency' => q(સાઇરિયન પાઉન્ડ),
				'one' => q(સાઇરિયન પાઉન્ડ),
				'other' => q(સાઇરિયન પાઉન્ડ),
			},
		},
		'SZL' => {
			display_name => {
				'currency' => q(સ્વાઝી લિલાન્ગેની),
				'one' => q(સ્વાઝી લિલાન્ગેની),
				'other' => q(સ્વાઝી લિલાન્ગેની),
			},
		},
		'THB' => {
			symbol => '฿',
			display_name => {
				'currency' => q(થાઇ બાહ્ત),
				'one' => q(થાઇ બાહ્ત),
				'other' => q(થાઇ બાહ્ત),
			},
		},
		'TJS' => {
			display_name => {
				'currency' => q(તાજિકિસ્તાની સોમોની),
				'one' => q(તાજિકિસ્તાની સોમોની),
				'other' => q(તાજિકિસ્તાની સોમોની),
			},
		},
		'TMT' => {
			display_name => {
				'currency' => q(તુર્કમેનિસ્તાની મનત),
				'one' => q(તુર્કમેનિસ્તાની મનત),
				'other' => q(તુર્કમેનિસ્તાની મનત),
			},
		},
		'TND' => {
			display_name => {
				'currency' => q(ટ્યુનિશિયન દિનાર),
				'one' => q(ટ્યુનિશિયન દિનાર),
				'other' => q(ટ્યુનિશિયન દિનાર),
			},
		},
		'TOP' => {
			display_name => {
				'currency' => q(ટોંગન પ'અંગા),
				'one' => q(ટોંગન પ'અંગા),
				'other' => q(ટોંગન પ'અંગા),
			},
		},
		'TRY' => {
			display_name => {
				'currency' => q(તુર્કિશ લિરા),
				'one' => q(તુર્કિશ લિરા),
				'other' => q(તુર્કિશ લિરા),
			},
		},
		'TTD' => {
			display_name => {
				'currency' => q(ત્રિનિદાદ અને ટોબેગો ડોલર),
				'one' => q(ત્રિનિદાદ અને ટોબેગો ડોલર),
				'other' => q(ત્રિનિદાદ અને ટોબેગો ડોલર),
			},
		},
		'TWD' => {
			symbol => 'NT$',
			display_name => {
				'currency' => q(ન્યુ તાઇવાન ડૉલર),
				'one' => q(ન્યુ તાઇવાન ડૉલર),
				'other' => q(ન્યુ તાઇવાન ડૉલર),
			},
		},
		'TZS' => {
			display_name => {
				'currency' => q(તાન્ઝાનિયન શિલિંગ),
				'one' => q(તાન્ઝાનિયન શિલિંગ),
				'other' => q(તાન્ઝાનિયન શિલિંગ),
			},
		},
		'UAH' => {
			display_name => {
				'currency' => q(યુક્રેનિયન હ્રિવિનિયા),
				'one' => q(યુક્રેનિયન હ્રિવિનિયા),
				'other' => q(યુક્રેનિયન હ્રિવિનિયા),
			},
		},
		'UGX' => {
			display_name => {
				'currency' => q(યુગાંડન શિલિંગ),
				'one' => q(યુગાંડન શિલિંગ),
				'other' => q(યુગાંડન શિલિંગ),
			},
		},
		'USD' => {
			symbol => 'US$',
			display_name => {
				'currency' => q(યુઍસ ડોલર),
				'one' => q(યુઍસ ડોલર),
				'other' => q(યુઍસ ડોલર),
			},
		},
		'UYU' => {
			display_name => {
				'currency' => q(ઉરુગ્વેયન પેસો),
				'one' => q(ઉરુગ્વેયન પેસો),
				'other' => q(ઉરુગ્વેયન પેસો),
			},
		},
		'UZS' => {
			display_name => {
				'currency' => q(ઉઝ્બેકિસ્તાન સોમ),
				'one' => q(ઉઝ્બેકિસ્તાન સોમ),
				'other' => q(ઉઝ્બેકિસ્તાન સોમ),
			},
		},
		'VEF' => {
			display_name => {
				'currency' => q(વેનેઝ્વીલિયન બોલિવર),
				'one' => q(વેનેઝ્વીલિયન બોલિવર),
				'other' => q(વેનેઝ્વીલિયન બોલિવર),
			},
		},
		'VND' => {
			symbol => '₫',
			display_name => {
				'currency' => q(વિયેતનામીસ ડોંગ),
				'one' => q(વિયેતનામીસ ડોંગ),
				'other' => q(વિયેતનામીસ ડોંગ),
			},
		},
		'VUV' => {
			display_name => {
				'currency' => q(વનૌતુ વાતુ),
				'one' => q(વનૌતુ વાતુ),
				'other' => q(વનૌતુ વાતુ),
			},
		},
		'WST' => {
			display_name => {
				'currency' => q(સમોઅન તાલા),
				'one' => q(સમોઅન તાલા),
				'other' => q(સમોઅન તાલા),
			},
		},
		'XAF' => {
			symbol => 'FCFA',
			display_name => {
				'currency' => q(CFA ફ્રેંક BEAC),
				'one' => q(CFA ફ્રેંક BEAC),
				'other' => q(CFA ફ્રેંક BEAC),
			},
		},
		'XCD' => {
			symbol => 'EC$',
			display_name => {
				'currency' => q(ઇસ્ટ કેરિબિયન ડોલર),
				'one' => q(ઇસ્ટ કેરિબિયન ડોલર),
				'other' => q(ઇસ્ટ કેરિબિયન ડોલર),
			},
		},
		'XOF' => {
			symbol => 'CFA',
			display_name => {
				'currency' => q(CFA ફ્રેંક BCEAO),
				'one' => q(CFA ફ્રેંક BCEAO),
				'other' => q(CFA ફ્રેંક BCEAO),
			},
		},
		'XPF' => {
			symbol => 'CFPF',
			display_name => {
				'currency' => q(CFP ફ્રેંક),
				'one' => q(CFP ફ્રેંક),
				'other' => q(CFP ફ્રેંક),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(અજ્ઞાત ચલણ),
				'one' => q(અજ્ઞાત ચલણ),
				'other' => q(અજ્ઞાત ચલણ),
			},
		},
		'YER' => {
			display_name => {
				'currency' => q(યેમેની રિઆલ),
				'one' => q(યેમેની રિઆલ),
				'other' => q(યેમેની રિઆલ),
			},
		},
		'ZAR' => {
			display_name => {
				'currency' => q(દક્ષિણ આફ્રિકી રેંડ),
				'one' => q(દક્ષિણ આફ્રિકી રેંડ),
				'other' => q(દક્ષિણ આફ્રિકી રેંડ),
			},
		},
		'ZMK' => {
			display_name => {
				'currency' => q(ઝામ્બિયન ક્વાચા \(1968–2012\)),
			},
		},
		'ZMW' => {
			display_name => {
				'currency' => q(ઝામ્બિયન ક્વાચા),
				'one' => q(ઝામ્બિયન ક્વાચા),
				'other' => q(ઝામ્બિયન ક્વાચા),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'જાન્યુ',
							'ફેબ્રુ',
							'માર્ચ',
							'એપ્રિલ',
							'મે',
							'જૂન',
							'જુલાઈ',
							'ઑગસ્ટ',
							'સપ્ટે',
							'ઑક્ટો',
							'નવે',
							'ડિસે'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'જા',
							'ફે',
							'મા',
							'એ',
							'મે',
							'જૂ',
							'જુ',
							'ઑ',
							'સ',
							'ઑ',
							'ન',
							'ડિ'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'જાન્યુઆરી',
							'ફેબ્રુઆરી',
							'માર્ચ',
							'એપ્રિલ',
							'મે',
							'જૂન',
							'જુલાઈ',
							'ઑગસ્ટ',
							'સપ્ટેમ્બર',
							'ઑક્ટોબર',
							'નવેમ્બર',
							'ડિસેમ્બર'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'જાન્યુ',
							'ફેબ્રુ',
							'માર્ચ',
							'એપ્રિલ',
							'મે',
							'જૂન',
							'જુલાઈ',
							'ઑગ',
							'સપ્ટે',
							'ઑક્ટો',
							'નવે',
							'ડિસે'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'જા',
							'ફે',
							'મા',
							'એ',
							'મે',
							'જૂ',
							'જુ',
							'ઑ',
							'સ',
							'ઑ',
							'ન',
							'ડિ'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'જાન્યુઆરી',
							'ફેબ્રુઆરી',
							'માર્ચ',
							'એપ્રિલ',
							'મે',
							'જૂન',
							'જુલાઈ',
							'ઑગસ્ટ',
							'સપ્ટેમ્બર',
							'ઑક્ટોબર',
							'નવેમ્બર',
							'ડિસેમ્બર'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'સોમ',
						tue => 'મંગળ',
						wed => 'બુધ',
						thu => 'ગુરુ',
						fri => 'શુક્ર',
						sat => 'શનિ',
						sun => 'રવિ'
					},
					narrow => {
						mon => 'સો',
						tue => 'મં',
						wed => 'બુ',
						thu => 'ગુ',
						fri => 'શુ',
						sat => 'શ',
						sun => 'ર'
					},
					short => {
						mon => 'સો',
						tue => 'મં',
						wed => 'બુ',
						thu => 'ગુ',
						fri => 'શુ',
						sat => 'શ',
						sun => 'ર'
					},
					wide => {
						mon => 'સોમવાર',
						tue => 'મંગળવાર',
						wed => 'બુધવાર',
						thu => 'ગુરુવાર',
						fri => 'શુક્રવાર',
						sat => 'શનિવાર',
						sun => 'રવિવાર'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'સોમ',
						tue => 'મંગળ',
						wed => 'બુધ',
						thu => 'ગુરુ',
						fri => 'શુક્ર',
						sat => 'શનિ',
						sun => 'રવિ'
					},
					narrow => {
						mon => 'સો',
						tue => 'મં',
						wed => 'બુ',
						thu => 'ગુ',
						fri => 'શુ',
						sat => 'શ',
						sun => 'ર'
					},
					short => {
						mon => 'સો',
						tue => 'મં',
						wed => 'બુ',
						thu => 'ગુ',
						fri => 'શુ',
						sat => 'શ',
						sun => 'ર'
					},
					wide => {
						mon => 'સોમવાર',
						tue => 'મંગળવાર',
						wed => 'બુધવાર',
						thu => 'ગુરુવાર',
						fri => 'શુક્રવાર',
						sat => 'શનિવાર',
						sun => 'રવિવાર'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'Q1',
						1 => 'Q2',
						2 => 'Q3',
						3 => 'Q4'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => 'પહેલો ત્રિમાસ',
						1 => 'બીજો ત્રિમાસ',
						2 => 'ત્રીજો ત્રિમાસ',
						3 => 'ચોથો ત્રિમાસ'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => 'Q1',
						1 => 'Q2',
						2 => 'Q3',
						3 => 'Q4'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => 'પહેલો ત્રિમાસ',
						1 => 'બીજો ત્રિમાસ',
						2 => 'ત્રીજો ત્રિમાસ',
						3 => 'ચોથો ત્રિમાસ'
					},
				},
			},
	} },
);

has 'day_periods' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'wide' => {
					'am' => q{AM},
					'pm' => q{PM},
				},
				'narrow' => {
					'pm' => q{PM},
					'am' => q{AM},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'ઈસુના જન્મ પહેલા',
				'1' => 'ઇસવીસન'
			},
			narrow => {
				'0' => 'ઇ સ પુ',
				'1' => 'ઇસ'
			},
			wide => {
				'0' => 'ઈસવીસન પૂર્વે',
				'1' => 'ઇસવીસન'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{EEEE, d MMMM, G y},
			'long' => q{d MMMM, G y},
			'medium' => q{d MMM, G y},
			'short' => q{d-MM- GGGGG y},
		},
		'gregorian' => {
			'full' => q{EEEE, d MMMM, y},
			'long' => q{d MMMM, y},
			'medium' => q{d MMM, y},
			'short' => q{d-MM-yy},
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			'full' => q{hh:mm:ss a zzzz},
			'long' => q{hh:mm:ss a z},
			'medium' => q{hh:mm:ss a},
			'short' => q{hh:mm a},
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'gregorian' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Ed => q{E d},
			Gy => q{G y},
			GyMMM => q{MMM G y},
			GyMMMEd => q{E, d MMM, G y},
			GyMMMd => q{d, MMM G y},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{E, d/M},
			MMM => q{LLL},
			MMMEd => q{E, d MMM},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			MMdd => q{dd-MM},
			Md => q{d/M},
			d => q{d},
			h => q{h a},
			hm => q{hh:mm a},
			hms => q{hh:mm:ss a},
			ms => q{mm:ss},
			y => q{G y},
			yyyy => q{G y},
			yyyyM => q{M/G y},
			yyyyMEd => q{E, d/M/G y},
			yyyyMM => q{MM-y G},
			yyyyMMM => q{MMM G y},
			yyyyMMMEd => q{E, d MMM, G y},
			yyyyMMMM => q{MMMM G y},
			yyyyMMMd => q{d MMM, G y},
			yyyyMd => q{d/M/G y},
			yyyyQQQ => q{QQQ G y},
			yyyyQQQQ => q{QQQQ G y},
		},
		'gregorian' => {
			EHm => q{HH:mm E},
			EHms => q{HH:mm:ss E},
			Ed => q{E d},
			Ehm => q{h:mm a E},
			Ehms => q{h:mm:ss a E},
			Gy => q{G y},
			GyMMM => q{MMM, G y},
			GyMMMEd => q{E, d MMM, G y},
			GyMMMd => q{d MMM, G y},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{E, d/M},
			MMM => q{LLL},
			MMMEd => q{E, d MMM},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			MMdd => q{dd-MM},
			Md => q{d/M},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{y},
			yM => q{M/y},
			yMEd => q{E, d/M/y},
			yMM => q{MM-y},
			yMMM => q{MMM y},
			yMMMEd => q{E, d MMM, y},
			yMMMM => q{MMMM y},
			yMMMd => q{d MMM, y},
			yMd => q{d/M/y},
			yQQQ => q{y QQQ},
			yQQQQ => q{y QQQQ},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'Timezone' => '{0} {1}',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E,d/M-E,d/M},
				d => q{E, d/M-E, d/M},
			},
			MMM => {
				M => q{MMM–MMM},
			},
			MMMEd => {
				M => q{E, d MMM – E, d MMM},
				d => q{E, d MMM-E, d MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d–d MMM},
			},
			Md => {
				M => q{d/M – d/M},
				d => q{d/M – d/M},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{G y–y},
			},
			yM => {
				M => q{M/y – M/y},
				y => q{M/y – M/y},
			},
			yMEd => {
				M => q{E,d/M/y- E,d/M/y},
				d => q{E,d/M/y- E,d/M/y},
				y => q{E,d/M/y-E,d/M/y},
			},
			yMMM => {
				M => q{MMM–MMM y},
				y => q{MMM y – MMM y},
			},
			yMMMEd => {
				M => q{E,d MMM-E,d MMM G y},
				d => q{E, d MMM-E, d MMM G y},
				y => q{E, d MMM y-E, d MMM G y},
			},
			yMMMM => {
				M => q{MMMM–MMMM G y},
				y => q{MMMM y – MMMM y},
			},
			yMMMd => {
				M => q{d MMM-d MMM y},
				d => q{d-d MMM,y},
				y => q{d MMM,y-d MMM,y},
			},
			yMd => {
				M => q{d/M/y-d/M/y},
				d => q{d/M/y-d/M/y},
				y => q{d/M/y-d/M/y},
			},
		},
		'gregorian' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E,d/M – E,d/M},
				d => q{E, d/M – E, d/M},
			},
			MMM => {
				M => q{MMM–MMM},
			},
			MMMEd => {
				M => q{E, d MMM – E, d MMM},
				d => q{E, d MMM – E, d MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d–d MMM},
			},
			Md => {
				M => q{d/M – d/M},
				d => q{d/M – d/M},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y–y},
			},
			yM => {
				M => q{M/y – M/y},
				y => q{M/y – M/y},
			},
			yMEd => {
				M => q{E, d/M/y – E, d/M/y},
				d => q{E, d/M/y – E, d/M/y},
				y => q{E, d/M/y – E, d/M/y},
			},
			yMMM => {
				M => q{MMM–MMM y},
				y => q{MMM y – MMM y},
			},
			yMMMEd => {
				M => q{E, d MMM – E, d MMM, y},
				d => q{E, d MMM – E, d MMM, y},
				y => q{E, d MMM, y – E, d MMM, y},
			},
			yMMMM => {
				M => q{MMMM – MMMM y},
				y => q{MMMM y – MMMM y},
			},
			yMMMd => {
				M => q{d MMM – d MMM, y},
				d => q{d–d MMM, y},
				y => q{d MMM, y – d MMM, y},
			},
			yMd => {
				M => q{d/M/y – d/M/y},
				d => q{d/M/y – d/M/y},
				y => q{d/M/y – d/M/y},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HH:mm;-HH:mm),
		gmtFormat => q(GMT{0}),
		gmtZeroFormat => q(GMT),
		regionFormat => q({0} સમય),
		regionFormat => q({0} (+1)),
		regionFormat => q({0} (+0)),
		fallbackFormat => q({1} ({0})),
		'Acre' => {
			long => {
				'daylight' => q(એકર ગ્રીષ્મ સમય),
				'generic' => q(એકર સમય),
				'standard' => q(એકર પ્રમાણભૂત સમય),
			},
		},
		'Afghanistan' => {
			long => {
				'standard' => q(અફઘાનિસ્તાન સમય),
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#આબિદ્જાન#,
		},
		'Africa/Accra' => {
			exemplarCity => q#ઍકરા#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#એડિસ અબાબા#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#અલ્જીયર્સ#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#અસ્મારા#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#બમેકો#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#બાંગુઈ#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#બાંજુલ#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#બિસાઉ#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#બ્લેંટીર#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#બ્રાઝાવિલે#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#બુજમ્બુરા#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#કૈરો#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#કાસાબ્લાંકા#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#ક્વેટા#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#કોનૅક્રી#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#ડકાર#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#દાર એસ સલામ#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#જીબુટી#,
		},
		'Africa/Douala' => {
			exemplarCity => q#ડૌઆલા#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#એલ ઐઉન#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#ફ્રીટાઉન#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#ગૅબોરોન#,
		},
		'Africa/Harare' => {
			exemplarCity => q#હરારે#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#જોહાન્સબર્ગ#,
		},
		'Africa/Juba' => {
			exemplarCity => q#જુબા#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#કમ્પાલા#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#ખાર્ટૂમ#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#કિગાલી#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#કિંશાસા#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#લાગોસ#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#લિબ્રેવિલે#,
		},
		'Africa/Lome' => {
			exemplarCity => q#લોમ#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#લ્યુએન્ડા#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#લુબુમ્બાશી#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#લુસાકા#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#મલાબો#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#માપુટો#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#મસેરુ#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#અમ્બબાન#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#મોગાડીશુ#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#મોંરોવિયા#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#નૈરોબી#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#અન્જમેન#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#યામેય#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#નૌકચોટ#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#ઔઆગાદૌગૌ#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#પોર્ટો-નોવો#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#સાઓ ટૉમ#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#ટ્રીપોલી#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#ટ્યુનિસ#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#વિંડહૉક#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q(મધ્ય આફ્રિકા સમય),
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q(પૂર્વ આફ્રિકા સમય),
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q(દક્ષિણ આફ્રિકા માનક સમય),
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q(પશ્ચિમ આફ્રિકા ગ્રીષ્મ સમય),
				'generic' => q(પશ્ચિમ આફ્રિકા સમય),
				'standard' => q(પશ્ચિમ આફ્રિકા માનક સમય),
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q(અલાસ્કા દિવસ સમય),
				'generic' => q(અલાસ્કા સમય),
				'standard' => q(અલાસ્કા પ્રમાણભૂત સમય),
			},
		},
		'Almaty' => {
			long => {
				'daylight' => q(અલ્માટી ગ્રીષ્મ સમય),
				'generic' => q(અલ્માટી સમય),
				'standard' => q(અલ્માટી પ્રમાણભૂત સમય),
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q(એમેઝોન ગ્રીષ્મ સમય),
				'generic' => q(એમેઝોન સમય),
				'standard' => q(એમેઝોન માનક સમય),
			},
		},
		'America/Adak' => {
			exemplarCity => q#અદક#,
		},
		'America/Anchorage' => {
			exemplarCity => q#એન્કોરેજ#,
		},
		'America/Anguilla' => {
			exemplarCity => q#ઍંગ્વિલા#,
		},
		'America/Antigua' => {
			exemplarCity => q#ઍન્ટિગુઆ#,
		},
		'America/Araguaina' => {
			exemplarCity => q#અરાગુઇના#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#લા રિઓહા#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#રિઓ ગેલેગોસ#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#સાલ્ટા#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#સેન જુએન#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#સેન લુઇસ#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#તુકુમાન#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#ઉશાયા#,
		},
		'America/Aruba' => {
			exemplarCity => q#અરુબા#,
		},
		'America/Asuncion' => {
			exemplarCity => q#એસન્શિયન#,
		},
		'America/Bahia' => {
			exemplarCity => q#બાહિયા#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#બહિયા બાંદ્રાસ#,
		},
		'America/Barbados' => {
			exemplarCity => q#બારબાડોસ#,
		},
		'America/Belem' => {
			exemplarCity => q#બેલેમ#,
		},
		'America/Belize' => {
			exemplarCity => q#બેલીઝ#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#બ્લાંક-સેબલોન#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#બોઆ વિસ્ટા#,
		},
		'America/Bogota' => {
			exemplarCity => q#બોગોટા#,
		},
		'America/Boise' => {
			exemplarCity => q#બોઇઝ#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#બ્યુનસ એયર્સ#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#કેમ્બ્રિજ બે#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#કામ્પો ગ્રાંડ#,
		},
		'America/Cancun' => {
			exemplarCity => q#કાન્કુન#,
		},
		'America/Caracas' => {
			exemplarCity => q#કૅરાકસ#,
		},
		'America/Catamarca' => {
			exemplarCity => q#કાતામાર્કા#,
		},
		'America/Cayenne' => {
			exemplarCity => q#કાયેને#,
		},
		'America/Cayman' => {
			exemplarCity => q#કેમેન#,
		},
		'America/Chicago' => {
			exemplarCity => q#શિકાગો#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#ચિહુઆહુઆ#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#એટિકોકેન#,
		},
		'America/Cordoba' => {
			exemplarCity => q#કોર્ડોબા#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#કોસ્ટા રિકા#,
		},
		'America/Creston' => {
			exemplarCity => q#ક્રેસ્ટન#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#ક્યુએબા#,
		},
		'America/Curacao' => {
			exemplarCity => q#કુરાકાઓ#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#ડેનમાર્કશૉન#,
		},
		'America/Dawson' => {
			exemplarCity => q#ડૌસન#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#ડૌસન ક્રિક#,
		},
		'America/Denver' => {
			exemplarCity => q#દેન્વર#,
		},
		'America/Detroit' => {
			exemplarCity => q#ડેટ્રોઇટ#,
		},
		'America/Dominica' => {
			exemplarCity => q#ડોમિનિકા#,
		},
		'America/Edmonton' => {
			exemplarCity => q#એડમેન્ટન#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#ઇરુનેપ#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#એલ સેલ્વાડોર#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#ફોર્ટાલેઝા#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#ગ્લેસ બે#,
		},
		'America/Godthab' => {
			exemplarCity => q#નૂક#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#ગૂસ બે#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#ગ્રાન્ડ ટર્ક#,
		},
		'America/Grenada' => {
			exemplarCity => q#ગ્રેનેડા#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#ગ્વાડેલોપ#,
		},
		'America/Guatemala' => {
			exemplarCity => q#ગ્વાટેમાલા#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#ગુયાક્વિલ#,
		},
		'America/Guyana' => {
			exemplarCity => q#ગયાના#,
		},
		'America/Halifax' => {
			exemplarCity => q#હેલિફેક્સ#,
		},
		'America/Havana' => {
			exemplarCity => q#હવાના#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#એરમોસિયો#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#નોક્સ,ઇન્ડિયાના#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#મેરેંગો, ઇન્ડિયાના#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#પિટર્સબર્ગ,ઇન્ડિયાના#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#ટેલ સિટી,ઇન્ડિયાના#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#વેવૈ, ઇન્ડિયાના#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#વેસેંન, ઇન્ડિયાના#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#વિનામેક,ઇન્ડિયાના#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#ઇન્ડિયાનપોલિસ#,
		},
		'America/Inuvik' => {
			exemplarCity => q#ઇનુવિક#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#ઇકાલુઇત#,
		},
		'America/Jamaica' => {
			exemplarCity => q#જમૈકા#,
		},
		'America/Jujuy' => {
			exemplarCity => q#હુહુઇ#,
		},
		'America/Juneau' => {
			exemplarCity => q#જુનો#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#મોંટીસેલો,કેન્ટુકી#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#ક્રાલેન્ડિક#,
		},
		'America/La_Paz' => {
			exemplarCity => q#લા પેઝ#,
		},
		'America/Lima' => {
			exemplarCity => q#લિમા#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#લોસ એંજેલેસ#,
		},
		'America/Louisville' => {
			exemplarCity => q#લૂઇવિલ#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#લોઅર પ્રિન્સનું ક્વાર્ટર#,
		},
		'America/Maceio' => {
			exemplarCity => q#મેસિઓ#,
		},
		'America/Managua' => {
			exemplarCity => q#માનાગુઆ#,
		},
		'America/Manaus' => {
			exemplarCity => q#મનૌસ#,
		},
		'America/Marigot' => {
			exemplarCity => q#મેરીગોટ#,
		},
		'America/Martinique' => {
			exemplarCity => q#માર્ટીનીક#,
		},
		'America/Matamoros' => {
			exemplarCity => q#માતામોરોસ#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#મઝત્લાન#,
		},
		'America/Mendoza' => {
			exemplarCity => q#મેન્ડોઝા#,
		},
		'America/Menominee' => {
			exemplarCity => q#મેનોમિની#,
		},
		'America/Merida' => {
			exemplarCity => q#મેરિદા#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#મેટ્લાકાટ્લા#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#મેક્સિકો સિટી#,
		},
		'America/Miquelon' => {
			exemplarCity => q#માઇક્યુલોન#,
		},
		'America/Moncton' => {
			exemplarCity => q#મોન્કટન#,
		},
		'America/Monterrey' => {
			exemplarCity => q#મોન્તોરે#,
		},
		'America/Montevideo' => {
			exemplarCity => q#મૉંટેવિડિઓ#,
		},
		'America/Montserrat' => {
			exemplarCity => q#મોંટસેરાત#,
		},
		'America/Nassau' => {
			exemplarCity => q#નાસાઉ#,
		},
		'America/New_York' => {
			exemplarCity => q#ન્યૂયોર્ક#,
		},
		'America/Nipigon' => {
			exemplarCity => q#નિપિગોન#,
		},
		'America/Nome' => {
			exemplarCity => q#નોમ#,
		},
		'America/Noronha' => {
			exemplarCity => q#નોરોન્હા#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#બિયુલાહ,ઉત્તર ડેકોટા#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#સેન્ટર,ઉત્તર ડેકોટા#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#નવું સેલમ,ઉત્તર ડેકોટા#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#ઓજિનાગા#,
		},
		'America/Panama' => {
			exemplarCity => q#પનામા#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#પેંગનિરતુંગ#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#પેરામેરિબો#,
		},
		'America/Phoenix' => {
			exemplarCity => q#ફોનિક્સ#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#પોર્ટ-ઓ-પ્રિન્સ#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#પોર્ટ ઑફ સ્પેન#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#પોર્ટો વેલ્હો#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#પ્યુઅર્ટો રિકો#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#બરસાતી નદી#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#રેંકિન ઇન્લેટ#,
		},
		'America/Recife' => {
			exemplarCity => q#રેસીફ#,
		},
		'America/Regina' => {
			exemplarCity => q#રેજીના#,
		},
		'America/Resolute' => {
			exemplarCity => q#રેઝોલૂટ#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#રિયો બ્રાંકો#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#સાંતા ઇસાબેલ#,
		},
		'America/Santarem' => {
			exemplarCity => q#સેન્તારેમ#,
		},
		'America/Santiago' => {
			exemplarCity => q#સાંટિયાગો#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#સેંટો ડોમિંગો#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#સાઓ પાઉલો#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#સ્કોર્સબાયસન્દ#,
		},
		'America/Sitka' => {
			exemplarCity => q#સિટ્કા#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#સેંટ બાર્થેલેમી#,
		},
		'America/St_Johns' => {
			exemplarCity => q#સેન્ટ જ્હોન્સ#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#સેન્ટ કીટ્સ#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#સેંટ લુસિયા#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#સેંટ થોમસ#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#સેન્ટ વિંસેંટ#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#સ્વિફ્ટ કરંટ#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#તેગુસિગલ્પા#,
		},
		'America/Thule' => {
			exemplarCity => q#થુલે#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#થંડર બે#,
		},
		'America/Tijuana' => {
			exemplarCity => q#તિજુઆના#,
		},
		'America/Toronto' => {
			exemplarCity => q#ટોરન્ટો#,
		},
		'America/Tortola' => {
			exemplarCity => q#ટોર્ટોલા#,
		},
		'America/Vancouver' => {
			exemplarCity => q#વેન્કુવર#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#વ્હાઇટહોર્સ#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#વિન્નિપેગ#,
		},
		'America/Yakutat' => {
			exemplarCity => q#યકુતત#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#યેલોનાઇફ#,
		},
		'America_Central' => {
			long => {
				'daylight' => q(ઉત્તર અમેરિકન મધ્ય દિવસ સમય),
				'generic' => q(ઉત્તર અમેરિકન મધ્ય સમય),
				'standard' => q(ઉત્તર અમેરિકન મધ્ય પ્રમાણભૂત સમય),
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q(ઉત્તર અમેરિકન પૂર્વી દિવસ સમય),
				'generic' => q(ઉત્તર અમેરિકન પૂર્વી સમય),
				'standard' => q(ઉત્તર અમેરિકન પૂર્વી પ્રમાણભૂત સમય),
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q(ઉત્તર અમેરિકન માઉન્ટન દિવસ સમય),
				'generic' => q(ઉત્તર અમેરિકન માઉન્ટન સમય),
				'standard' => q(ઉત્તર અમેરિકન માઉન્ટન પ્રમાણભૂત સમય),
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q(ઉત્તર અમેરિકન પેસિફિક દિવસ સમય),
				'generic' => q(ઉત્તર અમેરિકન પેસિફિક સમય),
				'standard' => q(ઉત્તર અમેરિકન પેસિફિક પ્રમાણભૂત સમય),
			},
		},
		'Anadyr' => {
			long => {
				'daylight' => q(અનાડિર ગ્રીષ્મ સમય),
				'generic' => q(અનાદિર સમય),
				'standard' => q(અનાડિર પ્રમાણભૂત સમય),
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#કૅસી#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#ડૅવિસ#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#દુમોન્ત દી'ઉર્વિલ#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#મેક્વેરી#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#મોસન#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#મૅકમર્ડો#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#પાલ્મર#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#રોથેરા#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#સ્યોવા#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#વોસ્ટૉક#,
		},
		'Aqtau' => {
			long => {
				'daylight' => q(અક્તાઉ ગ્રીષ્મ સમય),
				'generic' => q(અક્તાઉ સમય),
				'standard' => q(અક્તાઉ પ્રમાણભૂત સમય),
			},
		},
		'Aqtobe' => {
			long => {
				'daylight' => q(ઍક્ટોબ ગ્રીષ્મ સમય),
				'generic' => q(ઍક્ટોબ સમય),
				'standard' => q(ઍક્ટોબ પ્રમાણભૂત સમય),
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q(અરેબિયન દિવસ સમય),
				'generic' => q(અરેબિયન સમય),
				'standard' => q(અરેબિયન માનક સમય),
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#લોંગઇયરબિયેન#,
		},
		'Argentina' => {
			long => {
				'daylight' => q(આર્જેન્ટીના ગ્રીષ્મ સમય),
				'generic' => q(અર્જેન્ટીના સમય),
				'standard' => q(અર્જેન્ટીના માનક સમય),
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q(પશ્ચિમી અર્જેન્ટીના ગ્રીષ્મ સમય),
				'generic' => q(પશ્ચિમી અર્જેન્ટીના સમય),
				'standard' => q(પશ્ચિમી અર્જેન્ટીના માનક સમય),
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q(આર્મેનિયા ગ્રીષ્મ સમય),
				'generic' => q(આર્મેનિયા સમય),
				'standard' => q(આર્મેનિયા માનક સમય),
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#એદેન#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#અલ્માટી#,
		},
		'Asia/Amman' => {
			exemplarCity => q#અમ્માન#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#અનદિર#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#અકટાઉ#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#ઍક્ટોબ#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#અશગાબટ#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#બગદાદ#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#બેહરીન#,
		},
		'Asia/Baku' => {
			exemplarCity => q#બાકુ#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#બેંગકોક#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#બૈરુત#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#બિશકેક#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#બ્રુનેઇ#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#કોલકાતા#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#ચોઇબાલ્સન#,
		},
		'Asia/Chongqing' => {
			exemplarCity => q#ચોંગકિંગ#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#કોલંબો#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#દમાસ્કસ#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#ઢાકા#,
		},
		'Asia/Dili' => {
			exemplarCity => q#દિલિ#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#દુબઈ#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#દુશામ્બે#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#ગાઝા#,
		},
		'Asia/Harbin' => {
			exemplarCity => q#હારબિન#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#હેબ્રોન#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#હોંગકોંગ#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#હોવ્ડ#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#ઇર્કુત્સ્ક#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#જાકાર્તા#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#જયાપુરા#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#જેરુસલેમ#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#કાબુલ#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#કામચટ્કા#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#કરાચી#,
		},
		'Asia/Kashgar' => {
			exemplarCity => q#કાશ્ગર#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#કથમન્ડુ#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#ખંડિગા#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#ક્રિસ્નોયાર્સ્ક#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#કુઆલાલમ્પુર#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#કુચિંગ#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#કુવૈત#,
		},
		'Asia/Macau' => {
			exemplarCity => q#મકાઉ#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#મેગાડન#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#માકસ્સર#,
		},
		'Asia/Manila' => {
			exemplarCity => q#મનિલા#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#મસ્કત#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#નિકોસિયા#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#નોવોકુઝ્નેત્સ્ક#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#નોવોસીર્બિર્સ્ક#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#ઓમ્સ્ક#,
		},
		'Asia/Oral' => {
			exemplarCity => q#ઓરલ#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#ફ્નોમ પેન્હ#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#પોન્ટિયનેક#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#પ્યોંગયાંગ#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#કતાર#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#કિઝિલોર્ડા#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#રંગૂન#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#રિયાધ#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#હો ચી મીન સિટી#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#સખાલિન#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#સમરકન્ડ#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#સીઓલ#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#શેંઘાઇ#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#સિંગાપુર#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#તાઇપેઇ#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#તાશકેન્ટ#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#બિલિસિ#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#તેહરાન#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#થીમ્ફુ#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#ટોક્યો#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#ઉલાંબાતર#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#ઉરુમ્કી#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#ઉસ્ત-નેરા#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#વિયેનટિયેન#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#વ્લેડિવોસ્ટોક#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#યકુત્સક#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#યેકાતેરિનબર્ગ#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#યેરેવાન#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q(અટલાન્ટિક દિવસ સમય),
				'generic' => q(અટલાન્ટિક સમય),
				'standard' => q(અટલાન્ટિક પ્રમાણભૂત સમય),
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#એઝોરેઝ#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#બર્મુડા#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#કૅનેરી#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#કૅપ વેર્ડે#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#ફેરો#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#મડિરા#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#રૅકયાવિક#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#સાઉથ જ્યોર્જિયા#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#સેન્ટ હેલેના#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#સ્ટેનલી#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#એડિલેઇડ#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#બ્રિસબેન#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#બ્રોકન હિલ#,
		},
		'Australia/Currie' => {
			exemplarCity => q#ક્યુરી#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#ડાર્વિન#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#ઉક્લા#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#હોબાર્ટ#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#લિન્ડેમેન#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#લોર્ડ હોવ#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#મેલબોર્ન#,
		},
		'Australia/Perth' => {
			exemplarCity => q#પર્થ#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#સિડ્ની#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q(ઓસ્ટ્રેલિયન મધ્ય દિવસ સમય),
				'generic' => q(મધ્ય ઓસ્ટ્રેલિયન સમય),
				'standard' => q(ઓસ્ટ્રેલિયન મધ્ય પ્રમાણભૂત સમય),
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q(ઓસ્ટ્રેલિયન મધ્ય પશ્ચિમી દિવસ સમય),
				'generic' => q(ઓસ્ટ્રેલિયન મધ્ય પશ્ચિમી સમય),
				'standard' => q(ઓસ્ટ્રેલિયન મધ્ય પશ્ચિમી પ્રમાણભૂત સમય),
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q(ઓસ્ટ્રેલિયન પૂર્વી દિવસ સમય),
				'generic' => q(પૂર્વી ઓસ્ટ્રેલિયા સમય),
				'standard' => q(ઓસ્ટ્રેલિયન પૂર્વી પ્રમાણભૂત સમય),
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q(ઓસ્ટ્રેલિયન પશ્ચિમી દિવસ સમય),
				'generic' => q(પશ્ચિમી ઓસ્ટ્રેલિયા સમય),
				'standard' => q(ઓસ્ટ્રેલિયન પશ્ચિમી પ્રમાણભૂત સમય),
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q(અઝરબૈજાન ગ્રીષ્મ સમય),
				'generic' => q(અઝરબૈજાન સમય),
				'standard' => q(અઝરબૈજાન માનક સમય),
			},
		},
		'Azores' => {
			long => {
				'daylight' => q(એઝોર્સ ગ્રીષ્મ સમય),
				'generic' => q(એઝોર્સ સમય),
				'standard' => q(એઝોર્સ માનક સમય),
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q(બાંગ્લાદેશ ગ્રીષ્મ સમય),
				'generic' => q(બાંગ્લાદેશ સમય),
				'standard' => q(બાંગ્લાદેશ માનક સમય),
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q(ભૂટાન સમય),
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q(બોલિવિયા સમય),
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q(બ્રાઝિલિયા ગ્રીષ્મ સમય),
				'generic' => q(બ્રાઝિલિયા સમય),
				'standard' => q(બ્રાઝિલિયા માનક સમય),
			},
		},
		'Brunei' => {
			long => {
				'standard' => q(બ્રૂનેઈ દારુસલામ સમય),
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q(કૅપ વર્ડે ગ્રીષ્મ સમય),
				'generic' => q(કૅપ વર્ડે સમય),
				'standard' => q(કૅપ વર્ડે માનક સમય),
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q(કેમોરો માનક સમય),
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q(ચેતહામ દિવસ સમય),
				'generic' => q(ચેતહામ સમય),
				'standard' => q(ચેતહામ માનક સમય),
			},
		},
		'Chile' => {
			long => {
				'daylight' => q(ચિલી ગ્રીષ્મ સમય),
				'generic' => q(ચિલી સમય),
				'standard' => q(ચિલી માનક સમય),
			},
		},
		'China' => {
			long => {
				'daylight' => q(ચીન દિવસ સમય),
				'generic' => q(ચીન સમય),
				'standard' => q(ચીન માનક સમય),
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q(ચોઇબાલ્સન ગ્રીષ્મ સમય),
				'generic' => q(ચોઇબાલ્સન સમય),
				'standard' => q(ચોઇબાલ્સન માનક સમય),
			},
		},
		'Christmas' => {
			long => {
				'standard' => q(ક્રિસમસ આઇલેન્ડ સમય),
			},
		},
		'Cocos' => {
			long => {
				'standard' => q(કોકોઝ આઇલેન્ડ સમય),
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q(કોલંબિયા ગ્રીષ્મ સમય),
				'generic' => q(કોલંબિયા સમય),
				'standard' => q(કોલંબિયા માનક સમય),
			},
		},
		'Cook' => {
			long => {
				'daylight' => q(કુક આઇલેન્ડ્સ અર્ધ ગ્રીષ્મ સમય),
				'generic' => q(કુક આઇલેન્ડ્સ સમય),
				'standard' => q(કુક આઇલેન્ડ્સ માનક સમય),
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q(ક્યૂબા દિવસ સમય),
				'generic' => q(ક્યૂબા સમય),
				'standard' => q(ક્યૂબા માનક સમય),
			},
		},
		'Davis' => {
			long => {
				'standard' => q(ડેવિસ સમય),
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q(ડ્યુમોન્ટ-ડી'ઉર્વિલ સમય),
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q(પૂર્વ તિમોર સમય),
			},
		},
		'Easter' => {
			long => {
				'daylight' => q(ઇસ્ટર આઇલેન્ડ ગ્રીષ્મ સમય),
				'generic' => q(ઇસ્ટર આઇલેન્ડ સમય),
				'standard' => q(ઇસ્ટર આઇલેન્ડ માનક સમય),
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q(એક્વાડોર સમય),
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#અજ્ઞાત શહેર#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#ઍમ્સ્ટરડૅમ#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#ઍંડોરા#,
		},
		'Europe/Athens' => {
			exemplarCity => q#એથેંસ#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#બેલગ્રેડ#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#બર્લિન#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#બ્રેટિસલાવા#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#બ્રસેલ્સ#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#બુકરેસ્ટ#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#બુડાપેસ્ટ#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#બિઝેન્ગન#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#ચિસીનાઉ#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#કૉપેનહૅજેન#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#ડબલિન#,
			long => {
				'daylight' => q(આઇરિશ ગ્રીષ્મ સમય),
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#જીબ્રાલ્ટર#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#ગર્નઝી#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#હેલસિંકી#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#આય્લ ઓફ મૅન#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#ઇસ્તાંબુલ#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#જર્સી#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#કલિનિન્ગ્રેડ#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#કૈવ#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#લિસ્બન#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#લુબ્લિયાના#,
		},
		'Europe/London' => {
			exemplarCity => q#લંડન#,
			long => {
				'daylight' => q(બ્રિટિશ ગ્રીષ્મ સમય),
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#લક્ઝમબર્ગ#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#મૅડ્રીડ#,
		},
		'Europe/Malta' => {
			exemplarCity => q#માલ્ટા#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#મેરિહેમ#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#મિંસ્ક#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#મોનાકો#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#મોસ્કો#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#ઑસ્લો#,
		},
		'Europe/Paris' => {
			exemplarCity => q#પેરિસ#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#પોડગોરિકા#,
		},
		'Europe/Prague' => {
			exemplarCity => q#પ્રાગ#,
		},
		'Europe/Riga' => {
			exemplarCity => q#રિગા#,
		},
		'Europe/Rome' => {
			exemplarCity => q#રોમ#,
		},
		'Europe/Samara' => {
			exemplarCity => q#સમારા#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#સૅન મેરિનો#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#સારાજેવો#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#સિમ્ફેરોપોલ#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#સ્કોપયે#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#સોફિયા#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#સ્ટોકહૉમ#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#તલ્લીન#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#તિરાને#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#ઉઝ્ગોરોદ#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#વૅદુઝ#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#વેટિકન#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#વિયેના#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#વિલ્નિઅસ#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#વોલ્ગોગ્રેડ#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#વોરસૉ#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#ઝેગરેબ#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#જેપોરોઝિયે#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#ઝુરીક#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q(મધ્ય યુરોપિયન ગ્રીષ્મ સમય),
				'generic' => q(મધ્ય યુરોપિયન સમય),
				'standard' => q(મધ્ય યુરોપિયન માનક સમય),
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q(પૂર્વી યુરોપીયન ગ્રીષ્મ સમય),
				'generic' => q(પૂર્વી યુરોપિયન સમય),
				'standard' => q(પૂર્વી યુરોપિયન માનક સમય),
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q(પશ્ચિમી યુરોપિયન ગ્રીષ્મ સમય),
				'generic' => q(પશ્ચિમી યુરોપિયન સમય),
				'standard' => q(પશ્ચિમી યુરોપિયન માનક સમય),
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q(ફોકલૅંડ આઇલેન્ડ્સ ગ્રીષ્મ સમય),
				'generic' => q(ફોકલૅંડ આઇલેન્ડ્સ સમય),
				'standard' => q(ફૉકલૅંડ આઇલેન્ડ્સ માનક સમય),
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q(ફિજી ગ્રીષ્મ સમય),
				'generic' => q(ફિજી સમય),
				'standard' => q(ફિજી માનક સમય),
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q(ફ્રેન્ચ ગયાના સમય),
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q(ફ્રેન્ચ સાઉધર્ન અને એન્ટાર્કટિક સમય),
			},
		},
		'GMT' => {
			long => {
				'standard' => q(ગ્રીનવિચ મધ્યમ સમય),
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q(ગાલાપાગોસ સમય),
			},
		},
		'Gambier' => {
			long => {
				'standard' => q(ગેમ્બિયર સમય),
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q(જ્યોર્જિયા ગ્રીષ્મ સમય),
				'generic' => q(જ્યોર્જિયા સમય),
				'standard' => q(જ્યોર્જિયા માનક સમય),
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q(ગિલબર્ટ આઇલેન્ડ સમય),
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q(પૂર્વ ગ્રીનલેન્ડ ગ્રીષ્મ સમય),
				'generic' => q(પૂર્વ ગ્રીનલેન્ડ સમય),
				'standard' => q(પૂર્વ ગ્રીનલેન્ડ માનક સમય),
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q(પશ્ચિમ ગ્રીનલેન્ડ ગ્રીષ્મ સમય),
				'generic' => q(પશ્ચિમ ગ્રીનલેન્ડ સમય),
				'standard' => q(પશ્ચિમ ગ્રીનલેન્ડ માનક સમય),
			},
		},
		'Guam' => {
			long => {
				'standard' => q(ગ્વામ પ્રમાણભૂત સમય),
			},
		},
		'Gulf' => {
			long => {
				'standard' => q(ગલ્ફ માનક સમય),
			},
		},
		'Guyana' => {
			long => {
				'standard' => q(ગયાના સમય),
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q(હવાઇ-એલ્યુશિઅન દિવસ સમય),
				'generic' => q(હવાઈ-એલ્યુશિઅન સમય),
				'standard' => q(હવાઇ-એલ્યુશિઅન માનક સમય),
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q(હોંગ કોંગ ગ્રીષ્મ સમય),
				'generic' => q(હોંગ કોંગ સમય),
				'standard' => q(હોંગ કોંગ માનક સમય),
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q(હોવ્ડ ગ્રીષ્મ સમય),
				'generic' => q(હોવ્ડ સમય),
				'standard' => q(હોવ્ડ માનક સમય),
			},
		},
		'India' => {
			long => {
				'standard' => q(ભારતીય માનક સમય),
			},
			short => {
				'standard' => q(IST),
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#અંતાનાનારિવો#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#ચાગોસ#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#ક્રિસમસ#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#કૉકોસ#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#કોમોરો#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#કેરગ્વેલિન#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#માહે#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#માલદિવ્સ#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#મોરિશિયસ#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#મેયોટ#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#રિયુનિયન#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q(ભારતીય મહાસાગર સમય),
			},
		},
		'Indochina' => {
			long => {
				'standard' => q(ઇન્ડોચાઇના સમય),
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q(મધ્ય ઇન્ડોનેશિયા સમય),
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q(પૂર્વી ઇન્ડોનેશિયા સમય),
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q(પશ્ચિમી ઇન્ડોનેશિયા સમય),
			},
		},
		'Iran' => {
			long => {
				'daylight' => q(ઈરાન દિવસ સમય),
				'generic' => q(ઈરાન સમય),
				'standard' => q(ઈરાન માનક સમય),
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q(ઇર્કુત્સ્ક ગ્રીષ્મ સમય),
				'generic' => q(ઇર્કુત્સ્ક સમય),
				'standard' => q(ઇર્કુત્સ્ક માનક સમય),
			},
		},
		'Israel' => {
			long => {
				'daylight' => q(ઇઝરાઇલ દિવસ સમય),
				'generic' => q(ઇઝરાઇલ સમય),
				'standard' => q(ઇઝરાઇલ માનક સમય),
			},
		},
		'Japan' => {
			long => {
				'daylight' => q(જાપાન દિવસ સમય),
				'generic' => q(જાપાન સમય),
				'standard' => q(જાપાન માનક સમય),
			},
		},
		'Kamchatka' => {
			long => {
				'daylight' => q(પેટ્રોપેવલોવ્સ્ક-કામચતસ્કી ગ્રીષ્મ સમય),
				'generic' => q(પેટ્રોપેવલોવ્સ્ક-કામચતસ્કી સમય),
				'standard' => q(પેટ્રોપેવલોવ્સ્ક-કામચતસ્કી પ્રમાણભૂત સમય),
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q(પૂર્વ કઝાકિસ્તાન સમય),
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q(પશ્ચિમ કઝાકિસ્તાન સમય),
			},
		},
		'Korea' => {
			long => {
				'daylight' => q(કોરિયન દિવસ સમય),
				'generic' => q(કોરિયન સમય),
				'standard' => q(કોરિયન માનક સમય),
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q(કોસરે સમય),
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q(ક્રેસનોયાર્સ્ક ગ્રીષ્મ સમય),
				'generic' => q(ક્રેસ્નોયાર્સ્કી સમય),
				'standard' => q(ક્રસ્નોયાર્સ્ક માનક સમય),
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q(કિર્ગિઝતાન સમય),
			},
		},
		'Lanka' => {
			long => {
				'standard' => q(લંકા સમય),
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q(લાઇન આઇલેન્ડ્સ સમય),
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q(લોર્ડ હોવ દિવસ સમય),
				'generic' => q(લોર્ડ હોવ સમય),
				'standard' => q(લોર્ડ હોવ પ્રમાણભૂત સમય),
			},
		},
		'Macau' => {
			long => {
				'daylight' => q(મકાઉ ગ્રીષ્મ સમય),
				'generic' => q(મકાઉ સમય),
				'standard' => q(મકાઉ પ્રમાણભૂત સમય),
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q(મેક્વાયર આઇલેન્ડ સમય),
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q(મગદન ગ્રીષ્મ સમય),
				'generic' => q(મેગાડન સમય),
				'standard' => q(માગાદાન માનક સમય),
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q(મલેશિયા સમય),
			},
		},
		'Maldives' => {
			long => {
				'standard' => q(માલદીવ સમય),
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q(માર્ક્યૂસસ સમય),
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q(માર્શલ આઇલેન્ડ્સ સમય),
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q(મોરિશિયસ ગ્રીષ્મ સમય),
				'generic' => q(મોરિશિયસ સમય),
				'standard' => q(મોરિશિયસ માનક સમય),
			},
		},
		'Mawson' => {
			long => {
				'standard' => q(મોસન સમય),
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q(ઉલાન બટોર ગ્રીષ્મ સમય),
				'generic' => q(ઉલાન બાટોર સમય),
				'standard' => q(ઉલાન બાટોર માનક સમય),
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q(મોસ્કો ગ્રીષ્મ સમય),
				'generic' => q(મોસ્કો સમય),
				'standard' => q(મોસ્કો પ્રમાણભૂત સમય),
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q(મ્યાનમાર સમય),
			},
		},
		'Nauru' => {
			long => {
				'standard' => q(નૌરુ સમય),
			},
		},
		'Nepal' => {
			long => {
				'standard' => q(નેપાળ સમય),
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q(ન્યુ સેલેડોનિયા ગ્રીષ્મ સમય),
				'generic' => q(ન્યુ સેલેડોનિયા સમય),
				'standard' => q(ન્યુ સેલેડોનિયા માનક સમય),
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q(ન્યુઝીલેન્ડ દિવસ સમય),
				'generic' => q(ન્યુઝીલેન્ડ સમય),
				'standard' => q(ન્યુઝીલેન્ડ માનક સમય),
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q(ન્યૂફાઉન્ડલેન્ડ દિવસ સમય),
				'generic' => q(ન્યૂફાઉન્ડલેન્ડ સમય),
				'standard' => q(ન્યૂફાઉન્ડલેન્ડ પ્રમાણભૂત સમય),
			},
		},
		'Niue' => {
			long => {
				'standard' => q(નીયુ સમય),
			},
		},
		'Norfolk' => {
			long => {
				'standard' => q(નોરફૉક આઇલેન્ડ સમય),
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q(ફરનેન્ડો દે નોરોહા ગ્રીષ્મ સમય),
				'generic' => q(ફર્નાન્ડો ડી નોરોન્હા સમય),
				'standard' => q(ફર્નાન્ડો ડી નોરોન્હા માનક સમય),
			},
		},
		'North_Mariana' => {
			long => {
				'standard' => q(ઉત્તર મારિયાના આઇલેન્ડ્સ),
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q(નોવોસીબર્ક્સ ગ્રીષ્મ સમય),
				'generic' => q(નોવોસીર્બિર્સ્ક સમય),
				'standard' => q(નોવોસિબિર્સ્ક માનક સમય),
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q(ઓમ્સ્ક ગ્રીષ્મ સમય),
				'generic' => q(ઓમ્સ્ક સમય),
				'standard' => q(ઓમસ્ક માનક સમય),
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#એપિયા#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#ઑકલેન્ડ#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#ચથમ#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#ઇસ્ટર#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#એફેટ#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#એંડર્બરી#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#ફાકાઓફો#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#ફીજી#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#ફુનાફુટી#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#ગાલાપેગોસ#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#ગેમ્બિયર#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#ગૌડલકૅનલ#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#ગ્વામ#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#હોનોલુલુ#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#જોહ્નસ્ટોન#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#કિરિતિમાતી#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#કોસરે#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#ક્વાજાલીન#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#માજુરો#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#માર્કીસાસ#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#મીડવે#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#નૌરુ#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#નીયુ#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#નૉરફૉક#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#નૌમીઆ#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#પેગો પેગો#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#પલાઉ#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#પીટકૈર્ન#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#પોન્પે#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#પોર્ટ મોર્સ્બી#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#રેરોટોંગા#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#સાઇપન#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#તાહીતી#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#તારાવા#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#ટૉંગાટાપુ#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#ચુક#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#વેક#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#વાલિસ#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q(પાકિસ્તાન ગ્રીષ્મ સમય),
				'generic' => q(પાકિસ્તાન સમય),
				'standard' => q(પાકિસ્તાન માનક સમય),
			},
		},
		'Palau' => {
			long => {
				'standard' => q(પલાઉ સમય),
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q(પાપુઆ ન્યુ ગિની સમય),
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q(પેરાગ્વે ગ્રીષ્મ સમય),
				'generic' => q(પેરાગ્વે સમય),
				'standard' => q(પેરાગ્વે માનક સમય),
			},
		},
		'Peru' => {
			long => {
				'daylight' => q(પેરુ ગ્રીષ્મ સમય),
				'generic' => q(પેરુ સમય),
				'standard' => q(પેરુ માનક સમય),
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q(ફિલિપાઇન ગ્રીષ્મ સમય),
				'generic' => q(ફિલિપાઇન સમય),
				'standard' => q(ફિલિપાઇન માનક સમય),
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q(ફોનિક્સ આઇલેન્ડ્સ સમય),
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q(સેંટ પીએરે એન્ડ મિકીલોન દિવસ સમય),
				'generic' => q(સેંટ પીએરે એન્ડ મિકીલોન સમય),
				'standard' => q(સેંટ પીએરે એન્ડ મિકીલોન માનક સમય),
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q(પિટકેયર્ન સમય),
			},
		},
		'Ponape' => {
			long => {
				'standard' => q(પોનપે સમય),
			},
		},
		'Qyzylorda' => {
			long => {
				'daylight' => q(કિઝિલોર્ડા ગ્રીષ્મ સમય),
				'generic' => q(કિઝિલોર્ડા સમય),
				'standard' => q(કિઝિલોર્ડા પ્રમાણભૂત સમય),
			},
		},
		'Reunion' => {
			long => {
				'standard' => q(રીયૂનિયન સમય),
			},
		},
		'Rothera' => {
			long => {
				'standard' => q(રોથેરા સમય),
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q(સખાલિન ગ્રીષ્મ સમય),
				'generic' => q(સખાલિન સમય),
				'standard' => q(સખાલિન માનક સમય),
			},
		},
		'Samara' => {
			long => {
				'daylight' => q(સમારા ગ્રીષ્મ સમય),
				'generic' => q(સમારા સમય),
				'standard' => q(સમારા પ્રમાણભૂત સમય),
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q(સમોઆ ગ્રીષ્મ સમય),
				'generic' => q(સમોઆ સમય),
				'standard' => q(સમોઆ માનક સમય),
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q(સેશલ્સ સમય),
			},
		},
		'Singapore' => {
			long => {
				'standard' => q(સિંગાપુર માનક સમય),
			},
		},
		'Solomon' => {
			long => {
				'standard' => q(સોલોમન આઇલેન્ડ્સ સમય),
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q(દક્ષિણ જ્યોર્જીયા સમય),
			},
		},
		'Suriname' => {
			long => {
				'standard' => q(સૂરીનામ સમય),
			},
		},
		'Syowa' => {
			long => {
				'standard' => q(સ્યોવા સમય),
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q(તાહિતી સમય),
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q(તાઇપેઇ દિવસ સમય),
				'generic' => q(તાઇપેઇ સમય),
				'standard' => q(તાઇપેઇ માનક સમય),
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q(તાજીકિસ્તાન સમય),
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q(ટોકલાઉ સમય),
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q(ટોંગા ગ્રીષ્મ સમય),
				'generic' => q(ટોંગા સમય),
				'standard' => q(ટોંગા માનક સમય),
			},
		},
		'Truk' => {
			long => {
				'standard' => q(ચુઉક સમય),
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q(તુર્કમેનિસ્તાન ગ્રીષ્મ સમય),
				'generic' => q(તુર્કમેનિસ્તાન સમય),
				'standard' => q(તુર્કમેનિસ્તાન માનક સમય),
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q(ટવાલૂ સમય),
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q(ઉરૂગ્વે ગ્રીષ્મ સમય),
				'generic' => q(ઉરૂગ્વે સમય),
				'standard' => q(ઉરૂગ્વે માનક સમય),
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q(ઉઝ્બેકિસ્તાન ગ્રીષ્મ સમય),
				'generic' => q(ઉઝ્બેકિસ્તાન સમય),
				'standard' => q(ઉઝ્બેકિસ્તાન માનક સમય),
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q(વનાતૂ ગ્રીષ્મ સમય),
				'generic' => q(વનાતૂ સમય),
				'standard' => q(વનાતૂ માનક સમય),
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q(વેનેઝુએલા સમય),
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q(વ્લેડિવોસ્ટોક ગ્રીષ્મ સમય),
				'generic' => q(વ્લેડિવોસ્ટોક સમય),
				'standard' => q(વ્લાદિવોસ્તોક માનક સમય),
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q(વોલ્ગોગ્રેડ ગ્રીષ્મ સમય),
				'generic' => q(વોલ્ગોગ્રેડ સમય),
				'standard' => q(વોલ્ગોગ્રેડ માનક સમય),
			},
		},
		'Vostok' => {
			long => {
				'standard' => q(વોસ્ટોક સમય),
			},
		},
		'Wake' => {
			long => {
				'standard' => q(વૅક આઇલેન્ડ સમય),
			},
		},
		'Wallis' => {
			long => {
				'standard' => q(વૉલિસ અને ફ્યુચુના સમય),
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q(યકુત્સ્ક ગ્રીષ્મ સમય),
				'generic' => q(યકુત્સક સમય),
				'standard' => q(યાકુત્સ્ક માનક સમય),
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q(ઇકાટેરિન્બર્ગ ગ્રીષ્મ સમય),
				'generic' => q(યેકાતેરિંબર્ગ સમય),
				'standard' => q(યેકાટેરીન્બર્ગ માનક સમય),
			},
		},
	 } }
);
no Moose;
__PACKAGE__->meta->make_immutable;

1;

# vim: tabstop=4
