package Locale::CLDR::Mk v0.25.1;
# This file auto generated from Data\common\main\mk.xml
#	on Sat 10 May 11:43:39 pm GMT
# XML file generated 2014-02-28 23:57:43 -0600 (Fri, 28 Feb 2014)

use v5.10;
use mro 'c3';
use utf8;

use Moose;

extends('Locale::CLDR::Root');
# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $territory, $script, $variant) = @_;

	my $display_pattern = '{0} ({1})';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0}, {1}', grep {$_} (
		$territory,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub { 
		 sub {
			 my %languages = (
				'aa' => 'афар',
 				'ab' => 'апхаски',
 				'ace' => 'акинески',
 				'ach' => 'аколи',
 				'ada' => 'адангме',
 				'ady' => 'адиге',
 				'ae' => 'авестан',
 				'af' => 'африканс',
 				'afh' => 'африхили',
 				'agq' => 'агемски',
 				'ain' => 'аину',
 				'ak' => 'акан',
 				'akk' => 'акадијски',
 				'ale' => 'алеут',
 				'alt' => 'јужен алтај',
 				'am' => 'амхарски',
 				'an' => 'арагонески',
 				'ang' => 'стар англиски',
 				'anp' => 'ангика',
 				'ar' => 'арапски',
 				'ar_001' => 'литературен арапски',
 				'arc' => 'арамејски',
 				'arn' => 'арокенски',
 				'arp' => 'арапахо',
 				'arw' => 'аравак',
 				'as' => 'асамски',
 				'asa' => 'асу',
 				'ast' => 'астуриски',
 				'av' => 'аварски',
 				'awa' => 'авади',
 				'ay' => 'ајмара',
 				'az' => 'азербејџански',
 				'ba' => 'башкирски',
 				'bal' => 'балучи',
 				'ban' => 'балинезе',
 				'bas' => 'баса',
 				'bax' => 'бамунски',
 				'bbj' => 'гомала',
 				'be' => 'белоруски',
 				'bej' => 'беха',
 				'bem' => 'бемба',
 				'bez' => 'бена',
 				'bfd' => 'бафут',
 				'bg' => 'бугарски',
 				'bho' => 'бојпури',
 				'bi' => 'бислама',
 				'bik' => 'бикол',
 				'bin' => 'бини',
 				'bkm' => 'ком',
 				'bla' => 'сиксика',
 				'bm' => 'бамбара',
 				'bn' => 'бенгалски',
 				'bo' => 'тибетски',
 				'br' => 'бретонски',
 				'bra' => 'брај',
 				'brx' => 'бодо',
 				'bs' => 'босански',
 				'bss' => 'акосе',
 				'bua' => 'буријат',
 				'bug' => 'буџински',
 				'bum' => 'булу',
 				'byn' => 'блин',
 				'byv' => 'медумба',
 				'ca' => 'каталонски',
 				'cad' => 'кадо',
 				'car' => 'кариб',
 				'cay' => 'кајуга',
 				'cch' => 'ацам',
 				'ce' => 'чеченски',
 				'ceb' => 'себуано',
 				'cgg' => 'чига',
 				'ch' => 'чаморо',
 				'chb' => 'чибча',
 				'chg' => 'чагатај',
 				'chk' => 'чуук',
 				'chm' => 'мари',
 				'chn' => 'жаргон чинук',
 				'cho' => 'чокто',
 				'chp' => 'чипујан',
 				'chr' => 'чироки',
 				'chy' => 'чејенски',
 				'ckb' => 'сорански курдски',
 				'co' => 'корзикански',
 				'cop' => 'коптски',
 				'cr' => 'кри',
 				'crh' => 'кримско турски',
 				'cs' => 'чешки',
 				'csb' => 'кашубиски',
 				'cu' => 'црковнословенски',
 				'cv' => 'чувашки',
 				'cy' => 'велшки',
 				'da' => 'дански',
 				'dak' => 'дакота',
 				'dar' => 'даргва',
 				'dav' => 'таита',
 				'de' => 'германски',
 				'de_AT' => 'германски (во Австрија)',
 				'de_CH' => 'германски (во Швајцарија)',
 				'del' => 'делавер',
 				'den' => 'славски',
 				'dgr' => 'догриб',
 				'din' => 'динка',
 				'dje' => 'зарма',
 				'doi' => 'догри',
 				'dsb' => 'долносорбиски',
 				'dua' => 'дуала',
 				'dum' => 'среднохоландски',
 				'dv' => 'дивехи',
 				'dyo' => 'јола-фоњи',
 				'dyu' => 'џула',
 				'dz' => 'џонга',
 				'dzg' => 'дазага',
 				'ebu' => 'ембу',
 				'ee' => 'еве',
 				'efi' => 'ефик',
 				'egy' => 'староегипетски',
 				'eka' => 'екајук',
 				'el' => 'грчки',
 				'elx' => 'еламит',
 				'en' => 'англиски',
 				'en_AU' => 'англиски (во Австралија)',
 				'en_CA' => 'англиски (во Канада)',
 				'en_GB' => 'англиски (во Велика Британија)',
 				'en_GB@alt=short' => 'англиски (во ОК)',
 				'en_US' => 'американски англиски',
 				'en_US@alt=short' => 'англиски (во САД)',
 				'enm' => 'средноанглиски',
 				'eo' => 'есперанто',
 				'es' => 'шпански',
 				'es_419' => 'шпански (во Латинска Америка)',
 				'es_ES' => 'шпански (во Европа)',
 				'es_MX' => 'шпански (во Мексико)',
 				'et' => 'естонски',
 				'eu' => 'баскиски',
 				'ewo' => 'евондо',
 				'fa' => 'персиски',
 				'fan' => 'фанг',
 				'fat' => 'фанти',
 				'ff' => 'фула',
 				'fi' => 'фински',
 				'fil' => 'филипински',
 				'fj' => 'фиџиски',
 				'fo' => 'фарски',
 				'fon' => 'фон',
 				'fr' => 'француски',
 				'fr_CA' => 'француски (во Канада)',
 				'fr_CH' => 'француски (во Швајцарија)',
 				'frm' => 'среднофранцуски',
 				'fro' => 'стар француски',
 				'frr' => 'северен фризиски',
 				'frs' => 'источен фризиски',
 				'fur' => 'фрулијански',
 				'fy' => 'западнофризиски',
 				'ga' => 'ирски',
 				'gaa' => 'га',
 				'gay' => 'гајо',
 				'gba' => 'гбаја',
 				'gd' => 'шкотско галски',
 				'gez' => 'гиз',
 				'gil' => 'гилбертански',
 				'gl' => 'галициски',
 				'gmh' => 'среден горногермански',
 				'gn' => 'гварански',
 				'goh' => 'стар високогермански',
 				'gon' => 'гонди',
 				'gor' => 'горонтало',
 				'got' => 'готски',
 				'grb' => 'гребо',
 				'grc' => 'старогрчки',
 				'gsw' => 'швајцарски германски',
 				'gu' => 'гуџарати',
 				'guz' => 'гуси',
 				'gv' => 'манкс',
 				'gwi' => 'гвишин',
 				'ha' => 'хауса',
 				'hai' => 'хајда',
 				'haw' => 'хавајски',
 				'he' => 'хебрејски',
 				'hi' => 'хинди',
 				'hil' => 'хилигајнон',
 				'hit' => 'хитите',
 				'hmn' => 'хмонг',
 				'ho' => 'хири моту',
 				'hr' => 'хрватски',
 				'hsb' => 'горносорбиски',
 				'ht' => 'хаитски',
 				'hu' => 'унгарски',
 				'hup' => 'хупа',
 				'hy' => 'ерменски',
 				'hz' => 'хереро',
 				'ia' => 'интерлингва',
 				'iba' => 'ибан',
 				'ibb' => 'ибибио',
 				'id' => 'индонезиски',
 				'ie' => 'интерлинг',
 				'ig' => 'игбо',
 				'ii' => 'сичуан ји',
 				'ik' => 'инупијак',
 				'ilo' => 'илоко',
 				'inh' => 'ингуш',
 				'io' => 'идо',
 				'is' => 'исландски',
 				'it' => 'италијански',
 				'iu' => 'инуктитут',
 				'ja' => 'јапонски',
 				'jbo' => 'лојбански',
 				'jgo' => 'нгомба',
 				'jmc' => 'мачаме',
 				'jpr' => 'еврејско персиски',
 				'jrb' => 'еврејско арапски',
 				'jv' => 'јавански',
 				'ka' => 'грузиски',
 				'kaa' => 'кара калпак',
 				'kab' => 'кабиле',
 				'kac' => 'кашин',
 				'kaj' => 'жжи',
 				'kam' => 'камба',
 				'kaw' => 'кави',
 				'kbd' => 'кабардиски',
 				'kbl' => 'канембу',
 				'kcg' => 'тјап',
 				'kde' => 'маконде',
 				'kea' => 'кабувердиану',
 				'kfo' => 'коро',
 				'kg' => 'конго',
 				'kha' => 'каси',
 				'kho' => 'котанески',
 				'khq' => 'којра чиини',
 				'ki' => 'кикују',
 				'kj' => 'куањама',
 				'kk' => 'казакстански',
 				'kkj' => 'како',
 				'kl' => 'калалисут',
 				'kln' => 'каленџин',
 				'km' => 'кмерски',
 				'kmb' => 'кимбунду',
 				'kn' => 'каннада',
 				'ko' => 'корејски',
 				'kok' => 'конкани',
 				'kos' => 'козрејски',
 				'kpe' => 'кпеле',
 				'kr' => 'канури',
 				'krc' => 'карашај-балкар',
 				'krl' => 'карелијски',
 				'kru' => 'курук',
 				'ks' => 'кашмирски',
 				'ksb' => 'шамбала',
 				'ksf' => 'бафија',
 				'ksh' => 'колоњски',
 				'ku' => 'курдски',
 				'kum' => 'кумик',
 				'kut' => 'кутенајски',
 				'kv' => 'коми',
 				'kw' => 'корнуолски келтски',
 				'ky' => 'киргистански',
 				'la' => 'латински',
 				'lad' => 'ладино',
 				'lag' => 'ланги',
 				'lah' => 'ланда',
 				'lam' => 'ламба',
 				'lb' => 'луксембуршки',
 				'lez' => 'лежгијски',
 				'lg' => 'ганда',
 				'li' => 'лимбуршки',
 				'ln' => 'лингала',
 				'lo' => 'лаошки',
 				'lol' => 'монго',
 				'loz' => 'лози',
 				'lt' => 'литвански',
 				'lu' => 'луба-катанга',
 				'lua' => 'луба-лулуа',
 				'lui' => 'луизено',
 				'lun' => 'лунда',
 				'luo' => 'луо',
 				'lus' => 'лушајски',
 				'luy' => 'луја',
 				'lv' => 'латвиски',
 				'mad' => 'мадурески',
 				'maf' => 'мафа',
 				'mag' => 'магахи',
 				'mai' => 'маитхили',
 				'mak' => 'макасарски',
 				'man' => 'мандинго',
 				'mas' => 'масаи',
 				'mde' => 'маба',
 				'mdf' => 'мокша',
 				'mdr' => 'мандар',
 				'men' => 'мендески',
 				'mer' => 'меру',
 				'mfe' => 'морисјен',
 				'mg' => 'малгашки',
 				'mga' => 'средноирски',
 				'mgh' => 'макува-мито',
 				'mgo' => 'мета',
 				'mh' => 'маршалски',
 				'mi' => 'маорски',
 				'mic' => 'микмек',
 				'min' => 'минанкабау',
 				'mk' => 'македонски',
 				'ml' => 'малајалам',
 				'mn' => 'монголски',
 				'mnc' => 'манчу',
 				'mni' => 'манипури',
 				'moh' => 'мохак',
 				'mos' => 'моси',
 				'mr' => 'марати',
 				'ms' => 'малезиски',
 				'mt' => 'малтешки',
 				'mua' => 'мунданг',
 				'mul' => 'повеќе јазици',
 				'mus' => 'крик',
 				'mwl' => 'мирандески',
 				'mwr' => 'марвари',
 				'my' => 'бурмански',
 				'mye' => 'мјене',
 				'myv' => 'ержа',
 				'na' => 'науру',
 				'nap' => 'неаполски',
 				'naq' => 'нама',
 				'nb' => 'норвешки букмол',
 				'nd' => 'северен ндебеле',
 				'nds' => 'долногермански',
 				'ne' => 'непалски',
 				'new' => 'невари',
 				'ng' => 'ндонга',
 				'nia' => 'нијас',
 				'niu' => 'најуан',
 				'nl' => 'холандски',
 				'nl_BE' => 'холандски (во Белгија)',
 				'nmg' => 'квазио',
 				'nn' => 'норвешки нинорск',
 				'nnh' => 'нгиембун',
 				'no' => 'норвешки',
 				'nog' => 'ногај',
 				'non' => 'стар норски',
 				'nqo' => 'нко',
 				'nr' => 'јужен ндебелески',
 				'nso' => 'северен сото',
 				'nus' => 'нуер',
 				'nv' => 'навахо',
 				'nwc' => 'класичен невари',
 				'ny' => 'њања',
 				'nym' => 'њамвези',
 				'nyn' => 'њанколе',
 				'nyo' => 'њоро',
 				'nzi' => 'нзима',
 				'oc' => 'окситански',
 				'oj' => 'оџибва',
 				'om' => 'оромо',
 				'or' => 'орија',
 				'os' => 'осетиски',
 				'osa' => 'осаж',
 				'ota' => 'отомански турски',
 				'pa' => 'панџаби',
 				'pag' => 'пангасинан',
 				'pal' => 'палависки',
 				'pam' => 'пампанга',
 				'pap' => 'папиаменто',
 				'pau' => 'палауански',
 				'peo' => 'стар персиски',
 				'phn' => 'феникиски',
 				'pi' => 'пали',
 				'pl' => 'полски',
 				'pon' => 'понпејански',
 				'pro' => 'стар провенчал',
 				'ps' => 'паштунски',
 				'pt' => 'португалски',
 				'pt_BR' => 'португалски (во Бразил)',
 				'pt_PT' => 'португалски (во Европа)',
 				'qu' => 'кечуански',
 				'raj' => 'раџастански',
 				'rap' => 'рапануи',
 				'rar' => 'раротонган',
 				'rm' => 'реторомански',
 				'rn' => 'рундиски',
 				'ro' => 'романски',
 				'ro_MD' => 'молдавски',
 				'rof' => 'ромбо',
 				'rom' => 'ромски',
 				'root' => 'рутски',
 				'ru' => 'руски',
 				'rup' => 'влашки',
 				'rw' => 'кињарванда',
 				'rwk' => 'руа',
 				'sa' => 'санскрит',
 				'sad' => 'сандаве',
 				'sah' => 'јакутски',
 				'sam' => 'самариќански арамејски',
 				'saq' => 'самбуру',
 				'sas' => 'сасак',
 				'sat' => 'сантали',
 				'sba' => 'нгембеј',
 				'sbp' => 'сангу',
 				'sc' => 'сардиниски',
 				'scn' => 'сицилијански',
 				'sco' => 'скоц',
 				'sd' => 'синди',
 				'se' => 'северен самиски',
 				'see' => 'сенека',
 				'seh' => 'сена',
 				'sel' => 'селкап',
 				'ses' => 'којраборо сени',
 				'sg' => 'санго',
 				'sga' => 'стар ирски',
 				'sh' => 'српско-хрватски',
 				'shi' => 'тачелхит',
 				'shn' => 'шан',
 				'shu' => 'чадски арапски',
 				'si' => 'синхалски',
 				'sid' => 'сидамо',
 				'sk' => 'словачки',
 				'sl' => 'словенечки',
 				'sm' => 'самоански',
 				'sma' => 'јужен сами',
 				'smj' => 'луле сами',
 				'smn' => 'инари сами',
 				'sms' => 'сколт сами',
 				'sn' => 'шона',
 				'snk' => 'сонинке',
 				'so' => 'сомалиски',
 				'sog' => 'согдијен',
 				'sq' => 'албански',
 				'sr' => 'српски',
 				'srn' => 'срански тонго',
 				'srr' => 'серер',
 				'ss' => 'свати',
 				'ssy' => 'сахо',
 				'st' => 'сесото',
 				'su' => 'сундски',
 				'suk' => 'сукума',
 				'sus' => 'сусу',
 				'sux' => 'сумериски',
 				'sv' => 'шведски',
 				'sw' => 'свахили',
 				'swb' => 'коморијански',
 				'swc' => 'конго свахили',
 				'syc' => 'класичен сиријак',
 				'syr' => 'сиријак',
 				'ta' => 'тамилски',
 				'te' => 'телугу',
 				'tem' => 'тимне',
 				'teo' => 'тесо',
 				'ter' => 'терено',
 				'tet' => 'тетум',
 				'tg' => 'таџикистански',
 				'th' => 'тајландски',
 				'ti' => 'тигриња',
 				'tig' => 'тигре',
 				'tiv' => 'тив',
 				'tk' => 'туркменски',
 				'tkl' => 'токелау',
 				'tl' => 'тагалог',
 				'tlh' => 'клингонски',
 				'tli' => 'тлингит',
 				'tmh' => 'тамашек',
 				'tn' => 'цвана',
 				'to' => 'тонгански',
 				'tog' => 'њаса тонга',
 				'tpi' => 'ток писин',
 				'tr' => 'турски',
 				'trv' => 'тароко',
 				'ts' => 'цонга',
 				'tsi' => 'цимшијански',
 				'tt' => 'татарски',
 				'tum' => 'тумбука',
 				'tvl' => 'тувалу',
 				'tw' => 'тви',
 				'twq' => 'тазавак',
 				'ty' => 'тахитски',
 				'tyv' => 'тувинијански',
 				'tzm' => 'централно марокански тамазитски',
 				'udm' => 'удмурт',
 				'ug' => 'ујгурски',
 				'uga' => 'угаритски',
 				'uk' => 'украински',
 				'umb' => 'умбунду',
 				'und' => 'непознат јазик',
 				'ur' => 'урду',
 				'uz' => 'узбекистански',
 				'vai' => 'ваи',
 				've' => 'венда',
 				'vi' => 'виетнамски',
 				'vo' => 'волапјок',
 				'vot' => 'вотски',
 				'vun' => 'вунџо',
 				'wa' => 'валунски',
 				'wae' => 'валсер',
 				'wal' => 'валамо',
 				'war' => 'вареј',
 				'was' => 'вашо',
 				'wo' => 'волофски',
 				'xal' => 'калмик',
 				'xh' => 'коса',
 				'xog' => 'сога',
 				'yao' => 'јао',
 				'yap' => 'јапезе',
 				'yav' => 'јенгбен',
 				'ybb' => 'јемба',
 				'yi' => 'јидски',
 				'yo' => 'јорупски',
 				'yue' => 'кантонски',
 				'za' => 'жуанг',
 				'zap' => 'запотек',
 				'zbl' => 'блисимболс',
 				'zen' => 'зенага',
 				'zgh' => 'стандарден марокански тамазигтски',
 				'zh' => 'кинески',
 				'zh_Hans' => 'поедноставен кинески',
 				'zh_Hant' => 'традиционален кинески',
 				'zu' => 'зулу',
 				'zun' => 'зуни',
 				'zxx' => 'без лингвистичка содржина',
 				'zza' => 'заза',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Arab' => 'арапско писмо',
 			'Armn' => 'ерменско писмо',
 			'Beng' => 'бенгалско писмо',
 			'Bopo' => 'бопомофо',
 			'Brai' => 'брајово писмо',
 			'Cyrl' => 'кирилско писмо',
 			'Deva' => 'деванагари',
 			'Ethi' => 'етиопско писмо',
 			'Geor' => 'грузиско писмо',
 			'Grek' => 'грчко писмо',
 			'Gujr' => 'гуџарати',
 			'Guru' => 'гурмуки',
 			'Hang' => 'хангул',
 			'Hani' => 'ханско писмо',
 			'Hans' => 'поедноставено',
 			'Hans@alt=stand-alone' => 'поедноставено ханско писмо',
 			'Hant' => 'традиционално',
 			'Hant@alt=stand-alone' => 'традиционално ханско писмо',
 			'Hebr' => 'хебрејско писмо',
 			'Hira' => 'хирагана',
 			'Jpan' => 'јапонско писмо',
 			'Kana' => 'катакана',
 			'Khmr' => 'кмерско писмо',
 			'Knda' => 'каннада',
 			'Kore' => 'корејско писмо',
 			'Laoo' => 'лаошко писмо',
 			'Latn' => 'латинично писмо',
 			'Mlym' => 'малајаламско писмо',
 			'Mong' => 'монголско писмо',
 			'Mymr' => 'мјанмарско писмо',
 			'Orya' => 'оријанско писмо',
 			'Sinh' => 'синхалско писмо',
 			'Taml' => 'тамилско писмо',
 			'Telu' => 'телугу',
 			'Thaa' => 'тана',
 			'Thai' => 'тајландско писмо',
 			'Tibt' => 'тибетско писмо',
 			'Zsym' => 'симболи',
 			'Zxxx' => 'без писмо',
 			'Zyyy' => 'општо',
 			'Zzzz' => 'непознато писмо',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_territory' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'001' => 'Свет',
 			'002' => 'Африка',
 			'003' => 'Северна Америка',
 			'005' => 'Јужна Америка',
 			'009' => 'Океанија',
 			'011' => 'Западна Африка',
 			'013' => 'Централна Америка',
 			'014' => 'Источна Африка',
 			'015' => 'Северна Африка',
 			'017' => 'Средна Африка',
 			'018' => 'Јужна Африка',
 			'019' => 'Америки',
 			'021' => 'Северна континентална Америка',
 			'029' => 'Кариби',
 			'030' => 'Источна Азија',
 			'034' => 'Јужна Азија',
 			'035' => 'Југоисточна Азија',
 			'039' => 'Јужна Европа',
 			'053' => 'Австралазија',
 			'054' => 'Меланезија',
 			'057' => 'Микронезиски регион',
 			'061' => 'Полинезија',
 			'142' => 'Азија',
 			'143' => 'Централна Азија',
 			'145' => 'Западна Азија',
 			'150' => 'Европа',
 			'151' => 'Источна Европа',
 			'154' => 'Северна Европа',
 			'155' => 'Западна Европа',
 			'419' => 'Латинска Америка',
 			'AC' => 'Остров Асенсион',
 			'AD' => 'Андора',
 			'AE' => 'Обединети Арапски Емирати',
 			'AF' => 'Авганистан',
 			'AG' => 'Антигва и Барбуда',
 			'AI' => 'Ангвила',
 			'AL' => 'Албанија',
 			'AM' => 'Ерменија',
 			'AN' => 'Холандски Антили',
 			'AO' => 'Ангола',
 			'AQ' => 'Антарктик',
 			'AR' => 'Аргентина',
 			'AS' => 'Американска Самоа',
 			'AT' => 'Австрија',
 			'AU' => 'Австралија',
 			'AW' => 'Аруба',
 			'AX' => 'Оландски острови',
 			'AZ' => 'Азербејџан',
 			'BA' => 'Босна и Херцеговина',
 			'BB' => 'Барбадос',
 			'BD' => 'Бангладеш',
 			'BE' => 'Белгија',
 			'BF' => 'Буркина Фасо',
 			'BG' => 'Бугарија',
 			'BH' => 'Бахреин',
 			'BI' => 'Бурунди',
 			'BJ' => 'Бенин',
 			'BL' => 'Сент Бартоломеј',
 			'BM' => 'Бермуди',
 			'BN' => 'Брунеј',
 			'BO' => 'Боливија',
 			'BQ' => 'Карипска Холандија',
 			'BR' => 'Бразил',
 			'BS' => 'Бахами',
 			'BT' => 'Бутан',
 			'BV' => 'Остров Буве',
 			'BW' => 'Боцвана',
 			'BY' => 'Белорусија',
 			'BZ' => 'Белизе',
 			'CA' => 'Канада',
 			'CC' => 'Кокосови (Килиншки) Острови',
 			'CD' => 'Конго - Киншаса',
 			'CD@alt=variant' => 'Конго (Демократска Република Конго)',
 			'CF' => 'Централноафриканска Република',
 			'CG' => 'Конго - Бразавил',
 			'CG@alt=variant' => 'Конго (Република)',
 			'CH' => 'Швајцарија',
 			'CI' => 'Брегот на Слоновата Коска',
 			'CI@alt=variant' => 'Брег на Слонова Коска',
 			'CK' => 'Кукови Острови',
 			'CL' => 'Чиле',
 			'CM' => 'Камерун',
 			'CN' => 'Кина',
 			'CO' => 'Колумбија',
 			'CP' => 'Остров Клипертон',
 			'CR' => 'Костарика',
 			'CU' => 'Куба',
 			'CV' => 'Зелен ’Рт',
 			'CW' => 'Курасао',
 			'CX' => 'Божиќен Остров',
 			'CY' => 'Кипар',
 			'CZ' => 'Република Чешка',
 			'DE' => 'Германија',
 			'DG' => 'Диего Гарсија',
 			'DJ' => 'Џибути',
 			'DK' => 'Данска',
 			'DM' => 'Доминика',
 			'DO' => 'Доминиканска Република',
 			'DZ' => 'Алжир',
 			'EA' => 'Сеута и Мелиља',
 			'EC' => 'Еквадор',
 			'EE' => 'Естонија',
 			'EG' => 'Египет',
 			'EH' => 'Западна Сахара',
 			'ER' => 'Еритреја',
 			'ES' => 'Шпанија',
 			'ET' => 'Етиопија',
 			'EU' => 'Европска унија',
 			'FI' => 'Финска',
 			'FJ' => 'Фиџи',
 			'FK' => 'Фолкландски Острови',
 			'FK@alt=variant' => 'Фолкландски Острови (Малвински Острови)',
 			'FM' => 'Микронезија',
 			'FO' => 'Фарски Острови',
 			'FR' => 'Франција',
 			'GA' => 'Габон',
 			'GB' => 'Обединето Кралство',
 			'GB@alt=short' => 'ОК',
 			'GD' => 'Гренада',
 			'GE' => 'Грузија',
 			'GF' => 'Француска Гвајана',
 			'GG' => 'Гернзи',
 			'GH' => 'Гана',
 			'GI' => 'Гибралтар',
 			'GL' => 'Гренланд',
 			'GM' => 'Гамбија',
 			'GN' => 'Гвинеја',
 			'GP' => 'Гвадалупе',
 			'GQ' => 'Екваторска Гвинеја',
 			'GR' => 'Грција',
 			'GS' => 'Јужна Грузија и Јужни Сендвич Острови',
 			'GT' => 'Гватемала',
 			'GU' => 'Гвам',
 			'GW' => 'Гвинеја-Бисау',
 			'GY' => 'Гвајана',
 			'HK' => 'Хонг Конг С.А.Р Кина',
 			'HK@alt=short' => 'Хонг Конг',
 			'HM' => 'Остров Херд и Острови Макдоналд',
 			'HN' => 'Хондурас',
 			'HR' => 'Хрватска',
 			'HT' => 'Хаити',
 			'HU' => 'Унгарија',
 			'IC' => 'Канарски острови',
 			'ID' => 'Индонезија',
 			'IE' => 'Ирска',
 			'IL' => 'Израел',
 			'IM' => 'Остров Ман',
 			'IN' => 'Индија',
 			'IO' => 'Британска Индоокеанска Територија',
 			'IQ' => 'Ирак',
 			'IR' => 'Иран',
 			'IS' => 'Исланд',
 			'IT' => 'Италија',
 			'JE' => 'Џерси',
 			'JM' => 'Јамајка',
 			'JO' => 'Јордан',
 			'JP' => 'Јапонија',
 			'KE' => 'Кенија',
 			'KG' => 'Киргистан',
 			'KH' => 'Камбоџа',
 			'KI' => 'Кирибати',
 			'KM' => 'Коморски Острови',
 			'KN' => 'Сент Кристофер и Невис',
 			'KP' => 'Северна Кореја',
 			'KR' => 'Јужна Кореја',
 			'KW' => 'Кувајт',
 			'KY' => 'Кајмански Острови',
 			'KZ' => 'Казахстан',
 			'LA' => 'Лаос',
 			'LB' => 'Либан',
 			'LC' => 'Света Луција',
 			'LI' => 'Лихтенштајн',
 			'LK' => 'Шри Ланка',
 			'LR' => 'Либерија',
 			'LS' => 'Лесото',
 			'LT' => 'Литванија',
 			'LU' => 'Луксембург',
 			'LV' => 'Латвија',
 			'LY' => 'Либија',
 			'MA' => 'Мароко',
 			'MC' => 'Монако',
 			'MD' => 'Молдавија',
 			'ME' => 'Црна Гора',
 			'MF' => 'Сент Мартин',
 			'MG' => 'Мадагаскар',
 			'MH' => 'Маршалски Острови',
 			'MK' => 'Македонија',
 			'MK@alt=variant' => 'Република Македонија',
 			'ML' => 'Мали',
 			'MM' => 'Мјанмар (Бурма)',
 			'MN' => 'Монголија',
 			'MO' => 'Макао С.А.Р Кина',
 			'MO@alt=short' => 'Макао',
 			'MP' => 'Северни Маријански Острови',
 			'MQ' => 'Мартиник',
 			'MR' => 'Мавританија',
 			'MS' => 'Монсерат',
 			'MT' => 'Малта',
 			'MU' => 'Маврициус',
 			'MV' => 'Малдиви',
 			'MW' => 'Малави',
 			'MX' => 'Мексико',
 			'MY' => 'Малезија',
 			'MZ' => 'Мозамбик',
 			'NA' => 'Намибија',
 			'NC' => 'Нова Каледонија',
 			'NE' => 'Нигер',
 			'NF' => 'Норфолшки Остров',
 			'NG' => 'Нигерија',
 			'NI' => 'Никарагва',
 			'NL' => 'Холандија',
 			'NO' => 'Норвешка',
 			'NP' => 'Непал',
 			'NR' => 'Науру',
 			'NU' => 'Нијуе',
 			'NZ' => 'Нов Зеланд',
 			'OM' => 'Оман',
 			'PA' => 'Панама',
 			'PE' => 'Перу',
 			'PF' => 'Француска Полинезија',
 			'PG' => 'Папуа Нова Гвинеја',
 			'PH' => 'Филипини',
 			'PK' => 'Пакистан',
 			'PL' => 'Полска',
 			'PM' => 'Сент Пјер и Микелан',
 			'PN' => 'Питкернски Острови',
 			'PR' => 'Порторико',
 			'PS' => 'Палестински територии',
 			'PS@alt=short' => 'Палестина',
 			'PT' => 'Португалија',
 			'PW' => 'Палау',
 			'PY' => 'Парагвај',
 			'QA' => 'Катар',
 			'QO' => 'Зависни земји во Океанија',
 			'RE' => 'Ријунион',
 			'RO' => 'Романија',
 			'RS' => 'Србија',
 			'RU' => 'Русија',
 			'RW' => 'Руанда',
 			'SA' => 'Саудиска Арабија',
 			'SB' => 'Соломонски Острови',
 			'SC' => 'Сејшели',
 			'SD' => 'Судан',
 			'SE' => 'Шведска',
 			'SG' => 'Сингапур',
 			'SH' => 'Света Елена',
 			'SI' => 'Словенија',
 			'SJ' => 'Свалбард и Жан Мејен',
 			'SK' => 'Словачка',
 			'SL' => 'Сиера Леоне',
 			'SM' => 'Сан Марино',
 			'SN' => 'Сенегал',
 			'SO' => 'Сомалија',
 			'SR' => 'Суринам',
 			'SS' => 'Јужен Судан',
 			'ST' => 'Сао Томе и Принсипе',
 			'SV' => 'Ел Салвадор',
 			'SX' => 'Свети Мартин',
 			'SY' => 'Сирија',
 			'SZ' => 'Свазиленд',
 			'TA' => 'Тристан да Куња',
 			'TC' => 'Острови Туркс и Кајкос',
 			'TD' => 'Чад',
 			'TF' => 'Француски Јужни територии',
 			'TG' => 'Того',
 			'TH' => 'Тајланд',
 			'TJ' => 'Таџикистан',
 			'TK' => 'Токелау',
 			'TL' => 'Источен Тимор (Тимор Лесте)',
 			'TL@alt=variant' => 'Источен Тимор',
 			'TM' => 'Туркменистан',
 			'TN' => 'Тунис',
 			'TO' => 'Тонга',
 			'TR' => 'Турција',
 			'TT' => 'Тринидад и Тобаго',
 			'TV' => 'Тувалу',
 			'TW' => 'Тајван',
 			'TZ' => 'Танзанија',
 			'UA' => 'Украина',
 			'UG' => 'Уганда',
 			'UM' => 'Американски територии во Пацификот',
 			'US' => 'Соединети Американски Држави',
 			'US@alt=short' => 'САД',
 			'UY' => 'Уругвај',
 			'UZ' => 'Узбекистан',
 			'VA' => 'Ватикан',
 			'VC' => 'Сент Винсент и Гренадините',
 			'VE' => 'Венецуела',
 			'VG' => 'Британски Девствени Острови',
 			'VI' => 'Американски Девствени Острови',
 			'VN' => 'Виетнам',
 			'VU' => 'Вануату',
 			'WF' => 'Волис и Футуна',
 			'WS' => 'Самоа',
 			'XK' => 'Косово',
 			'YE' => 'Јемен',
 			'YT' => 'Мајот',
 			'ZA' => 'Јужноафриканска Република',
 			'ZM' => 'Замбија',
 			'ZW' => 'Зимбабве',
 			'ZZ' => 'Непознат регион',

		}
	},
);

has 'display_name_variant' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'PINYIN' => 'Пинјин романизација',
 			'WADEGILE' => 'Вејд-Џајлс романизација',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'calendar' => 'Календар',
 			'collation' => 'Сортирање',
 			'currency' => 'Валута',
 			'numbers' => 'Броеви',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[Str]]',
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{Будистички календар},
 				'chinese' => q{Кинески календар},
 				'coptic' => q{Коптски календар},
 				'ethiopic' => q{Етиопски календар},
 				'ethiopic-amete-alem' => q{Етиопски Амет Алем календар},
 				'gregorian' => q{Грегоријански календар},
 				'hebrew' => q{Еврејски календар},
 				'indian' => q{Индијски национален календар},
 				'islamic' => q{Исламски календар},
 				'islamic-civil' => q{Исламски граѓански календар},
 				'japanese' => q{Јапонски календар},
 				'roc' => q{Календар на Република Кина},
 			},
 			'collation' => {
 				'big5han' => q{Традиционално кинеско сортирање},
 				'ducet' => q{Стандардно сортирање во уникод},
 				'gb2312han' => q{Поедноставено кинеско сортирање},
 				'phonebook' => q{Азбучен редослед},
 				'pinyin' => q{Сортирање Pinyin},
 				'search' => q{Општо пребарување},
 				'standard' => q{Стандардно сортирање},
 				'stroke' => q{Ритмички редослед},
 				'traditional' => q{Традиционално сортирање},
 			},
 			'numbers' => {
 				'arab' => q{Арапски-индиски цифри},
 				'arabext' => q{Проширени арапско-индиски цифри},
 				'armn' => q{Ерменски броеви},
 				'armnlow' => q{Ерменски мали броеви},
 				'beng' => q{Бенгалски цифри},
 				'deva' => q{Деванагари цифри},
 				'ethi' => q{Етиопски броеви},
 				'fullwide' => q{Цифри со целосна ширина},
 				'geor' => q{Грузиски броеви},
 				'grek' => q{Грчки броеви},
 				'greklow' => q{Грчки мали броеви},
 				'gujr' => q{Гуџарати цифри},
 				'guru' => q{Гурмуки цифри},
 				'hanidec' => q{Кинески децимални броеви},
 				'hans' => q{Поедноставени кинески броеви},
 				'hansfin' => q{Поедноставени кинески финансиски броеви},
 				'hant' => q{Традиционални кинески броеви},
 				'hantfin' => q{Традиционални кинески финансиски броеви},
 				'hebr' => q{Хебрејски броеви},
 				'jpan' => q{Јапонски броеви},
 				'jpanfin' => q{Јапонски финансиски броеви},
 				'khmr' => q{Кмерски цифри},
 				'knda' => q{Канада цифри},
 				'laoo' => q{Лаошки цифри},
 				'latn' => q{Арапски броеви},
 				'mlym' => q{Малајаламски цифри},
 				'mymr' => q{Мјанмарски цифри},
 				'orya' => q{Оријски цифри},
 				'roman' => q{Римски броеви},
 				'romanlow' => q{Римски мали броеви},
 				'taml' => q{Традиционални тамилски броеви},
 				'tamldec' => q{Тамилски цифри},
 				'telu' => q{Телугу цифри},
 				'thai' => q{Тајландски цифри},
 				'tibt' => q{Тибетски цифри},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'metric' => q{метрички},
 			'UK' => q{британски},
 			'US' => q{американски},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'language' => 'Јазик: {0}',
 			'script' => 'Писмо: {0}',
 			'territory' => 'Регион: {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{(?^u:[ѐ ѝ])},
			index => ['А', 'Б', 'В', 'Г', 'Д', 'Ѓ', 'Е', 'Ж', 'З', 'Ѕ', 'И', 'Ј', 'К', 'Л', 'Љ', 'М', 'Н', 'Њ', 'О', 'П', 'Р', 'С', 'Т', 'Ќ', 'У', 'Ф', 'Х', 'Ц', 'Ч', 'Џ', 'Ш'],
			main => qr{(?^u:[а б в г д ѓ е ж з ѕ и ј к л љ м н њ о п р с т ќ у ф х ц ч џ ш])},
			punctuation => qr{(?^u:[\- ‐ – — , ; \: ! ? . … ‘ ‚ “ „ ( ) \[ \] \{ \}])},
		};
	},
);

has 'ellipsis' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub {
		return {
			'final' => '{0}…',
			'initial' => '…{0}',
			'medial' => '{0}…{1}',
			'word-final' => '{0}…',
			'word-initial' => '…{0}',
			'word-medial' => '{0}… {1}',
		};
	},
);

has 'more_information' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{?},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{„},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{“},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{‚},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{‘},
);

has 'duration_units' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { {
				hm => 'h:mm',
				hms => 'h:mm:ss',
				ms => 'm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[HashRef[Str]]]',
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					'acre' => {
						'one' => q({0} акр),
						'other' => q({0} акри),
					},
					'arc-minute' => {
						'one' => q({0} минута),
						'other' => q({0} минути),
					},
					'arc-second' => {
						'one' => q({0} секунда),
						'other' => q({0} секунди),
					},
					'celsius' => {
						'one' => q({0} целзиусов степен),
						'other' => q({0} целзиусови степени),
					},
					'centimeter' => {
						'one' => q({0} сантиметар),
						'other' => q({0} сантиметри),
					},
					'cubic-kilometer' => {
						'one' => q({0} кубен километар),
						'other' => q({0} кубни километри),
					},
					'cubic-mile' => {
						'one' => q({0} кубна милја),
						'other' => q({0} кубни милји),
					},
					'day' => {
						'one' => q({0} ден),
						'other' => q({0} дена),
					},
					'degree' => {
						'one' => q({0} степен),
						'other' => q({0} степени),
					},
					'fahrenheit' => {
						'one' => q({0} фаренхајтов степен),
						'other' => q({0} фаренхајтови степени),
					},
					'foot' => {
						'one' => q({0} стапка),
						'other' => q({0} стапки),
					},
					'g-force' => {
						'one' => q({0} гравитациска сила),
						'other' => q({0} гравитациска сила),
					},
					'gram' => {
						'one' => q({0} грам),
						'other' => q({0} грама),
					},
					'hectare' => {
						'one' => q({0} хектар),
						'other' => q({0} хектари),
					},
					'hectopascal' => {
						'one' => q({0} хектопаскал),
						'other' => q({0} хектопаскали),
					},
					'horsepower' => {
						'one' => q({0} коњска сила),
						'other' => q({0} коњски сили),
					},
					'hour' => {
						'one' => q({0} час),
						'other' => q({0} часа),
					},
					'inch' => {
						'one' => q({0} инч),
						'other' => q({0} инчи),
					},
					'inch-hg' => {
						'one' => q({0} инч жива),
						'other' => q({0} инчи жива),
					},
					'kilogram' => {
						'one' => q({0} килограм),
						'other' => q({0} килограми),
					},
					'kilometer' => {
						'one' => q({0} километар),
						'other' => q({0} километри),
					},
					'kilometer-per-hour' => {
						'one' => q({0} километар на час),
						'other' => q({0} километри на час),
					},
					'kilowatt' => {
						'one' => q({0} киловат),
						'other' => q({0} киловати),
					},
					'light-year' => {
						'one' => q({0} светлосна година),
						'other' => q({0} светлосни години),
					},
					'liter' => {
						'one' => q({0} литар),
						'other' => q({0} литри),
					},
					'meter' => {
						'one' => q({0} метар),
						'other' => q({0} метри),
					},
					'meter-per-second' => {
						'one' => q({0} метар во секунда),
						'other' => q({0} метри во секунда),
					},
					'mile' => {
						'one' => q({0} милја),
						'other' => q({0} милји),
					},
					'mile-per-hour' => {
						'one' => q({0} милја на час),
						'other' => q({0} милји на час),
					},
					'millibar' => {
						'one' => q({0} милибар),
						'other' => q({0} милибари),
					},
					'millimeter' => {
						'one' => q({0} милиметар),
						'other' => q({0} милиметри),
					},
					'millisecond' => {
						'one' => q({0} милисекунда),
						'other' => q({0} милисекунди),
					},
					'minute' => {
						'one' => q({0} минута),
						'other' => q({0} минути),
					},
					'month' => {
						'one' => q({0} месец),
						'other' => q({0} месеци),
					},
					'ounce' => {
						'one' => q({0} унца),
						'other' => q({0} унци),
					},
					'per' => {
						'' => q({0} на {1}),
					},
					'picometer' => {
						'one' => q({0} пикометар),
						'other' => q({0} пикометри),
					},
					'pound' => {
						'one' => q({0} фунта),
						'other' => q({0} фунти),
					},
					'second' => {
						'one' => q({0} секунда),
						'other' => q({0} секунди),
					},
					'square-foot' => {
						'one' => q({0} квадратна стапка),
						'other' => q({0} квадратни стапки),
					},
					'square-kilometer' => {
						'one' => q({0} квадратен километар),
						'other' => q({0} квадратни километри),
					},
					'square-meter' => {
						'one' => q({0} квадратен метар),
						'other' => q({0} квадратни метри),
					},
					'square-mile' => {
						'one' => q({0} квадратна милја),
						'other' => q({0} квадратни милји),
					},
					'watt' => {
						'one' => q({0} ват),
						'other' => q({0} вати),
					},
					'week' => {
						'one' => q({0} седмица),
						'other' => q({0} седмици),
					},
					'yard' => {
						'one' => q({0} јард),
						'other' => q({0} јарди),
					},
					'year' => {
						'one' => q({0} година),
						'other' => q({0} години),
					},
				},
				'narrow' => {
					'acre' => {
						'one' => q({0} акр),
						'other' => q({0} акри),
					},
					'arc-minute' => {
						'one' => q({0}′),
						'other' => q({0}′),
					},
					'arc-second' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					'celsius' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'centimeter' => {
						'one' => q({0} см),
						'other' => q({0} см),
					},
					'cubic-kilometer' => {
						'one' => q({0} км³),
						'other' => q({0} км³),
					},
					'cubic-mile' => {
						'one' => q({0} ми³),
						'other' => q({0} ми³),
					},
					'day' => {
						'one' => q({0} ден),
						'other' => q({0} дена),
					},
					'degree' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'fahrenheit' => {
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					'foot' => {
						'one' => q({0} ст),
						'other' => q({0} ст),
					},
					'g-force' => {
						'one' => q({0} G),
						'other' => q({0} G),
					},
					'gram' => {
						'one' => q({0} г),
						'other' => q({0} г),
					},
					'hectare' => {
						'one' => q({0} ха),
						'other' => q({0} ха),
					},
					'hectopascal' => {
						'one' => q({0} hPa),
						'other' => q({0} hPa),
					},
					'horsepower' => {
						'one' => q({0} кс),
						'other' => q({0} кс),
					},
					'hour' => {
						'one' => q({0} час),
						'other' => q({0} часа),
					},
					'inch' => {
						'one' => q({0} инч),
						'other' => q({0} инчи),
					},
					'inch-hg' => {
						'one' => q({0} inHg),
						'other' => q({0} inHg),
					},
					'kilogram' => {
						'one' => q({0} кг),
						'other' => q({0} кг),
					},
					'kilometer' => {
						'one' => q({0} км),
						'other' => q({0} км),
					},
					'kilometer-per-hour' => {
						'one' => q({0} к/ч),
						'other' => q({0} к/ч),
					},
					'kilowatt' => {
						'one' => q({0} kW),
						'other' => q({0} kW),
					},
					'light-year' => {
						'one' => q({0} сг),
						'other' => q({0} сг),
					},
					'liter' => {
						'one' => q({0} л),
						'other' => q({0} л),
					},
					'meter' => {
						'one' => q({0} м),
						'other' => q({0} м),
					},
					'meter-per-second' => {
						'one' => q({0} м/с),
						'other' => q({0} м/с),
					},
					'mile' => {
						'one' => q({0} ми),
						'other' => q({0} ми),
					},
					'mile-per-hour' => {
						'one' => q({0} ми/ч),
						'other' => q({0} ми/ч),
					},
					'millibar' => {
						'one' => q({0} мб),
						'other' => q({0} мб),
					},
					'millimeter' => {
						'one' => q({0} мм),
						'other' => q({0} мм),
					},
					'millisecond' => {
						'one' => q({0} мс),
						'other' => q({0} мс),
					},
					'minute' => {
						'one' => q({0} мин.),
						'other' => q({0} мин.),
					},
					'month' => {
						'one' => q({0} мес.),
						'other' => q({0} мес.),
					},
					'ounce' => {
						'one' => q({0} унца),
						'other' => q({0} унци),
					},
					'per' => {
						'' => q({0}/{1}),
					},
					'picometer' => {
						'one' => q({0} пм),
						'other' => q({0} пм),
					},
					'pound' => {
						'one' => q({0} фунта),
						'other' => q({0} фунти),
					},
					'second' => {
						'one' => q({0} сек.),
						'other' => q({0} сек.),
					},
					'square-foot' => {
						'one' => q({0} ст²),
						'other' => q({0} ст²),
					},
					'square-kilometer' => {
						'one' => q({0} км²),
						'other' => q({0} км²),
					},
					'square-meter' => {
						'one' => q({0} м²),
						'other' => q({0} м²),
					},
					'square-mile' => {
						'one' => q({0} ми²),
						'other' => q({0} ми²),
					},
					'watt' => {
						'one' => q({0} ват),
						'other' => q({0} вати),
					},
					'week' => {
						'one' => q({0} сед.),
						'other' => q({0} сед.),
					},
					'yard' => {
						'one' => q({0} јард),
						'other' => q({0} јарди),
					},
					'year' => {
						'one' => q({0} год.),
						'other' => q({0} год.),
					},
				},
				'short' => {
					'acre' => {
						'one' => q({0} акр),
						'other' => q({0} акри),
					},
					'arc-minute' => {
						'one' => q({0} мин.),
						'other' => q({0} мин.),
					},
					'arc-second' => {
						'one' => q({0} сек),
						'other' => q({0} сек),
					},
					'celsius' => {
						'one' => q({0}°C),
						'other' => q({0}°C),
					},
					'centimeter' => {
						'one' => q({0} см),
						'other' => q({0} см),
					},
					'cubic-kilometer' => {
						'one' => q({0} км³),
						'other' => q({0} км³),
					},
					'cubic-mile' => {
						'one' => q({0} ми³),
						'other' => q({0} ми³),
					},
					'day' => {
						'one' => q({0} ден),
						'other' => q({0} дена),
					},
					'degree' => {
						'one' => q({0} степ.),
						'other' => q({0} степ.),
					},
					'fahrenheit' => {
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					'foot' => {
						'one' => q({0} ст),
						'other' => q({0} ст),
					},
					'g-force' => {
						'one' => q({0} G),
						'other' => q({0} G),
					},
					'gram' => {
						'one' => q({0} г),
						'other' => q({0} г),
					},
					'hectare' => {
						'one' => q({0} ха),
						'other' => q({0} ха),
					},
					'hectopascal' => {
						'one' => q({0} hPa),
						'other' => q({0} hPa),
					},
					'horsepower' => {
						'one' => q({0} кс),
						'other' => q({0} кс),
					},
					'hour' => {
						'one' => q({0} час),
						'other' => q({0} часа),
					},
					'inch' => {
						'one' => q({0} инч),
						'other' => q({0} инчи),
					},
					'inch-hg' => {
						'one' => q({0} inHg),
						'other' => q({0} inHg),
					},
					'kilogram' => {
						'one' => q({0} кг),
						'other' => q({0} кг),
					},
					'kilometer' => {
						'one' => q({0} км),
						'other' => q({0} км),
					},
					'kilometer-per-hour' => {
						'one' => q({0} к/ч),
						'other' => q({0} к/ч),
					},
					'kilowatt' => {
						'one' => q({0} kW),
						'other' => q({0} kW),
					},
					'light-year' => {
						'one' => q({0} сг),
						'other' => q({0} сг),
					},
					'liter' => {
						'one' => q({0} л),
						'other' => q({0} л),
					},
					'meter' => {
						'one' => q({0} м),
						'other' => q({0} м),
					},
					'meter-per-second' => {
						'one' => q({0} м/с),
						'other' => q({0} м/с),
					},
					'mile' => {
						'one' => q({0} ми),
						'other' => q({0} ми),
					},
					'mile-per-hour' => {
						'one' => q({0} ми/ч),
						'other' => q({0} ми/ч),
					},
					'millibar' => {
						'one' => q({0} мб),
						'other' => q({0} мб),
					},
					'millimeter' => {
						'one' => q({0} мм),
						'other' => q({0} мм),
					},
					'millisecond' => {
						'one' => q({0} мс),
						'other' => q({0} мс),
					},
					'minute' => {
						'one' => q({0} мин.),
						'other' => q({0} мин.),
					},
					'month' => {
						'one' => q({0} мес.),
						'other' => q({0} мес.),
					},
					'ounce' => {
						'one' => q({0} унца),
						'other' => q({0} унци),
					},
					'per' => {
						'' => q({0}/{1}),
					},
					'picometer' => {
						'one' => q({0} пм),
						'other' => q({0} пм),
					},
					'pound' => {
						'one' => q({0} фунта),
						'other' => q({0} фунти),
					},
					'second' => {
						'one' => q({0} сек.),
						'other' => q({0} сек.),
					},
					'square-foot' => {
						'one' => q({0} кв. стапка),
						'other' => q({0} кв. стапки),
					},
					'square-kilometer' => {
						'one' => q({0} км²),
						'other' => q({0} км²),
					},
					'square-meter' => {
						'one' => q({0} м²),
						'other' => q({0} м²),
					},
					'square-mile' => {
						'one' => q({0} кв. милја),
						'other' => q({0} кв. милји),
					},
					'watt' => {
						'one' => q({0} ват),
						'other' => q({0} вати),
					},
					'week' => {
						'one' => q({0} сед.),
						'other' => q({0} сед.),
					},
					'yard' => {
						'one' => q({0} јард),
						'other' => q({0} јарди),
					},
					'year' => {
						'one' => q({0} год.),
						'other' => q({0} год.),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:да|д|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:не|н|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
				start => q({0}, {1}),
				middle => q({0}, {1}),
				end => q({0} и {1}),
				2 => q({0} и {1}),
		} }
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'decimal' => q(,),
			'exponential' => q(E),
			'group' => q(.),
			'infinity' => q(∞),
			'list' => q(;),
			'minusSign' => q(-),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'0' => {
					'default' => '#,##0.###',
				},
				'1000' => {
					'one' => '0 илј'.'',
					'other' => '0 илј'.'',
				},
				'10000' => {
					'one' => '00 илј'.'',
					'other' => '00 илј'.'',
				},
				'100000' => {
					'one' => '000 илј'.'',
					'other' => '000 илј'.'',
				},
				'1000000' => {
					'one' => '0 мил'.'',
					'other' => '0 мил'.'',
				},
				'10000000' => {
					'one' => '00 мил'.'',
					'other' => '00 мил'.'',
				},
				'100000000' => {
					'one' => '000 мил'.'',
					'other' => '000 мил'.'',
				},
				'1000000000' => {
					'one' => '0 милј'.'',
					'other' => '0 милј'.'',
				},
				'10000000000' => {
					'one' => '00 милј'.'',
					'other' => '00 милј'.'',
				},
				'100000000000' => {
					'one' => '000 милј'.'',
					'other' => '000 милј'.'',
				},
				'1000000000000' => {
					'one' => '0 трил'.'',
					'other' => '0 трил'.'',
				},
				'10000000000000' => {
					'one' => '00 трил'.'',
					'other' => '00 трил'.'',
				},
				'100000000000000' => {
					'one' => '000 трил'.'',
					'other' => '000 трил'.'',
				},
			},
			'long' => {
				'1000' => {
					'one' => '0 илјада',
					'other' => '0 илјади',
				},
				'10000' => {
					'one' => '00 илјади',
					'other' => '00 илјади',
				},
				'100000' => {
					'one' => '000 илјади',
					'other' => '000 илјади',
				},
				'1000000' => {
					'one' => '0 милион',
					'other' => '0 милиони',
				},
				'10000000' => {
					'one' => '00 милиони',
					'other' => '00 милиони',
				},
				'100000000' => {
					'one' => '000 милиони',
					'other' => '000 милиони',
				},
				'1000000000' => {
					'one' => '0 милијарда',
					'other' => '0 милијарди',
				},
				'10000000000' => {
					'one' => '00 милијарди',
					'other' => '00 милијарди',
				},
				'100000000000' => {
					'one' => '000 милијарди',
					'other' => '000 милијарди',
				},
				'1000000000000' => {
					'one' => '0 трилиони',
					'other' => '0 трилиони',
				},
				'10000000000000' => {
					'one' => '00 трилиони',
					'other' => '00 трилиони',
				},
				'100000000000000' => {
					'one' => '000 трилиони',
					'other' => '000 трилиони',
				},
			},
			'short' => {
				'1000' => {
					'one' => '0 илј'.'',
					'other' => '0 илј'.'',
				},
				'10000' => {
					'one' => '00 илј'.'',
					'other' => '00 илј'.'',
				},
				'100000' => {
					'one' => '000 илј'.'',
					'other' => '000 илј'.'',
				},
				'1000000' => {
					'one' => '0 мил'.'',
					'other' => '0 мил'.'',
				},
				'10000000' => {
					'one' => '00 мил'.'',
					'other' => '00 мил'.'',
				},
				'100000000' => {
					'one' => '000 мил'.'',
					'other' => '000 мил'.'',
				},
				'1000000000' => {
					'one' => '0 милј'.'',
					'other' => '0 милј'.'',
				},
				'10000000000' => {
					'one' => '00 милј'.'',
					'other' => '00 милј'.'',
				},
				'100000000000' => {
					'one' => '000 милј'.'',
					'other' => '000 милј'.'',
				},
				'1000000000000' => {
					'one' => '0 трил'.'',
					'other' => '0 трил'.'',
				},
				'10000000000000' => {
					'one' => '00 трил'.'',
					'other' => '00 трил'.'',
				},
				'100000000000000' => {
					'one' => '000 трил'.'',
					'other' => '000 трил'.'',
				},
			},
		},
		percentFormat => {
			'default' => {
				'0' => {
					'default' => '#,##0%',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'0' => {
					'default' => '#E0',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'standard' => {
						'negative' => '¤ #,##0.00',
						'positive' => '¤ #,##0.00',
					},
				},
			},
		},
} },
);

has 'curriencies' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'ADP' => {
			display_name => {
				'currency' => q(Андорска Пезета),
			},
		},
		'AED' => {
			display_name => {
				'currency' => q(Обединети Арапски Емирати Дирхам),
				'one' => q(Обединети Арапски Емирати Дирхам),
				'other' => q(Обединети Арапски Емирати Дирхам),
			},
		},
		'AFA' => {
			display_name => {
				'currency' => q(Авгани \(1927–2002\)),
			},
		},
		'AFN' => {
			display_name => {
				'currency' => q(Авгани),
				'one' => q(Авгани),
				'other' => q(Авгани),
			},
		},
		'ALL' => {
			display_name => {
				'currency' => q(Албански Лек),
				'one' => q(Албански Лек),
				'other' => q(Албански Лек),
			},
		},
		'AMD' => {
			display_name => {
				'currency' => q(Ермениски Драм),
				'one' => q(Ермениски Драм),
				'other' => q(Ермениски Драм),
			},
		},
		'ANG' => {
			display_name => {
				'currency' => q(Холандски антилски гилдер),
				'one' => q(Холандски антилски гилдер),
				'other' => q(Холандски антилски гилдери),
			},
		},
		'AOA' => {
			display_name => {
				'currency' => q(Анголска Кванза),
				'one' => q(Анголска Кванза),
				'other' => q(Анголска Кванза),
			},
		},
		'AOK' => {
			display_name => {
				'currency' => q(Анголска Кванза \(1977–1990\)),
			},
		},
		'AON' => {
			display_name => {
				'currency' => q(Анголска нова Кванза \(1990–2000\)),
			},
		},
		'ARP' => {
			display_name => {
				'currency' => q(Аргентински Пезос \(1983–1985\)),
			},
		},
		'ARS' => {
			display_name => {
				'currency' => q(Аргентински Пезос),
				'one' => q(Аргентински пезоси),
				'other' => q(Аргентински пезоси),
			},
		},
		'ATS' => {
			display_name => {
				'currency' => q(Австралиски Шилинг),
			},
		},
		'AUD' => {
			symbol => 'AUD',
			display_name => {
				'currency' => q(Австралиски долар),
				'one' => q(Австралиски Долар),
				'other' => q(Австралиски Долар),
			},
		},
		'AWG' => {
			display_name => {
				'currency' => q(Арубиски флорин),
				'one' => q(Арубиски флорин),
				'other' => q(Арубиски флорин),
			},
		},
		'AZN' => {
			display_name => {
				'currency' => q(Азербејџански манат),
				'one' => q(Азербејџански манат),
				'other' => q(Азербејџански манати),
			},
		},
		'BAD' => {
			display_name => {
				'currency' => q(Босанско-Херцеговски Динар),
			},
		},
		'BAM' => {
			display_name => {
				'currency' => q(Босанско-Херцеговска конвертибилна марка),
				'one' => q(Босанско-Херцеговска конвертибилна марка),
				'other' => q(Босанско-Херцеговска конвертибилна марка),
			},
		},
		'BBD' => {
			display_name => {
				'currency' => q(Барбадоски долар),
				'one' => q(Барбадоски Долар),
				'other' => q(Барбадоски долари),
			},
		},
		'BDT' => {
			display_name => {
				'currency' => q(Бангладешка така),
				'one' => q(Бангладешка така),
				'other' => q(Бангладешки таки),
			},
		},
		'BEC' => {
			display_name => {
				'currency' => q(Белгиски Франк \(конвертибилен\)),
			},
		},
		'BEF' => {
			display_name => {
				'currency' => q(Белгиски Франк),
			},
		},
		'BEL' => {
			display_name => {
				'currency' => q(Белгиски Франк \(финансиски\)),
			},
		},
		'BGL' => {
			display_name => {
				'currency' => q(Бугарски цврст лев),
			},
		},
		'BGN' => {
			display_name => {
				'currency' => q(Бугарски лев),
				'one' => q(Бугарски нов лев),
				'other' => q(Бугарски нов лев),
			},
		},
		'BHD' => {
			display_name => {
				'currency' => q(Бахреински Динар),
				'one' => q(Бахреински Динар),
				'other' => q(Бахреински Динар),
			},
		},
		'BIF' => {
			display_name => {
				'currency' => q(Бурундиски Франк),
				'one' => q(Бурундиски Франк),
				'other' => q(Бурундиски Франк),
			},
		},
		'BMD' => {
			display_name => {
				'currency' => q(Бермудски долар),
				'one' => q(Бермудски долари),
				'other' => q(Бермудски долари),
			},
		},
		'BND' => {
			display_name => {
				'currency' => q(Брунејски долар),
				'one' => q(Брунејски долар),
				'other' => q(Брунејски долар),
			},
		},
		'BRL' => {
			symbol => 'R$',
			display_name => {
				'currency' => q(Бразилски реал),
				'one' => q(Бразилски реал),
				'other' => q(Бразилски реали),
			},
		},
		'BSD' => {
			display_name => {
				'currency' => q(Бахамски долар),
				'one' => q(Бахамски долари),
				'other' => q(Бахамски долари),
			},
		},
		'BTN' => {
			display_name => {
				'currency' => q(Бутански нгултрум),
				'one' => q(Бутански нгултрум),
				'other' => q(Бутански нгултруми),
			},
		},
		'BWP' => {
			display_name => {
				'currency' => q(Боцванска Пула),
				'one' => q(Боцванска Пула),
				'other' => q(Боцванска Пула),
			},
		},
		'BYB' => {
			display_name => {
				'currency' => q(Белоруска нова рубља \(1994–1999\)),
			},
		},
		'BYR' => {
			display_name => {
				'currency' => q(Белоруска рубља),
				'one' => q(Белоруска Рубља),
				'other' => q(Белоруска Рубља),
			},
		},
		'BZD' => {
			display_name => {
				'currency' => q(Белизиски Долар),
				'one' => q(Белизиски Долар),
				'other' => q(Белизиски Долар),
			},
		},
		'CAD' => {
			symbol => 'CA$',
			display_name => {
				'currency' => q(Канадски долар),
				'one' => q(Канадски долари),
				'other' => q(Канадски долари),
			},
		},
		'CDF' => {
			display_name => {
				'currency' => q(Конголски франк),
				'one' => q(Конголски франк),
				'other' => q(Конголски франци),
			},
		},
		'CHF' => {
			display_name => {
				'currency' => q(Швајцарски Франк),
				'one' => q(Швајцарски Франк),
				'other' => q(Швајцарски Франк),
			},
		},
		'CLP' => {
			display_name => {
				'currency' => q(Чилеански пезос),
				'one' => q(Чилеански пезос),
				'other' => q(Чилеански пезос),
			},
		},
		'CNY' => {
			symbol => 'CNY',
			display_name => {
				'currency' => q(Кинески јуан),
				'one' => q(Кинески јуан),
				'other' => q(Кинески јуани),
			},
		},
		'COP' => {
			display_name => {
				'currency' => q(Колумбиски Пезос),
				'one' => q(Колумбиски Пезос),
				'other' => q(Колумбиски Пезос),
			},
		},
		'CRC' => {
			display_name => {
				'currency' => q(Костарикански колон),
				'one' => q(Костарикански колони),
				'other' => q(Костарикански колони),
			},
		},
		'CSK' => {
			display_name => {
				'currency' => q(Чехословачка цврста корона),
			},
		},
		'CUC' => {
			display_name => {
				'currency' => q(Кубански пезос \(конвертибилен\)),
				'one' => q(Кубански пезос \(конвертибилен\)),
				'other' => q(Кубански пезос \(конвертибилен\)),
			},
		},
		'CUP' => {
			display_name => {
				'currency' => q(Кубански пезос),
				'one' => q(Кубански пезос),
				'other' => q(Кубански пезос),
			},
		},
		'CVE' => {
			display_name => {
				'currency' => q(Зелено'ртски ескудо),
				'one' => q(Зелено'ртски ескудо),
				'other' => q(Зелено'ртски ескуди),
			},
		},
		'CYP' => {
			display_name => {
				'currency' => q(Кипарска фунта),
			},
		},
		'CZK' => {
			display_name => {
				'currency' => q(Чешка корона),
				'one' => q(Чешка корона),
				'other' => q(Чешка корона),
			},
		},
		'DEM' => {
			display_name => {
				'currency' => q(Германска Марка),
			},
		},
		'DJF' => {
			display_name => {
				'currency' => q(Џибути франк),
				'one' => q(Џибути франк),
				'other' => q(Џибути франци),
			},
		},
		'DKK' => {
			display_name => {
				'currency' => q(Данска круна),
				'one' => q(Данска круна),
				'other' => q(Данска круна),
			},
		},
		'DOP' => {
			display_name => {
				'currency' => q(Доминикански Пезос),
				'one' => q(Доминикански Пезос),
				'other' => q(Доминикански Пезос),
			},
		},
		'DZD' => {
			display_name => {
				'currency' => q(Алжирски Динар),
				'one' => q(Алжирски Динар),
				'other' => q(Алжирски Динар),
			},
		},
		'EGP' => {
			display_name => {
				'currency' => q(Египетска Фунта),
				'one' => q(Египетска Фунта),
				'other' => q(Египетска Фунта),
			},
		},
		'ERN' => {
			display_name => {
				'currency' => q(Еритрејска Накфа),
				'one' => q(Еритрејска Накфа),
				'other' => q(Еритрејски Накфи),
			},
		},
		'ESP' => {
			display_name => {
				'currency' => q(Шпанска Пезета),
			},
		},
		'ETB' => {
			display_name => {
				'currency' => q(Етиописки Бир),
				'one' => q(Етиописки Бир),
				'other' => q(Етиописки Бир),
			},
		},
		'EUR' => {
			display_name => {
				'currency' => q(Евро),
				'one' => q(Евро),
				'other' => q(Евро),
			},
		},
		'FIM' => {
			display_name => {
				'currency' => q(Финска марка),
			},
		},
		'FJD' => {
			display_name => {
				'currency' => q(Фиџиски долар),
				'one' => q(Фиџи долар),
				'other' => q(Фиџи долар),
			},
		},
		'FKP' => {
			display_name => {
				'currency' => q(Фолкландска фунта),
				'one' => q(Фолкландски фунти),
				'other' => q(Фолкландски фунти),
			},
		},
		'FRF' => {
			display_name => {
				'currency' => q(Француски франк),
			},
		},
		'GBP' => {
			symbol => 'GBP',
			display_name => {
				'currency' => q(Британска Фунта),
				'one' => q(Британска Фунта),
				'other' => q(Британска Фунта),
			},
		},
		'GEL' => {
			display_name => {
				'currency' => q(Грузиски лари),
				'one' => q(Грузиски лари),
				'other' => q(Грузиски лари),
			},
		},
		'GHC' => {
			display_name => {
				'currency' => q(Ганајски Седи),
			},
		},
		'GHS' => {
			display_name => {
				'currency' => q(Гански седи),
				'one' => q(Гански седи),
				'other' => q(Гански седи),
			},
		},
		'GIP' => {
			display_name => {
				'currency' => q(Гибралтарска фунта),
				'one' => q(Гибралтарска фунта),
				'other' => q(Гибралтарска фунта),
			},
		},
		'GMD' => {
			display_name => {
				'currency' => q(Гамбиски даласи),
				'one' => q(Гамбиски Даласи),
				'other' => q(Гамбиски Даласи),
			},
		},
		'GNF' => {
			display_name => {
				'currency' => q(Гвинејски франк),
				'one' => q(Гвинејски франк),
				'other' => q(Гвинејски франк),
			},
		},
		'GRD' => {
			display_name => {
				'currency' => q(Грчка драхма),
			},
		},
		'GTQ' => {
			display_name => {
				'currency' => q(Гватемалски кветцал),
				'one' => q(Гватемалски кветцал),
				'other' => q(Гватемалски кветцал),
			},
		},
		'GWP' => {
			display_name => {
				'currency' => q(Гвинејски Бисау пезос),
			},
		},
		'GYD' => {
			display_name => {
				'currency' => q(Гвијански Долар),
				'one' => q(Гвијански Долар),
				'other' => q(Гвијански Долар),
			},
		},
		'HKD' => {
			symbol => 'HKD',
			display_name => {
				'currency' => q(Хонгконшки долар),
				'one' => q(Хонгконшки долар),
				'other' => q(Хонгконшки долар),
			},
		},
		'HNL' => {
			display_name => {
				'currency' => q(Хондурска лемпира),
				'one' => q(Хондурски лемпири),
				'other' => q(Хондурски лемпири),
			},
		},
		'HRD' => {
			display_name => {
				'currency' => q(Хрватски динар),
			},
		},
		'HRK' => {
			display_name => {
				'currency' => q(Хрватска Куна),
				'one' => q(Хрватска Куна),
				'other' => q(Хрватска Куна),
			},
		},
		'HTG' => {
			display_name => {
				'currency' => q(Хаитски гурд),
				'one' => q(Хаитски гурд),
				'other' => q(Хаитски гурд),
			},
		},
		'HUF' => {
			display_name => {
				'currency' => q(Унгарска форинта),
				'one' => q(Унгарска форинта),
				'other' => q(Унгарска форинта),
			},
		},
		'IDR' => {
			display_name => {
				'currency' => q(Индонезиска рупија),
				'one' => q(Индонезиска рупија),
				'other' => q(Индонезиска рупија),
			},
		},
		'IEP' => {
			display_name => {
				'currency' => q(Ирска фунта),
			},
		},
		'ILP' => {
			display_name => {
				'currency' => q(Изрелска фунта),
			},
		},
		'ILS' => {
			symbol => 'ILS',
			display_name => {
				'currency' => q(Израелски нов шекел),
				'one' => q(Израелски нов шекел),
				'other' => q(Израелски нов шекел),
			},
		},
		'INR' => {
			symbol => 'INR',
			display_name => {
				'currency' => q(Индијска рупија),
				'one' => q(Индијска рупија),
				'other' => q(Индијска рупија),
			},
		},
		'IQD' => {
			display_name => {
				'currency' => q(Ирачки динар),
				'one' => q(Ирачки динар),
				'other' => q(Ирачки динар),
			},
		},
		'IRR' => {
			display_name => {
				'currency' => q(Ирански риал),
				'one' => q(Ирански риал),
				'other' => q(Ирански риал),
			},
		},
		'ISK' => {
			display_name => {
				'currency' => q(Исландска крона),
				'one' => q(Исландска крона),
				'other' => q(Исландска крона),
			},
		},
		'ITL' => {
			display_name => {
				'currency' => q(Италијанска лира),
			},
		},
		'JMD' => {
			display_name => {
				'currency' => q(Јамајкански долар),
				'one' => q(Јамајкански долари),
				'other' => q(Јамајкански долари),
			},
		},
		'JOD' => {
			display_name => {
				'currency' => q(Јордански динар),
				'one' => q(Јордански динар),
				'other' => q(Јордански динар),
			},
		},
		'JPY' => {
			symbol => 'JPY',
			display_name => {
				'currency' => q(Јапонски јен),
				'one' => q(Јапонски јен),
				'other' => q(Јапонски јен),
			},
		},
		'KES' => {
			display_name => {
				'currency' => q(Кениски шилинг),
				'one' => q(Кениски шилинг),
				'other' => q(Кениски шилинг),
			},
		},
		'KGS' => {
			display_name => {
				'currency' => q(Киргистански сом),
				'one' => q(Киргистански сом),
				'other' => q(Киргистански сом),
			},
		},
		'KHR' => {
			display_name => {
				'currency' => q(Камбоџиски рел),
				'one' => q(Камбоџиски рел),
				'other' => q(Камбоџиски рел),
			},
		},
		'KMF' => {
			display_name => {
				'currency' => q(Коморски долар),
				'one' => q(Коморски долар),
				'other' => q(Коморски долар),
			},
		},
		'KPW' => {
			display_name => {
				'currency' => q(Северно корејски вон),
				'one' => q(Северно корејски вон),
				'other' => q(Северно корејски вон),
			},
		},
		'KRW' => {
			symbol => 'KRW',
			display_name => {
				'currency' => q(Јужно корејски вон),
				'one' => q(Јужно корејски вон),
				'other' => q(Јужно корејски вон),
			},
		},
		'KWD' => {
			display_name => {
				'currency' => q(Кувајтски динар),
				'one' => q(Кувајтски динар),
				'other' => q(Кувајтски динар),
			},
		},
		'KYD' => {
			display_name => {
				'currency' => q(Долар на кајмански острови),
				'one' => q(Долар на кајмански острови),
				'other' => q(Долари на кајмански острови),
			},
		},
		'KZT' => {
			display_name => {
				'currency' => q(Казахстанска тенга),
				'one' => q(Казахстанска тенга),
				'other' => q(Казахстанска тенга),
			},
		},
		'LAK' => {
			display_name => {
				'currency' => q(Лаоски кип),
				'one' => q(Лаоски кип),
				'other' => q(Лаоски кип),
			},
		},
		'LBP' => {
			display_name => {
				'currency' => q(Либанска фунта),
				'one' => q(Либанска фунта),
				'other' => q(Либанска фунта),
			},
		},
		'LKR' => {
			display_name => {
				'currency' => q(Шриланканска рупија),
				'one' => q(Шриланканска рупија),
				'other' => q(Шриланканска рупија),
			},
		},
		'LRD' => {
			display_name => {
				'currency' => q(Либериски долар),
				'one' => q(Либериски долар),
				'other' => q(Либериски долари),
			},
		},
		'LSL' => {
			display_name => {
				'currency' => q(Лесотско лоти),
			},
		},
		'LTL' => {
			display_name => {
				'currency' => q(Литваниска лита),
				'one' => q(Литваниска лита),
				'other' => q(Литваниска лита),
			},
		},
		'LTT' => {
			display_name => {
				'currency' => q(Литваниски литаз),
			},
		},
		'LUF' => {
			display_name => {
				'currency' => q(Луксембуршки франк),
			},
		},
		'LVL' => {
			display_name => {
				'currency' => q(Латвијски лат),
				'one' => q(Латвијски лат),
				'other' => q(Латвијски лат),
			},
		},
		'LVR' => {
			display_name => {
				'currency' => q(Латвијска рубља),
			},
		},
		'LYD' => {
			display_name => {
				'currency' => q(Либијски динар),
				'one' => q(Либијски динар),
				'other' => q(Либијски динар),
			},
		},
		'MAD' => {
			display_name => {
				'currency' => q(Марокански Дирхам),
				'one' => q(Марокански Дирхам),
				'other' => q(Марокански Дирхам),
			},
		},
		'MAF' => {
			display_name => {
				'currency' => q(Марокански франк),
			},
		},
		'MDL' => {
			display_name => {
				'currency' => q(Молдавски леу),
				'one' => q(Молдавски леу),
				'other' => q(Молдавски леу),
			},
		},
		'MGA' => {
			display_name => {
				'currency' => q(Малагасиски ариари),
				'one' => q(Малагасиски ариари),
				'other' => q(Малагасиски ариари),
			},
		},
		'MKD' => {
			symbol => 'ден',
			display_name => {
				'currency' => q(Македонски денар),
				'one' => q(Македонски денар),
				'other' => q(Македонски денар),
			},
		},
		'MLF' => {
			display_name => {
				'currency' => q(Малски франк),
			},
		},
		'MMK' => {
			display_name => {
				'currency' => q(Мја),
				'one' => q(Мјанмарски киат),
				'other' => q(Мјанмарски киати),
			},
		},
		'MNT' => {
			display_name => {
				'currency' => q(Монголиски тугрик),
				'one' => q(Монголиски тугрик),
				'other' => q(Монголиски тугрик),
			},
		},
		'MOP' => {
			display_name => {
				'currency' => q(Макао патака),
				'one' => q(Макао патака),
				'other' => q(Макао патака),
			},
		},
		'MRO' => {
			display_name => {
				'currency' => q(Мавританска угија),
				'one' => q(Мавританска угија),
				'other' => q(Мавритански угии),
			},
		},
		'MTL' => {
			display_name => {
				'currency' => q(Малтешка лира),
			},
		},
		'MTP' => {
			display_name => {
				'currency' => q(Малтешка фунта),
			},
		},
		'MUR' => {
			display_name => {
				'currency' => q(Мавританска рупија),
				'one' => q(Мавританска рупија),
				'other' => q(Мавритански рупии),
			},
		},
		'MVR' => {
			display_name => {
				'currency' => q(Малдивиска руфија),
				'one' => q(Малдивска руфија),
				'other' => q(Малдивски руфии),
			},
		},
		'MWK' => {
			display_name => {
				'currency' => q(Малависка квача),
				'one' => q(Малависка квача),
				'other' => q(Малависки квачи),
			},
		},
		'MXN' => {
			symbol => 'MX$',
			display_name => {
				'currency' => q(Мексикански пезос),
				'one' => q(Мексикански пезоси),
				'other' => q(Мексикански пезоси),
			},
		},
		'MXP' => {
			display_name => {
				'currency' => q(Мексикански сребрен пезос \(1861–1992\)),
			},
		},
		'MYR' => {
			display_name => {
				'currency' => q(Малазиски рингит),
				'one' => q(Малазиски рингит),
				'other' => q(Малазиски рингит),
			},
		},
		'MZE' => {
			display_name => {
				'currency' => q(Мозамбиско ескудо),
			},
		},
		'MZM' => {
			display_name => {
				'currency' => q(Стар мозамбиски метикал),
			},
		},
		'MZN' => {
			display_name => {
				'currency' => q(Мозамбиски метикал),
				'one' => q(Мозамбиски метикали),
				'other' => q(Мозамбиски метикал),
			},
		},
		'NAD' => {
			display_name => {
				'currency' => q(Намибиски долар),
				'one' => q(Намибиски долар),
				'other' => q(Намибиски долар),
			},
		},
		'NGN' => {
			display_name => {
				'currency' => q(Нигериска наира),
				'one' => q(Нигериска наира),
				'other' => q(Нигериска наира),
			},
		},
		'NIC' => {
			display_name => {
				'currency' => q(Никарагванска кордоба \(1988–1991\)),
				'one' => q(Никарагванска кордоба \(1988–1991\)),
				'other' => q(Никарагвански кордоби \(1988–1991\)),
			},
		},
		'NIO' => {
			display_name => {
				'currency' => q(Никарагванска кордоба),
				'one' => q(Никарагванска кордоба),
				'other' => q(Никарагвански кордоби),
			},
		},
		'NLG' => {
			display_name => {
				'currency' => q(Холандски гилдер),
			},
		},
		'NOK' => {
			display_name => {
				'currency' => q(Норвешка круна),
				'one' => q(Норвешка круна),
				'other' => q(Норвешка круна),
			},
		},
		'NPR' => {
			display_name => {
				'currency' => q(Непалска рупија),
				'one' => q(Непалска рупија),
				'other' => q(Непалска рупија),
			},
		},
		'NZD' => {
			symbol => 'NZD',
			display_name => {
				'currency' => q(Новозеландски долар),
				'one' => q(Новозеландски долар),
				'other' => q(Новозеландски долар),
			},
		},
		'OMR' => {
			display_name => {
				'currency' => q(Омански риал),
				'one' => q(Омански риал),
				'other' => q(Омански риал),
			},
		},
		'PAB' => {
			display_name => {
				'currency' => q(Панамска балбоа),
				'one' => q(Панамска балбоа),
				'other' => q(Панамска балбоа),
			},
		},
		'PEN' => {
			display_name => {
				'currency' => q(Перуански нов сол),
				'one' => q(Перуански нов сол),
				'other' => q(Перуански нов сол),
			},
		},
		'PES' => {
			display_name => {
				'currency' => q(Перуански сол),
			},
		},
		'PGK' => {
			display_name => {
				'currency' => q(Папуа новогвинејска кина),
				'one' => q(Папуа новогвинејска кина),
				'other' => q(Папуа новогвинејска кина),
			},
		},
		'PHP' => {
			display_name => {
				'currency' => q(Филипински пезос),
				'one' => q(Филипински пезос),
				'other' => q(Филипински пезос),
			},
		},
		'PKR' => {
			display_name => {
				'currency' => q(Пакистанска рупија),
				'one' => q(Пакистанска рупија),
				'other' => q(Пакистанска рупија),
			},
		},
		'PLN' => {
			display_name => {
				'currency' => q(Полска злота),
				'one' => q(Полска злота),
				'other' => q(Полска злота),
			},
		},
		'PLZ' => {
			display_name => {
				'currency' => q(Полска злота \(1950–1995\)),
			},
		},
		'PTE' => {
			display_name => {
				'currency' => q(Португалско ескудо),
			},
		},
		'PYG' => {
			display_name => {
				'currency' => q(Парагвајска гуарана),
				'one' => q(Парагвајска гуарана),
				'other' => q(Парагвајска гуарана),
			},
		},
		'QAR' => {
			display_name => {
				'currency' => q(Катарски риал),
				'one' => q(Катарски риал),
				'other' => q(Катарски риал),
			},
		},
		'ROL' => {
			display_name => {
				'currency' => q(Романска леи \(1952–2006\)),
				'one' => q(Романска леи \(1952–2006\)),
				'other' => q(Романска леи \(1952–2006\)),
			},
		},
		'RON' => {
			display_name => {
				'currency' => q(Романска леи),
				'one' => q(Романска леи),
				'other' => q(Романска леи),
			},
		},
		'RSD' => {
			display_name => {
				'currency' => q(Српски динар),
				'one' => q(Српски динар),
				'other' => q(Српски динар),
			},
		},
		'RUB' => {
			display_name => {
				'currency' => q(Руска рубља),
				'one' => q(Руска рубља),
				'other' => q(Руска рубља),
			},
		},
		'RUR' => {
			display_name => {
				'currency' => q(Руска рубља \(1991–1998\)),
			},
		},
		'RWF' => {
			display_name => {
				'currency' => q(Руандски франк),
				'one' => q(Руандски франк),
				'other' => q(Руандски франк),
			},
		},
		'SAR' => {
			display_name => {
				'currency' => q(Саудиски ријал),
				'one' => q(Саудиски ријал),
				'other' => q(Саудиски ријал),
			},
		},
		'SBD' => {
			display_name => {
				'currency' => q(Соломонски долар),
				'one' => q(Соломонски долар),
				'other' => q(Соломонски долар),
			},
		},
		'SCR' => {
			display_name => {
				'currency' => q(Сејшелска рупија),
				'one' => q(Сејшелска рупија),
				'other' => q(Сејшелски рупии),
			},
		},
		'SDD' => {
			display_name => {
				'currency' => q(Стар судански динар),
			},
		},
		'SDG' => {
			display_name => {
				'currency' => q(Суданска фунта),
				'one' => q(Суданска фунта),
				'other' => q(Судански фунти),
			},
		},
		'SDP' => {
			display_name => {
				'currency' => q(Стара суданска фунта),
			},
		},
		'SEK' => {
			display_name => {
				'currency' => q(Шведска круна),
				'one' => q(Шведска круна),
				'other' => q(Шведска круна),
			},
		},
		'SGD' => {
			display_name => {
				'currency' => q(Сингапурски долар),
				'one' => q(Сингапурски долар),
				'other' => q(Сингапурски долар),
			},
		},
		'SHP' => {
			display_name => {
				'currency' => q(Фунта на Света Елена),
				'one' => q(Фунта на Света Елена),
				'other' => q(Фунти на Света Елена),
			},
		},
		'SIT' => {
			display_name => {
				'currency' => q(Словенечки толар),
			},
		},
		'SKK' => {
			display_name => {
				'currency' => q(Словачка круна),
			},
		},
		'SLL' => {
			display_name => {
				'currency' => q(Сиералеонско леоне),
				'one' => q(Сиералеонско леоне),
				'other' => q(Сиералеонско леоне),
			},
		},
		'SOS' => {
			display_name => {
				'currency' => q(Сомалијски шилинг),
				'one' => q(Сомалијски шилинзи),
				'other' => q(Сомалијски шилинзи),
			},
		},
		'SRD' => {
			display_name => {
				'currency' => q(Суринамски долар),
				'one' => q(Суринамски долар),
				'other' => q(Суринамски долари),
			},
		},
		'SRG' => {
			display_name => {
				'currency' => q(Суринамски гилдер),
			},
		},
		'SSP' => {
			display_name => {
				'currency' => q(Јужносуданска фунта),
				'one' => q(Јужносуданска фунта),
				'other' => q(Јужносудански фунти),
			},
		},
		'STD' => {
			display_name => {
				'currency' => q(Добра на Сао Томе и Принсипе),
				'one' => q(Добра на Сао Томе и Принсипе),
				'other' => q(Добри на Сао Томе и Принсипе),
			},
		},
		'SUR' => {
			display_name => {
				'currency' => q(Советска рубља),
			},
		},
		'SVC' => {
			display_name => {
				'currency' => q(Салвадорски колон),
			},
		},
		'SYP' => {
			display_name => {
				'currency' => q(Сиријска фунта),
				'one' => q(Сиријска фунта),
				'other' => q(Сиријска фунта),
			},
		},
		'SZL' => {
			display_name => {
				'currency' => q(Свазилендски лиланген),
				'one' => q(Свазилендски лиланген),
				'other' => q(Свазилендски лиланген),
			},
		},
		'THB' => {
			symbol => 'THB',
			display_name => {
				'currency' => q(Таи бат),
				'one' => q(Таи бат),
				'other' => q(Таи бат),
			},
		},
		'TJR' => {
			display_name => {
				'currency' => q(Таџикистанска рубља),
			},
		},
		'TJS' => {
			display_name => {
				'currency' => q(Таџикистански сомони),
				'one' => q(Таџикистански сомони),
				'other' => q(Таџикистански сомони),
			},
		},
		'TMM' => {
			display_name => {
				'currency' => q(Туркменистански манат),
			},
		},
		'TMT' => {
			display_name => {
				'one' => q(Туркменистански манати),
				'other' => q(Туркменистански манати),
			},
		},
		'TND' => {
			display_name => {
				'currency' => q(Тунизиски динар),
				'one' => q(Тунизиски динар),
				'other' => q(Тунизиски динари),
			},
		},
		'TOP' => {
			display_name => {
				'currency' => q(Тонганска панга),
				'one' => q(Тонганска панга),
				'other' => q(Тонганска панга),
			},
		},
		'TPE' => {
			display_name => {
				'currency' => q(Тиморски ескудо),
			},
		},
		'TRL' => {
			display_name => {
				'currency' => q(Турска лира \(1922–2005\)),
				'one' => q(Турска лира \(1922–2005\)),
				'other' => q(Турска лира \(1922–2005\)),
			},
		},
		'TRY' => {
			display_name => {
				'currency' => q(Турска лира),
				'one' => q(Турска лира),
				'other' => q(Турски лири),
			},
		},
		'TWD' => {
			symbol => 'TWD',
			display_name => {
				'currency' => q(Тајвански нов долар),
				'one' => q(Тајвански нов долар),
				'other' => q(Тајвански нов долар),
			},
		},
		'TZS' => {
			display_name => {
				'currency' => q(Танзаниски шилинг),
				'one' => q(Танзаниски шилинг),
				'other' => q(Танзаниски шилинг),
			},
		},
		'UAH' => {
			display_name => {
				'currency' => q(Украинска хривнија),
				'one' => q(Украинска хривнија),
				'other' => q(Украинска хривнија),
			},
		},
		'UGS' => {
			display_name => {
				'currency' => q(Угандиски шилинг \(1966–1987\)),
			},
		},
		'UGX' => {
			display_name => {
				'currency' => q(Угандиски шилинг),
				'one' => q(Угандиски шилинг),
				'other' => q(Угандиски шилинг),
			},
		},
		'USD' => {
			symbol => 'US$',
			display_name => {
				'currency' => q(Американски долар),
				'one' => q(Американски долари),
				'other' => q(Американски долари),
			},
		},
		'USN' => {
			display_name => {
				'currency' => q(САД долар \(Next day\)),
			},
		},
		'USS' => {
			display_name => {
				'currency' => q(САД долар \(Same day\)),
			},
		},
		'UYP' => {
			display_name => {
				'currency' => q(Уругвајски пезос \(1975–1993\)),
			},
		},
		'UYU' => {
			display_name => {
				'currency' => q(Уругвајски пезос),
				'one' => q(Уругвајски пезоси),
				'other' => q(Уругвајски пезоси),
			},
		},
		'UZS' => {
			display_name => {
				'currency' => q(Узбекистански сом),
				'one' => q(Узбекистански сом),
				'other' => q(Узбекистански сом),
			},
		},
		'VEB' => {
			display_name => {
				'currency' => q(Венецуелски боливар \(1871–2008\)),
				'one' => q(Венецуелски боливар \(1871–2008\)),
				'other' => q(Венецуелски боливар \(1871–2008\)),
			},
		},
		'VEF' => {
			display_name => {
				'currency' => q(Венецуелски боливар),
				'one' => q(Венецуелски боливар),
				'other' => q(Венецуелски боливари),
			},
		},
		'VND' => {
			symbol => 'VND',
			display_name => {
				'currency' => q(Виетнамски донг),
				'one' => q(Виетнамски донг),
				'other' => q(Виетнамски донг),
			},
		},
		'VUV' => {
			display_name => {
				'currency' => q(Ванатски вату),
				'one' => q(Ванатски вату),
				'other' => q(Ванатски вату),
			},
		},
		'WST' => {
			display_name => {
				'currency' => q(Самоанска тала),
				'one' => q(Самоанска тала),
				'other' => q(Самоанска тала),
			},
		},
		'XAF' => {
			symbol => 'FCFA',
		},
		'XCD' => {
			symbol => 'EC$',
			display_name => {
				'currency' => q(Источно карибиски долар),
				'one' => q(Источно карибиски долар),
				'other' => q(Источно карибиски долар),
			},
		},
		'XOF' => {
			symbol => 'CFA',
		},
		'XPF' => {
			symbol => 'CFPF',
			display_name => {
				'currency' => q(ЦФП франк),
				'one' => q(ЦФП франк),
				'other' => q(ЦФП франци),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(Непозната валута),
				'one' => q(Непозната валута),
				'other' => q(Непозната валута),
			},
		},
		'YDD' => {
			display_name => {
				'currency' => q(Јеменски динар),
			},
		},
		'YER' => {
			display_name => {
				'currency' => q(Јеменски риал),
				'one' => q(Јеменски риал),
				'other' => q(Јеменски риал),
			},
		},
		'YUD' => {
			display_name => {
				'currency' => q(Југословенски динар),
			},
		},
		'YUN' => {
			display_name => {
				'currency' => q(Југословенски конвертибилен динар),
			},
		},
		'ZAL' => {
			display_name => {
				'currency' => q(Јужно афрички ранд\(финансиски\)),
			},
		},
		'ZAR' => {
			display_name => {
				'currency' => q(Јужно афрички ранд),
				'one' => q(Јужно афрички ранд),
				'other' => q(Јужно афрички ранд),
			},
		},
		'ZMK' => {
			display_name => {
				'currency' => q(Замбијска квача \(1968–2012\)),
			},
		},
		'ZMW' => {
			display_name => {
				'currency' => q(Замбијска квача),
				'one' => q(Замбијска квача),
				'other' => q(Замбијска квача),
			},
		},
		'ZRN' => {
			display_name => {
				'currency' => q(Заирско новозаире),
			},
		},
		'ZRZ' => {
			display_name => {
				'currency' => q(Заирско заире),
			},
		},
		'ZWD' => {
			display_name => {
				'currency' => q(Зимбабвиски долар),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'јан.',
							'фев.',
							'мар.',
							'апр.',
							'мај',
							'јун.',
							'јул.',
							'авг.',
							'септ.',
							'окт.',
							'ноем.',
							'дек.'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'ј',
							'ф',
							'м',
							'а',
							'м',
							'ј',
							'ј',
							'а',
							'с',
							'о',
							'н',
							'д'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'јануари',
							'февруари',
							'март',
							'април',
							'мај',
							'јуни',
							'јули',
							'август',
							'септември',
							'октомври',
							'ноември',
							'декември'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'јан.',
							'фев.',
							'мар.',
							'апр.',
							'мај',
							'јун.',
							'јул.',
							'авг.',
							'септ.',
							'окт.',
							'ноем.',
							'дек.'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'ј',
							'ф',
							'м',
							'а',
							'м',
							'ј',
							'ј',
							'а',
							'с',
							'о',
							'н',
							'д'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'јануари',
							'февруари',
							'март',
							'април',
							'мај',
							'јуни',
							'јули',
							'август',
							'септември',
							'октомври',
							'ноември',
							'декември'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'пон.',
						tue => 'вт.',
						wed => 'сре.',
						thu => 'чет.',
						fri => 'пет.',
						sat => 'саб.',
						sun => 'нед.'
					},
					narrow => {
						mon => 'п',
						tue => 'в',
						wed => 'с',
						thu => 'ч',
						fri => 'п',
						sat => 'с',
						sun => 'н'
					},
					short => {
						mon => 'пон.',
						tue => '3',
						wed => 'сре.',
						thu => 'чет.',
						fri => 'пет.',
						sat => '7',
						sun => 'нед.'
					},
					wide => {
						mon => 'понеделник',
						tue => 'вторник',
						wed => 'среда',
						thu => 'четврток',
						fri => 'петок',
						sat => 'сабота',
						sun => 'недела'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'пон.',
						tue => 'вт.',
						wed => 'сре.',
						thu => 'чет.',
						fri => 'пет.',
						sat => 'саб.',
						sun => 'нед.'
					},
					narrow => {
						mon => 'п',
						tue => 'в',
						wed => 'с',
						thu => 'ч',
						fri => 'п',
						sat => 'с',
						sun => 'н'
					},
					short => {
						mon => 'пон.',
						tue => 'вто.',
						wed => 'сре.',
						thu => 'чет.',
						fri => 'пет.',
						sat => 'саб.',
						sun => 'нед.'
					},
					wide => {
						mon => 'понеделник',
						tue => 'вторник',
						wed => 'среда',
						thu => 'четврток',
						fri => 'петок',
						sat => 'сабота',
						sun => 'недела'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'Q1',
						1 => 'Q2',
						2 => 'Q3',
						3 => 'Q4'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => 'прво тромесечје',
						1 => 'второ тромесечје',
						2 => 'трето тромесечје',
						3 => 'четврто тромесечје'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => 'јан-мар',
						1 => 'апр-јун',
						2 => 'јул-сеп',
						3 => 'окт-дек'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => 'прво тромесечје',
						1 => 'второ тромесечје',
						2 => 'трето тромесечје',
						3 => 'четврто тромесечје'
					},
				},
			},
	} },
);

has 'day_periods' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'wide' => {
					'am' => q{претпладне},
					'pm' => q{попладне},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'пр.н.е.',
				'1' => 'н.е.'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{EEEE, dd MMMM y 'г'. G},
			'long' => q{dd MMMM y 'г'. G},
			'medium' => q{dd.M.y G},
			'short' => q{dd.M.y GGGGG},
		},
		'gregorian' => {
			'full' => q{EEEE, dd MMMM y 'г'.},
			'long' => q{dd MMMM y 'г'.},
			'medium' => q{dd.M.y},
			'short' => q{dd.M.yy},
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			'full' => q{HH:mm:ss zzzz},
			'long' => q{HH:mm:ss z},
			'medium' => q{HH:mm:ss},
			'short' => q{HH:mm},
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'gregorian' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{E, d},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{y 'г'. G},
			GyMMM => q{MMM y 'г'. G},
			GyMMMEd => q{E, dd MMM y 'г'. G},
			GyMMMd => q{dd MMM y 'г'. G},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{E, d.M},
			MMM => q{LLL},
			MMMEd => q{E d MMM},
			MMMMEd => q{E d MMMM},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			Md => q{d.M},
			Mdd => q{dd.M},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{y 'г'.},
			yM => q{M.y},
			yMEd => q{E, d.M.y},
			yMMM => q{MMM y 'г'.},
			yMMMEd => q{E, d MMM y 'г'.},
			yMMMM => q{MMMM y 'г'.},
			yMMMd => q{d MMM y 'г'.},
			yMd => q{d.M.y},
			yQQQ => q{QQQ y 'г'.},
			yQQQQ => q{QQQQ y 'г'.},
		},
		'generic' => {
			Ed => q{d E},
			Gy => q{y 'г'. G},
			GyMMM => q{MMM y 'г'. G},
			GyMMMEd => q{E, dd MMM y 'г'. G},
			GyMMMd => q{dd MMM y 'г'. G},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{E, dd.M},
			MMM => q{LLL},
			MMMEd => q{E, dd MMM},
			MMMMEd => q{E, dd MMMM},
			MMMMd => q{dd MMMM},
			MMMd => q{dd MMM},
			Md => q{dd.M},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{y 'г'. G},
			yyyy => q{y 'г'. G},
			yyyyM => q{M.y G},
			yyyyMEd => q{E, dd.M.y G},
			yyyyMMM => q{MMM y 'г'. G},
			yyyyMMMEd => q{E, dd MMM y 'г'. G},
			yyyyMMMM => q{MMMM y 'г'. G},
			yyyyMMMd => q{dd MMM y 'г'. G},
			yyyyMd => q{dd.M.y G},
			yyyyQQQ => q{G y QQQ},
			yyyyQQQQ => q{G y QQQQ},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'Timezone' => '{0} {1}',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm-HH:mm},
				m => q{HH:mm-HH:mm},
			},
			Hmv => {
				H => q{HH:mm-HH:mm v},
				m => q{HH:mm-HH:mm v},
			},
			Hv => {
				H => q{HH-HH v},
			},
			M => {
				M => q{M-M},
			},
			MEd => {
				M => q{E, dd.M - E, dd.M},
				d => q{E, dd.M - E, dd.M},
			},
			MMM => {
				M => q{MMM-MMM},
			},
			MMMEd => {
				M => q{E, dd MMM - E, dd MMM},
				d => q{E, dd - E, dd MMM},
			},
			MMMM => {
				M => q{LLLL–LLLL},
			},
			MMMd => {
				M => q{dd MMM - dd MMM},
				d => q{dd-dd MMM},
			},
			Md => {
				M => q{dd.M - dd.M},
				d => q{dd.M - dd.M},
			},
			d => {
				d => q{d-d},
			},
			fallback => '{0} - {1}',
			h => {
				a => q{h a – h a},
				h => q{h-h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm-h:mm a},
				m => q{h:mm-h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm-h:mm a v},
				m => q{h:mm-h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h-h a v},
			},
			y => {
				y => q{y-y},
			},
			yM => {
				M => q{M.y - M.y},
				y => q{M.y - M.y},
			},
			yMEd => {
				M => q{E, dd.M.y - E, dd.M.y},
				d => q{E, dd.M.y - E, dd.M.y},
				y => q{E, dd.M.y - E, dd.M.y},
			},
			yMMM => {
				M => q{MMM-MMM y},
				y => q{MMM y - MMM y},
			},
			yMMMEd => {
				M => q{E, dd MMM - E, dd MMM y},
				d => q{E, dd - E, dd MMM y},
				y => q{E, dd MMM y - E, dd MMM y},
			},
			yMMMM => {
				M => q{MMMM–MMMM y},
				y => q{MMMM y – MMMM y},
			},
			yMMMd => {
				M => q{dd MMM - dd MMM y},
				d => q{dd-dd MMM y},
				y => q{dd MMM y - dd MMM y},
			},
			yMd => {
				M => q{dd.M.y - dd.M.y},
				d => q{dd.M.y - dd.M.y},
				y => q{dd.M.y - dd.M.y},
			},
		},
		'generic' => {
			H => {
				H => q{HH-HH},
			},
			Hm => {
				H => q{HH:mm-HH:mm},
				m => q{HH:mm-HH:mm},
			},
			Hmv => {
				H => q{HH:mm-HH:mm v},
				m => q{HH:mm-HH:mm v},
			},
			Hv => {
				H => q{HH-HH v},
			},
			M => {
				M => q{M-M},
			},
			MEd => {
				M => q{E, dd.M - E, dd.M},
				d => q{E, dd.M - E, dd.M},
			},
			MMM => {
				M => q{MMM-MMM},
			},
			MMMEd => {
				M => q{E, dd MMM - E, dd MMM},
				d => q{E, dd - E, dd MMM},
			},
			MMMM => {
				M => q{LLLL–LLLL},
			},
			MMMd => {
				M => q{dd MMM - dd MMM},
				d => q{dd-dd MMM},
			},
			Md => {
				M => q{dd.M - dd.M},
				d => q{dd.M - dd.M},
			},
			d => {
				d => q{d-d},
			},
			fallback => '{0} - {1}',
			h => {
				a => q{h a – h a},
				h => q{h-h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm-h:mm a},
				m => q{h:mm-h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm-h:mm a v},
				m => q{h:mm-h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h-h a v},
			},
			y => {
				y => q{y-y G},
			},
			yM => {
				M => q{M.y - M.y G},
				y => q{M.y - M.y G},
			},
			yMEd => {
				M => q{E, dd.M.y - E, dd.M.y G},
				d => q{E, dd.M.y - E, dd.M.y G},
				y => q{E, dd.M.y - E, dd.M.y G},
			},
			yMMM => {
				M => q{MMM-MMM y G},
				y => q{MMM y - MMM y G},
			},
			yMMMEd => {
				M => q{E, dd MMM - E, dd MMM y G},
				d => q{E, dd - E, dd MMM y G},
				y => q{E, dd MMM y - E, dd MMM y G},
			},
			yMMMM => {
				M => q{MMMM-MMMM y G},
				y => q{MMMM y - MMMM y G},
			},
			yMMMd => {
				M => q{dd MMM - dd MMM y G},
				d => q{dd-dd MMM y G},
				y => q{dd MMM y - dd MMM y G},
			},
			yMd => {
				M => q{dd.M.y - dd.M.y G},
				d => q{dd.M.y - dd.M.y G},
				y => q{dd.M.y - dd.M.y G},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HH:mm;-HH:mm),
		gmtFormat => q(GMT{0}),
		gmtZeroFormat => q(GMT),
		regionFormat => q(Време во {0}),
		regionFormat => q({0} (+1)),
		regionFormat => q({0} (+0)),
		fallbackFormat => q({1} ({0})),
		'Acre' => {
			long => {
				'daylight' => q(Акре летно сметање на времето),
				'generic' => q(Акре време),
				'standard' => q(Акре стандардно време),
			},
		},
		'Afghanistan' => {
			long => {
				'standard' => q(Време во Авганистан),
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#Абиџан#,
		},
		'Africa/Accra' => {
			exemplarCity => q#Акра#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#Адис Абеба#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#Алжир#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#Асмара#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#Бамако#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#Банги#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#Банџул#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#Бисау#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#Блантајр#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#Бразавил#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#Буџумбура#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#Каиро#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#Казабланка#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#Сеута#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#Конакри#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#Дакар#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#Дар ес Салам#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#Џибути#,
		},
		'Africa/Douala' => {
			exemplarCity => q#Дуала#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#Ел Ајун#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#Фритаун#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#Габороне#,
		},
		'Africa/Harare' => {
			exemplarCity => q#Хараре#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#Јоханесбург#,
		},
		'Africa/Juba' => {
			exemplarCity => q#Џуба#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#Кампала#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#Картум#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#Кигали#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#Киншаса#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#Лагос#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#Либрвил#,
		},
		'Africa/Lome' => {
			exemplarCity => q#Ломе#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#Луанда#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#Лубумбаши#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#Лусака#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#Малабо#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#Мапуто#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#Масеру#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#Мбабане#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#Могадишу#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#Монровија#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#Најроби#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#Нџамена#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#Нијамеј#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#Нуакшот#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#Уагадугу#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#Порто Ново#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#Сао Томе#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#Триполи#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#Тунис#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#Виндхук#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q(Средноафриканско време),
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q(Источноафриканско време),
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q(Време во Јужноафриканска Република),
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q(Западноафриканско летно сметање на времето),
				'generic' => q(Западноафриканско време),
				'standard' => q(Западноафриканско стандардно време),
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q(Летно сметање на времето во Аљаска),
				'generic' => q(Време во Аљаска),
				'standard' => q(Стандардно време во Аљаска),
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q(Летно сметање на времето во Амазон),
				'generic' => q(Време во Амазон),
				'standard' => q(Стандардно време во Амазон),
			},
		},
		'America/Adak' => {
			exemplarCity => q#Адак#,
		},
		'America/Anchorage' => {
			exemplarCity => q#Енкориџ#,
		},
		'America/Anguilla' => {
			exemplarCity => q#Ангилја#,
		},
		'America/Antigua' => {
			exemplarCity => q#Антигва#,
		},
		'America/Araguaina' => {
			exemplarCity => q#Арагвајана#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#Ла Риоха#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#Рио Галегос#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#Салта#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#Сан Хуан#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#Сан Луис#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#Тукуман#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#Ушуаја#,
		},
		'America/Aruba' => {
			exemplarCity => q#Аруба#,
		},
		'America/Asuncion' => {
			exemplarCity => q#Асунсион#,
		},
		'America/Bahia' => {
			exemplarCity => q#Бахиа#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#Бахија де Бандерас#,
		},
		'America/Barbados' => {
			exemplarCity => q#Барбадос#,
		},
		'America/Belem' => {
			exemplarCity => q#Белем#,
		},
		'America/Belize' => {
			exemplarCity => q#Белизе#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#Бланк-Сејблон#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#Боа Виста#,
		},
		'America/Bogota' => {
			exemplarCity => q#Богота#,
		},
		'America/Boise' => {
			exemplarCity => q#Бојзи#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#Буенос Аирес#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#Кембриџ Беј#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#Кампо Гранде#,
		},
		'America/Cancun' => {
			exemplarCity => q#Канкун#,
		},
		'America/Caracas' => {
			exemplarCity => q#Каракас#,
		},
		'America/Catamarca' => {
			exemplarCity => q#Катамарка#,
		},
		'America/Cayenne' => {
			exemplarCity => q#Кајена#,
		},
		'America/Cayman' => {
			exemplarCity => q#Кајмански Острови#,
		},
		'America/Chicago' => {
			exemplarCity => q#Чикаго#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#Чивава#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#Корал Харбор#,
		},
		'America/Cordoba' => {
			exemplarCity => q#Кордоба#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#Костарика#,
		},
		'America/Creston' => {
			exemplarCity => q#Крестон#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#Кујаба#,
		},
		'America/Curacao' => {
			exemplarCity => q#Курасао#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#Данмаркшан#,
		},
		'America/Dawson' => {
			exemplarCity => q#Досон#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#Досон Крик#,
		},
		'America/Denver' => {
			exemplarCity => q#Денвер#,
		},
		'America/Detroit' => {
			exemplarCity => q#Детроит#,
		},
		'America/Dominica' => {
			exemplarCity => q#Доминика#,
		},
		'America/Edmonton' => {
			exemplarCity => q#Едмонтон#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#Еирунепе#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#Ел Салвадор#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#Форталеза#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#Глејс Беј#,
		},
		'America/Godthab' => {
			exemplarCity => q#Нук#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#Гус Беј#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#Гранд Турк#,
		},
		'America/Grenada' => {
			exemplarCity => q#Гренада#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#Гвадалупе#,
		},
		'America/Guatemala' => {
			exemplarCity => q#Гватемала#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#Гвајакил#,
		},
		'America/Guyana' => {
			exemplarCity => q#Гвајана#,
		},
		'America/Halifax' => {
			exemplarCity => q#Халифакс#,
		},
		'America/Havana' => {
			exemplarCity => q#Хавана#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#Ермосиљо#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#Нокс, Индијана#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#Маренго, Индијана#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#Питерсбург, Индијана#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#Тел Сити, Индијана#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#Вивеј, Индијана#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#Венсен, Индијана#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#Винамак, Индијана#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#Индијанаполис#,
		},
		'America/Inuvik' => {
			exemplarCity => q#Инувик#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#Икалуит#,
		},
		'America/Jamaica' => {
			exemplarCity => q#Јамајка#,
		},
		'America/Jujuy' => {
			exemplarCity => q#Хухуј#,
		},
		'America/Juneau' => {
			exemplarCity => q#Џуно#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#Монтичело, Кентаки#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#Кралендајк#,
		},
		'America/La_Paz' => {
			exemplarCity => q#Ла Паз#,
		},
		'America/Lima' => {
			exemplarCity => q#Лима#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#Лос Анџелес#,
		},
		'America/Louisville' => {
			exemplarCity => q#Луизвил#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#Долен Принс квортр#,
		},
		'America/Maceio' => {
			exemplarCity => q#Масејо#,
		},
		'America/Managua' => {
			exemplarCity => q#Манагва#,
		},
		'America/Manaus' => {
			exemplarCity => q#Манаус#,
		},
		'America/Marigot' => {
			exemplarCity => q#Мариго#,
		},
		'America/Martinique' => {
			exemplarCity => q#Мартиник#,
		},
		'America/Matamoros' => {
			exemplarCity => q#Матаморос#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#Мазатлан#,
		},
		'America/Mendoza' => {
			exemplarCity => q#Мендоза#,
		},
		'America/Menominee' => {
			exemplarCity => q#Меномини#,
		},
		'America/Merida' => {
			exemplarCity => q#Мерида#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#Метлакатла#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#Мексико Сити#,
		},
		'America/Miquelon' => {
			exemplarCity => q#Микелан#,
		},
		'America/Moncton' => {
			exemplarCity => q#Монктон#,
		},
		'America/Monterrey' => {
			exemplarCity => q#Монтереј#,
		},
		'America/Montevideo' => {
			exemplarCity => q#Монтевидео#,
		},
		'America/Montserrat' => {
			exemplarCity => q#Монтсерат#,
		},
		'America/Nassau' => {
			exemplarCity => q#Насау#,
		},
		'America/New_York' => {
			exemplarCity => q#Њујорк#,
		},
		'America/Nipigon' => {
			exemplarCity => q#Нипигон#,
		},
		'America/Nome' => {
			exemplarCity => q#Ном#,
		},
		'America/Noronha' => {
			exemplarCity => q#Нороња#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#Бјула, Северна Дакота#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#Центар, Северна Дакота#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#Њу Салем, Северна Дакота#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#Охинага#,
		},
		'America/Panama' => {
			exemplarCity => q#Панама#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#Пангниртунг#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#Парамарибо#,
		},
		'America/Phoenix' => {
			exemplarCity => q#Феникс#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#Порт о Пренс#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#Порт ов Спејн#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#Порто Вељо#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#Порторико#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#Рејни Ривер#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#Ренкин Инлет#,
		},
		'America/Recife' => {
			exemplarCity => q#Ресифи#,
		},
		'America/Regina' => {
			exemplarCity => q#Реџајна#,
		},
		'America/Resolute' => {
			exemplarCity => q#Резолут#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#Рио Бранко#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#Света Изабела#,
		},
		'America/Santarem' => {
			exemplarCity => q#Сантарем#,
		},
		'America/Santiago' => {
			exemplarCity => q#Сантијаго#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#Санто Доминго#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#Сао Паоло#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#Итокортормит#,
		},
		'America/Sitka' => {
			exemplarCity => q#Ситка#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#Сент Бартоломеј#,
		},
		'America/St_Johns' => {
			exemplarCity => q#Сент Џонс#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#Свети Кристофер#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#Света Луција#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#Сент Томас#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#Сент Винсент#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#Свифт Курент#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#Тегусигалпа#,
		},
		'America/Thule' => {
			exemplarCity => q#Туле#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#Тандр Беј#,
		},
		'America/Tijuana' => {
			exemplarCity => q#Тихуана#,
		},
		'America/Toronto' => {
			exemplarCity => q#Торонто#,
		},
		'America/Tortola' => {
			exemplarCity => q#Тортола#,
		},
		'America/Vancouver' => {
			exemplarCity => q#Ванкувер#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#Вајтхорс#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#Винипег#,
		},
		'America/Yakutat' => {
			exemplarCity => q#Јакутат#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#Јелоунајф#,
		},
		'America_Central' => {
			long => {
				'daylight' => q(Централно летно сметање на времето),
				'generic' => q(Централно време во Северна Америка),
				'standard' => q(Централно стандардно време во Северна Америка),
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q(Источно летно сметање на времето),
				'generic' => q(Источно време),
				'standard' => q(Источно стандардно време),
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q(Планинско летно сметање на времето),
				'generic' => q(Планинско време),
				'standard' => q(Планинско стандардно време),
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q(Пацифичко летно сметање на времето),
				'generic' => q(Пацифичко време),
				'standard' => q(Пацифичко стандардно време),
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#Кејси#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#Дејвис#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#Димон Дирвил#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#Маквори#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#Мосон#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#Макмурдо#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#Палмер#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#Ротера#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#Сајова#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#Восток#,
		},
		'Arabian' => {
			long => {
				'daylight' => q(Арапски летно сметање на времето),
				'generic' => q(Арапско време),
				'standard' => q(Стандардно арапско време),
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#Лонгјиербјен#,
		},
		'Argentina' => {
			long => {
				'daylight' => q(Летно сметање на времето во Аргентина),
				'generic' => q(Време во Аргентина),
				'standard' => q(Стандардно време во Аргентина),
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q(Летно сметање на времето во западна Аргентина),
				'generic' => q(Време во западна Аргентина),
				'standard' => q(Стандардно време во западна Аргентина),
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q(Летно време во Ерменија),
				'generic' => q(Време во Ерменија),
				'standard' => q(Стандардно време во Ерменија),
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#Аден#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#Алмати#,
		},
		'Asia/Amman' => {
			exemplarCity => q#Аман#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#Анадир#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#Актау#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#Актобе#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#Ашкабад#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#Багдад#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#Бахреин#,
		},
		'Asia/Baku' => {
			exemplarCity => q#Баку#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#Бангкок#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#Бејрут#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#Бишкек#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#Брунеј#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#Колката#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#Чојбалсан#,
		},
		'Asia/Chongqing' => {
			exemplarCity => q#Чонгчинг#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#Коломбо#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#Дамаск#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#Дака#,
		},
		'Asia/Dili' => {
			exemplarCity => q#Дили#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#Дубаи#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#Душанбе#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#Газа#,
		},
		'Asia/Harbin' => {
			exemplarCity => q#Харбин#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#Хеброн#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#Хонг Конг#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#Ховд#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#Иркутск#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#Џакарта#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#Џајапура#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#Ерусалим#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#Кабул#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#Камчатка#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#Карачи#,
		},
		'Asia/Kashgar' => {
			exemplarCity => q#Кашгар#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#Катманду#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#Хандига#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#Краснојарск#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#Куала Лумпур#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#Кучинг#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#Кувајт#,
		},
		'Asia/Macau' => {
			exemplarCity => q#Макао#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#Магадан#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#Макасар#,
		},
		'Asia/Manila' => {
			exemplarCity => q#Манила#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#Мускат#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#Никозија#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#Новокузњецк#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#Новосибирск#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#Омск#,
		},
		'Asia/Oral' => {
			exemplarCity => q#Орал#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#Пном Пен#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#Понтијанак#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#Пјонгјанг#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#Катар#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#Кизилорда#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#Рангун#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#Ријад#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#Хо Ши Мин#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#Сакалин#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#Самарканд#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#Сеул#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#Шангај#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#Сингапур#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#Тајпеј#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#Ташкент#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#Тбилиси#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#Техеран#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#Тимпу#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#Токио#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#Улан Батор#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#Урумчи#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#Уст-Нера#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#Виентијан#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#Владивосток#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#Јакутск#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#Екатеринбург#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#Ереван#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q(Атлантско летно сметање на времето),
				'generic' => q(Атлантско време),
				'standard' => q(Атлантско стандардно време),
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#Азорски Острови#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#Бермуди#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#Канарски Острови#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#Зелен 'Рт#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#Фарски Острови#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#Мадеира#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#Рејкјавик#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#Јужна Џорџија#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#Света Елена#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#Стенли#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#Аделаида#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#Бризбејн#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#Брокен Хил#,
		},
		'Australia/Currie' => {
			exemplarCity => q#Курие#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#Дарвин#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#Јукла#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#Хобарт#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#Линдеман#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#Лорд Хау#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#Мелбурн#,
		},
		'Australia/Perth' => {
			exemplarCity => q#Перт#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#Сиднеј#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q(Летно сметање на времето во Централна Австралија),
				'generic' => q(Време во Централна Австралија),
				'standard' => q(Стандардно време во Централна Австралија),
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q(Летно сметање на времето во Централна и Западна Австралија),
				'generic' => q(Време во Централна и Западна Австралија),
				'standard' => q(Стандардно време во Централна и Западна Австралија),
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q(Летно сметање на времето во Источна Австралија),
				'generic' => q(Време во Источна Австралија),
				'standard' => q(Стандардно време во Источна Австралија),
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q(Летно сметање на времето во Западна Австралија),
				'generic' => q(Време во Западна Австралија),
				'standard' => q(Стандардно време во Западна Австралија),
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q(Летно време во Азербејџан),
				'generic' => q(Време во Азербејџан),
				'standard' => q(Стандардно време во Азербејџан),
			},
		},
		'Azores' => {
			long => {
				'daylight' => q(Летно време во Азорес),
				'generic' => q(Време во Азорес),
				'standard' => q(Стандардно време во Азорес),
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q(Летно време во Бангладеш),
				'generic' => q(Време во Бангладеш),
				'standard' => q(Стандардно време во Бангладеш),
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q(Време во Бутан),
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q(Време во Боливија),
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q(Летно сметање на времето во Бразилија),
				'generic' => q(Време во Бразилија),
				'standard' => q(Стандардно време во Бразилија),
			},
		},
		'Brunei' => {
			long => {
				'standard' => q(Време во Брунеи Дарусалам),
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q(Летно време на Зелениот 'Рт),
				'generic' => q(Време на Зелениот 'Рт),
				'standard' => q(Стандардно време на Зелениот 'R),
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q(Време во Чаморо),
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q(Летно сметање на времето во Четем),
				'generic' => q(Време во Четем),
				'standard' => q(Стандардно време во Четем),
			},
		},
		'Chile' => {
			long => {
				'daylight' => q(Летно сметање на времето во Чиле),
				'generic' => q(Време во Чиле),
				'standard' => q(Стандардно време во Чиле),
			},
		},
		'China' => {
			long => {
				'daylight' => q(Летно сметање на времето во Кина),
				'generic' => q(Време во Кина),
				'standard' => q(Стандардно време во Кина),
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q(Летно време во Чојбалсан),
				'generic' => q(Време во Чојбалсан),
				'standard' => q(Стандардно време во Чојбалсан),
			},
		},
		'Christmas' => {
			long => {
				'standard' => q(Време на Божиќниот остров),
			},
		},
		'Cocos' => {
			long => {
				'standard' => q(Време на Кокосовите Острови),
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q(Летно сметање на времето во Колумбија),
				'generic' => q(Време во Колумбија),
				'standard' => q(Стандардно време во Колумбија),
			},
		},
		'Cook' => {
			long => {
				'daylight' => q(Летно време на Островите Кук),
				'generic' => q(Време на островите Кук),
				'standard' => q(Стандардно време на Островите Кук),
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q(Летно сметање на времето во Куба),
				'generic' => q(Време во Куба),
				'standard' => q(Стандардно време во Куба),
			},
		},
		'Davis' => {
			long => {
				'standard' => q(Време во Дејвис),
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q(Димон-дурвил време),
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q(Време во Источен Тимор),
			},
		},
		'Easter' => {
			long => {
				'daylight' => q(Летно време на Велигденскиот Остров),
				'generic' => q(Време на Велигденскиот Остров),
				'standard' => q(Стандардно време на Велигденскиот Остров),
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q(Време во Еквадор),
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#Непознато#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#Амстердам#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#Андора#,
		},
		'Europe/Athens' => {
			exemplarCity => q#Атина#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#Белград#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#Берлин#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#Братислава#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#Брисел#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#Букурешт#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#Будимпешта#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#Бисинген#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#Кишинау#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#Копенхаген#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#Даблин#,
			long => {
				'daylight' => q(Ирско летно време),
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#Гибралтар#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#Гернзи#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#Хелсинки#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#Остров Ман#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#Истанбул#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#Џерзи#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#Калининград#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#Киев#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#Лисабон#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#Љубљана#,
		},
		'Europe/London' => {
			exemplarCity => q#Лондон#,
			long => {
				'daylight' => q(Британско летно време),
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#Луксембург#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#Мадрид#,
		},
		'Europe/Malta' => {
			exemplarCity => q#Малта#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#Маријехамен#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#Минск#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#Монако#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#Москва#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#Осло#,
		},
		'Europe/Paris' => {
			exemplarCity => q#Париз#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#Подгорица#,
		},
		'Europe/Prague' => {
			exemplarCity => q#Прага#,
		},
		'Europe/Riga' => {
			exemplarCity => q#Рига#,
		},
		'Europe/Rome' => {
			exemplarCity => q#Рим#,
		},
		'Europe/Samara' => {
			exemplarCity => q#Самара#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#Сан Марино#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#Сараево#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#Симферопол#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#Скопје#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#Софија#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#Стокхолм#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#Талин#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#Тирана#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#Ужгород#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#Вадуц#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#Ватикан#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#Виена#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#Вилнус#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#Волгоград#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#Варшава#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#Загреб#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#Запорожје#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#Цирих#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q(Средноевропско летно сметање на времето),
				'generic' => q(Средноевропско време),
				'standard' => q(Средноевропско стандардно време),
			},
			short => {
				'daylight' => q(CEST),
				'generic' => q(CET),
				'standard' => q(CET),
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q(Источноевропско летно сметање на времето),
				'generic' => q(Источноевропско време),
				'standard' => q(Источноевропско стандардно време),
			},
			short => {
				'daylight' => q(EEST),
				'generic' => q(EET),
				'standard' => q(EET),
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q(Западноевропско летно сметање на времето),
				'generic' => q(Западноевропско време),
				'standard' => q(Западноевропско стандардно време),
			},
			short => {
				'daylight' => q(WEST),
				'generic' => q(WET),
				'standard' => q(WET),
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q(Летно сметање на времето на Фолкландските Острови),
				'generic' => q(Време на Фолкландските Острови),
				'standard' => q(Стандардно време на Фолкландските Острови),
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q(Летно време во Фиџи),
				'generic' => q(Време во Фиџи),
				'standard' => q(Стандардно време во Фиџи),
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q(Време во Француска Гвајана),
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q(Француско јужно и антарктичко време),
			},
		},
		'GMT' => {
			long => {
				'standard' => q(Средно време по Гринич),
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q(Време во Галапагос),
			},
		},
		'Gambier' => {
			long => {
				'standard' => q(Време во Гамбе),
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q(Летно време во Грузија),
				'generic' => q(Време во Грузија),
				'standard' => q(Стандардно време во Грузија),
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q(Време на Островите Гилберт),
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q(Летно сметање на времето во Источен Гренланд),
				'generic' => q(Време во Источен Гренланд),
				'standard' => q(Стандардно време во Источен Гренланд),
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q(Летно сметање на времето во Западен Гренланд),
				'generic' => q(Време во Западен Гренланд),
				'standard' => q(Стандардно време во Западен Гренланд),
			},
		},
		'Gulf' => {
			long => {
				'standard' => q(Време на Мексиканскиот Залив),
			},
		},
		'Guyana' => {
			long => {
				'standard' => q(Време во Гвајана),
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q(Летно сметање на времето во Хаваи - Алеутски острови),
				'generic' => q(Време во Хаваи - Алеутски острови),
				'standard' => q(Стандардно време во Хаваи - Алеутски острови),
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q(Летно време во Хонг Конг),
				'generic' => q(Време во Хонг Конг),
				'standard' => q(Стандардно време во Хонг Конг),
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q(Летно време во Ховд),
				'generic' => q(Време во Ховд),
				'standard' => q(Стандардно време во Ховд),
			},
		},
		'India' => {
			long => {
				'standard' => q(Време во Индија),
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#Антананариво#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#Чагос#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#Божиќен Остров#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#Кокосови Острови#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#Коморски Острови#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#Кергелен#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#Махе#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#Малдиви#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#Маврициус#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#Мајот#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#Ријунион#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q(Време на Индиски океан),
			},
		},
		'Indochina' => {
			long => {
				'standard' => q(Време во Индокина),
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q(Време во Централна Индонезија),
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q(Време во Источна Индонезија),
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q(Време во Западна Индонезија),
			},
		},
		'Iran' => {
			long => {
				'daylight' => q(Летно сметање на времето во Иран),
				'generic' => q(Време во Иран),
				'standard' => q(Стандардно време во Иран),
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q(Летно време во Иркутск),
				'generic' => q(Време во Иркутск),
				'standard' => q(Стандардно време во Иркутск),
			},
		},
		'Israel' => {
			long => {
				'daylight' => q(Летно сметање на времето во Израел),
				'generic' => q(Време во Израел),
				'standard' => q(Стандардно време во Израел),
			},
		},
		'Japan' => {
			long => {
				'daylight' => q(Летно сметање на времето во Јапонија),
				'generic' => q(Време во Јапонија),
				'standard' => q(Стандардно време во Јапонија),
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q(Време во Источен Казахстан),
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q(Време во Западен Казахстан),
			},
		},
		'Korea' => {
			long => {
				'daylight' => q(Летно сметање на времето во Кореја),
				'generic' => q(Време во Кореја),
				'standard' => q(Стандардно време во Кореја),
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q(Време во Косра),
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q(Летно време во Краснојарск),
				'generic' => q(Време во Краснојарск),
				'standard' => q(Стандардно време во Краснојарск),
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q(Време во Киргистан),
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q(Време во Линиски Острови),
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q(Летно сметање на времето во Лорд Хау),
				'generic' => q(Време во Лорд Хау),
				'standard' => q(Стандардно време во Лорд Хау),
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q(Време на Островот Макуари),
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q(Летно време во Магадан),
				'generic' => q(Време во Магадан),
				'standard' => q(Стандардно време во Магадан),
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q(Време во Малезија),
			},
		},
		'Maldives' => {
			long => {
				'standard' => q(Време на Малдиви),
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q(Време во Маркесас),
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q(Време на Маршалски острови),
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q(Летно сметање на времето на Маврициус),
				'generic' => q(Време на Маврициус),
				'standard' => q(Стандардно време на Маврициус),
			},
		},
		'Mawson' => {
			long => {
				'standard' => q(Време во Мосон),
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q(Летно време во Улан Батор),
				'generic' => q(Време во Улан Батор),
				'standard' => q(Стандардно време во Улан Батор),
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q(Летно сметање на времето во Москва),
				'generic' => q(Време во Москва),
				'standard' => q(Стандардно време во Москва),
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q(Време во Мјанмар),
			},
		},
		'Nauru' => {
			long => {
				'standard' => q(Време во Науру),
			},
		},
		'Nepal' => {
			long => {
				'standard' => q(Време во Непал),
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q(Летно време во Нова Каледонија),
				'generic' => q(Време во Нова Каледонија),
				'standard' => q(Стандардно време во Нова Каледонија),
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q(Летно сметање на времето во Нов Зеланд),
				'generic' => q(Време во Нов Зеланд),
				'standard' => q(Стандардно време во Нов Зеланд),
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q(Летно сметање на времето на Њуфаундленд),
				'generic' => q(Време на Њуфаундленд),
				'standard' => q(Стандардно време на Њуфаундленд),
			},
		},
		'Niue' => {
			long => {
				'standard' => q(Време во Ниуе),
			},
		},
		'Norfolk' => {
			long => {
				'standard' => q(Време на Островите Норфолк),
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q(Летно сметање на времето на Фернандо де Нороња),
				'generic' => q(Време на Фернандо де Нороња),
				'standard' => q(Стандардно време на Фернандо де Нороња),
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q(Летно време во Новосибирск),
				'generic' => q(Време во Новосибирск),
				'standard' => q(Стандардно време во Новосибирск),
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q(Летно време во Омск),
				'generic' => q(Време во Омск),
				'standard' => q(Стандардно време во Омск),
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#Апија#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#Окленд#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#Чатам#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#Велигденски Остров#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#Ефате#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#Ендербери#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#Факаофо#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#Фиџи#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#Фунафути#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#Галапагос#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#Гамбије#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#Гвадалканал#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#Гвам#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#Хонолулу#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#Џонстон#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#Киритимати#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#Косрае#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#Кваџалејн#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#Маџуро#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#Маркески Острови#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#Мидвеј#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#Науру#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#Ниуе#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#Норфолк#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#Нумеа#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#Паго Паго#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#Палау#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#Питкернски Острови#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#Понпеј#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#Порт Морсби#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#Раротонга#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#Сајпан#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#Тахити#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#Тарава#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#Тонгатапу#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#Чук#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#Вејк#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#Валис#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q(Летно време во Пакистан),
				'generic' => q(Време во Пакистан),
				'standard' => q(Стандардно време во Пакистан),
			},
		},
		'Palau' => {
			long => {
				'standard' => q(Време во Палау),
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q(Време во Папуа Нова Гвинеја),
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q(Летно сметање на времето во Парагвај),
				'generic' => q(Време во Парагвај),
				'standard' => q(Стандардно време во Парагвај),
			},
		},
		'Peru' => {
			long => {
				'daylight' => q(Летно сметање на времето во Перу),
				'generic' => q(Време во Перу),
				'standard' => q(Стандардно време во Перу),
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q(Летно време во Филипини),
				'generic' => q(Време во Филипини),
				'standard' => q(Стандардно време во Филипини),
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q(Време на Островите Феникс),
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q(Летно сметање на времето на Сент Пјер и Микелан),
				'generic' => q(Време на на Сент Пјер и Микелан),
				'standard' => q(Стандардно време на Сент Пјер и Микелан),
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q(Време во Питкерн),
			},
		},
		'Ponape' => {
			long => {
				'standard' => q(Време во Понапе),
			},
		},
		'Reunion' => {
			long => {
				'standard' => q(Време на Ријунион),
			},
		},
		'Rothera' => {
			long => {
				'standard' => q(Време во Ротера),
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q(Летно време во Сакалин),
				'generic' => q(Време во Сакалин),
				'standard' => q(Стандардно време во Сакалин),
			},
		},
		'Samara' => {
			long => {
				'daylight' => q(Самара летно сметање на времето),
				'generic' => q(Самара време),
				'standard' => q(Самара стандардно време),
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q(Летно време во Самоа),
				'generic' => q(Време во Самоа),
				'standard' => q(Стандардно време во Самоа),
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q(Време на Сејшели),
			},
		},
		'Singapore' => {
			long => {
				'standard' => q(Време во Сингапур),
			},
		},
		'Solomon' => {
			long => {
				'standard' => q(Време на Соломонските острови),
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q(Време во Јужна Грузија),
			},
		},
		'Suriname' => {
			long => {
				'standard' => q(Време во Суринам),
			},
		},
		'Syowa' => {
			long => {
				'standard' => q(Време во Сајова),
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q(Време во Тахити),
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q(Летно сметање на времето во Таипеи),
				'generic' => q(Време во Таипеи),
				'standard' => q(Стандардно време во Таипеи),
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q(Време во Таџикистан),
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q(Време во Токелау),
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q(Летно време во Тонга),
				'generic' => q(Време во Тонга),
				'standard' => q(Стандардно време во Тонга),
			},
		},
		'Truk' => {
			long => {
				'standard' => q(Време во Чуук),
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q(Летно време во Туркменистан),
				'generic' => q(Време во Туркменистан),
				'standard' => q(Стандардно време во Туркменистан),
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q(Време во Тувалу),
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q(Летно сметање на времето во Уругвај),
				'generic' => q(Време во Уругвај),
				'standard' => q(Стандардно време во Уругвај),
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q(Летно време во Узбекистан),
				'generic' => q(Време во Узбекистан),
				'standard' => q(Стандардно време во Узбекистан),
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q(Летно време во Вануату),
				'generic' => q(Време во Вануату),
				'standard' => q(Стандардно време во Вануату),
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q(Време во Венецуела),
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q(Летно време во Владивосток),
				'generic' => q(Време во Владивосток),
				'standard' => q(Стандардно време во Владивосток),
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q(Летно сметање на времето во Волгоград),
				'generic' => q(Време во Волгоград),
				'standard' => q(Стандардно време во Волгоград),
			},
		},
		'Vostok' => {
			long => {
				'standard' => q(Време во Восток),
			},
		},
		'Wake' => {
			long => {
				'standard' => q(Време на островот Вејк),
			},
		},
		'Wallis' => {
			long => {
				'standard' => q(Време во Валис и Футуна),
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q(Летно време во Јакутск),
				'generic' => q(Време во Јакутск),
				'standard' => q(Стандардно време во Јакутск),
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q(Летно време во Екатеринбург),
				'generic' => q(Време во Екатеринбург),
				'standard' => q(Стандардно време во Екатеринбург),
			},
		},
	 } }
);
no Moose;
__PACKAGE__->meta->make_immutable;

1;

# vim: tabstop=4
