=encoding utf8

=head1 NAME

Locale::CLDR::Locales::Uz::Cyrl - Package for language Uzbek

=cut

package Locale::CLDR::Locales::Uz::Cyrl;
# This file auto generated from Data\common\main\uz_Cyrl.xml
#	on Sun 25 Feb 10:41:40 am GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.44.0');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Root');
has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		 sub {
			 my %languages = (
				'aa' => 'афарча',
 				'ab' => 'абхазча',
 				'ace' => 'ачин',
 				'ada' => 'адангмэ',
 				'ady' => 'адигей',
 				'af' => 'африкаанс',
 				'agq' => 'агемча',
 				'ain' => 'айну',
 				'ak' => 'аканча',
 				'ale' => 'алеут',
 				'am' => 'амхарча',
 				'an' => 'арагон',
 				'anp' => 'ангика',
 				'ar' => 'арабча',
 				'ar_001' => 'стандарт арабча',
 				'arn' => 'мапудунгун',
 				'arp' => 'арапахо',
 				'as' => 'ассомча',
 				'asa' => 'асуча',
 				'ast' => 'астурийча',
 				'av' => 'аварча',
 				'awa' => 'авадхи',
 				'ay' => 'аймара',
 				'az' => 'озарбайжонча',
 				'az@alt=short' => 'озар',
 				'ba' => 'бошқирдча',
 				'ban' => 'балича',
 				'bas' => 'басаа',
 				'be' => 'беларусча',
 				'bem' => 'бемба',
 				'bez' => 'бенача',
 				'bg' => 'болгарча',
 				'bho' => 'бхожпури',
 				'bi' => 'бислама',
 				'bin' => 'бини',
 				'bm' => 'бамбарча',
 				'bn' => 'бенгалча',
 				'bo' => 'тибетча',
 				'br' => 'бретонча',
 				'brx' => 'бодоча',
 				'bs' => 'боснийча',
 				'bug' => 'бугийча',
 				'byn' => 'блинча',
 				'ca' => 'каталонча',
 				'ce' => 'чечен тили',
 				'ceb' => 'себуанча',
 				'cgg' => 'чигача',
 				'ch' => 'чаморро',
 				'chk' => 'чуукча',
 				'chm' => 'мари',
 				'cho' => 'чоктавча',
 				'chr' => 'чероки',
 				'chy' => 'шайенн',
 				'ckb' => 'сорани-курдча',
 				'co' => 'корсиканча',
 				'cs' => 'чехча',
 				'cu' => 'славянча (черков)',
 				'cv' => 'чуваш тили',
 				'cy' => 'уэлсча',
 				'da' => 'датча',
 				'dak' => 'дакотча',
 				'dar' => 'даргинча',
 				'dav' => 'таитача',
 				'de' => 'немисча',
 				'dgr' => 'догриб',
 				'dje' => 'зарма',
 				'dsb' => 'қуйи-сорбча',
 				'dua' => 'дуалача',
 				'dv' => 'дивехи',
 				'dyo' => 'диола-фогни',
 				'dz' => 'дзонгка',
 				'dzg' => 'дазага',
 				'ebu' => 'эмбуча',
 				'ee' => 'эвеча',
 				'efi' => 'эфик',
 				'eka' => 'экажук',
 				'el' => 'грекча',
 				'en' => 'инглизча',
 				'en_GB' => 'инглизча (Британия)',
 				'en_US' => 'инглизча (Америка)',
 				'en_US@alt=short' => 'инглизча (АҚШ)',
 				'eo' => 'эсперанто',
 				'es' => 'испанча',
 				'et' => 'эстонча',
 				'eu' => 'баскча',
 				'ewo' => 'эвондонча',
 				'fa' => 'форсий',
 				'ff' => 'фулаҳ',
 				'fi' => 'финча',
 				'fil' => 'филипинча',
 				'fj' => 'фижича',
 				'fo' => 'фарерча',
 				'fon' => 'фон',
 				'fr' => 'французча',
 				'fur' => 'фриулча',
 				'fy' => 'ғарбий фризча',
 				'ga' => 'ирландча',
 				'gaa' => 'га',
 				'gd' => 'шотландча гаелик',
 				'gez' => 'геэз',
 				'gil' => 'гилбертча',
 				'gl' => 'галицийча',
 				'gn' => 'гуарани',
 				'gor' => 'горонтало',
 				'gu' => 'гужаротча',
 				'guz' => 'гусии',
 				'gv' => 'мэнча',
 				'gwi' => 'гвичин',
 				'ha' => 'хауса',
 				'haw' => 'гавайча',
 				'he' => 'иброний',
 				'hi' => 'ҳинди',
 				'hil' => 'хилигайнон',
 				'hmn' => 'хмонгча',
 				'hr' => 'хорватча',
 				'hsb' => 'юқори сорбча',
 				'ht' => 'гаитянча',
 				'hu' => 'венгерча',
 				'hup' => 'хупа тили',
 				'hy' => 'арманча',
 				'hz' => 'гереро',
 				'ia' => 'интерлингва',
 				'iba' => 'ибан тили',
 				'ibb' => 'ибибо',
 				'id' => 'индонезча',
 				'ig' => 'игбо',
 				'ilo' => 'илоко',
 				'inh' => 'ингушча',
 				'io' => 'идо',
 				'is' => 'исландча',
 				'it' => 'италянча',
 				'iu' => 'инуктитут',
 				'ja' => 'японча',
 				'jgo' => 'нгомба',
 				'jmc' => 'мачаме тили',
 				'jv' => 'яванча',
 				'ka' => 'грузинча',
 				'kab' => 'кабилча',
 				'kaj' => 'кажи',
 				'kam' => 'камбача',
 				'kde' => 'макондеча',
 				'kea' => 'кабувердиану',
 				'khq' => 'койра-чиини',
 				'ki' => 'кикую',
 				'kk' => 'қозоқча',
 				'kkj' => 'како',
 				'kl' => 'гренландча',
 				'kln' => 'каленжинча',
 				'km' => 'хмерча',
 				'kn' => 'каннада',
 				'ko' => 'корейсча',
 				'kok' => 'конканча',
 				'kr' => 'канури',
 				'ks' => 'кашмирча',
 				'ksb' => 'шамбала',
 				'ksf' => 'бафияча',
 				'ksh' => 'кёлнча',
 				'ku' => 'курдча',
 				'kw' => 'корнча',
 				'ky' => 'қирғизча',
 				'la' => 'лотинча',
 				'lag' => 'лангича',
 				'lb' => 'люксембургча',
 				'lg' => 'гандача',
 				'lkt' => 'лакотачалакотача',
 				'ln' => 'лингалча',
 				'lo' => 'лаосча',
 				'lrc' => 'шимолий лури',
 				'lt' => 'литвача',
 				'lu' => 'луба-катанга',
 				'lus' => 'лушай',
 				'luy' => 'луҳя',
 				'lv' => 'латишча',
 				'mas' => 'масайча',
 				'mdf' => 'мокша тили',
 				'men' => 'менде',
 				'mer' => 'меруча',
 				'mfe' => 'морисьен',
 				'mg' => 'малагасийча',
 				'mgh' => 'махува-митто',
 				'mgo' => 'мета',
 				'mh' => 'маршалл тили',
 				'mi' => 'маори',
 				'mic' => 'микмак',
 				'min' => 'минангкабау',
 				'mk' => 'македонча',
 				'ml' => 'малаялам',
 				'mn' => 'мўғулча',
 				'mni' => 'манипурча',
 				'moh' => 'могавк',
 				'mos' => 'мосси',
 				'mr' => 'маратхи',
 				'ms' => 'малай тил',
 				'mt' => 'малтача',
 				'mua' => 'мунданг',
 				'mul' => 'бир нечта тил',
 				'mus' => 'крикча',
 				'mwl' => 'мирандес',
 				'my' => 'бирманча',
 				'myv' => 'эрзянча',
 				'mzn' => 'мазандеран',
 				'naq' => 'нама',
 				'nb' => 'норвегча бокмал',
 				'nd' => 'шимолий ндебеле',
 				'ne' => 'непалча',
 				'niu' => 'ниуэча',
 				'nl' => 'голландча',
 				'nl_BE' => 'фламандча',
 				'nmg' => 'квасио',
 				'nn' => 'норвегча нюнорск',
 				'nnh' => 'нгиембун',
 				'nqo' => 'нко',
 				'nr' => 'жанубий ндебелча',
 				'nus' => 'нуэрча',
 				'ny' => 'чева',
 				'nyn' => 'нянколе',
 				'oc' => 'окситанча',
 				'om' => 'оромо',
 				'or' => 'одия',
 				'pa' => 'панжобча',
 				'pap' => 'папияменто',
 				'pl' => 'полякча',
 				'ps' => 'пушту',
 				'pt' => 'португалча',
 				'qu' => 'кечуа',
 				'quc' => 'кичэ',
 				'rm' => 'романшча',
 				'rn' => 'рунди',
 				'ro' => 'руминча',
 				'rof' => 'ромбоча',
 				'ru' => 'русча',
 				'rup' => 'арумин',
 				'rw' => 'киняруанда',
 				'rwk' => 'руанда тили',
 				'sa' => 'санскрит',
 				'sah' => 'саха',
 				'saq' => 'самбуруча',
 				'sat' => 'сантали',
 				'sbp' => 'сангуча',
 				'sd' => 'синдҳи',
 				'se' => 'шимолий саамча',
 				'seh' => 'сена',
 				'ses' => 'койраборо-сенни',
 				'sg' => 'санго',
 				'shi' => 'ташелхит',
 				'si' => 'сингалча',
 				'sk' => 'словакча',
 				'sl' => 'словенча',
 				'sma' => 'жанубий саамча',
 				'smj' => 'луле-саамча',
 				'smn' => 'инари-саамча',
 				'sms' => 'сколт-саамча',
 				'sn' => 'шона',
 				'so' => 'сомалича',
 				'sq' => 'албанча',
 				'sr' => 'сербча',
 				'ss' => 'свати',
 				'ssy' => 'саҳоча',
 				'su' => 'сунданча',
 				'sv' => 'шведча',
 				'sw' => 'суахили',
 				'sw_CD' => 'конго-суахили',
 				'swb' => 'коморча',
 				'syr' => 'сурияча',
 				'ta' => 'тамилча',
 				'te' => 'телугу',
 				'teo' => 'тесо',
 				'tg' => 'тожикча',
 				'th' => 'тайча',
 				'ti' => 'тигриняча',
 				'tig' => 'тигре',
 				'tk' => 'туркманча',
 				'to' => 'тонганча',
 				'tr' => 'туркча',
 				'tt' => 'татарча',
 				'twq' => 'тасавак',
 				'tzm' => 'марказий атлас тамазигхт',
 				'ug' => 'уйғурча',
 				'uk' => 'украинча',
 				'und' => 'номаълум тил',
 				'ur' => 'урду',
 				'uz' => 'ўзбекча',
 				'vai' => 'ваи',
 				've' => 'венда',
 				'vi' => 'ветнамча',
 				'vo' => 'волапюк',
 				'vun' => 'вунжо',
 				'wae' => 'валсерча',
 				'wal' => 'волятта',
 				'wo' => 'волофча',
 				'xh' => 'хоса',
 				'xog' => 'сога',
 				'yav' => 'янгбен',
 				'yi' => 'иддиш',
 				'yo' => 'йоруба',
 				'yue' => 'кантонча',
 				'zgh' => 'тамазигхт',
 				'zh' => 'хитойча',
 				'zh_Hans' => 'соддалаштирилган хитойча',
 				'zh_Hant' => 'анъанавий хитойча',
 				'zu' => 'зулу',
 				'zxx' => 'Тил таркиби йўқ',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Arab' => 'Араб',
 			'Armn' => 'Арман',
 			'Beng' => 'Бенгали',
 			'Bopo' => 'Бопомофо',
 			'Brai' => 'Браилле',
 			'Cyrl' => 'Кирил',
 			'Deva' => 'Девангари',
 			'Ethi' => 'Ҳабаш',
 			'Geor' => 'Грузин',
 			'Grek' => 'Юнон',
 			'Gujr' => 'Гужарати',
 			'Guru' => 'Гурмухи',
 			'Hang' => 'Хангул',
 			'Hani' => 'Хан',
 			'Hans' => 'Соддалаштирилган',
 			'Hant' => 'Анъанавий',
 			'Hebr' => 'Иброний',
 			'Hira' => 'Хирагана',
 			'Jpan' => 'Япон',
 			'Kana' => 'Катакана',
 			'Khmr' => 'Хмер',
 			'Knda' => 'Каннада',
 			'Kore' => 'Корейс',
 			'Laoo' => 'Лао',
 			'Latn' => 'Лотин',
 			'Mlym' => 'Малайалам',
 			'Mong' => 'Мўғулча',
 			'Mymr' => 'Мьянма',
 			'Orya' => 'Ория',
 			'Sinh' => 'Синхала',
 			'Taml' => 'Тамил',
 			'Telu' => 'Телугу',
 			'Thaa' => 'Таана',
 			'Thai' => 'Тай',
 			'Tibt' => 'Тибет',
 			'Zsym' => 'Рамзлар',
 			'Zxxx' => 'Ёзилмаган',
 			'Zyyy' => 'Умумий',
 			'Zzzz' => 'Номаълум шрифт',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'001' => 'Дунё',
 			'002' => 'Африка',
 			'003' => 'Шимолий Америка',
 			'005' => 'Жанубий Америка',
 			'009' => 'Океания',
 			'011' => 'Ғарбий Африка',
 			'013' => 'Марказий Америка',
 			'014' => 'Шарқий Африка',
 			'015' => 'Шимолий Африка',
 			'017' => 'Марказий Африка',
 			'018' => 'Жануби-Африка',
 			'019' => 'Америка',
 			'021' => 'Шимоли-Америка',
 			'029' => 'Кариб ҳавзаси',
 			'030' => 'Шарқий Осиё',
 			'034' => 'Жанубий Осиё',
 			'035' => 'Жанубий-Шарқий Осиё',
 			'039' => 'Жанубий Европа',
 			'053' => 'Австралазия',
 			'054' => 'Меланезия',
 			'057' => 'Микронезия минтақаси',
 			'061' => 'Полинезия',
 			'142' => 'Осиё',
 			'143' => 'Марказий Осиё',
 			'145' => 'Ғарбий Осиё',
 			'150' => 'Европа',
 			'151' => 'Шарқий Европа',
 			'154' => 'Шимолий Европа',
 			'155' => 'Ғарбий Европа',
 			'419' => 'Лотин Америкаси',
 			'AC' => 'Меърож ороли',
 			'AD' => 'Андорра',
 			'AE' => 'Бирлашган Араб Амирликлари',
 			'AF' => 'Афғонистон',
 			'AG' => 'Антигуа ва Барбуда',
 			'AI' => 'Ангилья',
 			'AL' => 'Албания',
 			'AM' => 'Арманистон',
 			'AO' => 'Ангола',
 			'AQ' => 'Антарктида',
 			'AR' => 'Аргентина',
 			'AS' => 'Америка Самоаси',
 			'AT' => 'Австрия',
 			'AU' => 'Австралия',
 			'AW' => 'Аруба',
 			'AX' => 'Аланд ороллари',
 			'AZ' => 'Озарбайжон',
 			'BA' => 'Босния ва Герцеговина',
 			'BB' => 'Барбадос',
 			'BD' => 'Бангладеш',
 			'BE' => 'Бельгия',
 			'BF' => 'Буркина-Фасо',
 			'BG' => 'Болгария',
 			'BH' => 'Баҳрайн',
 			'BI' => 'Бурунди',
 			'BJ' => 'Бенин',
 			'BL' => 'Сен-Бартелеми',
 			'BM' => 'Бермуда',
 			'BN' => 'Бруней',
 			'BO' => 'Боливия',
 			'BQ' => 'Бонейр, Синт-Эстатиус ва Саба',
 			'BR' => 'Бразилия',
 			'BS' => 'Багама ороллари',
 			'BT' => 'Бутан',
 			'BV' => 'Буве ороли',
 			'BW' => 'Ботсванна',
 			'BY' => 'Беларус',
 			'BZ' => 'Белиз',
 			'CA' => 'Канада',
 			'CC' => 'Кокос (Килинг) ороллари',
 			'CD' => 'Конго-Киншаса',
 			'CD@alt=variant' => 'Конго (КДР)',
 			'CF' => 'Марказий Африка Республикаси',
 			'CG' => 'Конго Браззавиль',
 			'CG@alt=variant' => 'Конго (Республика)',
 			'CH' => 'Швейцария',
 			'CI' => 'Кот-д’Ивуар',
 			'CI@alt=variant' => 'Фил Суяги Қирғоғи',
 			'CK' => 'Кук ороллари',
 			'CL' => 'Чили',
 			'CM' => 'Камерун',
 			'CN' => 'Хитой',
 			'CO' => 'Колумбия',
 			'CP' => 'Клиппертон ороли',
 			'CR' => 'Коста-Рика',
 			'CU' => 'Куба',
 			'CV' => 'Кабо-Верде',
 			'CW' => 'Кюрасао',
 			'CX' => 'Рождество ороли',
 			'CY' => 'Кипр',
 			'CZ' => 'Чехия',
 			'CZ@alt=variant' => 'Чехия Республикаси',
 			'DE' => 'Германия',
 			'DG' => 'Диего-Гарсия',
 			'DJ' => 'Жибути',
 			'DK' => 'Дания',
 			'DM' => 'Доминика',
 			'DO' => 'Доминикан Республикаси',
 			'DZ' => 'Жазоир',
 			'EA' => 'Сэута ва Мелилла',
 			'EC' => 'Эквадор',
 			'EE' => 'Эстония',
 			'EG' => 'Миср',
 			'EH' => 'Ғарбий Саҳрои Кабир',
 			'ER' => 'Эритрея',
 			'ES' => 'Испания',
 			'ET' => 'Эфиопия',
 			'EU' => 'Европа Иттифоқи',
 			'FI' => 'Финляндия',
 			'FJ' => 'Фижи',
 			'FK' => 'Фолкленд ороллари',
 			'FK@alt=variant' => 'Фолкленд (Малвин) ороллари',
 			'FM' => 'Микронезия',
 			'FO' => 'Фарер ороллари',
 			'FR' => 'Франция',
 			'GA' => 'Габон',
 			'GB' => 'Буюк Британия',
 			'GD' => 'Гренада',
 			'GE' => 'Грузия',
 			'GF' => 'Француз Гвианаси',
 			'GG' => 'Гернси',
 			'GH' => 'Гана',
 			'GI' => 'Гибралтар',
 			'GL' => 'Гренландия',
 			'GM' => 'Гамбия',
 			'GN' => 'Гвинея',
 			'GP' => 'Гваделупе',
 			'GQ' => 'Экваториал Гвинея',
 			'GR' => 'Греция',
 			'GS' => 'Жанубий Георгия ва Жанубий Сендвич ороллари',
 			'GT' => 'Гватемала',
 			'GU' => 'Гуам',
 			'GW' => 'Гвинея-Бисау',
 			'GY' => 'Гаяна',
 			'HK' => 'Гонконг (Хитой ММҲ)',
 			'HK@alt=short' => 'Гонконг',
 			'HM' => 'Херд ва Макдоналд ороллари',
 			'HN' => 'Гондурас',
 			'HR' => 'Хорватия',
 			'HT' => 'Гаити',
 			'HU' => 'Венгрия',
 			'IC' => 'Канар ороллари',
 			'ID' => 'Индонезия',
 			'IE' => 'Ирландия',
 			'IL' => 'Исроил',
 			'IM' => 'Мэн ороли',
 			'IN' => 'Ҳиндистон',
 			'IO' => 'Британиянинг Ҳинд океанидаги ҳудуди',
 			'IQ' => 'Ироқ',
 			'IR' => 'Эрон',
 			'IS' => 'Исландия',
 			'IT' => 'Италия',
 			'JE' => 'Жерси',
 			'JM' => 'Ямайка',
 			'JO' => 'Иордания',
 			'JP' => 'Япония',
 			'KE' => 'Кения',
 			'KG' => 'Қирғизистон',
 			'KH' => 'Камбоджа',
 			'KI' => 'Кирибати',
 			'KM' => 'Комор ороллари',
 			'KN' => 'Сент-Китс ва Невис',
 			'KP' => 'Шимолий Корея',
 			'KR' => 'Жанубий Корея',
 			'KW' => 'Қувайт',
 			'KY' => 'Кайман ороллари',
 			'KZ' => 'Қозоғистон',
 			'LA' => 'Лаос',
 			'LB' => 'Ливан',
 			'LC' => 'Сент-Люсия',
 			'LI' => 'Лихтенштейн',
 			'LK' => 'Шри-Ланка',
 			'LR' => 'Либерия',
 			'LS' => 'Лесото',
 			'LT' => 'Литва',
 			'LU' => 'Люксембург',
 			'LV' => 'Латвия',
 			'LY' => 'Ливия',
 			'MA' => 'Марокаш',
 			'MC' => 'Монако',
 			'MD' => 'Молдова',
 			'ME' => 'Черногория',
 			'MF' => 'Сент-Мартин',
 			'MG' => 'Мадагаскар',
 			'MH' => 'Маршал ороллари',
 			'MK' => 'Шимолий Македония',
 			'ML' => 'Мали',
 			'MM' => 'Мьянма (Бирма)',
 			'MN' => 'Монголия',
 			'MO' => 'Макао (Хитой ММҲ)',
 			'MO@alt=short' => 'Макао',
 			'MP' => 'Шимолий Марианна ороллари',
 			'MQ' => 'Мартиника',
 			'MR' => 'Мавритания',
 			'MS' => 'Монтсеррат',
 			'MT' => 'Мальта',
 			'MU' => 'Маврикий',
 			'MV' => 'Мальдив ороллари',
 			'MW' => 'Малави',
 			'MX' => 'Мексика',
 			'MY' => 'Малайзия',
 			'MZ' => 'Мозамбик',
 			'NA' => 'Намибия',
 			'NC' => 'Янги Каледония',
 			'NE' => 'Нигер',
 			'NF' => 'Норфолк ороллари',
 			'NG' => 'Нигерия',
 			'NI' => 'Никарагуа',
 			'NL' => 'Нидерландия',
 			'NO' => 'Норвегия',
 			'NP' => 'Непал',
 			'NR' => 'Науру',
 			'NU' => 'Ниуэ',
 			'NZ' => 'Янги Зеландия',
 			'OM' => 'Уммон',
 			'PA' => 'Панама',
 			'PE' => 'Перу',
 			'PF' => 'Француз Полинезияси',
 			'PG' => 'Папуа - Янги Гвинея',
 			'PH' => 'Филиппин',
 			'PK' => 'Покистон',
 			'PL' => 'Польша',
 			'PM' => 'Сент-Пьер ва Микелон',
 			'PN' => 'Питкэрн ороллари',
 			'PR' => 'Пуэрто-Рико',
 			'PS' => 'Фаластин ҳудуди',
 			'PS@alt=short' => 'Фаластин',
 			'PT' => 'Португалия',
 			'PW' => 'Палау',
 			'PY' => 'Парагвай',
 			'QA' => 'Қатар',
 			'QO' => 'Ёндош Океания',
 			'RE' => 'Реюнион',
 			'RO' => 'Руминия',
 			'RS' => 'Сербия',
 			'RU' => 'Россия',
 			'RW' => 'Руанда',
 			'SA' => 'Саудия Арабистони',
 			'SB' => 'Соломон ороллари',
 			'SC' => 'Сейшел ороллари',
 			'SD' => 'Судан',
 			'SE' => 'Швеция',
 			'SG' => 'Сингапур',
 			'SH' => 'Муқаддас Елена ороли',
 			'SI' => 'Словения',
 			'SJ' => 'Свалбард ва Ян-Майен',
 			'SK' => 'Словакия',
 			'SL' => 'Сьерра-Леоне',
 			'SM' => 'Сан-Марино',
 			'SN' => 'Сенегал',
 			'SO' => 'Сомали',
 			'SR' => 'Суринам',
 			'SS' => 'Жанубий Судан',
 			'ST' => 'Сан-Томе ва Принсипи',
 			'SV' => 'Салвадор',
 			'SX' => 'Синт-Мартен',
 			'SY' => 'Сурия',
 			'SZ' => 'Свазиленд',
 			'TA' => 'Тристан-да-Куня',
 			'TC' => 'Туркс ва Кайкос ороллари',
 			'TD' => 'Чад',
 			'TF' => 'Француз жанубий ҳудудлари',
 			'TG' => 'Того',
 			'TH' => 'Таиланд',
 			'TJ' => 'Тожикистон',
 			'TK' => 'Токелау',
 			'TL' => 'Тимор-Лесте',
 			'TL@alt=variant' => 'Шарқий Тимор',
 			'TM' => 'Туркманистон',
 			'TN' => 'Тунис',
 			'TO' => 'Тонга',
 			'TR' => 'Туркия',
 			'TT' => 'Тринидад ва Тобаго',
 			'TV' => 'Тувалу',
 			'TW' => 'Тайван',
 			'TZ' => 'Танзания',
 			'UA' => 'Украина',
 			'UG' => 'Уганда',
 			'UM' => 'АҚШ ёндош ороллари',
 			'US' => 'Америка Қўшма Штатлари',
 			'US@alt=short' => 'АҚШ',
 			'UY' => 'Уругвай',
 			'UZ' => 'Ўзбекистон',
 			'VA' => 'Ватикан',
 			'VC' => 'Сент-Винсент ва Гренадин',
 			'VE' => 'Венесуэла',
 			'VG' => 'Британия Виргин ороллари',
 			'VI' => 'АҚШ Виргин ороллари',
 			'VN' => 'Вьетнам',
 			'VU' => 'Вануату',
 			'WF' => 'Уоллис ва Футуна',
 			'WS' => 'Самоа',
 			'XK' => 'Косово',
 			'YE' => 'Яман',
 			'YT' => 'Майотта',
 			'ZA' => 'Жанубий Африка Республикаси',
 			'ZM' => 'Замбия',
 			'ZW' => 'Зимбабве',
 			'ZZ' => 'Номаълум минтақа',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => 'Календарь',
 			'collation' => 'Саралаш тартиби',
 			'currency' => 'Валюта',
 			'numbers' => 'Рақамлар',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[Str]],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'gregorian' => q{Григориан календари},
 			},
 			'collation' => {
 				'ducet' => q{Сукут бўйича саралаш тартиби},
 				'search' => q{Умумий қидириш},
 				'standard' => q{Стандарт саралаш тартиби},
 			},
 			'numbers' => {
 				'arab' => q{Араб-ҳинд рақамлари},
 				'arabext' => q{Кенгайтирилган араб-ҳинд рақамлари},
 				'armn' => q{Арман сонлари},
 				'armnlow' => q{Арман кичик сонлари},
 				'beng' => q{Бенгали рақамлари},
 				'deva' => q{Деванагари рақамлари},
 				'ethi' => q{Ҳабаш сонлари},
 				'fullwide' => q{Тўлиқ кенгликдаги рақамлар},
 				'geor' => q{Грузин сонлари},
 				'grek' => q{Грек сонлари},
 				'greklow' => q{Грек кичик сонлари},
 				'gujr' => q{Гужарати рақамлари},
 				'guru' => q{Гурмухи рақамлари},
 				'hanidec' => q{Хитой ўнлик сонлари},
 				'hans' => q{Соддалаштирилган Хитой сонлари},
 				'hansfin' => q{Соддалаштирилган Хитой молия сонлари},
 				'hant' => q{Анъанавий Хитой сонлари},
 				'hantfin' => q{Анъанавий Хитой молия сонлари},
 				'hebr' => q{Иброний сонлари},
 				'jpan' => q{Япония сонлари},
 				'jpanfin' => q{Япония молия сонлари},
 				'khmr' => q{Хмер рақамлари},
 				'knda' => q{Каннада рақамлари},
 				'laoo' => q{Лао рақамлари},
 				'latn' => q{Ғарб рақамлари},
 				'mlym' => q{Малайалам рақамлари},
 				'mymr' => q{Мьянма рақамлари},
 				'orya' => q{Ория рақамлари},
 				'roman' => q{Рим сонлари},
 				'romanlow' => q{Рим кичик сонлари},
 				'taml' => q{Анъанавий Тамил сонлари},
 				'tamldec' => q{Тамил рақамлари},
 				'telu' => q{Телугу рақамлари},
 				'thai' => q{Тай рақамлари},
 				'tibt' => q{Тибет рақамлари},
 			},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'language' => 'Тил: {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{[ц щ ы ь]},
			index => ['А', 'Б', 'В', 'Г', 'Ғ', 'Д', 'Е', 'Ж', 'З', 'И', 'Й', 'К', 'Қ', 'Л', 'М', 'Н', 'О', 'П', 'Р', 'С', 'Т', 'УЎ', 'Ф', 'Х', 'Ҳ', 'Ч', 'Ш', 'Ъ', 'Э', 'Ю', 'Я'],
			main => qr{[а б в г ғ д её ж з и й к қ л м н о п р с т уў ф х ҳ ч ш ъ э ю я]},
			numbers => qr{[  \- ‑ , % ‰ + 0 1 2 3 4 5 6 7 8 9]},
		};
	},
EOT
: sub {
		return { index => ['А', 'Б', 'В', 'Г', 'Ғ', 'Д', 'Е', 'Ж', 'З', 'И', 'Й', 'К', 'Қ', 'Л', 'М', 'Н', 'О', 'П', 'Р', 'С', 'Т', 'УЎ', 'Ф', 'Х', 'Ҳ', 'Ч', 'Ш', 'Ъ', 'Э', 'Ю', 'Я'], };
},
);


has 'units' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[HashRef[Str]]],
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					# Long Unit Identifier
					'duration-millisecond' => {
						'one' => q({0} миллисония),
						'other' => q({0} миллисония),
					},
					# Core Unit Identifier
					'millisecond' => {
						'one' => q({0} миллисония),
						'other' => q({0} миллисония),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'one' => q({0} дақиқа),
						'other' => q({0} дақиқа),
					},
					# Core Unit Identifier
					'minute' => {
						'one' => q({0} дақиқа),
						'other' => q({0} дақиқа),
					},
					# Long Unit Identifier
					'duration-week' => {
						'one' => q({0} ҳафта),
						'other' => q({0} ҳафта),
					},
					# Core Unit Identifier
					'week' => {
						'one' => q({0} ҳафта),
						'other' => q({0} ҳафта),
					},
					# Long Unit Identifier
					'duration-year' => {
						'one' => q({0} йил),
						'other' => q({0} йил),
					},
					# Core Unit Identifier
					'year' => {
						'one' => q({0} йил),
						'other' => q({0} йил),
					},
				},
				'narrow' => {
					# Long Unit Identifier
					'duration-day' => {
						'one' => q({0} к),
						'other' => q({0} к),
					},
					# Core Unit Identifier
					'day' => {
						'one' => q({0} к),
						'other' => q({0} к),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'one' => q({0} с),
						'other' => q({0} с),
					},
					# Core Unit Identifier
					'hour' => {
						'one' => q({0} с),
						'other' => q({0} с),
					},
					# Long Unit Identifier
					'duration-second' => {
						'one' => q({0} сон),
						'other' => q({0} сон),
					},
					# Core Unit Identifier
					'second' => {
						'one' => q({0} сон),
						'other' => q({0} сон),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Core Unit Identifier
					'celsius' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
				},
				'short' => {
					# Long Unit Identifier
					'acceleration-g-force' => {
						'name' => q(G),
					},
					# Core Unit Identifier
					'g-force' => {
						'name' => q(G),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'name' => q(′),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'name' => q(′),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'name' => q(″),
					},
					# Core Unit Identifier
					'arc-second' => {
						'name' => q(″),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'name' => q(°),
					},
					# Core Unit Identifier
					'degree' => {
						'name' => q(°),
					},
					# Long Unit Identifier
					'area-acre' => {
						'name' => q(ac),
					},
					# Core Unit Identifier
					'acre' => {
						'name' => q(ac),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'name' => q(ha),
					},
					# Core Unit Identifier
					'hectare' => {
						'name' => q(ha),
					},
					# Long Unit Identifier
					'duration-day' => {
						'name' => q(кун),
						'one' => q({0} кун),
						'other' => q({0} кун),
					},
					# Core Unit Identifier
					'day' => {
						'name' => q(кун),
						'one' => q({0} кун),
						'other' => q({0} кун),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'name' => q(соат),
						'one' => q({0} соат),
						'other' => q({0} соат),
					},
					# Core Unit Identifier
					'hour' => {
						'name' => q(соат),
						'one' => q({0} соат),
						'other' => q({0} соат),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'name' => q(миллисония),
						'one' => q({0} мс),
						'other' => q({0} мс),
					},
					# Core Unit Identifier
					'millisecond' => {
						'name' => q(миллисония),
						'one' => q({0} мс),
						'other' => q({0} мс),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'name' => q(дақиқа),
						'one' => q({0} дақ),
						'other' => q({0} дақ),
					},
					# Core Unit Identifier
					'minute' => {
						'name' => q(дақиқа),
						'one' => q({0} дақ),
						'other' => q({0} дақ),
					},
					# Long Unit Identifier
					'duration-month' => {
						'name' => q(ой),
						'one' => q({0} ой),
						'other' => q({0} ой),
					},
					# Core Unit Identifier
					'month' => {
						'name' => q(ой),
						'one' => q({0} ой),
						'other' => q({0} ой),
					},
					# Long Unit Identifier
					'duration-second' => {
						'name' => q(сония),
						'one' => q({0} сония),
						'other' => q({0} сония),
					},
					# Core Unit Identifier
					'second' => {
						'name' => q(сония),
						'one' => q({0} сония),
						'other' => q({0} сония),
					},
					# Long Unit Identifier
					'duration-week' => {
						'name' => q(ҳафта),
						'one' => q({0} ҳафт),
						'other' => q({0} ҳафт),
					},
					# Core Unit Identifier
					'week' => {
						'name' => q(ҳафта),
						'one' => q({0} ҳафт),
						'other' => q({0} ҳафт),
					},
					# Long Unit Identifier
					'duration-year' => {
						'name' => q(йил),
						'one' => q({0} й),
						'other' => q({0} й),
					},
					# Core Unit Identifier
					'year' => {
						'name' => q(йил),
						'one' => q({0} й),
						'other' => q({0} й),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'name' => q(см),
						'one' => q({0} см),
						'other' => q({0} см),
					},
					# Core Unit Identifier
					'centimeter' => {
						'name' => q(см),
						'one' => q({0} см),
						'other' => q({0} см),
					},
					# Long Unit Identifier
					'length-foot' => {
						'name' => q(фут),
						'one' => q({0} фут),
						'other' => q({0} фут),
					},
					# Core Unit Identifier
					'foot' => {
						'name' => q(фут),
						'one' => q({0} фут),
						'other' => q({0} фут),
					},
					# Long Unit Identifier
					'length-inch' => {
						'name' => q(дюйм),
						'one' => q({0} дюйм),
						'other' => q({0} дюйм),
					},
					# Core Unit Identifier
					'inch' => {
						'name' => q(дюйм),
						'one' => q({0} дюйм),
						'other' => q({0} дюйм),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'name' => q(км),
						'one' => q({0} км),
						'other' => q({0} км),
					},
					# Core Unit Identifier
					'kilometer' => {
						'name' => q(км),
						'one' => q({0} км),
						'other' => q({0} км),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'name' => q(ё.й.),
						'one' => q({0} ё.й.),
						'other' => q({0} ё.й.),
					},
					# Core Unit Identifier
					'light-year' => {
						'name' => q(ё.й.),
						'one' => q({0} ё.й.),
						'other' => q({0} ё.й.),
					},
					# Long Unit Identifier
					'length-meter' => {
						'name' => q(м),
						'one' => q({0} м),
						'other' => q({0} м),
					},
					# Core Unit Identifier
					'meter' => {
						'name' => q(м),
						'one' => q({0} м),
						'other' => q({0} м),
					},
					# Long Unit Identifier
					'length-mile' => {
						'name' => q(миля),
						'one' => q({0} миля),
						'other' => q({0} миля),
					},
					# Core Unit Identifier
					'mile' => {
						'name' => q(миля),
						'one' => q({0} миля),
						'other' => q({0} миля),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'name' => q(мм),
						'one' => q({0} мм),
						'other' => q({0} мм),
					},
					# Core Unit Identifier
					'millimeter' => {
						'name' => q(мм),
						'one' => q({0} мм),
						'other' => q({0} мм),
					},
					# Long Unit Identifier
					'length-picometer' => {
						'name' => q(пм),
						'one' => q({0} пм),
						'other' => q({0} пм),
					},
					# Core Unit Identifier
					'picometer' => {
						'name' => q(пм),
						'one' => q({0} пм),
						'other' => q({0} пм),
					},
					# Long Unit Identifier
					'length-yard' => {
						'name' => q(ярд),
						'one' => q({0} ярд),
						'other' => q({0} ярд),
					},
					# Core Unit Identifier
					'yard' => {
						'name' => q(ярд),
						'one' => q({0} ярд),
						'other' => q({0} ярд),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'name' => q(г),
						'one' => q({0} г),
						'other' => q({0} г),
					},
					# Core Unit Identifier
					'gram' => {
						'name' => q(г),
						'one' => q({0} г),
						'other' => q({0} г),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'name' => q(кг),
						'one' => q({0} кг),
						'other' => q({0} кг),
					},
					# Core Unit Identifier
					'kilogram' => {
						'name' => q(кг),
						'one' => q({0} кг),
						'other' => q({0} кг),
					},
					# Long Unit Identifier
					'mass-ounce' => {
						'name' => q(унция),
						'one' => q({0} унция),
						'other' => q({0} унция),
					},
					# Core Unit Identifier
					'ounce' => {
						'name' => q(унция),
						'one' => q({0} унция),
						'other' => q({0} унция),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'name' => q(фунт),
						'one' => q({0} фунт),
						'other' => q({0} фунт),
					},
					# Core Unit Identifier
					'pound' => {
						'name' => q(фунт),
						'one' => q({0} фунт),
						'other' => q({0} фунт),
					},
					# Long Unit Identifier
					'power-watt' => {
						'name' => q(W),
					},
					# Core Unit Identifier
					'watt' => {
						'name' => q(W),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'name' => q(l),
					},
					# Core Unit Identifier
					'liter' => {
						'name' => q(l),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:ҳа|ҳ|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:йўқ|й|no|n)$' }
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'arabext' => {
			'minusSign' => q(-),
			'nan' => q(ҳақиқий сон эмас),
			'plusSign' => q(+),
		},
		'latn' => {
			'decimal' => q(,),
			'group' => q( ),
			'nan' => q(ҳақиқий сон эмас),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'long' => {
				'1000' => {
					'one' => '0 минг',
					'other' => '0 минг',
				},
				'10000' => {
					'one' => '00 минг',
					'other' => '00 минг',
				},
				'100000' => {
					'one' => '000 минг',
					'other' => '000 минг',
				},
				'1000000' => {
					'one' => '0 миллион',
					'other' => '0 миллион',
				},
				'10000000' => {
					'one' => '00 миллион',
					'other' => '00 миллион',
				},
				'100000000' => {
					'one' => '000 миллион',
					'other' => '000 миллион',
				},
				'1000000000' => {
					'one' => '0 миллиард',
					'other' => '0 миллиард',
				},
				'10000000000' => {
					'one' => '00 миллиард',
					'other' => '00 миллиард',
				},
				'100000000000' => {
					'one' => '000 миллиард',
					'other' => '000 миллиард',
				},
				'1000000000000' => {
					'one' => '0 трилион',
					'other' => '0 трилион',
				},
				'10000000000000' => {
					'one' => '00 трилион',
					'other' => '00 трилион',
				},
				'100000000000000' => {
					'one' => '000 трилион',
					'other' => '000 трилион',
				},
			},
			'short' => {
				'1000' => {
					'one' => '0минг',
					'other' => '0минг',
				},
				'10000' => {
					'one' => '00минг',
					'other' => '00минг',
				},
				'100000' => {
					'one' => '000минг',
					'other' => '000минг',
				},
				'1000000' => {
					'one' => '0млн',
					'other' => '0млн',
				},
				'10000000' => {
					'one' => '00млн',
					'other' => '00млн',
				},
				'100000000' => {
					'one' => '000млн',
					'other' => '000млн',
				},
				'1000000000' => {
					'one' => '0млрд',
					'other' => '0млрд',
				},
				'10000000000' => {
					'one' => '00млрд',
					'other' => '00млрд',
				},
				'100000000000' => {
					'one' => '000млрд',
					'other' => '000млрд',
				},
				'1000000000000' => {
					'one' => '0трлн',
					'other' => '0трлн',
				},
				'10000000000000' => {
					'one' => '00трлн',
					'other' => '00трлн',
				},
				'100000000000000' => {
					'one' => '000трлн',
					'other' => '000трлн',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'standard' => {
						'positive' => '#,##0.00 ¤',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'ANG' => {
			display_name => {
				'currency' => q(Голланд Антил гульдени),
			},
		},
		'ARS' => {
			display_name => {
				'currency' => q(Аргентина песоси),
			},
		},
		'AWG' => {
			display_name => {
				'currency' => q(Аруба флорини),
			},
		},
		'BBD' => {
			display_name => {
				'currency' => q(Барбадос доллари),
			},
		},
		'BMD' => {
			display_name => {
				'currency' => q(Бермуда доллари),
			},
		},
		'BOB' => {
			display_name => {
				'currency' => q(Боливия болвиани),
			},
		},
		'BRL' => {
			display_name => {
				'currency' => q(Бразил реали),
			},
		},
		'BSD' => {
			display_name => {
				'currency' => q(Багама доллари),
			},
		},
		'BZD' => {
			display_name => {
				'currency' => q(Белиз доллари),
			},
		},
		'CAD' => {
			display_name => {
				'currency' => q(Канада доллари),
			},
		},
		'CLP' => {
			display_name => {
				'currency' => q(Чили песоси),
			},
		},
		'CNY' => {
			display_name => {
				'currency' => q(Хитой юани),
			},
		},
		'COP' => {
			display_name => {
				'currency' => q(Колумбия песоси),
			},
		},
		'CRC' => {
			display_name => {
				'currency' => q(Коста-Рика колони),
			},
		},
		'CUC' => {
			display_name => {
				'currency' => q(Куба Айирбошлаш песоси),
				'one' => q(Куба айирбошлаш песоси),
				'other' => q(Куба айирбошлаш песоси),
			},
		},
		'CUP' => {
			display_name => {
				'currency' => q(Куба песоси),
			},
		},
		'DOP' => {
			display_name => {
				'currency' => q(Доминикан песоси),
			},
		},
		'DZD' => {
			display_name => {
				'currency' => q(Жазоир динори),
			},
		},
		'EGP' => {
			display_name => {
				'currency' => q(Миср фунти),
			},
		},
		'EUR' => {
			display_name => {
				'currency' => q(Евро),
			},
		},
		'FKP' => {
			display_name => {
				'currency' => q(Фолькленд ороли фунти),
			},
		},
		'GBP' => {
			display_name => {
				'currency' => q(Инглиз фунт),
			},
		},
		'GTQ' => {
			display_name => {
				'currency' => q(Гватемала кветзали),
			},
		},
		'GYD' => {
			display_name => {
				'currency' => q(Гаяна доллари),
			},
		},
		'HNL' => {
			display_name => {
				'currency' => q(Гондурас лемпираси),
			},
		},
		'HTG' => {
			display_name => {
				'currency' => q(Гаити гурдаси),
			},
		},
		'INR' => {
			display_name => {
				'currency' => q(Ҳинд рупияси),
			},
		},
		'JMD' => {
			display_name => {
				'currency' => q(Ямайка доллари),
			},
		},
		'JPY' => {
			display_name => {
				'currency' => q(Япон йенаси),
			},
		},
		'KYD' => {
			display_name => {
				'currency' => q(Кайман ороли Доллари),
				'one' => q(Кайман ороли доллари),
				'other' => q(Кайман ороли доллари),
			},
		},
		'LYD' => {
			display_name => {
				'currency' => q(Ливия динори),
			},
		},
		'MAD' => {
			display_name => {
				'currency' => q(Марокаш дирҳами),
			},
		},
		'MXN' => {
			display_name => {
				'currency' => q(Мексика песоси),
			},
		},
		'NIO' => {
			display_name => {
				'currency' => q(Никарагуа кордобаси),
			},
		},
		'PAB' => {
			display_name => {
				'currency' => q(Панама бальбоаси),
			},
		},
		'PEN' => {
			display_name => {
				'currency' => q(Перу сол),
			},
		},
		'PYG' => {
			display_name => {
				'currency' => q(Парагвай гуарани),
			},
		},
		'RUB' => {
			display_name => {
				'currency' => q(Рус рубли),
			},
		},
		'SRD' => {
			display_name => {
				'currency' => q(Суринам доллари),
			},
		},
		'THB' => {
			symbol => '฿',
		},
		'TTD' => {
			display_name => {
				'currency' => q(Тринидад ва Тобаго доллари),
			},
		},
		'USD' => {
			display_name => {
				'currency' => q(АҚШ доллари),
			},
		},
		'UYU' => {
			display_name => {
				'currency' => q(Уругвай песоси),
			},
		},
		'UZS' => {
			symbol => 'сўм',
			display_name => {
				'currency' => q(Ўзбекистон сўм),
			},
		},
		'VEF' => {
			display_name => {
				'currency' => q(Венесуэла боливари \(2008–2018\)),
			},
		},
		'VES' => {
			display_name => {
				'currency' => q(Венесуэла боливари),
			},
		},
		'XCD' => {
			display_name => {
				'currency' => q(Шарқий Кариб доллари),
				'one' => q(Шарқ Кариб доллари),
				'other' => q(Шарқ Кариб доллари),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'янв',
							'фев',
							'мар',
							'апр',
							'май',
							'июн',
							'июл',
							'авг',
							'сен',
							'окт',
							'ноя',
							'дек'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'январ',
							'феврал',
							'март',
							'апрел',
							'май',
							'июн',
							'июл',
							'август',
							'сентябр',
							'октябр',
							'ноябр',
							'декабр'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					narrow => {
						nonleap => [
							'Я',
							'Ф',
							'М',
							'А',
							'М',
							'И',
							'И',
							'А',
							'С',
							'О',
							'Н',
							'Д'
						],
						leap => [
							
						],
					},
				},
			},
			'islamic' => {
				'format' => {
					wide => {
						nonleap => [
							'Муҳаррам',
							'Сафар',
							'Рабиул-аввал',
							'Рабиул-охир',
							'Жумодиул-уло',
							'Жумодиул-ухро',
							'Ражаб',
							'Шаъбон',
							'Рамазон',
							'Шаввол',
							'Зил-қаъда',
							'Зил-ҳижжа'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'душ',
						tue => 'сеш',
						wed => 'чор',
						thu => 'пай',
						fri => 'жум',
						sat => 'шан',
						sun => 'якш'
					},
					short => {
						mon => 'ду',
						tue => 'се',
						wed => 'чо',
						thu => 'па',
						fri => 'жу',
						sat => 'ша',
						sun => 'як'
					},
					wide => {
						mon => 'душанба',
						tue => 'сешанба',
						wed => 'чоршанба',
						thu => 'пайшанба',
						fri => 'жума',
						sat => 'шанба',
						sun => 'якшанба'
					},
				},
				'stand-alone' => {
					narrow => {
						mon => 'Д',
						tue => 'С',
						wed => 'Ч',
						thu => 'П',
						fri => 'Ж',
						sat => 'Ш',
						sun => 'Я'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => '1-ч',
						1 => '2-ч',
						2 => '3-ч',
						3 => '4-ч'
					},
					wide => {0 => '1-чорак',
						1 => '2-чорак',
						2 => '3-чорак',
						3 => '4-чорак'
					},
				},
			},
	} },
);

has 'day_period_data' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub { sub {
		# Time in hhmm format
		my ($self, $type, $time, $day_period_type) = @_;
		$day_period_type //= 'default';
		SWITCH:
		for ($type) {
			if ($_ eq 'generic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1100
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2200;
					return 'morning1' if $time >= 600
						&& $time < 1100;
					return 'night1' if $time >= 2200;
					return 'night1' if $time < 600;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1100
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2200;
					return 'morning1' if $time >= 600
						&& $time < 1100;
					return 'night1' if $time >= 2200;
					return 'night1' if $time < 600;
				}
				last SWITCH;
				}
			if ($_ eq 'gregorian') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1100
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2200;
					return 'morning1' if $time >= 600
						&& $time < 1100;
					return 'night1' if $time >= 2200;
					return 'night1' if $time < 600;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1100
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2200;
					return 'morning1' if $time >= 600
						&& $time < 1100;
					return 'night1' if $time >= 2200;
					return 'night1' if $time < 600;
				}
				last SWITCH;
				}
			if ($_ eq 'islamic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1100
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2200;
					return 'morning1' if $time >= 600
						&& $time < 1100;
					return 'night1' if $time >= 2200;
					return 'night1' if $time < 600;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1100
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2200;
					return 'morning1' if $time >= 600
						&& $time < 1100;
					return 'night1' if $time >= 2200;
					return 'night1' if $time < 600;
				}
				last SWITCH;
				}
		}
	} },
);

around day_period_data => sub {
    my ($orig, $self) = @_;
    return $self->$orig;
};

has 'day_periods' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'abbreviated' => {
					'afternoon1' => q{кундузи},
					'am' => q{ТО},
					'evening1' => q{кечқурун},
					'midnight' => q{ярим тун},
					'morning1' => q{эрталаб},
					'night1' => q{кечаси},
					'noon' => q{туш пайти},
					'pm' => q{ТК},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'м.а.',
				'1' => 'милодий'
			},
			wide => {
				'0' => 'милоддан аввалги'
			},
		},
		'islamic' => {
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{EEEE, G y MMMM dd},
			'long' => q{G y MMMM d},
			'medium' => q{G y MMM d},
			'short' => q{GGGGG y/MM/dd},
		},
		'gregorian' => {
			'full' => q{EEEE, dd MMMM, y},
			'long' => q{d MMMM, y},
			'medium' => q{d MMM, y},
			'short' => q{dd/MM/yy},
		},
		'islamic' => {
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			'full' => q{HH:mm:ss (zzzz)},
			'long' => q{HH:mm:ss (z)},
			'medium' => q{HH:mm:ss},
			'short' => q{HH:mm},
		},
		'islamic' => {
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'gregorian' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'islamic' => {
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			Bh => q{B h},
			Bhm => q{B h:mm},
			Bhms => q{B h:mm:ss},
			EBhm => q{E, B h:mm},
			EBhms => q{E, B h:mm:ss},
			EHm => q{E, HH:mm},
			EHms => q{E, HH:mm:ss},
			Ehm => q{E, h:mm a},
			Ehms => q{E, h:mm:ss a},
			GyMMM => q{MMM, G y},
			GyMMMEd => q{E, d-MMM, G y},
			GyMMMd => q{d MMM, G y},
			Hmsv => q{HH:mm:ss (v)},
			Hmv => q{HH:mm (v)},
			M => q{LL},
			MEd => q{E, dd/MM},
			MMMEd => q{E, d MMM},
			MMMMW => q{MMMM, W-'ҳафта'},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			Md => q{dd/MM},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			hmsv => q{h:mm:ss a (v)},
			hmv => q{h:mm a (v)},
			yM => q{MM/y},
			yMEd => q{E, dd/MM/y},
			yMMM => q{MMM, y},
			yMMMEd => q{E, d-MMM, y},
			yMMMM => q{MMMM, y},
			yMMMd => q{d MMM, y},
			yMd => q{dd/MM/y},
			yQQQ => q{y, QQQ},
			yQQQQ => q{y, QQQQ},
			yw => q{Y, w-'ҳафта'},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			fallback => '{0} – {1}',
		},
		'gregorian' => {
			Hmv => {
				H => q{HH:mm–HH:mm (v)},
				m => q{HH:mm–HH:mm (v)},
			},
			Hv => {
				H => q{HH–HH (v)},
			},
			MEd => {
				M => q{E, dd/MM – E, dd/MM},
				d => q{E, dd/MM – E, dd/MM},
			},
			MMM => {
				M => q{MMM–MMM},
			},
			MMMEd => {
				M => q{E, d MMM – E, d MMM},
				d => q{E, d MMM – E, d MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d – d MMM},
			},
			Md => {
				M => q{dd/MM – dd/MM},
				d => q{dd/MM – dd/MM},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a (v)},
				h => q{h:mm–h:mm a (v)},
				m => q{h:mm–h:mm a (v)},
			},
			hv => {
				a => q{h a – h a (v)},
				h => q{h–h a (v)},
			},
			yM => {
				M => q{MM/y – MM/y},
				y => q{MM/y – MM/y},
			},
			yMEd => {
				M => q{E, dd/MM/y – E, dd/MM/y},
				d => q{E, dd/MM/y – E, dd/MM/y},
				y => q{E, dd/MM/y – E, dd/MM/y},
			},
			yMMM => {
				M => q{MMM – MMM, y},
				y => q{MMM, y – MMM, y},
			},
			yMMMEd => {
				M => q{E, d MMM – E, d MMM, y},
				d => q{E, d MMM – E, d MMM, y},
				y => q{E, d MMM, y – E, d MMM, y},
			},
			yMMMM => {
				M => q{MMMM – MMMM, y},
				y => q{MMMM, y – MMMM, y},
			},
			yMMMd => {
				M => q{d MMM – d MMM, y},
				d => q{d – d MMM, y},
				y => q{d MMM, y – d MMM, y},
			},
			yMd => {
				M => q{dd/MM/y – dd/MM/y},
				d => q{dd/MM/y – dd/MM/y},
				y => q{dd/MM/y – dd/MM/y},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default	=> sub { {
		regionFormat => q({0} вақти),
		regionFormat => q({0} кундузги вақти),
		regionFormat => q({0} стандарт вақти),
		'Afghanistan' => {
			long => {
				'standard' => q#Афғонистон вақти#,
			},
		},
		'Africa_Central' => {
			long => {
				'standard' => q#Марказий Африка вақти#,
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q#Шарқий Африка вақти#,
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q#Жанубий Африка вақти#,
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q#Ғарбий Африка ёзги вақти#,
				'generic' => q#Ғарбий Африка вақти#,
				'standard' => q#Ғарбий Африка стандарт вақти#,
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q#Аляска кундузги вақти#,
				'generic' => q#Аляска вақти#,
				'standard' => q#Аляска стандарт вақти#,
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q#Амазонка ёзги вақти#,
				'generic' => q#Амазонка вақти#,
				'standard' => q#Амазонка стандарт вақти#,
			},
		},
		'America/Lower_Princes' => {
			exemplarCity => q#Lower Princeʼs Quarter#,
		},
		'America_Central' => {
			long => {
				'daylight' => q#Шимолий Америка марказий кундузги вақти#,
				'generic' => q#Шимолий Америка#,
				'standard' => q#Шимолий Америка марказий стандарт вақти#,
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q#Шимолий Америка шарқий кундузги вақти#,
				'generic' => q#Шимолий Америка шарқий вақти#,
				'standard' => q#Шимолий Америка шарқий стандарт вақти#,
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q#Шимолий Америка тоғ кундузги вақти#,
				'generic' => q#Шимолий Америка тоғ вақти#,
				'standard' => q#Шимолий Америка тоғ стандарт вақти#,
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q#Шимолий Америка тинч океани кундузги вақти#,
				'generic' => q#Шимолий Америка тинч океани вақти#,
				'standard' => q#Шимолий Америка тинч океани стандарт вақти#,
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q#Арабистон кундузги вақти#,
				'generic' => q#Арабистон вақти#,
				'standard' => q#Арабистон стандарт вақти#,
			},
		},
		'Argentina' => {
			long => {
				'daylight' => q#Аргентина ёзги вақти#,
				'generic' => q#Аргентина вақти#,
				'standard' => q#Аргентина стандарт вақти#,
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q#Ғарбий Аргентина ёзги вақти#,
				'generic' => q#Ғарбий Аргентина вақти#,
				'standard' => q#Ғарбий Аргентина стандарт вақти#,
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q#Арманистон ёзги вақти#,
				'generic' => q#Арамнистон вақти#,
				'standard' => q#Арманистон стандарт вақти#,
			},
		},
		'Atlantic' => {
			long => {
				'daylight' => q#Атлантика кундузги вақти#,
				'generic' => q#Атлантика вақти#,
				'standard' => q#Атлантика стандарт вақти#,
			},
		},
		'Australia_Central' => {
			long => {
				'daylight' => q#Марказий Австралия кундузги вақти#,
				'generic' => q#Марказий Австралия вақти#,
				'standard' => q#Марказий Австралия стандарт вақти#,
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q#Марказий Австралия Ғарбий кундузги вақти#,
				'generic' => q#Марказий Австралия Ғарбий вақти#,
				'standard' => q#Марказий Австралия Ғарбий стандарт вақти#,
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q#Шарқий Австралия кундузги вақти#,
				'generic' => q#Шарқий Австралия вақти#,
				'standard' => q#Шарқий Австралия стандарт вақти#,
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q#Ғарбий Австралия кундузги вақти#,
				'generic' => q#Ғарбий Австралия вақти#,
				'standard' => q#Ғарбий Австралия стандарт вақти#,
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q#Озарбайжон ёзги вақти#,
				'generic' => q#Озарбайжон вақти#,
				'standard' => q#Озарбайжон стандарт вақти#,
			},
		},
		'Azores' => {
			long => {
				'daylight' => q#Азор ёзги вақти#,
				'generic' => q#Азор вақти#,
				'standard' => q#Азор стандарт вақти#,
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q#Бангладеш ёзги вақти#,
				'generic' => q#Бангладеш вақти#,
				'standard' => q#Бангладеш стандарт вақти#,
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q#Бутан вақти#,
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q#Боливия вақти#,
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q#Бразилия ёзги вақти#,
				'generic' => q#Бразилия вақти#,
				'standard' => q#Бразилия стандарт вақти#,
			},
		},
		'Brunei' => {
			long => {
				'standard' => q#Бруней Даруссалом вақти#,
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q#Кабо-Верде ёзги вақти#,
				'generic' => q#Кабо-Верде вақти#,
				'standard' => q#Кабо-Верде стандарт вақти#,
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q#Каморро вақти#,
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q#Чатхам кундузги вақти#,
				'generic' => q#Чатхам вақти#,
				'standard' => q#Чатхам стандарт вақти#,
			},
		},
		'Chile' => {
			long => {
				'daylight' => q#Чили ёзги вақти#,
				'generic' => q#Чили вақти#,
				'standard' => q#Чили стандарт вақти#,
			},
		},
		'China' => {
			long => {
				'daylight' => q#Хитой кундузги вақти#,
				'generic' => q#Хитой вақти#,
				'standard' => q#Хитой стандарт вақти#,
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q#Чойбалсан ёзги вақти#,
				'generic' => q#Чойбалсан вақти#,
				'standard' => q#Чойбалсан стандарт вақти#,
			},
		},
		'Christmas' => {
			long => {
				'standard' => q#Рождество ороли вақти#,
			},
		},
		'Cocos' => {
			long => {
				'standard' => q#Кокос ороллари вақти#,
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q#Колумбия ёзги вақти#,
				'generic' => q#Колумбия вақти#,
				'standard' => q#Колумбия стандарт вақти#,
			},
		},
		'Cook' => {
			long => {
				'daylight' => q#Кук ороллари ярим ёзги вақти#,
				'generic' => q#Кук ороллари вақти#,
				'standard' => q#Кук ороллари стандарт вақти#,
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q#Куба кундузги вақти#,
				'generic' => q#Куба вақти#,
				'standard' => q#Куба стандарт вақти#,
			},
		},
		'Davis' => {
			long => {
				'standard' => q#Дэвис вақти#,
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q#Думонт-д-Урвил вақти#,
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q#Шарқий Тимор вақти#,
			},
		},
		'Easter' => {
			long => {
				'daylight' => q#Пасхи ороли ёзги вақти#,
				'generic' => q#Пасхи Ороли вақти#,
				'standard' => q#Пасхи ороли стандарт вақти#,
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q#Эквадор вақти#,
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#Номаълум#,
		},
		'Europe/Dublin' => {
			long => {
				'daylight' => q#Ирландия ёзги вақти#,
			},
		},
		'Europe/London' => {
			long => {
				'daylight' => q#Британия ёзги вақти#,
			},
		},
		'Europe_Central' => {
			long => {
				'daylight' => q#Марказий Европа ёзги вақти#,
				'generic' => q#Марказий Европа вақти#,
				'standard' => q#Марказий Европа стандарт вақти#,
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q#Шарқий Европа ёзги вақти#,
				'generic' => q#Шарқий Европа вақти#,
				'standard' => q#Шарқий Европа стандарт вақти#,
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q#Ғарбий Европа ёзги вақти#,
				'generic' => q#Ғарбий Европа вақти#,
				'standard' => q#Ғарбий Европа стандарт вақти#,
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q#Фолькленд ороллари ёзги вақти#,
				'generic' => q#Фолькленд ороллари вақти#,
				'standard' => q#Фолькленд ороллари стандарт вақти#,
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q#Фижи ёзги вақти#,
				'generic' => q#Фижи вақти#,
				'standard' => q#Фижи стандарт вақти#,
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q#Француз Гвианаси вақти#,
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q#Француз жанубий ва Антарктика вақти#,
			},
		},
		'GMT' => {
			long => {
				'standard' => q#Гринвич вақти#,
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q#Галапагос вақти#,
			},
		},
		'Gambier' => {
			long => {
				'standard' => q#Гамбиер вақти#,
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q#Грузия ёзги вақти#,
				'generic' => q#Грузия вақти#,
				'standard' => q#Грузия стандарт вақти#,
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q#Гилберт ороллари вақти#,
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q#Шарқий Гренландия ёзги вақти#,
				'generic' => q#Шарқий Гренландия вақти#,
				'standard' => q#Шарқий Гренландия стандарт вақти#,
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q#Ғарбий Гренландия ёзги вақти#,
				'generic' => q#Ғарбий Гренландия вақти#,
				'standard' => q#Ғарбий Гренландия стандарт вақти#,
			},
		},
		'Gulf' => {
			long => {
				'standard' => q#Кўрфаз вақти#,
			},
		},
		'Guyana' => {
			long => {
				'standard' => q#Гайана вақти#,
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q#Гавайи-алеут кундузги вақти#,
				'generic' => q#Гавайи-алеут вақти#,
				'standard' => q#Гавайи-алеут стандарт вақти#,
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q#Гонконг ёзги вақти#,
				'generic' => q#Гонконг вақти#,
				'standard' => q#Гонконг стандарт вақти#,
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q#Ховд ёзги вақти#,
				'generic' => q#Ховд вақти#,
				'standard' => q#Ховд стандарт вақти#,
			},
		},
		'India' => {
			long => {
				'standard' => q#Ҳиндистон вақти#,
			},
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q#Ҳинд океани вақти#,
			},
		},
		'Indochina' => {
			long => {
				'standard' => q#Ҳинд-Хитой вақти#,
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q#Марказий Индонезия вақти#,
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q#Шарқий Индонезия вақти#,
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q#Ғарбий Индонезия вақти#,
			},
		},
		'Iran' => {
			long => {
				'daylight' => q#Эрон кундузги вақти#,
				'generic' => q#Эрон вақти#,
				'standard' => q#Эрон стандарт вақти#,
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q#Иркутск ёзги вақти#,
				'generic' => q#Иркутск вақти#,
				'standard' => q#Иркутск стандарт вақти#,
			},
		},
		'Israel' => {
			long => {
				'daylight' => q#Исроил кундузги вақти#,
				'generic' => q#Исроил вақти#,
				'standard' => q#Исроил стандарт вақти#,
			},
		},
		'Japan' => {
			long => {
				'daylight' => q#Япония кундузги вақти#,
				'generic' => q#Япония вақти#,
				'standard' => q#Япония стандарт вақти#,
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q#Шарқий Қозоғистон вақти#,
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q#Ғарбий Қозоғистон вақти#,
			},
		},
		'Korea' => {
			long => {
				'daylight' => q#Корея кундузги вақти#,
				'generic' => q#Корея вақти#,
				'standard' => q#Корея стандарт вақти#,
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q#Косрае вақти#,
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q#Красноярск ёзги вақти#,
				'generic' => q#Красноярск вақти#,
				'standard' => q#Красноярск стандарт вақти#,
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q#Қирғизистон вақти#,
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q#Лайн ороллари вақти#,
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q#Лорд Хове кундузги вақти#,
				'generic' => q#Лорд Хове вақти#,
				'standard' => q#Лорд Хове стандарт вақти#,
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q#Маквари ороли вақти#,
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q#Магадан ёзги вақти#,
				'generic' => q#Магадан вақти#,
				'standard' => q#Магадан стандарт вақти#,
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q#Малайзия вақти#,
			},
		},
		'Maldives' => {
			long => {
				'standard' => q#Мальдив ороллар#,
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q#Маркезас вақти#,
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q#Маршалл ороллари вақти#,
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q#Маврикий ёзги вақти#,
				'generic' => q#Маврикий вақти#,
				'standard' => q#Маврикий стандарт вақти#,
			},
		},
		'Mawson' => {
			long => {
				'standard' => q#Моувсон вақти#,
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q#Улан-Батор ёзги вақти#,
				'generic' => q#Улан-Батор вақти#,
				'standard' => q#Улан-Батор стандарт вақти#,
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q#Москва ёзги вақти#,
				'generic' => q#Москва вақти#,
				'standard' => q#Москва стандарт вақти#,
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q#Мьянма вақти#,
			},
		},
		'Nauru' => {
			long => {
				'standard' => q#Науру вақти#,
			},
		},
		'Nepal' => {
			long => {
				'standard' => q#Непал вақти#,
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q#Янги Каледония ёзги вақти#,
				'generic' => q#Янги Каледония вақти#,
				'standard' => q#Янги Каледония стандарт вақти#,
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q#Янги Зеландия кундузги вақти#,
				'generic' => q#Янги Зеландия вақти#,
				'standard' => q#Янги Зеландия стандарт вақти#,
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q#Ньюфаундленд кундузги вақти#,
				'generic' => q#Ньюфаундленд вақти#,
				'standard' => q#Ньюфаундленд стандарт вақти#,
			},
		},
		'Niue' => {
			long => {
				'standard' => q#Ниуе вақти#,
			},
		},
		'Norfolk' => {
			long => {
				'daylight' => q#Норфолк ороли ёзги вақти#,
				'generic' => q#Норфолк ороли вақти#,
				'standard' => q#Норфолк ороли стандарт вақти#,
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q#Фернандо де Норонья ёзги вақти#,
				'generic' => q#Фернандо де Норонья вақти#,
				'standard' => q#Фернандо де Норонья стандарт вақти#,
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q#Новосибирск ёзги вақти#,
				'generic' => q#Новосибирск вақти#,
				'standard' => q#Новосибирск стандарт вақти#,
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q#Омск ёзги вақти#,
				'generic' => q#Омск вақти#,
				'standard' => q#Омск стандарт вақти#,
			},
		},
		'Pakistan' => {
			long => {
				'daylight' => q#Покистон ёзги вақти#,
				'generic' => q#Покистон вақти#,
				'standard' => q#Покистон стандарт вақти#,
			},
		},
		'Palau' => {
			long => {
				'standard' => q#Палау вақти#,
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q#Папуа-Янги Гвинея вақти#,
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q#Парагвай ёзги вақти#,
				'generic' => q#Парагвай вақти#,
				'standard' => q#Парагвай стандарт вақти#,
			},
		},
		'Peru' => {
			long => {
				'daylight' => q#Перу ёзги вақти#,
				'generic' => q#Перу вақти#,
				'standard' => q#Перу стандарт вақти#,
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q#Филиппин ёзги вақти#,
				'generic' => q#Филиппин вақти#,
				'standard' => q#Филиппин стандарт вақти#,
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q#Феникс ороллари вақти#,
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q#Сент-Пьер ва Микелон кундузги вақти#,
				'generic' => q#Сент-Пьер ва Микелон вақти#,
				'standard' => q#Сент-Пьер ва Микелон стандарт вақти#,
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q#Питкерн вақти#,
			},
		},
		'Ponape' => {
			long => {
				'standard' => q#Понапе вақти#,
			},
		},
		'Reunion' => {
			long => {
				'standard' => q#Реюньон вақти#,
			},
		},
		'Rothera' => {
			long => {
				'standard' => q#Ротера вақти#,
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q#Сахалин ёзги вақти#,
				'generic' => q#Сахалин вақти#,
				'standard' => q#Сахалин стандарт вақти#,
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q#Самоа кундузги вақти#,
				'generic' => q#Самоа вақти#,
				'standard' => q#Самоа стандарт вақти#,
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q#Сейшел ороллари вақти#,
			},
		},
		'Singapore' => {
			long => {
				'standard' => q#Сингапур вақти#,
			},
		},
		'Solomon' => {
			long => {
				'standard' => q#Соломон ороллари вақти#,
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q#Жанубий Джорджия вақти#,
			},
		},
		'Suriname' => {
			long => {
				'standard' => q#Суринам вақти#,
			},
		},
		'Syowa' => {
			long => {
				'standard' => q#Сьова вақти#,
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q#Таити вақти#,
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q#Тайпей кундузги вақти#,
				'generic' => q#Тайпей вақти#,
				'standard' => q#Тайпей стандарт вақти#,
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q#Тожикистон вақти#,
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q#Токелау вақти#,
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q#Тонга ёзги вақти#,
				'generic' => q#Тонга вақти#,
				'standard' => q#Тонга стандарт вақти#,
			},
		},
		'Truk' => {
			long => {
				'standard' => q#Чуук вақти#,
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q#Туркманистон ёзги вақти#,
				'generic' => q#Туркманистон вақти#,
				'standard' => q#Туркманистон стандарт вақти#,
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q#Тувалу вақти#,
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q#Уругвай ёзги вақти#,
				'generic' => q#Уругвай вақти#,
				'standard' => q#Уругвай стандарт вақти#,
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q#Ўзбекистон ёзги вақти#,
				'generic' => q#Ўзбекистон вақти#,
				'standard' => q#Ўзбекистон стандарт вақти#,
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q#Вануату ёзги вақти#,
				'generic' => q#Вануату вақти#,
				'standard' => q#Вануату стандарт вақти#,
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q#Венесуэла вақти#,
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q#Владивосток ёзги вақти#,
				'generic' => q#Владивосток вақти#,
				'standard' => q#Владивосток стандарт вақти#,
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q#Волгоград ёзги вақти#,
				'generic' => q#Волгоград вақти#,
				'standard' => q#Волгоград стандарт вақти#,
			},
		},
		'Vostok' => {
			long => {
				'standard' => q#Восток вақти#,
			},
		},
		'Wake' => {
			long => {
				'standard' => q#Уэйк ороли вақти#,
			},
		},
		'Wallis' => {
			long => {
				'standard' => q#Уэллис ва Футуна вақти#,
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q#Якутск ёзги вақти#,
				'generic' => q#Якутск вақти#,
				'standard' => q#Якутск стандарт вақти#,
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q#Екатеринбург ёзги вақти#,
				'generic' => q#Екатеринбург вақти#,
				'standard' => q#Екатеринбург стандарт вақти#,
			},
		},
	 } }
);
no Moo;

1;

# vim: tabstop=4
