=encoding utf8

=head1 NAME

Locale::CLDR::Locales::Ne - Package for language Nepali

=cut

package Locale::CLDR::Locales::Ne;
# This file auto generated from Data\common\main\ne.xml
#	on Sun  7 Jan  2:30:41 pm GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.40.1');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Root');
has 'valid_algorithmic_formats' => (
    is => 'ro',
    isa => ArrayRef,
    init_arg => undef,
    default => sub {[ 'spellout-numbering-year','spellout-numbering','spellout-cardinal','spellout-ordinal-masculine','spellout-ordinal-feminine' ]},
);

has 'algorithmic_number_format_data' => (
    is => 'ro',
    isa => HashRef,
    init_arg => undef,
    default => sub {
        use bigfloat;
        return {
		'consonant-suffix' => {
			'private' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(ौँ),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(' =%spellout-numbering=ौँ),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(' दुयौँ),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(' =%spellout-numbering=ौँ),
				},
				'5' => {
					base_value => q(5),
					divisor => q(1),
					rule => q(' =%spellout-ordinal-masculine=),
				},
				'max' => {
					base_value => q(5),
					divisor => q(1),
					rule => q(' =%spellout-ordinal-masculine=),
				},
			},
		},
		'spellout-cardinal' => {
			'public' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-numbering=),
				},
				'max' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-numbering=),
				},
			},
		},
		'spellout-numbering' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(ऋणात्मक →→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(शुन्य),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(←← दशमलव →→),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(एक),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(दुई),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(तिन),
				},
				'4' => {
					base_value => q(4),
					divisor => q(1),
					rule => q(चार),
				},
				'5' => {
					base_value => q(5),
					divisor => q(1),
					rule => q(पाँच),
				},
				'6' => {
					base_value => q(6),
					divisor => q(1),
					rule => q(छ),
				},
				'7' => {
					base_value => q(7),
					divisor => q(1),
					rule => q(सात),
				},
				'8' => {
					base_value => q(8),
					divisor => q(1),
					rule => q(आठ),
				},
				'9' => {
					base_value => q(9),
					divisor => q(1),
					rule => q(नौ),
				},
				'10' => {
					base_value => q(10),
					divisor => q(10),
					rule => q(दस),
				},
				'11' => {
					base_value => q(11),
					divisor => q(10),
					rule => q(एघार),
				},
				'12' => {
					base_value => q(12),
					divisor => q(10),
					rule => q(बाह्र),
				},
				'13' => {
					base_value => q(13),
					divisor => q(10),
					rule => q(तेह्र),
				},
				'14' => {
					base_value => q(14),
					divisor => q(10),
					rule => q(चौध),
				},
				'15' => {
					base_value => q(15),
					divisor => q(10),
					rule => q(पन्ध्र),
				},
				'16' => {
					base_value => q(16),
					divisor => q(10),
					rule => q(सोह्र),
				},
				'17' => {
					base_value => q(17),
					divisor => q(10),
					rule => q(सत्र),
				},
				'18' => {
					base_value => q(18),
					divisor => q(10),
					rule => q(अठार),
				},
				'19' => {
					base_value => q(19),
					divisor => q(10),
					rule => q(उन्नाइस),
				},
				'20' => {
					base_value => q(20),
					divisor => q(10),
					rule => q(बिस),
				},
				'21' => {
					base_value => q(21),
					divisor => q(10),
					rule => q(एक्काइस),
				},
				'22' => {
					base_value => q(22),
					divisor => q(10),
					rule => q(बाइस),
				},
				'23' => {
					base_value => q(23),
					divisor => q(10),
					rule => q(तेइस),
				},
				'24' => {
					base_value => q(24),
					divisor => q(10),
					rule => q(चौबिस),
				},
				'25' => {
					base_value => q(25),
					divisor => q(10),
					rule => q(पच्चिस),
				},
				'26' => {
					base_value => q(26),
					divisor => q(10),
					rule => q(छब्बिस),
				},
				'27' => {
					base_value => q(27),
					divisor => q(10),
					rule => q(सत्ताइस),
				},
				'28' => {
					base_value => q(28),
					divisor => q(10),
					rule => q(अट्ठाइस),
				},
				'29' => {
					base_value => q(29),
					divisor => q(10),
					rule => q(उनन्तिस),
				},
				'30' => {
					base_value => q(30),
					divisor => q(10),
					rule => q(तिस),
				},
				'31' => {
					base_value => q(31),
					divisor => q(10),
					rule => q(एकतिस),
				},
				'32' => {
					base_value => q(32),
					divisor => q(10),
					rule => q(बत्तिस),
				},
				'33' => {
					base_value => q(33),
					divisor => q(10),
					rule => q(तेत्तिस),
				},
				'34' => {
					base_value => q(34),
					divisor => q(10),
					rule => q(चौँतिस),
				},
				'35' => {
					base_value => q(35),
					divisor => q(10),
					rule => q(पैँतिस),
				},
				'36' => {
					base_value => q(36),
					divisor => q(10),
					rule => q(छत्तिस),
				},
				'37' => {
					base_value => q(37),
					divisor => q(10),
					rule => q(सैँतिस),
				},
				'38' => {
					base_value => q(38),
					divisor => q(10),
					rule => q(अठतिस),
				},
				'39' => {
					base_value => q(39),
					divisor => q(10),
					rule => q(उनन्चालिस),
				},
				'40' => {
					base_value => q(40),
					divisor => q(10),
					rule => q(चालिस),
				},
				'41' => {
					base_value => q(41),
					divisor => q(10),
					rule => q(एकचालिस),
				},
				'42' => {
					base_value => q(42),
					divisor => q(10),
					rule => q(बयालिस),
				},
				'43' => {
					base_value => q(43),
					divisor => q(10),
					rule => q(त्रिचालिस),
				},
				'44' => {
					base_value => q(44),
					divisor => q(10),
					rule => q(चवालिस),
				},
				'45' => {
					base_value => q(45),
					divisor => q(10),
					rule => q(पैँतालिस),
				},
				'46' => {
					base_value => q(46),
					divisor => q(10),
					rule => q(छयालिस),
				},
				'47' => {
					base_value => q(47),
					divisor => q(10),
					rule => q(सतचालिस),
				},
				'48' => {
					base_value => q(48),
					divisor => q(10),
					rule => q(अठचालिस),
				},
				'49' => {
					base_value => q(49),
					divisor => q(10),
					rule => q(उनन्चास),
				},
				'50' => {
					base_value => q(50),
					divisor => q(10),
					rule => q(पचास),
				},
				'51' => {
					base_value => q(51),
					divisor => q(10),
					rule => q(एकाउन्न),
				},
				'52' => {
					base_value => q(52),
					divisor => q(10),
					rule => q(बाउन्न),
				},
				'53' => {
					base_value => q(53),
					divisor => q(10),
					rule => q(त्रिपन्न),
				},
				'54' => {
					base_value => q(54),
					divisor => q(10),
					rule => q(चवन्न),
				},
				'55' => {
					base_value => q(55),
					divisor => q(10),
					rule => q(पचपन्न),
				},
				'56' => {
					base_value => q(56),
					divisor => q(10),
					rule => q(छपन्न),
				},
				'57' => {
					base_value => q(57),
					divisor => q(10),
					rule => q(सन्ताउन्न),
				},
				'58' => {
					base_value => q(58),
					divisor => q(10),
					rule => q(अन्ठाउन्न),
				},
				'59' => {
					base_value => q(59),
					divisor => q(10),
					rule => q(उनन्साठी),
				},
				'60' => {
					base_value => q(60),
					divisor => q(10),
					rule => q(साठी),
				},
				'61' => {
					base_value => q(61),
					divisor => q(10),
					rule => q(एकसट्ठी),
				},
				'62' => {
					base_value => q(62),
					divisor => q(10),
					rule => q(बयसट्ठी),
				},
				'63' => {
					base_value => q(63),
					divisor => q(10),
					rule => q(त्रिसट्ठी),
				},
				'64' => {
					base_value => q(64),
					divisor => q(10),
					rule => q(चौसट्ठी),
				},
				'65' => {
					base_value => q(65),
					divisor => q(10),
					rule => q(पैँसट्ठी),
				},
				'66' => {
					base_value => q(66),
					divisor => q(10),
					rule => q(छयसट्ठी),
				},
				'67' => {
					base_value => q(67),
					divisor => q(10),
					rule => q(सतसट्ठी),
				},
				'68' => {
					base_value => q(68),
					divisor => q(10),
					rule => q(अठसट्ठी),
				},
				'69' => {
					base_value => q(69),
					divisor => q(10),
					rule => q(उनन्सत्तरी),
				},
				'70' => {
					base_value => q(70),
					divisor => q(10),
					rule => q(सत्तरी),
				},
				'71' => {
					base_value => q(71),
					divisor => q(10),
					rule => q(एकहत्तर),
				},
				'72' => {
					base_value => q(72),
					divisor => q(10),
					rule => q(बहत्तर),
				},
				'73' => {
					base_value => q(73),
					divisor => q(10),
					rule => q(त्रिहत्तर),
				},
				'74' => {
					base_value => q(74),
					divisor => q(10),
					rule => q(चौहत्तर),
				},
				'75' => {
					base_value => q(75),
					divisor => q(10),
					rule => q(पचहत्तर),
				},
				'76' => {
					base_value => q(76),
					divisor => q(10),
					rule => q(छयहत्तर),
				},
				'77' => {
					base_value => q(77),
					divisor => q(10),
					rule => q(सतहत्तर),
				},
				'78' => {
					base_value => q(78),
					divisor => q(10),
					rule => q(अठहत्तर),
				},
				'79' => {
					base_value => q(79),
					divisor => q(10),
					rule => q(उनासी),
				},
				'80' => {
					base_value => q(80),
					divisor => q(10),
					rule => q(असी),
				},
				'81' => {
					base_value => q(81),
					divisor => q(10),
					rule => q(एकासी),
				},
				'82' => {
					base_value => q(82),
					divisor => q(10),
					rule => q(बयासी),
				},
				'83' => {
					base_value => q(83),
					divisor => q(10),
					rule => q(त्रियासी),
				},
				'84' => {
					base_value => q(84),
					divisor => q(10),
					rule => q(चौरासी),
				},
				'85' => {
					base_value => q(85),
					divisor => q(10),
					rule => q(पचासी),
				},
				'86' => {
					base_value => q(86),
					divisor => q(10),
					rule => q(छयासी),
				},
				'87' => {
					base_value => q(87),
					divisor => q(10),
					rule => q(सतासी),
				},
				'88' => {
					base_value => q(88),
					divisor => q(10),
					rule => q(अठासी),
				},
				'89' => {
					base_value => q(89),
					divisor => q(10),
					rule => q(उनान्नब्बे),
				},
				'90' => {
					base_value => q(90),
					divisor => q(10),
					rule => q(नब्बे),
				},
				'91' => {
					base_value => q(91),
					divisor => q(10),
					rule => q(एकानब्बे),
				},
				'92' => {
					base_value => q(92),
					divisor => q(10),
					rule => q(बयानब्बे),
				},
				'93' => {
					base_value => q(93),
					divisor => q(10),
					rule => q(त्रियानब्बे),
				},
				'94' => {
					base_value => q(94),
					divisor => q(10),
					rule => q(चौरानब्बे),
				},
				'95' => {
					base_value => q(95),
					divisor => q(10),
					rule => q(पन्चानब्बे),
				},
				'96' => {
					base_value => q(96),
					divisor => q(10),
					rule => q(छयानब्बे),
				},
				'97' => {
					base_value => q(97),
					divisor => q(10),
					rule => q(सन्तानब्बे),
				},
				'98' => {
					base_value => q(98),
					divisor => q(10),
					rule => q(अन्ठानब्बे),
				},
				'99' => {
					base_value => q(99),
					divisor => q(10),
					rule => q(उनान्सय),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(←← सय[ →→]),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(←← हजार[ →→]),
				},
				'100000' => {
					base_value => q(100000),
					divisor => q(100000),
					rule => q(←← लाख[ →→]),
				},
				'10000000' => {
					base_value => q(10000000),
					divisor => q(10000000),
					rule => q(←← करोड[ →→]),
				},
				'1000000000' => {
					base_value => q(1000000000),
					divisor => q(1000000000),
					rule => q(←← अरब[ →→]),
				},
				'100000000000' => {
					base_value => q(100000000000),
					divisor => q(100000000000),
					rule => q(←← खरब[ →→]),
				},
				'10000000000000' => {
					base_value => q(10000000000000),
					divisor => q(10000000000000),
					rule => q(←← शंख[ →→]),
				},
				'1000000000000000' => {
					base_value => q(1000000000000000),
					divisor => q(1000000000000000),
					rule => q(=#,##,##0=),
				},
				'Inf' => {
					divisor => q(1),
					rule => q(अनन्त),
				},
				'max' => {
					divisor => q(1),
					rule => q(अनन्त),
				},
			},
		},
		'spellout-numbering-year' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(ऋणात्मक →→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-numbering=),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(=#,##,##0.#=),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(100),
					rule => q(←← सय[ →→]),
				},
				'10000' => {
					base_value => q(10000),
					divisor => q(10000),
					rule => q(=%spellout-numbering=),
				},
				'max' => {
					base_value => q(10000),
					divisor => q(10000),
					rule => q(=%spellout-numbering=),
				},
			},
		},
		'spellout-ordinal-feminine' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(ऋणात्मक →→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(शुन्यौँ),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(=#,##,##0.#=),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(पहिली),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(दोस्री),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(तेस्री),
				},
				'4' => {
					base_value => q(4),
					divisor => q(1),
					rule => q(चौथी),
				},
				'5' => {
					base_value => q(5),
					divisor => q(1),
					rule => q(पाँचवी),
				},
				'6' => {
					base_value => q(6),
					divisor => q(1),
					rule => q(=%spellout-ordinal-masculine=),
				},
				'max' => {
					base_value => q(6),
					divisor => q(1),
					rule => q(=%spellout-ordinal-masculine=),
				},
			},
		},
		'spellout-ordinal-masculine' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(ऋणात्मक →→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(शुन्यौँ),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(=#,##,##0.#=),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(पहिलो),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(दोस्रो),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(तेस्रो),
				},
				'4' => {
					base_value => q(4),
					divisor => q(1),
					rule => q(चौथो),
				},
				'5' => {
					base_value => q(5),
					divisor => q(1),
					rule => q(पाँचौँ),
				},
				'6' => {
					base_value => q(6),
					divisor => q(1),
					rule => q(छैटौँ),
				},
				'7' => {
					base_value => q(7),
					divisor => q(1),
					rule => q(सातौँ),
				},
				'8' => {
					base_value => q(8),
					divisor => q(1),
					rule => q(आठौँ),
				},
				'9' => {
					base_value => q(9),
					divisor => q(1),
					rule => q(नवौँ),
				},
				'10' => {
					base_value => q(10),
					divisor => q(10),
					rule => q(दशौँ),
				},
				'11' => {
					base_value => q(11),
					divisor => q(10),
					rule => q(एघारौँ),
				},
				'12' => {
					base_value => q(12),
					divisor => q(10),
					rule => q(बाह्रौँ),
				},
				'13' => {
					base_value => q(13),
					divisor => q(10),
					rule => q(=%spellout-numbering=ौँ),
				},
				'60' => {
					base_value => q(60),
					divisor => q(10),
					rule => q(=%spellout-numbering=औँ),
				},
				'71' => {
					base_value => q(71),
					divisor => q(10),
					rule => q(=%spellout-numbering=ौँ),
				},
				'80' => {
					base_value => q(80),
					divisor => q(10),
					rule => q(=%spellout-numbering=औँ),
				},
				'99' => {
					base_value => q(99),
					divisor => q(10),
					rule => q(=%spellout-numbering=ौँ),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(←%spellout-numbering← सय→%%consonant-suffix→),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(←%spellout-numbering← हजार→%%consonant-suffix→),
				},
				'100000' => {
					base_value => q(100000),
					divisor => q(100000),
					rule => q(←%spellout-numbering← लाख→%%consonant-suffix→),
				},
				'10000000' => {
					base_value => q(10000000),
					divisor => q(10000000),
					rule => q(←%spellout-numbering← करोड→%%consonant-suffix→),
				},
				'1000000000' => {
					base_value => q(1000000000),
					divisor => q(1000000000),
					rule => q(←%spellout-numbering← अरब→%%consonant-suffix→),
				},
				'100000000000' => {
					base_value => q(100000000000),
					divisor => q(100000000000),
					rule => q(←%spellout-numbering← खरब→%%consonant-suffix→),
				},
				'10000000000000' => {
					base_value => q(10000000000000),
					divisor => q(10000000000000),
					rule => q(←%spellout-numbering← शंख→%%consonant-suffix→),
				},
				'1000000000000000' => {
					base_value => q(1000000000000000),
					divisor => q(1000000000000000),
					rule => q(=#,##,##0=.),
				},
				'max' => {
					base_value => q(1000000000000000),
					divisor => q(1000000000000000),
					rule => q(=#,##,##0=.),
				},
			},
		},
    } },
);

# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $region, $script, $variant) = @_;

	my $display_pattern = '{0} ({1})';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0}, {1}', grep {$_} (
		$region,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		 sub {
			 my %languages = (
				'aa' => 'अफार',
 				'ab' => 'अब्खाजियाली',
 				'ace' => 'अचाइनिज',
 				'ach' => 'अकोली',
 				'ada' => 'अदाङमे',
 				'ady' => 'अदिघे',
 				'ae' => 'अवेस्तान',
 				'af' => 'अफ्रिकान्स',
 				'afh' => 'अफ्रिहिली',
 				'agq' => 'आघेम',
 				'ain' => 'अइनु',
 				'ak' => 'आकान',
 				'akk' => 'अक्कादियाली',
 				'akz' => 'अलाबामा',
 				'ale' => 'अलेउट',
 				'aln' => 'घेग अल्बानियाली',
 				'alt' => 'दक्षिणी आल्टाइ',
 				'am' => 'अम्हारिक',
 				'an' => 'अरागोनी',
 				'ang' => 'पुरातन अङ्ग्रेजी',
 				'anp' => 'अङ्गिका',
 				'ar' => 'अरबी',
 				'ar_001' => 'आधुनिक मानक अरबी',
 				'arc' => 'अरामाइक',
 				'arn' => 'मापुचे',
 				'aro' => 'अराओना',
 				'arp' => 'अरापाहो',
 				'arq' => 'अल्जेरियाली अरबी',
 				'arw' => 'अरावाक',
 				'ary' => 'मोरोक्कोली अरबी',
 				'arz' => 'इजिप्ट अरबी',
 				'as' => 'आसामी',
 				'asa' => 'आसु',
 				'ase' => 'अमेरिकी साङ्केतिक भाषा',
 				'ast' => 'अस्टुरियाली',
 				'av' => 'अवारिक',
 				'avk' => 'कोटावा',
 				'awa' => 'अवधी',
 				'ay' => 'ऐमारा',
 				'az' => 'अजरबैजानी',
 				'az@alt=short' => 'अजेरी',
 				'ba' => 'बास्किर',
 				'bal' => 'बालुची',
 				'ban' => 'बाली',
 				'bar' => 'बाभारियाली',
 				'bas' => 'बासा',
 				'bax' => 'बामुन',
 				'bbc' => 'बाताक तोबा',
 				'bbj' => 'घोमाला',
 				'be' => 'बेलारुसी',
 				'bej' => 'बेजा',
 				'bem' => 'बेम्बा',
 				'bew' => 'बेटावी',
 				'bez' => 'बेना',
 				'bfd' => 'बाफुट',
 				'bfq' => 'बडागा',
 				'bg' => 'बुल्गेरियाली',
 				'bgn' => 'पश्चिम बालोची',
 				'bho' => 'भोजपुरी',
 				'bi' => 'बिस्लाम',
 				'bik' => 'बिकोल',
 				'bin' => 'बिनी',
 				'bjn' => 'बन्जार',
 				'bkm' => 'कोम',
 				'bla' => 'सिक्सिका',
 				'bm' => 'बाम्बारा',
 				'bn' => 'बंगाली',
 				'bo' => 'तिब्बती',
 				'bpy' => 'विष्णुप्रिया',
 				'bqi' => 'बाख्तिआरी',
 				'br' => 'ब्रेटन',
 				'bra' => 'ब्रज',
 				'brh' => 'ब्राहुइ',
 				'brx' => 'बोडो',
 				'bs' => 'बोस्नियाली',
 				'bss' => 'अकुज',
 				'bua' => 'बुरिआत',
 				'bug' => 'बुगिनियाली',
 				'bum' => 'बुलु',
 				'byn' => 'ब्लिन',
 				'byv' => 'मेडुम्बा',
 				'ca' => 'क्याटालन',
 				'cad' => 'काड्डो',
 				'car' => 'क्यारिब',
 				'cay' => 'कायुगा',
 				'cch' => 'अट्साम',
 				'ccp' => 'चाक्मा',
 				'ce' => 'चेचेन',
 				'ceb' => 'सेबुआनो',
 				'cgg' => 'चिगा',
 				'ch' => 'चामोर्रो',
 				'chb' => 'चिब्चा',
 				'chg' => 'चागाटाई',
 				'chk' => 'चुकेसे',
 				'chm' => 'मारी',
 				'chn' => 'चिनुक जार्गन',
 				'cho' => 'चोक्टाव',
 				'chp' => 'चिपेव्यान',
 				'chr' => 'चेरोकी',
 				'chy' => 'चेयेन्ने',
 				'ckb' => 'मध्यवर्ती कुर्दिस',
 				'co' => 'कोर्सिकन',
 				'cop' => 'कोप्टिक',
 				'cps' => 'कापिज्नोन',
 				'cr' => 'क्री',
 				'crh' => 'क्रिमियाली तुर्क',
 				'crs' => 'सेसेल्वा क्रिओल फ्रान्सेली',
 				'cs' => 'चेक',
 				'csb' => 'कासुवियन',
 				'cu' => 'चर्च स्लाभिक',
 				'cv' => 'चुभास',
 				'cy' => 'वेल्श',
 				'da' => 'डेनिस',
 				'dak' => 'डाकोटा',
 				'dar' => 'दार्ग्वा',
 				'dav' => 'ताइता',
 				'de' => 'जर्मन',
 				'de_AT' => 'अस्ट्रिएन जर्मन',
 				'de_CH' => 'स्वीस हाई जर्मन',
 				'del' => 'देलावर',
 				'dgr' => 'दोग्रिब',
 				'din' => 'दिन्का',
 				'dje' => 'जर्मा',
 				'doi' => 'डोगरी',
 				'dsb' => 'तल्लो सोर्बियन',
 				'dtp' => 'केन्द्रीय दुसुन',
 				'dua' => 'दुवाला',
 				'dum' => 'मध्य डच',
 				'dv' => 'दिबेही',
 				'dyo' => 'जोला-फोनिल',
 				'dyu' => 'द्युला',
 				'dz' => 'जोङ्खा',
 				'dzg' => 'दाजागा',
 				'ebu' => 'एम्बु',
 				'ee' => 'इवी',
 				'efi' => 'एफिक',
 				'egl' => 'एमिलियाली',
 				'egy' => 'पुरातन इजिप्टी',
 				'eka' => 'एकाजुक',
 				'el' => 'ग्रीक',
 				'elx' => 'एलामाइट',
 				'en' => 'अङ्ग्रेजी',
 				'en_AU' => 'अस्ट्रेलियाली अङ्ग्रेजी',
 				'en_CA' => 'क्यानाडेली अङ्ग्रेजी',
 				'en_GB' => 'बेलायती अङ्ग्रेजी',
 				'en_GB@alt=short' => 'संयुक्त अधिराज्य अङ्ग्रेजी',
 				'en_US' => 'अमेरिकी अङ्ग्रेजी',
 				'en_US@alt=short' => 'युएस अङ्ग्रेजी',
 				'enm' => 'मध्य अङ्ग्रेजी',
 				'eo' => 'एस्पेरान्तो',
 				'es' => 'स्पेनी',
 				'es_419' => 'ल्याटिन अमेरिकी स्पेनी',
 				'es_ES' => 'युरोपेली स्पेनी',
 				'es_MX' => 'मेक्सिकन स्पेनी',
 				'esu' => 'केन्द्रीय युपिक',
 				'et' => 'इस्टोनियन',
 				'eu' => 'बास्क',
 				'ewo' => 'इवोन्डो',
 				'ext' => 'एक्सट्रेमादुराली',
 				'fa' => 'फारसी',
 				'fa_AF' => 'दारी',
 				'fan' => 'फाङ',
 				'fat' => 'फान्टी',
 				'ff' => 'फुलाह',
 				'fi' => 'फिनिस',
 				'fil' => 'फिलिपिनी',
 				'fj' => 'फिजियन',
 				'fo' => 'फारोज',
 				'fon' => 'फोन',
 				'fr' => 'फ्रान्सेली',
 				'fr_CA' => 'क्यानेडाली फ्रान्सेली',
 				'fr_CH' => 'स्विस फ्रेन्च',
 				'frc' => 'काहुन फ्रान्सेली',
 				'frm' => 'मध्य फ्रान्सेली',
 				'fro' => 'पुरातन फ्रान्सेली',
 				'frp' => 'अर्पितान',
 				'frr' => 'उत्तरी फ्रिजी',
 				'frs' => 'पूर्वी फ्रिसियाली',
 				'fur' => 'फ्रिउलियाली',
 				'fy' => 'पश्चिमी फ्रिसियन',
 				'ga' => 'आइरिस',
 				'gaa' => 'गा',
 				'gag' => 'गगाउज',
 				'gan' => 'गान चिनियाँ',
 				'gay' => 'गायो',
 				'gba' => 'ग्बाया',
 				'gd' => 'स्कटिस गाएलिक',
 				'gez' => 'गिज',
 				'gil' => 'गिल्बर्टी',
 				'gl' => 'गलिसियाली',
 				'glk' => 'गिलाकी',
 				'gmh' => 'मध्य उच्च जर्मन',
 				'gn' => 'गुवारानी',
 				'goh' => 'पुरातन उच्च जर्मन',
 				'gom' => 'गोवा कोन्कानी',
 				'gon' => 'गोन्डी',
 				'gor' => 'गोरोन्टालो',
 				'got' => 'गोथिक',
 				'grb' => 'ग्रेबो',
 				'grc' => 'पुरातन ग्रिक',
 				'gsw' => 'स्वीस जर्मन',
 				'gu' => 'गुजराती',
 				'gur' => 'फ्राफ्रा',
 				'guz' => 'गुसी',
 				'gv' => 'मान्क्स',
 				'gwi' => 'गुइचिन',
 				'ha' => 'हाउसा',
 				'hai' => 'हाइदा',
 				'hak' => 'हक्का चिनियाँ',
 				'haw' => 'हवाइयन',
 				'he' => 'हिब्रु',
 				'hi' => 'हिन्दी',
 				'hif' => 'फिजी हिन्दी',
 				'hil' => 'हिलिगायनोन',
 				'hit' => 'हिट्टिटे',
 				'hmn' => 'हमोङ',
 				'ho' => 'हिरी मोटु',
 				'hr' => 'क्रोयसियाली',
 				'hsb' => 'माथिल्लो सोर्बियन',
 				'hsn' => 'जियाङ चिनियाँ',
 				'ht' => 'हैटियाली क्रियोल',
 				'hu' => 'हङ्गेरियाली',
 				'hup' => 'हुपा',
 				'hy' => 'आर्मेनियाली',
 				'hz' => 'हेरेरो',
 				'ia' => 'इन्टर्लिङ्गुआ',
 				'iba' => 'इबान',
 				'ibb' => 'इबिबियो',
 				'id' => 'इन्डोनेसियाली',
 				'ie' => 'इन्टरलिङ्ग्वे',
 				'ig' => 'इग्बो',
 				'ii' => 'सिचुआन यि',
 				'ik' => 'इनुपिआक्',
 				'ilo' => 'इयोको',
 				'inh' => 'इन्गस',
 				'io' => 'इडो',
 				'is' => 'आइसल्यान्डियाली',
 				'it' => 'इटालेली',
 				'iu' => 'इनुक्टिटुट',
 				'izh' => 'इन्ग्रियाली',
 				'ja' => 'जापानी',
 				'jam' => 'जमैकाली क्रेओले अङ्ग्रेजी',
 				'jbo' => 'लोज्बान',
 				'jgo' => 'न्गोम्बा',
 				'jmc' => 'माचामे',
 				'jpr' => 'जुडियो-फारसी',
 				'jrb' => 'जुडियो-अरबी',
 				'jut' => 'जुटिस',
 				'jv' => 'जाभानी',
 				'ka' => 'जर्जियाली',
 				'kaa' => 'कारा-काल्पाक',
 				'kab' => 'काबिल',
 				'kac' => 'काचिन',
 				'kaj' => 'ज्जु',
 				'kam' => 'काम्बा',
 				'kaw' => 'कावी',
 				'kbd' => 'काबार्दियाली',
 				'kbl' => 'कानेम्बु',
 				'kcg' => 'टुआप',
 				'kde' => 'माकोन्डे',
 				'kea' => 'काबुभेर्डियानु',
 				'ken' => 'केनयाङ',
 				'kfo' => 'कोरो',
 				'kg' => 'कोङ्गो',
 				'kgp' => 'काइनगाङ',
 				'kha' => 'खासी',
 				'kho' => 'खोटानी',
 				'khq' => 'कोयरा चिनी',
 				'khw' => 'खोवार',
 				'ki' => 'किकुयु',
 				'kiu' => 'किर्मान्जकी',
 				'kj' => 'कुआन्यामा',
 				'kk' => 'काजाख',
 				'kkj' => 'काको',
 				'kl' => 'कालालिसुट',
 				'kln' => 'कालेन्जिन',
 				'km' => 'खमेर',
 				'kmb' => 'किम्बुन्डु',
 				'kn' => 'कन्नाडा',
 				'ko' => 'कोरियाली',
 				'koi' => 'कोमी-पर्म्याक',
 				'kok' => 'कोन्कानी',
 				'kos' => 'कोस्राली',
 				'kpe' => 'क्पेल्ले',
 				'kr' => 'कानुरी',
 				'krc' => 'काराचाय-बाल्कर',
 				'kri' => 'क्रिओ',
 				'krj' => 'किनाराय-ए',
 				'krl' => 'करेलियन',
 				'kru' => 'कुरुख',
 				'ks' => 'कास्मिरी',
 				'ksb' => 'शाम्बाला',
 				'ksf' => 'बाफिया',
 				'ksh' => 'कोलोग्नियाली',
 				'ku' => 'कुर्दी',
 				'kum' => 'कुमिक',
 				'kut' => 'कुतेनाइ',
 				'kv' => 'कोमी',
 				'kw' => 'कोर्निस',
 				'ky' => 'किर्गिज',
 				'la' => 'ल्याटिन',
 				'lad' => 'लाडिनो',
 				'lag' => 'लाङ्गी',
 				'lah' => 'लाहन्डा',
 				'lam' => 'लाम्बा',
 				'lb' => 'लक्जेम्बर्गी',
 				'lez' => 'लाज्घियाली',
 				'lfn' => 'लिङ्गुवा फ्राङ्का नोभा',
 				'lg' => 'गान्डा',
 				'li' => 'लिम्बुर्गी',
 				'lij' => 'लिगुरियाली',
 				'liv' => 'लिभोनियाली',
 				'lkt' => 'लाकोता',
 				'lmo' => 'लोम्बार्ड',
 				'ln' => 'लिङ्गाला',
 				'lo' => 'लाओ',
 				'lol' => 'मोङ्गो',
 				'loz' => 'लोजी',
 				'lrc' => 'उत्तरी लुरी',
 				'lt' => 'लिथुआनियाली',
 				'ltg' => 'लाट्गाली',
 				'lu' => 'लुबा-काताङ्गा',
 				'lua' => 'लुबा-लुलुआ',
 				'lui' => 'लुइसेनो',
 				'lun' => 'लुन्डा',
 				'luo' => 'लुओ',
 				'lus' => 'मिजो',
 				'luy' => 'लुइया',
 				'lv' => 'लात्भियाली',
 				'lzh' => 'साहित्यिक चिनियाँ',
 				'lzz' => 'लाज',
 				'mad' => 'मादुरेसे',
 				'maf' => 'माफा',
 				'mag' => 'मगधी',
 				'mai' => 'मैथिली',
 				'mak' => 'माकासार',
 				'man' => 'मान्दिङो',
 				'mas' => 'मसाई',
 				'mde' => 'माबा',
 				'mdf' => 'मोक्ष',
 				'mdr' => 'मन्दर',
 				'men' => 'मेन्डे',
 				'mer' => 'मेरू',
 				'mfe' => 'मोरिसेन',
 				'mg' => 'मलागासी',
 				'mga' => 'मध्य आयरिस',
 				'mgh' => 'माखुवा-मिट्टो',
 				'mgo' => 'मेटा',
 				'mh' => 'मार्साली',
 				'mi' => 'माओरी',
 				'mic' => 'मिकमाक',
 				'min' => 'मिनाङकाबाउ',
 				'mk' => 'म्यासेडोनियन',
 				'ml' => 'मलयालम',
 				'mn' => 'मङ्गोलियाली',
 				'mnc' => 'मान्चु',
 				'mni' => 'मनिपुरी',
 				'moh' => 'मोहक',
 				'mos' => 'मोस्सी',
 				'mr' => 'मराठी',
 				'ms' => 'मलाय',
 				'mt' => 'माल्टिज',
 				'mua' => 'मुन्डाङ',
 				'mul' => 'बहुभाषा',
 				'mus' => 'क्रिक',
 				'mwl' => 'मिरान्डी',
 				'mwr' => 'माडवारी',
 				'mwv' => 'मेन्टावाई',
 				'my' => 'बर्मेली',
 				'mye' => 'म्येने',
 				'myv' => 'इर्ज्या',
 				'mzn' => 'मजानडेरानी',
 				'na' => 'नाउरू',
 				'nan' => 'मिन नान चिनियाँ',
 				'nap' => 'नेपोलिटान',
 				'naq' => 'नामा',
 				'nb' => 'नर्वेली बोकमाल',
 				'nd' => 'उत्तरी न्डेबेले',
 				'nds' => 'तल्लो जर्मन',
 				'nds_NL' => 'तल्लो साक्सन',
 				'ne' => 'नेपाली',
 				'new' => 'नेवारी',
 				'ng' => 'न्दोन्गा',
 				'nia' => 'नियास',
 				'niu' => 'निउएन',
 				'njo' => 'अओ नागा',
 				'nl' => 'डच',
 				'nl_BE' => 'फ्लेमिस',
 				'nmg' => 'क्वासियो',
 				'nn' => 'नर्वेली नाइनोर्स्क',
 				'nnh' => 'न्गिएम्बुन',
 				'no' => 'नर्वेली',
 				'nog' => 'नोगाइ',
 				'non' => 'पुरानो नोर्से',
 				'nov' => 'नोभियल',
 				'nqo' => 'नको',
 				'nr' => 'दक्षिण न्देबेले',
 				'nso' => 'उत्तरी सोथो',
 				'nus' => 'नुएर',
 				'nv' => 'नाभाजो',
 				'nwc' => 'परम्परागत नेवारी',
 				'ny' => 'न्यान्जा',
 				'nym' => 'न्यामवेजी',
 				'nyn' => 'न्यान्कोल',
 				'nyo' => 'न्योरो',
 				'nzi' => 'नजिमा',
 				'oc' => 'अक्सिटन',
 				'oj' => 'ओजिब्वा',
 				'om' => 'ओरोमो',
 				'or' => 'उडिया',
 				'os' => 'ओस्सेटिक',
 				'osa' => 'ओसागे',
 				'ota' => 'अटोमन तुर्की',
 				'pa' => 'पंजाबी',
 				'pag' => 'पाङ्गासिनान',
 				'pal' => 'पाहलावी',
 				'pam' => 'पामपाङ्गा',
 				'pap' => 'पापियामेन्तो',
 				'pau' => 'पालाउवाली',
 				'pcd' => 'पिकार्ड',
 				'pcm' => 'नाइजेरियाली पिड्जिन',
 				'pdc' => 'पेन्सिलभानियाली जर्मन',
 				'peo' => 'पुरातन फारसी',
 				'pfl' => 'पालाटिन जर्मन',
 				'phn' => 'फोनिसियाली',
 				'pi' => 'पाली',
 				'pl' => 'पोलिस',
 				'pms' => 'पिएडमोन्तेसे',
 				'pnt' => 'पोन्टिक',
 				'prg' => 'प्रसियाली',
 				'pro' => 'पुरातन प्रोभेन्काल',
 				'ps' => 'पास्तो',
 				'pt' => 'पोर्तुगी',
 				'pt_BR' => 'ब्राजिली पोर्तुगी',
 				'pt_PT' => 'युरोपेली पोर्तुगी',
 				'qu' => 'क्वेचुवा',
 				'quc' => 'किचे',
 				'qug' => 'चिम्बोराजो उच्चस्थान किचुआ',
 				'raj' => 'राजस्थानी',
 				'rap' => 'रापानुई',
 				'rar' => 'रारोटोङ्गान',
 				'rhg' => 'रोहिङ्ग्या',
 				'rm' => 'रोमानिस',
 				'rn' => 'रुन्डी',
 				'ro' => 'रोमानियाली',
 				'ro_MD' => 'मोल्डाभियाली',
 				'rof' => 'रोम्बो',
 				'ru' => 'रसियाली',
 				'rup' => 'अरोमानीयाली',
 				'rw' => 'किन्यारवान्डा',
 				'rwk' => 'र्‌वा',
 				'sa' => 'संस्कृत',
 				'sad' => 'सान्डेअ',
 				'sah' => 'साखा',
 				'saq' => 'साम्बुरू',
 				'sat' => 'सान्ताली',
 				'sba' => 'न्गामबाय',
 				'sbp' => 'साङ्गु',
 				'sc' => 'सार्डिनियाली',
 				'scn' => 'सिसिलियाली',
 				'sco' => 'स्कट्स',
 				'sd' => 'सिन्धी',
 				'sdh' => 'दक्षिणी कुर्दिश',
 				'se' => 'उत्तरी सामी',
 				'seh' => 'सेना',
 				'ses' => 'कोयराबोरो सेन्नी',
 				'sg' => 'साङ्गो',
 				'sga' => 'पुरातन आयरीस',
 				'shi' => 'टाचेल्हिट',
 				'shn' => 'शान',
 				'shu' => 'चाड अरबी',
 				'si' => 'सिन्हाली',
 				'sk' => 'स्लोभाकियाली',
 				'sl' => 'स्लोभेनियाली',
 				'sli' => 'तल्लो सिलेसियाली',
 				'sm' => 'सामोआ',
 				'sma' => 'दक्षिणी सामी',
 				'smj' => 'लुले सामी',
 				'smn' => 'इनारी सामी',
 				'sms' => 'स्कोइट सामी',
 				'sn' => 'शोना',
 				'snk' => 'सोनिन्के',
 				'so' => 'सोमाली',
 				'sq' => 'अल्बानियाली',
 				'sr' => 'सर्बियाली',
 				'srn' => 'स्रानान टोङ्गो',
 				'ss' => 'स्वाती',
 				'ssy' => 'साहो',
 				'st' => 'दक्षिणी सोथो',
 				'su' => 'सुडानी',
 				'suk' => 'सुकुमा',
 				'sus' => 'सुसू',
 				'sux' => 'सुमेरियाली',
 				'sv' => 'स्विडिस',
 				'sw' => 'स्वाहिली',
 				'sw_CD' => 'कङ्गो स्वाहिली',
 				'swb' => 'कोमोरी',
 				'syc' => 'परम्परागत सिरियाक',
 				'syr' => 'सिरियाक',
 				'ta' => 'तामिल',
 				'te' => 'तेलुगु',
 				'tem' => 'टिम्ने',
 				'teo' => 'टेसो',
 				'tet' => 'टेटुम',
 				'tg' => 'ताजिक',
 				'th' => 'थाई',
 				'ti' => 'टिग्रिन्या',
 				'tig' => 'टिग्रे',
 				'tk' => 'टर्कमेन',
 				'tlh' => 'क्लिङ्गन',
 				'tn' => 'ट्स्वाना',
 				'to' => 'टोङ्गन',
 				'tog' => 'न्यास टोङ्गा',
 				'tpi' => 'टोक पिसिन',
 				'tr' => 'टर्किश',
 				'trv' => 'टारोको',
 				'ts' => 'ट्सोङ्गा',
 				'tt' => 'तातार',
 				'ttt' => 'मुस्लिम टाट',
 				'tum' => 'टुम्बुका',
 				'tvl' => 'टुभालु',
 				'twq' => 'तासावाक',
 				'ty' => 'टाहिटियन',
 				'tyv' => 'टुभिनियाली',
 				'tzm' => 'केन्द्रीय एट्लास टामाजिघट',
 				'udm' => 'उड्मुर्ट',
 				'ug' => 'उइघुर',
 				'uk' => 'युक्रेनी',
 				'umb' => 'उम्बुन्डी',
 				'und' => 'अज्ञात भाषा',
 				'ur' => 'उर्दु',
 				'uz' => 'उज्बेकी',
 				'vai' => 'भाइ',
 				've' => 'भेन्डा',
 				'vi' => 'भियतनामी',
 				'vmf' => 'मुख्य-फ्राङ्कोनियाली',
 				'vo' => 'भोलापिक',
 				'vun' => 'भुन्जो',
 				'wa' => 'वाल्लुन',
 				'wae' => 'वाल्सर',
 				'wal' => 'वोलेट्टा',
 				'war' => 'वारे',
 				'wbp' => 'वार्ल्पिरी',
 				'wo' => 'वुलुफ',
 				'xal' => 'काल्मिक',
 				'xh' => 'खोसा',
 				'xmf' => 'मिनग्रेलियाली',
 				'xog' => 'सोगा',
 				'yav' => 'याङ्बेन',
 				'ybb' => 'येम्बा',
 				'yi' => 'यिद्दिस',
 				'yo' => 'योरूवा',
 				'yrl' => 'न्हिनगातु',
 				'yue' => 'क्यान्टोनिज',
 				'yue@alt=menu' => 'चिनियाँ, क्यान्टोनिज',
 				'zbl' => 'ब्लिससिम्बोल्स',
 				'zgh' => 'मानक मोरोक्कोन तामाजिघट',
 				'zh' => 'चिनियाँ',
 				'zh@alt=menu' => 'चिनियाँ, म्यान्डरिन',
 				'zh_Hans' => 'सरलिकृत चिनियाँ',
 				'zh_Hans@alt=long' => 'सरलिकृत म्यान्डरिन चिनियाँ',
 				'zh_Hant' => 'परम्परागत चिनियाँ',
 				'zh_Hant@alt=long' => 'परम्परागत म्यान्डरिन चिनियाँ',
 				'zu' => 'जुलु',
 				'zun' => 'जुनी',
 				'zxx' => 'भाषिक सामग्री छैन',
 				'zza' => 'जाजा',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Arab' => 'अरबी',
 			'Armi' => 'आर्मी',
 			'Armn' => 'आर्मेनियाली',
 			'Avst' => 'आभेस्टान',
 			'Bali' => 'बाली',
 			'Batk' => 'बाटक',
 			'Beng' => 'बङ्गाली',
 			'Blis' => 'ब्लिजसिम्बोल्स',
 			'Bopo' => 'बोपोमोफो',
 			'Brah' => 'ब्राह्मी',
 			'Brai' => 'ब्रेल',
 			'Bugi' => 'बुगिनिज',
 			'Buhd' => 'बुहिद',
 			'Cakm' => 'काक्म्',
 			'Cari' => 'कारियन',
 			'Cham' => 'चाम',
 			'Cher' => 'चेरोकी',
 			'Cirt' => 'किर्थ',
 			'Copt' => 'कप्टिक',
 			'Cprt' => 'कप्रियट',
 			'Cyrl' => 'सिरिलिक',
 			'Deva' => 'देवानागरी',
 			'Dsrt' => 'डेसेरेट',
 			'Egyd' => 'इजिप्टियन डेमोटिक',
 			'Egyh' => 'इजिप्टियन हाइरटिक',
 			'Egyp' => 'इजिप्टियन हाइरोग्लिफ्स',
 			'Ethi' => 'इथियोपिक',
 			'Geok' => 'ग्रुजियाली खुट्सुरी',
 			'Geor' => 'जर्जियाली',
 			'Glag' => 'ग्लागोलिटिक',
 			'Goth' => 'गोथिक',
 			'Grek' => 'ग्रीक',
 			'Gujr' => 'गुजराती',
 			'Guru' => 'गुरूमुखी',
 			'Hanb' => 'हान्ब',
 			'Hang' => 'हान्गुल',
 			'Hani' => 'हान',
 			'Hano' => 'हानुनु',
 			'Hans' => 'सरलिकृत चिनियाँ',
 			'Hans@alt=stand-alone' => 'सरलीकृत चिनियाँ',
 			'Hant' => 'परम्परागत चिनियाँ',
 			'Hebr' => 'हिब्रु',
 			'Hira' => 'हिरागना',
 			'Hmng' => 'पहावह हमोङ्ग',
 			'Hrkt' => 'काताकाना वा हिरागाना',
 			'Hung' => 'पुरानो हङ्गेरियाली',
 			'Inds' => 'इन्दुस',
 			'Ital' => 'पुरानो इटालिक',
 			'Jamo' => 'जामो',
 			'Java' => 'जाभानी',
 			'Jpan' => 'जापानी',
 			'Kali' => 'कायाहली',
 			'Kana' => 'काताकाना',
 			'Khar' => 'खारोस्थिति',
 			'Khmr' => 'खमेर',
 			'Knda' => 'कान्नाडा',
 			'Kore' => 'कोरियन',
 			'Kthi' => 'क्थी',
 			'Lana' => 'लान्ना',
 			'Laoo' => 'लाओ',
 			'Latf' => 'फ्राक्टुर ल्याटिन',
 			'Latg' => 'ग्यालिक ल्याटिन',
 			'Latn' => 'ल्याटिन',
 			'Lepc' => 'लेप्चा',
 			'Limb' => 'लिम्बु',
 			'Lyci' => 'लाइसियन',
 			'Lydi' => 'लाइडियन',
 			'Mand' => 'मान्डाएन',
 			'Mani' => 'मानिकाएन',
 			'Maya' => 'माया हाइरोग्लिफ्स',
 			'Mero' => 'मेरियोटिक',
 			'Mlym' => 'मलायालम',
 			'Mong' => 'मङ्गोल',
 			'Moon' => 'जून',
 			'Mtei' => 'माइटेइ मायेक',
 			'Mymr' => 'म्यान्मार',
 			'Nkoo' => 'एन्को',
 			'Ogam' => 'ओघाम',
 			'Olck' => 'ओलचिकी',
 			'Orkh' => 'ओर्खोन',
 			'Orya' => 'ओडिया',
 			'Osma' => 'ओस्मान्या',
 			'Perm' => 'पुरानो पर्मिक',
 			'Phag' => 'फाग्स-पा',
 			'Phli' => 'फ्लि',
 			'Phlp' => 'फ्ल्प',
 			'Phlv' => 'बुक पहल्भी',
 			'Phnx' => 'फोनिसियन',
 			'Plrd' => 'पोल्लार्ड फोनेटिक',
 			'Prti' => 'पिआरटी',
 			'Rjng' => 'रेजाङ',
 			'Roro' => 'रोङ्गोरोङ्गो',
 			'Runr' => 'रूनिक',
 			'Samr' => 'समारिटन',
 			'Sara' => 'सारती',
 			'Saur' => 'सौराष्ट्र',
 			'Sgnw' => 'साइनराइटिङ',
 			'Shaw' => 'शाभियन',
 			'Sinh' => 'सिन्हाला',
 			'Sylo' => 'स्ल्योटी नाग्री',
 			'Syrc' => 'सिरियाक',
 			'Syre' => 'इस्ट्रेनजेलो सिरियाक',
 			'Syrj' => 'पश्चिमी सिरियाक',
 			'Syrn' => 'पूर्वी सिरियाक',
 			'Tagb' => 'टाग्वान्वा',
 			'Tale' => 'टाइले',
 			'Talu' => 'न्यू टाइ लुइ',
 			'Taml' => 'तामिल',
 			'Tavt' => 'टाभ्ट',
 			'Telu' => 'तेलुगु',
 			'Teng' => 'टेङ्वार',
 			'Tfng' => 'टिफिनाघ',
 			'Tglg' => 'टागालोग',
 			'Thaa' => 'थाना',
 			'Thai' => 'थाई',
 			'Tibt' => 'तिब्बती',
 			'Ugar' => 'युगारिटिक',
 			'Vaii' => 'भाइ',
 			'Visp' => 'दृश्यमय वाणी',
 			'Xpeo' => 'पुरानो पर्सियन',
 			'Yiii' => 'यी',
 			'Zinh' => 'इन्हेरिटेड',
 			'Zmth' => 'गणितीय चिन्ह',
 			'Zsye' => 'इमोजी',
 			'Zsym' => 'प्रतीकहरू',
 			'Zxxx' => 'नलेखिएको',
 			'Zyyy' => 'साझा',
 			'Zzzz' => 'अज्ञात लिपि',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'001' => 'विश्व',
 			'002' => 'अफ्रिका',
 			'003' => 'उत्तर अमेरिका',
 			'005' => 'दक्षिण अमेरिका',
 			'009' => 'ओसनिया',
 			'011' => 'पश्चिमी अफ्रिका',
 			'013' => 'केन्द्रीय अमेरिका',
 			'014' => 'पूर्वी अफ्रिका',
 			'015' => 'उत्तरी अफ्रिका',
 			'017' => 'मध्य अफ्रिका',
 			'018' => 'दक्षिणी अफ्रिका',
 			'019' => 'अमेरिकास',
 			'021' => 'उत्तरी अमेरिका',
 			'029' => 'क्यारिबियन',
 			'030' => 'पूर्वी एशिया',
 			'034' => 'दक्षिणी एशिया',
 			'035' => 'दक्षिण पूर्वी एशिया',
 			'039' => 'दक्षिणी युरोप',
 			'053' => 'अष्ट्रालासिया',
 			'054' => 'मेलानेसिया',
 			'057' => 'माइक्रोनेसियाली क्षेत्र',
 			'061' => 'पोलिनेशिया',
 			'142' => 'एशिया',
 			'143' => 'केन्द्रीय एशिया',
 			'145' => 'पश्चिमी एशिया',
 			'150' => 'युरोप',
 			'151' => 'पूर्वी युरोप',
 			'154' => 'उत्तरी युरोप',
 			'155' => 'पश्चिमी युरोप',
 			'202' => 'उप-साहारा अफ्रिका',
 			'419' => 'ल्याटिन अमेरिका',
 			'AC' => 'असेन्सन टापु',
 			'AD' => 'अन्डोर्रा',
 			'AE' => 'संयुक्त अरब इमिराट्स',
 			'AF' => 'अफगानिस्तान',
 			'AG' => 'एन्टिगुआ र बारबुडा',
 			'AI' => 'आङ्गुइला',
 			'AL' => 'अल्बेनिया',
 			'AM' => 'आर्मेनिया',
 			'AO' => 'अङ्गोला',
 			'AQ' => 'अन्टारटिका',
 			'AR' => 'अर्जेन्टिना',
 			'AS' => 'अमेरिकी समोआ',
 			'AT' => 'अष्ट्रिया',
 			'AU' => 'अस्ट्रेलिया',
 			'AW' => 'अरुबा',
 			'AX' => 'अलान्ड टापुहरु',
 			'AZ' => 'अजरबैजान',
 			'BA' => 'बोस्निया एण्ड हर्जगोभिनिया',
 			'BB' => 'बार्बाडोस',
 			'BD' => 'बङ्गलादेश',
 			'BE' => 'बेल्जियम',
 			'BF' => 'बुर्किना फासो',
 			'BG' => 'बुल्गेरिया',
 			'BH' => 'बहराइन',
 			'BI' => 'बुरूण्डी',
 			'BJ' => 'बेनिन',
 			'BL' => 'सेन्ट बार्थेलेमी',
 			'BM' => 'बर्मुडा',
 			'BN' => 'ब्रुनाइ',
 			'BO' => 'बोलिभिया',
 			'BQ' => 'क्यारिवियन नेदरल्याण्ड्स',
 			'BR' => 'ब्राजिल',
 			'BS' => 'बहामास',
 			'BT' => 'भुटान',
 			'BV' => 'बुभेट टापु',
 			'BW' => 'बोट्स्वाना',
 			'BY' => 'बेलारूस',
 			'BZ' => 'बेलिज',
 			'CA' => 'क्यानाडा',
 			'CC' => 'कोकोस (किलिंग) टापुहरु',
 			'CD' => 'कङ्गो - किन्शासा',
 			'CD@alt=variant' => 'कङ्गो (डीआर्‌सी)',
 			'CF' => 'मध्य अफ्रिकी गणतन्त्र',
 			'CG' => 'कङ्गो ब्राजाभिल',
 			'CG@alt=variant' => 'कङ्गो (गणतन्त्र)',
 			'CH' => 'स्विजरल्याण्ड',
 			'CI' => 'कोट दिभोर',
 			'CI@alt=variant' => 'आइभोरी कोस्ट',
 			'CK' => 'कुक टापुहरु',
 			'CL' => 'चिली',
 			'CM' => 'क्यामरून',
 			'CN' => 'चीन',
 			'CO' => 'कोलोम्बिया',
 			'CP' => 'क्लिप्पेर्टन टापु',
 			'CR' => 'कोष्टारिका',
 			'CU' => 'क्युबा',
 			'CV' => 'केप भर्डे',
 			'CW' => 'कुराकाओ',
 			'CX' => 'क्रिष्टमस टापु',
 			'CY' => 'साइप्रस',
 			'CZ' => 'चेकिया',
 			'CZ@alt=variant' => 'चेक गणतन्त्र',
 			'DE' => 'जर्मनी',
 			'DG' => 'डियगो गार्सिया',
 			'DJ' => 'डिजिबुटी',
 			'DK' => 'डेनमार्क',
 			'DM' => 'डोमिनिका',
 			'DO' => 'डोमिनिकन गणतन्त्र',
 			'DZ' => 'अल्जेरिया',
 			'EA' => 'सिउटा र मेलिला',
 			'EC' => 'इक्वेडोर',
 			'EE' => 'इस्टोनिया',
 			'EG' => 'इजिप्ट',
 			'EH' => 'पश्चिमी साहारा',
 			'ER' => 'एरिट्रीया',
 			'ES' => 'स्पेन',
 			'ET' => 'इथियोपिया',
 			'EU' => 'युरोपियन युनियन',
 			'EZ' => 'युरोजोन',
 			'FI' => 'फिनल्याण्ड',
 			'FJ' => 'फिजी',
 			'FK' => 'फकल्याण्ड टापुहरु',
 			'FK@alt=variant' => 'फक्ल्याण्ड टापुहरू (इज्लास माल्भिनास)',
 			'FM' => 'माइक्रोनेसिया',
 			'FO' => 'फारो टापुहरू',
 			'FR' => 'फ्रान्स',
 			'GA' => 'गावोन',
 			'GB' => 'संयुक्त अधिराज्य',
 			'GB@alt=short' => 'युके',
 			'GD' => 'ग्रेनाडा',
 			'GE' => 'जर्जिया',
 			'GF' => 'फ्रान्सेली गायना',
 			'GG' => 'ग्यूर्न्सी',
 			'GH' => 'घाना',
 			'GI' => 'जिब्राल्टार',
 			'GL' => 'ग्रिनल्याण्ड',
 			'GM' => 'गाम्विया',
 			'GN' => 'गिनी',
 			'GP' => 'ग्वाडेलुप',
 			'GQ' => 'भू-मध्यीय गिनी',
 			'GR' => 'ग्रीस',
 			'GS' => 'दक्षिण जर्जिया र दक्षिण स्यान्डवीच टापुहरू',
 			'GT' => 'ग्वाटेमाला',
 			'GU' => 'गुवाम',
 			'GW' => 'गिनी-बिसाउ',
 			'GY' => 'गुयाना',
 			'HK' => 'हङकङ चिनियाँ विशेष प्रशासनिक क्षेत्र',
 			'HK@alt=short' => 'हङकङ',
 			'HM' => 'हर्ड टापु र म्याकडोनाल्ड टापुहरु',
 			'HN' => 'हन्डुरास',
 			'HR' => 'क्रोएशिया',
 			'HT' => 'हैटी',
 			'HU' => 'हङ्गेरी',
 			'IC' => 'क्यानारी टापुहरू',
 			'ID' => 'इन्डोनेशिया',
 			'IE' => 'आयरल्याण्ड',
 			'IL' => 'इजरायल',
 			'IM' => 'आइल अफ म्यान',
 			'IN' => 'भारत',
 			'IO' => 'बेलायती हिन्द महासागर क्षेत्र',
 			'IQ' => 'इराक',
 			'IR' => 'इरान',
 			'IS' => 'आइस्ल्याण्ड',
 			'IT' => 'इटली',
 			'JE' => 'जर्सी',
 			'JM' => 'जमैका',
 			'JO' => 'जोर्डन',
 			'JP' => 'जापान',
 			'KE' => 'केन्या',
 			'KG' => 'किर्गिस्तान',
 			'KH' => 'कम्बोडिया',
 			'KI' => 'किरिबाटी',
 			'KM' => 'कोमोरोस',
 			'KN' => 'सेन्ट किट्स र नेभिस',
 			'KP' => 'उत्तर कोरिया',
 			'KR' => 'दक्षिण कोरिया',
 			'KW' => 'कुवेत',
 			'KY' => 'केयमान टापु',
 			'KZ' => 'काजाकस्तान',
 			'LA' => 'लाओस',
 			'LB' => 'लेबनन',
 			'LC' => 'सेन्ट लुसिया',
 			'LI' => 'लिकटेन्सटाइन',
 			'LK' => 'श्रीलङ्का',
 			'LR' => 'लाइबेरिया',
 			'LS' => 'लेसोथो',
 			'LT' => 'लिथुएनिया',
 			'LU' => 'लक्जेमबर्ग',
 			'LV' => 'लाट्भिया',
 			'LY' => 'लिबिया',
 			'MA' => 'मोरोक्को',
 			'MC' => 'मोनाको',
 			'MD' => 'माल्डोभा',
 			'ME' => 'मोन्टेनिग्रो',
 			'MF' => 'सेन्ट मार्टिन',
 			'MG' => 'माडागास्कर',
 			'MH' => 'मार्शल टापुहरु',
 			'MK' => 'उत्तर म्यासेडोनिया',
 			'ML' => 'माली',
 			'MM' => 'म्यान्मार (बर्मा)',
 			'MN' => 'मङ्गोलिया',
 			'MO' => 'मकाउ चिनियाँ विशेष प्रशासनिक क्षेत्र',
 			'MO@alt=short' => 'मकाउ',
 			'MP' => 'उत्तरी मारिआना टापु',
 			'MQ' => 'मार्टिनिक',
 			'MR' => 'माउरिटानिया',
 			'MS' => 'मोन्टसेर्राट',
 			'MT' => 'माल्टा',
 			'MU' => 'मौरिसियस',
 			'MV' => 'माल्दिभ्स',
 			'MW' => 'मालावी',
 			'MX' => 'मेक्सिको',
 			'MY' => 'मलेसिया',
 			'MZ' => 'मोजाम्बिक',
 			'NA' => 'नामिबिया',
 			'NC' => 'न्यु क्यालेडोनिया',
 			'NE' => 'नाइजर',
 			'NF' => 'नोरफोल्क टापु',
 			'NG' => 'नाइजेरिया',
 			'NI' => 'निकारागुवा',
 			'NL' => 'नेदरल्याण्ड',
 			'NO' => 'नर्वे',
 			'NP' => 'नेपाल',
 			'NR' => 'नाउरू',
 			'NU' => 'नियुइ',
 			'NZ' => 'न्युजिल्याण्ड',
 			'OM' => 'ओमन',
 			'PA' => 'प्यानामा',
 			'PE' => 'पेरू',
 			'PF' => 'फ्रान्सेली पोलिनेसिया',
 			'PG' => 'पपुआ न्यू गाइनिया',
 			'PH' => 'फिलिपिन्स',
 			'PK' => 'पाकिस्तान',
 			'PL' => 'पोल्याण्ड',
 			'PM' => 'सेन्ट पिर्रे र मिक्केलोन',
 			'PN' => 'पिटकाइर्न टापुहरु',
 			'PR' => 'पुएर्टो रिको',
 			'PS' => 'प्यालेस्टिनी भू-भागहरू',
 			'PS@alt=short' => 'प्‍यालेस्टाइन',
 			'PT' => 'पोर्चुगल',
 			'PW' => 'पलाउ',
 			'PY' => 'प्याराग्वे',
 			'QA' => 'कतार',
 			'QO' => 'बाह्य ओसनिया',
 			'RE' => 'रियुनियन',
 			'RO' => 'रोमेनिया',
 			'RS' => 'सर्बिया',
 			'RU' => 'रूस',
 			'RW' => 'रवाण्डा',
 			'SA' => 'साउदी अरब',
 			'SB' => 'सोलोमन टापुहरू',
 			'SC' => 'सेचेलेस',
 			'SD' => 'सुडान',
 			'SE' => 'स्विडेन',
 			'SG' => 'सिङ्गापुर',
 			'SH' => 'सेन्ट हेलेना',
 			'SI' => 'स्लोभेनिया',
 			'SJ' => 'सभाल्बार्ड र जान मायेन',
 			'SK' => 'स्लोभाकिया',
 			'SL' => 'सिएर्रा लिओन',
 			'SM' => 'सान् मारिनो',
 			'SN' => 'सेनेगल',
 			'SO' => 'सोमालिया',
 			'SR' => 'सुरिनेम',
 			'SS' => 'दक्षिण सुडान',
 			'ST' => 'साओ टोमे र प्रिन्सिप',
 			'SV' => 'एल् साल्भाडोर',
 			'SX' => 'सिन्ट मार्टेन',
 			'SY' => 'सिरिया',
 			'SZ' => 'स्वाजिल्याण्ड',
 			'TA' => 'ट्रिस्टान डा कुन्हा',
 			'TC' => 'तुर्क र काइकोस टापु',
 			'TD' => 'चाड',
 			'TF' => 'फ्रेन्च दक्षिणी राज्यहरू',
 			'TG' => 'टोगो',
 			'TH' => 'थाइल्याण्ड',
 			'TJ' => 'ताजिकिस्तान',
 			'TK' => 'तोकेलाउ',
 			'TL' => 'टिमोर-लेस्टे',
 			'TL@alt=variant' => 'पृर्वी टीमोर',
 			'TM' => 'तुर्कमेनिस्तान',
 			'TN' => 'ट्युनिसिया',
 			'TO' => 'टोंगा',
 			'TR' => 'टर्की',
 			'TT' => 'त्रिनिडाड एण्ड टोबागो',
 			'TV' => 'तुभालु',
 			'TW' => 'ताइवान',
 			'TZ' => 'तान्जानिया',
 			'UA' => 'युक्रेन',
 			'UG' => 'युगाण्डा',
 			'UM' => 'संयुक्त राज्यका बाह्य टापुहरु',
 			'UN' => 'संयुक्त राष्ट्र संघ',
 			'UN@alt=short' => 'यूएन',
 			'US' => 'संयुक्त राज्य',
 			'US@alt=short' => 'अमेरिका',
 			'UY' => 'उरूग्वे',
 			'UZ' => 'उज्बेकिस्तान',
 			'VA' => 'भेटिकन सिटी',
 			'VC' => 'सेन्ट भिन्सेन्ट र ग्रेनाडिन्स',
 			'VE' => 'भेनेजुएला',
 			'VG' => 'बेलायती भर्जिन टापुहरू',
 			'VI' => 'संयुक्त राज्य भर्जिन टापुहरु',
 			'VN' => 'भिएतनाम',
 			'VU' => 'भानुआतु',
 			'WF' => 'वालिस र फुटुना',
 			'WS' => 'सामोआ',
 			'XA' => 'सिउडो-एक्सेन्ट्स',
 			'XB' => 'सिउडो-बिडी',
 			'XK' => 'कोसोभो',
 			'YE' => 'येमेन',
 			'YT' => 'मायोट्ट',
 			'ZA' => 'दक्षिण अफ्रिका',
 			'ZM' => 'जाम्बिया',
 			'ZW' => 'जिम्बाबवे',
 			'ZZ' => 'अज्ञात क्षेत्र',

		}
	},
);

has 'display_name_variant' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'AREVELA' => 'पूर्वी आर्मेनियाली',
 			'POSIX' => 'कम्प्युटर',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => 'पात्रो',
 			'cf' => 'मुद्राको ढाँचा',
 			'collation' => 'क्रमबद्ध सुची',
 			'currency' => 'मुद्रा',
 			'hc' => 'समय चक्र (12 तथा 24)',
 			'lb' => 'पङ्क्ति विच्छेदको शैली',
 			'ms' => 'मापन प्रणाली',
 			'numbers' => 'अङ्कहरू',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[Str]],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{बुद्धिष्ट पात्रो},
 				'chinese' => q{चिनियाँ पात्रो},
 				'dangi' => q{डाङ्गी पात्रो},
 				'ethiopic' => q{इथिओपिक पात्रो},
 				'gregorian' => q{ग्रेगोरियन पात्रो},
 				'hebrew' => q{हिब्रु पात्रो},
 				'indian' => q{भारतीय राष्ट्रिय पात्रो},
 				'islamic' => q{इस्लामी पात्रो},
 				'islamic-civil' => q{इस्लामी नागरिक पात्रो},
 				'iso8601' => q{ISO-8601 पात्रो},
 				'japanese' => q{जापानी पात्रो},
 				'persian' => q{फारसी पात्रो},
 				'roc' => q{चिनियाँ गणतन्त्रको पात्रो},
 			},
 			'cf' => {
 				'account' => q{cf-account},
 				'standard' => q{cf-standard},
 			},
 			'collation' => {
 				'big5han' => q{परम्परागत चिनिँया क्रमबद्धता पद्दति - बिग फाइभ},
 				'ducet' => q{पूर्वनिर्धारित युनिकोडको क्रमबद्धता सूची},
 				'gb2312han' => q{सरलिकृत चिनियाँ क्रमबद्धता पद्दति-गीबीटुथ्रीवानटु},
 				'phonebook' => q{टेलिफोन पुस्तिका क्रमबद्धतापद्दति},
 				'pinyin' => q{पिनयिन क्रमबद्धता पद्दति},
 				'search' => q{सामान्य उद्देशीय खोजी},
 				'standard' => q{मानक क्रमबद्धता},
 				'stroke' => q{स्ट्रोक क्रमबद्धता पद्दति},
 				'traditional' => q{परम्परागत क्रमबद्धता पद्दति},
 			},
 			'hc' => {
 				'h11' => q{hc-h11},
 				'h12' => q{hc-h12},
 				'h23' => q{hc-h23},
 				'h24' => q{hc-h24},
 			},
 			'lb' => {
 				'loose' => q{पङ्क्ति विच्छेदको खुला शैली},
 				'normal' => q{पङ्क्ति विच्छेदको सामान्य शैली},
 				'strict' => q{पङ्क्ति विच्छेदको कडा शैली},
 			},
 			'ms' => {
 				'metric' => q{मेट्रिक प्रणाली},
 				'uksystem' => q{इम्पेरियल मापन प्रणाली},
 				'ussystem' => q{संयुक्त राज्य मापन प्रणाली},
 			},
 			'numbers' => {
 				'arab' => q{अरबी भारतीय अङ्कहरू},
 				'arabext' => q{विस्तृत अरबी भारतीय अङ्कहरू},
 				'armn' => q{आर्मेनियाली अङ्कहरू},
 				'armnlow' => q{आर्मेनियाली साना अङ्कहरू},
 				'beng' => q{बङ्गाली अङ्कहरू},
 				'deva' => q{देवानागरी},
 				'ethi' => q{इथियोपाली अङ्कहरू},
 				'fullwide' => q{पूरा चौंडाइका अङ्कहरू},
 				'geor' => q{जर्जियाली अङ्कहरू},
 				'grek' => q{ग्रीक अङ्कहरू},
 				'greklow' => q{ग्रीक साना अङ्कहरू},
 				'gujr' => q{गुजराती अङ्कहरू},
 				'guru' => q{गुरूमुखी अङ्कहरू},
 				'hanidec' => q{चिनियाँ दशमलव अङ्कहरू},
 				'hans' => q{सरलिकृत चिनियाँ अङ्कहरू},
 				'hansfin' => q{सरलिकृत चिनियाँ वित्तीय अङ्कहरू},
 				'hant' => q{परम्परागत चिनियाँ अङ्कहरू},
 				'hantfin' => q{परम्परागत चिनियाँ वित्तीय अङ्कहरू},
 				'hebr' => q{हिब्रु अङ्कहरू},
 				'jpan' => q{जापानी अङ्कहरू},
 				'jpanfin' => q{जापानी वित्तीय अङ्कहरू},
 				'khmr' => q{खमेर अङ्कहरू},
 				'knda' => q{कन्नाडा अङ्कहरू},
 				'laoo' => q{लाओ अङ्कहरू},
 				'latn' => q{पश्चिमी अङ्कहरू},
 				'mlym' => q{मलायलम अङ्कहरू},
 				'mymr' => q{म्यान्मारका अङ्कहरू},
 				'orya' => q{ओरिया अङ्कहरू},
 				'roman' => q{रोमन अङ्कहरू},
 				'romanlow' => q{रोमन साना केसका अङ्कहरू},
 				'taml' => q{परम्परागत तामिल अङ्कहरू},
 				'tamldec' => q{तामिल अङ्कहरू},
 				'telu' => q{तेलेगु अङ्कहरू},
 				'thai' => q{थाई अङ्कहरू},
 				'tibt' => q{तिब्बती अङ्कहरू},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'metric' => q{मेट्रिक},
 			'UK' => q{संयुक्त अधिराज्य},
 			'US' => q{संयु्क्त राज्य},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'language' => 'भाषा: {0}',
 			'script' => 'लिपि: {0}',
 			'region' => 'क्षेत्र: {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{[‌‍]},
			index => ['अ', 'आ', 'इ', 'ई', 'उ', 'ऊ', 'ऋ', 'ए', 'ऐ', 'ओ', 'औ', 'क', 'ख', 'ग', 'घ', 'ङ', 'च', 'छ', 'ज', 'झ', 'ञ', 'ट', 'ठ', 'ड', 'ढ', 'ण', 'त', 'थ', 'द', 'ध', 'न', 'प', 'फ', 'ब', 'भ', 'म', 'य', 'र', 'ल', 'व', 'श', 'ष', 'स', 'ह'],
			main => qr{[़ ँ ं ः ॐ अ आ इ ई उ ऊ ऋ ऌ ऍ ए ऐ ऑ ओ औ क ख ग घ ङ च छ ज झ ञ ट ठ ड ढ ण त थ द ध न प फ ब भ म य र ल ळ व श ष स ह ऽ ा ि ी ु ू ृ ॄ ॅ े ै ॉ ो ौ ्]},
			numbers => qr{[\- ‑ , . % ‰ + 0० 1१ 2२ 3३ 4४ 5५ 6६ 7७ 8८ 9९]},
			punctuation => qr{[\- ‑ — , ; ! ? । ' ‘ ’ " “ ” ( ) \[ \] \{ \}]},
		};
	},
EOT
: sub {
		return { index => ['अ', 'आ', 'इ', 'ई', 'उ', 'ऊ', 'ऋ', 'ए', 'ऐ', 'ओ', 'औ', 'क', 'ख', 'ग', 'घ', 'ङ', 'च', 'छ', 'ज', 'झ', 'ञ', 'ट', 'ठ', 'ड', 'ढ', 'ण', 'त', 'थ', 'द', 'ध', 'न', 'प', 'फ', 'ब', 'भ', 'म', 'य', 'र', 'ल', 'व', 'श', 'ष', 'स', 'ह'], };
},
);


has 'ellipsis' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub {
		return {
			'final' => '{0}…',
			'initial' => '…{0}',
			'medial' => '{0}…{1}',
			'word-final' => '{0} …',
			'word-initial' => '… {0}',
			'word-medial' => '{0} … {1}',
		};
	},
);

has 'more_information' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{?},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{“},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{”},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{‘},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{’},
);

has 'duration_units' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { {
				hm => 'h:mm',
				hms => 'h:mm:ss',
				ms => 'm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[HashRef[Str]]],
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					# Long Unit Identifier
					'' => {
						'name' => q(मुख्य दिशा),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(मुख्य दिशा),
					},
					# Long Unit Identifier
					'1024p1' => {
						'1' => q(किबी{0}),
					},
					# Core Unit Identifier
					'1024p1' => {
						'1' => q(किबी{0}),
					},
					# Long Unit Identifier
					'1024p2' => {
						'1' => q(मेबी{0}),
					},
					# Core Unit Identifier
					'1024p2' => {
						'1' => q(मेबी{0}),
					},
					# Long Unit Identifier
					'1024p3' => {
						'1' => q(जिबि{0}),
					},
					# Core Unit Identifier
					'1024p3' => {
						'1' => q(जिबि{0}),
					},
					# Long Unit Identifier
					'1024p4' => {
						'1' => q(टेबि{0}),
					},
					# Core Unit Identifier
					'1024p4' => {
						'1' => q(टेबि{0}),
					},
					# Long Unit Identifier
					'1024p5' => {
						'1' => q(पेबि{0}),
					},
					# Core Unit Identifier
					'1024p5' => {
						'1' => q(पेबि{0}),
					},
					# Long Unit Identifier
					'1024p6' => {
						'1' => q(एक्‍सबि{0}),
					},
					# Core Unit Identifier
					'1024p6' => {
						'1' => q(एक्‍सबि{0}),
					},
					# Long Unit Identifier
					'1024p7' => {
						'1' => q(जेबि{0}),
					},
					# Core Unit Identifier
					'1024p7' => {
						'1' => q(जेबि{0}),
					},
					# Long Unit Identifier
					'1024p8' => {
						'1' => q(योबे{0}),
					},
					# Core Unit Identifier
					'1024p8' => {
						'1' => q(योबे{0}),
					},
					# Long Unit Identifier
					'10p-1' => {
						'1' => q(डेसि{0}),
					},
					# Core Unit Identifier
					'1' => {
						'1' => q(डेसि{0}),
					},
					# Long Unit Identifier
					'10p-12' => {
						'1' => q(पिको{0}),
					},
					# Core Unit Identifier
					'12' => {
						'1' => q(पिको{0}),
					},
					# Long Unit Identifier
					'10p-15' => {
						'1' => q(फेमटो{0}),
					},
					# Core Unit Identifier
					'15' => {
						'1' => q(फेमटो{0}),
					},
					# Long Unit Identifier
					'10p-18' => {
						'1' => q(अटो{0}),
					},
					# Core Unit Identifier
					'18' => {
						'1' => q(अटो{0}),
					},
					# Long Unit Identifier
					'10p-2' => {
						'1' => q(सेन्टी{0}),
					},
					# Core Unit Identifier
					'2' => {
						'1' => q(सेन्टी{0}),
					},
					# Long Unit Identifier
					'10p-21' => {
						'1' => q(जेप्टो{0}),
					},
					# Core Unit Identifier
					'21' => {
						'1' => q(जेप्टो{0}),
					},
					# Long Unit Identifier
					'10p-24' => {
						'1' => q(योक्टो{0}),
					},
					# Core Unit Identifier
					'24' => {
						'1' => q(योक्टो{0}),
					},
					# Long Unit Identifier
					'10p-3' => {
						'1' => q(मिली{0}),
					},
					# Core Unit Identifier
					'3' => {
						'1' => q(मिली{0}),
					},
					# Long Unit Identifier
					'10p-6' => {
						'1' => q(माइक्रो{0}),
					},
					# Core Unit Identifier
					'6' => {
						'1' => q(माइक्रो{0}),
					},
					# Long Unit Identifier
					'10p-9' => {
						'1' => q(नानो{0}),
					},
					# Core Unit Identifier
					'9' => {
						'1' => q(नानो{0}),
					},
					# Long Unit Identifier
					'10p1' => {
						'1' => q(डेका{0}),
					},
					# Core Unit Identifier
					'10p1' => {
						'1' => q(डेका{0}),
					},
					# Long Unit Identifier
					'10p12' => {
						'1' => q(टेरा{0}),
					},
					# Core Unit Identifier
					'10p12' => {
						'1' => q(टेरा{0}),
					},
					# Long Unit Identifier
					'10p15' => {
						'1' => q(पेटा{0}),
					},
					# Core Unit Identifier
					'10p15' => {
						'1' => q(पेटा{0}),
					},
					# Long Unit Identifier
					'10p18' => {
						'1' => q(एक्सा{0}),
					},
					# Core Unit Identifier
					'10p18' => {
						'1' => q(एक्सा{0}),
					},
					# Long Unit Identifier
					'10p2' => {
						'1' => q(हेक्टो{0}),
					},
					# Core Unit Identifier
					'10p2' => {
						'1' => q(हेक्टो{0}),
					},
					# Long Unit Identifier
					'10p21' => {
						'1' => q(जेटा{0}),
					},
					# Core Unit Identifier
					'10p21' => {
						'1' => q(जेटा{0}),
					},
					# Long Unit Identifier
					'10p24' => {
						'1' => q(योटा{0}),
					},
					# Core Unit Identifier
					'10p24' => {
						'1' => q(योटा{0}),
					},
					# Long Unit Identifier
					'10p3' => {
						'1' => q(किलो{0}),
					},
					# Core Unit Identifier
					'10p3' => {
						'1' => q(किलो{0}),
					},
					# Long Unit Identifier
					'10p6' => {
						'1' => q(मेगा{0}),
					},
					# Core Unit Identifier
					'10p6' => {
						'1' => q(मेगा{0}),
					},
					# Long Unit Identifier
					'10p9' => {
						'1' => q(गिगा{0}),
					},
					# Core Unit Identifier
					'10p9' => {
						'1' => q(गिगा{0}),
					},
					# Long Unit Identifier
					'acceleration-g-force' => {
						'name' => q(गुरूत्वाकर्षण शक्ति),
						'one' => q({0} गुरूत्वाकर्षण शक्ति),
						'other' => q({0} गुरूत्वाकर्षण शक्ति),
					},
					# Core Unit Identifier
					'g-force' => {
						'name' => q(गुरूत्वाकर्षण शक्ति),
						'one' => q({0} गुरूत्वाकर्षण शक्ति),
						'other' => q({0} गुरूत्वाकर्षण शक्ति),
					},
					# Long Unit Identifier
					'acceleration-meter-per-square-second' => {
						'name' => q(मिटर प्रति वर्ग सेकेन्ड),
						'one' => q({0}मिटर प्रति सेकेण्ड वर्ग),
						'other' => q({0}मिटर प्रति सेकेण्ड वर्ग),
					},
					# Core Unit Identifier
					'meter-per-square-second' => {
						'name' => q(मिटर प्रति वर्ग सेकेन्ड),
						'one' => q({0}मिटर प्रति सेकेण्ड वर्ग),
						'other' => q({0}मिटर प्रति सेकेण्ड वर्ग),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'name' => q(आर्क मिनेट),
						'one' => q({0}आर्क मिनेट),
						'other' => q({0}आर्क मिनेट),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'name' => q(आर्क मिनेट),
						'one' => q({0}आर्क मिनेट),
						'other' => q({0}आर्क मिनेट),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'name' => q(आर्क सेकेन्ड),
						'one' => q({0}आर्क सेकेन्ड),
						'other' => q({0}आर्क सेकेन्ड),
					},
					# Core Unit Identifier
					'arc-second' => {
						'name' => q(आर्क सेकेन्ड),
						'one' => q({0}आर्क सेकेन्ड),
						'other' => q({0}आर्क सेकेन्ड),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'name' => q(डिग्री),
						'one' => q({0} डिग्री),
						'other' => q({0} डिग्री),
					},
					# Core Unit Identifier
					'degree' => {
						'name' => q(डिग्री),
						'one' => q({0} डिग्री),
						'other' => q({0} डिग्री),
					},
					# Long Unit Identifier
					'angle-radian' => {
						'name' => q(रेडियन),
						'one' => q({0}रेडियन),
						'other' => q({0}रेडियन),
					},
					# Core Unit Identifier
					'radian' => {
						'name' => q(रेडियन),
						'one' => q({0}रेडियन),
						'other' => q({0}रेडियन),
					},
					# Long Unit Identifier
					'angle-revolution' => {
						'name' => q(परिक्रमा),
						'one' => q({0}परिक्रमा),
						'other' => q({0}परिक्रमा),
					},
					# Core Unit Identifier
					'revolution' => {
						'name' => q(परिक्रमा),
						'one' => q({0}परिक्रमा),
						'other' => q({0}परिक्रमा),
					},
					# Long Unit Identifier
					'area-acre' => {
						'name' => q(वर्ग गज),
						'one' => q({0}वर्ग गज),
						'other' => q({0}वर्ग गज),
					},
					# Core Unit Identifier
					'acre' => {
						'name' => q(वर्ग गज),
						'one' => q({0}वर्ग गज),
						'other' => q({0}वर्ग गज),
					},
					# Long Unit Identifier
					'area-dunam' => {
						'name' => q(डुनाम),
						'one' => q({0} डुनाम),
						'other' => q({0} डुनाम),
					},
					# Core Unit Identifier
					'dunam' => {
						'name' => q(डुनाम),
						'one' => q({0} डुनाम),
						'other' => q({0} डुनाम),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'name' => q(हेक्टर),
						'one' => q({0} हेक्टर),
						'other' => q({0} हेक्टर),
					},
					# Core Unit Identifier
					'hectare' => {
						'name' => q(हेक्टर),
						'one' => q({0} हेक्टर),
						'other' => q({0} हेक्टर),
					},
					# Long Unit Identifier
					'area-square-centimeter' => {
						'name' => q(वर्ग सेन्टिमिटर),
						'one' => q({0}वर्ग सेन्टिमिटर),
						'other' => q({0}वर्ग सेन्टिमिटर),
						'per' => q({0}प्रति वर्ग सेन्टिमिटर),
					},
					# Core Unit Identifier
					'square-centimeter' => {
						'name' => q(वर्ग सेन्टिमिटर),
						'one' => q({0}वर्ग सेन्टिमिटर),
						'other' => q({0}वर्ग सेन्टिमिटर),
						'per' => q({0}प्रति वर्ग सेन्टिमिटर),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'name' => q(वर्ग फिट),
						'one' => q({0}वर्ग फुट),
						'other' => q({0}वर्ग फुट),
					},
					# Core Unit Identifier
					'square-foot' => {
						'name' => q(वर्ग फिट),
						'one' => q({0}वर्ग फुट),
						'other' => q({0}वर्ग फुट),
					},
					# Long Unit Identifier
					'area-square-inch' => {
						'name' => q(वर्ग इन्च),
						'one' => q({0}वर्ग इन्च),
						'other' => q({0}वर्ग इन्च),
						'per' => q({0}प्रति वर्ग इन्च),
					},
					# Core Unit Identifier
					'square-inch' => {
						'name' => q(वर्ग इन्च),
						'one' => q({0}वर्ग इन्च),
						'other' => q({0}वर्ग इन्च),
						'per' => q({0}प्रति वर्ग इन्च),
					},
					# Long Unit Identifier
					'area-square-kilometer' => {
						'name' => q(वर्ग किलोमिटर),
						'one' => q({0}वर्ग किलोमिटर),
						'other' => q({0}वर्ग किलोमिटर),
						'per' => q({0}प्रति वर्ग किलोमिटर),
					},
					# Core Unit Identifier
					'square-kilometer' => {
						'name' => q(वर्ग किलोमिटर),
						'one' => q({0}वर्ग किलोमिटर),
						'other' => q({0}वर्ग किलोमिटर),
						'per' => q({0}प्रति वर्ग किलोमिटर),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'name' => q(वर्ग मिटर),
						'one' => q({0}वर्ग मिटर),
						'other' => q({0}वर्ग मिटर),
						'per' => q({0}प्रति वर्ग मिटर),
					},
					# Core Unit Identifier
					'square-meter' => {
						'name' => q(वर्ग मिटर),
						'one' => q({0}वर्ग मिटर),
						'other' => q({0}वर्ग मिटर),
						'per' => q({0}प्रति वर्ग मिटर),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'name' => q(वर्ग माइल),
						'one' => q({0}वर्ग माइल),
						'other' => q({0}वर्ग माइल),
						'per' => q({0}प्रति वर्ग माइल),
					},
					# Core Unit Identifier
					'square-mile' => {
						'name' => q(वर्ग माइल),
						'one' => q({0}वर्ग माइल),
						'other' => q({0}वर्ग माइल),
						'per' => q({0}प्रति वर्ग माइल),
					},
					# Long Unit Identifier
					'area-square-yard' => {
						'name' => q(वर्ग यार्ड),
						'one' => q({0}वर्ग यार्ड),
						'other' => q({0}वर्ग यार्ड),
					},
					# Core Unit Identifier
					'square-yard' => {
						'name' => q(वर्ग यार्ड),
						'one' => q({0}वर्ग यार्ड),
						'other' => q({0}वर्ग यार्ड),
					},
					# Long Unit Identifier
					'concentr-item' => {
						'name' => q(वस्तुहरू),
						'one' => q({0} वस्तु),
						'other' => q({0} वटा वस्तुहरू),
					},
					# Core Unit Identifier
					'item' => {
						'name' => q(वस्तुहरू),
						'one' => q({0} वस्तु),
						'other' => q({0} वटा वस्तुहरू),
					},
					# Long Unit Identifier
					'concentr-karat' => {
						'name' => q(कराट),
						'one' => q({0}कराट),
						'other' => q({0}कराट),
					},
					# Core Unit Identifier
					'karat' => {
						'name' => q(कराट),
						'one' => q({0}कराट),
						'other' => q({0}कराट),
					},
					# Long Unit Identifier
					'concentr-milligram-ofglucose-per-deciliter' => {
						'name' => q(mg/dL),
						'one' => q({0} mg/dL),
						'other' => q({0} mg/dL),
					},
					# Core Unit Identifier
					'milligram-ofglucose-per-deciliter' => {
						'name' => q(mg/dL),
						'one' => q({0} mg/dL),
						'other' => q({0} mg/dL),
					},
					# Long Unit Identifier
					'concentr-millimole-per-liter' => {
						'name' => q(mmol/L),
						'one' => q({0} mmol/L),
						'other' => q({0} mmol/L),
					},
					# Core Unit Identifier
					'millimole-per-liter' => {
						'name' => q(mmol/L),
						'one' => q({0} mmol/L),
						'other' => q({0} mmol/L),
					},
					# Long Unit Identifier
					'concentr-mole' => {
						'name' => q(मोल),
						'one' => q({0} मोल),
						'other' => q({0} मोल),
					},
					# Core Unit Identifier
					'mole' => {
						'name' => q(मोल),
						'one' => q({0} मोल),
						'other' => q({0} मोल),
					},
					# Long Unit Identifier
					'concentr-percent' => {
						'name' => q(प्रतिशत),
						'one' => q({0} प्रतिशत),
						'other' => q({0} प्रतिशत),
					},
					# Core Unit Identifier
					'percent' => {
						'name' => q(प्रतिशत),
						'one' => q({0} प्रतिशत),
						'other' => q({0} प्रतिशत),
					},
					# Long Unit Identifier
					'concentr-permille' => {
						'name' => q(प्रति मिल),
						'one' => q({0} प्रति मिल),
						'other' => q({0} प्रति मिल),
					},
					# Core Unit Identifier
					'permille' => {
						'name' => q(प्रति मिल),
						'one' => q({0} प्रति मिल),
						'other' => q({0} प्रति मिल),
					},
					# Long Unit Identifier
					'concentr-permillion' => {
						'name' => q(ppm),
						'one' => q({0} ppm),
						'other' => q({0} ppm),
					},
					# Core Unit Identifier
					'permillion' => {
						'name' => q(ppm),
						'one' => q({0} ppm),
						'other' => q({0} ppm),
					},
					# Long Unit Identifier
					'concentr-permyriad' => {
						'name' => q(पर्माइराइड),
						'one' => q({0} पर्माइराइड),
						'other' => q({0} पर्माइराइड),
					},
					# Core Unit Identifier
					'permyriad' => {
						'name' => q(पर्माइराइड),
						'one' => q({0} पर्माइराइड),
						'other' => q({0} पर्माइराइड),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'name' => q(लिटर प्रति १०० किलोमिटर),
						'one' => q({0}लिटर प्रति १०० किलोमिटर),
						'other' => q({0}लिटर प्रति १०० किलोमिटर),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'name' => q(लिटर प्रति १०० किलोमिटर),
						'one' => q({0}लिटर प्रति १०० किलोमिटर),
						'other' => q({0}लिटर प्रति १०० किलोमिटर),
					},
					# Long Unit Identifier
					'consumption-liter-per-kilometer' => {
						'name' => q(लिटर प्रति किलोमिटर),
						'one' => q({0}लिटर प्रति किलोमिटर),
						'other' => q({0}लिटर प्रति किलोमिटर),
					},
					# Core Unit Identifier
					'liter-per-kilometer' => {
						'name' => q(लिटर प्रति किलोमिटर),
						'one' => q({0}लिटर प्रति किलोमिटर),
						'other' => q({0}लिटर प्रति किलोमिटर),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon' => {
						'name' => q(माइल प्रति ग्यालोन),
						'one' => q({0}माइल प्रति ग्यालोन),
						'other' => q({0}माइल प्रति ग्यालोन),
					},
					# Core Unit Identifier
					'mile-per-gallon' => {
						'name' => q(माइल प्रति ग्यालोन),
						'one' => q({0}माइल प्रति ग्यालोन),
						'other' => q({0}माइल प्रति ग्यालोन),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon-imperial' => {
						'name' => q(mpg Imp.),
						'one' => q({0} mpg Imp.),
						'other' => q({0} mpg Imp.),
					},
					# Core Unit Identifier
					'mile-per-gallon-imperial' => {
						'name' => q(mpg Imp.),
						'one' => q({0} mpg Imp.),
						'other' => q({0} mpg Imp.),
					},
					# Long Unit Identifier
					'coordinate' => {
						'east' => q({0}पूर्व),
						'north' => q({0}उत्तर),
						'south' => q({0}दक्षिण),
						'west' => q({0}पश्चिम),
					},
					# Core Unit Identifier
					'coordinate' => {
						'east' => q({0}पूर्व),
						'north' => q({0}उत्तर),
						'south' => q({0}दक्षिण),
						'west' => q({0}पश्चिम),
					},
					# Long Unit Identifier
					'digital-bit' => {
						'name' => q(बिट),
						'one' => q({0}बिट),
						'other' => q({0}बिट),
					},
					# Core Unit Identifier
					'bit' => {
						'name' => q(बिट),
						'one' => q({0}बिट),
						'other' => q({0}बिट),
					},
					# Long Unit Identifier
					'digital-byte' => {
						'name' => q(बाइट),
						'one' => q({0}बाइट),
						'other' => q({0}बाइट),
					},
					# Core Unit Identifier
					'byte' => {
						'name' => q(बाइट),
						'one' => q({0}बाइट),
						'other' => q({0}बाइट),
					},
					# Long Unit Identifier
					'digital-gigabit' => {
						'name' => q(गिगाबिट),
						'one' => q({0}गिगाबिट),
						'other' => q({0}गिगाबिट),
					},
					# Core Unit Identifier
					'gigabit' => {
						'name' => q(गिगाबिट),
						'one' => q({0}गिगाबिट),
						'other' => q({0}गिगाबिट),
					},
					# Long Unit Identifier
					'digital-gigabyte' => {
						'name' => q(गिगाबाइट),
						'one' => q({0}गिगाबाइट),
						'other' => q({0}गिगाबाइट),
					},
					# Core Unit Identifier
					'gigabyte' => {
						'name' => q(गिगाबाइट),
						'one' => q({0}गिगाबाइट),
						'other' => q({0}गिगाबाइट),
					},
					# Long Unit Identifier
					'digital-kilobit' => {
						'name' => q(किलोबिट),
						'one' => q({0}किलोबिट),
						'other' => q({0}किलोबिट),
					},
					# Core Unit Identifier
					'kilobit' => {
						'name' => q(किलोबिट),
						'one' => q({0}किलोबिट),
						'other' => q({0}किलोबिट),
					},
					# Long Unit Identifier
					'digital-kilobyte' => {
						'name' => q(किलोबाइट),
						'one' => q({0}किलोबाइट),
						'other' => q({0}किलोबाइट),
					},
					# Core Unit Identifier
					'kilobyte' => {
						'name' => q(किलोबाइट),
						'one' => q({0}किलोबाइट),
						'other' => q({0}किलोबाइट),
					},
					# Long Unit Identifier
					'digital-megabit' => {
						'name' => q(मेगाबिट),
						'one' => q({0}मेगाबिट),
						'other' => q({0}मेगाबिट),
					},
					# Core Unit Identifier
					'megabit' => {
						'name' => q(मेगाबिट),
						'one' => q({0}मेगाबिट),
						'other' => q({0}मेगाबिट),
					},
					# Long Unit Identifier
					'digital-megabyte' => {
						'name' => q(मेगाबाइट),
						'one' => q({0}मेगाबाइट),
						'other' => q({0}मेगाबाइट),
					},
					# Core Unit Identifier
					'megabyte' => {
						'name' => q(मेगाबाइट),
						'one' => q({0}मेगाबाइट),
						'other' => q({0}मेगाबाइट),
					},
					# Long Unit Identifier
					'digital-petabyte' => {
						'name' => q(पिटाबाइटहरू),
						'one' => q({0} पिटाबाइट),
						'other' => q({0} पिटाबाइटहरू),
					},
					# Core Unit Identifier
					'petabyte' => {
						'name' => q(पिटाबाइटहरू),
						'one' => q({0} पिटाबाइट),
						'other' => q({0} पिटाबाइटहरू),
					},
					# Long Unit Identifier
					'digital-terabit' => {
						'name' => q(टेराबिट),
						'one' => q({0}टेराबिट),
						'other' => q({0}टेराबिट),
					},
					# Core Unit Identifier
					'terabit' => {
						'name' => q(टेराबिट),
						'one' => q({0}टेराबिट),
						'other' => q({0}टेराबिट),
					},
					# Long Unit Identifier
					'digital-terabyte' => {
						'name' => q(टेराबाइट),
						'one' => q({0}टेराबाइट),
						'other' => q({0}टेराबाइट),
					},
					# Core Unit Identifier
					'terabyte' => {
						'name' => q(टेराबाइट),
						'one' => q({0}टेराबाइट),
						'other' => q({0}टेराबाइट),
					},
					# Long Unit Identifier
					'duration-century' => {
						'name' => q(शताब्दी),
						'one' => q({0} शताब्दी),
						'other' => q({0} शताब्दी),
					},
					# Core Unit Identifier
					'century' => {
						'name' => q(शताब्दी),
						'one' => q({0} शताब्दी),
						'other' => q({0} शताब्दी),
					},
					# Long Unit Identifier
					'duration-day' => {
						'name' => q(दिन),
						'one' => q({0} दिन),
						'other' => q({0} दिन),
						'per' => q({0} प्रति दिन),
					},
					# Core Unit Identifier
					'day' => {
						'name' => q(दिन),
						'one' => q({0} दिन),
						'other' => q({0} दिन),
						'per' => q({0} प्रति दिन),
					},
					# Long Unit Identifier
					'duration-decade' => {
						'name' => q(दशाब्दी),
						'one' => q({0} दशाब्दी),
						'other' => q({0} दशाब्दी),
					},
					# Core Unit Identifier
					'decade' => {
						'name' => q(दशाब्दी),
						'one' => q({0} दशाब्दी),
						'other' => q({0} दशाब्दी),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'name' => q(घण्टा),
						'one' => q({0} घण्टा),
						'other' => q({0} घण्टा),
						'per' => q({0}प्रति घण्टा),
					},
					# Core Unit Identifier
					'hour' => {
						'name' => q(घण्टा),
						'one' => q({0} घण्टा),
						'other' => q({0} घण्टा),
						'per' => q({0}प्रति घण्टा),
					},
					# Long Unit Identifier
					'duration-microsecond' => {
						'name' => q(माइक्रोसेकेन्ड),
						'one' => q({0} माइक्रोसेकेन्ड),
						'other' => q({0} माइक्रोसेकेन्ड),
					},
					# Core Unit Identifier
					'microsecond' => {
						'name' => q(माइक्रोसेकेन्ड),
						'one' => q({0} माइक्रोसेकेन्ड),
						'other' => q({0} माइक्रोसेकेन्ड),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'name' => q(मिली सेकेन्ड),
						'one' => q({0} मिली सेकेन्ड),
						'other' => q({0} मिली सेकेन्ड),
					},
					# Core Unit Identifier
					'millisecond' => {
						'name' => q(मिली सेकेन्ड),
						'one' => q({0} मिली सेकेन्ड),
						'other' => q({0} मिली सेकेन्ड),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'name' => q(मिनेट),
						'one' => q({0} मिनेट),
						'other' => q({0} मिनेट),
						'per' => q({0} प्रति मिनेट),
					},
					# Core Unit Identifier
					'minute' => {
						'name' => q(मिनेट),
						'one' => q({0} मिनेट),
						'other' => q({0} मिनेट),
						'per' => q({0} प्रति मिनेट),
					},
					# Long Unit Identifier
					'duration-month' => {
						'name' => q(महिना),
						'one' => q({0} महिना),
						'other' => q({0} महिना),
						'per' => q({0} प्रति महिना),
					},
					# Core Unit Identifier
					'month' => {
						'name' => q(महिना),
						'one' => q({0} महिना),
						'other' => q({0} महिना),
						'per' => q({0} प्रति महिना),
					},
					# Long Unit Identifier
					'duration-nanosecond' => {
						'name' => q(न्यानोसेकेन्ड),
						'one' => q({0} न्यानोसेकेन्ड),
						'other' => q({0} न्यानोसेकेन्ड),
					},
					# Core Unit Identifier
					'nanosecond' => {
						'name' => q(न्यानोसेकेन्ड),
						'one' => q({0} न्यानोसेकेन्ड),
						'other' => q({0} न्यानोसेकेन्ड),
					},
					# Long Unit Identifier
					'duration-second' => {
						'name' => q(सेकेन्ड),
						'one' => q({0} सेकेन्ड),
						'other' => q({0} सेकेन्ड),
						'per' => q({0} प्रति सेकेन्ड),
					},
					# Core Unit Identifier
					'second' => {
						'name' => q(सेकेन्ड),
						'one' => q({0} सेकेन्ड),
						'other' => q({0} सेकेन्ड),
						'per' => q({0} प्रति सेकेन्ड),
					},
					# Long Unit Identifier
					'duration-week' => {
						'name' => q(हप्ता),
						'one' => q({0} हप्ता),
						'other' => q({0} हप्ता),
						'per' => q({0} प्रति हप्ता),
					},
					# Core Unit Identifier
					'week' => {
						'name' => q(हप्ता),
						'one' => q({0} हप्ता),
						'other' => q({0} हप्ता),
						'per' => q({0} प्रति हप्ता),
					},
					# Long Unit Identifier
					'duration-year' => {
						'name' => q(वर्ष),
						'one' => q({0} वर्ष),
						'other' => q({0} वर्ष),
						'per' => q({0} प्रति वर्ष),
					},
					# Core Unit Identifier
					'year' => {
						'name' => q(वर्ष),
						'one' => q({0} वर्ष),
						'other' => q({0} वर्ष),
						'per' => q({0} प्रति वर्ष),
					},
					# Long Unit Identifier
					'electric-ampere' => {
						'name' => q(एम्पियर),
						'one' => q({0} एम्पियर),
						'other' => q({0}एम्पियर),
					},
					# Core Unit Identifier
					'ampere' => {
						'name' => q(एम्पियर),
						'one' => q({0} एम्पियर),
						'other' => q({0}एम्पियर),
					},
					# Long Unit Identifier
					'electric-milliampere' => {
						'name' => q(मिलिएम्पियर),
						'one' => q({0} मिलिएम्पियर),
						'other' => q({0} मिलिएम्पियर),
					},
					# Core Unit Identifier
					'milliampere' => {
						'name' => q(मिलिएम्पियर),
						'one' => q({0} मिलिएम्पियर),
						'other' => q({0} मिलिएम्पियर),
					},
					# Long Unit Identifier
					'electric-ohm' => {
						'name' => q(ohm),
						'one' => q({0} Ω),
						'other' => q({0} Ω),
					},
					# Core Unit Identifier
					'ohm' => {
						'name' => q(ohm),
						'one' => q({0} Ω),
						'other' => q({0} Ω),
					},
					# Long Unit Identifier
					'electric-volt' => {
						'name' => q(भोल्ट),
						'one' => q({0}भोल्ट),
						'other' => q({0}भोल्ट),
					},
					# Core Unit Identifier
					'volt' => {
						'name' => q(भोल्ट),
						'one' => q({0}भोल्ट),
						'other' => q({0}भोल्ट),
					},
					# Long Unit Identifier
					'energy-british-thermal-unit' => {
						'name' => q(बेलायती तापीय एकाइ),
						'one' => q({0} बेलायती ताप एकाइ),
						'other' => q({0} बेलायती तापीय एकाइ),
					},
					# Core Unit Identifier
					'british-thermal-unit' => {
						'name' => q(बेलायती तापीय एकाइ),
						'one' => q({0} बेलायती ताप एकाइ),
						'other' => q({0} बेलायती तापीय एकाइ),
					},
					# Long Unit Identifier
					'energy-calorie' => {
						'name' => q(क्यालोरी),
						'one' => q({0}क्यालोरी),
						'other' => q({0}क्यालोरी),
					},
					# Core Unit Identifier
					'calorie' => {
						'name' => q(क्यालोरी),
						'one' => q({0}क्यालोरी),
						'other' => q({0}क्यालोरी),
					},
					# Long Unit Identifier
					'energy-electronvolt' => {
						'name' => q(इलेक्ट्रोनभोल्ट),
						'one' => q({0} इलेक्ट्रोनभोल्ट),
						'other' => q({0} इलेक्ट्रोनभोल्ट),
					},
					# Core Unit Identifier
					'electronvolt' => {
						'name' => q(इलेक्ट्रोनभोल्ट),
						'one' => q({0} इलेक्ट्रोनभोल्ट),
						'other' => q({0} इलेक्ट्रोनभोल्ट),
					},
					# Long Unit Identifier
					'energy-foodcalorie' => {
						'name' => q(क्यालोरी),
						'one' => q({0}क्यालोरी),
						'other' => q({0}क्यालोरी),
					},
					# Core Unit Identifier
					'foodcalorie' => {
						'name' => q(क्यालोरी),
						'one' => q({0}क्यालोरी),
						'other' => q({0}क्यालोरी),
					},
					# Long Unit Identifier
					'energy-joule' => {
						'name' => q(जुल),
						'one' => q({0} जुल),
						'other' => q({0}जुल),
					},
					# Core Unit Identifier
					'joule' => {
						'name' => q(जुल),
						'one' => q({0} जुल),
						'other' => q({0}जुल),
					},
					# Long Unit Identifier
					'energy-kilocalorie' => {
						'name' => q(किलोक्यालोरी),
						'one' => q({0}किलोक्यालोरी),
						'other' => q({0}किलोक्यालोरी),
					},
					# Core Unit Identifier
					'kilocalorie' => {
						'name' => q(किलोक्यालोरी),
						'one' => q({0}किलोक्यालोरी),
						'other' => q({0}किलोक्यालोरी),
					},
					# Long Unit Identifier
					'energy-kilojoule' => {
						'name' => q(किलोजुल),
						'one' => q({0}किलोजुल),
						'other' => q({0}किलोजुल),
					},
					# Core Unit Identifier
					'kilojoule' => {
						'name' => q(किलोजुल),
						'one' => q({0}किलोजुल),
						'other' => q({0}किलोजुल),
					},
					# Long Unit Identifier
					'energy-kilowatt-hour' => {
						'name' => q(किलोवाट-घण्टा),
						'one' => q({0}किलोवाट-घण्टा),
						'other' => q({0}किलोवाट-घण्टा),
					},
					# Core Unit Identifier
					'kilowatt-hour' => {
						'name' => q(किलोवाट-घण्टा),
						'one' => q({0}किलोवाट-घण्टा),
						'other' => q({0}किलोवाट-घण्टा),
					},
					# Long Unit Identifier
					'energy-therm-us' => {
						'name' => q(युएस थर्म),
						'one' => q({0} युएस थर्म),
						'other' => q({0} युएस थर्म),
					},
					# Core Unit Identifier
					'therm-us' => {
						'name' => q(युएस थर्म),
						'one' => q({0} युएस थर्म),
						'other' => q({0} युएस थर्म),
					},
					# Long Unit Identifier
					'force-kilowatt-hour-per-100-kilometer' => {
						'name' => q(किलोवाट-घण्टा प्रति १०० किलोमिटर),
						'one' => q({0} किलोवाट-घण्टा प्रति १०० किलोमिटर),
						'other' => q({0} किलोवाट घण्टा प्रति १०० किलोमिटर),
					},
					# Core Unit Identifier
					'kilowatt-hour-per-100-kilometer' => {
						'name' => q(किलोवाट-घण्टा प्रति १०० किलोमिटर),
						'one' => q({0} किलोवाट-घण्टा प्रति १०० किलोमिटर),
						'other' => q({0} किलोवाट घण्टा प्रति १०० किलोमिटर),
					},
					# Long Unit Identifier
					'force-newton' => {
						'name' => q(न्युटन),
						'one' => q({0} न्युटन),
						'other' => q({0} न्युटन),
					},
					# Core Unit Identifier
					'newton' => {
						'name' => q(न्युटन),
						'one' => q({0} न्युटन),
						'other' => q({0} न्युटन),
					},
					# Long Unit Identifier
					'force-pound-force' => {
						'name' => q(पाउन्ड बल),
						'one' => q({0} पाउन्ड बल),
						'other' => q({0} पाउन्ड बल),
					},
					# Core Unit Identifier
					'pound-force' => {
						'name' => q(पाउन्ड बल),
						'one' => q({0} पाउन्ड बल),
						'other' => q({0} पाउन्ड बल),
					},
					# Long Unit Identifier
					'frequency-gigahertz' => {
						'name' => q(गिगाहर्ज),
						'one' => q({0}गिगाहर्ज),
						'other' => q({0}गिगाहर्ज),
					},
					# Core Unit Identifier
					'gigahertz' => {
						'name' => q(गिगाहर्ज),
						'one' => q({0}गिगाहर्ज),
						'other' => q({0}गिगाहर्ज),
					},
					# Long Unit Identifier
					'frequency-hertz' => {
						'name' => q(हर्ज),
						'one' => q({0} हर्ज),
						'other' => q({0} हर्ज),
					},
					# Core Unit Identifier
					'hertz' => {
						'name' => q(हर्ज),
						'one' => q({0} हर्ज),
						'other' => q({0} हर्ज),
					},
					# Long Unit Identifier
					'frequency-kilohertz' => {
						'name' => q(किलोहर्ज),
						'one' => q({0}किलोहर्ज),
						'other' => q({0}किलोहर्ज),
					},
					# Core Unit Identifier
					'kilohertz' => {
						'name' => q(किलोहर्ज),
						'one' => q({0}किलोहर्ज),
						'other' => q({0}किलोहर्ज),
					},
					# Long Unit Identifier
					'frequency-megahertz' => {
						'name' => q(मेगाहर्ज),
						'one' => q({0} मेगाहर्ज),
						'other' => q({0} मेगाहर्ज),
					},
					# Core Unit Identifier
					'megahertz' => {
						'name' => q(मेगाहर्ज),
						'one' => q({0} मेगाहर्ज),
						'other' => q({0} मेगाहर्ज),
					},
					# Long Unit Identifier
					'graphics-dot' => {
						'name' => q(बिन्‍दु),
						'one' => q({0}बिन्‍दु),
						'other' => q({0}बिन्‍दु),
					},
					# Core Unit Identifier
					'dot' => {
						'name' => q(बिन्‍दु),
						'one' => q({0}बिन्‍दु),
						'other' => q({0}बिन्‍दु),
					},
					# Long Unit Identifier
					'graphics-dot-per-centimeter' => {
						'name' => q(डट प्रति सेन्टिमिटर),
						'one' => q({0} डट प्रति सेन्टिमिटर),
						'other' => q({0} डट प्रति सेन्टिमिटर),
					},
					# Core Unit Identifier
					'dot-per-centimeter' => {
						'name' => q(डट प्रति सेन्टिमिटर),
						'one' => q({0} डट प्रति सेन्टिमिटर),
						'other' => q({0} डट प्रति सेन्टिमिटर),
					},
					# Long Unit Identifier
					'graphics-dot-per-inch' => {
						'name' => q(डट प्रति इन्च),
						'one' => q({0} डट प्रति इन्च),
						'other' => q({0} डट प्रति इन्च),
					},
					# Core Unit Identifier
					'dot-per-inch' => {
						'name' => q(डट प्रति इन्च),
						'one' => q({0} डट प्रति इन्च),
						'other' => q({0} डट प्रति इन्च),
					},
					# Long Unit Identifier
					'graphics-em' => {
						'name' => q(टाइपोग्रापिक एम),
					},
					# Core Unit Identifier
					'em' => {
						'name' => q(टाइपोग्रापिक एम),
					},
					# Long Unit Identifier
					'graphics-megapixel' => {
						'name' => q(मेगापिक्सेल),
						'one' => q({0} मेगापिक्सेल),
						'other' => q({0} मेगापिक्सेल),
					},
					# Core Unit Identifier
					'megapixel' => {
						'name' => q(मेगापिक्सेल),
						'one' => q({0} मेगापिक्सेल),
						'other' => q({0} मेगापिक्सेल),
					},
					# Long Unit Identifier
					'graphics-pixel' => {
						'name' => q(पिक्सेल),
						'one' => q({0} पिक्सेल),
						'other' => q({0} पिक्सेल),
					},
					# Core Unit Identifier
					'pixel' => {
						'name' => q(पिक्सेल),
						'one' => q({0} पिक्सेल),
						'other' => q({0} पिक्सेल),
					},
					# Long Unit Identifier
					'graphics-pixel-per-centimeter' => {
						'name' => q(पिक्सेल प्रति सेन्टिमिटर),
						'one' => q({0} पिक्सेल प्रति सेन्टिमिटर),
						'other' => q({0} पिक्सेल प्रति सेन्टिमिटर),
					},
					# Core Unit Identifier
					'pixel-per-centimeter' => {
						'name' => q(पिक्सेल प्रति सेन्टिमिटर),
						'one' => q({0} पिक्सेल प्रति सेन्टिमिटर),
						'other' => q({0} पिक्सेल प्रति सेन्टिमिटर),
					},
					# Long Unit Identifier
					'graphics-pixel-per-inch' => {
						'name' => q(पिक्सेल प्रति इन्च),
						'one' => q({0} पिक्सेल प्रति इन्च),
						'other' => q({0} पिक्सेल प्रति इन्च),
					},
					# Core Unit Identifier
					'pixel-per-inch' => {
						'name' => q(पिक्सेल प्रति इन्च),
						'one' => q({0} पिक्सेल प्रति इन्च),
						'other' => q({0} पिक्सेल प्रति इन्च),
					},
					# Long Unit Identifier
					'length-astronomical-unit' => {
						'name' => q(खगोल एकाइ),
						'one' => q({0}खगोल एकाइ),
						'other' => q({0}खगोल एकाइ),
					},
					# Core Unit Identifier
					'astronomical-unit' => {
						'name' => q(खगोल एकाइ),
						'one' => q({0}खगोल एकाइ),
						'other' => q({0}खगोल एकाइ),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'name' => q(सेन्टिमिटर),
						'one' => q({0} सेन्टिमिटर),
						'other' => q({0} सेन्टिमिटर),
						'per' => q({0}प्रति सेन्टिमिटर),
					},
					# Core Unit Identifier
					'centimeter' => {
						'name' => q(सेन्टिमिटर),
						'one' => q({0} सेन्टिमिटर),
						'other' => q({0} सेन्टिमिटर),
						'per' => q({0}प्रति सेन्टिमिटर),
					},
					# Long Unit Identifier
					'length-decimeter' => {
						'name' => q(डेसिमिटर),
						'one' => q({0}डेसिमिटर),
						'other' => q({0}डेसिमिटर),
					},
					# Core Unit Identifier
					'decimeter' => {
						'name' => q(डेसिमिटर),
						'one' => q({0}डेसिमिटर),
						'other' => q({0}डेसिमिटर),
					},
					# Long Unit Identifier
					'length-earth-radius' => {
						'name' => q(पृथ्वीको त्रिज्या),
						'one' => q({0} पृथ्वीको त्रिज्या),
						'other' => q({0} पृथ्वीको त्रिज्या),
					},
					# Core Unit Identifier
					'earth-radius' => {
						'name' => q(पृथ्वीको त्रिज्या),
						'one' => q({0} पृथ्वीको त्रिज्या),
						'other' => q({0} पृथ्वीको त्रिज्या),
					},
					# Long Unit Identifier
					'length-fathom' => {
						'name' => q(फ्यादम),
						'one' => q({0} फ्यादम),
						'other' => q({0} फ्यादम),
					},
					# Core Unit Identifier
					'fathom' => {
						'name' => q(फ्यादम),
						'one' => q({0} फ्यादम),
						'other' => q({0} फ्यादम),
					},
					# Long Unit Identifier
					'length-foot' => {
						'name' => q(फुट),
						'one' => q({0} फुट),
						'other' => q({0} फुट),
						'per' => q({0} प्रति फुट),
					},
					# Core Unit Identifier
					'foot' => {
						'name' => q(फुट),
						'one' => q({0} फुट),
						'other' => q({0} फुट),
						'per' => q({0} प्रति फुट),
					},
					# Long Unit Identifier
					'length-furlong' => {
						'name' => q(फर्लंग),
						'one' => q({0} फर्लंग),
						'other' => q({0} फर्लंग),
					},
					# Core Unit Identifier
					'furlong' => {
						'name' => q(फर्लंग),
						'one' => q({0} फर्लंग),
						'other' => q({0} फर्लंग),
					},
					# Long Unit Identifier
					'length-inch' => {
						'name' => q(इन्च),
						'one' => q({0}इन्च),
						'other' => q({0}इन्च),
						'per' => q({0} प्रति इन्च),
					},
					# Core Unit Identifier
					'inch' => {
						'name' => q(इन्च),
						'one' => q({0}इन्च),
						'other' => q({0}इन्च),
						'per' => q({0} प्रति इन्च),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'name' => q(किलोमिटर),
						'one' => q({0} किलोमिटर),
						'other' => q({0}किलोमिटर),
						'per' => q({0}प्रति किलोमिटर),
					},
					# Core Unit Identifier
					'kilometer' => {
						'name' => q(किलोमिटर),
						'one' => q({0} किलोमिटर),
						'other' => q({0}किलोमिटर),
						'per' => q({0}प्रति किलोमिटर),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'name' => q(प्रकाश वर्ष),
						'one' => q({0} प्रकाश वर्ष),
						'other' => q({0} प्रकाश वर्ष),
					},
					# Core Unit Identifier
					'light-year' => {
						'name' => q(प्रकाश वर्ष),
						'one' => q({0} प्रकाश वर्ष),
						'other' => q({0} प्रकाश वर्ष),
					},
					# Long Unit Identifier
					'length-meter' => {
						'name' => q(मिटर),
						'one' => q({0} मिटर),
						'other' => q({0} मिटर),
						'per' => q({0}प्रति मिटर),
					},
					# Core Unit Identifier
					'meter' => {
						'name' => q(मिटर),
						'one' => q({0} मिटर),
						'other' => q({0} मिटर),
						'per' => q({0}प्रति मिटर),
					},
					# Long Unit Identifier
					'length-micrometer' => {
						'name' => q(माइक्रोमिटर),
						'one' => q({0}माइक्रोमिटर),
						'other' => q({0}माइक्रोमिटर),
					},
					# Core Unit Identifier
					'micrometer' => {
						'name' => q(माइक्रोमिटर),
						'one' => q({0}माइक्रोमिटर),
						'other' => q({0}माइक्रोमिटर),
					},
					# Long Unit Identifier
					'length-mile' => {
						'name' => q(माइल),
						'one' => q(माइल),
						'other' => q({0} माइल),
					},
					# Core Unit Identifier
					'mile' => {
						'name' => q(माइल),
						'one' => q(माइल),
						'other' => q({0} माइल),
					},
					# Long Unit Identifier
					'length-mile-scandinavian' => {
						'name' => q(smi),
						'one' => q({0} miles-scandinavian),
						'other' => q({0} miles-scandinavian),
					},
					# Core Unit Identifier
					'mile-scandinavian' => {
						'name' => q(smi),
						'one' => q({0} miles-scandinavian),
						'other' => q({0} miles-scandinavian),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'name' => q(मिलिमिटर),
						'one' => q({0} मिलिमिटर),
						'other' => q({0} मिलिमिटर),
					},
					# Core Unit Identifier
					'millimeter' => {
						'name' => q(मिलिमिटर),
						'one' => q({0} मिलिमिटर),
						'other' => q({0} मिलिमिटर),
					},
					# Long Unit Identifier
					'length-nanometer' => {
						'name' => q(न्यानोमिटर),
						'one' => q({0}न्यानोमिटर),
						'other' => q({0}न्यानोमिटर),
					},
					# Core Unit Identifier
					'nanometer' => {
						'name' => q(न्यानोमिटर),
						'one' => q({0}न्यानोमिटर),
						'other' => q({0}न्यानोमिटर),
					},
					# Long Unit Identifier
					'length-nautical-mile' => {
						'name' => q(नउटिकल माइल),
						'one' => q({0}नउटिकल माइल),
						'other' => q({0}नउटिकल माइल),
					},
					# Core Unit Identifier
					'nautical-mile' => {
						'name' => q(नउटिकल माइल),
						'one' => q({0}नउटिकल माइल),
						'other' => q({0}नउटिकल माइल),
					},
					# Long Unit Identifier
					'length-parsec' => {
						'name' => q(पारसेकेन्ड),
						'one' => q({0}पारसेकेन्ड),
						'other' => q({0}पारसेकेन्ड),
					},
					# Core Unit Identifier
					'parsec' => {
						'name' => q(पारसेकेन्ड),
						'one' => q({0}पारसेकेन्ड),
						'other' => q({0}पारसेकेन्ड),
					},
					# Long Unit Identifier
					'length-picometer' => {
						'name' => q(पिकोमिटर),
						'one' => q({0} पिकोमिटर),
						'other' => q({0} पिकोमिटर),
					},
					# Core Unit Identifier
					'picometer' => {
						'name' => q(पिकोमिटर),
						'one' => q({0} पिकोमिटर),
						'other' => q({0} पिकोमिटर),
					},
					# Long Unit Identifier
					'length-point' => {
						'name' => q(pt),
						'one' => q({0} pt),
						'other' => q({0} pt),
					},
					# Core Unit Identifier
					'point' => {
						'name' => q(pt),
						'one' => q({0} pt),
						'other' => q({0} pt),
					},
					# Long Unit Identifier
					'length-solar-radius' => {
						'name' => q(सौर्य रेडिआई),
						'one' => q({0} सौर्य रेडियस),
						'other' => q({0} सौर्य रेडिआई),
					},
					# Core Unit Identifier
					'solar-radius' => {
						'name' => q(सौर्य रेडिआई),
						'one' => q({0} सौर्य रेडियस),
						'other' => q({0} सौर्य रेडिआई),
					},
					# Long Unit Identifier
					'length-yard' => {
						'name' => q(गज),
						'one' => q({0} गज),
						'other' => q({0} गज),
					},
					# Core Unit Identifier
					'yard' => {
						'name' => q(गज),
						'one' => q({0} गज),
						'other' => q({0} गज),
					},
					# Long Unit Identifier
					'light-candela' => {
						'name' => q(क्यान्डेला),
						'one' => q({0} क्यान्डेला),
						'other' => q({0} क्यान्डेला),
					},
					# Core Unit Identifier
					'candela' => {
						'name' => q(क्यान्डेला),
						'one' => q({0} क्यान्डेला),
						'other' => q({0} क्यान्डेला),
					},
					# Long Unit Identifier
					'light-lumen' => {
						'name' => q(लुमेन),
						'one' => q({0} लुमेन),
						'other' => q({0} लुमेन),
					},
					# Core Unit Identifier
					'lumen' => {
						'name' => q(लुमेन),
						'one' => q({0} लुमेन),
						'other' => q({0} लुमेन),
					},
					# Long Unit Identifier
					'light-lux' => {
						'name' => q(लक्स),
						'one' => q({0}लक्स),
						'other' => q({0}लक्स),
					},
					# Core Unit Identifier
					'lux' => {
						'name' => q(लक्स),
						'one' => q({0}लक्स),
						'other' => q({0}लक्स),
					},
					# Long Unit Identifier
					'light-solar-luminosity' => {
						'name' => q(सौर्य प्रकाश),
						'one' => q({0} सौर्य प्रकाश),
						'other' => q({0} सौर्य प्रकाश),
					},
					# Core Unit Identifier
					'solar-luminosity' => {
						'name' => q(सौर्य प्रकाश),
						'one' => q({0} सौर्य प्रकाश),
						'other' => q({0} सौर्य प्रकाश),
					},
					# Long Unit Identifier
					'mass-carat' => {
						'name' => q(कराट),
						'one' => q({0}कराट),
						'other' => q({0}कराट),
					},
					# Core Unit Identifier
					'carat' => {
						'name' => q(कराट),
						'one' => q({0}कराट),
						'other' => q({0}कराट),
					},
					# Long Unit Identifier
					'mass-dalton' => {
						'name' => q(डाल्टन),
						'one' => q({0} डाल्टन),
						'other' => q({0} डाल्टन),
					},
					# Core Unit Identifier
					'dalton' => {
						'name' => q(डाल्टन),
						'one' => q({0} डाल्टन),
						'other' => q({0} डाल्टन),
					},
					# Long Unit Identifier
					'mass-earth-mass' => {
						'name' => q(पृथ्वी घन),
						'one' => q({0} पृथ्वी घन),
						'other' => q({0} पृथ्वी घन),
					},
					# Core Unit Identifier
					'earth-mass' => {
						'name' => q(पृथ्वी घन),
						'one' => q({0} पृथ्वी घन),
						'other' => q({0} पृथ्वी घन),
					},
					# Long Unit Identifier
					'mass-grain' => {
						'name' => q(दाना),
						'one' => q({0} दाना),
						'other' => q({0} दाना),
					},
					# Core Unit Identifier
					'grain' => {
						'name' => q(दाना),
						'one' => q({0} दाना),
						'other' => q({0} दाना),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'name' => q(ग्राम),
						'one' => q({0} ग्राम),
						'other' => q({0} ग्राम),
						'per' => q({0}प्रति ग्राम),
					},
					# Core Unit Identifier
					'gram' => {
						'name' => q(ग्राम),
						'one' => q({0} ग्राम),
						'other' => q({0} ग्राम),
						'per' => q({0}प्रति ग्राम),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'name' => q(किलोग्राम),
						'one' => q({0} किलोग्राम),
						'other' => q({0} किलोग्राम),
						'per' => q({0} प्रति किलोग्राम),
					},
					# Core Unit Identifier
					'kilogram' => {
						'name' => q(किलोग्राम),
						'one' => q({0} किलोग्राम),
						'other' => q({0} किलोग्राम),
						'per' => q({0} प्रति किलोग्राम),
					},
					# Long Unit Identifier
					'mass-metric-ton' => {
						'name' => q(मेट्रिक टन),
						'one' => q({0}मेट्रिक टन),
						'other' => q({0}मेट्रिक टन),
					},
					# Core Unit Identifier
					'metric-ton' => {
						'name' => q(मेट्रिक टन),
						'one' => q({0}मेट्रिक टन),
						'other' => q({0}मेट्रिक टन),
					},
					# Long Unit Identifier
					'mass-microgram' => {
						'name' => q(माइक्रोग्राम),
						'one' => q({0}माइक्रोग्राम),
						'other' => q({0}माइक्रोग्राम),
					},
					# Core Unit Identifier
					'microgram' => {
						'name' => q(माइक्रोग्राम),
						'one' => q({0}माइक्रोग्राम),
						'other' => q({0}माइक्रोग्राम),
					},
					# Long Unit Identifier
					'mass-milligram' => {
						'name' => q(मिलिग्राम),
						'one' => q({0}मिलिग्राम),
						'other' => q({0}मिलिग्राम),
					},
					# Core Unit Identifier
					'milligram' => {
						'name' => q(मिलिग्राम),
						'one' => q({0}मिलिग्राम),
						'other' => q({0}मिलिग्राम),
					},
					# Long Unit Identifier
					'mass-ounce' => {
						'name' => q(आउन्स),
						'one' => q({0} आउन्स),
						'other' => q({0} आउन्स),
						'per' => q({0}प्रति आउन्स),
					},
					# Core Unit Identifier
					'ounce' => {
						'name' => q(आउन्स),
						'one' => q({0} आउन्स),
						'other' => q({0} आउन्स),
						'per' => q({0}प्रति आउन्स),
					},
					# Long Unit Identifier
					'mass-ounce-troy' => {
						'name' => q(ट्रोय आउन्स),
						'one' => q({0} ट्रोय आउन्स),
						'other' => q({0}ट्रोय आउन्स),
					},
					# Core Unit Identifier
					'ounce-troy' => {
						'name' => q(ट्रोय आउन्स),
						'one' => q({0} ट्रोय आउन्स),
						'other' => q({0}ट्रोय आउन्स),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'name' => q(पाउन्ड),
						'one' => q({0}पाउन्ड),
						'other' => q({0}पाउन्ड),
						'per' => q({0}प्रति पाउन्ड),
					},
					# Core Unit Identifier
					'pound' => {
						'name' => q(पाउन्ड),
						'one' => q({0}पाउन्ड),
						'other' => q({0}पाउन्ड),
						'per' => q({0}प्रति पाउन्ड),
					},
					# Long Unit Identifier
					'mass-solar-mass' => {
						'name' => q(सौर्य घन),
						'one' => q({0} सौर्य घन),
						'other' => q({0} सौर्य घन),
					},
					# Core Unit Identifier
					'solar-mass' => {
						'name' => q(सौर्य घन),
						'one' => q({0} सौर्य घन),
						'other' => q({0} सौर्य घन),
					},
					# Long Unit Identifier
					'mass-stone' => {
						'name' => q(स्टोन),
						'one' => q({0} स्टोन),
						'other' => q({0} स्टोन),
					},
					# Core Unit Identifier
					'stone' => {
						'name' => q(स्टोन),
						'one' => q({0} स्टोन),
						'other' => q({0} स्टोन),
					},
					# Long Unit Identifier
					'mass-ton' => {
						'name' => q(टन),
						'one' => q({0}टन),
						'other' => q({0} टन),
					},
					# Core Unit Identifier
					'ton' => {
						'name' => q(टन),
						'one' => q({0}टन),
						'other' => q({0} टन),
					},
					# Long Unit Identifier
					'per' => {
						'1' => q({0}प्रति{1}),
					},
					# Core Unit Identifier
					'per' => {
						'1' => q({0}प्रति{1}),
					},
					# Long Unit Identifier
					'power-gigawatt' => {
						'name' => q(गिगावाट),
						'one' => q({0}गिगावाट),
						'other' => q({0}गिगावाट),
					},
					# Core Unit Identifier
					'gigawatt' => {
						'name' => q(गिगावाट),
						'one' => q({0}गिगावाट),
						'other' => q({0}गिगावाट),
					},
					# Long Unit Identifier
					'power-horsepower' => {
						'name' => q(हर्सपावर),
						'one' => q({0} हर्सपावर),
						'other' => q({0} हर्सपावर),
					},
					# Core Unit Identifier
					'horsepower' => {
						'name' => q(हर्सपावर),
						'one' => q({0} हर्सपावर),
						'other' => q({0} हर्सपावर),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'name' => q(किलोवाट),
						'one' => q({0} किलोवाट),
						'other' => q({0} किलोवाट),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'name' => q(किलोवाट),
						'one' => q({0} किलोवाट),
						'other' => q({0} किलोवाट),
					},
					# Long Unit Identifier
					'power-megawatt' => {
						'name' => q(मेगावाट),
						'one' => q({0}मेगावाट),
						'other' => q({0}मेगावाट),
					},
					# Core Unit Identifier
					'megawatt' => {
						'name' => q(मेगावाट),
						'one' => q({0}मेगावाट),
						'other' => q({0}मेगावाट),
					},
					# Long Unit Identifier
					'power-milliwatt' => {
						'name' => q(मिलिवाट),
						'one' => q({0}मिलिवाट),
						'other' => q({0}मिलिवाट),
					},
					# Core Unit Identifier
					'milliwatt' => {
						'name' => q(मिलिवाट),
						'one' => q({0}मिलिवाट),
						'other' => q({0}मिलिवाट),
					},
					# Long Unit Identifier
					'power-watt' => {
						'name' => q(वाट),
						'one' => q({0} वाट),
						'other' => q({0} वाट),
					},
					# Core Unit Identifier
					'watt' => {
						'name' => q(वाट),
						'one' => q({0} वाट),
						'other' => q({0} वाट),
					},
					# Long Unit Identifier
					'power2' => {
						'1' => q(वर्ग {0}),
						'one' => q(वर्ग {0}),
						'other' => q(वर्ग {0}),
					},
					# Core Unit Identifier
					'power2' => {
						'1' => q(वर्ग {0}),
						'one' => q(वर्ग {0}),
						'other' => q(वर्ग {0}),
					},
					# Long Unit Identifier
					'power3' => {
						'1' => q(घन {0}),
						'one' => q(घन {0}),
						'other' => q(घन {0}),
					},
					# Core Unit Identifier
					'power3' => {
						'1' => q(घन {0}),
						'one' => q(घन {0}),
						'other' => q(घन {0}),
					},
					# Long Unit Identifier
					'pressure-atmosphere' => {
						'name' => q(वायुमण्डल),
						'one' => q({0} वायुमण्डल),
						'other' => q({0} वायुमण्डलहरू),
					},
					# Core Unit Identifier
					'atmosphere' => {
						'name' => q(वायुमण्डल),
						'one' => q({0} वायुमण्डल),
						'other' => q({0} वायुमण्डलहरू),
					},
					# Long Unit Identifier
					'pressure-bar' => {
						'name' => q(धर्का),
						'one' => q({0} धर्का),
						'other' => q({0} धर्का),
					},
					# Core Unit Identifier
					'bar' => {
						'name' => q(धर्का),
						'one' => q({0} धर्का),
						'other' => q({0} धर्का),
					},
					# Long Unit Identifier
					'pressure-hectopascal' => {
						'name' => q(हेक्टो पास्कल),
						'one' => q({0} हेक्टो पास्कल),
						'other' => q({0} हेक्टो पास्कल),
					},
					# Core Unit Identifier
					'hectopascal' => {
						'name' => q(हेक्टो पास्कल),
						'one' => q({0} हेक्टो पास्कल),
						'other' => q({0} हेक्टो पास्कल),
					},
					# Long Unit Identifier
					'pressure-inch-ofhg' => {
						'name' => q(इन्च पारो),
						'one' => q({0} इन्च पारो),
						'other' => q({0} इन्च पारो),
					},
					# Core Unit Identifier
					'inch-ofhg' => {
						'name' => q(इन्च पारो),
						'one' => q({0} इन्च पारो),
						'other' => q({0} इन्च पारो),
					},
					# Long Unit Identifier
					'pressure-kilopascal' => {
						'name' => q(किलोपास्कल),
						'one' => q({0} किलोपास्कल),
						'other' => q({0} किलोपास्कल),
					},
					# Core Unit Identifier
					'kilopascal' => {
						'name' => q(किलोपास्कल),
						'one' => q({0} किलोपास्कल),
						'other' => q({0} किलोपास्कल),
					},
					# Long Unit Identifier
					'pressure-megapascal' => {
						'name' => q(मेघापास्कल),
						'one' => q({0} मेघापास्कल),
						'other' => q({0} मेघापास्कल),
					},
					# Core Unit Identifier
					'megapascal' => {
						'name' => q(मेघापास्कल),
						'one' => q({0} मेघापास्कल),
						'other' => q({0} मेघापास्कल),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'name' => q(मिलिबार),
						'one' => q({0} मिलिबार),
						'other' => q({0} मिलिबार),
					},
					# Core Unit Identifier
					'millibar' => {
						'name' => q(मिलिबार),
						'one' => q({0} मिलिबार),
						'other' => q({0} मिलिबार),
					},
					# Long Unit Identifier
					'pressure-millimeter-ofhg' => {
						'name' => q(मिलिमिटर पारो),
						'one' => q({0} मिलिमिटर पारो),
						'other' => q({0} मिलिमिटर पारो),
					},
					# Core Unit Identifier
					'millimeter-ofhg' => {
						'name' => q(मिलिमिटर पारो),
						'one' => q({0} मिलिमिटर पारो),
						'other' => q({0} मिलिमिटर पारो),
					},
					# Long Unit Identifier
					'pressure-pascal' => {
						'name' => q(पास्कल),
						'one' => q({0} पास्कल),
						'other' => q({0} पास्कल),
					},
					# Core Unit Identifier
					'pascal' => {
						'name' => q(पास्कल),
						'one' => q({0} पास्कल),
						'other' => q({0} पास्कल),
					},
					# Long Unit Identifier
					'pressure-pound-force-per-square-inch' => {
						'name' => q(पाउन्ड प्रति वर्ग इन्च),
						'one' => q({0} पाउन्ड प्रति वर्ग इन्च),
						'other' => q({0}पाउन्ड प्रति वर्ग इन्च),
					},
					# Core Unit Identifier
					'pound-force-per-square-inch' => {
						'name' => q(पाउन्ड प्रति वर्ग इन्च),
						'one' => q({0} पाउन्ड प्रति वर्ग इन्च),
						'other' => q({0}पाउन्ड प्रति वर्ग इन्च),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'name' => q(किलोमिटर प्रति घण्टा),
						'one' => q({0} किलोमिटर प्रति घण्टा),
						'other' => q({0} किलोमिटर प्रति घण्टा),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'name' => q(किलोमिटर प्रति घण्टा),
						'one' => q({0} किलोमिटर प्रति घण्टा),
						'other' => q({0} किलोमिटर प्रति घण्टा),
					},
					# Long Unit Identifier
					'speed-knot' => {
						'name' => q(नट),
						'one' => q({0}नट),
						'other' => q({0}नट्स),
					},
					# Core Unit Identifier
					'knot' => {
						'name' => q(नट),
						'one' => q({0}नट),
						'other' => q({0}नट्स),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'name' => q(मिटर प्रति सेकेण्ड),
						'one' => q({0} मिटर प्रति सेकेण्ड),
						'other' => q({0} मिटर प्रति सेकेण्ड),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'name' => q(मिटर प्रति सेकेण्ड),
						'one' => q({0} मिटर प्रति सेकेण्ड),
						'other' => q({0} मिटर प्रति सेकेण्ड),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'name' => q(माइल प्रति घण्टा),
						'one' => q(माइल प्रति घण्टा),
						'other' => q({0} माइल प्रति घण्टा),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'name' => q(माइल प्रति घण्टा),
						'one' => q(माइल प्रति घण्टा),
						'other' => q({0} माइल प्रति घण्टा),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'name' => q(डिग्री सेल्सियस्),
						'one' => q({0} डिग्री सेल्सियस्),
						'other' => q({0} डिग्री सेल्सियस्),
					},
					# Core Unit Identifier
					'celsius' => {
						'name' => q(डिग्री सेल्सियस्),
						'one' => q({0} डिग्री सेल्सियस्),
						'other' => q({0} डिग्री सेल्सियस्),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'name' => q(डिग्री फरेनहाइट),
						'one' => q({0}डिग्री फरेनहाइट),
						'other' => q({0}डिग्री फरेनहाइट),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'name' => q(डिग्री फरेनहाइट),
						'one' => q({0}डिग्री फरेनहाइट),
						'other' => q({0}डिग्री फरेनहाइट),
					},
					# Long Unit Identifier
					'temperature-generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Core Unit Identifier
					'generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Long Unit Identifier
					'temperature-kelvin' => {
						'name' => q(केल्भिन),
						'one' => q({0} K),
						'other' => q({0} K),
					},
					# Core Unit Identifier
					'kelvin' => {
						'name' => q(केल्भिन),
						'one' => q({0} K),
						'other' => q({0} K),
					},
					# Long Unit Identifier
					'torque-newton-meter' => {
						'name' => q(न्युटन मिटर),
						'one' => q({0} न्युटन मिटर),
						'other' => q({0} न्युटन मिटर),
					},
					# Core Unit Identifier
					'newton-meter' => {
						'name' => q(न्युटन मिटर),
						'one' => q({0} न्युटन मिटर),
						'other' => q({0} न्युटन मिटर),
					},
					# Long Unit Identifier
					'torque-pound-force-foot' => {
						'name' => q(पाउन्ड फिट),
						'one' => q({0} पाउन्ड फुट),
						'other' => q({0} पाउन्ड फिट),
					},
					# Core Unit Identifier
					'pound-force-foot' => {
						'name' => q(पाउन्ड फिट),
						'one' => q({0} पाउन्ड फुट),
						'other' => q({0} पाउन्ड फिट),
					},
					# Long Unit Identifier
					'volume-acre-foot' => {
						'name' => q(वर्ग गज-फिट),
						'one' => q({0}वर्ग गज-फिट),
						'other' => q({0}वर्ग गज-फिट),
					},
					# Core Unit Identifier
					'acre-foot' => {
						'name' => q(वर्ग गज-फिट),
						'one' => q({0}वर्ग गज-फिट),
						'other' => q({0}वर्ग गज-फिट),
					},
					# Long Unit Identifier
					'volume-barrel' => {
						'name' => q(ब्यारल),
						'one' => q({0} ब्यारल),
						'other' => q({0} ब्यारल),
					},
					# Core Unit Identifier
					'barrel' => {
						'name' => q(ब्यारल),
						'one' => q({0} ब्यारल),
						'other' => q({0} ब्यारल),
					},
					# Long Unit Identifier
					'volume-bushel' => {
						'name' => q(बुशेल),
						'one' => q({0} बुशेल),
						'other' => q({0} बुशेल),
					},
					# Core Unit Identifier
					'bushel' => {
						'name' => q(बुशेल),
						'one' => q({0} बुशेल),
						'other' => q({0} बुशेल),
					},
					# Long Unit Identifier
					'volume-centiliter' => {
						'name' => q(सेन्टिलिटर),
						'one' => q({0}सेन्टिलिटर),
						'other' => q({0}सेन्टिलिटर),
					},
					# Core Unit Identifier
					'centiliter' => {
						'name' => q(सेन्टिलिटर),
						'one' => q({0}सेन्टिलिटर),
						'other' => q({0}सेन्टिलिटर),
					},
					# Long Unit Identifier
					'volume-cubic-centimeter' => {
						'name' => q(घन सेन्टिमिटर),
						'one' => q({0}घन सेन्टिमिटर),
						'other' => q({0}घन सेन्टिमिटर),
						'per' => q({0}प्रति घन सेन्टिमिटर),
					},
					# Core Unit Identifier
					'cubic-centimeter' => {
						'name' => q(घन सेन्टिमिटर),
						'one' => q({0}घन सेन्टिमिटर),
						'other' => q({0}घन सेन्टिमिटर),
						'per' => q({0}प्रति घन सेन्टिमिटर),
					},
					# Long Unit Identifier
					'volume-cubic-foot' => {
						'name' => q(घन फिट),
						'one' => q({0}घन फिट),
						'other' => q({0}घन फिट),
					},
					# Core Unit Identifier
					'cubic-foot' => {
						'name' => q(घन फिट),
						'one' => q({0}घन फिट),
						'other' => q({0}घन फिट),
					},
					# Long Unit Identifier
					'volume-cubic-inch' => {
						'name' => q(घन इन्च),
						'one' => q({0}घन इन्च),
						'other' => q({0}घन इन्च),
					},
					# Core Unit Identifier
					'cubic-inch' => {
						'name' => q(घन इन्च),
						'one' => q({0}घन इन्च),
						'other' => q({0}घन इन्च),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'name' => q(घन किलोमिटर),
						'one' => q({0} घन किलोमिटर),
						'other' => q({0} घन किलोमिटर),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'name' => q(घन किलोमिटर),
						'one' => q({0} घन किलोमिटर),
						'other' => q({0} घन किलोमिटर),
					},
					# Long Unit Identifier
					'volume-cubic-meter' => {
						'name' => q(घन मिटर),
						'one' => q({0}घन मिटर),
						'other' => q({0}घन मिटर),
						'per' => q({0}प्रति घन मिटर),
					},
					# Core Unit Identifier
					'cubic-meter' => {
						'name' => q(घन मिटर),
						'one' => q({0}घन मिटर),
						'other' => q({0}घन मिटर),
						'per' => q({0}प्रति घन मिटर),
					},
					# Long Unit Identifier
					'volume-cubic-mile' => {
						'name' => q(घन माइल),
						'one' => q({0} घन माइल),
						'other' => q({0} घन माइल),
					},
					# Core Unit Identifier
					'cubic-mile' => {
						'name' => q(घन माइल),
						'one' => q({0} घन माइल),
						'other' => q({0} घन माइल),
					},
					# Long Unit Identifier
					'volume-cubic-yard' => {
						'name' => q(घन यार्ड),
						'one' => q({0}घन यार्ड),
						'other' => q({0}घन यार्ड),
					},
					# Core Unit Identifier
					'cubic-yard' => {
						'name' => q(घन यार्ड),
						'one' => q({0}घन यार्ड),
						'other' => q({0}घन यार्ड),
					},
					# Long Unit Identifier
					'volume-cup' => {
						'name' => q(कप्स),
						'one' => q({0}कप),
						'other' => q({0}कप्स),
					},
					# Core Unit Identifier
					'cup' => {
						'name' => q(कप्स),
						'one' => q({0}कप),
						'other' => q({0}कप्स),
					},
					# Long Unit Identifier
					'volume-cup-metric' => {
						'name' => q(मेट्रिक कप्स),
						'one' => q({0}मेट्रिक कप),
						'other' => q({0}मेट्रिक कप्स),
					},
					# Core Unit Identifier
					'cup-metric' => {
						'name' => q(मेट्रिक कप्स),
						'one' => q({0}मेट्रिक कप),
						'other' => q({0}मेट्रिक कप्स),
					},
					# Long Unit Identifier
					'volume-deciliter' => {
						'name' => q(डेसिलिटर),
						'one' => q({0}डेसिलिटर),
						'other' => q({0}डेसिलिटर),
					},
					# Core Unit Identifier
					'deciliter' => {
						'name' => q(डेसिलिटर),
						'one' => q({0}डेसिलिटर),
						'other' => q({0}डेसिलिटर),
					},
					# Long Unit Identifier
					'volume-dessert-spoon' => {
						'name' => q(डेजर्ट चम्चा),
						'one' => q({0} डेजर्ट चम्चा),
						'other' => q({0} डेजर्ट चम्चा),
					},
					# Core Unit Identifier
					'dessert-spoon' => {
						'name' => q(डेजर्ट चम्चा),
						'one' => q({0} डेजर्ट चम्चा),
						'other' => q({0} डेजर्ट चम्चा),
					},
					# Long Unit Identifier
					'volume-dessert-spoon-imperial' => {
						'name' => q(Imp. डेजर्ट चम्चा),
						'one' => q({0} Imp. डेजर्ट चम्चा),
						'other' => q({0} Imp. डेजर्ट चम्चा),
					},
					# Core Unit Identifier
					'dessert-spoon-imperial' => {
						'name' => q(Imp. डेजर्ट चम्चा),
						'one' => q({0} Imp. डेजर्ट चम्चा),
						'other' => q({0} Imp. डेजर्ट चम्चा),
					},
					# Long Unit Identifier
					'volume-dram' => {
						'name' => q(ड्राम),
						'one' => q({0} ड्राम),
						'other' => q({0} ड्राम),
					},
					# Core Unit Identifier
					'dram' => {
						'name' => q(ड्राम),
						'one' => q({0} ड्राम),
						'other' => q({0} ड्राम),
					},
					# Long Unit Identifier
					'volume-drop' => {
						'name' => q(थोपा),
						'one' => q({0} थोपा),
						'other' => q({0} थोपा),
					},
					# Core Unit Identifier
					'drop' => {
						'name' => q(थोपा),
						'one' => q({0} थोपा),
						'other' => q({0} थोपा),
					},
					# Long Unit Identifier
					'volume-fluid-ounce' => {
						'name' => q(तरल आउन्स),
						'one' => q({0} तरल आउन्स),
						'other' => q({0}तरल आउन्स),
					},
					# Core Unit Identifier
					'fluid-ounce' => {
						'name' => q(तरल आउन्स),
						'one' => q({0} तरल आउन्स),
						'other' => q({0}तरल आउन्स),
					},
					# Long Unit Identifier
					'volume-fluid-ounce-imperial' => {
						'name' => q(Imp. fluid ounces),
						'one' => q({0} Imp. fluid ounce),
						'other' => q({0} Imp. fluid ounces),
					},
					# Core Unit Identifier
					'fluid-ounce-imperial' => {
						'name' => q(Imp. fluid ounces),
						'one' => q({0} Imp. fluid ounce),
						'other' => q({0} Imp. fluid ounces),
					},
					# Long Unit Identifier
					'volume-gallon' => {
						'name' => q(ग्यालोन),
						'one' => q({0}ग्यालोन),
						'other' => q({0}ग्यालोन),
						'per' => q({0}प्रति ग्यालोन),
					},
					# Core Unit Identifier
					'gallon' => {
						'name' => q(ग्यालोन),
						'one' => q({0}ग्यालोन),
						'other' => q({0}ग्यालोन),
						'per' => q({0}प्रति ग्यालोन),
					},
					# Long Unit Identifier
					'volume-gallon-imperial' => {
						'name' => q(Imp. gal),
						'one' => q({0} gal Imp.),
						'other' => q({0} gal Imp.),
						'per' => q({0}/gal Imp.),
					},
					# Core Unit Identifier
					'gallon-imperial' => {
						'name' => q(Imp. gal),
						'one' => q({0} gal Imp.),
						'other' => q({0} gal Imp.),
						'per' => q({0}/gal Imp.),
					},
					# Long Unit Identifier
					'volume-hectoliter' => {
						'name' => q(हेक्टोलिटर),
						'one' => q({0}हेक्टोलिटर),
						'other' => q({0}हेक्टोलिटर),
					},
					# Core Unit Identifier
					'hectoliter' => {
						'name' => q(हेक्टोलिटर),
						'one' => q({0}हेक्टोलिटर),
						'other' => q({0}हेक्टोलिटर),
					},
					# Long Unit Identifier
					'volume-jigger' => {
						'name' => q(जिगर),
						'one' => q({0} जिगर),
						'other' => q({0} जिगर),
					},
					# Core Unit Identifier
					'jigger' => {
						'name' => q(जिगर),
						'one' => q({0} जिगर),
						'other' => q({0} जिगर),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'name' => q(लिटर),
						'one' => q({0} लिटर),
						'other' => q({0} लिटर),
						'per' => q({0}प्रति लिटर),
					},
					# Core Unit Identifier
					'liter' => {
						'name' => q(लिटर),
						'one' => q({0} लिटर),
						'other' => q({0} लिटर),
						'per' => q({0}प्रति लिटर),
					},
					# Long Unit Identifier
					'volume-megaliter' => {
						'name' => q(मेगालिटर),
						'one' => q({0}मेगालिटर),
						'other' => q({0}मेगालिटर),
					},
					# Core Unit Identifier
					'megaliter' => {
						'name' => q(मेगालिटर),
						'one' => q({0}मेगालिटर),
						'other' => q({0}मेगालिटर),
					},
					# Long Unit Identifier
					'volume-milliliter' => {
						'name' => q(मिलिलिटर),
						'one' => q({0}मिलिलिटर),
						'other' => q({0}मिलिलिटर),
					},
					# Core Unit Identifier
					'milliliter' => {
						'name' => q(मिलिलिटर),
						'one' => q({0}मिलिलिटर),
						'other' => q({0}मिलिलिटर),
					},
					# Long Unit Identifier
					'volume-pinch' => {
						'name' => q(चुटकी),
						'one' => q({0} चुटकी),
						'other' => q({0} चुटकी),
					},
					# Core Unit Identifier
					'pinch' => {
						'name' => q(चुटकी),
						'one' => q({0} चुटकी),
						'other' => q({0} चुटकी),
					},
					# Long Unit Identifier
					'volume-pint' => {
						'name' => q(पिन्ट),
						'one' => q({0}पिन्ट),
						'other' => q({0}पिन्ट),
					},
					# Core Unit Identifier
					'pint' => {
						'name' => q(पिन्ट),
						'one' => q({0}पिन्ट),
						'other' => q({0}पिन्ट),
					},
					# Long Unit Identifier
					'volume-pint-metric' => {
						'name' => q(मेट्रिक पिन्ट्स),
						'one' => q({0}मेट्रिक पिन्ट),
						'other' => q({0}मेट्रिक पिन्ट्स),
					},
					# Core Unit Identifier
					'pint-metric' => {
						'name' => q(मेट्रिक पिन्ट्स),
						'one' => q({0}मेट्रिक पिन्ट),
						'other' => q({0}मेट्रिक पिन्ट्स),
					},
					# Long Unit Identifier
					'volume-quart' => {
						'name' => q(क्वार्ट्स),
						'one' => q({0}क्वार्ट),
						'other' => q({0}क्वार्ट्स),
					},
					# Core Unit Identifier
					'quart' => {
						'name' => q(क्वार्ट्स),
						'one' => q({0}क्वार्ट),
						'other' => q({0}क्वार्ट्स),
					},
					# Long Unit Identifier
					'volume-quart-imperial' => {
						'name' => q(इम्पिरियल चौथाइ),
						'one' => q({0} इम्पिरियल चौथाइ),
						'other' => q({0} इम्पिरियल चौथाइ),
					},
					# Core Unit Identifier
					'quart-imperial' => {
						'name' => q(इम्पिरियल चौथाइ),
						'one' => q({0} इम्पिरियल चौथाइ),
						'other' => q({0} इम्पिरियल चौथाइ),
					},
					# Long Unit Identifier
					'volume-tablespoon' => {
						'name' => q(टेबल चम्चा),
						'one' => q({0} टेबल चम्चा),
						'other' => q({0} टेबल चम्चा),
					},
					# Core Unit Identifier
					'tablespoon' => {
						'name' => q(टेबल चम्चा),
						'one' => q({0} टेबल चम्चा),
						'other' => q({0} टेबल चम्चा),
					},
					# Long Unit Identifier
					'volume-teaspoon' => {
						'name' => q(चिया चम्चा),
						'one' => q({0}चिया चम्चा),
						'other' => q({0}चिया चम्चा),
					},
					# Core Unit Identifier
					'teaspoon' => {
						'name' => q(चिया चम्चा),
						'one' => q({0}चिया चम्चा),
						'other' => q({0}चिया चम्चा),
					},
				},
				'narrow' => {
					# Long Unit Identifier
					'' => {
						'name' => q(दिशा),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(दिशा),
					},
					# Long Unit Identifier
					'1024p1' => {
						'1' => q(केआइ{0}),
					},
					# Core Unit Identifier
					'1024p1' => {
						'1' => q(केआइ{0}),
					},
					# Long Unit Identifier
					'1024p2' => {
						'1' => q(एमआइ{0}),
					},
					# Core Unit Identifier
					'1024p2' => {
						'1' => q(एमआइ{0}),
					},
					# Long Unit Identifier
					'1024p3' => {
						'1' => q(जीआइ{0}),
					},
					# Core Unit Identifier
					'1024p3' => {
						'1' => q(जीआइ{0}),
					},
					# Long Unit Identifier
					'1024p4' => {
						'1' => q(टिआइ{0}),
					},
					# Core Unit Identifier
					'1024p4' => {
						'1' => q(टिआइ{0}),
					},
					# Long Unit Identifier
					'1024p5' => {
						'1' => q(पिआइ{0}),
					},
					# Core Unit Identifier
					'1024p5' => {
						'1' => q(पिआइ{0}),
					},
					# Long Unit Identifier
					'1024p6' => {
						'1' => q(इआइ{0}),
					},
					# Core Unit Identifier
					'1024p6' => {
						'1' => q(इआइ{0}),
					},
					# Long Unit Identifier
					'1024p7' => {
						'1' => q(जेडआइ{0}),
					},
					# Core Unit Identifier
					'1024p7' => {
						'1' => q(जेडआइ{0}),
					},
					# Long Unit Identifier
					'1024p8' => {
						'1' => q(वाइआइ{0}),
					},
					# Core Unit Identifier
					'1024p8' => {
						'1' => q(वाइआइ{0}),
					},
					# Long Unit Identifier
					'10p-1' => {
						'1' => q(डेसि{0}),
					},
					# Core Unit Identifier
					'1' => {
						'1' => q(डेसि{0}),
					},
					# Long Unit Identifier
					'10p-12' => {
						'1' => q(पिको{0}),
					},
					# Core Unit Identifier
					'12' => {
						'1' => q(पिको{0}),
					},
					# Long Unit Identifier
					'10p-15' => {
						'1' => q(फेमटो{0}),
					},
					# Core Unit Identifier
					'15' => {
						'1' => q(फेमटो{0}),
					},
					# Long Unit Identifier
					'10p-18' => {
						'1' => q(अटो{0}),
					},
					# Core Unit Identifier
					'18' => {
						'1' => q(अटो{0}),
					},
					# Long Unit Identifier
					'10p-2' => {
						'1' => q(सेन्टी{0}),
					},
					# Core Unit Identifier
					'2' => {
						'1' => q(सेन्टी{0}),
					},
					# Long Unit Identifier
					'10p-21' => {
						'1' => q(जेप्टो{0}),
					},
					# Core Unit Identifier
					'21' => {
						'1' => q(जेप्टो{0}),
					},
					# Long Unit Identifier
					'10p-24' => {
						'1' => q(योक्टो{0}),
					},
					# Core Unit Identifier
					'24' => {
						'1' => q(योक्टो{0}),
					},
					# Long Unit Identifier
					'10p-3' => {
						'1' => q(मिली{0}),
					},
					# Core Unit Identifier
					'3' => {
						'1' => q(मिली{0}),
					},
					# Long Unit Identifier
					'10p-6' => {
						'1' => q(माइक्रो{0}),
					},
					# Core Unit Identifier
					'6' => {
						'1' => q(माइक्रो{0}),
					},
					# Long Unit Identifier
					'10p-9' => {
						'1' => q(नानो{0}),
					},
					# Core Unit Identifier
					'9' => {
						'1' => q(नानो{0}),
					},
					# Long Unit Identifier
					'10p1' => {
						'1' => q(डेका{0}),
					},
					# Core Unit Identifier
					'10p1' => {
						'1' => q(डेका{0}),
					},
					# Long Unit Identifier
					'10p12' => {
						'1' => q(टेरा{0}),
					},
					# Core Unit Identifier
					'10p12' => {
						'1' => q(टेरा{0}),
					},
					# Long Unit Identifier
					'10p15' => {
						'1' => q(पेटा{0}),
					},
					# Core Unit Identifier
					'10p15' => {
						'1' => q(पेटा{0}),
					},
					# Long Unit Identifier
					'10p18' => {
						'1' => q(एक्सा{0}),
					},
					# Core Unit Identifier
					'10p18' => {
						'1' => q(एक्सा{0}),
					},
					# Long Unit Identifier
					'10p2' => {
						'1' => q(हेक्टो{0}),
					},
					# Core Unit Identifier
					'10p2' => {
						'1' => q(हेक्टो{0}),
					},
					# Long Unit Identifier
					'10p21' => {
						'1' => q(जेटा{0}),
					},
					# Core Unit Identifier
					'10p21' => {
						'1' => q(जेटा{0}),
					},
					# Long Unit Identifier
					'10p24' => {
						'1' => q(योटा{0}),
					},
					# Core Unit Identifier
					'10p24' => {
						'1' => q(योटा{0}),
					},
					# Long Unit Identifier
					'10p3' => {
						'1' => q(किलो{0}),
					},
					# Core Unit Identifier
					'10p3' => {
						'1' => q(किलो{0}),
					},
					# Long Unit Identifier
					'10p6' => {
						'1' => q(मेगा{0}),
					},
					# Core Unit Identifier
					'10p6' => {
						'1' => q(मेगा{0}),
					},
					# Long Unit Identifier
					'10p9' => {
						'1' => q(गिगा{0}),
					},
					# Core Unit Identifier
					'10p9' => {
						'1' => q(गिगा{0}),
					},
					# Long Unit Identifier
					'acceleration-g-force' => {
						'one' => q({0} g),
						'other' => q({0} g),
					},
					# Core Unit Identifier
					'g-force' => {
						'one' => q({0} g),
						'other' => q({0} g),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'one' => q({0}′),
						'other' => q({0}′),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'one' => q({0}′),
						'other' => q({0}′),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					# Core Unit Identifier
					'arc-second' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Core Unit Identifier
					'degree' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Long Unit Identifier
					'area-acre' => {
						'one' => q({0} एकर),
						'other' => q({0} एकर),
					},
					# Core Unit Identifier
					'acre' => {
						'one' => q({0} एकर),
						'other' => q({0} एकर),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'one' => q({0} हे.),
						'other' => q({0} हे.),
					},
					# Core Unit Identifier
					'hectare' => {
						'one' => q({0} हे.),
						'other' => q({0} हे.),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'one' => q({0} ब.फु.),
						'other' => q({0} ब.फु.),
					},
					# Core Unit Identifier
					'square-foot' => {
						'one' => q({0} ब.फु.),
						'other' => q({0} ब.फु.),
					},
					# Long Unit Identifier
					'area-square-kilometer' => {
						'one' => q({0} ब.कि.मि.),
						'other' => q({0} ब.कि.मि.),
					},
					# Core Unit Identifier
					'square-kilometer' => {
						'one' => q({0} ब.कि.मि.),
						'other' => q({0} ब.कि.मि.),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'one' => q({0} ब.मि.),
						'other' => q({0} ब.मि.),
					},
					# Core Unit Identifier
					'square-meter' => {
						'one' => q({0} ब.मि.),
						'other' => q({0} ब.मि.),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'one' => q({0} बर्ग माईल),
						'other' => q({0} बर्ग माईल),
					},
					# Core Unit Identifier
					'square-mile' => {
						'one' => q({0} बर्ग माईल),
						'other' => q({0} बर्ग माईल),
					},
					# Long Unit Identifier
					'concentr-item' => {
						'name' => q(वस्तु),
					},
					# Core Unit Identifier
					'item' => {
						'name' => q(वस्तु),
					},
					# Long Unit Identifier
					'concentr-percent' => {
						'name' => q(प्रतिशत),
						'one' => q({0}प्रतिशत),
						'other' => q({0}प्रतिशत),
					},
					# Core Unit Identifier
					'percent' => {
						'name' => q(प्रतिशत),
						'one' => q({0}प्रतिशत),
						'other' => q({0}प्रतिशत),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'name' => q(लि./१००कि.मि.),
						'one' => q({0}L/100km),
						'other' => q({0}L/100km),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'name' => q(लि./१००कि.मि.),
						'one' => q({0}L/100km),
						'other' => q({0}L/100km),
					},
					# Long Unit Identifier
					'coordinate' => {
						'east' => q({0}पूर्व),
						'north' => q({0}उत्तर),
						'south' => q({0}दक्षिण),
						'west' => q({0}पश्चिम),
					},
					# Core Unit Identifier
					'coordinate' => {
						'east' => q({0}पूर्व),
						'north' => q({0}उत्तर),
						'south' => q({0}दक्षिण),
						'west' => q({0}पश्चिम),
					},
					# Long Unit Identifier
					'duration-day' => {
						'name' => q(दिन),
						'one' => q({0} दिन),
						'other' => q({0} दिन),
					},
					# Core Unit Identifier
					'day' => {
						'name' => q(दिन),
						'one' => q({0} दिन),
						'other' => q({0} दिन),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'name' => q(घण्टा),
						'one' => q({0} घण्टा),
						'other' => q({0} घण्टा),
					},
					# Core Unit Identifier
					'hour' => {
						'name' => q(घण्टा),
						'one' => q({0} घण्टा),
						'other' => q({0} घण्टा),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'name' => q(मिली सेकेन्ड),
						'one' => q({0}मि.से.),
						'other' => q({0}मि.से.),
					},
					# Core Unit Identifier
					'millisecond' => {
						'name' => q(मिली सेकेन्ड),
						'one' => q({0}मि.से.),
						'other' => q({0}मि.से.),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'name' => q(मिनेट),
						'one' => q({0} मिनेट),
						'other' => q({0} मिनेट),
					},
					# Core Unit Identifier
					'minute' => {
						'name' => q(मिनेट),
						'one' => q({0} मिनेट),
						'other' => q({0} मिनेट),
					},
					# Long Unit Identifier
					'duration-month' => {
						'name' => q(महिना),
						'one' => q({0} महिना),
						'other' => q({0} महिना),
					},
					# Core Unit Identifier
					'month' => {
						'name' => q(महिना),
						'one' => q({0} महिना),
						'other' => q({0} महिना),
					},
					# Long Unit Identifier
					'duration-second' => {
						'name' => q(सेकेन्ड),
						'one' => q({0} सेकेन्ड),
						'other' => q({0} सेकेन्ड),
					},
					# Core Unit Identifier
					'second' => {
						'name' => q(सेकेन्ड),
						'one' => q({0} सेकेन्ड),
						'other' => q({0} सेकेन्ड),
					},
					# Long Unit Identifier
					'duration-week' => {
						'name' => q(हप्ता),
						'one' => q({0} हप्ता),
						'other' => q({0} हप्ता),
					},
					# Core Unit Identifier
					'week' => {
						'name' => q(हप्ता),
						'one' => q({0} हप्ता),
						'other' => q({0} हप्ता),
					},
					# Long Unit Identifier
					'duration-year' => {
						'name' => q(वर्ष),
						'one' => q({0} वर्ष),
						'other' => q({0} वर्ष),
					},
					# Core Unit Identifier
					'year' => {
						'name' => q(वर्ष),
						'one' => q({0} वर्ष),
						'other' => q({0} वर्ष),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'name' => q(से.मि.),
						'one' => q({0}से.मि.),
						'other' => q({0}से.मि.),
					},
					# Core Unit Identifier
					'centimeter' => {
						'name' => q(से.मि.),
						'one' => q({0}से.मि.),
						'other' => q({0}से.मि.),
					},
					# Long Unit Identifier
					'length-foot' => {
						'one' => q({0}′),
						'other' => q({0}′),
					},
					# Core Unit Identifier
					'foot' => {
						'one' => q({0}′),
						'other' => q({0}′),
					},
					# Long Unit Identifier
					'length-inch' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					# Core Unit Identifier
					'inch' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'name' => q(कि.मि.),
						'one' => q({0}कि.मि.),
						'other' => q({0}कि.मि.),
					},
					# Core Unit Identifier
					'kilometer' => {
						'name' => q(कि.मि.),
						'one' => q({0}कि.मि.),
						'other' => q({0}कि.मि.),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'one' => q({0} ly),
						'other' => q({0} ly),
					},
					# Core Unit Identifier
					'light-year' => {
						'one' => q({0} ly),
						'other' => q({0} ly),
					},
					# Long Unit Identifier
					'length-meter' => {
						'name' => q(मिटर),
						'one' => q({0} मि.),
						'other' => q({0} मि.),
					},
					# Core Unit Identifier
					'meter' => {
						'name' => q(मिटर),
						'one' => q({0} मि.),
						'other' => q({0} मि.),
					},
					# Long Unit Identifier
					'length-mile' => {
						'one' => q({0} माईल),
						'other' => q({0} माईल),
					},
					# Core Unit Identifier
					'mile' => {
						'one' => q({0} माईल),
						'other' => q({0} माईल),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'name' => q(मि.मि.),
						'one' => q({0}मि.मि.),
						'other' => q({0}मि.मि.),
					},
					# Core Unit Identifier
					'millimeter' => {
						'name' => q(मि.मि.),
						'one' => q({0}मि.मि.),
						'other' => q({0}मि.मि.),
					},
					# Long Unit Identifier
					'length-picometer' => {
						'one' => q({0} pm),
						'other' => q({0} pm),
					},
					# Core Unit Identifier
					'picometer' => {
						'one' => q({0} pm),
						'other' => q({0} pm),
					},
					# Long Unit Identifier
					'length-yard' => {
						'one' => q({0} गज),
						'other' => q({0} गज),
					},
					# Core Unit Identifier
					'yard' => {
						'one' => q({0} गज),
						'other' => q({0} गज),
					},
					# Long Unit Identifier
					'light-solar-luminosity' => {
						'one' => q({0}L☉),
						'other' => q({0} L☉),
					},
					# Core Unit Identifier
					'solar-luminosity' => {
						'one' => q({0}L☉),
						'other' => q({0} L☉),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'name' => q(ग्राम),
						'one' => q({0} ग्राम),
						'other' => q({0} ग्राम),
					},
					# Core Unit Identifier
					'gram' => {
						'name' => q(ग्राम),
						'one' => q({0} ग्राम),
						'other' => q({0} ग्राम),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'name' => q(किलो),
						'one' => q({0} किलो),
						'other' => q({0} किलो),
					},
					# Core Unit Identifier
					'kilogram' => {
						'name' => q(किलो),
						'one' => q({0} किलो),
						'other' => q({0} किलो),
					},
					# Long Unit Identifier
					'mass-ounce' => {
						'one' => q({0} आऊन्स),
						'other' => q({0} आऊन्स),
					},
					# Core Unit Identifier
					'ounce' => {
						'one' => q({0} आऊन्स),
						'other' => q({0} आऊन्स),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'one' => q({0} पाउण्ड),
						'other' => q({0} पाउण्ड),
					},
					# Core Unit Identifier
					'pound' => {
						'one' => q({0} पाउण्ड),
						'other' => q({0} पाउण्ड),
					},
					# Long Unit Identifier
					'per' => {
						'1' => q({0}प्रति {1}),
					},
					# Core Unit Identifier
					'per' => {
						'1' => q({0}प्रति {1}),
					},
					# Long Unit Identifier
					'power-horsepower' => {
						'name' => q(हर्सपावर),
						'one' => q({0} हर्सपावर),
						'other' => q({0} हर्सपावर),
					},
					# Core Unit Identifier
					'horsepower' => {
						'name' => q(हर्सपावर),
						'one' => q({0} हर्सपावर),
						'other' => q({0} हर्सपावर),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'name' => q(किलोवाट),
						'one' => q({0} किलोवाट),
						'other' => q({0} किलोवाट),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'name' => q(किलोवाट),
						'one' => q({0} किलोवाट),
						'other' => q({0} किलोवाट),
					},
					# Long Unit Identifier
					'power-watt' => {
						'one' => q({0} वाट),
						'other' => q({0} वाट),
					},
					# Core Unit Identifier
					'watt' => {
						'one' => q({0} वाट),
						'other' => q({0} वाट),
					},
					# Long Unit Identifier
					'power2' => {
						'1' => q({0}²),
						'one' => q({0}²),
						'other' => q({0}²),
					},
					# Core Unit Identifier
					'power2' => {
						'1' => q({0}²),
						'one' => q({0}²),
						'other' => q({0}²),
					},
					# Long Unit Identifier
					'pressure-hectopascal' => {
						'one' => q({0} hPa),
						'other' => q({0} hPa),
					},
					# Core Unit Identifier
					'hectopascal' => {
						'one' => q({0} hPa),
						'other' => q({0} hPa),
					},
					# Long Unit Identifier
					'pressure-inch-ofhg' => {
						'one' => q({0} ईञ्‍च पारो),
						'other' => q({0} ईञ्‍च पारो),
					},
					# Core Unit Identifier
					'inch-ofhg' => {
						'one' => q({0} ईञ्‍च पारो),
						'other' => q({0} ईञ्‍च पारो),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'one' => q({0} मिलीबार),
						'other' => q({0} मिलीबार),
					},
					# Core Unit Identifier
					'millibar' => {
						'one' => q({0} मिलीबार),
						'other' => q({0} मिलीबार),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'name' => q(किलोमिटर प्रति घण्टा),
						'one' => q({0} km/h),
						'other' => q({0} km/h),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'name' => q(किलोमिटर प्रति घण्टा),
						'one' => q({0} km/h),
						'other' => q({0} km/h),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'one' => q({0} m/s),
						'other' => q({0} m/s),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'one' => q({0} m/s),
						'other' => q({0} m/s),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'one' => q({0} mi/h),
						'other' => q({0} mi/h),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'one' => q({0} mi/h),
						'other' => q({0} mi/h),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'name' => q(°से),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Core Unit Identifier
					'celsius' => {
						'name' => q(°से),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'one' => q({0}°फ),
						'other' => q({0}°फ),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'one' => q({0}°फ),
						'other' => q({0}°फ),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'one' => q({0} km³),
						'other' => q({0} km³),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'one' => q({0} km³),
						'other' => q({0} km³),
					},
					# Long Unit Identifier
					'volume-cubic-mile' => {
						'one' => q({0} घन माईल),
						'other' => q({0} घन माईल),
					},
					# Core Unit Identifier
					'cubic-mile' => {
						'one' => q({0} घन माईल),
						'other' => q({0} घन माईल),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'name' => q(लिटर),
						'one' => q({0} लि.),
						'other' => q({0} लि.),
					},
					# Core Unit Identifier
					'liter' => {
						'name' => q(लिटर),
						'one' => q({0} लि.),
						'other' => q({0} लि.),
					},
				},
				'short' => {
					# Long Unit Identifier
					'' => {
						'name' => q(दिशा),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(दिशा),
					},
					# Long Unit Identifier
					'1024p1' => {
						'1' => q(Ki{0}),
					},
					# Core Unit Identifier
					'1024p1' => {
						'1' => q(Ki{0}),
					},
					# Long Unit Identifier
					'1024p2' => {
						'1' => q(Mi{0}),
					},
					# Core Unit Identifier
					'1024p2' => {
						'1' => q(Mi{0}),
					},
					# Long Unit Identifier
					'1024p3' => {
						'1' => q(Gi{0}),
					},
					# Core Unit Identifier
					'1024p3' => {
						'1' => q(Gi{0}),
					},
					# Long Unit Identifier
					'1024p4' => {
						'1' => q(Ti{0}),
					},
					# Core Unit Identifier
					'1024p4' => {
						'1' => q(Ti{0}),
					},
					# Long Unit Identifier
					'1024p5' => {
						'1' => q(Pi{0}),
					},
					# Core Unit Identifier
					'1024p5' => {
						'1' => q(Pi{0}),
					},
					# Long Unit Identifier
					'1024p6' => {
						'1' => q(Ei{0}),
					},
					# Core Unit Identifier
					'1024p6' => {
						'1' => q(Ei{0}),
					},
					# Long Unit Identifier
					'1024p7' => {
						'1' => q(Zi{0}),
					},
					# Core Unit Identifier
					'1024p7' => {
						'1' => q(Zi{0}),
					},
					# Long Unit Identifier
					'1024p8' => {
						'1' => q(Yi{0}),
					},
					# Core Unit Identifier
					'1024p8' => {
						'1' => q(Yi{0}),
					},
					# Long Unit Identifier
					'10p-1' => {
						'1' => q(डे.{0}),
					},
					# Core Unit Identifier
					'1' => {
						'1' => q(डे.{0}),
					},
					# Long Unit Identifier
					'10p-12' => {
						'1' => q(पि.{0}),
					},
					# Core Unit Identifier
					'12' => {
						'1' => q(पि.{0}),
					},
					# Long Unit Identifier
					'10p-15' => {
						'1' => q(फे.{0}),
					},
					# Core Unit Identifier
					'15' => {
						'1' => q(फे.{0}),
					},
					# Long Unit Identifier
					'10p-18' => {
						'1' => q(अ.{0}),
					},
					# Core Unit Identifier
					'18' => {
						'1' => q(अ.{0}),
					},
					# Long Unit Identifier
					'10p-2' => {
						'1' => q(से.{0}),
					},
					# Core Unit Identifier
					'2' => {
						'1' => q(से.{0}),
					},
					# Long Unit Identifier
					'10p-21' => {
						'1' => q(जे.{0}),
					},
					# Core Unit Identifier
					'21' => {
						'1' => q(जे.{0}),
					},
					# Long Unit Identifier
					'10p-24' => {
						'1' => q(यो.{0}),
					},
					# Core Unit Identifier
					'24' => {
						'1' => q(यो.{0}),
					},
					# Long Unit Identifier
					'10p-3' => {
						'1' => q(मि.{0}),
					},
					# Core Unit Identifier
					'3' => {
						'1' => q(मि.{0}),
					},
					# Long Unit Identifier
					'10p-6' => {
						'1' => q(मा.{0}),
					},
					# Core Unit Identifier
					'6' => {
						'1' => q(मा.{0}),
					},
					# Long Unit Identifier
					'10p-9' => {
						'1' => q(ना.{0}),
					},
					# Core Unit Identifier
					'9' => {
						'1' => q(ना.{0}),
					},
					# Long Unit Identifier
					'10p1' => {
						'1' => q(डेका{0}),
					},
					# Core Unit Identifier
					'10p1' => {
						'1' => q(डेका{0}),
					},
					# Long Unit Identifier
					'10p12' => {
						'1' => q(टे.{0}),
					},
					# Core Unit Identifier
					'10p12' => {
						'1' => q(टे.{0}),
					},
					# Long Unit Identifier
					'10p15' => {
						'1' => q(पे.{0}),
					},
					# Core Unit Identifier
					'10p15' => {
						'1' => q(पे.{0}),
					},
					# Long Unit Identifier
					'10p18' => {
						'1' => q(ए.{0}),
					},
					# Core Unit Identifier
					'10p18' => {
						'1' => q(ए.{0}),
					},
					# Long Unit Identifier
					'10p2' => {
						'1' => q(हे.{0}),
					},
					# Core Unit Identifier
					'10p2' => {
						'1' => q(हे.{0}),
					},
					# Long Unit Identifier
					'10p21' => {
						'1' => q(जेटा{0}),
					},
					# Core Unit Identifier
					'10p21' => {
						'1' => q(जेटा{0}),
					},
					# Long Unit Identifier
					'10p24' => {
						'1' => q(योटा{0}),
					},
					# Core Unit Identifier
					'10p24' => {
						'1' => q(योटा{0}),
					},
					# Long Unit Identifier
					'10p3' => {
						'1' => q(कि.{0}),
					},
					# Core Unit Identifier
					'10p3' => {
						'1' => q(कि.{0}),
					},
					# Long Unit Identifier
					'10p6' => {
						'1' => q(मे.{0}),
					},
					# Core Unit Identifier
					'10p6' => {
						'1' => q(मे.{0}),
					},
					# Long Unit Identifier
					'10p9' => {
						'1' => q(गि.{0}),
					},
					# Core Unit Identifier
					'10p9' => {
						'1' => q(गि.{0}),
					},
					# Long Unit Identifier
					'acceleration-g-force' => {
						'name' => q(गुरूत्वाकर्षण शक्ति),
						'one' => q({0} G),
						'other' => q({0} G),
					},
					# Core Unit Identifier
					'g-force' => {
						'name' => q(गुरूत्वाकर्षण शक्ति),
						'one' => q({0} G),
						'other' => q({0} G),
					},
					# Long Unit Identifier
					'acceleration-meter-per-square-second' => {
						'name' => q(m/s²),
						'one' => q({0} m/s²),
						'other' => q({0} m/s²),
					},
					# Core Unit Identifier
					'meter-per-square-second' => {
						'name' => q(m/s²),
						'one' => q({0} m/s²),
						'other' => q({0} m/s²),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'name' => q(आर्क मिनेट),
						'one' => q({0}आर्क मिनेट),
						'other' => q({0}आर्क मिनेट),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'name' => q(आर्क मिनेट),
						'one' => q({0}आर्क मिनेट),
						'other' => q({0}आर्क मिनेट),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'name' => q(आर्क सेकेन्ड),
						'one' => q({0}आर्क सेकेन्ड),
						'other' => q({0}आर्क सेकेन्ड),
					},
					# Core Unit Identifier
					'arc-second' => {
						'name' => q(आर्क सेकेन्ड),
						'one' => q({0}आर्क सेकेन्ड),
						'other' => q({0}आर्क सेकेन्ड),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'name' => q(डिग्री),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Core Unit Identifier
					'degree' => {
						'name' => q(डिग्री),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Long Unit Identifier
					'angle-radian' => {
						'name' => q(रेडियन),
						'one' => q({0} rad),
						'other' => q({0} rad),
					},
					# Core Unit Identifier
					'radian' => {
						'name' => q(रेडियन),
						'one' => q({0} rad),
						'other' => q({0} rad),
					},
					# Long Unit Identifier
					'angle-revolution' => {
						'name' => q(परिक्रमा),
						'one' => q({0}परिक्रमा),
						'other' => q({0}परिक्रमा),
					},
					# Core Unit Identifier
					'revolution' => {
						'name' => q(परिक्रमा),
						'one' => q({0}परिक्रमा),
						'other' => q({0}परिक्रमा),
					},
					# Long Unit Identifier
					'area-acre' => {
						'name' => q(वर्ग गज),
						'one' => q({0}वर्ग गज),
						'other' => q({0}वर्ग गज),
					},
					# Core Unit Identifier
					'acre' => {
						'name' => q(वर्ग गज),
						'one' => q({0}वर्ग गज),
						'other' => q({0}वर्ग गज),
					},
					# Long Unit Identifier
					'area-dunam' => {
						'name' => q(डुनाम),
						'one' => q({0} डुनाम),
						'other' => q({0} डुनाम),
					},
					# Core Unit Identifier
					'dunam' => {
						'name' => q(डुनाम),
						'one' => q({0} डुनाम),
						'other' => q({0} डुनाम),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'name' => q(हेक्टर),
						'one' => q({0} हे.),
						'other' => q({0} हे.),
					},
					# Core Unit Identifier
					'hectare' => {
						'name' => q(हेक्टर),
						'one' => q({0} हे.),
						'other' => q({0} हे.),
					},
					# Long Unit Identifier
					'area-square-centimeter' => {
						'name' => q(वर्ग सेन्टिमिटर),
						'one' => q({0} वर्ग सेन्टिमिटर),
						'other' => q({0}वर्ग सेन्टिमिटर),
						'per' => q({0}वर्ग सेन्टिमिटर),
					},
					# Core Unit Identifier
					'square-centimeter' => {
						'name' => q(वर्ग सेन्टिमिटर),
						'one' => q({0} वर्ग सेन्टिमिटर),
						'other' => q({0}वर्ग सेन्टिमिटर),
						'per' => q({0}वर्ग सेन्टिमिटर),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'name' => q(वर्ग फुट),
						'one' => q({0}वर्ग फुट),
						'other' => q({0}वर्ग फुट),
					},
					# Core Unit Identifier
					'square-foot' => {
						'name' => q(वर्ग फुट),
						'one' => q({0}वर्ग फुट),
						'other' => q({0}वर्ग फुट),
					},
					# Long Unit Identifier
					'area-square-inch' => {
						'name' => q(वर्ग इन्च),
						'one' => q({0}वर्ग इन्च),
						'other' => q({0}वर्ग इन्च),
						'per' => q({0}प्रति वर्ग इन्च),
					},
					# Core Unit Identifier
					'square-inch' => {
						'name' => q(वर्ग इन्च),
						'one' => q({0}वर्ग इन्च),
						'other' => q({0}वर्ग इन्च),
						'per' => q({0}प्रति वर्ग इन्च),
					},
					# Long Unit Identifier
					'area-square-kilometer' => {
						'name' => q(वर्ग किलोमिटर),
						'one' => q({0}वर्ग किलोमिटर),
						'other' => q({0}वर्ग किलोमिटर),
						'per' => q({0}वर्ग किलोमिटर),
					},
					# Core Unit Identifier
					'square-kilometer' => {
						'name' => q(वर्ग किलोमिटर),
						'one' => q({0}वर्ग किलोमिटर),
						'other' => q({0}वर्ग किलोमिटर),
						'per' => q({0}वर्ग किलोमिटर),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'name' => q(वर्ग मिटर),
						'one' => q({0}वर्ग मिटर),
						'other' => q({0}वर्ग मिटर),
						'per' => q({0} प्रति वर्ग मिटर),
					},
					# Core Unit Identifier
					'square-meter' => {
						'name' => q(वर्ग मिटर),
						'one' => q({0}वर्ग मिटर),
						'other' => q({0}वर्ग मिटर),
						'per' => q({0} प्रति वर्ग मिटर),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'name' => q(वर्ग माइल),
						'one' => q({0} वर्ग माइल),
						'other' => q({0}वर्ग माइल),
						'per' => q({0}प्रति वर्ग माइल),
					},
					# Core Unit Identifier
					'square-mile' => {
						'name' => q(वर्ग माइल),
						'one' => q({0} वर्ग माइल),
						'other' => q({0}वर्ग माइल),
						'per' => q({0}प्रति वर्ग माइल),
					},
					# Long Unit Identifier
					'area-square-yard' => {
						'name' => q(वर्ग यार्ड),
						'one' => q({0} yd²),
						'other' => q({0} yd²),
					},
					# Core Unit Identifier
					'square-yard' => {
						'name' => q(वर्ग यार्ड),
						'one' => q({0} yd²),
						'other' => q({0} yd²),
					},
					# Long Unit Identifier
					'concentr-item' => {
						'name' => q(वस्तु),
						'one' => q({0} वस्तु),
						'other' => q({0} वस्तु),
					},
					# Core Unit Identifier
					'item' => {
						'name' => q(वस्तु),
						'one' => q({0} वस्तु),
						'other' => q({0} वस्तु),
					},
					# Long Unit Identifier
					'concentr-karat' => {
						'name' => q(कराट),
						'one' => q({0} kt),
						'other' => q({0} kt),
					},
					# Core Unit Identifier
					'karat' => {
						'name' => q(कराट),
						'one' => q({0} kt),
						'other' => q({0} kt),
					},
					# Long Unit Identifier
					'concentr-milligram-ofglucose-per-deciliter' => {
						'name' => q(mg/dL),
						'one' => q({0} mg/dL),
						'other' => q({0} mg/dL),
					},
					# Core Unit Identifier
					'milligram-ofglucose-per-deciliter' => {
						'name' => q(mg/dL),
						'one' => q({0} mg/dL),
						'other' => q({0} mg/dL),
					},
					# Long Unit Identifier
					'concentr-millimole-per-liter' => {
						'name' => q(mmol/L),
						'one' => q({0} mmol/L),
						'other' => q({0} mmol/L),
					},
					# Core Unit Identifier
					'millimole-per-liter' => {
						'name' => q(mmol/L),
						'one' => q({0} mmol/L),
						'other' => q({0} mmol/L),
					},
					# Long Unit Identifier
					'concentr-mole' => {
						'name' => q(मोल),
						'one' => q({0} मोल),
						'other' => q({0} मोल),
					},
					# Core Unit Identifier
					'mole' => {
						'name' => q(मोल),
						'one' => q({0} मोल),
						'other' => q({0} मोल),
					},
					# Long Unit Identifier
					'concentr-percent' => {
						'name' => q(प्रतिशत),
						'one' => q({0}प्रतिशत),
						'other' => q({0}प्रतिशत),
					},
					# Core Unit Identifier
					'percent' => {
						'name' => q(प्रतिशत),
						'one' => q({0}प्रतिशत),
						'other' => q({0}प्रतिशत),
					},
					# Long Unit Identifier
					'concentr-permille' => {
						'name' => q(प्रति मिल),
						'one' => q({0}प्रति मिल),
						'other' => q({0}प्रतिशत १),
					},
					# Core Unit Identifier
					'permille' => {
						'name' => q(प्रति मिल),
						'one' => q({0}प्रति मिल),
						'other' => q({0}प्रतिशत १),
					},
					# Long Unit Identifier
					'concentr-permillion' => {
						'name' => q(ppm),
						'one' => q({0} ppm),
						'other' => q({0} ppm),
					},
					# Core Unit Identifier
					'permillion' => {
						'name' => q(ppm),
						'one' => q({0} ppm),
						'other' => q({0} ppm),
					},
					# Long Unit Identifier
					'concentr-permyriad' => {
						'name' => q(पर्माइराइड),
					},
					# Core Unit Identifier
					'permyriad' => {
						'name' => q(पर्माइराइड),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'name' => q(लि./१००कि.मि.),
						'one' => q({0}लि./१००कि.मि.),
						'other' => q({0}लि./१००कि.मि.),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'name' => q(लि./१००कि.मि.),
						'one' => q({0}लि./१००कि.मि.),
						'other' => q({0}लि./१००कि.मि.),
					},
					# Long Unit Identifier
					'consumption-liter-per-kilometer' => {
						'name' => q(लिटर/किलोमिटर),
						'one' => q({0} L/km),
						'other' => q({0} L/km),
					},
					# Core Unit Identifier
					'liter-per-kilometer' => {
						'name' => q(लिटर/किलोमिटर),
						'one' => q({0} L/km),
						'other' => q({0} L/km),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon' => {
						'name' => q(माइल प्रति ग्यालोन),
						'one' => q({0} mpg),
						'other' => q({0} mpg),
					},
					# Core Unit Identifier
					'mile-per-gallon' => {
						'name' => q(माइल प्रति ग्यालोन),
						'one' => q({0} mpg),
						'other' => q({0} mpg),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon-imperial' => {
						'name' => q(mpg Imp.),
						'one' => q({0} mpg Imp.),
						'other' => q({0} mpg Imp.),
					},
					# Core Unit Identifier
					'mile-per-gallon-imperial' => {
						'name' => q(mpg Imp.),
						'one' => q({0} mpg Imp.),
						'other' => q({0} mpg Imp.),
					},
					# Long Unit Identifier
					'coordinate' => {
						'east' => q({0}पूर्व),
						'north' => q({0}उत्तर),
						'south' => q({0}दक्षिण),
						'west' => q({0}पश्चिम),
					},
					# Core Unit Identifier
					'coordinate' => {
						'east' => q({0}पूर्व),
						'north' => q({0}उत्तर),
						'south' => q({0}दक्षिण),
						'west' => q({0}पश्चिम),
					},
					# Long Unit Identifier
					'digital-bit' => {
						'name' => q(bit),
						'one' => q({0} bit),
						'other' => q({0} bit),
					},
					# Core Unit Identifier
					'bit' => {
						'name' => q(bit),
						'one' => q({0} bit),
						'other' => q({0} bit),
					},
					# Long Unit Identifier
					'digital-byte' => {
						'name' => q(बाइट),
						'one' => q({0} byte),
						'other' => q({0} byte),
					},
					# Core Unit Identifier
					'byte' => {
						'name' => q(बाइट),
						'one' => q({0} byte),
						'other' => q({0} byte),
					},
					# Long Unit Identifier
					'digital-gigabit' => {
						'name' => q(Gb),
						'one' => q({0} Gb),
						'other' => q({0} Gb),
					},
					# Core Unit Identifier
					'gigabit' => {
						'name' => q(Gb),
						'one' => q({0} Gb),
						'other' => q({0} Gb),
					},
					# Long Unit Identifier
					'digital-gigabyte' => {
						'name' => q(GB),
						'one' => q({0} GB),
						'other' => q({0} GB),
					},
					# Core Unit Identifier
					'gigabyte' => {
						'name' => q(GB),
						'one' => q({0} GB),
						'other' => q({0} GB),
					},
					# Long Unit Identifier
					'digital-kilobit' => {
						'name' => q(kb),
						'one' => q({0} kb),
						'other' => q({0} kb),
					},
					# Core Unit Identifier
					'kilobit' => {
						'name' => q(kb),
						'one' => q({0} kb),
						'other' => q({0} kb),
					},
					# Long Unit Identifier
					'digital-kilobyte' => {
						'name' => q(kB),
						'one' => q({0} kB),
						'other' => q({0} kB),
					},
					# Core Unit Identifier
					'kilobyte' => {
						'name' => q(kB),
						'one' => q({0} kB),
						'other' => q({0} kB),
					},
					# Long Unit Identifier
					'digital-megabit' => {
						'name' => q(Mb),
						'one' => q({0} Mb),
						'other' => q({0} Mb),
					},
					# Core Unit Identifier
					'megabit' => {
						'name' => q(Mb),
						'one' => q({0} Mb),
						'other' => q({0} Mb),
					},
					# Long Unit Identifier
					'digital-megabyte' => {
						'name' => q(MB),
						'one' => q({0} MB),
						'other' => q({0} MB),
					},
					# Core Unit Identifier
					'megabyte' => {
						'name' => q(MB),
						'one' => q({0} MB),
						'other' => q({0} MB),
					},
					# Long Unit Identifier
					'digital-petabyte' => {
						'name' => q(पिटाबाइट),
						'one' => q({0} पिटा),
						'other' => q({0} पिटा),
					},
					# Core Unit Identifier
					'petabyte' => {
						'name' => q(पिटाबाइट),
						'one' => q({0} पिटा),
						'other' => q({0} पिटा),
					},
					# Long Unit Identifier
					'digital-terabit' => {
						'name' => q(Tb),
						'one' => q({0} Tb),
						'other' => q({0} Tb),
					},
					# Core Unit Identifier
					'terabit' => {
						'name' => q(Tb),
						'one' => q({0} Tb),
						'other' => q({0} Tb),
					},
					# Long Unit Identifier
					'digital-terabyte' => {
						'name' => q(TB),
						'one' => q({0} TB),
						'other' => q({0} TB),
					},
					# Core Unit Identifier
					'terabyte' => {
						'name' => q(TB),
						'one' => q({0} TB),
						'other' => q({0} TB),
					},
					# Long Unit Identifier
					'duration-century' => {
						'name' => q(शताब्दी),
						'one' => q({0} शताब्दी),
						'other' => q({0} शताब्दी),
					},
					# Core Unit Identifier
					'century' => {
						'name' => q(शताब्दी),
						'one' => q({0} शताब्दी),
						'other' => q({0} शताब्दी),
					},
					# Long Unit Identifier
					'duration-day' => {
						'name' => q(दिन),
						'one' => q({0} दिन),
						'other' => q({0} दिन),
						'per' => q({0}/दिन),
					},
					# Core Unit Identifier
					'day' => {
						'name' => q(दिन),
						'one' => q({0} दिन),
						'other' => q({0} दिन),
						'per' => q({0}/दिन),
					},
					# Long Unit Identifier
					'duration-decade' => {
						'name' => q(दशाब्दी),
						'one' => q({0} दशाब्दी),
						'other' => q({0} दशाब्दी),
					},
					# Core Unit Identifier
					'decade' => {
						'name' => q(दशाब्दी),
						'one' => q({0} दशाब्दी),
						'other' => q({0} दशाब्दी),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'name' => q(घण्टा),
						'one' => q({0} घण्टा),
						'other' => q({0} घण्टा),
						'per' => q({0}प्रति घण्टा),
					},
					# Core Unit Identifier
					'hour' => {
						'name' => q(घण्टा),
						'one' => q({0} घण्टा),
						'other' => q({0} घण्टा),
						'per' => q({0}प्रति घण्टा),
					},
					# Long Unit Identifier
					'duration-microsecond' => {
						'name' => q(माइक्रोसेकेन्ड),
						'one' => q({0} मा.से.),
						'other' => q({0} मा.से.),
					},
					# Core Unit Identifier
					'microsecond' => {
						'name' => q(माइक्रोसेकेन्ड),
						'one' => q({0} मा.से.),
						'other' => q({0} मा.से.),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'name' => q(मिली सेकेन्ड),
						'one' => q({0} मि.से.),
						'other' => q({0} मि.से.),
					},
					# Core Unit Identifier
					'millisecond' => {
						'name' => q(मिली सेकेन्ड),
						'one' => q({0} मि.से.),
						'other' => q({0} मि.से.),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'name' => q(मिनेट),
						'one' => q({0} मिनेट),
						'other' => q({0} मिनेट),
						'per' => q({0}प्रति मिनेट),
					},
					# Core Unit Identifier
					'minute' => {
						'name' => q(मिनेट),
						'one' => q({0} मिनेट),
						'other' => q({0} मिनेट),
						'per' => q({0}प्रति मिनेट),
					},
					# Long Unit Identifier
					'duration-month' => {
						'name' => q(महिना),
						'one' => q({0} महिना),
						'other' => q({0} महिना),
						'per' => q({0}/महिना),
					},
					# Core Unit Identifier
					'month' => {
						'name' => q(महिना),
						'one' => q({0} महिना),
						'other' => q({0} महिना),
						'per' => q({0}/महिना),
					},
					# Long Unit Identifier
					'duration-nanosecond' => {
						'name' => q(न्यानोसेकेन्ड),
						'one' => q({0} न.से.),
						'other' => q({0} न.से.),
					},
					# Core Unit Identifier
					'nanosecond' => {
						'name' => q(न्यानोसेकेन्ड),
						'one' => q({0} न.से.),
						'other' => q({0} न.से.),
					},
					# Long Unit Identifier
					'duration-second' => {
						'name' => q(सेकेन्ड),
						'one' => q({0} सेकेन्ड),
						'other' => q({0} सेकेन्ड),
						'per' => q({0}/सेकेन्ड),
					},
					# Core Unit Identifier
					'second' => {
						'name' => q(सेकेन्ड),
						'one' => q({0} सेकेन्ड),
						'other' => q({0} सेकेन्ड),
						'per' => q({0}/सेकेन्ड),
					},
					# Long Unit Identifier
					'duration-week' => {
						'name' => q(हप्ता),
						'one' => q({0} हप्ता),
						'other' => q({0} हप्ता),
						'per' => q({0}/हप्ता),
					},
					# Core Unit Identifier
					'week' => {
						'name' => q(हप्ता),
						'one' => q({0} हप्ता),
						'other' => q({0} हप्ता),
						'per' => q({0}/हप्ता),
					},
					# Long Unit Identifier
					'duration-year' => {
						'name' => q(वर्ष),
						'one' => q({0} वर्ष),
						'other' => q({0} वर्ष),
						'per' => q({0}/वर्ष),
					},
					# Core Unit Identifier
					'year' => {
						'name' => q(वर्ष),
						'one' => q({0} वर्ष),
						'other' => q({0} वर्ष),
						'per' => q({0}/वर्ष),
					},
					# Long Unit Identifier
					'electric-ampere' => {
						'name' => q(amp),
						'one' => q({0} A),
						'other' => q({0} A),
					},
					# Core Unit Identifier
					'ampere' => {
						'name' => q(amp),
						'one' => q({0} A),
						'other' => q({0} A),
					},
					# Long Unit Identifier
					'electric-milliampere' => {
						'name' => q(mA),
						'one' => q({0} mA),
						'other' => q({0} mA),
					},
					# Core Unit Identifier
					'milliampere' => {
						'name' => q(mA),
						'one' => q({0} mA),
						'other' => q({0} mA),
					},
					# Long Unit Identifier
					'electric-ohm' => {
						'name' => q(ohm),
						'one' => q({0} Ω),
						'other' => q({0} Ω),
					},
					# Core Unit Identifier
					'ohm' => {
						'name' => q(ohm),
						'one' => q({0} Ω),
						'other' => q({0} Ω),
					},
					# Long Unit Identifier
					'electric-volt' => {
						'name' => q(भोल्ट),
						'one' => q({0} V),
						'other' => q({0} V),
					},
					# Core Unit Identifier
					'volt' => {
						'name' => q(भोल्ट),
						'one' => q({0} V),
						'other' => q({0} V),
					},
					# Long Unit Identifier
					'energy-british-thermal-unit' => {
						'name' => q(बेलाइती तापीय एकाइ),
						'one' => q({0} बेलाइती तापीय एकाइ),
						'other' => q({0} बेलाइती तापीय एकाइ),
					},
					# Core Unit Identifier
					'british-thermal-unit' => {
						'name' => q(बेलाइती तापीय एकाइ),
						'one' => q({0} बेलाइती तापीय एकाइ),
						'other' => q({0} बेलाइती तापीय एकाइ),
					},
					# Long Unit Identifier
					'energy-calorie' => {
						'name' => q(cal),
						'one' => q({0} cal),
						'other' => q({0} cal),
					},
					# Core Unit Identifier
					'calorie' => {
						'name' => q(cal),
						'one' => q({0} cal),
						'other' => q({0} cal),
					},
					# Long Unit Identifier
					'energy-electronvolt' => {
						'name' => q(इलेक्ट्रोनभोल्ट),
						'one' => q({0} इलेक्ट्रोनभोल्ट),
						'other' => q({0} इलेक्ट्रोनभोल्ट),
					},
					# Core Unit Identifier
					'electronvolt' => {
						'name' => q(इलेक्ट्रोनभोल्ट),
						'one' => q({0} इलेक्ट्रोनभोल्ट),
						'other' => q({0} इलेक्ट्रोनभोल्ट),
					},
					# Long Unit Identifier
					'energy-foodcalorie' => {
						'name' => q(क्याल),
						'one' => q({0}क्याल),
						'other' => q({0} क्याल),
					},
					# Core Unit Identifier
					'foodcalorie' => {
						'name' => q(क्याल),
						'one' => q({0}क्याल),
						'other' => q({0} क्याल),
					},
					# Long Unit Identifier
					'energy-joule' => {
						'name' => q(जुल),
						'one' => q({0} J),
						'other' => q({0} J),
					},
					# Core Unit Identifier
					'joule' => {
						'name' => q(जुल),
						'one' => q({0} J),
						'other' => q({0} J),
					},
					# Long Unit Identifier
					'energy-kilocalorie' => {
						'name' => q(kcal),
						'one' => q({0} kcal),
						'other' => q({0} kcal),
					},
					# Core Unit Identifier
					'kilocalorie' => {
						'name' => q(kcal),
						'one' => q({0} kcal),
						'other' => q({0} kcal),
					},
					# Long Unit Identifier
					'energy-kilojoule' => {
						'name' => q(किलोजुल),
						'one' => q({0} kJ),
						'other' => q({0} kJ),
					},
					# Core Unit Identifier
					'kilojoule' => {
						'name' => q(किलोजुल),
						'one' => q({0} kJ),
						'other' => q({0} kJ),
					},
					# Long Unit Identifier
					'energy-kilowatt-hour' => {
						'name' => q(किलोवाट-घण्टा),
						'one' => q({0} kWh),
						'other' => q({0} kWh),
					},
					# Core Unit Identifier
					'kilowatt-hour' => {
						'name' => q(किलोवाट-घण्टा),
						'one' => q({0} kWh),
						'other' => q({0} kWh),
					},
					# Long Unit Identifier
					'energy-therm-us' => {
						'name' => q(युएस थर्म),
						'one' => q({0} युएस थर्म),
						'other' => q({0} युएस थर्म),
					},
					# Core Unit Identifier
					'therm-us' => {
						'name' => q(युएस थर्म),
						'one' => q({0} युएस थर्म),
						'other' => q({0} युएस थर्म),
					},
					# Long Unit Identifier
					'force-kilowatt-hour-per-100-kilometer' => {
						'name' => q(kWh/१०० किमी),
						'one' => q({0} kWh/१०० किमी),
						'other' => q({0} kWh/१०० किमी),
					},
					# Core Unit Identifier
					'kilowatt-hour-per-100-kilometer' => {
						'name' => q(kWh/१०० किमी),
						'one' => q({0} kWh/१०० किमी),
						'other' => q({0} kWh/१०० किमी),
					},
					# Long Unit Identifier
					'force-newton' => {
						'name' => q(न्युटन),
						'one' => q({0} न्युटन),
						'other' => q({0} न्युटन),
					},
					# Core Unit Identifier
					'newton' => {
						'name' => q(न्युटन),
						'one' => q({0} न्युटन),
						'other' => q({0} न्युटन),
					},
					# Long Unit Identifier
					'force-pound-force' => {
						'name' => q(पाउन्ड बल),
						'one' => q({0} पाउन्ड बल),
						'other' => q({0} पाउन्ड बल),
					},
					# Core Unit Identifier
					'pound-force' => {
						'name' => q(पाउन्ड बल),
						'one' => q({0} पाउन्ड बल),
						'other' => q({0} पाउन्ड बल),
					},
					# Long Unit Identifier
					'frequency-gigahertz' => {
						'name' => q(GHz),
						'one' => q({0} GHz),
						'other' => q({0} GHz),
					},
					# Core Unit Identifier
					'gigahertz' => {
						'name' => q(GHz),
						'one' => q({0} GHz),
						'other' => q({0} GHz),
					},
					# Long Unit Identifier
					'frequency-hertz' => {
						'name' => q(Hz),
						'one' => q({0} Hz),
						'other' => q({0} Hz),
					},
					# Core Unit Identifier
					'hertz' => {
						'name' => q(Hz),
						'one' => q({0} Hz),
						'other' => q({0} Hz),
					},
					# Long Unit Identifier
					'frequency-kilohertz' => {
						'name' => q(kHz),
						'one' => q({0} kHz),
						'other' => q({0} kHz),
					},
					# Core Unit Identifier
					'kilohertz' => {
						'name' => q(kHz),
						'one' => q({0} kHz),
						'other' => q({0} kHz),
					},
					# Long Unit Identifier
					'frequency-megahertz' => {
						'name' => q(MHz),
						'one' => q({0} MHz),
						'other' => q({0} MHz),
					},
					# Core Unit Identifier
					'megahertz' => {
						'name' => q(MHz),
						'one' => q({0} MHz),
						'other' => q({0} MHz),
					},
					# Long Unit Identifier
					'graphics-dot' => {
						'name' => q(बिन्‍दु),
						'one' => q({0} बिन्‍दु),
						'other' => q({0} बिन्‍दु),
					},
					# Core Unit Identifier
					'dot' => {
						'name' => q(बिन्‍दु),
						'one' => q({0} बिन्‍दु),
						'other' => q({0} बिन्‍दु),
					},
					# Long Unit Identifier
					'graphics-dot-per-centimeter' => {
						'name' => q(dpcm),
						'one' => q({0} ppcm),
						'other' => q({0} dpcm),
					},
					# Core Unit Identifier
					'dot-per-centimeter' => {
						'name' => q(dpcm),
						'one' => q({0} ppcm),
						'other' => q({0} dpcm),
					},
					# Long Unit Identifier
					'graphics-dot-per-inch' => {
						'name' => q(dpi),
						'one' => q({0} ppi),
						'other' => q({0} dpi),
					},
					# Core Unit Identifier
					'dot-per-inch' => {
						'name' => q(dpi),
						'one' => q({0} ppi),
						'other' => q({0} dpi),
					},
					# Long Unit Identifier
					'graphics-em' => {
						'name' => q(em),
						'one' => q({0} em),
						'other' => q({0} em),
					},
					# Core Unit Identifier
					'em' => {
						'name' => q(em),
						'one' => q({0} em),
						'other' => q({0} em),
					},
					# Long Unit Identifier
					'graphics-megapixel' => {
						'name' => q(मेगापिक्सेल),
						'one' => q({0} MP),
						'other' => q({0} MP),
					},
					# Core Unit Identifier
					'megapixel' => {
						'name' => q(मेगापिक्सेल),
						'one' => q({0} MP),
						'other' => q({0} MP),
					},
					# Long Unit Identifier
					'graphics-pixel' => {
						'name' => q(पिक्सेल),
						'one' => q({0} px),
						'other' => q({0} px),
					},
					# Core Unit Identifier
					'pixel' => {
						'name' => q(पिक्सेल),
						'one' => q({0} px),
						'other' => q({0} px),
					},
					# Long Unit Identifier
					'graphics-pixel-per-centimeter' => {
						'name' => q(ppcm),
						'one' => q({0} ppcm),
						'other' => q({0} ppcm),
					},
					# Core Unit Identifier
					'pixel-per-centimeter' => {
						'name' => q(ppcm),
						'one' => q({0} ppcm),
						'other' => q({0} ppcm),
					},
					# Long Unit Identifier
					'graphics-pixel-per-inch' => {
						'name' => q(ppi),
						'one' => q({0} ppi),
						'other' => q({0} ppi),
					},
					# Core Unit Identifier
					'pixel-per-inch' => {
						'name' => q(ppi),
						'one' => q({0} ppi),
						'other' => q({0} ppi),
					},
					# Long Unit Identifier
					'length-astronomical-unit' => {
						'name' => q(au),
						'one' => q({0} au),
						'other' => q({0} au),
					},
					# Core Unit Identifier
					'astronomical-unit' => {
						'name' => q(au),
						'one' => q({0} au),
						'other' => q({0} au),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'name' => q(से.मि.),
						'one' => q({0}से.मि.),
						'other' => q({0}से.मि.),
						'per' => q({0}प्रति से.मि.),
					},
					# Core Unit Identifier
					'centimeter' => {
						'name' => q(से.मि.),
						'one' => q({0}से.मि.),
						'other' => q({0}से.मि.),
						'per' => q({0}प्रति से.मि.),
					},
					# Long Unit Identifier
					'length-decimeter' => {
						'name' => q(dm),
						'one' => q({0} dm),
						'other' => q({0} dm),
					},
					# Core Unit Identifier
					'decimeter' => {
						'name' => q(dm),
						'one' => q({0} dm),
						'other' => q({0} dm),
					},
					# Long Unit Identifier
					'length-earth-radius' => {
						'name' => q(R⊕),
						'one' => q({0} R⊕),
						'other' => q({0} R⊕),
					},
					# Core Unit Identifier
					'earth-radius' => {
						'name' => q(R⊕),
						'one' => q({0} R⊕),
						'other' => q({0} R⊕),
					},
					# Long Unit Identifier
					'length-fathom' => {
						'name' => q(फ्यादम),
						'one' => q({0} fth),
						'other' => q({0} fth),
					},
					# Core Unit Identifier
					'fathom' => {
						'name' => q(फ्यादम),
						'one' => q({0} fth),
						'other' => q({0} fth),
					},
					# Long Unit Identifier
					'length-foot' => {
						'name' => q(फिट),
						'one' => q({0}फिट),
						'other' => q({0}फिट),
						'per' => q({0}प्रति फिट),
					},
					# Core Unit Identifier
					'foot' => {
						'name' => q(फिट),
						'one' => q({0}फिट),
						'other' => q({0}फिट),
						'per' => q({0}प्रति फिट),
					},
					# Long Unit Identifier
					'length-furlong' => {
						'name' => q(फर्लंग),
						'one' => q({0} फर),
						'other' => q({0} fur),
					},
					# Core Unit Identifier
					'furlong' => {
						'name' => q(फर्लंग),
						'one' => q({0} फर),
						'other' => q({0} fur),
					},
					# Long Unit Identifier
					'length-inch' => {
						'name' => q(इन्च),
						'one' => q(इन्च),
						'other' => q({0}इन्च),
						'per' => q({0}प्रति इन्च),
					},
					# Core Unit Identifier
					'inch' => {
						'name' => q(इन्च),
						'one' => q(इन्च),
						'other' => q({0}इन्च),
						'per' => q({0}प्रति इन्च),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'name' => q(कि.मि.),
						'one' => q({0}कि.मि.),
						'other' => q({0}कि.मि.),
						'per' => q({0} प्रति कि.मि.),
					},
					# Core Unit Identifier
					'kilometer' => {
						'name' => q(कि.मि.),
						'one' => q({0}कि.मि.),
						'other' => q({0}कि.मि.),
						'per' => q({0} प्रति कि.मि.),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'name' => q(प्रकाश वर्ष),
						'one' => q({0} ly),
						'other' => q({0} ly),
					},
					# Core Unit Identifier
					'light-year' => {
						'name' => q(प्रकाश वर्ष),
						'one' => q({0} ly),
						'other' => q({0} ly),
					},
					# Long Unit Identifier
					'length-meter' => {
						'name' => q(मिटर),
						'one' => q({0} मि.),
						'other' => q({0} मि.),
						'per' => q({0} प्रति मिटर),
					},
					# Core Unit Identifier
					'meter' => {
						'name' => q(मिटर),
						'one' => q({0} मि.),
						'other' => q({0} मि.),
						'per' => q({0} प्रति मिटर),
					},
					# Long Unit Identifier
					'length-micrometer' => {
						'name' => q(μm),
						'one' => q({0} μm),
						'other' => q({0} μm),
					},
					# Core Unit Identifier
					'micrometer' => {
						'name' => q(μm),
						'one' => q({0} μm),
						'other' => q({0} μm),
					},
					# Long Unit Identifier
					'length-mile' => {
						'name' => q(माइल),
						'one' => q({0} माइल),
						'other' => q({0} माइल),
					},
					# Core Unit Identifier
					'mile' => {
						'name' => q(माइल),
						'one' => q({0} माइल),
						'other' => q({0} माइल),
					},
					# Long Unit Identifier
					'length-mile-scandinavian' => {
						'name' => q(smi),
						'one' => q({0} smi),
						'other' => q({0} smi),
					},
					# Core Unit Identifier
					'mile-scandinavian' => {
						'name' => q(smi),
						'one' => q({0} smi),
						'other' => q({0} smi),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'name' => q(मि.मि.),
						'one' => q(मि.मि.),
						'other' => q({0}मि.मि.),
					},
					# Core Unit Identifier
					'millimeter' => {
						'name' => q(मि.मि.),
						'one' => q(मि.मि.),
						'other' => q({0}मि.मि.),
					},
					# Long Unit Identifier
					'length-nanometer' => {
						'name' => q(nm),
						'one' => q({0} nm),
						'other' => q({0} nm),
					},
					# Core Unit Identifier
					'nanometer' => {
						'name' => q(nm),
						'one' => q({0} nm),
						'other' => q({0} nm),
					},
					# Long Unit Identifier
					'length-nautical-mile' => {
						'name' => q(nmi),
						'one' => q({0} nmi),
						'other' => q({0} nmi),
					},
					# Core Unit Identifier
					'nautical-mile' => {
						'name' => q(nmi),
						'one' => q({0} nmi),
						'other' => q({0} nmi),
					},
					# Long Unit Identifier
					'length-parsec' => {
						'name' => q(पारसेकेन्ड),
						'one' => q({0} pc),
						'other' => q({0} pc),
					},
					# Core Unit Identifier
					'parsec' => {
						'name' => q(पारसेकेन्ड),
						'one' => q({0} pc),
						'other' => q({0} pc),
					},
					# Long Unit Identifier
					'length-picometer' => {
						'name' => q(पिकोमिटर),
						'one' => q({0}पिकोमिटर),
						'other' => q({0}पिकोमिटर),
					},
					# Core Unit Identifier
					'picometer' => {
						'name' => q(पिकोमिटर),
						'one' => q({0}पिकोमिटर),
						'other' => q({0}पिकोमिटर),
					},
					# Long Unit Identifier
					'length-point' => {
						'name' => q(pt),
						'one' => q({0} pt),
						'other' => q({0} pt),
					},
					# Core Unit Identifier
					'point' => {
						'name' => q(pt),
						'one' => q({0} pt),
						'other' => q({0} pt),
					},
					# Long Unit Identifier
					'length-solar-radius' => {
						'name' => q(सौर्य रेडिआई),
					},
					# Core Unit Identifier
					'solar-radius' => {
						'name' => q(सौर्य रेडिआई),
					},
					# Long Unit Identifier
					'length-yard' => {
						'name' => q(गज),
						'one' => q({0} गज),
						'other' => q({0} गज),
					},
					# Core Unit Identifier
					'yard' => {
						'name' => q(गज),
						'one' => q({0} गज),
						'other' => q({0} गज),
					},
					# Long Unit Identifier
					'light-candela' => {
						'name' => q(cd),
						'one' => q({0} cd),
						'other' => q({0} cd),
					},
					# Core Unit Identifier
					'candela' => {
						'name' => q(cd),
						'one' => q({0} cd),
						'other' => q({0} cd),
					},
					# Long Unit Identifier
					'light-lumen' => {
						'name' => q(lm),
						'one' => q({0} lm),
						'other' => q({0} lm),
					},
					# Core Unit Identifier
					'lumen' => {
						'name' => q(lm),
						'one' => q({0} lm),
						'other' => q({0} lm),
					},
					# Long Unit Identifier
					'light-lux' => {
						'name' => q(लक्स),
						'one' => q({0} lx),
						'other' => q({0} lx),
					},
					# Core Unit Identifier
					'lux' => {
						'name' => q(लक्स),
						'one' => q({0} lx),
						'other' => q({0} lx),
					},
					# Long Unit Identifier
					'light-solar-luminosity' => {
						'name' => q(सौर्य प्रकाश),
					},
					# Core Unit Identifier
					'solar-luminosity' => {
						'name' => q(सौर्य प्रकाश),
					},
					# Long Unit Identifier
					'mass-carat' => {
						'name' => q(कराट),
						'one' => q({0} CD),
						'other' => q({0} CD),
					},
					# Core Unit Identifier
					'carat' => {
						'name' => q(कराट),
						'one' => q({0} CD),
						'other' => q({0} CD),
					},
					# Long Unit Identifier
					'mass-dalton' => {
						'name' => q(डाल्टन),
						'one' => q({0} डाल्टन),
						'other' => q({0} डाल्टन),
					},
					# Core Unit Identifier
					'dalton' => {
						'name' => q(डाल्टन),
						'one' => q({0} डाल्टन),
						'other' => q({0} डाल्टन),
					},
					# Long Unit Identifier
					'mass-earth-mass' => {
						'name' => q(पृथ्वी घन),
						'one' => q({0} M⊕),
						'other' => q({0} M⊕),
					},
					# Core Unit Identifier
					'earth-mass' => {
						'name' => q(पृथ्वी घन),
						'one' => q({0} M⊕),
						'other' => q({0} M⊕),
					},
					# Long Unit Identifier
					'mass-grain' => {
						'name' => q(दाना),
						'one' => q({0} दाना),
						'other' => q({0} दाना),
					},
					# Core Unit Identifier
					'grain' => {
						'name' => q(दाना),
						'one' => q({0} दाना),
						'other' => q({0} दाना),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'name' => q(ग्राम),
						'one' => q({0} ग्राम),
						'other' => q({0} ग्राम),
						'per' => q({0}प्रति ग्राम),
					},
					# Core Unit Identifier
					'gram' => {
						'name' => q(ग्राम),
						'one' => q({0} ग्राम),
						'other' => q({0} ग्राम),
						'per' => q({0}प्रति ग्राम),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'name' => q(किलोग्राम),
						'one' => q({0} किलो),
						'other' => q({0} किलो),
						'per' => q({0}प्रति किलो),
					},
					# Core Unit Identifier
					'kilogram' => {
						'name' => q(किलोग्राम),
						'one' => q({0} किलो),
						'other' => q({0} किलो),
						'per' => q({0}प्रति किलो),
					},
					# Long Unit Identifier
					'mass-metric-ton' => {
						'name' => q(t),
						'one' => q({0} t),
						'other' => q({0} t),
					},
					# Core Unit Identifier
					'metric-ton' => {
						'name' => q(t),
						'one' => q({0} t),
						'other' => q({0} t),
					},
					# Long Unit Identifier
					'mass-microgram' => {
						'name' => q(μg),
						'one' => q({0} μg),
						'other' => q({0} μg),
					},
					# Core Unit Identifier
					'microgram' => {
						'name' => q(μg),
						'one' => q({0} μg),
						'other' => q({0} μg),
					},
					# Long Unit Identifier
					'mass-milligram' => {
						'name' => q(मिलिग्राम),
						'one' => q({0}मिलिग्राम),
						'other' => q({0}मिलिग्राम),
					},
					# Core Unit Identifier
					'milligram' => {
						'name' => q(मिलिग्राम),
						'one' => q({0}मिलिग्राम),
						'other' => q({0}मिलिग्राम),
					},
					# Long Unit Identifier
					'mass-ounce' => {
						'name' => q(आउन्स),
						'one' => q({0} आउन्स),
						'other' => q({0} आउन्स),
						'per' => q({0}प्रति आउन्स),
					},
					# Core Unit Identifier
					'ounce' => {
						'name' => q(आउन्स),
						'one' => q({0} आउन्स),
						'other' => q({0} आउन्स),
						'per' => q({0}प्रति आउन्स),
					},
					# Long Unit Identifier
					'mass-ounce-troy' => {
						'name' => q(ओज ट्रोय),
						'one' => q({0} oz t),
						'other' => q({0} oz t),
					},
					# Core Unit Identifier
					'ounce-troy' => {
						'name' => q(ओज ट्रोय),
						'one' => q({0} oz t),
						'other' => q({0} oz t),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'name' => q(पाउन्ड),
						'one' => q({0}पाउन्ड),
						'other' => q({0}पाउन्ड),
						'per' => q({0}प्रति पाउन्ड),
					},
					# Core Unit Identifier
					'pound' => {
						'name' => q(पाउन्ड),
						'one' => q({0}पाउन्ड),
						'other' => q({0}पाउन्ड),
						'per' => q({0}प्रति पाउन्ड),
					},
					# Long Unit Identifier
					'mass-solar-mass' => {
						'name' => q(सौर्य घन),
					},
					# Core Unit Identifier
					'solar-mass' => {
						'name' => q(सौर्य घन),
					},
					# Long Unit Identifier
					'mass-stone' => {
						'name' => q(स्टोन),
						'one' => q({0} st),
						'other' => q({0} st),
					},
					# Core Unit Identifier
					'stone' => {
						'name' => q(स्टोन),
						'one' => q({0} st),
						'other' => q({0} st),
					},
					# Long Unit Identifier
					'mass-ton' => {
						'name' => q(टन),
						'one' => q({0}टन),
						'other' => q({0}टन),
					},
					# Core Unit Identifier
					'ton' => {
						'name' => q(टन),
						'one' => q({0}टन),
						'other' => q({0}टन),
					},
					# Long Unit Identifier
					'per' => {
						'1' => q({0}प्रति {1}),
					},
					# Core Unit Identifier
					'per' => {
						'1' => q({0}प्रति {1}),
					},
					# Long Unit Identifier
					'power-gigawatt' => {
						'name' => q(GW),
						'one' => q({0} GW),
						'other' => q({0} GW),
					},
					# Core Unit Identifier
					'gigawatt' => {
						'name' => q(GW),
						'one' => q({0} GW),
						'other' => q({0} GW),
					},
					# Long Unit Identifier
					'power-horsepower' => {
						'name' => q(हर्सपावर),
						'one' => q({0} हर्सपावर),
						'other' => q({0} हर्सपावर),
					},
					# Core Unit Identifier
					'horsepower' => {
						'name' => q(हर्सपावर),
						'one' => q({0} हर्सपावर),
						'other' => q({0} हर्सपावर),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'name' => q(किलोवाट),
						'one' => q({0} किलोवाट),
						'other' => q({0} किलोवाट),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'name' => q(किलोवाट),
						'one' => q({0} किलोवाट),
						'other' => q({0} किलोवाट),
					},
					# Long Unit Identifier
					'power-megawatt' => {
						'name' => q(मेगावाट),
						'one' => q({0} MW),
						'other' => q({0} MW),
					},
					# Core Unit Identifier
					'megawatt' => {
						'name' => q(मेगावाट),
						'one' => q({0} MW),
						'other' => q({0} MW),
					},
					# Long Unit Identifier
					'power-milliwatt' => {
						'name' => q(मिलिवाट),
						'one' => q({0} mW),
						'other' => q({0} mW),
					},
					# Core Unit Identifier
					'milliwatt' => {
						'name' => q(मिलिवाट),
						'one' => q({0} mW),
						'other' => q({0} mW),
					},
					# Long Unit Identifier
					'power-watt' => {
						'name' => q(वाट),
						'one' => q({0} वाट),
						'other' => q({0} वाट),
					},
					# Core Unit Identifier
					'watt' => {
						'name' => q(वाट),
						'one' => q({0} वाट),
						'other' => q({0} वाट),
					},
					# Long Unit Identifier
					'power2' => {
						'1' => q({0}²),
						'one' => q({0}²),
						'other' => q({0}²),
					},
					# Core Unit Identifier
					'power2' => {
						'1' => q({0}²),
						'one' => q({0}²),
						'other' => q({0}²),
					},
					# Long Unit Identifier
					'pressure-atmosphere' => {
						'name' => q(वायु),
						'one' => q({0} वायु),
						'other' => q({0} वायु),
					},
					# Core Unit Identifier
					'atmosphere' => {
						'name' => q(वायु),
						'one' => q({0} वायु),
						'other' => q({0} वायु),
					},
					# Long Unit Identifier
					'pressure-bar' => {
						'name' => q(धर्का),
						'one' => q({0} धर्का),
						'other' => q({0} धर्का),
					},
					# Core Unit Identifier
					'bar' => {
						'name' => q(धर्का),
						'one' => q({0} धर्का),
						'other' => q({0} धर्का),
					},
					# Long Unit Identifier
					'pressure-hectopascal' => {
						'name' => q(हेक्टो पास्कल),
						'one' => q({0}hPa),
						'other' => q({0} hPa),
					},
					# Core Unit Identifier
					'hectopascal' => {
						'name' => q(हेक्टो पास्कल),
						'one' => q({0}hPa),
						'other' => q({0} hPa),
					},
					# Long Unit Identifier
					'pressure-inch-ofhg' => {
						'name' => q(इन्च पारो),
						'one' => q({0} इन्च पारो),
						'other' => q({0} इन्च पारो),
					},
					# Core Unit Identifier
					'inch-ofhg' => {
						'name' => q(इन्च पारो),
						'one' => q({0} इन्च पारो),
						'other' => q({0} इन्च पारो),
					},
					# Long Unit Identifier
					'pressure-kilopascal' => {
						'name' => q(किलोपास्कल),
						'one' => q({0} किलोपास्कल),
						'other' => q({0} किलोपास्कल),
					},
					# Core Unit Identifier
					'kilopascal' => {
						'name' => q(किलोपास्कल),
						'one' => q({0} किलोपास्कल),
						'other' => q({0} किलोपास्कल),
					},
					# Long Unit Identifier
					'pressure-megapascal' => {
						'name' => q(मेघापास्कल),
						'one' => q(मेघापास्कल),
						'other' => q({0} मेघापास्कल),
					},
					# Core Unit Identifier
					'megapascal' => {
						'name' => q(मेघापास्कल),
						'one' => q(मेघापास्कल),
						'other' => q({0} मेघापास्कल),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'name' => q(मिलिबार),
						'one' => q({0} मिलिबार),
						'other' => q({0} मिलिबार),
					},
					# Core Unit Identifier
					'millibar' => {
						'name' => q(मिलिबार),
						'one' => q({0} मिलिबार),
						'other' => q({0} मिलिबार),
					},
					# Long Unit Identifier
					'pressure-millimeter-ofhg' => {
						'name' => q(mm Hg),
						'one' => q({0} mm Hg),
						'other' => q({0} mm Hg),
					},
					# Core Unit Identifier
					'millimeter-ofhg' => {
						'name' => q(mm Hg),
						'one' => q({0} mm Hg),
						'other' => q({0} mm Hg),
					},
					# Long Unit Identifier
					'pressure-pascal' => {
						'name' => q(Pa),
						'one' => q({0} Pa),
						'other' => q({0} Pa),
					},
					# Core Unit Identifier
					'pascal' => {
						'name' => q(Pa),
						'one' => q({0} Pa),
						'other' => q({0} Pa),
					},
					# Long Unit Identifier
					'pressure-pound-force-per-square-inch' => {
						'name' => q(psi),
						'one' => q({0} psi),
						'other' => q({0} psi),
					},
					# Core Unit Identifier
					'pound-force-per-square-inch' => {
						'name' => q(psi),
						'one' => q({0} psi),
						'other' => q({0} psi),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'name' => q(किलोमिटर प्रति घण्टा),
						'one' => q({0} kph),
						'other' => q({0} kph),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'name' => q(किलोमिटर प्रति घण्टा),
						'one' => q({0} kph),
						'other' => q({0} kph),
					},
					# Long Unit Identifier
					'speed-knot' => {
						'name' => q(kn),
						'one' => q({0} kn),
						'other' => q({0} kn),
					},
					# Core Unit Identifier
					'knot' => {
						'name' => q(kn),
						'one' => q({0} kn),
						'other' => q({0} kn),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'name' => q(मिटर प्रति सेकेण्ड),
						'one' => q({0} m/s),
						'other' => q({0} m/s),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'name' => q(मिटर प्रति सेकेण्ड),
						'one' => q({0} m/s),
						'other' => q({0} m/s),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'name' => q(माइल प्रति घण्टा),
						'one' => q({0} mph),
						'other' => q({0} mph),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'name' => q(माइल प्रति घण्टा),
						'one' => q({0} mph),
						'other' => q({0} mph),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'name' => q(डिग्री सेल्सियस्),
						'one' => q({0}°से),
						'other' => q({0}°से),
					},
					# Core Unit Identifier
					'celsius' => {
						'name' => q(डिग्री सेल्सियस्),
						'one' => q({0}°से),
						'other' => q({0}°से),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'name' => q(डिग्री फरेनहाइट),
						'one' => q({0}°फ),
						'other' => q({0}°फ),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'name' => q(डिग्री फरेनहाइट),
						'one' => q({0}°फ),
						'other' => q({0}°फ),
					},
					# Long Unit Identifier
					'temperature-generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Core Unit Identifier
					'generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Long Unit Identifier
					'temperature-kelvin' => {
						'name' => q(K),
						'one' => q({0} K),
						'other' => q({0} K),
					},
					# Core Unit Identifier
					'kelvin' => {
						'name' => q(K),
						'one' => q({0} K),
						'other' => q({0} K),
					},
					# Long Unit Identifier
					'times' => {
						'1' => q({0}⋅{1}),
					},
					# Core Unit Identifier
					'times' => {
						'1' => q({0}⋅{1}),
					},
					# Long Unit Identifier
					'torque-newton-meter' => {
						'name' => q(न्युटन मिटर),
						'one' => q({0} न्युटन मिटर),
						'other' => q({0} न्युटन मिटर),
					},
					# Core Unit Identifier
					'newton-meter' => {
						'name' => q(न्युटन मिटर),
						'one' => q({0} न्युटन मिटर),
						'other' => q({0} न्युटन मिटर),
					},
					# Long Unit Identifier
					'volume-acre-foot' => {
						'name' => q(वर्ग गज फिट),
						'one' => q({0}वर्ग गज फिट),
						'other' => q({0}वर्ग गज फिट),
					},
					# Core Unit Identifier
					'acre-foot' => {
						'name' => q(वर्ग गज फिट),
						'one' => q({0}वर्ग गज फिट),
						'other' => q({0}वर्ग गज फिट),
					},
					# Long Unit Identifier
					'volume-barrel' => {
						'name' => q(ब्यारल),
						'one' => q({0} ब्यारल),
						'other' => q({0} ब्यारल),
					},
					# Core Unit Identifier
					'barrel' => {
						'name' => q(ब्यारल),
						'one' => q({0} ब्यारल),
						'other' => q({0} ब्यारल),
					},
					# Long Unit Identifier
					'volume-bushel' => {
						'name' => q(बुशेल),
						'one' => q({0} bu),
						'other' => q({0} bu),
					},
					# Core Unit Identifier
					'bushel' => {
						'name' => q(बुशेल),
						'one' => q({0} bu),
						'other' => q({0} bu),
					},
					# Long Unit Identifier
					'volume-centiliter' => {
						'name' => q(cL),
						'one' => q({0} cL),
						'other' => q({0} cL),
					},
					# Core Unit Identifier
					'centiliter' => {
						'name' => q(cL),
						'one' => q({0} cL),
						'other' => q({0} cL),
					},
					# Long Unit Identifier
					'volume-cubic-centimeter' => {
						'name' => q(घन से.मि.),
						'one' => q({0}घन से.मि.),
						'other' => q({0}घन से.मि.),
						'per' => q({0}प्रति घन से.मि.),
					},
					# Core Unit Identifier
					'cubic-centimeter' => {
						'name' => q(घन से.मि.),
						'one' => q({0}घन से.मि.),
						'other' => q({0}घन से.मि.),
						'per' => q({0}प्रति घन से.मि.),
					},
					# Long Unit Identifier
					'volume-cubic-foot' => {
						'name' => q(घन फिट),
						'one' => q({0}घन फिट),
						'other' => q({0}घन फिट),
					},
					# Core Unit Identifier
					'cubic-foot' => {
						'name' => q(घन फिट),
						'one' => q({0}घन फिट),
						'other' => q({0}घन फिट),
					},
					# Long Unit Identifier
					'volume-cubic-inch' => {
						'name' => q(घन इन्च),
						'one' => q({0}घन इन्च),
						'other' => q({0}घन इन्च),
					},
					# Core Unit Identifier
					'cubic-inch' => {
						'name' => q(घन इन्च),
						'one' => q({0}घन इन्च),
						'other' => q({0}घन इन्च),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'name' => q(घन किलोमिटर),
						'one' => q({0}घन कि.मि.),
						'other' => q({0}घन कि.मि.),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'name' => q(घन किलोमिटर),
						'one' => q({0}घन कि.मि.),
						'other' => q({0}घन कि.मि.),
					},
					# Long Unit Identifier
					'volume-cubic-meter' => {
						'name' => q(घन मिटर),
						'one' => q({0}घन मि.),
						'other' => q({0}घन मि.),
						'per' => q({0}प्रति घन मि.),
					},
					# Core Unit Identifier
					'cubic-meter' => {
						'name' => q(घन मिटर),
						'one' => q({0}घन मि.),
						'other' => q({0}घन मि.),
						'per' => q({0}प्रति घन मि.),
					},
					# Long Unit Identifier
					'volume-cubic-mile' => {
						'name' => q(घन माइल),
						'one' => q({0} घन माइल),
						'other' => q({0} घन माइल),
					},
					# Core Unit Identifier
					'cubic-mile' => {
						'name' => q(घन माइल),
						'one' => q({0} घन माइल),
						'other' => q({0} घन माइल),
					},
					# Long Unit Identifier
					'volume-cubic-yard' => {
						'name' => q(घन यार्ड),
						'one' => q({0}घन यार्ड),
						'other' => q({0}घन यार्ड),
					},
					# Core Unit Identifier
					'cubic-yard' => {
						'name' => q(घन यार्ड),
						'one' => q({0}घन यार्ड),
						'other' => q({0}घन यार्ड),
					},
					# Long Unit Identifier
					'volume-cup' => {
						'name' => q(कप्स),
						'one' => q({0} c),
						'other' => q({0} c),
					},
					# Core Unit Identifier
					'cup' => {
						'name' => q(कप्स),
						'one' => q({0} c),
						'other' => q({0} c),
					},
					# Long Unit Identifier
					'volume-cup-metric' => {
						'name' => q(mcup),
						'one' => q({0}mc),
						'other' => q({0} mc),
					},
					# Core Unit Identifier
					'cup-metric' => {
						'name' => q(mcup),
						'one' => q({0}mc),
						'other' => q({0} mc),
					},
					# Long Unit Identifier
					'volume-deciliter' => {
						'name' => q(dL),
						'one' => q({0} dL),
						'other' => q({0} dL),
					},
					# Core Unit Identifier
					'deciliter' => {
						'name' => q(dL),
						'one' => q({0} dL),
						'other' => q({0} dL),
					},
					# Long Unit Identifier
					'volume-dessert-spoon' => {
						'name' => q(dstspn),
						'one' => q({0} dstspn),
						'other' => q({0} dstspn),
					},
					# Core Unit Identifier
					'dessert-spoon' => {
						'name' => q(dstspn),
						'one' => q({0} dstspn),
						'other' => q({0} dstspn),
					},
					# Long Unit Identifier
					'volume-dessert-spoon-imperial' => {
						'name' => q(dstspn Imp),
						'one' => q({0} dstspn Imp),
						'other' => q({0} dstspn Imp),
					},
					# Core Unit Identifier
					'dessert-spoon-imperial' => {
						'name' => q(dstspn Imp),
						'one' => q({0} dstspn Imp),
						'other' => q({0} dstspn Imp),
					},
					# Long Unit Identifier
					'volume-dram' => {
						'name' => q(ड्राम तरल पदार्थ),
						'one' => q({0} ड्राम तरल),
						'other' => q({0} ड्राम fl),
					},
					# Core Unit Identifier
					'dram' => {
						'name' => q(ड्राम तरल पदार्थ),
						'one' => q({0} ड्राम तरल),
						'other' => q({0} ड्राम fl),
					},
					# Long Unit Identifier
					'volume-drop' => {
						'name' => q(थोपा),
						'one' => q({0} थोपा),
						'other' => q({0} थोपा),
					},
					# Core Unit Identifier
					'drop' => {
						'name' => q(थोपा),
						'one' => q({0} थोपा),
						'other' => q({0} थोपा),
					},
					# Long Unit Identifier
					'volume-fluid-ounce' => {
						'name' => q(fl oz),
						'one' => q({0} fl oz),
						'other' => q({0} fl oz),
					},
					# Core Unit Identifier
					'fluid-ounce' => {
						'name' => q(fl oz),
						'one' => q({0} fl oz),
						'other' => q({0} fl oz),
					},
					# Long Unit Identifier
					'volume-gallon' => {
						'name' => q(ग्यालोन),
						'one' => q({0}ग्यालोन),
						'other' => q({0}ग्यालोन),
						'per' => q({0}प्रति ग्यालोन),
					},
					# Core Unit Identifier
					'gallon' => {
						'name' => q(ग्यालोन),
						'one' => q({0}ग्यालोन),
						'other' => q({0}ग्यालोन),
						'per' => q({0}प्रति ग्यालोन),
					},
					# Long Unit Identifier
					'volume-gallon-imperial' => {
						'name' => q(Imp. gal),
						'one' => q({0} gal Imp.),
						'other' => q({0} gal Imp.),
						'per' => q({0}/gal Imp.),
					},
					# Core Unit Identifier
					'gallon-imperial' => {
						'name' => q(Imp. gal),
						'one' => q({0} gal Imp.),
						'other' => q({0} gal Imp.),
						'per' => q({0}/gal Imp.),
					},
					# Long Unit Identifier
					'volume-hectoliter' => {
						'name' => q(hL),
						'one' => q({0} hL),
						'other' => q({0} hL),
					},
					# Core Unit Identifier
					'hectoliter' => {
						'name' => q(hL),
						'one' => q({0} hL),
						'other' => q({0} hL),
					},
					# Long Unit Identifier
					'volume-jigger' => {
						'name' => q(जिगर),
						'one' => q({0} जिगर),
						'other' => q({0} जिगर),
					},
					# Core Unit Identifier
					'jigger' => {
						'name' => q(जिगर),
						'one' => q({0} जिगर),
						'other' => q({0} जिगर),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'name' => q(लिटर),
						'one' => q({0} लि.),
						'other' => q({0} लि.),
						'per' => q({0} प्रति लिटर),
					},
					# Core Unit Identifier
					'liter' => {
						'name' => q(लिटर),
						'one' => q({0} लि.),
						'other' => q({0} लि.),
						'per' => q({0} प्रति लिटर),
					},
					# Long Unit Identifier
					'volume-megaliter' => {
						'name' => q(ML),
						'one' => q({0} ML),
						'other' => q({0} ML),
					},
					# Core Unit Identifier
					'megaliter' => {
						'name' => q(ML),
						'one' => q({0} ML),
						'other' => q({0} ML),
					},
					# Long Unit Identifier
					'volume-milliliter' => {
						'name' => q(mL),
						'one' => q({0} mL),
						'other' => q({0} mL),
					},
					# Core Unit Identifier
					'milliliter' => {
						'name' => q(mL),
						'one' => q({0} mL),
						'other' => q({0} mL),
					},
					# Long Unit Identifier
					'volume-pinch' => {
						'name' => q(चुटकी),
						'one' => q({0} चुटकी),
						'other' => q({0} चुटकी),
					},
					# Core Unit Identifier
					'pinch' => {
						'name' => q(चुटकी),
						'one' => q({0} चुटकी),
						'other' => q({0} चुटकी),
					},
					# Long Unit Identifier
					'volume-pint' => {
						'name' => q(पिन्ट),
						'one' => q({0} pt),
						'other' => q({0} pt),
					},
					# Core Unit Identifier
					'pint' => {
						'name' => q(पिन्ट),
						'one' => q({0} pt),
						'other' => q({0} pt),
					},
					# Long Unit Identifier
					'volume-pint-metric' => {
						'name' => q(mpt),
						'one' => q({0} mpt),
						'other' => q({0} mpt),
					},
					# Core Unit Identifier
					'pint-metric' => {
						'name' => q(mpt),
						'one' => q({0} mpt),
						'other' => q({0} mpt),
					},
					# Long Unit Identifier
					'volume-quart' => {
						'name' => q(क्वार्ट्स),
						'one' => q({0} qt),
						'other' => q({0} qt),
					},
					# Core Unit Identifier
					'quart' => {
						'name' => q(क्वार्ट्स),
						'one' => q({0} qt),
						'other' => q({0} qt),
					},
					# Long Unit Identifier
					'volume-quart-imperial' => {
						'name' => q(qt Imp),
						'one' => q({0} qt Imp.),
						'other' => q({0} qt Imp.),
					},
					# Core Unit Identifier
					'quart-imperial' => {
						'name' => q(qt Imp),
						'one' => q({0} qt Imp.),
						'other' => q({0} qt Imp.),
					},
					# Long Unit Identifier
					'volume-tablespoon' => {
						'name' => q(tbsp),
						'one' => q({0} tbsp),
						'other' => q({0} tbsp),
					},
					# Core Unit Identifier
					'tablespoon' => {
						'name' => q(tbsp),
						'one' => q({0} tbsp),
						'other' => q({0} tbsp),
					},
					# Long Unit Identifier
					'volume-teaspoon' => {
						'name' => q(tsp),
						'one' => q({0} tsp),
						'other' => q({0} tsp),
					},
					# Core Unit Identifier
					'teaspoon' => {
						'name' => q(tsp),
						'one' => q({0} tsp),
						'other' => q({0} tsp),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:हो|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:होइन|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
				start => q({0},{1}),
				middle => q({0}, {1}),
				end => q({0},{1}),
				2 => q({0} {1}),
		} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'deva',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'deva',
);

has 'minimum_grouping_digits' => (
	is			=>'ro',
	isa			=> Int,
	init_arg	=> undef,
	default		=> 1,
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'deva' => {
			'decimal' => q(.),
			'exponential' => q(E),
			'group' => q(,),
			'infinity' => q(∞),
			'minusSign' => q(-),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
			'timeSeparator' => q(:),
		},
		'latn' => {
			'decimal' => q(.),
			'exponential' => q(E),
			'group' => q(,),
			'infinity' => q(∞),
			'list' => q(;),
			'minusSign' => q(-),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
			'timeSeparator' => q(:),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'1000' => {
					'one' => '0 हजार',
					'other' => '0 हजार',
				},
				'10000' => {
					'one' => '00 हजार',
					'other' => '00 हजार',
				},
				'100000' => {
					'one' => '0 लाख',
					'other' => '0 लाख',
				},
				'1000000' => {
					'one' => '00 लाख',
					'other' => '00 लाख',
				},
				'10000000' => {
					'one' => '0 करोड',
					'other' => '0 करोड',
				},
				'100000000' => {
					'one' => '00 करोड',
					'other' => '00 करोड',
				},
				'1000000000' => {
					'one' => '0 अरब',
					'other' => '0 अरब',
				},
				'10000000000' => {
					'one' => '00 अरब',
					'other' => '00 अरब',
				},
				'100000000000' => {
					'one' => '0 खरब',
					'other' => '0 खरब',
				},
				'1000000000000' => {
					'one' => '00 खरब',
					'other' => '00 खरब',
				},
				'10000000000000' => {
					'one' => '0 शंख',
					'other' => '0 शंख',
				},
				'100000000000000' => {
					'one' => '00 शंख',
					'other' => '00 शंख',
				},
				'standard' => {
					'default' => '#,##,##0.###',
				},
			},
			'long' => {
				'1000' => {
					'one' => '0 हजार',
					'other' => '0 हजार',
				},
				'10000' => {
					'one' => '00 हजार',
					'other' => '00 हजार',
				},
				'100000' => {
					'one' => '0 लाख',
					'other' => '0 लाख',
				},
				'1000000' => {
					'one' => '0 करोड',
					'other' => '0 करोड',
				},
				'10000000' => {
					'one' => '00 करोड',
					'other' => '00 करोड',
				},
				'100000000' => {
					'one' => '000 करोड',
					'other' => '000 करोड',
				},
				'1000000000' => {
					'one' => '0 अरब',
					'other' => '0 अरब',
				},
				'10000000000' => {
					'one' => '00 अरब',
					'other' => '00 अरब',
				},
				'100000000000' => {
					'one' => '000 अरब',
					'other' => '000 अरब',
				},
				'1000000000000' => {
					'one' => '00 खरब',
					'other' => '00 खरब',
				},
				'10000000000000' => {
					'one' => '0 शंख',
					'other' => '0 शंख',
				},
				'100000000000000' => {
					'one' => '00 शंख',
					'other' => '00 शंख',
				},
			},
			'short' => {
				'1000' => {
					'one' => '0 हजार',
					'other' => '0 हजार',
				},
				'10000' => {
					'one' => '00 हजार',
					'other' => '00 हजार',
				},
				'100000' => {
					'one' => '0 लाख',
					'other' => '0 लाख',
				},
				'1000000' => {
					'one' => '00 लाख',
					'other' => '00 लाख',
				},
				'10000000' => {
					'one' => '0 करोड',
					'other' => '0 करोड',
				},
				'100000000' => {
					'one' => '00 करोड',
					'other' => '00 करोड',
				},
				'1000000000' => {
					'one' => '0 अरब',
					'other' => '0 अरब',
				},
				'10000000000' => {
					'one' => '00 अरब',
					'other' => '00 अरब',
				},
				'100000000000' => {
					'one' => '0 खरब',
					'other' => '0 खरब',
				},
				'1000000000000' => {
					'one' => '00 खरब',
					'other' => '00 खरब',
				},
				'10000000000000' => {
					'one' => '0 शंख',
					'other' => '0 शंख',
				},
				'100000000000000' => {
					'one' => '00 शंख',
					'other' => '00 शंख',
				},
			},
		},
		percentFormat => {
			'default' => {
				'standard' => {
					'default' => '#,##,##0%',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'standard' => {
					'default' => '#E0',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'deva' => {
			'pattern' => {
				'default' => {
					'standard' => {
						'positive' => '¤ #,##,##0.00',
					},
				},
			},
		},
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'positive' => '¤ #,##,##0.00',
					},
					'standard' => {
						'positive' => '¤ #,##,##0.00',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'AED' => {
			symbol => 'AED',
			display_name => {
				'currency' => q(संयुक्त अरब एमिराट्स डिर्हाम),
				'one' => q(संयुक्त अरब एमिराट्स डिर्हाम),
				'other' => q(संयुक्त अरब एमिराट्स डिर्हाम),
			},
		},
		'AFA' => {
			display_name => {
				'currency' => q(अफ्गानी\(१९२७–२००२\)),
			},
		},
		'AFN' => {
			symbol => 'AFN',
			display_name => {
				'currency' => q(अफ्गान अफ्गानी),
				'one' => q(अफ्गान अफ्गानी),
				'other' => q(अफ्गान अफ्गानी),
			},
		},
		'ALL' => {
			symbol => 'ALL',
			display_name => {
				'currency' => q(अल्बानियन लेक),
				'one' => q(अल्बानियन लेक),
				'other' => q(अल्बानियन लेक),
			},
		},
		'AMD' => {
			symbol => 'AMD',
			display_name => {
				'currency' => q(आर्मेनियाली ड्राम),
				'one' => q(आर्मेनियाली ड्राम),
				'other' => q(आर्मेनियाली ड्राम),
			},
		},
		'ANG' => {
			symbol => 'ANG',
			display_name => {
				'currency' => q(नेदरल्याण्ड्स एन्टिलियन गिल्डर),
				'one' => q(नेदरल्याण्ड्स एन्टिलियन गिल्डर),
				'other' => q(नेदरल्याण्ड्स एन्टिलियन गिल्डर),
			},
		},
		'AOA' => {
			symbol => 'AOA',
			display_name => {
				'currency' => q(एङ्गोलान क्वान्जा),
				'one' => q(एङ्गोलान क्वान्जा),
				'other' => q(एङ्गोलान क्वान्जा),
			},
		},
		'ARS' => {
			symbol => 'ARS',
			display_name => {
				'currency' => q(अर्जेन्टिनी पेसो),
				'one' => q(अर्जेन्टिनी पेसो),
				'other' => q(अर्जेन्टिनी पेसो),
			},
		},
		'AUD' => {
			symbol => 'A$',
			display_name => {
				'currency' => q(अष्ट्रेलियन डलर),
				'one' => q(अष्ट्रेलियन डलर),
				'other' => q(अष्ट्रेलियन डलर),
			},
		},
		'AWG' => {
			symbol => 'AWG',
			display_name => {
				'currency' => q(आरूबन फ्लोरिन),
				'one' => q(आरूबन फ्लोरिन),
				'other' => q(आरूबन फ्लोरिन),
			},
		},
		'AZN' => {
			symbol => 'AZN',
			display_name => {
				'currency' => q(अजरबैजानी मानात),
				'one' => q(अजरबैजानी मानात),
				'other' => q(अजरबैजानी मानात),
			},
		},
		'BAM' => {
			symbol => 'BAM',
			display_name => {
				'currency' => q(बोस्निया-हर्जगोभिनिया रूपान्तरयोग्य मार्क),
				'one' => q(बोस्निया-हर्जगोभिनिया रूपान्तरयोग्य मार्क),
				'other' => q(बोस्निया-हर्जगोभिनिया रूपान्तरयोग्य मार्क),
			},
		},
		'BBD' => {
			symbol => 'BBD',
			display_name => {
				'currency' => q(बर्बाडियन डलर),
				'one' => q(बार्बाडियन डलर),
				'other' => q(बर्बाडियन डलर),
			},
		},
		'BDT' => {
			symbol => 'BDT',
			display_name => {
				'currency' => q(बङ्गलादेशी टाका),
				'one' => q(बङ्गलादेशी टाका),
				'other' => q(बङ्गलादेशी टाका),
			},
		},
		'BGN' => {
			symbol => 'BGN',
			display_name => {
				'currency' => q(बुल्गारियाली लेभ),
				'one' => q(बुल्गारियाली लेभ),
				'other' => q(बुल्गारियाली लेभा),
			},
		},
		'BHD' => {
			symbol => 'BHD',
			display_name => {
				'currency' => q(बाहारैनी डिनार),
				'one' => q(बाहारैनी डिनार),
				'other' => q(बाहारैनी डिनार),
			},
		},
		'BIF' => {
			symbol => 'BIF',
			display_name => {
				'currency' => q(बुरूण्डियाली फ्रान्क),
				'one' => q(बुरूण्डियाली फ्रान्क),
				'other' => q(बुरूण्डियाली फ्रान्क),
			},
		},
		'BMD' => {
			symbol => 'BMD',
			display_name => {
				'currency' => q(बर्मुडन डलर),
				'one' => q(बर्मुडन डलर),
				'other' => q(बर्मुडन डलर),
			},
		},
		'BND' => {
			symbol => 'BND',
			display_name => {
				'currency' => q(ब्रुनाई डलर),
				'one' => q(ब्रुनाई डलर),
				'other' => q(ब्रुनाई डलर),
			},
		},
		'BOB' => {
			symbol => 'BOB',
			display_name => {
				'currency' => q(बोलिभियन बोलिभियानो),
				'one' => q(बोलिभियन बोलिभियानो),
				'other' => q(बोलिभियन बोलिभियानो),
			},
		},
		'BRL' => {
			symbol => 'R$',
			display_name => {
				'currency' => q(ब्राजिलियन रियल),
				'one' => q(ब्राजिलियन रियल),
				'other' => q(ब्राजिलियन रियल),
			},
		},
		'BSD' => {
			symbol => 'BSD',
			display_name => {
				'currency' => q(बहामियाली डलर),
				'one' => q(बहामियाली डलर),
				'other' => q(बहामियाली डलर),
			},
		},
		'BTN' => {
			symbol => 'BTN',
			display_name => {
				'currency' => q(भुटानी एन्‌गुल्ट्रुम),
				'one' => q(भुटानी एन्‌गुल्ट्रुम),
				'other' => q(भुटानी एन्‌गुल्ट्रुम),
			},
		},
		'BWP' => {
			symbol => 'BWP',
			display_name => {
				'currency' => q(बोट्सवानान पुला),
				'one' => q(बोट्सवानान पुला),
				'other' => q(बोट्सवानान पुला),
			},
		},
		'BYN' => {
			symbol => 'BYN',
			display_name => {
				'currency' => q(बेलारूसी रूबल),
				'one' => q(बेलारूसी रूबल),
				'other' => q(बेलारूसी रूबल),
			},
		},
		'BYR' => {
			symbol => 'BYR',
			display_name => {
				'currency' => q(बेलारूसी रूबल \(2000–2016\)),
				'one' => q(बेलारूसी रूबल \(2000–2016\)),
				'other' => q(बेलारूसी रूबल \(2000–2016\)),
			},
		},
		'BZD' => {
			symbol => 'BZD',
			display_name => {
				'currency' => q(वेलिज डलर),
				'one' => q(वेलिज डलर),
				'other' => q(वेलिज डलर),
			},
		},
		'CAD' => {
			symbol => 'CA$',
			display_name => {
				'currency' => q(क्यानाडियाली डलर),
				'one' => q(क्यानाडियाली डलर),
				'other' => q(क्यानाडियाली डलर),
			},
		},
		'CDF' => {
			symbol => 'CDF',
			display_name => {
				'currency' => q(कङ्गोली फ्रान्क),
				'one' => q(कङ्गोली फ्रान्क),
				'other' => q(कङ्गोली फ्रान्क),
			},
		},
		'CHF' => {
			symbol => 'CHF',
			display_name => {
				'currency' => q(स्विस् फ्रैङ्क),
				'one' => q(स्विस् फ्रैङ्क),
				'other' => q(स्विस् फ्रैङ्क),
			},
		},
		'CLP' => {
			symbol => 'CLP',
			display_name => {
				'currency' => q(चिलियन पेसो),
				'one' => q(चिलियन पेसो),
				'other' => q(चिलियन पेसो),
			},
		},
		'CNH' => {
			symbol => 'CNH',
			display_name => {
				'currency' => q(चिनियाँ युआन\(तटवर्ती\)),
				'one' => q(चिनियाँ युआन\(तटवर्ती\)),
				'other' => q(चिनियाँ युआन\(तटवर्ती\)),
			},
		},
		'CNY' => {
			symbol => 'CN¥',
			display_name => {
				'currency' => q(चिनिँया युआन),
				'one' => q(चिनिँया युआन),
				'other' => q(चिनिँया युआन),
			},
		},
		'COP' => {
			symbol => 'COP',
			display_name => {
				'currency' => q(कोलम्वियन पेसो),
				'one' => q(कोलम्वियन पेसो),
				'other' => q(कोलम्वियन पेसो),
			},
		},
		'CRC' => {
			symbol => 'CRC',
			display_name => {
				'currency' => q(कोष्टारिकन कोलोन),
				'one' => q(कोष्टारिकन कोलोन),
				'other' => q(कोष्टारिकन कोलोनहरू),
			},
		},
		'CUC' => {
			symbol => 'CUC',
			display_name => {
				'currency' => q(क्यूवाली रूपान्तरणयोग्य पेसो),
				'one' => q(क्यूवाली रूपान्तरणयोग्य पेसो),
				'other' => q(क्यूवाली रूपान्तरणयोग्य पेसो),
			},
		},
		'CUP' => {
			symbol => 'CUP',
			display_name => {
				'currency' => q(क्यूवाली पेसो),
				'one' => q(क्यूवाली पेसो),
				'other' => q(क्यूवाली पेसो),
			},
		},
		'CVE' => {
			symbol => 'CVE',
			display_name => {
				'currency' => q(केप भर्डियन एस्कुडो),
				'one' => q(केप भर्डियन एस्कुडो),
				'other' => q(केप भर्डियन एस्कुडो),
			},
		},
		'CZK' => {
			symbol => 'CZK',
			display_name => {
				'currency' => q(चेख गणतञ्त्र कोरूना),
				'one' => q(चेख गणतञ्त्र कोरूना),
				'other' => q(चेख गणतञ्त्र कोरूना),
			},
		},
		'DJF' => {
			symbol => 'DJF',
			display_name => {
				'currency' => q(जिबौंटियाली फ्रान्क),
				'one' => q(जिबौटियाली फ्रान्क),
				'other' => q(जिबौंटियाली फ्रान्क),
			},
		},
		'DKK' => {
			symbol => 'DKK',
			display_name => {
				'currency' => q(ड्यानिश क्रोन),
				'one' => q(ड्यानिश क्रोन),
				'other' => q(ड्यानिश क्रोनर),
			},
		},
		'DOP' => {
			symbol => 'DOP',
			display_name => {
				'currency' => q(डोमिनिकन पेसो),
				'one' => q(डोमिनिकन पेसो),
				'other' => q(डोमिनिकन पेसो),
			},
		},
		'DZD' => {
			symbol => 'DZD',
			display_name => {
				'currency' => q(अल्जेरियाली डिनार),
				'one' => q(अल्जेरियाली डिनार),
				'other' => q(अल्जेरियाली डिनार),
			},
		},
		'EGP' => {
			symbol => 'EGP',
			display_name => {
				'currency' => q(इजिप्सियन पाउन्ड),
				'one' => q(इजिप्सियन पाउन्ड),
				'other' => q(इजिप्सियन पाउन्ड),
			},
		},
		'ERN' => {
			symbol => 'ERN',
			display_name => {
				'currency' => q(एरिट्रियन नाक्फा),
				'one' => q(एरिट्रियन नाक्फा),
				'other' => q(एरिट्रियन नाक्फा),
			},
		},
		'ETB' => {
			symbol => 'ETB',
			display_name => {
				'currency' => q(इथियोपियाली बिर),
				'one' => q(इथियोपियाली बिर),
				'other' => q(इथियोपियाली बिर),
			},
		},
		'EUR' => {
			symbol => '€',
			display_name => {
				'currency' => q(युरो),
				'one' => q(युरो),
				'other' => q(युरो),
			},
		},
		'FJD' => {
			symbol => 'FJD',
			display_name => {
				'currency' => q(फिजीयाली डलर),
				'one' => q(फिजीयाली डलर),
				'other' => q(फिजीयाली डलरहरू),
			},
		},
		'FKP' => {
			symbol => 'FKP',
			display_name => {
				'currency' => q(फक्‌ल्याण्ड टापुहरूका पाउन्ड),
				'one' => q(फक्‌ल्याण्ड टापुहरूका पाउन्ड),
				'other' => q(फक्‌ल्याण्ड टापुहरूका पाउन्ड),
			},
		},
		'GBP' => {
			symbol => '£',
			display_name => {
				'currency' => q(बेलायती पाउण्ड स्टर्लिङ),
				'one' => q(बेलायती पाउण्ड स्टर्लिङ),
				'other' => q(बेलायती पाउण्ड स्टर्लिङ),
			},
		},
		'GEL' => {
			symbol => 'GEL',
			display_name => {
				'currency' => q(जर्जियाली लारी),
				'one' => q(जर्जियाली लारी),
				'other' => q(जर्जियन लारी),
			},
		},
		'GHS' => {
			symbol => 'GHS',
			display_name => {
				'currency' => q(घानाली सेडी),
				'one' => q(घानाली सेडी),
				'other' => q(घानाली सेडी),
			},
		},
		'GIP' => {
			symbol => 'GIP',
			display_name => {
				'currency' => q(जिब्राल्टर पाउण्ड),
				'one' => q(जिब्राल्टर पाउण्ड),
				'other' => q(जिब्राल्टर पाउण्ड),
			},
		},
		'GMD' => {
			symbol => 'GMD',
			display_name => {
				'currency' => q(गाम्वियाली डालासी),
				'one' => q(गाम्वियाली डालासी),
				'other' => q(गाम्वियाली डालासी),
			},
		},
		'GNF' => {
			symbol => 'GNF',
			display_name => {
				'currency' => q(गिनियाली फ्रान्क),
				'one' => q(गिनियाली फ्रान्क),
				'other' => q(गिनियाली फ्रान्क),
			},
		},
		'GTQ' => {
			symbol => 'GTQ',
			display_name => {
				'currency' => q(ग्वाटेमाला क्वेट्जाल),
				'one' => q(ग्वाटेमाला क्वेट्जाल),
				'other' => q(ग्वाटेमाला क्वेट्जाल),
			},
		},
		'GYD' => {
			symbol => 'GYD',
			display_name => {
				'currency' => q(गाइनिज डलर),
				'one' => q(गाइनिज डलर),
				'other' => q(गाइनिज डलर),
			},
		},
		'HKD' => {
			symbol => 'HK$',
			display_name => {
				'currency' => q(हङकङ डलर),
				'one' => q(हङकङ डलर),
				'other' => q(हङकङ डलर),
			},
		},
		'HNL' => {
			symbol => 'HNL',
			display_name => {
				'currency' => q(होन्डुरान लेम्पिरा),
				'one' => q(होन्डुरान लेम्पिरा),
				'other' => q(होन्डुरान लेम्पिरा),
			},
		},
		'HRK' => {
			symbol => 'HRK',
			display_name => {
				'currency' => q(क्रोएशियाली कुना),
				'one' => q(क्रोएशियाली कुना),
				'other' => q(क्रोएशियाली कुना),
			},
		},
		'HTG' => {
			symbol => 'HTG',
			display_name => {
				'currency' => q(हैटियाली गुर्ड),
				'one' => q(हैटियाली),
				'other' => q(हैटियाली गुर्ड),
			},
		},
		'HUF' => {
			symbol => 'HUF',
			display_name => {
				'currency' => q(हङ्गेरियन फोरिन्ट),
				'one' => q(हङ्गेरियन फोरिन्ट),
				'other' => q(हङ्गेरियन फोरिन्ट),
			},
		},
		'IDR' => {
			symbol => 'IDR',
			display_name => {
				'currency' => q(इण्डोनेशियाली रूपियाँ),
				'one' => q(इण्डोनेशियाली रूपियाँ),
				'other' => q(इण्डोनेशियाली रूपियाँ),
			},
		},
		'ILS' => {
			symbol => '₪',
			display_name => {
				'currency' => q(इजरायली नयाँ शेकेल),
				'one' => q(इजरायली नयाँ शेकेल),
				'other' => q(इजरायली नयाँ शेकेल),
			},
		},
		'INR' => {
			symbol => '₹',
			display_name => {
				'currency' => q(भारतीय रूपिँया),
				'one' => q(भारतीय रूपिँया),
				'other' => q(भारतीय रूपिँया),
			},
		},
		'IQD' => {
			symbol => 'IQD',
			display_name => {
				'currency' => q(इराकी डिनार),
				'one' => q(इराकी डिनार),
				'other' => q(इराकी डिनार),
			},
		},
		'IRR' => {
			symbol => 'IRR',
			display_name => {
				'currency' => q(इरानियाली रियाल),
				'one' => q(इरानियाली रियाल),
				'other' => q(इरानियाली रियाल),
			},
		},
		'ISK' => {
			symbol => 'ISK',
			display_name => {
				'currency' => q(आइसल्याण्डिक क्रोना),
				'one' => q(आइसल्याण्डिक क्रोना),
				'other' => q(आइसल्याण्डिक क्रोनर),
			},
		},
		'JMD' => {
			symbol => 'JMD',
			display_name => {
				'currency' => q(जमाइकाली डलर),
				'one' => q(जमाइकाली डलर),
				'other' => q(जमाइकाली डलर),
			},
		},
		'JOD' => {
			symbol => 'JOD',
			display_name => {
				'currency' => q(जोर्डानियाली डलर),
				'one' => q(जोर्डानियाली डलर),
				'other' => q(जोर्डानियाली डलर),
			},
		},
		'JPY' => {
			symbol => 'JP¥',
			display_name => {
				'currency' => q(जापानी येन),
				'one' => q(जापानी येन),
				'other' => q(जापानी येन),
			},
		},
		'KES' => {
			symbol => 'KES',
			display_name => {
				'currency' => q(केन्याली शिलिङ),
				'one' => q(केन्याली शिलिङ),
				'other' => q(केन्याली शिलिङ),
			},
		},
		'KGS' => {
			symbol => 'KGS',
			display_name => {
				'currency' => q(किर्गिस्तानी सोम),
				'one' => q(किर्गिस्तानी सोम),
				'other' => q(किर्गिस्तानी सोम),
			},
		},
		'KHR' => {
			symbol => 'KHR',
			display_name => {
				'currency' => q(कम्बोडिनेयाली रियल),
				'one' => q(कम्बोडिनेयाली रियल),
				'other' => q(कम्बोडिनेयाली रियल),
			},
		},
		'KMF' => {
			symbol => 'KMF',
			display_name => {
				'currency' => q(कोमोरियन फ्रान्क),
				'one' => q(कोमोरियन फ्रान्क),
				'other' => q(कोमोरियन फ्रान्क),
			},
		},
		'KPW' => {
			symbol => 'KPW',
			display_name => {
				'currency' => q(उत्तर कोरियाली वन),
				'one' => q(उत्तर कोरियाली वन),
				'other' => q(उत्तर कोरियाली वन),
			},
		},
		'KRW' => {
			symbol => '₩',
			display_name => {
				'currency' => q(दक्षिण कोरियाली वन),
				'one' => q(दक्षिण कोरियाली वन),
				'other' => q(दक्षिण कोरियाली वन),
			},
		},
		'KWD' => {
			symbol => 'KWD',
			display_name => {
				'currency' => q(कुवेती डिनार),
				'one' => q(कुवेती डिनार),
				'other' => q(कुवेती डिनार),
			},
		},
		'KYD' => {
			symbol => 'KYD',
			display_name => {
				'currency' => q(केम्यान टापुहरूका डलर),
				'one' => q(केम्यान टापुहरूका डलर),
				'other' => q(केम्यान टापुहरूका डलर),
			},
		},
		'KZT' => {
			symbol => 'KZT',
			display_name => {
				'currency' => q(काजाखस्तानी टेन्ज),
				'one' => q(काजाखस्तानी टेन्ज),
				'other' => q(काजाखस्तानी टेन्ज),
			},
		},
		'LAK' => {
			symbol => 'LAK',
			display_name => {
				'currency' => q(लाओशियन किप),
				'one' => q(लाओशियन किप),
				'other' => q(लाओशियन किप),
			},
		},
		'LBP' => {
			symbol => 'LBP',
			display_name => {
				'currency' => q(लेबनाली पाउन्ड),
				'one' => q(लेबनाली पाउन्ड),
				'other' => q(लेबनाली पाउन्ड),
			},
		},
		'LKR' => {
			symbol => 'LKR',
			display_name => {
				'currency' => q(श्रीलङ्काली रूपिया),
				'one' => q(श्रीलङ्काली रूपिया),
				'other' => q(श्रीलङ्काली रूपिया),
			},
		},
		'LRD' => {
			symbol => 'LRD',
			display_name => {
				'currency' => q(लिबेरियाली डलर),
				'one' => q(लिबेरियाली डलर),
				'other' => q(लिबेरियाली डलर),
			},
		},
		'LSL' => {
			display_name => {
				'currency' => q(लेसोथो लोटी),
				'one' => q(लेसोथो लोटी),
				'other' => q(लेसोथो लोटिस),
			},
		},
		'LTL' => {
			symbol => 'LTL',
			display_name => {
				'currency' => q(लिथुनियाली लिटास),
				'one' => q(लिथुनियाली लिटास),
				'other' => q(लिथुनियाली लिटाई),
			},
		},
		'LVL' => {
			symbol => 'LVL',
			display_name => {
				'currency' => q(लाट्भियाली लाट्स),
				'one' => q(लाट्भियाली लाट्स),
				'other' => q(लाट्भियाली लाटी),
			},
		},
		'LYD' => {
			symbol => 'LYD',
			display_name => {
				'currency' => q(लिवियाली डिनार),
				'one' => q(लिवियाली डिनार),
				'other' => q(लिवियाली डिनार),
			},
		},
		'MAD' => {
			symbol => 'MAD',
			display_name => {
				'currency' => q(मोरोक्काली डिर्‌हाम),
				'one' => q(मोरोक्काली डिर्‌हाम),
				'other' => q(मोरोक्काली डिर्‌हाम),
			},
		},
		'MDL' => {
			symbol => 'MDL',
			display_name => {
				'currency' => q(माल्डोभन लेउ),
				'one' => q(माल्डोभन लेउ),
				'other' => q(माल्डोभन लेई),
			},
		},
		'MGA' => {
			symbol => 'MGA',
			display_name => {
				'currency' => q(मालागासी एरिआरी),
				'one' => q(मालागासी एरिआरी),
				'other' => q(मालागासी एरिआरी),
			},
		},
		'MKD' => {
			symbol => 'MKD',
			display_name => {
				'currency' => q(म्यासेडोनियाली डेनार),
				'one' => q(म्यासेडोनियाली डेनार),
				'other' => q(म्यासेडोनियाली डेनारी),
			},
		},
		'MMK' => {
			symbol => 'MMK',
			display_name => {
				'currency' => q(म्यान्मार क्याट),
				'one' => q(म्यान्मार क्याट),
				'other' => q(म्यान्मार क्याट),
			},
		},
		'MNT' => {
			symbol => 'MNT',
			display_name => {
				'currency' => q(मङ्गोलियाली टुग्रिक),
				'one' => q(मङ्गोलियाली टुग्रिक),
				'other' => q(मङ्गोलियाली टुग्रिक),
			},
		},
		'MOP' => {
			symbol => 'MOP',
			display_name => {
				'currency' => q(माकानिज पटाका),
				'one' => q(माकानिज पटाका),
				'other' => q(माकानिज पटाका),
			},
		},
		'MRO' => {
			symbol => 'MRO',
			display_name => {
				'currency' => q(माउरिटानियानली औगुइया \(१९७३–२०१७\)),
				'one' => q(माउरिटानियाली औगुइया \(१९७३–२०१७\)),
				'other' => q(माउरिटानियानली औगुइया \(१९७३–२०१७\)),
			},
		},
		'MRU' => {
			symbol => 'MRU',
			display_name => {
				'currency' => q(माउरिटानियानली औगुइया),
				'one' => q(माउरिटानियाली औगुइया),
				'other' => q(माउरिटानियानली औगुइया),
			},
		},
		'MUR' => {
			symbol => 'MUR',
			display_name => {
				'currency' => q(माउरिटियन रूपी),
				'one' => q(माउरिटियन रूपी),
				'other' => q(माउरिटियन रूपी),
			},
		},
		'MVR' => {
			symbol => 'MVR',
			display_name => {
				'currency' => q(मालडिभियाली रूफियाँ),
				'one' => q(मालडिभियाली रूफियाँ),
				'other' => q(मालडिभियाली रूफियाँ),
			},
		},
		'MWK' => {
			symbol => 'MWK',
			display_name => {
				'currency' => q(मलाविअन क्वाचा),
				'one' => q(मलाविअन क्वाचा),
				'other' => q(मलाविअन क्वाचा),
			},
		},
		'MXN' => {
			symbol => 'MX$',
			display_name => {
				'currency' => q(मेक्सिकन पेसो),
				'one' => q(मेक्सिकन पेसो),
				'other' => q(मेक्सिकन पेसो),
			},
		},
		'MYR' => {
			symbol => 'MYR',
			display_name => {
				'currency' => q(मलेशियाली रिङ्गेट),
				'one' => q(मलेशियाली रिङ्गेट),
				'other' => q(मलेशियाली रिङ्गेट),
			},
		},
		'MZN' => {
			symbol => 'MZN',
			display_name => {
				'currency' => q(मोजाम्विकन मेटिकल),
				'one' => q(मोजाम्विकन मेटिकल),
				'other' => q(मोजाम्विकन मेटिकल),
			},
		},
		'NAD' => {
			symbol => 'NAD',
			display_name => {
				'currency' => q(नामिबियन डलर),
				'one' => q(नामिबियन डलर),
				'other' => q(नामिबियन डलर),
			},
		},
		'NGN' => {
			symbol => 'NGN',
			display_name => {
				'currency' => q(नाइजेरियन नाइरा),
				'one' => q(नाइजेरियन नाइरा),
				'other' => q(नाइजेरियन नाइरा),
			},
		},
		'NIO' => {
			symbol => 'NIO',
			display_name => {
				'currency' => q(निकारागुवान कोर्डोवा),
				'one' => q(निकारागुवान कोर्डोवा),
				'other' => q(निकारागुवान कोर्डोवा),
			},
		},
		'NOK' => {
			symbol => 'NOK',
			display_name => {
				'currency' => q(नर्वेजियाली क्रोन),
				'one' => q(नर्वेजियाली क्रोन),
				'other' => q(नर्वेजियाली क्रोनर),
			},
		},
		'NPR' => {
			symbol => 'नेरू',
			display_name => {
				'currency' => q(नेपाली रूपैयाँ),
				'one' => q(नेपाली रूपैयाँ),
				'other' => q(नेपाली रूपैयाँ),
			},
		},
		'NZD' => {
			symbol => 'NZ$',
			display_name => {
				'currency' => q(न्यूजिल्याण्ड डलर),
				'one' => q(न्यूजिल्याण्ड डलर),
				'other' => q(न्यूजिल्याण्ड डलरहरू),
			},
		},
		'OMR' => {
			symbol => 'OMR',
			display_name => {
				'currency' => q(ओमनी रियल),
				'one' => q(ओमनी रियाल),
				'other' => q(ओमनी रियल),
			},
		},
		'PAB' => {
			symbol => 'PAB',
			display_name => {
				'currency' => q(पानामानियाली बाल्बोआ),
				'one' => q(पानामानियाली बाल्बोआ),
				'other' => q(पानामानियाली बाल्बोआ),
			},
		},
		'PEN' => {
			symbol => 'PEN',
			display_name => {
				'currency' => q(पेरूभियाली सोल),
				'one' => q(पेरूभियाली सोल),
				'other' => q(पेरूभियाली सोल),
			},
		},
		'PGK' => {
			symbol => 'PGK',
			display_name => {
				'currency' => q(पपुआ न्यू गिनियाली किना),
				'one' => q(पपुआ न्यू गिनियाली किना),
				'other' => q(पपुआ न्यू गिनियाली किना),
			},
		},
		'PHP' => {
			symbol => 'PHP',
			display_name => {
				'currency' => q(फिलिपिनी पेसो),
				'one' => q(फिलिपिनी पेसो),
				'other' => q(फिलिपिनी पेसो),
			},
		},
		'PKR' => {
			symbol => 'PKR',
			display_name => {
				'currency' => q(पाकिस्तानी रूपियाँ),
				'one' => q(पाकिस्तानी रूपियाँ),
				'other' => q(पाकिस्तानी रूपियाँ),
			},
		},
		'PLN' => {
			symbol => 'PLN',
			display_name => {
				'currency' => q(पोलिश ज्लोटाई),
				'one' => q(पोलिश ज्लोटाई),
				'other' => q(पोलिश ज्लोटाई),
			},
		},
		'PYG' => {
			symbol => 'PYG',
			display_name => {
				'currency' => q(पारागुयाली गुरानी),
				'one' => q(पारागुयाली गुरानी),
				'other' => q(पारागुयाली गुरानी),
			},
		},
		'QAR' => {
			symbol => 'QAR',
			display_name => {
				'currency' => q(कतारी रियल),
				'one' => q(कतारी रियाल),
				'other' => q(कतारी रियल),
			},
		},
		'RON' => {
			symbol => 'RON',
			display_name => {
				'currency' => q(रोमानियाली लेऊ),
				'one' => q(रोमानियाली लेऊ),
				'other' => q(रोमानियाली लेई),
			},
		},
		'RSD' => {
			symbol => 'RSD',
			display_name => {
				'currency' => q(सर्बियाली डिनार),
				'one' => q(सर्बियाली डिनार),
				'other' => q(सर्बियाली डिनार),
			},
		},
		'RUB' => {
			symbol => 'RUB',
			display_name => {
				'currency' => q(रूसी रूबल),
				'one' => q(रूसी रूबल),
				'other' => q(रूसी रूबल),
			},
		},
		'RWF' => {
			symbol => 'RWF',
			display_name => {
				'currency' => q(र्‌वाण्डाली फ्रान्क),
				'one' => q(र्‌वाण्डाली फ्रान्क),
				'other' => q(र्‌वाण्डाली फ्रान्क),
			},
		},
		'SAR' => {
			symbol => 'SAR',
			display_name => {
				'currency' => q(साउदी रियालहरू),
				'one' => q(साउदी रियाल),
				'other' => q(साउदी रियाल),
			},
		},
		'SBD' => {
			symbol => 'SBD',
			display_name => {
				'currency' => q(सोलोमन टापुहरूका डलर),
				'one' => q(सोलोमन टापुहरूका डलर),
				'other' => q(सोलोमन टापुहरूका डलर),
			},
		},
		'SCR' => {
			symbol => 'SCR',
			display_name => {
				'currency' => q(सेचेलोइस रूपी),
				'one' => q(सेचेलोइस रूपी),
				'other' => q(सेचेलोइस रूपी),
			},
		},
		'SDG' => {
			symbol => 'SDG',
			display_name => {
				'currency' => q(सुडानी पाउन्ड),
				'one' => q(सुडानी पाउन्ड),
				'other' => q(सुडानी पाउन्ड),
			},
		},
		'SEK' => {
			symbol => 'SEK',
			display_name => {
				'currency' => q(स्विडिश क्रोना),
				'one' => q(स्विडिश क्रोना),
				'other' => q(स्विडिश क्रोनर),
			},
		},
		'SGD' => {
			symbol => 'SGD',
			display_name => {
				'currency' => q(सिङ्गापुर डलर),
				'one' => q(सिङ्गापुर डलर),
				'other' => q(सिङ्गापुर डलर),
			},
		},
		'SHP' => {
			symbol => 'SHP',
			display_name => {
				'currency' => q(सेन्ट हेलेना पाउन्ड),
				'one' => q(सेन्ट हेलेना पाउन्ड),
				'other' => q(सेन्ट हेलेना पाउन्ड),
			},
		},
		'SLL' => {
			symbol => 'SLL',
			display_name => {
				'currency' => q(सियरा लियोनेन लियोन),
				'one' => q(सियरा लियोनेन लियोन),
				'other' => q(सियरा लियोनेन लियोन),
			},
		},
		'SOS' => {
			symbol => 'SOS',
			display_name => {
				'currency' => q(सोमाली शिलिङ),
				'one' => q(सोमाली शिलिङ),
				'other' => q(सोमाली शिलिङ),
			},
		},
		'SRD' => {
			symbol => 'SRD',
			display_name => {
				'currency' => q(सुरिनामिज डलर),
				'one' => q(सुरिनामिज डलर),
				'other' => q(सुरिनामिज डलर),
			},
		},
		'SSP' => {
			symbol => 'SSP',
			display_name => {
				'currency' => q(दक्षिण सुडानी पाउन्ड),
				'one' => q(दक्षिण सुडानी पाउन्ड),
				'other' => q(दक्षिण सुडानी पाउन्ड),
			},
		},
		'STD' => {
			symbol => 'STD',
			display_name => {
				'currency' => q(साओ टोम र प्रिन्सिप डोब्रा \(१९७७–२०१७\)),
				'one' => q(साओ टोम र प्रिन्सिप डोब्रा \(१९७७–२०१७\)),
				'other' => q(साओ टोम र प्रिन्सिप डोब्रा \(१९७७–२०१७\)),
			},
		},
		'STN' => {
			symbol => 'STN',
			display_name => {
				'currency' => q(साओ टोम र प्रिन्सिप डोब्रा),
				'one' => q(साओ टोम र प्रिन्सिप डोब्रा),
				'other' => q(साओ टोम र प्रिन्सिप डोब्रा),
			},
		},
		'SYP' => {
			symbol => 'SYP',
			display_name => {
				'currency' => q(सिरियाली पाउन्ड),
				'one' => q(सिरियाली पाउन्ड),
				'other' => q(सिरियाली पाउन्ड),
			},
		},
		'SZL' => {
			symbol => 'SZL',
			display_name => {
				'currency' => q(स्वाजी लिलान्गेनी),
				'one' => q(स्वाजी लिलान्गेनी),
				'other' => q(स्वाजी इमालेन्गेनी),
			},
		},
		'THB' => {
			symbol => '฿',
			display_name => {
				'currency' => q(थाई भाट),
				'one' => q(थाई भाट),
				'other' => q(थाई भाट),
			},
		},
		'TJS' => {
			symbol => 'TJS',
			display_name => {
				'currency' => q(ताजिक्स्तानी सोमोनी),
				'one' => q(ताजिक्स्तानी सोमोनी),
				'other' => q(ताजिक्स्तानी सोमोनी),
			},
		},
		'TMT' => {
			symbol => 'TMT',
			display_name => {
				'currency' => q(टुर्क्मेनिस्तानी मानात),
				'one' => q(टुर्क्मेनिस्तानी मानात),
				'other' => q(टुर्क्मेनिस्तानी मानात),
			},
		},
		'TND' => {
			symbol => 'TND',
			display_name => {
				'currency' => q(टुनिसियाली डिनार),
				'one' => q(टुनिसियाली डिनार),
				'other' => q(टुनिसियाली डिनार),
			},
		},
		'TOP' => {
			symbol => 'TOP',
			display_name => {
				'currency' => q(टङ्गन पाङ्गा),
				'one' => q(टङ्गन पाङ्गा),
				'other' => q(टङ्गन पाङ्गा),
			},
		},
		'TRY' => {
			symbol => 'TRY',
			display_name => {
				'currency' => q(टर्किश लिरा),
				'one' => q(टर्किश लिरा),
				'other' => q(टर्किश लिरा),
			},
		},
		'TTD' => {
			symbol => 'TTD',
			display_name => {
				'currency' => q(त्रिनिडाड र टोबागो डलर),
				'one' => q(त्रिनिडाड र टोबागो डलर),
				'other' => q(त्रिनिडाड र टोबागो डलर),
			},
		},
		'TWD' => {
			symbol => 'NT$',
			display_name => {
				'currency' => q(नयाँ ताइवान डलर),
				'one' => q(नयाँ ताइवान डलर),
				'other' => q(नयाँ ताइवान डलर),
			},
		},
		'TZS' => {
			symbol => 'TZS',
			display_name => {
				'currency' => q(ताञ्जानियाली शिलिङ),
				'one' => q(ताञ्जानियाली शिलिङ),
				'other' => q(ताञ्जानियाली शिलिङ),
			},
		},
		'UAH' => {
			symbol => 'UAH',
			display_name => {
				'currency' => q(युक्रेनी हिर्भिनिया),
				'one' => q(युक्रेनी हिर्भिनिया),
				'other' => q(युक्रेनी हिर्भिनिया),
			},
		},
		'UGX' => {
			symbol => 'UGX',
			display_name => {
				'currency' => q(युगाण्डाली शिलिङ),
				'one' => q(युगाण्डाली शिलिङ),
				'other' => q(युगाण्डाली शिलिङ),
			},
		},
		'USD' => {
			symbol => 'US$',
			display_name => {
				'currency' => q(अमेरिकी डलर),
				'one' => q(अमेरिकी डलर),
				'other' => q(संयुक्त राज्य डलर),
			},
		},
		'UYU' => {
			symbol => 'UYU',
			display_name => {
				'currency' => q(उरूगुवायाली पेसो),
				'one' => q(उरूगुवायाली पेसो),
				'other' => q(उरूगुवायाली पेसो),
			},
		},
		'UZS' => {
			symbol => 'UZS',
			display_name => {
				'currency' => q(उज्बेकिस्तान सोम),
				'one' => q(उज्बेकिस्तान सोम),
				'other' => q(उज्बेकिस्तान सोम),
			},
		},
		'VEF' => {
			symbol => 'VEF',
			display_name => {
				'currency' => q(भेनेजुएलन बोलिभर \(२००८–२०१८\)),
				'one' => q(भेनेजुएलन बोलिभर),
				'other' => q(भेनेजुएलन बोलिभर),
			},
		},
		'VES' => {
			symbol => 'VES',
			display_name => {
				'currency' => q(भेनेजुएलन बोलिभर-2),
				'one' => q(भेनेजुएलन बोलिभर मुद्रा),
				'other' => q(भेनेजुएलन बोलिभर-3),
			},
		},
		'VND' => {
			symbol => '₫',
			display_name => {
				'currency' => q(भियतनामी डङ्),
				'one' => q(भियतनामी डङ्),
				'other' => q(भियतनामी डङ्),
			},
		},
		'VUV' => {
			symbol => 'VUV',
			display_name => {
				'currency' => q(भानुआतू भातु),
				'one' => q(भानुआतू भातु),
				'other' => q(भानुआतू भातुहरू),
			},
		},
		'WST' => {
			symbol => 'WST',
			display_name => {
				'currency' => q(सामोआन ताला),
				'one' => q(सामोआन ताला),
				'other' => q(सामोआन ताला),
			},
		},
		'XAF' => {
			symbol => 'FCFA',
			display_name => {
				'currency' => q(सीएफ्‌ए फ्रान्क बीइएसी),
				'one' => q(सीएफ्‌ए फ्रान्क बीइएसी),
				'other' => q(सीएफ्‌ए फ्रान्क बीइएसी),
			},
		},
		'XCD' => {
			symbol => 'EC$',
			display_name => {
				'currency' => q(पूर्वी क्यारिबियन डलर),
				'one' => q(पूर्वी क्यारिबियन डलर),
				'other' => q(पूर्वी क्यारिबियन डलर),
			},
		},
		'XOF' => {
			symbol => 'F CFA',
			display_name => {
				'currency' => q(सीएफ्‌ए फ्रान्क बीसीइएओ),
				'one' => q(सीएफ्‌ए फ्रान्क बीसीइएओ),
				'other' => q(सीऐफ्‌ए फ्रान्क्स बीसीइएओ),
			},
		},
		'XPF' => {
			symbol => 'CFPF',
			display_name => {
				'currency' => q(सीएफ्‌पी फ्रान्क),
				'one' => q(सीएफ्‌पी फ्रान्क),
				'other' => q(सीएफ्‌पी फ्रान्कहरू),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(अज्ञात मुद्रा),
				'one' => q(अज्ञात मुद्रा),
				'other' => q(अज्ञात मुद्रा),
			},
		},
		'YER' => {
			symbol => 'YER',
			display_name => {
				'currency' => q(येमेनी रियाल),
				'one' => q(येमेनी रियाल),
				'other' => q(येमेनी रियाल),
			},
		},
		'ZAR' => {
			symbol => 'ZAR',
			display_name => {
				'currency' => q(दक्षिण अफ्रिकी र्‍यान्ड),
				'one' => q(दक्षिण अफ्रिकी र्‍यान्ड),
				'other' => q(दक्षिण अफ्रिकी र्‍यान्ड),
			},
		},
		'ZMK' => {
			display_name => {
				'currency' => q(जाम्बियाली क्वाचा \(१९६८–२०१२\)),
				'one' => q(जाम्बियाली क्वाचा \(१९६८–२०१२\)),
				'other' => q(जाम्बियाली क्वाचाहरू \(१९६८–२०१२\)),
			},
		},
		'ZMW' => {
			symbol => 'ZMW',
			display_name => {
				'currency' => q(जाम्बियाली क्वाचा),
				'one' => q(जाम्बियाली क्वाचा),
				'other' => q(जाम्बियाली क्वाचा),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'जनवरी',
							'फेब्रुअरी',
							'मार्च',
							'अप्रिल',
							'मे',
							'जुन',
							'जुलाई',
							'अगस्ट',
							'सेप्टेम्बर',
							'अक्टोबर',
							'नोभेम्बर',
							'डिसेम्बर'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'जन',
							'फेब',
							'मार्च',
							'अप्र',
							'मे',
							'जुन',
							'जुल',
							'अग',
							'सेप',
							'अक्टो',
							'नोभे',
							'डिसे'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'जनवरी',
							'फेब्रुअरी',
							'मार्च',
							'अप्रिल',
							'मे',
							'जुन',
							'जुलाई',
							'अगस्ट',
							'सेप्टेम्बर',
							'अक्टोबर',
							'नोभेम्बर',
							'डिसेम्बर'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'जनवरी',
							'फेब्रुअरी',
							'मार्च',
							'अप्रिल',
							'मे',
							'जुन',
							'जुलाई',
							'अगस्ट',
							'सेप्टेम्बर',
							'अक्टोबर',
							'नोभेम्बर',
							'डिसेम्बर'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'जन',
							'फेेब',
							'मार्च',
							'अप्र',
							'मे',
							'जुन',
							'जुल',
							'अग',
							'सेप',
							'अक्टो',
							'नोभे',
							'डिसे'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'जनवरी',
							'फेब्रुअरी',
							'मार्च',
							'अप्रिल',
							'मे',
							'जुन',
							'जुलाई',
							'अगस्ट',
							'सेप्टेम्बर',
							'अक्टोबर',
							'नोभेम्बर',
							'डिसेम्बर'
						],
						leap => [
							
						],
					},
				},
			},
			'indian' => {
				'format' => {
					wide => {
						nonleap => [
							'वैशाख',
							'जेठ',
							'असार',
							'साउन',
							'भदौ',
							'असोज',
							'कात्तिक',
							'मङसिर',
							'पुस',
							'माघ',
							'फागुन',
							'चैत'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'सोम',
						tue => 'मङ्गल',
						wed => 'बुध',
						thu => 'बिहि',
						fri => 'शुक्र',
						sat => 'शनि',
						sun => 'आइत'
					},
					narrow => {
						mon => 'सो',
						tue => 'म',
						wed => 'बु',
						thu => 'बि',
						fri => 'शु',
						sat => 'श',
						sun => 'आ'
					},
					short => {
						mon => 'सोम',
						tue => 'मङ्गल',
						wed => 'बुध',
						thu => 'बिहि',
						fri => 'शुक्र',
						sat => 'शनि',
						sun => 'आइत'
					},
					wide => {
						mon => 'सोमबार',
						tue => 'मङ्गलबार',
						wed => 'बुधबार',
						thu => 'बिहिबार',
						fri => 'शुक्रबार',
						sat => 'शनिबार',
						sun => 'आइतबार'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'सोम',
						tue => 'मङ्गल',
						wed => 'बुध',
						thu => 'बिहि',
						fri => 'शुक्र',
						sat => 'शनि',
						sun => 'आइत'
					},
					narrow => {
						mon => 'सो',
						tue => 'म',
						wed => 'बु',
						thu => 'बि',
						fri => 'शु',
						sat => 'श',
						sun => 'आ'
					},
					short => {
						mon => 'सोम',
						tue => 'मङ्गल',
						wed => 'बुध',
						thu => 'बिहि',
						fri => 'शुक्र',
						sat => 'शनि',
						sun => 'आइत'
					},
					wide => {
						mon => 'सोमबार',
						tue => 'मङ्गलबार',
						wed => 'बुधबार',
						thu => 'बिहिबार',
						fri => 'शुक्रबार',
						sat => 'शनिबार',
						sun => 'आइतबार'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'पहिलो सत्र',
						1 => 'दोस्रो सत्र',
						2 => 'तेस्रो सत्र',
						3 => 'चौथो सत्र'
					},
					narrow => {0 => '१',
						1 => '२',
						2 => '३',
						3 => '४'
					},
					wide => {0 => 'पहिलो सत्र',
						1 => 'दोस्रो सत्र',
						2 => 'तेस्रो सत्र',
						3 => 'चौथो सत्र'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => 'पहिलो सत्र',
						1 => 'दोस्रो सत्र',
						2 => 'तेस्रो सत्र',
						3 => 'चौथो सत्र'
					},
					narrow => {0 => '१',
						1 => '२',
						2 => '३',
						3 => '४'
					},
					wide => {0 => 'पहिलो सत्र',
						1 => 'दोस्रो सत्र',
						2 => 'तेस्रो सत्र',
						3 => 'चौथो सत्र'
					},
				},
			},
	} },
);

has 'day_period_data' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub { sub {
		# Time in hhmm format
		my ($self, $type, $time, $day_period_type) = @_;
		$day_period_type //= 'default';
		SWITCH:
		for ($type) {
			if ($_ eq 'generic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1900;
					return 'evening1' if $time >= 1900
						&& $time < 2200;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2200;
					return 'night1' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1900;
					return 'evening1' if $time >= 1900
						&& $time < 2200;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2200;
					return 'night1' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'gregorian') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1900;
					return 'evening1' if $time >= 1900
						&& $time < 2200;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2200;
					return 'night1' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1900;
					return 'evening1' if $time >= 1900
						&& $time < 2200;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2200;
					return 'night1' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'indian') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1900;
					return 'evening1' if $time >= 1900
						&& $time < 2200;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2200;
					return 'night1' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1900;
					return 'evening1' if $time >= 1900
						&& $time < 2200;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2200;
					return 'night1' if $time < 400;
				}
				last SWITCH;
				}
		}
	} },
);

around day_period_data => sub {
    my ($orig, $self) = @_;
    return $self->$orig;
};

has 'day_periods' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'abbreviated' => {
					'afternoon1' => q{अपरान्ह},
					'afternoon2' => q{साँझ},
					'am' => q{पूर्वाह्न},
					'evening1' => q{बेलुकी},
					'midnight' => q{मध्यरात},
					'morning1' => q{बिहान},
					'night1' => q{रात},
					'noon' => q{मध्यान्ह},
					'pm' => q{अपराह्न},
				},
				'narrow' => {
					'afternoon1' => q{अपरान्ह},
					'afternoon2' => q{साँझ},
					'am' => q{पूर्वाह्न},
					'evening1' => q{बेलुकी},
					'midnight' => q{मध्यरात},
					'morning1' => q{बिहान},
					'night1' => q{रात},
					'noon' => q{मध्यान्ह},
					'pm' => q{अपराह्न},
				},
				'wide' => {
					'afternoon1' => q{अपरान्ह},
					'afternoon2' => q{साँझ},
					'am' => q{पूर्वाह्न},
					'evening1' => q{बेलुकी},
					'midnight' => q{मध्यरात},
					'morning1' => q{बिहान},
					'night1' => q{रात},
					'noon' => q{मध्यान्ह},
					'pm' => q{अपराह्न},
				},
			},
			'stand-alone' => {
				'abbreviated' => {
					'afternoon1' => q{अपरान्ह},
					'afternoon2' => q{साँझ},
					'am' => q{पूर्वाह्न},
					'evening1' => q{बेलुकी},
					'midnight' => q{मध्यरात},
					'morning1' => q{बिहान},
					'night1' => q{रात},
					'noon' => q{मध्यान्ह},
					'pm' => q{अपराह्न},
				},
				'narrow' => {
					'afternoon1' => q{अपरान्ह},
					'afternoon2' => q{साँझ},
					'am' => q{पूर्वाह्न},
					'evening1' => q{बेलुकी},
					'midnight' => q{मध्यरात},
					'morning1' => q{बिहान},
					'night1' => q{रात},
					'noon' => q{मध्यान्ह},
					'pm' => q{अपराह्न},
				},
				'wide' => {
					'afternoon1' => q{अपरान्ह},
					'afternoon2' => q{साँझ},
					'am' => q{पूर्वाह्न},
					'evening1' => q{बेलुकी},
					'midnight' => q{मध्यरात},
					'morning1' => q{बिहान},
					'night1' => q{रात},
					'noon' => q{मध्यान्ह},
					'pm' => q{अपराह्न},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'ईसा पूर्व',
				'1' => 'सन्'
			},
			wide => {
				'0' => 'ईसा पूर्व',
				'1' => 'सन्'
			},
		},
		'indian' => {
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{G y MMMM d, EEEE},
			'long' => q{G y MMMM d},
			'medium' => q{G y MMM d},
			'short' => q{GGGGG y-MM-dd},
		},
		'gregorian' => {
			'full' => q{y MMMM d, EEEE},
			'long' => q{y MMMM d},
			'medium' => q{y MMM d},
			'short' => q{yy/M/d},
		},
		'indian' => {
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			'full' => q{HH:mm:ss zzzz},
			'long' => q{HH:mm:ss z},
			'medium' => q{HH:mm:ss},
			'short' => q{HH:mm},
		},
		'indian' => {
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{{1}{0}मा},
			'long' => q{{1}{0}मा},
			'medium' => q{{1},{0}},
			'short' => q{{1},{0}},
		},
		'gregorian' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1}, {0}},
			'short' => q{{1}, {0}},
		},
		'indian' => {
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Bh => q{h B},
			Bhm => q{h:mm B},
			Bhms => q{h:mm:ss B},
			E => q{ccc},
			EBhm => q{E h:mm B},
			EBhms => q{E h:mm:ss B},
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{d, E},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{G y},
			GyMMM => q{G y MMM},
			GyMMMEd => q{G y MMM d, E},
			GyMMMd => q{G y MMM d},
			GyMd => q{M/d/y GGGGG},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{MM/dd, E},
			MMM => q{LLL},
			MMMEd => q{MMM d, E},
			MMMMd => q{MMMM d},
			MMMd => q{MMM d},
			Md => q{MM-dd},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{G y},
			yyyy => q{G y},
			yyyyM => q{GGGGG y-MM},
			yyyyMEd => q{GGGGG y-MM-dd, E},
			yyyyMMM => q{G y MMM},
			yyyyMMMEd => q{G y MMM d, E},
			yyyyMMMM => q{G y MMMM},
			yyyyMMMd => q{G y MMM d},
			yyyyMd => q{GGGGG y-MM-dd},
			yyyyQQQ => q{G y QQQ},
			yyyyQQQQ => q{G y QQQQ},
		},
		'gregorian' => {
			Bh => q{h B},
			Bhm => q{h:mm B},
			Bhms => q{h:mm:ss B},
			E => q{ccc},
			EBhm => q{E h:mm B},
			EBhms => q{E h:mm:ss B},
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{d E},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{G y},
			GyMMM => q{G y MMM},
			GyMMMEd => q{G y MMM d, E},
			GyMMMd => q{G y MMM d},
			GyMd => q{M/d/y GGGGG},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			Hmsv => q{HH:mm:ss v},
			Hmv => q{HH:mm v},
			M => q{L},
			MEd => q{MM-dd, E},
			MMM => q{LLL},
			MMMEd => q{MMM d, E},
			MMMMW => q{MMMM को W हप्ता},
			MMMMd => q{MMMM d},
			MMMd => q{MMM d},
			Md => q{MM-dd},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			hmsv => q{h:mm:ss a v},
			hmv => q{h:mm a v},
			ms => q{mm:ss},
			y => q{y},
			yM => q{y-MM},
			yMEd => q{y-MM-dd, E},
			yMMM => q{y MMM},
			yMMMEd => q{y MMM d, E},
			yMMMM => q{y MMMM},
			yMMMd => q{y MMM d},
			yMd => q{y-MM-dd},
			yQQQ => q{y QQQ},
			yQQQQ => q{y QQQQ},
			yw => q{Y को w हप्ता},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'Timezone' => '{0} {1}',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			M => {
				M => q{MM–MM},
			},
			MEd => {
				M => q{MM/dd, E – MM/dd, E},
				d => q{MM/dd, E – MM/dd, E},
			},
			MMM => {
				M => q{LLL–LLL},
			},
			MMMEd => {
				M => q{MMM d, E – MMM d, E},
				d => q{MMM d, E – MMM d, E},
			},
			MMMd => {
				M => q{MMM d – MMM d},
				d => q{MMM d–d},
			},
			Md => {
				M => q{MM-dd – MM-dd},
				d => q{MM-dd – MM-dd},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			y => {
				y => q{G y–y},
			},
			yM => {
				M => q{GGGGG y-MM – y-MM},
				y => q{GGGGG y-MM – y-MM},
			},
			yMEd => {
				M => q{GGGGG y-MM-dd, E – y-MM-dd, E},
				d => q{GGGGG y-MM-dd, E – y-MM-dd, E},
				y => q{GGGGG y-MM-dd, E – y-MM-dd, E},
			},
			yMMM => {
				M => q{G y MMM–MMM},
				y => q{G y MMM – y MMM},
			},
			yMMMEd => {
				M => q{G y MMM d, E – MMM d, E},
				d => q{G y MMM d, E – MMM d, E},
				y => q{G y MMM d, E – y MMM d, E},
			},
			yMMMM => {
				M => q{G y MMMM–MMMM},
				y => q{G y MMMM – y MMMM},
			},
			yMMMd => {
				M => q{G y MMM d – MMM d},
				d => q{G y MMM d–d},
				y => q{G y MMM d – y MMM d},
			},
			yMd => {
				M => q{GGGGG y-MM-dd – y-MM-dd},
				d => q{GGGGG y-MM-dd – y-MM-dd},
				y => q{GGGGG y-MM-dd – y-MM-dd},
			},
		},
		'gregorian' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{MM–MM},
			},
			MEd => {
				M => q{MM-dd, E – MM-dd, E},
				d => q{MM-dd, E – MM-dd, E},
			},
			MMM => {
				M => q{LLL–LLL},
			},
			MMMEd => {
				M => q{MMM d, E – MMM d, E},
				d => q{MMM d, E – MMM d, E},
			},
			MMMd => {
				M => q{MMM d – MMM d},
				d => q{MMM d–d},
			},
			Md => {
				M => q{MM-dd – MM-dd},
				d => q{MM-dd – MM-dd},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y–y},
			},
			yM => {
				M => q{y-MM – y-MM},
				y => q{y-MM – y-MM},
			},
			yMEd => {
				M => q{y-MM-dd, E – y-MM-dd, E},
				d => q{y-MM-dd, E – y-MM-dd, E},
				y => q{y-MM-dd, E – y-MM-dd, E},
			},
			yMMM => {
				M => q{y MMM–MMM},
				y => q{y MMM – y MMM},
			},
			yMMMEd => {
				M => q{y MMM d, E – MMM d, E},
				d => q{y MMM d, E – MMM d, E},
				y => q{y MMM d, E – y MMM d, E},
			},
			yMMMM => {
				M => q{y MMMM–MMMM},
				y => q{y MMMM – y MMMM},
			},
			yMMMd => {
				M => q{y MMM d – MMM d},
				d => q{y MMM d–d},
				y => q{y MMM d – y MMM d},
			},
			yMd => {
				M => q{y-MM-dd – y-MM-dd},
				d => q{y-MM-dd – y-MM-dd},
				y => q{y-MM-dd – y-MM-dd},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HH:mm;-HH:mm),
		gmtFormat => q(GMT{0}),
		gmtZeroFormat => q(GMT),
		regionFormat => q({0} समय),
		regionFormat => q({0} (+१)),
		regionFormat => q({0} (+०)),
		fallbackFormat => q({1} ({0})),
		'Afghanistan' => {
			long => {
				'standard' => q#अफगानिस्तान समय#,
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#अविड्जान#,
		},
		'Africa/Accra' => {
			exemplarCity => q#अक्रा#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#एड्डिस आबाबा#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#अल्जियर्स#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#आस्मारा#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#बोमाको#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#बाङ्गुवी#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#बन्जुल#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#बिसाउ#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#ब्लान्टायर#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#ब्राजाभिल्ले#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#बुजुम्बुरा#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#काइरो#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#कासाब्लान्का#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#सेउटा#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#कोनाक्री#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#डाकार#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#डार एस् सलाम#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#जिबौंटी#,
		},
		'Africa/Douala' => {
			exemplarCity => q#डोउआला#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#एल् आइयुन#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#फ्रिटाउन#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#गावोरोन#,
		},
		'Africa/Harare' => {
			exemplarCity => q#हरारे#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#जोहानेसवर्ग#,
		},
		'Africa/Juba' => {
			exemplarCity => q#जुबा#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#काम्पाला#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#खार्टउम#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#किगाली#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#किन्शासा#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#लागोस#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#लिब्रेभिल्ले#,
		},
		'Africa/Lome' => {
			exemplarCity => q#लोम#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#लुवान्डा#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#लुबुम्बासी#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#लुसाका#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#मालाबो#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#मापुतो#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#मासेरू#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#एमबाबेन#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#मोगाडिशु#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#मोन्रोभिया#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#नाइरोबी#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#एन्‌जामेना#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#नायमे#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#नोउआकचोट#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#औआगाडौगौ#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#पोर्टो-नोभो#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#साओ टोमे#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#त्रिपोली#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#टुनिस#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#विन्डहोएक#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q#केन्द्रीय अफ्रिकी समय#,
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q#पूर्वी अफ्रिकी समय#,
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q#दक्षिण अफ्रिकी समय#,
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q#पश्चिम अफ्रिकी ग्रीष्मकालीन समय#,
				'generic' => q#पश्चिम अफ्रिकी समय#,
				'standard' => q#पश्चिम अफ्रिकी मानक समय#,
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q#अलस्काको दिवा समय#,
				'generic' => q#अलस्काको समय#,
				'standard' => q#अलस्काको मानक समय#,
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q#एमाजोन ग्रीष्मकालीन समय#,
				'generic' => q#एमाजोन समय#,
				'standard' => q#एमाजोन मानक समय#,
			},
		},
		'America/Adak' => {
			exemplarCity => q#आडाक#,
		},
		'America/Anchorage' => {
			exemplarCity => q#एङ्कोरेज#,
		},
		'America/Anguilla' => {
			exemplarCity => q#एङ्ग्विल्ला#,
		},
		'America/Antigua' => {
			exemplarCity => q#एन्टिगुवा#,
		},
		'America/Araguaina' => {
			exemplarCity => q#आरागुवाना#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#ला रियोजा#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#रियो ग्यालेगोस#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#साल्टा#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#सान जुवान#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#सान लुइस#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#टुकुमान#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#उशुआइआ#,
		},
		'America/Aruba' => {
			exemplarCity => q#अरुबा#,
		},
		'America/Asuncion' => {
			exemplarCity => q#असन्सियन#,
		},
		'America/Bahia' => {
			exemplarCity => q#बाहिया#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#बाहिया बान्डेराश#,
		},
		'America/Barbados' => {
			exemplarCity => q#बार्बाडोस#,
		},
		'America/Belem' => {
			exemplarCity => q#बेलेम#,
		},
		'America/Belize' => {
			exemplarCity => q#बेलिज#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#ब्लान्क-साब्लोन#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#बोआ भिष्टा#,
		},
		'America/Bogota' => {
			exemplarCity => q#बोगोटा#,
		},
		'America/Boise' => {
			exemplarCity => q#बोइज#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#ब्यनेश आयर्स#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#क्याम्ब्रिज बे#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#क्याम्पो ग्रान्डे#,
		},
		'America/Cancun' => {
			exemplarCity => q#कानकुन#,
		},
		'America/Caracas' => {
			exemplarCity => q#काराकास#,
		},
		'America/Catamarca' => {
			exemplarCity => q#कातामार्का#,
		},
		'America/Cayenne' => {
			exemplarCity => q#कायेन्ने#,
		},
		'America/Cayman' => {
			exemplarCity => q#केम्यान#,
		},
		'America/Chicago' => {
			exemplarCity => q#शिकागो#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#चिहुवाहुवा#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#एटिकोकान#,
		},
		'America/Cordoba' => {
			exemplarCity => q#कोरडोवा#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#कोष्टा रिका#,
		},
		'America/Creston' => {
			exemplarCity => q#क्रेस्टन#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#क्युइआबा#,
		},
		'America/Curacao' => {
			exemplarCity => q#कुराकाओ#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#डान्मार्कशाभन#,
		},
		'America/Dawson' => {
			exemplarCity => q#डसन#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#डसन क्रिक#,
		},
		'America/Denver' => {
			exemplarCity => q#डेन्भर#,
		},
		'America/Detroit' => {
			exemplarCity => q#डिट्रोइट#,
		},
		'America/Dominica' => {
			exemplarCity => q#डोमिनिका#,
		},
		'America/Edmonton' => {
			exemplarCity => q#एड्मोन्टन#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#आइरनेपे#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#एल् साल्भाडोर#,
		},
		'America/Fort_Nelson' => {
			exemplarCity => q#फोर्ट नेल्सन#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#फोर्टालेजा#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#ग्लेस बे#,
		},
		'America/Godthab' => {
			exemplarCity => q#नूक#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#गुज बे#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#ग्रान्ड टर्क#,
		},
		'America/Grenada' => {
			exemplarCity => q#ग्रेनाडा#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#ग्वाडेलुप#,
		},
		'America/Guatemala' => {
			exemplarCity => q#ग्वाटेमाला#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#गुयाक्विल#,
		},
		'America/Guyana' => {
			exemplarCity => q#गुयाना#,
		},
		'America/Halifax' => {
			exemplarCity => q#ह्यालिफ्याक्स#,
		},
		'America/Havana' => {
			exemplarCity => q#हभाना#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#हेर्मोसिल्लो#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#नोक्स इन्डियाना#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#मारेन्गो, इन्डियाना#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#पिटर्सबर्ग, इन्डियाना#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#टेल सिटी, इन्डियाना#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#भेभे, इन्डियाना#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#भिन्सेन्स#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#विनामाक, इन्डियाना#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#इन्डियानापोलिस#,
		},
		'America/Inuvik' => {
			exemplarCity => q#इनुभिक#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#इक्वालुइट#,
		},
		'America/Jamaica' => {
			exemplarCity => q#जमाइका#,
		},
		'America/Jujuy' => {
			exemplarCity => q#जुजुई#,
		},
		'America/Juneau' => {
			exemplarCity => q#जुनिउ#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#मोन्टिसेल्लो,केन्टकी#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#कालेन्देजिक#,
		},
		'America/La_Paz' => {
			exemplarCity => q#ला पाज#,
		},
		'America/Lima' => {
			exemplarCity => q#लिमा#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#लस् एन्जेलस#,
		},
		'America/Louisville' => {
			exemplarCity => q#लुइसभिल्ले#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#लोअर प्रिन्स्स क्वार्टर#,
		},
		'America/Maceio' => {
			exemplarCity => q#मासेइओ#,
		},
		'America/Managua' => {
			exemplarCity => q#मानागुवा#,
		},
		'America/Manaus' => {
			exemplarCity => q#मानाउस#,
		},
		'America/Marigot' => {
			exemplarCity => q#म्यारिगट#,
		},
		'America/Martinique' => {
			exemplarCity => q#मार्टिनिक#,
		},
		'America/Matamoros' => {
			exemplarCity => q#माट्तामोरोस्#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#माजाट्लान#,
		},
		'America/Mendoza' => {
			exemplarCity => q#मेन्डोजा#,
		},
		'America/Menominee' => {
			exemplarCity => q#मेनोमिनी#,
		},
		'America/Merida' => {
			exemplarCity => q#मेरिडा#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#मेट्लाक्टला#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#मेक्सिको सिटी#,
		},
		'America/Miquelon' => {
			exemplarCity => q#मिक्विलन#,
		},
		'America/Moncton' => {
			exemplarCity => q#मोन्कटन#,
		},
		'America/Monterrey' => {
			exemplarCity => q#मोन्टेर्रे#,
		},
		'America/Montevideo' => {
			exemplarCity => q#मोन्टेभिडियो#,
		},
		'America/Montserrat' => {
			exemplarCity => q#मन्टसेर्राट#,
		},
		'America/Nassau' => {
			exemplarCity => q#नास्साउ#,
		},
		'America/New_York' => {
			exemplarCity => q#न्युयोर्क#,
		},
		'America/Nipigon' => {
			exemplarCity => q#निपिगन#,
		},
		'America/Nome' => {
			exemplarCity => q#नोम#,
		},
		'America/Noronha' => {
			exemplarCity => q#नोरोन्हा#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#बेउला, उत्तर डाकोटा#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#उत्तर डाकोटा, केन्द्र#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#नयाँ सालेम, उत्तर डाकोटा#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#ओजिनागा#,
		},
		'America/Panama' => {
			exemplarCity => q#पानामा#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#पाङ्निरतुङ#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#पारामारिवो#,
		},
		'America/Phoenix' => {
			exemplarCity => q#फिनिक्स#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#पोर्ट-अउ-प्रिन्स#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#पोर्ट अफ् स्पेन#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#पोर्टो भेल्हो#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#प्युर्टो रिको#,
		},
		'America/Punta_Arenas' => {
			exemplarCity => q#पुन्टा अरिनाज#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#रेनिरिभर#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#रान्किन इन्लेट#,
		},
		'America/Recife' => {
			exemplarCity => q#रिसाइफ#,
		},
		'America/Regina' => {
			exemplarCity => q#रेजिना#,
		},
		'America/Resolute' => {
			exemplarCity => q#रिजोलुट#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#रियो ब्रान्को#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#सान्टा ईसाबेल#,
		},
		'America/Santarem' => {
			exemplarCity => q#सान्टारेम#,
		},
		'America/Santiago' => {
			exemplarCity => q#सान्टिआगो#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#सान्टो डोमिङ्गो#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#साओ पाउलो#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#ईट्टोक्कोरटूर्मिट#,
		},
		'America/Sitka' => {
			exemplarCity => q#सिट्का#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#सेन्ट बार्थेलेमी#,
		},
		'America/St_Johns' => {
			exemplarCity => q#सेन्ट जोन्स#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#सेन्ट् किट्स#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#सेन्ट लुसिया#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#सेन्ट थोमस#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#सेन्ट भिन्सेन्ट#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#स्विफ्ट करेन्ट#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#टेगुसिगाल्पा#,
		},
		'America/Thule' => {
			exemplarCity => q#थुले#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#थण्डर बे#,
		},
		'America/Tijuana' => {
			exemplarCity => q#तिजुआना#,
		},
		'America/Toronto' => {
			exemplarCity => q#टोरोण्टो#,
		},
		'America/Tortola' => {
			exemplarCity => q#टार्टोला#,
		},
		'America/Vancouver' => {
			exemplarCity => q#भ्यानकोभर#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#ह्वाइटहर्स#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#विन्निपेग#,
		},
		'America/Yakutat' => {
			exemplarCity => q#याकुटाट#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#येल्लोनाइफ#,
		},
		'America_Central' => {
			long => {
				'daylight' => q#केन्द्रीय दिवा समय#,
				'generic' => q#केन्द्रीय समय#,
				'standard' => q#केन्द्रीय मानक समय#,
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q#पूर्वी दिवा समय#,
				'generic' => q#पूर्वी समय#,
				'standard' => q#पूर्वी मानक समय#,
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q#हिमाली दिवा समय#,
				'generic' => q#हिमाली समय#,
				'standard' => q#हिमाली मानक समय#,
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q#प्यासिफिक दिवा समय#,
				'generic' => q#प्यासिफिक समय#,
				'standard' => q#प्यासिफिक मानक समय#,
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#केजे#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#डेभिस#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#दुमोन्ट डि उर्भेल्ले#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#मक्वारिई#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#माउसन#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#माकमुर्डो#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#पाल्मेर#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#रोथेरा#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#सिओआ#,
		},
		'Antarctica/Troll' => {
			exemplarCity => q#ट्रोल#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#भास्टोक#,
		},
		'Apia' => {
			long => {
				'daylight' => q#आपिया दिवा समय#,
				'generic' => q#आपिया समय#,
				'standard' => q#आपिया मानक समय#,
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q#अरबी दिवा समय#,
				'generic' => q#अरबी समय#,
				'standard' => q#अरबी मानक समय#,
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#लङयिअरबाइएन#,
		},
		'Argentina' => {
			long => {
				'daylight' => q#अर्जेनटिनी ग्रीष्मकालीन समय#,
				'generic' => q#अर्जेनटिनी समय#,
				'standard' => q#अर्जेनटिनी मानक समय#,
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q#पश्चिमी अर्जेनटिनी ग्रीष्मकालीन समय#,
				'generic' => q#पश्चिमी अर्जेनटिनी समय#,
				'standard' => q#पश्चिमी अर्जेनटिनी मानक समय#,
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q#अर्मेनिया ग्रीष्मकालीन समय#,
				'generic' => q#अर्मेनिया समय#,
				'standard' => q#अर्मेनिया मानक समय#,
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#एडेन#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#आल्माटी#,
		},
		'Asia/Amman' => {
			exemplarCity => q#आम्मान#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#आनाडियर#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#आक्टाउ#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#आक्टोब#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#अस्काबाट#,
		},
		'Asia/Atyrau' => {
			exemplarCity => q#अटिराउ#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#बगदाद#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#बहराईन#,
		},
		'Asia/Baku' => {
			exemplarCity => q#बाकु#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#बैंकक#,
		},
		'Asia/Barnaul' => {
			exemplarCity => q#बरनौल#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#बेईरुट#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#बिसकेक्#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#ब्रुनाइ#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#कोलकाता#,
		},
		'Asia/Chita' => {
			exemplarCity => q#चिता#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#चोइबाल्सान#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#कोलम्बो#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#दामास्कस्#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#ढाका#,
		},
		'Asia/Dili' => {
			exemplarCity => q#दिल्ली#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#दुबही#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#दस्सान्बे#,
		},
		'Asia/Famagusta' => {
			exemplarCity => q#फामागुस्ता#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#गाजा#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#हिब्रोन#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#हङकङ#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#होभ्ड#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#इर्कुत्स्क#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#जाकार्ता#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#जयापुरा#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#जेरुसलेम#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#काबुल#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#कामचट्का#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#कराची#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#काठमाण्डौं#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#खान्दिगा#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#क्रास्नोयार्स्क#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#कुआ लाम्पुर#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#कुचिङ#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#कुवेत#,
		},
		'Asia/Macau' => {
			exemplarCity => q#मकाउ#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#मागाडान#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#माकास्सार#,
		},
		'Asia/Manila' => {
			exemplarCity => q#मनिला#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#मस्क्याट#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#निकोसिया#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#नेभोकुजनेस्क#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#नोबोसिबिर्स्क#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#ओम्स्क#,
		},
		'Asia/Oral' => {
			exemplarCity => q#ओरल#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#फेनोम फेन#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#पोन्टिआनाक#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#प्योङयाङ#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#कतार#,
		},
		'Asia/Qostanay' => {
			exemplarCity => q#कस्टाने#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#किजिलोर्डा#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#रान्गुन#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#रियाद#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#हो ची मिन्ह शहर#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#साखालिन#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#समारकण्ड#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#सिओल#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#सान्घाई#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#सिंगापुर#,
		},
		'Asia/Srednekolymsk' => {
			exemplarCity => q#स्रेद्निकोलिम्स्क#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#ताईपे#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#तास्केन्ट#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#तिबिलिसी#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#तेहेरान#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#थिम्पु#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#टोकियो#,
		},
		'Asia/Tomsk' => {
			exemplarCity => q#टोम्स्क#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#उलानबटार#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#उरूम्की#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#उस्ट-नेरा#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#भियन्तिन#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#भ्लाडिभास्टोक#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#याकुत्स्क#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#एकटरिनबुर्ग#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#येरेभान#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q#एट्लान्टिक दिवा समय#,
				'generic' => q#एट्लान्टिक समय#,
				'standard' => q#एट्लान्टिक मानक समय#,
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#आजोर्स#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#बर्मुडा#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#क्यानारी#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#केप भर्डे#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#फारोइ#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#माडेइरा#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#रेक्जाभिक#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#दक्षिण जर्जिया#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#सेन्ट हेलेना#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#स्ट्यान्ली#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#एडेलेड#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#ब्रिस्बेन#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#ब्रोकन हिल#,
		},
		'Australia/Currie' => {
			exemplarCity => q#क्युरी#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#डार्विन#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#इयुक्ला#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#होभार्ट#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#लिन्डेम्यान#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#लर्ड होवे#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#मेल्बर्न#,
		},
		'Australia/Perth' => {
			exemplarCity => q#पर्थ#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#सिड्नी#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q#केन्द्रीय अस्ट्रेलिया दिवा समय#,
				'generic' => q#केन्द्रीय अस्ट्रेलिया समय#,
				'standard' => q#केन्द्रीय अस्ट्रेलिया मानक समय#,
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q#केन्द्रीय पश्चिमी अस्ट्रेलिया दिवा समय#,
				'generic' => q#केन्द्रीय पश्चिमी अस्ट्रेलिया समय#,
				'standard' => q#केन्द्रीय पश्चिमी अस्ट्रेलिया मानक समय#,
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q#पूर्वी अस्ट्रेलिया दिवा समय#,
				'generic' => q#पूर्वी अस्ट्रेलिया समय#,
				'standard' => q#पूर्वी अस्ट्रेलिया मानक समय#,
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q#पश्चिमी अस्ट्रेलिया दिवा समय#,
				'generic' => q#पश्चिमी अस्ट्रेलिया समय#,
				'standard' => q#पश्चिमी अस्ट्रेलिया मानक समय#,
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q#अजरबैजान ग्रीष्मकालीन समय#,
				'generic' => q#अजरबैजान समय#,
				'standard' => q#अजरबैजान मानक समय#,
			},
		},
		'Azores' => {
			long => {
				'daylight' => q#एजोरेस् ग्रीष्मकालीन समय#,
				'generic' => q#एजोरेस् समय#,
				'standard' => q#एजोरेस् मानक समय#,
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q#बंगलादेशी ग्रीष्मकालीन समय#,
				'generic' => q#बंगलादेशी समय#,
				'standard' => q#बंगलादेशी मानक समय#,
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q#भुटानी समय#,
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q#बोलिभिया समय#,
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q#ब्राजिलीया ग्रीष्मकालीन समय#,
				'generic' => q#ब्राजिलीया समय#,
				'standard' => q#ब्राजिलिया मानक समय#,
			},
		},
		'Brunei' => {
			long => {
				'standard' => q#ब्रुनाइ दारूस्सलम समय#,
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q#केप भर्दे ग्रीष्मकालीन समय#,
				'generic' => q#केप भर्दे समय#,
				'standard' => q#केप भर्दे मानक समय#,
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q#चामोर्रो मानक समय#,
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q#चाथाम दिवा समय#,
				'generic' => q#चाथाम समय#,
				'standard' => q#चाथाम मानक समय#,
			},
		},
		'Chile' => {
			long => {
				'daylight' => q#चिली ग्रीष्मकालीन समय#,
				'generic' => q#चिली समय#,
				'standard' => q#चिली मानक समय#,
			},
		},
		'China' => {
			long => {
				'daylight' => q#चीन दिवा समय#,
				'generic' => q#चीन समय#,
				'standard' => q#चीन मानक समय#,
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q#चोइबाल्सन ग्रीष्मकालीन समय#,
				'generic' => q#चोइबाल्सन समय#,
				'standard' => q#चोइबाल्सन मानक समय#,
			},
		},
		'Christmas' => {
			long => {
				'standard' => q#क्रिस्मस टापु समय#,
			},
		},
		'Cocos' => {
			long => {
				'standard' => q#कोकोस टापु समय#,
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q#कोलम्बियाली ग्रीष्मकालीन समय#,
				'generic' => q#कोलम्बियाली समय#,
				'standard' => q#कोलम्बियाली मानक समय#,
			},
		},
		'Cook' => {
			long => {
				'daylight' => q#कुक टापु आधा ग्रीष्मकालीन समय#,
				'generic' => q#कुक टापु समय#,
				'standard' => q#कुक टापु मानक समय#,
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q#क्यूबाको दिवा समय#,
				'generic' => q#क्यूबाको समय#,
				'standard' => q#क्यूबाको मानक समय#,
			},
		},
		'Davis' => {
			long => {
				'standard' => q#डेभिस समय#,
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q#डुमोन्ट-डी‘ उर्भिले समय#,
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q#पूर्वी टिमोर समय#,
			},
		},
		'Easter' => {
			long => {
				'daylight' => q#इस्टर टापू ग्रीष्म समय#,
				'generic' => q#इस्टर टापू समय#,
				'standard' => q#इस्टर टापू मानक समय#,
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q#ईक्वोडोर समय#,
			},
		},
		'Etc/UTC' => {
			long => {
				'standard' => q#समन्वित विश्व समय#,
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#अज्ञात शहर#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#एम्स्ट्र्डम#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#आन्डोर्रा#,
		},
		'Europe/Astrakhan' => {
			exemplarCity => q#अस्त्रखान#,
		},
		'Europe/Athens' => {
			exemplarCity => q#एथेन्स#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#बेलग्रेड#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#बर्लिन#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#ब्राटिस्लाभा#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#ब्रसेल्स#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#वुचारेस्ट#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#बुडापेस्ट#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#बुसिन्नगन#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#चिसिनाउ#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#कोपेनह्यागन#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#डब्लिन#,
			long => {
				'daylight' => q#आइरिश मानक समय#,
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#जिब्राल्टार#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#गुएर्नसे#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#हेल्सिन्की#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#इजल अफ् म्यान#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#ईस्टानबुल#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#जर्सी#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#कालिनिनग्राद#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#किभ#,
		},
		'Europe/Kirov' => {
			exemplarCity => q#किरोभ#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#लिस्बोन#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#लजुबिजाना#,
		},
		'Europe/London' => {
			exemplarCity => q#लण्डन#,
			long => {
				'daylight' => q#बेलायती ग्रीष्मकालीन समय#,
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#लक्जेम्वर्ग#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#म्याड्रिड#,
		},
		'Europe/Malta' => {
			exemplarCity => q#माल्टा#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#म्यारिह्याम्न#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#मिन्स्क#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#मोनाको#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#मस्को#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#ओस्लो#,
		},
		'Europe/Paris' => {
			exemplarCity => q#पेरिस#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#पड्गोरिका#,
		},
		'Europe/Prague' => {
			exemplarCity => q#प्राग#,
		},
		'Europe/Riga' => {
			exemplarCity => q#रिगा#,
		},
		'Europe/Rome' => {
			exemplarCity => q#रोम#,
		},
		'Europe/Samara' => {
			exemplarCity => q#सामारा#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#सान मारिनो#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#साराजेभो#,
		},
		'Europe/Saratov' => {
			exemplarCity => q#साराटोभ#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#सिम्फेरोपोल#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#स्कोपजे#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#सोफिया#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#स्टकहोल्म#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#ताल्लिन#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#टिराने#,
		},
		'Europe/Ulyanovsk' => {
			exemplarCity => q#उल्यानोभ्स्क#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#उझगोरद#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#भाडुज#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#भ्याटिकन#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#भियना#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#भिल्निअस#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#भोल्गोग्राद#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#वारसअ#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#जाग्रेब#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#जापोरोझ्ये#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#जुरिक#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q#केन्द्रीय युरोपेली ग्रीष्मकालीन समय#,
				'generic' => q#केन्द्रीय युरोपेली समय#,
				'standard' => q#केन्द्रीय युरोपेली मानक समय#,
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q#पूर्वी युरोपेली ग्रीष्मकालीन समय#,
				'generic' => q#पूर्वी युरोपेली समय#,
				'standard' => q#पूर्वी युरोपेली मानक समय#,
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q#थप-पूर्वी युरोपेली समय#,
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q#युरोपेली ग्रीष्मकालीन समय#,
				'generic' => q#पश्चिमी युरोपेली समय#,
				'standard' => q#पश्चिमी युरोपेली मानक समय#,
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q#फल्कल्यान्ड टापू ग्रीष्मकालीन समय#,
				'generic' => q#फल्कल्यान्ड टापू समय#,
				'standard' => q#फल्कल्यान्ड टापू मानक समय#,
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q#फिजी ग्रीष्मकालीन समय#,
				'generic' => q#फिजी समय#,
				'standard' => q#फिजी मानक समय#,
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q#फ्रेन्च ग्वाना समय#,
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q#फ्रेन्च दक्षिणी र अन्टार्टिक समय#,
			},
		},
		'GMT' => {
			long => {
				'standard' => q#ग्रीनविच मिन समय#,
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q#गालापागोस् समय#,
			},
		},
		'Gambier' => {
			long => {
				'standard' => q#ग्याम्बियर समय#,
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q#जर्जिया ग्रीष्मकालीन समय#,
				'generic' => q#जर्जिया समय#,
				'standard' => q#जर्जिया मानक समय#,
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q#गिल्बर्ट टापु समय#,
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q#पूर्वी ग्रीनल्यान्डको ग्रीष्मकालीन समय#,
				'generic' => q#पूर्वी ग्रीनल्यान्डको समय#,
				'standard' => q#पूर्वी ग्रीनल्यान्डको मानक समय#,
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q#पश्चिमी ग्रीनल्यान्डको ग्रीष्मकालीन समय#,
				'generic' => q#पश्चिमी ग्रीनल्यान्डको समय#,
				'standard' => q#पश्चिमी ग्रीनल्यान्डको मानक समय#,
			},
		},
		'Gulf' => {
			long => {
				'standard' => q#खाडी मानक समय#,
			},
		},
		'Guyana' => {
			long => {
				'standard' => q#गुयाना समय#,
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q#हवाई-एलुटियन दिवा समय#,
				'generic' => q#हवाई-एलुटियन समय#,
				'standard' => q#हवाई-एलुटियन मानक समय#,
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q#हङकङ ग्रीष्मकालीन समय#,
				'generic' => q#हङकङ समय#,
				'standard' => q#हङकङ मानक समय#,
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q#होब्ड ग्रीष्मकालीन समय#,
				'generic' => q#होब्ड समय#,
				'standard' => q#होब्ड मानक समय#,
			},
		},
		'India' => {
			long => {
				'standard' => q#भारतीय मानक समय#,
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#अन्टानारिभो#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#चागोस#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#ख्रिस्टमस#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#कोकोस#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#कोमोरो#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#केर्गुएलेन#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#माहे#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#माल्दिभ्स#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#मउरिटिअस#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#मायोट्टे#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#रियुनियन#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q#हिन्द महासागर समय#,
			},
		},
		'Indochina' => {
			long => {
				'standard' => q#इन्डोचाइना समय#,
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q#केन्द्रीय इन्डोनेशिया समय#,
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q#पूर्वी इन्डोनेशिया समय#,
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q#पश्चिमी इन्डोनेशिया समय#,
			},
		},
		'Iran' => {
			long => {
				'daylight' => q#इरानी दिवा समय#,
				'generic' => q#इरानी समय#,
				'standard' => q#इरानी मानक समय#,
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q#ईर्कुट्स्क ग्रीष्मकालीन समय#,
				'generic' => q#ईर्कुट्स्क समय#,
				'standard' => q#ईर्कुट्स्क मानक समय#,
			},
		},
		'Israel' => {
			long => {
				'daylight' => q#इजरायल दिवा समय#,
				'generic' => q#इजरायल समय#,
				'standard' => q#इजरायल मानक समय#,
			},
		},
		'Japan' => {
			long => {
				'daylight' => q#जापान दिवा समय#,
				'generic' => q#जापान समय#,
				'standard' => q#जापान मानक समय#,
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q#पूर्वी काजकस्तान समय#,
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q#पश्चिम काजकस्तान समय#,
			},
		},
		'Korea' => {
			long => {
				'daylight' => q#कोरियाली दिवा समय#,
				'generic' => q#कोरियाली समय#,
				'standard' => q#कोरियाली मानक समय#,
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q#कोसराए समय#,
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q#क्रासनोयार्क ग्रीष्मकालीन समय#,
				'generic' => q#क्रासनोयार्क समय#,
				'standard' => q#क्रासनोयार्क मानक समय#,
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q#किर्गिस्तान समय#,
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q#लाइन टापु समय#,
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q#लर्ड हावे दिवा समय#,
				'generic' => q#लर्ड हावे समय#,
				'standard' => q#लर्ड हावे मानक समय#,
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q#माक्वेरी टापु समय#,
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q#मागादान ग्रीष्मकालीन समय#,
				'generic' => q#मागादान समय#,
				'standard' => q#मागादान मानक समय#,
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q#मलेसिया समय#,
			},
		},
		'Maldives' => {
			long => {
				'standard' => q#माल्दिभ्स समय#,
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q#मार्किसस समय#,
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q#मार्शल टापु समय#,
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q#मउरिटस ग्रीष्मकालीन समय#,
				'generic' => q#मउरिटस समय#,
				'standard' => q#मउरिटस मानक समय#,
			},
		},
		'Mawson' => {
			long => {
				'standard' => q#म्वसन समय#,
			},
		},
		'Mexico_Northwest' => {
			long => {
				'daylight' => q#उत्तर पश्चिम मेक्सिकोको दिवा समय#,
				'generic' => q#उत्तर पश्चिम मेक्सिको समय#,
				'standard' => q#उत्तर पश्चिम मेक्सिकोको मानक समय#,
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q#मेक्सिकन प्यासिफिक दिवा समय#,
				'generic' => q#मेक्सिकन प्यासिफिक समय#,
				'standard' => q#मेक्सिकन प्यासिफिक मानक समय#,
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q#उलान बाटोर ग्रीष्मकालीन समय#,
				'generic' => q#उलान बाटोर समय#,
				'standard' => q#उलान बाटोर मानक समय#,
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q#मस्को ग्रीष्मकालीन समय#,
				'generic' => q#मस्को समय#,
				'standard' => q#मस्को मानक समय#,
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q#म्यानमार समय#,
			},
		},
		'Nauru' => {
			long => {
				'standard' => q#नाउरु समय#,
			},
		},
		'Nepal' => {
			long => {
				'standard' => q#नेपाली समय#,
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q#नयाँ कालेदोनिया ग्रीष्मकालीन समय#,
				'generic' => q#नयाँ कालेदोनिया समय#,
				'standard' => q#नयाँ कालेदोनिया मानक समय#,
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q#न्यूजिल्यान्ड दिवा समय#,
				'generic' => q#न्यूजिल्यान्ड समय#,
				'standard' => q#न्यूजिल्यान्ड मानक समय#,
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q#न्यूफाउनल्यान्डको दिवा समय#,
				'generic' => q#न्यूफाउन्डल्यान्डको समय#,
				'standard' => q#न्यूफाउनडल्यान्डको मानक समय#,
			},
		},
		'Niue' => {
			long => {
				'standard' => q#निउए समय#,
			},
		},
		'Norfolk' => {
			long => {
				'daylight' => q#नोर्फोक टापूको ग्रीष्मकालीन समय#,
				'generic' => q#नोर्फोक टापूको समय#,
				'standard' => q#नोर्फोक टापूको मानक समय#,
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q#फर्नान्डो डे नोरोन्हा ग्रीष्मकालीन समय#,
				'generic' => q#फर्नान्डो डे नोरोन्हा समय#,
				'standard' => q#फर्नान्डो डे नोरोन्हा मानक समय#,
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q#नोभोसिविर्स्क ग्रीष्मकालीन समय#,
				'generic' => q#नोभोसिविर्स्क समय#,
				'standard' => q#नोभोसिविर्स्क मानक समय#,
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q#ओम्स्क ग्रीष्मकालीन समय#,
				'generic' => q#ओम्स्क समय#,
				'standard' => q#ओम्स्क मानक समय#,
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#अपिया#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#अकल्यान्ड#,
		},
		'Pacific/Bougainville' => {
			exemplarCity => q#बुगेनभिल्ले#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#चाथाम#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#इस्टर#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#ईफाते#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#एन्डरबरी#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#फाकाओफो#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#फिजी#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#फुनाफुति#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#गलापागोस#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#ग्याम्बियर#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#गुअडालकनाल#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#गुवाम#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#होनोलुलु#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#जोन्सटन#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#किरितिमाटी#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#कोस्राए#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#क्वाजालेइन#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#माजुरो#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#मार्केसास#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#मिडवे#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#नाउरु#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#निउई#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#नरफोल्क#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#नोउमेअ#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#पागो पागो#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#पलाउ#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#पितकाईरन#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#पोनापे#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#पोर्ट मोरेस्बी#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#राओतोंगा#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#साईपन#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#ताहिती#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#तरवा#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#टंगातपु#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#चूक#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#वेक#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#वालिस#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q#पाकिस्तानी ग्रीष्मकालीन समय#,
				'generic' => q#पाकिस्तानी समय#,
				'standard' => q#पाकिस्तानी मानक समय#,
			},
		},
		'Palau' => {
			long => {
				'standard' => q#पालाउ समय#,
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q#पपूवा न्यू गिनी समय#,
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q#पाराग्वे ग्रीष्मकालीन समय#,
				'generic' => q#पाराग्वे समय#,
				'standard' => q#पाराग्वे मानक समय#,
			},
		},
		'Peru' => {
			long => {
				'daylight' => q#पेरु ग्रीष्मकालीन समय#,
				'generic' => q#पेरु समय#,
				'standard' => q#पेरू मानक समय#,
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q#फिलिपिनी ग्रीष्मकालीन समय#,
				'generic' => q#फिलिपिनी समय#,
				'standard' => q#फिलिपिनी मानक समय#,
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q#फिनिक्स टापु समय#,
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q#सेन्ट पियर्रे र मिक्युलोनको दिवा समय#,
				'generic' => q#सेन्ट पियर्रे र मिक्युलोनको समय#,
				'standard' => q#सेन्ट पियर्रे र मिक्युलोनको मानक समय#,
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q#पिटकैरण समय#,
			},
		},
		'Ponape' => {
			long => {
				'standard' => q#पोनापे समय#,
			},
		},
		'Pyongyang' => {
			long => {
				'standard' => q#प्योङयाङ समय#,
			},
		},
		'Reunion' => {
			long => {
				'standard' => q#रियुनियन समय#,
			},
		},
		'Rothera' => {
			long => {
				'standard' => q#रोथेरा समय#,
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q#साखालिन ग्रीष्मकालीन समय#,
				'generic' => q#साखालिन समय#,
				'standard' => q#साखालिन मानक समय#,
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q#सामोअ दिवा समय#,
				'generic' => q#सामोअ समय#,
				'standard' => q#सामोअ मानक समय#,
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q#सेयेचेलास् समय#,
			},
		},
		'Singapore' => {
			long => {
				'standard' => q#सिंगापुर मानक समय#,
			},
		},
		'Solomon' => {
			long => {
				'standard' => q#सोलोमोन टापु समय#,
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q#दक्षिण जर्जिया समय#,
			},
		},
		'Suriname' => {
			long => {
				'standard' => q#सुरिनामा समय#,
			},
		},
		'Syowa' => {
			long => {
				'standard' => q#स्योवा समय#,
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q#ताहिती समय#,
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q#ताइपेइ दिवा समय#,
				'generic' => q#ताइपेइ समय#,
				'standard' => q#ताइपेइ मानक समय#,
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q#ताजिकस्तान समय#,
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q#तोकेलाउ समय#,
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q#टोंगा ग्रीष्मकालीन समय#,
				'generic' => q#टोंगा समय#,
				'standard' => q#टोंगा मानक समय#,
			},
		},
		'Truk' => {
			long => {
				'standard' => q#चुउक समय#,
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q#तुर्कमेनिस्तान ग्रीष्मकालीन मानक समय#,
				'generic' => q#तुर्कमेनिस्तान समय#,
				'standard' => q#तुर्कमेनिस्तान मानक समय#,
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q#टुभालु समय#,
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q#उरुग्वे ग्रीष्मकालीन समय#,
				'generic' => q#उरुग्वे समय#,
				'standard' => q#उरूग्वे मानक समय#,
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q#उज्बेकिस्तान ग्रीष्मकालीन समय#,
				'generic' => q#उज्बेकिस्तान समय#,
				'standard' => q#उज्बेकिस्तान मानक समय#,
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q#भानुआतु ग्रीष्मकालीन समय#,
				'generic' => q#भानुआतु समय#,
				'standard' => q#भानुआतु मानक समय#,
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q#भेनेज्युएला समय#,
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q#भ्लादिभास्टोक ग्रीष्मकालीन समय#,
				'generic' => q#भ्लादिभास्टोक समय#,
				'standard' => q#भ्लादिभास्टोक मानक समय#,
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q#भोल्गाग्राद ग्रीष्मकालीन समय#,
				'generic' => q#भोल्गाग्राड समय#,
				'standard' => q#भोल्गाग्राद मानक समय#,
			},
		},
		'Vostok' => {
			long => {
				'standard' => q#भास्टोक समय#,
			},
		},
		'Wake' => {
			long => {
				'standard' => q#वेक टापु समय#,
			},
		},
		'Wallis' => {
			long => {
				'standard' => q#वालिस् र फुटुना समय#,
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q#याकुस्ट ग्रीष्मकालीन समय#,
				'generic' => q#याकुस्ट समय#,
				'standard' => q#याकुस्ट मानक समय#,
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q#येकाटेरिनबर्ग ग्रीष्मकालीन समय#,
				'generic' => q#येकाटेरिनबर्ग समय#,
				'standard' => q#येकाटेरिनबर्ग मानक समय#,
			},
		},
		'Yukon' => {
			long => {
				'standard' => q#युकोनको समय#,
			},
		},
	 } }
);
no Moo;

1;

# vim: tabstop=4
